//    SPDX-License-Identifier: LGPL-3.0-or-later
/*
   This file is part of FlexiBLAS, a BLAS/LAPACK interface wrapper library.
   Copyright (C) 2013-2025 Martin Koehler

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <complex.h>

#include "flexiblas_config.h"
#include "flexiblas.h"
#include "flexiblas_fortran_char_len.h"
#include "flexiblas_fortran_mangle.h"
#include "helper.h"

#if __GNUC__ >= 7
#define likely(x)      __builtin_expect(!!(x), 1)
#define unlikely(x)    __builtin_expect(!!(x), 0)
#else
#define likely(x) x
#define unlikely(x) x
#endif

#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cbbcsd = 0;
#endif

/* Wrapper for cbbcsd */
void FC_GLOBAL(cbbcsd,CBBCSD)
    (char *jobu1, char *jobu2, char *jobv1t, char *jobv2t, char *trans, blasint *m, blasint *p, blasint *q, float *theta, float *phi, lapack_complex_float *u1, blasint *ldu1, lapack_complex_float *u2, blasint *ldu2, lapack_complex_float *v1t, blasint *ldv1t, lapack_complex_float *v2t, blasint *ldv2t, float *b11d, float *b11e, float *b12d, float *b12e, float *b21d, float *b21e, float *b22d, float *b22e, float *rwork, blasint *lrwork, blasint *info, flexiblas_fortran_charlen_t jobu1_len, flexiblas_fortran_charlen_t jobu2_len, flexiblas_fortran_charlen_t jobv1t_len, flexiblas_fortran_charlen_t jobv2t_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *jobu1, void *jobu2, void *jobv1t, void *jobv2t, void *trans, void *m, void *p, void *q, void *theta, void *phi, void *u1, void *ldu1, void *u2, void *ldu2, void *v1t, void *ldv1t, void *v2t, void *ldv2t, void *b11d, void *b11e, void *b12d, void *b12e, void *b21d, void *b21e, void *b22d, void *b22e, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t jobu1_len, flexiblas_fortran_charlen_t jobu2_len, flexiblas_fortran_charlen_t jobv1t_len, flexiblas_fortran_charlen_t jobv2t_len, flexiblas_fortran_charlen_t trans_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobu1, void *jobu2, void *jobv1t, void *jobv2t, void *trans, void *m, void *p, void *q, void *theta, void *phi, void *u1, void *ldu1, void *u2, void *ldu2, void *v1t, void *ldv1t, void *v2t, void *ldv2t, void *b11d, void *b11e, void *b12d, void *b12e, void *b21d, void *b21e, void *b22d, void *b22e, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t jobu1_len, flexiblas_fortran_charlen_t jobu2_len, flexiblas_fortran_charlen_t jobv1t_len, flexiblas_fortran_charlen_t jobv2t_len, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cbbcsd = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cbbcsd;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cbbcsd.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobu1, (void *) jobu2, (void *) jobv1t, (void *) jobv2t, (void *) trans, (void *) m, (void *) p, (void *) q, (void *) theta, (void *) phi, (void *) u1, (void *) ldu1, (void *) u2, (void *) ldu2, (void *) v1t, (void *) ldv1t, (void *) v2t, (void *) ldv2t, (void *) b11d, (void *) b11e, (void *) b12d, (void *) b12e, (void *) b21d, (void *) b21e, (void *) b22d, (void *) b22e, (void *) rwork, (void *) lrwork, (void *) info, jobu1_len, jobu2_len, jobv1t_len, jobv2t_len, trans_len);
    } else {
        fn((void *) jobu1, (void *) jobu2, (void *) jobv1t, (void *) jobv2t, (void *) trans, (void *) m, (void *) p, (void *) q, (void *) theta, (void *) phi, (void *) u1, (void *) ldu1, (void *) u2, (void *) ldu2, (void *) v1t, (void *) ldv1t, (void *) v2t, (void *) ldv2t, (void *) b11d, (void *) b11e, (void *) b12d, (void *) b12e, (void *) b21d, (void *) b21e, (void *) b22d, (void *) b22e, (void *) rwork, (void *) lrwork, (void *) info, jobu1_len, jobu2_len, jobv1t_len, jobv2t_len, trans_len);
    }
    #else
    fn((void *) jobu1, (void *) jobu2, (void *) jobv1t, (void *) jobv2t, (void *) trans, (void *) m, (void *) p, (void *) q, (void *) theta, (void *) phi, (void *) u1, (void *) ldu1, (void *) u2, (void *) ldu2, (void *) v1t, (void *) ldv1t, (void *) v2t, (void *) ldv2t, (void *) b11d, (void *) b11e, (void *) b12d, (void *) b12e, (void *) b21d, (void *) b21e, (void *) b22d, (void *) b22e, (void *) rwork, (void *) lrwork, (void *) info, jobu1_len, jobu2_len, jobv1t_len, jobv2t_len, trans_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cbbcsd,CBBCSD)(char *jobu1, char *jobu2, char *jobv1t, char *jobv2t, char *trans, blasint *m, blasint *p, blasint *q, float *theta, float *phi, lapack_complex_float *u1, blasint *ldu1, lapack_complex_float *u2, blasint *ldu2, lapack_complex_float *v1t, blasint *ldv1t, lapack_complex_float *v2t, blasint *ldv2t, float *b11d, float *b11e, float *b12d, float *b12e, float *b21d, float *b21e, float *b22d, float *b22e, float *rwork, blasint *lrwork, blasint *info, flexiblas_fortran_charlen_t jobu1_len, flexiblas_fortran_charlen_t jobu2_len, flexiblas_fortran_charlen_t jobv1t_len, flexiblas_fortran_charlen_t jobv2t_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cbbcsd,CBBCSD)))));
void FC_GLOBAL3(cbbcsd,CBBCSD)(char *jobu1, char *jobu2, char *jobv1t, char *jobv2t, char *trans, blasint *m, blasint *p, blasint *q, float *theta, float *phi, lapack_complex_float *u1, blasint *ldu1, lapack_complex_float *u2, blasint *ldu2, lapack_complex_float *v1t, blasint *ldv1t, lapack_complex_float *v2t, blasint *ldv2t, float *b11d, float *b11e, float *b12d, float *b12e, float *b21d, float *b21e, float *b22d, float *b22e, float *rwork, blasint *lrwork, blasint *info, flexiblas_fortran_charlen_t jobu1_len, flexiblas_fortran_charlen_t jobu2_len, flexiblas_fortran_charlen_t jobv1t_len, flexiblas_fortran_charlen_t jobv2t_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cbbcsd,CBBCSD)))));
#else
void FC_GLOBAL2(cbbcsd,CBBCSD)(char *jobu1, char *jobu2, char *jobv1t, char *jobv2t, char *trans, blasint *m, blasint *p, blasint *q, float *theta, float *phi, lapack_complex_float *u1, blasint *ldu1, lapack_complex_float *u2, blasint *ldu2, lapack_complex_float *v1t, blasint *ldv1t, lapack_complex_float *v2t, blasint *ldv2t, float *b11d, float *b11e, float *b12d, float *b12e, float *b21d, float *b21e, float *b22d, float *b22e, float *rwork, blasint *lrwork, blasint *info, flexiblas_fortran_charlen_t jobu1_len, flexiblas_fortran_charlen_t jobu2_len, flexiblas_fortran_charlen_t jobv1t_len, flexiblas_fortran_charlen_t jobv2t_len, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cbbcsd,CBBCSD)((void *) jobu1, (void *) jobu2, (void *) jobv1t, (void *) jobv2t, (void *) trans, (void *) m, (void *) p, (void *) q, (void *) theta, (void *) phi, (void *) u1, (void *) ldu1, (void *) u2, (void *) ldu2, (void *) v1t, (void *) ldv1t, (void *) v2t, (void *) ldv2t, (void *) b11d, (void *) b11e, (void *) b12d, (void *) b12e, (void *) b21d, (void *) b21e, (void *) b22d, (void *) b22e, (void *) rwork, (void *) lrwork, (void *) info, jobu1_len, jobu2_len, jobv1t_len, jobv2t_len, trans_len);
}
void FC_GLOBAL3(cbbcsd,CBBCSD)(char *jobu1, char *jobu2, char *jobv1t, char *jobv2t, char *trans, blasint *m, blasint *p, blasint *q, float *theta, float *phi, lapack_complex_float *u1, blasint *ldu1, lapack_complex_float *u2, blasint *ldu2, lapack_complex_float *v1t, blasint *ldv1t, lapack_complex_float *v2t, blasint *ldv2t, float *b11d, float *b11e, float *b12d, float *b12e, float *b21d, float *b21e, float *b22d, float *b22e, float *rwork, blasint *lrwork, blasint *info, flexiblas_fortran_charlen_t jobu1_len, flexiblas_fortran_charlen_t jobu2_len, flexiblas_fortran_charlen_t jobv1t_len, flexiblas_fortran_charlen_t jobv2t_len, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cbbcsd,CBBCSD)((void *) jobu1, (void *) jobu2, (void *) jobv1t, (void *) jobv2t, (void *) trans, (void *) m, (void *) p, (void *) q, (void *) theta, (void *) phi, (void *) u1, (void *) ldu1, (void *) u2, (void *) ldu2, (void *) v1t, (void *) ldv1t, (void *) v2t, (void *) ldv2t, (void *) b11d, (void *) b11e, (void *) b12d, (void *) b12e, (void *) b21d, (void *) b21e, (void *) b22d, (void *) b22e, (void *) rwork, (void *) lrwork, (void *) info, jobu1_len, jobu2_len, jobv1t_len, jobv2t_len, trans_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cbbcsd_(void *jobu1, void *jobu2, void *jobv1t, void *jobv2t, void *trans, void *m, void *p, void *q, void *theta, void *phi, void *u1, void *ldu1, void *u2, void *ldu2, void *v1t, void *ldv1t, void *v2t, void *ldv2t, void *b11d, void *b11e, void *b12d, void *b12e, void *b21d, void *b21e, void *b22d, void *b22e, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t jobu1_len, flexiblas_fortran_charlen_t jobu2_len, flexiblas_fortran_charlen_t jobv1t_len, flexiblas_fortran_charlen_t jobv2t_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *jobu1, void *jobu2, void *jobv1t, void *jobv2t, void *trans, void *m, void *p, void *q, void *theta, void *phi, void *u1, void *ldu1, void *u2, void *ldu2, void *v1t, void *ldv1t, void *v2t, void *ldv2t, void *b11d, void *b11e, void *b12d, void *b12e, void *b21d, void *b21e, void *b22d, void *b22e, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t jobu1_len, flexiblas_fortran_charlen_t jobu2_len, flexiblas_fortran_charlen_t jobv1t_len, flexiblas_fortran_charlen_t jobv2t_len, flexiblas_fortran_charlen_t trans_len);
    *(void **) &fn = current_backend->lapack.cbbcsd;
    fn((void *) jobu1, (void *) jobu2, (void *) jobv1t, (void *) jobv2t, (void *) trans, (void *) m, (void *) p, (void *) q, (void *) theta, (void *) phi, (void *) u1, (void *) ldu1, (void *) u2, (void *) ldu2, (void *) v1t, (void *) ldv1t, (void *) v2t, (void *) ldv2t, (void *) b11d, (void *) b11e, (void *) b12d, (void *) b12e, (void *) b21d, (void *) b21e, (void *) b22d, (void *) b22e, (void *) rwork, (void *) lrwork, (void *) info, jobu1_len, jobu2_len, jobv1t_len, jobv2t_len, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cbbcsd(void *jobu1, void *jobu2, void *jobv1t, void *jobv2t, void *trans, void *m, void *p, void *q, void *theta, void *phi, void *u1, void *ldu1, void *u2, void *ldu2, void *v1t, void *ldv1t, void *v2t, void *ldv2t, void *b11d, void *b11e, void *b12d, void *b12e, void *b21d, void *b21e, void *b22d, void *b22e, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t jobu1_len, flexiblas_fortran_charlen_t jobu2_len, flexiblas_fortran_charlen_t jobv1t_len, flexiblas_fortran_charlen_t jobv2t_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_real_cbbcsd_")));
#else
void flexiblas_real_cbbcsd(void *jobu1, void *jobu2, void *jobv1t, void *jobv2t, void *trans, void *m, void *p, void *q, void *theta, void *phi, void *u1, void *ldu1, void *u2, void *ldu2, void *v1t, void *ldv1t, void *v2t, void *ldv2t, void *b11d, void *b11e, void *b12d, void *b12e, void *b21d, void *b21e, void *b22d, void *b22e, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t jobu1_len, flexiblas_fortran_charlen_t jobu2_len, flexiblas_fortran_charlen_t jobv1t_len, flexiblas_fortran_charlen_t jobv2t_len, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_real_cbbcsd_((void *) jobu1, (void *) jobu2, (void *) jobv1t, (void *) jobv2t, (void *) trans, (void *) m, (void *) p, (void *) q, (void *) theta, (void *) phi, (void *) u1, (void *) ldu1, (void *) u2, (void *) ldu2, (void *) v1t, (void *) ldv1t, (void *) v2t, (void *) ldv2t, (void *) b11d, (void *) b11e, (void *) b12d, (void *) b12e, (void *) b21d, (void *) b21e, (void *) b22d, (void *) b22e, (void *) rwork, (void *) lrwork, (void *) info, jobu1_len, jobu2_len, jobv1t_len, jobv2t_len, trans_len);
    return;
}
#endif

void flexiblas_chain_cbbcsd_(void *jobu1, void *jobu2, void *jobv1t, void *jobv2t, void *trans, void *m, void *p, void *q, void *theta, void *phi, void *u1, void *ldu1, void *u2, void *ldu2, void *v1t, void *ldv1t, void *v2t, void *ldv2t, void *b11d, void *b11e, void *b12d, void *b12e, void *b21d, void *b21e, void *b22d, void *b22e, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t jobu1_len, flexiblas_fortran_charlen_t jobu2_len, flexiblas_fortran_charlen_t jobv1t_len, flexiblas_fortran_charlen_t jobv2t_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *jobu1, void *jobu2, void *jobv1t, void *jobv2t, void *trans, void *m, void *p, void *q, void *theta, void *phi, void *u1, void *ldu1, void *u2, void *ldu2, void *v1t, void *ldv1t, void *v2t, void *ldv2t, void *b11d, void *b11e, void *b12d, void *b12e, void *b21d, void *b21e, void *b22d, void *b22e, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t jobu1_len, flexiblas_fortran_charlen_t jobu2_len, flexiblas_fortran_charlen_t jobv1t_len, flexiblas_fortran_charlen_t jobv2t_len, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cbbcsd++;
    if ( hook_pos_cbbcsd < __flexiblas_hooks->cbbcsd.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cbbcsd.hook_function[hook_pos_cbbcsd];
    } else {
        hook_pos_cbbcsd = 0;
        *(void **) &fn = current_backend->lapack.cbbcsd;
    }
    fn((void *) jobu1, (void *) jobu2, (void *) jobv1t, (void *) jobv2t, (void *) trans, (void *) m, (void *) p, (void *) q, (void *) theta, (void *) phi, (void *) u1, (void *) ldu1, (void *) u2, (void *) ldu2, (void *) v1t, (void *) ldv1t, (void *) v2t, (void *) ldv2t, (void *) b11d, (void *) b11e, (void *) b12d, (void *) b12e, (void *) b21d, (void *) b21e, (void *) b22d, (void *) b22e, (void *) rwork, (void *) lrwork, (void *) info, jobu1_len, jobu2_len, jobv1t_len, jobv2t_len, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cbbcsd(void *jobu1, void *jobu2, void *jobv1t, void *jobv2t, void *trans, void *m, void *p, void *q, void *theta, void *phi, void *u1, void *ldu1, void *u2, void *ldu2, void *v1t, void *ldv1t, void *v2t, void *ldv2t, void *b11d, void *b11e, void *b12d, void *b12e, void *b21d, void *b21e, void *b22d, void *b22e, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t jobu1_len, flexiblas_fortran_charlen_t jobu2_len, flexiblas_fortran_charlen_t jobv1t_len, flexiblas_fortran_charlen_t jobv2t_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_chain_cbbcsd_")));
#else
void flexiblas_chain_cbbcsd(void *jobu1, void *jobu2, void *jobv1t, void *jobv2t, void *trans, void *m, void *p, void *q, void *theta, void *phi, void *u1, void *ldu1, void *u2, void *ldu2, void *v1t, void *ldv1t, void *v2t, void *ldv2t, void *b11d, void *b11e, void *b12d, void *b12e, void *b21d, void *b21e, void *b22d, void *b22e, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t jobu1_len, flexiblas_fortran_charlen_t jobu2_len, flexiblas_fortran_charlen_t jobv1t_len, flexiblas_fortran_charlen_t jobv2t_len, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_chain_cbbcsd_((void *) jobu1, (void *) jobu2, (void *) jobv1t, (void *) jobv2t, (void *) trans, (void *) m, (void *) p, (void *) q, (void *) theta, (void *) phi, (void *) u1, (void *) ldu1, (void *) u2, (void *) ldu2, (void *) v1t, (void *) ldv1t, (void *) v2t, (void *) ldv2t, (void *) b11d, (void *) b11e, (void *) b12d, (void *) b12e, (void *) b21d, (void *) b21e, (void *) b22d, (void *) b22e, (void *) rwork, (void *) lrwork, (void *) info, jobu1_len, jobu2_len, jobv1t_len, jobv2t_len, trans_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cbdsqr = 0;
#endif

/* Wrapper for cbdsqr */
void FC_GLOBAL(cbdsqr,CBDSQR)
    (char *uplo, blasint *n, blasint *ncvt, blasint *nru, blasint *ncc, float *d, float *e, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *u, blasint *ldu, lapack_complex_float *c, blasint *ldc, float *rwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *ncvt, void *nru, void *ncc, void *d, void *e, void *vt, void *ldvt, void *u, void *ldu, void *c, void *ldc, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *uplo, void *n, void *ncvt, void *nru, void *ncc, void *d, void *e, void *vt, void *ldvt, void *u, void *ldu, void *c, void *ldc, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cbdsqr = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cbdsqr;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cbdsqr.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) uplo, (void *) n, (void *) ncvt, (void *) nru, (void *) ncc, (void *) d, (void *) e, (void *) vt, (void *) ldvt, (void *) u, (void *) ldu, (void *) c, (void *) ldc, (void *) rwork, (void *) info, uplo_len);
    } else {
        fn((void *) uplo, (void *) n, (void *) ncvt, (void *) nru, (void *) ncc, (void *) d, (void *) e, (void *) vt, (void *) ldvt, (void *) u, (void *) ldu, (void *) c, (void *) ldc, (void *) rwork, (void *) info, uplo_len);
    }
    #else
    fn((void *) uplo, (void *) n, (void *) ncvt, (void *) nru, (void *) ncc, (void *) d, (void *) e, (void *) vt, (void *) ldvt, (void *) u, (void *) ldu, (void *) c, (void *) ldc, (void *) rwork, (void *) info, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cbdsqr,CBDSQR)(char *uplo, blasint *n, blasint *ncvt, blasint *nru, blasint *ncc, float *d, float *e, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *u, blasint *ldu, lapack_complex_float *c, blasint *ldc, float *rwork, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cbdsqr,CBDSQR)))));
void FC_GLOBAL3(cbdsqr,CBDSQR)(char *uplo, blasint *n, blasint *ncvt, blasint *nru, blasint *ncc, float *d, float *e, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *u, blasint *ldu, lapack_complex_float *c, blasint *ldc, float *rwork, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cbdsqr,CBDSQR)))));
#else
void FC_GLOBAL2(cbdsqr,CBDSQR)(char *uplo, blasint *n, blasint *ncvt, blasint *nru, blasint *ncc, float *d, float *e, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *u, blasint *ldu, lapack_complex_float *c, blasint *ldc, float *rwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cbdsqr,CBDSQR)((void *) uplo, (void *) n, (void *) ncvt, (void *) nru, (void *) ncc, (void *) d, (void *) e, (void *) vt, (void *) ldvt, (void *) u, (void *) ldu, (void *) c, (void *) ldc, (void *) rwork, (void *) info, uplo_len);
}
void FC_GLOBAL3(cbdsqr,CBDSQR)(char *uplo, blasint *n, blasint *ncvt, blasint *nru, blasint *ncc, float *d, float *e, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *u, blasint *ldu, lapack_complex_float *c, blasint *ldc, float *rwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cbdsqr,CBDSQR)((void *) uplo, (void *) n, (void *) ncvt, (void *) nru, (void *) ncc, (void *) d, (void *) e, (void *) vt, (void *) ldvt, (void *) u, (void *) ldu, (void *) c, (void *) ldc, (void *) rwork, (void *) info, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cbdsqr_(void *uplo, void *n, void *ncvt, void *nru, void *ncc, void *d, void *e, void *vt, void *ldvt, void *u, void *ldu, void *c, void *ldc, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *ncvt, void *nru, void *ncc, void *d, void *e, void *vt, void *ldvt, void *u, void *ldu, void *c, void *ldc, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.cbdsqr;
    fn((void *) uplo, (void *) n, (void *) ncvt, (void *) nru, (void *) ncc, (void *) d, (void *) e, (void *) vt, (void *) ldvt, (void *) u, (void *) ldu, (void *) c, (void *) ldc, (void *) rwork, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cbdsqr(void *uplo, void *n, void *ncvt, void *nru, void *ncc, void *d, void *e, void *vt, void *ldvt, void *u, void *ldu, void *c, void *ldc, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_cbdsqr_")));
#else
void flexiblas_real_cbdsqr(void *uplo, void *n, void *ncvt, void *nru, void *ncc, void *d, void *e, void *vt, void *ldvt, void *u, void *ldu, void *c, void *ldc, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_cbdsqr_((void *) uplo, (void *) n, (void *) ncvt, (void *) nru, (void *) ncc, (void *) d, (void *) e, (void *) vt, (void *) ldvt, (void *) u, (void *) ldu, (void *) c, (void *) ldc, (void *) rwork, (void *) info, uplo_len);
    return;
}
#endif

void flexiblas_chain_cbdsqr_(void *uplo, void *n, void *ncvt, void *nru, void *ncc, void *d, void *e, void *vt, void *ldvt, void *u, void *ldu, void *c, void *ldc, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *ncvt, void *nru, void *ncc, void *d, void *e, void *vt, void *ldvt, void *u, void *ldu, void *c, void *ldc, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cbdsqr++;
    if ( hook_pos_cbdsqr < __flexiblas_hooks->cbdsqr.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cbdsqr.hook_function[hook_pos_cbdsqr];
    } else {
        hook_pos_cbdsqr = 0;
        *(void **) &fn = current_backend->lapack.cbdsqr;
    }
    fn((void *) uplo, (void *) n, (void *) ncvt, (void *) nru, (void *) ncc, (void *) d, (void *) e, (void *) vt, (void *) ldvt, (void *) u, (void *) ldu, (void *) c, (void *) ldc, (void *) rwork, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cbdsqr(void *uplo, void *n, void *ncvt, void *nru, void *ncc, void *d, void *e, void *vt, void *ldvt, void *u, void *ldu, void *c, void *ldc, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_cbdsqr_")));
#else
void flexiblas_chain_cbdsqr(void *uplo, void *n, void *ncvt, void *nru, void *ncc, void *d, void *e, void *vt, void *ldvt, void *u, void *ldu, void *c, void *ldc, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_cbdsqr_((void *) uplo, (void *) n, (void *) ncvt, (void *) nru, (void *) ncc, (void *) d, (void *) e, (void *) vt, (void *) ldvt, (void *) u, (void *) ldu, (void *) c, (void *) ldc, (void *) rwork, (void *) info, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgbbrd = 0;
#endif

/* Wrapper for cgbbrd */
void FC_GLOBAL(cgbbrd,CGBBRD)
    (char *vect, blasint *m, blasint *n, blasint *ncc, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, float *d, float *e, lapack_complex_float *q, blasint *ldq, lapack_complex_float *pt, blasint *ldpt, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t vect_len)
{
    void (*fn) (void *vect, void *m, void *n, void *ncc, void *kl, void *ku, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *pt, void *ldpt, void *c, void *ldc, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *vect, void *m, void *n, void *ncc, void *kl, void *ku, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *pt, void *ldpt, void *c, void *ldc, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len);
    hook_pos_cgbbrd = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgbbrd;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgbbrd.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) vect, (void *) m, (void *) n, (void *) ncc, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) pt, (void *) ldpt, (void *) c, (void *) ldc, (void *) work, (void *) rwork, (void *) info, vect_len);
    } else {
        fn((void *) vect, (void *) m, (void *) n, (void *) ncc, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) pt, (void *) ldpt, (void *) c, (void *) ldc, (void *) work, (void *) rwork, (void *) info, vect_len);
    }
    #else
    fn((void *) vect, (void *) m, (void *) n, (void *) ncc, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) pt, (void *) ldpt, (void *) c, (void *) ldc, (void *) work, (void *) rwork, (void *) info, vect_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgbbrd,CGBBRD)(char *vect, blasint *m, blasint *n, blasint *ncc, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, float *d, float *e, lapack_complex_float *q, blasint *ldq, lapack_complex_float *pt, blasint *ldpt, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t vect_len) __attribute__((alias(MTS(FC_GLOBAL(cgbbrd,CGBBRD)))));
void FC_GLOBAL3(cgbbrd,CGBBRD)(char *vect, blasint *m, blasint *n, blasint *ncc, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, float *d, float *e, lapack_complex_float *q, blasint *ldq, lapack_complex_float *pt, blasint *ldpt, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t vect_len) __attribute__((alias(MTS(FC_GLOBAL(cgbbrd,CGBBRD)))));
#else
void FC_GLOBAL2(cgbbrd,CGBBRD)(char *vect, blasint *m, blasint *n, blasint *ncc, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, float *d, float *e, lapack_complex_float *q, blasint *ldq, lapack_complex_float *pt, blasint *ldpt, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t vect_len)
{
    FC_GLOBAL(cgbbrd,CGBBRD)((void *) vect, (void *) m, (void *) n, (void *) ncc, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) pt, (void *) ldpt, (void *) c, (void *) ldc, (void *) work, (void *) rwork, (void *) info, vect_len);
}
void FC_GLOBAL3(cgbbrd,CGBBRD)(char *vect, blasint *m, blasint *n, blasint *ncc, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, float *d, float *e, lapack_complex_float *q, blasint *ldq, lapack_complex_float *pt, blasint *ldpt, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t vect_len)
{
    FC_GLOBAL(cgbbrd,CGBBRD)((void *) vect, (void *) m, (void *) n, (void *) ncc, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) pt, (void *) ldpt, (void *) c, (void *) ldc, (void *) work, (void *) rwork, (void *) info, vect_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgbbrd_(void *vect, void *m, void *n, void *ncc, void *kl, void *ku, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *pt, void *ldpt, void *c, void *ldc, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len)
{
    void (*fn) (void *vect, void *m, void *n, void *ncc, void *kl, void *ku, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *pt, void *ldpt, void *c, void *ldc, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len);
    *(void **) &fn = current_backend->lapack.cgbbrd;
    fn((void *) vect, (void *) m, (void *) n, (void *) ncc, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) pt, (void *) ldpt, (void *) c, (void *) ldc, (void *) work, (void *) rwork, (void *) info, vect_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgbbrd(void *vect, void *m, void *n, void *ncc, void *kl, void *ku, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *pt, void *ldpt, void *c, void *ldc, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len) __attribute__((alias("flexiblas_real_cgbbrd_")));
#else
void flexiblas_real_cgbbrd(void *vect, void *m, void *n, void *ncc, void *kl, void *ku, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *pt, void *ldpt, void *c, void *ldc, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len)
{
    flexiblas_real_cgbbrd_((void *) vect, (void *) m, (void *) n, (void *) ncc, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) pt, (void *) ldpt, (void *) c, (void *) ldc, (void *) work, (void *) rwork, (void *) info, vect_len);
    return;
}
#endif

void flexiblas_chain_cgbbrd_(void *vect, void *m, void *n, void *ncc, void *kl, void *ku, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *pt, void *ldpt, void *c, void *ldc, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len)
{
    void (*fn) (void *vect, void *m, void *n, void *ncc, void *kl, void *ku, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *pt, void *ldpt, void *c, void *ldc, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len);
    hook_pos_cgbbrd++;
    if ( hook_pos_cgbbrd < __flexiblas_hooks->cgbbrd.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgbbrd.hook_function[hook_pos_cgbbrd];
    } else {
        hook_pos_cgbbrd = 0;
        *(void **) &fn = current_backend->lapack.cgbbrd;
    }
    fn((void *) vect, (void *) m, (void *) n, (void *) ncc, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) pt, (void *) ldpt, (void *) c, (void *) ldc, (void *) work, (void *) rwork, (void *) info, vect_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgbbrd(void *vect, void *m, void *n, void *ncc, void *kl, void *ku, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *pt, void *ldpt, void *c, void *ldc, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len) __attribute__((alias("flexiblas_chain_cgbbrd_")));
#else
void flexiblas_chain_cgbbrd(void *vect, void *m, void *n, void *ncc, void *kl, void *ku, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *pt, void *ldpt, void *c, void *ldc, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len)
{
    flexiblas_chain_cgbbrd_((void *) vect, (void *) m, (void *) n, (void *) ncc, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) pt, (void *) ldpt, (void *) c, (void *) ldc, (void *) work, (void *) rwork, (void *) info, vect_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgbcon = 0;
#endif

/* Wrapper for cgbcon */
void FC_GLOBAL(cgbcon,CGBCON)
    (char *norm, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t norm_len)
{
    void (*fn) (void *norm, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *norm, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len);
    hook_pos_cgbcon = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgbcon;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgbcon.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) norm, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
    } else {
        fn((void *) norm, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
    }
    #else
    fn((void *) norm, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgbcon,CGBCON)(char *norm, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t norm_len) __attribute__((alias(MTS(FC_GLOBAL(cgbcon,CGBCON)))));
void FC_GLOBAL3(cgbcon,CGBCON)(char *norm, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t norm_len) __attribute__((alias(MTS(FC_GLOBAL(cgbcon,CGBCON)))));
#else
void FC_GLOBAL2(cgbcon,CGBCON)(char *norm, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t norm_len)
{
    FC_GLOBAL(cgbcon,CGBCON)((void *) norm, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
}
void FC_GLOBAL3(cgbcon,CGBCON)(char *norm, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t norm_len)
{
    FC_GLOBAL(cgbcon,CGBCON)((void *) norm, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgbcon_(void *norm, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len)
{
    void (*fn) (void *norm, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len);
    *(void **) &fn = current_backend->lapack.cgbcon;
    fn((void *) norm, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgbcon(void *norm, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len) __attribute__((alias("flexiblas_real_cgbcon_")));
#else
void flexiblas_real_cgbcon(void *norm, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len)
{
    flexiblas_real_cgbcon_((void *) norm, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
    return;
}
#endif

void flexiblas_chain_cgbcon_(void *norm, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len)
{
    void (*fn) (void *norm, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len);
    hook_pos_cgbcon++;
    if ( hook_pos_cgbcon < __flexiblas_hooks->cgbcon.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgbcon.hook_function[hook_pos_cgbcon];
    } else {
        hook_pos_cgbcon = 0;
        *(void **) &fn = current_backend->lapack.cgbcon;
    }
    fn((void *) norm, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgbcon(void *norm, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len) __attribute__((alias("flexiblas_chain_cgbcon_")));
#else
void flexiblas_chain_cgbcon(void *norm, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len)
{
    flexiblas_chain_cgbcon_((void *) norm, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgbequ = 0;
#endif

/* Wrapper for cgbequ */
void FC_GLOBAL(cgbequ,CGBEQU)
    (blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info)
{
    void (*fn) (void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info);
    hook_pos_cgbequ = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgbequ;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgbequ.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgbequ,CGBEQU)(blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgbequ,CGBEQU)))));
void FC_GLOBAL3(cgbequ,CGBEQU)(blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgbequ,CGBEQU)))));
#else
void FC_GLOBAL2(cgbequ,CGBEQU)(blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info)
{
    FC_GLOBAL(cgbequ,CGBEQU)((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
}
void FC_GLOBAL3(cgbequ,CGBEQU)(blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info)
{
    FC_GLOBAL(cgbequ,CGBEQU)((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgbequ_(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info)
{
    void (*fn) (void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info);
    *(void **) &fn = current_backend->lapack.cgbequ;
    fn((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgbequ(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info) __attribute__((alias("flexiblas_real_cgbequ_")));
#else
void flexiblas_real_cgbequ(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info)
{
    flexiblas_real_cgbequ_((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgbequ_(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info)
{
    void (*fn) (void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info);
    hook_pos_cgbequ++;
    if ( hook_pos_cgbequ < __flexiblas_hooks->cgbequ.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgbequ.hook_function[hook_pos_cgbequ];
    } else {
        hook_pos_cgbequ = 0;
        *(void **) &fn = current_backend->lapack.cgbequ;
    }
    fn((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgbequ(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info) __attribute__((alias("flexiblas_chain_cgbequ_")));
#else
void flexiblas_chain_cgbequ(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info)
{
    flexiblas_chain_cgbequ_((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgbequb = 0;
#endif

/* Wrapper for cgbequb */
void FC_GLOBAL(cgbequb,CGBEQUB)
    (blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info)
{
    void (*fn) (void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info);
    hook_pos_cgbequb = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgbequb;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgbequb.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgbequb,CGBEQUB)(blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgbequb,CGBEQUB)))));
void FC_GLOBAL3(cgbequb,CGBEQUB)(blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgbequb,CGBEQUB)))));
#else
void FC_GLOBAL2(cgbequb,CGBEQUB)(blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info)
{
    FC_GLOBAL(cgbequb,CGBEQUB)((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
}
void FC_GLOBAL3(cgbequb,CGBEQUB)(blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info)
{
    FC_GLOBAL(cgbequb,CGBEQUB)((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgbequb_(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info)
{
    void (*fn) (void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info);
    *(void **) &fn = current_backend->lapack.cgbequb;
    fn((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgbequb(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info) __attribute__((alias("flexiblas_real_cgbequb_")));
#else
void flexiblas_real_cgbequb(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info)
{
    flexiblas_real_cgbequb_((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgbequb_(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info)
{
    void (*fn) (void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info);
    hook_pos_cgbequb++;
    if ( hook_pos_cgbequb < __flexiblas_hooks->cgbequb.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgbequb.hook_function[hook_pos_cgbequb];
    } else {
        hook_pos_cgbequb = 0;
        *(void **) &fn = current_backend->lapack.cgbequb;
    }
    fn((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgbequb(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info) __attribute__((alias("flexiblas_chain_cgbequb_")));
#else
void flexiblas_chain_cgbequb(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info)
{
    flexiblas_chain_cgbequb_((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgbrfs = 0;
#endif

/* Wrapper for cgbrfs */
void FC_GLOBAL(cgbrfs,CGBRFS)
    (char *trans, blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *afb, blasint *ldafb, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgbrfs = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgbrfs;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgbrfs.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    } else {
        fn((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    }
    #else
    fn((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgbrfs,CGBRFS)(char *trans, blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *afb, blasint *ldafb, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgbrfs,CGBRFS)))));
void FC_GLOBAL3(cgbrfs,CGBRFS)(char *trans, blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *afb, blasint *ldafb, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgbrfs,CGBRFS)))));
#else
void FC_GLOBAL2(cgbrfs,CGBRFS)(char *trans, blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *afb, blasint *ldafb, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgbrfs,CGBRFS)((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
}
void FC_GLOBAL3(cgbrfs,CGBRFS)(char *trans, blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *afb, blasint *ldafb, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgbrfs,CGBRFS)((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgbrfs_(void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len);
    *(void **) &fn = current_backend->lapack.cgbrfs;
    fn((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgbrfs(void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_real_cgbrfs_")));
#else
void flexiblas_real_cgbrfs(void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_real_cgbrfs_((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    return;
}
#endif

void flexiblas_chain_cgbrfs_(void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgbrfs++;
    if ( hook_pos_cgbrfs < __flexiblas_hooks->cgbrfs.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgbrfs.hook_function[hook_pos_cgbrfs];
    } else {
        hook_pos_cgbrfs = 0;
        *(void **) &fn = current_backend->lapack.cgbrfs;
    }
    fn((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgbrfs(void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_chain_cgbrfs_")));
#else
void flexiblas_chain_cgbrfs(void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_chain_cgbrfs_((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgbsv = 0;
#endif

/* Wrapper for cgbsv */
void FC_GLOBAL(cgbsv,CGBSV)
    (blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info)
{
    void (*fn) (void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info);
    hook_pos_cgbsv = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgbsv;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgbsv.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
    } else {
        fn((void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
    }
    #else
    fn((void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgbsv,CGBSV)(blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgbsv,CGBSV)))));
void FC_GLOBAL3(cgbsv,CGBSV)(blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgbsv,CGBSV)))));
#else
void FC_GLOBAL2(cgbsv,CGBSV)(blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info)
{
    FC_GLOBAL(cgbsv,CGBSV)((void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
}
void FC_GLOBAL3(cgbsv,CGBSV)(blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info)
{
    FC_GLOBAL(cgbsv,CGBSV)((void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgbsv_(void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info)
{
    void (*fn) (void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info);
    *(void **) &fn = current_backend->lapack.cgbsv;
    fn((void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgbsv(void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info) __attribute__((alias("flexiblas_real_cgbsv_")));
#else
void flexiblas_real_cgbsv(void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info)
{
    flexiblas_real_cgbsv_((void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgbsv_(void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info)
{
    void (*fn) (void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info);
    hook_pos_cgbsv++;
    if ( hook_pos_cgbsv < __flexiblas_hooks->cgbsv.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgbsv.hook_function[hook_pos_cgbsv];
    } else {
        hook_pos_cgbsv = 0;
        *(void **) &fn = current_backend->lapack.cgbsv;
    }
    fn((void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgbsv(void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info) __attribute__((alias("flexiblas_chain_cgbsv_")));
#else
void flexiblas_chain_cgbsv(void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info)
{
    flexiblas_chain_cgbsv_((void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgbsvx = 0;
#endif

/* Wrapper for cgbsvx */
void FC_GLOBAL(cgbsvx,CGBSVX)
    (char *fact, char *trans, blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *afb, blasint *ldafb, blasint *ipiv, char *equed, float *r, float *c, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len)
{
    void (*fn) (void *fact, void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *fact, void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len);
    hook_pos_cgbsvx = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgbsvx;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgbsvx.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) fact, (void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
    } else {
        fn((void *) fact, (void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
    }
    #else
    fn((void *) fact, (void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgbsvx,CGBSVX)(char *fact, char *trans, blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *afb, blasint *ldafb, blasint *ipiv, char *equed, float *r, float *c, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len) __attribute__((alias(MTS(FC_GLOBAL(cgbsvx,CGBSVX)))));
void FC_GLOBAL3(cgbsvx,CGBSVX)(char *fact, char *trans, blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *afb, blasint *ldafb, blasint *ipiv, char *equed, float *r, float *c, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len) __attribute__((alias(MTS(FC_GLOBAL(cgbsvx,CGBSVX)))));
#else
void FC_GLOBAL2(cgbsvx,CGBSVX)(char *fact, char *trans, blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *afb, blasint *ldafb, blasint *ipiv, char *equed, float *r, float *c, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len)
{
    FC_GLOBAL(cgbsvx,CGBSVX)((void *) fact, (void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
}
void FC_GLOBAL3(cgbsvx,CGBSVX)(char *fact, char *trans, blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *afb, blasint *ldafb, blasint *ipiv, char *equed, float *r, float *c, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len)
{
    FC_GLOBAL(cgbsvx,CGBSVX)((void *) fact, (void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgbsvx_(void *fact, void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len)
{
    void (*fn) (void *fact, void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len);
    *(void **) &fn = current_backend->lapack.cgbsvx;
    fn((void *) fact, (void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgbsvx(void *fact, void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len) __attribute__((alias("flexiblas_real_cgbsvx_")));
#else
void flexiblas_real_cgbsvx(void *fact, void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len)
{
    flexiblas_real_cgbsvx_((void *) fact, (void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
    return;
}
#endif

void flexiblas_chain_cgbsvx_(void *fact, void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len)
{
    void (*fn) (void *fact, void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len);
    hook_pos_cgbsvx++;
    if ( hook_pos_cgbsvx < __flexiblas_hooks->cgbsvx.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgbsvx.hook_function[hook_pos_cgbsvx];
    } else {
        hook_pos_cgbsvx = 0;
        *(void **) &fn = current_backend->lapack.cgbsvx;
    }
    fn((void *) fact, (void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgbsvx(void *fact, void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len) __attribute__((alias("flexiblas_chain_cgbsvx_")));
#else
void flexiblas_chain_cgbsvx(void *fact, void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *afb, void *ldafb, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len)
{
    flexiblas_chain_cgbsvx_((void *) fact, (void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) afb, (void *) ldafb, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgbtf2 = 0;
#endif

/* Wrapper for cgbtf2 */
void FC_GLOBAL(cgbtf2,CGBTF2)
    (blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, blasint *info)
{
    void (*fn) (void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info);
    hook_pos_cgbtf2 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgbtf2;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgbtf2.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgbtf2,CGBTF2)(blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgbtf2,CGBTF2)))));
void FC_GLOBAL3(cgbtf2,CGBTF2)(blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgbtf2,CGBTF2)))));
#else
void FC_GLOBAL2(cgbtf2,CGBTF2)(blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, blasint *info)
{
    FC_GLOBAL(cgbtf2,CGBTF2)((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
}
void FC_GLOBAL3(cgbtf2,CGBTF2)(blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, blasint *info)
{
    FC_GLOBAL(cgbtf2,CGBTF2)((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgbtf2_(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info)
{
    void (*fn) (void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info);
    *(void **) &fn = current_backend->lapack.cgbtf2;
    fn((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgbtf2(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info) __attribute__((alias("flexiblas_real_cgbtf2_")));
#else
void flexiblas_real_cgbtf2(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info)
{
    flexiblas_real_cgbtf2_((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgbtf2_(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info)
{
    void (*fn) (void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info);
    hook_pos_cgbtf2++;
    if ( hook_pos_cgbtf2 < __flexiblas_hooks->cgbtf2.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgbtf2.hook_function[hook_pos_cgbtf2];
    } else {
        hook_pos_cgbtf2 = 0;
        *(void **) &fn = current_backend->lapack.cgbtf2;
    }
    fn((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgbtf2(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info) __attribute__((alias("flexiblas_chain_cgbtf2_")));
#else
void flexiblas_chain_cgbtf2(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info)
{
    flexiblas_chain_cgbtf2_((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgbtrf = 0;
#endif

/* Wrapper for cgbtrf */
void FC_GLOBAL(cgbtrf,CGBTRF)
    (blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, blasint *info)
{
    void (*fn) (void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info);
    hook_pos_cgbtrf = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgbtrf;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgbtrf.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgbtrf,CGBTRF)(blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgbtrf,CGBTRF)))));
void FC_GLOBAL3(cgbtrf,CGBTRF)(blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgbtrf,CGBTRF)))));
#else
void FC_GLOBAL2(cgbtrf,CGBTRF)(blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, blasint *info)
{
    FC_GLOBAL(cgbtrf,CGBTRF)((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
}
void FC_GLOBAL3(cgbtrf,CGBTRF)(blasint *m, blasint *n, blasint *kl, blasint *ku, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, blasint *info)
{
    FC_GLOBAL(cgbtrf,CGBTRF)((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgbtrf_(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info)
{
    void (*fn) (void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info);
    *(void **) &fn = current_backend->lapack.cgbtrf;
    fn((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgbtrf(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info) __attribute__((alias("flexiblas_real_cgbtrf_")));
#else
void flexiblas_real_cgbtrf(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info)
{
    flexiblas_real_cgbtrf_((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgbtrf_(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info)
{
    void (*fn) (void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info);
    hook_pos_cgbtrf++;
    if ( hook_pos_cgbtrf < __flexiblas_hooks->cgbtrf.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgbtrf.hook_function[hook_pos_cgbtrf];
    } else {
        hook_pos_cgbtrf = 0;
        *(void **) &fn = current_backend->lapack.cgbtrf;
    }
    fn((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgbtrf(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info) __attribute__((alias("flexiblas_chain_cgbtrf_")));
#else
void flexiblas_chain_cgbtrf(void *m, void *n, void *kl, void *ku, void *ab, void *ldab, void *ipiv, void *info)
{
    flexiblas_chain_cgbtrf_((void *) m, (void *) n, (void *) kl, (void *) ku, (void *) ab, (void *) ldab, (void *) ipiv, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgbtrs = 0;
#endif

/* Wrapper for cgbtrs */
void FC_GLOBAL(cgbtrs,CGBTRS)
    (char *trans, blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgbtrs = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgbtrs;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgbtrs.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    } else {
        fn((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    }
    #else
    fn((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgbtrs,CGBTRS)(char *trans, blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgbtrs,CGBTRS)))));
void FC_GLOBAL3(cgbtrs,CGBTRS)(char *trans, blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgbtrs,CGBTRS)))));
#else
void FC_GLOBAL2(cgbtrs,CGBTRS)(char *trans, blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgbtrs,CGBTRS)((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
}
void FC_GLOBAL3(cgbtrs,CGBTRS)(char *trans, blasint *n, blasint *kl, blasint *ku, blasint *nrhs, lapack_complex_float *ab, blasint *ldab, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgbtrs,CGBTRS)((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgbtrs_(void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len);
    *(void **) &fn = current_backend->lapack.cgbtrs;
    fn((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgbtrs(void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_real_cgbtrs_")));
#else
void flexiblas_real_cgbtrs(void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_real_cgbtrs_((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    return;
}
#endif

void flexiblas_chain_cgbtrs_(void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgbtrs++;
    if ( hook_pos_cgbtrs < __flexiblas_hooks->cgbtrs.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgbtrs.hook_function[hook_pos_cgbtrs];
    } else {
        hook_pos_cgbtrs = 0;
        *(void **) &fn = current_backend->lapack.cgbtrs;
    }
    fn((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgbtrs(void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_chain_cgbtrs_")));
#else
void flexiblas_chain_cgbtrs(void *trans, void *n, void *kl, void *ku, void *nrhs, void *ab, void *ldab, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_chain_cgbtrs_((void *) trans, (void *) n, (void *) kl, (void *) ku, (void *) nrhs, (void *) ab, (void *) ldab, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgebak = 0;
#endif

/* Wrapper for cgebak */
void FC_GLOBAL(cgebak,CGEBAK)
    (char *job, char *side, blasint *n, blasint *ilo, blasint *ihi, float *scale, blasint *m, lapack_complex_float *v, blasint *ldv, blasint *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len)
{
    void (*fn) (void *job, void *side, void *n, void *ilo, void *ihi, void *scale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *job, void *side, void *n, void *ilo, void *ihi, void *scale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len);
    hook_pos_cgebak = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgebak;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgebak.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) scale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
    } else {
        fn((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) scale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
    }
    #else
    fn((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) scale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgebak,CGEBAK)(char *job, char *side, blasint *n, blasint *ilo, blasint *ihi, float *scale, blasint *m, lapack_complex_float *v, blasint *ldv, blasint *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len) __attribute__((alias(MTS(FC_GLOBAL(cgebak,CGEBAK)))));
void FC_GLOBAL3(cgebak,CGEBAK)(char *job, char *side, blasint *n, blasint *ilo, blasint *ihi, float *scale, blasint *m, lapack_complex_float *v, blasint *ldv, blasint *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len) __attribute__((alias(MTS(FC_GLOBAL(cgebak,CGEBAK)))));
#else
void FC_GLOBAL2(cgebak,CGEBAK)(char *job, char *side, blasint *n, blasint *ilo, blasint *ihi, float *scale, blasint *m, lapack_complex_float *v, blasint *ldv, blasint *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len)
{
    FC_GLOBAL(cgebak,CGEBAK)((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) scale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
}
void FC_GLOBAL3(cgebak,CGEBAK)(char *job, char *side, blasint *n, blasint *ilo, blasint *ihi, float *scale, blasint *m, lapack_complex_float *v, blasint *ldv, blasint *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len)
{
    FC_GLOBAL(cgebak,CGEBAK)((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) scale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgebak_(void *job, void *side, void *n, void *ilo, void *ihi, void *scale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len)
{
    void (*fn) (void *job, void *side, void *n, void *ilo, void *ihi, void *scale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len);
    *(void **) &fn = current_backend->lapack.cgebak;
    fn((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) scale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgebak(void *job, void *side, void *n, void *ilo, void *ihi, void *scale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len) __attribute__((alias("flexiblas_real_cgebak_")));
#else
void flexiblas_real_cgebak(void *job, void *side, void *n, void *ilo, void *ihi, void *scale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len)
{
    flexiblas_real_cgebak_((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) scale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
    return;
}
#endif

void flexiblas_chain_cgebak_(void *job, void *side, void *n, void *ilo, void *ihi, void *scale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len)
{
    void (*fn) (void *job, void *side, void *n, void *ilo, void *ihi, void *scale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len);
    hook_pos_cgebak++;
    if ( hook_pos_cgebak < __flexiblas_hooks->cgebak.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgebak.hook_function[hook_pos_cgebak];
    } else {
        hook_pos_cgebak = 0;
        *(void **) &fn = current_backend->lapack.cgebak;
    }
    fn((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) scale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgebak(void *job, void *side, void *n, void *ilo, void *ihi, void *scale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len) __attribute__((alias("flexiblas_chain_cgebak_")));
#else
void flexiblas_chain_cgebak(void *job, void *side, void *n, void *ilo, void *ihi, void *scale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len)
{
    flexiblas_chain_cgebak_((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) scale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgebal = 0;
#endif

/* Wrapper for cgebal */
void FC_GLOBAL(cgebal,CGEBAL)
    (char *job, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ilo, blasint *ihi, float *scale, blasint *info, flexiblas_fortran_charlen_t job_len)
{
    void (*fn) (void *job, void *n, void *a, void *lda, void *ilo, void *ihi, void *scale, void *info, flexiblas_fortran_charlen_t job_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *job, void *n, void *a, void *lda, void *ilo, void *ihi, void *scale, void *info, flexiblas_fortran_charlen_t job_len);
    hook_pos_cgebal = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgebal;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgebal.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) job, (void *) n, (void *) a, (void *) lda, (void *) ilo, (void *) ihi, (void *) scale, (void *) info, job_len);
    } else {
        fn((void *) job, (void *) n, (void *) a, (void *) lda, (void *) ilo, (void *) ihi, (void *) scale, (void *) info, job_len);
    }
    #else
    fn((void *) job, (void *) n, (void *) a, (void *) lda, (void *) ilo, (void *) ihi, (void *) scale, (void *) info, job_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgebal,CGEBAL)(char *job, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ilo, blasint *ihi, float *scale, blasint *info, flexiblas_fortran_charlen_t job_len) __attribute__((alias(MTS(FC_GLOBAL(cgebal,CGEBAL)))));
void FC_GLOBAL3(cgebal,CGEBAL)(char *job, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ilo, blasint *ihi, float *scale, blasint *info, flexiblas_fortran_charlen_t job_len) __attribute__((alias(MTS(FC_GLOBAL(cgebal,CGEBAL)))));
#else
void FC_GLOBAL2(cgebal,CGEBAL)(char *job, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ilo, blasint *ihi, float *scale, blasint *info, flexiblas_fortran_charlen_t job_len)
{
    FC_GLOBAL(cgebal,CGEBAL)((void *) job, (void *) n, (void *) a, (void *) lda, (void *) ilo, (void *) ihi, (void *) scale, (void *) info, job_len);
}
void FC_GLOBAL3(cgebal,CGEBAL)(char *job, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ilo, blasint *ihi, float *scale, blasint *info, flexiblas_fortran_charlen_t job_len)
{
    FC_GLOBAL(cgebal,CGEBAL)((void *) job, (void *) n, (void *) a, (void *) lda, (void *) ilo, (void *) ihi, (void *) scale, (void *) info, job_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgebal_(void *job, void *n, void *a, void *lda, void *ilo, void *ihi, void *scale, void *info, flexiblas_fortran_charlen_t job_len)
{
    void (*fn) (void *job, void *n, void *a, void *lda, void *ilo, void *ihi, void *scale, void *info, flexiblas_fortran_charlen_t job_len);
    *(void **) &fn = current_backend->lapack.cgebal;
    fn((void *) job, (void *) n, (void *) a, (void *) lda, (void *) ilo, (void *) ihi, (void *) scale, (void *) info, job_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgebal(void *job, void *n, void *a, void *lda, void *ilo, void *ihi, void *scale, void *info, flexiblas_fortran_charlen_t job_len) __attribute__((alias("flexiblas_real_cgebal_")));
#else
void flexiblas_real_cgebal(void *job, void *n, void *a, void *lda, void *ilo, void *ihi, void *scale, void *info, flexiblas_fortran_charlen_t job_len)
{
    flexiblas_real_cgebal_((void *) job, (void *) n, (void *) a, (void *) lda, (void *) ilo, (void *) ihi, (void *) scale, (void *) info, job_len);
    return;
}
#endif

void flexiblas_chain_cgebal_(void *job, void *n, void *a, void *lda, void *ilo, void *ihi, void *scale, void *info, flexiblas_fortran_charlen_t job_len)
{
    void (*fn) (void *job, void *n, void *a, void *lda, void *ilo, void *ihi, void *scale, void *info, flexiblas_fortran_charlen_t job_len);
    hook_pos_cgebal++;
    if ( hook_pos_cgebal < __flexiblas_hooks->cgebal.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgebal.hook_function[hook_pos_cgebal];
    } else {
        hook_pos_cgebal = 0;
        *(void **) &fn = current_backend->lapack.cgebal;
    }
    fn((void *) job, (void *) n, (void *) a, (void *) lda, (void *) ilo, (void *) ihi, (void *) scale, (void *) info, job_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgebal(void *job, void *n, void *a, void *lda, void *ilo, void *ihi, void *scale, void *info, flexiblas_fortran_charlen_t job_len) __attribute__((alias("flexiblas_chain_cgebal_")));
#else
void flexiblas_chain_cgebal(void *job, void *n, void *a, void *lda, void *ilo, void *ihi, void *scale, void *info, flexiblas_fortran_charlen_t job_len)
{
    flexiblas_chain_cgebal_((void *) job, (void *) n, (void *) a, (void *) lda, (void *) ilo, (void *) ihi, (void *) scale, (void *) info, job_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgebd2 = 0;
#endif

/* Wrapper for cgebd2 */
void FC_GLOBAL(cgebd2,CGEBD2)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *d, float *e, lapack_complex_float *tauq, lapack_complex_float *taup, lapack_complex_float *work, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *info);
    hook_pos_cgebd2 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgebd2;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgebd2.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgebd2,CGEBD2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *d, float *e, lapack_complex_float *tauq, lapack_complex_float *taup, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgebd2,CGEBD2)))));
void FC_GLOBAL3(cgebd2,CGEBD2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *d, float *e, lapack_complex_float *tauq, lapack_complex_float *taup, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgebd2,CGEBD2)))));
#else
void FC_GLOBAL2(cgebd2,CGEBD2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *d, float *e, lapack_complex_float *tauq, lapack_complex_float *taup, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgebd2,CGEBD2)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) info);
}
void FC_GLOBAL3(cgebd2,CGEBD2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *d, float *e, lapack_complex_float *tauq, lapack_complex_float *taup, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgebd2,CGEBD2)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgebd2_(void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *info);
    *(void **) &fn = current_backend->lapack.cgebd2;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgebd2(void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *info) __attribute__((alias("flexiblas_real_cgebd2_")));
#else
void flexiblas_real_cgebd2(void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *info)
{
    flexiblas_real_cgebd2_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgebd2_(void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *info);
    hook_pos_cgebd2++;
    if ( hook_pos_cgebd2 < __flexiblas_hooks->cgebd2.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgebd2.hook_function[hook_pos_cgebd2];
    } else {
        hook_pos_cgebd2 = 0;
        *(void **) &fn = current_backend->lapack.cgebd2;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgebd2(void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *info) __attribute__((alias("flexiblas_chain_cgebd2_")));
#else
void flexiblas_chain_cgebd2(void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *info)
{
    flexiblas_chain_cgebd2_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgebrd = 0;
#endif

/* Wrapper for cgebrd */
void FC_GLOBAL(cgebrd,CGEBRD)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *d, float *e, lapack_complex_float *tauq, lapack_complex_float *taup, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *lwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *lwork, void *info);
    hook_pos_cgebrd = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgebrd;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgebrd.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) lwork, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) lwork, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) lwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgebrd,CGEBRD)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *d, float *e, lapack_complex_float *tauq, lapack_complex_float *taup, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgebrd,CGEBRD)))));
void FC_GLOBAL3(cgebrd,CGEBRD)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *d, float *e, lapack_complex_float *tauq, lapack_complex_float *taup, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgebrd,CGEBRD)))));
#else
void FC_GLOBAL2(cgebrd,CGEBRD)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *d, float *e, lapack_complex_float *tauq, lapack_complex_float *taup, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgebrd,CGEBRD)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) lwork, (void *) info);
}
void FC_GLOBAL3(cgebrd,CGEBRD)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *d, float *e, lapack_complex_float *tauq, lapack_complex_float *taup, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgebrd,CGEBRD)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) lwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgebrd_(void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *lwork, void *info);
    *(void **) &fn = current_backend->lapack.cgebrd;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgebrd(void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_real_cgebrd_")));
#else
void flexiblas_real_cgebrd(void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *lwork, void *info)
{
    flexiblas_real_cgebrd_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgebrd_(void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *lwork, void *info);
    hook_pos_cgebrd++;
    if ( hook_pos_cgebrd < __flexiblas_hooks->cgebrd.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgebrd.hook_function[hook_pos_cgebrd];
    } else {
        hook_pos_cgebrd = 0;
        *(void **) &fn = current_backend->lapack.cgebrd;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgebrd(void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_chain_cgebrd_")));
#else
void flexiblas_chain_cgebrd(void *m, void *n, void *a, void *lda, void *d, void *e, void *tauq, void *taup, void *work, void *lwork, void *info)
{
    flexiblas_chain_cgebrd_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tauq, (void *) taup, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgecon = 0;
#endif

/* Wrapper for cgecon */
void FC_GLOBAL(cgecon,CGECON)
    (char *norm, blasint *n, lapack_complex_float *a, blasint *lda, float *anorm, float *rcond, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t norm_len)
{
    void (*fn) (void *norm, void *n, void *a, void *lda, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *norm, void *n, void *a, void *lda, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len);
    hook_pos_cgecon = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgecon;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgecon.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) norm, (void *) n, (void *) a, (void *) lda, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
    } else {
        fn((void *) norm, (void *) n, (void *) a, (void *) lda, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
    }
    #else
    fn((void *) norm, (void *) n, (void *) a, (void *) lda, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgecon,CGECON)(char *norm, blasint *n, lapack_complex_float *a, blasint *lda, float *anorm, float *rcond, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t norm_len) __attribute__((alias(MTS(FC_GLOBAL(cgecon,CGECON)))));
void FC_GLOBAL3(cgecon,CGECON)(char *norm, blasint *n, lapack_complex_float *a, blasint *lda, float *anorm, float *rcond, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t norm_len) __attribute__((alias(MTS(FC_GLOBAL(cgecon,CGECON)))));
#else
void FC_GLOBAL2(cgecon,CGECON)(char *norm, blasint *n, lapack_complex_float *a, blasint *lda, float *anorm, float *rcond, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t norm_len)
{
    FC_GLOBAL(cgecon,CGECON)((void *) norm, (void *) n, (void *) a, (void *) lda, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
}
void FC_GLOBAL3(cgecon,CGECON)(char *norm, blasint *n, lapack_complex_float *a, blasint *lda, float *anorm, float *rcond, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t norm_len)
{
    FC_GLOBAL(cgecon,CGECON)((void *) norm, (void *) n, (void *) a, (void *) lda, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgecon_(void *norm, void *n, void *a, void *lda, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len)
{
    void (*fn) (void *norm, void *n, void *a, void *lda, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len);
    *(void **) &fn = current_backend->lapack.cgecon;
    fn((void *) norm, (void *) n, (void *) a, (void *) lda, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgecon(void *norm, void *n, void *a, void *lda, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len) __attribute__((alias("flexiblas_real_cgecon_")));
#else
void flexiblas_real_cgecon(void *norm, void *n, void *a, void *lda, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len)
{
    flexiblas_real_cgecon_((void *) norm, (void *) n, (void *) a, (void *) lda, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
    return;
}
#endif

void flexiblas_chain_cgecon_(void *norm, void *n, void *a, void *lda, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len)
{
    void (*fn) (void *norm, void *n, void *a, void *lda, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len);
    hook_pos_cgecon++;
    if ( hook_pos_cgecon < __flexiblas_hooks->cgecon.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgecon.hook_function[hook_pos_cgecon];
    } else {
        hook_pos_cgecon = 0;
        *(void **) &fn = current_backend->lapack.cgecon;
    }
    fn((void *) norm, (void *) n, (void *) a, (void *) lda, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgecon(void *norm, void *n, void *a, void *lda, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len) __attribute__((alias("flexiblas_chain_cgecon_")));
#else
void flexiblas_chain_cgecon(void *norm, void *n, void *a, void *lda, void *anorm, void *rcond, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t norm_len)
{
    flexiblas_chain_cgecon_((void *) norm, (void *) n, (void *) a, (void *) lda, (void *) anorm, (void *) rcond, (void *) work, (void *) rwork, (void *) info, norm_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgedmd = 0;
#endif

/* Wrapper for cgedmd */
void FC_GLOBAL(cgedmd,CGEDMD)
    (char *jobs, char *jobz, char *jobr, char *jobf, blasint *whtsvd, blasint *m, blasint *n, lapack_complex_float *x, blasint *ldx, lapack_complex_float *y, blasint *ldy, blasint *nrnk, float *tol, blasint *k, lapack_complex_float *eigs, lapack_complex_float *z, blasint *ldz, float *res, lapack_complex_float *b, blasint *ldb, lapack_complex_float *w, blasint *ldw, lapack_complex_float *s, blasint *lds, lapack_complex_float *zwork, blasint *lzwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobf_len)
{
    void (*fn) (void *jobs, void *jobz, void *jobr, void *jobf, void *whtsvd, void *m, void *n, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *w, void *ldw, void *s, void *lds, void *zwork, void *lzwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobf_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobs, void *jobz, void *jobr, void *jobf, void *whtsvd, void *m, void *n, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *w, void *ldw, void *s, void *lds, void *zwork, void *lzwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobf_len);
    hook_pos_cgedmd = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgedmd;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgedmd.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) w, (void *) ldw, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobf_len);
    } else {
        fn((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) w, (void *) ldw, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobf_len);
    }
    #else
    fn((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) w, (void *) ldw, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobf_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgedmd,CGEDMD)(char *jobs, char *jobz, char *jobr, char *jobf, blasint *whtsvd, blasint *m, blasint *n, lapack_complex_float *x, blasint *ldx, lapack_complex_float *y, blasint *ldy, blasint *nrnk, float *tol, blasint *k, lapack_complex_float *eigs, lapack_complex_float *z, blasint *ldz, float *res, lapack_complex_float *b, blasint *ldb, lapack_complex_float *w, blasint *ldw, lapack_complex_float *s, blasint *lds, lapack_complex_float *zwork, blasint *lzwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobf_len) __attribute__((alias(MTS(FC_GLOBAL(cgedmd,CGEDMD)))));
void FC_GLOBAL3(cgedmd,CGEDMD)(char *jobs, char *jobz, char *jobr, char *jobf, blasint *whtsvd, blasint *m, blasint *n, lapack_complex_float *x, blasint *ldx, lapack_complex_float *y, blasint *ldy, blasint *nrnk, float *tol, blasint *k, lapack_complex_float *eigs, lapack_complex_float *z, blasint *ldz, float *res, lapack_complex_float *b, blasint *ldb, lapack_complex_float *w, blasint *ldw, lapack_complex_float *s, blasint *lds, lapack_complex_float *zwork, blasint *lzwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobf_len) __attribute__((alias(MTS(FC_GLOBAL(cgedmd,CGEDMD)))));
#else
void FC_GLOBAL2(cgedmd,CGEDMD)(char *jobs, char *jobz, char *jobr, char *jobf, blasint *whtsvd, blasint *m, blasint *n, lapack_complex_float *x, blasint *ldx, lapack_complex_float *y, blasint *ldy, blasint *nrnk, float *tol, blasint *k, lapack_complex_float *eigs, lapack_complex_float *z, blasint *ldz, float *res, lapack_complex_float *b, blasint *ldb, lapack_complex_float *w, blasint *ldw, lapack_complex_float *s, blasint *lds, lapack_complex_float *zwork, blasint *lzwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobf_len)
{
    FC_GLOBAL(cgedmd,CGEDMD)((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) w, (void *) ldw, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobf_len);
}
void FC_GLOBAL3(cgedmd,CGEDMD)(char *jobs, char *jobz, char *jobr, char *jobf, blasint *whtsvd, blasint *m, blasint *n, lapack_complex_float *x, blasint *ldx, lapack_complex_float *y, blasint *ldy, blasint *nrnk, float *tol, blasint *k, lapack_complex_float *eigs, lapack_complex_float *z, blasint *ldz, float *res, lapack_complex_float *b, blasint *ldb, lapack_complex_float *w, blasint *ldw, lapack_complex_float *s, blasint *lds, lapack_complex_float *zwork, blasint *lzwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobf_len)
{
    FC_GLOBAL(cgedmd,CGEDMD)((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) w, (void *) ldw, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobf_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgedmd_(void *jobs, void *jobz, void *jobr, void *jobf, void *whtsvd, void *m, void *n, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *w, void *ldw, void *s, void *lds, void *zwork, void *lzwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobf_len)
{
    void (*fn) (void *jobs, void *jobz, void *jobr, void *jobf, void *whtsvd, void *m, void *n, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *w, void *ldw, void *s, void *lds, void *zwork, void *lzwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobf_len);
    *(void **) &fn = current_backend->lapack.cgedmd;
    fn((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) w, (void *) ldw, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobf_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgedmd(void *jobs, void *jobz, void *jobr, void *jobf, void *whtsvd, void *m, void *n, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *w, void *ldw, void *s, void *lds, void *zwork, void *lzwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobf_len) __attribute__((alias("flexiblas_real_cgedmd_")));
#else
void flexiblas_real_cgedmd(void *jobs, void *jobz, void *jobr, void *jobf, void *whtsvd, void *m, void *n, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *w, void *ldw, void *s, void *lds, void *zwork, void *lzwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobf_len)
{
    flexiblas_real_cgedmd_((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) w, (void *) ldw, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobf_len);
    return;
}
#endif

void flexiblas_chain_cgedmd_(void *jobs, void *jobz, void *jobr, void *jobf, void *whtsvd, void *m, void *n, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *w, void *ldw, void *s, void *lds, void *zwork, void *lzwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobf_len)
{
    void (*fn) (void *jobs, void *jobz, void *jobr, void *jobf, void *whtsvd, void *m, void *n, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *w, void *ldw, void *s, void *lds, void *zwork, void *lzwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobf_len);
    hook_pos_cgedmd++;
    if ( hook_pos_cgedmd < __flexiblas_hooks->cgedmd.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgedmd.hook_function[hook_pos_cgedmd];
    } else {
        hook_pos_cgedmd = 0;
        *(void **) &fn = current_backend->lapack.cgedmd;
    }
    fn((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) w, (void *) ldw, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobf_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgedmd(void *jobs, void *jobz, void *jobr, void *jobf, void *whtsvd, void *m, void *n, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *w, void *ldw, void *s, void *lds, void *zwork, void *lzwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobf_len) __attribute__((alias("flexiblas_chain_cgedmd_")));
#else
void flexiblas_chain_cgedmd(void *jobs, void *jobz, void *jobr, void *jobf, void *whtsvd, void *m, void *n, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *w, void *ldw, void *s, void *lds, void *zwork, void *lzwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobf_len)
{
    flexiblas_chain_cgedmd_((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) w, (void *) ldw, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobf_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgedmdq = 0;
#endif

/* Wrapper for cgedmdq */
void FC_GLOBAL(cgedmdq,CGEDMDQ)
    (char *jobs, char *jobz, char *jobr, char *jobq, char *jobt, char *jobf, blasint *whtsvd, blasint *m, blasint *n, lapack_complex_float *f, blasint *ldf, lapack_complex_float *x, blasint *ldx, lapack_complex_float *y, blasint *ldy, blasint *nrnk, float *tol, blasint *k, lapack_complex_float *eigs, lapack_complex_float *z, blasint *ldz, float *res, lapack_complex_float *b, blasint *ldb, lapack_complex_float *v, blasint *ldv, lapack_complex_float *s, blasint *lds, lapack_complex_float *zwork, blasint *lzwork, float *work, blasint *lwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobq_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobf_len)
{
    void (*fn) (void *jobs, void *jobz, void *jobr, void *jobq, void *jobt, void *jobf, void *whtsvd, void *m, void *n, void *f, void *ldf, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *v, void *ldv, void *s, void *lds, void *zwork, void *lzwork, void *work, void *lwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobq_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobf_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobs, void *jobz, void *jobr, void *jobq, void *jobt, void *jobf, void *whtsvd, void *m, void *n, void *f, void *ldf, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *v, void *ldv, void *s, void *lds, void *zwork, void *lzwork, void *work, void *lwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobq_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobf_len);
    hook_pos_cgedmdq = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgedmdq;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgedmdq.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobq, (void *) jobt, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) f, (void *) ldf, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) v, (void *) ldv, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) work, (void *) lwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobq_len, jobt_len, jobf_len);
    } else {
        fn((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobq, (void *) jobt, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) f, (void *) ldf, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) v, (void *) ldv, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) work, (void *) lwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobq_len, jobt_len, jobf_len);
    }
    #else
    fn((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobq, (void *) jobt, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) f, (void *) ldf, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) v, (void *) ldv, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) work, (void *) lwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobq_len, jobt_len, jobf_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgedmdq,CGEDMDQ)(char *jobs, char *jobz, char *jobr, char *jobq, char *jobt, char *jobf, blasint *whtsvd, blasint *m, blasint *n, lapack_complex_float *f, blasint *ldf, lapack_complex_float *x, blasint *ldx, lapack_complex_float *y, blasint *ldy, blasint *nrnk, float *tol, blasint *k, lapack_complex_float *eigs, lapack_complex_float *z, blasint *ldz, float *res, lapack_complex_float *b, blasint *ldb, lapack_complex_float *v, blasint *ldv, lapack_complex_float *s, blasint *lds, lapack_complex_float *zwork, blasint *lzwork, float *work, blasint *lwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobq_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobf_len) __attribute__((alias(MTS(FC_GLOBAL(cgedmdq,CGEDMDQ)))));
void FC_GLOBAL3(cgedmdq,CGEDMDQ)(char *jobs, char *jobz, char *jobr, char *jobq, char *jobt, char *jobf, blasint *whtsvd, blasint *m, blasint *n, lapack_complex_float *f, blasint *ldf, lapack_complex_float *x, blasint *ldx, lapack_complex_float *y, blasint *ldy, blasint *nrnk, float *tol, blasint *k, lapack_complex_float *eigs, lapack_complex_float *z, blasint *ldz, float *res, lapack_complex_float *b, blasint *ldb, lapack_complex_float *v, blasint *ldv, lapack_complex_float *s, blasint *lds, lapack_complex_float *zwork, blasint *lzwork, float *work, blasint *lwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobq_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobf_len) __attribute__((alias(MTS(FC_GLOBAL(cgedmdq,CGEDMDQ)))));
#else
void FC_GLOBAL2(cgedmdq,CGEDMDQ)(char *jobs, char *jobz, char *jobr, char *jobq, char *jobt, char *jobf, blasint *whtsvd, blasint *m, blasint *n, lapack_complex_float *f, blasint *ldf, lapack_complex_float *x, blasint *ldx, lapack_complex_float *y, blasint *ldy, blasint *nrnk, float *tol, blasint *k, lapack_complex_float *eigs, lapack_complex_float *z, blasint *ldz, float *res, lapack_complex_float *b, blasint *ldb, lapack_complex_float *v, blasint *ldv, lapack_complex_float *s, blasint *lds, lapack_complex_float *zwork, blasint *lzwork, float *work, blasint *lwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobq_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobf_len)
{
    FC_GLOBAL(cgedmdq,CGEDMDQ)((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobq, (void *) jobt, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) f, (void *) ldf, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) v, (void *) ldv, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) work, (void *) lwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobq_len, jobt_len, jobf_len);
}
void FC_GLOBAL3(cgedmdq,CGEDMDQ)(char *jobs, char *jobz, char *jobr, char *jobq, char *jobt, char *jobf, blasint *whtsvd, blasint *m, blasint *n, lapack_complex_float *f, blasint *ldf, lapack_complex_float *x, blasint *ldx, lapack_complex_float *y, blasint *ldy, blasint *nrnk, float *tol, blasint *k, lapack_complex_float *eigs, lapack_complex_float *z, blasint *ldz, float *res, lapack_complex_float *b, blasint *ldb, lapack_complex_float *v, blasint *ldv, lapack_complex_float *s, blasint *lds, lapack_complex_float *zwork, blasint *lzwork, float *work, blasint *lwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobq_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobf_len)
{
    FC_GLOBAL(cgedmdq,CGEDMDQ)((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobq, (void *) jobt, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) f, (void *) ldf, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) v, (void *) ldv, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) work, (void *) lwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobq_len, jobt_len, jobf_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgedmdq_(void *jobs, void *jobz, void *jobr, void *jobq, void *jobt, void *jobf, void *whtsvd, void *m, void *n, void *f, void *ldf, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *v, void *ldv, void *s, void *lds, void *zwork, void *lzwork, void *work, void *lwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobq_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobf_len)
{
    void (*fn) (void *jobs, void *jobz, void *jobr, void *jobq, void *jobt, void *jobf, void *whtsvd, void *m, void *n, void *f, void *ldf, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *v, void *ldv, void *s, void *lds, void *zwork, void *lzwork, void *work, void *lwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobq_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobf_len);
    *(void **) &fn = current_backend->lapack.cgedmdq;
    fn((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobq, (void *) jobt, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) f, (void *) ldf, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) v, (void *) ldv, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) work, (void *) lwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobq_len, jobt_len, jobf_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgedmdq(void *jobs, void *jobz, void *jobr, void *jobq, void *jobt, void *jobf, void *whtsvd, void *m, void *n, void *f, void *ldf, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *v, void *ldv, void *s, void *lds, void *zwork, void *lzwork, void *work, void *lwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobq_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobf_len) __attribute__((alias("flexiblas_real_cgedmdq_")));
#else
void flexiblas_real_cgedmdq(void *jobs, void *jobz, void *jobr, void *jobq, void *jobt, void *jobf, void *whtsvd, void *m, void *n, void *f, void *ldf, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *v, void *ldv, void *s, void *lds, void *zwork, void *lzwork, void *work, void *lwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobq_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobf_len)
{
    flexiblas_real_cgedmdq_((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobq, (void *) jobt, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) f, (void *) ldf, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) v, (void *) ldv, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) work, (void *) lwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobq_len, jobt_len, jobf_len);
    return;
}
#endif

void flexiblas_chain_cgedmdq_(void *jobs, void *jobz, void *jobr, void *jobq, void *jobt, void *jobf, void *whtsvd, void *m, void *n, void *f, void *ldf, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *v, void *ldv, void *s, void *lds, void *zwork, void *lzwork, void *work, void *lwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobq_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobf_len)
{
    void (*fn) (void *jobs, void *jobz, void *jobr, void *jobq, void *jobt, void *jobf, void *whtsvd, void *m, void *n, void *f, void *ldf, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *v, void *ldv, void *s, void *lds, void *zwork, void *lzwork, void *work, void *lwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobq_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobf_len);
    hook_pos_cgedmdq++;
    if ( hook_pos_cgedmdq < __flexiblas_hooks->cgedmdq.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgedmdq.hook_function[hook_pos_cgedmdq];
    } else {
        hook_pos_cgedmdq = 0;
        *(void **) &fn = current_backend->lapack.cgedmdq;
    }
    fn((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobq, (void *) jobt, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) f, (void *) ldf, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) v, (void *) ldv, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) work, (void *) lwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobq_len, jobt_len, jobf_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgedmdq(void *jobs, void *jobz, void *jobr, void *jobq, void *jobt, void *jobf, void *whtsvd, void *m, void *n, void *f, void *ldf, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *v, void *ldv, void *s, void *lds, void *zwork, void *lzwork, void *work, void *lwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobq_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobf_len) __attribute__((alias("flexiblas_chain_cgedmdq_")));
#else
void flexiblas_chain_cgedmdq(void *jobs, void *jobz, void *jobr, void *jobq, void *jobt, void *jobf, void *whtsvd, void *m, void *n, void *f, void *ldf, void *x, void *ldx, void *y, void *ldy, void *nrnk, void *tol, void *k, void *eigs, void *z, void *ldz, void *res, void *b, void *ldb, void *v, void *ldv, void *s, void *lds, void *zwork, void *lzwork, void *work, void *lwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobs_len, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobq_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobf_len)
{
    flexiblas_chain_cgedmdq_((void *) jobs, (void *) jobz, (void *) jobr, (void *) jobq, (void *) jobt, (void *) jobf, (void *) whtsvd, (void *) m, (void *) n, (void *) f, (void *) ldf, (void *) x, (void *) ldx, (void *) y, (void *) ldy, (void *) nrnk, (void *) tol, (void *) k, (void *) eigs, (void *) z, (void *) ldz, (void *) res, (void *) b, (void *) ldb, (void *) v, (void *) ldv, (void *) s, (void *) lds, (void *) zwork, (void *) lzwork, (void *) work, (void *) lwork, (void *) iwork, (void *) liwork, (void *) info, jobs_len, jobz_len, jobr_len, jobq_len, jobt_len, jobf_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeequ = 0;
#endif

/* Wrapper for cgeequ */
void FC_GLOBAL(cgeequ,CGEEQU)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info);
    hook_pos_cgeequ = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeequ;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeequ.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeequ,CGEEQU)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeequ,CGEEQU)))));
void FC_GLOBAL3(cgeequ,CGEEQU)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeequ,CGEEQU)))));
#else
void FC_GLOBAL2(cgeequ,CGEEQU)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info)
{
    FC_GLOBAL(cgeequ,CGEEQU)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
}
void FC_GLOBAL3(cgeequ,CGEEQU)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info)
{
    FC_GLOBAL(cgeequ,CGEEQU)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeequ_(void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info);
    *(void **) &fn = current_backend->lapack.cgeequ;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeequ(void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info) __attribute__((alias("flexiblas_real_cgeequ_")));
#else
void flexiblas_real_cgeequ(void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info)
{
    flexiblas_real_cgeequ_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgeequ_(void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info);
    hook_pos_cgeequ++;
    if ( hook_pos_cgeequ < __flexiblas_hooks->cgeequ.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeequ.hook_function[hook_pos_cgeequ];
    } else {
        hook_pos_cgeequ = 0;
        *(void **) &fn = current_backend->lapack.cgeequ;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeequ(void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info) __attribute__((alias("flexiblas_chain_cgeequ_")));
#else
void flexiblas_chain_cgeequ(void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info)
{
    flexiblas_chain_cgeequ_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeequb = 0;
#endif

/* Wrapper for cgeequb */
void FC_GLOBAL(cgeequb,CGEEQUB)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info);
    hook_pos_cgeequb = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeequb;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeequb.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeequb,CGEEQUB)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeequb,CGEEQUB)))));
void FC_GLOBAL3(cgeequb,CGEEQUB)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeequb,CGEEQUB)))));
#else
void FC_GLOBAL2(cgeequb,CGEEQUB)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info)
{
    FC_GLOBAL(cgeequb,CGEEQUB)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
}
void FC_GLOBAL3(cgeequb,CGEEQUB)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *r, float *c, float *rowcnd, float *colcnd, float *amax, blasint *info)
{
    FC_GLOBAL(cgeequb,CGEEQUB)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeequb_(void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info);
    *(void **) &fn = current_backend->lapack.cgeequb;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeequb(void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info) __attribute__((alias("flexiblas_real_cgeequb_")));
#else
void flexiblas_real_cgeequb(void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info)
{
    flexiblas_real_cgeequb_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgeequb_(void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info);
    hook_pos_cgeequb++;
    if ( hook_pos_cgeequb < __flexiblas_hooks->cgeequb.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeequb.hook_function[hook_pos_cgeequb];
    } else {
        hook_pos_cgeequb = 0;
        *(void **) &fn = current_backend->lapack.cgeequb;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeequb(void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info) __attribute__((alias("flexiblas_chain_cgeequb_")));
#else
void flexiblas_chain_cgeequb(void *m, void *n, void *a, void *lda, void *r, void *c, void *rowcnd, void *colcnd, void *amax, void *info)
{
    flexiblas_chain_cgeequb_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) r, (void *) c, (void *) rowcnd, (void *) colcnd, (void *) amax, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgees = 0;
#endif

/* Wrapper for cgees */
void FC_GLOBAL(cgees,CGEES)
    (char *jobvs, char *sort, blaslogical *select, blasint *n, lapack_complex_float *a, blasint *lda, blasint *sdim, lapack_complex_float *w, lapack_complex_float *vs, blasint *ldvs, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len)
{
    void (*fn) (void *jobvs, void *sort, void *select, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobvs, void *sort, void *select, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len);
    hook_pos_cgees = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgees;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgees.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobvs, (void *) sort, (void *) select, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len);
    } else {
        fn((void *) jobvs, (void *) sort, (void *) select, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len);
    }
    #else
    fn((void *) jobvs, (void *) sort, (void *) select, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgees,CGEES)(char *jobvs, char *sort, blaslogical *select, blasint *n, lapack_complex_float *a, blasint *lda, blasint *sdim, lapack_complex_float *w, lapack_complex_float *vs, blasint *ldvs, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len) __attribute__((alias(MTS(FC_GLOBAL(cgees,CGEES)))));
void FC_GLOBAL3(cgees,CGEES)(char *jobvs, char *sort, blaslogical *select, blasint *n, lapack_complex_float *a, blasint *lda, blasint *sdim, lapack_complex_float *w, lapack_complex_float *vs, blasint *ldvs, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len) __attribute__((alias(MTS(FC_GLOBAL(cgees,CGEES)))));
#else
void FC_GLOBAL2(cgees,CGEES)(char *jobvs, char *sort, blaslogical *select, blasint *n, lapack_complex_float *a, blasint *lda, blasint *sdim, lapack_complex_float *w, lapack_complex_float *vs, blasint *ldvs, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len)
{
    FC_GLOBAL(cgees,CGEES)((void *) jobvs, (void *) sort, (void *) select, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len);
}
void FC_GLOBAL3(cgees,CGEES)(char *jobvs, char *sort, blaslogical *select, blasint *n, lapack_complex_float *a, blasint *lda, blasint *sdim, lapack_complex_float *w, lapack_complex_float *vs, blasint *ldvs, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len)
{
    FC_GLOBAL(cgees,CGEES)((void *) jobvs, (void *) sort, (void *) select, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgees_(void *jobvs, void *sort, void *select, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len)
{
    void (*fn) (void *jobvs, void *sort, void *select, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len);
    *(void **) &fn = current_backend->lapack.cgees;
    fn((void *) jobvs, (void *) sort, (void *) select, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgees(void *jobvs, void *sort, void *select, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len) __attribute__((alias("flexiblas_real_cgees_")));
#else
void flexiblas_real_cgees(void *jobvs, void *sort, void *select, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len)
{
    flexiblas_real_cgees_((void *) jobvs, (void *) sort, (void *) select, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len);
    return;
}
#endif

void flexiblas_chain_cgees_(void *jobvs, void *sort, void *select, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len)
{
    void (*fn) (void *jobvs, void *sort, void *select, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len);
    hook_pos_cgees++;
    if ( hook_pos_cgees < __flexiblas_hooks->cgees.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgees.hook_function[hook_pos_cgees];
    } else {
        hook_pos_cgees = 0;
        *(void **) &fn = current_backend->lapack.cgees;
    }
    fn((void *) jobvs, (void *) sort, (void *) select, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgees(void *jobvs, void *sort, void *select, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len) __attribute__((alias("flexiblas_chain_cgees_")));
#else
void flexiblas_chain_cgees(void *jobvs, void *sort, void *select, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len)
{
    flexiblas_chain_cgees_((void *) jobvs, (void *) sort, (void *) select, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeesx = 0;
#endif

/* Wrapper for cgeesx */
void FC_GLOBAL(cgeesx,CGEESX)
    (char *jobvs, char *sort, blaslogical *select, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, blasint *sdim, lapack_complex_float *w, lapack_complex_float *vs, blasint *ldvs, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len)
{
    void (*fn) (void *jobvs, void *sort, void *select, void *sense, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobvs, void *sort, void *select, void *sense, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len);
    hook_pos_cgeesx = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeesx;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeesx.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobvs, (void *) sort, (void *) select, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len, sense_len);
    } else {
        fn((void *) jobvs, (void *) sort, (void *) select, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len, sense_len);
    }
    #else
    fn((void *) jobvs, (void *) sort, (void *) select, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len, sense_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeesx,CGEESX)(char *jobvs, char *sort, blaslogical *select, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, blasint *sdim, lapack_complex_float *w, lapack_complex_float *vs, blasint *ldvs, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len) __attribute__((alias(MTS(FC_GLOBAL(cgeesx,CGEESX)))));
void FC_GLOBAL3(cgeesx,CGEESX)(char *jobvs, char *sort, blaslogical *select, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, blasint *sdim, lapack_complex_float *w, lapack_complex_float *vs, blasint *ldvs, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len) __attribute__((alias(MTS(FC_GLOBAL(cgeesx,CGEESX)))));
#else
void FC_GLOBAL2(cgeesx,CGEESX)(char *jobvs, char *sort, blaslogical *select, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, blasint *sdim, lapack_complex_float *w, lapack_complex_float *vs, blasint *ldvs, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len)
{
    FC_GLOBAL(cgeesx,CGEESX)((void *) jobvs, (void *) sort, (void *) select, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len, sense_len);
}
void FC_GLOBAL3(cgeesx,CGEESX)(char *jobvs, char *sort, blaslogical *select, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, blasint *sdim, lapack_complex_float *w, lapack_complex_float *vs, blasint *ldvs, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len)
{
    FC_GLOBAL(cgeesx,CGEESX)((void *) jobvs, (void *) sort, (void *) select, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len, sense_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeesx_(void *jobvs, void *sort, void *select, void *sense, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len)
{
    void (*fn) (void *jobvs, void *sort, void *select, void *sense, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len);
    *(void **) &fn = current_backend->lapack.cgeesx;
    fn((void *) jobvs, (void *) sort, (void *) select, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len, sense_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeesx(void *jobvs, void *sort, void *select, void *sense, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len) __attribute__((alias("flexiblas_real_cgeesx_")));
#else
void flexiblas_real_cgeesx(void *jobvs, void *sort, void *select, void *sense, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len)
{
    flexiblas_real_cgeesx_((void *) jobvs, (void *) sort, (void *) select, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len, sense_len);
    return;
}
#endif

void flexiblas_chain_cgeesx_(void *jobvs, void *sort, void *select, void *sense, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len)
{
    void (*fn) (void *jobvs, void *sort, void *select, void *sense, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len);
    hook_pos_cgeesx++;
    if ( hook_pos_cgeesx < __flexiblas_hooks->cgeesx.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeesx.hook_function[hook_pos_cgeesx];
    } else {
        hook_pos_cgeesx = 0;
        *(void **) &fn = current_backend->lapack.cgeesx;
    }
    fn((void *) jobvs, (void *) sort, (void *) select, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len, sense_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeesx(void *jobvs, void *sort, void *select, void *sense, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len) __attribute__((alias("flexiblas_chain_cgeesx_")));
#else
void flexiblas_chain_cgeesx(void *jobvs, void *sort, void *select, void *sense, void *n, void *a, void *lda, void *sdim, void *w, void *vs, void *ldvs, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvs_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len)
{
    flexiblas_chain_cgeesx_((void *) jobvs, (void *) sort, (void *) select, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) sdim, (void *) w, (void *) vs, (void *) ldvs, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvs_len, sort_len, sense_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeev = 0;
#endif

/* Wrapper for cgeev */
void FC_GLOBAL(cgeev,CGEEV)
    (char *jobvl, char *jobvr, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *w, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    void (*fn) (void *jobvl, void *jobvr, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobvl, void *jobvr, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len);
    hook_pos_cgeev = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeev;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeev.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    } else {
        fn((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    }
    #else
    fn((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeev,CGEEV)(char *jobvl, char *jobvr, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *w, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len) __attribute__((alias(MTS(FC_GLOBAL(cgeev,CGEEV)))));
void FC_GLOBAL3(cgeev,CGEEV)(char *jobvl, char *jobvr, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *w, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len) __attribute__((alias(MTS(FC_GLOBAL(cgeev,CGEEV)))));
#else
void FC_GLOBAL2(cgeev,CGEEV)(char *jobvl, char *jobvr, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *w, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    FC_GLOBAL(cgeev,CGEEV)((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
}
void FC_GLOBAL3(cgeev,CGEEV)(char *jobvl, char *jobvr, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *w, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    FC_GLOBAL(cgeev,CGEEV)((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeev_(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    void (*fn) (void *jobvl, void *jobvr, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len);
    *(void **) &fn = current_backend->lapack.cgeev;
    fn((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeev(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len) __attribute__((alias("flexiblas_real_cgeev_")));
#else
void flexiblas_real_cgeev(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    flexiblas_real_cgeev_((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    return;
}
#endif

void flexiblas_chain_cgeev_(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    void (*fn) (void *jobvl, void *jobvr, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len);
    hook_pos_cgeev++;
    if ( hook_pos_cgeev < __flexiblas_hooks->cgeev.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeev.hook_function[hook_pos_cgeev];
    } else {
        hook_pos_cgeev = 0;
        *(void **) &fn = current_backend->lapack.cgeev;
    }
    fn((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeev(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len) __attribute__((alias("flexiblas_chain_cgeev_")));
#else
void flexiblas_chain_cgeev(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    flexiblas_chain_cgeev_((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeevx = 0;
#endif

/* Wrapper for cgeevx */
void FC_GLOBAL(cgeevx,CGEEVX)
    (char *balanc, char *jobvl, char *jobvr, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *w, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, blasint *ilo, blasint *ihi, float *scale, float *abnrm, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len)
{
    void (*fn) (void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *scale, void *abnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *scale, void *abnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len);
    hook_pos_cgeevx = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeevx;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeevx.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) scale, (void *) abnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
    } else {
        fn((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) scale, (void *) abnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
    }
    #else
    fn((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) scale, (void *) abnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeevx,CGEEVX)(char *balanc, char *jobvl, char *jobvr, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *w, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, blasint *ilo, blasint *ihi, float *scale, float *abnrm, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len) __attribute__((alias(MTS(FC_GLOBAL(cgeevx,CGEEVX)))));
void FC_GLOBAL3(cgeevx,CGEEVX)(char *balanc, char *jobvl, char *jobvr, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *w, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, blasint *ilo, blasint *ihi, float *scale, float *abnrm, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len) __attribute__((alias(MTS(FC_GLOBAL(cgeevx,CGEEVX)))));
#else
void FC_GLOBAL2(cgeevx,CGEEVX)(char *balanc, char *jobvl, char *jobvr, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *w, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, blasint *ilo, blasint *ihi, float *scale, float *abnrm, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len)
{
    FC_GLOBAL(cgeevx,CGEEVX)((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) scale, (void *) abnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
}
void FC_GLOBAL3(cgeevx,CGEEVX)(char *balanc, char *jobvl, char *jobvr, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *w, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, blasint *ilo, blasint *ihi, float *scale, float *abnrm, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len)
{
    FC_GLOBAL(cgeevx,CGEEVX)((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) scale, (void *) abnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeevx_(void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *scale, void *abnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len)
{
    void (*fn) (void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *scale, void *abnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len);
    *(void **) &fn = current_backend->lapack.cgeevx;
    fn((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) scale, (void *) abnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeevx(void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *scale, void *abnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len) __attribute__((alias("flexiblas_real_cgeevx_")));
#else
void flexiblas_real_cgeevx(void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *scale, void *abnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len)
{
    flexiblas_real_cgeevx_((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) scale, (void *) abnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
    return;
}
#endif

void flexiblas_chain_cgeevx_(void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *scale, void *abnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len)
{
    void (*fn) (void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *scale, void *abnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len);
    hook_pos_cgeevx++;
    if ( hook_pos_cgeevx < __flexiblas_hooks->cgeevx.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeevx.hook_function[hook_pos_cgeevx];
    } else {
        hook_pos_cgeevx = 0;
        *(void **) &fn = current_backend->lapack.cgeevx;
    }
    fn((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) scale, (void *) abnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeevx(void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *scale, void *abnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len) __attribute__((alias("flexiblas_chain_cgeevx_")));
#else
void flexiblas_chain_cgeevx(void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *w, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *scale, void *abnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len)
{
    flexiblas_chain_cgeevx_((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) scale, (void *) abnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgehd2 = 0;
#endif

/* Wrapper for cgehd2 */
void FC_GLOBAL(cgehd2,CGEHD2)
    (blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    void (*fn) (void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *info);
    hook_pos_cgehd2 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgehd2;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgehd2.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    } else {
        fn((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    }
    #else
    fn((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgehd2,CGEHD2)(blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgehd2,CGEHD2)))));
void FC_GLOBAL3(cgehd2,CGEHD2)(blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgehd2,CGEHD2)))));
#else
void FC_GLOBAL2(cgehd2,CGEHD2)(blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgehd2,CGEHD2)((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
}
void FC_GLOBAL3(cgehd2,CGEHD2)(blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgehd2,CGEHD2)((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgehd2_(void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *info)
{
    void (*fn) (void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *info);
    *(void **) &fn = current_backend->lapack.cgehd2;
    fn((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgehd2(void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *info) __attribute__((alias("flexiblas_real_cgehd2_")));
#else
void flexiblas_real_cgehd2(void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *info)
{
    flexiblas_real_cgehd2_((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgehd2_(void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *info)
{
    void (*fn) (void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *info);
    hook_pos_cgehd2++;
    if ( hook_pos_cgehd2 < __flexiblas_hooks->cgehd2.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgehd2.hook_function[hook_pos_cgehd2];
    } else {
        hook_pos_cgehd2 = 0;
        *(void **) &fn = current_backend->lapack.cgehd2;
    }
    fn((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgehd2(void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *info) __attribute__((alias("flexiblas_chain_cgehd2_")));
#else
void flexiblas_chain_cgehd2(void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *info)
{
    flexiblas_chain_cgehd2_((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgehrd = 0;
#endif

/* Wrapper for cgehrd */
void FC_GLOBAL(cgehrd,CGEHRD)
    (blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    void (*fn) (void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    hook_pos_cgehrd = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgehrd;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgehrd.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    } else {
        fn((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    }
    #else
    fn((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgehrd,CGEHRD)(blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgehrd,CGEHRD)))));
void FC_GLOBAL3(cgehrd,CGEHRD)(blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgehrd,CGEHRD)))));
#else
void FC_GLOBAL2(cgehrd,CGEHRD)(blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgehrd,CGEHRD)((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
}
void FC_GLOBAL3(cgehrd,CGEHRD)(blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgehrd,CGEHRD)((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgehrd_(void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    void (*fn) (void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    *(void **) &fn = current_backend->lapack.cgehrd;
    fn((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgehrd(void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_real_cgehrd_")));
#else
void flexiblas_real_cgehrd(void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    flexiblas_real_cgehrd_((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgehrd_(void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    void (*fn) (void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    hook_pos_cgehrd++;
    if ( hook_pos_cgehrd < __flexiblas_hooks->cgehrd.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgehrd.hook_function[hook_pos_cgehrd];
    } else {
        hook_pos_cgehrd = 0;
        *(void **) &fn = current_backend->lapack.cgehrd;
    }
    fn((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgehrd(void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_chain_cgehrd_")));
#else
void flexiblas_chain_cgehrd(void *n, void *ilo, void *ihi, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    flexiblas_chain_cgehrd_((void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgejsv = 0;
#endif

/* Wrapper for cgejsv */
void FC_GLOBAL(cgejsv,CGEJSV)
    (char *joba, char *jobu, char *jobv, char *jobr, char *jobt, char *jobp, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *sva, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, lapack_complex_float *cwork, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobp_len)
{
    void (*fn) (void *joba, void *jobu, void *jobv, void *jobr, void *jobt, void *jobp, void *m, void *n, void *a, void *lda, void *sva, void *u, void *ldu, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *iwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobp_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *joba, void *jobu, void *jobv, void *jobr, void *jobt, void *jobp, void *m, void *n, void *a, void *lda, void *sva, void *u, void *ldu, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *iwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobp_len);
    hook_pos_cgejsv = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgejsv;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgejsv.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) joba, (void *) jobu, (void *) jobv, (void *) jobr, (void *) jobt, (void *) jobp, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) info, joba_len, jobu_len, jobv_len, jobr_len, jobt_len, jobp_len);
    } else {
        fn((void *) joba, (void *) jobu, (void *) jobv, (void *) jobr, (void *) jobt, (void *) jobp, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) info, joba_len, jobu_len, jobv_len, jobr_len, jobt_len, jobp_len);
    }
    #else
    fn((void *) joba, (void *) jobu, (void *) jobv, (void *) jobr, (void *) jobt, (void *) jobp, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) info, joba_len, jobu_len, jobv_len, jobr_len, jobt_len, jobp_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgejsv,CGEJSV)(char *joba, char *jobu, char *jobv, char *jobr, char *jobt, char *jobp, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *sva, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, lapack_complex_float *cwork, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobp_len) __attribute__((alias(MTS(FC_GLOBAL(cgejsv,CGEJSV)))));
void FC_GLOBAL3(cgejsv,CGEJSV)(char *joba, char *jobu, char *jobv, char *jobr, char *jobt, char *jobp, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *sva, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, lapack_complex_float *cwork, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobp_len) __attribute__((alias(MTS(FC_GLOBAL(cgejsv,CGEJSV)))));
#else
void FC_GLOBAL2(cgejsv,CGEJSV)(char *joba, char *jobu, char *jobv, char *jobr, char *jobt, char *jobp, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *sva, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, lapack_complex_float *cwork, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobp_len)
{
    FC_GLOBAL(cgejsv,CGEJSV)((void *) joba, (void *) jobu, (void *) jobv, (void *) jobr, (void *) jobt, (void *) jobp, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) info, joba_len, jobu_len, jobv_len, jobr_len, jobt_len, jobp_len);
}
void FC_GLOBAL3(cgejsv,CGEJSV)(char *joba, char *jobu, char *jobv, char *jobr, char *jobt, char *jobp, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *sva, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, lapack_complex_float *cwork, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobp_len)
{
    FC_GLOBAL(cgejsv,CGEJSV)((void *) joba, (void *) jobu, (void *) jobv, (void *) jobr, (void *) jobt, (void *) jobp, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) info, joba_len, jobu_len, jobv_len, jobr_len, jobt_len, jobp_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgejsv_(void *joba, void *jobu, void *jobv, void *jobr, void *jobt, void *jobp, void *m, void *n, void *a, void *lda, void *sva, void *u, void *ldu, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *iwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobp_len)
{
    void (*fn) (void *joba, void *jobu, void *jobv, void *jobr, void *jobt, void *jobp, void *m, void *n, void *a, void *lda, void *sva, void *u, void *ldu, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *iwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobp_len);
    *(void **) &fn = current_backend->lapack.cgejsv;
    fn((void *) joba, (void *) jobu, (void *) jobv, (void *) jobr, (void *) jobt, (void *) jobp, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) info, joba_len, jobu_len, jobv_len, jobr_len, jobt_len, jobp_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgejsv(void *joba, void *jobu, void *jobv, void *jobr, void *jobt, void *jobp, void *m, void *n, void *a, void *lda, void *sva, void *u, void *ldu, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *iwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobp_len) __attribute__((alias("flexiblas_real_cgejsv_")));
#else
void flexiblas_real_cgejsv(void *joba, void *jobu, void *jobv, void *jobr, void *jobt, void *jobp, void *m, void *n, void *a, void *lda, void *sva, void *u, void *ldu, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *iwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobp_len)
{
    flexiblas_real_cgejsv_((void *) joba, (void *) jobu, (void *) jobv, (void *) jobr, (void *) jobt, (void *) jobp, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) info, joba_len, jobu_len, jobv_len, jobr_len, jobt_len, jobp_len);
    return;
}
#endif

void flexiblas_chain_cgejsv_(void *joba, void *jobu, void *jobv, void *jobr, void *jobt, void *jobp, void *m, void *n, void *a, void *lda, void *sva, void *u, void *ldu, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *iwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobp_len)
{
    void (*fn) (void *joba, void *jobu, void *jobv, void *jobr, void *jobt, void *jobp, void *m, void *n, void *a, void *lda, void *sva, void *u, void *ldu, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *iwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobp_len);
    hook_pos_cgejsv++;
    if ( hook_pos_cgejsv < __flexiblas_hooks->cgejsv.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgejsv.hook_function[hook_pos_cgejsv];
    } else {
        hook_pos_cgejsv = 0;
        *(void **) &fn = current_backend->lapack.cgejsv;
    }
    fn((void *) joba, (void *) jobu, (void *) jobv, (void *) jobr, (void *) jobt, (void *) jobp, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) info, joba_len, jobu_len, jobv_len, jobr_len, jobt_len, jobp_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgejsv(void *joba, void *jobu, void *jobv, void *jobr, void *jobt, void *jobp, void *m, void *n, void *a, void *lda, void *sva, void *u, void *ldu, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *iwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobp_len) __attribute__((alias("flexiblas_chain_cgejsv_")));
#else
void flexiblas_chain_cgejsv(void *joba, void *jobu, void *jobv, void *jobr, void *jobt, void *jobp, void *m, void *n, void *a, void *lda, void *sva, void *u, void *ldu, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *iwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobt_len, flexiblas_fortran_charlen_t jobp_len)
{
    flexiblas_chain_cgejsv_((void *) joba, (void *) jobu, (void *) jobv, (void *) jobr, (void *) jobt, (void *) jobp, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) info, joba_len, jobu_len, jobv_len, jobr_len, jobt_len, jobp_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgelq = 0;
#endif

/* Wrapper for cgelq */
void FC_GLOBAL(cgelq,CGELQ)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info);
    hook_pos_cgelq = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgelq;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgelq.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgelq,CGELQ)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgelq,CGELQ)))));
void FC_GLOBAL3(cgelq,CGELQ)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgelq,CGELQ)))));
#else
void FC_GLOBAL2(cgelq,CGELQ)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgelq,CGELQ)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
}
void FC_GLOBAL3(cgelq,CGELQ)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgelq,CGELQ)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgelq_(void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info);
    *(void **) &fn = current_backend->lapack.cgelq;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgelq(void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_real_cgelq_")));
#else
void flexiblas_real_cgelq(void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info)
{
    flexiblas_real_cgelq_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgelq_(void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info);
    hook_pos_cgelq++;
    if ( hook_pos_cgelq < __flexiblas_hooks->cgelq.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgelq.hook_function[hook_pos_cgelq];
    } else {
        hook_pos_cgelq = 0;
        *(void **) &fn = current_backend->lapack.cgelq;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgelq(void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_chain_cgelq_")));
#else
void flexiblas_chain_cgelq(void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info)
{
    flexiblas_chain_cgelq_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgelq2 = 0;
#endif

/* Wrapper for cgelq2 */
void FC_GLOBAL(cgelq2,CGELQ2)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    hook_pos_cgelq2 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgelq2;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgelq2.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgelq2,CGELQ2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgelq2,CGELQ2)))));
void FC_GLOBAL3(cgelq2,CGELQ2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgelq2,CGELQ2)))));
#else
void FC_GLOBAL2(cgelq2,CGELQ2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgelq2,CGELQ2)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
}
void FC_GLOBAL3(cgelq2,CGELQ2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgelq2,CGELQ2)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgelq2_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    *(void **) &fn = current_backend->lapack.cgelq2;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgelq2(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info) __attribute__((alias("flexiblas_real_cgelq2_")));
#else
void flexiblas_real_cgelq2(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    flexiblas_real_cgelq2_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgelq2_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    hook_pos_cgelq2++;
    if ( hook_pos_cgelq2 < __flexiblas_hooks->cgelq2.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgelq2.hook_function[hook_pos_cgelq2];
    } else {
        hook_pos_cgelq2 = 0;
        *(void **) &fn = current_backend->lapack.cgelq2;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgelq2(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info) __attribute__((alias("flexiblas_chain_cgelq2_")));
#else
void flexiblas_chain_cgelq2(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    flexiblas_chain_cgelq2_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgelqf = 0;
#endif

/* Wrapper for cgelqf */
void FC_GLOBAL(cgelqf,CGELQF)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    hook_pos_cgelqf = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgelqf;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgelqf.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgelqf,CGELQF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgelqf,CGELQF)))));
void FC_GLOBAL3(cgelqf,CGELQF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgelqf,CGELQF)))));
#else
void FC_GLOBAL2(cgelqf,CGELQF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgelqf,CGELQF)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
}
void FC_GLOBAL3(cgelqf,CGELQF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgelqf,CGELQF)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgelqf_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    *(void **) &fn = current_backend->lapack.cgelqf;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgelqf(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_real_cgelqf_")));
#else
void flexiblas_real_cgelqf(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    flexiblas_real_cgelqf_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgelqf_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    hook_pos_cgelqf++;
    if ( hook_pos_cgelqf < __flexiblas_hooks->cgelqf.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgelqf.hook_function[hook_pos_cgelqf];
    } else {
        hook_pos_cgelqf = 0;
        *(void **) &fn = current_backend->lapack.cgelqf;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgelqf(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_chain_cgelqf_")));
#else
void flexiblas_chain_cgelqf(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    flexiblas_chain_cgelqf_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgelqt = 0;
#endif

/* Wrapper for cgelqt */
void FC_GLOBAL(cgelqt,CGELQT)
    (blasint *m, blasint *n, blasint *mb, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, lapack_complex_float *work, blasint *info)
{
    void (*fn) (void *m, void *n, void *mb, void *a, void *lda, void *t, void *ldt, void *work, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *mb, void *a, void *lda, void *t, void *ldt, void *work, void *info);
    hook_pos_cgelqt = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgelqt;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgelqt.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) mb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) mb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) mb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgelqt,CGELQT)(blasint *m, blasint *n, blasint *mb, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgelqt,CGELQT)))));
void FC_GLOBAL3(cgelqt,CGELQT)(blasint *m, blasint *n, blasint *mb, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgelqt,CGELQT)))));
#else
void FC_GLOBAL2(cgelqt,CGELQT)(blasint *m, blasint *n, blasint *mb, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgelqt,CGELQT)((void *) m, (void *) n, (void *) mb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
}
void FC_GLOBAL3(cgelqt,CGELQT)(blasint *m, blasint *n, blasint *mb, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgelqt,CGELQT)((void *) m, (void *) n, (void *) mb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgelqt_(void *m, void *n, void *mb, void *a, void *lda, void *t, void *ldt, void *work, void *info)
{
    void (*fn) (void *m, void *n, void *mb, void *a, void *lda, void *t, void *ldt, void *work, void *info);
    *(void **) &fn = current_backend->lapack.cgelqt;
    fn((void *) m, (void *) n, (void *) mb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgelqt(void *m, void *n, void *mb, void *a, void *lda, void *t, void *ldt, void *work, void *info) __attribute__((alias("flexiblas_real_cgelqt_")));
#else
void flexiblas_real_cgelqt(void *m, void *n, void *mb, void *a, void *lda, void *t, void *ldt, void *work, void *info)
{
    flexiblas_real_cgelqt_((void *) m, (void *) n, (void *) mb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgelqt_(void *m, void *n, void *mb, void *a, void *lda, void *t, void *ldt, void *work, void *info)
{
    void (*fn) (void *m, void *n, void *mb, void *a, void *lda, void *t, void *ldt, void *work, void *info);
    hook_pos_cgelqt++;
    if ( hook_pos_cgelqt < __flexiblas_hooks->cgelqt.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgelqt.hook_function[hook_pos_cgelqt];
    } else {
        hook_pos_cgelqt = 0;
        *(void **) &fn = current_backend->lapack.cgelqt;
    }
    fn((void *) m, (void *) n, (void *) mb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgelqt(void *m, void *n, void *mb, void *a, void *lda, void *t, void *ldt, void *work, void *info) __attribute__((alias("flexiblas_chain_cgelqt_")));
#else
void flexiblas_chain_cgelqt(void *m, void *n, void *mb, void *a, void *lda, void *t, void *ldt, void *work, void *info)
{
    flexiblas_chain_cgelqt_((void *) m, (void *) n, (void *) mb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgelqt3 = 0;
#endif

/* Wrapper for cgelqt3 */
void FC_GLOBAL(cgelqt3,CGELQT3)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info);
    hook_pos_cgelqt3 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgelqt3;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgelqt3.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgelqt3,CGELQT3)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgelqt3,CGELQT3)))));
void FC_GLOBAL3(cgelqt3,CGELQT3)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgelqt3,CGELQT3)))));
#else
void FC_GLOBAL2(cgelqt3,CGELQT3)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, blasint *info)
{
    FC_GLOBAL(cgelqt3,CGELQT3)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
}
void FC_GLOBAL3(cgelqt3,CGELQT3)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, blasint *info)
{
    FC_GLOBAL(cgelqt3,CGELQT3)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgelqt3_(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info);
    *(void **) &fn = current_backend->lapack.cgelqt3;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgelqt3(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info) __attribute__((alias("flexiblas_real_cgelqt3_")));
#else
void flexiblas_real_cgelqt3(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info)
{
    flexiblas_real_cgelqt3_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgelqt3_(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info);
    hook_pos_cgelqt3++;
    if ( hook_pos_cgelqt3 < __flexiblas_hooks->cgelqt3.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgelqt3.hook_function[hook_pos_cgelqt3];
    } else {
        hook_pos_cgelqt3 = 0;
        *(void **) &fn = current_backend->lapack.cgelqt3;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgelqt3(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info) __attribute__((alias("flexiblas_chain_cgelqt3_")));
#else
void flexiblas_chain_cgelqt3(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info)
{
    flexiblas_chain_cgelqt3_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgels = 0;
#endif

/* Wrapper for cgels */
void FC_GLOBAL(cgels,CGELS)
    (char *trans, blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgels = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgels;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgels.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    } else {
        fn((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    }
    #else
    fn((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgels,CGELS)(char *trans, blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgels,CGELS)))));
void FC_GLOBAL3(cgels,CGELS)(char *trans, blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgels,CGELS)))));
#else
void FC_GLOBAL2(cgels,CGELS)(char *trans, blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgels,CGELS)((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
}
void FC_GLOBAL3(cgels,CGELS)(char *trans, blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgels,CGELS)((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgels_(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len);
    *(void **) &fn = current_backend->lapack.cgels;
    fn((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgels(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_real_cgels_")));
#else
void flexiblas_real_cgels(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_real_cgels_((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    return;
}
#endif

void flexiblas_chain_cgels_(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgels++;
    if ( hook_pos_cgels < __flexiblas_hooks->cgels.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgels.hook_function[hook_pos_cgels];
    } else {
        hook_pos_cgels = 0;
        *(void **) &fn = current_backend->lapack.cgels;
    }
    fn((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgels(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_chain_cgels_")));
#else
void flexiblas_chain_cgels(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_chain_cgels_((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgelsd = 0;
#endif

/* Wrapper for cgelsd */
void FC_GLOBAL(cgelsd,CGELSD)
    (blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *s, float *rcond, blasint *rank, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info)
{
    void (*fn) (void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *iwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *iwork, void *info);
    hook_pos_cgelsd = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgelsd;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgelsd.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgelsd,CGELSD)(blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *s, float *rcond, blasint *rank, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgelsd,CGELSD)))));
void FC_GLOBAL3(cgelsd,CGELSD)(blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *s, float *rcond, blasint *rank, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgelsd,CGELSD)))));
#else
void FC_GLOBAL2(cgelsd,CGELSD)(blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *s, float *rcond, blasint *rank, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info)
{
    FC_GLOBAL(cgelsd,CGELSD)((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
}
void FC_GLOBAL3(cgelsd,CGELSD)(blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *s, float *rcond, blasint *rank, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info)
{
    FC_GLOBAL(cgelsd,CGELSD)((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgelsd_(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *iwork, void *info)
{
    void (*fn) (void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *iwork, void *info);
    *(void **) &fn = current_backend->lapack.cgelsd;
    fn((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgelsd(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *iwork, void *info) __attribute__((alias("flexiblas_real_cgelsd_")));
#else
void flexiblas_real_cgelsd(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *iwork, void *info)
{
    flexiblas_real_cgelsd_((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgelsd_(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *iwork, void *info)
{
    void (*fn) (void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *iwork, void *info);
    hook_pos_cgelsd++;
    if ( hook_pos_cgelsd < __flexiblas_hooks->cgelsd.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgelsd.hook_function[hook_pos_cgelsd];
    } else {
        hook_pos_cgelsd = 0;
        *(void **) &fn = current_backend->lapack.cgelsd;
    }
    fn((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgelsd(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *iwork, void *info) __attribute__((alias("flexiblas_chain_cgelsd_")));
#else
void flexiblas_chain_cgelsd(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *iwork, void *info)
{
    flexiblas_chain_cgelsd_((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgelss = 0;
#endif

/* Wrapper for cgelss */
void FC_GLOBAL(cgelss,CGELSS)
    (blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *s, float *rcond, blasint *rank, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info)
{
    void (*fn) (void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info);
    hook_pos_cgelss = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgelss;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgelss.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgelss,CGELSS)(blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *s, float *rcond, blasint *rank, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgelss,CGELSS)))));
void FC_GLOBAL3(cgelss,CGELSS)(blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *s, float *rcond, blasint *rank, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgelss,CGELSS)))));
#else
void FC_GLOBAL2(cgelss,CGELSS)(blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *s, float *rcond, blasint *rank, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info)
{
    FC_GLOBAL(cgelss,CGELSS)((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
}
void FC_GLOBAL3(cgelss,CGELSS)(blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *s, float *rcond, blasint *rank, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info)
{
    FC_GLOBAL(cgelss,CGELSS)((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgelss_(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info)
{
    void (*fn) (void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info);
    *(void **) &fn = current_backend->lapack.cgelss;
    fn((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgelss(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info) __attribute__((alias("flexiblas_real_cgelss_")));
#else
void flexiblas_real_cgelss(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info)
{
    flexiblas_real_cgelss_((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgelss_(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info)
{
    void (*fn) (void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info);
    hook_pos_cgelss++;
    if ( hook_pos_cgelss < __flexiblas_hooks->cgelss.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgelss.hook_function[hook_pos_cgelss];
    } else {
        hook_pos_cgelss = 0;
        *(void **) &fn = current_backend->lapack.cgelss;
    }
    fn((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgelss(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info) __attribute__((alias("flexiblas_chain_cgelss_")));
#else
void flexiblas_chain_cgelss(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *s, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info)
{
    flexiblas_chain_cgelss_((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) s, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgelst = 0;
#endif

/* Wrapper for cgelst */
void FC_GLOBAL(cgelst,CGELST)
    (char *trans, blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgelst = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgelst;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgelst.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    } else {
        fn((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    }
    #else
    fn((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgelst,CGELST)(char *trans, blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgelst,CGELST)))));
void FC_GLOBAL3(cgelst,CGELST)(char *trans, blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgelst,CGELST)))));
#else
void FC_GLOBAL2(cgelst,CGELST)(char *trans, blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgelst,CGELST)((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
}
void FC_GLOBAL3(cgelst,CGELST)(char *trans, blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgelst,CGELST)((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgelst_(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len);
    *(void **) &fn = current_backend->lapack.cgelst;
    fn((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgelst(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_real_cgelst_")));
#else
void flexiblas_real_cgelst(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_real_cgelst_((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    return;
}
#endif

void flexiblas_chain_cgelst_(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgelst++;
    if ( hook_pos_cgelst < __flexiblas_hooks->cgelst.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgelst.hook_function[hook_pos_cgelst];
    } else {
        hook_pos_cgelst = 0;
        *(void **) &fn = current_backend->lapack.cgelst;
    }
    fn((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgelst(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_chain_cgelst_")));
#else
void flexiblas_chain_cgelst(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_chain_cgelst_((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgelsy = 0;
#endif

/* Wrapper for cgelsy */
void FC_GLOBAL(cgelsy,CGELSY)
    (blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *jpvt, float *rcond, blasint *rank, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info)
{
    void (*fn) (void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *jpvt, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *jpvt, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info);
    hook_pos_cgelsy = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgelsy;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgelsy.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) jpvt, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) jpvt, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) jpvt, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgelsy,CGELSY)(blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *jpvt, float *rcond, blasint *rank, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgelsy,CGELSY)))));
void FC_GLOBAL3(cgelsy,CGELSY)(blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *jpvt, float *rcond, blasint *rank, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgelsy,CGELSY)))));
#else
void FC_GLOBAL2(cgelsy,CGELSY)(blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *jpvt, float *rcond, blasint *rank, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info)
{
    FC_GLOBAL(cgelsy,CGELSY)((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) jpvt, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
}
void FC_GLOBAL3(cgelsy,CGELSY)(blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *jpvt, float *rcond, blasint *rank, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info)
{
    FC_GLOBAL(cgelsy,CGELSY)((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) jpvt, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgelsy_(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *jpvt, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info)
{
    void (*fn) (void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *jpvt, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info);
    *(void **) &fn = current_backend->lapack.cgelsy;
    fn((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) jpvt, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgelsy(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *jpvt, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info) __attribute__((alias("flexiblas_real_cgelsy_")));
#else
void flexiblas_real_cgelsy(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *jpvt, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info)
{
    flexiblas_real_cgelsy_((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) jpvt, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgelsy_(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *jpvt, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info)
{
    void (*fn) (void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *jpvt, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info);
    hook_pos_cgelsy++;
    if ( hook_pos_cgelsy < __flexiblas_hooks->cgelsy.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgelsy.hook_function[hook_pos_cgelsy];
    } else {
        hook_pos_cgelsy = 0;
        *(void **) &fn = current_backend->lapack.cgelsy;
    }
    fn((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) jpvt, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgelsy(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *jpvt, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info) __attribute__((alias("flexiblas_chain_cgelsy_")));
#else
void flexiblas_chain_cgelsy(void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *jpvt, void *rcond, void *rank, void *work, void *lwork, void *rwork, void *info)
{
    flexiblas_chain_cgelsy_((void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) jpvt, (void *) rcond, (void *) rank, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgemlq = 0;
#endif

/* Wrapper for cgemlq */
void FC_GLOBAL(cgemlq,CGEMLQ)
    (char *side, char *trans, blasint *m, blasint *n, blasint *k, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgemlq = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgemlq;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgemlq.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
    } else {
        fn((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
    }
    #else
    fn((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgemlq,CGEMLQ)(char *side, char *trans, blasint *m, blasint *n, blasint *k, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgemlq,CGEMLQ)))));
void FC_GLOBAL3(cgemlq,CGEMLQ)(char *side, char *trans, blasint *m, blasint *n, blasint *k, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgemlq,CGEMLQ)))));
#else
void FC_GLOBAL2(cgemlq,CGEMLQ)(char *side, char *trans, blasint *m, blasint *n, blasint *k, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgemlq,CGEMLQ)((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
}
void FC_GLOBAL3(cgemlq,CGEMLQ)(char *side, char *trans, blasint *m, blasint *n, blasint *k, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgemlq,CGEMLQ)((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgemlq_(void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len);
    *(void **) &fn = current_backend->lapack.cgemlq;
    fn((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgemlq(void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_real_cgemlq_")));
#else
void flexiblas_real_cgemlq(void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_real_cgemlq_((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
    return;
}
#endif

void flexiblas_chain_cgemlq_(void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgemlq++;
    if ( hook_pos_cgemlq < __flexiblas_hooks->cgemlq.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgemlq.hook_function[hook_pos_cgemlq];
    } else {
        hook_pos_cgemlq = 0;
        *(void **) &fn = current_backend->lapack.cgemlq;
    }
    fn((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgemlq(void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_chain_cgemlq_")));
#else
void flexiblas_chain_cgemlq(void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_chain_cgemlq_((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgemlqt = 0;
#endif

/* Wrapper for cgemlqt */
void FC_GLOBAL(cgemlqt,CGEMLQT)
    (char *side, char *trans, blasint *m, blasint *n, blasint *k, blasint *mb, lapack_complex_float *v, blasint *ldv, lapack_complex_float *t, blasint *ldt, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *side, void *trans, void *m, void *n, void *k, void *mb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *side, void *trans, void *m, void *n, void *k, void *mb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgemlqt = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgemlqt;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgemlqt.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) mb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
    } else {
        fn((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) mb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
    }
    #else
    fn((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) mb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgemlqt,CGEMLQT)(char *side, char *trans, blasint *m, blasint *n, blasint *k, blasint *mb, lapack_complex_float *v, blasint *ldv, lapack_complex_float *t, blasint *ldt, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgemlqt,CGEMLQT)))));
void FC_GLOBAL3(cgemlqt,CGEMLQT)(char *side, char *trans, blasint *m, blasint *n, blasint *k, blasint *mb, lapack_complex_float *v, blasint *ldv, lapack_complex_float *t, blasint *ldt, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgemlqt,CGEMLQT)))));
#else
void FC_GLOBAL2(cgemlqt,CGEMLQT)(char *side, char *trans, blasint *m, blasint *n, blasint *k, blasint *mb, lapack_complex_float *v, blasint *ldv, lapack_complex_float *t, blasint *ldt, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgemlqt,CGEMLQT)((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) mb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
}
void FC_GLOBAL3(cgemlqt,CGEMLQT)(char *side, char *trans, blasint *m, blasint *n, blasint *k, blasint *mb, lapack_complex_float *v, blasint *ldv, lapack_complex_float *t, blasint *ldt, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgemlqt,CGEMLQT)((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) mb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgemlqt_(void *side, void *trans, void *m, void *n, void *k, void *mb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *side, void *trans, void *m, void *n, void *k, void *mb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len);
    *(void **) &fn = current_backend->lapack.cgemlqt;
    fn((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) mb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgemlqt(void *side, void *trans, void *m, void *n, void *k, void *mb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_real_cgemlqt_")));
#else
void flexiblas_real_cgemlqt(void *side, void *trans, void *m, void *n, void *k, void *mb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_real_cgemlqt_((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) mb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
    return;
}
#endif

void flexiblas_chain_cgemlqt_(void *side, void *trans, void *m, void *n, void *k, void *mb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *side, void *trans, void *m, void *n, void *k, void *mb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgemlqt++;
    if ( hook_pos_cgemlqt < __flexiblas_hooks->cgemlqt.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgemlqt.hook_function[hook_pos_cgemlqt];
    } else {
        hook_pos_cgemlqt = 0;
        *(void **) &fn = current_backend->lapack.cgemlqt;
    }
    fn((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) mb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgemlqt(void *side, void *trans, void *m, void *n, void *k, void *mb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_chain_cgemlqt_")));
#else
void flexiblas_chain_cgemlqt(void *side, void *trans, void *m, void *n, void *k, void *mb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_chain_cgemlqt_((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) mb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgemqr = 0;
#endif

/* Wrapper for cgemqr */
void FC_GLOBAL(cgemqr,CGEMQR)
    (char *side, char *trans, blasint *m, blasint *n, blasint *k, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgemqr = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgemqr;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgemqr.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
    } else {
        fn((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
    }
    #else
    fn((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgemqr,CGEMQR)(char *side, char *trans, blasint *m, blasint *n, blasint *k, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgemqr,CGEMQR)))));
void FC_GLOBAL3(cgemqr,CGEMQR)(char *side, char *trans, blasint *m, blasint *n, blasint *k, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgemqr,CGEMQR)))));
#else
void FC_GLOBAL2(cgemqr,CGEMQR)(char *side, char *trans, blasint *m, blasint *n, blasint *k, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgemqr,CGEMQR)((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
}
void FC_GLOBAL3(cgemqr,CGEMQR)(char *side, char *trans, blasint *m, blasint *n, blasint *k, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgemqr,CGEMQR)((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgemqr_(void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len);
    *(void **) &fn = current_backend->lapack.cgemqr;
    fn((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgemqr(void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_real_cgemqr_")));
#else
void flexiblas_real_cgemqr(void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_real_cgemqr_((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
    return;
}
#endif

void flexiblas_chain_cgemqr_(void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgemqr++;
    if ( hook_pos_cgemqr < __flexiblas_hooks->cgemqr.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgemqr.hook_function[hook_pos_cgemqr];
    } else {
        hook_pos_cgemqr = 0;
        *(void **) &fn = current_backend->lapack.cgemqr;
    }
    fn((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgemqr(void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_chain_cgemqr_")));
#else
void flexiblas_chain_cgemqr(void *side, void *trans, void *m, void *n, void *k, void *a, void *lda, void *t, void *tsize, void *c, void *ldc, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_chain_cgemqr_((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) c, (void *) ldc, (void *) work, (void *) lwork, (void *) info, side_len, trans_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgemqrt = 0;
#endif

/* Wrapper for cgemqrt */
void FC_GLOBAL(cgemqrt,CGEMQRT)
    (char *side, char *trans, blasint *m, blasint *n, blasint *k, blasint *nb, lapack_complex_float *v, blasint *ldv, lapack_complex_float *t, blasint *ldt, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *side, void *trans, void *m, void *n, void *k, void *nb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *side, void *trans, void *m, void *n, void *k, void *nb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgemqrt = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgemqrt;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgemqrt.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) nb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
    } else {
        fn((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) nb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
    }
    #else
    fn((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) nb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgemqrt,CGEMQRT)(char *side, char *trans, blasint *m, blasint *n, blasint *k, blasint *nb, lapack_complex_float *v, blasint *ldv, lapack_complex_float *t, blasint *ldt, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgemqrt,CGEMQRT)))));
void FC_GLOBAL3(cgemqrt,CGEMQRT)(char *side, char *trans, blasint *m, blasint *n, blasint *k, blasint *nb, lapack_complex_float *v, blasint *ldv, lapack_complex_float *t, blasint *ldt, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgemqrt,CGEMQRT)))));
#else
void FC_GLOBAL2(cgemqrt,CGEMQRT)(char *side, char *trans, blasint *m, blasint *n, blasint *k, blasint *nb, lapack_complex_float *v, blasint *ldv, lapack_complex_float *t, blasint *ldt, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgemqrt,CGEMQRT)((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) nb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
}
void FC_GLOBAL3(cgemqrt,CGEMQRT)(char *side, char *trans, blasint *m, blasint *n, blasint *k, blasint *nb, lapack_complex_float *v, blasint *ldv, lapack_complex_float *t, blasint *ldt, lapack_complex_float *c, blasint *ldc, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgemqrt,CGEMQRT)((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) nb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgemqrt_(void *side, void *trans, void *m, void *n, void *k, void *nb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *side, void *trans, void *m, void *n, void *k, void *nb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len);
    *(void **) &fn = current_backend->lapack.cgemqrt;
    fn((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) nb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgemqrt(void *side, void *trans, void *m, void *n, void *k, void *nb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_real_cgemqrt_")));
#else
void flexiblas_real_cgemqrt(void *side, void *trans, void *m, void *n, void *k, void *nb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_real_cgemqrt_((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) nb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
    return;
}
#endif

void flexiblas_chain_cgemqrt_(void *side, void *trans, void *m, void *n, void *k, void *nb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *side, void *trans, void *m, void *n, void *k, void *nb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgemqrt++;
    if ( hook_pos_cgemqrt < __flexiblas_hooks->cgemqrt.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgemqrt.hook_function[hook_pos_cgemqrt];
    } else {
        hook_pos_cgemqrt = 0;
        *(void **) &fn = current_backend->lapack.cgemqrt;
    }
    fn((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) nb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgemqrt(void *side, void *trans, void *m, void *n, void *k, void *nb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_chain_cgemqrt_")));
#else
void flexiblas_chain_cgemqrt(void *side, void *trans, void *m, void *n, void *k, void *nb, void *v, void *ldv, void *t, void *ldt, void *c, void *ldc, void *work, void *info, flexiblas_fortran_charlen_t side_len, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_chain_cgemqrt_((void *) side, (void *) trans, (void *) m, (void *) n, (void *) k, (void *) nb, (void *) v, (void *) ldv, (void *) t, (void *) ldt, (void *) c, (void *) ldc, (void *) work, (void *) info, side_len, trans_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeql2 = 0;
#endif

/* Wrapper for cgeql2 */
void FC_GLOBAL(cgeql2,CGEQL2)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    hook_pos_cgeql2 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeql2;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeql2.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeql2,CGEQL2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeql2,CGEQL2)))));
void FC_GLOBAL3(cgeql2,CGEQL2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeql2,CGEQL2)))));
#else
void FC_GLOBAL2(cgeql2,CGEQL2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgeql2,CGEQL2)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
}
void FC_GLOBAL3(cgeql2,CGEQL2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgeql2,CGEQL2)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeql2_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    *(void **) &fn = current_backend->lapack.cgeql2;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeql2(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info) __attribute__((alias("flexiblas_real_cgeql2_")));
#else
void flexiblas_real_cgeql2(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    flexiblas_real_cgeql2_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgeql2_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    hook_pos_cgeql2++;
    if ( hook_pos_cgeql2 < __flexiblas_hooks->cgeql2.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeql2.hook_function[hook_pos_cgeql2];
    } else {
        hook_pos_cgeql2 = 0;
        *(void **) &fn = current_backend->lapack.cgeql2;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeql2(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info) __attribute__((alias("flexiblas_chain_cgeql2_")));
#else
void flexiblas_chain_cgeql2(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    flexiblas_chain_cgeql2_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeqlf = 0;
#endif

/* Wrapper for cgeqlf */
void FC_GLOBAL(cgeqlf,CGEQLF)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    hook_pos_cgeqlf = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeqlf;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeqlf.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeqlf,CGEQLF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqlf,CGEQLF)))));
void FC_GLOBAL3(cgeqlf,CGEQLF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqlf,CGEQLF)))));
#else
void FC_GLOBAL2(cgeqlf,CGEQLF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgeqlf,CGEQLF)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
}
void FC_GLOBAL3(cgeqlf,CGEQLF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgeqlf,CGEQLF)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeqlf_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    *(void **) &fn = current_backend->lapack.cgeqlf;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeqlf(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_real_cgeqlf_")));
#else
void flexiblas_real_cgeqlf(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    flexiblas_real_cgeqlf_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgeqlf_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    hook_pos_cgeqlf++;
    if ( hook_pos_cgeqlf < __flexiblas_hooks->cgeqlf.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeqlf.hook_function[hook_pos_cgeqlf];
    } else {
        hook_pos_cgeqlf = 0;
        *(void **) &fn = current_backend->lapack.cgeqlf;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeqlf(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_chain_cgeqlf_")));
#else
void flexiblas_chain_cgeqlf(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    flexiblas_chain_cgeqlf_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeqp3 = 0;
#endif

/* Wrapper for cgeqp3 */
void FC_GLOBAL(cgeqp3,CGEQP3)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *jpvt, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *jpvt, void *tau, void *work, void *lwork, void *rwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *jpvt, void *tau, void *work, void *lwork, void *rwork, void *info);
    hook_pos_cgeqp3 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeqp3;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeqp3.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) jpvt, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) jpvt, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) jpvt, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeqp3,CGEQP3)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *jpvt, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqp3,CGEQP3)))));
void FC_GLOBAL3(cgeqp3,CGEQP3)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *jpvt, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqp3,CGEQP3)))));
#else
void FC_GLOBAL2(cgeqp3,CGEQP3)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *jpvt, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info)
{
    FC_GLOBAL(cgeqp3,CGEQP3)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) jpvt, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
}
void FC_GLOBAL3(cgeqp3,CGEQP3)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *jpvt, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info)
{
    FC_GLOBAL(cgeqp3,CGEQP3)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) jpvt, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeqp3_(void *m, void *n, void *a, void *lda, void *jpvt, void *tau, void *work, void *lwork, void *rwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *jpvt, void *tau, void *work, void *lwork, void *rwork, void *info);
    *(void **) &fn = current_backend->lapack.cgeqp3;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) jpvt, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeqp3(void *m, void *n, void *a, void *lda, void *jpvt, void *tau, void *work, void *lwork, void *rwork, void *info) __attribute__((alias("flexiblas_real_cgeqp3_")));
#else
void flexiblas_real_cgeqp3(void *m, void *n, void *a, void *lda, void *jpvt, void *tau, void *work, void *lwork, void *rwork, void *info)
{
    flexiblas_real_cgeqp3_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) jpvt, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgeqp3_(void *m, void *n, void *a, void *lda, void *jpvt, void *tau, void *work, void *lwork, void *rwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *jpvt, void *tau, void *work, void *lwork, void *rwork, void *info);
    hook_pos_cgeqp3++;
    if ( hook_pos_cgeqp3 < __flexiblas_hooks->cgeqp3.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeqp3.hook_function[hook_pos_cgeqp3];
    } else {
        hook_pos_cgeqp3 = 0;
        *(void **) &fn = current_backend->lapack.cgeqp3;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) jpvt, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeqp3(void *m, void *n, void *a, void *lda, void *jpvt, void *tau, void *work, void *lwork, void *rwork, void *info) __attribute__((alias("flexiblas_chain_cgeqp3_")));
#else
void flexiblas_chain_cgeqp3(void *m, void *n, void *a, void *lda, void *jpvt, void *tau, void *work, void *lwork, void *rwork, void *info)
{
    flexiblas_chain_cgeqp3_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) jpvt, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeqp3rk = 0;
#endif

/* Wrapper for cgeqp3rk */
void FC_GLOBAL(cgeqp3rk,CGEQP3RK)
    (blasint *m, blasint *n, blasint *nrhs, blasint *kmax, float *abstol, float *reltol, lapack_complex_float *a, blasint *lda, blasint *k, float *maxc2nrmk, float *relmaxc2nrmk, blasint *jpiv, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info)
{
    void (*fn) (void *m, void *n, void *nrhs, void *kmax, void *abstol, void *reltol, void *a, void *lda, void *k, void *maxc2nrmk, void *relmaxc2nrmk, void *jpiv, void *tau, void *work, void *lwork, void *rwork, void *iwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *nrhs, void *kmax, void *abstol, void *reltol, void *a, void *lda, void *k, void *maxc2nrmk, void *relmaxc2nrmk, void *jpiv, void *tau, void *work, void *lwork, void *rwork, void *iwork, void *info);
    hook_pos_cgeqp3rk = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeqp3rk;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeqp3rk.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) nrhs, (void *) kmax, (void *) abstol, (void *) reltol, (void *) a, (void *) lda, (void *) k, (void *) maxc2nrmk, (void *) relmaxc2nrmk, (void *) jpiv, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) nrhs, (void *) kmax, (void *) abstol, (void *) reltol, (void *) a, (void *) lda, (void *) k, (void *) maxc2nrmk, (void *) relmaxc2nrmk, (void *) jpiv, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) nrhs, (void *) kmax, (void *) abstol, (void *) reltol, (void *) a, (void *) lda, (void *) k, (void *) maxc2nrmk, (void *) relmaxc2nrmk, (void *) jpiv, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeqp3rk,CGEQP3RK)(blasint *m, blasint *n, blasint *nrhs, blasint *kmax, float *abstol, float *reltol, lapack_complex_float *a, blasint *lda, blasint *k, float *maxc2nrmk, float *relmaxc2nrmk, blasint *jpiv, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqp3rk,CGEQP3RK)))));
void FC_GLOBAL3(cgeqp3rk,CGEQP3RK)(blasint *m, blasint *n, blasint *nrhs, blasint *kmax, float *abstol, float *reltol, lapack_complex_float *a, blasint *lda, blasint *k, float *maxc2nrmk, float *relmaxc2nrmk, blasint *jpiv, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqp3rk,CGEQP3RK)))));
#else
void FC_GLOBAL2(cgeqp3rk,CGEQP3RK)(blasint *m, blasint *n, blasint *nrhs, blasint *kmax, float *abstol, float *reltol, lapack_complex_float *a, blasint *lda, blasint *k, float *maxc2nrmk, float *relmaxc2nrmk, blasint *jpiv, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info)
{
    FC_GLOBAL(cgeqp3rk,CGEQP3RK)((void *) m, (void *) n, (void *) nrhs, (void *) kmax, (void *) abstol, (void *) reltol, (void *) a, (void *) lda, (void *) k, (void *) maxc2nrmk, (void *) relmaxc2nrmk, (void *) jpiv, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
}
void FC_GLOBAL3(cgeqp3rk,CGEQP3RK)(blasint *m, blasint *n, blasint *nrhs, blasint *kmax, float *abstol, float *reltol, lapack_complex_float *a, blasint *lda, blasint *k, float *maxc2nrmk, float *relmaxc2nrmk, blasint *jpiv, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info)
{
    FC_GLOBAL(cgeqp3rk,CGEQP3RK)((void *) m, (void *) n, (void *) nrhs, (void *) kmax, (void *) abstol, (void *) reltol, (void *) a, (void *) lda, (void *) k, (void *) maxc2nrmk, (void *) relmaxc2nrmk, (void *) jpiv, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeqp3rk_(void *m, void *n, void *nrhs, void *kmax, void *abstol, void *reltol, void *a, void *lda, void *k, void *maxc2nrmk, void *relmaxc2nrmk, void *jpiv, void *tau, void *work, void *lwork, void *rwork, void *iwork, void *info)
{
    void (*fn) (void *m, void *n, void *nrhs, void *kmax, void *abstol, void *reltol, void *a, void *lda, void *k, void *maxc2nrmk, void *relmaxc2nrmk, void *jpiv, void *tau, void *work, void *lwork, void *rwork, void *iwork, void *info);
    *(void **) &fn = current_backend->lapack.cgeqp3rk;
    fn((void *) m, (void *) n, (void *) nrhs, (void *) kmax, (void *) abstol, (void *) reltol, (void *) a, (void *) lda, (void *) k, (void *) maxc2nrmk, (void *) relmaxc2nrmk, (void *) jpiv, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeqp3rk(void *m, void *n, void *nrhs, void *kmax, void *abstol, void *reltol, void *a, void *lda, void *k, void *maxc2nrmk, void *relmaxc2nrmk, void *jpiv, void *tau, void *work, void *lwork, void *rwork, void *iwork, void *info) __attribute__((alias("flexiblas_real_cgeqp3rk_")));
#else
void flexiblas_real_cgeqp3rk(void *m, void *n, void *nrhs, void *kmax, void *abstol, void *reltol, void *a, void *lda, void *k, void *maxc2nrmk, void *relmaxc2nrmk, void *jpiv, void *tau, void *work, void *lwork, void *rwork, void *iwork, void *info)
{
    flexiblas_real_cgeqp3rk_((void *) m, (void *) n, (void *) nrhs, (void *) kmax, (void *) abstol, (void *) reltol, (void *) a, (void *) lda, (void *) k, (void *) maxc2nrmk, (void *) relmaxc2nrmk, (void *) jpiv, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgeqp3rk_(void *m, void *n, void *nrhs, void *kmax, void *abstol, void *reltol, void *a, void *lda, void *k, void *maxc2nrmk, void *relmaxc2nrmk, void *jpiv, void *tau, void *work, void *lwork, void *rwork, void *iwork, void *info)
{
    void (*fn) (void *m, void *n, void *nrhs, void *kmax, void *abstol, void *reltol, void *a, void *lda, void *k, void *maxc2nrmk, void *relmaxc2nrmk, void *jpiv, void *tau, void *work, void *lwork, void *rwork, void *iwork, void *info);
    hook_pos_cgeqp3rk++;
    if ( hook_pos_cgeqp3rk < __flexiblas_hooks->cgeqp3rk.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeqp3rk.hook_function[hook_pos_cgeqp3rk];
    } else {
        hook_pos_cgeqp3rk = 0;
        *(void **) &fn = current_backend->lapack.cgeqp3rk;
    }
    fn((void *) m, (void *) n, (void *) nrhs, (void *) kmax, (void *) abstol, (void *) reltol, (void *) a, (void *) lda, (void *) k, (void *) maxc2nrmk, (void *) relmaxc2nrmk, (void *) jpiv, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeqp3rk(void *m, void *n, void *nrhs, void *kmax, void *abstol, void *reltol, void *a, void *lda, void *k, void *maxc2nrmk, void *relmaxc2nrmk, void *jpiv, void *tau, void *work, void *lwork, void *rwork, void *iwork, void *info) __attribute__((alias("flexiblas_chain_cgeqp3rk_")));
#else
void flexiblas_chain_cgeqp3rk(void *m, void *n, void *nrhs, void *kmax, void *abstol, void *reltol, void *a, void *lda, void *k, void *maxc2nrmk, void *relmaxc2nrmk, void *jpiv, void *tau, void *work, void *lwork, void *rwork, void *iwork, void *info)
{
    flexiblas_chain_cgeqp3rk_((void *) m, (void *) n, (void *) nrhs, (void *) kmax, (void *) abstol, (void *) reltol, (void *) a, (void *) lda, (void *) k, (void *) maxc2nrmk, (void *) relmaxc2nrmk, (void *) jpiv, (void *) tau, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeqr = 0;
#endif

/* Wrapper for cgeqr */
void FC_GLOBAL(cgeqr,CGEQR)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info);
    hook_pos_cgeqr = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeqr;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeqr.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeqr,CGEQR)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqr,CGEQR)))));
void FC_GLOBAL3(cgeqr,CGEQR)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqr,CGEQR)))));
#else
void FC_GLOBAL2(cgeqr,CGEQR)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgeqr,CGEQR)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
}
void FC_GLOBAL3(cgeqr,CGEQR)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *tsize, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgeqr,CGEQR)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeqr_(void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info);
    *(void **) &fn = current_backend->lapack.cgeqr;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeqr(void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_real_cgeqr_")));
#else
void flexiblas_real_cgeqr(void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info)
{
    flexiblas_real_cgeqr_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgeqr_(void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info);
    hook_pos_cgeqr++;
    if ( hook_pos_cgeqr < __flexiblas_hooks->cgeqr.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeqr.hook_function[hook_pos_cgeqr];
    } else {
        hook_pos_cgeqr = 0;
        *(void **) &fn = current_backend->lapack.cgeqr;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeqr(void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_chain_cgeqr_")));
#else
void flexiblas_chain_cgeqr(void *m, void *n, void *a, void *lda, void *t, void *tsize, void *work, void *lwork, void *info)
{
    flexiblas_chain_cgeqr_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) tsize, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeqr2 = 0;
#endif

/* Wrapper for cgeqr2 */
void FC_GLOBAL(cgeqr2,CGEQR2)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    hook_pos_cgeqr2 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeqr2;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeqr2.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeqr2,CGEQR2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqr2,CGEQR2)))));
void FC_GLOBAL3(cgeqr2,CGEQR2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqr2,CGEQR2)))));
#else
void FC_GLOBAL2(cgeqr2,CGEQR2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgeqr2,CGEQR2)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
}
void FC_GLOBAL3(cgeqr2,CGEQR2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgeqr2,CGEQR2)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeqr2_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    *(void **) &fn = current_backend->lapack.cgeqr2;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeqr2(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info) __attribute__((alias("flexiblas_real_cgeqr2_")));
#else
void flexiblas_real_cgeqr2(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    flexiblas_real_cgeqr2_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgeqr2_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    hook_pos_cgeqr2++;
    if ( hook_pos_cgeqr2 < __flexiblas_hooks->cgeqr2.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeqr2.hook_function[hook_pos_cgeqr2];
    } else {
        hook_pos_cgeqr2 = 0;
        *(void **) &fn = current_backend->lapack.cgeqr2;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeqr2(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info) __attribute__((alias("flexiblas_chain_cgeqr2_")));
#else
void flexiblas_chain_cgeqr2(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    flexiblas_chain_cgeqr2_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeqr2p = 0;
#endif

/* Wrapper for cgeqr2p */
void FC_GLOBAL(cgeqr2p,CGEQR2P)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    hook_pos_cgeqr2p = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeqr2p;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeqr2p.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeqr2p,CGEQR2P)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqr2p,CGEQR2P)))));
void FC_GLOBAL3(cgeqr2p,CGEQR2P)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqr2p,CGEQR2P)))));
#else
void FC_GLOBAL2(cgeqr2p,CGEQR2P)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgeqr2p,CGEQR2P)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
}
void FC_GLOBAL3(cgeqr2p,CGEQR2P)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgeqr2p,CGEQR2P)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeqr2p_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    *(void **) &fn = current_backend->lapack.cgeqr2p;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeqr2p(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info) __attribute__((alias("flexiblas_real_cgeqr2p_")));
#else
void flexiblas_real_cgeqr2p(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    flexiblas_real_cgeqr2p_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgeqr2p_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    hook_pos_cgeqr2p++;
    if ( hook_pos_cgeqr2p < __flexiblas_hooks->cgeqr2p.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeqr2p.hook_function[hook_pos_cgeqr2p];
    } else {
        hook_pos_cgeqr2p = 0;
        *(void **) &fn = current_backend->lapack.cgeqr2p;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeqr2p(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info) __attribute__((alias("flexiblas_chain_cgeqr2p_")));
#else
void flexiblas_chain_cgeqr2p(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    flexiblas_chain_cgeqr2p_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeqrf = 0;
#endif

/* Wrapper for cgeqrf */
void FC_GLOBAL(cgeqrf,CGEQRF)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    hook_pos_cgeqrf = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeqrf;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeqrf.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeqrf,CGEQRF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqrf,CGEQRF)))));
void FC_GLOBAL3(cgeqrf,CGEQRF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqrf,CGEQRF)))));
#else
void FC_GLOBAL2(cgeqrf,CGEQRF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgeqrf,CGEQRF)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
}
void FC_GLOBAL3(cgeqrf,CGEQRF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgeqrf,CGEQRF)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeqrf_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    *(void **) &fn = current_backend->lapack.cgeqrf;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeqrf(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_real_cgeqrf_")));
#else
void flexiblas_real_cgeqrf(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    flexiblas_real_cgeqrf_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgeqrf_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    hook_pos_cgeqrf++;
    if ( hook_pos_cgeqrf < __flexiblas_hooks->cgeqrf.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeqrf.hook_function[hook_pos_cgeqrf];
    } else {
        hook_pos_cgeqrf = 0;
        *(void **) &fn = current_backend->lapack.cgeqrf;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeqrf(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_chain_cgeqrf_")));
#else
void flexiblas_chain_cgeqrf(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    flexiblas_chain_cgeqrf_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeqrfp = 0;
#endif

/* Wrapper for cgeqrfp */
void FC_GLOBAL(cgeqrfp,CGEQRFP)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    hook_pos_cgeqrfp = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeqrfp;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeqrfp.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeqrfp,CGEQRFP)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqrfp,CGEQRFP)))));
void FC_GLOBAL3(cgeqrfp,CGEQRFP)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqrfp,CGEQRFP)))));
#else
void FC_GLOBAL2(cgeqrfp,CGEQRFP)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgeqrfp,CGEQRFP)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
}
void FC_GLOBAL3(cgeqrfp,CGEQRFP)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgeqrfp,CGEQRFP)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeqrfp_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    *(void **) &fn = current_backend->lapack.cgeqrfp;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeqrfp(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_real_cgeqrfp_")));
#else
void flexiblas_real_cgeqrfp(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    flexiblas_real_cgeqrfp_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgeqrfp_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    hook_pos_cgeqrfp++;
    if ( hook_pos_cgeqrfp < __flexiblas_hooks->cgeqrfp.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeqrfp.hook_function[hook_pos_cgeqrfp];
    } else {
        hook_pos_cgeqrfp = 0;
        *(void **) &fn = current_backend->lapack.cgeqrfp;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeqrfp(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_chain_cgeqrfp_")));
#else
void flexiblas_chain_cgeqrfp(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    flexiblas_chain_cgeqrfp_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeqrt = 0;
#endif

/* Wrapper for cgeqrt */
void FC_GLOBAL(cgeqrt,CGEQRT)
    (blasint *m, blasint *n, blasint *nb, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, lapack_complex_float *work, blasint *info)
{
    void (*fn) (void *m, void *n, void *nb, void *a, void *lda, void *t, void *ldt, void *work, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *nb, void *a, void *lda, void *t, void *ldt, void *work, void *info);
    hook_pos_cgeqrt = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeqrt;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeqrt.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) nb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) nb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) nb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeqrt,CGEQRT)(blasint *m, blasint *n, blasint *nb, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqrt,CGEQRT)))));
void FC_GLOBAL3(cgeqrt,CGEQRT)(blasint *m, blasint *n, blasint *nb, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqrt,CGEQRT)))));
#else
void FC_GLOBAL2(cgeqrt,CGEQRT)(blasint *m, blasint *n, blasint *nb, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgeqrt,CGEQRT)((void *) m, (void *) n, (void *) nb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
}
void FC_GLOBAL3(cgeqrt,CGEQRT)(blasint *m, blasint *n, blasint *nb, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgeqrt,CGEQRT)((void *) m, (void *) n, (void *) nb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeqrt_(void *m, void *n, void *nb, void *a, void *lda, void *t, void *ldt, void *work, void *info)
{
    void (*fn) (void *m, void *n, void *nb, void *a, void *lda, void *t, void *ldt, void *work, void *info);
    *(void **) &fn = current_backend->lapack.cgeqrt;
    fn((void *) m, (void *) n, (void *) nb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeqrt(void *m, void *n, void *nb, void *a, void *lda, void *t, void *ldt, void *work, void *info) __attribute__((alias("flexiblas_real_cgeqrt_")));
#else
void flexiblas_real_cgeqrt(void *m, void *n, void *nb, void *a, void *lda, void *t, void *ldt, void *work, void *info)
{
    flexiblas_real_cgeqrt_((void *) m, (void *) n, (void *) nb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgeqrt_(void *m, void *n, void *nb, void *a, void *lda, void *t, void *ldt, void *work, void *info)
{
    void (*fn) (void *m, void *n, void *nb, void *a, void *lda, void *t, void *ldt, void *work, void *info);
    hook_pos_cgeqrt++;
    if ( hook_pos_cgeqrt < __flexiblas_hooks->cgeqrt.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeqrt.hook_function[hook_pos_cgeqrt];
    } else {
        hook_pos_cgeqrt = 0;
        *(void **) &fn = current_backend->lapack.cgeqrt;
    }
    fn((void *) m, (void *) n, (void *) nb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeqrt(void *m, void *n, void *nb, void *a, void *lda, void *t, void *ldt, void *work, void *info) __attribute__((alias("flexiblas_chain_cgeqrt_")));
#else
void flexiblas_chain_cgeqrt(void *m, void *n, void *nb, void *a, void *lda, void *t, void *ldt, void *work, void *info)
{
    flexiblas_chain_cgeqrt_((void *) m, (void *) n, (void *) nb, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeqrt2 = 0;
#endif

/* Wrapper for cgeqrt2 */
void FC_GLOBAL(cgeqrt2,CGEQRT2)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info);
    hook_pos_cgeqrt2 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeqrt2;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeqrt2.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeqrt2,CGEQRT2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqrt2,CGEQRT2)))));
void FC_GLOBAL3(cgeqrt2,CGEQRT2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqrt2,CGEQRT2)))));
#else
void FC_GLOBAL2(cgeqrt2,CGEQRT2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, blasint *info)
{
    FC_GLOBAL(cgeqrt2,CGEQRT2)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
}
void FC_GLOBAL3(cgeqrt2,CGEQRT2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, blasint *info)
{
    FC_GLOBAL(cgeqrt2,CGEQRT2)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeqrt2_(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info);
    *(void **) &fn = current_backend->lapack.cgeqrt2;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeqrt2(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info) __attribute__((alias("flexiblas_real_cgeqrt2_")));
#else
void flexiblas_real_cgeqrt2(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info)
{
    flexiblas_real_cgeqrt2_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgeqrt2_(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info);
    hook_pos_cgeqrt2++;
    if ( hook_pos_cgeqrt2 < __flexiblas_hooks->cgeqrt2.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeqrt2.hook_function[hook_pos_cgeqrt2];
    } else {
        hook_pos_cgeqrt2 = 0;
        *(void **) &fn = current_backend->lapack.cgeqrt2;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeqrt2(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info) __attribute__((alias("flexiblas_chain_cgeqrt2_")));
#else
void flexiblas_chain_cgeqrt2(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info)
{
    flexiblas_chain_cgeqrt2_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgeqrt3 = 0;
#endif

/* Wrapper for cgeqrt3 */
void FC_GLOBAL(cgeqrt3,CGEQRT3)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info);
    hook_pos_cgeqrt3 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgeqrt3;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgeqrt3.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgeqrt3,CGEQRT3)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqrt3,CGEQRT3)))));
void FC_GLOBAL3(cgeqrt3,CGEQRT3)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgeqrt3,CGEQRT3)))));
#else
void FC_GLOBAL2(cgeqrt3,CGEQRT3)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, blasint *info)
{
    FC_GLOBAL(cgeqrt3,CGEQRT3)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
}
void FC_GLOBAL3(cgeqrt3,CGEQRT3)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, blasint *info)
{
    FC_GLOBAL(cgeqrt3,CGEQRT3)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgeqrt3_(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info);
    *(void **) &fn = current_backend->lapack.cgeqrt3;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgeqrt3(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info) __attribute__((alias("flexiblas_real_cgeqrt3_")));
#else
void flexiblas_real_cgeqrt3(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info)
{
    flexiblas_real_cgeqrt3_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgeqrt3_(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info);
    hook_pos_cgeqrt3++;
    if ( hook_pos_cgeqrt3 < __flexiblas_hooks->cgeqrt3.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgeqrt3.hook_function[hook_pos_cgeqrt3];
    } else {
        hook_pos_cgeqrt3 = 0;
        *(void **) &fn = current_backend->lapack.cgeqrt3;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgeqrt3(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info) __attribute__((alias("flexiblas_chain_cgeqrt3_")));
#else
void flexiblas_chain_cgeqrt3(void *m, void *n, void *a, void *lda, void *t, void *ldt, void *info)
{
    flexiblas_chain_cgeqrt3_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgerfs = 0;
#endif

/* Wrapper for cgerfs */
void FC_GLOBAL(cgerfs,CGERFS)
    (char *trans, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgerfs = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgerfs;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgerfs.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    } else {
        fn((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    }
    #else
    fn((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgerfs,CGERFS)(char *trans, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgerfs,CGERFS)))));
void FC_GLOBAL3(cgerfs,CGERFS)(char *trans, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgerfs,CGERFS)))));
#else
void FC_GLOBAL2(cgerfs,CGERFS)(char *trans, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgerfs,CGERFS)((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
}
void FC_GLOBAL3(cgerfs,CGERFS)(char *trans, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgerfs,CGERFS)((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgerfs_(void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len);
    *(void **) &fn = current_backend->lapack.cgerfs;
    fn((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgerfs(void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_real_cgerfs_")));
#else
void flexiblas_real_cgerfs(void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_real_cgerfs_((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    return;
}
#endif

void flexiblas_chain_cgerfs_(void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgerfs++;
    if ( hook_pos_cgerfs < __flexiblas_hooks->cgerfs.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgerfs.hook_function[hook_pos_cgerfs];
    } else {
        hook_pos_cgerfs = 0;
        *(void **) &fn = current_backend->lapack.cgerfs;
    }
    fn((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgerfs(void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_chain_cgerfs_")));
#else
void flexiblas_chain_cgerfs(void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_chain_cgerfs_((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgerq2 = 0;
#endif

/* Wrapper for cgerq2 */
void FC_GLOBAL(cgerq2,CGERQ2)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    hook_pos_cgerq2 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgerq2;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgerq2.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgerq2,CGERQ2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgerq2,CGERQ2)))));
void FC_GLOBAL3(cgerq2,CGERQ2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgerq2,CGERQ2)))));
#else
void FC_GLOBAL2(cgerq2,CGERQ2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgerq2,CGERQ2)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
}
void FC_GLOBAL3(cgerq2,CGERQ2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *info)
{
    FC_GLOBAL(cgerq2,CGERQ2)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgerq2_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    *(void **) &fn = current_backend->lapack.cgerq2;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgerq2(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info) __attribute__((alias("flexiblas_real_cgerq2_")));
#else
void flexiblas_real_cgerq2(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    flexiblas_real_cgerq2_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgerq2_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *info);
    hook_pos_cgerq2++;
    if ( hook_pos_cgerq2 < __flexiblas_hooks->cgerq2.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgerq2.hook_function[hook_pos_cgerq2];
    } else {
        hook_pos_cgerq2 = 0;
        *(void **) &fn = current_backend->lapack.cgerq2;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgerq2(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info) __attribute__((alias("flexiblas_chain_cgerq2_")));
#else
void flexiblas_chain_cgerq2(void *m, void *n, void *a, void *lda, void *tau, void *work, void *info)
{
    flexiblas_chain_cgerq2_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgerqf = 0;
#endif

/* Wrapper for cgerqf */
void FC_GLOBAL(cgerqf,CGERQF)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    hook_pos_cgerqf = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgerqf;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgerqf.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgerqf,CGERQF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgerqf,CGERQF)))));
void FC_GLOBAL3(cgerqf,CGERQF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgerqf,CGERQF)))));
#else
void FC_GLOBAL2(cgerqf,CGERQF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgerqf,CGERQF)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
}
void FC_GLOBAL3(cgerqf,CGERQF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgerqf,CGERQF)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgerqf_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    *(void **) &fn = current_backend->lapack.cgerqf;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgerqf(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_real_cgerqf_")));
#else
void flexiblas_real_cgerqf(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    flexiblas_real_cgerqf_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgerqf_(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info);
    hook_pos_cgerqf++;
    if ( hook_pos_cgerqf < __flexiblas_hooks->cgerqf.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgerqf.hook_function[hook_pos_cgerqf];
    } else {
        hook_pos_cgerqf = 0;
        *(void **) &fn = current_backend->lapack.cgerqf;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgerqf(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_chain_cgerqf_")));
#else
void flexiblas_chain_cgerqf(void *m, void *n, void *a, void *lda, void *tau, void *work, void *lwork, void *info)
{
    flexiblas_chain_cgerqf_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) tau, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgesc2 = 0;
#endif

/* Wrapper for cgesc2 */
void FC_GLOBAL(cgesc2,CGESC2)
    (blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *rhs, blasint *ipiv, blasint *jpiv, float *scale)
{
    void (*fn) (void *n, void *a, void *lda, void *rhs, void *ipiv, void *jpiv, void *scale);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *n, void *a, void *lda, void *rhs, void *ipiv, void *jpiv, void *scale);
    hook_pos_cgesc2 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgesc2;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgesc2.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) n, (void *) a, (void *) lda, (void *) rhs, (void *) ipiv, (void *) jpiv, (void *) scale);
    } else {
        fn((void *) n, (void *) a, (void *) lda, (void *) rhs, (void *) ipiv, (void *) jpiv, (void *) scale);
    }
    #else
    fn((void *) n, (void *) a, (void *) lda, (void *) rhs, (void *) ipiv, (void *) jpiv, (void *) scale);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgesc2,CGESC2)(blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *rhs, blasint *ipiv, blasint *jpiv, float *scale) __attribute__((alias(MTS(FC_GLOBAL(cgesc2,CGESC2)))));
void FC_GLOBAL3(cgesc2,CGESC2)(blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *rhs, blasint *ipiv, blasint *jpiv, float *scale) __attribute__((alias(MTS(FC_GLOBAL(cgesc2,CGESC2)))));
#else
void FC_GLOBAL2(cgesc2,CGESC2)(blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *rhs, blasint *ipiv, blasint *jpiv, float *scale)
{
    FC_GLOBAL(cgesc2,CGESC2)((void *) n, (void *) a, (void *) lda, (void *) rhs, (void *) ipiv, (void *) jpiv, (void *) scale);
}
void FC_GLOBAL3(cgesc2,CGESC2)(blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *rhs, blasint *ipiv, blasint *jpiv, float *scale)
{
    FC_GLOBAL(cgesc2,CGESC2)((void *) n, (void *) a, (void *) lda, (void *) rhs, (void *) ipiv, (void *) jpiv, (void *) scale);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgesc2_(void *n, void *a, void *lda, void *rhs, void *ipiv, void *jpiv, void *scale)
{
    void (*fn) (void *n, void *a, void *lda, void *rhs, void *ipiv, void *jpiv, void *scale);
    *(void **) &fn = current_backend->lapack.cgesc2;
    fn((void *) n, (void *) a, (void *) lda, (void *) rhs, (void *) ipiv, (void *) jpiv, (void *) scale);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgesc2(void *n, void *a, void *lda, void *rhs, void *ipiv, void *jpiv, void *scale) __attribute__((alias("flexiblas_real_cgesc2_")));
#else
void flexiblas_real_cgesc2(void *n, void *a, void *lda, void *rhs, void *ipiv, void *jpiv, void *scale)
{
    flexiblas_real_cgesc2_((void *) n, (void *) a, (void *) lda, (void *) rhs, (void *) ipiv, (void *) jpiv, (void *) scale);
    return;
}
#endif

void flexiblas_chain_cgesc2_(void *n, void *a, void *lda, void *rhs, void *ipiv, void *jpiv, void *scale)
{
    void (*fn) (void *n, void *a, void *lda, void *rhs, void *ipiv, void *jpiv, void *scale);
    hook_pos_cgesc2++;
    if ( hook_pos_cgesc2 < __flexiblas_hooks->cgesc2.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgesc2.hook_function[hook_pos_cgesc2];
    } else {
        hook_pos_cgesc2 = 0;
        *(void **) &fn = current_backend->lapack.cgesc2;
    }
    fn((void *) n, (void *) a, (void *) lda, (void *) rhs, (void *) ipiv, (void *) jpiv, (void *) scale);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgesc2(void *n, void *a, void *lda, void *rhs, void *ipiv, void *jpiv, void *scale) __attribute__((alias("flexiblas_chain_cgesc2_")));
#else
void flexiblas_chain_cgesc2(void *n, void *a, void *lda, void *rhs, void *ipiv, void *jpiv, void *scale)
{
    flexiblas_chain_cgesc2_((void *) n, (void *) a, (void *) lda, (void *) rhs, (void *) ipiv, (void *) jpiv, (void *) scale);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgesdd = 0;
#endif

/* Wrapper for cgesdd */
void FC_GLOBAL(cgesdd,CGESDD)
    (char *jobz, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t jobz_len)
{
    void (*fn) (void *jobz, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobz_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobz_len);
    hook_pos_cgesdd = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgesdd;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgesdd.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobz_len);
    } else {
        fn((void *) jobz, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobz_len);
    }
    #else
    fn((void *) jobz, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobz_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgesdd,CGESDD)(char *jobz, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t jobz_len) __attribute__((alias(MTS(FC_GLOBAL(cgesdd,CGESDD)))));
void FC_GLOBAL3(cgesdd,CGESDD)(char *jobz, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t jobz_len) __attribute__((alias(MTS(FC_GLOBAL(cgesdd,CGESDD)))));
#else
void FC_GLOBAL2(cgesdd,CGESDD)(char *jobz, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t jobz_len)
{
    FC_GLOBAL(cgesdd,CGESDD)((void *) jobz, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobz_len);
}
void FC_GLOBAL3(cgesdd,CGESDD)(char *jobz, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t jobz_len)
{
    FC_GLOBAL(cgesdd,CGESDD)((void *) jobz, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobz_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgesdd_(void *jobz, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobz_len)
{
    void (*fn) (void *jobz, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobz_len);
    *(void **) &fn = current_backend->lapack.cgesdd;
    fn((void *) jobz, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobz_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgesdd(void *jobz, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobz_len) __attribute__((alias("flexiblas_real_cgesdd_")));
#else
void flexiblas_real_cgesdd(void *jobz, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobz_len)
{
    flexiblas_real_cgesdd_((void *) jobz, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobz_len);
    return;
}
#endif

void flexiblas_chain_cgesdd_(void *jobz, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobz_len)
{
    void (*fn) (void *jobz, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobz_len);
    hook_pos_cgesdd++;
    if ( hook_pos_cgesdd < __flexiblas_hooks->cgesdd.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgesdd.hook_function[hook_pos_cgesdd];
    } else {
        hook_pos_cgesdd = 0;
        *(void **) &fn = current_backend->lapack.cgesdd;
    }
    fn((void *) jobz, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobz_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgesdd(void *jobz, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobz_len) __attribute__((alias("flexiblas_chain_cgesdd_")));
#else
void flexiblas_chain_cgesdd(void *jobz, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobz_len)
{
    flexiblas_chain_cgesdd_((void *) jobz, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobz_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgesv = 0;
#endif

/* Wrapper for cgesv */
void FC_GLOBAL(cgesv,CGESV)
    (blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info)
{
    void (*fn) (void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info);
    hook_pos_cgesv = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgesv;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgesv.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
    } else {
        fn((void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
    }
    #else
    fn((void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgesv,CGESV)(blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgesv,CGESV)))));
void FC_GLOBAL3(cgesv,CGESV)(blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgesv,CGESV)))));
#else
void FC_GLOBAL2(cgesv,CGESV)(blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info)
{
    FC_GLOBAL(cgesv,CGESV)((void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
}
void FC_GLOBAL3(cgesv,CGESV)(blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info)
{
    FC_GLOBAL(cgesv,CGESV)((void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgesv_(void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info)
{
    void (*fn) (void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info);
    *(void **) &fn = current_backend->lapack.cgesv;
    fn((void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgesv(void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info) __attribute__((alias("flexiblas_real_cgesv_")));
#else
void flexiblas_real_cgesv(void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info)
{
    flexiblas_real_cgesv_((void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgesv_(void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info)
{
    void (*fn) (void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info);
    hook_pos_cgesv++;
    if ( hook_pos_cgesv < __flexiblas_hooks->cgesv.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgesv.hook_function[hook_pos_cgesv];
    } else {
        hook_pos_cgesv = 0;
        *(void **) &fn = current_backend->lapack.cgesv;
    }
    fn((void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgesv(void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info) __attribute__((alias("flexiblas_chain_cgesv_")));
#else
void flexiblas_chain_cgesv(void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info)
{
    flexiblas_chain_cgesv_((void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgesvd = 0;
#endif

/* Wrapper for cgesvd */
void FC_GLOBAL(cgesvd,CGESVD)
    (char *jobu, char *jobvt, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len)
{
    void (*fn) (void *jobu, void *jobvt, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobu, void *jobvt, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len);
    hook_pos_cgesvd = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgesvd;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgesvd.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobu, (void *) jobvt, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobu_len, jobvt_len);
    } else {
        fn((void *) jobu, (void *) jobvt, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobu_len, jobvt_len);
    }
    #else
    fn((void *) jobu, (void *) jobvt, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobu_len, jobvt_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgesvd,CGESVD)(char *jobu, char *jobvt, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len) __attribute__((alias(MTS(FC_GLOBAL(cgesvd,CGESVD)))));
void FC_GLOBAL3(cgesvd,CGESVD)(char *jobu, char *jobvt, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len) __attribute__((alias(MTS(FC_GLOBAL(cgesvd,CGESVD)))));
#else
void FC_GLOBAL2(cgesvd,CGESVD)(char *jobu, char *jobvt, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len)
{
    FC_GLOBAL(cgesvd,CGESVD)((void *) jobu, (void *) jobvt, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobu_len, jobvt_len);
}
void FC_GLOBAL3(cgesvd,CGESVD)(char *jobu, char *jobvt, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len)
{
    FC_GLOBAL(cgesvd,CGESVD)((void *) jobu, (void *) jobvt, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobu_len, jobvt_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgesvd_(void *jobu, void *jobvt, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len)
{
    void (*fn) (void *jobu, void *jobvt, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len);
    *(void **) &fn = current_backend->lapack.cgesvd;
    fn((void *) jobu, (void *) jobvt, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobu_len, jobvt_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgesvd(void *jobu, void *jobvt, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len) __attribute__((alias("flexiblas_real_cgesvd_")));
#else
void flexiblas_real_cgesvd(void *jobu, void *jobvt, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len)
{
    flexiblas_real_cgesvd_((void *) jobu, (void *) jobvt, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobu_len, jobvt_len);
    return;
}
#endif

void flexiblas_chain_cgesvd_(void *jobu, void *jobvt, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len)
{
    void (*fn) (void *jobu, void *jobvt, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len);
    hook_pos_cgesvd++;
    if ( hook_pos_cgesvd < __flexiblas_hooks->cgesvd.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgesvd.hook_function[hook_pos_cgesvd];
    } else {
        hook_pos_cgesvd = 0;
        *(void **) &fn = current_backend->lapack.cgesvd;
    }
    fn((void *) jobu, (void *) jobvt, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobu_len, jobvt_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgesvd(void *jobu, void *jobvt, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len) __attribute__((alias("flexiblas_chain_cgesvd_")));
#else
void flexiblas_chain_cgesvd(void *jobu, void *jobvt, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len)
{
    flexiblas_chain_cgesvd_((void *) jobu, (void *) jobvt, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobu_len, jobvt_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgesvdq = 0;
#endif

/* Wrapper for cgesvdq */
void FC_GLOBAL(cgesvdq,CGESVDQ)
    (char *joba, char *jobp, char *jobr, char *jobu, char *jobv, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, blasint *numrank, blasint *iwork, blasint *liwork, lapack_complex_float *cwork, blasint *lcwork, float *rwork, blasint *lrwork, blasint *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobp_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len)
{
    void (*fn) (void *joba, void *jobp, void *jobr, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *v, void *ldv, void *numrank, void *iwork, void *liwork, void *cwork, void *lcwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobp_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *joba, void *jobp, void *jobr, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *v, void *ldv, void *numrank, void *iwork, void *liwork, void *cwork, void *lcwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobp_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len);
    hook_pos_cgesvdq = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgesvdq;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgesvdq.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) joba, (void *) jobp, (void *) jobr, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) numrank, (void *) iwork, (void *) liwork, (void *) cwork, (void *) lcwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobp_len, jobr_len, jobu_len, jobv_len);
    } else {
        fn((void *) joba, (void *) jobp, (void *) jobr, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) numrank, (void *) iwork, (void *) liwork, (void *) cwork, (void *) lcwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobp_len, jobr_len, jobu_len, jobv_len);
    }
    #else
    fn((void *) joba, (void *) jobp, (void *) jobr, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) numrank, (void *) iwork, (void *) liwork, (void *) cwork, (void *) lcwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobp_len, jobr_len, jobu_len, jobv_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgesvdq,CGESVDQ)(char *joba, char *jobp, char *jobr, char *jobu, char *jobv, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, blasint *numrank, blasint *iwork, blasint *liwork, lapack_complex_float *cwork, blasint *lcwork, float *rwork, blasint *lrwork, blasint *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobp_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len) __attribute__((alias(MTS(FC_GLOBAL(cgesvdq,CGESVDQ)))));
void FC_GLOBAL3(cgesvdq,CGESVDQ)(char *joba, char *jobp, char *jobr, char *jobu, char *jobv, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, blasint *numrank, blasint *iwork, blasint *liwork, lapack_complex_float *cwork, blasint *lcwork, float *rwork, blasint *lrwork, blasint *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobp_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len) __attribute__((alias(MTS(FC_GLOBAL(cgesvdq,CGESVDQ)))));
#else
void FC_GLOBAL2(cgesvdq,CGESVDQ)(char *joba, char *jobp, char *jobr, char *jobu, char *jobv, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, blasint *numrank, blasint *iwork, blasint *liwork, lapack_complex_float *cwork, blasint *lcwork, float *rwork, blasint *lrwork, blasint *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobp_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len)
{
    FC_GLOBAL(cgesvdq,CGESVDQ)((void *) joba, (void *) jobp, (void *) jobr, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) numrank, (void *) iwork, (void *) liwork, (void *) cwork, (void *) lcwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobp_len, jobr_len, jobu_len, jobv_len);
}
void FC_GLOBAL3(cgesvdq,CGESVDQ)(char *joba, char *jobp, char *jobr, char *jobu, char *jobv, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, blasint *numrank, blasint *iwork, blasint *liwork, lapack_complex_float *cwork, blasint *lcwork, float *rwork, blasint *lrwork, blasint *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobp_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len)
{
    FC_GLOBAL(cgesvdq,CGESVDQ)((void *) joba, (void *) jobp, (void *) jobr, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) numrank, (void *) iwork, (void *) liwork, (void *) cwork, (void *) lcwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobp_len, jobr_len, jobu_len, jobv_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgesvdq_(void *joba, void *jobp, void *jobr, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *v, void *ldv, void *numrank, void *iwork, void *liwork, void *cwork, void *lcwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobp_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len)
{
    void (*fn) (void *joba, void *jobp, void *jobr, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *v, void *ldv, void *numrank, void *iwork, void *liwork, void *cwork, void *lcwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobp_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len);
    *(void **) &fn = current_backend->lapack.cgesvdq;
    fn((void *) joba, (void *) jobp, (void *) jobr, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) numrank, (void *) iwork, (void *) liwork, (void *) cwork, (void *) lcwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobp_len, jobr_len, jobu_len, jobv_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgesvdq(void *joba, void *jobp, void *jobr, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *v, void *ldv, void *numrank, void *iwork, void *liwork, void *cwork, void *lcwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobp_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len) __attribute__((alias("flexiblas_real_cgesvdq_")));
#else
void flexiblas_real_cgesvdq(void *joba, void *jobp, void *jobr, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *v, void *ldv, void *numrank, void *iwork, void *liwork, void *cwork, void *lcwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobp_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len)
{
    flexiblas_real_cgesvdq_((void *) joba, (void *) jobp, (void *) jobr, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) numrank, (void *) iwork, (void *) liwork, (void *) cwork, (void *) lcwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobp_len, jobr_len, jobu_len, jobv_len);
    return;
}
#endif

void flexiblas_chain_cgesvdq_(void *joba, void *jobp, void *jobr, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *v, void *ldv, void *numrank, void *iwork, void *liwork, void *cwork, void *lcwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobp_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len)
{
    void (*fn) (void *joba, void *jobp, void *jobr, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *v, void *ldv, void *numrank, void *iwork, void *liwork, void *cwork, void *lcwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobp_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len);
    hook_pos_cgesvdq++;
    if ( hook_pos_cgesvdq < __flexiblas_hooks->cgesvdq.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgesvdq.hook_function[hook_pos_cgesvdq];
    } else {
        hook_pos_cgesvdq = 0;
        *(void **) &fn = current_backend->lapack.cgesvdq;
    }
    fn((void *) joba, (void *) jobp, (void *) jobr, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) numrank, (void *) iwork, (void *) liwork, (void *) cwork, (void *) lcwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobp_len, jobr_len, jobu_len, jobv_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgesvdq(void *joba, void *jobp, void *jobr, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *v, void *ldv, void *numrank, void *iwork, void *liwork, void *cwork, void *lcwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobp_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len) __attribute__((alias("flexiblas_chain_cgesvdq_")));
#else
void flexiblas_chain_cgesvdq(void *joba, void *jobp, void *jobr, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *s, void *u, void *ldu, void *v, void *ldv, void *numrank, void *iwork, void *liwork, void *cwork, void *lcwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobp_len, flexiblas_fortran_charlen_t jobr_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len)
{
    flexiblas_chain_cgesvdq_((void *) joba, (void *) jobp, (void *) jobr, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) numrank, (void *) iwork, (void *) liwork, (void *) cwork, (void *) lcwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobp_len, jobr_len, jobu_len, jobv_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgesvdx = 0;
#endif

/* Wrapper for cgesvdx */
void FC_GLOBAL(cgesvdx,CGESVDX)
    (char *jobu, char *jobvt, char *range, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, blasint *ns, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len, flexiblas_fortran_charlen_t range_len)
{
    void (*fn) (void *jobu, void *jobvt, void *range, void *m, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *ns, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len, flexiblas_fortran_charlen_t range_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobu, void *jobvt, void *range, void *m, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *ns, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len, flexiblas_fortran_charlen_t range_len);
    hook_pos_cgesvdx = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgesvdx;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgesvdx.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobu, (void *) jobvt, (void *) range, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) ns, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobvt_len, range_len);
    } else {
        fn((void *) jobu, (void *) jobvt, (void *) range, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) ns, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobvt_len, range_len);
    }
    #else
    fn((void *) jobu, (void *) jobvt, (void *) range, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) ns, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobvt_len, range_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgesvdx,CGESVDX)(char *jobu, char *jobvt, char *range, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, blasint *ns, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len, flexiblas_fortran_charlen_t range_len) __attribute__((alias(MTS(FC_GLOBAL(cgesvdx,CGESVDX)))));
void FC_GLOBAL3(cgesvdx,CGESVDX)(char *jobu, char *jobvt, char *range, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, blasint *ns, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len, flexiblas_fortran_charlen_t range_len) __attribute__((alias(MTS(FC_GLOBAL(cgesvdx,CGESVDX)))));
#else
void FC_GLOBAL2(cgesvdx,CGESVDX)(char *jobu, char *jobvt, char *range, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, blasint *ns, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len, flexiblas_fortran_charlen_t range_len)
{
    FC_GLOBAL(cgesvdx,CGESVDX)((void *) jobu, (void *) jobvt, (void *) range, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) ns, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobvt_len, range_len);
}
void FC_GLOBAL3(cgesvdx,CGESVDX)(char *jobu, char *jobvt, char *range, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, blasint *ns, float *s, lapack_complex_float *u, blasint *ldu, lapack_complex_float *vt, blasint *ldvt, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len, flexiblas_fortran_charlen_t range_len)
{
    FC_GLOBAL(cgesvdx,CGESVDX)((void *) jobu, (void *) jobvt, (void *) range, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) ns, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobvt_len, range_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgesvdx_(void *jobu, void *jobvt, void *range, void *m, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *ns, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len, flexiblas_fortran_charlen_t range_len)
{
    void (*fn) (void *jobu, void *jobvt, void *range, void *m, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *ns, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len, flexiblas_fortran_charlen_t range_len);
    *(void **) &fn = current_backend->lapack.cgesvdx;
    fn((void *) jobu, (void *) jobvt, (void *) range, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) ns, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobvt_len, range_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgesvdx(void *jobu, void *jobvt, void *range, void *m, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *ns, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len, flexiblas_fortran_charlen_t range_len) __attribute__((alias("flexiblas_real_cgesvdx_")));
#else
void flexiblas_real_cgesvdx(void *jobu, void *jobvt, void *range, void *m, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *ns, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len, flexiblas_fortran_charlen_t range_len)
{
    flexiblas_real_cgesvdx_((void *) jobu, (void *) jobvt, (void *) range, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) ns, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobvt_len, range_len);
    return;
}
#endif

void flexiblas_chain_cgesvdx_(void *jobu, void *jobvt, void *range, void *m, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *ns, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len, flexiblas_fortran_charlen_t range_len)
{
    void (*fn) (void *jobu, void *jobvt, void *range, void *m, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *ns, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len, flexiblas_fortran_charlen_t range_len);
    hook_pos_cgesvdx++;
    if ( hook_pos_cgesvdx < __flexiblas_hooks->cgesvdx.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgesvdx.hook_function[hook_pos_cgesvdx];
    } else {
        hook_pos_cgesvdx = 0;
        *(void **) &fn = current_backend->lapack.cgesvdx;
    }
    fn((void *) jobu, (void *) jobvt, (void *) range, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) ns, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobvt_len, range_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgesvdx(void *jobu, void *jobvt, void *range, void *m, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *ns, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len, flexiblas_fortran_charlen_t range_len) __attribute__((alias("flexiblas_chain_cgesvdx_")));
#else
void flexiblas_chain_cgesvdx(void *jobu, void *jobvt, void *range, void *m, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *ns, void *s, void *u, void *ldu, void *vt, void *ldvt, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobvt_len, flexiblas_fortran_charlen_t range_len)
{
    flexiblas_chain_cgesvdx_((void *) jobu, (void *) jobvt, (void *) range, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) ns, (void *) s, (void *) u, (void *) ldu, (void *) vt, (void *) ldvt, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobvt_len, range_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgesvj = 0;
#endif

/* Wrapper for cgesvj */
void FC_GLOBAL(cgesvj,CGESVJ)
    (char *joba, char *jobu, char *jobv, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *sva, blasint *mv, lapack_complex_float *v, blasint *ldv, lapack_complex_float *cwork, blasint *lwork, float *rwork, blasint *lrwork, blasint *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len)
{
    void (*fn) (void *joba, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *sva, void *mv, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *joba, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *sva, void *mv, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len);
    hook_pos_cgesvj = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgesvj;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgesvj.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) joba, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobu_len, jobv_len);
    } else {
        fn((void *) joba, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobu_len, jobv_len);
    }
    #else
    fn((void *) joba, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobu_len, jobv_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgesvj,CGESVJ)(char *joba, char *jobu, char *jobv, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *sva, blasint *mv, lapack_complex_float *v, blasint *ldv, lapack_complex_float *cwork, blasint *lwork, float *rwork, blasint *lrwork, blasint *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len) __attribute__((alias(MTS(FC_GLOBAL(cgesvj,CGESVJ)))));
void FC_GLOBAL3(cgesvj,CGESVJ)(char *joba, char *jobu, char *jobv, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *sva, blasint *mv, lapack_complex_float *v, blasint *ldv, lapack_complex_float *cwork, blasint *lwork, float *rwork, blasint *lrwork, blasint *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len) __attribute__((alias(MTS(FC_GLOBAL(cgesvj,CGESVJ)))));
#else
void FC_GLOBAL2(cgesvj,CGESVJ)(char *joba, char *jobu, char *jobv, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *sva, blasint *mv, lapack_complex_float *v, blasint *ldv, lapack_complex_float *cwork, blasint *lwork, float *rwork, blasint *lrwork, blasint *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len)
{
    FC_GLOBAL(cgesvj,CGESVJ)((void *) joba, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobu_len, jobv_len);
}
void FC_GLOBAL3(cgesvj,CGESVJ)(char *joba, char *jobu, char *jobv, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, float *sva, blasint *mv, lapack_complex_float *v, blasint *ldv, lapack_complex_float *cwork, blasint *lwork, float *rwork, blasint *lrwork, blasint *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len)
{
    FC_GLOBAL(cgesvj,CGESVJ)((void *) joba, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobu_len, jobv_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgesvj_(void *joba, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *sva, void *mv, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len)
{
    void (*fn) (void *joba, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *sva, void *mv, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len);
    *(void **) &fn = current_backend->lapack.cgesvj;
    fn((void *) joba, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobu_len, jobv_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgesvj(void *joba, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *sva, void *mv, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len) __attribute__((alias("flexiblas_real_cgesvj_")));
#else
void flexiblas_real_cgesvj(void *joba, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *sva, void *mv, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len)
{
    flexiblas_real_cgesvj_((void *) joba, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobu_len, jobv_len);
    return;
}
#endif

void flexiblas_chain_cgesvj_(void *joba, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *sva, void *mv, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len)
{
    void (*fn) (void *joba, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *sva, void *mv, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len);
    hook_pos_cgesvj++;
    if ( hook_pos_cgesvj < __flexiblas_hooks->cgesvj.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgesvj.hook_function[hook_pos_cgesvj];
    } else {
        hook_pos_cgesvj = 0;
        *(void **) &fn = current_backend->lapack.cgesvj;
    }
    fn((void *) joba, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobu_len, jobv_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgesvj(void *joba, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *sva, void *mv, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len) __attribute__((alias("flexiblas_chain_cgesvj_")));
#else
void flexiblas_chain_cgesvj(void *joba, void *jobu, void *jobv, void *m, void *n, void *a, void *lda, void *sva, void *mv, void *v, void *ldv, void *cwork, void *lwork, void *rwork, void *lrwork, void *info, flexiblas_fortran_charlen_t joba_len, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len)
{
    flexiblas_chain_cgesvj_((void *) joba, (void *) jobu, (void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) cwork, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) info, joba_len, jobu_len, jobv_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgesvx = 0;
#endif

/* Wrapper for cgesvx */
void FC_GLOBAL(cgesvx,CGESVX)
    (char *fact, char *trans, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, char *equed, float *r, float *c, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len)
{
    void (*fn) (void *fact, void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *fact, void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len);
    hook_pos_cgesvx = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgesvx;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgesvx.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
    } else {
        fn((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
    }
    #else
    fn((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgesvx,CGESVX)(char *fact, char *trans, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, char *equed, float *r, float *c, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len) __attribute__((alias(MTS(FC_GLOBAL(cgesvx,CGESVX)))));
void FC_GLOBAL3(cgesvx,CGESVX)(char *fact, char *trans, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, char *equed, float *r, float *c, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len) __attribute__((alias(MTS(FC_GLOBAL(cgesvx,CGESVX)))));
#else
void FC_GLOBAL2(cgesvx,CGESVX)(char *fact, char *trans, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, char *equed, float *r, float *c, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len)
{
    FC_GLOBAL(cgesvx,CGESVX)((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
}
void FC_GLOBAL3(cgesvx,CGESVX)(char *fact, char *trans, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, char *equed, float *r, float *c, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len)
{
    FC_GLOBAL(cgesvx,CGESVX)((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgesvx_(void *fact, void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len)
{
    void (*fn) (void *fact, void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len);
    *(void **) &fn = current_backend->lapack.cgesvx;
    fn((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgesvx(void *fact, void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len) __attribute__((alias("flexiblas_real_cgesvx_")));
#else
void flexiblas_real_cgesvx(void *fact, void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len)
{
    flexiblas_real_cgesvx_((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
    return;
}
#endif

void flexiblas_chain_cgesvx_(void *fact, void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len)
{
    void (*fn) (void *fact, void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len);
    hook_pos_cgesvx++;
    if ( hook_pos_cgesvx < __flexiblas_hooks->cgesvx.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgesvx.hook_function[hook_pos_cgesvx];
    } else {
        hook_pos_cgesvx = 0;
        *(void **) &fn = current_backend->lapack.cgesvx;
    }
    fn((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgesvx(void *fact, void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len) __attribute__((alias("flexiblas_chain_cgesvx_")));
#else
void flexiblas_chain_cgesvx(void *fact, void *trans, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *equed, void *r, void *c, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len, flexiblas_fortran_charlen_t equed_len)
{
    flexiblas_chain_cgesvx_((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) equed, (void *) r, (void *) c, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len, equed_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgetc2 = 0;
#endif

/* Wrapper for cgetc2 */
void FC_GLOBAL(cgetc2,CGETC2)
    (blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *jpiv, blasint *info)
{
    void (*fn) (void *n, void *a, void *lda, void *ipiv, void *jpiv, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *n, void *a, void *lda, void *ipiv, void *jpiv, void *info);
    hook_pos_cgetc2 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgetc2;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgetc2.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) jpiv, (void *) info);
    } else {
        fn((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) jpiv, (void *) info);
    }
    #else
    fn((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) jpiv, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgetc2,CGETC2)(blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *jpiv, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgetc2,CGETC2)))));
void FC_GLOBAL3(cgetc2,CGETC2)(blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *jpiv, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgetc2,CGETC2)))));
#else
void FC_GLOBAL2(cgetc2,CGETC2)(blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *jpiv, blasint *info)
{
    FC_GLOBAL(cgetc2,CGETC2)((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) jpiv, (void *) info);
}
void FC_GLOBAL3(cgetc2,CGETC2)(blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *jpiv, blasint *info)
{
    FC_GLOBAL(cgetc2,CGETC2)((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) jpiv, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgetc2_(void *n, void *a, void *lda, void *ipiv, void *jpiv, void *info)
{
    void (*fn) (void *n, void *a, void *lda, void *ipiv, void *jpiv, void *info);
    *(void **) &fn = current_backend->lapack.cgetc2;
    fn((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) jpiv, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgetc2(void *n, void *a, void *lda, void *ipiv, void *jpiv, void *info) __attribute__((alias("flexiblas_real_cgetc2_")));
#else
void flexiblas_real_cgetc2(void *n, void *a, void *lda, void *ipiv, void *jpiv, void *info)
{
    flexiblas_real_cgetc2_((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) jpiv, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgetc2_(void *n, void *a, void *lda, void *ipiv, void *jpiv, void *info)
{
    void (*fn) (void *n, void *a, void *lda, void *ipiv, void *jpiv, void *info);
    hook_pos_cgetc2++;
    if ( hook_pos_cgetc2 < __flexiblas_hooks->cgetc2.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgetc2.hook_function[hook_pos_cgetc2];
    } else {
        hook_pos_cgetc2 = 0;
        *(void **) &fn = current_backend->lapack.cgetc2;
    }
    fn((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) jpiv, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgetc2(void *n, void *a, void *lda, void *ipiv, void *jpiv, void *info) __attribute__((alias("flexiblas_chain_cgetc2_")));
#else
void flexiblas_chain_cgetc2(void *n, void *a, void *lda, void *ipiv, void *jpiv, void *info)
{
    flexiblas_chain_cgetc2_((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) jpiv, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgetf2 = 0;
#endif

/* Wrapper for cgetf2 */
void FC_GLOBAL(cgetf2,CGETF2)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *ipiv, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *ipiv, void *info);
    hook_pos_cgetf2 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgetf2;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgetf2.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgetf2,CGETF2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgetf2,CGETF2)))));
void FC_GLOBAL3(cgetf2,CGETF2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgetf2,CGETF2)))));
#else
void FC_GLOBAL2(cgetf2,CGETF2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info)
{
    FC_GLOBAL(cgetf2,CGETF2)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
}
void FC_GLOBAL3(cgetf2,CGETF2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info)
{
    FC_GLOBAL(cgetf2,CGETF2)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgetf2_(void *m, void *n, void *a, void *lda, void *ipiv, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *ipiv, void *info);
    *(void **) &fn = current_backend->lapack.cgetf2;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgetf2(void *m, void *n, void *a, void *lda, void *ipiv, void *info) __attribute__((alias("flexiblas_real_cgetf2_")));
#else
void flexiblas_real_cgetf2(void *m, void *n, void *a, void *lda, void *ipiv, void *info)
{
    flexiblas_real_cgetf2_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgetf2_(void *m, void *n, void *a, void *lda, void *ipiv, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *ipiv, void *info);
    hook_pos_cgetf2++;
    if ( hook_pos_cgetf2 < __flexiblas_hooks->cgetf2.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgetf2.hook_function[hook_pos_cgetf2];
    } else {
        hook_pos_cgetf2 = 0;
        *(void **) &fn = current_backend->lapack.cgetf2;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgetf2(void *m, void *n, void *a, void *lda, void *ipiv, void *info) __attribute__((alias("flexiblas_chain_cgetf2_")));
#else
void flexiblas_chain_cgetf2(void *m, void *n, void *a, void *lda, void *ipiv, void *info)
{
    flexiblas_chain_cgetf2_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgetrf = 0;
#endif

/* Wrapper for cgetrf */
void FC_GLOBAL(cgetrf,CGETRF)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *ipiv, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *ipiv, void *info);
    hook_pos_cgetrf = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgetrf;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgetrf.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgetrf,CGETRF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgetrf,CGETRF)))));
void FC_GLOBAL3(cgetrf,CGETRF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgetrf,CGETRF)))));
#else
void FC_GLOBAL2(cgetrf,CGETRF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info)
{
    FC_GLOBAL(cgetrf,CGETRF)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
}
void FC_GLOBAL3(cgetrf,CGETRF)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info)
{
    FC_GLOBAL(cgetrf,CGETRF)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgetrf_(void *m, void *n, void *a, void *lda, void *ipiv, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *ipiv, void *info);
    *(void **) &fn = current_backend->lapack.cgetrf;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgetrf(void *m, void *n, void *a, void *lda, void *ipiv, void *info) __attribute__((alias("flexiblas_real_cgetrf_")));
#else
void flexiblas_real_cgetrf(void *m, void *n, void *a, void *lda, void *ipiv, void *info)
{
    flexiblas_real_cgetrf_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgetrf_(void *m, void *n, void *a, void *lda, void *ipiv, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *ipiv, void *info);
    hook_pos_cgetrf++;
    if ( hook_pos_cgetrf < __flexiblas_hooks->cgetrf.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgetrf.hook_function[hook_pos_cgetrf];
    } else {
        hook_pos_cgetrf = 0;
        *(void **) &fn = current_backend->lapack.cgetrf;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgetrf(void *m, void *n, void *a, void *lda, void *ipiv, void *info) __attribute__((alias("flexiblas_chain_cgetrf_")));
#else
void flexiblas_chain_cgetrf(void *m, void *n, void *a, void *lda, void *ipiv, void *info)
{
    flexiblas_chain_cgetrf_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgetrf2 = 0;
#endif

/* Wrapper for cgetrf2 */
void FC_GLOBAL(cgetrf2,CGETRF2)
    (blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *ipiv, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *a, void *lda, void *ipiv, void *info);
    hook_pos_cgetrf2 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgetrf2;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgetrf2.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgetrf2,CGETRF2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgetrf2,CGETRF2)))));
void FC_GLOBAL3(cgetrf2,CGETRF2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgetrf2,CGETRF2)))));
#else
void FC_GLOBAL2(cgetrf2,CGETRF2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info)
{
    FC_GLOBAL(cgetrf2,CGETRF2)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
}
void FC_GLOBAL3(cgetrf2,CGETRF2)(blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info)
{
    FC_GLOBAL(cgetrf2,CGETRF2)((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgetrf2_(void *m, void *n, void *a, void *lda, void *ipiv, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *ipiv, void *info);
    *(void **) &fn = current_backend->lapack.cgetrf2;
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgetrf2(void *m, void *n, void *a, void *lda, void *ipiv, void *info) __attribute__((alias("flexiblas_real_cgetrf2_")));
#else
void flexiblas_real_cgetrf2(void *m, void *n, void *a, void *lda, void *ipiv, void *info)
{
    flexiblas_real_cgetrf2_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgetrf2_(void *m, void *n, void *a, void *lda, void *ipiv, void *info)
{
    void (*fn) (void *m, void *n, void *a, void *lda, void *ipiv, void *info);
    hook_pos_cgetrf2++;
    if ( hook_pos_cgetrf2 < __flexiblas_hooks->cgetrf2.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgetrf2.hook_function[hook_pos_cgetrf2];
    } else {
        hook_pos_cgetrf2 = 0;
        *(void **) &fn = current_backend->lapack.cgetrf2;
    }
    fn((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgetrf2(void *m, void *n, void *a, void *lda, void *ipiv, void *info) __attribute__((alias("flexiblas_chain_cgetrf2_")));
#else
void flexiblas_chain_cgetrf2(void *m, void *n, void *a, void *lda, void *ipiv, void *info)
{
    flexiblas_chain_cgetrf2_((void *) m, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgetri = 0;
#endif

/* Wrapper for cgetri */
void FC_GLOBAL(cgetri,CGETRI)
    (blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    void (*fn) (void *n, void *a, void *lda, void *ipiv, void *work, void *lwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *n, void *a, void *lda, void *ipiv, void *work, void *lwork, void *info);
    hook_pos_cgetri = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgetri;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgetri.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) work, (void *) lwork, (void *) info);
    } else {
        fn((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) work, (void *) lwork, (void *) info);
    }
    #else
    fn((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) work, (void *) lwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgetri,CGETRI)(blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgetri,CGETRI)))));
void FC_GLOBAL3(cgetri,CGETRI)(blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgetri,CGETRI)))));
#else
void FC_GLOBAL2(cgetri,CGETRI)(blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgetri,CGETRI)((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) work, (void *) lwork, (void *) info);
}
void FC_GLOBAL3(cgetri,CGETRI)(blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgetri,CGETRI)((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) work, (void *) lwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgetri_(void *n, void *a, void *lda, void *ipiv, void *work, void *lwork, void *info)
{
    void (*fn) (void *n, void *a, void *lda, void *ipiv, void *work, void *lwork, void *info);
    *(void **) &fn = current_backend->lapack.cgetri;
    fn((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgetri(void *n, void *a, void *lda, void *ipiv, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_real_cgetri_")));
#else
void flexiblas_real_cgetri(void *n, void *a, void *lda, void *ipiv, void *work, void *lwork, void *info)
{
    flexiblas_real_cgetri_((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgetri_(void *n, void *a, void *lda, void *ipiv, void *work, void *lwork, void *info)
{
    void (*fn) (void *n, void *a, void *lda, void *ipiv, void *work, void *lwork, void *info);
    hook_pos_cgetri++;
    if ( hook_pos_cgetri < __flexiblas_hooks->cgetri.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgetri.hook_function[hook_pos_cgetri];
    } else {
        hook_pos_cgetri = 0;
        *(void **) &fn = current_backend->lapack.cgetri;
    }
    fn((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgetri(void *n, void *a, void *lda, void *ipiv, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_chain_cgetri_")));
#else
void flexiblas_chain_cgetri(void *n, void *a, void *lda, void *ipiv, void *work, void *lwork, void *info)
{
    flexiblas_chain_cgetri_((void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgetrs = 0;
#endif

/* Wrapper for cgetrs */
void FC_GLOBAL(cgetrs,CGETRS)
    (char *trans, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *trans, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgetrs = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgetrs;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgetrs.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    } else {
        fn((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    }
    #else
    fn((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgetrs,CGETRS)(char *trans, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgetrs,CGETRS)))));
void FC_GLOBAL3(cgetrs,CGETRS)(char *trans, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgetrs,CGETRS)))));
#else
void FC_GLOBAL2(cgetrs,CGETRS)(char *trans, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgetrs,CGETRS)((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
}
void FC_GLOBAL3(cgetrs,CGETRS)(char *trans, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgetrs,CGETRS)((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgetrs_(void *trans, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len);
    *(void **) &fn = current_backend->lapack.cgetrs;
    fn((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgetrs(void *trans, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_real_cgetrs_")));
#else
void flexiblas_real_cgetrs(void *trans, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_real_cgetrs_((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    return;
}
#endif

void flexiblas_chain_cgetrs_(void *trans, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgetrs++;
    if ( hook_pos_cgetrs < __flexiblas_hooks->cgetrs.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgetrs.hook_function[hook_pos_cgetrs];
    } else {
        hook_pos_cgetrs = 0;
        *(void **) &fn = current_backend->lapack.cgetrs;
    }
    fn((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgetrs(void *trans, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_chain_cgetrs_")));
#else
void flexiblas_chain_cgetrs(void *trans, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_chain_cgetrs_((void *) trans, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgetsls = 0;
#endif

/* Wrapper for cgetsls */
void FC_GLOBAL(cgetsls,CGETSLS)
    (char *trans, blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgetsls = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgetsls;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgetsls.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    } else {
        fn((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    }
    #else
    fn((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgetsls,CGETSLS)(char *trans, blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgetsls,CGETSLS)))));
void FC_GLOBAL3(cgetsls,CGETSLS)(char *trans, blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgetsls,CGETSLS)))));
#else
void FC_GLOBAL2(cgetsls,CGETSLS)(char *trans, blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgetsls,CGETSLS)((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
}
void FC_GLOBAL3(cgetsls,CGETSLS)(char *trans, blasint *m, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgetsls,CGETSLS)((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgetsls_(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len);
    *(void **) &fn = current_backend->lapack.cgetsls;
    fn((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgetsls(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_real_cgetsls_")));
#else
void flexiblas_real_cgetsls(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_real_cgetsls_((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    return;
}
#endif

void flexiblas_chain_cgetsls_(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgetsls++;
    if ( hook_pos_cgetsls < __flexiblas_hooks->cgetsls.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgetsls.hook_function[hook_pos_cgetsls];
    } else {
        hook_pos_cgetsls = 0;
        *(void **) &fn = current_backend->lapack.cgetsls;
    }
    fn((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgetsls(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_chain_cgetsls_")));
#else
void flexiblas_chain_cgetsls(void *trans, void *m, void *n, void *nrhs, void *a, void *lda, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_chain_cgetsls_((void *) trans, (void *) m, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, trans_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgetsqrhrt = 0;
#endif

/* Wrapper for cgetsqrhrt */
void FC_GLOBAL(cgetsqrhrt,CGETSQRHRT)
    (blasint *m, blasint *n, blasint *mb1, blasint *nb1, blasint *nb2, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    void (*fn) (void *m, void *n, void *mb1, void *nb1, void *nb2, void *a, void *lda, void *t, void *ldt, void *work, void *lwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *mb1, void *nb1, void *nb2, void *a, void *lda, void *t, void *ldt, void *work, void *lwork, void *info);
    hook_pos_cgetsqrhrt = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgetsqrhrt;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgetsqrhrt.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) mb1, (void *) nb1, (void *) nb2, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) lwork, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) mb1, (void *) nb1, (void *) nb2, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) lwork, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) mb1, (void *) nb1, (void *) nb2, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) lwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgetsqrhrt,CGETSQRHRT)(blasint *m, blasint *n, blasint *mb1, blasint *nb1, blasint *nb2, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgetsqrhrt,CGETSQRHRT)))));
void FC_GLOBAL3(cgetsqrhrt,CGETSQRHRT)(blasint *m, blasint *n, blasint *mb1, blasint *nb1, blasint *nb2, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgetsqrhrt,CGETSQRHRT)))));
#else
void FC_GLOBAL2(cgetsqrhrt,CGETSQRHRT)(blasint *m, blasint *n, blasint *mb1, blasint *nb1, blasint *nb2, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgetsqrhrt,CGETSQRHRT)((void *) m, (void *) n, (void *) mb1, (void *) nb1, (void *) nb2, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) lwork, (void *) info);
}
void FC_GLOBAL3(cgetsqrhrt,CGETSQRHRT)(blasint *m, blasint *n, blasint *mb1, blasint *nb1, blasint *nb2, lapack_complex_float *a, blasint *lda, lapack_complex_float *t, blasint *ldt, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgetsqrhrt,CGETSQRHRT)((void *) m, (void *) n, (void *) mb1, (void *) nb1, (void *) nb2, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) lwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgetsqrhrt_(void *m, void *n, void *mb1, void *nb1, void *nb2, void *a, void *lda, void *t, void *ldt, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *mb1, void *nb1, void *nb2, void *a, void *lda, void *t, void *ldt, void *work, void *lwork, void *info);
    *(void **) &fn = current_backend->lapack.cgetsqrhrt;
    fn((void *) m, (void *) n, (void *) mb1, (void *) nb1, (void *) nb2, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgetsqrhrt(void *m, void *n, void *mb1, void *nb1, void *nb2, void *a, void *lda, void *t, void *ldt, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_real_cgetsqrhrt_")));
#else
void flexiblas_real_cgetsqrhrt(void *m, void *n, void *mb1, void *nb1, void *nb2, void *a, void *lda, void *t, void *ldt, void *work, void *lwork, void *info)
{
    flexiblas_real_cgetsqrhrt_((void *) m, (void *) n, (void *) mb1, (void *) nb1, (void *) nb2, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgetsqrhrt_(void *m, void *n, void *mb1, void *nb1, void *nb2, void *a, void *lda, void *t, void *ldt, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *mb1, void *nb1, void *nb2, void *a, void *lda, void *t, void *ldt, void *work, void *lwork, void *info);
    hook_pos_cgetsqrhrt++;
    if ( hook_pos_cgetsqrhrt < __flexiblas_hooks->cgetsqrhrt.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgetsqrhrt.hook_function[hook_pos_cgetsqrhrt];
    } else {
        hook_pos_cgetsqrhrt = 0;
        *(void **) &fn = current_backend->lapack.cgetsqrhrt;
    }
    fn((void *) m, (void *) n, (void *) mb1, (void *) nb1, (void *) nb2, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgetsqrhrt(void *m, void *n, void *mb1, void *nb1, void *nb2, void *a, void *lda, void *t, void *ldt, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_chain_cgetsqrhrt_")));
#else
void flexiblas_chain_cgetsqrhrt(void *m, void *n, void *mb1, void *nb1, void *nb2, void *a, void *lda, void *t, void *ldt, void *work, void *lwork, void *info)
{
    flexiblas_chain_cgetsqrhrt_((void *) m, (void *) n, (void *) mb1, (void *) nb1, (void *) nb2, (void *) a, (void *) lda, (void *) t, (void *) ldt, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cggbak = 0;
#endif

/* Wrapper for cggbak */
void FC_GLOBAL(cggbak,CGGBAK)
    (char *job, char *side, blasint *n, blasint *ilo, blasint *ihi, float *lscale, float *rscale, blasint *m, lapack_complex_float *v, blasint *ldv, blasint *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len)
{
    void (*fn) (void *job, void *side, void *n, void *ilo, void *ihi, void *lscale, void *rscale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *job, void *side, void *n, void *ilo, void *ihi, void *lscale, void *rscale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len);
    hook_pos_cggbak = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cggbak;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cggbak.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
    } else {
        fn((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
    }
    #else
    fn((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cggbak,CGGBAK)(char *job, char *side, blasint *n, blasint *ilo, blasint *ihi, float *lscale, float *rscale, blasint *m, lapack_complex_float *v, blasint *ldv, blasint *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len) __attribute__((alias(MTS(FC_GLOBAL(cggbak,CGGBAK)))));
void FC_GLOBAL3(cggbak,CGGBAK)(char *job, char *side, blasint *n, blasint *ilo, blasint *ihi, float *lscale, float *rscale, blasint *m, lapack_complex_float *v, blasint *ldv, blasint *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len) __attribute__((alias(MTS(FC_GLOBAL(cggbak,CGGBAK)))));
#else
void FC_GLOBAL2(cggbak,CGGBAK)(char *job, char *side, blasint *n, blasint *ilo, blasint *ihi, float *lscale, float *rscale, blasint *m, lapack_complex_float *v, blasint *ldv, blasint *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len)
{
    FC_GLOBAL(cggbak,CGGBAK)((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
}
void FC_GLOBAL3(cggbak,CGGBAK)(char *job, char *side, blasint *n, blasint *ilo, blasint *ihi, float *lscale, float *rscale, blasint *m, lapack_complex_float *v, blasint *ldv, blasint *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len)
{
    FC_GLOBAL(cggbak,CGGBAK)((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cggbak_(void *job, void *side, void *n, void *ilo, void *ihi, void *lscale, void *rscale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len)
{
    void (*fn) (void *job, void *side, void *n, void *ilo, void *ihi, void *lscale, void *rscale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len);
    *(void **) &fn = current_backend->lapack.cggbak;
    fn((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cggbak(void *job, void *side, void *n, void *ilo, void *ihi, void *lscale, void *rscale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len) __attribute__((alias("flexiblas_real_cggbak_")));
#else
void flexiblas_real_cggbak(void *job, void *side, void *n, void *ilo, void *ihi, void *lscale, void *rscale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len)
{
    flexiblas_real_cggbak_((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
    return;
}
#endif

void flexiblas_chain_cggbak_(void *job, void *side, void *n, void *ilo, void *ihi, void *lscale, void *rscale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len)
{
    void (*fn) (void *job, void *side, void *n, void *ilo, void *ihi, void *lscale, void *rscale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len);
    hook_pos_cggbak++;
    if ( hook_pos_cggbak < __flexiblas_hooks->cggbak.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cggbak.hook_function[hook_pos_cggbak];
    } else {
        hook_pos_cggbak = 0;
        *(void **) &fn = current_backend->lapack.cggbak;
    }
    fn((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cggbak(void *job, void *side, void *n, void *ilo, void *ihi, void *lscale, void *rscale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len) __attribute__((alias("flexiblas_chain_cggbak_")));
#else
void flexiblas_chain_cggbak(void *job, void *side, void *n, void *ilo, void *ihi, void *lscale, void *rscale, void *m, void *v, void *ldv, void *info, flexiblas_fortran_charlen_t job_len, flexiblas_fortran_charlen_t side_len)
{
    flexiblas_chain_cggbak_((void *) job, (void *) side, (void *) n, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) m, (void *) v, (void *) ldv, (void *) info, job_len, side_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cggbal = 0;
#endif

/* Wrapper for cggbal */
void FC_GLOBAL(cggbal,CGGBAL)
    (char *job, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *ilo, blasint *ihi, float *lscale, float *rscale, float *work, blasint *info, flexiblas_fortran_charlen_t job_len)
{
    void (*fn) (void *job, void *n, void *a, void *lda, void *b, void *ldb, void *ilo, void *ihi, void *lscale, void *rscale, void *work, void *info, flexiblas_fortran_charlen_t job_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *job, void *n, void *a, void *lda, void *b, void *ldb, void *ilo, void *ihi, void *lscale, void *rscale, void *work, void *info, flexiblas_fortran_charlen_t job_len);
    hook_pos_cggbal = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cggbal;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cggbal.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) job, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) work, (void *) info, job_len);
    } else {
        fn((void *) job, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) work, (void *) info, job_len);
    }
    #else
    fn((void *) job, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) work, (void *) info, job_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cggbal,CGGBAL)(char *job, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *ilo, blasint *ihi, float *lscale, float *rscale, float *work, blasint *info, flexiblas_fortran_charlen_t job_len) __attribute__((alias(MTS(FC_GLOBAL(cggbal,CGGBAL)))));
void FC_GLOBAL3(cggbal,CGGBAL)(char *job, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *ilo, blasint *ihi, float *lscale, float *rscale, float *work, blasint *info, flexiblas_fortran_charlen_t job_len) __attribute__((alias(MTS(FC_GLOBAL(cggbal,CGGBAL)))));
#else
void FC_GLOBAL2(cggbal,CGGBAL)(char *job, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *ilo, blasint *ihi, float *lscale, float *rscale, float *work, blasint *info, flexiblas_fortran_charlen_t job_len)
{
    FC_GLOBAL(cggbal,CGGBAL)((void *) job, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) work, (void *) info, job_len);
}
void FC_GLOBAL3(cggbal,CGGBAL)(char *job, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *ilo, blasint *ihi, float *lscale, float *rscale, float *work, blasint *info, flexiblas_fortran_charlen_t job_len)
{
    FC_GLOBAL(cggbal,CGGBAL)((void *) job, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) work, (void *) info, job_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cggbal_(void *job, void *n, void *a, void *lda, void *b, void *ldb, void *ilo, void *ihi, void *lscale, void *rscale, void *work, void *info, flexiblas_fortran_charlen_t job_len)
{
    void (*fn) (void *job, void *n, void *a, void *lda, void *b, void *ldb, void *ilo, void *ihi, void *lscale, void *rscale, void *work, void *info, flexiblas_fortran_charlen_t job_len);
    *(void **) &fn = current_backend->lapack.cggbal;
    fn((void *) job, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) work, (void *) info, job_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cggbal(void *job, void *n, void *a, void *lda, void *b, void *ldb, void *ilo, void *ihi, void *lscale, void *rscale, void *work, void *info, flexiblas_fortran_charlen_t job_len) __attribute__((alias("flexiblas_real_cggbal_")));
#else
void flexiblas_real_cggbal(void *job, void *n, void *a, void *lda, void *b, void *ldb, void *ilo, void *ihi, void *lscale, void *rscale, void *work, void *info, flexiblas_fortran_charlen_t job_len)
{
    flexiblas_real_cggbal_((void *) job, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) work, (void *) info, job_len);
    return;
}
#endif

void flexiblas_chain_cggbal_(void *job, void *n, void *a, void *lda, void *b, void *ldb, void *ilo, void *ihi, void *lscale, void *rscale, void *work, void *info, flexiblas_fortran_charlen_t job_len)
{
    void (*fn) (void *job, void *n, void *a, void *lda, void *b, void *ldb, void *ilo, void *ihi, void *lscale, void *rscale, void *work, void *info, flexiblas_fortran_charlen_t job_len);
    hook_pos_cggbal++;
    if ( hook_pos_cggbal < __flexiblas_hooks->cggbal.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cggbal.hook_function[hook_pos_cggbal];
    } else {
        hook_pos_cggbal = 0;
        *(void **) &fn = current_backend->lapack.cggbal;
    }
    fn((void *) job, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) work, (void *) info, job_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cggbal(void *job, void *n, void *a, void *lda, void *b, void *ldb, void *ilo, void *ihi, void *lscale, void *rscale, void *work, void *info, flexiblas_fortran_charlen_t job_len) __attribute__((alias("flexiblas_chain_cggbal_")));
#else
void flexiblas_chain_cggbal(void *job, void *n, void *a, void *lda, void *b, void *ldb, void *ilo, void *ihi, void *lscale, void *rscale, void *work, void *info, flexiblas_fortran_charlen_t job_len)
{
    flexiblas_chain_cggbal_((void *) job, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) work, (void *) info, job_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgges = 0;
#endif

/* Wrapper for cgges */
void FC_GLOBAL(cgges,CGGES)
    (char *jobvsl, char *jobvsr, char *sort, blaslogical *selctg, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *sdim, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vsl, blasint *ldvsl, lapack_complex_float *vsr, blasint *ldvsr, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len)
{
    void (*fn) (void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len);
    hook_pos_cgges = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgges;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgges.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
    } else {
        fn((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
    }
    #else
    fn((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgges,CGGES)(char *jobvsl, char *jobvsr, char *sort, blaslogical *selctg, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *sdim, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vsl, blasint *ldvsl, lapack_complex_float *vsr, blasint *ldvsr, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len) __attribute__((alias(MTS(FC_GLOBAL(cgges,CGGES)))));
void FC_GLOBAL3(cgges,CGGES)(char *jobvsl, char *jobvsr, char *sort, blaslogical *selctg, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *sdim, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vsl, blasint *ldvsl, lapack_complex_float *vsr, blasint *ldvsr, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len) __attribute__((alias(MTS(FC_GLOBAL(cgges,CGGES)))));
#else
void FC_GLOBAL2(cgges,CGGES)(char *jobvsl, char *jobvsr, char *sort, blaslogical *selctg, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *sdim, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vsl, blasint *ldvsl, lapack_complex_float *vsr, blasint *ldvsr, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len)
{
    FC_GLOBAL(cgges,CGGES)((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
}
void FC_GLOBAL3(cgges,CGGES)(char *jobvsl, char *jobvsr, char *sort, blaslogical *selctg, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *sdim, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vsl, blasint *ldvsl, lapack_complex_float *vsr, blasint *ldvsr, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len)
{
    FC_GLOBAL(cgges,CGGES)((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgges_(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len)
{
    void (*fn) (void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len);
    *(void **) &fn = current_backend->lapack.cgges;
    fn((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgges(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len) __attribute__((alias("flexiblas_real_cgges_")));
#else
void flexiblas_real_cgges(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len)
{
    flexiblas_real_cgges_((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
    return;
}
#endif

void flexiblas_chain_cgges_(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len)
{
    void (*fn) (void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len);
    hook_pos_cgges++;
    if ( hook_pos_cgges < __flexiblas_hooks->cgges.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgges.hook_function[hook_pos_cgges];
    } else {
        hook_pos_cgges = 0;
        *(void **) &fn = current_backend->lapack.cgges;
    }
    fn((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgges(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len) __attribute__((alias("flexiblas_chain_cgges_")));
#else
void flexiblas_chain_cgges(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len)
{
    flexiblas_chain_cgges_((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgges3 = 0;
#endif

/* Wrapper for cgges3 */
void FC_GLOBAL(cgges3,CGGES3)
    (char *jobvsl, char *jobvsr, char *sort, blaslogical *selctg, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *sdim, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vsl, blasint *ldvsl, lapack_complex_float *vsr, blasint *ldvsr, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len)
{
    void (*fn) (void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len);
    hook_pos_cgges3 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgges3;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgges3.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
    } else {
        fn((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
    }
    #else
    fn((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgges3,CGGES3)(char *jobvsl, char *jobvsr, char *sort, blaslogical *selctg, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *sdim, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vsl, blasint *ldvsl, lapack_complex_float *vsr, blasint *ldvsr, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len) __attribute__((alias(MTS(FC_GLOBAL(cgges3,CGGES3)))));
void FC_GLOBAL3(cgges3,CGGES3)(char *jobvsl, char *jobvsr, char *sort, blaslogical *selctg, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *sdim, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vsl, blasint *ldvsl, lapack_complex_float *vsr, blasint *ldvsr, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len) __attribute__((alias(MTS(FC_GLOBAL(cgges3,CGGES3)))));
#else
void FC_GLOBAL2(cgges3,CGGES3)(char *jobvsl, char *jobvsr, char *sort, blaslogical *selctg, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *sdim, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vsl, blasint *ldvsl, lapack_complex_float *vsr, blasint *ldvsr, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len)
{
    FC_GLOBAL(cgges3,CGGES3)((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
}
void FC_GLOBAL3(cgges3,CGGES3)(char *jobvsl, char *jobvsr, char *sort, blaslogical *selctg, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *sdim, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vsl, blasint *ldvsl, lapack_complex_float *vsr, blasint *ldvsr, lapack_complex_float *work, blasint *lwork, float *rwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len)
{
    FC_GLOBAL(cgges3,CGGES3)((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgges3_(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len)
{
    void (*fn) (void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len);
    *(void **) &fn = current_backend->lapack.cgges3;
    fn((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgges3(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len) __attribute__((alias("flexiblas_real_cgges3_")));
#else
void flexiblas_real_cgges3(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len)
{
    flexiblas_real_cgges3_((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
    return;
}
#endif

void flexiblas_chain_cgges3_(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len)
{
    void (*fn) (void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len);
    hook_pos_cgges3++;
    if ( hook_pos_cgges3 < __flexiblas_hooks->cgges3.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgges3.hook_function[hook_pos_cgges3];
    } else {
        hook_pos_cgges3 = 0;
        *(void **) &fn = current_backend->lapack.cgges3;
    }
    fn((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgges3(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len) __attribute__((alias("flexiblas_chain_cgges3_")));
#else
void flexiblas_chain_cgges3(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *work, void *lwork, void *rwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len)
{
    flexiblas_chain_cgges3_((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) work, (void *) lwork, (void *) rwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cggesx = 0;
#endif

/* Wrapper for cggesx */
void FC_GLOBAL(cggesx,CGGESX)
    (char *jobvsl, char *jobvsr, char *sort, blaslogical *selctg, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *sdim, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vsl, blasint *ldvsl, lapack_complex_float *vsr, blasint *ldvsr, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *liwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len)
{
    void (*fn) (void *jobvsl, void *jobvsr, void *sort, void *selctg, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *liwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobvsl, void *jobvsr, void *sort, void *selctg, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *liwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len);
    hook_pos_cggesx = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cggesx;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cggesx.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) liwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len, sense_len);
    } else {
        fn((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) liwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len, sense_len);
    }
    #else
    fn((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) liwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len, sense_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cggesx,CGGESX)(char *jobvsl, char *jobvsr, char *sort, blaslogical *selctg, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *sdim, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vsl, blasint *ldvsl, lapack_complex_float *vsr, blasint *ldvsr, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *liwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len) __attribute__((alias(MTS(FC_GLOBAL(cggesx,CGGESX)))));
void FC_GLOBAL3(cggesx,CGGESX)(char *jobvsl, char *jobvsr, char *sort, blaslogical *selctg, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *sdim, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vsl, blasint *ldvsl, lapack_complex_float *vsr, blasint *ldvsr, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *liwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len) __attribute__((alias(MTS(FC_GLOBAL(cggesx,CGGESX)))));
#else
void FC_GLOBAL2(cggesx,CGGESX)(char *jobvsl, char *jobvsr, char *sort, blaslogical *selctg, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *sdim, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vsl, blasint *ldvsl, lapack_complex_float *vsr, blasint *ldvsr, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *liwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len)
{
    FC_GLOBAL(cggesx,CGGESX)((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) liwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len, sense_len);
}
void FC_GLOBAL3(cggesx,CGGESX)(char *jobvsl, char *jobvsr, char *sort, blaslogical *selctg, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *sdim, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vsl, blasint *ldvsl, lapack_complex_float *vsr, blasint *ldvsr, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *liwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len)
{
    FC_GLOBAL(cggesx,CGGESX)((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) liwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len, sense_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cggesx_(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *liwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len)
{
    void (*fn) (void *jobvsl, void *jobvsr, void *sort, void *selctg, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *liwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len);
    *(void **) &fn = current_backend->lapack.cggesx;
    fn((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) liwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len, sense_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cggesx(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *liwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len) __attribute__((alias("flexiblas_real_cggesx_")));
#else
void flexiblas_real_cggesx(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *liwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len)
{
    flexiblas_real_cggesx_((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) liwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len, sense_len);
    return;
}
#endif

void flexiblas_chain_cggesx_(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *liwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len)
{
    void (*fn) (void *jobvsl, void *jobvsr, void *sort, void *selctg, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *liwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len);
    hook_pos_cggesx++;
    if ( hook_pos_cggesx < __flexiblas_hooks->cggesx.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cggesx.hook_function[hook_pos_cggesx];
    } else {
        hook_pos_cggesx = 0;
        *(void **) &fn = current_backend->lapack.cggesx;
    }
    fn((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) liwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len, sense_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cggesx(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *liwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len) __attribute__((alias("flexiblas_chain_cggesx_")));
#else
void flexiblas_chain_cggesx(void *jobvsl, void *jobvsr, void *sort, void *selctg, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *sdim, void *alpha, void *beta, void *vsl, void *ldvsl, void *vsr, void *ldvsr, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *liwork, void *bwork, void *info, flexiblas_fortran_charlen_t jobvsl_len, flexiblas_fortran_charlen_t jobvsr_len, flexiblas_fortran_charlen_t sort_len, flexiblas_fortran_charlen_t sense_len)
{
    flexiblas_chain_cggesx_((void *) jobvsl, (void *) jobvsr, (void *) sort, (void *) selctg, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) sdim, (void *) alpha, (void *) beta, (void *) vsl, (void *) ldvsl, (void *) vsr, (void *) ldvsr, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) liwork, (void *) bwork, (void *) info, jobvsl_len, jobvsr_len, sort_len, sense_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cggev = 0;
#endif

/* Wrapper for cggev */
void FC_GLOBAL(cggev,CGGEV)
    (char *jobvl, char *jobvr, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    void (*fn) (void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len);
    hook_pos_cggev = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cggev;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cggev.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    } else {
        fn((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    }
    #else
    fn((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cggev,CGGEV)(char *jobvl, char *jobvr, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len) __attribute__((alias(MTS(FC_GLOBAL(cggev,CGGEV)))));
void FC_GLOBAL3(cggev,CGGEV)(char *jobvl, char *jobvr, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len) __attribute__((alias(MTS(FC_GLOBAL(cggev,CGGEV)))));
#else
void FC_GLOBAL2(cggev,CGGEV)(char *jobvl, char *jobvr, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    FC_GLOBAL(cggev,CGGEV)((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
}
void FC_GLOBAL3(cggev,CGGEV)(char *jobvl, char *jobvr, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    FC_GLOBAL(cggev,CGGEV)((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cggev_(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    void (*fn) (void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len);
    *(void **) &fn = current_backend->lapack.cggev;
    fn((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cggev(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len) __attribute__((alias("flexiblas_real_cggev_")));
#else
void flexiblas_real_cggev(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    flexiblas_real_cggev_((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    return;
}
#endif

void flexiblas_chain_cggev_(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    void (*fn) (void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len);
    hook_pos_cggev++;
    if ( hook_pos_cggev < __flexiblas_hooks->cggev.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cggev.hook_function[hook_pos_cggev];
    } else {
        hook_pos_cggev = 0;
        *(void **) &fn = current_backend->lapack.cggev;
    }
    fn((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cggev(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len) __attribute__((alias("flexiblas_chain_cggev_")));
#else
void flexiblas_chain_cggev(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    flexiblas_chain_cggev_((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cggev3 = 0;
#endif

/* Wrapper for cggev3 */
void FC_GLOBAL(cggev3,CGGEV3)
    (char *jobvl, char *jobvr, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    void (*fn) (void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len);
    hook_pos_cggev3 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cggev3;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cggev3.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    } else {
        fn((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    }
    #else
    fn((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cggev3,CGGEV3)(char *jobvl, char *jobvr, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len) __attribute__((alias(MTS(FC_GLOBAL(cggev3,CGGEV3)))));
void FC_GLOBAL3(cggev3,CGGEV3)(char *jobvl, char *jobvr, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len) __attribute__((alias(MTS(FC_GLOBAL(cggev3,CGGEV3)))));
#else
void FC_GLOBAL2(cggev3,CGGEV3)(char *jobvl, char *jobvr, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    FC_GLOBAL(cggev3,CGGEV3)((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
}
void FC_GLOBAL3(cggev3,CGGEV3)(char *jobvl, char *jobvr, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    FC_GLOBAL(cggev3,CGGEV3)((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cggev3_(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    void (*fn) (void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len);
    *(void **) &fn = current_backend->lapack.cggev3;
    fn((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cggev3(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len) __attribute__((alias("flexiblas_real_cggev3_")));
#else
void flexiblas_real_cggev3(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    flexiblas_real_cggev3_((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    return;
}
#endif

void flexiblas_chain_cggev3_(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    void (*fn) (void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len);
    hook_pos_cggev3++;
    if ( hook_pos_cggev3 < __flexiblas_hooks->cggev3.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cggev3.hook_function[hook_pos_cggev3];
    } else {
        hook_pos_cggev3 = 0;
        *(void **) &fn = current_backend->lapack.cggev3;
    }
    fn((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cggev3(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len) __attribute__((alias("flexiblas_chain_cggev3_")));
#else
void flexiblas_chain_cggev3(void *jobvl, void *jobvr, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len)
{
    flexiblas_chain_cggev3_((void *) jobvl, (void *) jobvr, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobvl_len, jobvr_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cggevx = 0;
#endif

/* Wrapper for cggevx */
void FC_GLOBAL(cggevx,CGGEVX)
    (char *balanc, char *jobvl, char *jobvr, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, blasint *ilo, blasint *ihi, float *lscale, float *rscale, float *abnrm, float *bbnrm, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len)
{
    void (*fn) (void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *lscale, void *rscale, void *abnrm, void *bbnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *bwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *lscale, void *rscale, void *abnrm, void *bbnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *bwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len);
    hook_pos_cggevx = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cggevx;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cggevx.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) abnrm, (void *) bbnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) bwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
    } else {
        fn((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) abnrm, (void *) bbnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) bwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
    }
    #else
    fn((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) abnrm, (void *) bbnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) bwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cggevx,CGGEVX)(char *balanc, char *jobvl, char *jobvr, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, blasint *ilo, blasint *ihi, float *lscale, float *rscale, float *abnrm, float *bbnrm, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len) __attribute__((alias(MTS(FC_GLOBAL(cggevx,CGGEVX)))));
void FC_GLOBAL3(cggevx,CGGEVX)(char *balanc, char *jobvl, char *jobvr, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, blasint *ilo, blasint *ihi, float *lscale, float *rscale, float *abnrm, float *bbnrm, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len) __attribute__((alias(MTS(FC_GLOBAL(cggevx,CGGEVX)))));
#else
void FC_GLOBAL2(cggevx,CGGEVX)(char *balanc, char *jobvl, char *jobvr, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, blasint *ilo, blasint *ihi, float *lscale, float *rscale, float *abnrm, float *bbnrm, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len)
{
    FC_GLOBAL(cggevx,CGGEVX)((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) abnrm, (void *) bbnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) bwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
}
void FC_GLOBAL3(cggevx,CGGEVX)(char *balanc, char *jobvl, char *jobvr, char *sense, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *alpha, lapack_complex_float *beta, lapack_complex_float *vl, blasint *ldvl, lapack_complex_float *vr, blasint *ldvr, blasint *ilo, blasint *ihi, float *lscale, float *rscale, float *abnrm, float *bbnrm, float *rconde, float *rcondv, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blaslogical *bwork, blasint *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len)
{
    FC_GLOBAL(cggevx,CGGEVX)((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) abnrm, (void *) bbnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) bwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cggevx_(void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *lscale, void *rscale, void *abnrm, void *bbnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *bwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len)
{
    void (*fn) (void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *lscale, void *rscale, void *abnrm, void *bbnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *bwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len);
    *(void **) &fn = current_backend->lapack.cggevx;
    fn((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) abnrm, (void *) bbnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) bwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cggevx(void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *lscale, void *rscale, void *abnrm, void *bbnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *bwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len) __attribute__((alias("flexiblas_real_cggevx_")));
#else
void flexiblas_real_cggevx(void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *lscale, void *rscale, void *abnrm, void *bbnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *bwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len)
{
    flexiblas_real_cggevx_((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) abnrm, (void *) bbnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) bwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
    return;
}
#endif

void flexiblas_chain_cggevx_(void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *lscale, void *rscale, void *abnrm, void *bbnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *bwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len)
{
    void (*fn) (void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *lscale, void *rscale, void *abnrm, void *bbnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *bwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len);
    hook_pos_cggevx++;
    if ( hook_pos_cggevx < __flexiblas_hooks->cggevx.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cggevx.hook_function[hook_pos_cggevx];
    } else {
        hook_pos_cggevx = 0;
        *(void **) &fn = current_backend->lapack.cggevx;
    }
    fn((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) abnrm, (void *) bbnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) bwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cggevx(void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *lscale, void *rscale, void *abnrm, void *bbnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *bwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len) __attribute__((alias("flexiblas_chain_cggevx_")));
#else
void flexiblas_chain_cggevx(void *balanc, void *jobvl, void *jobvr, void *sense, void *n, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *vl, void *ldvl, void *vr, void *ldvr, void *ilo, void *ihi, void *lscale, void *rscale, void *abnrm, void *bbnrm, void *rconde, void *rcondv, void *work, void *lwork, void *rwork, void *iwork, void *bwork, void *info, flexiblas_fortran_charlen_t balanc_len, flexiblas_fortran_charlen_t jobvl_len, flexiblas_fortran_charlen_t jobvr_len, flexiblas_fortran_charlen_t sense_len)
{
    flexiblas_chain_cggevx_((void *) balanc, (void *) jobvl, (void *) jobvr, (void *) sense, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) vl, (void *) ldvl, (void *) vr, (void *) ldvr, (void *) ilo, (void *) ihi, (void *) lscale, (void *) rscale, (void *) abnrm, (void *) bbnrm, (void *) rconde, (void *) rcondv, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) bwork, (void *) info, balanc_len, jobvl_len, jobvr_len, sense_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cggglm = 0;
#endif

/* Wrapper for cggglm */
void FC_GLOBAL(cggglm,CGGGLM)
    (blasint *n, blasint *m, blasint *p, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *d, lapack_complex_float *x, lapack_complex_float *y, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    void (*fn) (void *n, void *m, void *p, void *a, void *lda, void *b, void *ldb, void *d, void *x, void *y, void *work, void *lwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *n, void *m, void *p, void *a, void *lda, void *b, void *ldb, void *d, void *x, void *y, void *work, void *lwork, void *info);
    hook_pos_cggglm = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cggglm;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cggglm.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) d, (void *) x, (void *) y, (void *) work, (void *) lwork, (void *) info);
    } else {
        fn((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) d, (void *) x, (void *) y, (void *) work, (void *) lwork, (void *) info);
    }
    #else
    fn((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) d, (void *) x, (void *) y, (void *) work, (void *) lwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cggglm,CGGGLM)(blasint *n, blasint *m, blasint *p, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *d, lapack_complex_float *x, lapack_complex_float *y, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cggglm,CGGGLM)))));
void FC_GLOBAL3(cggglm,CGGGLM)(blasint *n, blasint *m, blasint *p, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *d, lapack_complex_float *x, lapack_complex_float *y, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cggglm,CGGGLM)))));
#else
void FC_GLOBAL2(cggglm,CGGGLM)(blasint *n, blasint *m, blasint *p, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *d, lapack_complex_float *x, lapack_complex_float *y, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cggglm,CGGGLM)((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) d, (void *) x, (void *) y, (void *) work, (void *) lwork, (void *) info);
}
void FC_GLOBAL3(cggglm,CGGGLM)(blasint *n, blasint *m, blasint *p, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *d, lapack_complex_float *x, lapack_complex_float *y, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cggglm,CGGGLM)((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) d, (void *) x, (void *) y, (void *) work, (void *) lwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cggglm_(void *n, void *m, void *p, void *a, void *lda, void *b, void *ldb, void *d, void *x, void *y, void *work, void *lwork, void *info)
{
    void (*fn) (void *n, void *m, void *p, void *a, void *lda, void *b, void *ldb, void *d, void *x, void *y, void *work, void *lwork, void *info);
    *(void **) &fn = current_backend->lapack.cggglm;
    fn((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) d, (void *) x, (void *) y, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cggglm(void *n, void *m, void *p, void *a, void *lda, void *b, void *ldb, void *d, void *x, void *y, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_real_cggglm_")));
#else
void flexiblas_real_cggglm(void *n, void *m, void *p, void *a, void *lda, void *b, void *ldb, void *d, void *x, void *y, void *work, void *lwork, void *info)
{
    flexiblas_real_cggglm_((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) d, (void *) x, (void *) y, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cggglm_(void *n, void *m, void *p, void *a, void *lda, void *b, void *ldb, void *d, void *x, void *y, void *work, void *lwork, void *info)
{
    void (*fn) (void *n, void *m, void *p, void *a, void *lda, void *b, void *ldb, void *d, void *x, void *y, void *work, void *lwork, void *info);
    hook_pos_cggglm++;
    if ( hook_pos_cggglm < __flexiblas_hooks->cggglm.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cggglm.hook_function[hook_pos_cggglm];
    } else {
        hook_pos_cggglm = 0;
        *(void **) &fn = current_backend->lapack.cggglm;
    }
    fn((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) d, (void *) x, (void *) y, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cggglm(void *n, void *m, void *p, void *a, void *lda, void *b, void *ldb, void *d, void *x, void *y, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_chain_cggglm_")));
#else
void flexiblas_chain_cggglm(void *n, void *m, void *p, void *a, void *lda, void *b, void *ldb, void *d, void *x, void *y, void *work, void *lwork, void *info)
{
    flexiblas_chain_cggglm_((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) d, (void *) x, (void *) y, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgghd3 = 0;
#endif

/* Wrapper for cgghd3 */
void FC_GLOBAL(cgghd3,CGGHD3)
    (char *compq, char *compz, blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *q, blasint *ldq, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len)
{
    void (*fn) (void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len);
    hook_pos_cgghd3 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgghd3;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgghd3.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) info, compq_len, compz_len);
    } else {
        fn((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) info, compq_len, compz_len);
    }
    #else
    fn((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) info, compq_len, compz_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgghd3,CGGHD3)(char *compq, char *compz, blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *q, blasint *ldq, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len) __attribute__((alias(MTS(FC_GLOBAL(cgghd3,CGGHD3)))));
void FC_GLOBAL3(cgghd3,CGGHD3)(char *compq, char *compz, blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *q, blasint *ldq, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len) __attribute__((alias(MTS(FC_GLOBAL(cgghd3,CGGHD3)))));
#else
void FC_GLOBAL2(cgghd3,CGGHD3)(char *compq, char *compz, blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *q, blasint *ldq, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len)
{
    FC_GLOBAL(cgghd3,CGGHD3)((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) info, compq_len, compz_len);
}
void FC_GLOBAL3(cgghd3,CGGHD3)(char *compq, char *compz, blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *q, blasint *ldq, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len)
{
    FC_GLOBAL(cgghd3,CGGHD3)((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) info, compq_len, compz_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgghd3_(void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len)
{
    void (*fn) (void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len);
    *(void **) &fn = current_backend->lapack.cgghd3;
    fn((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) info, compq_len, compz_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgghd3(void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len) __attribute__((alias("flexiblas_real_cgghd3_")));
#else
void flexiblas_real_cgghd3(void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len)
{
    flexiblas_real_cgghd3_((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) info, compq_len, compz_len);
    return;
}
#endif

void flexiblas_chain_cgghd3_(void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len)
{
    void (*fn) (void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len);
    hook_pos_cgghd3++;
    if ( hook_pos_cgghd3 < __flexiblas_hooks->cgghd3.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgghd3.hook_function[hook_pos_cgghd3];
    } else {
        hook_pos_cgghd3 = 0;
        *(void **) &fn = current_backend->lapack.cgghd3;
    }
    fn((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) info, compq_len, compz_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgghd3(void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len) __attribute__((alias("flexiblas_chain_cgghd3_")));
#else
void flexiblas_chain_cgghd3(void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len)
{
    flexiblas_chain_cgghd3_((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) info, compq_len, compz_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgghrd = 0;
#endif

/* Wrapper for cgghrd */
void FC_GLOBAL(cgghrd,CGGHRD)
    (char *compq, char *compz, blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *q, blasint *ldq, lapack_complex_float *z, blasint *ldz, blasint *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len)
{
    void (*fn) (void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len);
    hook_pos_cgghrd = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgghrd;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgghrd.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) info, compq_len, compz_len);
    } else {
        fn((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) info, compq_len, compz_len);
    }
    #else
    fn((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) info, compq_len, compz_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgghrd,CGGHRD)(char *compq, char *compz, blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *q, blasint *ldq, lapack_complex_float *z, blasint *ldz, blasint *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len) __attribute__((alias(MTS(FC_GLOBAL(cgghrd,CGGHRD)))));
void FC_GLOBAL3(cgghrd,CGGHRD)(char *compq, char *compz, blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *q, blasint *ldq, lapack_complex_float *z, blasint *ldz, blasint *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len) __attribute__((alias(MTS(FC_GLOBAL(cgghrd,CGGHRD)))));
#else
void FC_GLOBAL2(cgghrd,CGGHRD)(char *compq, char *compz, blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *q, blasint *ldq, lapack_complex_float *z, blasint *ldz, blasint *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len)
{
    FC_GLOBAL(cgghrd,CGGHRD)((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) info, compq_len, compz_len);
}
void FC_GLOBAL3(cgghrd,CGGHRD)(char *compq, char *compz, blasint *n, blasint *ilo, blasint *ihi, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *q, blasint *ldq, lapack_complex_float *z, blasint *ldz, blasint *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len)
{
    FC_GLOBAL(cgghrd,CGGHRD)((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) info, compq_len, compz_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgghrd_(void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len)
{
    void (*fn) (void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len);
    *(void **) &fn = current_backend->lapack.cgghrd;
    fn((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) info, compq_len, compz_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgghrd(void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len) __attribute__((alias("flexiblas_real_cgghrd_")));
#else
void flexiblas_real_cgghrd(void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len)
{
    flexiblas_real_cgghrd_((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) info, compq_len, compz_len);
    return;
}
#endif

void flexiblas_chain_cgghrd_(void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len)
{
    void (*fn) (void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len);
    hook_pos_cgghrd++;
    if ( hook_pos_cgghrd < __flexiblas_hooks->cgghrd.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgghrd.hook_function[hook_pos_cgghrd];
    } else {
        hook_pos_cgghrd = 0;
        *(void **) &fn = current_backend->lapack.cgghrd;
    }
    fn((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) info, compq_len, compz_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgghrd(void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len) __attribute__((alias("flexiblas_chain_cgghrd_")));
#else
void flexiblas_chain_cgghrd(void *compq, void *compz, void *n, void *ilo, void *ihi, void *a, void *lda, void *b, void *ldb, void *q, void *ldq, void *z, void *ldz, void *info, flexiblas_fortran_charlen_t compq_len, flexiblas_fortran_charlen_t compz_len)
{
    flexiblas_chain_cgghrd_((void *) compq, (void *) compz, (void *) n, (void *) ilo, (void *) ihi, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) q, (void *) ldq, (void *) z, (void *) ldz, (void *) info, compq_len, compz_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgglse = 0;
#endif

/* Wrapper for cgglse */
void FC_GLOBAL(cgglse,CGGLSE)
    (blasint *m, blasint *n, blasint *p, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *c, lapack_complex_float *d, lapack_complex_float *x, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    void (*fn) (void *m, void *n, void *p, void *a, void *lda, void *b, void *ldb, void *c, void *d, void *x, void *work, void *lwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *n, void *p, void *a, void *lda, void *b, void *ldb, void *c, void *d, void *x, void *work, void *lwork, void *info);
    hook_pos_cgglse = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgglse;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgglse.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) n, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) c, (void *) d, (void *) x, (void *) work, (void *) lwork, (void *) info);
    } else {
        fn((void *) m, (void *) n, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) c, (void *) d, (void *) x, (void *) work, (void *) lwork, (void *) info);
    }
    #else
    fn((void *) m, (void *) n, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) c, (void *) d, (void *) x, (void *) work, (void *) lwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgglse,CGGLSE)(blasint *m, blasint *n, blasint *p, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *c, lapack_complex_float *d, lapack_complex_float *x, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgglse,CGGLSE)))));
void FC_GLOBAL3(cgglse,CGGLSE)(blasint *m, blasint *n, blasint *p, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *c, lapack_complex_float *d, lapack_complex_float *x, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgglse,CGGLSE)))));
#else
void FC_GLOBAL2(cgglse,CGGLSE)(blasint *m, blasint *n, blasint *p, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *c, lapack_complex_float *d, lapack_complex_float *x, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgglse,CGGLSE)((void *) m, (void *) n, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) c, (void *) d, (void *) x, (void *) work, (void *) lwork, (void *) info);
}
void FC_GLOBAL3(cgglse,CGGLSE)(blasint *m, blasint *n, blasint *p, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, lapack_complex_float *c, lapack_complex_float *d, lapack_complex_float *x, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cgglse,CGGLSE)((void *) m, (void *) n, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) c, (void *) d, (void *) x, (void *) work, (void *) lwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgglse_(void *m, void *n, void *p, void *a, void *lda, void *b, void *ldb, void *c, void *d, void *x, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *p, void *a, void *lda, void *b, void *ldb, void *c, void *d, void *x, void *work, void *lwork, void *info);
    *(void **) &fn = current_backend->lapack.cgglse;
    fn((void *) m, (void *) n, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) c, (void *) d, (void *) x, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgglse(void *m, void *n, void *p, void *a, void *lda, void *b, void *ldb, void *c, void *d, void *x, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_real_cgglse_")));
#else
void flexiblas_real_cgglse(void *m, void *n, void *p, void *a, void *lda, void *b, void *ldb, void *c, void *d, void *x, void *work, void *lwork, void *info)
{
    flexiblas_real_cgglse_((void *) m, (void *) n, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) c, (void *) d, (void *) x, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgglse_(void *m, void *n, void *p, void *a, void *lda, void *b, void *ldb, void *c, void *d, void *x, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *n, void *p, void *a, void *lda, void *b, void *ldb, void *c, void *d, void *x, void *work, void *lwork, void *info);
    hook_pos_cgglse++;
    if ( hook_pos_cgglse < __flexiblas_hooks->cgglse.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgglse.hook_function[hook_pos_cgglse];
    } else {
        hook_pos_cgglse = 0;
        *(void **) &fn = current_backend->lapack.cgglse;
    }
    fn((void *) m, (void *) n, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) c, (void *) d, (void *) x, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgglse(void *m, void *n, void *p, void *a, void *lda, void *b, void *ldb, void *c, void *d, void *x, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_chain_cgglse_")));
#else
void flexiblas_chain_cgglse(void *m, void *n, void *p, void *a, void *lda, void *b, void *ldb, void *c, void *d, void *x, void *work, void *lwork, void *info)
{
    flexiblas_chain_cgglse_((void *) m, (void *) n, (void *) p, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) c, (void *) d, (void *) x, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cggqrf = 0;
#endif

/* Wrapper for cggqrf */
void FC_GLOBAL(cggqrf,CGGQRF)
    (blasint *n, blasint *m, blasint *p, lapack_complex_float *a, blasint *lda, lapack_complex_float *taua, lapack_complex_float *b, blasint *ldb, lapack_complex_float *taub, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    void (*fn) (void *n, void *m, void *p, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *n, void *m, void *p, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info);
    hook_pos_cggqrf = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cggqrf;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cggqrf.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
    } else {
        fn((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
    }
    #else
    fn((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cggqrf,CGGQRF)(blasint *n, blasint *m, blasint *p, lapack_complex_float *a, blasint *lda, lapack_complex_float *taua, lapack_complex_float *b, blasint *ldb, lapack_complex_float *taub, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cggqrf,CGGQRF)))));
void FC_GLOBAL3(cggqrf,CGGQRF)(blasint *n, blasint *m, blasint *p, lapack_complex_float *a, blasint *lda, lapack_complex_float *taua, lapack_complex_float *b, blasint *ldb, lapack_complex_float *taub, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cggqrf,CGGQRF)))));
#else
void FC_GLOBAL2(cggqrf,CGGQRF)(blasint *n, blasint *m, blasint *p, lapack_complex_float *a, blasint *lda, lapack_complex_float *taua, lapack_complex_float *b, blasint *ldb, lapack_complex_float *taub, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cggqrf,CGGQRF)((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
}
void FC_GLOBAL3(cggqrf,CGGQRF)(blasint *n, blasint *m, blasint *p, lapack_complex_float *a, blasint *lda, lapack_complex_float *taua, lapack_complex_float *b, blasint *ldb, lapack_complex_float *taub, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cggqrf,CGGQRF)((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cggqrf_(void *n, void *m, void *p, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info)
{
    void (*fn) (void *n, void *m, void *p, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info);
    *(void **) &fn = current_backend->lapack.cggqrf;
    fn((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cggqrf(void *n, void *m, void *p, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_real_cggqrf_")));
#else
void flexiblas_real_cggqrf(void *n, void *m, void *p, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info)
{
    flexiblas_real_cggqrf_((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cggqrf_(void *n, void *m, void *p, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info)
{
    void (*fn) (void *n, void *m, void *p, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info);
    hook_pos_cggqrf++;
    if ( hook_pos_cggqrf < __flexiblas_hooks->cggqrf.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cggqrf.hook_function[hook_pos_cggqrf];
    } else {
        hook_pos_cggqrf = 0;
        *(void **) &fn = current_backend->lapack.cggqrf;
    }
    fn((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cggqrf(void *n, void *m, void *p, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_chain_cggqrf_")));
#else
void flexiblas_chain_cggqrf(void *n, void *m, void *p, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info)
{
    flexiblas_chain_cggqrf_((void *) n, (void *) m, (void *) p, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cggrqf = 0;
#endif

/* Wrapper for cggrqf */
void FC_GLOBAL(cggrqf,CGGRQF)
    (blasint *m, blasint *p, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *taua, lapack_complex_float *b, blasint *ldb, lapack_complex_float *taub, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    void (*fn) (void *m, void *p, void *n, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *m, void *p, void *n, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info);
    hook_pos_cggrqf = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cggrqf;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cggrqf.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
    } else {
        fn((void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
    }
    #else
    fn((void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cggrqf,CGGRQF)(blasint *m, blasint *p, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *taua, lapack_complex_float *b, blasint *ldb, lapack_complex_float *taub, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cggrqf,CGGRQF)))));
void FC_GLOBAL3(cggrqf,CGGRQF)(blasint *m, blasint *p, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *taua, lapack_complex_float *b, blasint *ldb, lapack_complex_float *taub, lapack_complex_float *work, blasint *lwork, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cggrqf,CGGRQF)))));
#else
void FC_GLOBAL2(cggrqf,CGGRQF)(blasint *m, blasint *p, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *taua, lapack_complex_float *b, blasint *ldb, lapack_complex_float *taub, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cggrqf,CGGRQF)((void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
}
void FC_GLOBAL3(cggrqf,CGGRQF)(blasint *m, blasint *p, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *taua, lapack_complex_float *b, blasint *ldb, lapack_complex_float *taub, lapack_complex_float *work, blasint *lwork, blasint *info)
{
    FC_GLOBAL(cggrqf,CGGRQF)((void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cggrqf_(void *m, void *p, void *n, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *p, void *n, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info);
    *(void **) &fn = current_backend->lapack.cggrqf;
    fn((void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cggrqf(void *m, void *p, void *n, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_real_cggrqf_")));
#else
void flexiblas_real_cggrqf(void *m, void *p, void *n, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info)
{
    flexiblas_real_cggrqf_((void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif

void flexiblas_chain_cggrqf_(void *m, void *p, void *n, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info)
{
    void (*fn) (void *m, void *p, void *n, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info);
    hook_pos_cggrqf++;
    if ( hook_pos_cggrqf < __flexiblas_hooks->cggrqf.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cggrqf.hook_function[hook_pos_cggrqf];
    } else {
        hook_pos_cggrqf = 0;
        *(void **) &fn = current_backend->lapack.cggrqf;
    }
    fn((void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cggrqf(void *m, void *p, void *n, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info) __attribute__((alias("flexiblas_chain_cggrqf_")));
#else
void flexiblas_chain_cggrqf(void *m, void *p, void *n, void *a, void *lda, void *taua, void *b, void *ldb, void *taub, void *work, void *lwork, void *info)
{
    flexiblas_chain_cggrqf_((void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) taua, (void *) b, (void *) ldb, (void *) taub, (void *) work, (void *) lwork, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cggsvd3 = 0;
#endif

/* Wrapper for cggsvd3 */
void FC_GLOBAL(cggsvd3,CGGSVD3)
    (char *jobu, char *jobv, char *jobq, blasint *m, blasint *n, blasint *p, blasint *k, blasint *l, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *alpha, float *beta, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, lapack_complex_float *q, blasint *ldq, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len)
{
    void (*fn) (void *jobu, void *jobv, void *jobq, void *m, void *n, void *p, void *k, void *l, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobu, void *jobv, void *jobq, void *m, void *n, void *p, void *k, void *l, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len);
    hook_pos_cggsvd3 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cggsvd3;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cggsvd3.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) n, (void *) p, (void *) k, (void *) l, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobv_len, jobq_len);
    } else {
        fn((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) n, (void *) p, (void *) k, (void *) l, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobv_len, jobq_len);
    }
    #else
    fn((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) n, (void *) p, (void *) k, (void *) l, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobv_len, jobq_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cggsvd3,CGGSVD3)(char *jobu, char *jobv, char *jobq, blasint *m, blasint *n, blasint *p, blasint *k, blasint *l, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *alpha, float *beta, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, lapack_complex_float *q, blasint *ldq, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len) __attribute__((alias(MTS(FC_GLOBAL(cggsvd3,CGGSVD3)))));
void FC_GLOBAL3(cggsvd3,CGGSVD3)(char *jobu, char *jobv, char *jobq, blasint *m, blasint *n, blasint *p, blasint *k, blasint *l, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *alpha, float *beta, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, lapack_complex_float *q, blasint *ldq, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len) __attribute__((alias(MTS(FC_GLOBAL(cggsvd3,CGGSVD3)))));
#else
void FC_GLOBAL2(cggsvd3,CGGSVD3)(char *jobu, char *jobv, char *jobq, blasint *m, blasint *n, blasint *p, blasint *k, blasint *l, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *alpha, float *beta, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, lapack_complex_float *q, blasint *ldq, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len)
{
    FC_GLOBAL(cggsvd3,CGGSVD3)((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) n, (void *) p, (void *) k, (void *) l, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobv_len, jobq_len);
}
void FC_GLOBAL3(cggsvd3,CGGSVD3)(char *jobu, char *jobv, char *jobq, blasint *m, blasint *n, blasint *p, blasint *k, blasint *l, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *alpha, float *beta, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, lapack_complex_float *q, blasint *ldq, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len)
{
    FC_GLOBAL(cggsvd3,CGGSVD3)((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) n, (void *) p, (void *) k, (void *) l, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobv_len, jobq_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cggsvd3_(void *jobu, void *jobv, void *jobq, void *m, void *n, void *p, void *k, void *l, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len)
{
    void (*fn) (void *jobu, void *jobv, void *jobq, void *m, void *n, void *p, void *k, void *l, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len);
    *(void **) &fn = current_backend->lapack.cggsvd3;
    fn((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) n, (void *) p, (void *) k, (void *) l, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobv_len, jobq_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cggsvd3(void *jobu, void *jobv, void *jobq, void *m, void *n, void *p, void *k, void *l, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len) __attribute__((alias("flexiblas_real_cggsvd3_")));
#else
void flexiblas_real_cggsvd3(void *jobu, void *jobv, void *jobq, void *m, void *n, void *p, void *k, void *l, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len)
{
    flexiblas_real_cggsvd3_((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) n, (void *) p, (void *) k, (void *) l, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobv_len, jobq_len);
    return;
}
#endif

void flexiblas_chain_cggsvd3_(void *jobu, void *jobv, void *jobq, void *m, void *n, void *p, void *k, void *l, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len)
{
    void (*fn) (void *jobu, void *jobv, void *jobq, void *m, void *n, void *p, void *k, void *l, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len);
    hook_pos_cggsvd3++;
    if ( hook_pos_cggsvd3 < __flexiblas_hooks->cggsvd3.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cggsvd3.hook_function[hook_pos_cggsvd3];
    } else {
        hook_pos_cggsvd3 = 0;
        *(void **) &fn = current_backend->lapack.cggsvd3;
    }
    fn((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) n, (void *) p, (void *) k, (void *) l, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobv_len, jobq_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cggsvd3(void *jobu, void *jobv, void *jobq, void *m, void *n, void *p, void *k, void *l, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len) __attribute__((alias("flexiblas_chain_cggsvd3_")));
#else
void flexiblas_chain_cggsvd3(void *jobu, void *jobv, void *jobq, void *m, void *n, void *p, void *k, void *l, void *a, void *lda, void *b, void *ldb, void *alpha, void *beta, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *work, void *lwork, void *rwork, void *iwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len)
{
    flexiblas_chain_cggsvd3_((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) n, (void *) p, (void *) k, (void *) l, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) alpha, (void *) beta, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) info, jobu_len, jobv_len, jobq_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cggsvp3 = 0;
#endif

/* Wrapper for cggsvp3 */
void FC_GLOBAL(cggsvp3,CGGSVP3)
    (char *jobu, char *jobv, char *jobq, blasint *m, blasint *p, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *tola, float *tolb, blasint *k, blasint *l, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, lapack_complex_float *q, blasint *ldq, blasint *iwork, float *rwork, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len)
{
    void (*fn) (void *jobu, void *jobv, void *jobq, void *m, void *p, void *n, void *a, void *lda, void *b, void *ldb, void *tola, void *tolb, void *k, void *l, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *iwork, void *rwork, void *tau, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobu, void *jobv, void *jobq, void *m, void *p, void *n, void *a, void *lda, void *b, void *ldb, void *tola, void *tolb, void *k, void *l, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *iwork, void *rwork, void *tau, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len);
    hook_pos_cggsvp3 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cggsvp3;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cggsvp3.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) tola, (void *) tolb, (void *) k, (void *) l, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) iwork, (void *) rwork, (void *) tau, (void *) work, (void *) lwork, (void *) info, jobu_len, jobv_len, jobq_len);
    } else {
        fn((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) tola, (void *) tolb, (void *) k, (void *) l, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) iwork, (void *) rwork, (void *) tau, (void *) work, (void *) lwork, (void *) info, jobu_len, jobv_len, jobq_len);
    }
    #else
    fn((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) tola, (void *) tolb, (void *) k, (void *) l, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) iwork, (void *) rwork, (void *) tau, (void *) work, (void *) lwork, (void *) info, jobu_len, jobv_len, jobq_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cggsvp3,CGGSVP3)(char *jobu, char *jobv, char *jobq, blasint *m, blasint *p, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *tola, float *tolb, blasint *k, blasint *l, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, lapack_complex_float *q, blasint *ldq, blasint *iwork, float *rwork, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len) __attribute__((alias(MTS(FC_GLOBAL(cggsvp3,CGGSVP3)))));
void FC_GLOBAL3(cggsvp3,CGGSVP3)(char *jobu, char *jobv, char *jobq, blasint *m, blasint *p, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *tola, float *tolb, blasint *k, blasint *l, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, lapack_complex_float *q, blasint *ldq, blasint *iwork, float *rwork, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len) __attribute__((alias(MTS(FC_GLOBAL(cggsvp3,CGGSVP3)))));
#else
void FC_GLOBAL2(cggsvp3,CGGSVP3)(char *jobu, char *jobv, char *jobq, blasint *m, blasint *p, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *tola, float *tolb, blasint *k, blasint *l, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, lapack_complex_float *q, blasint *ldq, blasint *iwork, float *rwork, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len)
{
    FC_GLOBAL(cggsvp3,CGGSVP3)((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) tola, (void *) tolb, (void *) k, (void *) l, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) iwork, (void *) rwork, (void *) tau, (void *) work, (void *) lwork, (void *) info, jobu_len, jobv_len, jobq_len);
}
void FC_GLOBAL3(cggsvp3,CGGSVP3)(char *jobu, char *jobv, char *jobq, blasint *m, blasint *p, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *tola, float *tolb, blasint *k, blasint *l, lapack_complex_float *u, blasint *ldu, lapack_complex_float *v, blasint *ldv, lapack_complex_float *q, blasint *ldq, blasint *iwork, float *rwork, lapack_complex_float *tau, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len)
{
    FC_GLOBAL(cggsvp3,CGGSVP3)((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) tola, (void *) tolb, (void *) k, (void *) l, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) iwork, (void *) rwork, (void *) tau, (void *) work, (void *) lwork, (void *) info, jobu_len, jobv_len, jobq_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cggsvp3_(void *jobu, void *jobv, void *jobq, void *m, void *p, void *n, void *a, void *lda, void *b, void *ldb, void *tola, void *tolb, void *k, void *l, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *iwork, void *rwork, void *tau, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len)
{
    void (*fn) (void *jobu, void *jobv, void *jobq, void *m, void *p, void *n, void *a, void *lda, void *b, void *ldb, void *tola, void *tolb, void *k, void *l, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *iwork, void *rwork, void *tau, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len);
    *(void **) &fn = current_backend->lapack.cggsvp3;
    fn((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) tola, (void *) tolb, (void *) k, (void *) l, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) iwork, (void *) rwork, (void *) tau, (void *) work, (void *) lwork, (void *) info, jobu_len, jobv_len, jobq_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cggsvp3(void *jobu, void *jobv, void *jobq, void *m, void *p, void *n, void *a, void *lda, void *b, void *ldb, void *tola, void *tolb, void *k, void *l, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *iwork, void *rwork, void *tau, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len) __attribute__((alias("flexiblas_real_cggsvp3_")));
#else
void flexiblas_real_cggsvp3(void *jobu, void *jobv, void *jobq, void *m, void *p, void *n, void *a, void *lda, void *b, void *ldb, void *tola, void *tolb, void *k, void *l, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *iwork, void *rwork, void *tau, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len)
{
    flexiblas_real_cggsvp3_((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) tola, (void *) tolb, (void *) k, (void *) l, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) iwork, (void *) rwork, (void *) tau, (void *) work, (void *) lwork, (void *) info, jobu_len, jobv_len, jobq_len);
    return;
}
#endif

void flexiblas_chain_cggsvp3_(void *jobu, void *jobv, void *jobq, void *m, void *p, void *n, void *a, void *lda, void *b, void *ldb, void *tola, void *tolb, void *k, void *l, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *iwork, void *rwork, void *tau, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len)
{
    void (*fn) (void *jobu, void *jobv, void *jobq, void *m, void *p, void *n, void *a, void *lda, void *b, void *ldb, void *tola, void *tolb, void *k, void *l, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *iwork, void *rwork, void *tau, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len);
    hook_pos_cggsvp3++;
    if ( hook_pos_cggsvp3 < __flexiblas_hooks->cggsvp3.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cggsvp3.hook_function[hook_pos_cggsvp3];
    } else {
        hook_pos_cggsvp3 = 0;
        *(void **) &fn = current_backend->lapack.cggsvp3;
    }
    fn((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) tola, (void *) tolb, (void *) k, (void *) l, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) iwork, (void *) rwork, (void *) tau, (void *) work, (void *) lwork, (void *) info, jobu_len, jobv_len, jobq_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cggsvp3(void *jobu, void *jobv, void *jobq, void *m, void *p, void *n, void *a, void *lda, void *b, void *ldb, void *tola, void *tolb, void *k, void *l, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *iwork, void *rwork, void *tau, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len) __attribute__((alias("flexiblas_chain_cggsvp3_")));
#else
void flexiblas_chain_cggsvp3(void *jobu, void *jobv, void *jobq, void *m, void *p, void *n, void *a, void *lda, void *b, void *ldb, void *tola, void *tolb, void *k, void *l, void *u, void *ldu, void *v, void *ldv, void *q, void *ldq, void *iwork, void *rwork, void *tau, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobu_len, flexiblas_fortran_charlen_t jobv_len, flexiblas_fortran_charlen_t jobq_len)
{
    flexiblas_chain_cggsvp3_((void *) jobu, (void *) jobv, (void *) jobq, (void *) m, (void *) p, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) tola, (void *) tolb, (void *) k, (void *) l, (void *) u, (void *) ldu, (void *) v, (void *) ldv, (void *) q, (void *) ldq, (void *) iwork, (void *) rwork, (void *) tau, (void *) work, (void *) lwork, (void *) info, jobu_len, jobv_len, jobq_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgsvj0 = 0;
#endif

/* Wrapper for cgsvj0 */
void FC_GLOBAL(cgsvj0,CGSVJ0)
    (char *jobv, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *d, float *sva, blasint *mv, lapack_complex_float *v, blasint *ldv, float *eps, float *sfmin, float *tol, blasint *nsweep, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t jobv_len)
{
    void (*fn) (void *jobv, void *m, void *n, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobv, void *m, void *n, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len);
    hook_pos_cgsvj0 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgsvj0;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgsvj0.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
    } else {
        fn((void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
    }
    #else
    fn((void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgsvj0,CGSVJ0)(char *jobv, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *d, float *sva, blasint *mv, lapack_complex_float *v, blasint *ldv, float *eps, float *sfmin, float *tol, blasint *nsweep, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t jobv_len) __attribute__((alias(MTS(FC_GLOBAL(cgsvj0,CGSVJ0)))));
void FC_GLOBAL3(cgsvj0,CGSVJ0)(char *jobv, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *d, float *sva, blasint *mv, lapack_complex_float *v, blasint *ldv, float *eps, float *sfmin, float *tol, blasint *nsweep, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t jobv_len) __attribute__((alias(MTS(FC_GLOBAL(cgsvj0,CGSVJ0)))));
#else
void FC_GLOBAL2(cgsvj0,CGSVJ0)(char *jobv, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *d, float *sva, blasint *mv, lapack_complex_float *v, blasint *ldv, float *eps, float *sfmin, float *tol, blasint *nsweep, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t jobv_len)
{
    FC_GLOBAL(cgsvj0,CGSVJ0)((void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
}
void FC_GLOBAL3(cgsvj0,CGSVJ0)(char *jobv, blasint *m, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *d, float *sva, blasint *mv, lapack_complex_float *v, blasint *ldv, float *eps, float *sfmin, float *tol, blasint *nsweep, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t jobv_len)
{
    FC_GLOBAL(cgsvj0,CGSVJ0)((void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgsvj0_(void *jobv, void *m, void *n, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len)
{
    void (*fn) (void *jobv, void *m, void *n, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len);
    *(void **) &fn = current_backend->lapack.cgsvj0;
    fn((void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgsvj0(void *jobv, void *m, void *n, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len) __attribute__((alias("flexiblas_real_cgsvj0_")));
#else
void flexiblas_real_cgsvj0(void *jobv, void *m, void *n, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len)
{
    flexiblas_real_cgsvj0_((void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
    return;
}
#endif

void flexiblas_chain_cgsvj0_(void *jobv, void *m, void *n, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len)
{
    void (*fn) (void *jobv, void *m, void *n, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len);
    hook_pos_cgsvj0++;
    if ( hook_pos_cgsvj0 < __flexiblas_hooks->cgsvj0.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgsvj0.hook_function[hook_pos_cgsvj0];
    } else {
        hook_pos_cgsvj0 = 0;
        *(void **) &fn = current_backend->lapack.cgsvj0;
    }
    fn((void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgsvj0(void *jobv, void *m, void *n, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len) __attribute__((alias("flexiblas_chain_cgsvj0_")));
#else
void flexiblas_chain_cgsvj0(void *jobv, void *m, void *n, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len)
{
    flexiblas_chain_cgsvj0_((void *) jobv, (void *) m, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgsvj1 = 0;
#endif

/* Wrapper for cgsvj1 */
void FC_GLOBAL(cgsvj1,CGSVJ1)
    (char *jobv, blasint *m, blasint *n, blasint *n1, lapack_complex_float *a, blasint *lda, lapack_complex_float *d, float *sva, blasint *mv, lapack_complex_float *v, blasint *ldv, float *eps, float *sfmin, float *tol, blasint *nsweep, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t jobv_len)
{
    void (*fn) (void *jobv, void *m, void *n, void *n1, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobv, void *m, void *n, void *n1, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len);
    hook_pos_cgsvj1 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgsvj1;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgsvj1.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobv, (void *) m, (void *) n, (void *) n1, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
    } else {
        fn((void *) jobv, (void *) m, (void *) n, (void *) n1, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
    }
    #else
    fn((void *) jobv, (void *) m, (void *) n, (void *) n1, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgsvj1,CGSVJ1)(char *jobv, blasint *m, blasint *n, blasint *n1, lapack_complex_float *a, blasint *lda, lapack_complex_float *d, float *sva, blasint *mv, lapack_complex_float *v, blasint *ldv, float *eps, float *sfmin, float *tol, blasint *nsweep, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t jobv_len) __attribute__((alias(MTS(FC_GLOBAL(cgsvj1,CGSVJ1)))));
void FC_GLOBAL3(cgsvj1,CGSVJ1)(char *jobv, blasint *m, blasint *n, blasint *n1, lapack_complex_float *a, blasint *lda, lapack_complex_float *d, float *sva, blasint *mv, lapack_complex_float *v, blasint *ldv, float *eps, float *sfmin, float *tol, blasint *nsweep, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t jobv_len) __attribute__((alias(MTS(FC_GLOBAL(cgsvj1,CGSVJ1)))));
#else
void FC_GLOBAL2(cgsvj1,CGSVJ1)(char *jobv, blasint *m, blasint *n, blasint *n1, lapack_complex_float *a, blasint *lda, lapack_complex_float *d, float *sva, blasint *mv, lapack_complex_float *v, blasint *ldv, float *eps, float *sfmin, float *tol, blasint *nsweep, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t jobv_len)
{
    FC_GLOBAL(cgsvj1,CGSVJ1)((void *) jobv, (void *) m, (void *) n, (void *) n1, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
}
void FC_GLOBAL3(cgsvj1,CGSVJ1)(char *jobv, blasint *m, blasint *n, blasint *n1, lapack_complex_float *a, blasint *lda, lapack_complex_float *d, float *sva, blasint *mv, lapack_complex_float *v, blasint *ldv, float *eps, float *sfmin, float *tol, blasint *nsweep, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t jobv_len)
{
    FC_GLOBAL(cgsvj1,CGSVJ1)((void *) jobv, (void *) m, (void *) n, (void *) n1, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgsvj1_(void *jobv, void *m, void *n, void *n1, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len)
{
    void (*fn) (void *jobv, void *m, void *n, void *n1, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len);
    *(void **) &fn = current_backend->lapack.cgsvj1;
    fn((void *) jobv, (void *) m, (void *) n, (void *) n1, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgsvj1(void *jobv, void *m, void *n, void *n1, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len) __attribute__((alias("flexiblas_real_cgsvj1_")));
#else
void flexiblas_real_cgsvj1(void *jobv, void *m, void *n, void *n1, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len)
{
    flexiblas_real_cgsvj1_((void *) jobv, (void *) m, (void *) n, (void *) n1, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
    return;
}
#endif

void flexiblas_chain_cgsvj1_(void *jobv, void *m, void *n, void *n1, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len)
{
    void (*fn) (void *jobv, void *m, void *n, void *n1, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len);
    hook_pos_cgsvj1++;
    if ( hook_pos_cgsvj1 < __flexiblas_hooks->cgsvj1.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgsvj1.hook_function[hook_pos_cgsvj1];
    } else {
        hook_pos_cgsvj1 = 0;
        *(void **) &fn = current_backend->lapack.cgsvj1;
    }
    fn((void *) jobv, (void *) m, (void *) n, (void *) n1, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgsvj1(void *jobv, void *m, void *n, void *n1, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len) __attribute__((alias("flexiblas_chain_cgsvj1_")));
#else
void flexiblas_chain_cgsvj1(void *jobv, void *m, void *n, void *n1, void *a, void *lda, void *d, void *sva, void *mv, void *v, void *ldv, void *eps, void *sfmin, void *tol, void *nsweep, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t jobv_len)
{
    flexiblas_chain_cgsvj1_((void *) jobv, (void *) m, (void *) n, (void *) n1, (void *) a, (void *) lda, (void *) d, (void *) sva, (void *) mv, (void *) v, (void *) ldv, (void *) eps, (void *) sfmin, (void *) tol, (void *) nsweep, (void *) work, (void *) lwork, (void *) info, jobv_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgtcon = 0;
#endif

/* Wrapper for cgtcon */
void FC_GLOBAL(cgtcon,CGTCON)
    (char *norm, blasint *n, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t norm_len)
{
    void (*fn) (void *norm, void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t norm_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *norm, void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t norm_len);
    hook_pos_cgtcon = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgtcon;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgtcon.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) norm, (void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, norm_len);
    } else {
        fn((void *) norm, (void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, norm_len);
    }
    #else
    fn((void *) norm, (void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, norm_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgtcon,CGTCON)(char *norm, blasint *n, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t norm_len) __attribute__((alias(MTS(FC_GLOBAL(cgtcon,CGTCON)))));
void FC_GLOBAL3(cgtcon,CGTCON)(char *norm, blasint *n, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t norm_len) __attribute__((alias(MTS(FC_GLOBAL(cgtcon,CGTCON)))));
#else
void FC_GLOBAL2(cgtcon,CGTCON)(char *norm, blasint *n, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t norm_len)
{
    FC_GLOBAL(cgtcon,CGTCON)((void *) norm, (void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, norm_len);
}
void FC_GLOBAL3(cgtcon,CGTCON)(char *norm, blasint *n, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t norm_len)
{
    FC_GLOBAL(cgtcon,CGTCON)((void *) norm, (void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, norm_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgtcon_(void *norm, void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t norm_len)
{
    void (*fn) (void *norm, void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t norm_len);
    *(void **) &fn = current_backend->lapack.cgtcon;
    fn((void *) norm, (void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, norm_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgtcon(void *norm, void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t norm_len) __attribute__((alias("flexiblas_real_cgtcon_")));
#else
void flexiblas_real_cgtcon(void *norm, void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t norm_len)
{
    flexiblas_real_cgtcon_((void *) norm, (void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, norm_len);
    return;
}
#endif

void flexiblas_chain_cgtcon_(void *norm, void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t norm_len)
{
    void (*fn) (void *norm, void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t norm_len);
    hook_pos_cgtcon++;
    if ( hook_pos_cgtcon < __flexiblas_hooks->cgtcon.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgtcon.hook_function[hook_pos_cgtcon];
    } else {
        hook_pos_cgtcon = 0;
        *(void **) &fn = current_backend->lapack.cgtcon;
    }
    fn((void *) norm, (void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, norm_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgtcon(void *norm, void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t norm_len) __attribute__((alias("flexiblas_chain_cgtcon_")));
#else
void flexiblas_chain_cgtcon(void *norm, void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t norm_len)
{
    flexiblas_chain_cgtcon_((void *) norm, (void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, norm_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgtrfs = 0;
#endif

/* Wrapper for cgtrfs */
void FC_GLOBAL(cgtrfs,CGTRFS)
    (char *trans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *dlf, lapack_complex_float *df, lapack_complex_float *duf, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgtrfs = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgtrfs;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgtrfs.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    } else {
        fn((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    }
    #else
    fn((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgtrfs,CGTRFS)(char *trans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *dlf, lapack_complex_float *df, lapack_complex_float *duf, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgtrfs,CGTRFS)))));
void FC_GLOBAL3(cgtrfs,CGTRFS)(char *trans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *dlf, lapack_complex_float *df, lapack_complex_float *duf, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgtrfs,CGTRFS)))));
#else
void FC_GLOBAL2(cgtrfs,CGTRFS)(char *trans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *dlf, lapack_complex_float *df, lapack_complex_float *duf, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgtrfs,CGTRFS)((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
}
void FC_GLOBAL3(cgtrfs,CGTRFS)(char *trans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *dlf, lapack_complex_float *df, lapack_complex_float *duf, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgtrfs,CGTRFS)((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgtrfs_(void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len);
    *(void **) &fn = current_backend->lapack.cgtrfs;
    fn((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgtrfs(void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_real_cgtrfs_")));
#else
void flexiblas_real_cgtrfs(void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_real_cgtrfs_((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    return;
}
#endif

void flexiblas_chain_cgtrfs_(void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgtrfs++;
    if ( hook_pos_cgtrfs < __flexiblas_hooks->cgtrfs.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgtrfs.hook_function[hook_pos_cgtrfs];
    } else {
        hook_pos_cgtrfs = 0;
        *(void **) &fn = current_backend->lapack.cgtrfs;
    }
    fn((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgtrfs(void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_chain_cgtrfs_")));
#else
void flexiblas_chain_cgtrfs(void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_chain_cgtrfs_((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, trans_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgtsv = 0;
#endif

/* Wrapper for cgtsv */
void FC_GLOBAL(cgtsv,CGTSV)
    (blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *b, blasint *ldb, blasint *info)
{
    void (*fn) (void *n, void *nrhs, void *dl, void *d, void *du, void *b, void *ldb, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *n, void *nrhs, void *dl, void *d, void *du, void *b, void *ldb, void *info);
    hook_pos_cgtsv = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgtsv;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgtsv.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) b, (void *) ldb, (void *) info);
    } else {
        fn((void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) b, (void *) ldb, (void *) info);
    }
    #else
    fn((void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) b, (void *) ldb, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgtsv,CGTSV)(blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *b, blasint *ldb, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgtsv,CGTSV)))));
void FC_GLOBAL3(cgtsv,CGTSV)(blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *b, blasint *ldb, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgtsv,CGTSV)))));
#else
void FC_GLOBAL2(cgtsv,CGTSV)(blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *b, blasint *ldb, blasint *info)
{
    FC_GLOBAL(cgtsv,CGTSV)((void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) b, (void *) ldb, (void *) info);
}
void FC_GLOBAL3(cgtsv,CGTSV)(blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *b, blasint *ldb, blasint *info)
{
    FC_GLOBAL(cgtsv,CGTSV)((void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) b, (void *) ldb, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgtsv_(void *n, void *nrhs, void *dl, void *d, void *du, void *b, void *ldb, void *info)
{
    void (*fn) (void *n, void *nrhs, void *dl, void *d, void *du, void *b, void *ldb, void *info);
    *(void **) &fn = current_backend->lapack.cgtsv;
    fn((void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) b, (void *) ldb, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgtsv(void *n, void *nrhs, void *dl, void *d, void *du, void *b, void *ldb, void *info) __attribute__((alias("flexiblas_real_cgtsv_")));
#else
void flexiblas_real_cgtsv(void *n, void *nrhs, void *dl, void *d, void *du, void *b, void *ldb, void *info)
{
    flexiblas_real_cgtsv_((void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) b, (void *) ldb, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgtsv_(void *n, void *nrhs, void *dl, void *d, void *du, void *b, void *ldb, void *info)
{
    void (*fn) (void *n, void *nrhs, void *dl, void *d, void *du, void *b, void *ldb, void *info);
    hook_pos_cgtsv++;
    if ( hook_pos_cgtsv < __flexiblas_hooks->cgtsv.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgtsv.hook_function[hook_pos_cgtsv];
    } else {
        hook_pos_cgtsv = 0;
        *(void **) &fn = current_backend->lapack.cgtsv;
    }
    fn((void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) b, (void *) ldb, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgtsv(void *n, void *nrhs, void *dl, void *d, void *du, void *b, void *ldb, void *info) __attribute__((alias("flexiblas_chain_cgtsv_")));
#else
void flexiblas_chain_cgtsv(void *n, void *nrhs, void *dl, void *d, void *du, void *b, void *ldb, void *info)
{
    flexiblas_chain_cgtsv_((void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) b, (void *) ldb, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgtsvx = 0;
#endif

/* Wrapper for cgtsvx */
void FC_GLOBAL(cgtsvx,CGTSVX)
    (char *fact, char *trans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *dlf, lapack_complex_float *df, lapack_complex_float *duf, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *fact, void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *fact, void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgtsvx = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgtsvx;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgtsvx.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len);
    } else {
        fn((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len);
    }
    #else
    fn((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgtsvx,CGTSVX)(char *fact, char *trans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *dlf, lapack_complex_float *df, lapack_complex_float *duf, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgtsvx,CGTSVX)))));
void FC_GLOBAL3(cgtsvx,CGTSVX)(char *fact, char *trans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *dlf, lapack_complex_float *df, lapack_complex_float *duf, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgtsvx,CGTSVX)))));
#else
void FC_GLOBAL2(cgtsvx,CGTSVX)(char *fact, char *trans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *dlf, lapack_complex_float *df, lapack_complex_float *duf, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgtsvx,CGTSVX)((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len);
}
void FC_GLOBAL3(cgtsvx,CGTSVX)(char *fact, char *trans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *dlf, lapack_complex_float *df, lapack_complex_float *duf, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgtsvx,CGTSVX)((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgtsvx_(void *fact, void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *fact, void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len);
    *(void **) &fn = current_backend->lapack.cgtsvx;
    fn((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgtsvx(void *fact, void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_real_cgtsvx_")));
#else
void flexiblas_real_cgtsvx(void *fact, void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_real_cgtsvx_((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len);
    return;
}
#endif

void flexiblas_chain_cgtsvx_(void *fact, void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *fact, void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgtsvx++;
    if ( hook_pos_cgtsvx < __flexiblas_hooks->cgtsvx.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgtsvx.hook_function[hook_pos_cgtsvx];
    } else {
        hook_pos_cgtsvx = 0;
        *(void **) &fn = current_backend->lapack.cgtsvx;
    }
    fn((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgtsvx(void *fact, void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_chain_cgtsvx_")));
#else
void flexiblas_chain_cgtsvx(void *fact, void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *dlf, void *df, void *duf, void *du2, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_chain_cgtsvx_((void *) fact, (void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) dlf, (void *) df, (void *) duf, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, fact_len, trans_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgttrf = 0;
#endif

/* Wrapper for cgttrf */
void FC_GLOBAL(cgttrf,CGTTRF)
    (blasint *n, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, blasint *info)
{
    void (*fn) (void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *info);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *info);
    hook_pos_cgttrf = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgttrf;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgttrf.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) info);
    } else {
        fn((void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) info);
    }
    #else
    fn((void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) info);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgttrf,CGTTRF)(blasint *n, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgttrf,CGTTRF)))));
void FC_GLOBAL3(cgttrf,CGTTRF)(blasint *n, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, blasint *info) __attribute__((alias(MTS(FC_GLOBAL(cgttrf,CGTTRF)))));
#else
void FC_GLOBAL2(cgttrf,CGTTRF)(blasint *n, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, blasint *info)
{
    FC_GLOBAL(cgttrf,CGTTRF)((void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) info);
}
void FC_GLOBAL3(cgttrf,CGTTRF)(blasint *n, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, blasint *info)
{
    FC_GLOBAL(cgttrf,CGTTRF)((void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) info);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgttrf_(void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *info)
{
    void (*fn) (void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *info);
    *(void **) &fn = current_backend->lapack.cgttrf;
    fn((void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgttrf(void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *info) __attribute__((alias("flexiblas_real_cgttrf_")));
#else
void flexiblas_real_cgttrf(void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *info)
{
    flexiblas_real_cgttrf_((void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) info);
    return;
}
#endif

void flexiblas_chain_cgttrf_(void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *info)
{
    void (*fn) (void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *info);
    hook_pos_cgttrf++;
    if ( hook_pos_cgttrf < __flexiblas_hooks->cgttrf.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgttrf.hook_function[hook_pos_cgttrf];
    } else {
        hook_pos_cgttrf = 0;
        *(void **) &fn = current_backend->lapack.cgttrf;
    }
    fn((void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) info);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgttrf(void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *info) __attribute__((alias("flexiblas_chain_cgttrf_")));
#else
void flexiblas_chain_cgttrf(void *n, void *dl, void *d, void *du, void *du2, void *ipiv, void *info)
{
    flexiblas_chain_cgttrf_((void *) n, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) info);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgttrs = 0;
#endif

/* Wrapper for cgttrs */
void FC_GLOBAL(cgttrs,CGTTRS)
    (char *trans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgttrs = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgttrs;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgttrs.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    } else {
        fn((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    }
    #else
    fn((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgttrs,CGTTRS)(char *trans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgttrs,CGTTRS)))));
void FC_GLOBAL3(cgttrs,CGTTRS)(char *trans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias(MTS(FC_GLOBAL(cgttrs,CGTTRS)))));
#else
void FC_GLOBAL2(cgttrs,CGTTRS)(char *trans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgttrs,CGTTRS)((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
}
void FC_GLOBAL3(cgttrs,CGTTRS)(char *trans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t trans_len)
{
    FC_GLOBAL(cgttrs,CGTTRS)((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgttrs_(void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len);
    *(void **) &fn = current_backend->lapack.cgttrs;
    fn((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgttrs(void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_real_cgttrs_")));
#else
void flexiblas_real_cgttrs(void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_real_cgttrs_((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    return;
}
#endif

void flexiblas_chain_cgttrs_(void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len)
{
    void (*fn) (void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len);
    hook_pos_cgttrs++;
    if ( hook_pos_cgttrs < __flexiblas_hooks->cgttrs.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgttrs.hook_function[hook_pos_cgttrs];
    } else {
        hook_pos_cgttrs = 0;
        *(void **) &fn = current_backend->lapack.cgttrs;
    }
    fn((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgttrs(void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len) __attribute__((alias("flexiblas_chain_cgttrs_")));
#else
void flexiblas_chain_cgttrs(void *trans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t trans_len)
{
    flexiblas_chain_cgttrs_((void *) trans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb, (void *) info, trans_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cgtts2 = 0;
#endif

/* Wrapper for cgtts2 */
void FC_GLOBAL(cgtts2,CGTTS2)
    (blasint *itrans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb)
{
    void (*fn) (void *itrans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *itrans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb);
    hook_pos_cgtts2 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cgtts2;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cgtts2.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) itrans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb);
    } else {
        fn((void *) itrans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb);
    }
    #else
    fn((void *) itrans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cgtts2,CGTTS2)(blasint *itrans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb) __attribute__((alias(MTS(FC_GLOBAL(cgtts2,CGTTS2)))));
void FC_GLOBAL3(cgtts2,CGTTS2)(blasint *itrans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb) __attribute__((alias(MTS(FC_GLOBAL(cgtts2,CGTTS2)))));
#else
void FC_GLOBAL2(cgtts2,CGTTS2)(blasint *itrans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb)
{
    FC_GLOBAL(cgtts2,CGTTS2)((void *) itrans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb);
}
void FC_GLOBAL3(cgtts2,CGTTS2)(blasint *itrans, blasint *n, blasint *nrhs, lapack_complex_float *dl, lapack_complex_float *d, lapack_complex_float *du, lapack_complex_float *du2, blasint *ipiv, lapack_complex_float *b, blasint *ldb)
{
    FC_GLOBAL(cgtts2,CGTTS2)((void *) itrans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cgtts2_(void *itrans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb)
{
    void (*fn) (void *itrans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb);
    *(void **) &fn = current_backend->lapack.cgtts2;
    fn((void *) itrans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cgtts2(void *itrans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb) __attribute__((alias("flexiblas_real_cgtts2_")));
#else
void flexiblas_real_cgtts2(void *itrans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb)
{
    flexiblas_real_cgtts2_((void *) itrans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb);
    return;
}
#endif

void flexiblas_chain_cgtts2_(void *itrans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb)
{
    void (*fn) (void *itrans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb);
    hook_pos_cgtts2++;
    if ( hook_pos_cgtts2 < __flexiblas_hooks->cgtts2.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cgtts2.hook_function[hook_pos_cgtts2];
    } else {
        hook_pos_cgtts2 = 0;
        *(void **) &fn = current_backend->lapack.cgtts2;
    }
    fn((void *) itrans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cgtts2(void *itrans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb) __attribute__((alias("flexiblas_chain_cgtts2_")));
#else
void flexiblas_chain_cgtts2(void *itrans, void *n, void *nrhs, void *dl, void *d, void *du, void *du2, void *ipiv, void *b, void *ldb)
{
    flexiblas_chain_cgtts2_((void *) itrans, (void *) n, (void *) nrhs, (void *) dl, (void *) d, (void *) du, (void *) du2, (void *) ipiv, (void *) b, (void *) ldb);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chb2st_kernels = 0;
#endif

/* Wrapper for chb2st_kernels */
void FC_GLOBAL(chb2st_kernels,CHB2ST_KERNELS)
    (char *uplo, blaslogical *wantz, blasint *ttype, blasint *st, blasint *ed, blasint *sweep, blasint *n, blasint *nb, blasint *ib, lapack_complex_float *a, blasint *lda, lapack_complex_float *v, lapack_complex_float *tau, blasint *ldvt, lapack_complex_float *work, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *wantz, void *ttype, void *st, void *ed, void *sweep, void *n, void *nb, void *ib, void *a, void *lda, void *v, void *tau, void *ldvt, void *work, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *uplo, void *wantz, void *ttype, void *st, void *ed, void *sweep, void *n, void *nb, void *ib, void *a, void *lda, void *v, void *tau, void *ldvt, void *work, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chb2st_kernels = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chb2st_kernels;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chb2st_kernels.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) uplo, (void *) wantz, (void *) ttype, (void *) st, (void *) ed, (void *) sweep, (void *) n, (void *) nb, (void *) ib, (void *) a, (void *) lda, (void *) v, (void *) tau, (void *) ldvt, (void *) work, uplo_len);
    } else {
        fn((void *) uplo, (void *) wantz, (void *) ttype, (void *) st, (void *) ed, (void *) sweep, (void *) n, (void *) nb, (void *) ib, (void *) a, (void *) lda, (void *) v, (void *) tau, (void *) ldvt, (void *) work, uplo_len);
    }
    #else
    fn((void *) uplo, (void *) wantz, (void *) ttype, (void *) st, (void *) ed, (void *) sweep, (void *) n, (void *) nb, (void *) ib, (void *) a, (void *) lda, (void *) v, (void *) tau, (void *) ldvt, (void *) work, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chb2st_kernels,CHB2ST_KERNELS)(char *uplo, blaslogical *wantz, blasint *ttype, blasint *st, blasint *ed, blasint *sweep, blasint *n, blasint *nb, blasint *ib, lapack_complex_float *a, blasint *lda, lapack_complex_float *v, lapack_complex_float *tau, blasint *ldvt, lapack_complex_float *work, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chb2st_kernels,CHB2ST_KERNELS)))));
void FC_GLOBAL3(chb2st_kernels,CHB2ST_KERNELS)(char *uplo, blaslogical *wantz, blasint *ttype, blasint *st, blasint *ed, blasint *sweep, blasint *n, blasint *nb, blasint *ib, lapack_complex_float *a, blasint *lda, lapack_complex_float *v, lapack_complex_float *tau, blasint *ldvt, lapack_complex_float *work, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chb2st_kernels,CHB2ST_KERNELS)))));
#else
void FC_GLOBAL2(chb2st_kernels,CHB2ST_KERNELS)(char *uplo, blaslogical *wantz, blasint *ttype, blasint *st, blasint *ed, blasint *sweep, blasint *n, blasint *nb, blasint *ib, lapack_complex_float *a, blasint *lda, lapack_complex_float *v, lapack_complex_float *tau, blasint *ldvt, lapack_complex_float *work, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chb2st_kernels,CHB2ST_KERNELS)((void *) uplo, (void *) wantz, (void *) ttype, (void *) st, (void *) ed, (void *) sweep, (void *) n, (void *) nb, (void *) ib, (void *) a, (void *) lda, (void *) v, (void *) tau, (void *) ldvt, (void *) work, uplo_len);
}
void FC_GLOBAL3(chb2st_kernels,CHB2ST_KERNELS)(char *uplo, blaslogical *wantz, blasint *ttype, blasint *st, blasint *ed, blasint *sweep, blasint *n, blasint *nb, blasint *ib, lapack_complex_float *a, blasint *lda, lapack_complex_float *v, lapack_complex_float *tau, blasint *ldvt, lapack_complex_float *work, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chb2st_kernels,CHB2ST_KERNELS)((void *) uplo, (void *) wantz, (void *) ttype, (void *) st, (void *) ed, (void *) sweep, (void *) n, (void *) nb, (void *) ib, (void *) a, (void *) lda, (void *) v, (void *) tau, (void *) ldvt, (void *) work, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chb2st_kernels_(void *uplo, void *wantz, void *ttype, void *st, void *ed, void *sweep, void *n, void *nb, void *ib, void *a, void *lda, void *v, void *tau, void *ldvt, void *work, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *wantz, void *ttype, void *st, void *ed, void *sweep, void *n, void *nb, void *ib, void *a, void *lda, void *v, void *tau, void *ldvt, void *work, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chb2st_kernels;
    fn((void *) uplo, (void *) wantz, (void *) ttype, (void *) st, (void *) ed, (void *) sweep, (void *) n, (void *) nb, (void *) ib, (void *) a, (void *) lda, (void *) v, (void *) tau, (void *) ldvt, (void *) work, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chb2st_kernels(void *uplo, void *wantz, void *ttype, void *st, void *ed, void *sweep, void *n, void *nb, void *ib, void *a, void *lda, void *v, void *tau, void *ldvt, void *work, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chb2st_kernels_")));
#else
void flexiblas_real_chb2st_kernels(void *uplo, void *wantz, void *ttype, void *st, void *ed, void *sweep, void *n, void *nb, void *ib, void *a, void *lda, void *v, void *tau, void *ldvt, void *work, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chb2st_kernels_((void *) uplo, (void *) wantz, (void *) ttype, (void *) st, (void *) ed, (void *) sweep, (void *) n, (void *) nb, (void *) ib, (void *) a, (void *) lda, (void *) v, (void *) tau, (void *) ldvt, (void *) work, uplo_len);
    return;
}
#endif

void flexiblas_chain_chb2st_kernels_(void *uplo, void *wantz, void *ttype, void *st, void *ed, void *sweep, void *n, void *nb, void *ib, void *a, void *lda, void *v, void *tau, void *ldvt, void *work, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *wantz, void *ttype, void *st, void *ed, void *sweep, void *n, void *nb, void *ib, void *a, void *lda, void *v, void *tau, void *ldvt, void *work, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chb2st_kernels++;
    if ( hook_pos_chb2st_kernels < __flexiblas_hooks->chb2st_kernels.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chb2st_kernels.hook_function[hook_pos_chb2st_kernels];
    } else {
        hook_pos_chb2st_kernels = 0;
        *(void **) &fn = current_backend->lapack.chb2st_kernels;
    }
    fn((void *) uplo, (void *) wantz, (void *) ttype, (void *) st, (void *) ed, (void *) sweep, (void *) n, (void *) nb, (void *) ib, (void *) a, (void *) lda, (void *) v, (void *) tau, (void *) ldvt, (void *) work, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chb2st_kernels(void *uplo, void *wantz, void *ttype, void *st, void *ed, void *sweep, void *n, void *nb, void *ib, void *a, void *lda, void *v, void *tau, void *ldvt, void *work, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chb2st_kernels_")));
#else
void flexiblas_chain_chb2st_kernels(void *uplo, void *wantz, void *ttype, void *st, void *ed, void *sweep, void *n, void *nb, void *ib, void *a, void *lda, void *v, void *tau, void *ldvt, void *work, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chb2st_kernels_((void *) uplo, (void *) wantz, (void *) ttype, (void *) st, (void *) ed, (void *) sweep, (void *) n, (void *) nb, (void *) ib, (void *) a, (void *) lda, (void *) v, (void *) tau, (void *) ldvt, (void *) work, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chbev = 0;
#endif

/* Wrapper for chbev */
void FC_GLOBAL(chbev,CHBEV)
    (char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbev = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chbev;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chbev.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chbev,CHBEV)(char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbev,CHBEV)))));
void FC_GLOBAL3(chbev,CHBEV)(char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbev,CHBEV)))));
#else
void FC_GLOBAL2(chbev,CHBEV)(char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbev,CHBEV)((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
}
void FC_GLOBAL3(chbev,CHBEV)(char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbev,CHBEV)((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chbev_(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chbev;
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chbev(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chbev_")));
#else
void flexiblas_real_chbev(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chbev_((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_chbev_(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbev++;
    if ( hook_pos_chbev < __flexiblas_hooks->chbev.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chbev.hook_function[hook_pos_chbev];
    } else {
        hook_pos_chbev = 0;
        *(void **) &fn = current_backend->lapack.chbev;
    }
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chbev(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chbev_")));
#else
void flexiblas_chain_chbev(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chbev_((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chbev_2stage = 0;
#endif

/* Wrapper for chbev_2stage */
void FC_GLOBAL(chbev_2stage,CHBEV_2STAGE)
    (char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbev_2stage = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chbev_2stage;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chbev_2stage.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chbev_2stage,CHBEV_2STAGE)(char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbev_2stage,CHBEV_2STAGE)))));
void FC_GLOBAL3(chbev_2stage,CHBEV_2STAGE)(char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbev_2stage,CHBEV_2STAGE)))));
#else
void FC_GLOBAL2(chbev_2stage,CHBEV_2STAGE)(char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbev_2stage,CHBEV_2STAGE)((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
}
void FC_GLOBAL3(chbev_2stage,CHBEV_2STAGE)(char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbev_2stage,CHBEV_2STAGE)((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chbev_2stage_(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chbev_2stage;
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chbev_2stage(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chbev_2stage_")));
#else
void flexiblas_real_chbev_2stage(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chbev_2stage_((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_chbev_2stage_(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbev_2stage++;
    if ( hook_pos_chbev_2stage < __flexiblas_hooks->chbev_2stage.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chbev_2stage.hook_function[hook_pos_chbev_2stage];
    } else {
        hook_pos_chbev_2stage = 0;
        *(void **) &fn = current_backend->lapack.chbev_2stage;
    }
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chbev_2stage(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chbev_2stage_")));
#else
void flexiblas_chain_chbev_2stage(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chbev_2stage_((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chbevd = 0;
#endif

/* Wrapper for chbevd */
void FC_GLOBAL(chbevd,CHBEVD)
    (char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbevd = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chbevd;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chbevd.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chbevd,CHBEVD)(char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbevd,CHBEVD)))));
void FC_GLOBAL3(chbevd,CHBEVD)(char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbevd,CHBEVD)))));
#else
void FC_GLOBAL2(chbevd,CHBEVD)(char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbevd,CHBEVD)((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
}
void FC_GLOBAL3(chbevd,CHBEVD)(char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbevd,CHBEVD)((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chbevd_(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chbevd;
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chbevd(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chbevd_")));
#else
void flexiblas_real_chbevd(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chbevd_((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_chbevd_(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbevd++;
    if ( hook_pos_chbevd < __flexiblas_hooks->chbevd.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chbevd.hook_function[hook_pos_chbevd];
    } else {
        hook_pos_chbevd = 0;
        *(void **) &fn = current_backend->lapack.chbevd;
    }
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chbevd(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chbevd_")));
#else
void flexiblas_chain_chbevd(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chbevd_((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chbevd_2stage = 0;
#endif

/* Wrapper for chbevd_2stage */
void FC_GLOBAL(chbevd_2stage,CHBEVD_2STAGE)
    (char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbevd_2stage = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chbevd_2stage;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chbevd_2stage.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chbevd_2stage,CHBEVD_2STAGE)(char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbevd_2stage,CHBEVD_2STAGE)))));
void FC_GLOBAL3(chbevd_2stage,CHBEVD_2STAGE)(char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbevd_2stage,CHBEVD_2STAGE)))));
#else
void FC_GLOBAL2(chbevd_2stage,CHBEVD_2STAGE)(char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbevd_2stage,CHBEVD_2STAGE)((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
}
void FC_GLOBAL3(chbevd_2stage,CHBEVD_2STAGE)(char *jobz, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbevd_2stage,CHBEVD_2STAGE)((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chbevd_2stage_(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chbevd_2stage;
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chbevd_2stage(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chbevd_2stage_")));
#else
void flexiblas_real_chbevd_2stage(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chbevd_2stage_((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_chbevd_2stage_(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbevd_2stage++;
    if ( hook_pos_chbevd_2stage < __flexiblas_hooks->chbevd_2stage.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chbevd_2stage.hook_function[hook_pos_chbevd_2stage];
    } else {
        hook_pos_chbevd_2stage = 0;
        *(void **) &fn = current_backend->lapack.chbevd_2stage;
    }
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chbevd_2stage(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chbevd_2stage_")));
#else
void flexiblas_chain_chbevd_2stage(void *jobz, void *uplo, void *n, void *kd, void *ab, void *ldab, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chbevd_2stage_((void *) jobz, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chbevx = 0;
#endif

/* Wrapper for chbevx */
void FC_GLOBAL(chbevx,CHBEVX)
    (char *jobz, char *range, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *q, blasint *ldq, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbevx = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chbevx;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chbevx.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chbevx,CHBEVX)(char *jobz, char *range, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *q, blasint *ldq, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbevx,CHBEVX)))));
void FC_GLOBAL3(chbevx,CHBEVX)(char *jobz, char *range, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *q, blasint *ldq, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbevx,CHBEVX)))));
#else
void FC_GLOBAL2(chbevx,CHBEVX)(char *jobz, char *range, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *q, blasint *ldq, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbevx,CHBEVX)((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
}
void FC_GLOBAL3(chbevx,CHBEVX)(char *jobz, char *range, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *q, blasint *ldq, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbevx,CHBEVX)((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chbevx_(void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chbevx;
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chbevx(void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chbevx_")));
#else
void flexiblas_real_chbevx(void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chbevx_((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_chbevx_(void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbevx++;
    if ( hook_pos_chbevx < __flexiblas_hooks->chbevx.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chbevx.hook_function[hook_pos_chbevx];
    } else {
        hook_pos_chbevx = 0;
        *(void **) &fn = current_backend->lapack.chbevx;
    }
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chbevx(void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chbevx_")));
#else
void flexiblas_chain_chbevx(void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chbevx_((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chbevx_2stage = 0;
#endif

/* Wrapper for chbevx_2stage */
void FC_GLOBAL(chbevx_2stage,CHBEVX_2STAGE)
    (char *jobz, char *range, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *q, blasint *ldq, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbevx_2stage = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chbevx_2stage;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chbevx_2stage.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chbevx_2stage,CHBEVX_2STAGE)(char *jobz, char *range, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *q, blasint *ldq, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbevx_2stage,CHBEVX_2STAGE)))));
void FC_GLOBAL3(chbevx_2stage,CHBEVX_2STAGE)(char *jobz, char *range, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *q, blasint *ldq, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbevx_2stage,CHBEVX_2STAGE)))));
#else
void FC_GLOBAL2(chbevx_2stage,CHBEVX_2STAGE)(char *jobz, char *range, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *q, blasint *ldq, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbevx_2stage,CHBEVX_2STAGE)((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
}
void FC_GLOBAL3(chbevx_2stage,CHBEVX_2STAGE)(char *jobz, char *range, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *q, blasint *ldq, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbevx_2stage,CHBEVX_2STAGE)((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chbevx_2stage_(void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chbevx_2stage;
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chbevx_2stage(void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chbevx_2stage_")));
#else
void flexiblas_real_chbevx_2stage(void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chbevx_2stage_((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_chbevx_2stage_(void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbevx_2stage++;
    if ( hook_pos_chbevx_2stage < __flexiblas_hooks->chbevx_2stage.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chbevx_2stage.hook_function[hook_pos_chbevx_2stage];
    } else {
        hook_pos_chbevx_2stage = 0;
        *(void **) &fn = current_backend->lapack.chbevx_2stage;
    }
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chbevx_2stage(void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chbevx_2stage_")));
#else
void flexiblas_chain_chbevx_2stage(void *jobz, void *range, void *uplo, void *n, void *kd, void *ab, void *ldab, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chbevx_2stage_((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chbgst = 0;
#endif

/* Wrapper for chbgst */
void FC_GLOBAL(chbgst,CHBGST)
    (char *vect, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, lapack_complex_float *x, blasint *ldx, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *vect, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *x, void *ldx, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *vect, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *x, void *ldx, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbgst = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chbgst;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chbgst.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) vect, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) x, (void *) ldx, (void *) work, (void *) rwork, (void *) info, vect_len, uplo_len);
    } else {
        fn((void *) vect, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) x, (void *) ldx, (void *) work, (void *) rwork, (void *) info, vect_len, uplo_len);
    }
    #else
    fn((void *) vect, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) x, (void *) ldx, (void *) work, (void *) rwork, (void *) info, vect_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chbgst,CHBGST)(char *vect, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, lapack_complex_float *x, blasint *ldx, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbgst,CHBGST)))));
void FC_GLOBAL3(chbgst,CHBGST)(char *vect, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, lapack_complex_float *x, blasint *ldx, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbgst,CHBGST)))));
#else
void FC_GLOBAL2(chbgst,CHBGST)(char *vect, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, lapack_complex_float *x, blasint *ldx, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbgst,CHBGST)((void *) vect, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) x, (void *) ldx, (void *) work, (void *) rwork, (void *) info, vect_len, uplo_len);
}
void FC_GLOBAL3(chbgst,CHBGST)(char *vect, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, lapack_complex_float *x, blasint *ldx, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbgst,CHBGST)((void *) vect, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) x, (void *) ldx, (void *) work, (void *) rwork, (void *) info, vect_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chbgst_(void *vect, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *x, void *ldx, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *vect, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *x, void *ldx, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chbgst;
    fn((void *) vect, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) x, (void *) ldx, (void *) work, (void *) rwork, (void *) info, vect_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chbgst(void *vect, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *x, void *ldx, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chbgst_")));
#else
void flexiblas_real_chbgst(void *vect, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *x, void *ldx, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chbgst_((void *) vect, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) x, (void *) ldx, (void *) work, (void *) rwork, (void *) info, vect_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_chbgst_(void *vect, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *x, void *ldx, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *vect, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *x, void *ldx, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbgst++;
    if ( hook_pos_chbgst < __flexiblas_hooks->chbgst.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chbgst.hook_function[hook_pos_chbgst];
    } else {
        hook_pos_chbgst = 0;
        *(void **) &fn = current_backend->lapack.chbgst;
    }
    fn((void *) vect, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) x, (void *) ldx, (void *) work, (void *) rwork, (void *) info, vect_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chbgst(void *vect, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *x, void *ldx, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chbgst_")));
#else
void flexiblas_chain_chbgst(void *vect, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *x, void *ldx, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chbgst_((void *) vect, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) x, (void *) ldx, (void *) work, (void *) rwork, (void *) info, vect_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chbgv = 0;
#endif

/* Wrapper for chbgv */
void FC_GLOBAL(chbgv,CHBGV)
    (char *jobz, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbgv = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chbgv;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chbgv.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chbgv,CHBGV)(char *jobz, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbgv,CHBGV)))));
void FC_GLOBAL3(chbgv,CHBGV)(char *jobz, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbgv,CHBGV)))));
#else
void FC_GLOBAL2(chbgv,CHBGV)(char *jobz, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbgv,CHBGV)((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
}
void FC_GLOBAL3(chbgv,CHBGV)(char *jobz, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbgv,CHBGV)((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chbgv_(void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chbgv;
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chbgv(void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chbgv_")));
#else
void flexiblas_real_chbgv(void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chbgv_((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_chbgv_(void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbgv++;
    if ( hook_pos_chbgv < __flexiblas_hooks->chbgv.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chbgv.hook_function[hook_pos_chbgv];
    } else {
        hook_pos_chbgv = 0;
        *(void **) &fn = current_backend->lapack.chbgv;
    }
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chbgv(void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chbgv_")));
#else
void flexiblas_chain_chbgv(void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chbgv_((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chbgvd = 0;
#endif

/* Wrapper for chbgvd */
void FC_GLOBAL(chbgvd,CHBGVD)
    (char *jobz, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbgvd = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chbgvd;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chbgvd.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chbgvd,CHBGVD)(char *jobz, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbgvd,CHBGVD)))));
void FC_GLOBAL3(chbgvd,CHBGVD)(char *jobz, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbgvd,CHBGVD)))));
#else
void FC_GLOBAL2(chbgvd,CHBGVD)(char *jobz, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbgvd,CHBGVD)((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
}
void FC_GLOBAL3(chbgvd,CHBGVD)(char *jobz, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbgvd,CHBGVD)((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chbgvd_(void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chbgvd;
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chbgvd(void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chbgvd_")));
#else
void flexiblas_real_chbgvd(void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chbgvd_((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_chbgvd_(void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbgvd++;
    if ( hook_pos_chbgvd < __flexiblas_hooks->chbgvd.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chbgvd.hook_function[hook_pos_chbgvd];
    } else {
        hook_pos_chbgvd = 0;
        *(void **) &fn = current_backend->lapack.chbgvd;
    }
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chbgvd(void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chbgvd_")));
#else
void flexiblas_chain_chbgvd(void *jobz, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chbgvd_((void *) jobz, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chbgvx = 0;
#endif

/* Wrapper for chbgvx */
void FC_GLOBAL(chbgvx,CHBGVX)
    (char *jobz, char *range, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, lapack_complex_float *q, blasint *ldq, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *range, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbgvx = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chbgvx;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chbgvx.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chbgvx,CHBGVX)(char *jobz, char *range, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, lapack_complex_float *q, blasint *ldq, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbgvx,CHBGVX)))));
void FC_GLOBAL3(chbgvx,CHBGVX)(char *jobz, char *range, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, lapack_complex_float *q, blasint *ldq, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbgvx,CHBGVX)))));
#else
void FC_GLOBAL2(chbgvx,CHBGVX)(char *jobz, char *range, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, lapack_complex_float *q, blasint *ldq, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbgvx,CHBGVX)((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
}
void FC_GLOBAL3(chbgvx,CHBGVX)(char *jobz, char *range, char *uplo, blasint *n, blasint *ka, blasint *kb, lapack_complex_float *ab, blasint *ldab, lapack_complex_float *bb, blasint *ldbb, lapack_complex_float *q, blasint *ldq, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbgvx,CHBGVX)((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chbgvx_(void *jobz, void *range, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chbgvx;
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chbgvx(void *jobz, void *range, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chbgvx_")));
#else
void flexiblas_real_chbgvx(void *jobz, void *range, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chbgvx_((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_chbgvx_(void *jobz, void *range, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbgvx++;
    if ( hook_pos_chbgvx < __flexiblas_hooks->chbgvx.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chbgvx.hook_function[hook_pos_chbgvx];
    } else {
        hook_pos_chbgvx = 0;
        *(void **) &fn = current_backend->lapack.chbgvx;
    }
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chbgvx(void *jobz, void *range, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chbgvx_")));
#else
void flexiblas_chain_chbgvx(void *jobz, void *range, void *uplo, void *n, void *ka, void *kb, void *ab, void *ldab, void *bb, void *ldbb, void *q, void *ldq, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chbgvx_((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) ka, (void *) kb, (void *) ab, (void *) ldab, (void *) bb, (void *) ldbb, (void *) q, (void *) ldq, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chbtrd = 0;
#endif

/* Wrapper for chbtrd */
void FC_GLOBAL(chbtrd,CHBTRD)
    (char *vect, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *d, float *e, lapack_complex_float *q, blasint *ldq, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *vect, void *uplo, void *n, void *kd, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *work, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *vect, void *uplo, void *n, void *kd, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *work, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbtrd = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chbtrd;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chbtrd.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) vect, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) work, (void *) info, vect_len, uplo_len);
    } else {
        fn((void *) vect, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) work, (void *) info, vect_len, uplo_len);
    }
    #else
    fn((void *) vect, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) work, (void *) info, vect_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chbtrd,CHBTRD)(char *vect, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *d, float *e, lapack_complex_float *q, blasint *ldq, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbtrd,CHBTRD)))));
void FC_GLOBAL3(chbtrd,CHBTRD)(char *vect, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *d, float *e, lapack_complex_float *q, blasint *ldq, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chbtrd,CHBTRD)))));
#else
void FC_GLOBAL2(chbtrd,CHBTRD)(char *vect, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *d, float *e, lapack_complex_float *q, blasint *ldq, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbtrd,CHBTRD)((void *) vect, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) work, (void *) info, vect_len, uplo_len);
}
void FC_GLOBAL3(chbtrd,CHBTRD)(char *vect, char *uplo, blasint *n, blasint *kd, lapack_complex_float *ab, blasint *ldab, float *d, float *e, lapack_complex_float *q, blasint *ldq, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chbtrd,CHBTRD)((void *) vect, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) work, (void *) info, vect_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chbtrd_(void *vect, void *uplo, void *n, void *kd, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *work, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *vect, void *uplo, void *n, void *kd, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *work, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chbtrd;
    fn((void *) vect, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) work, (void *) info, vect_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chbtrd(void *vect, void *uplo, void *n, void *kd, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *work, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chbtrd_")));
#else
void flexiblas_real_chbtrd(void *vect, void *uplo, void *n, void *kd, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *work, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chbtrd_((void *) vect, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) work, (void *) info, vect_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_chbtrd_(void *vect, void *uplo, void *n, void *kd, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *work, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *vect, void *uplo, void *n, void *kd, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *work, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chbtrd++;
    if ( hook_pos_chbtrd < __flexiblas_hooks->chbtrd.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chbtrd.hook_function[hook_pos_chbtrd];
    } else {
        hook_pos_chbtrd = 0;
        *(void **) &fn = current_backend->lapack.chbtrd;
    }
    fn((void *) vect, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) work, (void *) info, vect_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chbtrd(void *vect, void *uplo, void *n, void *kd, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *work, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chbtrd_")));
#else
void flexiblas_chain_chbtrd(void *vect, void *uplo, void *n, void *kd, void *ab, void *ldab, void *d, void *e, void *q, void *ldq, void *work, void *info, flexiblas_fortran_charlen_t vect_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chbtrd_((void *) vect, (void *) uplo, (void *) n, (void *) kd, (void *) ab, (void *) ldab, (void *) d, (void *) e, (void *) q, (void *) ldq, (void *) work, (void *) info, vect_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_checon = 0;
#endif

/* Wrapper for checon */
void FC_GLOBAL(checon,CHECON)
    (char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_checon = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.checon;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->checon.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    } else {
        fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    }
    #else
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(checon,CHECON)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(checon,CHECON)))));
void FC_GLOBAL3(checon,CHECON)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(checon,CHECON)))));
#else
void FC_GLOBAL2(checon,CHECON)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(checon,CHECON)((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
}
void FC_GLOBAL3(checon,CHECON)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(checon,CHECON)((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_checon_(void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.checon;
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_checon(void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_checon_")));
#else
void flexiblas_real_checon(void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_checon_((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    return;
}
#endif

void flexiblas_chain_checon_(void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_checon++;
    if ( hook_pos_checon < __flexiblas_hooks->checon.nhook ) {
        *(void **) &fn = __flexiblas_hooks->checon.hook_function[hook_pos_checon];
    } else {
        hook_pos_checon = 0;
        *(void **) &fn = current_backend->lapack.checon;
    }
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_checon(void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_checon_")));
#else
void flexiblas_chain_checon(void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_checon_((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_checon_3 = 0;
#endif

/* Wrapper for checon_3 */
void FC_GLOBAL(checon_3,CHECON_3)
    (char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *e, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *e, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *uplo, void *n, void *a, void *lda, void *e, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_checon_3 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.checon_3;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->checon_3.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    } else {
        fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    }
    #else
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(checon_3,CHECON_3)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *e, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(checon_3,CHECON_3)))));
void FC_GLOBAL3(checon_3,CHECON_3)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *e, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(checon_3,CHECON_3)))));
#else
void FC_GLOBAL2(checon_3,CHECON_3)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *e, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(checon_3,CHECON_3)((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
}
void FC_GLOBAL3(checon_3,CHECON_3)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *e, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(checon_3,CHECON_3)((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_checon_3_(void *uplo, void *n, void *a, void *lda, void *e, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *e, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.checon_3;
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_checon_3(void *uplo, void *n, void *a, void *lda, void *e, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_checon_3_")));
#else
void flexiblas_real_checon_3(void *uplo, void *n, void *a, void *lda, void *e, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_checon_3_((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    return;
}
#endif

void flexiblas_chain_checon_3_(void *uplo, void *n, void *a, void *lda, void *e, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *e, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_checon_3++;
    if ( hook_pos_checon_3 < __flexiblas_hooks->checon_3.nhook ) {
        *(void **) &fn = __flexiblas_hooks->checon_3.hook_function[hook_pos_checon_3];
    } else {
        hook_pos_checon_3 = 0;
        *(void **) &fn = current_backend->lapack.checon_3;
    }
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_checon_3(void *uplo, void *n, void *a, void *lda, void *e, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_checon_3_")));
#else
void flexiblas_chain_checon_3(void *uplo, void *n, void *a, void *lda, void *e, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_checon_3_((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_checon_rook = 0;
#endif

/* Wrapper for checon_rook */
void FC_GLOBAL(checon_rook,CHECON_ROOK)
    (char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_checon_rook = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.checon_rook;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->checon_rook.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    } else {
        fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    }
    #else
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(checon_rook,CHECON_ROOK)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(checon_rook,CHECON_ROOK)))));
void FC_GLOBAL3(checon_rook,CHECON_ROOK)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(checon_rook,CHECON_ROOK)))));
#else
void FC_GLOBAL2(checon_rook,CHECON_ROOK)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(checon_rook,CHECON_ROOK)((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
}
void FC_GLOBAL3(checon_rook,CHECON_ROOK)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, float *anorm, float *rcond, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(checon_rook,CHECON_ROOK)((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_checon_rook_(void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.checon_rook;
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_checon_rook(void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_checon_rook_")));
#else
void flexiblas_real_checon_rook(void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_checon_rook_((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    return;
}
#endif

void flexiblas_chain_checon_rook_(void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_checon_rook++;
    if ( hook_pos_checon_rook < __flexiblas_hooks->checon_rook.nhook ) {
        *(void **) &fn = __flexiblas_hooks->checon_rook.hook_function[hook_pos_checon_rook];
    } else {
        hook_pos_checon_rook = 0;
        *(void **) &fn = current_backend->lapack.checon_rook;
    }
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_checon_rook(void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_checon_rook_")));
#else
void flexiblas_chain_checon_rook(void *uplo, void *n, void *a, void *lda, void *ipiv, void *anorm, void *rcond, void *work, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_checon_rook_((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) anorm, (void *) rcond, (void *) work, (void *) info, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cheequb = 0;
#endif

/* Wrapper for cheequb */
void FC_GLOBAL(cheequb,CHEEQUB)
    (char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *s, float *scond, float *amax, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *s, void *scond, void *amax, void *work, void *info, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *uplo, void *n, void *a, void *lda, void *s, void *scond, void *amax, void *work, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheequb = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cheequb;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cheequb.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) scond, (void *) amax, (void *) work, (void *) info, uplo_len);
    } else {
        fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) scond, (void *) amax, (void *) work, (void *) info, uplo_len);
    }
    #else
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) scond, (void *) amax, (void *) work, (void *) info, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cheequb,CHEEQUB)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *s, float *scond, float *amax, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheequb,CHEEQUB)))));
void FC_GLOBAL3(cheequb,CHEEQUB)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *s, float *scond, float *amax, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheequb,CHEEQUB)))));
#else
void FC_GLOBAL2(cheequb,CHEEQUB)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *s, float *scond, float *amax, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheequb,CHEEQUB)((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) scond, (void *) amax, (void *) work, (void *) info, uplo_len);
}
void FC_GLOBAL3(cheequb,CHEEQUB)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *s, float *scond, float *amax, lapack_complex_float *work, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheequb,CHEEQUB)((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) scond, (void *) amax, (void *) work, (void *) info, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cheequb_(void *uplo, void *n, void *a, void *lda, void *s, void *scond, void *amax, void *work, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *s, void *scond, void *amax, void *work, void *info, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.cheequb;
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) scond, (void *) amax, (void *) work, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cheequb(void *uplo, void *n, void *a, void *lda, void *s, void *scond, void *amax, void *work, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_cheequb_")));
#else
void flexiblas_real_cheequb(void *uplo, void *n, void *a, void *lda, void *s, void *scond, void *amax, void *work, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_cheequb_((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) scond, (void *) amax, (void *) work, (void *) info, uplo_len);
    return;
}
#endif

void flexiblas_chain_cheequb_(void *uplo, void *n, void *a, void *lda, void *s, void *scond, void *amax, void *work, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *s, void *scond, void *amax, void *work, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheequb++;
    if ( hook_pos_cheequb < __flexiblas_hooks->cheequb.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cheequb.hook_function[hook_pos_cheequb];
    } else {
        hook_pos_cheequb = 0;
        *(void **) &fn = current_backend->lapack.cheequb;
    }
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) scond, (void *) amax, (void *) work, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cheequb(void *uplo, void *n, void *a, void *lda, void *s, void *scond, void *amax, void *work, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_cheequb_")));
#else
void flexiblas_chain_cheequb(void *uplo, void *n, void *a, void *lda, void *s, void *scond, void *amax, void *work, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_cheequb_((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) s, (void *) scond, (void *) amax, (void *) work, (void *) info, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cheev = 0;
#endif

/* Wrapper for cheev */
void FC_GLOBAL(cheev,CHEEV)
    (char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheev = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cheev;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cheev.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cheev,CHEEV)(char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheev,CHEEV)))));
void FC_GLOBAL3(cheev,CHEEV)(char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheev,CHEEV)))));
#else
void FC_GLOBAL2(cheev,CHEEV)(char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheev,CHEEV)((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
}
void FC_GLOBAL3(cheev,CHEEV)(char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheev,CHEEV)((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cheev_(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.cheev;
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cheev(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_cheev_")));
#else
void flexiblas_real_cheev(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_cheev_((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_cheev_(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheev++;
    if ( hook_pos_cheev < __flexiblas_hooks->cheev.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cheev.hook_function[hook_pos_cheev];
    } else {
        hook_pos_cheev = 0;
        *(void **) &fn = current_backend->lapack.cheev;
    }
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cheev(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_cheev_")));
#else
void flexiblas_chain_cheev(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_cheev_((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cheev_2stage = 0;
#endif

/* Wrapper for cheev_2stage */
void FC_GLOBAL(cheev_2stage,CHEEV_2STAGE)
    (char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheev_2stage = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cheev_2stage;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cheev_2stage.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cheev_2stage,CHEEV_2STAGE)(char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheev_2stage,CHEEV_2STAGE)))));
void FC_GLOBAL3(cheev_2stage,CHEEV_2STAGE)(char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheev_2stage,CHEEV_2STAGE)))));
#else
void FC_GLOBAL2(cheev_2stage,CHEEV_2STAGE)(char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheev_2stage,CHEEV_2STAGE)((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
}
void FC_GLOBAL3(cheev_2stage,CHEEV_2STAGE)(char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheev_2stage,CHEEV_2STAGE)((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cheev_2stage_(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.cheev_2stage;
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cheev_2stage(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_cheev_2stage_")));
#else
void flexiblas_real_cheev_2stage(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_cheev_2stage_((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_cheev_2stage_(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheev_2stage++;
    if ( hook_pos_cheev_2stage < __flexiblas_hooks->cheev_2stage.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cheev_2stage.hook_function[hook_pos_cheev_2stage];
    } else {
        hook_pos_cheev_2stage = 0;
        *(void **) &fn = current_backend->lapack.cheev_2stage;
    }
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cheev_2stage(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_cheev_2stage_")));
#else
void flexiblas_chain_cheev_2stage(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_cheev_2stage_((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cheevd = 0;
#endif

/* Wrapper for cheevd */
void FC_GLOBAL(cheevd,CHEEVD)
    (char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheevd = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cheevd;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cheevd.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cheevd,CHEEVD)(char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheevd,CHEEVD)))));
void FC_GLOBAL3(cheevd,CHEEVD)(char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheevd,CHEEVD)))));
#else
void FC_GLOBAL2(cheevd,CHEEVD)(char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheevd,CHEEVD)((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
}
void FC_GLOBAL3(cheevd,CHEEVD)(char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheevd,CHEEVD)((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cheevd_(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.cheevd;
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cheevd(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_cheevd_")));
#else
void flexiblas_real_cheevd(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_cheevd_((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_cheevd_(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheevd++;
    if ( hook_pos_cheevd < __flexiblas_hooks->cheevd.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cheevd.hook_function[hook_pos_cheevd];
    } else {
        hook_pos_cheevd = 0;
        *(void **) &fn = current_backend->lapack.cheevd;
    }
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cheevd(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_cheevd_")));
#else
void flexiblas_chain_cheevd(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_cheevd_((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cheevd_2stage = 0;
#endif

/* Wrapper for cheevd_2stage */
void FC_GLOBAL(cheevd_2stage,CHEEVD_2STAGE)
    (char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheevd_2stage = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cheevd_2stage;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cheevd_2stage.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cheevd_2stage,CHEEVD_2STAGE)(char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheevd_2stage,CHEEVD_2STAGE)))));
void FC_GLOBAL3(cheevd_2stage,CHEEVD_2STAGE)(char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheevd_2stage,CHEEVD_2STAGE)))));
#else
void FC_GLOBAL2(cheevd_2stage,CHEEVD_2STAGE)(char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheevd_2stage,CHEEVD_2STAGE)((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
}
void FC_GLOBAL3(cheevd_2stage,CHEEVD_2STAGE)(char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheevd_2stage,CHEEVD_2STAGE)((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cheevd_2stage_(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.cheevd_2stage;
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cheevd_2stage(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_cheevd_2stage_")));
#else
void flexiblas_real_cheevd_2stage(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_cheevd_2stage_((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_cheevd_2stage_(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheevd_2stage++;
    if ( hook_pos_cheevd_2stage < __flexiblas_hooks->cheevd_2stage.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cheevd_2stage.hook_function[hook_pos_cheevd_2stage];
    } else {
        hook_pos_cheevd_2stage = 0;
        *(void **) &fn = current_backend->lapack.cheevd_2stage;
    }
    fn((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cheevd_2stage(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_cheevd_2stage_")));
#else
void flexiblas_chain_cheevd_2stage(void *jobz, void *uplo, void *n, void *a, void *lda, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_cheevd_2stage_((void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cheevr = 0;
#endif

/* Wrapper for cheevr */
void FC_GLOBAL(cheevr,CHEEVR)
    (char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, blasint *isuppz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheevr = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cheevr;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cheevr.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cheevr,CHEEVR)(char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, blasint *isuppz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheevr,CHEEVR)))));
void FC_GLOBAL3(cheevr,CHEEVR)(char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, blasint *isuppz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheevr,CHEEVR)))));
#else
void FC_GLOBAL2(cheevr,CHEEVR)(char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, blasint *isuppz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheevr,CHEEVR)((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
}
void FC_GLOBAL3(cheevr,CHEEVR)(char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, blasint *isuppz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheevr,CHEEVR)((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cheevr_(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.cheevr;
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cheevr(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_cheevr_")));
#else
void flexiblas_real_cheevr(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_cheevr_((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_cheevr_(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheevr++;
    if ( hook_pos_cheevr < __flexiblas_hooks->cheevr.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cheevr.hook_function[hook_pos_cheevr];
    } else {
        hook_pos_cheevr = 0;
        *(void **) &fn = current_backend->lapack.cheevr;
    }
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cheevr(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_cheevr_")));
#else
void flexiblas_chain_cheevr(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_cheevr_((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cheevr_2stage = 0;
#endif

/* Wrapper for cheevr_2stage */
void FC_GLOBAL(cheevr_2stage,CHEEVR_2STAGE)
    (char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, blasint *isuppz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheevr_2stage = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cheevr_2stage;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cheevr_2stage.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cheevr_2stage,CHEEVR_2STAGE)(char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, blasint *isuppz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheevr_2stage,CHEEVR_2STAGE)))));
void FC_GLOBAL3(cheevr_2stage,CHEEVR_2STAGE)(char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, blasint *isuppz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheevr_2stage,CHEEVR_2STAGE)))));
#else
void FC_GLOBAL2(cheevr_2stage,CHEEVR_2STAGE)(char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, blasint *isuppz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheevr_2stage,CHEEVR_2STAGE)((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
}
void FC_GLOBAL3(cheevr_2stage,CHEEVR_2STAGE)(char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, blasint *isuppz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheevr_2stage,CHEEVR_2STAGE)((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cheevr_2stage_(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.cheevr_2stage;
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cheevr_2stage(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_cheevr_2stage_")));
#else
void flexiblas_real_cheevr_2stage(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_cheevr_2stage_((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_cheevr_2stage_(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheevr_2stage++;
    if ( hook_pos_cheevr_2stage < __flexiblas_hooks->cheevr_2stage.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cheevr_2stage.hook_function[hook_pos_cheevr_2stage];
    } else {
        hook_pos_cheevr_2stage = 0;
        *(void **) &fn = current_backend->lapack.cheevr_2stage;
    }
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cheevr_2stage(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_cheevr_2stage_")));
#else
void flexiblas_chain_cheevr_2stage(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *isuppz, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_cheevr_2stage_((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) isuppz, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cheevx = 0;
#endif

/* Wrapper for cheevx */
void FC_GLOBAL(cheevx,CHEEVX)
    (char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheevx = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cheevx;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cheevx.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cheevx,CHEEVX)(char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheevx,CHEEVX)))));
void FC_GLOBAL3(cheevx,CHEEVX)(char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheevx,CHEEVX)))));
#else
void FC_GLOBAL2(cheevx,CHEEVX)(char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheevx,CHEEVX)((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
}
void FC_GLOBAL3(cheevx,CHEEVX)(char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheevx,CHEEVX)((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cheevx_(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.cheevx;
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cheevx(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_cheevx_")));
#else
void flexiblas_real_cheevx(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_cheevx_((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_cheevx_(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheevx++;
    if ( hook_pos_cheevx < __flexiblas_hooks->cheevx.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cheevx.hook_function[hook_pos_cheevx];
    } else {
        hook_pos_cheevx = 0;
        *(void **) &fn = current_backend->lapack.cheevx;
    }
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cheevx(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_cheevx_")));
#else
void flexiblas_chain_cheevx(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_cheevx_((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cheevx_2stage = 0;
#endif

/* Wrapper for cheevx_2stage */
void FC_GLOBAL(cheevx_2stage,CHEEVX_2STAGE)
    (char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheevx_2stage = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cheevx_2stage;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cheevx_2stage.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    } else {
        fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    }
    #else
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cheevx_2stage,CHEEVX_2STAGE)(char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheevx_2stage,CHEEVX_2STAGE)))));
void FC_GLOBAL3(cheevx_2stage,CHEEVX_2STAGE)(char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheevx_2stage,CHEEVX_2STAGE)))));
#else
void FC_GLOBAL2(cheevx_2stage,CHEEVX_2STAGE)(char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheevx_2stage,CHEEVX_2STAGE)((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
}
void FC_GLOBAL3(cheevx_2stage,CHEEVX_2STAGE)(char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheevx_2stage,CHEEVX_2STAGE)((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cheevx_2stage_(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.cheevx_2stage;
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cheevx_2stage(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_cheevx_2stage_")));
#else
void flexiblas_real_cheevx_2stage(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_cheevx_2stage_((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_cheevx_2stage_(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheevx_2stage++;
    if ( hook_pos_cheevx_2stage < __flexiblas_hooks->cheevx_2stage.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cheevx_2stage.hook_function[hook_pos_cheevx_2stage];
    } else {
        hook_pos_cheevx_2stage = 0;
        *(void **) &fn = current_backend->lapack.cheevx_2stage;
    }
    fn((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cheevx_2stage(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_cheevx_2stage_")));
#else
void flexiblas_chain_cheevx_2stage(void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_cheevx_2stage_((void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chegs2 = 0;
#endif

/* Wrapper for chegs2 */
void FC_GLOBAL(chegs2,CHEGS2)
    (blasint *itype, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chegs2 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chegs2;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chegs2.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
    } else {
        fn((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
    }
    #else
    fn((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chegs2,CHEGS2)(blasint *itype, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chegs2,CHEGS2)))));
void FC_GLOBAL3(chegs2,CHEGS2)(blasint *itype, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chegs2,CHEGS2)))));
#else
void FC_GLOBAL2(chegs2,CHEGS2)(blasint *itype, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chegs2,CHEGS2)((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
}
void FC_GLOBAL3(chegs2,CHEGS2)(blasint *itype, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chegs2,CHEGS2)((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chegs2_(void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chegs2;
    fn((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chegs2(void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chegs2_")));
#else
void flexiblas_real_chegs2(void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chegs2_((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
    return;
}
#endif

void flexiblas_chain_chegs2_(void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chegs2++;
    if ( hook_pos_chegs2 < __flexiblas_hooks->chegs2.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chegs2.hook_function[hook_pos_chegs2];
    } else {
        hook_pos_chegs2 = 0;
        *(void **) &fn = current_backend->lapack.chegs2;
    }
    fn((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chegs2(void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chegs2_")));
#else
void flexiblas_chain_chegs2(void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chegs2_((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chegst = 0;
#endif

/* Wrapper for chegst */
void FC_GLOBAL(chegst,CHEGST)
    (blasint *itype, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chegst = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chegst;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chegst.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
    } else {
        fn((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
    }
    #else
    fn((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chegst,CHEGST)(blasint *itype, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chegst,CHEGST)))));
void FC_GLOBAL3(chegst,CHEGST)(blasint *itype, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chegst,CHEGST)))));
#else
void FC_GLOBAL2(chegst,CHEGST)(blasint *itype, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chegst,CHEGST)((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
}
void FC_GLOBAL3(chegst,CHEGST)(blasint *itype, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chegst,CHEGST)((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chegst_(void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chegst;
    fn((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chegst(void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chegst_")));
#else
void flexiblas_real_chegst(void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chegst_((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
    return;
}
#endif

void flexiblas_chain_chegst_(void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chegst++;
    if ( hook_pos_chegst < __flexiblas_hooks->chegst.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chegst.hook_function[hook_pos_chegst];
    } else {
        hook_pos_chegst = 0;
        *(void **) &fn = current_backend->lapack.chegst;
    }
    fn((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chegst(void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chegst_")));
#else
void flexiblas_chain_chegst(void *itype, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chegst_((void *) itype, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) info, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chegv = 0;
#endif

/* Wrapper for chegv */
void FC_GLOBAL(chegv,CHEGV)
    (blasint *itype, char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chegv = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chegv;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chegv.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    } else {
        fn((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    }
    #else
    fn((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chegv,CHEGV)(blasint *itype, char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chegv,CHEGV)))));
void FC_GLOBAL3(chegv,CHEGV)(blasint *itype, char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chegv,CHEGV)))));
#else
void FC_GLOBAL2(chegv,CHEGV)(blasint *itype, char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chegv,CHEGV)((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
}
void FC_GLOBAL3(chegv,CHEGV)(blasint *itype, char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chegv,CHEGV)((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chegv_(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chegv;
    fn((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chegv(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chegv_")));
#else
void flexiblas_real_chegv(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chegv_((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_chegv_(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chegv++;
    if ( hook_pos_chegv < __flexiblas_hooks->chegv.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chegv.hook_function[hook_pos_chegv];
    } else {
        hook_pos_chegv = 0;
        *(void **) &fn = current_backend->lapack.chegv;
    }
    fn((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chegv(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chegv_")));
#else
void flexiblas_chain_chegv(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chegv_((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chegv_2stage = 0;
#endif

/* Wrapper for chegv_2stage */
void FC_GLOBAL(chegv_2stage,CHEGV_2STAGE)
    (blasint *itype, char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chegv_2stage = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chegv_2stage;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chegv_2stage.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    } else {
        fn((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    }
    #else
    fn((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chegv_2stage,CHEGV_2STAGE)(blasint *itype, char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chegv_2stage,CHEGV_2STAGE)))));
void FC_GLOBAL3(chegv_2stage,CHEGV_2STAGE)(blasint *itype, char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chegv_2stage,CHEGV_2STAGE)))));
#else
void FC_GLOBAL2(chegv_2stage,CHEGV_2STAGE)(blasint *itype, char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chegv_2stage,CHEGV_2STAGE)((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
}
void FC_GLOBAL3(chegv_2stage,CHEGV_2STAGE)(blasint *itype, char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chegv_2stage,CHEGV_2STAGE)((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chegv_2stage_(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chegv_2stage;
    fn((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chegv_2stage(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chegv_2stage_")));
#else
void flexiblas_real_chegv_2stage(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chegv_2stage_((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_chegv_2stage_(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chegv_2stage++;
    if ( hook_pos_chegv_2stage < __flexiblas_hooks->chegv_2stage.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chegv_2stage.hook_function[hook_pos_chegv_2stage];
    } else {
        hook_pos_chegv_2stage = 0;
        *(void **) &fn = current_backend->lapack.chegv_2stage;
    }
    fn((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chegv_2stage(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chegv_2stage_")));
#else
void flexiblas_chain_chegv_2stage(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chegv_2stage_((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chegvd = 0;
#endif

/* Wrapper for chegvd */
void FC_GLOBAL(chegvd,CHEGVD)
    (blasint *itype, char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chegvd = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chegvd;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chegvd.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    } else {
        fn((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    }
    #else
    fn((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chegvd,CHEGVD)(blasint *itype, char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chegvd,CHEGVD)))));
void FC_GLOBAL3(chegvd,CHEGVD)(blasint *itype, char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chegvd,CHEGVD)))));
#else
void FC_GLOBAL2(chegvd,CHEGVD)(blasint *itype, char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chegvd,CHEGVD)((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
}
void FC_GLOBAL3(chegvd,CHEGVD)(blasint *itype, char *jobz, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *w, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *lrwork, blasint *iwork, blasint *liwork, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chegvd,CHEGVD)((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chegvd_(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chegvd;
    fn((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chegvd(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chegvd_")));
#else
void flexiblas_real_chegvd(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chegvd_((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_chegvd_(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chegvd++;
    if ( hook_pos_chegvd < __flexiblas_hooks->chegvd.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chegvd.hook_function[hook_pos_chegvd];
    } else {
        hook_pos_chegvd = 0;
        *(void **) &fn = current_backend->lapack.chegvd;
    }
    fn((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chegvd(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chegvd_")));
#else
void flexiblas_chain_chegvd(void *itype, void *jobz, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *w, void *work, void *lwork, void *rwork, void *lrwork, void *iwork, void *liwork, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chegvd_((void *) itype, (void *) jobz, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) w, (void *) work, (void *) lwork, (void *) rwork, (void *) lrwork, (void *) iwork, (void *) liwork, (void *) info, jobz_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chegvx = 0;
#endif

/* Wrapper for chegvx */
void FC_GLOBAL(chegvx,CHEGVX)
    (blasint *itype, char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *itype, void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chegvx = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chegvx;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chegvx.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) itype, (void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    } else {
        fn((void *) itype, (void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    }
    #else
    fn((void *) itype, (void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chegvx,CHEGVX)(blasint *itype, char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chegvx,CHEGVX)))));
void FC_GLOBAL3(chegvx,CHEGVX)(blasint *itype, char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chegvx,CHEGVX)))));
#else
void FC_GLOBAL2(chegvx,CHEGVX)(blasint *itype, char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chegvx,CHEGVX)((void *) itype, (void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
}
void FC_GLOBAL3(chegvx,CHEGVX)(blasint *itype, char *jobz, char *range, char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, lapack_complex_float *b, blasint *ldb, float *vl, float *vu, blasint *il, blasint *iu, float *abstol, blasint *m, float *w, lapack_complex_float *z, blasint *ldz, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *iwork, blasint *ifail, blasint *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chegvx,CHEGVX)((void *) itype, (void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chegvx_(void *itype, void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chegvx;
    fn((void *) itype, (void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chegvx(void *itype, void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chegvx_")));
#else
void flexiblas_real_chegvx(void *itype, void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chegvx_((void *) itype, (void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_chegvx_(void *itype, void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *itype, void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chegvx++;
    if ( hook_pos_chegvx < __flexiblas_hooks->chegvx.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chegvx.hook_function[hook_pos_chegvx];
    } else {
        hook_pos_chegvx = 0;
        *(void **) &fn = current_backend->lapack.chegvx;
    }
    fn((void *) itype, (void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chegvx(void *itype, void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chegvx_")));
#else
void flexiblas_chain_chegvx(void *itype, void *jobz, void *range, void *uplo, void *n, void *a, void *lda, void *b, void *ldb, void *vl, void *vu, void *il, void *iu, void *abstol, void *m, void *w, void *z, void *ldz, void *work, void *lwork, void *rwork, void *iwork, void *ifail, void *info, flexiblas_fortran_charlen_t jobz_len, flexiblas_fortran_charlen_t range_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chegvx_((void *) itype, (void *) jobz, (void *) range, (void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) b, (void *) ldb, (void *) vl, (void *) vu, (void *) il, (void *) iu, (void *) abstol, (void *) m, (void *) w, (void *) z, (void *) ldz, (void *) work, (void *) lwork, (void *) rwork, (void *) iwork, (void *) ifail, (void *) info, jobz_len, range_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cherfs = 0;
#endif

/* Wrapper for cherfs */
void FC_GLOBAL(cherfs,CHERFS)
    (char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cherfs = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cherfs;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cherfs.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, uplo_len);
    } else {
        fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, uplo_len);
    }
    #else
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cherfs,CHERFS)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cherfs,CHERFS)))));
void FC_GLOBAL3(cherfs,CHERFS)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cherfs,CHERFS)))));
#else
void FC_GLOBAL2(cherfs,CHERFS)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cherfs,CHERFS)((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, uplo_len);
}
void FC_GLOBAL3(cherfs,CHERFS)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *ferr, float *berr, lapack_complex_float *work, float *rwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cherfs,CHERFS)((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cherfs_(void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.cherfs;
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cherfs(void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_cherfs_")));
#else
void flexiblas_real_cherfs(void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_cherfs_((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, uplo_len);
    return;
}
#endif

void flexiblas_chain_cherfs_(void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cherfs++;
    if ( hook_pos_cherfs < __flexiblas_hooks->cherfs.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cherfs.hook_function[hook_pos_cherfs];
    } else {
        hook_pos_cherfs = 0;
        *(void **) &fn = current_backend->lapack.cherfs;
    }
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cherfs(void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_cherfs_")));
#else
void flexiblas_chain_cherfs(void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *ferr, void *berr, void *work, void *rwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_cherfs_((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) ferr, (void *) berr, (void *) work, (void *) rwork, (void *) info, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chesv = 0;
#endif

/* Wrapper for chesv */
void FC_GLOBAL(chesv,CHESV)
    (char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chesv = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chesv;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chesv.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    } else {
        fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    }
    #else
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chesv,CHESV)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chesv,CHESV)))));
void FC_GLOBAL3(chesv,CHESV)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chesv,CHESV)))));
#else
void FC_GLOBAL2(chesv,CHESV)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chesv,CHESV)((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
}
void FC_GLOBAL3(chesv,CHESV)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chesv,CHESV)((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chesv_(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chesv;
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chesv(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chesv_")));
#else
void flexiblas_real_chesv(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chesv_((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#endif

void flexiblas_chain_chesv_(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chesv++;
    if ( hook_pos_chesv < __flexiblas_hooks->chesv.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chesv.hook_function[hook_pos_chesv];
    } else {
        hook_pos_chesv = 0;
        *(void **) &fn = current_backend->lapack.chesv;
    }
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chesv(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chesv_")));
#else
void flexiblas_chain_chesv(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chesv_((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chesv_aa = 0;
#endif

/* Wrapper for chesv_aa */
void FC_GLOBAL(chesv_aa,CHESV_AA)
    (char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chesv_aa = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chesv_aa;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chesv_aa.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    } else {
        fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    }
    #else
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chesv_aa,CHESV_AA)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chesv_aa,CHESV_AA)))));
void FC_GLOBAL3(chesv_aa,CHESV_AA)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chesv_aa,CHESV_AA)))));
#else
void FC_GLOBAL2(chesv_aa,CHESV_AA)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chesv_aa,CHESV_AA)((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
}
void FC_GLOBAL3(chesv_aa,CHESV_AA)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chesv_aa,CHESV_AA)((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chesv_aa_(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chesv_aa;
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chesv_aa(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chesv_aa_")));
#else
void flexiblas_real_chesv_aa(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chesv_aa_((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#endif

void flexiblas_chain_chesv_aa_(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chesv_aa++;
    if ( hook_pos_chesv_aa < __flexiblas_hooks->chesv_aa.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chesv_aa.hook_function[hook_pos_chesv_aa];
    } else {
        hook_pos_chesv_aa = 0;
        *(void **) &fn = current_backend->lapack.chesv_aa;
    }
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chesv_aa(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chesv_aa_")));
#else
void flexiblas_chain_chesv_aa(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chesv_aa_((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chesv_aa_2stage = 0;
#endif

/* Wrapper for chesv_aa_2stage */
void FC_GLOBAL(chesv_aa_2stage,CHESV_AA_2STAGE)
    (char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *tb, blasint *ltb, blasint *ipiv, blasint *ipiv2, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *tb, void *ltb, void *ipiv, void *ipiv2, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *tb, void *ltb, void *ipiv, void *ipiv2, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chesv_aa_2stage = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chesv_aa_2stage;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chesv_aa_2stage.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) tb, (void *) ltb, (void *) ipiv, (void *) ipiv2, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    } else {
        fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) tb, (void *) ltb, (void *) ipiv, (void *) ipiv2, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    }
    #else
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) tb, (void *) ltb, (void *) ipiv, (void *) ipiv2, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chesv_aa_2stage,CHESV_AA_2STAGE)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *tb, blasint *ltb, blasint *ipiv, blasint *ipiv2, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chesv_aa_2stage,CHESV_AA_2STAGE)))));
void FC_GLOBAL3(chesv_aa_2stage,CHESV_AA_2STAGE)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *tb, blasint *ltb, blasint *ipiv, blasint *ipiv2, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chesv_aa_2stage,CHESV_AA_2STAGE)))));
#else
void FC_GLOBAL2(chesv_aa_2stage,CHESV_AA_2STAGE)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *tb, blasint *ltb, blasint *ipiv, blasint *ipiv2, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chesv_aa_2stage,CHESV_AA_2STAGE)((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) tb, (void *) ltb, (void *) ipiv, (void *) ipiv2, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
}
void FC_GLOBAL3(chesv_aa_2stage,CHESV_AA_2STAGE)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *tb, blasint *ltb, blasint *ipiv, blasint *ipiv2, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chesv_aa_2stage,CHESV_AA_2STAGE)((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) tb, (void *) ltb, (void *) ipiv, (void *) ipiv2, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chesv_aa_2stage_(void *uplo, void *n, void *nrhs, void *a, void *lda, void *tb, void *ltb, void *ipiv, void *ipiv2, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *tb, void *ltb, void *ipiv, void *ipiv2, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chesv_aa_2stage;
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) tb, (void *) ltb, (void *) ipiv, (void *) ipiv2, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chesv_aa_2stage(void *uplo, void *n, void *nrhs, void *a, void *lda, void *tb, void *ltb, void *ipiv, void *ipiv2, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chesv_aa_2stage_")));
#else
void flexiblas_real_chesv_aa_2stage(void *uplo, void *n, void *nrhs, void *a, void *lda, void *tb, void *ltb, void *ipiv, void *ipiv2, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chesv_aa_2stage_((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) tb, (void *) ltb, (void *) ipiv, (void *) ipiv2, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#endif

void flexiblas_chain_chesv_aa_2stage_(void *uplo, void *n, void *nrhs, void *a, void *lda, void *tb, void *ltb, void *ipiv, void *ipiv2, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *tb, void *ltb, void *ipiv, void *ipiv2, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chesv_aa_2stage++;
    if ( hook_pos_chesv_aa_2stage < __flexiblas_hooks->chesv_aa_2stage.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chesv_aa_2stage.hook_function[hook_pos_chesv_aa_2stage];
    } else {
        hook_pos_chesv_aa_2stage = 0;
        *(void **) &fn = current_backend->lapack.chesv_aa_2stage;
    }
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) tb, (void *) ltb, (void *) ipiv, (void *) ipiv2, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chesv_aa_2stage(void *uplo, void *n, void *nrhs, void *a, void *lda, void *tb, void *ltb, void *ipiv, void *ipiv2, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chesv_aa_2stage_")));
#else
void flexiblas_chain_chesv_aa_2stage(void *uplo, void *n, void *nrhs, void *a, void *lda, void *tb, void *ltb, void *ipiv, void *ipiv2, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chesv_aa_2stage_((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) tb, (void *) ltb, (void *) ipiv, (void *) ipiv2, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chesv_rk = 0;
#endif

/* Wrapper for chesv_rk */
void FC_GLOBAL(chesv_rk,CHESV_RK)
    (char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *e, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *e, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *e, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chesv_rk = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chesv_rk;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chesv_rk.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    } else {
        fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    }
    #else
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chesv_rk,CHESV_RK)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *e, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chesv_rk,CHESV_RK)))));
void FC_GLOBAL3(chesv_rk,CHESV_RK)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *e, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chesv_rk,CHESV_RK)))));
#else
void FC_GLOBAL2(chesv_rk,CHESV_RK)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *e, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chesv_rk,CHESV_RK)((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
}
void FC_GLOBAL3(chesv_rk,CHESV_RK)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *e, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chesv_rk,CHESV_RK)((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chesv_rk_(void *uplo, void *n, void *nrhs, void *a, void *lda, void *e, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *e, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chesv_rk;
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chesv_rk(void *uplo, void *n, void *nrhs, void *a, void *lda, void *e, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chesv_rk_")));
#else
void flexiblas_real_chesv_rk(void *uplo, void *n, void *nrhs, void *a, void *lda, void *e, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chesv_rk_((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#endif

void flexiblas_chain_chesv_rk_(void *uplo, void *n, void *nrhs, void *a, void *lda, void *e, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *e, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chesv_rk++;
    if ( hook_pos_chesv_rk < __flexiblas_hooks->chesv_rk.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chesv_rk.hook_function[hook_pos_chesv_rk];
    } else {
        hook_pos_chesv_rk = 0;
        *(void **) &fn = current_backend->lapack.chesv_rk;
    }
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chesv_rk(void *uplo, void *n, void *nrhs, void *a, void *lda, void *e, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chesv_rk_")));
#else
void flexiblas_chain_chesv_rk(void *uplo, void *n, void *nrhs, void *a, void *lda, void *e, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chesv_rk_((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) e, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chesv_rook = 0;
#endif

/* Wrapper for chesv_rook */
void FC_GLOBAL(chesv_rook,CHESV_ROOK)
    (char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chesv_rook = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chesv_rook;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chesv_rook.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    } else {
        fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    }
    #else
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chesv_rook,CHESV_ROOK)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chesv_rook,CHESV_ROOK)))));
void FC_GLOBAL3(chesv_rook,CHESV_ROOK)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chesv_rook,CHESV_ROOK)))));
#else
void FC_GLOBAL2(chesv_rook,CHESV_ROOK)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chesv_rook,CHESV_ROOK)((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
}
void FC_GLOBAL3(chesv_rook,CHESV_ROOK)(char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *work, blasint *lwork, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chesv_rook,CHESV_ROOK)((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chesv_rook_(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chesv_rook;
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chesv_rook(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chesv_rook_")));
#else
void flexiblas_real_chesv_rook(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chesv_rook_((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#endif

void flexiblas_chain_chesv_rook_(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chesv_rook++;
    if ( hook_pos_chesv_rook < __flexiblas_hooks->chesv_rook.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chesv_rook.hook_function[hook_pos_chesv_rook];
    } else {
        hook_pos_chesv_rook = 0;
        *(void **) &fn = current_backend->lapack.chesv_rook;
    }
    fn((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chesv_rook(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chesv_rook_")));
#else
void flexiblas_chain_chesv_rook(void *uplo, void *n, void *nrhs, void *a, void *lda, void *ipiv, void *b, void *ldb, void *work, void *lwork, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chesv_rook_((void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) ipiv, (void *) b, (void *) ldb, (void *) work, (void *) lwork, (void *) info, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chesvx = 0;
#endif

/* Wrapper for chesvx */
void FC_GLOBAL(chesvx,CHESVX)
    (char *fact, char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *fact, void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *fact, void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chesvx = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chesvx;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chesvx.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) fact, (void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, fact_len, uplo_len);
    } else {
        fn((void *) fact, (void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, fact_len, uplo_len);
    }
    #else
    fn((void *) fact, (void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, fact_len, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chesvx,CHESVX)(char *fact, char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chesvx,CHESVX)))));
void FC_GLOBAL3(chesvx,CHESVX)(char *fact, char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chesvx,CHESVX)))));
#else
void FC_GLOBAL2(chesvx,CHESVX)(char *fact, char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chesvx,CHESVX)((void *) fact, (void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, fact_len, uplo_len);
}
void FC_GLOBAL3(chesvx,CHESVX)(char *fact, char *uplo, blasint *n, blasint *nrhs, lapack_complex_float *a, blasint *lda, lapack_complex_float *af, blasint *ldaf, blasint *ipiv, lapack_complex_float *b, blasint *ldb, lapack_complex_float *x, blasint *ldx, float *rcond, float *ferr, float *berr, lapack_complex_float *work, blasint *lwork, float *rwork, blasint *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chesvx,CHESVX)((void *) fact, (void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, fact_len, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chesvx_(void *fact, void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *fact, void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chesvx;
    fn((void *) fact, (void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, fact_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chesvx(void *fact, void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chesvx_")));
#else
void flexiblas_real_chesvx(void *fact, void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chesvx_((void *) fact, (void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, fact_len, uplo_len);
    return;
}
#endif

void flexiblas_chain_chesvx_(void *fact, void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *fact, void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chesvx++;
    if ( hook_pos_chesvx < __flexiblas_hooks->chesvx.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chesvx.hook_function[hook_pos_chesvx];
    } else {
        hook_pos_chesvx = 0;
        *(void **) &fn = current_backend->lapack.chesvx;
    }
    fn((void *) fact, (void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, fact_len, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chesvx(void *fact, void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chesvx_")));
#else
void flexiblas_chain_chesvx(void *fact, void *uplo, void *n, void *nrhs, void *a, void *lda, void *af, void *ldaf, void *ipiv, void *b, void *ldb, void *x, void *ldx, void *rcond, void *ferr, void *berr, void *work, void *lwork, void *rwork, void *info, flexiblas_fortran_charlen_t fact_len, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chesvx_((void *) fact, (void *) uplo, (void *) n, (void *) nrhs, (void *) a, (void *) lda, (void *) af, (void *) ldaf, (void *) ipiv, (void *) b, (void *) ldb, (void *) x, (void *) ldx, (void *) rcond, (void *) ferr, (void *) berr, (void *) work, (void *) lwork, (void *) rwork, (void *) info, fact_len, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_cheswapr = 0;
#endif

/* Wrapper for cheswapr */
void FC_GLOBAL(cheswapr,CHESWAPR)
    (char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *i1, blasint *i2, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *i1, void *i2, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *uplo, void *n, void *a, void *lda, void *i1, void *i2, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheswapr = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.cheswapr;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->cheswapr.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) i1, (void *) i2, uplo_len);
    } else {
        fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) i1, (void *) i2, uplo_len);
    }
    #else
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) i1, (void *) i2, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(cheswapr,CHESWAPR)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *i1, blasint *i2, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheswapr,CHESWAPR)))));
void FC_GLOBAL3(cheswapr,CHESWAPR)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *i1, blasint *i2, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(cheswapr,CHESWAPR)))));
#else
void FC_GLOBAL2(cheswapr,CHESWAPR)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *i1, blasint *i2, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheswapr,CHESWAPR)((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) i1, (void *) i2, uplo_len);
}
void FC_GLOBAL3(cheswapr,CHESWAPR)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *i1, blasint *i2, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(cheswapr,CHESWAPR)((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) i1, (void *) i2, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_cheswapr_(void *uplo, void *n, void *a, void *lda, void *i1, void *i2, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *i1, void *i2, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.cheswapr;
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) i1, (void *) i2, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_cheswapr(void *uplo, void *n, void *a, void *lda, void *i1, void *i2, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_cheswapr_")));
#else
void flexiblas_real_cheswapr(void *uplo, void *n, void *a, void *lda, void *i1, void *i2, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_cheswapr_((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) i1, (void *) i2, uplo_len);
    return;
}
#endif

void flexiblas_chain_cheswapr_(void *uplo, void *n, void *a, void *lda, void *i1, void *i2, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *i1, void *i2, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_cheswapr++;
    if ( hook_pos_cheswapr < __flexiblas_hooks->cheswapr.nhook ) {
        *(void **) &fn = __flexiblas_hooks->cheswapr.hook_function[hook_pos_cheswapr];
    } else {
        hook_pos_cheswapr = 0;
        *(void **) &fn = current_backend->lapack.cheswapr;
    }
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) i1, (void *) i2, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_cheswapr(void *uplo, void *n, void *a, void *lda, void *i1, void *i2, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_cheswapr_")));
#else
void flexiblas_chain_cheswapr(void *uplo, void *n, void *a, void *lda, void *i1, void *i2, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_cheswapr_((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) i1, (void *) i2, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chetd2 = 0;
#endif

/* Wrapper for chetd2 */
void FC_GLOBAL(chetd2,CHETD2)
    (char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *d, float *e, lapack_complex_float *tau, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *d, void *e, void *tau, void *info, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *uplo, void *n, void *a, void *lda, void *d, void *e, void *tau, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chetd2 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chetd2;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chetd2.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tau, (void *) info, uplo_len);
    } else {
        fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tau, (void *) info, uplo_len);
    }
    #else
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tau, (void *) info, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chetd2,CHETD2)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *d, float *e, lapack_complex_float *tau, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chetd2,CHETD2)))));
void FC_GLOBAL3(chetd2,CHETD2)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *d, float *e, lapack_complex_float *tau, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chetd2,CHETD2)))));
#else
void FC_GLOBAL2(chetd2,CHETD2)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *d, float *e, lapack_complex_float *tau, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chetd2,CHETD2)((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tau, (void *) info, uplo_len);
}
void FC_GLOBAL3(chetd2,CHETD2)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, float *d, float *e, lapack_complex_float *tau, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chetd2,CHETD2)((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tau, (void *) info, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chetd2_(void *uplo, void *n, void *a, void *lda, void *d, void *e, void *tau, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *d, void *e, void *tau, void *info, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chetd2;
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tau, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chetd2(void *uplo, void *n, void *a, void *lda, void *d, void *e, void *tau, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chetd2_")));
#else
void flexiblas_real_chetd2(void *uplo, void *n, void *a, void *lda, void *d, void *e, void *tau, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chetd2_((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tau, (void *) info, uplo_len);
    return;
}
#endif

void flexiblas_chain_chetd2_(void *uplo, void *n, void *a, void *lda, void *d, void *e, void *tau, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *d, void *e, void *tau, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chetd2++;
    if ( hook_pos_chetd2 < __flexiblas_hooks->chetd2.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chetd2.hook_function[hook_pos_chetd2];
    } else {
        hook_pos_chetd2 = 0;
        *(void **) &fn = current_backend->lapack.chetd2;
    }
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tau, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chetd2(void *uplo, void *n, void *a, void *lda, void *d, void *e, void *tau, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chetd2_")));
#else
void flexiblas_chain_chetd2(void *uplo, void *n, void *a, void *lda, void *d, void *e, void *tau, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chetd2_((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) d, (void *) e, (void *) tau, (void *) info, uplo_len);
    return;
}
#endif
#endif
#ifdef FLEXIBLAS_HOOK_API
static TLS_STORE uint8_t hook_pos_chetf2 = 0;
#endif

/* Wrapper for chetf2 */
void FC_GLOBAL(chetf2,CHETF2)
    (char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *ipiv, void *info, flexiblas_fortran_charlen_t uplo_len);
    #ifdef FLEXIBLAS_HOOK_API
    void (*fn_hook) (void *uplo, void *n, void *a, void *lda, void *ipiv, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chetf2 = 0;
    #endif

    /* Post init if necessary */
    if ( unlikely(current_backend->post_init != 0) ) {
        __flexiblas_backend_init(current_backend);
        current_backend->post_init = 0;
    }

    *(void **) &fn = current_backend->lapack.chetf2;
    #ifdef FLEXIBLAS_HOOK_API
    *(void **) &fn_hook = __flexiblas_hooks->chetf2.hook_function[0];

    if ( fn_hook != NULL ) {
        fn_hook((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info, uplo_len);
    } else {
        fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info, uplo_len);
    }
    #else
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info, uplo_len);
    #endif
    return;
}

#ifndef __APPLE__
void FC_GLOBAL2(chetf2,CHETF2)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chetf2,CHETF2)))));
void FC_GLOBAL3(chetf2,CHETF2)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias(MTS(FC_GLOBAL(chetf2,CHETF2)))));
#else
void FC_GLOBAL2(chetf2,CHETF2)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chetf2,CHETF2)((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info, uplo_len);
}
void FC_GLOBAL3(chetf2,CHETF2)(char *uplo, blasint *n, lapack_complex_float *a, blasint *lda, blasint *ipiv, blasint *info, flexiblas_fortran_charlen_t uplo_len)
{
    FC_GLOBAL(chetf2,CHETF2)((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info, uplo_len);
}
#endif


#ifdef FLEXIBLAS_HOOK_API
void flexiblas_real_chetf2_(void *uplo, void *n, void *a, void *lda, void *ipiv, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *ipiv, void *info, flexiblas_fortran_charlen_t uplo_len);
    *(void **) &fn = current_backend->lapack.chetf2;
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_real_chetf2(void *uplo, void *n, void *a, void *lda, void *ipiv, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_real_chetf2_")));
#else
void flexiblas_real_chetf2(void *uplo, void *n, void *a, void *lda, void *ipiv, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_real_chetf2_((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info, uplo_len);
    return;
}
#endif

void flexiblas_chain_chetf2_(void *uplo, void *n, void *a, void *lda, void *ipiv, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    void (*fn) (void *uplo, void *n, void *a, void *lda, void *ipiv, void *info, flexiblas_fortran_charlen_t uplo_len);
    hook_pos_chetf2++;
    if ( hook_pos_chetf2 < __flexiblas_hooks->chetf2.nhook ) {
        *(void **) &fn = __flexiblas_hooks->chetf2.hook_function[hook_pos_chetf2];
    } else {
        hook_pos_chetf2 = 0;
        *(void **) &fn = current_backend->lapack.chetf2;
    }
    fn((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info, uplo_len);
    return;
}
#ifndef __APPLE__
void flexiblas_chain_chetf2(void *uplo, void *n, void *a, void *lda, void *ipiv, void *info, flexiblas_fortran_charlen_t uplo_len) __attribute__((alias("flexiblas_chain_chetf2_")));
#else
void flexiblas_chain_chetf2(void *uplo, void *n, void *a, void *lda, void *ipiv, void *info, flexiblas_fortran_charlen_t uplo_len)
{
    flexiblas_chain_chetf2_((void *) uplo, (void *) n, (void *) a, (void *) lda, (void *) ipiv, (void *) info, uplo_len);
    return;
}
#endif
#endif
#ifdef 