IF(${CMAKE_VERSION} VERSION_LESS "3.5.0")
    INCLUDE(CMakeParseArguments)
ENDIF()

SET(CUR_DIR ${CMAKE_CURRENT_LIST_DIR})


IF(NOT TARGET lua_include_gen)
    ADD_EXECUTABLE(lua_include_gen ${CMAKE_CURRENT_LIST_DIR}/lua_include_gen.c)
    TARGET_LINK_LIBRARIES(lua_include_gen cscutils)
    SET_TARGET_PROPERTIES(lua_include_gen PROPERTIES RUNTIME_OUTPUT_DIRECTORY ${PROJECT_BINARY_DIR})
ENDIF()

FUNCTION(CSC_LUA_ADD_INLINE_CODE TARGET LUA_SOURCE)
    GET_FILENAME_COMPONENT(LUA_FILE_NAME ${LUA_SOURCE} NAME)

    SET(OPTIONS)
    SET(OneValueOpts VARNAME FUNCTIONNAME)
    SET(MultiValueOpts)
    cmake_parse_arguments(LUA_INTERFACE "${OPTIONS}" "${OneValueOpts}" "${MultiValueOpts}" ${ARGN})

    SET(LUA_C_SOURCE_NAME ${LUA_FILE_NAME}.c)
    SET(LUA_OUTDIR "${PROJECT_BINARY_DIR}/lua_interface_tmp_dir/")
    SET(LUA_C_SOURCE "${LUA_OUTDIR}/${LUA_C_SOURCE_NAME}")

    FILE(MAKE_DIRECTORY "${LUA_OUTDIR}")

    # message(STATUS "\nVARNAME: ${LUA_INTERFACE_VARNAME}\n")
    # message(STATUS "\nFUNCNAME: ${LUA_INTERFACE_FUNCTIONNAME}\n")

    IF ( NOT LUA_INTERFACE_VARNAME )
        SET(LUA_INTERFACE_VARNAME "lua_inline_code_string")
    ENDIF()

    IF ( NOT LUA_INTERFACE_FUNCTIONNAME)
        SET(LUA_INTERFACE_FUNCTIONNAME "lua_inline_code")
    ENDIF()

    ADD_CUSTOM_COMMAND(
        OUTPUT ${LUA_C_SOURCE}
        COMMAND $<TARGET_FILE:lua_include_gen> -i ${LUA_SOURCE} -o ${LUA_C_SOURCE} -c "${LUA_INTERFACE_VARNAME}" -f "${LUA_INTERFACE_FUNCTIONNAME}"
        DEPENDS lua_include_gen
        MAIN_DEPENDENCY ${LUA_SOURCE})
    TARGET_SOURCES(${TARGET} PRIVATE ${LUA_C_SOURCE})


ENDFUNCTION()
