# Rcgen 0.12 to 0.13 Migration Guide

This document is a meant to be a helpful guide for some of the API changes made
between rcgen 0.12 and 0.13. For information on other changes in 0.13 see
[rcgen/CHANGELOG.md].

## Key Pairs

* Previously it was possible to have certificate generation automatically create
  a subject `KeyPair` for you by leaving the `key_pair` field of
  `CertificateParams` empty, and retrieving the generated `KeyPair` from
  a `Certificate` created with the `CertificateParams` by calling
  `Certificate::get_key_pair()`.

  To offer more consistency and to keep the `CertificateParams` and `Certificate`
  types from holding private key data, the new API requires you handle `KeyPair`
  creation yourself. See `CertifiedKey`, `KeyPair::generate()`,
  `KeyPair::generate_for()` and `KeyPair::generate_rsa_for()` for more information.

* Serializing a `Certificate`'s `KeyPair` to DER or PEM was previously done by
  calling `Certificate::serialize_private_key_der()` or
  `Certificate::serialize_private_key_pem()`. This is now handled by calling
  `KeyPair::serialize_der()` or `KeyPair::serialize_pem()`.

## Certificates

* For quick-and-easy self-signed certificate issuance,
  `generate_simple_self_signed` now returns a `CertifiedKey` in the success case
  instead of a `Certificate`. The self-signed `Certificate` can be accessed in
  the `cert` field of `CertifiedKey`, and the generated subject key pair in
  `key_pair`.

* Custom self-signed certificate issuance was previously done by
  constructing `CertificateParams` and calling `Certificate::from_params()` to
  create a `Certificate`. This is now done by calling
  `CertificateParams::self_signed()`, providing a subject `KeyPair` of your
  choosing.

* Custom certificate issuance signed by an issuer was previously done by
  constructing `CertificateParams`, calling `Certificate::from_params()` and
  then choosing the issuer at serialization time. This is now done ahead of
  serialization by calling `CertificateParams::signed_by()` and providing
  a subject `KeyPair` as well as an issuer `Certificate` and `KeyPair`.

* Previously certificate serialization was done by calling
  `Certificate::serialize_der()`, `Certificate::serialize_pem()`,
  `Certificate::serialize_der_with_signer()` or
  `Certificate::serialize_pem_with_signer()`. Each time a serialization fn was
  called a new certificate was issued, leading to confusion when it was desired
  to serialize the same certificate in two formats. In the new API issuance is
  handled by `CertificateParams` fns and the generated `Certificate` will not change
  when serialized. You can serialize it to PEM by calling `Certificate::pem()`,
  or access the DER encoding by calling `Certificate::der()`.

## Certificate Signing Requests (CSRs)

* Previously it was only possible to create a new CSR by first issuing
  a `Certificate` from `CertificateParams`, and calling
  `Certificate::serialize_request_pem()` or
  `Certificate::serialize_request_der()`. In the updated API you can create
  a `CertificateSigningRequest` directly from `CertificateParams` by calling
  `CertificateParams::serialize_request` and providing a subject `KeyPair`. You
  may serialize the CSR to DER or PEM by calling
  `CertificateSigningRequest::der()` or `CertificateSingingRequest::pem()`.

* To load a CSR from an existing PEM/DER copy with the old API required
  calling `CertificateSingingRequest::from_pem()` or
  `CertificateSigningRequest::from_der()`. The new API introduces
  a `CertificateSingingRequestParams` type that can be created using
  `CertificateSigningRequestParams::from_pem()` or
  `CertificateSingingRequest::from_der()`.

* To issue a certificate from an existing CSR with the old API required calling
  `CertificateSigningRequest::serialize_der_with_signer()` or
  `CertificateSigningRequest::serialize_pem_with_signer()`. In the new API, call
  `CertificateSigningRequestParams::signed_by()` and provide an issuer
  `Certificate` and `KeyPair`.

## Certificate Revocation Lists (CRLs)

* Previously a `CertificateRevocationList` was created by calling
  `CertificateRevocationList::from_params()`. This is now done by calling
  `CertificateRevocationListParams::signed_by()` and providing an issuer
  `Certificate` and `KeyPair`.

* Previously a created `CertificateRevocationList` could be serialized to DER or
  PEM by calling `CertificateRevocationList::serialize_der_with_signer()` or
  `CertificateRevocationList::serialize_pem_with_signer()`. This is now done by
  calling `CertificateRevocationList::der()` or
  `CertificateRevocationList::pem()`.
