/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinEnumEntryStubImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtEnumEntryElementType;", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinEnumEntryStubImpl;", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "<init>", "()V", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "serialize", "", "stub", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "indexStub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "psi-impl"})
public final class KtEnumEntryElementType
extends KtStubElementType<KotlinEnumEntryStubImpl, KtEnumEntry> {
    @NotNull
    public static final KtEnumEntryElementType INSTANCE = new KtEnumEntryElementType();

    private KtEnumEntryElementType() {
        super("ENUM_ENTRY", KtEnumEntry.class, KotlinClassStub.class);
    }

    @Override
    @NotNull
    public KotlinEnumEntryStubImpl createStub(@NotNull KtEnumEntry psi, @NotNull StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter(psi, "psi");
        Intrinsics.checkNotNullParameter(parentStub, "parentStub");
        FqName fqName = KtPsiUtilKt.safeFqNameForLazyResolve(psi);
        String fqName2 = fqName != null ? fqName.asString() : null;
        String name2 = psi.getName();
        boolean isLocal = psi.isLocal();
        return new KotlinEnumEntryStubImpl(parentStub, StringRef.fromString(fqName2), StringRef.fromString(name2), isLocal);
    }

    @Override
    public void serialize(@NotNull KotlinEnumEntryStubImpl stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter(stub, "stub");
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        FqName fqName = stub.getFqName();
        dataStream.writeName(fqName != null ? fqName.asString() : null);
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.isLocal());
    }

    @Override
    @NotNull
    public KotlinEnumEntryStubImpl deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        StringRef qualifiedName = dataStream.readName();
        StringRef name2 = dataStream.readName();
        boolean isLocal = dataStream.readBoolean();
        return new KotlinEnumEntryStubImpl(parentStub, qualifiedName, name2, isLocal);
    }

    @Override
    public void indexStub(@NotNull KotlinEnumEntryStubImpl stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub, "stub");
        Intrinsics.checkNotNullParameter(sink, "sink");
        StubIndexService.Companion.getInstance().indexClass(stub, sink);
    }
}

