Highlights
==========

Improved project URL usability
------------------------------

Charliecloud’s GitLab project used to be located at
`https://gitlab.com/charliecloud/main`, i.e. a project named `main` within a
group called `charliecloud`. This caused confusion, including (1) the default
branch is also caused `main` as well as (2) `git clone` yielding a directory
called `main`, which is unhelpfully vague. We have moved it to
`https://gitlab.com/charliecloud/charliecloud`, i.e. a project named
`charliecloud`, which we hope will reduce confusion (#1999). The old URL
should still work via a redirect in both Git and your browser.

Multi-threaded `libgc` compatibility
------------------------------------

Previously, `ch-run` was unable to create containers if linked with a `libgc`
that was multi-threaded by default, which is a common configuration, e.g.
RHEL 9 (#2027). (A key system call, `unshare(2)`, fails with `EINVAL` in a
multi-threaded process.) We fixed this by setting `libgc` to single-threaded
before initialization, which in theory degrades performance, but we assume
that’s negligible in a small program like Charliecloud.


Highlights in prior releases
============================

We forgot to put this in the e-mailed 0.40 release notes.

`ch-run` memory management
--------------------------

`ch-run`’s approach to memory changed in 0.40 (#2036). Previously, there was
some proper manual memory management (i.e., free every allocation exactly
once) mixed with a huge amount of leaking. We now optionally link with
[`libgc`](https://hboehm.info/gc/), the Boehm-Demers-Weiser conservative
garbage collector. This lets programmers treat memory allocation much like a
high-level language: allocate objects as needed, then forget about them when
done. The downsides of this approach seemed worth the programmer time savings,
even if libgc is not linked, in which case we just leak everything. For a more
detailed discussion, see our [contributors’ guide](https://charliecloud.io/latest/dev.html#memory-management).


Other changes by component
==========================

`ch-run`
--------

* Environment variables now set correctly under `--join` (#2043).
* `ch-run` and user command environment now handled separately (#2044).
* Fix a few incorrect integer sizes for 32-bit machines (#2059).

`ch-image`
----------

* Now compatible with Python’s FIPS mode (#1367).
* Minor performance improvement when building huge images (#2048).

Build/install
-------------

* Now builds correctly with:
  * Clang on Alpine Linux (#2015).
  * `-Werror=format-security` in some compilers that previously failed (#2032).
* Uses `-Wformat=2` by default if supported (#2035)
* Now compatible with BusyBox’ `install(1)` (#2037).
* Fix typo in `configure` (#2062).

Documentation/logging
---------------------

* Detailed install guide for newbies now available on wiki (#1936).
* Fix copyright language in docs (#1954).
* Development workflow revised to take advantage of GitLab features (#2054).
* Branch naming convention now actually documented (#1822).
* Add HPSF-approved governance docs (#2033) and update README (#2034).
* Fix typo (#2058).

Test/examples/CI
----------------

* Broaden CI to test:
  * Alpine (musl and Clang) (#1942).
  * Both garbage-collected and leaky builds (#2019)
  * A Red Hat type distribution (AlmaLinux) (#2029)
* Remove redundant merge train CI pipelines (#2042).
* Fix:
  * LOC script for newer `cloc` (#2045).
  * review reminder CI script (#2060).
  * CI failure due to Debian Buster EOL (#2061)

Miscellaneous
-------------

* Old GitHub Pages doc site now redirects to new docs URL (#1991).
* Website now accepts leading `www.` on URL (#1998).
* Update `packaging/requirements.txt` (#2057).
