# Copyright 2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

CRATES="
	addr2line@0.25.1
	adler2@2.0.1
	aho-corasick@1.1.4
	allocator-api2@0.2.21
	android_system_properties@0.1.5
	anstream@0.6.21
	anstyle-parse@0.2.7
	anstyle-query@1.1.5
	anstyle-wincon@3.0.11
	anstyle@1.0.13
	anyhow@1.0.101
	ar@0.9.0
	arrayref@0.3.9
	arrayvec@0.7.6
	atomic-polyfill@1.0.3
	atomic-take@1.1.0
	autocfg@1.5.0
	backtrace@0.3.76
	bitflags@2.10.0
	blake3@1.8.3
	block2@0.6.2
	bumpalo-herd@0.1.2
	bumpalo@3.19.1
	bytecount@0.6.9
	byteorder@1.5.0
	bytes@1.11.0
	bytesize@2.3.1
	cc@1.2.52
	cfg-if@1.0.4
	cfg_aliases@0.2.1
	clap@4.5.57
	clap_builder@4.5.57
	clap_derive@4.5.55
	clap_lex@0.7.7
	cobs@0.3.0
	colorchoice@1.0.4
	colored@3.1.1
	colosseum@0.2.2
	console@0.16.2
	constant_time_eq@0.4.2
	cpp_demangle@0.5.1
	cpufeatures@0.2.17
	crc32fast@1.5.0
	critical-section@1.2.0
	crossbeam-channel@0.5.15
	crossbeam-deque@0.8.6
	crossbeam-epoch@0.9.18
	crossbeam-queue@0.3.12
	crossbeam-utils@0.8.21
	debugid@0.8.0
	derive_more-impl@2.1.1
	derive_more@2.1.1
	dhat@0.3.3
	dispatch2@0.3.0
	either@1.15.0
	embedded-io@0.4.0
	embedded-io@0.6.1
	encode_unicode@1.0.0
	env_home@0.1.0
	equivalent@1.0.2
	errno@0.3.14
	fastrand@2.3.0
	find-msvc-tools@0.1.7
	flate2@1.1.9
	fnv@1.0.7
	foldhash@0.2.0
	futures-core@0.3.31
	futures-macro@0.3.31
	futures-task@0.3.31
	futures-timer@3.0.3
	futures-util@0.3.31
	getrandom@0.3.4
	gimli@0.32.3
	gimli@0.33.0
	git-version-macro@0.3.9
	git-version@0.3.9
	glob@0.3.3
	hash32@0.2.1
	hashbrown@0.16.1
	heapless@0.7.17
	heck@0.5.0
	hex@0.4.3
	iced-x86@1.21.0
	indexmap@2.13.0
	indicatif@0.18.3
	is_terminal_polyfill@1.70.2
	itertools@0.14.0
	itoa@1.0.17
	jobserver@0.1.34
	js-sys@0.3.83
	lazy_static@1.5.0
	leb128@0.2.5
	libc@0.2.180
	libloading@0.8.9
	libmimalloc-sys@0.1.44
	linux-raw-sys@0.11.0
	lock_api@0.4.14
	log@0.4.29
	matchers@0.2.0
	memchr@2.8.0
	memmap2@0.9.9
	mimalloc@0.1.48
	minimal-lexical@0.2.1
	miniz_oxide@0.8.9
	mintex@0.1.4
	nix@0.30.1
	nom@7.1.3
	num-traits@0.2.19
	objc2-cloud-kit@0.3.2
	objc2-core-data@0.3.2
	objc2-core-foundation@0.3.2
	objc2-core-graphics@0.3.2
	objc2-core-image@0.3.2
	objc2-core-location@0.3.2
	objc2-core-text@0.3.2
	objc2-encode@4.1.0
	objc2-foundation@0.3.2
	objc2-io-surface@0.3.2
	objc2-quartz-core@0.3.2
	objc2-ui-kit@0.3.2
	objc2-user-notifications@0.3.2
	objc2@0.6.3
	object@0.37.3
	object@0.38.1
	once_cell@1.21.3
	once_cell_polyfill@1.70.2
	os_info@3.14.0
	papergrid@0.17.0
	parking_lot@0.12.5
	parking_lot_core@0.9.12
	paste@1.0.15
	perf-event-open-sys@4.0.0
	perf-event@0.4.8
	perfetto-recorder@0.3.2
	pin-project-lite@0.2.16
	pin-utils@0.1.0
	pkg-config@0.3.32
	portable-atomic@1.13.0
	postcard@1.1.3
	ppv-lite86@0.2.21
	proc-macro-crate@3.4.0
	proc-macro-error-attr2@2.0.0
	proc-macro-error2@2.0.1
	proc-macro2@1.0.105
	prost-derive@0.14.3
	prost@0.14.3
	quote@1.0.43
	r-efi@5.3.0
	rand@0.9.2
	rand_chacha@0.9.0
	rand_core@0.9.5
	rayon-core@1.13.0
	rayon@1.11.0
	redox_syscall@0.5.18
	regex-automata@0.4.13
	regex-syntax@0.8.8
	regex@1.12.3
	relative-path@1.9.3
	remain@0.2.15
	rstest@0.26.1
	rstest_macros@0.26.1
	rustc-demangle@0.1.26
	rustc-hash@1.1.0
	rustc_version@0.4.1
	rustix@1.1.3
	rustversion@1.0.22
	scopeguard@1.2.0
	semver@1.0.27
	serde-keyvalue@0.1.0
	serde@1.0.228
	serde_core@1.0.228
	serde_derive@1.0.228
	serde_json@1.0.149
	serde_spanned@1.0.4
	sharded-offset-map@0.2.0
	sharded-slab@0.1.7
	sharded-vec-writer@0.3.0
	sharded-vec-writer@0.4.0
	shlex@1.3.0
	simd-adler32@0.3.8
	slab@0.4.11
	smallvec@1.15.1
	spin@0.9.8
	stable_deref_trait@1.2.1
	strsim@0.11.1
	strum@0.27.2
	strum_macros@0.27.2
	symbolic-common@12.17.2
	symbolic-demangle@12.17.2
	syn@2.0.114
	tabled@0.20.0
	tabled_derive@0.11.0
	tempfile@3.25.0
	testing_table@0.3.0
	thiserror-impl@1.0.69
	thiserror-impl@2.0.17
	thiserror@1.0.69
	thiserror@2.0.17
	thousands@0.2.0
	thread_local@1.1.9
	toml@0.9.11+spec-1.1.0
	toml_datetime@0.7.5+spec-1.1.0
	toml_edit@0.23.10+spec-1.0.0
	toml_parser@1.0.6+spec-1.1.0
	toml_writer@1.0.6+spec-1.1.0
	tracing-attributes@0.1.31
	tracing-core@0.1.36
	tracing-subscriber@0.3.22
	tracing@0.1.44
	unicode-ident@1.0.22
	unicode-width@0.2.2
	unicode-xid@0.2.6
	unit-prefix@0.5.2
	utf8parse@0.2.2
	uuid@1.20.0
	wait-timeout@0.2.1
	wait4@0.1.3
	wasip2@1.0.1+wasi-0.2.4
	wasm-bindgen-macro-support@0.2.106
	wasm-bindgen-macro@0.2.106
	wasm-bindgen-shared@0.2.106
	wasm-bindgen@0.2.106
	web-time@1.1.0
	which@8.0.0
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-link@0.2.1
	windows-sys@0.61.2
	winnow@0.7.14
	winsafe@0.0.19
	wit-bindgen@0.46.0
	zerocopy-derive@0.8.39
	zerocopy@0.8.39
	zlib-rs@0.6.0
	zmij@1.0.14
	zstd-safe@7.2.4
	zstd-sys@2.0.16+zstd.1.5.7
	zstd@0.13.3
"

LLVM_COMPAT=( {20..21} )
RUST_MIN_VER="1.92"
inherit cargo llvm-r2 unpacker

DESCRIPTION="A very fast linker for Linux"
HOMEPAGE="https://github.com/davidlattimore/wild"
if [[ ${PV} == *9999* ]]; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/davidlattimore/wild.git"
else
	SRC_URI="https://github.com/davidlattimore/wild/archive/${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"
	KEYWORDS="~amd64 ~arm64 ~riscv"
fi

LICENSE="|| ( Apache-2.0 MIT )"
# Dependent crate licenses
LICENSE+=" Apache-2.0 BSD-2 BSD ISC MIT MPL-2.0 Unicode-3.0 ZLIB"
SLOT="0"
# LTO disabled by default upstream
IUSE="lto test"
RESTRICT="!test? ( test )"

# TODO: blake3 still bundled?
# https://github.com/BLAKE3-team/BLAKE3/issues/130
# https://github.com/BLAKE3-team/BLAKE3/issues/425
RDEPEND="app-arch/zstd:="
DEPEND="${RDEPEND}"

# Upstream uses LLD and Clang for running some of their tests
BDEPEND="
	virtual/pkgconfig
	test? ( $(llvm_gen_dep '
			llvm-core/clang:${LLVM_SLOT}=
			llvm-core/lld:${LLVM_SLOT}=
		')
	)
"

QA_FLAGS_IGNORED="usr/bin/${PN}"

pkg_setup() {
	# zstd-sys https://wiki.gentoo.org/wiki/Project:Rust/sys_crates#zstd-sys
	export ZSTD_SYS_USE_PKG_CONFIG=1
	rust_pkg_setup
	use test && llvm-r2_pkg_setup
}

src_unpack() {
	if [[ ${PV} == *9999* ]]; then
		git-r3_src_unpack
		S="${S}/rust-src" cargo_live_src_unpack
	else
		unpacker ${P}.tar.gz
		cargo_src_unpack
	fi
}

src_configure() {
	# LTO linker plugin (experimental)
	local myfeatures=( $(usev lto plugins) )

	cargo_src_configure
}

src_install() {
	# Wild has a virtual Cargo.toml, so specify the path to the bin
	cargo_src_install --path "${S}/wild"

	dosym ${PN} /usr/bin/ld.${PN}
}
