# Copyright 2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.2

EAPI=8

CRATES="
	ahash@0.8.7
	allocator-api2@0.2.16
	anyhow@1.0.80
	autocfg@1.1.0
	bitflags@1.3.2
	bitflags@2.4.2
	cassowary@0.3.0
	castaway@0.2.2
	cc@1.0.83
	cfg-if@1.0.0
	cfg_aliases@0.1.1
	circular-buffer@0.1.6
	compact_str@0.7.1
	crossterm@0.27.0
	crossterm_winapi@0.9.1
	either@1.10.0
	equivalent@1.0.1
	hashbrown@0.14.3
	heck@0.4.1
	hermit-abi@0.3.5
	indexmap@2.2.2
	indoc@2.0.4
	itertools@0.12.1
	itoa@1.0.10
	lazy_static@1.4.0
	libbpf-rs@0.22.1
	libbpf-sys@1.3.0+v1.3.0
	libc@0.2.153
	lock_api@0.4.11
	log@0.4.20
	lru@0.12.2
	memchr@2.7.1
	memoffset@0.9.0
	mio@0.8.10
	nix@0.27.1
	nix@0.28.0
	num_cpus@1.16.0
	num_enum@0.5.11
	num_enum_derive@0.5.11
	once_cell@1.19.0
	parking_lot@0.12.1
	parking_lot_core@0.9.9
	paste@1.0.14
	pkg-config@0.3.29
	proc-macro-crate@1.3.1
	proc-macro2@1.0.78
	quote@1.0.35
	ratatui@0.26.1
	redox_syscall@0.4.1
	rustversion@1.0.14
	ryu@1.0.16
	scopeguard@1.2.0
	signal-hook-mio@0.2.3
	signal-hook-registry@1.4.1
	signal-hook@0.3.17
	smallvec@1.13.1
	stability@0.1.1
	static_assertions@1.1.0
	strum@0.26.1
	strum_macros@0.24.3
	strum_macros@0.26.1
	syn@1.0.109
	syn@2.0.48
	thiserror-impl@1.0.56
	thiserror@1.0.56
	toml_datetime@0.6.5
	toml_edit@0.19.15
	unicode-ident@1.0.12
	unicode-segmentation@1.11.0
	unicode-width@0.1.11
	version_check@0.9.4
	vsprintf@2.0.0
	wasi@0.11.0+wasi-snapshot-preview1
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-sys@0.48.0
	windows-targets@0.48.5
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_msvc@0.48.5
	windows_i686_gnu@0.48.5
	windows_i686_msvc@0.48.5
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_msvc@0.48.5
	winnow@0.5.39
	zerocopy-derive@0.7.32
	zerocopy@0.7.32
"

inherit desktop cargo

DESCRIPTION="Process monitor for BPF programs"
HOMEPAGE="https://github.com/Netflix/bpftop"
SRC_URI="
	https://github.com/Netflix/bpftop/archive/refs/tags/v${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"

LICENSE="Apache-2.0"
# Dependent crate licenses
LICENSE+="
	BSD-2 BSD MIT Unicode-DFS-2016
	|| ( Apache-2.0 Boost-1.0 )
"
SLOT="0"
KEYWORDS="~amd64"

QA_FLAGS_IGNORED="usr/bin/${PN}"

DOCS=(
	README.md
)

src_install() {
	cargo_src_install

	doicon bpftop-logo.png
	make_desktop_entry /usr/bin/${PN} bpftop-logo.png Development
}
