# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

FORTRAN_NEEDED=fortran

inherit cmake flag-o-matic fortran-2 optfeature

DESCRIPTION="Library to store and exchange meshed data or computation results"
HOMEPAGE="
	https://www.salome-platform.org/?page_id=2768
	https://docs.salome-platform.org/latest/dev/MEDCoupling/developer/med-file.html
"
# The original url blocks curl https://files.salome-platform.org/Salome/medfile/${P}.tar.bz2
# so we use the arch git mirror. It has the exact same files. The version 5.0.0 also does
# not exist as a tag in the linked github repo..., since med-files is a submodule of med.
SRC_URI="https://github.com/chennes/med/archive/refs/tags/v${PV}.tar.gz -> ${P}.gh.tar.gz"
LICENSE="LGPL-3"

SLOT="0"
KEYWORDS="amd64 ~x86"
IUSE="doc fortran mpi test"
RESTRICT="!test? ( test )"

RDEPEND="
	>=sci-libs/hdf5-1.12.1:=[fortran?,mpi(+)?]
	mpi? ( virtual/mpi[fortran?] )
"
DEPEND="${RDEPEND}"

PATCHES=(
	"${FILESDIR}/${PN}-5.0.0-0001-Gentoo-specific-Adjust-install-path-for-build-dir.patch"
	"${FILESDIR}/${PN}-4.1.0-0002-Re-add-option-for-building-Fortran-library.patch"
	# https://src.fedoraproject.org/rpms/med/raw/rawhide/f/hdf5-1.14.patch
	"${FILESDIR}/${PN}-5.0.0-hdf5-1.14.patch"
)

DOCS=( AUTHORS ChangeLog NEWS README README.CMAKE TODO )

src_prepare() {
	if use test; then
		# test10 only works with med 4.1.1, so we let MED detect the version itself
		# instead of hardcoding it to 5.0.0
		sed -i -e 's/MEDfileVersionOpen(filename,MODE_ACCES,MED_MAJOR_NUM,MED_MINOR_NUM,MED_RELEASE_NUM)/MEDfileOpen(filename,MODE_ACCES)/g' tests/c/test10*.c || die "could not patch test10"
	fi
	# gentoo package is called med, while the original is called med-fichier (med files)
	sed -e 's/med-fichier/med/' -i CMakeLists.txt || die "fix paths failed"
	sed -e 's|doc/med-${MED_STR_VERSION}|doc/'${PF}'/html|' \
		-i CMakeLists.txt || die "fix doc path failed"

	# bug #862900, already reported upstream. CHECK on updates!
	use fortran && filter-lto

	cmake_src_prepare
}

src_configure() {
	# bug #943874
	append-cflags -std=gnu17

	local mycmakeargs=(
		# as indicated in the CMakeLists.txt, the shipped documentation is generated by a custom doxygen,
		# so let's avoid rebuilding it because it will be different
		-DMEDFILE_BUILD_DOC=OFF
		-DMEDFILE_BUILD_FORTRAN=$(usex fortran)
		-DMEDFILE_BUILD_PYTHON=OFF
		-DMEDFILE_BUILD_SHARED_LIBS=ON
		-DMEDFILE_BUILD_STATIC_LIBS=OFF
		-DMEDFILE_BUILD_TESTS=$(usex test)
		-DMEDFILE_INSTALL_DOC=$(usex doc)
		-DMEDFILE_USE_MPI=$(usex mpi)
		-DMEDFILE_USE_UNICODE=ON
	)
	cmake_src_configure
}

src_test() {
	# override parallel mode only for tests
	cmake_src_test -j1
}

src_install() {
	cmake_src_install

	# we don't need old 2.3.6 include files
	rm -r "${ED}"/usr/include/2.3.6 || die "failed to delete obsolete include dir"

	# Prevent test executables being installed
	if use test; then
		rm -r "${ED}"/usr/bin/testc || die "failed to delete C test executables"
		if use fortran; then
			rm -r "${ED}"/usr/bin/testf || die "failed to delete fortran test executables"
		fi
	fi
}

pkg_postinst() {
	optfeature "xmdump scripts support" dev-lang/tk
}
