# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit dune

DESCRIPTION="Streaming client for OCaml's Memprof"
HOMEPAGE="https://github.com/janestreet/memtrace/"

if [[ "${PV}" == *9999* ]] ; then
	inherit git-r3

	EGIT_REPO_URI="https://github.com/janestreet/${PN}.git"
else
	SRC_URI="https://github.com/janestreet/${PN}/archive/v${PV}.tar.gz
		-> ${P}.tar.gz"

	KEYWORDS="~amd64 ~x86"
fi

LICENSE="MIT"
SLOT="0"
IUSE="+ocamlopt"
RESTRICT="test" # Very long bug #959363
