/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.sxpath.DedicatedStaticContext;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;

public class XPathCompiler {
    private Processor processor;
    private IndependentContext env;
    private ItemType requiredContextItemType;
    private Map<String, XPathExecutable> cache = null;

    protected XPathCompiler(Processor processor) {
        this.processor = processor;
        this.env = new IndependentContext(processor.getUnderlyingConfiguration());
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setBackwardsCompatible(boolean option) {
        if (this.isCaching()) {
            this.cache.clear();
        }
        this.env.setBackwardsCompatibilityMode(option);
    }

    public boolean isBackwardsCompatible() {
        return this.env.isInBackwardsCompatibleMode();
    }

    public void setSchemaAware(boolean schemaAware) {
        this.env.setSchemaAware(schemaAware);
    }

    public boolean isSchemaAware() {
        return this.env.isSchemaAware();
    }

    public void setLanguageVersion(String version) {
        DecimalValue dv;
        if (this.isCaching()) {
            this.cache.clear();
        }
        try {
            dv = (DecimalValue)DecimalValue.makeDecimalValue(version, true).asAtomic();
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Language version must be in the form of a decimal number");
        }
        if (DecimalValue.ONE.equals(dv)) {
            dv = DecimalValue.TWO;
            this.env.setBackwardsCompatibilityMode(true);
        }
        if (!(DecimalValue.ONE.equals(dv) || DecimalValue.TWO.equals(dv) || DecimalValue.THREE.equals(dv))) {
            throw new IllegalArgumentException("Unknown XPath language version " + version);
        }
        this.env.setXPathLanguageLevel(dv);
    }

    public String getLanguageVersion() {
        return this.env.getXPathLanguageLevel().equals(DecimalValue.TWO) ? "2.0" : "3.0";
    }

    public void setBaseURI(URI uri) {
        if (this.isCaching()) {
            this.cache.clear();
        }
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("Supplied base URI must be absolute");
        }
        this.env.setBaseURI(uri.toString());
    }

    public URI getBaseURI() {
        try {
            return new URI(this.env.getBaseURI());
        }
        catch (URISyntaxException err) {
            throw new IllegalStateException(err);
        }
    }

    public void declareNamespace(String prefix, String uri) {
        if (this.isCaching()) {
            this.cache.clear();
        }
        this.env.declareNamespace(prefix, uri);
    }

    public void importSchemaNamespace(String uri) {
        if (this.isCaching()) {
            this.cache.clear();
        }
        this.env.getImportedSchemaNamespaces().add(uri);
        this.env.setSchemaAware(true);
    }

    public void setAllowUndeclaredVariables(boolean allow) {
        if (this.isCaching()) {
            this.cache.clear();
        }
        this.env.setAllowUndeclaredVariables(allow);
    }

    public boolean isAllowUndeclaredVariables() {
        return this.env.isAllowUndeclaredVariables();
    }

    public void declareVariable(QName qname) {
        if (this.isCaching()) {
            this.cache.clear();
        }
        this.env.declareVariable(qname.getNamespaceURI(), qname.getLocalName());
    }

    public void declareVariable(QName qname, ItemType itemType, OccurrenceIndicator occurrences) throws SaxonApiException {
        if (this.isCaching()) {
            this.cache.clear();
        }
        XPathVariable var = this.env.declareVariable(qname.getNamespaceURI(), qname.getLocalName());
        var.setRequiredType(SequenceType.makeSequenceType(itemType.getUnderlyingItemType(), occurrences.getCardinality()));
    }

    public void setRequiredContextItemType(ItemType type) {
        this.requiredContextItemType = type;
        this.env.setRequiredContextItemType(type.getUnderlyingItemType());
    }

    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    public void setCaching(boolean caching) {
        if (caching) {
            if (this.cache == null) {
                this.cache = new ConcurrentHashMap<String, XPathExecutable>();
            }
        } else {
            this.cache = null;
        }
    }

    public boolean isCaching() {
        return this.cache != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XPathExecutable compile(String source) throws SaxonApiException {
        if (this.isCaching()) {
            XPathCompiler xPathCompiler = this;
            synchronized (xPathCompiler) {
                XPathExecutable expr = this.cache.get(source);
                if (expr == null) {
                    expr = this.internalCompile(source);
                    this.cache.put(source, expr);
                }
                return expr;
            }
        }
        return this.internalCompile(source);
    }

    private XPathExecutable internalCompile(String source) throws SaxonApiException {
        IndependentContext ic = this.env;
        if (ic.isAllowUndeclaredVariables()) {
            ic = new DedicatedStaticContext(this.env);
            Iterator<XPathVariable> iter = this.env.iterateExternalVariables();
            while (iter.hasNext()) {
                XPathVariable var = iter.next();
                XPathVariable var2 = ic.declareVariable(var.getVariableQName());
                var2.setRequiredType(var.getRequiredType());
            }
        }
        try {
            XPathEvaluator eval = new XPathEvaluator(this.processor.getUnderlyingConfiguration());
            eval.setStaticContext(ic);
            XPathExpression cexp = eval.createExpression(source);
            return new XPathExecutable(cexp, this.processor, ic);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XdmValue evaluate(String expression, XdmItem contextItem) throws SaxonApiException {
        XPathSelector selector = this.compile(expression).load();
        if (contextItem != null) {
            selector.setContextItem(contextItem);
        }
        return selector.evaluate();
    }

    public XdmItem evaluateSingle(String expression, XdmItem contextItem) throws SaxonApiException {
        XPathSelector selector = this.compile(expression).load();
        if (contextItem != null) {
            selector.setContextItem(contextItem);
        }
        return selector.evaluateSingle();
    }

    public XPathExecutable compilePattern(String source) throws SaxonApiException {
        try {
            XPathEvaluator eval = new XPathEvaluator(this.processor.getUnderlyingConfiguration());
            eval.setStaticContext(this.env);
            XPathExpression cexp = eval.createPattern(source);
            return new XPathExecutable(cexp, this.processor, this.env);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public StaticContext getUnderlyingStaticContext() {
        return this.env;
    }
}

