/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.net;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.DefaultModuleDescriptor;
import fr.jayasoft.ivy.DependencyResolver;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.MDArtifact;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.report.ArtifactDownloadReport;
import fr.jayasoft.ivy.report.DownloadStatus;
import fr.jayasoft.ivy.resolver.FileSystemResolver;
import fr.jayasoft.ivy.resolver.IvyRepResolver;
import fr.jayasoft.ivy.resolver.URLResolver;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.ImportTask;

public class URLImportTask
extends Task {
    private String org;
    private String module;
    private String rev = "latest.integration";
    private String type = "jar";
    private String repositoryUrl;
    private String repositoryDir;
    private URL ivyConfUrl;
    private File ivyConfFile;
    private String artifactPattern = "/[org]/[module]/[ext]s/[module]-[revision].[ext]";
    private String ivyPattern = "/[org]/[module]/ivy-[revision].xml";

    public void setModule(String module) {
        this.module = module;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public void setRev(String rev) {
        this.rev = rev;
    }

    public void setIvyConfFile(File ivyConfFile) {
        this.ivyConfFile = ivyConfFile;
    }

    public void setIvyConfUrl(URL ivyConfUrl) {
        this.ivyConfUrl = ivyConfUrl;
    }

    public void execute() throws BuildException {
        Ivy ivy = new Ivy();
        URLResolver resolver = null;
        Object rep = null;
        if (this.repositoryUrl != null) {
            resolver = new URLResolver();
            resolver.addArtifactPattern(this.repositoryUrl + "/" + this.artifactPattern);
            resolver.addIvyPattern(this.repositoryUrl + "/" + this.ivyPattern);
            resolver.setName("default");
        } else if (this.repositoryDir != null) {
            resolver = new FileSystemResolver();
            ((FileSystemResolver)resolver).addArtifactPattern(this.repositoryDir + "/" + this.artifactPattern);
            ((FileSystemResolver)resolver).addIvyPattern(this.repositoryDir + "/" + this.ivyPattern);
        } else if (this.ivyConfUrl != null) {
            try {
                ivy.configure(this.ivyConfUrl);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            catch (ParseException e) {
                throw new BuildException((Throwable)e);
            }
        } else if (this.ivyConfFile != null) {
            try {
                ivy.configure(this.ivyConfFile);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            catch (ParseException e) {
                throw new BuildException((Throwable)e);
            }
        } else {
            resolver = new IvyRepResolver();
        }
        resolver.setName("default");
        ivy.addResolver((DependencyResolver)resolver);
        ivy.setDefaultResolver(resolver.getName());
        ModuleId moduleId = new ModuleId(this.org, this.module);
        ModuleRevisionId revId = new ModuleRevisionId(moduleId, this.rev);
        DefaultModuleDescriptor md = new DefaultModuleDescriptor(revId, "integration", new Date());
        MDArtifact artifact = new MDArtifact((ModuleDescriptor)md, this.module, this.type, this.type);
        ArtifactDownloadReport report = ivy.download((Artifact)artifact, null);
        DownloadStatus status = report.getDownloadStatus();
        if (status == DownloadStatus.FAILED) {
            throw new BuildException("Could not resolve resource.");
        }
        String path = ivy.getArchivePathInCache((Artifact)artifact);
        File file = new File(ivy.getDefaultCache(), path);
        File importFile = null;
        if ("xml".equalsIgnoreCase(this.type)) {
            importFile = file;
        } else if ("jar".equalsIgnoreCase(this.type)) {
            File dir = new File(file.getParentFile(), file.getName() + ".extracted");
            dir.mkdir();
            Expand expand = (Expand)this.getProject().createTask("unjar");
            expand.setSrc(file);
            expand.setDest(dir);
            expand.perform();
            importFile = new File(dir, "build.xml");
            if (!importFile.exists()) {
                throw new BuildException("Cannot find a 'build.xml' file in " + file.getName());
            }
        } else {
            throw new BuildException("Don't know what to do with type: " + this.type);
        }
        File buildFile = null;
        ImportTask importTask = new ImportTask();
        importTask.setProject(this.getProject());
        importTask.setOwningTarget(this.getOwningTarget());
        importTask.setLocation(this.getLocation());
        importTask.setFile(buildFile.getAbsolutePath());
        importTask.perform();
        this.log("Import complete.", 2);
    }
}

