/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.expr.sort.IntIterator;
import net.sf.saxon.expr.sort.IntToIntHashMap;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.style.CollationDeclaration;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetFunctionLibrary;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLImportSchema;
import net.sf.saxon.style.XSLNamespaceAlias;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.StripSpaceRules;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrincipalStylesheetModule
extends StylesheetModule {
    private static final boolean TIMING = false;
    private PreparedStylesheet preparedStylesheet;
    private HashSet<String> schemaIndex = new HashSet(10);
    private XQueryFunctionLibrary queryFunctions;
    private FunctionLibraryList functionLibrary;
    private String version;
    private HashMap<StructuredQName, Declaration> globalVariableIndex = new HashMap(20);
    private HashMap<StructuredQName, Declaration> templateIndex = new HashMap(20);
    private IntHashMap<HashMap<StructuredQName, Declaration>> functionIndex = new IntHashMap(8);
    private HashMap<StructuredQName, Integer> localParameterNumbers = null;
    private int numberOfAliases = 0;
    private List<Declaration> namespaceAliasList = new ArrayList<Declaration>(5);
    private IntToIntHashMap namespaceAliasMap;
    private IntHashSet aliasResultUriSet;
    private boolean needsDynamicOutputProperties = false;
    private int largestPatternStackFrame = 0;
    private HashMap<DocumentURI, XSLStylesheet> moduleCache = new HashMap(4);

    public PrincipalStylesheetModule(XSLStylesheet sourceElement, int precedence) {
        super(sourceElement, precedence);
    }

    public void setPreparedStylesheet(PreparedStylesheet preparedStylesheet) {
        this.preparedStylesheet = preparedStylesheet;
    }

    public PreparedStylesheet getPreparedStylesheet() {
        return this.preparedStylesheet;
    }

    @Override
    public PrincipalStylesheetModule getPrincipalStylesheetModule() {
        return this;
    }

    public FunctionLibraryList createFunctionLibrary() {
        Configuration config = this.getPreparedStylesheet().getConfiguration();
        this.functionLibrary = new FunctionLibraryList();
        int functionSet = 3;
        if ("3.0".equals(this.getVersion())) {
            functionSet |= 0x50;
        }
        this.functionLibrary.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(functionSet));
        this.functionLibrary.addFunctionLibrary(new StylesheetFunctionLibrary(this, true));
        this.functionLibrary.addFunctionLibrary(config.getVendorFunctionLibrary());
        this.functionLibrary.addFunctionLibrary(new ConstructorFunctionLibrary(config));
        this.queryFunctions = new XQueryFunctionLibrary(config);
        this.functionLibrary.addFunctionLibrary(this.queryFunctions);
        this.functionLibrary.addFunctionLibrary(config.getIntegratedFunctionLibrary());
        config.addExtensionBinders(this.functionLibrary);
        this.functionLibrary.addFunctionLibrary(new StylesheetFunctionLibrary(this, false));
        return this.functionLibrary;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public void declareXQueryFunction(XQueryFunction function) throws XPathException {
        this.queryFunctions.declareFunction(function);
    }

    public void putStylesheetDocument(DocumentURI key, XSLStylesheet module) {
        this.moduleCache.put(key, module);
    }

    public XSLStylesheet getStylesheetDocument(DocumentURI key) {
        XSLStylesheet sheet = this.moduleCache.get(key);
        if (sheet != null) {
            TransformerException warning = new TransformerException("Stylesheet module " + key + " is included or imported more than once. " + "This is permitted, but may lead to errors or unexpected behavior");
            this.getPreparedStylesheet().reportWarning(warning);
        }
        return sheet;
    }

    public void preprocess() throws XPathException {
        Declaration decl;
        this.spliceIncludes();
        this.buildIndexes();
        this.checkForSchemaAwareness();
        this.processAllAttributes();
        this.collectNamespaceAliases();
        for (int i = 0; i < this.topLevel.size(); ++i) {
            decl = (Declaration)this.topLevel.get(i);
            StyleElement inst = decl.getSourceElement();
            if (inst.isActionCompleted(16)) continue;
            inst.setActionCompleted(16);
            inst.fixupReferences();
        }
        XSLStylesheet top = this.getSourceElement();
        this.setInputTypeAnnotations(top.getInputTypeAnnotationsAttribute());
        decl = new Declaration(this, top);
        if (!top.isActionCompleted(1)) {
            top.setActionCompleted(1);
            top.validate(decl);
            for (int i = 0; i < this.topLevel.size(); ++i) {
                decl = (Declaration)this.topLevel.get(i);
                decl.getSourceElement().validateSubtree(decl);
            }
        }
    }

    private void buildIndexes() throws XPathException {
        for (int i = this.topLevel.size() - 1; i >= 0; --i) {
            Declaration decl = (Declaration)this.topLevel.get(i);
            decl.getSourceElement().index(decl, this);
        }
        Configuration config = this.getPreparedStylesheet().getConfiguration();
        for (String ns : this.schemaIndex) {
            config.sealNamespace(ns);
        }
    }

    public void processAllAttributes() throws XPathException {
        this.getSourceElement().processDefaultCollationAttribute("");
        this.getSourceElement().prepareAttributes();
        for (int i = 0; i < this.topLevel.size(); ++i) {
            Declaration decl = (Declaration)this.topLevel.get(i);
            StyleElement inst = decl.getSourceElement();
            if (inst.isActionCompleted(32)) continue;
            inst.setActionCompleted(32);
            try {
                inst.processAllAttributes();
                continue;
            }
            catch (XPathException err) {
                decl.getSourceElement().compileError(err);
            }
        }
    }

    protected void indexFunction(Declaration decl) throws XPathException {
        int arity;
        XSLFunction function = (XSLFunction)decl.getSourceElement();
        StructuredQName qName = function.getObjectName();
        Declaration other = this.getFunctionDeclaration(qName, arity = function.getNumberOfArguments());
        if (other == null) {
            this.putFunction(decl);
        } else {
            int otherPrecedence;
            int thisPrecedence = decl.getPrecedence();
            if (thisPrecedence == (otherPrecedence = other.getPrecedence())) {
                StyleElement f2 = other.getSourceElement();
                if (decl.getSourceElement() == f2) {
                    function.compileError("Function " + qName.getDisplayName() + " is declared more than once " + "(caused by including the containing module more than once)", "XTSE0770");
                } else {
                    function.compileError("Duplicate function declaration (see line " + f2.getLineNumber() + " of " + f2.getSystemId() + ')', "XTSE0770");
                }
            } else if (thisPrecedence >= otherPrecedence) {
                this.putFunction(decl);
            }
        }
    }

    protected Declaration getFunctionDeclaration(StructuredQName name, int arity) {
        HashMap<StructuredQName, Declaration> m = this.functionIndex.get(arity);
        return m == null ? null : m.get(name);
    }

    protected XSLFunction getFunction(StructuredQName name, int arity) {
        if (arity == -1) {
            IntIterator arities = this.functionIndex.keyIterator();
            while (arities.hasNext()) {
                int a = arities.next();
                Declaration decl = this.getFunctionDeclaration(name, a);
                if (decl == null) continue;
                return (XSLFunction)decl.getSourceElement();
            }
            return null;
        }
        Declaration decl = this.getFunctionDeclaration(name, arity);
        return decl == null ? null : (XSLFunction)decl.getSourceElement();
    }

    protected void putFunction(Declaration decl) {
        XSLFunction function = (XSLFunction)decl.getSourceElement();
        StructuredQName qName = function.getObjectName();
        int arity = function.getNumberOfArguments();
        HashMap<StructuredQName, Declaration> m = this.functionIndex.get(arity);
        if (m == null) {
            m = new HashMap();
            this.functionIndex.put(arity, m);
        }
        m.put(qName, decl);
    }

    protected void indexVariableDeclaration(Declaration decl) throws XPathException {
        XSLVariableDeclaration var = (XSLVariableDeclaration)decl.getSourceElement();
        StructuredQName qName = var.getVariableQName();
        if (qName != null) {
            Declaration other = this.globalVariableIndex.get(qName);
            if (other == null) {
                this.globalVariableIndex.put(qName, decl);
            } else {
                int otherPrecedence;
                int thisPrecedence = decl.getPrecedence();
                if (thisPrecedence == (otherPrecedence = other.getPrecedence())) {
                    StyleElement v2 = other.getSourceElement();
                    if (v2 == var) {
                        var.compileError("Global variable " + qName.getDisplayName() + " is declared more than once " + "(caused by including the containing module more than once)", "XTSE0630");
                    } else {
                        var.compileError("Duplicate global variable declaration (see line " + v2.getLineNumber() + " of " + v2.getSystemId() + ')', "XTSE0630");
                    }
                } else if (thisPrecedence < otherPrecedence && var != other.getSourceElement()) {
                    var.setRedundant();
                } else if (var != other.getSourceElement()) {
                    ((XSLVariableDeclaration)other.getSourceElement()).setRedundant();
                    this.globalVariableIndex.put(qName, decl);
                }
            }
        }
    }

    public XSLVariableDeclaration getGlobalVariable(StructuredQName qName) {
        Declaration decl = this.globalVariableIndex.get(qName);
        return decl == null ? null : (XSLVariableDeclaration)decl.getSourceElement();
    }

    public int allocateUniqueParameterNumber(StructuredQName qName) {
        Integer x;
        if (this.localParameterNumbers == null) {
            this.localParameterNumbers = new HashMap(50);
        }
        if ((x = this.localParameterNumbers.get(qName)) == null) {
            x = this.localParameterNumbers.size();
            this.localParameterNumbers.put(qName, x);
        }
        return x;
    }

    protected void indexNamedTemplate(Declaration decl) throws XPathException {
        XSLTemplate template = (XSLTemplate)decl.getSourceElement();
        StructuredQName qName = template.getTemplateName();
        if (qName != null) {
            Executable exec = this.getPreparedStylesheet().getExecutable();
            Declaration other = this.templateIndex.get(qName);
            if (other == null) {
                this.templateIndex.put(qName, decl);
                this.getPreparedStylesheet().putNamedTemplate(qName, template.getCompiledTemplate());
            } else {
                int otherPrecedence;
                int thisPrecedence = decl.getPrecedence();
                if (thisPrecedence == (otherPrecedence = other.getPrecedence())) {
                    StyleElement t2 = other.getSourceElement();
                    template.compileError("Duplicate named template (see line " + t2.getLineNumber() + " of " + t2.getSystemId() + ')', "XTSE0660");
                } else if (thisPrecedence >= otherPrecedence) {
                    this.templateIndex.put(qName, decl);
                    this.getPreparedStylesheet().putNamedTemplate(qName, template.getCompiledTemplate());
                }
            }
        }
    }

    public XSLTemplate getNamedTemplate(StructuredQName name) {
        Declaration decl = this.templateIndex.get(name);
        return decl == null ? null : (XSLTemplate)decl.getSourceElement();
    }

    private void checkForSchemaAwareness() {
        Executable exec = this.getPreparedStylesheet().getExecutable();
        if (!exec.isSchemaAware() && exec.getConfiguration().isLicensedFeature(2)) {
            for (int i = 0; i < this.topLevel.size(); ++i) {
                Object node = this.topLevel.get(i);
                if (!(node instanceof XSLImportSchema)) continue;
                exec.setSchemaAware(true);
                return;
            }
        }
    }

    protected void addNamespaceAlias(Declaration node) {
        this.namespaceAliasList.add(node);
        ++this.numberOfAliases;
    }

    protected int getNamespaceAlias(short uriCode) {
        int alias = this.namespaceAliasMap.get(uriCode);
        return alias == this.namespaceAliasMap.getDefaultValue() ? uriCode : alias;
    }

    protected boolean isAliasResultNamespace(short uriCode) {
        return this.aliasResultUriSet.contains(uriCode);
    }

    private void collectNamespaceAliases() throws XPathException {
        this.namespaceAliasMap = new IntToIntHashMap(this.numberOfAliases);
        this.aliasResultUriSet = new IntHashSet(this.numberOfAliases);
        IntHashSet aliasesAtThisPrecedence = new IntHashSet();
        int currentPrecedence = -1;
        for (int i = 0; i < this.numberOfAliases; ++i) {
            Declaration decl = this.namespaceAliasList.get(i);
            XSLNamespaceAlias xna = (XSLNamespaceAlias)decl.getSourceElement();
            short scode = xna.getStylesheetURICode();
            int ncode = xna.getResultNamespaceCode();
            int prec = decl.getPrecedence();
            if (currentPrecedence != prec) {
                currentPrecedence = prec;
                aliasesAtThisPrecedence.clear();
            }
            if (aliasesAtThisPrecedence.contains(scode) && this.namespaceAliasMap.get(scode) != (ncode & 0xFFFF)) {
                xna.compileError("More than one alias is defined for the same namespace", "XTSE0810");
            }
            if (this.namespaceAliasMap.get(scode) == this.namespaceAliasMap.getDefaultValue()) {
                this.namespaceAliasMap.put(scode, ncode);
                this.aliasResultUriSet.add(ncode & 0xFFFF);
            }
            aliasesAtThisPrecedence.add(scode);
        }
        this.namespaceAliasList = null;
    }

    protected boolean hasNamespaceAliases() {
        return this.numberOfAliases > 0;
    }

    public CollationMap getCollationMap() {
        Executable exec = this.getPreparedStylesheet().getExecutable();
        return exec.getCollationTable();
    }

    public void setCollation(String name, StringCollator collation) {
        Executable exec = this.getPreparedStylesheet().getExecutable();
        if (exec.getCollationTable() == null) {
            exec.setCollationTable(new CollationMap(exec.getConfiguration()));
        }
        exec.getCollationTable().setNamedCollation(name, collation);
    }

    protected StringCollator findCollation(String name, String baseURI) {
        Executable exec = this.getPreparedStylesheet().getExecutable();
        Configuration config = exec.getConfiguration();
        if (name.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        StringCollator c = null;
        if (exec.getCollationTable() != null) {
            c = exec.getCollationTable().getNamedCollation(name);
        }
        if (c != null) {
            return c;
        }
        for (int i = this.topLevel.size() - 1; i >= 0; --i) {
            CollationDeclaration t;
            Declaration decl = (Declaration)this.topLevel.get(i);
            if (!(decl.getSourceElement() instanceof CollationDeclaration) || !(t = (CollationDeclaration)((Object)decl.getSourceElement())).getCollationName().equals(name)) continue;
            return t.getCollator();
        }
        return config.getCollationURIResolver().resolve(name, baseURI, config);
    }

    public Properties gatherOutputProperties(StructuredQName formatQName) throws XPathException {
        boolean found = formatQName == null;
        Configuration config = this.getPreparedStylesheet().getConfiguration();
        Properties details = new Properties(config.getDefaultSerializationProperties());
        HashMap precedences = new HashMap(10);
        for (int i = this.topLevel.size() - 1; i >= 0; --i) {
            Declaration decl = (Declaration)this.topLevel.get(i);
            if (!(decl.getSourceElement() instanceof XSLOutput)) continue;
            XSLOutput xo = (XSLOutput)decl.getSourceElement();
            if (!(formatQName == null ? xo.getFormatQName() == null : formatQName.equals(xo.getFormatQName()))) continue;
            found = true;
            xo.gatherOutputProperties(details, precedences, decl.getPrecedence());
        }
        if (!found) {
            this.compileError("Requested output format " + formatQName.getDisplayName() + " has not been defined", "XTDE1460");
        }
        return details;
    }

    public void compileStylesheet() throws XPathException {
        block28: {
            try {
                Declaration decl;
                StyleElement node;
                StyleElement snode;
                Declaration decl2;
                int i;
                PreparedStylesheet pss = this.getPreparedStylesheet();
                Configuration config = pss.getConfiguration();
                Executable exec = pss.getExecutable();
                try {
                    Iterator<XQueryFunction> qf = this.queryFunctions.getFunctionDefinitions();
                    while (qf.hasNext()) {
                        XQueryFunction f = qf.next();
                        f.fixupReferences();
                    }
                }
                catch (XPathException e) {
                    this.compileError(e);
                }
                for (i = 0; i < this.topLevel.size(); ++i) {
                    decl2 = (Declaration)this.topLevel.get(i);
                    snode = decl2.getSourceElement();
                    if (!(snode instanceof XSLTemplate)) continue;
                    ((XSLTemplate)snode).register(decl2);
                }
                for (i = 0; i < this.topLevel.size(); ++i) {
                    decl2 = (Declaration)this.topLevel.get(i);
                    snode = decl2.getSourceElement();
                    if (snode.isActionCompleted(2)) continue;
                    snode.setActionCompleted(2);
                    Expression inst = snode.compile(exec, decl2);
                    if (inst == null) continue;
                    inst.setLocationId(snode.allocateLocationId(snode.getSystemId(), snode.getLineNumber()));
                }
                IntIterator arities = this.functionIndex.keyIterator();
                while (arities.hasNext()) {
                    for (Declaration decl3 : this.functionIndex.get(arities.next()).values()) {
                        node = decl3.getSourceElement();
                        if (node.isActionCompleted(4)) continue;
                        node.setActionCompleted(4);
                        ((XSLFunction)node).typeCheckBody();
                    }
                }
                if (this.getPreparedStylesheet().getErrorCount() > 0) {
                    return;
                }
                for (int i2 = 0; i2 < this.topLevel.size(); ++i2) {
                    decl2 = (Declaration)this.topLevel.get(i2);
                    StyleElement node2 = decl2.getSourceElement();
                    if (!(node2 instanceof StylesheetProcedure) || node2 instanceof XSLFunction || node2.isActionCompleted(8)) continue;
                    node2.setActionCompleted(8);
                    ((StylesheetProcedure)((Object)node2)).optimize(decl2);
                }
                arities = this.functionIndex.keyIterator();
                while (arities.hasNext()) {
                    for (Declaration decl3 : this.functionIndex.get(arities.next()).values()) {
                        node = decl3.getSourceElement();
                        if (node.isActionCompleted(8)) continue;
                        node.setActionCompleted(8);
                        ((StylesheetProcedure)((Object)node)).optimize(decl3);
                    }
                }
                if (pss.getDecimalFormatManager() != null) {
                    try {
                        pss.getDecimalFormatManager().fixupDefaultDefault();
                    }
                    catch (XPathException err) {
                        this.compileError(err.getMessage(), err.getErrorCodeLocalPart());
                    }
                }
                exec.setStripsWhitespace(this.stripsWhitespace());
                Properties props = this.gatherOutputProperties(null);
                props.setProperty("{http://saxon.sf.net/}stylesheet-version", this.getVersion());
                exec.setDefaultOutputProperties(props);
                HashSet<StructuredQName> outputNames = new HashSet<StructuredQName>(5);
                for (int i3 = 0; i3 < this.topLevel.size(); ++i3) {
                    XSLOutput out;
                    StructuredQName qName;
                    decl = (Declaration)this.topLevel.get(i3);
                    if (!(decl.getSourceElement() instanceof XSLOutput) || (qName = (out = (XSLOutput)decl.getSourceElement()).getFormatQName()) == null) continue;
                    outputNames.add(qName);
                }
                if (outputNames.isEmpty()) {
                    if (this.needsDynamicOutputProperties) {
                        this.compileError("The stylesheet contains xsl:result-document instructions that calculate the output format name at run-time, but there are no named xsl:output declarations", "XTDE1460");
                    }
                } else {
                    for (StructuredQName qName : outputNames) {
                        Properties oprops = this.gatherOutputProperties(qName);
                        if (!this.needsDynamicOutputProperties) continue;
                        exec.setOutputProperties(qName, oprops);
                    }
                }
                exec.setPatternSlotSpace(this.largestPatternStackFrame);
                exec.setStripsInputTypeAnnotations(this.getInputTypeAnnotations() == 1);
                for (int i4 = 0; i4 < this.topLevel.size(); ++i4) {
                    XSLCharacterMap t;
                    decl = (Declaration)this.topLevel.get(i4);
                    if (!(decl.getSourceElement() instanceof XSLCharacterMap) || (t = (XSLCharacterMap)decl.getSourceElement()).isRedundant()) continue;
                    StructuredQName qn = t.getCharacterMapName();
                    IntHashMap<String> charMap = new IntHashMap<String>();
                    t.assemble(charMap);
                    CharacterMap map = new CharacterMap(charMap);
                    if (exec.getCharacterMapIndex() == null) {
                        exec.setCharacterMapIndex(new CharacterMapIndex());
                    }
                    exec.getCharacterMapIndex().putCharacterMap(qn, map);
                }
                RuleManager ruleManager = this.getPreparedStylesheet().getRuleManager();
                ruleManager.computeRankings();
                ruleManager.invertStreamableTemplates(config.getOptimizer());
                ExecutableFunctionLibrary overriding = new ExecutableFunctionLibrary(config);
                ExecutableFunctionLibrary underriding = new ExecutableFunctionLibrary(config);
                for (int i5 = 0; i5 < this.topLevel.size(); ++i5) {
                    Declaration decl4 = (Declaration)this.topLevel.get(i5);
                    if (!(decl4.getSourceElement() instanceof XSLFunction)) continue;
                    XSLFunction func = (XSLFunction)decl4.getSourceElement();
                    if (func.isOverriding()) {
                        overriding.addFunction(func.getCompiledFunction());
                        continue;
                    }
                    underriding.addFunction(func.getCompiledFunction());
                }
                FunctionLibraryList libraryList = new FunctionLibraryList();
                for (FunctionLibrary lib : this.functionLibrary.getLibraryList()) {
                    if (lib instanceof StylesheetFunctionLibrary) {
                        if (((StylesheetFunctionLibrary)lib).isOverriding()) {
                            libraryList.addFunctionLibrary(overriding);
                            continue;
                        }
                        libraryList.addFunctionLibrary(underriding);
                        continue;
                    }
                    libraryList.addFunctionLibrary(lib);
                }
                exec.setFunctionLibrary(libraryList);
            }
            catch (RuntimeException err) {
                if (this.getPreparedStylesheet().getErrorCount() != 0) break block28;
                throw err;
            }
        }
    }

    protected boolean isImportedSchema(String targetNamespace) {
        return this.schemaIndex.contains(targetNamespace);
    }

    protected void addImportedSchema(String targetNamespace) {
        this.schemaIndex.add(targetNamespace);
    }

    protected HashSet<String> getImportedSchemaTable() {
        return this.schemaIndex;
    }

    protected boolean getAttributeSets(StructuredQName name, List<Declaration> list) throws XPathException {
        boolean found = false;
        for (int i = 0; i < this.topLevel.size(); ++i) {
            XSLAttributeSet t;
            Declaration decl = (Declaration)this.topLevel.get(i);
            if (!(decl.getSourceElement() instanceof XSLAttributeSet) || !(t = (XSLAttributeSet)decl.getSourceElement()).getAttributeSetName().equals(name)) continue;
            t.incrementReferenceCount();
            list.add(decl);
            found = true;
        }
        return found;
    }

    public boolean stripsWhitespace() {
        for (int i = 0; i < this.topLevel.size(); ++i) {
            StyleElement s = ((Declaration)this.topLevel.get(i)).getSourceElement();
            if (s.getFingerprint() != 198) continue;
            return true;
        }
        return false;
    }

    protected StripSpaceRules getStripperRules() {
        Executable exec = this.getPreparedStylesheet().getExecutable();
        if (exec.getStripperRules() == null) {
            exec.setStripperRules(new StripSpaceRules());
        }
        return exec.getStripperRules();
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setNeedsDynamicOutputProperties(boolean b) {
        this.needsDynamicOutputProperties = b;
    }

    public Declaration getCharacterMap(StructuredQName name) {
        for (int i = this.topLevel.size() - 1; i >= 0; --i) {
            XSLCharacterMap t;
            Declaration decl = (Declaration)this.topLevel.get(i);
            if (!(decl.getSourceElement() instanceof XSLCharacterMap) || !(t = (XSLCharacterMap)decl.getSourceElement()).getCharacterMapName().equals(name)) continue;
            return decl;
        }
        return null;
    }

    public void allocatePatternSlots(int n) {
        if (n > this.largestPatternStackFrame) {
            this.largestPatternStackFrame = n;
        }
    }

    protected void compileError(String message, String errorCode) throws XPathException {
        XPathException tce = new XPathException(message);
        tce.setErrorCode(errorCode);
        this.compileError(tce);
    }

    protected void compileError(XPathException error) throws XPathException {
        error.setIsStaticError(true);
        PreparedStylesheet pss = this.getPreparedStylesheet();
        try {
            if (pss == null) {
                throw error;
            }
            pss.reportError(error);
        }
        catch (TransformerException err2) {
            throw XPathException.makeXPathException(err2);
        }
    }
}

