// This file is automatically generated, DO NOT EDIT
//
// To regenerate this file run the `crates/witx-bindgen` command

// Inherit from WASI
pub use wasi::*;

use core::fmt;
use core::mem::MaybeUninit;
pub type Pointersize = usize;
pub type Waker = u64;
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct Errno(u16);
/// No error occurred. System call completed successfully.
pub const ERRNO_SUCCESS: Errno = Errno(0);
/// Argument list too long.
pub const ERRNO_2BIG: Errno = Errno(1);
/// Permission denied.
pub const ERRNO_ACCES: Errno = Errno(2);
/// Address in use.
pub const ERRNO_ADDRINUSE: Errno = Errno(3);
/// Address not available.
pub const ERRNO_ADDRNOTAVAIL: Errno = Errno(4);
/// Address family not supported.
pub const ERRNO_AFNOSUPPORT: Errno = Errno(5);
/// Resource unavailable, or operation would block.
pub const ERRNO_AGAIN: Errno = Errno(6);
/// Connection already in progress.
pub const ERRNO_ALREADY: Errno = Errno(7);
/// Bad file descriptor.
pub const ERRNO_BADF: Errno = Errno(8);
/// Bad message.
pub const ERRNO_BADMSG: Errno = Errno(9);
/// Device or resource busy.
pub const ERRNO_BUSY: Errno = Errno(10);
/// Operation canceled.
pub const ERRNO_CANCELED: Errno = Errno(11);
/// No child processes.
pub const ERRNO_CHILD: Errno = Errno(12);
/// Connection aborted.
pub const ERRNO_CONNABORTED: Errno = Errno(13);
/// Connection refused.
pub const ERRNO_CONNREFUSED: Errno = Errno(14);
/// Connection reset.
pub const ERRNO_CONNRESET: Errno = Errno(15);
/// Resource deadlock would occur.
pub const ERRNO_DEADLK: Errno = Errno(16);
/// Destination address required.
pub const ERRNO_DESTADDRREQ: Errno = Errno(17);
/// Mathematics argument out of domain of function.
pub const ERRNO_DOM: Errno = Errno(18);
/// Reserved.
pub const ERRNO_DQUOT: Errno = Errno(19);
/// File exists.
pub const ERRNO_EXIST: Errno = Errno(20);
/// Bad address.
pub const ERRNO_FAULT: Errno = Errno(21);
/// File too large.
pub const ERRNO_FBIG: Errno = Errno(22);
/// Host is unreachable.
pub const ERRNO_HOSTUNREACH: Errno = Errno(23);
/// Identifier removed.
pub const ERRNO_IDRM: Errno = Errno(24);
/// Illegal byte sequence.
pub const ERRNO_ILSEQ: Errno = Errno(25);
/// Operation in progress.
pub const ERRNO_INPROGRESS: Errno = Errno(26);
/// Interrupted function.
pub const ERRNO_INTR: Errno = Errno(27);
/// Invalid argument.
pub const ERRNO_INVAL: Errno = Errno(28);
/// I/O error.
pub const ERRNO_IO: Errno = Errno(29);
/// Socket is connected.
pub const ERRNO_ISCONN: Errno = Errno(30);
/// Is a directory.
pub const ERRNO_ISDIR: Errno = Errno(31);
/// Too many levels of symbolic links.
pub const ERRNO_LOOP: Errno = Errno(32);
/// File descriptor value too large.
pub const ERRNO_MFILE: Errno = Errno(33);
/// Too many links.
pub const ERRNO_MLINK: Errno = Errno(34);
/// Message too large.
pub const ERRNO_MSGSIZE: Errno = Errno(35);
/// Reserved.
pub const ERRNO_MULTIHOP: Errno = Errno(36);
/// Filename too long.
pub const ERRNO_NAMETOOLONG: Errno = Errno(37);
/// Network is down.
pub const ERRNO_NETDOWN: Errno = Errno(38);
/// Connection aborted by network.
pub const ERRNO_NETRESET: Errno = Errno(39);
/// Network unreachable.
pub const ERRNO_NETUNREACH: Errno = Errno(40);
/// Too many files open in system.
pub const ERRNO_NFILE: Errno = Errno(41);
/// No buffer space available.
pub const ERRNO_NOBUFS: Errno = Errno(42);
/// No such device.
pub const ERRNO_NODEV: Errno = Errno(43);
/// No such file or directory.
pub const ERRNO_NOENT: Errno = Errno(44);
/// Executable file format error.
pub const ERRNO_NOEXEC: Errno = Errno(45);
/// No locks available.
pub const ERRNO_NOLCK: Errno = Errno(46);
/// Reserved.
pub const ERRNO_NOLINK: Errno = Errno(47);
/// Not enough space.
pub const ERRNO_NOMEM: Errno = Errno(48);
/// No message of the desired type.
pub const ERRNO_NOMSG: Errno = Errno(49);
/// Protocol not available.
pub const ERRNO_NOPROTOOPT: Errno = Errno(50);
/// No space left on device.
pub const ERRNO_NOSPC: Errno = Errno(51);
/// Function not supported.
pub const ERRNO_NOSYS: Errno = Errno(52);
/// The socket is not connected.
pub const ERRNO_NOTCONN: Errno = Errno(53);
/// Not a directory or a symbolic link to a directory.
pub const ERRNO_NOTDIR: Errno = Errno(54);
/// Directory not empty.
pub const ERRNO_NOTEMPTY: Errno = Errno(55);
/// State not recoverable.
pub const ERRNO_NOTRECOVERABLE: Errno = Errno(56);
/// Not a socket.
pub const ERRNO_NOTSOCK: Errno = Errno(57);
/// Not supported, or operation not supported on socket.
pub const ERRNO_NOTSUP: Errno = Errno(58);
/// Inappropriate I/O control operation.
pub const ERRNO_NOTTY: Errno = Errno(59);
/// No such device or address.
pub const ERRNO_NXIO: Errno = Errno(60);
/// Value too large to be stored in data type.
pub const ERRNO_OVERFLOW: Errno = Errno(61);
/// Previous owner died.
pub const ERRNO_OWNERDEAD: Errno = Errno(62);
/// Operation not permitted.
pub const ERRNO_PERM: Errno = Errno(63);
/// Broken pipe.
pub const ERRNO_PIPE: Errno = Errno(64);
/// Protocol error.
pub const ERRNO_PROTO: Errno = Errno(65);
/// Protocol not supported.
pub const ERRNO_PROTONOSUPPORT: Errno = Errno(66);
/// Protocol wrong type for socket.
pub const ERRNO_PROTOTYPE: Errno = Errno(67);
/// Result too large.
pub const ERRNO_RANGE: Errno = Errno(68);
/// Read-only file system.
pub const ERRNO_ROFS: Errno = Errno(69);
/// Invalid seek.
pub const ERRNO_SPIPE: Errno = Errno(70);
/// No such process.
pub const ERRNO_SRCH: Errno = Errno(71);
/// Reserved.
pub const ERRNO_STALE: Errno = Errno(72);
/// Connection timed out.
pub const ERRNO_TIMEDOUT: Errno = Errno(73);
/// Text file busy.
pub const ERRNO_TXTBSY: Errno = Errno(74);
/// Cross-device link.
pub const ERRNO_XDEV: Errno = Errno(75);
/// Extension: Capabilities insufficient.
pub const ERRNO_NOTCAPABLE: Errno = Errno(76);
/// Cannot send after socket shutdown.
pub const ERRNO_SHUTDOWN: Errno = Errno(77);
/// Memory access violation.
pub const ERRNO_MEMVIOLATION: Errno = Errno(78);
/// Unknown error has occurred.
pub const ERRNO_UNKNOWN: Errno = Errno(79);
/// Pending asynchronous wake.
pub const ERRNO_PENDING: Errno = Errno(80);
impl Errno {
    pub const fn raw(&self) -> u16 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "SUCCESS",
            1 => "2BIG",
            2 => "ACCES",
            3 => "ADDRINUSE",
            4 => "ADDRNOTAVAIL",
            5 => "AFNOSUPPORT",
            6 => "AGAIN",
            7 => "ALREADY",
            8 => "BADF",
            9 => "BADMSG",
            10 => "BUSY",
            11 => "CANCELED",
            12 => "CHILD",
            13 => "CONNABORTED",
            14 => "CONNREFUSED",
            15 => "CONNRESET",
            16 => "DEADLK",
            17 => "DESTADDRREQ",
            18 => "DOM",
            19 => "DQUOT",
            20 => "EXIST",
            21 => "FAULT",
            22 => "FBIG",
            23 => "HOSTUNREACH",
            24 => "IDRM",
            25 => "ILSEQ",
            26 => "INPROGRESS",
            27 => "INTR",
            28 => "INVAL",
            29 => "IO",
            30 => "ISCONN",
            31 => "ISDIR",
            32 => "LOOP",
            33 => "MFILE",
            34 => "MLINK",
            35 => "MSGSIZE",
            36 => "MULTIHOP",
            37 => "NAMETOOLONG",
            38 => "NETDOWN",
            39 => "NETRESET",
            40 => "NETUNREACH",
            41 => "NFILE",
            42 => "NOBUFS",
            43 => "NODEV",
            44 => "NOENT",
            45 => "NOEXEC",
            46 => "NOLCK",
            47 => "NOLINK",
            48 => "NOMEM",
            49 => "NOMSG",
            50 => "NOPROTOOPT",
            51 => "NOSPC",
            52 => "NOSYS",
            53 => "NOTCONN",
            54 => "NOTDIR",
            55 => "NOTEMPTY",
            56 => "NOTRECOVERABLE",
            57 => "NOTSOCK",
            58 => "NOTSUP",
            59 => "NOTTY",
            60 => "NXIO",
            61 => "OVERFLOW",
            62 => "OWNERDEAD",
            63 => "PERM",
            64 => "PIPE",
            65 => "PROTO",
            66 => "PROTONOSUPPORT",
            67 => "PROTOTYPE",
            68 => "RANGE",
            69 => "ROFS",
            70 => "SPIPE",
            71 => "SRCH",
            72 => "STALE",
            73 => "TIMEDOUT",
            74 => "TXTBSY",
            75 => "XDEV",
            76 => "NOTCAPABLE",
            77 => "SHUTDOWN",
            78 => "MEMVIOLATION",
            79 => "UNKNOWN",
            80 => "PENDING",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "No error occurred. System call completed successfully.",
            1 => "Argument list too long.",
            2 => "Permission denied.",
            3 => "Address in use.",
            4 => "Address not available.",
            5 => "Address family not supported.",
            6 => "Resource unavailable, or operation would block.",
            7 => "Connection already in progress.",
            8 => "Bad file descriptor.",
            9 => "Bad message.",
            10 => "Device or resource busy.",
            11 => "Operation canceled.",
            12 => "No child processes.",
            13 => "Connection aborted.",
            14 => "Connection refused.",
            15 => "Connection reset.",
            16 => "Resource deadlock would occur.",
            17 => "Destination address required.",
            18 => "Mathematics argument out of domain of function.",
            19 => "Reserved.",
            20 => "File exists.",
            21 => "Bad address.",
            22 => "File too large.",
            23 => "Host is unreachable.",
            24 => "Identifier removed.",
            25 => "Illegal byte sequence.",
            26 => "Operation in progress.",
            27 => "Interrupted function.",
            28 => "Invalid argument.",
            29 => "I/O error.",
            30 => "Socket is connected.",
            31 => "Is a directory.",
            32 => "Too many levels of symbolic links.",
            33 => "File descriptor value too large.",
            34 => "Too many links.",
            35 => "Message too large.",
            36 => "Reserved.",
            37 => "Filename too long.",
            38 => "Network is down.",
            39 => "Connection aborted by network.",
            40 => "Network unreachable.",
            41 => "Too many files open in system.",
            42 => "No buffer space available.",
            43 => "No such device.",
            44 => "No such file or directory.",
            45 => "Executable file format error.",
            46 => "No locks available.",
            47 => "Reserved.",
            48 => "Not enough space.",
            49 => "No message of the desired type.",
            50 => "Protocol not available.",
            51 => "No space left on device.",
            52 => "Function not supported.",
            53 => "The socket is not connected.",
            54 => "Not a directory or a symbolic link to a directory.",
            55 => "Directory not empty.",
            56 => "State not recoverable.",
            57 => "Not a socket.",
            58 => "Not supported, or operation not supported on socket.",
            59 => "Inappropriate I/O control operation.",
            60 => "No such device or address.",
            61 => "Value too large to be stored in data type.",
            62 => "Previous owner died.",
            63 => "Operation not permitted.",
            64 => "Broken pipe.",
            65 => "Protocol error.",
            66 => "Protocol not supported.",
            67 => "Protocol wrong type for socket.",
            68 => "Result too large.",
            69 => "Read-only file system.",
            70 => "Invalid seek.",
            71 => "No such process.",
            72 => "Reserved.",
            73 => "Connection timed out.",
            74 => "Text file busy.",
            75 => "Cross-device link.",
            76 => "Extension: Capabilities insufficient.",
            77 => "Cannot send after socket shutdown.",
            78 => "Memory access violation.",
            79 => "Unknown error has occurred.",
            80 => "Pending asynchronous wake.",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for Errno {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("Errno")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}
impl From<u16> for Errno {
    fn from(a: u16) -> Self {
        Self(a)
    }
}
impl fmt::Display for Errno {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "{} (error {})", self.name(), self.0)
    }
}

#[cfg(feature = "std")]
extern crate std;
#[cfg(feature = "std")]
impl std::error::Error for Errno {}

pub type Rights = u64;
/// The right to invoke `fd_datasync`.
/// If `path_open` is set, includes the right to invoke
/// `path_open` with `fdflags::dsync`.
pub const RIGHTS_FD_DATASYNC: Rights = 1 << 0;
/// The right to invoke `fd_read` and `sock_recv`.
/// If `rights::fd_seek` is set, includes the right to invoke `fd_pread`.
pub const RIGHTS_FD_READ: Rights = 1 << 1;
/// The right to invoke `fd_seek`. This flag implies `rights::fd_tell`.
pub const RIGHTS_FD_SEEK: Rights = 1 << 2;
/// The right to invoke `fd_fdstat_set_flags`.
pub const RIGHTS_FD_FDSTAT_SET_FLAGS: Rights = 1 << 3;
/// The right to invoke `fd_sync`.
/// If `path_open` is set, includes the right to invoke
/// `path_open` with `fdflags::rsync` and `fdflags::dsync`.
pub const RIGHTS_FD_SYNC: Rights = 1 << 4;
/// The right to invoke `fd_seek` in such a way that the file offset
/// remains unaltered (i.e., `whence::cur` with offset zero), or to
/// invoke `fd_tell`.
pub const RIGHTS_FD_TELL: Rights = 1 << 5;
/// The right to invoke `fd_write` and `sock_send`.
/// If `rights::fd_seek` is set, includes the right to invoke `fd_pwrite`.
pub const RIGHTS_FD_WRITE: Rights = 1 << 6;
/// The right to invoke `fd_advise`.
pub const RIGHTS_FD_ADVISE: Rights = 1 << 7;
/// The right to invoke `fd_allocate`.
pub const RIGHTS_FD_ALLOCATE: Rights = 1 << 8;
/// The right to invoke `path_create_directory`.
pub const RIGHTS_PATH_CREATE_DIRECTORY: Rights = 1 << 9;
/// If `path_open` is set, the right to invoke `path_open` with `oflags::creat`.
pub const RIGHTS_PATH_CREATE_FILE: Rights = 1 << 10;
/// The right to invoke `path_link` with the file descriptor as the
/// source directory.
pub const RIGHTS_PATH_LINK_SOURCE: Rights = 1 << 11;
/// The right to invoke `path_link` with the file descriptor as the
/// target directory.
pub const RIGHTS_PATH_LINK_TARGET: Rights = 1 << 12;
/// The right to invoke `path_open`.
pub const RIGHTS_PATH_OPEN: Rights = 1 << 13;
/// The right to invoke `fd_readdir`.
pub const RIGHTS_FD_READDIR: Rights = 1 << 14;
/// The right to invoke `path_readlink`.
pub const RIGHTS_PATH_READLINK: Rights = 1 << 15;
/// The right to invoke `path_rename` with the file descriptor as the source directory.
pub const RIGHTS_PATH_RENAME_SOURCE: Rights = 1 << 16;
/// The right to invoke `path_rename` with the file descriptor as the target directory.
pub const RIGHTS_PATH_RENAME_TARGET: Rights = 1 << 17;
/// The right to invoke `path_filestat_get`.
pub const RIGHTS_PATH_FILESTAT_GET: Rights = 1 << 18;
/// The right to change a file's size (there is no `path_filestat_set_size`).
/// If `path_open` is set, includes the right to invoke `path_open` with `oflags::trunc`.
pub const RIGHTS_PATH_FILESTAT_SET_SIZE: Rights = 1 << 19;
/// The right to invoke `path_filestat_set_times`.
pub const RIGHTS_PATH_FILESTAT_SET_TIMES: Rights = 1 << 20;
/// The right to invoke `fd_filestat_get`.
pub const RIGHTS_FD_FILESTAT_GET: Rights = 1 << 21;
/// The right to invoke `fd_filestat_set_size`.
pub const RIGHTS_FD_FILESTAT_SET_SIZE: Rights = 1 << 22;
/// The right to invoke `fd_filestat_set_times`.
pub const RIGHTS_FD_FILESTAT_SET_TIMES: Rights = 1 << 23;
/// The right to invoke `path_symlink`.
pub const RIGHTS_PATH_SYMLINK: Rights = 1 << 24;
/// The right to invoke `path_remove_directory`.
pub const RIGHTS_PATH_REMOVE_DIRECTORY: Rights = 1 << 25;
/// The right to invoke `path_unlink_file`.
pub const RIGHTS_PATH_UNLINK_FILE: Rights = 1 << 26;
/// If `rights::fd_read` is set, includes the right to invoke `poll_oneoff` to subscribe to `eventtype::fd_read`.
/// If `rights::fd_write` is set, includes the right to invoke `poll_oneoff` to subscribe to `eventtype::fd_write`.
pub const RIGHTS_POLL_FD_READWRITE: Rights = 1 << 27;
/// The right to invoke `sock_shutdown`.
pub const RIGHTS_SOCK_SHUTDOWN: Rights = 1 << 28;
/// Accept incoming connection
pub const RIGHTS_SOCK_ACCEPT: Rights = 1 << 29;
/// Connect to an address
pub const RIGHTS_SOCK_CONNECT: Rights = 1 << 30;
/// Listen for incoming connection on an address
pub const RIGHTS_SOCK_LISTEN: Rights = 1 << 31;
/// Bind an address to a socket
pub const RIGHTS_SOCK_BIND: Rights = 1 << 32;
/// Receive data on a socket
pub const RIGHTS_SOCK_RECV: Rights = 1 << 33;
/// Send data on a socket
pub const RIGHTS_SOCK_SEND: Rights = 1 << 34;
/// Retrieve locally bound address on a socket
pub const RIGHTS_SOCK_ADDR_LOCAL: Rights = 1 << 35;
/// Retrieve remote address on a socket
pub const RIGHTS_SOCK_ADDR_REMOTE: Rights = 1 << 36;
/// Receive datagram on a socket
pub const RIGHTS_SOCK_RECV_FROM: Rights = 1 << 37;
/// Send datagram on a socket
pub const RIGHTS_SOCK_SEND_TO: Rights = 1 << 38;

#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct Filetype(u8);
/// The type of the file descriptor or file is unknown or is different from any of the other types specified.
pub const FILETYPE_UNKNOWN: Filetype = Filetype(0);
/// The file descriptor or file refers to a block device inode.
pub const FILETYPE_BLOCK_DEVICE: Filetype = Filetype(1);
/// The file descriptor or file refers to a character device inode.
pub const FILETYPE_CHARACTER_DEVICE: Filetype = Filetype(2);
/// The file descriptor or file refers to a directory inode.
pub const FILETYPE_DIRECTORY: Filetype = Filetype(3);
/// The file descriptor or file refers to a regular file inode.
pub const FILETYPE_REGULAR_FILE: Filetype = Filetype(4);
/// The file descriptor or file refers to a datagram socket.
pub const FILETYPE_SOCKET_DGRAM: Filetype = Filetype(5);
/// The file descriptor or file refers to a byte-stream socket.
pub const FILETYPE_SOCKET_STREAM: Filetype = Filetype(6);
/// The file refers to a symbolic link inode.
pub const FILETYPE_SYMBOLIC_LINK: Filetype = Filetype(7);
/// The file descriptor or file refers to a raw socket.
pub const FILETYPE_SOCKET_RAW: Filetype = Filetype(8);
/// The file descriptor or file refers to a sequential packet socket.
pub const FILETYPE_SOCKET_SEQPACKET: Filetype = Filetype(9);
impl Filetype {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "UNKNOWN",
            1 => "BLOCK_DEVICE",
            2 => "CHARACTER_DEVICE",
            3 => "DIRECTORY",
            4 => "REGULAR_FILE",
            5 => "SOCKET_DGRAM",
            6 => "SOCKET_STREAM",
            7 => "SYMBOLIC_LINK",
            8 => "SOCKET_RAW",
            9 => "SOCKET_SEQPACKET",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {0 => "The type of the file descriptor or file is unknown or is different from any of the other types specified.",1 => "The file descriptor or file refers to a block device inode.",2 => "The file descriptor or file refers to a character device inode.",3 => "The file descriptor or file refers to a directory inode.",4 => "The file descriptor or file refers to a regular file inode.",5 => "The file descriptor or file refers to a datagram socket.",6 => "The file descriptor or file refers to a byte-stream socket.",7 => "The file refers to a symbolic link inode.",8 => "The file descriptor or file refers to a raw socket.",9 => "The file descriptor or file refers to a sequential packet socket.",_ => unsafe { core::hint::unreachable_unchecked() },}
    }
}
impl fmt::Debug for Filetype {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("Filetype")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}
impl From<u8> for Filetype {
    fn from(a: u8) -> Self {
        Self(a)
    }
}

pub type Riflags = u16;
/// Returns the message without removing it from the socket's receive queue.
pub const RIFLAGS_RECV_PEEK: Riflags = 1 << 0;
/// On byte-stream sockets, block until the full amount of data can be returned.
pub const RIFLAGS_RECV_WAITALL: Riflags = 1 << 1;
/// Indicates if the packet should be truncated to the buffer size
pub const RIFLAGS_RECV_DATA_TRUNCATED: Riflags = 1 << 2;

#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct Signal(u8);
/// No signal. Note that POSIX has special semantics for `kill(pid, 0)`,
/// so this value is reserved.
pub const SIGNAL_NONE: Signal = Signal(0);
/// Hangup.
/// Action: Terminates the process.
pub const SIGNAL_HUP: Signal = Signal(1);
/// Terminate interrupt signal.
/// Action: Terminates the process.
pub const SIGNAL_INT: Signal = Signal(2);
/// Terminal quit signal.
/// Action: Terminates the process.
pub const SIGNAL_QUIT: Signal = Signal(3);
/// Illegal instruction.
/// Action: Terminates the process.
pub const SIGNAL_ILL: Signal = Signal(4);
/// Trace/breakpoint trap.
/// Action: Terminates the process.
pub const SIGNAL_TRAP: Signal = Signal(5);
/// Process abort signal.
/// Action: Terminates the process.
pub const SIGNAL_ABRT: Signal = Signal(6);
/// Access to an undefined portion of a memory object.
/// Action: Terminates the process.
pub const SIGNAL_BUS: Signal = Signal(7);
/// Erroneous arithmetic operation.
/// Action: Terminates the process.
pub const SIGNAL_FPE: Signal = Signal(8);
/// Kill.
/// Action: Terminates the process.
pub const SIGNAL_KILL: Signal = Signal(9);
/// User-defined signal 1.
/// Action: Terminates the process.
pub const SIGNAL_USR1: Signal = Signal(10);
/// Invalid memory reference.
/// Action: Terminates the process.
pub const SIGNAL_SEGV: Signal = Signal(11);
/// User-defined signal 2.
/// Action: Terminates the process.
pub const SIGNAL_USR2: Signal = Signal(12);
/// Write on a pipe with no one to read it.
/// Action: Ignored.
pub const SIGNAL_PIPE: Signal = Signal(13);
/// Alarm clock.
/// Action: Terminates the process.
pub const SIGNAL_ALRM: Signal = Signal(14);
/// Termination signal.
/// Action: Terminates the process.
pub const SIGNAL_TERM: Signal = Signal(15);
/// Stkflt
/// Action: Ignored.
pub const SIGNAL_STKFLT: Signal = Signal(16);
/// Child process terminated, stopped, or continued.
/// Action: Ignored.
pub const SIGNAL_CHLD: Signal = Signal(17);
/// Continue executing, if stopped.
/// Action: Continues executing, if stopped.
pub const SIGNAL_CONT: Signal = Signal(18);
/// Stop executing.
/// Action: Stops executing.
pub const SIGNAL_STOP: Signal = Signal(19);
/// Terminal stop signal.
/// Action: Stops executing.
pub const SIGNAL_TSTP: Signal = Signal(20);
/// Background process attempting read.
/// Action: Stops executing.
pub const SIGNAL_TTIN: Signal = Signal(21);
/// Background process attempting write.
/// Action: Stops executing.
pub const SIGNAL_TTOU: Signal = Signal(22);
/// High bandwidth data is available at a socket.
/// Action: Ignored.
pub const SIGNAL_URG: Signal = Signal(23);
/// CPU time limit exceeded.
/// Action: Terminates the process.
pub const SIGNAL_XCPU: Signal = Signal(24);
/// File size limit exceeded.
/// Action: Terminates the process.
pub const SIGNAL_XFSZ: Signal = Signal(25);
/// Virtual timer expired.
/// Action: Terminates the process.
pub const SIGNAL_VTALRM: Signal = Signal(26);
/// Profiling timer expired.
/// Action: Terminates the process.
pub const SIGNAL_PROF: Signal = Signal(27);
/// Window changed.
/// Action: Ignored.
pub const SIGNAL_WINCH: Signal = Signal(28);
/// I/O possible.
/// Action: Terminates the process.
pub const SIGNAL_POLL: Signal = Signal(29);
/// Power failure.
/// Action: Terminates the process.
pub const SIGNAL_PWR: Signal = Signal(30);
/// Bad system call.
/// Action: Terminates the process.
pub const SIGNAL_SYS: Signal = Signal(31);
impl Signal {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "NONE",
            1 => "HUP",
            2 => "INT",
            3 => "QUIT",
            4 => "ILL",
            5 => "TRAP",
            6 => "ABRT",
            7 => "BUS",
            8 => "FPE",
            9 => "KILL",
            10 => "USR1",
            11 => "SEGV",
            12 => "USR2",
            13 => "PIPE",
            14 => "ALRM",
            15 => "TERM",
            16 => "STKFLT",
            17 => "CHLD",
            18 => "CONT",
            19 => "STOP",
            20 => "TSTP",
            21 => "TTIN",
            22 => "TTOU",
            23 => "URG",
            24 => "XCPU",
            25 => "XFSZ",
            26 => "VTALRM",
            27 => "PROF",
            28 => "WINCH",
            29 => "POLL",
            30 => "PWR",
            31 => "SYS",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => {
                "No signal. Note that POSIX has special semantics for `kill(pid, 0)`,
so this value is reserved."
            }
            1 => {
                "Hangup.
Action: Terminates the process."
            }
            2 => {
                "Terminate interrupt signal.
Action: Terminates the process."
            }
            3 => {
                "Terminal quit signal.
Action: Terminates the process."
            }
            4 => {
                "Illegal instruction.
Action: Terminates the process."
            }
            5 => {
                "Trace/breakpoint trap.
Action: Terminates the process."
            }
            6 => {
                "Process abort signal.
Action: Terminates the process."
            }
            7 => {
                "Access to an undefined portion of a memory object.
Action: Terminates the process."
            }
            8 => {
                "Erroneous arithmetic operation.
Action: Terminates the process."
            }
            9 => {
                "Kill.
Action: Terminates the process."
            }
            10 => {
                "User-defined signal 1.
Action: Terminates the process."
            }
            11 => {
                "Invalid memory reference.
Action: Terminates the process."
            }
            12 => {
                "User-defined signal 2.
Action: Terminates the process."
            }
            13 => {
                "Write on a pipe with no one to read it.
Action: Ignored."
            }
            14 => {
                "Alarm clock.
Action: Terminates the process."
            }
            15 => {
                "Termination signal.
Action: Terminates the process."
            }
            16 => {
                "Stkflt
Action: Ignored."
            }
            17 => {
                "Child process terminated, stopped, or continued.
Action: Ignored."
            }
            18 => {
                "Continue executing, if stopped.
Action: Continues executing, if stopped."
            }
            19 => {
                "Stop executing.
Action: Stops executing."
            }
            20 => {
                "Terminal stop signal.
Action: Stops executing."
            }
            21 => {
                "Background process attempting read.
Action: Stops executing."
            }
            22 => {
                "Background process attempting write.
Action: Stops executing."
            }
            23 => {
                "High bandwidth data is available at a socket.
Action: Ignored."
            }
            24 => {
                "CPU time limit exceeded.
Action: Terminates the process."
            }
            25 => {
                "File size limit exceeded.
Action: Terminates the process."
            }
            26 => {
                "Virtual timer expired.
Action: Terminates the process."
            }
            27 => {
                "Profiling timer expired.
Action: Terminates the process."
            }
            28 => {
                "Window changed.
Action: Ignored."
            }
            29 => {
                "I/O possible.
Action: Terminates the process."
            }
            30 => {
                "Power failure.
Action: Terminates the process."
            }
            31 => {
                "Bad system call.
Action: Terminates the process."
            }
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for Signal {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("Signal")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}
impl From<u8> for Signal {
    fn from(a: u8) -> Self {
        Self(a)
    }
}

pub type Longsize = u64;
pub type ShortHash = u64;
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct Hugesize {
    /// First set of 64 bits
    pub b0: u64,
    /// second set of 64 bits
    pub b1: u64,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct Hash {
    /// First set of 64 bits
    pub b0: u64,
    /// second set of 64 bits
    pub b1: u64,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct StackSnapshot {
    /// User defined field that can be used by functions
    pub user: u64,
    /// Hash used to identify which stack snapshot to restore
    pub hash: Hash,
}
pub type BufArray<'a> = &'a [u8];
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct Option(u8);
pub const OPTION_NONE: Option = Option(0);
pub const OPTION_SOME: Option = Option(1);
impl Option {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "NONE",
            1 => "SOME",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "",
            1 => "",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for Option {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("Option")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}
impl From<u8> for Option {
    fn from(a: u8) -> Self {
        Self(a)
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub union OptionTimestampU {
    pub none: u8,
    pub some: Timestamp,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct OptionTimestamp {
    pub tag: u8,
    pub u: OptionTimestampU,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub union OptionHashU {
    pub none: u8,
    pub some: Hash,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct OptionHash {
    pub tag: u8,
    pub u: OptionHashU,
}

pub type Pid = u32;
pub type Tid = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub union OptionPidU {
    pub none: u8,
    pub some: Pid,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct OptionPid {
    pub tag: u8,
    pub u: OptionPidU,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub union OptionFdU {
    pub none: u8,
    pub some: Fd,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct OptionFd {
    pub tag: u8,
    pub u: OptionFdU,
}

#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct Bool(u8);
pub const BOOL_FALSE: Bool = Bool(0);
pub const BOOL_TRUE: Bool = Bool(1);
impl Bool {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "FALSE",
            1 => "TRUE",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "",
            1 => "",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for Bool {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("Bool")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}
impl From<u8> for Bool {
    fn from(a: u8) -> Self {
        Self(a)
    }
}

pub type Eventfdflags = u16;
/// Indicates if this event file description will run as a semaphore
pub const EVENTFDFLAGS_SEMAPHORE: Eventfdflags = 1 << 0;

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct Tty {
    /// Number of columns
    pub cols: u32,
    /// Number of rows
    pub rows: u32,
    /// Width of the screen in pixels
    pub width: u32,
    /// Height of the screen in pixels
    pub height: u32,
    /// Indicates if stdin is a TTY
    pub stdin_tty: Bool,
    /// Indicates if stdout is a TTY
    pub stdout_tty: Bool,
    /// Indicates if stderr is a TTY
    pub stderr_tty: Bool,
    /// When enabled the TTY will echo input to console
    pub echo: Bool,
    /// When enabled buffers the input until the return key is pressed
    pub line_buffered: Bool,
    /// Indicates if line feeds are ignored on the input
    pub line_feeds: Bool,
}
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct StdioMode(u8);
/// The stdio will be piped
pub const STDIO_MODE_PIPED: StdioMode = StdioMode(0);
/// The stdio will inherit from its parent
pub const STDIO_MODE_INHERIT: StdioMode = StdioMode(1);
/// The stdio will be dumped to null
pub const STDIO_MODE_NULL: StdioMode = StdioMode(2);
/// The stdio will be written to the log file
pub const STDIO_MODE_LOG: StdioMode = StdioMode(3);
impl StdioMode {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "PIPED",
            1 => "INHERIT",
            2 => "NULL",
            3 => "LOG",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "The stdio will be piped",
            1 => "The stdio will inherit from its parent",
            2 => "The stdio will be dumped to null",
            3 => "The stdio will be written to the log file",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for StdioMode {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("StdioMode")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}
impl From<u8> for StdioMode {
    fn from(a: u8) -> Self {
        Self(a)
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ProcessHandles {
    /// Handle that represents the process
    pub pid: Pid,
    /// File handle for STDIN
    pub stdin: OptionFd,
    /// File handle for STDOUT
    pub stdout: OptionFd,
    /// File handle for STDERR
    pub stderr: OptionFd,
}
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct SockType(u8);
/// Unused enum variant to prevent $socket_dgram value of 0, which
/// conflicts with a macro defined in cpython which is used in a case arm
/// of a switch statement alongside C macros generated from this enum.
///  ref: https://github.com/python/cpython/blob/2f369cafeeb4a4886b00396abd8a5f33e555e1c3/Modules/getaddrinfo.c#L68
///  ref: https://github.com/python/cpython/blob/3f369cafeeb4a4886b00396abd8a5f33e555e1c3/Modules/getaddrinfo.c#L355-L368
pub const SOCK_TYPE_SOCKET_UNUSED: SockType = SockType(0);
/// The file descriptor or file refers to a byte-stream socket.
pub const SOCK_TYPE_SOCKET_STREAM: SockType = SockType(1);
/// The file descriptor or file refers to a datagram socket.
pub const SOCK_TYPE_SOCKET_DGRAM: SockType = SockType(2);
/// The file descriptor or file refers to a raw socket.
pub const SOCK_TYPE_SOCKET_RAW: SockType = SockType(3);
/// The file descriptor or file refers to a sequential packet socket.
pub const SOCK_TYPE_SOCKET_SEQPACKET: SockType = SockType(4);
impl SockType {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "SOCKET_UNUSED",
            1 => "SOCKET_STREAM",
            2 => "SOCKET_DGRAM",
            3 => "SOCKET_RAW",
            4 => "SOCKET_SEQPACKET",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {0 => "Unused enum variant to prevent $socket_dgram value of 0, which
conflicts with a macro defined in cpython which is used in a case arm
of a switch statement alongside C macros generated from this enum.
 ref: https://github.com/python/cpython/blob/2f369cafeeb4a4886b00396abd8a5f33e555e1c3/Modules/getaddrinfo.c#L68
 ref: https://github.com/python/cpython/blob/3f369cafeeb4a4886b00396abd8a5f33e555e1c3/Modules/getaddrinfo.c#L355-L368",1 => "The file descriptor or file refers to a byte-stream socket.",2 => "The file descriptor or file refers to a datagram socket.",3 => "The file descriptor or file refers to a raw socket.",4 => "The file descriptor or file refers to a sequential packet socket.",_ => unsafe { core::hint::unreachable_unchecked() },}
    }
}
impl fmt::Debug for SockType {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("SockType")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}
impl From<u8> for SockType {
    fn from(a: u8) -> Self {
        Self(a)
    }
}

#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct SockProto(u16);
pub const SOCK_PROTO_IP: SockProto = SockProto(0);
pub const SOCK_PROTO_ICMP: SockProto = SockProto(1);
pub const SOCK_PROTO_IGMP: SockProto = SockProto(2);
pub const SOCK_PROTO_PROTO_3: SockProto = SockProto(3);
pub const SOCK_PROTO_IPIP: SockProto = SockProto(4);
pub const SOCK_PROTO_PROTO_5: SockProto = SockProto(5);
pub const SOCK_PROTO_TCP: SockProto = SockProto(6);
pub const SOCK_PROTO_PROTO_7: SockProto = SockProto(7);
pub const SOCK_PROTO_EGP: SockProto = SockProto(8);
pub const SOCK_PROTO_PROTO_9: SockProto = SockProto(9);
pub const SOCK_PROTO_PROTO_10: SockProto = SockProto(10);
pub const SOCK_PROTO_PROTO_11: SockProto = SockProto(11);
pub const SOCK_PROTO_PUP: SockProto = SockProto(12);
pub const SOCK_PROTO_PROTO_13: SockProto = SockProto(13);
pub const SOCK_PROTO_PROTO_14: SockProto = SockProto(14);
pub const SOCK_PROTO_PROTO_15: SockProto = SockProto(15);
pub const SOCK_PROTO_PROTO_16: SockProto = SockProto(16);
pub const SOCK_PROTO_UDP: SockProto = SockProto(17);
pub const SOCK_PROTO_PROTO_18: SockProto = SockProto(18);
pub const SOCK_PROTO_PROTO_19: SockProto = SockProto(19);
pub const SOCK_PROTO_PROTO_20: SockProto = SockProto(20);
pub const SOCK_PROTO_PROTO_21: SockProto = SockProto(21);
pub const SOCK_PROTO_IDP: SockProto = SockProto(22);
pub const SOCK_PROTO_PROTO_23: SockProto = SockProto(23);
pub const SOCK_PROTO_PROTO_24: SockProto = SockProto(24);
pub const SOCK_PROTO_PROTO_25: SockProto = SockProto(25);
pub const SOCK_PROTO_PROTO_26: SockProto = SockProto(26);
pub const SOCK_PROTO_PROTO_27: SockProto = SockProto(27);
pub const SOCK_PROTO_PROTO_28: SockProto = SockProto(28);
pub const SOCK_PROTO_PROTO_TP: SockProto = SockProto(29);
pub const SOCK_PROTO_PROTO_30: SockProto = SockProto(30);
pub const SOCK_PROTO_PROTO_31: SockProto = SockProto(31);
pub const SOCK_PROTO_PROTO_32: SockProto = SockProto(32);
pub const SOCK_PROTO_DCCP: SockProto = SockProto(33);
pub const SOCK_PROTO_PROTO_34: SockProto = SockProto(34);
pub const SOCK_PROTO_PROTO_35: SockProto = SockProto(35);
pub const SOCK_PROTO_PROTO_36: SockProto = SockProto(36);
pub const SOCK_PROTO_PROTO_37: SockProto = SockProto(37);
pub const SOCK_PROTO_PROTO_38: SockProto = SockProto(38);
pub const SOCK_PROTO_PROTO_39: SockProto = SockProto(39);
pub const SOCK_PROTO_PROTO_40: SockProto = SockProto(40);
pub const SOCK_PROTO_IPV6: SockProto = SockProto(41);
pub const SOCK_PROTO_PROTO_42: SockProto = SockProto(42);
pub const SOCK_PROTO_ROUTING: SockProto = SockProto(43);
pub const SOCK_PROTO_FRAGMENT: SockProto = SockProto(44);
pub const SOCK_PROTO_PROTO_45: SockProto = SockProto(45);
pub const SOCK_PROTO_RSVP: SockProto = SockProto(46);
pub const SOCK_PROTO_GRE: SockProto = SockProto(47);
pub const SOCK_PROTO_PROTO_48: SockProto = SockProto(48);
pub const SOCK_PROTO_PROTO_49: SockProto = SockProto(49);
pub const SOCK_PROTO_ESP: SockProto = SockProto(50);
pub const SOCK_PROTO_AH: SockProto = SockProto(51);
pub const SOCK_PROTO_PROTO_52: SockProto = SockProto(52);
pub const SOCK_PROTO_PROTO_53: SockProto = SockProto(53);
pub const SOCK_PROTO_PROTO_54: SockProto = SockProto(54);
pub const SOCK_PROTO_PROTO_55: SockProto = SockProto(55);
pub const SOCK_PROTO_PROTO_56: SockProto = SockProto(56);
pub const SOCK_PROTO_PROTO_57: SockProto = SockProto(57);
pub const SOCK_PROTO_ICMPV6: SockProto = SockProto(58);
pub const SOCK_PROTO_NONE: SockProto = SockProto(59);
pub const SOCK_PROTO_DSTOPTS: SockProto = SockProto(60);
pub const SOCK_PROTO_PROTO_61: SockProto = SockProto(61);
pub const SOCK_PROTO_PROTO_62: SockProto = SockProto(62);
pub const SOCK_PROTO_PROTO_63: SockProto = SockProto(63);
pub const SOCK_PROTO_PROTO_64: SockProto = SockProto(64);
pub const SOCK_PROTO_PROTO_65: SockProto = SockProto(65);
pub const SOCK_PROTO_PROTO_66: SockProto = SockProto(66);
pub const SOCK_PROTO_PROTO_67: SockProto = SockProto(67);
pub const SOCK_PROTO_PROTO_68: SockProto = SockProto(68);
pub const SOCK_PROTO_PROTO_69: SockProto = SockProto(69);
pub const SOCK_PROTO_PROTO_70: SockProto = SockProto(70);
pub const SOCK_PROTO_PROTO_71: SockProto = SockProto(71);
pub const SOCK_PROTO_PROTO_72: SockProto = SockProto(72);
pub const SOCK_PROTO_PROTO_73: SockProto = SockProto(73);
pub const SOCK_PROTO_PROTO_74: SockProto = SockProto(74);
pub const SOCK_PROTO_PROTO_75: SockProto = SockProto(75);
pub const SOCK_PROTO_PROTO_76: SockProto = SockProto(76);
pub const SOCK_PROTO_PROTO_77: SockProto = SockProto(77);
pub const SOCK_PROTO_PROTO_78: SockProto = SockProto(78);
pub const SOCK_PROTO_PROTO_79: SockProto = SockProto(79);
pub const SOCK_PROTO_PROTO_80: SockProto = SockProto(80);
pub const SOCK_PROTO_PROTO_81: SockProto = SockProto(81);
pub const SOCK_PROTO_PROTO_82: SockProto = SockProto(82);
pub const SOCK_PROTO_PROTO_83: SockProto = SockProto(83);
pub const SOCK_PROTO_PROTO_84: SockProto = SockProto(84);
pub const SOCK_PROTO_PROTO_85: SockProto = SockProto(85);
pub const SOCK_PROTO_PROTO_86: SockProto = SockProto(86);
pub const SOCK_PROTO_PROTO_87: SockProto = SockProto(87);
pub const SOCK_PROTO_PROTO_88: SockProto = SockProto(88);
pub const SOCK_PROTO_PROTO_89: SockProto = SockProto(89);
pub const SOCK_PROTO_PROTO_90: SockProto = SockProto(90);
pub const SOCK_PROTO_PROTO_91: SockProto = SockProto(91);
pub const SOCK_PROTO_MTP: SockProto = SockProto(92);
pub const SOCK_PROTO_PROTO_93: SockProto = SockProto(93);
pub const SOCK_PROTO_BEETPH: SockProto = SockProto(94);
pub const SOCK_PROTO_PROTO_95: SockProto = SockProto(95);
pub const SOCK_PROTO_PROTO_96: SockProto = SockProto(96);
pub const SOCK_PROTO_PROTO_97: SockProto = SockProto(97);
pub const SOCK_PROTO_ENCAP: SockProto = SockProto(98);
pub const SOCK_PROTO_PROTO_99: SockProto = SockProto(99);
pub const SOCK_PROTO_PROTO_100: SockProto = SockProto(100);
pub const SOCK_PROTO_PROTO_101: SockProto = SockProto(101);
pub const SOCK_PROTO_PROTO_102: SockProto = SockProto(102);
pub const SOCK_PROTO_PIM: SockProto = SockProto(103);
pub const SOCK_PROTO_PROTO_104: SockProto = SockProto(104);
pub const SOCK_PROTO_PROTO_105: SockProto = SockProto(105);
pub const SOCK_PROTO_PROTO_106: SockProto = SockProto(106);
pub const SOCK_PROTO_PROTO_107: SockProto = SockProto(107);
pub const SOCK_PROTO_COMP: SockProto = SockProto(108);
pub const SOCK_PROTO_PROTO_109: SockProto = SockProto(109);
pub const SOCK_PROTO_PROTO_110: SockProto = SockProto(110);
pub const SOCK_PROTO_PROTO_111: SockProto = SockProto(111);
pub const SOCK_PROTO_PROTO_112: SockProto = SockProto(112);
pub const SOCK_PROTO_PROTO_113: SockProto = SockProto(113);
pub const SOCK_PROTO_PROTO_114: SockProto = SockProto(114);
pub const SOCK_PROTO_PROTO_115: SockProto = SockProto(115);
pub const SOCK_PROTO_PROTO_116: SockProto = SockProto(116);
pub const SOCK_PROTO_PROTO_117: SockProto = SockProto(117);
pub const SOCK_PROTO_PROTO_118: SockProto = SockProto(118);
pub const SOCK_PROTO_PROTO_119: SockProto = SockProto(119);
pub const SOCK_PROTO_PROTO_120: SockProto = SockProto(120);
pub const SOCK_PROTO_PROTO_121: SockProto = SockProto(121);
pub const SOCK_PROTO_PROTO_122: SockProto = SockProto(122);
pub const SOCK_PROTO_PROTO_123: SockProto = SockProto(123);
pub const SOCK_PROTO_PROTO_124: SockProto = SockProto(124);
pub const SOCK_PROTO_PROTO_125: SockProto = SockProto(125);
pub const SOCK_PROTO_PROTO_126: SockProto = SockProto(126);
pub const SOCK_PROTO_PROTO_127: SockProto = SockProto(127);
pub const SOCK_PROTO_PROTO_128: SockProto = SockProto(128);
pub const SOCK_PROTO_PROTO_129: SockProto = SockProto(129);
pub const SOCK_PROTO_PROTO_130: SockProto = SockProto(130);
pub const SOCK_PROTO_PROTO_131: SockProto = SockProto(131);
pub const SOCK_PROTO_SCTP: SockProto = SockProto(132);
pub const SOCK_PROTO_PROTO_133: SockProto = SockProto(133);
pub const SOCK_PROTO_PROTO_134: SockProto = SockProto(134);
pub const SOCK_PROTO_MH: SockProto = SockProto(135);
pub const SOCK_PROTO_UDPLITE: SockProto = SockProto(136);
pub const SOCK_PROTO_MPLS: SockProto = SockProto(137);
pub const SOCK_PROTO_PROTO_138: SockProto = SockProto(138);
pub const SOCK_PROTO_PROTO_139: SockProto = SockProto(139);
pub const SOCK_PROTO_PROTO_140: SockProto = SockProto(140);
pub const SOCK_PROTO_PROTO_141: SockProto = SockProto(141);
pub const SOCK_PROTO_PROTO_142: SockProto = SockProto(142);
pub const SOCK_PROTO_ETHERNET: SockProto = SockProto(143);
pub const SOCK_PROTO_PROTO_144: SockProto = SockProto(144);
pub const SOCK_PROTO_PROTO_145: SockProto = SockProto(145);
pub const SOCK_PROTO_PROTO_146: SockProto = SockProto(146);
pub const SOCK_PROTO_PROTO_147: SockProto = SockProto(147);
pub const SOCK_PROTO_PROTO_148: SockProto = SockProto(148);
pub const SOCK_PROTO_PROTO_149: SockProto = SockProto(149);
pub const SOCK_PROTO_PROTO_150: SockProto = SockProto(150);
pub const SOCK_PROTO_PROTO_151: SockProto = SockProto(151);
pub const SOCK_PROTO_PROTO_152: SockProto = SockProto(152);
pub const SOCK_PROTO_PROTO_153: SockProto = SockProto(153);
pub const SOCK_PROTO_PROTO_154: SockProto = SockProto(154);
pub const SOCK_PROTO_PROTO_155: SockProto = SockProto(155);
pub const SOCK_PROTO_PROTO_156: SockProto = SockProto(156);
pub const SOCK_PROTO_PROTO_157: SockProto = SockProto(157);
pub const SOCK_PROTO_PROTO_158: SockProto = SockProto(158);
pub const SOCK_PROTO_PROTO_159: SockProto = SockProto(159);
pub const SOCK_PROTO_PROTO_160: SockProto = SockProto(160);
pub const SOCK_PROTO_PROTO_161: SockProto = SockProto(161);
pub const SOCK_PROTO_PROTO_162: SockProto = SockProto(162);
pub const SOCK_PROTO_PROTO_163: SockProto = SockProto(163);
pub const SOCK_PROTO_PROTO_164: SockProto = SockProto(164);
pub const SOCK_PROTO_PROTO_165: SockProto = SockProto(165);
pub const SOCK_PROTO_PROTO_166: SockProto = SockProto(166);
pub const SOCK_PROTO_PROTO_167: SockProto = SockProto(167);
pub const SOCK_PROTO_PROTO_168: SockProto = SockProto(168);
pub const SOCK_PROTO_PROTO_169: SockProto = SockProto(169);
pub const SOCK_PROTO_PROTO_170: SockProto = SockProto(170);
pub const SOCK_PROTO_PROTO_171: SockProto = SockProto(171);
pub const SOCK_PROTO_PROTO_172: SockProto = SockProto(172);
pub const SOCK_PROTO_PROTO_173: SockProto = SockProto(173);
pub const SOCK_PROTO_PROTO_174: SockProto = SockProto(174);
pub const SOCK_PROTO_PROTO_175: SockProto = SockProto(175);
pub const SOCK_PROTO_PROTO_176: SockProto = SockProto(176);
pub const SOCK_PROTO_PROTO_177: SockProto = SockProto(177);
pub const SOCK_PROTO_PROTO_178: SockProto = SockProto(178);
pub const SOCK_PROTO_PROTO_179: SockProto = SockProto(179);
pub const SOCK_PROTO_PROTO_180: SockProto = SockProto(180);
pub const SOCK_PROTO_PROTO_181: SockProto = SockProto(181);
pub const SOCK_PROTO_PROTO_182: SockProto = SockProto(182);
pub const SOCK_PROTO_PROTO_183: SockProto = SockProto(183);
pub const SOCK_PROTO_PROTO_184: SockProto = SockProto(184);
pub const SOCK_PROTO_PROTO_185: SockProto = SockProto(185);
pub const SOCK_PROTO_PROTO_186: SockProto = SockProto(186);
pub const SOCK_PROTO_PROTO_187: SockProto = SockProto(187);
pub const SOCK_PROTO_PROTO_188: SockProto = SockProto(188);
pub const SOCK_PROTO_PROTO_189: SockProto = SockProto(189);
pub const SOCK_PROTO_PROTO_190: SockProto = SockProto(190);
pub const SOCK_PROTO_PROTO_191: SockProto = SockProto(191);
pub const SOCK_PROTO_PROTO_192: SockProto = SockProto(192);
pub const SOCK_PROTO_PROTO_193: SockProto = SockProto(193);
pub const SOCK_PROTO_PROTO_194: SockProto = SockProto(194);
pub const SOCK_PROTO_PROTO_195: SockProto = SockProto(195);
pub const SOCK_PROTO_PROTO_196: SockProto = SockProto(196);
pub const SOCK_PROTO_PROTO_197: SockProto = SockProto(197);
pub const SOCK_PROTO_PROTO_198: SockProto = SockProto(198);
pub const SOCK_PROTO_PROTO_199: SockProto = SockProto(199);
pub const SOCK_PROTO_PROTO_200: SockProto = SockProto(200);
pub const SOCK_PROTO_PROTO_201: SockProto = SockProto(201);
pub const SOCK_PROTO_PROTO_202: SockProto = SockProto(202);
pub const SOCK_PROTO_PROTO_203: SockProto = SockProto(203);
pub const SOCK_PROTO_PROTO_204: SockProto = SockProto(204);
pub const SOCK_PROTO_PROTO_205: SockProto = SockProto(205);
pub const SOCK_PROTO_PROTO_206: SockProto = SockProto(206);
pub const SOCK_PROTO_PROTO_207: SockProto = SockProto(207);
pub const SOCK_PROTO_PROTO_208: SockProto = SockProto(208);
pub const SOCK_PROTO_PROTO_209: SockProto = SockProto(209);
pub const SOCK_PROTO_PROTO_210: SockProto = SockProto(210);
pub const SOCK_PROTO_PROTO_211: SockProto = SockProto(211);
pub const SOCK_PROTO_PROTO_212: SockProto = SockProto(212);
pub const SOCK_PROTO_PROTO_213: SockProto = SockProto(213);
pub const SOCK_PROTO_PROTO_214: SockProto = SockProto(214);
pub const SOCK_PROTO_PROTO_215: SockProto = SockProto(215);
pub const SOCK_PROTO_PROTO_216: SockProto = SockProto(216);
pub const SOCK_PROTO_PROTO_217: SockProto = SockProto(217);
pub const SOCK_PROTO_PROTO_218: SockProto = SockProto(218);
pub const SOCK_PROTO_PROTO_219: SockProto = SockProto(219);
pub const SOCK_PROTO_PROTO_220: SockProto = SockProto(220);
pub const SOCK_PROTO_PROTO_221: SockProto = SockProto(221);
pub const SOCK_PROTO_PROTO_222: SockProto = SockProto(222);
pub const SOCK_PROTO_PROTO_223: SockProto = SockProto(223);
pub const SOCK_PROTO_PROTO_224: SockProto = SockProto(224);
pub const SOCK_PROTO_PROTO_225: SockProto = SockProto(225);
pub const SOCK_PROTO_PROTO_226: SockProto = SockProto(226);
pub const SOCK_PROTO_PROTO_227: SockProto = SockProto(227);
pub const SOCK_PROTO_PROTO_228: SockProto = SockProto(228);
pub const SOCK_PROTO_PROTO_229: SockProto = SockProto(229);
pub const SOCK_PROTO_PROTO_230: SockProto = SockProto(230);
pub const SOCK_PROTO_PROTO_231: SockProto = SockProto(231);
pub const SOCK_PROTO_PROTO_232: SockProto = SockProto(232);
pub const SOCK_PROTO_PROTO_233: SockProto = SockProto(233);
pub const SOCK_PROTO_PROTO_234: SockProto = SockProto(234);
pub const SOCK_PROTO_PROTO_235: SockProto = SockProto(235);
pub const SOCK_PROTO_PROTO_236: SockProto = SockProto(236);
pub const SOCK_PROTO_PROTO_237: SockProto = SockProto(237);
pub const SOCK_PROTO_PROTO_238: SockProto = SockProto(238);
pub const SOCK_PROTO_PROTO_239: SockProto = SockProto(239);
pub const SOCK_PROTO_PROTO_240: SockProto = SockProto(240);
pub const SOCK_PROTO_PROTO_241: SockProto = SockProto(241);
pub const SOCK_PROTO_PROTO_242: SockProto = SockProto(242);
pub const SOCK_PROTO_PROTO_243: SockProto = SockProto(243);
pub const SOCK_PROTO_PROTO_244: SockProto = SockProto(244);
pub const SOCK_PROTO_PROTO_245: SockProto = SockProto(245);
pub const SOCK_PROTO_PROTO_246: SockProto = SockProto(246);
pub const SOCK_PROTO_PROTO_247: SockProto = SockProto(247);
pub const SOCK_PROTO_PROTO_248: SockProto = SockProto(248);
pub const SOCK_PROTO_PROTO_249: SockProto = SockProto(249);
pub const SOCK_PROTO_PROTO_250: SockProto = SockProto(250);
pub const SOCK_PROTO_PROTO_251: SockProto = SockProto(251);
pub const SOCK_PROTO_PROTO_252: SockProto = SockProto(252);
pub const SOCK_PROTO_PROTO_253: SockProto = SockProto(253);
pub const SOCK_PROTO_PROTO_254: SockProto = SockProto(254);
pub const SOCK_PROTO_PROTO_RAW: SockProto = SockProto(255);
pub const SOCK_PROTO_PROTO_256: SockProto = SockProto(256);
pub const SOCK_PROTO_PROTO_257: SockProto = SockProto(257);
pub const SOCK_PROTO_PROTO_258: SockProto = SockProto(258);
pub const SOCK_PROTO_PROTO_259: SockProto = SockProto(259);
pub const SOCK_PROTO_PROTO_260: SockProto = SockProto(260);
pub const SOCK_PROTO_PROTO_261: SockProto = SockProto(261);
pub const SOCK_PROTO_MPTCP: SockProto = SockProto(262);
pub const SOCK_PROTO_MAX: SockProto = SockProto(263);
impl SockProto {
    pub const fn raw(&self) -> u16 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "IP",
            1 => "ICMP",
            2 => "IGMP",
            3 => "PROTO_3",
            4 => "IPIP",
            5 => "PROTO_5",
            6 => "TCP",
            7 => "PROTO_7",
            8 => "EGP",
            9 => "PROTO_9",
            10 => "PROTO_10",
            11 => "PROTO_11",
            12 => "PUP",
            13 => "PROTO_13",
            14 => "PROTO_14",
            15 => "PROTO_15",
            16 => "PROTO_16",
            17 => "UDP",
            18 => "PROTO_18",
            19 => "PROTO_19",
            20 => "PROTO_20",
            21 => "PROTO_21",
            22 => "IDP",
            23 => "PROTO_23",
            24 => "PROTO_24",
            25 => "PROTO_25",
            26 => "PROTO_26",
            27 => "PROTO_27",
            28 => "PROTO_28",
            29 => "PROTO_TP",
            30 => "PROTO_30",
            31 => "PROTO_31",
            32 => "PROTO_32",
            33 => "DCCP",
            34 => "PROTO_34",
            35 => "PROTO_35",
            36 => "PROTO_36",
            37 => "PROTO_37",
            38 => "PROTO_38",
            39 => "PROTO_39",
            40 => "PROTO_40",
            41 => "IPV6",
            42 => "PROTO_42",
            43 => "ROUTING",
            44 => "FRAGMENT",
            45 => "PROTO_45",
            46 => "RSVP",
            47 => "GRE",
            48 => "PROTO_48",
            49 => "PROTO_49",
            50 => "ESP",
            51 => "AH",
            52 => "PROTO_52",
            53 => "PROTO_53",
            54 => "PROTO_54",
            55 => "PROTO_55",
            56 => "PROTO_56",
            57 => "PROTO_57",
            58 => "ICMPV6",
            59 => "NONE",
            60 => "DSTOPTS",
            61 => "PROTO_61",
            62 => "PROTO_62",
            63 => "PROTO_63",
            64 => "PROTO_64",
            65 => "PROTO_65",
            66 => "PROTO_66",
            67 => "PROTO_67",
            68 => "PROTO_68",
            69 => "PROTO_69",
            70 => "PROTO_70",
            71 => "PROTO_71",
            72 => "PROTO_72",
            73 => "PROTO_73",
            74 => "PROTO_74",
            75 => "PROTO_75",
            76 => "PROTO_76",
            77 => "PROTO_77",
            78 => "PROTO_78",
            79 => "PROTO_79",
            80 => "PROTO_80",
            81 => "PROTO_81",
            82 => "PROTO_82",
            83 => "PROTO_83",
            84 => "PROTO_84",
            85 => "PROTO_85",
            86 => "PROTO_86",
            87 => "PROTO_87",
            88 => "PROTO_88",
            89 => "PROTO_89",
            90 => "PROTO_90",
            91 => "PROTO_91",
            92 => "MTP",
            93 => "PROTO_93",
            94 => "BEETPH",
            95 => "PROTO_95",
            96 => "PROTO_96",
            97 => "PROTO_97",
            98 => "ENCAP",
            99 => "PROTO_99",
            100 => "PROTO_100",
            101 => "PROTO_101",
            102 => "PROTO_102",
            103 => "PIM",
            104 => "PROTO_104",
            105 => "PROTO_105",
            106 => "PROTO_106",
            107 => "PROTO_107",
            108 => "COMP",
            109 => "PROTO_109",
            110 => "PROTO_110",
            111 => "PROTO_111",
            112 => "PROTO_112",
            113 => "PROTO_113",
            114 => "PROTO_114",
            115 => "PROTO_115",
            116 => "PROTO_116",
            117 => "PROTO_117",
            118 => "PROTO_118",
            119 => "PROTO_119",
            120 => "PROTO_120",
            121 => "PROTO_121",
            122 => "PROTO_122",
            123 => "PROTO_123",
            124 => "PROTO_124",
            125 => "PROTO_125",
            126 => "PROTO_126",
            127 => "PROTO_127",
            128 => "PROTO_128",
            129 => "PROTO_129",
            130 => "PROTO_130",
            131 => "PROTO_131",
            132 => "SCTP",
            133 => "PROTO_133",
            134 => "PROTO_134",
            135 => "MH",
            136 => "UDPLITE",
            137 => "MPLS",
            138 => "PROTO_138",
            139 => "PROTO_139",
            140 => "PROTO_140",
            141 => "PROTO_141",
            142 => "PROTO_142",
            143 => "ETHERNET",
            144 => "PROTO_144",
            145 => "PROTO_145",
            146 => "PROTO_146",
            147 => "PROTO_147",
            148 => "PROTO_148",
            149 => "PROTO_149",
            150 => "PROTO_150",
            151 => "PROTO_151",
            152 => "PROTO_152",
            153 => "PROTO_153",
            154 => "PROTO_154",
            155 => "PROTO_155",
            156 => "PROTO_156",
            157 => "PROTO_157",
            158 => "PROTO_158",
            159 => "PROTO_159",
            160 => "PROTO_160",
            161 => "PROTO_161",
            162 => "PROTO_162",
            163 => "PROTO_163",
            164 => "PROTO_164",
            165 => "PROTO_165",
            166 => "PROTO_166",
            167 => "PROTO_167",
            168 => "PROTO_168",
            169 => "PROTO_169",
            170 => "PROTO_170",
            171 => "PROTO_171",
            172 => "PROTO_172",
            173 => "PROTO_173",
            174 => "PROTO_174",
            175 => "PROTO_175",
            176 => "PROTO_176",
            177 => "PROTO_177",
            178 => "PROTO_178",
            179 => "PROTO_179",
            180 => "PROTO_180",
            181 => "PROTO_181",
            182 => "PROTO_182",
            183 => "PROTO_183",
            184 => "PROTO_184",
            185 => "PROTO_185",
            186 => "PROTO_186",
            187 => "PROTO_187",
            188 => "PROTO_188",
            189 => "PROTO_189",
            190 => "PROTO_190",
            191 => "PROTO_191",
            192 => "PROTO_192",
            193 => "PROTO_193",
            194 => "PROTO_194",
            195 => "PROTO_195",
            196 => "PROTO_196",
            197 => "PROTO_197",
            198 => "PROTO_198",
            199 => "PROTO_199",
            200 => "PROTO_200",
            201 => "PROTO_201",
            202 => "PROTO_202",
            203 => "PROTO_203",
            204 => "PROTO_204",
            205 => "PROTO_205",
            206 => "PROTO_206",
            207 => "PROTO_207",
            208 => "PROTO_208",
            209 => "PROTO_209",
            210 => "PROTO_210",
            211 => "PROTO_211",
            212 => "PROTO_212",
            213 => "PROTO_213",
            214 => "PROTO_214",
            215 => "PROTO_215",
            216 => "PROTO_216",
            217 => "PROTO_217",
            218 => "PROTO_218",
            219 => "PROTO_219",
            220 => "PROTO_220",
            221 => "PROTO_221",
            222 => "PROTO_222",
            223 => "PROTO_223",
            224 => "PROTO_224",
            225 => "PROTO_225",
            226 => "PROTO_226",
            227 => "PROTO_227",
            228 => "PROTO_228",
            229 => "PROTO_229",
            230 => "PROTO_230",
            231 => "PROTO_231",
            232 => "PROTO_232",
            233 => "PROTO_233",
            234 => "PROTO_234",
            235 => "PROTO_235",
            236 => "PROTO_236",
            237 => "PROTO_237",
            238 => "PROTO_238",
            239 => "PROTO_239",
            240 => "PROTO_240",
            241 => "PROTO_241",
            242 => "PROTO_242",
            243 => "PROTO_243",
            244 => "PROTO_244",
            245 => "PROTO_245",
            246 => "PROTO_246",
            247 => "PROTO_247",
            248 => "PROTO_248",
            249 => "PROTO_249",
            250 => "PROTO_250",
            251 => "PROTO_251",
            252 => "PROTO_252",
            253 => "PROTO_253",
            254 => "PROTO_254",
            255 => "PROTO_RAW",
            256 => "PROTO_256",
            257 => "PROTO_257",
            258 => "PROTO_258",
            259 => "PROTO_259",
            260 => "PROTO_260",
            261 => "PROTO_261",
            262 => "MPTCP",
            263 => "MAX",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "",
            1 => "",
            2 => "",
            3 => "",
            4 => "",
            5 => "",
            6 => "",
            7 => "",
            8 => "",
            9 => "",
            10 => "",
            11 => "",
            12 => "",
            13 => "",
            14 => "",
            15 => "",
            16 => "",
            17 => "",
            18 => "",
            19 => "",
            20 => "",
            21 => "",
            22 => "",
            23 => "",
            24 => "",
            25 => "",
            26 => "",
            27 => "",
            28 => "",
            29 => "",
            30 => "",
            31 => "",
            32 => "",
            33 => "",
            34 => "",
            35 => "",
            36 => "",
            37 => "",
            38 => "",
            39 => "",
            40 => "",
            41 => "",
            42 => "",
            43 => "",
            44 => "",
            45 => "",
            46 => "",
            47 => "",
            48 => "",
            49 => "",
            50 => "",
            51 => "",
            52 => "",
            53 => "",
            54 => "",
            55 => "",
            56 => "",
            57 => "",
            58 => "",
            59 => "",
            60 => "",
            61 => "",
            62 => "",
            63 => "",
            64 => "",
            65 => "",
            66 => "",
            67 => "",
            68 => "",
            69 => "",
            70 => "",
            71 => "",
            72 => "",
            73 => "",
            74 => "",
            75 => "",
            76 => "",
            77 => "",
            78 => "",
            79 => "",
            80 => "",
            81 => "",
            82 => "",
            83 => "",
            84 => "",
            85 => "",
            86 => "",
            87 => "",
            88 => "",
            89 => "",
            90 => "",
            91 => "",
            92 => "",
            93 => "",
            94 => "",
            95 => "",
            96 => "",
            97 => "",
            98 => "",
            99 => "",
            100 => "",
            101 => "",
            102 => "",
            103 => "",
            104 => "",
            105 => "",
            106 => "",
            107 => "",
            108 => "",
            109 => "",
            110 => "",
            111 => "",
            112 => "",
            113 => "",
            114 => "",
            115 => "",
            116 => "",
            117 => "",
            118 => "",
            119 => "",
            120 => "",
            121 => "",
            122 => "",
            123 => "",
            124 => "",
            125 => "",
            126 => "",
            127 => "",
            128 => "",
            129 => "",
            130 => "",
            131 => "",
            132 => "",
            133 => "",
            134 => "",
            135 => "",
            136 => "",
            137 => "",
            138 => "",
            139 => "",
            140 => "",
            141 => "",
            142 => "",
            143 => "",
            144 => "",
            145 => "",
            146 => "",
            147 => "",
            148 => "",
            149 => "",
            150 => "",
            151 => "",
            152 => "",
            153 => "",
            154 => "",
            155 => "",
            156 => "",
            157 => "",
            158 => "",
            159 => "",
            160 => "",
            161 => "",
            162 => "",
            163 => "",
            164 => "",
            165 => "",
            166 => "",
            167 => "",
            168 => "",
            169 => "",
            170 => "",
            171 => "",
            172 => "",
            173 => "",
            174 => "",
            175 => "",
            176 => "",
            177 => "",
            178 => "",
            179 => "",
            180 => "",
            181 => "",
            182 => "",
            183 => "",
            184 => "",
            185 => "",
            186 => "",
            187 => "",
            188 => "",
            189 => "",
            190 => "",
            191 => "",
            192 => "",
            193 => "",
            194 => "",
            195 => "",
            196 => "",
            197 => "",
            198 => "",
            199 => "",
            200 => "",
            201 => "",
            202 => "",
            203 => "",
            204 => "",
            205 => "",
            206 => "",
            207 => "",
            208 => "",
            209 => "",
            210 => "",
            211 => "",
            212 => "",
            213 => "",
            214 => "",
            215 => "",
            216 => "",
            217 => "",
            218 => "",
            219 => "",
            220 => "",
            221 => "",
            222 => "",
            223 => "",
            224 => "",
            225 => "",
            226 => "",
            227 => "",
            228 => "",
            229 => "",
            230 => "",
            231 => "",
            232 => "",
            233 => "",
            234 => "",
            235 => "",
            236 => "",
            237 => "",
            238 => "",
            239 => "",
            240 => "",
            241 => "",
            242 => "",
            243 => "",
            244 => "",
            245 => "",
            246 => "",
            247 => "",
            248 => "",
            249 => "",
            250 => "",
            251 => "",
            252 => "",
            253 => "",
            254 => "",
            255 => "",
            256 => "",
            257 => "",
            258 => "",
            259 => "",
            260 => "",
            261 => "",
            262 => "",
            263 => "",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for SockProto {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("SockProto")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}
impl From<u16> for SockProto {
    fn from(a: u16) -> Self {
        Self(a)
    }
}

#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct SockStatus(u8);
/// The socket is still opening
pub const SOCK_STATUS_OPENING: SockStatus = SockStatus(0);
/// The socket has fully opened
pub const SOCK_STATUS_OPENED: SockStatus = SockStatus(1);
/// The socket has closed
pub const SOCK_STATUS_CLOSED: SockStatus = SockStatus(2);
/// The socket has failed
pub const SOCK_STATUS_FAILED: SockStatus = SockStatus(3);
impl SockStatus {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "OPENING",
            1 => "OPENED",
            2 => "CLOSED",
            3 => "FAILED",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "The socket is still opening",
            1 => "The socket has fully opened",
            2 => "The socket has closed",
            3 => "The socket has failed",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for SockStatus {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("SockStatus")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}
impl From<u8> for SockStatus {
    fn from(a: u8) -> Self {
        Self(a)
    }
}

#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct SockOption(u8);
/// Socket option that does nothing
pub const SOCK_OPTION_NOOP: SockOption = SockOption(0);
/// Reuse Port
pub const SOCK_OPTION_REUSE_PORT: SockOption = SockOption(1);
/// Reuse Address
pub const SOCK_OPTION_REUSE_ADDR: SockOption = SockOption(2);
/// No delay
pub const SOCK_OPTION_NO_DELAY: SockOption = SockOption(3);
/// Dont route
pub const SOCK_OPTION_DONT_ROUTE: SockOption = SockOption(4);
/// Only accept IPv6
pub const SOCK_OPTION_ONLY_V6: SockOption = SockOption(5);
/// Broadcast
pub const SOCK_OPTION_BROADCAST: SockOption = SockOption(6);
/// Multicast Loop IPv4
pub const SOCK_OPTION_MULTICAST_LOOP_V4: SockOption = SockOption(7);
/// Multicast Loop IPv6
pub const SOCK_OPTION_MULTICAST_LOOP_V6: SockOption = SockOption(8);
/// Promiscuous
pub const SOCK_OPTION_PROMISCUOUS: SockOption = SockOption(9);
/// Socket is listening
pub const SOCK_OPTION_LISTENING: SockOption = SockOption(10);
/// Last error
pub const SOCK_OPTION_LAST_ERROR: SockOption = SockOption(11);
/// Keep alive
pub const SOCK_OPTION_KEEP_ALIVE: SockOption = SockOption(12);
/// Linger time
pub const SOCK_OPTION_LINGER: SockOption = SockOption(13);
/// Out-of-band inline
pub const SOCK_OPTION_OOB_INLINE: SockOption = SockOption(14);
/// Receive buffer size
pub const SOCK_OPTION_RECV_BUF_SIZE: SockOption = SockOption(15);
/// Send buffer size
pub const SOCK_OPTION_SEND_BUF_SIZE: SockOption = SockOption(16);
/// Receive lowat
pub const SOCK_OPTION_RECV_LOWAT: SockOption = SockOption(17);
/// Send lowat
pub const SOCK_OPTION_SEND_LOWAT: SockOption = SockOption(18);
/// Receive timeout
pub const SOCK_OPTION_RECV_TIMEOUT: SockOption = SockOption(19);
/// Send timeout
pub const SOCK_OPTION_SEND_TIMEOUT: SockOption = SockOption(20);
/// Connect timeout
pub const SOCK_OPTION_CONNECT_TIMEOUT: SockOption = SockOption(21);
/// Accept timeout
pub const SOCK_OPTION_ACCEPT_TIMEOUT: SockOption = SockOption(22);
/// TTL of packets
pub const SOCK_OPTION_TTL: SockOption = SockOption(23);
/// Multicast TTL for IPv4
pub const SOCK_OPTION_MULTICAST_TTL_V4: SockOption = SockOption(24);
/// Type of socket
pub const SOCK_OPTION_TYPE: SockOption = SockOption(25);
/// Protocol of the socket
pub const SOCK_OPTION_PROTO: SockOption = SockOption(26);
impl SockOption {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "NOOP",
            1 => "REUSE_PORT",
            2 => "REUSE_ADDR",
            3 => "NO_DELAY",
            4 => "DONT_ROUTE",
            5 => "ONLY_V6",
            6 => "BROADCAST",
            7 => "MULTICAST_LOOP_V4",
            8 => "MULTICAST_LOOP_V6",
            9 => "PROMISCUOUS",
            10 => "LISTENING",
            11 => "LAST_ERROR",
            12 => "KEEP_ALIVE",
            13 => "LINGER",
            14 => "OOB_INLINE",
            15 => "RECV_BUF_SIZE",
            16 => "SEND_BUF_SIZE",
            17 => "RECV_LOWAT",
            18 => "SEND_LOWAT",
            19 => "RECV_TIMEOUT",
            20 => "SEND_TIMEOUT",
            21 => "CONNECT_TIMEOUT",
            22 => "ACCEPT_TIMEOUT",
            23 => "TTL",
            24 => "MULTICAST_TTL_V4",
            25 => "TYPE",
            26 => "PROTO",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "Socket option that does nothing",
            1 => "Reuse Port",
            2 => "Reuse Address",
            3 => "No delay",
            4 => "Dont route",
            5 => "Only accept IPv6",
            6 => "Broadcast",
            7 => "Multicast Loop IPv4",
            8 => "Multicast Loop IPv6",
            9 => "Promiscuous",
            10 => "Socket is listening",
            11 => "Last error",
            12 => "Keep alive",
            13 => "Linger time",
            14 => "Out-of-band inline",
            15 => "Receive buffer size",
            16 => "Send buffer size",
            17 => "Receive lowat",
            18 => "Send lowat",
            19 => "Receive timeout",
            20 => "Send timeout",
            21 => "Connect timeout",
            22 => "Accept timeout",
            23 => "TTL of packets",
            24 => "Multicast TTL for IPv4",
            25 => "Type of socket",
            26 => "Protocol of the socket",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for SockOption {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("SockOption")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}
impl From<u8> for SockOption {
    fn from(a: u8) -> Self {
        Self(a)
    }
}

pub type StreamSecurity = u8;
/// Unencrypted
pub const STREAM_SECURITY_UNENCRYPTED: StreamSecurity = 1 << 0;
/// Any encryption
pub const STREAM_SECURITY_ANY_ENCRYPTION: StreamSecurity = 1 << 1;
/// Classic encryption
pub const STREAM_SECURITY_CLASSIC_ENCRYPTION: StreamSecurity = 1 << 2;
/// Double encryption
pub const STREAM_SECURITY_DOUBLE_ENCRYPTION: StreamSecurity = 1 << 3;

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct HardwareAddress {
    pub n0: u8,
    pub n1: u8,
    pub n2: u8,
    pub h0: u8,
    pub h1: u8,
    pub h2: u8,
}
pub type IpPort = u16;
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct AddressFamily(u8);
/// Unspecified
pub const ADDRESS_FAMILY_UNSPEC: AddressFamily = AddressFamily(0);
/// IP v4
pub const ADDRESS_FAMILY_INET4: AddressFamily = AddressFamily(1);
/// IP v6
pub const ADDRESS_FAMILY_INET6: AddressFamily = AddressFamily(2);
/// Unix
pub const ADDRESS_FAMILY_UNIX: AddressFamily = AddressFamily(3);
impl AddressFamily {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "UNSPEC",
            1 => "INET4",
            2 => "INET6",
            3 => "UNIX",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "Unspecified",
            1 => "IP v4",
            2 => "IP v6",
            3 => "Unix",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for AddressFamily {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("AddressFamily")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}
impl From<u8> for AddressFamily {
    fn from(a: u8) -> Self {
        Self(a)
    }
}

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrUnspec {
    pub n0: u8,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrUnspecPort {
    pub port: IpPort,
    pub addr: AddrUnspec,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrUnspecCidr {
    pub addr: AddrUnspec,
    pub prefix: u8,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrIp4 {
    pub n0: u8,
    pub n1: u8,
    pub h0: u8,
    pub h1: u8,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrIp4Port {
    pub port: IpPort,
    pub addr: AddrIp4,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrIp4Cidr {
    pub addr: AddrIp4,
    pub prefix: u8,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrIp6 {
    pub n0: u16,
    pub n1: u16,
    pub n2: u16,
    pub n3: u16,
    pub h0: u16,
    pub h1: u16,
    pub h2: u16,
    pub h3: u16,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrUnix {
    pub b0: u8,
    pub b1: u8,
    pub b2: u8,
    pub b3: u8,
    pub b4: u8,
    pub b5: u8,
    pub b6: u8,
    pub b7: u8,
    pub b8: u8,
    pub b9: u8,
    pub b10: u8,
    pub b11: u8,
    pub b12: u8,
    pub b13: u8,
    pub b14: u8,
    pub b15: u8,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrUnixPort {
    pub port: IpPort,
    pub addr: AddrUnix,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrUnixCidr {
    pub addr: AddrUnix,
    pub prefix: u8,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrIp6Port {
    pub port: IpPort,
    pub addr: AddrIp6,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrIp6Cidr {
    pub addr: AddrIp6,
    pub prefix: u8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union AddrU {
    pub unspec: AddrUnspec,
    pub inet4: AddrIp4,
    pub inet6: AddrIp6,
    pub unix: AddrUnix,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct Addr {
    pub tag: u8,
    pub u: AddrU,
}

pub type AddrArray<'a> = &'a [Addr];
#[repr(C)]
#[derive(Copy, Clone)]
pub union AddrPortU {
    pub unspec: AddrUnspecPort,
    pub inet4: AddrIp4Port,
    pub inet6: AddrIp6Port,
    pub unix: AddrUnixPort,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct AddrPort {
    pub tag: u8,
    pub u: AddrPortU,
}

pub type AddrPortArray<'a> = &'a [AddrPort];
#[repr(C)]
#[derive(Copy, Clone)]
pub union AddrCidrU {
    pub unspec: AddrUnspecCidr,
    pub inet4: AddrIp4Cidr,
    pub inet6: AddrIp6Cidr,
    pub unix: AddrUnixCidr,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct AddrCidr {
    pub tag: u8,
    pub u: AddrCidrU,
}

pub type AddrCidrArray<'a> = &'a [AddrCidr];
#[repr(C)]
#[derive(Copy, Clone)]
pub struct Route {
    pub cidr: AddrCidr,
    pub via_router: Addr,
    pub preferred_until: OptionTimestamp,
    pub expires_at: OptionTimestamp,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct HttpHandles {
    /// File handle used to write the request data
    pub request: Fd,
    /// File handle used to receive the response data
    pub response: Fd,
    /// File handle used to read the response headers
    /// (entries are separated by line feeds)
    pub headers: Fd,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct HttpStatus {
    pub ok: Bool,
    pub redirected: Bool,
    /// Size of the response
    pub size: Filesize,
    /// HTTP status code for this response
    pub status: u16,
}
pub type JoinFlags = u32;
/// Non-blocking join on the process
pub const JOIN_FLAGS_NON_BLOCKING: JoinFlags = 1 << 0;
/// Return if a process is stopped
pub const JOIN_FLAGS_WAKE_STOPPED: JoinFlags = 1 << 1;

#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct JoinStatusType(u8);
/// Nothing has happened
pub const JOIN_STATUS_TYPE_NOTHING: JoinStatusType = JoinStatusType(0);
/// The process has exited by a normal exit code
pub const JOIN_STATUS_TYPE_EXIT_NORMAL: JoinStatusType = JoinStatusType(1);
/// The process was terminated by a signal
pub const JOIN_STATUS_TYPE_EXIT_SIGNAL: JoinStatusType = JoinStatusType(2);
/// The process was stopped by a signal and can be resumed with SIGCONT
pub const JOIN_STATUS_TYPE_STOPPED: JoinStatusType = JoinStatusType(3);
impl JoinStatusType {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "NOTHING",
            1 => "EXIT_NORMAL",
            2 => "EXIT_SIGNAL",
            3 => "STOPPED",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "Nothing has happened",
            1 => "The process has exited by a normal exit code",
            2 => "The process was terminated by a signal",
            3 => "The process was stopped by a signal and can be resumed with SIGCONT",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for JoinStatusType {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("JoinStatusType")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}
impl From<u8> for JoinStatusType {
    fn from(a: u8) -> Self {
        Self(a)
    }
}

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct ErrnoSignal {
    /// The exit code that was returned
    pub exit_code: Errno,
    /// The signal that was returned
    pub signal: Signal,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union JoinStatusU {
    pub nothing: u8,
    pub exit_normal: Errno,
    pub exit_signal: ErrnoSignal,
    pub stopped: Signal,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct JoinStatus {
    pub tag: u8,
    pub u: JoinStatusU,
}

pub type ThreadFlags = u16;
/// tsd_used
pub const THREAD_FLAGS_TSD_USED: ThreadFlags = 1 << 0;
/// dlerror_flag
pub const THREAD_FLAGS_DLERROR_FLAG: ThreadFlags = 1 << 1;

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct ThreadState {
    pub thread_self: Pointersize,
    pub dtv: Pointersize,
    pub thread_prev: Pointersize,
    pub thread_next: Pointersize,
    pub sysinfo: Pointersize,
    pub canary: Pointersize,
    pub tid: i32,
    pub errno_val: i32,
    pub detach_state: i32,
    pub cancel: i32,
    pub canceldisable: u8,
    pub cancelasync: u8,
    pub flags: ThreadFlags,
    pub map_base: Pointersize,
    pub map_size: Pointersize,
    pub stack: Pointersize,
    pub stack_size: Pointersize,
    pub guard_size: Pointersize,
    pub result: Pointersize,
    pub cancelbuf: Pointersize,
    pub tsd: Pointersize,
    pub robust_list_head: Pointersize,
    pub robust_list_off: Pointersize,
    pub robust_list_pending: Pointersize,
    pub h_errno_val: i32,
    pub timer_id: i32,
    pub locale: Pointersize,
    pub killlock: i32,
    pub dlerror_buf: Pointersize,
    pub stdio_locks: Pointersize,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct ThreadStart {
    /// Address where the stack starts
    pub stack: Pointersize,
    /// Address where the TLS starts
    pub tls_base: Pointersize,
    /// Function that will be invoked when the thread starts
    pub start_funct: Pointersize,
    /// Arguments to pass the callback function
    pub start_args: Pointersize,
    /// Reserved for future WASI usage
    pub reserved0: Pointersize,
    pub reserved1: Pointersize,
    pub reserved2: Pointersize,
    pub reserved3: Pointersize,
    pub reserved4: Pointersize,
    pub reserved5: Pointersize,
    pub reserved6: Pointersize,
    pub reserved7: Pointersize,
    pub reserved8: Pointersize,
    pub reserved9: Pointersize,
    /// The size of the stack
    pub stack_size: Pointersize,
    /// The size of the guards at the end of the stack
    pub guard_size: Pointersize,
}
pub type EpollType = u32;
pub const EPOLL_TYPE_EPOLLIN: EpollType = 1 << 0;
pub const EPOLL_TYPE_EPOLLOUT: EpollType = 1 << 1;
pub const EPOLL_TYPE_EPOLLRDHUP: EpollType = 1 << 2;
pub const EPOLL_TYPE_EPOLLPRI: EpollType = 1 << 3;
pub const EPOLL_TYPE_EPOLLERR: EpollType = 1 << 4;
pub const EPOLL_TYPE_EPOLLHUP: EpollType = 1 << 5;
pub const EPOLL_TYPE_EPOLLET: EpollType = 1 << 6;
pub const EPOLL_TYPE_EPOLLONESHOT: EpollType = 1 << 7;

#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct EpollCtl(u32);
/// Add an entry to the interest list of the epoll file descriptor, epfd.
pub const EPOLL_CTL_ADD: EpollCtl = EpollCtl(0);
/// Change the settings associated with fd in the interest list to the new settings specified in event.
pub const EPOLL_CTL_MOD: EpollCtl = EpollCtl(1);
/// Remove (deregister) the target file descriptor fd from the interest list.
pub const EPOLL_CTL_DEL: EpollCtl = EpollCtl(2);
impl EpollCtl {
    pub const fn raw(&self) -> u32 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "ADD",
            1 => "MOD",
            2 => "DEL",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {0 => "Add an entry to the interest list of the epoll file descriptor, epfd.",1 => "Change the settings associated with fd in the interest list to the new settings specified in event.",2 => "Remove (deregister) the target file descriptor fd from the interest list.",_ => unsafe { core::hint::unreachable_unchecked() },}
    }
}
impl fmt::Debug for EpollCtl {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("EpollCtl")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}
impl From<u32> for EpollCtl {
    fn from(a: u32) -> Self {
        Self(a)
    }
}

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct EpollData {
    /// Pointer to some user defined data
    pub ptr: Pointersize,
    /// The file descriptor of the event
    pub fd: Fd,
    /// User data for the event
    pub data1: u32,
    /// User data for the event
    pub data2: u64,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct EpollEvent {
    /// The events that are triggered for this
    pub events: EpollType,
    /// The data of the event
    pub data: EpollData,
}
/// Sets the time value of a clock.
/// Note: This is similar to `clock_settime` in POSIX.
///
/// ## Parameters
///
/// * `id` - The clock for which to set the time.
/// * `timestamp` - The value of the time to be set.
///
/// ## Return
///
/// The time value of the clock.
pub unsafe fn clock_time_set(id: Clockid, timestamp: Timestamp) -> Result<(), Errno> {
    let ret = wasix_64v1::clock_time_set(id.raw() as i32, timestamp as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Atomically duplicate a file handle.
pub unsafe fn fd_dup(fd: Fd) -> Result<Fd, Errno> {
    let mut rp0 = MaybeUninit::<Fd>::uninit();
    let ret = wasix_64v1::fd_dup(fd as i32, rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Fd)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Creates a file handle for event notifications
///
pub unsafe fn fd_event(initial_val: u64, flags: Eventfdflags) -> Result<Fd, Errno> {
    let mut rp0 = MaybeUninit::<Fd>::uninit();
    let ret = wasix_64v1::fd_event(initial_val as i64, flags as i32, rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Fd)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Opens a pipe with two file handles
///
/// Pipes are bidirectional
pub unsafe fn fd_pipe() -> Result<(Fd, Fd), Errno> {
    let mut rp0 = MaybeUninit::<Fd>::uninit();
    let mut rp1 = MaybeUninit::<Fd>::uninit();
    let ret = wasix_64v1::fd_pipe(rp0.as_mut_ptr() as i64, rp1.as_mut_ptr() as i64);
    match ret {
        0 => Ok((
            core::ptr::read(rp0.as_mut_ptr() as i64 as *const Fd),
            core::ptr::read(rp1.as_mut_ptr() as i64 as *const Fd),
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Retrieves the current state of the TTY
pub unsafe fn tty_get(state: *mut Tty) -> Result<(), Errno> {
    let ret = wasix_64v1::tty_get(state as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Updates the properties of the the TTY
pub unsafe fn tty_set(state: *mut Tty) -> Result<(), Errno> {
    let ret = wasix_64v1::tty_set(state as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the current working directory
///
/// If the path exceeds the size of the buffer then this function
/// will fill the path_len with the needed size and return EOVERFLOW
///
/// ## Parameters
///
/// * `path` - The buffer where current directory is stored
pub unsafe fn getcwd(path: *mut u8, path_len: *mut Pointersize) -> Result<(), Errno> {
    let ret = wasix_64v1::getcwd(path as i64, path_len as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Sets the current working directory
///
/// ## Parameters
///
/// * `path` - Path to change the current working directory to
pub unsafe fn chdir(path: &str) -> Result<(), Errno> {
    let ret = wasix_64v1::chdir(path.as_ptr() as i64, path.len() as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Registers a callback function for signals
///
/// ## Parameters
///
/// * `callback` - Exported function that will be called back when the signal triggers
///   (must match the callback signature that takes the signal value)
///   (if this is not specified the default will be "_signal")
pub unsafe fn callback_signal(callback: &str) {
    wasix_64v1::callback_signal(callback.as_ptr() as i64, callback.len() as i64);
}

/// Creates a new thread by spawning that shares the same
/// memory address space, file handles and main event loops.
/// The web assembly process must export function named 'wasi_thread_start'
///
/// ## Parameters
///
/// * `args` - Pointer to the structure the describes the thread
///   that is being spawened
///
/// ## Return
///
/// Returns the thread index of the newly created thread
/// (indices always start from zero)
pub unsafe fn thread_spawn_v2(args: *mut ThreadStart) -> Result<Tid, Errno> {
    let mut rp0 = MaybeUninit::<Tid>::uninit();
    let ret = wasix_64v1::thread_spawn_v2(args as i64, rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Tid)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Sends the current thread to sleep for a period of time
///
/// ## Parameters
///
/// * `duration` - Amount of time that the thread should sleep
pub unsafe fn thread_sleep(duration: Timestamp) -> Result<(), Errno> {
    let ret = wasix_64v1::thread_sleep(duration as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the index of the current thread
/// (threads indices are sequential from zero while the
///  main thread ID equals the process ID)
pub unsafe fn thread_id() -> Result<Tid, Errno> {
    let mut rp0 = MaybeUninit::<Tid>::uninit();
    let ret = wasix_64v1::thread_id(rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Tid)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Joins this thread with another thread, blocking this
/// one until the other finishes
///
/// ## Parameters
///
/// * `tid` - Handle of the thread to wait on
pub unsafe fn thread_join(tid: Tid) -> Result<(), Errno> {
    let ret = wasix_64v1::thread_join(tid as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the available parallelism which is normally the
/// number of available cores that can run concurrently
pub unsafe fn thread_parallelism() -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_64v1::thread_parallelism(rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Sends a signal to a specific thread
///
/// ## Parameters
///
/// * `tid` - Handle of the thread to send a signal
/// * `signal` - Signal to send to the thread
pub unsafe fn thread_signal(tid: Tid, signal: Signal) -> Result<(), Errno> {
    let ret = wasix_64v1::thread_signal(tid as i32, signal.0 as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Wait for a futex_wake operation to wake us.
///
/// Returns with EINVAL if the futex doesn't hold the expected value.
/// Returns false on timeout, and true in all other cases.
///
/// ## Parameters
///
/// * `futex` - Memory location that holds the value that will be checked
/// * `expected` - Expected value that should be currently held at the memory location
/// * `timeout` - Timeout should the futex not be triggered in the allocated time
pub unsafe fn futex_wait(
    futex: *mut u32,
    expected: u32,
    timeout: *const OptionTimestamp,
) -> Result<Bool, Errno> {
    let mut rp0 = MaybeUninit::<Bool>::uninit();
    let ret = wasix_64v1::futex_wait(
        futex as i64,
        expected as i32,
        timeout as i64,
        rp0.as_mut_ptr() as i64,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Bool)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Wake up one thread that's blocked on futex_wait on this futex.
///
/// Returns true if this actually woke up such a thread,
/// or false if no thread was waiting on this futex.
///
/// ## Parameters
///
/// * `futex` - Memory location that holds a futex that others may be waiting on
pub unsafe fn futex_wake(futex: *mut u32) -> Result<Bool, Errno> {
    let mut rp0 = MaybeUninit::<Bool>::uninit();
    let ret = wasix_64v1::futex_wake(futex as i64, rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Bool)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Wake up all threads that are waiting on futex_wait on this futex.
///
/// ## Parameters
///
/// * `futex` - Memory location that holds a futex that others may be waiting on
pub unsafe fn futex_wake_all(futex: *mut u32) -> Result<Bool, Errno> {
    let mut rp0 = MaybeUninit::<Bool>::uninit();
    let ret = wasix_64v1::futex_wake_all(futex as i64, rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Bool)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Terminates the current running thread, if this is the last thread then
/// the process will also exit with the specified exit code. An exit code
/// of 0 indicates successful termination of the thread. The meanings of
/// other values is dependent on the environment.
///
/// ## Parameters
///
/// * `rval` - The exit code returned by the process.
pub unsafe fn thread_exit(rval: Exitcode) {
    wasix_64v1::thread_exit(rval as i32);
}

/// Creates a checkpoint of the current stack which allows it to be restored
/// later using its stack hash. The value supplied will be returned upon
/// restoration (and hence must be none zero) - zero will be returned when
/// the stack is first recorded.
///
/// This is used by `longjmp` and `setjmp`
///
/// This function will read the __stack_pointer global
///
/// ## Parameters
///
/// * `snapshot` - Reference to the stack snapshot that will be filled
///
/// ## Return
///
/// Returns zero upon registration and the value when restored
pub unsafe fn stack_checkpoint(snapshot: *mut StackSnapshot) -> Result<Longsize, Errno> {
    let mut rp0 = MaybeUninit::<Longsize>::uninit();
    let ret = wasix_64v1::stack_checkpoint(snapshot as i64, rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Longsize)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Restores the current stack to a previous stack described by supplying
/// stack snapshot.
///
/// This function will manipulate the __stack_pointer global
///
/// ## Parameters
///
/// * `snapshot` - Reference to the stack snapshot that will be restored
/// * `val` - Value to be returned when the stack is restored
///   (if zero this will change to one)
pub unsafe fn stack_restore(snapshot: *const StackSnapshot, val: Longsize) {
    wasix_64v1::stack_restore(snapshot as i64, val as i64);
}

/// Send a signal to the process of the calling thread on a regular basis
/// Note: This is similar to `setitimer` in POSIX.
///
/// ## Parameters
///
/// * `sig` - The signal condition to trigger.
/// * `interval` - Time to wait before raising the signal
///   (zero here indicates the signal interval is cancelled)
/// * `repeat` - Flag that indicates if the signal will trigger indefinately
pub unsafe fn proc_raise_interval(
    sig: Signal,
    interval: Timestamp,
    repeat: Bool,
) -> Result<(), Errno> {
    let ret = wasix_64v1::proc_raise_interval(sig.0 as i32, interval as i64, repeat.0 as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Forks the current process into a new subprocess. If the function
/// returns a zero then its the new subprocess. If it returns a positive
/// number then its the current process and the $pid represents the child.
///
/// ## Parameters
///
/// * `copy_memory` - Indicates if the memory will be copied into the new process
///   (if it is not copied this then becomes similar to `vfork` in
///    that the current process pauses until `proc_exec` is called)
pub unsafe fn proc_fork(copy_memory: Bool) -> Result<Pid, Errno> {
    let mut rp0 = MaybeUninit::<Pid>::uninit();
    let ret = wasix_64v1::proc_fork(copy_memory.0 as i32, rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Pid)),
        _ => Err(Errno(ret as u16)),
    }
}

/// execve()  executes  the  program  referred to by pathname.  This causes the
/// program that is currently being run by the calling process to  be  replaced
/// with  a  new  program, with newly initialized stack, heap, and (initialized
/// and uninitialized) data segments
///
/// If the named process does not exist then the process will fail and terminate
///
/// ## Parameters
///
/// * `name` - Name of the process to be spawned
/// * `args` - List of the arguments to pass the process
///   (entries are separated by line feeds)
pub unsafe fn proc_exec(name: &str, args: &str) {
    wasix_64v1::proc_exec(
        name.as_ptr() as i64,
        name.len() as i64,
        args.as_ptr() as i64,
        args.len() as i64,
    );
}

/// Spawns a new process within the context of the parent process
/// (i.e. this process). It inherits the filesystem and sandbox
/// permissions but runs standalone.
///
/// ## Parameters
///
/// * `name` - Name of the process to be spawned
/// * `chroot` - Indicates if the process will chroot or not
/// * `args` - List of the arguments to pass the process
///   (entries are separated by line feeds)
/// * `preopen` - List of the preopens for this process
///   (entries are separated by line feeds)
/// * `stdin` - How will stdin be handled
/// * `stdout` - How will stdout be handled
/// * `stderr` - How will stderr be handled
/// * `working_dir` - Working directory where this process should run
///   (passing '.' will use the current directory)
///
/// ## Return
///
/// Returns a bus process id that can be used to invoke calls
pub unsafe fn proc_spawn(
    name: &str,
    chroot: Bool,
    args: &str,
    preopen: &str,
    stdin: StdioMode,
    stdout: StdioMode,
    stderr: StdioMode,
    working_dir: &str,
) -> Result<ProcessHandles, Errno> {
    let mut rp0 = MaybeUninit::<ProcessHandles>::uninit();
    let ret = wasix_64v1::proc_spawn(
        name.as_ptr() as i64,
        name.len() as i64,
        chroot.0 as i32,
        args.as_ptr() as i64,
        args.len() as i64,
        preopen.as_ptr() as i64,
        preopen.len() as i64,
        stdin.0 as i32,
        stdout.0 as i32,
        stderr.0 as i32,
        working_dir.as_ptr() as i64,
        working_dir.len() as i64,
        rp0.as_mut_ptr() as i64,
    );
    match ret {
        0 => Ok(core::ptr::read(
            rp0.as_mut_ptr() as i64 as *const ProcessHandles
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the handle of the current process
pub unsafe fn proc_id() -> Result<Pid, Errno> {
    let mut rp0 = MaybeUninit::<Pid>::uninit();
    let ret = wasix_64v1::proc_id(rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Pid)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the parent handle of a particular process
///
/// ## Parameters
///
/// * `pid` - Handle of the process to get the parent handle for
pub unsafe fn proc_parent(pid: Pid) -> Result<Pid, Errno> {
    let mut rp0 = MaybeUninit::<Pid>::uninit();
    let ret = wasix_64v1::proc_parent(pid as i32, rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Pid)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Wait for process to exit
///
/// Passing none to PID will mean that the call will wait
/// for any subprocess to exit. PID will be populated with
/// the process that exited.
///
/// ## Parameters
///
/// * `pid` - ID of the process to wait on
/// * `flags` - Flags that determine how the join behaves
///
/// ## Return
///
/// Returns the status of the process
pub unsafe fn proc_join(pid: *mut OptionPid, flags: JoinFlags) -> Result<JoinStatus, Errno> {
    let mut rp0 = MaybeUninit::<JoinStatus>::uninit();
    let ret = wasix_64v1::proc_join(pid as i64, flags as i32, rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const JoinStatus)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Sends a signal to another process
///
/// ## Parameters
///
/// * `pid` - ID of the process to send a singal
/// * `signal` - Signal to send to the thread
pub unsafe fn proc_signal(pid: Pid, signal: Signal) -> Result<(), Errno> {
    let ret = wasix_64v1::proc_signal(pid as i32, signal.0 as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Connects to a websocket at a particular network URL
///
/// ## Parameters
///
/// * `url` - URL of the web socket destination to connect to
///
/// ## Return
///
/// Returns a socket handle which is used to send and receive data
pub unsafe fn ws_connect(url: &str) -> Result<Fd, Errno> {
    let mut rp0 = MaybeUninit::<Fd>::uninit();
    let ret = wasix_64v1::ws_connect(
        url.as_ptr() as i64,
        url.len() as i64,
        rp0.as_mut_ptr() as i64,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Fd)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Makes a HTTP request to a remote web resource and
/// returns a socket handles that are used to send and receive data
///
/// ## Parameters
///
/// * `url` - URL of the HTTP resource to connect to
/// * `method` - HTTP method to be invoked
/// * `headers` - HTTP headers to attach to the request
///   (headers seperated by lines)
/// * `gzip` - Should the request body be compressed
///
/// ## Return
///
/// The body of the response can be streamed from the returned
/// file handle
pub unsafe fn http_request(
    url: &str,
    method: &str,
    headers: &str,
    gzip: Bool,
) -> Result<HttpHandles, Errno> {
    let mut rp0 = MaybeUninit::<HttpHandles>::uninit();
    let ret = wasix_64v1::http_request(
        url.as_ptr() as i64,
        url.len() as i64,
        method.as_ptr() as i64,
        method.len() as i64,
        headers.as_ptr() as i64,
        headers.len() as i64,
        gzip.0 as i32,
        rp0.as_mut_ptr() as i64,
    );
    match ret {
        0 => Ok(core::ptr::read(
            rp0.as_mut_ptr() as i64 as *const HttpHandles
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Retrieves the status of a HTTP request
///
/// ## Parameters
///
/// * `fd` - Handle of the HTTP request
/// * `status` - Pointer to a buffer that will be filled with the current
///   status of this HTTP request
pub unsafe fn http_status(fd: Fd, status: *mut HttpStatus) -> Result<(), Errno> {
    let ret = wasix_64v1::http_status(fd as i32, status as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Securely connects to a particular remote network
///
/// ## Parameters
///
/// * `network` - Fully qualified identifier for the network
/// * `token` - Access token used to authenticate with the network
/// * `security` - Level of encryption to encapsulate the network connection with
pub unsafe fn port_bridge(
    network: &str,
    token: &str,
    security: StreamSecurity,
) -> Result<(), Errno> {
    let ret = wasix_64v1::port_bridge(
        network.as_ptr() as i64,
        network.len() as i64,
        token.as_ptr() as i64,
        token.len() as i64,
        security as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Disconnects from a remote network
pub unsafe fn port_unbridge() -> Result<(), Errno> {
    let ret = wasix_64v1::port_unbridge();
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Acquires a set of addresses using DHCP
pub unsafe fn port_dhcp_acquire() -> Result<(), Errno> {
    let ret = wasix_64v1::port_dhcp_acquire();
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Adds another static address to the local port
///
/// ## Parameters
///
/// * `addr` - Address to be added
pub unsafe fn port_addr_add(addr: *const AddrCidr) -> Result<(), Errno> {
    let ret = wasix_64v1::port_addr_add(addr as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Removes an address from the local port
///
/// ## Parameters
///
/// * `addr` - Address to be removed
pub unsafe fn port_addr_remove(addr: *const Addr) -> Result<(), Errno> {
    let ret = wasix_64v1::port_addr_remove(addr as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Clears all the addresses on the local port
pub unsafe fn port_addr_clear() -> Result<(), Errno> {
    let ret = wasix_64v1::port_addr_clear();
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the MAC address of the local port
pub unsafe fn port_mac() -> Result<HardwareAddress, Errno> {
    let mut rp0 = MaybeUninit::<HardwareAddress>::uninit();
    let ret = wasix_64v1::port_mac(rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(
            rp0.as_mut_ptr() as i64 as *const HardwareAddress
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns a list of all the addresses owned by the local port
///
/// This function fills the output buffer as much as possible.
/// If the buffer is not big enough then the naddrs address will be
/// filled with the buffer size needed and the EOVERFLOW will be returned
///
/// ## Parameters
///
/// * `addrs` - The buffer where addresses will be stored
///
/// ## Return
///
/// The number of addresses returned.
pub unsafe fn port_addr_list(addrs: *mut AddrCidr, naddrs: *mut Size) -> Result<(), Errno> {
    let ret = wasix_64v1::port_addr_list(addrs as i64, naddrs as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Adds a default gateway to the local port
///
/// ## Parameters
///
/// * `addr` - Address of the default gateway
pub unsafe fn port_gateway_set(addr: *const Addr) -> Result<(), Errno> {
    let ret = wasix_64v1::port_gateway_set(addr as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Adds a new route to the local port
pub unsafe fn port_route_add(
    cidr: *const AddrCidr,
    via_router: *const Addr,
    preferred_until: *const OptionTimestamp,
    expires_at: *const OptionTimestamp,
) -> Result<(), Errno> {
    let ret = wasix_64v1::port_route_add(
        cidr as i64,
        via_router as i64,
        preferred_until as i64,
        expires_at as i64,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Removes an existing route from the local port
pub unsafe fn port_route_remove(cidr: *const Addr) -> Result<(), Errno> {
    let ret = wasix_64v1::port_route_remove(cidr as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Clears all the routes in the local port
pub unsafe fn port_route_clear() -> Result<(), Errno> {
    let ret = wasix_64v1::port_route_clear();
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns a list of all the routes owned by the local port
/// This function fills the output buffer as much as possible.
/// If the buffer is too small this will return EOVERFLOW and
/// fill nroutes with the size of the buffer needed.
///
/// ## Parameters
///
/// * `routes` - The buffer where routes will be stored
pub unsafe fn port_route_list(routes: *mut Route, nroutes: *mut Size) -> Result<(), Errno> {
    let ret = wasix_64v1::port_route_list(routes as i64, nroutes as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the current status of a socket
pub unsafe fn sock_status(fd: Fd) -> Result<SockStatus, Errno> {
    let mut rp0 = MaybeUninit::<SockStatus>::uninit();
    let ret = wasix_64v1::sock_status(fd as i32, rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const SockStatus)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the local address to which the socket is bound.
///
/// Note: This is similar to `getsockname` in POSIX
///
/// When successful, the contents of the output buffer consist of an IP address,
/// either IP4 or IP6.
///
/// ## Parameters
///
/// * `fd` - Socket that the address is bound to
pub unsafe fn sock_addr_local(fd: Fd) -> Result<AddrPort, Errno> {
    let mut rp0 = MaybeUninit::<AddrPort>::uninit();
    let ret = wasix_64v1::sock_addr_local(fd as i32, rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const AddrPort)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the remote address to which the socket is connected to.
///
/// Note: This is similar to `getpeername` in POSIX
///
/// When successful, the contents of the output buffer consist of an IP address,
/// either IP4 or IP6.
///
/// ## Parameters
///
/// * `fd` - Socket that the address is bound to
pub unsafe fn sock_addr_peer(fd: Fd) -> Result<AddrPort, Errno> {
    let mut rp0 = MaybeUninit::<AddrPort>::uninit();
    let ret = wasix_64v1::sock_addr_peer(fd as i32, rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const AddrPort)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Create an endpoint for communication.
///
/// creates an endpoint for communication and returns a file descriptor
/// tor that refers to that endpoint. The file descriptor returned by a successful
/// call will be the lowest-numbered file descriptor not currently open
/// for the process.
///
/// Note: This is similar to `socket` in POSIX using PF_INET
///
/// ## Parameters
///
/// * `af` - Address family
/// * `socktype` - Socket type, either datagram or stream
/// * `sock_proto` - Socket protocol
///
/// ## Return
///
/// The file descriptor of the socket that has been opened.
pub unsafe fn sock_open(
    af: AddressFamily,
    socktype: SockType,
    sock_proto: SockProto,
) -> Result<Fd, Errno> {
    let mut rp0 = MaybeUninit::<Fd>::uninit();
    let ret = wasix_64v1::sock_open(
        af.0 as i32,
        socktype.0 as i32,
        sock_proto.0 as i32,
        rp0.as_mut_ptr() as i64,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Fd)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Sets a particular socket setting
/// Note: This is similar to `setsockopt` in POSIX for SO_REUSEADDR
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `sockopt` - Socket option to be set
/// * `flag` - Value to set the option to
pub unsafe fn sock_set_opt_flag(fd: Fd, sockopt: SockOption, flag: Bool) -> Result<(), Errno> {
    let ret = wasix_64v1::sock_set_opt_flag(fd as i32, sockopt.0 as i32, flag.0 as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Retrieve status of particular socket seting
/// Note: This is similar to `getsockopt` in POSIX for SO_REUSEADDR
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `sockopt` - Socket option to be retrieved
pub unsafe fn sock_get_opt_flag(fd: Fd, sockopt: SockOption) -> Result<Bool, Errno> {
    let mut rp0 = MaybeUninit::<Bool>::uninit();
    let ret = wasix_64v1::sock_get_opt_flag(fd as i32, sockopt.0 as i32, rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Bool)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Sets one of the times the socket
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `sockopt` - Socket option to be set
/// * `timeout` - Value to set the time to
pub unsafe fn sock_set_opt_time(
    fd: Fd,
    sockopt: SockOption,
    timeout: *const OptionTimestamp,
) -> Result<(), Errno> {
    let ret = wasix_64v1::sock_set_opt_time(fd as i32, sockopt.0 as i32, timeout as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Retrieve one of the times on the socket
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `sockopt` - Socket option to be retrieved
pub unsafe fn sock_get_opt_time(fd: Fd, sockopt: SockOption) -> Result<OptionTimestamp, Errno> {
    let mut rp0 = MaybeUninit::<OptionTimestamp>::uninit();
    let ret = wasix_64v1::sock_get_opt_time(fd as i32, sockopt.0 as i32, rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(
            rp0.as_mut_ptr() as i64 as *const OptionTimestamp
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Set size of particular option for this socket
/// Note: This is similar to `setsockopt` in POSIX for SO_RCVBUF
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `sockopt` - Socket option to be set
/// * `size` - Buffer size
pub unsafe fn sock_set_opt_size(fd: Fd, sockopt: SockOption, size: Filesize) -> Result<(), Errno> {
    let ret = wasix_64v1::sock_set_opt_size(fd as i32, sockopt.0 as i32, size as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Retrieve the size of particular option for this socket
/// Note: This is similar to `getsockopt` in POSIX for SO_RCVBUF
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `sockopt` - Socket option to be retrieved
pub unsafe fn sock_get_opt_size(fd: Fd, sockopt: SockOption) -> Result<Filesize, Errno> {
    let mut rp0 = MaybeUninit::<Filesize>::uninit();
    let ret = wasix_64v1::sock_get_opt_size(fd as i32, sockopt.0 as i32, rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Filesize)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Joins a particular multicast IPv4 group
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `multiaddr` - Multicast group to joined
/// * `interface` - Interface that will join
pub unsafe fn sock_join_multicast_v4(
    fd: Fd,
    multiaddr: *const AddrIp4,
    interface: *const AddrIp4,
) -> Result<(), Errno> {
    let ret = wasix_64v1::sock_join_multicast_v4(fd as i32, multiaddr as i64, interface as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Leaves a particular multicast IPv4 group
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `multiaddr` - Multicast group to leave
/// * `interface` - Interface that will left
pub unsafe fn sock_leave_multicast_v4(
    fd: Fd,
    multiaddr: *const AddrIp4,
    interface: *const AddrIp4,
) -> Result<(), Errno> {
    let ret = wasix_64v1::sock_leave_multicast_v4(fd as i32, multiaddr as i64, interface as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Joins a particular multicast IPv6 group
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `multiaddr` - Multicast group to joined
/// * `interface` - Interface that will join
pub unsafe fn sock_join_multicast_v6(
    fd: Fd,
    multiaddr: *const AddrIp6,
    interface: u32,
) -> Result<(), Errno> {
    let ret = wasix_64v1::sock_join_multicast_v6(fd as i32, multiaddr as i64, interface as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Leaves a particular multicast IPv6 group
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `multiaddr` - Multicast group to leave
/// * `interface` - Interface that will left
pub unsafe fn sock_leave_multicast_v6(
    fd: Fd,
    multiaddr: *const AddrIp6,
    interface: u32,
) -> Result<(), Errno> {
    let ret = wasix_64v1::sock_leave_multicast_v6(fd as i32, multiaddr as i64, interface as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Bind a socket
/// Note: This is similar to `bind` in POSIX using PF_INET
///
/// ## Parameters
///
/// * `fd` - File descriptor of the socket to be bind
/// * `addr` - Address to bind the socket to
pub unsafe fn sock_bind(fd: Fd, addr: *const AddrPort) -> Result<(), Errno> {
    let ret = wasix_64v1::sock_bind(fd as i32, addr as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Listen for connections on a socket
///
/// Polling the socket handle will wait until a connection
/// attempt is made
///
/// Note: This is similar to `listen`
///
/// ## Parameters
///
/// * `fd` - File descriptor of the socket to be bind
/// * `backlog` - Maximum size of the queue for pending connections
pub unsafe fn sock_listen(fd: Fd, backlog: Size) -> Result<(), Errno> {
    let ret = wasix_64v1::sock_listen(fd as i32, backlog as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Accept a new incoming connection.
/// Note: This is similar to `accept` in POSIX.
///
/// ## Parameters
///
/// * `fd` - The listening socket.
/// * `flags` - The desired values of the file descriptor flags.
///
/// ## Return
///
/// New socket connection
pub unsafe fn sock_accept_v2(fd: Fd, flags: Fdflags) -> Result<(Fd, AddrPort), Errno> {
    let mut rp0 = MaybeUninit::<Fd>::uninit();
    let mut rp1 = MaybeUninit::<AddrPort>::uninit();
    let ret = wasix_64v1::sock_accept_v2(
        fd as i32,
        flags as i32,
        rp0.as_mut_ptr() as i64,
        rp1.as_mut_ptr() as i64,
    );
    match ret {
        0 => Ok((
            core::ptr::read(rp0.as_mut_ptr() as i64 as *const Fd),
            core::ptr::read(rp1.as_mut_ptr() as i64 as *const AddrPort),
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Initiate a connection on a socket to the specified address
///
/// Polling the socket handle will wait for data to arrive or for
/// the socket status to change which can be queried via 'sock_status'
///
/// Note: This is similar to `connect` in POSIX
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `addr` - Address of the socket to connect to
pub unsafe fn sock_connect(fd: Fd, addr: *const AddrPort) -> Result<(), Errno> {
    let ret = wasix_64v1::sock_connect(fd as i32, addr as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Receive a message and its peer address from a socket.
/// Note: This is similar to `recvfrom` in POSIX, though it also supports reading
/// the data into multiple buffers in the manner of `readv`.
///
/// ## Parameters
///
/// * `ri_data` - List of scatter/gather vectors to which to store data.
/// * `ri_flags` - Message flags.
///
/// ## Return
///
/// Number of bytes stored in ri_data and message flags.
pub unsafe fn sock_recv_from(
    fd: Fd,
    ri_data: IovecArray<'_>,
    ri_flags: Riflags,
) -> Result<(Size, Roflags, AddrPort), Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let mut rp1 = MaybeUninit::<Roflags>::uninit();
    let mut rp2 = MaybeUninit::<AddrPort>::uninit();
    let ret = wasix_64v1::sock_recv_from(
        fd as i32,
        ri_data.as_ptr() as i64,
        ri_data.len() as i64,
        ri_flags as i32,
        rp0.as_mut_ptr() as i64,
        rp1.as_mut_ptr() as i64,
        rp2.as_mut_ptr() as i64,
    );
    match ret {
        0 => Ok((
            core::ptr::read(rp0.as_mut_ptr() as i64 as *const Size),
            core::ptr::read(rp1.as_mut_ptr() as i64 as *const Roflags),
            core::ptr::read(rp2.as_mut_ptr() as i64 as *const AddrPort),
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Send a message on a socket to a specific address.
/// Note: This is similar to `sendto` in POSIX, though it also supports writing
/// the data from multiple buffers in the manner of `writev`.
///
/// ## Parameters
///
/// * `si_data` - List of scatter/gather vectors to which to retrieve data
/// * `si_flags` - Message flags.
/// * `addr` - Address of the socket to send message to
///
/// ## Return
///
/// Number of bytes transmitted.
pub unsafe fn sock_send_to(
    fd: Fd,
    si_data: CiovecArray<'_>,
    si_flags: Siflags,
    addr: *const AddrPort,
) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_64v1::sock_send_to(
        fd as i32,
        si_data.as_ptr() as i64,
        si_data.len() as i64,
        si_flags as i32,
        addr as i64,
        rp0.as_mut_ptr() as i64,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Sends the entire contents of a file down a socket
///
/// ## Parameters
///
/// * `in_fd` - Open file that has the data to be transmitted
/// * `offset` - Offset into the file to start reading at
/// * `count` - Number of bytes to be sent
///
/// ## Return
///
/// Number of bytes transmitted.
pub unsafe fn sock_send_file(
    out_fd: Fd,
    in_fd: Fd,
    offset: Filesize,
    count: Filesize,
) -> Result<Filesize, Errno> {
    let mut rp0 = MaybeUninit::<Filesize>::uninit();
    let ret = wasix_64v1::sock_send_file(
        out_fd as i32,
        in_fd as i32,
        offset as i64,
        count as i64,
        rp0.as_mut_ptr() as i64,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Filesize)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Resolves a hostname and a port to one or more IP addresses.
///
/// Note: This is similar to `getaddrinfo` in POSIX
///
/// When successful, the contents of the output buffer consist of a sequence of
/// IPv4 and/or IPv6 addresses. Each address entry consists of a addr_t object.
/// This function fills the output buffer as much as possible.
///
/// ## Parameters
///
/// * `host` - Host to resolve
/// * `port` - Port hint (zero if no hint is supplied)
/// * `addrs` - The buffer where addresses will be stored
///
/// ## Return
///
/// The number of IP addresses returned during the DNS resolution.
pub unsafe fn resolve(
    host: &str,
    port: u16,
    addrs: *mut Addr,
    naddrs: Size,
) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_64v1::resolve(
        host.as_ptr() as i64,
        host.len() as i64,
        port as i32,
        addrs as i64,
        naddrs as i32,
        rp0.as_mut_ptr() as i64,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Create an epoll interest list
///
///
/// ## Return
///
/// The file descriptor for this epoll interest list
pub unsafe fn epoll_create() -> Result<Fd, Errno> {
    let mut rp0 = MaybeUninit::<Fd>::uninit();
    let ret = wasix_64v1::epoll_create(rp0.as_mut_ptr() as i64);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Fd)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Modifies an epoll interest list
///
///
/// ## Parameters
///
/// * `epfd` - File descriptor of the epoll interest list
/// * `op` - Operation to be made on the list
/// * `fd` - File descriptor to be added, deleted or modified
/// * `event` - Reference to the event to be added, deleted or modified
///
/// ## Return
///
/// The number of bytes written.
pub unsafe fn epoll_ctl(
    epfd: Fd,
    op: EpollCtl,
    fd: Fd,
    event: *const EpollEvent,
) -> Result<(), Errno> {
    let ret = wasix_64v1::epoll_ctl(epfd as i32, op.0 as i32, fd as i32, event as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// wait for an I/O event on an epoll file descriptor
///
///
/// ## Parameters
///
/// * `epfd` - File descriptor of the epoll interest list
/// * `event` - Reference to the array of events
/// * `maxevents` - Maximum number of events that will be returned in the array
/// * `timeout` - Timeout for the wait event
///
/// ## Return
///
/// The number of events returned.
pub unsafe fn epoll_wait(
    epfd: Fd,
    event: *mut EpollEvent,
    maxevents: Size,
    timeout: Timestamp,
) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_64v1::epoll_wait(
        epfd as i32,
        event as i64,
        maxevents as i32,
        timeout as i64,
        rp0.as_mut_ptr() as i64,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i64 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

pub mod wasix_64v1 {
    #[link(wasm_import_module = "wasix_64v1")]
    extern "C" {
        /// Sets the time value of a clock.
        /// Note: This is similar to `clock_settime` in POSIX.
        pub fn clock_time_set(arg0: i32, arg1: i64) -> i32;
        /// Atomically duplicate a file handle.
        pub fn fd_dup(arg0: i32, arg1: i64) -> i32;
        /// Creates a file handle for event notifications
        ///
        pub fn fd_event(arg0: i64, arg1: i32, arg2: i64) -> i32;
        /// Opens a pipe with two file handles
        ///
        /// Pipes are bidirectional
        pub fn fd_pipe(arg0: i64, arg1: i64) -> i32;
        /// Retrieves the current state of the TTY
        pub fn tty_get(arg0: i64) -> i32;
        /// Updates the properties of the the TTY
        pub fn tty_set(arg0: i64) -> i32;
        /// Returns the current working directory
        ///
        /// If the path exceeds the size of the buffer then this function
        /// will fill the path_len with the needed size and return EOVERFLOW
        pub fn getcwd(arg0: i64, arg1: i64) -> i32;
        /// Sets the current working directory
        pub fn chdir(arg0: i64, arg1: i64) -> i32;
        /// Registers a callback function for signals
        pub fn callback_signal(arg0: i64, arg1: i64);
        /// Creates a new thread by spawning that shares the same
        /// memory address space, file handles and main event loops.
        /// The web assembly process must export function named 'wasi_thread_start'
        pub fn thread_spawn_v2(arg0: i64, arg1: i64) -> i32;
        /// Sends the current thread to sleep for a period of time
        pub fn thread_sleep(arg0: i64) -> i32;
        /// Returns the index of the current thread
        /// (threads indices are sequential from zero while the
        ///  main thread ID equals the process ID)
        pub fn thread_id(arg0: i64) -> i32;
        /// Joins this thread with another thread, blocking this
        /// one until the other finishes
        pub fn thread_join(arg0: i32) -> i32;
        /// Returns the available parallelism which is normally the
        /// number of available cores that can run concurrently
        pub fn thread_parallelism(arg0: i64) -> i32;
        /// Sends a signal to a specific thread
        pub fn thread_signal(arg0: i32, arg1: i32) -> i32;
        /// Wait for a futex_wake operation to wake us.
        ///
        /// Returns with EINVAL if the futex doesn't hold the expected value.
        /// Returns false on timeout, and true in all other cases.
        pub fn futex_wait(arg0: i64, arg1: i32, arg2: i64, arg3: i64) -> i32;
        /// Wake up one thread that's blocked on futex_wait on this futex.
        ///
        /// Returns true if this actually woke up such a thread,
        /// or false if no thread was waiting on this futex.
        pub fn futex_wake(arg0: i64, arg1: i64) -> i32;
        /// Wake up all threads that are waiting on futex_wait on this futex.
        pub fn futex_wake_all(arg0: i64, arg1: i64) -> i32;
        /// Terminates the current running thread, if this is the last thread then
        /// the process will also exit with the specified exit code. An exit code
        /// of 0 indicates successful termination of the thread. The meanings of
        /// other values is dependent on the environment.
        pub fn thread_exit(arg0: i32) -> !;
        /// Creates a checkpoint of the current stack which allows it to be restored
        /// later using its stack hash. The value supplied will be returned upon
        /// restoration (and hence must be none zero) - zero will be returned when
        /// the stack is first recorded.
        ///
        /// This is used by `longjmp` and `setjmp`
        ///
        /// This function will read the __stack_pointer global
        pub fn stack_checkpoint(arg0: i64, arg1: i64) -> i32;
        /// Restores the current stack to a previous stack described by supplying
        /// stack snapshot.
        ///
        /// This function will manipulate the __stack_pointer global
        pub fn stack_restore(arg0: i64, arg1: i64) -> !;
        /// Send a signal to the process of the calling thread on a regular basis
        /// Note: This is similar to `setitimer` in POSIX.
        pub fn proc_raise_interval(arg0: i32, arg1: i64, arg2: i32) -> i32;
        /// Forks the current process into a new subprocess. If the function
        /// returns a zero then its the new subprocess. If it returns a positive
        /// number then its the current process and the $pid represents the child.
        pub fn proc_fork(arg0: i32, arg1: i64) -> i32;
        /// execve()  executes  the  program  referred to by pathname.  This causes the
        /// program that is currently being run by the calling process to  be  replaced
        /// with  a  new  program, with newly initialized stack, heap, and (initialized
        /// and uninitialized) data segments
        ///
        /// If the named process does not exist then the process will fail and terminate
        pub fn proc_exec(arg0: i64, arg1: i64, arg2: i64, arg3: i64) -> !;
        /// Spawns a new process within the context of the parent process
        /// (i.e. this process). It inherits the filesystem and sandbox
        /// permissions but runs standalone.
        pub fn proc_spawn(
            arg0: i64,
            arg1: i64,
            arg2: i32,
            arg3: i64,
            arg4: i64,
            arg5: i64,
            arg6: i64,
            arg7: i32,
            arg8: i32,
            arg9: i32,
            arg10: i64,
            arg11: i64,
            arg12: i64,
        ) -> i32;
        /// Returns the handle of the current process
        pub fn proc_id(arg0: i64) -> i32;
        /// Returns the parent handle of a particular process
        pub fn proc_parent(arg0: i32, arg1: i64) -> i32;
        /// Wait for process to exit
        ///
        /// Passing none to PID will mean that the call will wait
        /// for any subprocess to exit. PID will be populated with
        /// the process that exited.
        pub fn proc_join(arg0: i64, arg1: i32, arg2: i64) -> i32;
        /// Sends a signal to another process
        pub fn proc_signal(arg0: i32, arg1: i32) -> i32;
        /// Connects to a websocket at a particular network URL
        pub fn ws_connect(arg0: i64, arg1: i64, arg2: i64) -> i32;
        /// Makes a HTTP request to a remote web resource and
        /// returns a socket handles that are used to send and receive data
        pub fn http_request(
            arg0: i64,
            arg1: i64,
            arg2: i64,
            arg3: i64,
            arg4: i64,
            arg5: i64,
            arg6: i32,
            arg7: i64,
        ) -> i32;
        /// Retrieves the status of a HTTP request
        pub fn http_status(arg0: i32, arg1: i64) -> i32;
        /// Securely connects to a particular remote network
        pub fn port_bridge(arg0: i64, arg1: i64, arg2: i64, arg3: i64, arg4: i32) -> i32;
        /// Disconnects from a remote network
        pub fn port_unbridge() -> i32;
        /// Acquires a set of addresses using DHCP
        pub fn port_dhcp_acquire() -> i32;
        /// Adds another static address to the local port
        pub fn port_addr_add(arg0: i64) -> i32;
        /// Removes an address from the local port
        pub fn port_addr_remove(arg0: i64) -> i32;
        /// Clears all the addresses on the local port
        pub fn port_addr_clear() -> i32;
        /// Returns the MAC address of the local port
        pub fn port_mac(arg0: i64) -> i32;
        /// Returns a list of all the addresses owned by the local port
        ///
        /// This function fills the output buffer as much as possible.
        /// If the buffer is not big enough then the naddrs address will be
        /// filled with the buffer size needed and the EOVERFLOW will be returned
        pub fn port_addr_list(arg0: i64, arg1: i64) -> i32;
        /// Adds a default gateway to the local port
        pub fn port_gateway_set(arg0: i64) -> i32;
        /// Adds a new route to the local port
        pub fn port_route_add(arg0: i64, arg1: i64, arg2: i64, arg3: i64) -> i32;
        /// Removes an existing route from the local port
        pub fn port_route_remove(arg0: i64) -> i32;
        /// Clears all the routes in the local port
        pub fn port_route_clear() -> i32;
        /// Returns a list of all the routes owned by the local port
        /// This function fills the output buffer as much as possible.
        /// If the buffer is too small this will return EOVERFLOW and
        /// fill nroutes with the size of the buffer needed.
        pub fn port_route_list(arg0: i64, arg1: i64) -> i32;
        /// Returns the current status of a socket
        pub fn sock_status(arg0: i32, arg1: i64) -> i32;
        /// Returns the local address to which the socket is bound.
        ///
        /// Note: This is similar to `getsockname` in POSIX
        ///
        /// When successful, the contents of the output buffer consist of an IP address,
        /// either IP4 or IP6.
        pub fn sock_addr_local(arg0: i32, arg1: i64) -> i32;
        /// Returns the remote address to which the socket is connected to.
        ///
        /// Note: This is similar to `getpeername` in POSIX
        ///
        /// When successful, the contents of the output buffer consist of an IP address,
        /// either IP4 or IP6.
        pub fn sock_addr_peer(arg0: i32, arg1: i64) -> i32;
        /// Create an endpoint for communication.
        ///
        /// creates an endpoint for communication and returns a file descriptor
        /// tor that refers to that endpoint. The file descriptor returned by a successful
        /// call will be the lowest-numbered file descriptor not currently open
        /// for the process.
        ///
        /// Note: This is similar to `socket` in POSIX using PF_INET
        pub fn sock_open(arg0: i32, arg1: i32, arg2: i32, arg3: i64) -> i32;
        /// Sets a particular socket setting
        /// Note: This is similar to `setsockopt` in POSIX for SO_REUSEADDR
        pub fn sock_set_opt_flag(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Retrieve status of particular socket seting
        /// Note: This is similar to `getsockopt` in POSIX for SO_REUSEADDR
        pub fn sock_get_opt_flag(arg0: i32, arg1: i32, arg2: i64) -> i32;
        /// Sets one of the times the socket
        pub fn sock_set_opt_time(arg0: i32, arg1: i32, arg2: i64) -> i32;
        /// Retrieve one of the times on the socket
        pub fn sock_get_opt_time(arg0: i32, arg1: i32, arg2: i64) -> i32;
        /// Set size of particular option for this socket
        /// Note: This is similar to `setsockopt` in POSIX for SO_RCVBUF
        pub fn sock_set_opt_size(arg0: i32, arg1: i32, arg2: i64) -> i32;
        /// Retrieve the size of particular option for this socket
        /// Note: This is similar to `getsockopt` in POSIX for SO_RCVBUF
        pub fn sock_get_opt_size(arg0: i32, arg1: i32, arg2: i64) -> i32;
        /// Joins a particular multicast IPv4 group
        pub fn sock_join_multicast_v4(arg0: i32, arg1: i64, arg2: i64) -> i32;
        /// Leaves a particular multicast IPv4 group
        pub fn sock_leave_multicast_v4(arg0: i32, arg1: i64, arg2: i64) -> i32;
        /// Joins a particular multicast IPv6 group
        pub fn sock_join_multicast_v6(arg0: i32, arg1: i64, arg2: i32) -> i32;
        /// Leaves a particular multicast IPv6 group
        pub fn sock_leave_multicast_v6(arg0: i32, arg1: i64, arg2: i32) -> i32;
        /// Bind a socket
        /// Note: This is similar to `bind` in POSIX using PF_INET
        pub fn sock_bind(arg0: i32, arg1: i64) -> i32;
        /// Listen for connections on a socket
        ///
        /// Polling the socket handle will wait until a connection
        /// attempt is made
        ///
        /// Note: This is similar to `listen`
        pub fn sock_listen(arg0: i32, arg1: i32) -> i32;
        /// Accept a new incoming connection.
        /// Note: This is similar to `accept` in POSIX.
        pub fn sock_accept_v2(arg0: i32, arg1: i32, arg2: i64, arg3: i64) -> i32;
        /// Initiate a connection on a socket to the specified address
        ///
        /// Polling the socket handle will wait for data to arrive or for
        /// the socket status to change which can be queried via 'sock_status'
        ///
        /// Note: This is similar to `connect` in POSIX
        pub fn sock_connect(arg0: i32, arg1: i64) -> i32;
        /// Receive a message and its peer address from a socket.
        /// Note: This is similar to `recvfrom` in POSIX, though it also supports reading
        /// the data into multiple buffers in the manner of `readv`.
        pub fn sock_recv_from(
            arg0: i32,
            arg1: i64,
            arg2: i64,
            arg3: i32,
            arg4: i64,
            arg5: i64,
            arg6: i64,
        ) -> i32;
        /// Send a message on a socket to a specific address.
        /// Note: This is similar to `sendto` in POSIX, though it also supports writing
        /// the data from multiple buffers in the manner of `writev`.
        pub fn sock_send_to(
            arg0: i32,
            arg1: i64,
            arg2: i64,
            arg3: i32,
            arg4: i64,
            arg5: i64,
        ) -> i32;
        /// Sends the entire contents of a file down a socket
        pub fn sock_send_file(arg0: i32, arg1: i32, arg2: i64, arg3: i64, arg4: i64) -> i32;
        /// Resolves a hostname and a port to one or more IP addresses.
        ///
        /// Note: This is similar to `getaddrinfo` in POSIX
        ///
        /// When successful, the contents of the output buffer consist of a sequence of
        /// IPv4 and/or IPv6 addresses. Each address entry consists of a addr_t object.
        /// This function fills the output buffer as much as possible.
        pub fn resolve(arg0: i64, arg1: i64, arg2: i32, arg3: i64, arg4: i32, arg5: i64) -> i32;
        /// Create an epoll interest list
        ///
        pub fn epoll_create(arg0: i64) -> i32;
        /// Modifies an epoll interest list
        ///
        pub fn epoll_ctl(arg0: i32, arg1: i32, arg2: i32, arg3: i64) -> i32;
        /// wait for an I/O event on an epoll file descriptor
        ///
        pub fn epoll_wait(arg0: i32, arg1: i64, arg2: i32, arg3: i64, arg4: i64) -> i32;
    }
}
