/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_or extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "ଗ୍ରୀନୱିଚ୍ ମିନ୍ ସମୟ",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "ଆକା ମାନକ ସମୟ",
               "",
               "ଆକା ଗ୍ରୀଷ୍ମ ସମୟ",
               "",
               "ଆକା ସମୟ",
               "",
            };
        final String[] Apia = new String[] {
               "ଆପିଆ ମାନାଙ୍କ ସମୟ",
               "",
               "ଆପିଆ ଦିବାଲୋକ ସମୟ",
               "",
               "ଆପିଆ ସମୟ",
               "",
            };
        final String[] Cook = new String[] {
               "କୁକ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ ମାନକ ସମୟ",
               "",
               "କୁକ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ ଅର୍ଦ୍ଧ ଗୀଷ୍ମକାଳୀନ ସମୟ",
               "",
               "କୁକ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ ସମୟ",
               "",
            };
        final String[] Cuba = new String[] {
               "କ୍ୟୁବା ମାନାଙ୍କ ସମୟ",
               "CST",
               "କ୍ୟୁବା ଦିବାଲୋକ ସମୟ",
               "CDT",
               "କ୍ୟୁବା ସମୟ",
               "CT",
            };
        final String[] Fiji = new String[] {
               "ଫିଜି ମାନକ ସମୟ",
               "",
               "ଫିଜି ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ",
               "",
               "ଫିଜି ସମୟ",
               "",
            };
        final String[] Gulf = new String[] {
               "ଗଲ୍ଫ ମାନାଙ୍କ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "ହୋଭଡ୍‌ ମାନକ ସମୟ",
               "",
               "ହୋଭଡ୍‌ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ହୋଭଡ୍‌ ସମୟ",
               "",
            };
        final String[] Iran = new String[] {
               "ଇରାନ ମାନକ ସମୟ",
               "",
               "ଇରାନ ଦିବାଲୋକ ସମୟ",
               "",
               "ଇରାନ ସମୟ",
               "",
            };
        final String[] Niue = new String[] {
               "ନିୟୁ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ଓମସ୍କ ମାନାଙ୍କ ସମୟ",
               "",
               "ଓମସ୍କ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ଓମସ୍କ ସମୟ",
               "",
            };
        final String[] Peru = new String[] {
               "ପେରୁ ମାନାଙ୍କ ସମୟ",
               "",
               "ପେରୁ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ପେରୁ ସମୟ",
               "",
            };
        final String[] Truk = new String[] {
               "ଚୂକ୍‌ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ୱେକ୍‌ ଦ୍ୱୀପ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "ଚିଲି ମାନାଙ୍କ ସମୟ",
               "",
               "ଚିଲି ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ଚିଲି ସମୟ",
               "",
            };
        final String[] China = new String[] {
               "ଚୀନ ମାନକ ସମୟ",
               "CST",
               "ଚୀନ ଦିବାଲୋକ ସମୟ",
               "CDT",
               "ଚୀନ ସମୟ",
               "CT",
            };
        final String[] Cocos = new String[] {
               "କୋକୋସ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "ଡେଭିସ୍‌ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ଭାରତୀୟ ମାନକ ସମୟ",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "ଜାପାନ ମାନକ ସମୟ",
               "JST",
               "ଜାପାନ ଦିବାଲୋକ ସମୟ",
               "JDT",
               "ଜାପାନ ସମୟ",
               "JT",
            };
        final String[] Korea = new String[] {
               "କୋରିୟ ମାନକ ସମୟ",
               "KST",
               "କୋରିୟ ଦିବାଲୋକ ସମୟ",
               "KST",
               "କୋରିୟ ସମୟ",
               "KST",
            };
        final String[] Nauru = new String[] {
               "ନାଉରୁ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "ନେପାଳ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "ପାଲାଉ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "ସାମୋଆ ମାନକ ସମୟ",
               "SST",
               "ସାମୋଆ ଦିବାଲୋକ ସମୟ",
               "SST",
               "ସାମୋଆ ସମୟ",
               "SST",
            };
        final String[] Syowa = new String[] {
               "ସୋୱା ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ଟୋଙ୍ଗା ମାନକ ସମୟ",
               "",
               "ଟୋଙ୍ଗା ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ",
               "",
               "ଟୋଙ୍ଗା ସମୟ",
               "",
            };
        final String[] Yukon = new String[] {
               "ୟୁକୋନ୍ ସମୟ",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "ଆଲାସ୍କା ମାନାଙ୍କ ସମୟ",
               "AKST",
               "ଆଲାସ୍କା ଦିବାଲୋକ ସମୟ",
               "AKDT",
               "ଆଲାସ୍କା ସମୟ",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "ଆମାଜନ୍ ମାନାଙ୍କ ସମୟ",
               "",
               "ଆମାଜନ୍ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ",
               "",
               "ଆମାଜନ୍ ସମୟ",
               "",
            };
        final String[] Azores = new String[] {
               "ଆଜୋରେସ୍ ମାନକ ସମୟ",
               "",
               "ଆଜୋରେସ୍ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ଆଜୋରେସ୍ ସମୟ",
               "",
            };
        final String[] Bhutan = new String[] {
               "ଭୁଟାନ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "ବ୍ରୁନେଇ ଡାରୁସାଲାମ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ଇଷ୍ଟର୍‌ ଆଇଲ୍ୟାଣ୍ଡ ମାନାଙ୍କ ସମୟ",
               "",
               "ଇଷ୍ଟର୍‌ ଆଇଲ୍ୟାଣ୍ଡ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ଇଷ୍ଟର୍‌ ଆଇଲ୍ୟାଣ୍ଡ ସମୟ",
               "",
            };
        final String[] Guyana = new String[] {
               "ଗୁଏନା ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "ହୱାଇ-ଆଲେଉଟିୟ ମାନାଙ୍କ ସମୟ",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "ଇସ୍ରାଏଲ ମାନାଙ୍କ ସମୟ",
               "IST",
               "ଇସ୍ରାଏଲ ଦିବାଲୋକ ସମୟ",
               "IDT",
               "ଇସ୍ରାଏଲ ସମୟ",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "କୋସରେଇ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "ମାୱସନ୍‌ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "ମସ୍କୋ ମାନାଙ୍କ ସମୟ",
               "MSK",
               "ମସ୍କୋ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "MSK",
               "ମସ୍କୋ ସମୟ",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "ପୋନାପେ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "ସମାରା ମାନକ ସମୟ",
               "",
               "ସମାରା ଗ୍ରୀଷ୍ମ ସମୟ",
               "",
               "ସମାରା ସମୟ",
               "",
            };
        final String[] Tahiti = new String[] {
               "ତାହିତି ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "ତାଇପେଇ ମାନକ ସମୟ",
               "CST",
               "ତାଇପେଇ ଦିବାଲୋକ ସମୟ",
               "CDT",
               "ତାଇପେଇ ସମୟ",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "ତୁଭାଲୁ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "ଭୋଷ୍ଟୋକ୍‌ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "ୱାଲିସ୍‌ ଏବଂ ଫୁଟୁନା ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "ଆରବୀୟ ମାନାଙ୍କ ସମୟ",
               "",
               "ଆରବୀୟ ଦିବାଲୋକ ସମୟ",
               "",
               "ଆରବୀୟ ସମୟ",
               "",
            };
        final String[] Armenia = new String[] {
               "ଆର୍ମେନିଆ ମାନାଙ୍କ ସମୟ",
               "",
               "ଆର୍ମେନିଆ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ଆର୍ମେନିଆ ସମୟ",
               "",
            };
        final String[] Bolivia = new String[] {
               "ବଲିଭିଆ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "ଚାଥାମ୍‌ ମାନାଙ୍କ ସମୟ",
               "",
               "ଚାଥାମ୍‌ ଦିବାଲୋକ ସମୟ",
               "",
               "ଚାଥାମ୍‌ ସମୟ",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "ସମନ୍ୱିତ ସାର୍ବଜନୀନ ସମୟ",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ଇକ୍ୱେଡର ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "ଗାମ୍ବିୟର୍ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "ଜର୍ଜିଆ ମାନାଙ୍କ ସମୟ",
               "",
               "ଜର୍ଜିଆ ଖରାଦିନ ସମୟ",
               "",
               "ଜର୍ଜିଆ ସମୟ",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ଇର୍କୁଟସ୍କ୍ ମାନକ ସମୟ",
               "",
               "ଇର୍କୁଟସ୍କ୍ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ",
               "",
               "ଇଅରକୁଟସ୍କ ସମୟ",
               "",
            };
        final String[] Magadan = new String[] {
               "ମାଗାଡାନ୍ ମାନାଙ୍କ ସମୟ",
               "",
               "ମାଗାଡାନ୍ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ମାଗାଡାନ୍ ସମୟ",
               "",
            };
        final String[] Myanmar = new String[] {
               "ମିଆଁମାର୍‌ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "ନରଫୋକ୍‌ ଦ୍ୱୀପ ମାନାଙ୍କ ସମୟ",
               "",
               "ନରଫୋକ୍‌ ଦ୍ୱୀପ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ନରଫୋକ୍‌ ଦ୍ୱୀପ ସମୟ",
               "",
            };
        final String[] Noronha = new String[] {
               "ଫର୍ଣ୍ଣାଣ୍ଡୋ ଡି ନୋରୋନ୍ନା ମାନାଙ୍କ ସମୟ",
               "",
               "ଫର୍ଣ୍ଣାଣ୍ଡୋ ଡି ନୋରୋନ୍ନା ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ଫର୍ଣ୍ଣାଣ୍ଡୋ ଡି ନୋରୋନ୍ନା ସମୟ",
               "",
            };
        final String[] Reunion = new String[] {
               "ରିୟୁନିଅନ୍‌ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "ରୋଥେରା ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "ସୋଲୋମନ ଦ୍ୱୀପପୁଞ୍ଜ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "ଟୋକେଲାଉ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "ଉରୁଗୁଏ ମାନାଙ୍କ ସମୟ",
               "",
               "ଉରୁଗୁଏ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ଉରୁଗୁଏ ସମୟ",
               "",
            };
        final String[] Vanuatu = new String[] {
               "ଭାନୁଆଟୁ ମାନକ ସମୟ",
               "",
               "ଭାନୁଆଟୁ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ",
               "",
               "ଭାନୁଆଟୁ ସମୟ",
               "",
            };
        final String[] Yakutsk = new String[] {
               "ୟାକୁଟସ୍କ ମାନାଙ୍କ ସମୟ",
               "",
               "ୟାକୁଟସ୍କ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ୟାକୁଟସ୍କ ସମୟ",
               "",
            };
        final String[] Atlantic = new String[] {
               "ଆଟଲାଣ୍ଟିକ୍ ମାନାଙ୍କ ସମୟ",
               "AST",
               "ଆଟଲାଣ୍ଟିକ୍ ଦିବାଲୋକ ସମୟ",
               "AST",
               "ଆଟଲାଣ୍ଟିକ୍ ସମୟ",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ବ୍ରାସିଲିଆ ମାନାଙ୍କ ସମୟ",
               "",
               "ବ୍ରାସିଲିଆ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ବ୍ରାସିଲିଆ ସମୟ",
               "",
            };
        final String[] Chamorro = new String[] {
               "ଚାମୋରୋ ମାନକ ସମୟ",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "କଲମ୍ବିଆ ମାନକ ସମୟ",
               "",
               "କଲମ୍ବିଆ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "କଲମ୍ବିଆ ସମୟ",
               "",
            };
        final String[] Falkland = new String[] {
               "ଫକଲ୍ୟାଣ୍ଡ ଦ୍ୱୀପପୁଞ୍ଜ ମାନକ ସମୟ",
               "",
               "ଫକଲ୍ୟାଣ୍ଡ ଦ୍ୱୀପପୁଞ୍ଜ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ଫକଲ୍ୟାଣ୍ଡ ଦ୍ୱୀପପୁଞ୍ଜ ସମୟ",
               "",
            };
        final String[] Malaysia = new String[] {
               "ମାଲେସିଆ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "ମାଳଦ୍ୱୀପ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ଉଲାନ୍‌ବାଟର୍‌ ମାନକ ସମୟ",
               "",
               "ଉଲାନ୍‌ବାଟର୍‌ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ",
               "",
               "ଉଲାନ୍‌ବାଟର୍‌ ସମୟ",
               "",
            };
        final String[] Pakistan = new String[] {
               "ପାକିସ୍ତାନ ମାନକ ସମୟ",
               "PKT",
               "ପାକିସ୍ତାନ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "PKST",
               "ପାକିସ୍ତାନ ସମୟ",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "ପାରାଗୁଏ ମାନାଙ୍କ ସମୟ",
               "",
               "ପାରାଗୁଏ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ପାରାଗୁଏ ସମୟ",
               "",
            };
        final String[] Pitcairn = new String[] {
               "ପିଟକେର୍ନ୍‌ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "ସୁରିନେମ୍‌ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "ଆର୍ଜେଣ୍ଟିନା ମାନାଙ୍କ ସମୟ",
               "",
               "ଆର୍ଜେଣ୍ଟିନା ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ଆର୍ଜେଣ୍ଟିନା ସମୟ",
               "",
            };
        final String[] Christmas = new String[] {
               "ଖ୍ରୀଷ୍ଟମାସ ଦ୍ୱୀପ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "ଗାଲାପାଗୋସ୍ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "ହଂ କଂ ମାନକ ସମୟ",
               "HKT",
               "ହଂ କଂ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "HKST",
               "ହଂ କଂ ସମୟ",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "ଇଣ୍ଡୋଚାଇନା ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "ପେଟ୍ରୋପାଭଲୋଭ୍ସକ-କମଚଟସ୍କି ମାନକ ସମୟ",
               "",
               "ପେଟ୍ରୋପାଭଲୋଭ୍ସକ-କମଚଟସ୍କି ଗ୍ରୀଷ୍ମ ସମୟ",
               "",
               "ପେଟ୍ରୋପାଭଲୋଭ୍ସକ-କମଚଟସ୍କି ସମୟ",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "କିର୍ଗିସ୍ତାନ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "ଲର୍ଡ ହୋୱେ ମାନାଙ୍କ ସମୟ",
               "",
               "ଲର୍ଡ ହୋୱେ ଦିବାଲୋକ ସମୟ",
               "",
               "ଲର୍ଡ ହୋୱେ ସମୟ",
               "",
            };
        final String[] Marquesas = new String[] {
               "ମାର୍କ୍ୱେସାସ୍‌ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "ମୌରିସସ୍‌ ମାନାଙ୍କ ସମୟ",
               "",
               "ମୌରିସସ୍‌ ଖରାଦିନ ସମୟ",
               "",
               "ମୌରିସସ୍‌ ସମୟ",
               "",
            };
        final String[] Singapore = new String[] {
               "ସିଙ୍ଗାପୁର୍‌ ମାନକ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "ଭେନିଜୁଏଲା ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "ଆଜେରବାଇଜାନ ମାନଙ୍କ ସମୟ",
               "",
               "ଆଜେରବାଇଜାନ ଖରାଦିନ ସମୟ",
               "",
               "ଆଜେରବାଇଜାନ ସମୟ",
               "",
            };
        final String[] Bangladesh = new String[] {
               "ବାଂଲାଦେଶ ମାନାଙ୍କ ସମୟ",
               "",
               "ବାଂଲାଦେଶ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ",
               "",
               "ବାଂଲାଦେଶ ସମୟ",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "କେପ୍‌ ଭର୍ଦେ ମାନାଙ୍କ ସମୟ",
               "",
               "କେପ୍‌ ଭର୍ଦେ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ",
               "",
               "କେପ୍‌ ଭର୍ଦେ ସମୟ",
               "",
            };
        final String[] East_Timor = new String[] {
               "ପୂର୍ବ ତିମୋର୍‌ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "କାଜାକସ୍ତାନ୍ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "ସେଚେଲ୍ଲେସ୍‌ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "ତାଜିକିସ୍ତାନ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "ଉଜବେକିସ୍ତାନ ମାନକ ସମୟ",
               "",
               "ଉଜବେକିସ୍ତାନ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ",
               "",
               "ଉଜବେକିସ୍ତାନ ସମୟ",
               "",
            };
        final String[] Afghanistan = new String[] {
               "ଆଫଗାନିସ୍ତାନ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "କ୍ରାସନୋୟାରସ୍କ ମାନାଙ୍କ ସମୟ",
               "",
               "କ୍ରାସନୋୟାରସ୍କ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "କ୍ରାସନୋୟାରସ୍କ ସମୟ",
               "",
            };
        final String[] New_Zealand = new String[] {
               "ନ୍ୟୁଜିଲାଣ୍ଡ ମାନାଙ୍କ ସମୟ",
               "NZST",
               "ନ୍ୟୁଜିଲାଣ୍ଡ ଦିବାଲୋକ ସମୟ",
               "NZDT",
               "ନ୍ୟୁଜିଲାଣ୍ଡ ସମୟ",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "ଫିଲିପାଇନ୍‌ ମାନାଙ୍କ ସମୟ",
               "PST",
               "ଫିଲିପାଇନ୍‌ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "PDT",
               "ଫିଲିପାଇନ୍‌ ସମୟ",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ଭ୍ଲାଡିଭୋଷ୍ଟୋକ୍ ମାନାଙ୍କ ସମୟ",
               "",
               "ଭ୍ଲାଡିଭୋଷ୍ଟୋକ୍ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ଭ୍ଲାଡିଭୋଷ୍ଟୋକ୍ ସମୟ",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "ଭାରତ ମାହାସାଗର ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "ଲାଇନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "ନ୍ୟୁଫାଉଣ୍ଡଲ୍ୟାଣ୍ଡ୍ ମାନାଙ୍କ ସମୟ",
               "NST",
               "ନ୍ୟୁଫାଉଣ୍ଡଲ୍ୟାଣ୍ଡ୍ ଦିବାଲୋକ ସମୟ",
               "NDT",
               "ନ୍ୟୁଫାଉଣ୍ଡଲ୍ୟାଣ୍ଡ୍ ସମୟ",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "ତୁର୍କମେନିସ୍ତାନ ମାନାଙ୍କ ସମୟ",
               "",
               "ତୁର୍କମେନିସ୍ତାନ ଖରାଦିନ ସମୟ",
               "",
               "ତୁର୍କମେନିସ୍ତାନ ସମୟ",
               "",
            };
        final String[] French_Guiana = new String[] {
               "ଫ୍ରେଞ୍ଚ ଗୁଆନା ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "ନ୍ୟୁ କାଲେଡୋନିଆ ମାନାଙ୍କ ସମୟ",
               "",
               "ନ୍ୟୁ କାଲେଡୋନିଆ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ନ୍ୟୁ କାଲେଡୋନିଆ ସମୟ",
               "",
            };
        final String[] South_Georgia = new String[] {
               "ଦକ୍ଷିଣ ଜର୍ଜିଆ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "ୟେକାଟେରିନବର୍ଗ୍ ମାନାଙ୍କ ସମୟ",
               "",
               "ୟେକାଟେରିନବର୍ଗ୍ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "",
               "ୟେକାଟେରିନବର୍ଗ୍ ସମୟ",
               "",
            };
        final String[] Africa_Central = new String[] {
               "ମଧ୍ୟ ଆଫ୍ରିକା ସମୟ",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "ପୂର୍ବ ଆଫ୍ରିକା ସମୟ",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "ପଶ୍ଚିମ ଆଫ୍ରିକା ସମୟ",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ଡୁମୋଣ୍ଟ-ଡି‘ଉରଭିଲ୍ଲେ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "କେନ୍ଦ୍ର ୟୁରୋପୀୟ ମାନକ ସମୟ",
               "CET",
               "କେନ୍ଦ୍ରୀୟ ୟୁରୋପୀୟ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "CEST",
               "କେନ୍ଦ୍ରୀୟ ୟୁରୋପୀୟ ସମୟ",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "ପୂର୍ବାଞ୍ଚଳ ୟୁରୋପୀୟ ମାନାଙ୍କ ସମୟ",
               "EET",
               "ପୂର୍ବାଞ୍ଚଳ ୟୁରୋପୀୟ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "EEST",
               "ପୂର୍ବାଞ୍ଚଳ ୟୁରୋପୀୟ ସମୟ",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "ପଶ୍ଚିମାଞ୍ଚଳ ୟୁରୋପୀୟ ମାନାଙ୍କ ସମୟ",
               "WET",
               "ପଶ୍ଚିମାଞ୍ଚଳ ୟୁରୋପୀୟ ଗ୍ରୀଷ୍ମକାଳ ସମୟ",
               "WEST",
               "ପଶ୍ଚିମାଞ୍ଚଳ ୟୁରୋପୀୟ ସମୟ",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "ମେକ୍ସିକାନ୍ ପାସିଫିକ୍ ମାନାଙ୍କ ସମୟ",
               "MST",
               "ମେକ୍ସିକାନ୍ ପାସିଫିକ୍ ଦିବାଲୋକ ସମୟ",
               "MDT",
               "ମେକ୍ସିକାନ୍ ପାସିଫିକ୍ ସମୟ",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "ଦକ୍ଷିଣ ଆଫ୍ରିକା ମାନାଙ୍କ ସମୟ",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "କେନ୍ଦ୍ରୀୟ ମାନାଙ୍କ ସମୟ",
               "CST",
               "କେନ୍ଦ୍ରୀୟ ଦିବାଲୋକ ସମୟ",
               "CDT",
               "କେନ୍ଦ୍ରୀୟ ସମୟ",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "ପୂର୍ବାଞ୍ଚଳ ମାନାଙ୍କ ସମୟ",
               "EST",
               "ପୂର୍ବାଞ୍ଚଳ ଦିବାଲୋକ ସମୟ",
               "EST",
               "ପୂର୍ବାଞ୍ଚଳ ସମୟ",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "ପାସିଫିକ୍ ମାନାଙ୍କ ସମୟ",
               "PST",
               "ପାସିଫିକ୍ ଦିବାଲୋକ ସମୟ",
               "PDT",
               "ପାସିଫିକ୍ ସମୟ",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "ଫ୍ରେଞ୍ଚ ଦକ୍ଷିଣ ଏବଂ ଆଣ୍ଟାର୍କାଟିକ୍‌ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "ଗିଲବର୍ଟ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "ହୱାଇ-ଆଲେଉଟିୟ ମାନାଙ୍କ ସମୟ",
               "HST",
               "ହୱାଇ-ଆଲେଉଟିୟ ଦିବାଲୋକ ସମୟ",
               "HDT",
               "ହୱାଇ-ଆଲେଉଟିୟ ସମୟ",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "ଫିନିକ୍ସ ଦ୍ୱୀପପୁଞ୍ଜ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "ସେଣ୍ଟ. ପିଏରେ ଏବଂ ମିକ୍ୟୁଲୋନ୍ ମାନାଙ୍କ ସମୟ",
               "",
               "ସେଣ୍ଟ. ପିଏରେ ଏବଂ ମିକ୍ୟୁଲୋନ୍ ଦିବାଲୋକ ସମୟ",
               "",
               "ସେଣ୍ଟ. ପିଏରେ ଏବଂ ମିକ୍ୟୁଲୋନ୍ ସମୟ",
               "",
            };
        final String[] America_Mountain = new String[] {
               "ପାର୍ବତ୍ୟ ମାନାଙ୍କ ସମୟ",
               "MST",
               "ପାର୍ବତ୍ୟ ଦିବାଲୋକ ସମୟ",
               "MST",
               "ପାର୍ବତ୍ୟ ସମୟ",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "ମାର୍ଶାଲ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "ପପୁଆ ନ୍ୟୁ ଗିନି ସମୟ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "ଅଷ୍ଟ୍ରେଲିୟ ମଧ୍ୟ ମାନାଙ୍କ ସମୟ",
               "ACST",
               "ଅଷ୍ଟ୍ରେଲିୟ ମଧ୍ୟ ଦିବାଲୋକ ସମୟ",
               "ACDT",
               "ମଧ୍ୟ ଅଷ୍ଟ୍ରେଲିଆ ସମୟ",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "ଅଷ୍ଟ୍ରେଲିୟ ପୂର୍ବ ମାନାଙ୍କ ସମୟ",
               "AEST",
               "ଅଷ୍ଟ୍ରେଲିୟ ପୂର୍ବ ଦିବାଲୋକ ସମୟ",
               "AEDT",
               "ପୂର୍ବ ଅଷ୍ଟ୍ରେଲିଆ ସମୟ",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "ଅଷ୍ଟ୍ରେଲିୟ ପଶ୍ଚିମ ମାନାଙ୍କ ସମୟ",
               "AWST",
               "ଅଷ୍ଟ୍ରେଲିୟ ପଶ୍ଚିମ ଦିବାଲୋକ ସମୟ",
               "AWDT",
               "ପଶ୍ଚିମ ଅଷ୍ଟ୍ରେଲିଆ ସମୟ",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "ମଧ୍ୟ ଇଣ୍ଡୋନେସିଆ ସମୟ",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "ପୂର୍ବ ଇଣ୍ଡୋନେସିଆ ସମୟ",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "ପଶ୍ଚିମ ଇଣ୍ଡୋନେସିଆ ସମୟ",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "ଅଷ୍ଟ୍ରେଲିୟ ମଧ୍ୟ ପଶ୍ଚିମ ମାନାଙ୍କ ସମୟ",
               "",
               "ଅଷ୍ଟ୍ରେଲିୟ ମଧ୍ୟ ପଶ୍ଚିମ ଦିବାଲୋକ ସମୟ",
               "",
               "ଅଷ୍ଟ୍ରେଲିୟ ମଧ୍ୟ ପଶ୍ଚିମ ସମୟ",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "ଗ୍ରୀନୱିଚ୍ ମିନ୍ ସମୟ",
                    "GMT",
                    "ବ୍ରିଟିଶ୍‌ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "ସମନ୍ୱିତ ସାର୍ବଜନୀନ ସମୟ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "ଗ୍ରୀନୱିଚ୍ ମିନ୍ ସମୟ",
                    "GMT",
                    "ଆଇରିଶ୍‌ ମାନକ ସମୟ",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "ସମନ୍ୱିତ ସାର୍ବଜନୀନ ସମୟ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "ସମନ୍ୱିତ ସାର୍ବଜନୀନ ସମୟ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "ଗ୍ରୀନୱିଚ୍ ମିନ୍ ସମୟ",
                    "GMT",
                    "ବ୍ରିଟିଶ୍‌ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "ସମନ୍ୱିତ ସାର୍ବଜନୀନ ସମୟ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "ସମନ୍ୱିତ ସାର୍ବଜନୀନ ସମୟ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "ସମନ୍ୱିତ ସାର୍ବଜନୀନ ସମୟ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "ଗ୍ରୀନୱିଚ୍ ମିନ୍ ସମୟ",
                    "GMT",
                    "ଆଇରିଶ୍‌ ମାନକ ସମୟ",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "ଗ୍ରୀନୱିଚ୍ ମିନ୍ ସମୟ",
                    "GMT",
                    "ବ୍ରିଟିଶ୍‌ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "ଗ୍ରୀନୱିଚ୍ ମିନ୍ ସମୟ",
                    "GMT",
                    "ବ୍ରିଟିଶ୍‌ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "ଗ୍ରୀନୱିଚ୍ ମିନ୍ ସମୟ",
                    "GMT",
                    "ବ୍ରିଟିଶ୍‌ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "ଗ୍ରୀନୱିଚ୍ ମିନ୍ ସମୟ",
                    "GMT",
                    "ବ୍ରିଟିଶ୍‌ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "ଗ୍ରୀନୱିଚ୍ ମିନ୍ ସମୟ",
                    "GMT",
                    "ବ୍ରିଟିଶ୍‌ ଗ୍ରୀଷ୍ମକାଳୀନ ସମୟ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "ଏଡେନ୍‌" },
            { "timezone.excity.Asia/Baku", "ବାକୁ" },
            { "timezone.excity.Asia/Dili", "ଦିଲ୍ଲୀ" },
            { "timezone.excity.Asia/Gaza", "ଗାଜା" },
            { "timezone.excity.Asia/Hovd", "ହୋଭଡ୍‌" },
            { "timezone.excity.Asia/Omsk", "ଓମସ୍କ" },
            { "timezone.excity.Asia/Oral", "ଓରାଲ୍‌" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "ଅମ୍ମାନ" },
            { "timezone.excity.Asia/Aqtau", "ଆକଟାଉ" },
            { "timezone.excity.Asia/Chita", "ଚିଟା" },
            { "timezone.excity.Asia/Dhaka", "ଢାକା" },
            { "timezone.excity.Asia/Dubai", "ଦୁବାଇ" },
            { "timezone.excity.Asia/Kabul", "କାବୁଲ" },
            { "timezone.excity.Asia/Macau", "ମାକାଉ" },
            { "timezone.excity.Asia/Qatar", "କତାର୍" },
            { "timezone.excity.Asia/Seoul", "ସିଓଲ" },
            { "timezone.excity.Asia/Tokyo", "ଟୋକିଓ" },
            { "timezone.excity.Asia/Tomsk", "ଟୋମସ୍କ" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "ଜୁବା" },
            { "timezone.excity.Africa/Lome", "ଲୋମ୍‌" },
            { "timezone.excity.Asia/Almaty", "ଅଲମାଟି" },
            { "timezone.excity.Asia/Anadyr", "ଆନାଡୟାର୍" },
            { "timezone.excity.Asia/Aqtobe", "ଆକଟୋବ୍‌" },
            { "timezone.excity.Asia/Atyrau", "ଅତିରାଉ" },
            { "timezone.excity.Asia/Beirut", "ବୀରୁଟ୍‌" },
            { "timezone.excity.Asia/Brunei", "ବ୍ରୁନେଇ" },
            { "timezone.excity.Asia/Hebron", "ହେବ୍ରନ୍‌" },
            { "timezone.excity.Asia/Kuwait", "କୁଏତ" },
            { "timezone.excity.Asia/Manila", "ମାନିଲା" },
            { "timezone.excity.Asia/Muscat", "ମସ୍କାଟ୍‌" },
            { "timezone.excity.Asia/Riyadh", "ରିଆଦ" },
            { "timezone.excity.Asia/Saigon", "ହୋ ଚି ମିନ୍‌ ସିଟି" },
            { "timezone.excity.Asia/Taipei", "ତାଇପେଇ" },
            { "timezone.excity.Asia/Tehran", "ତେହେରାନ୍" },
            { "timezone.excity.Asia/Urumqi", "ଉରୁମକି" },
            { "timezone.excity.Etc/Unknown", "ଅଜଣା ସହର" },
            { "timezone.excity.Europe/Kiev", "କିଏଭ୍" },
            { "timezone.excity.Europe/Oslo", "ଓସଲୋ" },
            { "timezone.excity.Europe/Riga", "ରିଗା" },
            { "timezone.excity.Europe/Rome", "ରୋମ୍" },
            { "timezone.excity.Indian/Mahe", "ମାହେ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "ଆକାରା" },
            { "timezone.excity.Africa/Cairo", "କାଇରୋ" },
            { "timezone.excity.Africa/Ceuta", "ସେଉଟା" },
            { "timezone.excity.Africa/Dakar", "ଡକାର" },
            { "timezone.excity.Africa/Lagos", "ଲାଗୋସ୍‌" },
            { "timezone.excity.Africa/Tunis", "ଟୁନିସ୍‌" },
            { "timezone.excity.America/Adak", "ଆଡାକ୍" },
            { "timezone.excity.America/Lima", "ଲିମା" },
            { "timezone.excity.America/Nome", "ନୋମେ" },
            { "timezone.excity.Asia/Baghdad", "ବାଗଦାଦ୍‌" },
            { "timezone.excity.Asia/Bahrain", "ବାହାରିନ୍" },
            { "timezone.excity.Asia/Bangkok", "ବ୍ୟାଙ୍ଗକକ୍‌" },
            { "timezone.excity.Asia/Barnaul", "ବାରନାଉଲ୍" },
            { "timezone.excity.Asia/Bishkek", "ବିଶକେକ୍‌" },
            { "timezone.excity.Asia/Colombo", "କଲମ୍ବୋ" },
            { "timezone.excity.Asia/Irkutsk", "ଇରକୁଟସ୍କ" },
            { "timezone.excity.Asia/Jakarta", "ଜାକର୍ତ୍ତା" },
            { "timezone.excity.Asia/Karachi", "କରାଚି" },
            { "timezone.excity.Asia/Kuching", "କୁଚିଂ" },
            { "timezone.excity.Asia/Magadan", "ମାଗାଡାନ୍" },
            { "timezone.excity.Asia/Nicosia", "ନିକୋସିଆ" },
            { "timezone.excity.Asia/Rangoon", "ୟାଙ୍ଗୁନ୍‌" },
            { "timezone.excity.Asia/Tbilisi", "ଟିବିଲିସି" },
            { "timezone.excity.Asia/Thimphu", "ଥିମ୍ପୁ" },
            { "timezone.excity.Asia/Yakutsk", "ୟାକୁଟସ୍କ" },
            { "timezone.excity.Asia/Yerevan", "ୟେରେଭାନ୍" },
            { "timezone.excity.Europe/Kirov", "କିରୋଭ" },
            { "timezone.excity.Europe/Malta", "ମାଲଟା" },
            { "timezone.excity.Europe/Minsk", "ମିନସ୍କ" },
            { "timezone.excity.Europe/Paris", "ପେରିସ୍" },
            { "timezone.excity.Europe/Sofia", "ସୋଫିଆ" },
            { "timezone.excity.Europe/Vaduz", "ଭାଡୁଜ" },
            { "timezone.excity.Indian/Cocos", "କୋକୋସ୍‌" },
            { "timezone.excity.Pacific/Apia", "ଆପିଆ" },
            { "timezone.excity.Pacific/Fiji", "ଫିଜି" },
            { "timezone.excity.Pacific/Guam", "ଗୁଆମ" },
            { "timezone.excity.Pacific/Niue", "ନିୟୂ" },
            { "timezone.excity.Pacific/Truk", "ଚୂକ୍‌" },
            { "timezone.excity.Pacific/Wake", "ୱେକ୍" },
            { "timezone.excity.Africa/Asmera", "ଅସମରା" },
            { "timezone.excity.Africa/Bamako", "ବାମାକୋ" },
            { "timezone.excity.Africa/Bangui", "ବାଙ୍ଗୁଇ" },
            { "timezone.excity.Africa/Banjul", "ବାଞ୍ଜୁଲ" },
            { "timezone.excity.Africa/Bissau", "ବିସାଉ" },
            { "timezone.excity.Africa/Douala", "ଡଉଲା" },
            { "timezone.excity.Africa/Harare", "ହରାରେ" },
            { "timezone.excity.Africa/Kigali", "କିଗାଲି" },
            { "timezone.excity.Africa/Luanda", "ଲୁଆଣ୍ଡା" },
            { "timezone.excity.Africa/Lusaka", "ଲୁସାକା" },
            { "timezone.excity.Africa/Malabo", "ମାଲାବୋ" },
            { "timezone.excity.Africa/Maputo", "ମାପୁତୋ" },
            { "timezone.excity.Africa/Maseru", "ମେସେରୁ" },
            { "timezone.excity.Africa/Niamey", "ନିଆମି" },
            { "timezone.excity.America/Aruba", "ଆରୁବା" },
            { "timezone.excity.America/Bahia", "ବାହିଆ" },
            { "timezone.excity.America/Belem", "ବେଲେମ" },
            { "timezone.excity.America/Boise", "ବୋଇସେ" },
            { "timezone.excity.America/Jujuy", "ଜୁଜୁଇ" },
            { "timezone.excity.America/Sitka", "ସିଟକା" },
            { "timezone.excity.America/Thule", "ଥୁଲେ" },
            { "timezone.excity.Asia/Ashgabat", "ଆଶ୍‌ଗାବୋଟ୍‌" },
            { "timezone.excity.Asia/Calcutta", "କୋଲକାତା" },
            { "timezone.excity.Asia/Damascus", "ଡାମାସକସ୍‌" },
            { "timezone.excity.Asia/Dushanbe", "ଦୁଶାନବେ" },
            { "timezone.excity.Asia/Jayapura", "ଜୟପୁରା" },
            { "timezone.excity.Asia/Katmandu", "କାଠମାଣ୍ଡୁ" },
            { "timezone.excity.Asia/Khandyga", "ଖାନଡ୍ୟାଗା" },
            { "timezone.excity.Asia/Makassar", "ମାକାସାର୍‌" },
            { "timezone.excity.Asia/Qostanay", "କୋଷ୍ଟନେ" },
            { "timezone.excity.Asia/Sakhalin", "ସଖାଲିନ୍" },
            { "timezone.excity.Asia/Shanghai", "ସାଂଘାଇ" },
            { "timezone.excity.Asia/Tashkent", "ତାଶକେଣ୍ଟ" },
            { "timezone.excity.Asia/Ust-Nera", "ୟୁଷ୍ଟ-ନେରା" },
            { "timezone.excity.Europe/Athens", "ଏଥେନ୍ସ" },
            { "timezone.excity.Europe/Berlin", "ବର୍ଲିନ୍" },
            { "timezone.excity.Europe/Dublin", "ଡବଲିନ୍" },
            { "timezone.excity.Europe/Jersey", "ଜର୍ସି" },
            { "timezone.excity.Europe/Lisbon", "ଲିସବୋନ୍" },
            { "timezone.excity.Europe/London", "ଲଣ୍ଡନ୍" },
            { "timezone.excity.Europe/Madrid", "ମାଡ୍ରିଡ୍" },
            { "timezone.excity.Europe/Monaco", "ମୋନାକୋ" },
            { "timezone.excity.Europe/Moscow", "ମସ୍କୋ" },
            { "timezone.excity.Europe/Prague", "ପ୍ରାଗ୍" },
            { "timezone.excity.Europe/Samara", "ସାମାରା" },
            { "timezone.excity.Europe/Skopje", "ସ୍କୋପଜେ" },
            { "timezone.excity.Europe/Tirane", "ଟିରାନେ" },
            { "timezone.excity.Europe/Vienna", "ଭିଏନା" },
            { "timezone.excity.Europe/Warsaw", "ୱାରସୱା" },
            { "timezone.excity.Europe/Zagreb", "ଜାଗ୍ରେବ୍" },
            { "timezone.excity.Europe/Zurich", "ଜୁରିକ୍" },
            { "timezone.excity.Indian/Chagos", "ଚାଗୋସ୍‌" },
            { "timezone.excity.Indian/Comoro", "କୋମୋରୋ" },
            { "timezone.excity.Pacific/Efate", "ଇଫେଟ୍‌" },
            { "timezone.excity.Pacific/Nauru", "ନାଉରୁ" },
            { "timezone.excity.Pacific/Palau", "ପାଲାଉ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "ଆବିଦଜାନ" },
            { "timezone.excity.Africa/Algiers", "ଅଲଜିୟର୍ସ" },
            { "timezone.excity.Africa/Conakry", "କୋନାକ୍ରି" },
            { "timezone.excity.Africa/Kampala", "କାମ୍ପାଲା" },
            { "timezone.excity.Africa/Mbabane", "ବାବେନ୍‌" },
            { "timezone.excity.Africa/Nairobi", "ନାଇରୋବି" },
            { "timezone.excity.Africa/Tripoli", "ତ୍ରିପୋଲି" },
            { "timezone.excity.America/Belize", "ବେଲିଜେ" },
            { "timezone.excity.America/Bogota", "ବୋଗୋଟା" },
            { "timezone.excity.America/Cancun", "କାନକୁନ୍" },
            { "timezone.excity.America/Cayman", "କାୟମ୍ୟାନ୍" },
            { "timezone.excity.America/Cuiaba", "କୁଇବା" },
            { "timezone.excity.America/Dawson", "ଡସନ୍‌" },
            { "timezone.excity.America/Denver", "ଡେନଭିର୍" },
            { "timezone.excity.America/Guyana", "ଗୁଏନା" },
            { "timezone.excity.America/Havana", "ହାଭାନା" },
            { "timezone.excity.America/Inuvik", "ଇନୁଭିକ୍" },
            { "timezone.excity.America/Juneau", "ଜୁନେଆଉ" },
            { "timezone.excity.America/La_Paz", "ଲା ପାଜ୍‌" },
            { "timezone.excity.America/Maceio", "ମାସିଓ" },
            { "timezone.excity.America/Manaus", "ମାନାଉସ୍‌" },
            { "timezone.excity.America/Merida", "ମେରିଡା" },
            { "timezone.excity.America/Nassau", "ନାସାଉ" },
            { "timezone.excity.America/Panama", "ପାନାମା" },
            { "timezone.excity.America/Recife", "ରେସିଫି" },
            { "timezone.excity.America/Regina", "ରେଗିନା" },
            { "timezone.excity.Asia/Famagusta", "ଫାମାଗୁଷ୍ଟା" },
            { "timezone.excity.Asia/Hong_Kong", "ହଂ କଂ" },
            { "timezone.excity.Asia/Jerusalem", "ଜେରୁଜେଲମ" },
            { "timezone.excity.Asia/Kamchatka", "କାମଚାଟକା" },
            { "timezone.excity.Asia/Pontianak", "ପୋଣ୍ଟିଆନାକ୍‌" },
            { "timezone.excity.Asia/Pyongyang", "ପୋୟଙ୍ଗୟାଙ୍ଗ" },
            { "timezone.excity.Asia/Qyzylorda", "କୀଜିଲୋର୍ଡା" },
            { "timezone.excity.Asia/Samarkand", "ସମରକନ୍ଦ" },
            { "timezone.excity.Asia/Singapore", "ସିଙ୍ଗାପୁର୍‌" },
            { "timezone.excity.Asia/Vientiane", "ଭିଏଣ୍ଟିଏନ୍‌" },
            { "timezone.excity.Europe/Andorra", "ଆନଡୋରା" },
            { "timezone.excity.Europe/Saratov", "ସାରାଟୋଭ୍" },
            { "timezone.excity.Europe/Tallinn", "ଟାଲିନ୍ନ" },
            { "timezone.excity.Europe/Vatican", "ଭାଟିକାନ୍" },
            { "timezone.excity.Europe/Vilnius", "ଭିଲନିଉସ୍" },
            { "timezone.excity.Indian/Mayotte", "ମାୟୋଟେ" },
            { "timezone.excity.Indian/Reunion", "ରିୟୁନିଅନ୍‌" },
            { "timezone.excity.Pacific/Easter", "ଇଷ୍ଟର୍‌" },
            { "timezone.excity.Pacific/Kosrae", "କୋସରେଇ" },
            { "timezone.excity.Pacific/Majuro", "ମାଜୁରୋ" },
            { "timezone.excity.Pacific/Midway", "ମିଡ୍‌ୱେ" },
            { "timezone.excity.Pacific/Noumea", "ନୌମିୟ" },
            { "timezone.excity.Pacific/Ponape", "ପୋହନପେଇ" },
            { "timezone.excity.Pacific/Saipan", "ସାଇପାନ୍" },
            { "timezone.excity.Pacific/Tahiti", "ତାହିତି" },
            { "timezone.excity.Pacific/Tarawa", "ତାରୱା" },
            { "timezone.excity.Pacific/Wallis", "ୱାଲିସ୍‌" },
            { "timezone.excity.Africa/Blantyre", "ବ୍ଲାଣ୍ଟାୟାର୍‌" },
            { "timezone.excity.Africa/Djibouti", "ଜିବୋଟି" },
            { "timezone.excity.Africa/El_Aaiun", "ଏଲ୍‌ ଏୟନ୍" },
            { "timezone.excity.Africa/Freetown", "ଫ୍ରିଟାଉନ୍‌" },
            { "timezone.excity.Africa/Gaborone", "ଗାବୋର୍ଣ୍ଣ" },
            { "timezone.excity.Africa/Khartoum", "ଖରଟୌମ୍‌" },
            { "timezone.excity.Africa/Kinshasa", "କିନସାସ୍‌" },
            { "timezone.excity.Africa/Monrovia", "ମନରୋଭିଆ" },
            { "timezone.excity.Africa/Ndjamena", "ଜାମେନା" },
            { "timezone.excity.Africa/Sao_Tome", "ସାଓ ଟୋମେ" },
            { "timezone.excity.Africa/Windhoek", "ୱିଣ୍ଡହୋଏକ୍" },
            { "timezone.excity.America/Antigua", "ଆଣ୍ଟିଗୁଆ" },
            { "timezone.excity.America/Caracas", "କାରକାସ୍‌" },
            { "timezone.excity.America/Cayenne", "କେୟେନ୍ନି" },
            { "timezone.excity.America/Chicago", "ଚିକାଗୋ" },
            { "timezone.excity.America/Cordoba", "କୋର୍ଡୋବା" },
            { "timezone.excity.America/Creston", "କ୍ରେଷ୍ଟୋନ୍" },
            { "timezone.excity.America/Curacao", "କୁରାକୋ" },
            { "timezone.excity.America/Detroit", "ଡେଟ୍ରୋଇଟ୍" },
            { "timezone.excity.America/Godthab", "ନୁଉକ୍" },
            { "timezone.excity.America/Grenada", "ଗ୍ରେନାଡା" },
            { "timezone.excity.America/Halifax", "ହାଲିଫ୍ୟାକ୍ସ୍" },
            { "timezone.excity.America/Iqaluit", "ଇକ୍ଵାଲୁଇଟ୍" },
            { "timezone.excity.America/Jamaica", "ଜାମାଇକା" },
            { "timezone.excity.America/Managua", "ମାନାଗୁଆ" },
            { "timezone.excity.America/Marigot", "ମାରିଗୋଟ୍" },
            { "timezone.excity.America/Mendoza", "ମେଣ୍ଡୋଜା" },
            { "timezone.excity.America/Moncton", "ମାନକଟୋନ୍" },
            { "timezone.excity.America/Noronha", "ନୋରୋନ୍ନା" },
            { "timezone.excity.America/Ojinaga", "ଓଜିନାଗା" },
            { "timezone.excity.America/Phoenix", "ଫୋଇନିକ୍ସ" },
            { "timezone.excity.America/Tijuana", "ତିଜୁଆନା" },
            { "timezone.excity.America/Toronto", "ଟୋରୋଣ୍ଟୋ" },
            { "timezone.excity.America/Tortola", "ଟୋରଟୋଲା" },
            { "timezone.excity.America/Yakutat", "ୟାକୁଟାଟ୍" },
            { "timezone.excity.Asia/Phnom_Penh", "ଫନୋମ୍‌ ପେନହ" },
            { "timezone.excity.Atlantic/Azores", "ଆଜୋରେସ୍" },
            { "timezone.excity.Atlantic/Canary", "କାନାରେ" },
            { "timezone.excity.Atlantic/Faeroe", "ଫାରୋଏ" },
            { "timezone.excity.Australia/Eucla", "ୟୁକଲା" },
            { "timezone.excity.Australia/Perth", "ପର୍ଥ୍‌" },
            { "timezone.excity.Europe/Belgrade", "ବେଲଗ୍ରେଡ୍‌" },
            { "timezone.excity.Europe/Brussels", "ବ୍ରସଲ୍ସ୍" },
            { "timezone.excity.Europe/Budapest", "ବୁଡାପେଷ୍ଟ୍" },
            { "timezone.excity.Europe/Busingen", "ବୁସିନଗେନ୍" },
            { "timezone.excity.Europe/Chisinau", "ଚିସିନୌ" },
            { "timezone.excity.Europe/Guernsey", "ଗୁଏରନସେ" },
            { "timezone.excity.Europe/Helsinki", "ହେଲସିନକି" },
            { "timezone.excity.Europe/Istanbul", "ଇସ୍ତାନବୁଲ" },
            { "timezone.excity.Europe/Sarajevo", "ସାରାଜେଭୋ" },
            { "timezone.excity.Indian/Maldives", "ମାଳଦ୍ୱୀପ" },
            { "timezone.excity.Pacific/Chatham", "ଚାଥାମ୍‌" },
            { "timezone.excity.Pacific/Fakaofo", "ଫାକାଓଫୋ" },
            { "timezone.excity.Pacific/Gambier", "ଗାମ୍ବିୟର୍‌" },
            { "timezone.excity.Pacific/Norfolk", "ନରଫୋକ୍‌" },
            { "timezone.excity.Africa/Bujumbura", "ବୁଜୁମ୍ବୁରା" },
            { "timezone.excity.Africa/Mogadishu", "ମୋଗାଦିଶୁ" },
            { "timezone.excity.America/Anguilla", "ଆଙ୍ଗୁଇଲା" },
            { "timezone.excity.America/Asuncion", "ଆସନସିଅନ୍‌" },
            { "timezone.excity.America/Barbados", "ବାର୍ବାଡୋସ୍" },
            { "timezone.excity.America/Dominica", "ଡୋମିନିକା" },
            { "timezone.excity.America/Edmonton", "ଏଡମୋନଟୋନ୍" },
            { "timezone.excity.America/Eirunepe", "ଇରୁନେପେ" },
            { "timezone.excity.America/Mazatlan", "ମାନାଟଲାନ୍" },
            { "timezone.excity.America/Miquelon", "ମିକ୍ଵେଲୋନ୍" },
            { "timezone.excity.America/New_York", "ନ୍ୟୁ ୟୋର୍କ୍" },
            { "timezone.excity.America/Resolute", "ରିସୋଲୁଟେ" },
            { "timezone.excity.America/Santarem", "ସାଣ୍ଟାରେମ୍‌" },
            { "timezone.excity.America/Santiago", "ସାଣ୍ଟିଆଗୋ" },
            { "timezone.excity.America/St_Johns", "ସେଣ୍ଟ୍. ଜନସ୍" },
            { "timezone.excity.America/St_Kitts", "ସେଣ୍ଟ୍ କିଟ୍ସ୍" },
            { "timezone.excity.America/St_Lucia", "ସେଣ୍ଟ୍. ଲୁସିଆ" },
            { "timezone.excity.America/Winnipeg", "ୱିନିପେଗ୍" },
            { "timezone.excity.Antarctica/Casey", "କାସେ" },
            { "timezone.excity.Antarctica/Davis", "ଡେଭିସ୍‌" },
            { "timezone.excity.Antarctica/Syowa", "ସୋୱା" },
            { "timezone.excity.Antarctica/Troll", "ଟ୍ରୋଲ୍" },
            { "timezone.excity.Asia/Krasnoyarsk", "କ୍ରାସନୋୟାରସ୍କ" },
            { "timezone.excity.Asia/Novosibirsk", "ନୋଭୋସିବିରସ୍କ" },
            { "timezone.excity.Asia/Ulaanbaatar", "ଉଲାନ୍‌ବାଟର୍‌" },
            { "timezone.excity.Asia/Vladivostok", "ଭ୍ଲାଡିଭୋଷ୍ଟୋକ୍" },
            { "timezone.excity.Atlantic/Bermuda", "ବର୍ମୁଡା" },
            { "timezone.excity.Atlantic/Madeira", "ମାଡେଇରା" },
            { "timezone.excity.Atlantic/Stanley", "ଷ୍ଟାନଲି" },
            { "timezone.excity.Australia/Darwin", "ଡାରୱିନ୍‌" },
            { "timezone.excity.Australia/Hobart", "ହୋବାର୍ଟ୍‌" },
            { "timezone.excity.Australia/Sydney", "ସିଡନୀ" },
            { "timezone.excity.Europe/Amsterdam", "ଆମଷ୍ଟରଡାମ୍" },
            { "timezone.excity.Europe/Astrakhan", "ଆଷ୍ଟ୍ରାଖାନ୍" },
            { "timezone.excity.Europe/Bucharest", "ବୁଚାରେଷ୍ଟ୍" },
            { "timezone.excity.Europe/Gibraltar", "ଜିବ୍ରାଲଟର୍‌" },
            { "timezone.excity.Europe/Ljubljana", "ଲଜୁବ୍ଲଜାନ୍" },
            { "timezone.excity.Europe/Mariehamn", "ମାରିଏହାମନ୍" },
            { "timezone.excity.Europe/Podgorica", "ପୋଡଗୋରିକା" },
            { "timezone.excity.Europe/Stockholm", "ଷ୍ଟକହୋମ୍‌" },
            { "timezone.excity.Europe/Ulyanovsk", "ୟୁଲୟାନୋଭସ୍କ" },
            { "timezone.excity.Europe/Volgograd", "ଭୋଲଗୋଗ୍ରାଡ୍" },
            { "timezone.excity.Indian/Christmas", "ଖ୍ରୀଷ୍ଟମାସ" },
            { "timezone.excity.Indian/Kerguelen", "କେରୁଗେଲେନ" },
            { "timezone.excity.Indian/Mauritius", "ମୌରିସସ୍" },
            { "timezone.excity.Pacific/Auckland", "ଅକଲାଣ୍ଡ" },
            { "timezone.excity.Pacific/Funafuti", "ଫୁନାଫୁଟି" },
            { "timezone.excity.Pacific/Honolulu", "ହୋନୋଲୁଲୁ" },
            { "timezone.excity.Pacific/Pitcairn", "ପିଟକାରିନ୍‌" },
            { "timezone.excity.Africa/Casablanca", "କାସାବ୍ଲାଙ୍କା" },
            { "timezone.excity.Africa/Libreville", "ଲିବ୍ରେଭିଲ୍ଲେ" },
            { "timezone.excity.Africa/Lubumbashi", "ଲୁବୁମ୍ବାଶି" },
            { "timezone.excity.Africa/Nouakchott", "ନୌକାଚୋଟ" },
            { "timezone.excity.Africa/Porto-Novo", "ପୋର୍ଟୋ-ନୋଭୋ" },
            { "timezone.excity.America/Anchorage", "ଆଙ୍କରେଜ୍" },
            { "timezone.excity.America/Araguaina", "ଆରାଗୁଆନା" },
            { "timezone.excity.America/Boa_Vista", "ବୋଆ ଭିଷ୍ଟା" },
            { "timezone.excity.America/Catamarca", "କାଟାମାର୍କା" },
            { "timezone.excity.America/Chihuahua", "ଚିହୁଆହୁଆ" },
            { "timezone.excity.America/Coyhaique", "କୋୟାଇକେ" },
            { "timezone.excity.America/Fortaleza", "ଫୋର୍ଟେଲେଜା" },
            { "timezone.excity.America/Glace_Bay", "ଗ୍ଲାସେ ବେ" },
            { "timezone.excity.America/Goose_Bay", "ଗୁସ୍ ବେ" },
            { "timezone.excity.America/Guatemala", "ଗୁଆଟେମାଲା" },
            { "timezone.excity.America/Guayaquil", "ଗୁୟାକ୍ୱିଲ" },
            { "timezone.excity.America/Matamoros", "ମାଟାମୋରୋସ୍" },
            { "timezone.excity.America/Menominee", "ମେନୋମିନି" },
            { "timezone.excity.America/Monterrey", "ମୋନଟେରିଏ" },
            { "timezone.excity.America/Sao_Paulo", "ସାଓ ପାଓଲୋ" },
            { "timezone.excity.America/St_Thomas", "ସେଣ୍ଟ୍. ଥୋମାସ୍" },
            { "timezone.excity.America/Vancouver", "ଭାଙ୍କୁଭର୍" },
            { "timezone.excity.Antarctica/Mawson", "ମାୱସନ୍" },
            { "timezone.excity.Antarctica/Palmer", "ପାଲମର୍‌" },
            { "timezone.excity.Antarctica/Vostok", "ଭୋଷ୍ଟୋକ୍‌" },
            { "timezone.excity.Asia/Kuala_Lumpur", "କ୍ୱାଲାଲମ୍ପୁର" },
            { "timezone.excity.Asia/Novokuznetsk", "ନୋଭୋକୁଜନେଟସ୍କ" },
            { "timezone.excity.Europe/Bratislava", "ବ୍ରାଟିସଲାଭା" },
            { "timezone.excity.Europe/Copenhagen", "କୋପେନହାଗେନ୍" },
            { "timezone.excity.Europe/Luxembourg", "ଲକ୍ସମବର୍ଗ" },
            { "timezone.excity.Europe/San_Marino", "ସାନ୍ ମାରିନୋ" },
            { "timezone.excity.Europe/Simferopol", "ସିମଫେରୋପୋଲ୍" },
            { "timezone.excity.Pacific/Enderbury", "କ୍ୟାଣ୍ଟନ" },
            { "timezone.excity.Pacific/Galapagos", "ଗାଲାପାଗୋସ" },
            { "timezone.excity.Pacific/Kwajalein", "କ୍ୱାଜାଲେଇନ୍" },
            { "timezone.excity.Pacific/Marquesas", "ମାର୍କ୍ୱେସାସ୍‌" },
            { "timezone.excity.Pacific/Pago_Pago", "ପାଗୋ ପାଗୋ" },
            { "timezone.excity.Pacific/Rarotonga", "ରାରୋଟୋଙ୍ଗା" },
            { "timezone.excity.Pacific/Tongatapu", "ଟୋଙ୍ଗାଟାପୁ" },
            { "timezone.excity.Africa/Addis_Ababa", "ଆଦିସ୍‌ ଆବାବା" },
            { "timezone.excity.Africa/Brazzaville", "ବ୍ରାଜାଭିଲ୍ଲେ" },
            { "timezone.excity.Africa/Ouagadougou", "ଅଉଗାଡଉଗଉ" },
            { "timezone.excity.America/Costa_Rica", "କୋଷ୍ଟା ରିକା" },
            { "timezone.excity.America/Grand_Turk", "ଗ୍ରାଣ୍ଡ୍ ଟର୍କ୍" },
            { "timezone.excity.America/Guadeloupe", "ଗୁଆଡେଲୋପ୍‌" },
            { "timezone.excity.America/Hermosillo", "ହେରମୋସିଲୋ" },
            { "timezone.excity.America/Kralendijk", "କ୍ରାଲେଣ୍ଡଜିକ" },
            { "timezone.excity.America/Louisville", "ଲୁଇଭିଲ୍ଲେ" },
            { "timezone.excity.America/Martinique", "ମାର୍ଟିନିକ୍ୟୁ" },
            { "timezone.excity.America/Metlakatla", "ମାଟଲାକାଟଲା" },
            { "timezone.excity.America/Montevideo", "ମଣ୍ଟେଭିଡିଓ" },
            { "timezone.excity.America/Montserrat", "ମୋନଟସେରରାଟ୍" },
            { "timezone.excity.America/Paramaribo", "ପାରାମାରିବୋ" },
            { "timezone.excity.America/Rio_Branco", "ରିଓ ବ୍ରାଙ୍କୋ" },
            { "timezone.excity.America/St_Vincent", "ସେଣ୍ଟ୍. ଭିନସେଣ୍ଟ୍" },
            { "timezone.excity.America/Whitehorse", "ହ୍ଵାଇଟହର୍ସ୍" },
            { "timezone.excity.Antarctica/McMurdo", "ମ୍ୟାକ୍‌ମୁର୍ଡୋ" },
            { "timezone.excity.Antarctica/Rothera", "ରୋଥେରା" },
            { "timezone.excity.Asia/Srednekolymsk", "ସ୍ରେଡନେକୋଲୟମସ୍କ" },
            { "timezone.excity.Asia/Yekaterinburg", "ୟେକାଟେରିନବର୍ଗ୍" },
            { "timezone.excity.Atlantic/Reykjavik", "ରେୟକଜାଭିକ୍" },
            { "timezone.excity.Atlantic/St_Helena", "ସେଣ୍ଟ୍‌ ହେଲିନା" },
            { "timezone.excity.Australia/Adelaide", "ଆଡିଲେଡ୍‌" },
            { "timezone.excity.Australia/Brisbane", "ବ୍ରିସବେନ୍‌" },
            { "timezone.excity.Australia/Lindeman", "ଲିଣ୍ଡେମ୍ୟାନ୍‌" },
            { "timezone.excity.Europe/Isle_of_Man", "ଇସଲେ ଅଫ୍ ମେନ୍" },
            { "timezone.excity.Europe/Kaliningrad", "କାଲିନିନଗ୍ରାଡ୍" },
            { "timezone.excity.Pacific/Kiritimati", "କିରିତିମାଟି" },
            { "timezone.excity.Africa/Johannesburg", "ଜୋହାନ୍ସବର୍ଗ" },
            { "timezone.excity.America/El_Salvador", "ଏଲ୍ ସାଲଭାଡୋର୍" },
            { "timezone.excity.America/Fort_Nelson", "ଫୋର୍ଟ୍ ନେଲସନ୍" },
            { "timezone.excity.America/Los_Angeles", "ଲସ୍ ଏଞ୍ଜେଲେସ୍" },
            { "timezone.excity.America/Mexico_City", "ମେକ୍ସିକୋ ସିଟି" },
            { "timezone.excity.America/Porto_Velho", "ପୋର୍ଟୋ ଭେଲୋ" },
            { "timezone.excity.America/Puerto_Rico", "ପୁଏର୍ତୋ ରିକୋ" },
            { "timezone.excity.America/Tegucigalpa", "ଟେଗୁସିଗାଲପା" },
            { "timezone.excity.Arctic/Longyearbyen", "ଲଙ୍ଗୟେଆରବୟେନ୍" },
            { "timezone.excity.Atlantic/Cape_Verde", "କେପ୍‌ ଭର୍ଦେ" },
            { "timezone.excity.Australia/Lord_Howe", "ଲର୍ଡ ହୋୱେ" },
            { "timezone.excity.Australia/Melbourne", "ମେଲବୋର୍ଣ୍ଣ" },
            { "timezone.excity.Indian/Antananarivo", "ଆଣ୍ଟାନାନାରିଭୋ" },
            { "timezone.excity.Pacific/Guadalcanal", "ଗୁଆଡାଲକାନାଲ" },
            { "timezone.excity.Africa/Dar_es_Salaam", "ଡର୍‌ ଇସ୍‌ ସାଲାମ" },
            { "timezone.excity.America/Blanc-Sablon", "ବ୍ଲାଙ୍କ-ସାବଲୋନ୍" },
            { "timezone.excity.America/Buenos_Aires", "ବୁଏନସ୍‌ ଏରିସ୍‌" },
            { "timezone.excity.America/Campo_Grande", "କାମ୍ପୋ ଗ୍ରାଣ୍ଡେ" },
            { "timezone.excity.America/Danmarkshavn", "ଡାନମାର୍କସାଭନ୍" },
            { "timezone.excity.America/Dawson_Creek", "ଡୱସନ୍ କ୍ରିକ୍" },
            { "timezone.excity.America/Indiana/Knox", "କ୍ନୋକ୍ସ, ଇଣ୍ଡିଆନା" },
            { "timezone.excity.America/Indianapolis", "ଇଣ୍ଡିଆନାପୋଲିସ୍" },
            { "timezone.excity.America/Punta_Arenas", "ପୁଣ୍ଟା ଏରିନାସ୍‌" },
            { "timezone.excity.America/Rankin_Inlet", "ରାନକିନ୍ ଇନଲେଟ୍" },
            { "timezone.excity.America/Scoresbysund", "ଇଟ୍ଟୋକ୍ଵୋରଟୋରମିଟ୍" },
            { "timezone.excity.Antarctica/Macquarie", "ମାକ୍ୱେରୀ" },
            { "timezone.excity.Pacific/Bougainville", "ବୌଗେନ୍‌ଭିଲ୍ଲେ" },
            { "timezone.excity.Pacific/Port_Moresby", "ପୋର୍ଟ୍‌ ମୋରେସବି" },
            { "timezone.excity.America/Cambridge_Bay", "କେମ୍ଵ୍ରିଜ୍ ବେ" },
            { "timezone.excity.America/Ciudad_Juarez", "ସିଉଡାଡ୍ ଜୁଆରେଜ୍" },
            { "timezone.excity.America/Coral_Harbour", "ଆଟିକୋକାନ୍" },
            { "timezone.excity.America/Indiana/Vevay", "ଭେଭାୟ, ଇଣ୍ଡିଆନା" },
            { "timezone.excity.America/Lower_Princes", "ନିମ୍ନ ପ୍ରିନ୍ସ’ର କ୍ଵାଟର୍" },
            { "timezone.excity.America/Port_of_Spain", "ପୋର୍ଟ୍ ଅଫ୍ ସ୍ପେନ୍" },
            { "timezone.excity.America/Santo_Domingo", "ସାଣ୍ଟୋ ଡୋମିଙ୍ଗୋ" },
            { "timezone.excity.America/St_Barthelemy", "ସେଣ୍ଟ୍. ବାର୍ଥେଲେମି" },
            { "timezone.excity.America/Swift_Current", "ସୁଇଫ୍ଟ୍ କରେଣ୍ଟ୍" },
            { "timezone.excity.Australia/Broken_Hill", "ବ୍ରୋକେନ୍‌ ହିଲ୍‌" },
            { "timezone.excity.America/Bahia_Banderas", "ବାହିଆ ବ୍ୟାଣ୍ଡେରାସ୍" },
            { "timezone.excity.America/Port-au-Prince", "ପୋର୍ଟ୍-ଏୟୁ-ପ୍ରିନ୍ସ" },
            { "timezone.excity.Atlantic/South_Georgia", "ଦକ୍ଷିଣ ଜର୍ଜିଆ" },
            { "timezone.excity.America/Argentina/Salta", "ସଲ୍ଟା" },
            { "timezone.excity.America/Indiana/Marengo", "ମାରେନଗୋ, ଇଣ୍ଡିଆନା" },
            { "timezone.excity.America/Indiana/Winamac", "ୱିନାମାକ୍, ଇଣ୍ଡିଆନା" },
            { "timezone.excity.America/Argentina/Tucuman", "ଟୁକୁମାନ୍‌" },
            { "timezone.excity.America/Argentina/Ushuaia", "ଉଶୁୟା" },
            { "timezone.excity.America/Indiana/Tell_City", "ଟେଲ୍ ସିଟି, ଇଣ୍ଡିଆନା" },
            { "timezone.excity.America/Indiana/Vincennes", "ଭିନସେନ୍ନେସ୍, ଇଣ୍ଡିଆନା" },
            { "timezone.excity.Antarctica/DumontDUrville", "ଡୁମୋଣ୍ଟ ଡି‘ଉରଭିଲ୍ଲେ" },
            { "timezone.excity.America/Argentina/La_Rioja", "ଲା ରିଓଜା" },
            { "timezone.excity.America/Argentina/San_Juan", "ସାନ୍‌ ଜୁଆନ" },
            { "timezone.excity.America/Argentina/San_Luis", "ସାନ୍‌ ଲୁଇସ୍‌" },
            { "timezone.excity.America/Indiana/Petersburg", "ପେଟେର୍ସବର୍ଗ୍, ଇଣ୍ଡିଆନା" },
            { "timezone.excity.America/Kentucky/Monticello", "ମୋଣ୍ଟିସେଲୋ, କେଣ୍ଟଉକିକେ" },
            { "timezone.excity.America/North_Dakota/Beulah", "ବେଉଲାହ, ଉତ୍ତର ଡାକୋଟା" },
            { "timezone.excity.America/North_Dakota/Center", "କେନ୍ଦ୍ର, ଉତ୍ତର ଡାକୋଟା" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "ରିଓ ଗାଲ୍ଲେଗସ୍‌" },
            { "timezone.excity.America/North_Dakota/New_Salem", "ନ୍ୟୁ ସାଲେମ୍, ଉତ୍ତର ଡାକୋଟା" },
        };
        return data;
    }
}
