/*----------------------------------------------------------------------------
                                 typegen
------------------------------------------------------------------------------
  This is a program to create an inttypes.h file for use in building
  Netpbm.  Ordinarily we use the inttypes.h that comes with the C library
  or C compiler, specified by Single Unix Specification.  When that isn't
  available there is usually some other system header file we should use.
  But when there isn't any system header file to define the needed types,
  the file we generate is better than nothing.

  The main problem with the inttypes.h we generate is that when we
  figure out which type is a 32 bit integer, we aren't necessarily using
  the same compile environment as what will actually get used to build
  Netpbm, and thus the one where our inttypes.h will be used.

  Right now, it simply generates either

    typedef int int32_t;

  or

    typedef long int32_t;

  based on which type, int, or long, is 32 bits.

  We also include the uint32_t and int_fast32_t typedefs.

  We also include the multiple inclusion guard ifdef.
-----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>



static void
createTypedefForUint32_t(void) {

    if (sizeof(unsigned int) == 4)
        printf("typedef unsigned int uint32_t;\n");
    else if (sizeof(unsigned long) == 4)
        printf("typedef unsigned long uint32_t;\n");
    else {
        fprintf(stderr, "Cannot find a 32 bit unsigned integer type!\n");
        exit(1);
    }
}



static void
createTypedefForUintFast32_t(void) {

    if (sizeof(unsigned int) == 4)
        printf("typedef unsigned int uint_fast32_t;\n");
    else if (sizeof(unsigned long) == 4)
        printf("typedef unsigned long uint_fast32_t;\n");
    else {
        fprintf(stderr, "Cannot find a 32 bit unsigned integer type!\n");
        exit(1);
    }
}



static void
createTypedefForInt32_t(void) {

    if (sizeof(signed int) == 4)
        printf("typedef signed int int32_t;\n");
    else if (sizeof(signed long) == 4)
        printf("typedef signed long int32_t;\n");
    else {
        fprintf(stderr, "Cannot find a 32 bit signed integer type!\n");
        exit(1);
    }
}



static void
createTypedefForIntFast32_t(void) {

    if (sizeof(signed int) == 4)
        printf("typedef signed int int_fast32_t;\n");
    else if (sizeof(signed long) == 4)
        printf("typedef signed long int_fast32_t;\n");
    else {
        fprintf(stderr, "Cannot find a 32 bit signed integer type!\n");
        exit(1);
    }
}



int
main(int argc, char **argv) {

    printf("/* This was generated by the program 'typegen' */\n");


    printf("#ifndef INTTYPES_H_NETPBM\n");
    printf("#define INTTYPES_H_NETPBM\n");

    createTypedefForUint32_t();
    createTypedefForInt32_t();
    createTypedefForIntFast32_t();
    createTypedefForUintFast32_t();

    printf("#endif\n");

    return 0;
}



