// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub fn ser_document_source(
    object_2: &mut ::aws_smithy_json::serialize::JsonObjectWriter,
    input: &crate::types::DocumentSource,
) -> ::std::result::Result<(), ::aws_smithy_types::error::operation::SerializationError> {
    match input {
        crate::types::DocumentSource::Bytes(inner) => {
            object_2.key("bytes").string_unchecked(&::aws_smithy_types::base64::encode(inner));
        }
        crate::types::DocumentSource::S3Location(inner) => {
            #[allow(unused_mut)]
            let mut object_1 = object_2.key("s3Location").start_object();
            crate::protocol_serde::shape_s3_location::ser_s3_location(&mut object_1, inner)?;
            object_1.finish();
        }
        crate::types::DocumentSource::Text(inner) => {
            object_2.key("text").string(inner.as_str());
        }
        crate::types::DocumentSource::Content(inner) => {
            let mut array_2 = object_2.key("content").start_array();
            for item_3 in inner {
                {
                    #[allow(unused_mut)]
                    let mut object_4 = array_2.value().start_object();
                    crate::protocol_serde::shape_document_content_block::ser_document_content_block(&mut object_4, item_3)?;
                    object_4.finish();
                }
            }
            array_2.finish();
        }
        crate::types::DocumentSource::Unknown => {
            return Err(::aws_smithy_types::error::operation::SerializationError::unknown_variant(
                "DocumentSource",
            ))
        }
    }
    Ok(())
}

pub(crate) fn de_document_source<'a, I>(
    tokens: &mut ::std::iter::Peekable<I>,
) -> ::std::result::Result<Option<crate::types::DocumentSource>, ::aws_smithy_json::deserialize::error::DeserializeError>
where
    I: Iterator<Item = Result<::aws_smithy_json::deserialize::Token<'a>, ::aws_smithy_json::deserialize::error::DeserializeError>>,
{
    let mut variant = None;
    match tokens.next().transpose()? {
        Some(::aws_smithy_json::deserialize::Token::ValueNull { .. }) => return Ok(None),
        Some(::aws_smithy_json::deserialize::Token::StartObject { .. }) => loop {
            match tokens.next().transpose()? {
                Some(::aws_smithy_json::deserialize::Token::EndObject { .. }) => break,
                Some(::aws_smithy_json::deserialize::Token::ObjectKey { key, .. }) => {
                    if let ::std::option::Option::Some(::std::result::Result::Ok(::aws_smithy_json::deserialize::Token::ValueNull { .. })) =
                        tokens.peek()
                    {
                        let _ = tokens.next().expect("peek returned a token")?;
                        continue;
                    }
                    let key = key.to_unescaped()?;
                    if key == "__type" {
                        ::aws_smithy_json::deserialize::token::skip_value(tokens)?;
                        continue;
                    }
                    if variant.is_some() {
                        return Err(::aws_smithy_json::deserialize::error::DeserializeError::custom(
                            "encountered mixed variants in union",
                        ));
                    }
                    variant = match key.as_ref() {
                        "bytes" => Some(crate::types::DocumentSource::Bytes(
                            ::aws_smithy_json::deserialize::token::expect_blob_or_null(tokens.next())?
                                .ok_or_else(|| ::aws_smithy_json::deserialize::error::DeserializeError::custom("value for 'bytes' cannot be null"))?,
                        )),
                        "s3Location" => Some(crate::types::DocumentSource::S3Location(
                            crate::protocol_serde::shape_s3_location::de_s3_location(tokens)?.ok_or_else(|| {
                                ::aws_smithy_json::deserialize::error::DeserializeError::custom("value for 's3Location' cannot be null")
                            })?,
                        )),
                        "text" => Some(crate::types::DocumentSource::Text(
                            ::aws_smithy_json::deserialize::token::expect_string_or_null(tokens.next())?
                                .map(|s| s.to_unescaped().map(|u| u.into_owned()))
                                .transpose()?
                                .ok_or_else(|| ::aws_smithy_json::deserialize::error::DeserializeError::custom("value for 'text' cannot be null"))?,
                        )),
                        "content" => Some(crate::types::DocumentSource::Content(
                            crate::protocol_serde::shape_document_content_blocks::de_document_content_blocks(tokens)?.ok_or_else(|| {
                                ::aws_smithy_json::deserialize::error::DeserializeError::custom("value for 'content' cannot be null")
                            })?,
                        )),
                        _ => {
                            ::aws_smithy_json::deserialize::token::skip_value(tokens)?;
                            Some(crate::types::DocumentSource::Unknown)
                        }
                    };
                }
                other => {
                    return Err(::aws_smithy_json::deserialize::error::DeserializeError::custom(format!(
                        "expected object key or end object, found: {:?}",
                        other
                    )))
                }
            }
        },
        _ => {
            return Err(::aws_smithy_json::deserialize::error::DeserializeError::custom(
                "expected start object or null",
            ))
        }
    }
    if variant.is_none() {
        return Err(::aws_smithy_json::deserialize::error::DeserializeError::custom(
            "Union did not contain a valid variant.",
        ));
    }
    Ok(variant)
}
