
use builtin;
use str;

set edit:completion:arg-completer[pkgcruft] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'pkgcruft'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'pkgcruft'= {
            cand --color 'Controls when to use color'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand completion 'Generate shell completion'
            cand diff 'Compare reports'
            cand ignore 'Show ignore information'
            cand replay 'Replay reports'
            cand scan 'Scan for QA issues'
            cand show 'Show various information'
        }
        &'pkgcruft;completion'= {
            cand -d 'Target directory for completion files'
            cand --dir 'Target directory for completion files'
            cand --color 'Controls when to use color'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pkgcruft;diff'= {
            cand -r 'Restrict by report target'
            cand --reports 'Restrict by report target'
            cand -p 'Package restrictions'
            cand --pkgs 'Package restrictions'
            cand --color 'Controls when to use color'
            cand -s 'Sort reports'
            cand --sort 'Sort reports'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pkgcruft;ignore'= {
            cand --repo 'Target repo'
            cand --color 'Controls when to use color'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pkgcruft;replay'= {
            cand -r 'Restrict by report target'
            cand --reports 'Restrict by report target'
            cand -p 'Package restrictions'
            cand --pkgs 'Package restrictions'
            cand -S 'Restrict by scope'
            cand --scopes 'Restrict by scope'
            cand -R 'Reporter to use'
            cand --reporter 'Reporter to use'
            cand --format 'Format string for the format reporter'
            cand --stats 'Sorting variant for the stats reporter'
            cand --color 'Controls when to use color'
            cand -s 'Sort reports'
            cand --sort 'Sort reports'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pkgcruft;scan'= {
            cand -f 'Enable package filtering'
            cand --filters 'Enable package filtering'
            cand -j 'Parallel jobs to run'
            cand --jobs 'Parallel jobs to run'
            cand --exit 'Exit status triggers'
            cand --repo 'Target repo'
            cand -R 'Reporter to use'
            cand --reporter 'Reporter to use'
            cand --format 'Format string for the format reporter'
            cand --stats 'Sorting variant for the stats reporter'
            cand -r 'Restrict by report target'
            cand --reports 'Restrict by report target'
            cand --color 'Controls when to use color'
            cand -F 'Disregard ignore settings'
            cand --force 'Disregard ignore settings'
            cand -s 'Output reports in sorted order'
            cand --sort 'Output reports in sorted order'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pkgcruft;show'= {
            cand --color 'Controls when to use color'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
            cand checks 'Show checks'
            cand reports 'Show reports'
        }
        &'pkgcruft;show;checks'= {
            cand --repo 'Target repo'
            cand --color 'Controls when to use color'
            cand -i 'Output extended information'
            cand --info 'Output extended information'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pkgcruft;show;reports'= {
            cand --repo 'Target repo'
            cand -r 'Restrict by report target'
            cand --reports 'Restrict by report target'
            cand --color 'Controls when to use color'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
    ]
    $completions[$command]
}
