/// <reference path="./gobject-2.0.d.ts" />
/// <reference path="./glib-2.0.d.ts" />
/// <reference path="./gmodule-2.0.d.ts" />

/**
 * Type Definitions for Gjs (https://gjs.guide/)
 *
 * These type definitions are automatically generated, do not edit them by hand.
 * If you found a bug fix it in `ts-for-gir` or create a bug report on https://github.com/gjsify/ts-for-gir
 *
 * The based EJS template file is used for the generated .d.ts file of each GIR module like Gtk-4.0, GObject-2.0, ...
 */

declare module 'gi://Gio?version=2.0' {
    // Module dependencies
    import type GObject from 'gi://GObject?version=2.0';
    import type GLib from 'gi://GLib?version=2.0';
    import type GModule from 'gi://GModule?version=2.0';

    export namespace Gio {
        /**
         * A convenient helper to create Promise wrappers for asynchronous functions in GJS.
         *
         * This utility replaces the original function on the class prototype with a Promise-based version,
         * allowing the function to be called on any instance of the class, including subclasses.
         * Simply pass the class prototype, the "async" function name, and the "finish" function name as arguments.
         *
         * The function can be used like any other Promise, without the need for a custom wrapper, by leaving out the callback argument.
         * The original function will still be available, and can be used by passing the callback.
         *
         * @param proto - The class prototype that contains the asynchronous function.
         * @param asyncFunc - The name of the asynchronous function.
         * @param finishFunc - The name of the "finish" function that is used to retrieve the result of the asynchronous function.
         *
         * @version Gjs 1.54
         * @see https://gjs.guide/guides/gjs/asynchronous-programming.html#promisify-helper
         *
         * @example
         * ```js
         * import Gio from "gi://Gio?version=2.0";
         *
         * Gio._promisify(Gio.InputStream.prototype, 'read_bytes_async', 'read_bytes_finish');
         *
         * try {
         *    const inputStream = new Gio.UnixInputStream({fd: 0});
         *    const bytes = await inputStream.read_bytes_async(4096, GLib.PRIORITY_DEFAULT, null);
         * } catch (e) {
         *    logError(e, 'Failed to read bytes');
         * }
         * ```
         *
         */
        export function _promisify(proto: any, asyncFunc: string, finishFunc?: string): void;

        /** Temporary Gio.File.prototype fix */
        export const _LocalFilePrototype: typeof File.prototype;

        /**
         * Gio-2.0
         */

        /**
         * An enumeration for well-known message buses.
         */

        /**
         * An enumeration for well-known message buses.
         */
        export namespace BusType {
            export const $gtype: GObject.GType<BusType>;
        }

        enum BusType {
            /**
             * An alias for the message bus that activated the process, if any.
             */
            STARTER,
            /**
             * Not a message bus.
             */
            NONE,
            /**
             * The system-wide message bus.
             */
            SYSTEM,
            /**
             * The login session message bus.
             */
            SESSION,
        }
        /**
         * Results returned from g_converter_convert().
         */

        /**
         * Results returned from g_converter_convert().
         */
        export namespace ConverterResult {
            export const $gtype: GObject.GType<ConverterResult>;
        }

        enum ConverterResult {
            /**
             * There was an error during conversion.
             */
            ERROR,
            /**
             * Some data was consumed or produced
             */
            CONVERTED,
            /**
             * The conversion is finished
             */
            FINISHED,
            /**
             * Flushing is finished
             */
            FLUSHED,
        }
        /**
         * Enumeration describing different kinds of native credential types.
         */

        /**
         * Enumeration describing different kinds of native credential types.
         */
        export namespace CredentialsType {
            export const $gtype: GObject.GType<CredentialsType>;
        }

        enum CredentialsType {
            /**
             * Indicates an invalid native credential type.
             */
            INVALID,
            /**
             * The native credentials type is a `struct ucred`.
             */
            LINUX_UCRED,
            /**
             * The native credentials type is a `struct cmsgcred`.
             */
            FREEBSD_CMSGCRED,
            /**
             * The native credentials type is a `struct sockpeercred`. Added in 2.30.
             */
            OPENBSD_SOCKPEERCRED,
            /**
             * The native credentials type is a `ucred_t`. Added in 2.40.
             */
            SOLARIS_UCRED,
            /**
             * The native credentials type is a `struct unpcbid`. Added in 2.42.
             */
            NETBSD_UNPCBID,
            /**
             * The native credentials type is a `struct xucred`. Added in 2.66.
             */
            APPLE_XUCRED,
            /**
             * The native credentials type is a PID `DWORD`. Added in 2.72.
             */
            WIN32_PID,
        }
        /**
         * Error codes for the %G_DBUS_ERROR error domain.
         */
        class DBusError extends GLib.Error {
            static $gtype: GObject.GType<DBusError>;

            // Static fields

            /**
             * A generic error; "something went wrong" - see the error message for
             * more.
             */
            static FAILED: number;
            /**
             * There was not enough memory to complete an operation.
             */
            static NO_MEMORY: number;
            /**
             * The bus doesn't know how to launch a service to supply the bus name
             * you wanted.
             */
            static SERVICE_UNKNOWN: number;
            /**
             * The bus name you referenced doesn't exist (i.e. no application owns
             * it).
             */
            static NAME_HAS_NO_OWNER: number;
            /**
             * No reply to a message expecting one, usually means a timeout occurred.
             */
            static NO_REPLY: number;
            /**
             * Something went wrong reading or writing to a socket, for example.
             */
            static IO_ERROR: number;
            /**
             * A D-Bus bus address was malformed.
             */
            static BAD_ADDRESS: number;
            /**
             * Requested operation isn't supported (like ENOSYS on UNIX).
             */
            static NOT_SUPPORTED: number;
            /**
             * Some limited resource is exhausted.
             */
            static LIMITS_EXCEEDED: number;
            /**
             * Security restrictions don't allow doing what you're trying to do.
             */
            static ACCESS_DENIED: number;
            /**
             * Authentication didn't work.
             */
            static AUTH_FAILED: number;
            /**
             * Unable to connect to server (probably caused by ECONNREFUSED on a
             * socket).
             */
            static NO_SERVER: number;
            /**
             * Certain timeout errors, possibly ETIMEDOUT on a socket.  Note that
             * %G_DBUS_ERROR_NO_REPLY is used for message reply timeouts. Warning:
             * this is confusingly-named given that %G_DBUS_ERROR_TIMED_OUT also
             * exists. We can't fix it for compatibility reasons so just be
             * careful.
             */
            static TIMEOUT: number;
            /**
             * No network access (probably ENETUNREACH on a socket).
             */
            static NO_NETWORK: number;
            /**
             * Can't bind a socket since its address is in use (i.e. EADDRINUSE).
             */
            static ADDRESS_IN_USE: number;
            /**
             * The connection is disconnected and you're trying to use it.
             */
            static DISCONNECTED: number;
            /**
             * Invalid arguments passed to a method call.
             */
            static INVALID_ARGS: number;
            /**
             * Missing file.
             */
            static FILE_NOT_FOUND: number;
            /**
             * Existing file and the operation you're using does not silently overwrite.
             */
            static FILE_EXISTS: number;
            /**
             * Method name you invoked isn't known by the object you invoked it on.
             */
            static UNKNOWN_METHOD: number;
            /**
             * Certain timeout errors, e.g. while starting a service. Warning: this is
             * confusingly-named given that %G_DBUS_ERROR_TIMEOUT also exists. We
             * can't fix it for compatibility reasons so just be careful.
             */
            static TIMED_OUT: number;
            /**
             * Tried to remove or modify a match rule that didn't exist.
             */
            static MATCH_RULE_NOT_FOUND: number;
            /**
             * The match rule isn't syntactically valid.
             */
            static MATCH_RULE_INVALID: number;
            /**
             * While starting a new process, the exec() call failed.
             */
            static SPAWN_EXEC_FAILED: number;
            /**
             * While starting a new process, the fork() call failed.
             */
            static SPAWN_FORK_FAILED: number;
            /**
             * While starting a new process, the child exited with a status code.
             */
            static SPAWN_CHILD_EXITED: number;
            /**
             * While starting a new process, the child exited on a signal.
             */
            static SPAWN_CHILD_SIGNALED: number;
            /**
             * While starting a new process, something went wrong.
             */
            static SPAWN_FAILED: number;
            /**
             * We failed to setup the environment correctly.
             */
            static SPAWN_SETUP_FAILED: number;
            /**
             * We failed to setup the config parser correctly.
             */
            static SPAWN_CONFIG_INVALID: number;
            /**
             * Bus name was not valid.
             */
            static SPAWN_SERVICE_INVALID: number;
            /**
             * Service file not found in system-services directory.
             */
            static SPAWN_SERVICE_NOT_FOUND: number;
            /**
             * Permissions are incorrect on the setuid helper.
             */
            static SPAWN_PERMISSIONS_INVALID: number;
            /**
             * Service file invalid (Name, User or Exec missing).
             */
            static SPAWN_FILE_INVALID: number;
            /**
             * Tried to get a UNIX process ID and it wasn't available.
             */
            static SPAWN_NO_MEMORY: number;
            /**
             * Tried to get a UNIX process ID and it wasn't available.
             */
            static UNIX_PROCESS_ID_UNKNOWN: number;
            /**
             * A type signature is not valid.
             */
            static INVALID_SIGNATURE: number;
            /**
             * A file contains invalid syntax or is otherwise broken.
             */
            static INVALID_FILE_CONTENT: number;
            /**
             * Asked for SELinux security context and it wasn't available.
             */
            static SELINUX_SECURITY_CONTEXT_UNKNOWN: number;
            /**
             * Asked for ADT audit data and it wasn't available.
             */
            static ADT_AUDIT_DATA_UNKNOWN: number;
            /**
             * There's already an object with the requested object path.
             */
            static OBJECT_PATH_IN_USE: number;
            /**
             * Object you invoked a method on isn't known. Since 2.42
             */
            static UNKNOWN_OBJECT: number;
            /**
             * Interface you invoked a method on isn't known by the object. Since 2.42
             */
            static UNKNOWN_INTERFACE: number;
            /**
             * Property you tried to access isn't known by the object. Since 2.42
             */
            static UNKNOWN_PROPERTY: number;
            /**
             * Property you tried to set is read-only. Since 2.42
             */
            static PROPERTY_READ_ONLY: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            /**
             * Creates a D-Bus error name to use for `error`. If `error` matches
             * a registered error (cf. g_dbus_error_register_error()), the corresponding
             * D-Bus error name will be returned.
             *
             * Otherwise the a name of the form
             * `org.gtk.GDBus.UnmappedGError.Quark._ESCAPED_QUARK_NAME.Code_ERROR_CODE`
             * will be used. This allows other GDBus applications to map the error
             * on the wire back to a #GError using g_dbus_error_new_for_dbus_error().
             *
             * This function is typically only used in object mappings to put a
             * #GError on the wire. Regular applications should not use it.
             * @param error A #GError.
             */
            static encode_gerror(error: GLib.Error): string;
            /**
             * Gets the D-Bus error name used for `error,` if any.
             *
             * This function is guaranteed to return a D-Bus error name for all
             * #GErrors returned from functions handling remote method calls
             * (e.g. g_dbus_connection_call_finish()) unless
             * g_dbus_error_strip_remote_error() has been used on `error`.
             * @param error a #GError
             */
            static get_remote_error(error: GLib.Error): string | null;
            /**
             * Checks if `error` represents an error received via D-Bus from a remote peer. If so,
             * use g_dbus_error_get_remote_error() to get the name of the error.
             * @param error A #GError.
             */
            static is_remote_error(error: GLib.Error): boolean;
            /**
             * Creates a #GError based on the contents of `dbus_error_name` and
             * `dbus_error_message`.
             *
             * Errors registered with g_dbus_error_register_error() will be looked
             * up using `dbus_error_name` and if a match is found, the error domain
             * and code is used. Applications can use g_dbus_error_get_remote_error()
             * to recover `dbus_error_name`.
             *
             * If a match against a registered error is not found and the D-Bus
             * error name is in a form as returned by g_dbus_error_encode_gerror()
             * the error domain and code encoded in the name is used to
             * create the #GError. Also, `dbus_error_name` is added to the error message
             * such that it can be recovered with g_dbus_error_get_remote_error().
             *
             * Otherwise, a #GError with the error code %G_IO_ERROR_DBUS_ERROR
             * in the %G_IO_ERROR error domain is returned. Also, `dbus_error_name` is
             * added to the error message such that it can be recovered with
             * g_dbus_error_get_remote_error().
             *
             * In all three cases, `dbus_error_name` can always be recovered from the
             * returned #GError using the g_dbus_error_get_remote_error() function
             * (unless g_dbus_error_strip_remote_error() hasn't been used on the returned error).
             *
             * This function is typically only used in object mappings to prepare
             * #GError instances for applications. Regular applications should not use
             * it.
             * @param dbus_error_name D-Bus error name.
             * @param dbus_error_message D-Bus error message.
             */
            static new_for_dbus_error(dbus_error_name: string, dbus_error_message: string): GLib.Error;
            static quark(): GLib.Quark;
            /**
             * Creates an association to map between `dbus_error_name` and
             * #GErrors specified by `error_domain` and `error_code`.
             *
             * This is typically done in the routine that returns the #GQuark for
             * an error domain.
             * @param error_domain A #GQuark for an error domain.
             * @param error_code An error code.
             * @param dbus_error_name A D-Bus error name.
             */
            static register_error(error_domain: GLib.Quark, error_code: number, dbus_error_name: string): boolean;
            /**
             * Helper function for associating a #GError error domain with D-Bus error names.
             *
             * While `quark_volatile` has a `volatile` qualifier, this is a historical
             * artifact and the argument passed to it should not be `volatile`.
             * @param error_domain_quark_name The error domain name.
             * @param quark_volatile A pointer where to store the #GQuark.
             * @param entries A pointer to @num_entries #GDBusErrorEntry struct items.
             */
            static register_error_domain(
                error_domain_quark_name: string,
                quark_volatile: number,
                entries: DBusErrorEntry[],
            ): void;
            /**
             * Does nothing if `error` is %NULL. Otherwise sets `*error` to
             * a new #GError created with g_dbus_error_new_for_dbus_error()
             * with `dbus_error_message` prepend with `format` (unless %NULL).
             * @param error A pointer to a #GError or %NULL.
             * @param dbus_error_name D-Bus error name.
             * @param dbus_error_message D-Bus error message.
             * @param format printf()-style format to prepend to @dbus_error_message or %NULL.
             * @param ___ Arguments for @format.
             */
            static set_dbus_error(
                error: GLib.Error,
                dbus_error_name: string,
                dbus_error_message: string,
                format: string | null,
                ___: any[],
            ): void;
            /**
             * Like g_dbus_error_set_dbus_error() but intended for language bindings.
             * @param error A pointer to a #GError or %NULL.
             * @param dbus_error_name D-Bus error name.
             * @param dbus_error_message D-Bus error message.
             * @param format printf()-style format to prepend to @dbus_error_message or %NULL.
             * @param var_args Arguments for @format.
             */
            static set_dbus_error_valist(
                error: GLib.Error,
                dbus_error_name: string,
                dbus_error_message: string,
                format: string | null,
                var_args: any,
            ): void;
            /**
             * Looks for extra information in the error message used to recover
             * the D-Bus error name and strips it if found. If stripped, the
             * message field in `error` will correspond exactly to what was
             * received on the wire.
             *
             * This is typically used when presenting errors to the end user.
             * @param error A #GError.
             */
            static strip_remote_error(error: GLib.Error): boolean;
            /**
             * Destroys an association previously set up with g_dbus_error_register_error().
             * @param error_domain A #GQuark for an error domain.
             * @param error_code An error code.
             * @param dbus_error_name A D-Bus error name.
             */
            static unregister_error(error_domain: GLib.Quark, error_code: number, dbus_error_name: string): boolean;
        }

        /**
         * Enumeration used to describe the byte order of a D-Bus message.
         */

        /**
         * Enumeration used to describe the byte order of a D-Bus message.
         */
        export namespace DBusMessageByteOrder {
            export const $gtype: GObject.GType<DBusMessageByteOrder>;
        }

        enum DBusMessageByteOrder {
            /**
             * The byte order is big endian.
             */
            BIG_ENDIAN,
            /**
             * The byte order is little endian.
             */
            LITTLE_ENDIAN,
        }
        /**
         * Header fields used in #GDBusMessage.
         */

        /**
         * Header fields used in #GDBusMessage.
         */
        export namespace DBusMessageHeaderField {
            export const $gtype: GObject.GType<DBusMessageHeaderField>;
        }

        enum DBusMessageHeaderField {
            /**
             * Not a valid header field.
             */
            INVALID,
            /**
             * The object path.
             */
            PATH,
            /**
             * The interface name.
             */
            INTERFACE,
            /**
             * The method or signal name.
             */
            MEMBER,
            /**
             * The name of the error that occurred.
             */
            ERROR_NAME,
            /**
             * The serial number the message is a reply to.
             */
            REPLY_SERIAL,
            /**
             * The name the message is intended for.
             */
            DESTINATION,
            /**
             * Unique name of the sender of the message (filled in by the bus).
             */
            SENDER,
            /**
             * The signature of the message body.
             */
            SIGNATURE,
            /**
             * The number of UNIX file descriptors that accompany the message.
             */
            NUM_UNIX_FDS,
        }
        /**
         * Message types used in #GDBusMessage.
         */

        /**
         * Message types used in #GDBusMessage.
         */
        export namespace DBusMessageType {
            export const $gtype: GObject.GType<DBusMessageType>;
        }

        enum DBusMessageType {
            /**
             * Message is of invalid type.
             */
            INVALID,
            /**
             * Method call.
             */
            METHOD_CALL,
            /**
             * Method reply.
             */
            METHOD_RETURN,
            /**
             * Error reply.
             */
            ERROR,
            /**
             * Signal emission.
             */
            SIGNAL,
        }
        /**
         * #GDataStreamByteOrder is used to ensure proper endianness of streaming data sources
         * across various machine architectures.
         */

        /**
         * #GDataStreamByteOrder is used to ensure proper endianness of streaming data sources
         * across various machine architectures.
         */
        export namespace DataStreamByteOrder {
            export const $gtype: GObject.GType<DataStreamByteOrder>;
        }

        enum DataStreamByteOrder {
            /**
             * Selects Big Endian byte order.
             */
            BIG_ENDIAN,
            /**
             * Selects Little Endian byte order.
             */
            LITTLE_ENDIAN,
            /**
             * Selects endianness based on host machine's architecture.
             */
            HOST_ENDIAN,
        }
        /**
         * #GDataStreamNewlineType is used when checking for or setting the line endings for a given file.
         */

        /**
         * #GDataStreamNewlineType is used when checking for or setting the line endings for a given file.
         */
        export namespace DataStreamNewlineType {
            export const $gtype: GObject.GType<DataStreamNewlineType>;
        }

        enum DataStreamNewlineType {
            /**
             * Selects "LF" line endings, common on most modern UNIX platforms.
             */
            LF,
            /**
             * Selects "CR" line endings.
             */
            CR,
            /**
             * Selects "CR, LF" line ending, common on Microsoft Windows.
             */
            CR_LF,
            /**
             * Automatically try to handle any line ending type.
             */
            ANY,
        }
        /**
         * Enumeration describing how a drive can be started/stopped.
         */

        /**
         * Enumeration describing how a drive can be started/stopped.
         */
        export namespace DriveStartStopType {
            export const $gtype: GObject.GType<DriveStartStopType>;
        }

        enum DriveStartStopType {
            /**
             * Unknown or drive doesn't support
             *    start/stop.
             */
            UNKNOWN,
            /**
             * The stop method will physically
             *    shut down the drive and e.g. power down the port the drive is
             *    attached to.
             */
            SHUTDOWN,
            /**
             * The start/stop methods are used
             *    for connecting/disconnect to the drive over the network.
             */
            NETWORK,
            /**
             * The start/stop methods will
             *    assemble/disassemble a virtual drive from several physical
             *    drives.
             */
            MULTIDISK,
            /**
             * The start/stop methods will
             *    unlock/lock the disk (for example using the ATA `SECURITY UNLOCK
             *    DEVICE` command)
             */
            PASSWORD,
        }
        /**
         * GEmblemOrigin is used to add information about the origin of the emblem
         * to #GEmblem.
         */

        /**
         * GEmblemOrigin is used to add information about the origin of the emblem
         * to #GEmblem.
         */
        export namespace EmblemOrigin {
            export const $gtype: GObject.GType<EmblemOrigin>;
        }

        enum EmblemOrigin {
            /**
             * Emblem of unknown origin
             */
            UNKNOWN,
            /**
             * Emblem adds device-specific information
             */
            DEVICE,
            /**
             * Emblem depicts live metadata, such as "readonly"
             */
            LIVEMETADATA,
            /**
             * Emblem comes from a user-defined tag, e.g. set by nautilus (in the future)
             */
            TAG,
        }
        /**
         * Used by g_file_set_attributes_from_info() when setting file attributes.
         */

        /**
         * Used by g_file_set_attributes_from_info() when setting file attributes.
         */
        export namespace FileAttributeStatus {
            export const $gtype: GObject.GType<FileAttributeStatus>;
        }

        enum FileAttributeStatus {
            /**
             * Attribute value is unset (empty).
             */
            UNSET,
            /**
             * Attribute value is set.
             */
            SET,
            /**
             * Indicates an error in setting the value.
             */
            ERROR_SETTING,
        }
        /**
         * The data types for file attributes.
         */

        /**
         * The data types for file attributes.
         */
        export namespace FileAttributeType {
            export const $gtype: GObject.GType<FileAttributeType>;
        }

        enum FileAttributeType {
            /**
             * indicates an invalid or uninitialized type.
             */
            INVALID,
            /**
             * a null terminated UTF8 string.
             */
            STRING,
            /**
             * a zero terminated string of non-zero bytes.
             */
            BYTE_STRING,
            /**
             * a boolean value.
             */
            BOOLEAN,
            /**
             * an unsigned 4-byte/32-bit integer.
             */
            UINT32,
            /**
             * a signed 4-byte/32-bit integer.
             */
            INT32,
            /**
             * an unsigned 8-byte/64-bit integer.
             */
            UINT64,
            /**
             * a signed 8-byte/64-bit integer.
             */
            INT64,
            /**
             * a #GObject.
             */
            OBJECT,
            /**
             * a %NULL terminated char **. Since 2.22
             */
            STRINGV,
        }
        /**
         * Specifies what type of event a monitor event is.
         */

        /**
         * Specifies what type of event a monitor event is.
         */
        export namespace FileMonitorEvent {
            export const $gtype: GObject.GType<FileMonitorEvent>;
        }

        enum FileMonitorEvent {
            /**
             * a file changed.
             */
            CHANGED,
            /**
             * a hint that this was probably the last change in a set of changes.
             */
            CHANGES_DONE_HINT,
            /**
             * a file was deleted.
             */
            DELETED,
            /**
             * a file was created.
             */
            CREATED,
            /**
             * a file attribute was changed.
             */
            ATTRIBUTE_CHANGED,
            /**
             * the file location will soon be unmounted.
             */
            PRE_UNMOUNT,
            /**
             * the file location was unmounted.
             */
            UNMOUNTED,
            /**
             * the file was moved -- only sent if the
             *   (deprecated) %G_FILE_MONITOR_SEND_MOVED flag is set
             */
            MOVED,
            /**
             * the file was renamed within the
             *   current directory -- only sent if the %G_FILE_MONITOR_WATCH_MOVES
             *   flag is set.  Since: 2.46.
             */
            RENAMED,
            /**
             * the file was moved into the
             *   monitored directory from another location -- only sent if the
             *   %G_FILE_MONITOR_WATCH_MOVES flag is set.  Since: 2.46.
             */
            MOVED_IN,
            /**
             * the file was moved out of the
             *   monitored directory to another location -- only sent if the
             *   %G_FILE_MONITOR_WATCH_MOVES flag is set.  Since: 2.46
             */
            MOVED_OUT,
        }
        /**
         * Indicates the file's on-disk type.
         *
         * On Windows systems a file will never have %G_FILE_TYPE_SYMBOLIC_LINK type;
         * use #GFileInfo and %G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK to determine
         * whether a file is a symlink or not. This is due to the fact that NTFS does
         * not have a single filesystem object type for symbolic links - it has
         * files that symlink to files, and directories that symlink to directories.
         * #GFileType enumeration cannot precisely represent this important distinction,
         * which is why all Windows symlinks will continue to be reported as
         * %G_FILE_TYPE_REGULAR or %G_FILE_TYPE_DIRECTORY.
         */

        /**
         * Indicates the file's on-disk type.
         *
         * On Windows systems a file will never have %G_FILE_TYPE_SYMBOLIC_LINK type;
         * use #GFileInfo and %G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK to determine
         * whether a file is a symlink or not. This is due to the fact that NTFS does
         * not have a single filesystem object type for symbolic links - it has
         * files that symlink to files, and directories that symlink to directories.
         * #GFileType enumeration cannot precisely represent this important distinction,
         * which is why all Windows symlinks will continue to be reported as
         * %G_FILE_TYPE_REGULAR or %G_FILE_TYPE_DIRECTORY.
         */
        export namespace FileType {
            export const $gtype: GObject.GType<FileType>;
        }

        enum FileType {
            /**
             * File's type is unknown.
             */
            UNKNOWN,
            /**
             * File handle represents a regular file.
             */
            REGULAR,
            /**
             * File handle represents a directory.
             */
            DIRECTORY,
            /**
             * File handle represents a symbolic link
             *    (Unix systems).
             */
            SYMBOLIC_LINK,
            /**
             * File is a "special" file, such as a socket, fifo,
             *    block device, or character device.
             */
            SPECIAL,
            /**
             * File is a shortcut (Windows systems).
             */
            SHORTCUT,
            /**
             * File is a mountable location.
             */
            MOUNTABLE,
        }
        /**
         * Indicates a hint from the file system whether files should be
         * previewed in a file manager. Returned as the value of the key
         * %G_FILE_ATTRIBUTE_FILESYSTEM_USE_PREVIEW.
         */

        /**
         * Indicates a hint from the file system whether files should be
         * previewed in a file manager. Returned as the value of the key
         * %G_FILE_ATTRIBUTE_FILESYSTEM_USE_PREVIEW.
         */
        export namespace FilesystemPreviewType {
            export const $gtype: GObject.GType<FilesystemPreviewType>;
        }

        enum FilesystemPreviewType {
            /**
             * Only preview files if user has explicitly requested it.
             */
            IF_ALWAYS,
            /**
             * Preview files if user has requested preview of "local" files.
             */
            IF_LOCAL,
            /**
             * Never preview files.
             */
            NEVER,
        }
        /**
         * Error codes returned by GIO functions.
         *
         * Note that this domain may be extended in future GLib releases. In
         * general, new error codes either only apply to new APIs, or else
         * replace %G_IO_ERROR_FAILED in cases that were not explicitly
         * distinguished before. You should therefore avoid writing code like
         *
         * ```c
         * if (g_error_matches (error, G_IO_ERROR, G_IO_ERROR_FAILED))
         *   {
         *     // Assume that this is EPRINTERONFIRE
         *     ...
         *   }
         * ```
         *
         * but should instead treat all unrecognized error codes the same as
         * %G_IO_ERROR_FAILED.
         *
         * See also #GPollableReturn for a cheaper way of returning
         * %G_IO_ERROR_WOULD_BLOCK to callers without allocating a #GError.
         */
        class IOErrorEnum extends GLib.Error {
            static $gtype: GObject.GType<IOErrorEnum>;

            // Static fields

            /**
             * Generic error condition for when an operation fails
             *     and no more specific #GIOErrorEnum value is defined.
             */
            static FAILED: number;
            /**
             * File not found.
             */
            static NOT_FOUND: number;
            /**
             * File already exists.
             */
            static EXISTS: number;
            /**
             * File is a directory.
             */
            static IS_DIRECTORY: number;
            /**
             * File is not a directory.
             */
            static NOT_DIRECTORY: number;
            /**
             * File is a directory that isn't empty.
             */
            static NOT_EMPTY: number;
            /**
             * File is not a regular file.
             */
            static NOT_REGULAR_FILE: number;
            /**
             * File is not a symbolic link.
             */
            static NOT_SYMBOLIC_LINK: number;
            /**
             * File cannot be mounted.
             */
            static NOT_MOUNTABLE_FILE: number;
            /**
             * Filename is too many characters.
             */
            static FILENAME_TOO_LONG: number;
            /**
             * Filename is invalid or contains invalid characters.
             */
            static INVALID_FILENAME: number;
            /**
             * File contains too many symbolic links.
             */
            static TOO_MANY_LINKS: number;
            /**
             * No space left on drive.
             */
            static NO_SPACE: number;
            /**
             * Invalid argument.
             */
            static INVALID_ARGUMENT: number;
            /**
             * Permission denied.
             */
            static PERMISSION_DENIED: number;
            /**
             * Operation (or one of its parameters) not supported
             */
            static NOT_SUPPORTED: number;
            /**
             * File isn't mounted.
             */
            static NOT_MOUNTED: number;
            /**
             * File is already mounted.
             */
            static ALREADY_MOUNTED: number;
            /**
             * File was closed.
             */
            static CLOSED: number;
            /**
             * Operation was cancelled. See #GCancellable.
             */
            static CANCELLED: number;
            /**
             * Operations are still pending.
             */
            static PENDING: number;
            /**
             * File is read only.
             */
            static READ_ONLY: number;
            /**
             * Backup couldn't be created.
             */
            static CANT_CREATE_BACKUP: number;
            /**
             * File's Entity Tag was incorrect.
             */
            static WRONG_ETAG: number;
            /**
             * Operation timed out.
             */
            static TIMED_OUT: number;
            /**
             * Operation would be recursive.
             */
            static WOULD_RECURSE: number;
            /**
             * File is busy.
             */
            static BUSY: number;
            /**
             * Operation would block.
             */
            static WOULD_BLOCK: number;
            /**
             * Host couldn't be found (remote operations).
             */
            static HOST_NOT_FOUND: number;
            /**
             * Operation would merge files.
             */
            static WOULD_MERGE: number;
            /**
             * Operation failed and a helper program has
             *     already interacted with the user. Do not display any error dialog.
             */
            static FAILED_HANDLED: number;
            /**
             * The current process has too many files
             *     open and can't open any more. Duplicate descriptors do count toward
             *     this limit. Since 2.20
             */
            static TOO_MANY_OPEN_FILES: number;
            /**
             * The object has not been initialized. Since 2.22
             */
            static NOT_INITIALIZED: number;
            /**
             * The requested address is already in use. Since 2.22
             */
            static ADDRESS_IN_USE: number;
            /**
             * Need more input to finish operation. Since 2.24
             */
            static PARTIAL_INPUT: number;
            /**
             * The input data was invalid. Since 2.24
             */
            static INVALID_DATA: number;
            /**
             * A remote object generated an error that
             *     doesn't correspond to a locally registered #GError error
             *     domain. Use g_dbus_error_get_remote_error() to extract the D-Bus
             *     error name and g_dbus_error_strip_remote_error() to fix up the
             *     message so it matches what was received on the wire. Since 2.26.
             */
            static DBUS_ERROR: number;
            /**
             * Host unreachable. Since 2.26
             */
            static HOST_UNREACHABLE: number;
            /**
             * Network unreachable. Since 2.26
             */
            static NETWORK_UNREACHABLE: number;
            /**
             * Connection refused. Since 2.26
             */
            static CONNECTION_REFUSED: number;
            /**
             * Connection to proxy server failed. Since 2.26
             */
            static PROXY_FAILED: number;
            /**
             * Proxy authentication failed. Since 2.26
             */
            static PROXY_AUTH_FAILED: number;
            /**
             * Proxy server needs authentication. Since 2.26
             */
            static PROXY_NEED_AUTH: number;
            /**
             * Proxy connection is not allowed by ruleset.
             *     Since 2.26
             */
            static PROXY_NOT_ALLOWED: number;
            /**
             * Broken pipe. Since 2.36
             */
            static BROKEN_PIPE: number;
            /**
             * Connection closed by peer. Note that this
             *     is the same code as %G_IO_ERROR_BROKEN_PIPE; before 2.44 some
             *     "connection closed" errors returned %G_IO_ERROR_BROKEN_PIPE, but others
             *     returned %G_IO_ERROR_FAILED. Now they should all return the same
             *     value, which has this more logical name. Since 2.44.
             */
            static CONNECTION_CLOSED: number;
            /**
             * Transport endpoint is not connected. Since 2.44
             */
            static NOT_CONNECTED: number;
            /**
             * Message too large. Since 2.48.
             */
            static MESSAGE_TOO_LARGE: number;
            /**
             * No such device found. Since 2.74
             */
            static NO_SUCH_DEVICE: number;
            /**
             * Destination address unset. Since 2.80
             */
            static DESTINATION_UNSET: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;
        }

        /**
         * Flags for use with g_io_module_scope_new().
         */

        /**
         * Flags for use with g_io_module_scope_new().
         */
        export namespace IOModuleScopeFlags {
            export const $gtype: GObject.GType<IOModuleScopeFlags>;
        }

        enum IOModuleScopeFlags {
            /**
             * No module scan flags
             */
            NONE,
            /**
             * When using this scope to load or
             *     scan modules, automatically block a modules which has the same base
             *     basename as previously loaded module.
             */
            BLOCK_DUPLICATES,
        }
        /**
         * Memory availability warning levels.
         *
         * Note that because new values might be added, it is recommended that applications check
         * #GMemoryMonitorWarningLevel as ranges, for example:
         *
         * ```c
         * if (warning_level > G_MEMORY_MONITOR_WARNING_LEVEL_LOW)
         *   drop_caches ();
         * ```
         *
         */

        /**
         * Memory availability warning levels.
         *
         * Note that because new values might be added, it is recommended that applications check
         * #GMemoryMonitorWarningLevel as ranges, for example:
         *
         * ```c
         * if (warning_level > G_MEMORY_MONITOR_WARNING_LEVEL_LOW)
         *   drop_caches ();
         * ```
         *
         */
        export namespace MemoryMonitorWarningLevel {
            export const $gtype: GObject.GType<MemoryMonitorWarningLevel>;
        }

        enum MemoryMonitorWarningLevel {
            /**
             * Memory on the device is low, processes
             *   should free up unneeded resources (for example, in-memory caches) so they can
             *   be used elsewhere.
             */
            LOW,
            /**
             * Same as `G_MEMORY_MONITOR_WARNING_LEVEL_LOW`
             *   but the device has even less free memory, so processes should try harder to free
             *   up unneeded resources. If your process does not need to stay running, it is a
             *   good time for it to quit.
             */
            MEDIUM,
            /**
             * The system will soon start terminating
             *   processes to reclaim memory, including background processes.
             */
            CRITICAL,
        }
        /**
         * #GMountOperationResult is returned as a result when a request for
         * information is send by the mounting operation.
         */

        /**
         * #GMountOperationResult is returned as a result when a request for
         * information is send by the mounting operation.
         */
        export namespace MountOperationResult {
            export const $gtype: GObject.GType<MountOperationResult>;
        }

        enum MountOperationResult {
            /**
             * The request was fulfilled and the
             *     user specified data is now available
             */
            HANDLED,
            /**
             * The user requested the mount operation
             *     to be aborted
             */
            ABORTED,
            /**
             * The request was unhandled (i.e. not
             *     implemented)
             */
            UNHANDLED,
        }
        /**
         * The host's network connectivity state, as reported by #GNetworkMonitor.
         */

        /**
         * The host's network connectivity state, as reported by #GNetworkMonitor.
         */
        export namespace NetworkConnectivity {
            export const $gtype: GObject.GType<NetworkConnectivity>;
        }

        enum NetworkConnectivity {
            /**
             * The host is not configured with a
             *   route to the Internet; it may or may not be connected to a local
             *   network.
             */
            LOCAL,
            /**
             * The host is connected to a network, but
             *   does not appear to be able to reach the full Internet, perhaps
             *   due to upstream network problems.
             */
            LIMITED,
            /**
             * The host is behind a captive portal and
             *   cannot reach the full Internet.
             */
            PORTAL,
            /**
             * The host is connected to a network, and
             *   appears to be able to reach the full Internet.
             */
            FULL,
        }
        /**
         * Priority levels for #GNotifications.
         */

        /**
         * Priority levels for #GNotifications.
         */
        export namespace NotificationPriority {
            export const $gtype: GObject.GType<NotificationPriority>;
        }

        enum NotificationPriority {
            /**
             * the default priority, to be used for the
             *   majority of notifications (for example email messages, software updates,
             *   completed download/sync operations)
             */
            NORMAL,
            /**
             * for notifications that do not require
             *   immediate attention - typically used for contextual background
             *   information, such as contact birthdays or local weather
             */
            LOW,
            /**
             * for events that require more attention,
             *   usually because responses are time-sensitive (for example chat and SMS
             *   messages or alarms)
             */
            HIGH,
            /**
             * for urgent notifications, or notifications
             *   that require a response in a short space of time (for example phone calls
             *   or emergency warnings)
             */
            URGENT,
        }
        /**
         * #GPasswordSave is used to indicate the lifespan of a saved password.
         *
         * #Gvfs stores passwords in the Gnome keyring when this flag allows it
         * to, and later retrieves it again from there.
         */

        /**
         * #GPasswordSave is used to indicate the lifespan of a saved password.
         *
         * #Gvfs stores passwords in the Gnome keyring when this flag allows it
         * to, and later retrieves it again from there.
         */
        export namespace PasswordSave {
            export const $gtype: GObject.GType<PasswordSave>;
        }

        enum PasswordSave {
            /**
             * never save a password.
             */
            NEVER,
            /**
             * save a password for the session.
             */
            FOR_SESSION,
            /**
             * save a password permanently.
             */
            PERMANENTLY,
        }
        /**
         * Return value for various IO operations that signal errors via the
         * return value and not necessarily via a #GError.
         *
         * This enum exists to be able to return errors to callers without having to
         * allocate a #GError. Allocating #GErrors can be quite expensive for
         * regularly happening errors like %G_IO_ERROR_WOULD_BLOCK.
         *
         * In case of %G_POLLABLE_RETURN_FAILED a #GError should be set for the
         * operation to give details about the error that happened.
         */

        /**
         * Return value for various IO operations that signal errors via the
         * return value and not necessarily via a #GError.
         *
         * This enum exists to be able to return errors to callers without having to
         * allocate a #GError. Allocating #GErrors can be quite expensive for
         * regularly happening errors like %G_IO_ERROR_WOULD_BLOCK.
         *
         * In case of %G_POLLABLE_RETURN_FAILED a #GError should be set for the
         * operation to give details about the error that happened.
         */
        export namespace PollableReturn {
            export const $gtype: GObject.GType<PollableReturn>;
        }

        enum PollableReturn {
            /**
             * Generic error condition for when an operation fails.
             */
            FAILED,
            /**
             * The operation was successfully finished.
             */
            OK,
            /**
             * The operation would block.
             */
            WOULD_BLOCK,
        }
        /**
         * An error code used with %G_RESOLVER_ERROR in a #GError returned
         * from a #GResolver routine.
         */
        class ResolverError extends GLib.Error {
            static $gtype: GObject.GType<ResolverError>;

            // Static fields

            /**
             * the requested name/address/service was not
             *     found
             */
            static NOT_FOUND: number;
            /**
             * the requested information could not
             *     be looked up due to a network error or similar problem
             */
            static TEMPORARY_FAILURE: number;
            /**
             * unknown error
             */
            static INTERNAL: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            /**
             * Gets the #GResolver Error Quark.
             */
            static quark(): GLib.Quark;
        }

        /**
         * The type of record that g_resolver_lookup_records() or
         * g_resolver_lookup_records_async() should retrieve. The records are returned
         * as lists of #GVariant tuples. Each record type has different values in
         * the variant tuples returned.
         *
         * %G_RESOLVER_RECORD_SRV records are returned as variants with the signature
         * `(qqqs)`, containing a `guint16` with the priority, a `guint16` with the
         * weight, a `guint16` with the port, and a string of the hostname.
         *
         * %G_RESOLVER_RECORD_MX records are returned as variants with the signature
         * `(qs)`, representing a `guint16` with the preference, and a string containing
         * the mail exchanger hostname.
         *
         * %G_RESOLVER_RECORD_TXT records are returned as variants with the signature
         * `(as)`, representing an array of the strings in the text record. Note: Most TXT
         * records only contain a single string, but
         * [RFC 1035](https://tools.ietf.org/html/rfc1035#section-3.3.14) does allow a
         * record to contain multiple strings. The RFC which defines the interpretation
         * of a specific TXT record will likely require concatenation of multiple
         * strings if they are present, as with
         * [RFC 7208](https://tools.ietf.org/html/rfc7208#section-3.3).
         *
         * %G_RESOLVER_RECORD_SOA records are returned as variants with the signature
         * `(ssuuuuu)`, representing a string containing the primary name server, a
         * string containing the administrator, the serial as a `guint32`, the refresh
         * interval as a `guint32`, the retry interval as a `guint32`, the expire timeout
         * as a `guint32`, and the TTL as a `guint32`.
         *
         * %G_RESOLVER_RECORD_NS records are returned as variants with the signature
         * `(s)`, representing a string of the hostname of the name server.
         */

        /**
         * The type of record that g_resolver_lookup_records() or
         * g_resolver_lookup_records_async() should retrieve. The records are returned
         * as lists of #GVariant tuples. Each record type has different values in
         * the variant tuples returned.
         *
         * %G_RESOLVER_RECORD_SRV records are returned as variants with the signature
         * `(qqqs)`, containing a `guint16` with the priority, a `guint16` with the
         * weight, a `guint16` with the port, and a string of the hostname.
         *
         * %G_RESOLVER_RECORD_MX records are returned as variants with the signature
         * `(qs)`, representing a `guint16` with the preference, and a string containing
         * the mail exchanger hostname.
         *
         * %G_RESOLVER_RECORD_TXT records are returned as variants with the signature
         * `(as)`, representing an array of the strings in the text record. Note: Most TXT
         * records only contain a single string, but
         * [RFC 1035](https://tools.ietf.org/html/rfc1035#section-3.3.14) does allow a
         * record to contain multiple strings. The RFC which defines the interpretation
         * of a specific TXT record will likely require concatenation of multiple
         * strings if they are present, as with
         * [RFC 7208](https://tools.ietf.org/html/rfc7208#section-3.3).
         *
         * %G_RESOLVER_RECORD_SOA records are returned as variants with the signature
         * `(ssuuuuu)`, representing a string containing the primary name server, a
         * string containing the administrator, the serial as a `guint32`, the refresh
         * interval as a `guint32`, the retry interval as a `guint32`, the expire timeout
         * as a `guint32`, and the TTL as a `guint32`.
         *
         * %G_RESOLVER_RECORD_NS records are returned as variants with the signature
         * `(s)`, representing a string of the hostname of the name server.
         */
        export namespace ResolverRecordType {
            export const $gtype: GObject.GType<ResolverRecordType>;
        }

        enum ResolverRecordType {
            /**
             * look up DNS SRV records for a domain
             */
            SRV,
            /**
             * look up DNS MX records for a domain
             */
            MX,
            /**
             * look up DNS TXT records for a name
             */
            TXT,
            /**
             * look up DNS SOA records for a zone
             */
            SOA,
            /**
             * look up DNS NS records for a domain
             */
            NS,
        }
        /**
         * An error code used with %G_RESOURCE_ERROR in a #GError returned
         * from a #GResource routine.
         */
        class ResourceError extends GLib.Error {
            static $gtype: GObject.GType<ResourceError>;

            // Static fields

            /**
             * no file was found at the requested path
             */
            static NOT_FOUND: number;
            /**
             * unknown error
             */
            static INTERNAL: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            /**
             * Gets the [struct`Gio`.Resource] Error Quark.
             */
            static quark(): GLib.Quark;
        }

        /**
         * Describes an event occurring on a #GSocketClient. See the
         * #GSocketClient::event signal for more details.
         *
         * Additional values may be added to this type in the future.
         */

        /**
         * Describes an event occurring on a #GSocketClient. See the
         * #GSocketClient::event signal for more details.
         *
         * Additional values may be added to this type in the future.
         */
        export namespace SocketClientEvent {
            export const $gtype: GObject.GType<SocketClientEvent>;
        }

        enum SocketClientEvent {
            /**
             * The client is doing a DNS lookup.
             */
            RESOLVING,
            /**
             * The client has completed a DNS lookup.
             */
            RESOLVED,
            /**
             * The client is connecting to a remote
             *   host (either a proxy or the destination server).
             */
            CONNECTING,
            /**
             * The client has connected to a remote
             *   host.
             */
            CONNECTED,
            /**
             * The client is negotiating
             *   with a proxy to connect to the destination server.
             */
            PROXY_NEGOTIATING,
            /**
             * The client has negotiated
             *   with the proxy server.
             */
            PROXY_NEGOTIATED,
            /**
             * The client is performing a
             *   TLS handshake.
             */
            TLS_HANDSHAKING,
            /**
             * The client has performed a
             *   TLS handshake.
             */
            TLS_HANDSHAKED,
            /**
             * The client is done with a particular
             *   #GSocketConnectable.
             */
            COMPLETE,
        }
        /**
         * The protocol family of a #GSocketAddress. (These values are
         * identical to the system defines %AF_INET, %AF_INET6 and %AF_UNIX,
         * if available.)
         */

        /**
         * The protocol family of a #GSocketAddress. (These values are
         * identical to the system defines %AF_INET, %AF_INET6 and %AF_UNIX,
         * if available.)
         */
        export namespace SocketFamily {
            export const $gtype: GObject.GType<SocketFamily>;
        }

        enum SocketFamily {
            /**
             * no address family
             */
            INVALID,
            /**
             * the UNIX domain family
             */
            UNIX,
            /**
             * the IPv4 family
             */
            IPV4,
            /**
             * the IPv6 family
             */
            IPV6,
        }
        /**
         * Describes an event occurring on a #GSocketListener. See the
         * #GSocketListener::event signal for more details.
         *
         * Additional values may be added to this type in the future.
         */

        /**
         * Describes an event occurring on a #GSocketListener. See the
         * #GSocketListener::event signal for more details.
         *
         * Additional values may be added to this type in the future.
         */
        export namespace SocketListenerEvent {
            export const $gtype: GObject.GType<SocketListenerEvent>;
        }

        enum SocketListenerEvent {
            /**
             * The listener is about to bind a socket.
             */
            BINDING,
            /**
             * The listener has bound a socket.
             */
            BOUND,
            /**
             * The listener is about to start
             *    listening on this socket.
             */
            LISTENING,
            /**
             * The listener is now listening on
             *   this socket.
             */
            LISTENED,
        }
        /**
         * A protocol identifier is specified when creating a #GSocket, which is a
         * family/type specific identifier, where 0 means the default protocol for
         * the particular family/type.
         *
         * This enum contains a set of commonly available and used protocols. You
         * can also pass any other identifiers handled by the platform in order to
         * use protocols not listed here.
         */

        /**
         * A protocol identifier is specified when creating a #GSocket, which is a
         * family/type specific identifier, where 0 means the default protocol for
         * the particular family/type.
         *
         * This enum contains a set of commonly available and used protocols. You
         * can also pass any other identifiers handled by the platform in order to
         * use protocols not listed here.
         */
        export namespace SocketProtocol {
            export const $gtype: GObject.GType<SocketProtocol>;
        }

        enum SocketProtocol {
            /**
             * The protocol type is unknown
             */
            UNKNOWN,
            /**
             * The default protocol for the family/type
             */
            DEFAULT,
            /**
             * TCP over IP
             */
            TCP,
            /**
             * UDP over IP
             */
            UDP,
            /**
             * SCTP over IP
             */
            SCTP,
        }
        /**
         * Flags used when creating a #GSocket. Some protocols may not implement
         * all the socket types.
         */

        /**
         * Flags used when creating a #GSocket. Some protocols may not implement
         * all the socket types.
         */
        export namespace SocketType {
            export const $gtype: GObject.GType<SocketType>;
        }

        enum SocketType {
            /**
             * Type unknown or wrong
             */
            INVALID,
            /**
             * Reliable connection-based byte streams (e.g. TCP).
             */
            STREAM,
            /**
             * Connectionless, unreliable datagram passing.
             *     (e.g. UDP)
             */
            DATAGRAM,
            /**
             * Reliable connection-based passing of datagrams
             *     of fixed maximum length (e.g. SCTP).
             */
            SEQPACKET,
        }
        /**
         * The client authentication mode for a #GTlsServerConnection.
         */

        /**
         * The client authentication mode for a #GTlsServerConnection.
         */
        export namespace TlsAuthenticationMode {
            export const $gtype: GObject.GType<TlsAuthenticationMode>;
        }

        enum TlsAuthenticationMode {
            /**
             * client authentication not required
             */
            NONE,
            /**
             * client authentication is requested
             */
            REQUESTED,
            /**
             * client authentication is required
             */
            REQUIRED,
        }
        /**
         * Flags for g_tls_interaction_request_certificate(),
         * g_tls_interaction_request_certificate_async(), and
         * g_tls_interaction_invoke_request_certificate().
         */

        /**
         * Flags for g_tls_interaction_request_certificate(),
         * g_tls_interaction_request_certificate_async(), and
         * g_tls_interaction_invoke_request_certificate().
         */
        export namespace TlsCertificateRequestFlags {
            export const $gtype: GObject.GType<TlsCertificateRequestFlags>;
        }

        enum TlsCertificateRequestFlags {
            /**
             * No flags
             */
            NONE,
        }
        /**
         * An error code used with %G_TLS_CHANNEL_BINDING_ERROR in a #GError to
         * indicate a TLS channel binding retrieval error.
         */
        class TlsChannelBindingError extends GLib.Error {
            static $gtype: GObject.GType<TlsChannelBindingError>;

            // Static fields

            /**
             * Either entire binding
             *    retrieval facility or specific binding type is not implemented in the
             *    TLS backend.
             */
            static NOT_IMPLEMENTED: number;
            /**
             * The handshake is not yet
             *    complete on the connection which is a strong requirement for any existing
             *    binding type.
             */
            static INVALID_STATE: number;
            /**
             * Handshake is complete but
             *    binding data is not available. That normally indicates the TLS
             *    implementation failed to provide the binding data. For example, some
             *    implementations do not provide a peer certificate for resumed connections.
             */
            static NOT_AVAILABLE: number;
            /**
             * Binding type is not supported
             *    on the current connection. This error could be triggered when requesting
             *    `tls-server-end-point` binding data for a certificate which has no hash
             *    function or uses multiple hash functions.
             */
            static NOT_SUPPORTED: number;
            /**
             * Any other backend error
             *    preventing binding data retrieval.
             */
            static GENERAL_ERROR: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            /**
             * Gets the TLS channel binding error quark.
             */
            static quark(): GLib.Quark;
        }

        /**
         * The type of TLS channel binding data to retrieve from #GTlsConnection
         * or #GDtlsConnection, as documented by RFC 5929 or RFC 9266. The
         * [`tls-unique-for-telnet`](https://tools.ietf.org/html/rfc5929#section-5)
         * binding type is not currently implemented.
         */

        /**
         * The type of TLS channel binding data to retrieve from #GTlsConnection
         * or #GDtlsConnection, as documented by RFC 5929 or RFC 9266. The
         * [`tls-unique-for-telnet`](https://tools.ietf.org/html/rfc5929#section-5)
         * binding type is not currently implemented.
         */
        export namespace TlsChannelBindingType {
            export const $gtype: GObject.GType<TlsChannelBindingType>;
        }

        enum TlsChannelBindingType {
            /**
             * [`tls-unique`](https://tools.ietf.org/html/rfc5929#section-3) binding
             *    type
             */
            UNIQUE,
            /**
             * [`tls-server-end-point`](https://tools.ietf.org/html/rfc5929#section-4)
             *    binding type
             */
            SERVER_END_POINT,
            /**
             * [`tls-exporter`](https://www.rfc-editor.org/rfc/rfc9266.html) binding
             *    type. Since: 2.74
             */
            EXPORTER,
        }
        /**
         * Flags for g_tls_database_lookup_certificate_for_handle(),
         * g_tls_database_lookup_certificate_issuer(),
         * and g_tls_database_lookup_certificates_issued_by().
         */

        /**
         * Flags for g_tls_database_lookup_certificate_for_handle(),
         * g_tls_database_lookup_certificate_issuer(),
         * and g_tls_database_lookup_certificates_issued_by().
         */
        export namespace TlsDatabaseLookupFlags {
            export const $gtype: GObject.GType<TlsDatabaseLookupFlags>;
        }

        enum TlsDatabaseLookupFlags {
            /**
             * No lookup flags
             */
            NONE,
            /**
             * Restrict lookup to certificates that have
             *     a private key.
             */
            KEYPAIR,
        }
        /**
         * An error code used with %G_TLS_ERROR in a #GError returned from a
         * TLS-related routine.
         */
        class TlsError extends GLib.Error {
            static $gtype: GObject.GType<TlsError>;

            // Static fields

            /**
             * No TLS provider is available
             */
            static UNAVAILABLE: number;
            /**
             * Miscellaneous TLS error
             */
            static MISC: number;
            /**
             * The certificate presented could not
             *   be parsed or failed validation.
             */
            static BAD_CERTIFICATE: number;
            /**
             * The TLS handshake failed because the
             *   peer does not seem to be a TLS server.
             */
            static NOT_TLS: number;
            /**
             * The TLS handshake failed because the
             *   peer's certificate was not acceptable.
             */
            static HANDSHAKE: number;
            /**
             * The TLS handshake failed because
             *   the server requested a client-side certificate, but none was
             *   provided. See g_tls_connection_set_certificate().
             */
            static CERTIFICATE_REQUIRED: number;
            /**
             * The TLS connection was closed without proper
             *   notice, which may indicate an attack. See
             *   g_tls_connection_set_require_close_notify().
             */
            static EOF: number;
            /**
             * The TLS handshake failed
             *   because the client sent the fallback SCSV, indicating a protocol
             *   downgrade attack. Since: 2.60
             */
            static INAPPROPRIATE_FALLBACK: number;
            /**
             * The certificate failed
             *   to load because a password was incorrect. Since: 2.72
             */
            static BAD_CERTIFICATE_PASSWORD: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            /**
             * Gets the TLS error quark.
             */
            static quark(): GLib.Quark;
        }

        /**
         * #GTlsInteractionResult is returned by various functions in #GTlsInteraction
         * when finishing an interaction request.
         */

        /**
         * #GTlsInteractionResult is returned by various functions in #GTlsInteraction
         * when finishing an interaction request.
         */
        export namespace TlsInteractionResult {
            export const $gtype: GObject.GType<TlsInteractionResult>;
        }

        enum TlsInteractionResult {
            /**
             * The interaction was unhandled (i.e. not
             *     implemented).
             */
            UNHANDLED,
            /**
             * The interaction completed, and resulting data
             *     is available.
             */
            HANDLED,
            /**
             * The interaction has failed, or was cancelled.
             *     and the operation should be aborted.
             */
            FAILED,
        }
        /**
         * The TLS or DTLS protocol version used by a #GTlsConnection or
         * #GDtlsConnection. The integer values of these versions are sequential
         * to ensure newer known protocol versions compare greater than older
         * known versions. Any known DTLS protocol version will compare greater
         * than any SSL or TLS protocol version. The protocol version may be
         * %G_TLS_PROTOCOL_VERSION_UNKNOWN if the TLS backend supports a newer
         * protocol version that GLib does not yet know about. This means that
         * it's possible for an unknown DTLS protocol version to compare less
         * than the TLS protocol versions.
         */

        /**
         * The TLS or DTLS protocol version used by a #GTlsConnection or
         * #GDtlsConnection. The integer values of these versions are sequential
         * to ensure newer known protocol versions compare greater than older
         * known versions. Any known DTLS protocol version will compare greater
         * than any SSL or TLS protocol version. The protocol version may be
         * %G_TLS_PROTOCOL_VERSION_UNKNOWN if the TLS backend supports a newer
         * protocol version that GLib does not yet know about. This means that
         * it's possible for an unknown DTLS protocol version to compare less
         * than the TLS protocol versions.
         */
        export namespace TlsProtocolVersion {
            export const $gtype: GObject.GType<TlsProtocolVersion>;
        }

        enum TlsProtocolVersion {
            /**
             * No protocol version or unknown protocol version
             */
            UNKNOWN,
            /**
             * SSL 3.0, which is insecure and should not be used
             */
            SSL_3_0,
            /**
             * TLS 1.0, which is insecure and should not be used
             */
            TLS_1_0,
            /**
             * TLS 1.1, which is insecure and should not be used
             */
            TLS_1_1,
            /**
             * TLS 1.2, defined by [RFC 5246](https://datatracker.ietf.org/doc/html/rfc5246)
             */
            TLS_1_2,
            /**
             * TLS 1.3, defined by [RFC 8446](https://datatracker.ietf.org/doc/html/rfc8446)
             */
            TLS_1_3,
            /**
             * DTLS 1.0, which is insecure and should not be used
             */
            DTLS_1_0,
            /**
             * DTLS 1.2, defined by [RFC 6347](https://datatracker.ietf.org/doc/html/rfc6347)
             */
            DTLS_1_2,
        }
        /**
         * When to allow rehandshaking. See
         * g_tls_connection_set_rehandshake_mode().
         */

        /**
         * When to allow rehandshaking. See
         * g_tls_connection_set_rehandshake_mode().
         */
        export namespace TlsRehandshakeMode {
            export const $gtype: GObject.GType<TlsRehandshakeMode>;
        }

        enum TlsRehandshakeMode {
            /**
             * Never allow rehandshaking
             */
            NEVER,
            /**
             * Allow safe rehandshaking only
             */
            SAFELY,
            /**
             * Allow unsafe rehandshaking
             */
            UNSAFELY,
        }
        /**
         * The type of name used by a #GUnixSocketAddress.
         * %G_UNIX_SOCKET_ADDRESS_PATH indicates a traditional unix domain
         * socket bound to a filesystem path. %G_UNIX_SOCKET_ADDRESS_ANONYMOUS
         * indicates a socket not bound to any name (eg, a client-side socket,
         * or a socket created with socketpair()).
         *
         * For abstract sockets, there are two incompatible ways of naming
         * them; the man pages suggest using the entire `struct sockaddr_un`
         * as the name, padding the unused parts of the %sun_path field with
         * zeroes; this corresponds to %G_UNIX_SOCKET_ADDRESS_ABSTRACT_PADDED.
         * However, many programs instead just use a portion of %sun_path, and
         * pass an appropriate smaller length to bind() or connect(). This is
         * %G_UNIX_SOCKET_ADDRESS_ABSTRACT.
         */

        /**
         * The type of name used by a #GUnixSocketAddress.
         * %G_UNIX_SOCKET_ADDRESS_PATH indicates a traditional unix domain
         * socket bound to a filesystem path. %G_UNIX_SOCKET_ADDRESS_ANONYMOUS
         * indicates a socket not bound to any name (eg, a client-side socket,
         * or a socket created with socketpair()).
         *
         * For abstract sockets, there are two incompatible ways of naming
         * them; the man pages suggest using the entire `struct sockaddr_un`
         * as the name, padding the unused parts of the %sun_path field with
         * zeroes; this corresponds to %G_UNIX_SOCKET_ADDRESS_ABSTRACT_PADDED.
         * However, many programs instead just use a portion of %sun_path, and
         * pass an appropriate smaller length to bind() or connect(). This is
         * %G_UNIX_SOCKET_ADDRESS_ABSTRACT.
         */
        export namespace UnixSocketAddressType {
            export const $gtype: GObject.GType<UnixSocketAddressType>;
        }

        enum UnixSocketAddressType {
            /**
             * invalid
             */
            INVALID,
            /**
             * anonymous
             */
            ANONYMOUS,
            /**
             * a filesystem path
             */
            PATH,
            /**
             * an abstract name
             */
            ABSTRACT,
            /**
             * an abstract name, 0-padded
             *   to the full length of a unix socket name
             */
            ABSTRACT_PADDED,
        }
        /**
         * Used to select the type of data format to use for #GZlibDecompressor
         * and #GZlibCompressor.
         */

        /**
         * Used to select the type of data format to use for #GZlibDecompressor
         * and #GZlibCompressor.
         */
        export namespace ZlibCompressorFormat {
            export const $gtype: GObject.GType<ZlibCompressorFormat>;
        }

        enum ZlibCompressorFormat {
            /**
             * deflate compression with zlib header
             */
            ZLIB,
            /**
             * gzip file format
             */
            GZIP,
            /**
             * deflate compression with no header
             */
            RAW,
        }
        /**
         * The value returned by handlers of the signals generated by
         * the `gdbus-codegen` tool to indicate that a method call has been
         * handled by an implementation. It is equal to %TRUE, but using
         * this macro is sometimes more readable.
         *
         * In code that needs to be backwards-compatible with older GLib,
         * use %TRUE instead, often written like this:
         *
         *
         * ```
         *   g_dbus_method_invocation_return_error (invocation, ...);
         *   return TRUE;    // handled
         * ```
         *
         */
        const DBUS_METHOD_INVOCATION_HANDLED: boolean;
        /**
         * The value returned by handlers of the signals generated by
         * the `gdbus-codegen` tool to indicate that a method call has not been
         * handled by an implementation. It is equal to %FALSE, but using
         * this macro is sometimes more readable.
         *
         * In code that needs to be backwards-compatible with older GLib,
         * use %FALSE instead.
         */
        const DBUS_METHOD_INVOCATION_UNHANDLED: boolean;
        /**
         * Extension point for debug control functionality.
         * See [Extending GIO](overview.html#extending-gio).
         */
        const DEBUG_CONTROLLER_EXTENSION_POINT_NAME: string;
        /**
         * Extension point for default handler to URI association. See
         * [Extending GIO](overview.html#extending-gio).
         */
        const DESKTOP_APP_INFO_LOOKUP_EXTENSION_POINT_NAME: string;
        /**
         * The string used to obtain a Unix device path with g_drive_get_identifier().
         */
        const DRIVE_IDENTIFIER_KIND_UNIX_DEVICE: string;
        /**
         * A key in the "access" namespace for checking deletion privileges.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         *
         * This attribute will be %TRUE if the user is able to delete the file.
         */
        const FILE_ATTRIBUTE_ACCESS_CAN_DELETE: string;
        /**
         * A key in the "access" namespace for getting execution privileges.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         *
         * This attribute will be %TRUE if the user is able to execute the file.
         */
        const FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE: string;
        /**
         * A key in the "access" namespace for getting read privileges.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         *
         * This attribute will be %TRUE if the user is able to read the file.
         */
        const FILE_ATTRIBUTE_ACCESS_CAN_READ: string;
        /**
         * A key in the "access" namespace for checking renaming privileges.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         *
         * This attribute will be %TRUE if the user is able to rename the file.
         */
        const FILE_ATTRIBUTE_ACCESS_CAN_RENAME: string;
        /**
         * A key in the "access" namespace for checking trashing privileges.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         *
         * This attribute will be %TRUE if the user is able to move the file to
         * the trash.
         */
        const FILE_ATTRIBUTE_ACCESS_CAN_TRASH: string;
        /**
         * A key in the "access" namespace for getting write privileges.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         *
         * This attribute will be %TRUE if the user is able to write to the file.
         */
        const FILE_ATTRIBUTE_ACCESS_CAN_WRITE: string;
        /**
         * A key in the "dos" namespace for checking if the file's archive flag
         * is set.
         *
         * This attribute is %TRUE if the archive flag is set.
         *
         * This attribute is only available for DOS file systems.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_DOS_IS_ARCHIVE: string;
        /**
         * A key in the "dos" namespace for checking if the file is a NTFS mount point
         * (a volume mount or a junction point).
         *
         * This attribute is %TRUE if file is a reparse point of type
         * [IO_REPARSE_TAG_MOUNT_POINT](https://msdn.microsoft.com/en-us/library/dd541667.aspx).
         *
         * This attribute is only available for DOS file systems.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_DOS_IS_MOUNTPOINT: string;
        /**
         * A key in the "dos" namespace for checking if the file's backup flag
         * is set.
         *
         * This attribute is %TRUE if the backup flag is set.
         *
         * This attribute is only available for DOS file systems.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_DOS_IS_SYSTEM: string;
        /**
         * A key in the "dos" namespace for getting the file NTFS reparse tag.
         *
         * This value is 0 for files that are not reparse points.
         *
         * See the [Reparse Tags](https://msdn.microsoft.com/en-us/library/dd541667.aspx)
         * page for possible reparse tag values.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_DOS_REPARSE_POINT_TAG: string;
        /**
         * A key in the "etag" namespace for getting the value of the file's
         * entity tag.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         */
        const FILE_ATTRIBUTE_ETAG_VALUE: string;
        /**
         * A key in the "filesystem" namespace for getting the number of bytes
         * of free space left on the file system.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64.
         */
        const FILE_ATTRIBUTE_FILESYSTEM_FREE: string;
        /**
         * A key in the "filesystem" namespace for checking if the file system
         * is read only.
         *
         * Is set to %TRUE if the file system is read only.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_FILESYSTEM_READONLY: string;
        /**
         * A key in the "filesystem" namespace for checking if the file system
         * is remote.
         *
         * Is set to %TRUE if the file system is remote.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_FILESYSTEM_REMOTE: string;
        /**
         * A key in the "filesystem" namespace for getting the total size (in
         * bytes) of the file system, used in g_file_query_filesystem_info().
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64.
         */
        const FILE_ATTRIBUTE_FILESYSTEM_SIZE: string;
        /**
         * A key in the "filesystem" namespace for getting the file system's type.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         */
        const FILE_ATTRIBUTE_FILESYSTEM_TYPE: string;
        /**
         * A key in the "filesystem" namespace for getting the number of bytes
         * used by data on the file system.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64.
         */
        const FILE_ATTRIBUTE_FILESYSTEM_USED: string;
        /**
         * A key in the "filesystem" namespace for hinting a file manager
         * application whether it should preview (e.g. thumbnail) files on the
         * file system.
         *
         * The value for this key contain a #GFilesystemPreviewType.
         */
        const FILE_ATTRIBUTE_FILESYSTEM_USE_PREVIEW: string;
        /**
         * A key in the "gvfs" namespace that gets the name of the current
         * GVFS backend in use.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         */
        const FILE_ATTRIBUTE_GVFS_BACKEND: string;
        /**
         * A key in the "id" namespace for getting a file identifier.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         *
         * An example use would be during listing files, to avoid recursive
         * directory scanning.
         */
        const FILE_ATTRIBUTE_ID_FILE: string;
        /**
         * A key in the "id" namespace for getting the file system identifier.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         *
         * An example use would be during drag and drop to see if the source
         * and target are on the same filesystem (default to move) or not (default
         * to copy).
         */
        const FILE_ATTRIBUTE_ID_FILESYSTEM: string;
        /**
         * A key in the "mountable" namespace for checking if a file (of
         * type G_FILE_TYPE_MOUNTABLE) can be ejected.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_MOUNTABLE_CAN_EJECT: string;
        /**
         * A key in the "mountable" namespace for checking if a file (of
         * type G_FILE_TYPE_MOUNTABLE) is mountable.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_MOUNTABLE_CAN_MOUNT: string;
        /**
         * A key in the "mountable" namespace for checking if a file (of
         * type G_FILE_TYPE_MOUNTABLE) can be polled.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_MOUNTABLE_CAN_POLL: string;
        /**
         * A key in the "mountable" namespace for checking if a file (of
         * type G_FILE_TYPE_MOUNTABLE) can be started.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_MOUNTABLE_CAN_START: string;
        /**
         * A key in the "mountable" namespace for checking if a file (of
         * type G_FILE_TYPE_MOUNTABLE) can be started degraded.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_MOUNTABLE_CAN_START_DEGRADED: string;
        /**
         * A key in the "mountable" namespace for checking if a file (of
         * type G_FILE_TYPE_MOUNTABLE) can be stopped.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_MOUNTABLE_CAN_STOP: string;
        /**
         * A key in the "mountable" namespace for checking if a file (of
         * type G_FILE_TYPE_MOUNTABLE)  is unmountable.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_MOUNTABLE_CAN_UNMOUNT: string;
        /**
         * A key in the "mountable" namespace for getting the HAL UDI for the mountable
         * file.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         */
        const FILE_ATTRIBUTE_MOUNTABLE_HAL_UDI: string;
        /**
         * A key in the "mountable" namespace for checking if a file (of
         * type G_FILE_TYPE_MOUNTABLE) is automatically polled for media.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_MOUNTABLE_IS_MEDIA_CHECK_AUTOMATIC: string;
        /**
         * A key in the "mountable" namespace for getting the #GDriveStartStopType.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_MOUNTABLE_START_STOP_TYPE: string;
        /**
         * A key in the "mountable" namespace for getting the unix device.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE: string;
        /**
         * A key in the "mountable" namespace for getting the unix device file.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         */
        const FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE_FILE: string;
        /**
         * A key in the "owner" namespace for getting the file owner's group.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         */
        const FILE_ATTRIBUTE_OWNER_GROUP: string;
        /**
         * A key in the "owner" namespace for getting the user name of the
         * file's owner.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         */
        const FILE_ATTRIBUTE_OWNER_USER: string;
        /**
         * A key in the "owner" namespace for getting the real name of the
         * user that owns the file.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         */
        const FILE_ATTRIBUTE_OWNER_USER_REAL: string;
        /**
         * A key in the "preview" namespace for getting a #GIcon that can be
         * used to get preview of the file.
         *
         * For example, it may be a low resolution thumbnail without metadata.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_OBJECT.
         *
         * The value for this key should contain a #GIcon.
         */
        const FILE_ATTRIBUTE_PREVIEW_ICON: string;
        /**
         * A key in the "recent" namespace for getting time, when the metadata for the
         * file in `recent:///` was last changed.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_INT64.
         */
        const FILE_ATTRIBUTE_RECENT_MODIFIED: string;
        /**
         * A key in the "selinux" namespace for getting the file's SELinux
         * context.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         *
         * Note that this attribute is only available if GLib has been built
         * with SELinux support.
         */
        const FILE_ATTRIBUTE_SELINUX_CONTEXT: string;
        /**
         * A key in the "standard" namespace for getting the amount of disk space
         * that is consumed by the file (in bytes).
         *
         * This will generally be larger than the file size (due to block size
         * overhead) but can occasionally be smaller (for example, for sparse files).
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64.
         */
        const FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE: string;
        /**
         * A key in the "standard" namespace for getting the content type of the file.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         *
         * The value for this key should contain a valid content type.
         */
        const FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE: string;
        /**
         * A key in the "standard" namespace for getting the copy name of the file.
         *
         * The copy name is an optional version of the name. If available it's always
         * in UTF8, and corresponds directly to the original filename (only transcoded to
         * UTF8). This is useful if you want to copy the file to another filesystem that
         * might have a different encoding. If the filename is not a valid string in the
         * encoding selected for the filesystem it is in then the copy name will not be set.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         */
        const FILE_ATTRIBUTE_STANDARD_COPY_NAME: string;
        /**
         * A key in the "standard" namespace for getting the description of the file.
         *
         * The description is a utf8 string that describes the file, generally containing
         * the filename, but can also contain further information. Example descriptions
         * could be "filename (on hostname)" for a remote file or "filename (in trash)"
         * for a file in the trash. This is useful for instance as the window title
         * when displaying a directory or for a bookmarks menu.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         */
        const FILE_ATTRIBUTE_STANDARD_DESCRIPTION: string;
        /**
         * A key in the "standard" namespace for getting the display name of the file.
         *
         * A display name is guaranteed to be in UTF-8 and can thus be displayed in
         * the UI. It is guaranteed to be set on every file.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         */
        const FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME: string;
        /**
         * A key in the "standard" namespace for edit name of the file.
         *
         * An edit name is similar to the display name, but it is meant to be
         * used when you want to rename the file in the UI. The display name
         * might contain information you don't want in the new filename (such as
         * "(invalid unicode)" if the filename was in an invalid encoding).
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         */
        const FILE_ATTRIBUTE_STANDARD_EDIT_NAME: string;
        /**
         * A key in the "standard" namespace for getting the fast content type.
         *
         * The fast content type isn't as reliable as the regular one, as it
         * only uses the filename to guess it, but it is faster to calculate than the
         * regular content type.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         */
        const FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE: string;
        /**
         * A key in the "standard" namespace for getting the icon for the file.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_OBJECT.
         *
         * The value for this key should contain a #GIcon.
         */
        const FILE_ATTRIBUTE_STANDARD_ICON: string;
        /**
         * A key in the "standard" namespace for checking if a file is a backup file.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_STANDARD_IS_BACKUP: string;
        /**
         * A key in the "standard" namespace for checking if a file is hidden.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_STANDARD_IS_HIDDEN: string;
        /**
         * A key in the "standard" namespace for checking if the file is a symlink.
         * Typically the actual type is something else, if we followed the symlink
         * to get the type.
         *
         * On Windows NTFS mountpoints are considered to be symlinks as well.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_STANDARD_IS_SYMLINK: string;
        /**
         * A key in the "standard" namespace for checking if a file is virtual.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_STANDARD_IS_VIRTUAL: string;
        /**
         * A key in the "standard" namespace for checking if a file is
         * volatile. This is meant for opaque, non-POSIX-like backends to
         * indicate that the URI is not persistent. Applications should look
         * at %G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET for the persistent URI.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_STANDARD_IS_VOLATILE: string;
        /**
         * A key in the "standard" namespace for getting the name of the file.
         *
         * The name is the on-disk filename which may not be in any known encoding,
         * and can thus not be generally displayed as is. It is guaranteed to be set on
         * every file.
         *
         * Use %G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME if you need to display the
         * name in a user interface.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BYTE_STRING.
         */
        const FILE_ATTRIBUTE_STANDARD_NAME: string;
        /**
         * A key in the "standard" namespace for getting the file's size (in bytes).
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64.
         */
        const FILE_ATTRIBUTE_STANDARD_SIZE: string;
        /**
         * A key in the "standard" namespace for setting the sort order of a file.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_INT32.
         *
         * An example use would be in file managers, which would use this key
         * to set the order files are displayed. Files with smaller sort order
         * should be sorted first, and files without sort order as if sort order
         * was zero.
         */
        const FILE_ATTRIBUTE_STANDARD_SORT_ORDER: string;
        /**
         * A key in the "standard" namespace for getting the symbolic icon for the file.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_OBJECT.
         *
         * The value for this key should contain a #GIcon.
         */
        const FILE_ATTRIBUTE_STANDARD_SYMBOLIC_ICON: string;
        /**
         * A key in the "standard" namespace for getting the symlink target, if the file
         * is a symlink.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BYTE_STRING.
         */
        const FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET: string;
        /**
         * A key in the "standard" namespace for getting the target URI for the file, in
         * the case of %G_FILE_TYPE_SHORTCUT or %G_FILE_TYPE_MOUNTABLE files.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         */
        const FILE_ATTRIBUTE_STANDARD_TARGET_URI: string;
        /**
         * A key in the "standard" namespace for storing file types.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
         *
         * The value for this key should contain a #GFileType.
         */
        const FILE_ATTRIBUTE_STANDARD_TYPE: string;
        /**
         * A key in the "thumbnail" namespace for checking if thumbnailing failed.
         *
         * This attribute is %TRUE if thumbnailing failed.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_THUMBNAILING_FAILED: string;
        /**
         * A key in the "thumbnail" namespace for checking if thumbnailing failed
         * for the large image.
         *
         * This attribute is %TRUE if thumbnailing failed.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_THUMBNAILING_FAILED_LARGE: string;
        /**
         * A key in the "thumbnail" namespace for checking if thumbnailing failed
         * for the normal image.
         *
         * This attribute is %TRUE if thumbnailing failed.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_THUMBNAILING_FAILED_NORMAL: string;
        /**
         * A key in the "thumbnail" namespace for checking if thumbnailing failed
         * for the x-large image.
         *
         * This attribute is %TRUE if thumbnailing failed.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_THUMBNAILING_FAILED_XLARGE: string;
        /**
         * A key in the "thumbnail" namespace for checking if thumbnailing failed
         * for the xx-large image.
         *
         * This attribute is %TRUE if thumbnailing failed.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_THUMBNAILING_FAILED_XXLARGE: string;
        /**
         * A key in the "thumbnail" namespace for checking whether the thumbnail is outdated.
         *
         * This attribute is %TRUE if the thumbnail is up-to-date with the file it represents,
         * and %FALSE if the file has been modified since the thumbnail was generated.
         *
         * If %G_FILE_ATTRIBUTE_THUMBNAILING_FAILED is %TRUE and this attribute is %FALSE,
         * it indicates that thumbnailing may be attempted again and may succeed.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_THUMBNAIL_IS_VALID: string;
        /**
         * A key in the "thumbnail" namespace for checking whether the large
         * thumbnail is outdated.
         *
         * This attribute is %TRUE if the large thumbnail is up-to-date with the file
         * it represents, and %FALSE if the file has been modified since the thumbnail
         * was generated.
         *
         * If %G_FILE_ATTRIBUTE_THUMBNAILING_FAILED_LARGE is %TRUE and this attribute
         * is %FALSE, it indicates that thumbnailing may be attempted again and may
         * succeed.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_THUMBNAIL_IS_VALID_LARGE: string;
        /**
         * A key in the "thumbnail" namespace for checking whether the normal
         * thumbnail is outdated.
         *
         * This attribute is %TRUE if the normal thumbnail is up-to-date with the file
         * it represents, and %FALSE if the file has been modified since the thumbnail
         * was generated.
         *
         * If %G_FILE_ATTRIBUTE_THUMBNAILING_FAILED_NORMAL is %TRUE and this attribute
         * is %FALSE, it indicates that thumbnailing may be attempted again and may
         * succeed.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_THUMBNAIL_IS_VALID_NORMAL: string;
        /**
         * A key in the "thumbnail" namespace for checking whether the x-large
         * thumbnail is outdated.
         *
         * This attribute is %TRUE if the x-large thumbnail is up-to-date with the file
         * it represents, and %FALSE if the file has been modified since the thumbnail
         * was generated.
         *
         * If %G_FILE_ATTRIBUTE_THUMBNAILING_FAILED_XLARGE is %TRUE and this attribute
         * is %FALSE, it indicates that thumbnailing may be attempted again and may
         * succeed.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_THUMBNAIL_IS_VALID_XLARGE: string;
        /**
         * A key in the "thumbnail" namespace for checking whether the xx-large
         * thumbnail is outdated.
         *
         * This attribute is %TRUE if the x-large thumbnail is up-to-date with the file
         * it represents, and %FALSE if the file has been modified since the thumbnail
         * was generated.
         *
         * If %G_FILE_ATTRIBUTE_THUMBNAILING_FAILED_XXLARGE is %TRUE and this attribute
         * is %FALSE, it indicates that thumbnailing may be attempted again and may
         * succeed.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_THUMBNAIL_IS_VALID_XXLARGE: string;
        /**
         * A key in the "thumbnail" namespace for getting the path to the thumbnail
         * image with the biggest size available.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BYTE_STRING.
         */
        const FILE_ATTRIBUTE_THUMBNAIL_PATH: string;
        /**
         * A key in the "thumbnail" namespace for getting the path to the large
         * thumbnail image.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BYTE_STRING.
         */
        const FILE_ATTRIBUTE_THUMBNAIL_PATH_LARGE: string;
        /**
         * A key in the "thumbnail" namespace for getting the path to the normal
         * thumbnail image.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BYTE_STRING.
         */
        const FILE_ATTRIBUTE_THUMBNAIL_PATH_NORMAL: string;
        /**
         * A key in the "thumbnail" namespace for getting the path to the x-large
         * thumbnail image.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BYTE_STRING.
         */
        const FILE_ATTRIBUTE_THUMBNAIL_PATH_XLARGE: string;
        /**
         * A key in the "thumbnail" namespace for getting the path to the xx-large
         * thumbnail image.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BYTE_STRING.
         */
        const FILE_ATTRIBUTE_THUMBNAIL_PATH_XXLARGE: string;
        /**
         * A key in the "time" namespace for getting the time the file was last
         * accessed.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64, and
         * contains the time since the file was last accessed, in seconds since the
         * UNIX epoch.
         */
        const FILE_ATTRIBUTE_TIME_ACCESS: string;
        /**
         * A key in the "time" namespace for getting the nanoseconds of the time
         * the file was last accessed. This should be used in conjunction with
         * #G_FILE_ATTRIBUTE_TIME_ACCESS. Corresponding #GFileAttributeType is
         * %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_TIME_ACCESS_NSEC: string;
        /**
         * A key in the "time" namespace for getting the microseconds of the time
         * the file was last accessed.
         *
         * This should be used in conjunction with %G_FILE_ATTRIBUTE_TIME_ACCESS.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_TIME_ACCESS_USEC: string;
        /**
         * A key in the "time" namespace for getting the time the file was last
         * changed.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64,
         * and contains the time since the file was last changed, in seconds since
         * the UNIX epoch.
         *
         * This corresponds to the traditional UNIX ctime.
         */
        const FILE_ATTRIBUTE_TIME_CHANGED: string;
        /**
         * A key in the "time" namespace for getting the nanoseconds of the time
         * the file was last changed. This should be used in conjunction with
         * #G_FILE_ATTRIBUTE_TIME_CHANGED. Corresponding #GFileAttributeType is
         * %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_TIME_CHANGED_NSEC: string;
        /**
         * A key in the "time" namespace for getting the microseconds of the time
         * the file was last changed.
         *
         * This should be used in conjunction with %G_FILE_ATTRIBUTE_TIME_CHANGED.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_TIME_CHANGED_USEC: string;
        /**
         * A key in the "time" namespace for getting the time the file was created.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64,
         * and contains the time since the file was created, in seconds since the UNIX
         * epoch.
         *
         * This may correspond to Linux `stx_btime`, FreeBSD `st_birthtim`, NetBSD
         * `st_birthtime` or NTFS `ctime`.
         */
        const FILE_ATTRIBUTE_TIME_CREATED: string;
        /**
         * A key in the "time" namespace for getting the nanoseconds of the time
         * the file was created. This should be used in conjunction with
         * #G_FILE_ATTRIBUTE_TIME_CREATED. Corresponding #GFileAttributeType is
         * %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_TIME_CREATED_NSEC: string;
        /**
         * A key in the "time" namespace for getting the microseconds of the time
         * the file was created.
         *
         * This should be used in conjunction with %G_FILE_ATTRIBUTE_TIME_CREATED.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_TIME_CREATED_USEC: string;
        /**
         * A key in the "time" namespace for getting the time the file was last
         * modified.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64, and
         * contains the time since the file was modified, in seconds since the UNIX
         * epoch.
         */
        const FILE_ATTRIBUTE_TIME_MODIFIED: string;
        /**
         * A key in the "time" namespace for getting the nanoseconds of the time
         * the file was last modified. This should be used in conjunction with
         * #G_FILE_ATTRIBUTE_TIME_MODIFIED. Corresponding #GFileAttributeType is
         * %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_TIME_MODIFIED_NSEC: string;
        /**
         * A key in the "time" namespace for getting the microseconds of the time
         * the file was last modified.
         *
         * This should be used in conjunction with %G_FILE_ATTRIBUTE_TIME_MODIFIED.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_TIME_MODIFIED_USEC: string;
        /**
         * A key in the "trash" namespace for getting the deletion date and time
         * of a file inside the `trash:///` folder.
         *
         * The format of the returned string is `YYYY-MM-DDThh:mm:ss`.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
         */
        const FILE_ATTRIBUTE_TRASH_DELETION_DATE: string;
        /**
         * A key in the "trash" namespace for getting the number of (toplevel) items
         * that are present in the `trash:///` folder.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_TRASH_ITEM_COUNT: string;
        /**
         * A key in the "trash" namespace for getting the original path of a file
         * inside the `trash:///` folder before it was trashed.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BYTE_STRING.
         */
        const FILE_ATTRIBUTE_TRASH_ORIG_PATH: string;
        /**
         * A key in the "unix" namespace for getting the number of blocks allocated
         * for the file.
         *
         * This attribute is only available for UNIX file systems.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64.
         */
        const FILE_ATTRIBUTE_UNIX_BLOCKS: string;
        /**
         * A key in the "unix" namespace for getting the block size for the file
         * system.
         *
         * This attribute is only available for UNIX file systems.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_UNIX_BLOCK_SIZE: string;
        /**
         * A key in the "unix" namespace for getting the device id of the device the
         * file is located on (see stat() documentation).
         *
         * This attribute is only available for UNIX file systems.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_UNIX_DEVICE: string;
        /**
         * A key in the "unix" namespace for getting the group ID for the file.
         *
         * This attribute is only available for UNIX file systems.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_UNIX_GID: string;
        /**
         * A key in the "unix" namespace for getting the inode of the file.
         *
         * This attribute is only available for UNIX file systems.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64.
         */
        const FILE_ATTRIBUTE_UNIX_INODE: string;
        /**
         * A key in the "unix" namespace for checking if the file represents a
         * UNIX mount point.
         *
         * This attribute is %TRUE if the file is a UNIX mount point.
         *
         * Since 2.58, `/` is considered to be a mount point.
         *
         * This attribute is only available for UNIX file systems.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
         */
        const FILE_ATTRIBUTE_UNIX_IS_MOUNTPOINT: string;
        /**
         * A key in the "unix" namespace for getting the mode of the file
         * (e.g. whether the file is a regular file, symlink, etc).
         *
         * See the documentation for `lstat()`: this attribute is equivalent to
         * the `st_mode` member of `struct stat`, and includes both the file type
         * and permissions.
         *
         * This attribute is only available for UNIX file systems.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_UNIX_MODE: string;
        /**
         * A key in the "unix" namespace for getting the number of hard links
         * for a file.
         *
         * See the documentation for `lstat()`.
         *
         * This attribute is only available for UNIX file systems.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_UNIX_NLINK: string;
        /**
         * A key in the "unix" namespace for getting the device ID for the file
         * (if it is a special file).
         *
         * See the documentation for `lstat()`.
         *
         * This attribute is only available for UNIX file systems.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_UNIX_RDEV: string;
        /**
         * A key in the "unix" namespace for getting the user ID for the file.
         *
         * This attribute is only available for UNIX file systems.
         *
         * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
         */
        const FILE_ATTRIBUTE_UNIX_UID: string;
        /**
         * Extension point for memory usage monitoring functionality.
         * See [Extending GIO](overview.html#extending-gio).
         */
        const MEMORY_MONITOR_EXTENSION_POINT_NAME: string;
        /**
         * The menu item attribute which holds the action name of the item.  Action
         * names are namespaced with an identifier for the action group in which the
         * action resides. For example, "win." for window-specific actions and "app."
         * for application-wide actions.
         *
         * See also g_menu_model_get_item_attribute() and g_menu_item_set_attribute().
         */
        const MENU_ATTRIBUTE_ACTION: string;
        /**
         * The menu item attribute that holds the namespace for all action names in
         * menus that are linked from this item.
         */
        const MENU_ATTRIBUTE_ACTION_NAMESPACE: string;
        /**
         * The menu item attribute which holds the icon of the item.
         *
         * The icon is stored in the format returned by g_icon_serialize().
         *
         * This attribute is intended only to represent 'noun' icons such as
         * favicons for a webpage, or application icons.  It should not be used
         * for 'verbs' (ie: stock icons).
         */
        const MENU_ATTRIBUTE_ICON: string;
        /**
         * The menu item attribute which holds the label of the item.
         */
        const MENU_ATTRIBUTE_LABEL: string;
        /**
         * The menu item attribute which holds the target with which the item's action
         * will be activated.
         *
         * See also g_menu_item_set_action_and_target()
         */
        const MENU_ATTRIBUTE_TARGET: string;
        /**
         * The maximum number of entries in a menu section supported by
         * g_dbus_connection_export_menu_model().
         *
         * The exact value of the limit may change in future GLib versions.
         */
        const MENU_EXPORTER_MAX_SECTION_SIZE: number;
        /**
         * The name of the link that associates a menu item with a section.  The linked
         * menu will usually be shown in place of the menu item, using the item's label
         * as a header.
         *
         * See also g_menu_item_set_link().
         */
        const MENU_LINK_SECTION: string;
        /**
         * The name of the link that associates a menu item with a submenu.
         *
         * See also g_menu_item_set_link().
         */
        const MENU_LINK_SUBMENU: string;
        const NATIVE_VOLUME_MONITOR_EXTENSION_POINT_NAME: string;
        /**
         * Extension point for network status monitoring functionality.
         * See [Extending GIO](overview.html#extending-gio).
         */
        const NETWORK_MONITOR_EXTENSION_POINT_NAME: string;
        /**
         * Extension point for power profile usage monitoring functionality.
         * See [Extending GIO](overview.html#extending-gio).
         */
        const POWER_PROFILE_MONITOR_EXTENSION_POINT_NAME: string;
        /**
         * Extension point for proxy functionality.
         * See [Extending GIO](overview.html#extending-gio).
         */
        const PROXY_EXTENSION_POINT_NAME: string;
        /**
         * Extension point for proxy resolving functionality.
         * See [Extending GIO](overview.html#extending-gio).
         */
        const PROXY_RESOLVER_EXTENSION_POINT_NAME: string;
        /**
         * Extension point for #GSettingsBackend functionality.
         */
        const SETTINGS_BACKEND_EXTENSION_POINT_NAME: string;
        /**
         * Extension point for TLS functionality via #GTlsBackend.
         * See [Extending GIO](overview.html#extending-gio).
         */
        const TLS_BACKEND_EXTENSION_POINT_NAME: string;
        /**
         * The purpose used to verify the client certificate in a TLS connection.
         * Used by TLS servers.
         */
        const TLS_DATABASE_PURPOSE_AUTHENTICATE_CLIENT: string;
        /**
         * The purpose used to verify the server certificate in a TLS connection. This
         * is the most common purpose in use. Used by TLS clients.
         */
        const TLS_DATABASE_PURPOSE_AUTHENTICATE_SERVER: string;
        /**
         * Extension point for #GVfs functionality.
         * See [Extending GIO](overview.html#extending-gio).
         */
        const VFS_EXTENSION_POINT_NAME: string;
        /**
         * The string used to obtain the volume class with g_volume_get_identifier().
         *
         * Known volume classes include `device`, `network`, and `loop`. Other
         * classes may be added in the future.
         *
         * This is intended to be used by applications to classify #GVolume
         * instances into different sections - for example a file manager or
         * file chooser can use this information to show `network` volumes under
         * a "Network" heading and `device` volumes under a "Devices" heading.
         */
        const VOLUME_IDENTIFIER_KIND_CLASS: string;
        /**
         * The string used to obtain a Hal UDI with g_volume_get_identifier().
         */
        const VOLUME_IDENTIFIER_KIND_HAL_UDI: string;
        /**
         * The string used to obtain a filesystem label with g_volume_get_identifier().
         */
        const VOLUME_IDENTIFIER_KIND_LABEL: string;
        /**
         * The string used to obtain a NFS mount with g_volume_get_identifier().
         */
        const VOLUME_IDENTIFIER_KIND_NFS_MOUNT: string;
        /**
         * The string used to obtain a Unix device path with g_volume_get_identifier().
         */
        const VOLUME_IDENTIFIER_KIND_UNIX_DEVICE: string;
        /**
         * The string used to obtain a UUID with g_volume_get_identifier().
         */
        const VOLUME_IDENTIFIER_KIND_UUID: string;
        /**
         * Extension point for volume monitor functionality.
         * See [Extending GIO](overview.html#extending-gio).
         */
        const VOLUME_MONITOR_EXTENSION_POINT_NAME: string;
        /**
         * Checks if `action_name` is valid.
         *
         * `action_name` is valid if it consists only of alphanumeric characters,
         * plus `-` and `.`.  The empty string is not a valid action name.
         *
         * It is an error to call this function with a non-UTF-8 `action_name`.
         * `action_name` must not be `NULL`.
         * @param action_name a potential action name
         * @returns `TRUE` if @action_name is valid
         */
        function action_name_is_valid(action_name: string): boolean;
        /**
         * Parses a detailed action name into its separate name and target
         * components.
         *
         * Detailed action names can have three formats.
         *
         * The first format is used to represent an action name with no target
         * value and consists of just an action name containing no whitespace
         * nor the characters `:`, `(` or `)`.  For example: `app.action`.
         *
         * The second format is used to represent an action with a target value
         * that is a non-empty string consisting only of alphanumerics, plus `-`
         * and `.`.  In that case, the action name and target value are
         * separated by a double colon (`::`).  For example:
         * `app.action::target`.
         *
         * The third format is used to represent an action with any type of
         * target value, including strings.  The target value follows the action
         * name, surrounded in parens.  For example: `app.action(42)`.  The
         * target value is parsed using [func`GLib`.Variant.parse].  If a tuple-typed
         * value is desired, it must be specified in the same way, resulting in
         * two sets of parens, for example: `app.action((1,2,3))`.  A string
         * target can be specified this way as well: `app.action('target')`.
         * For strings, this third format must be used if target value is
         * empty or contains characters other than alphanumerics, `-` and `.`.
         *
         * If this function returns `TRUE`, a non-`NULL` value is guaranteed to be returned
         * in `action_name` (if a pointer is passed in). A `NULL` value may still be
         * returned in `target_value,` as the `detailed_name` may not contain a target.
         *
         * If returned, the [type`GLib`.Variant] in `target_value` is guaranteed to not be floating.
         * @param detailed_name a detailed action name
         * @returns `TRUE` if successful, else `FALSE` with @error set
         */
        function action_parse_detailed_name(detailed_name: string): [boolean, string, GLib.Variant | null];
        /**
         * Formats a detailed action name from `action_name` and `target_value`.
         *
         * It is an error to call this function with an invalid action name.
         *
         * This function is the opposite of [func`Gio`.Action.parse_detailed_name].
         * It will produce a string that can be parsed back to the `action_name`
         * and `target_value` by that function.
         *
         * See that function for the types of strings that will be printed by
         * this function.
         * @param action_name a valid action name
         * @param target_value a [type@GLib.Variant] target value, or `NULL`
         * @returns a detailed format string
         */
        function action_print_detailed_name(action_name: string, target_value?: GLib.Variant | null): string;
        /**
         * Creates a new [iface`Gio`.AppInfo] from the given information.
         *
         * Note that for `commandline,` the quoting rules of the `Exec` key of the
         * [freedesktop.org Desktop Entry Specification](http://freedesktop.org/Standards/desktop-entry-spec)
         * are applied. For example, if the `commandline` contains
         * percent-encoded URIs, the percent-character must be doubled in order to prevent it from
         * being swallowed by `Exec` key unquoting. See
         * [the specification](https://specifications.freedesktop.org/desktop-entry-spec/latest/ar01s07.html)
         * for exact quoting rules.
         * @param commandline the command line to use
         * @param application_name the application name, or `NULL` to use @commandline
         * @param flags flags that can specify details of the created [iface@Gio.AppInfo]
         * @returns new [iface@Gio.AppInfo] for given command.
         */
        function app_info_create_from_commandline(
            commandline: string,
            application_name: string | null,
            flags: AppInfoCreateFlags | null,
        ): AppInfo;
        /**
         * Gets a list of all of the applications currently registered
         * on this system.
         *
         * For desktop files, this includes applications that have
         * [`NoDisplay=true`](https://specifications.freedesktop.org/desktop-entry-spec/latest/ar01s06.html#key-nodisplay)
         * set or are excluded from display by means of
         * [`OnlyShowIn`](https://specifications.freedesktop.org/desktop-entry-spec/latest/ar01s06.html#key-onlyshowin)
         * or [`NotShowIn`](https://specifications.freedesktop.org/desktop-entry-spec/latest/ar01s06.html#key-notshowin).
         * See [method`Gio`.AppInfo.should_show].
         *
         * The returned list does not include applications which have the
         * [`Hidden` key](https://specifications.freedesktop.org/desktop-entry-spec/latest/ar01s06.html#key-hidden)
         * set.
         * @returns a newly allocated   list of references to [iface@Gio.AppInfo]s.
         */
        function app_info_get_all(): AppInfo[];
        /**
         * Gets a list of all [iface`Gio`.AppInfo]s for a given content type,
         * including the recommended and fallback [iface`Gio`.AppInfo]s. See
         * [func`Gio`.AppInfo.get_recommended_for_type] and
         * [func`Gio`.AppInfo.get_fallback_for_type].
         * @param content_type the content type to find a [iface@Gio.AppInfo] for
         * @returns list of   [iface@Gio.AppInfo]s for given @content_type.
         */
        function app_info_get_all_for_type(content_type: string): AppInfo[];
        /**
         * Gets the default [iface`Gio`.AppInfo] for a given content type.
         * @param content_type the content type to find a [iface@Gio.AppInfo] for
         * @param must_support_uris if `TRUE`, the [iface@Gio.AppInfo] is expected to   support URIs
         * @returns [iface@Gio.AppInfo] for given   @content_type or `NULL` on error.
         */
        function app_info_get_default_for_type(content_type: string, must_support_uris: boolean): AppInfo | null;
        /**
         * Asynchronously gets the default [iface`Gio`.AppInfo] for a given content
         * type.
         * @param content_type the content type to find a [iface@Gio.AppInfo] for
         * @param must_support_uris if `TRUE`, the [iface@Gio.AppInfo] is expected to   support URIs
         * @param cancellable a [class@Gio.Cancellable]
         */
        function app_info_get_default_for_type_async(
            content_type: string,
            must_support_uris: boolean,
            cancellable?: Cancellable | null,
        ): Promise<AppInfo>;
        /**
         * Asynchronously gets the default [iface`Gio`.AppInfo] for a given content
         * type.
         * @param content_type the content type to find a [iface@Gio.AppInfo] for
         * @param must_support_uris if `TRUE`, the [iface@Gio.AppInfo] is expected to   support URIs
         * @param cancellable a [class@Gio.Cancellable]
         * @param callback a [type@Gio.AsyncReadyCallback] to call   when the request is done
         */
        function app_info_get_default_for_type_async(
            content_type: string,
            must_support_uris: boolean,
            cancellable: Cancellable | null,
            callback: AsyncReadyCallback<string> | null,
        ): void;
        /**
         * Asynchronously gets the default [iface`Gio`.AppInfo] for a given content
         * type.
         * @param content_type the content type to find a [iface@Gio.AppInfo] for
         * @param must_support_uris if `TRUE`, the [iface@Gio.AppInfo] is expected to   support URIs
         * @param cancellable a [class@Gio.Cancellable]
         * @param callback a [type@Gio.AsyncReadyCallback] to call   when the request is done
         */
        function app_info_get_default_for_type_async(
            content_type: string,
            must_support_uris: boolean,
            cancellable?: Cancellable | null,
            callback?: AsyncReadyCallback<string> | null,
        ): Promise<AppInfo> | void;
        /**
         * Finishes a default [iface`Gio`.AppInfo] lookup started by
         * [func`Gio`.AppInfo.get_default_for_type_async].
         *
         * If no #[iface`Gio`.AppInfo] is found, then `error` will be set to
         * [error`Gio`.IOErrorEnum.NOT_FOUND].
         * @param result the async result
         * @returns [iface@Gio.AppInfo] for given @content_type or   `NULL` on error.
         */
        function app_info_get_default_for_type_finish(result: AsyncResult): AppInfo;
        /**
         * Gets the default application for handling URIs with the given URI scheme.
         *
         * A URI scheme is the initial part of the URI, up to but not including the `:`.
         * For example, `http`, `ftp` or `sip`.
         * @param uri_scheme a string containing a URI scheme.
         * @returns [iface@Gio.AppInfo] for given   @uri_scheme or `NULL` on error.
         */
        function app_info_get_default_for_uri_scheme(uri_scheme: string): AppInfo | null;
        /**
         * Asynchronously gets the default application for handling URIs with
         * the given URI scheme. A URI scheme is the initial part
         * of the URI, up to but not including the `:`, e.g. `http`,
         * `ftp` or `sip`.
         * @param uri_scheme a string containing a URI scheme.
         * @param cancellable a [class@Gio.Cancellable]
         */
        function app_info_get_default_for_uri_scheme_async(
            uri_scheme: string,
            cancellable?: Cancellable | null,
        ): Promise<AppInfo>;
        /**
         * Asynchronously gets the default application for handling URIs with
         * the given URI scheme. A URI scheme is the initial part
         * of the URI, up to but not including the `:`, e.g. `http`,
         * `ftp` or `sip`.
         * @param uri_scheme a string containing a URI scheme.
         * @param cancellable a [class@Gio.Cancellable]
         * @param callback a [type@Gio.AsyncReadyCallback] to call   when the request is done
         */
        function app_info_get_default_for_uri_scheme_async(
            uri_scheme: string,
            cancellable: Cancellable | null,
            callback: AsyncReadyCallback<string> | null,
        ): void;
        /**
         * Asynchronously gets the default application for handling URIs with
         * the given URI scheme. A URI scheme is the initial part
         * of the URI, up to but not including the `:`, e.g. `http`,
         * `ftp` or `sip`.
         * @param uri_scheme a string containing a URI scheme.
         * @param cancellable a [class@Gio.Cancellable]
         * @param callback a [type@Gio.AsyncReadyCallback] to call   when the request is done
         */
        function app_info_get_default_for_uri_scheme_async(
            uri_scheme: string,
            cancellable?: Cancellable | null,
            callback?: AsyncReadyCallback<string> | null,
        ): Promise<AppInfo> | void;
        /**
         * Finishes a default [iface`Gio`.AppInfo] lookup started by
         * [func`Gio`.AppInfo.get_default_for_uri_scheme_async].
         *
         * If no [iface`Gio`.AppInfo] is found, then `error` will be set to
         * [error`Gio`.IOErrorEnum.NOT_FOUND].
         * @param result the async result
         * @returns [iface@Gio.AppInfo] for given @uri_scheme or   `NULL` on error.
         */
        function app_info_get_default_for_uri_scheme_finish(result: AsyncResult): AppInfo;
        /**
         * Gets a list of fallback [iface`Gio`.AppInfo]s for a given content type, i.e.
         * those applications which claim to support the given content type by MIME
         * type subclassing and not directly.
         * @param content_type the content type to find a [iface@Gio.AppInfo] for
         * @returns list of [iface@Gio.AppInfo]s     for given @content_type or `NULL` on error.
         */
        function app_info_get_fallback_for_type(content_type: string): AppInfo[];
        /**
         * Gets a list of recommended [iface`Gio`.AppInfo]s for a given content type,
         * i.e. those applications which claim to support the given content type
         * exactly, and not by MIME type subclassing.
         *
         * Note that the first application of the list is the last used one, i.e.
         * the last one for which [method`Gio`.AppInfo.set_as_last_used_for_type] has
         * been called.
         * @param content_type the content type to find a [iface@Gio.AppInfo] for
         * @returns list of   [iface@Gio.AppInfo]s for given @content_type or `NULL` on error.
         */
        function app_info_get_recommended_for_type(content_type: string): AppInfo[];
        /**
         * Utility function that launches the default application registered to handle
         * the specified uri. Synchronous I/O is done on the uri to detect the type of
         * the file if required.
         *
         * The D-Bus–activated applications don’t have to be started if your application
         * terminates too soon after this function. To prevent this, use
         * [func`Gio`.AppInfo.launch_default_for_uri_async] instead.
         * @param uri the uri to show
         * @param context optional launch context
         * @returns `TRUE` on success, `FALSE` on error.
         */
        function app_info_launch_default_for_uri(uri: string, context?: AppLaunchContext | null): boolean;
        /**
         * Async version of [func`Gio`.AppInfo.launch_default_for_uri].
         *
         * This version is useful if you are interested in receiving error information
         * in the case where the application is sandboxed and the portal may present an
         * application chooser dialog to the user.
         *
         * This is also useful if you want to be sure that the D-Bus–activated
         * applications are really started before termination and if you are interested
         * in receiving error information from their activation.
         * @param uri the uri to show
         * @param context optional launch context
         * @param cancellable a [class@Gio.Cancellable]
         */
        function app_info_launch_default_for_uri_async(
            uri: string,
            context?: AppLaunchContext | null,
            cancellable?: Cancellable | null,
        ): Promise<boolean>;
        /**
         * Async version of [func`Gio`.AppInfo.launch_default_for_uri].
         *
         * This version is useful if you are interested in receiving error information
         * in the case where the application is sandboxed and the portal may present an
         * application chooser dialog to the user.
         *
         * This is also useful if you want to be sure that the D-Bus–activated
         * applications are really started before termination and if you are interested
         * in receiving error information from their activation.
         * @param uri the uri to show
         * @param context optional launch context
         * @param cancellable a [class@Gio.Cancellable]
         * @param callback a [type@Gio.AsyncReadyCallback] to call   when the request is done
         */
        function app_info_launch_default_for_uri_async(
            uri: string,
            context: AppLaunchContext | null,
            cancellable: Cancellable | null,
            callback: AsyncReadyCallback<string> | null,
        ): void;
        /**
         * Async version of [func`Gio`.AppInfo.launch_default_for_uri].
         *
         * This version is useful if you are interested in receiving error information
         * in the case where the application is sandboxed and the portal may present an
         * application chooser dialog to the user.
         *
         * This is also useful if you want to be sure that the D-Bus–activated
         * applications are really started before termination and if you are interested
         * in receiving error information from their activation.
         * @param uri the uri to show
         * @param context optional launch context
         * @param cancellable a [class@Gio.Cancellable]
         * @param callback a [type@Gio.AsyncReadyCallback] to call   when the request is done
         */
        function app_info_launch_default_for_uri_async(
            uri: string,
            context?: AppLaunchContext | null,
            cancellable?: Cancellable | null,
            callback?: AsyncReadyCallback<string> | null,
        ): Promise<boolean> | void;
        /**
         * Finishes an asynchronous launch-default-for-uri operation.
         * @param result the async result
         * @returns `TRUE` if the launch was successful, `FALSE` if @error is set
         */
        function app_info_launch_default_for_uri_finish(result: AsyncResult): boolean;
        /**
         * Removes all changes to the type associations done by
         * [method`Gio`.AppInfo.set_as_default_for_type],
         * [method`Gio`.AppInfo.set_as_default_for_extension],
         * [method`Gio`.AppInfo.add_supports_type] or
         * [method`Gio`.AppInfo.remove_supports_type].
         * @param content_type a content type
         */
        function app_info_reset_type_associations(content_type: string): void;
        /**
         * Helper function for constructing #GAsyncInitable object. This is
         * similar to g_object_newv() but also initializes the object asynchronously.
         *
         * When the initialization is finished, `callback` will be called. You can
         * then call g_async_initable_new_finish() to get the new object and check
         * for any errors.
         * @param object_type a #GType supporting #GAsyncInitable.
         * @param n_parameters the number of parameters in @parameters
         * @param parameters the parameters to use to construct the object
         * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the operation
         * @param cancellable optional #GCancellable object, %NULL to ignore.
         * @param callback a #GAsyncReadyCallback to call when the initialization is     finished
         */
        function async_initable_newv_async(
            object_type: GObject.GType,
            n_parameters: number,
            parameters: GObject.Parameter,
            io_priority: number,
            cancellable?: Cancellable | null,
            callback?: AsyncReadyCallback<GObject.GType> | null,
        ): void;
        /**
         * Asynchronously connects to the message bus specified by `bus_type`.
         *
         * When the operation is finished, `callback` will be invoked. You can
         * then call g_bus_get_finish() to get the result of the operation.
         *
         * This is an asynchronous failable function. See g_bus_get_sync() for
         * the synchronous version.
         * @param bus_type a #GBusType
         * @param cancellable a #GCancellable or %NULL
         */
        function bus_get(bus_type: BusType | null, cancellable?: Cancellable | null): Promise<DBusConnection>;
        /**
         * Asynchronously connects to the message bus specified by `bus_type`.
         *
         * When the operation is finished, `callback` will be invoked. You can
         * then call g_bus_get_finish() to get the result of the operation.
         *
         * This is an asynchronous failable function. See g_bus_get_sync() for
         * the synchronous version.
         * @param bus_type a #GBusType
         * @param cancellable a #GCancellable or %NULL
         * @param callback a #GAsyncReadyCallback to call when the request is satisfied
         */
        function bus_get(
            bus_type: BusType | null,
            cancellable: Cancellable | null,
            callback: AsyncReadyCallback<BusType | null> | null,
        ): void;
        /**
         * Asynchronously connects to the message bus specified by `bus_type`.
         *
         * When the operation is finished, `callback` will be invoked. You can
         * then call g_bus_get_finish() to get the result of the operation.
         *
         * This is an asynchronous failable function. See g_bus_get_sync() for
         * the synchronous version.
         * @param bus_type a #GBusType
         * @param cancellable a #GCancellable or %NULL
         * @param callback a #GAsyncReadyCallback to call when the request is satisfied
         */
        function bus_get(
            bus_type: BusType | null,
            cancellable?: Cancellable | null,
            callback?: AsyncReadyCallback<BusType | null> | null,
        ): Promise<DBusConnection> | void;
        /**
         * Finishes an operation started with g_bus_get().
         *
         * The returned object is a singleton, that is, shared with other
         * callers of g_bus_get() and g_bus_get_sync() for `bus_type`. In the
         * event that you need a private message bus connection, use
         * g_dbus_address_get_for_bus_sync() and
         * g_dbus_connection_new_for_address() with
         * G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT and
         * G_DBUS_CONNECTION_FLAGS_MESSAGE_BUS_CONNECTION flags.
         *
         * Note that the returned #GDBusConnection object will (usually) have
         * the #GDBusConnection:exit-on-close property set to %TRUE.
         * @param res a #GAsyncResult obtained from the #GAsyncReadyCallback passed     to g_bus_get()
         * @returns a #GDBusConnection or %NULL if @error is set.     Free with g_object_unref().
         */
        function bus_get_finish(res: AsyncResult): DBusConnection;
        /**
         * Synchronously connects to the message bus specified by `bus_type`.
         * Note that the returned object may shared with other callers,
         * e.g. if two separate parts of a process calls this function with
         * the same `bus_type,` they will share the same object.
         *
         * This is a synchronous failable function. See g_bus_get() and
         * g_bus_get_finish() for the asynchronous version.
         *
         * The returned object is a singleton, that is, shared with other
         * callers of g_bus_get() and g_bus_get_sync() for `bus_type`. In the
         * event that you need a private message bus connection, use
         * g_dbus_address_get_for_bus_sync() and
         * g_dbus_connection_new_for_address() with
         * G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT and
         * G_DBUS_CONNECTION_FLAGS_MESSAGE_BUS_CONNECTION flags.
         *
         * Note that the returned #GDBusConnection object will (usually) have
         * the #GDBusConnection:exit-on-close property set to %TRUE.
         * @param bus_type a #GBusType
         * @param cancellable a #GCancellable or %NULL
         * @returns a #GDBusConnection or %NULL if @error is set.     Free with g_object_unref().
         */
        function bus_get_sync(bus_type: BusType | null, cancellable?: Cancellable | null): DBusConnection;
        /**
         * Version of g_bus_own_name() using closures instead of callbacks for
         * easier binding in other languages.
         * @param bus_type the type of bus to own a name on
         * @param name the well-known name to own
         * @param flags a set of flags from the #GBusNameOwnerFlags enumeration
         * @param bus_acquired_closure #GClosure to invoke when connected to     the bus of type @bus_type or %NULL
         * @param name_acquired_closure #GClosure to invoke when @name is     acquired or %NULL
         * @param name_lost_closure #GClosure to invoke when @name is lost or     %NULL
         * @returns an identifier (never 0) that can be used with     g_bus_unown_name() to stop owning the name.
         */
        function bus_own_name(
            bus_type: BusType | null,
            name: string,
            flags: BusNameOwnerFlags | null,
            bus_acquired_closure?: GObject.Closure | null,
            name_acquired_closure?: GObject.Closure | null,
            name_lost_closure?: GObject.Closure | null,
        ): number;
        /**
         * Version of g_bus_own_name_on_connection() using closures instead of
         * callbacks for easier binding in other languages.
         * @param connection a #GDBusConnection
         * @param name the well-known name to own
         * @param flags a set of flags from the #GBusNameOwnerFlags enumeration
         * @param name_acquired_closure #GClosure to invoke when @name is     acquired or %NULL
         * @param name_lost_closure #GClosure to invoke when @name is lost     or %NULL
         * @returns an identifier (never 0) that can be used with     g_bus_unown_name() to stop owning the name.
         */
        function bus_own_name_on_connection(
            connection: DBusConnection,
            name: string,
            flags: BusNameOwnerFlags | null,
            name_acquired_closure?: GObject.Closure | null,
            name_lost_closure?: GObject.Closure | null,
        ): number;
        /**
         * Stops owning a name.
         *
         * Note that there may still be D-Bus traffic to process (relating to owning
         * and unowning the name) in the current thread-default #GMainContext after
         * this function has returned. You should continue to iterate the #GMainContext
         * until the #GDestroyNotify function passed to g_bus_own_name() is called, in
         * order to avoid memory leaks through callbacks queued on the #GMainContext
         * after it’s stopped being iterated.
         * @param owner_id an identifier obtained from g_bus_own_name()
         */
        function bus_unown_name(owner_id: number): void;
        /**
         * Stops watching a name.
         *
         * Note that there may still be D-Bus traffic to process (relating to watching
         * and unwatching the name) in the current thread-default #GMainContext after
         * this function has returned. You should continue to iterate the #GMainContext
         * until the #GDestroyNotify function passed to g_bus_watch_name() is called, in
         * order to avoid memory leaks through callbacks queued on the #GMainContext
         * after it’s stopped being iterated.
         * @param watcher_id An identifier obtained from g_bus_watch_name()
         */
        function bus_unwatch_name(watcher_id: number): void;
        /**
         * Version of g_bus_watch_name() using closures instead of callbacks for
         * easier binding in other languages.
         * @param bus_type The type of bus to watch a name on.
         * @param name The name (well-known or unique) to watch.
         * @param flags Flags from the #GBusNameWatcherFlags enumeration.
         * @param name_appeared_closure #GClosure to invoke when @name is known to exist or %NULL.
         * @param name_vanished_closure #GClosure to invoke when @name is known to not exist or %NULL.
         * @returns An identifier (never 0) that can be used with g_bus_unwatch_name() to stop watching the name.
         */
        function bus_watch_name(
            bus_type: BusType | null,
            name: string,
            flags: BusNameWatcherFlags | null,
            name_appeared_closure?: GObject.Closure | null,
            name_vanished_closure?: GObject.Closure | null,
        ): number;
        /**
         * Version of g_bus_watch_name_on_connection() using closures instead of callbacks for
         * easier binding in other languages.
         * @param connection A #GDBusConnection.
         * @param name The name (well-known or unique) to watch.
         * @param flags Flags from the #GBusNameWatcherFlags enumeration.
         * @param name_appeared_closure #GClosure to invoke when @name is known to exist or %NULL.
         * @param name_vanished_closure #GClosure to invoke when @name is known to not exist or %NULL.
         * @returns An identifier (never 0) that can be used with g_bus_unwatch_name() to stop watching the name.
         */
        function bus_watch_name_on_connection(
            connection: DBusConnection,
            name: string,
            flags: BusNameWatcherFlags | null,
            name_appeared_closure?: GObject.Closure | null,
            name_vanished_closure?: GObject.Closure | null,
        ): number;
        /**
         * Checks if a content type can be executable. Note that for instance
         * things like text files can be executables (i.e. scripts and batch files).
         * @param type a content type string
         * @returns %TRUE if the file type corresponds to a type that     can be executable, %FALSE otherwise.
         */
        function content_type_can_be_executable(type: string): boolean;
        /**
         * Compares two content types for equality.
         * @param type1 a content type string
         * @param type2 a content type string
         * @returns %TRUE if the two strings are identical or equivalent,     %FALSE otherwise.
         */
        function content_type_equals(type1: string, type2: string): boolean;
        /**
         * Tries to find a content type based on the mime type name.
         * @param mime_type a mime type string
         * @returns Newly allocated string with content type or     %NULL. Free with g_free()
         */
        function content_type_from_mime_type(mime_type: string): string | null;
        /**
         * Gets the human readable description of the content type.
         * @param type a content type string
         * @returns a short description of the content type @type. Free the     returned string with g_free()
         */
        function content_type_get_description(type: string): string;
        /**
         * Gets the generic icon name for a content type.
         *
         * See the
         * [shared-mime-info](http://www.freedesktop.org/wiki/Specifications/shared-mime-info-spec)
         * specification for more on the generic icon name.
         * @param type a content type string
         * @returns the registered generic icon name for the given @type,     or %NULL if unknown. Free with g_free()
         */
        function content_type_get_generic_icon_name(type: string): string | null;
        /**
         * Gets the icon for a content type.
         * @param type a content type string
         * @returns #GIcon corresponding to the content type. Free the returned     object with g_object_unref()
         */
        function content_type_get_icon(type: string): Icon;
        /**
         * Get the list of directories which MIME data is loaded from. See
         * g_content_type_set_mime_dirs() for details.
         * @returns %NULL-terminated list of    directories to load MIME data from, including any `mime/` subdirectory,    and with the first directory to try listed first
         */
        function content_type_get_mime_dirs(): string[];
        /**
         * Gets the mime type for the content type, if one is registered.
         * @param type a content type string
         * @returns the registered mime type for the     given @type, or %NULL if unknown; free with g_free().
         */
        function content_type_get_mime_type(type: string): string | null;
        /**
         * Gets the symbolic icon for a content type.
         * @param type a content type string
         * @returns symbolic #GIcon corresponding to the content type.     Free the returned object with g_object_unref()
         */
        function content_type_get_symbolic_icon(type: string): Icon;
        /**
         * Guesses the content type based on example data. If the function is
         * uncertain, `result_uncertain` will be set to %TRUE. Either `filename`
         * or `data` may be %NULL, in which case the guess will be based solely
         * on the other argument.
         * @param filename a path, or %NULL
         * @param data a stream of data, or %NULL
         * @returns a string indicating a guessed content type for the     given data. Free with g_free()
         */
        function content_type_guess(filename: string | null, data: Uint8Array | null): [string, boolean];
        /**
         * Tries to guess the type of the tree with root `root,` by
         * looking at the files it contains. The result is an array
         * of content types, with the best guess coming first.
         *
         * The types returned all have the form x-content/foo, e.g.
         * x-content/audio-cdda (for audio CDs) or x-content/image-dcf
         * (for a camera memory card). See the
         * [shared-mime-info](http://www.freedesktop.org/wiki/Specifications/shared-mime-info-spec)
         * specification for more on x-content types.
         *
         * This function is useful in the implementation of
         * g_mount_guess_content_type().
         * @param root the root of the tree to guess a type for
         * @returns an %NULL-terminated     array of zero or more content types. Free with g_strfreev()
         */
        function content_type_guess_for_tree(root: File): string[];
        /**
         * Determines if `type` is a subset of `supertype`.
         * @param type a content type string
         * @param supertype a content type string
         * @returns %TRUE if @type is a kind of @supertype,     %FALSE otherwise.
         */
        function content_type_is_a(type: string, supertype: string): boolean;
        /**
         * Determines if `type` is a subset of `mime_type`.
         * Convenience wrapper around g_content_type_is_a().
         * @param type a content type string
         * @param mime_type a mime type string
         * @returns %TRUE if @type is a kind of @mime_type,     %FALSE otherwise.
         */
        function content_type_is_mime_type(type: string, mime_type: string): boolean;
        /**
         * Checks if the content type is the generic "unknown" type.
         * On UNIX this is the "application/octet-stream" mimetype,
         * while on win32 it is "*" and on OSX it is a dynamic type
         * or octet-stream.
         * @param type a content type string
         * @returns %TRUE if the type is the unknown type.
         */
        function content_type_is_unknown(type: string): boolean;
        /**
         * Set the list of directories used by GIO to load the MIME database.
         * If `dirs` is %NULL, the directories used are the default:
         *
         *  - the `mime` subdirectory of the directory in `$XDG_DATA_HOME`
         *  - the `mime` subdirectory of every directory in `$XDG_DATA_DIRS`
         *
         * This function is intended to be used when writing tests that depend on
         * information stored in the MIME database, in order to control the data.
         *
         * Typically, in case your tests use %G_TEST_OPTION_ISOLATE_DIRS, but they
         * depend on the system’s MIME database, you should call this function
         * with `dirs` set to %NULL before calling g_test_init(), for instance:
         *
         *
         * ```c
         *   // Load MIME data from the system
         *   g_content_type_set_mime_dirs (NULL);
         *   // Isolate the environment
         *   g_test_init (&argc, &argv, G_TEST_OPTION_ISOLATE_DIRS, NULL);
         *
         *   …
         *
         *   return g_test_run ();
         * ```
         *
         * @param dirs %NULL-terminated list of    directories to load MIME data from, including any `mime/` subdirectory,    and with the first directory to try listed first
         */
        function content_type_set_mime_dirs(dirs?: string[] | null): void;
        /**
         * Gets a list of strings containing all the registered content types
         * known to the system. The list and its data should be freed using
         * `g_list_free_full (list, g_free)`.
         * @returns list of the registered     content types
         */
        function content_types_get_registered(): string[];
        /**
         * Escape `string` so it can appear in a D-Bus address as the value
         * part of a key-value pair.
         *
         * For instance, if `string` is `/run/bus-for-:0`,
         * this function would return `/run/bus-for-%3A0`,
         * which could be used in a D-Bus address like
         * `unix:nonce-tcp:host=127.0.0.1,port=42,noncefile=/run/bus-for-%3A0`.
         * @param string an unescaped string to be included in a D-Bus address     as the value in a key-value pair
         * @returns a copy of @string with all     non-optionally-escaped bytes escaped
         */
        function dbus_address_escape_value(string: string): string;
        /**
         * Synchronously looks up the D-Bus address for the well-known message
         * bus instance specified by `bus_type`. This may involve using various
         * platform specific mechanisms.
         *
         * The returned address will be in the
         * [D-Bus address format](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses).
         * @param bus_type a #GBusType
         * @param cancellable a #GCancellable or %NULL
         * @returns a valid D-Bus address string for @bus_type or     %NULL if @error is set
         */
        function dbus_address_get_for_bus_sync(bus_type: BusType | null, cancellable?: Cancellable | null): string;
        /**
         * Asynchronously connects to an endpoint specified by `address` and
         * sets up the connection so it is in a state to run the client-side
         * of the D-Bus authentication conversation. `address` must be in the
         * [D-Bus address format](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses).
         *
         * When the operation is finished, `callback` will be invoked. You can
         * then call g_dbus_address_get_stream_finish() to get the result of
         * the operation.
         *
         * This is an asynchronous failable function. See
         * g_dbus_address_get_stream_sync() for the synchronous version.
         * @param address A valid D-Bus address.
         * @param cancellable A #GCancellable or %NULL.
         */
        function dbus_address_get_stream(
            address: string,
            cancellable?: Cancellable | null,
        ): Promise<[IOStream, string]>;
        /**
         * Asynchronously connects to an endpoint specified by `address` and
         * sets up the connection so it is in a state to run the client-side
         * of the D-Bus authentication conversation. `address` must be in the
         * [D-Bus address format](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses).
         *
         * When the operation is finished, `callback` will be invoked. You can
         * then call g_dbus_address_get_stream_finish() to get the result of
         * the operation.
         *
         * This is an asynchronous failable function. See
         * g_dbus_address_get_stream_sync() for the synchronous version.
         * @param address A valid D-Bus address.
         * @param cancellable A #GCancellable or %NULL.
         * @param callback A #GAsyncReadyCallback to call when the request is satisfied.
         */
        function dbus_address_get_stream(
            address: string,
            cancellable: Cancellable | null,
            callback: AsyncReadyCallback<string> | null,
        ): void;
        /**
         * Asynchronously connects to an endpoint specified by `address` and
         * sets up the connection so it is in a state to run the client-side
         * of the D-Bus authentication conversation. `address` must be in the
         * [D-Bus address format](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses).
         *
         * When the operation is finished, `callback` will be invoked. You can
         * then call g_dbus_address_get_stream_finish() to get the result of
         * the operation.
         *
         * This is an asynchronous failable function. See
         * g_dbus_address_get_stream_sync() for the synchronous version.
         * @param address A valid D-Bus address.
         * @param cancellable A #GCancellable or %NULL.
         * @param callback A #GAsyncReadyCallback to call when the request is satisfied.
         */
        function dbus_address_get_stream(
            address: string,
            cancellable?: Cancellable | null,
            callback?: AsyncReadyCallback<string> | null,
        ): Promise<[IOStream, string]> | void;
        /**
         * Finishes an operation started with g_dbus_address_get_stream().
         *
         * A server is not required to set a GUID, so `out_guid` may be set to %NULL
         * even on success.
         * @param res A #GAsyncResult obtained from the GAsyncReadyCallback passed to g_dbus_address_get_stream().
         * @returns A #GIOStream or %NULL if @error is set.
         */
        function dbus_address_get_stream_finish(res: AsyncResult): [IOStream, string];
        /**
         * Synchronously connects to an endpoint specified by `address` and
         * sets up the connection so it is in a state to run the client-side
         * of the D-Bus authentication conversation. `address` must be in the
         * [D-Bus address format](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses).
         *
         * A server is not required to set a GUID, so `out_guid` may be set to %NULL
         * even on success.
         *
         * This is a synchronous failable function. See
         * g_dbus_address_get_stream() for the asynchronous version.
         * @param address A valid D-Bus address.
         * @param cancellable A #GCancellable or %NULL.
         * @returns A #GIOStream or %NULL if @error is set.
         */
        function dbus_address_get_stream_sync(address: string, cancellable?: Cancellable | null): [IOStream, string];
        /**
         * Looks up the value of an annotation.
         *
         * The cost of this function is O(n) in number of annotations.
         * @param annotations A %NULL-terminated array of annotations or %NULL.
         * @param name The name of the annotation to look up.
         * @returns The value or %NULL if not found. Do not free, it is owned by @annotations.
         */
        function dbus_annotation_info_lookup(annotations: DBusAnnotationInfo[] | null, name: string): string | null;
        /**
         * Creates a D-Bus error name to use for `error`. If `error` matches
         * a registered error (cf. g_dbus_error_register_error()), the corresponding
         * D-Bus error name will be returned.
         *
         * Otherwise the a name of the form
         * `org.gtk.GDBus.UnmappedGError.Quark._ESCAPED_QUARK_NAME.Code_ERROR_CODE`
         * will be used. This allows other GDBus applications to map the error
         * on the wire back to a #GError using g_dbus_error_new_for_dbus_error().
         *
         * This function is typically only used in object mappings to put a
         * #GError on the wire. Regular applications should not use it.
         * @param error A #GError.
         * @returns A D-Bus error name (never %NULL).     Free with g_free().
         */
        function dbus_error_encode_gerror(error: GLib.Error): string;
        /**
         * Gets the D-Bus error name used for `error,` if any.
         *
         * This function is guaranteed to return a D-Bus error name for all
         * #GErrors returned from functions handling remote method calls
         * (e.g. g_dbus_connection_call_finish()) unless
         * g_dbus_error_strip_remote_error() has been used on `error`.
         * @param error a #GError
         * @returns an allocated string or %NULL if the     D-Bus error name could not be found. Free with g_free().
         */
        function dbus_error_get_remote_error(error: GLib.Error): string | null;
        /**
         * Checks if `error` represents an error received via D-Bus from a remote peer. If so,
         * use g_dbus_error_get_remote_error() to get the name of the error.
         * @param error A #GError.
         * @returns %TRUE if @error represents an error from a remote peer, %FALSE otherwise.
         */
        function dbus_error_is_remote_error(error: GLib.Error): boolean;
        /**
         * Creates a #GError based on the contents of `dbus_error_name` and
         * `dbus_error_message`.
         *
         * Errors registered with g_dbus_error_register_error() will be looked
         * up using `dbus_error_name` and if a match is found, the error domain
         * and code is used. Applications can use g_dbus_error_get_remote_error()
         * to recover `dbus_error_name`.
         *
         * If a match against a registered error is not found and the D-Bus
         * error name is in a form as returned by g_dbus_error_encode_gerror()
         * the error domain and code encoded in the name is used to
         * create the #GError. Also, `dbus_error_name` is added to the error message
         * such that it can be recovered with g_dbus_error_get_remote_error().
         *
         * Otherwise, a #GError with the error code %G_IO_ERROR_DBUS_ERROR
         * in the %G_IO_ERROR error domain is returned. Also, `dbus_error_name` is
         * added to the error message such that it can be recovered with
         * g_dbus_error_get_remote_error().
         *
         * In all three cases, `dbus_error_name` can always be recovered from the
         * returned #GError using the g_dbus_error_get_remote_error() function
         * (unless g_dbus_error_strip_remote_error() hasn't been used on the returned error).
         *
         * This function is typically only used in object mappings to prepare
         * #GError instances for applications. Regular applications should not use
         * it.
         * @param dbus_error_name D-Bus error name.
         * @param dbus_error_message D-Bus error message.
         * @returns An allocated #GError. Free with g_error_free().
         */
        function dbus_error_new_for_dbus_error(dbus_error_name: string, dbus_error_message: string): GLib.Error;
        function dbus_error_quark(): GLib.Quark;
        /**
         * Creates an association to map between `dbus_error_name` and
         * #GErrors specified by `error_domain` and `error_code`.
         *
         * This is typically done in the routine that returns the #GQuark for
         * an error domain.
         * @param error_domain A #GQuark for an error domain.
         * @param error_code An error code.
         * @param dbus_error_name A D-Bus error name.
         * @returns %TRUE if the association was created, %FALSE if it already exists.
         */
        function dbus_error_register_error(
            error_domain: GLib.Quark,
            error_code: number,
            dbus_error_name: string,
        ): boolean;
        /**
         * Helper function for associating a #GError error domain with D-Bus error names.
         *
         * While `quark_volatile` has a `volatile` qualifier, this is a historical
         * artifact and the argument passed to it should not be `volatile`.
         * @param error_domain_quark_name The error domain name.
         * @param quark_volatile A pointer where to store the #GQuark.
         * @param entries A pointer to @num_entries #GDBusErrorEntry struct items.
         */
        function dbus_error_register_error_domain(
            error_domain_quark_name: string,
            quark_volatile: number,
            entries: DBusErrorEntry[],
        ): void;
        /**
         * Looks for extra information in the error message used to recover
         * the D-Bus error name and strips it if found. If stripped, the
         * message field in `error` will correspond exactly to what was
         * received on the wire.
         *
         * This is typically used when presenting errors to the end user.
         * @param error A #GError.
         * @returns %TRUE if information was stripped, %FALSE otherwise.
         */
        function dbus_error_strip_remote_error(error: GLib.Error): boolean;
        /**
         * Destroys an association previously set up with g_dbus_error_register_error().
         * @param error_domain A #GQuark for an error domain.
         * @param error_code An error code.
         * @param dbus_error_name A D-Bus error name.
         * @returns %TRUE if the association was destroyed, %FALSE if it wasn't found.
         */
        function dbus_error_unregister_error(
            error_domain: GLib.Quark,
            error_code: number,
            dbus_error_name: string,
        ): boolean;
        /**
         * This is a language binding friendly version of g_dbus_escape_object_path_bytestring().
         * @param s the string to escape
         * @returns an escaped version of @s. Free with g_free().
         */
        function dbus_escape_object_path(s: string): string;
        /**
         * Escapes `bytes` for use in a D-Bus object path component.
         * `bytes` is an array of zero or more nonzero bytes in an
         * unspecified encoding, followed by a single zero byte.
         *
         * The escaping method consists of replacing all non-alphanumeric
         * characters (see g_ascii_isalnum()) with their hexadecimal value
         * preceded by an underscore (`_`). For example:
         * `foo.bar.baz` will become `foo_2ebar_2ebaz`.
         *
         * This method is appropriate to use when the input is nearly
         * a valid object path component but is not when your input
         * is far from being a valid object path component.
         * Other escaping algorithms are also valid to use with
         * D-Bus object paths.
         *
         * This can be reversed with g_dbus_unescape_object_path().
         * @param bytes the string of bytes to escape
         * @returns an escaped version of @bytes. Free with g_free().
         */
        function dbus_escape_object_path_bytestring(bytes: Uint8Array | string): string;
        /**
         * Generate a D-Bus GUID that can be used with
         * e.g. g_dbus_connection_new().
         *
         * See the
         * [D-Bus specification](https://dbus.freedesktop.org/doc/dbus-specification.html#uuids)
         * regarding what strings are valid D-Bus GUIDs. The specification refers to
         * these as ‘UUIDs’ whereas GLib (for historical reasons) refers to them as
         * ‘GUIDs’. The terms are interchangeable.
         *
         * Note that D-Bus GUIDs do not follow
         * [RFC 4122](https://datatracker.ietf.org/doc/html/rfc4122).
         * @returns A valid D-Bus GUID. Free with g_free().
         */
        function dbus_generate_guid(): string;
        /**
         * Converts a #GValue to a #GVariant of the type indicated by the `type`
         * parameter.
         *
         * The conversion is using the following rules:
         *
         * - `G_TYPE_STRING`: 's', 'o', 'g' or 'ay'
         * - `G_TYPE_STRV`: 'as', 'ao' or 'aay'
         * - `G_TYPE_BOOLEAN`: 'b'
         * - `G_TYPE_UCHAR`: 'y'
         * - `G_TYPE_INT`: 'i', 'n'
         * - `G_TYPE_UINT`: 'u', 'q'
         * - `G_TYPE_INT64`: 'x'
         * - `G_TYPE_UINT64`: 't'
         * - `G_TYPE_DOUBLE`: 'd'
         * - `G_TYPE_VARIANT`: Any #GVariantType
         *
         * This can fail if e.g. `gvalue` is of type %G_TYPE_STRING and `type`
         * is 'i', i.e. %G_VARIANT_TYPE_INT32. It will also fail for any #GType
         * (including e.g. %G_TYPE_OBJECT and %G_TYPE_BOXED derived-types) not
         * in the table above.
         *
         * Note that if `gvalue` is of type %G_TYPE_VARIANT and its value is
         * %NULL, the empty #GVariant instance (never %NULL) for `type` is
         * returned (e.g. 0 for scalar types, the empty string for string types,
         * '/' for object path types, the empty array for any array type and so on).
         *
         * See the g_dbus_gvariant_to_gvalue() function for how to convert a
         * #GVariant to a #GValue.
         * @param gvalue A #GValue to convert to a #GVariant
         * @param type A #GVariantType
         * @returns A #GVariant (never floating) of     #GVariantType @type holding the data from @gvalue or an empty #GVariant     in case of failure. Free with g_variant_unref().
         */
        function dbus_gvalue_to_gvariant(gvalue: GObject.Value | any, type: GLib.VariantType): GLib.Variant;
        /**
         * Converts a #GVariant to a #GValue. If `value` is floating, it is consumed.
         *
         * The rules specified in the g_dbus_gvalue_to_gvariant() function are
         * used - this function is essentially its reverse form. So, a #GVariant
         * containing any basic or string array type will be converted to a #GValue
         * containing a basic value or string array. Any other #GVariant (handle,
         * variant, tuple, dict entry) will be converted to a #GValue containing that
         * #GVariant.
         *
         * The conversion never fails - a valid #GValue is always returned in
         * `out_gvalue`.
         * @param value A #GVariant.
         */
        function dbus_gvariant_to_gvalue(value: GLib.Variant): unknown;
        /**
         * Checks if `string` is a
         * [D-Bus address](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses).
         *
         * This doesn't check if `string` is actually supported by #GDBusServer
         * or #GDBusConnection - use g_dbus_is_supported_address() to do more
         * checks.
         * @param string A string.
         * @returns %TRUE if @string is a valid D-Bus address, %FALSE otherwise.
         */
        function dbus_is_address(string: string): boolean;
        /**
         * Check whether `string` is a valid D-Bus error name.
         *
         * This function returns the same result as g_dbus_is_interface_name(),
         * because D-Bus error names are defined to have exactly the
         * same syntax as interface names.
         * @param string The string to check.
         * @returns %TRUE if valid, %FALSE otherwise.
         */
        function dbus_is_error_name(string: string): boolean;
        /**
         * Checks if `string` is a D-Bus GUID.
         *
         * See the documentation for g_dbus_generate_guid() for more information about
         * the format of a GUID.
         * @param string The string to check.
         * @returns %TRUE if @string is a GUID, %FALSE otherwise.
         */
        function dbus_is_guid(string: string): boolean;
        /**
         * Checks if `string` is a valid D-Bus interface name.
         * @param string The string to check.
         * @returns %TRUE if valid, %FALSE otherwise.
         */
        function dbus_is_interface_name(string: string): boolean;
        /**
         * Checks if `string` is a valid D-Bus member (e.g. signal or method) name.
         * @param string The string to check.
         * @returns %TRUE if valid, %FALSE otherwise.
         */
        function dbus_is_member_name(string: string): boolean;
        /**
         * Checks if `string` is a valid D-Bus bus name (either unique or well-known).
         * @param string The string to check.
         * @returns %TRUE if valid, %FALSE otherwise.
         */
        function dbus_is_name(string: string): boolean;
        /**
         * Like g_dbus_is_address() but also checks if the library supports the
         * transports in `string` and that key/value pairs for each transport
         * are valid. See the specification of the
         * [D-Bus address format](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses).
         * @param string A string.
         * @returns %TRUE if @string is a valid D-Bus address that is supported by this library, %FALSE if @error is set.
         */
        function dbus_is_supported_address(string: string): boolean;
        /**
         * Checks if `string` is a valid D-Bus unique bus name.
         * @param string The string to check.
         * @returns %TRUE if valid, %FALSE otherwise.
         */
        function dbus_is_unique_name(string: string): boolean;
        /**
         * Unescapes an string that was previously escaped with
         * g_dbus_escape_object_path(). If the string is in a format that could
         * not have been returned by g_dbus_escape_object_path(), this function
         * returns %NULL.
         *
         * Encoding alphanumeric characters which do not need to be
         * encoded is not allowed (e.g `_63` is not valid, the string
         * should contain `c` instead).
         * @param s the string to unescape
         * @returns an   unescaped version of @s, or %NULL if @s is not a string returned   from g_dbus_escape_object_path(). Free with g_free().
         */
        function dbus_unescape_object_path(s: string): Uint8Array | null;
        /**
         * Creates a new #GDtlsClientConnection wrapping `base_socket` which is
         * assumed to communicate with the server identified by `server_identity`.
         * @param base_socket the #GDatagramBased to wrap
         * @param server_identity the expected identity of the server
         * @returns the new   #GDtlsClientConnection, or %NULL on error
         */
        function dtls_client_connection_new(
            base_socket: DatagramBased,
            server_identity?: SocketConnectable | null,
        ): DtlsClientConnection;
        /**
         * Creates a new #GDtlsServerConnection wrapping `base_socket`.
         * @param base_socket the #GDatagramBased to wrap
         * @param certificate the default server certificate, or %NULL
         * @returns the new   #GDtlsServerConnection, or %NULL on error
         */
        function dtls_server_connection_new(
            base_socket: DatagramBased,
            certificate?: TlsCertificate | null,
        ): DtlsServerConnection;
        /**
         * Constructs a #GFile from a vector of elements using the correct
         * separator for filenames.
         *
         * Using this function is equivalent to calling g_build_filenamev(),
         * followed by g_file_new_for_path() on the result.
         * @param args %NULL-terminated   array of strings containing the path elements.
         * @returns a new #GFile
         */
        function file_new_build_filenamev(args: string[]): File;
        /**
         * Creates a #GFile with the given argument from the command line.
         * The value of `arg` can be either a URI, an absolute path or a
         * relative path resolved relative to the current working directory.
         * This operation never fails, but the returned object might not
         * support any I/O operation if `arg` points to a malformed path.
         *
         * Note that on Windows, this function expects its argument to be in
         * UTF-8 -- not the system code page.  This means that you
         * should not use this function with string from argv as it is passed
         * to main().  g_win32_get_command_line() will return a UTF-8 version of
         * the commandline.  #GApplication also uses UTF-8 but
         * g_application_command_line_create_file_for_arg() may be more useful
         * for you there.  It is also always possible to use this function with
         * #GOptionContext arguments of type %G_OPTION_ARG_FILENAME.
         * @param arg a command line string
         * @returns a new #GFile.   Free the returned object with g_object_unref().
         */
        function file_new_for_commandline_arg(arg: string): File;
        /**
         * Creates a #GFile with the given argument from the command line.
         *
         * This function is similar to g_file_new_for_commandline_arg() except
         * that it allows for passing the current working directory as an
         * argument instead of using the current working directory of the
         * process.
         *
         * This is useful if the commandline argument was given in a context
         * other than the invocation of the current process.
         *
         * See also g_application_command_line_create_file_for_arg().
         * @param arg a command line string
         * @param cwd the current working directory of the commandline
         * @returns a new #GFile
         */
        function file_new_for_commandline_arg_and_cwd(arg: string, cwd: string): File;
        /**
         * Constructs a #GFile for a given path. This operation never
         * fails, but the returned object might not support any I/O
         * operation if `path` is malformed.
         * @param path a string containing a relative or absolute path.   The string must be encoded in the glib filename encoding.
         * @returns a new #GFile for the given @path.   Free the returned object with g_object_unref().
         */
        function file_new_for_path(path: string): File;
        /**
         * Constructs a #GFile for a given URI. This operation never
         * fails, but the returned object might not support any I/O
         * operation if `uri` is malformed or if the uri type is
         * not supported.
         * @param uri a UTF-8 string containing a URI
         * @returns a new #GFile for the given @uri.   Free the returned object with g_object_unref().
         */
        function file_new_for_uri(uri: string): File;
        /**
         * Opens a file in the preferred directory for temporary files (as
         * returned by g_get_tmp_dir()) and returns a #GFile and
         * #GFileIOStream pointing to it.
         *
         * `tmpl` should be a string in the GLib file name encoding
         * containing a sequence of six 'X' characters, and containing no
         * directory components. If it is %NULL, a default template is used.
         *
         * Unlike the other #GFile constructors, this will return %NULL if
         * a temporary file could not be created.
         * @param tmpl Template for the file   name, as in g_file_open_tmp(), or %NULL for a default template
         * @returns a new #GFile.   Free the returned object with g_object_unref().
         */
        function file_new_tmp(tmpl: string | null): [File, FileIOStream];
        /**
         * Asynchronously opens a file in the preferred directory for temporary files
         *  (as returned by g_get_tmp_dir()) as g_file_new_tmp().
         *
         * `tmpl` should be a string in the GLib file name encoding
         * containing a sequence of six 'X' characters, and containing no
         * directory components. If it is %NULL, a default template is used.
         * @param tmpl Template for the file   name, as in g_file_open_tmp(), or %NULL for a default template
         * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
         * @param cancellable optional #GCancellable object, %NULL to ignore
         */
        function file_new_tmp_async(
            tmpl: string | null,
            io_priority: number,
            cancellable?: Cancellable | null,
        ): Promise<[File, FileIOStream]>;
        /**
         * Asynchronously opens a file in the preferred directory for temporary files
         *  (as returned by g_get_tmp_dir()) as g_file_new_tmp().
         *
         * `tmpl` should be a string in the GLib file name encoding
         * containing a sequence of six 'X' characters, and containing no
         * directory components. If it is %NULL, a default template is used.
         * @param tmpl Template for the file   name, as in g_file_open_tmp(), or %NULL for a default template
         * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
         * @param cancellable optional #GCancellable object, %NULL to ignore
         * @param callback a #GAsyncReadyCallback to call when the request is done
         */
        function file_new_tmp_async(
            tmpl: string | null,
            io_priority: number,
            cancellable: Cancellable | null,
            callback: AsyncReadyCallback<string | null> | null,
        ): void;
        /**
         * Asynchronously opens a file in the preferred directory for temporary files
         *  (as returned by g_get_tmp_dir()) as g_file_new_tmp().
         *
         * `tmpl` should be a string in the GLib file name encoding
         * containing a sequence of six 'X' characters, and containing no
         * directory components. If it is %NULL, a default template is used.
         * @param tmpl Template for the file   name, as in g_file_open_tmp(), or %NULL for a default template
         * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
         * @param cancellable optional #GCancellable object, %NULL to ignore
         * @param callback a #GAsyncReadyCallback to call when the request is done
         */
        function file_new_tmp_async(
            tmpl: string | null,
            io_priority: number,
            cancellable?: Cancellable | null,
            callback?: AsyncReadyCallback<string | null> | null,
        ): Promise<[File, FileIOStream]> | void;
        /**
         * Asynchronously creates a directory in the preferred directory for
         * temporary files (as returned by g_get_tmp_dir()) as g_dir_make_tmp().
         *
         * `tmpl` should be a string in the GLib file name encoding
         * containing a sequence of six 'X' characters, and containing no
         * directory components. If it is %NULL, a default template is used.
         * @param tmpl Template for the file   name, as in g_dir_make_tmp(), or %NULL for a default template
         * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
         * @param cancellable optional #GCancellable object, %NULL to ignore
         */
        function file_new_tmp_dir_async(
            tmpl: string | null,
            io_priority: number,
            cancellable?: Cancellable | null,
        ): Promise<File>;
        /**
         * Asynchronously creates a directory in the preferred directory for
         * temporary files (as returned by g_get_tmp_dir()) as g_dir_make_tmp().
         *
         * `tmpl` should be a string in the GLib file name encoding
         * containing a sequence of six 'X' characters, and containing no
         * directory components. If it is %NULL, a default template is used.
         * @param tmpl Template for the file   name, as in g_dir_make_tmp(), or %NULL for a default template
         * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
         * @param cancellable optional #GCancellable object, %NULL to ignore
         * @param callback a #GAsyncReadyCallback to call when the request is done
         */
        function file_new_tmp_dir_async(
            tmpl: string | null,
            io_priority: number,
            cancellable: Cancellable | null,
            callback: AsyncReadyCallback<string | null> | null,
        ): void;
        /**
         * Asynchronously creates a directory in the preferred directory for
         * temporary files (as returned by g_get_tmp_dir()) as g_dir_make_tmp().
         *
         * `tmpl` should be a string in the GLib file name encoding
         * containing a sequence of six 'X' characters, and containing no
         * directory components. If it is %NULL, a default template is used.
         * @param tmpl Template for the file   name, as in g_dir_make_tmp(), or %NULL for a default template
         * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
         * @param cancellable optional #GCancellable object, %NULL to ignore
         * @param callback a #GAsyncReadyCallback to call when the request is done
         */
        function file_new_tmp_dir_async(
            tmpl: string | null,
            io_priority: number,
            cancellable?: Cancellable | null,
            callback?: AsyncReadyCallback<string | null> | null,
        ): Promise<File> | void;
        /**
         * Finishes a temporary directory creation started by
         * g_file_new_tmp_dir_async().
         * @param result a #GAsyncResult
         * @returns a new #GFile.   Free the returned object with g_object_unref().
         */
        function file_new_tmp_dir_finish(result: AsyncResult): File;
        /**
         * Finishes a temporary file creation started by g_file_new_tmp_async().
         * @param result a #GAsyncResult
         * @returns a new #GFile.   Free the returned object with g_object_unref().
         */
        function file_new_tmp_finish(result: AsyncResult): [File, FileIOStream];
        /**
         * Constructs a #GFile with the given `parse_name` (i.e. something
         * given by g_file_get_parse_name()). This operation never fails,
         * but the returned object might not support any I/O operation if
         * the `parse_name` cannot be parsed.
         * @param parse_name a file name or path to be parsed
         * @returns a new #GFile.
         */
        function file_parse_name(parse_name: string): File;
        /**
         * Deserializes a #GIcon previously serialized using g_icon_serialize().
         * @param value a #GVariant created with g_icon_serialize()
         * @returns a #GIcon, or %NULL when deserialization fails.
         */
        function icon_deserialize(value: GLib.Variant): Icon | null;
        /**
         * Generate a #GIcon instance from `str`. This function can fail if
         * `str` is not valid - see g_icon_to_string() for discussion.
         *
         * If your application or library provides one or more #GIcon
         * implementations you need to ensure that each #GType is registered
         * with the type system prior to calling g_icon_new_for_string().
         * @param str A string obtained via g_icon_to_string().
         * @returns An object implementing the #GIcon          interface or %NULL if @error is set.
         */
        function icon_new_for_string(str: string): Icon;
        /**
         * Helper function for constructing #GInitable object. This is
         * similar to g_object_newv() but also initializes the object
         * and returns %NULL, setting an error on failure.
         * @param object_type a #GType supporting #GInitable.
         * @param parameters the parameters to use to construct the object
         * @param cancellable optional #GCancellable object, %NULL to ignore.
         * @returns a newly allocated      #GObject, or %NULL on error
         */
        function initable_newv<T = GObject.Object>(
            object_type: GObject.GType,
            parameters: GObject.Parameter[],
            cancellable?: Cancellable | null,
        ): T;
        /**
         * Converts `errno.h` error codes into GIO error codes.
         *
         * The fallback value %G_IO_ERROR_FAILED is returned for error codes not
         * currently handled (but note that future GLib releases may return a more
         * specific value instead).
         *
         * As `errno` is global and may be modified by intermediate function
         * calls, you should save its value immediately after the call returns,
         * and use the saved value instead of `errno`:
         *
         *
         *
         * ```c
         *   int saved_errno;
         *
         *   ret = read (blah);
         *   saved_errno = errno;
         *
         *   g_io_error_from_errno (saved_errno);
         * ```
         *
         * @param err_no Error number as defined in errno.h.
         * @returns #GIOErrorEnum value for the given `errno.h` error number
         */
        function io_error_from_errno(err_no: number): IOErrorEnum;
        /**
         * Converts #GFileError error codes into GIO error codes.
         * @param file_error a #GFileError.
         * @returns #GIOErrorEnum value for the given #GFileError error value.
         */
        function io_error_from_file_error(file_error: GLib.FileError | null): IOErrorEnum;
        /**
         * Gets the GIO Error Quark.
         * @returns a #GQuark.
         */
        function io_error_quark(): GLib.Quark;
        /**
         * Registers `type` as extension for the extension point with name
         * `extension_point_name`.
         *
         * If `type` has already been registered as an extension for this
         * extension point, the existing #GIOExtension object is returned.
         * @param extension_point_name the name of the extension point
         * @param type the #GType to register as extension
         * @param extension_name the name for the extension
         * @param priority the priority for the extension
         * @returns a #GIOExtension object for #GType
         */
        function io_extension_point_implement(
            extension_point_name: string,
            type: GObject.GType,
            extension_name: string,
            priority: number,
        ): IOExtension;
        /**
         * Looks up an existing extension point.
         * @param name the name of the extension point
         * @returns the #GIOExtensionPoint, or %NULL if there    is no registered extension point with the given name.
         */
        function io_extension_point_lookup(name: string): IOExtensionPoint;
        /**
         * Registers an extension point.
         * @param name The name of the extension point
         * @returns the new #GIOExtensionPoint. This object is    owned by GIO and should not be freed.
         */
        function io_extension_point_register(name: string): IOExtensionPoint;
        /**
         * Loads all the modules in the specified directory.
         *
         * If don't require all modules to be initialized (and thus registering
         * all gtypes) then you can use g_io_modules_scan_all_in_directory()
         * which allows delayed/lazy loading of modules.
         * @param dirname pathname for a directory containing modules     to load.
         * @returns a list of #GIOModules loaded      from the directory,      All the modules are loaded into memory, if you want to      unload them (enabling on-demand loading) you must call      g_type_module_unuse() on all the modules. Free the list      with g_list_free().
         */
        function io_modules_load_all_in_directory(dirname: string): IOModule[];
        /**
         * Loads all the modules in the specified directory.
         *
         * If don't require all modules to be initialized (and thus registering
         * all gtypes) then you can use g_io_modules_scan_all_in_directory()
         * which allows delayed/lazy loading of modules.
         * @param dirname pathname for a directory containing modules     to load.
         * @param scope a scope to use when scanning the modules.
         * @returns a list of #GIOModules loaded      from the directory,      All the modules are loaded into memory, if you want to      unload them (enabling on-demand loading) you must call      g_type_module_unuse() on all the modules. Free the list      with g_list_free().
         */
        function io_modules_load_all_in_directory_with_scope(dirname: string, scope: IOModuleScope): IOModule[];
        /**
         * Scans all the modules in the specified directory, ensuring that
         * any extension point implemented by a module is registered.
         *
         * This may not actually load and initialize all the types in each
         * module, some modules may be lazily loaded and initialized when
         * an extension point it implements is used with e.g.
         * g_io_extension_point_get_extensions() or
         * g_io_extension_point_get_extension_by_name().
         *
         * If you need to guarantee that all types are loaded in all the modules,
         * use g_io_modules_load_all_in_directory().
         * @param dirname pathname for a directory containing modules     to scan.
         */
        function io_modules_scan_all_in_directory(dirname: string): void;
        /**
         * Scans all the modules in the specified directory, ensuring that
         * any extension point implemented by a module is registered.
         *
         * This may not actually load and initialize all the types in each
         * module, some modules may be lazily loaded and initialized when
         * an extension point it implements is used with e.g.
         * g_io_extension_point_get_extensions() or
         * g_io_extension_point_get_extension_by_name().
         *
         * If you need to guarantee that all types are loaded in all the modules,
         * use g_io_modules_load_all_in_directory().
         * @param dirname pathname for a directory containing modules     to scan.
         * @param scope a scope to use when scanning the modules
         */
        function io_modules_scan_all_in_directory_with_scope(dirname: string, scope: IOModuleScope): void;
        /**
         * Cancels all cancellable I/O jobs.
         *
         * A job is cancellable if a #GCancellable was passed into
         * g_io_scheduler_push_job().
         */
        function io_scheduler_cancel_all_jobs(): void;
        /**
         * Schedules the I/O job to run in another thread.
         *
         * `notify` will be called on `user_data` after `job_func` has returned,
         * regardless whether the job was cancelled or has run to completion.
         *
         * If `cancellable` is not %NULL, it can be used to cancel the I/O job
         * by calling g_cancellable_cancel() or by calling
         * g_io_scheduler_cancel_all_jobs().
         * @param job_func a #GIOSchedulerJobFunc.
         * @param notify a #GDestroyNotify for @user_data, or %NULL
         * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request.
         * @param cancellable optional #GCancellable object, %NULL to ignore.
         */
        function io_scheduler_push_job(
            job_func: IOSchedulerJobFunc,
            notify: GLib.DestroyNotify | null,
            io_priority: number,
            cancellable?: Cancellable | null,
        ): void;
        /**
         * Creates a keyfile-backed [class`Gio`.SettingsBackend].
         *
         * The filename of the keyfile to use is given by `filename`.
         *
         * All settings read to or written from the backend must fall under the
         * path given in `root_path` (which must start and end with a slash and
         * not contain two consecutive slashes).  `root_path` may be `"/"`.
         *
         * If `root_group` is non-`NULL` then it specifies the name of the keyfile
         * group used for keys that are written directly below `root_path`.  For
         * example, if `root_path` is `"/apps/example/"` and `root_group` is
         * `"toplevel"`, then setting the key `"/apps/example/enabled"` to true will
         * cause the following to appear in the keyfile:
         *
         * ```
         * [toplevel]
         * enabled=true
         * ```
         *
         * If `root_group` is `NULL` then it is not permitted to store keys
         * directly below the `root_path`.
         *
         * For keys not stored directly below `root_path` (ie: in a sub-path),
         * the name of the subpath (with the final slash stripped) is used as
         * the name of the keyfile group.  To continue the example, if
         * `"/apps/example/profiles/default/font-size"` were set to
         * `12` then the following would appear in the keyfile:
         *
         * ```
         * [profiles/default]
         * font-size=12
         * ```
         *
         * The backend will refuse writes (and return writability as being
         * false) for keys outside of `root_path` and, in the event that
         * `root_group` is `NULL`, also for keys directly under `root_path`.
         * Writes will also be refused if the backend detects that it has the
         * inability to rewrite the keyfile (ie: the containing directory is not
         * writable).
         *
         * There is no checking done for your key namespace clashing with the
         * syntax of the key file format.  For example, if you have `[` or `]`
         * characters in your path names or `=` in your key names you may be in
         * trouble.
         *
         * The backend reads default values from a keyfile called `defaults` in
         * the directory specified by the `GKeyfileSettingsBackend:defaults-dir`
         * property, and a list of locked keys from a text file with the name `locks` in
         * the same location.
         * @param filename the filename of the keyfile
         * @param root_path the path under which all settings keys appear
         * @param root_group the group name corresponding to @root_path, or    `NULL` to disallow storing keys directly beneath @root_path
         * @returns a keyfile-backed [class@Gio.SettingsBackend]
         */
        function keyfile_settings_backend_new(
            filename: string,
            root_path: string,
            root_group?: string | null,
        ): SettingsBackend;
        /**
         * Gets a reference to the default #GMemoryMonitor for the system.
         * @returns a new reference to the default #GMemoryMonitor
         */
        function memory_monitor_dup_default(): MemoryMonitor;
        /**
         * Creates a memory-backed #GSettingsBackend.
         *
         * This backend allows changes to settings, but does not write them
         * to any backing storage, so the next time you run your application,
         * the memory backend will start out with the default values again.
         * @returns a newly created #GSettingsBackend
         */
        function memory_settings_backend_new(): SettingsBackend;
        /**
         * Gets the default #GNetworkMonitor for the system.
         * @returns a #GNetworkMonitor, which will be     a dummy object if no network monitor is available
         */
        function network_monitor_get_default(): NetworkMonitor;
        /**
         * Initializes the platform networking libraries (eg, on Windows, this
         * calls WSAStartup()). GLib will call this itself if it is needed, so
         * you only need to call it if you directly call system networking
         * functions (without calling any GLib networking functions first).
         */
        function networking_init(): void;
        /**
         * Creates a readonly #GSettingsBackend.
         *
         * This backend does not allow changes to settings, so all settings
         * will always have their default values.
         * @returns a newly created #GSettingsBackend
         */
        function null_settings_backend_new(): SettingsBackend;
        /**
         * Utility method for #GPollableInputStream and #GPollableOutputStream
         * implementations. Creates a new #GSource that expects a callback of
         * type #GPollableSourceFunc. The new source does not actually do
         * anything on its own; use g_source_add_child_source() to add other
         * sources to it to cause it to trigger.
         * @param pollable_stream the stream associated with the new source
         * @returns the new #GSource.
         */
        function pollable_source_new(pollable_stream: GObject.Object): GLib.Source;
        /**
         * Utility method for #GPollableInputStream and #GPollableOutputStream
         * implementations. Creates a new #GSource, as with
         * g_pollable_source_new(), but also attaching `child_source` (with a
         * dummy callback), and `cancellable,` if they are non-%NULL.
         * @param pollable_stream the stream associated with the   new source
         * @param child_source optional child source to attach
         * @param cancellable optional #GCancellable to attach
         * @returns the new #GSource.
         */
        function pollable_source_new_full(
            pollable_stream: GObject.Object,
            child_source?: GLib.Source | null,
            cancellable?: Cancellable | null,
        ): GLib.Source;
        /**
         * Tries to read from `stream,` as with g_input_stream_read() (if
         * `blocking` is %TRUE) or g_pollable_input_stream_read_nonblocking()
         * (if `blocking` is %FALSE). This can be used to more easily share
         * code between blocking and non-blocking implementations of a method.
         *
         * If `blocking` is %FALSE, then `stream` must be a
         * #GPollableInputStream for which g_pollable_input_stream_can_poll()
         * returns %TRUE, or else the behavior is undefined. If `blocking` is
         * %TRUE, then `stream` does not need to be a #GPollableInputStream.
         * @param stream a #GInputStream
         * @param buffer a buffer to   read data into
         * @param blocking whether to do blocking I/O
         * @param cancellable optional #GCancellable object, %NULL to ignore.
         * @returns the number of bytes read, or -1 on error.
         */
        function pollable_stream_read(
            stream: InputStream,
            buffer: Uint8Array | string,
            blocking: boolean,
            cancellable?: Cancellable | null,
        ): number;
        /**
         * Tries to write to `stream,` as with g_output_stream_write() (if
         * `blocking` is %TRUE) or g_pollable_output_stream_write_nonblocking()
         * (if `blocking` is %FALSE). This can be used to more easily share
         * code between blocking and non-blocking implementations of a method.
         *
         * If `blocking` is %FALSE, then `stream` must be a
         * #GPollableOutputStream for which
         * g_pollable_output_stream_can_poll() returns %TRUE or else the
         * behavior is undefined. If `blocking` is %TRUE, then `stream` does not
         * need to be a #GPollableOutputStream.
         * @param stream a #GOutputStream.
         * @param buffer the buffer   containing the data to write.
         * @param blocking whether to do blocking I/O
         * @param cancellable optional #GCancellable object, %NULL to ignore.
         * @returns the number of bytes written, or -1 on error.
         */
        function pollable_stream_write(
            stream: OutputStream,
            buffer: Uint8Array | string,
            blocking: boolean,
            cancellable?: Cancellable | null,
        ): number;
        /**
         * Tries to write `count` bytes to `stream,` as with
         * g_output_stream_write_all(), but using g_pollable_stream_write()
         * rather than g_output_stream_write().
         *
         * On a successful write of `count` bytes, %TRUE is returned, and
         * `bytes_written` is set to `count`.
         *
         * If there is an error during the operation (including
         * %G_IO_ERROR_WOULD_BLOCK in the non-blocking case), %FALSE is
         * returned and `error` is set to indicate the error status,
         * `bytes_written` is updated to contain the number of bytes written
         * into the stream before the error occurred.
         *
         * As with g_pollable_stream_write(), if `blocking` is %FALSE, then
         * `stream` must be a #GPollableOutputStream for which
         * g_pollable_output_stream_can_poll() returns %TRUE or else the
         * behavior is undefined. If `blocking` is %TRUE, then `stream` does not
         * need to be a #GPollableOutputStream.
         * @param stream a #GOutputStream.
         * @param buffer the buffer   containing the data to write.
         * @param blocking whether to do blocking I/O
         * @param cancellable optional #GCancellable object, %NULL to ignore.
         * @returns %TRUE on success, %FALSE if there was an error
         */
        function pollable_stream_write_all(
            stream: OutputStream,
            buffer: Uint8Array | string,
            blocking: boolean,
            cancellable?: Cancellable | null,
        ): [boolean, number];
        /**
         * Gets a reference to the default #GPowerProfileMonitor for the system.
         * @returns a new reference to the default #GPowerProfileMonitor
         */
        function power_profile_monitor_dup_default(): PowerProfileMonitor;
        /**
         * Find the `gio-proxy` extension point for a proxy implementation that supports
         * the specified protocol.
         * @param protocol the proxy protocol name (e.g. http, socks, etc)
         * @returns return a #GProxy or NULL if protocol               is not supported.
         */
        function proxy_get_default_for_protocol(protocol: string): Proxy | null;
        /**
         * Gets the default #GProxyResolver for the system.
         * @returns the default #GProxyResolver, which     will be a dummy object if no proxy resolver is available
         */
        function proxy_resolver_get_default(): ProxyResolver;
        /**
         * Gets the #GResolver Error Quark.
         * @returns a #GQuark.
         */
        function resolver_error_quark(): GLib.Quark;
        /**
         * Gets the [struct`Gio`.Resource] Error Quark.
         * @returns a [type@GLib.Quark]
         */
        function resource_error_quark(): GLib.Quark;
        /**
         * Loads a binary resource bundle and creates a [struct`Gio`.Resource]
         * representation of it, allowing you to query it for data.
         *
         * If you want to use this resource in the global resource namespace you need
         * to register it with [func`Gio`.resources_register].
         *
         * If `filename` is empty or the data in it is corrupt,
         * %G_RESOURCE_ERROR_INTERNAL will be returned. If `filename` doesn’t exist, or
         * there is an error in reading it, an error from [ctor`GLib`.MappedFile.new]
         * will be returned.
         * @param filename the path of a filename to load, in the GLib filename encoding
         * @returns a new [struct@Gio.Resource], or `NULL` on error
         */
        function resource_load(filename: string): Resource;
        /**
         * Returns all the names of children at the specified `path` in the set of
         * globally registered resources.
         *
         * The return result is a `NULL` terminated list of strings which should
         * be released with [func`GLib`.strfreev].
         *
         * `lookup_flags` controls the behaviour of the lookup.
         * @param path A path name inside the resource
         * @param lookup_flags A [flags@Gio.ResourceLookupFlags]
         * @returns an array of constant strings
         */
        function resources_enumerate_children(path: string, lookup_flags: ResourceLookupFlags | null): string[];
        /**
         * Looks for a file at the specified `path` in the set of
         * globally registered resources and if found returns information about it.
         *
         * `lookup_flags` controls the behaviour of the lookup.
         * @param path A path name inside the resource
         * @param lookup_flags A [flags@Gio.ResourceLookupFlags]
         * @returns `TRUE` if the file was found, `FALSE` if there were errors
         */
        function resources_get_info(path: string, lookup_flags: ResourceLookupFlags | null): [boolean, number, number];
        /**
         * Returns whether the specified `path` in the set of
         * globally registered resources has children.
         * @param path A pathname
         * @returns %TRUE if @patch has children
         */
        function resources_has_children(path: string): boolean;
        /**
         * Looks for a file at the specified `path` in the set of
         * globally registered resources and returns a [struct`GLib`.Bytes] that
         * lets you directly access the data in memory.
         *
         * The data is always followed by a zero byte, so you
         * can safely use the data as a C string. However, that byte
         * is not included in the size of the [struct`GLib`.Bytes].
         *
         * For uncompressed resource files this is a pointer directly into
         * the resource bundle, which is typically in some read-only data section
         * in the program binary. For compressed files we allocate memory on
         * the heap and automatically uncompress the data.
         *
         * `lookup_flags` controls the behaviour of the lookup.
         * @param path A path name inside the resource
         * @param lookup_flags A [flags@Gio.ResourceLookupFlags]
         * @returns [struct@GLib.Bytes] or `NULL` on error
         */
        function resources_lookup_data(path: string, lookup_flags: ResourceLookupFlags | null): GLib.Bytes;
        /**
         * Looks for a file at the specified `path` in the set of
         * globally registered resources and returns a [class`Gio`.InputStream]
         * that lets you read the data.
         *
         * `lookup_flags` controls the behaviour of the lookup.
         * @param path A path name inside the resource
         * @param lookup_flags A [flags@Gio.ResourceLookupFlags]
         * @returns [class@Gio.InputStream] or `NULL` on error
         */
        function resources_open_stream(path: string, lookup_flags: ResourceLookupFlags | null): InputStream;
        /**
         * Registers the resource with the process-global set of resources.
         *
         * Once a resource is registered the files in it can be accessed
         * with the global resource lookup functions like
         * [func`Gio`.resources_lookup_data].
         * @param resource A [struct@Gio.Resource]
         */
        function resources_register(resource: Resource): void;
        /**
         * Unregisters the resource from the process-global set of resources.
         * @param resource A [struct@Gio.Resource]
         */
        function resources_unregister(resource: Resource): void;
        /**
         * Gets the default system schema source.
         *
         * This function is not required for normal uses of #GSettings but it
         * may be useful to authors of plugin management systems or to those who
         * want to introspect the content of schemas.
         *
         * If no schemas are installed, %NULL will be returned.
         *
         * The returned source may actually consist of multiple schema sources
         * from different directories, depending on which directories were given
         * in `XDG_DATA_DIRS` and `GSETTINGS_SCHEMA_DIR`. For this reason, all
         * lookups performed against the default source should probably be done
         * recursively.
         * @returns the default schema source
         */
        function settings_schema_source_get_default(): SettingsSchemaSource | null;
        /**
         * Reports an error in an idle function. Similar to
         * g_simple_async_report_error_in_idle(), but takes a #GError rather
         * than building a new one.
         * @param object a #GObject, or %NULL
         * @param callback a #GAsyncReadyCallback.
         * @param error the #GError to report
         */
        function simple_async_report_gerror_in_idle(
            object: GObject.Object | null,
            callback: AsyncReadyCallback<GObject.Object | null> | null,
            error: GLib.Error,
        ): void;
        /**
         * Gets the default #GTlsBackend for the system.
         * @returns a #GTlsBackend, which will be a     dummy object if no TLS backend is available
         */
        function tls_backend_get_default(): TlsBackend;
        /**
         * Gets the TLS channel binding error quark.
         * @returns a #GQuark.
         */
        function tls_channel_binding_error_quark(): GLib.Quark;
        /**
         * Creates a new #GTlsClientConnection wrapping `base_io_stream` (which
         * must have pollable input and output streams) which is assumed to
         * communicate with the server identified by `server_identity`.
         *
         * See the documentation for #GTlsConnection:base-io-stream for restrictions
         * on when application code can run operations on the `base_io_stream` after
         * this function has returned.
         * @param base_io_stream the #GIOStream to wrap
         * @param server_identity the expected identity of the server
         * @returns the new #GTlsClientConnection, or %NULL on error
         */
        function tls_client_connection_new(
            base_io_stream: IOStream,
            server_identity?: SocketConnectable | null,
        ): TlsClientConnection;
        /**
         * Gets the TLS error quark.
         * @returns a #GQuark.
         */
        function tls_error_quark(): GLib.Quark;
        /**
         * Creates a new #GTlsFileDatabase which uses anchor certificate authorities
         * in `anchors` to verify certificate chains.
         *
         * The certificates in `anchors` must be PEM encoded.
         * @param anchors filename of anchor certificate authorities.
         * @returns the new #GTlsFileDatabase, or %NULL on error
         */
        function tls_file_database_new(anchors: string): TlsFileDatabase;
        /**
         * Creates a new #GTlsServerConnection wrapping `base_io_stream` (which
         * must have pollable input and output streams).
         *
         * See the documentation for #GTlsConnection:base-io-stream for restrictions
         * on when application code can run operations on the `base_io_stream` after
         * this function has returned.
         * @param base_io_stream the #GIOStream to wrap
         * @param certificate the default server certificate, or %NULL
         * @returns the new #GTlsServerConnection, or %NULL on error
         */
        function tls_server_connection_new(
            base_io_stream: IOStream,
            certificate?: TlsCertificate | null,
        ): TlsServerConnection;
        /**
         * Determines if `mount_path` is considered an implementation of the
         * OS.
         *
         * This is primarily used for hiding mountable and mounted volumes
         * that only are used in the OS and has little to no relevance to the
         * casual user.
         * @param mount_path a mount path, e.g. `/media/disk` or `/usr`
         * @returns true if @mount_path is considered an implementation detail    of the OS; false otherwise
         */
        function unix_is_mount_path_system_internal(mount_path: string): boolean;
        /**
         * Determines if `device_path` is considered a block device path which is only
         * used in implementation of the OS.
         *
         * This is primarily used for hiding mounted volumes that are intended as APIs
         * for programs to read, and system administrators at a shell; rather than
         * something that should, for example, appear in a GUI. For example, the Linux
         * `/proc` filesystem.
         *
         * The list of device paths considered ‘system’ ones may change over time.
         * @param device_path a device path, e.g. `/dev/loop0` or `nfsd`
         * @returns true if @device_path is considered an implementation detail of    the OS; false otherwise
         */
        function unix_is_system_device_path(device_path: string): boolean;
        /**
         * Determines if `fs_type` is considered a type of file system which is only
         * used in implementation of the OS.
         *
         * This is primarily used for hiding mounted volumes that are intended as APIs
         * for programs to read, and system administrators at a shell; rather than
         * something that should, for example, appear in a GUI. For example, the Linux
         * `/proc` filesystem.
         *
         * The list of file system types considered ‘system’ ones may change over time.
         * @param fs_type a file system type, e.g. `procfs` or `tmpfs`
         * @returns true if @fs_type is considered an implementation detail of the OS;    false otherwise
         */
        function unix_is_system_fs_type(fs_type: string): boolean;
        /**
         * Gets a [struct`GioUnix`.MountEntry] for a given mount path.
         *
         * If `time_read` is set, it will be filled with a Unix timestamp for checking
         * if the mounts have changed since with
         * [func`GioUnix`.mount_entries_changed_since].
         *
         * If more mounts have the same mount path, the last matching mount
         * is returned.
         *
         * This will return `NULL` if there is no mount point at `mount_path`.
         * @param mount_path path for a possible Unix mount
         * @returns a [struct@GioUnix.MountEntry]
         */
        function unix_mount_at(mount_path: string): [UnixMountEntry | null, number];
        /**
         * Compares two Unix mounts.
         * @param mount1 first [struct@GioUnix.MountEntry] to compare
         * @param mount2 second [struct@GioUnix.MountEntry] to compare
         * @returns `1`, `0` or `-1` if @mount1 is greater than, equal to,    or less than @mount2, respectively
         */
        function unix_mount_compare(mount1: UnixMountEntry, mount2: UnixMountEntry): number;
        /**
         * Makes a copy of `mount_entry`.
         * @param mount_entry a [struct@GioUnix.MountEntry]
         * @returns a new [struct@GioUnix.MountEntry]
         */
        function unix_mount_copy(mount_entry: UnixMountEntry): UnixMountEntry;
        /**
         * Checks if the Unix mounts have changed since a given Unix time.
         *
         * This can only work reliably if a [class`GioUnix`.MountMonitor] is running in
         * the process, otherwise changes in the mount entries file (such as
         * `/proc/self/mountinfo` on Linux) cannot be detected and, as a result, this
         * function has to conservatively always return `TRUE`.
         *
         * It is more efficient to use [signal`GioUnix`.MountMonitor::mounts-changed] to
         * be signalled of changes to the mount entries, rather than polling using this
         * function. This function is more appropriate for infrequently determining
         * cache validity.
         * @param time a timestamp
         * @returns true if the mounts have changed since @time; false otherwise Since 2.84
         */
        function unix_mount_entries_changed_since(time: number): boolean;
        /**
         * Gets a list of [struct`GioUnix`.MountEntry] instances representing the Unix
         * mounts.
         *
         * If `time_read` is set, it will be filled with the mount timestamp, allowing
         * for checking if the mounts have changed with
         * [func`GioUnix`.mount_entries_changed_since].
         * @returns a list of the    Unix mounts
         */
        function unix_mount_entries_get(): [UnixMountEntry[], number];
        /**
         * Gets an array of [struct`Gio`.UnixMountEntry]s containing the Unix mounts
         * listed in `table_path`.
         *
         * This is a generalized version of [func`GioUnix`.mount_entries_get], mainly
         * intended for internal testing use. Note that [func`GioUnix`.mount_entries_get]
         * may parse multiple hierarchical table files, so this function is not a direct
         * superset of its functionality.
         *
         * If there is an error reading or parsing the file, `NULL` will be returned
         * and both out parameters will be set to `0`.
         * @param table_path path to the mounts table file (for example `/proc/self/mountinfo`)
         * @returns mount   entries, or `NULL` if there was an error loading them
         */
        function unix_mount_entries_get_from_file(table_path: string): [UnixMountEntry[] | null, number];
        /**
         * Gets a [struct`GioUnix`.MountEntry] for a given mount path.
         *
         * If `time_read` is set, it will be filled with a Unix timestamp for checking
         * if the mounts have changed since with
         * [func`GioUnix`.mount_entries_changed_since].
         *
         * If more mounts have the same mount path, the last matching mount
         * is returned.
         *
         * This will return `NULL` if there is no mount point at `mount_path`.
         * @param mount_path path for a possible Unix mount
         * @returns a [struct@GioUnix.MountEntry]
         */
        function unix_mount_entry_at(mount_path: string): [UnixMountEntry | null, number];
        /**
         * Gets a [struct`GioUnix`.MountEntry] for a given file path.
         *
         * If `time_read` is set, it will be filled with a Unix timestamp for checking
         * if the mounts have changed since with
         * [func`GioUnix`.mount_entries_changed_since].
         *
         * If more mounts have the same mount path, the last matching mount
         * is returned.
         *
         * This will return `NULL` if looking up the mount entry fails, if
         * `file_path` doesn’t exist or there is an I/O error.
         * @param file_path file path on some Unix mount
         * @returns a [struct@GioUnix.MountEntry]
         */
        function unix_mount_entry_for(file_path: string): [UnixMountEntry | null, number];
        /**
         * Gets a [struct`GioUnix`.MountEntry] for a given file path.
         *
         * If `time_read` is set, it will be filled with a Unix timestamp for checking
         * if the mounts have changed since with
         * [func`GioUnix`.mount_entries_changed_since].
         *
         * If more mounts have the same mount path, the last matching mount
         * is returned.
         *
         * This will return `NULL` if looking up the mount entry fails, if
         * `file_path` doesn’t exist or there is an I/O error.
         * @param file_path file path on some Unix mount
         * @returns a [struct@GioUnix.MountEntry]
         */
        function unix_mount_for(file_path: string): [UnixMountEntry | null, number];
        /**
         * Frees a Unix mount.
         * @param mount_entry a [struct@GioUnix.MountEntry]
         */
        function unix_mount_free(mount_entry: UnixMountEntry): void;
        /**
         * Gets the device path for a Unix mount.
         * @param mount_entry a [struct@GioUnix.MountEntry]
         * @returns a string containing the device path
         */
        function unix_mount_get_device_path(mount_entry: UnixMountEntry): string;
        /**
         * Gets the filesystem type for the Unix mount.
         * @param mount_entry a [struct@GioUnix.MountEntry]
         * @returns a string containing the file system type
         */
        function unix_mount_get_fs_type(mount_entry: UnixMountEntry): string;
        /**
         * Gets the mount path for a Unix mount.
         * @param mount_entry a [struct@GioUnix.MountEntry] to get the mount path for
         * @returns the mount path for @mount_entry
         */
        function unix_mount_get_mount_path(mount_entry: UnixMountEntry): string;
        /**
         * Gets a comma separated list of mount options for the Unix mount.
         *
         * For example: `rw,relatime,seclabel,data=ordered`.
         *
         * This is similar to [func`GioUnix`.MountPoint.get_options], but it takes
         * a [struct`GioUnix`.MountEntry] as an argument.
         * @param mount_entry a [struct@GioUnix.MountEntry]
         * @returns a string containing the options, or `NULL` if not    available.
         */
        function unix_mount_get_options(mount_entry: UnixMountEntry): string | null;
        /**
         * Gets the root of the mount within the filesystem. This is useful e.g. for
         * mounts created by bind operation, or btrfs subvolumes.
         *
         * For example, the root path is equal to `/` for a mount created by
         * `mount /dev/sda1 /mnt/foo` and `/bar` for
         * `mount --bind /mnt/foo/bar /mnt/bar`.
         * @param mount_entry a [struct@GioUnix.MountEntry]
         * @returns a string containing the root, or `NULL` if not supported
         */
        function unix_mount_get_root_path(mount_entry: UnixMountEntry): string | null;
        /**
         * Guesses whether a Unix mount entry can be ejected.
         * @param mount_entry a [struct@GioUnix.MountEntry]
         * @returns true if @mount_entry is deemed to be ejectable; false otherwise
         */
        function unix_mount_guess_can_eject(mount_entry: UnixMountEntry): boolean;
        /**
         * Guesses the icon of a Unix mount entry.
         * @param mount_entry a [struct@GioUnix.MountEntry]
         * @returns a [iface@Gio.Icon]
         */
        function unix_mount_guess_icon(mount_entry: UnixMountEntry): Icon;
        /**
         * Guesses the name of a Unix mount entry.
         *
         * The result is a translated string.
         * @param mount_entry a [struct@GioUnix.MountEntry]
         * @returns a newly allocated translated string
         */
        function unix_mount_guess_name(mount_entry: UnixMountEntry): string;
        /**
         * Guesses whether a Unix mount entry should be displayed in the UI.
         * @param mount_entry a [struct@GioUnix.MountEntry]
         * @returns true if @mount_entry is deemed to be displayable; false otherwise
         */
        function unix_mount_guess_should_display(mount_entry: UnixMountEntry): boolean;
        /**
         * Guesses the symbolic icon of a Unix mount entry.
         * @param mount_entry a [struct@GioUnix.MountEntry]
         * @returns a [iface@Gio.Icon]
         */
        function unix_mount_guess_symbolic_icon(mount_entry: UnixMountEntry): Icon;
        /**
         * Checks if a Unix mount is mounted read only.
         * @param mount_entry a [struct@GioUnix.MountEntry]
         * @returns true if @mount_entry is read only; false otherwise
         */
        function unix_mount_is_readonly(mount_entry: UnixMountEntry): boolean;
        /**
         * Checks if a Unix mount is a system mount.
         *
         * This is the Boolean OR of
         * [func`GioUnix`.is_system_fs_type], [func`GioUnix`.is_system_device_path] and
         * [func`GioUnix`.is_mount_path_system_internal] on `mount_entry’`s properties.
         *
         * The definition of what a ‘system’ mount entry is may change over time as new
         * file system types and device paths are ignored.
         * @param mount_entry a [struct@GioUnix.MountEntry]
         * @returns true if the Unix mount is for a system path; false otherwise
         */
        function unix_mount_is_system_internal(mount_entry: UnixMountEntry): boolean;
        /**
         * Gets a [struct`GioUnix`.MountPoint] for a given mount path.
         *
         * If `time_read` is set, it will be filled with a Unix timestamp for checking if
         * the mount points have changed since with
         * [func`GioUnix`.mount_points_changed_since].
         *
         * If more mount points have the same mount path, the last matching mount point
         * is returned.
         * @param mount_path path for a possible Unix mount point
         * @returns a [struct@GioUnix.MountPoint], or `NULL`    if no match is found
         */
        function unix_mount_point_at(mount_path: string): [UnixMountPoint | null, number];
        /**
         * Checks if the Unix mount points have changed since a given Unix time.
         *
         * Unlike [func`GioUnix`.mount_entries_changed_since], this function can work
         * reliably without a [class`GioUnix`.MountMonitor] running, as it accesses the
         * static mount point information (such as `/etc/fstab` on Linux), which has a
         * valid modification time.
         *
         * It is more efficient to use [signal`GioUnix`.MountMonitor::mountpoints-changed]
         * to be signalled of changes to the mount points, rather than polling using
         * this function. This function is more appropriate for infrequently determining
         * cache validity.
         * @param time a timestamp
         * @returns true if the mount points have changed since @time; false otherwise
         */
        function unix_mount_points_changed_since(time: number): boolean;
        /**
         * Gets a list of [struct`GioUnix`.MountPoint] instances representing the Unix
         * mount points.
         *
         * If `time_read` is set, it will be filled with the mount timestamp, allowing
         * for checking if the mounts have changed with
         * [func`GioUnix`.mount_points_changed_since].
         * @returns a list of the Unix    mount points
         */
        function unix_mount_points_get(): [UnixMountPoint[], number];
        /**
         * Gets an array of [struct`Gio`.UnixMountPoint]s containing the Unix mount
         * points listed in `table_path`.
         *
         * This is a generalized version of [func`GioUnix`.mount_points_get], mainly
         * intended for internal testing use. Note that [func`GioUnix`.mount_points_get]
         * may parse multiple hierarchical table files, so this function is not a direct
         * superset of its functionality.
         *
         * If there is an error reading or parsing the file, `NULL` will be returned
         * and both out parameters will be set to `0`.
         * @param table_path path to the mount points table file (for example `/etc/fstab`)
         * @returns mount   points, or `NULL` if there was an error loading them
         */
        function unix_mount_points_get_from_file(table_path: string): [UnixMountPoint[] | null, number];
        /**
         * Checks if the Unix mounts have changed since a given Unix time.
         * @param time a timestamp
         * @returns true if the mounts have changed since @time; false otherwise
         */
        function unix_mounts_changed_since(time: number): boolean;
        /**
         * Gets a list of [struct`GioUnix`.MountEntry] instances representing the Unix
         * mounts.
         *
         * If `time_read` is set, it will be filled with the mount timestamp, allowing
         * for checking if the mounts have changed with
         * [func`GioUnix`.mount_entries_changed_since].
         * @returns a list of the    Unix mounts
         */
        function unix_mounts_get(): [UnixMountEntry[], number];
        /**
         * Gets an array of [struct`Gio`.UnixMountEntry]s containing the Unix mounts
         * listed in `table_path`.
         *
         * This is a generalized version of [func`GioUnix`.mount_entries_get], mainly
         * intended for internal testing use. Note that [func`GioUnix`.mount_entries_get]
         * may parse multiple hierarchical table files, so this function is not a direct
         * superset of its functionality.
         *
         * If there is an error reading or parsing the file, `NULL` will be returned
         * and both out parameters will be set to `0`.
         * @param table_path path to the mounts table file (for example `/proc/self/mountinfo`)
         * @returns mount   entries, or `NULL` if there was an error loading them
         */
        function unix_mounts_get_from_file(table_path: string): [UnixMountEntry[] | null, number];
        interface AsyncReadyCallback<A = GObject.Object> {
            (source_object: A | null, res: AsyncResult, data?: any | null): void;
        }
        interface BusAcquiredCallback {
            (connection: DBusConnection, name: string): void;
        }
        interface BusNameAcquiredCallback {
            (connection: DBusConnection, name: string): void;
        }
        interface BusNameAppearedCallback {
            (connection: DBusConnection, name: string, name_owner: string): void;
        }
        interface BusNameLostCallback {
            (connection: DBusConnection, name: string): void;
        }
        interface BusNameVanishedCallback {
            (connection: DBusConnection, name: string): void;
        }
        interface CancellableSourceFunc {
            (cancellable?: Cancellable | null, data?: any | null): boolean;
        }
        interface DBusInterfaceGetPropertyFunc {
            (
                connection: DBusConnection,
                sender: string | null,
                object_path: string,
                interface_name: string,
                property_name: string,
                error: GLib.Error,
            ): GLib.Variant;
        }
        interface DBusInterfaceMethodCallFunc {
            (
                connection: DBusConnection,
                sender: string | null,
                object_path: string,
                interface_name: string | null,
                method_name: string,
                parameters: GLib.Variant,
                invocation: DBusMethodInvocation,
            ): void;
        }
        interface DBusInterfaceSetPropertyFunc {
            (
                connection: DBusConnection,
                sender: string | null,
                object_path: string,
                interface_name: string,
                property_name: string,
                value: GLib.Variant,
                error: GLib.Error,
            ): boolean;
        }
        interface DBusMessageFilterFunction {
            (connection: DBusConnection, message: DBusMessage, incoming: boolean): DBusMessage | null;
        }
        interface DBusProxyTypeFunc {
            (
                manager: DBusObjectManagerClient,
                object_path: string,
                interface_name?: string | null,
                data?: any | null,
            ): GObject.GType;
        }
        interface DBusSignalCallback {
            (
                connection: DBusConnection,
                sender_name: string | null,
                object_path: string,
                interface_name: string,
                signal_name: string,
                parameters: GLib.Variant,
            ): void;
        }
        interface DBusSubtreeDispatchFunc {
            (
                connection: DBusConnection,
                sender: string,
                object_path: string,
                interface_name: string,
                node: string,
                out_user_data: any,
            ): DBusInterfaceVTable | null;
        }
        interface DBusSubtreeEnumerateFunc {
            (connection: DBusConnection, sender: string, object_path: string): string[];
        }
        interface DBusSubtreeIntrospectFunc {
            (connection: DBusConnection, sender: string, object_path: string, node: string): DBusInterfaceInfo[] | null;
        }
        interface DatagramBasedSourceFunc {
            (datagram_based: DatagramBased, condition: GLib.IOCondition, data?: any | null): boolean;
        }
        interface DesktopAppLaunchCallback {
            (appinfo: DesktopAppInfo, pid: GLib.Pid): void;
        }
        interface FileMeasureProgressCallback {
            (reporting: boolean, current_size: number, num_dirs: number, num_files: number, data?: any | null): void;
        }
        interface FileProgressCallback {
            (current_num_bytes: number, total_num_bytes: number, data?: any | null): void;
        }
        interface FileReadMoreCallback {
            (file_contents: string, file_size: number, callback_data?: any | null): boolean;
        }
        interface IOSchedulerJobFunc {
            (job: IOSchedulerJob, cancellable?: Cancellable | null, data?: any | null): boolean;
        }
        interface PollableSourceFunc<A = GObject.Object> {
            (pollable_stream: A, data?: any | null): boolean;
        }
        interface ReallocFunc {
            (data: any | null, size: number): any | null;
        }
        interface SettingsBindGetMapping {
            (value: GObject.Value | any, variant: GLib.Variant): boolean;
        }
        interface SettingsBindSetMapping {
            (value: GObject.Value | any, expected_type: GLib.VariantType): GLib.Variant | null;
        }
        interface SettingsGetMapping {
            (value: GLib.Variant | null): boolean;
        }
        interface SimpleAsyncThreadFunc<A = GObject.Object> {
            (res: SimpleAsyncResult, object: A, cancellable?: Cancellable | null): void;
        }
        interface SocketSourceFunc {
            (socket: Socket, condition: GLib.IOCondition, data?: any | null): boolean;
        }
        interface TaskThreadFunc<A = GObject.Object> {
            (task: Task, source_object: A, task_data?: any | null, cancellable?: Cancellable | null): void;
        }
        interface VfsFileLookupFunc {
            (vfs: Vfs, identifier: string): File | null;
        }
        /**
         * Flags used when creating a #GAppInfo.
         */

        /**
         * Flags used when creating a #GAppInfo.
         */
        export namespace AppInfoCreateFlags {
            export const $gtype: GObject.GType<AppInfoCreateFlags>;
        }

        enum AppInfoCreateFlags {
            /**
             * No flags.
             */
            NONE,
            /**
             * Application opens in a terminal window.
             */
            NEEDS_TERMINAL,
            /**
             * Application supports URI arguments.
             */
            SUPPORTS_URIS,
            /**
             * Application supports startup notification. Since 2.26
             */
            SUPPORTS_STARTUP_NOTIFICATION,
        }
        /**
         * Flags used to define the behaviour of a #GApplication.
         */

        /**
         * Flags used to define the behaviour of a #GApplication.
         */
        export namespace ApplicationFlags {
            export const $gtype: GObject.GType<ApplicationFlags>;
        }

        enum ApplicationFlags {
            /**
             * Default flags.
             */
            FLAGS_NONE,
            /**
             * Default flags.
             */
            DEFAULT_FLAGS,
            /**
             * Run as a service. In this mode, registration
             *      fails if the service is already running, and the application
             *      will initially wait up to 10 seconds for an initial activation
             *      message to arrive.
             */
            IS_SERVICE,
            /**
             * Don't try to become the primary instance.
             */
            IS_LAUNCHER,
            /**
             * This application handles opening files (in
             *     the primary instance). Note that this flag only affects the default
             *     implementation of local_command_line(), and has no effect if
             *     %G_APPLICATION_HANDLES_COMMAND_LINE is given.
             *     See g_application_run() for details.
             */
            HANDLES_OPEN,
            /**
             * This application handles command line
             *     arguments (in the primary instance). Note that this flag only affect
             *     the default implementation of local_command_line().
             *     See g_application_run() for details.
             */
            HANDLES_COMMAND_LINE,
            /**
             * Send the environment of the
             *     launching process to the primary instance. Set this flag if your
             *     application is expected to behave differently depending on certain
             *     environment variables. For instance, an editor might be expected
             *     to use the `GIT_COMMITTER_NAME` environment variable
             *     when editing a git commit message. The environment is available
             *     to the #GApplication::command-line signal handler, via
             *     g_application_command_line_getenv().
             */
            SEND_ENVIRONMENT,
            /**
             * Make no attempts to do any of the typical
             *     single-instance application negotiation, even if the application
             *     ID is given.  The application neither attempts to become the
             *     owner of the application ID nor does it check if an existing
             *     owner already exists.  Everything occurs in the local process.
             *     Since: 2.30.
             */
            NON_UNIQUE,
            /**
             * Allow users to override the
             *     application ID from the command line with `--gapplication-app-id`.
             *     Since: 2.48
             */
            CAN_OVERRIDE_APP_ID,
            /**
             * Allow another instance to take over
             *     the bus name. Since: 2.60
             */
            ALLOW_REPLACEMENT,
            /**
             * Take over from another instance. This flag is
             *     usually set by passing `--gapplication-replace` on the commandline.
             *     Since: 2.60
             */
            REPLACE,
        }
        /**
         * #GAskPasswordFlags are used to request specific information from the
         * user, or to notify the user of their choices in an authentication
         * situation.
         */

        /**
         * #GAskPasswordFlags are used to request specific information from the
         * user, or to notify the user of their choices in an authentication
         * situation.
         */
        export namespace AskPasswordFlags {
            export const $gtype: GObject.GType<AskPasswordFlags>;
        }

        enum AskPasswordFlags {
            /**
             * operation requires a password.
             */
            NEED_PASSWORD,
            /**
             * operation requires a username.
             */
            NEED_USERNAME,
            /**
             * operation requires a domain.
             */
            NEED_DOMAIN,
            /**
             * operation supports saving settings.
             */
            SAVING_SUPPORTED,
            /**
             * operation supports anonymous users.
             */
            ANONYMOUS_SUPPORTED,
            /**
             * operation takes TCRYPT parameters (Since: 2.58)
             */
            TCRYPT,
        }
        /**
         * Flags used in g_bus_own_name().
         */

        /**
         * Flags used in g_bus_own_name().
         */
        export namespace BusNameOwnerFlags {
            export const $gtype: GObject.GType<BusNameOwnerFlags>;
        }

        enum BusNameOwnerFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Allow another message bus connection to claim the name.
             */
            ALLOW_REPLACEMENT,
            /**
             * If another message bus connection owns the name and have
             * specified %G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT, then take the name from the other connection.
             */
            REPLACE,
            /**
             * If another message bus connection owns the name, immediately
             * return an error from g_bus_own_name() rather than entering the waiting queue for that name. (Since 2.54)
             */
            DO_NOT_QUEUE,
        }
        /**
         * Flags used in g_bus_watch_name().
         */

        /**
         * Flags used in g_bus_watch_name().
         */
        export namespace BusNameWatcherFlags {
            export const $gtype: GObject.GType<BusNameWatcherFlags>;
        }

        enum BusNameWatcherFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * If no-one owns the name when
             * beginning to watch the name, ask the bus to launch an owner for the
             * name.
             */
            AUTO_START,
        }
        /**
         * Flags used when calling a g_converter_convert().
         */

        /**
         * Flags used when calling a g_converter_convert().
         */
        export namespace ConverterFlags {
            export const $gtype: GObject.GType<ConverterFlags>;
        }

        enum ConverterFlags {
            /**
             * No flags.
             */
            NONE,
            /**
             * At end of input data
             */
            INPUT_AT_END,
            /**
             * Flush data
             */
            FLUSH,
        }
        /**
         * Flags used in g_dbus_connection_call() and similar APIs.
         */

        /**
         * Flags used in g_dbus_connection_call() and similar APIs.
         */
        export namespace DBusCallFlags {
            export const $gtype: GObject.GType<DBusCallFlags>;
        }

        enum DBusCallFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * The bus must not launch
             * an owner for the destination name in response to this method
             * invocation.
             */
            NO_AUTO_START,
            /**
             * the caller is prepared to
             * wait for interactive authorization. Since 2.46.
             */
            ALLOW_INTERACTIVE_AUTHORIZATION,
        }
        /**
         * Capabilities negotiated with the remote peer.
         */

        /**
         * Capabilities negotiated with the remote peer.
         */
        export namespace DBusCapabilityFlags {
            export const $gtype: GObject.GType<DBusCapabilityFlags>;
        }

        enum DBusCapabilityFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * The connection
             * supports exchanging UNIX file descriptors with the remote peer.
             */
            UNIX_FD_PASSING,
        }
        /**
         * Flags used when creating a new #GDBusConnection.
         */

        /**
         * Flags used when creating a new #GDBusConnection.
         */
        export namespace DBusConnectionFlags {
            export const $gtype: GObject.GType<DBusConnectionFlags>;
        }

        enum DBusConnectionFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Perform authentication against server.
             */
            AUTHENTICATION_CLIENT,
            /**
             * Perform authentication against client.
             */
            AUTHENTICATION_SERVER,
            /**
             * When
             * authenticating as a server, allow the anonymous authentication
             * method.
             */
            AUTHENTICATION_ALLOW_ANONYMOUS,
            /**
             * Pass this flag if connecting to a peer that is a
             * message bus. This means that the Hello() method will be invoked as part of the connection setup.
             */
            MESSAGE_BUS_CONNECTION,
            /**
             * If set, processing of D-Bus messages is
             * delayed until g_dbus_connection_start_message_processing() is called.
             */
            DELAY_MESSAGE_PROCESSING,
            /**
             * When authenticating
             * as a server, require the UID of the peer to be the same as the UID of the server. (Since: 2.68)
             */
            AUTHENTICATION_REQUIRE_SAME_USER,
            /**
             * When authenticating, try to use
             *  protocols that work across a Linux user namespace boundary, even if this
             *  reduces interoperability with older D-Bus implementations. This currently
             *  affects client-side `EXTERNAL` authentication, for which this flag makes
             *  connections to a server in another user namespace succeed, but causes
             *  a deadlock when connecting to a GDBus server older than 2.73.3. Since: 2.74
             */
            CROSS_NAMESPACE,
        }
        /**
         * Flags describing the behavior of a #GDBusInterfaceSkeleton instance.
         */

        /**
         * Flags describing the behavior of a #GDBusInterfaceSkeleton instance.
         */
        export namespace DBusInterfaceSkeletonFlags {
            export const $gtype: GObject.GType<DBusInterfaceSkeletonFlags>;
        }

        enum DBusInterfaceSkeletonFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Each method invocation is handled in
             *   a thread dedicated to the invocation. This means that the method implementation can use blocking IO
             *   without blocking any other part of the process. It also means that the method implementation must
             *   use locking to access data structures used by other threads.
             */
            HANDLE_METHOD_INVOCATIONS_IN_THREAD,
        }
        /**
         * Message flags used in #GDBusMessage.
         */

        /**
         * Message flags used in #GDBusMessage.
         */
        export namespace DBusMessageFlags {
            export const $gtype: GObject.GType<DBusMessageFlags>;
        }

        enum DBusMessageFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * A reply is not expected.
             */
            NO_REPLY_EXPECTED,
            /**
             * The bus must not launch an
             * owner for the destination name in response to this message.
             */
            NO_AUTO_START,
            /**
             * If set on a method
             * call, this flag means that the caller is prepared to wait for interactive
             * authorization. Since 2.46.
             */
            ALLOW_INTERACTIVE_AUTHORIZATION,
        }
        /**
         * Flags used when constructing a #GDBusObjectManagerClient.
         */

        /**
         * Flags used when constructing a #GDBusObjectManagerClient.
         */
        export namespace DBusObjectManagerClientFlags {
            export const $gtype: GObject.GType<DBusObjectManagerClientFlags>;
        }

        enum DBusObjectManagerClientFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * If not set and the
             *   manager is for a well-known name, then request the bus to launch
             *   an owner for the name if no-one owns the name. This flag can only
             *   be used in managers for well-known names.
             */
            DO_NOT_AUTO_START,
        }
        /**
         * Flags describing the access control of a D-Bus property.
         */

        /**
         * Flags describing the access control of a D-Bus property.
         */
        export namespace DBusPropertyInfoFlags {
            export const $gtype: GObject.GType<DBusPropertyInfoFlags>;
        }

        enum DBusPropertyInfoFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Property is readable.
             */
            READABLE,
            /**
             * Property is writable.
             */
            WRITABLE,
        }
        /**
         * Flags used when constructing an instance of a #GDBusProxy derived class.
         */

        /**
         * Flags used when constructing an instance of a #GDBusProxy derived class.
         */
        export namespace DBusProxyFlags {
            export const $gtype: GObject.GType<DBusProxyFlags>;
        }

        enum DBusProxyFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Don't load properties.
             */
            DO_NOT_LOAD_PROPERTIES,
            /**
             * Don't connect to signals on the remote object.
             */
            DO_NOT_CONNECT_SIGNALS,
            /**
             * If the proxy is for a well-known name,
             * do not ask the bus to launch an owner during proxy initialization or a method call.
             * This flag is only meaningful in proxies for well-known names.
             */
            DO_NOT_AUTO_START,
            /**
             * If set, the property value for any __invalidated property__ will be (asynchronously) retrieved upon receiving the [`PropertiesChanged`](http://dbus.freedesktop.org/doc/dbus-specification.html#standard-interfaces-properties) D-Bus signal and the property will not cause emission of the #GDBusProxy::g-properties-changed signal. When the value is received the #GDBusProxy::g-properties-changed signal is emitted for the property along with the retrieved value. Since 2.32.
             */
            GET_INVALIDATED_PROPERTIES,
            /**
             * If the proxy is for a well-known name,
             * do not ask the bus to launch an owner during proxy initialization, but allow it to be
             * autostarted by a method call. This flag is only meaningful in proxies for well-known names,
             * and only if %G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START is not also specified.
             */
            DO_NOT_AUTO_START_AT_CONSTRUCTION,
            /**
             * Don't actually send the AddMatch D-Bus
             *    call for this signal subscription. This gives you more control
             *    over which match rules you add (but you must add them manually). (Since: 2.72)
             */
            NO_MATCH_RULE,
        }
        /**
         * Flags used when sending #GDBusMessages on a #GDBusConnection.
         */

        /**
         * Flags used when sending #GDBusMessages on a #GDBusConnection.
         */
        export namespace DBusSendMessageFlags {
            export const $gtype: GObject.GType<DBusSendMessageFlags>;
        }

        enum DBusSendMessageFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Do not automatically
             * assign a serial number from the #GDBusConnection object when
             * sending a message.
             */
            PRESERVE_SERIAL,
        }
        /**
         * Flags used when creating a #GDBusServer.
         */

        /**
         * Flags used when creating a #GDBusServer.
         */
        export namespace DBusServerFlags {
            export const $gtype: GObject.GType<DBusServerFlags>;
        }

        enum DBusServerFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * All #GDBusServer::new-connection
             * signals will run in separated dedicated threads (see signal for
             * details).
             */
            RUN_IN_THREAD,
            /**
             * Allow the anonymous
             * authentication method.
             */
            AUTHENTICATION_ALLOW_ANONYMOUS,
            /**
             * Require the UID of the
             * peer to be the same as the UID of the server when authenticating. (Since: 2.68)
             */
            AUTHENTICATION_REQUIRE_SAME_USER,
        }
        /**
         * Flags used when subscribing to signals via g_dbus_connection_signal_subscribe().
         */

        /**
         * Flags used when subscribing to signals via g_dbus_connection_signal_subscribe().
         */
        export namespace DBusSignalFlags {
            export const $gtype: GObject.GType<DBusSignalFlags>;
        }

        enum DBusSignalFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Don't actually send the AddMatch
             * D-Bus call for this signal subscription.  This gives you more control
             * over which match rules you add (but you must add them manually).
             */
            NO_MATCH_RULE,
            /**
             * Match first arguments that
             * contain a bus or interface name with the given namespace.
             */
            MATCH_ARG0_NAMESPACE,
            /**
             * Match first arguments that
             * contain an object path that is either equivalent to the given path,
             * or one of the paths is a subpath of the other.
             */
            MATCH_ARG0_PATH,
        }
        /**
         * Flags passed to g_dbus_connection_register_subtree().
         */

        /**
         * Flags passed to g_dbus_connection_register_subtree().
         */
        export namespace DBusSubtreeFlags {
            export const $gtype: GObject.GType<DBusSubtreeFlags>;
        }

        enum DBusSubtreeFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Method calls to objects not in the enumerated range
             *                                                       will still be dispatched. This is useful if you want
             *                                                       to dynamically spawn objects in the subtree.
             */
            DISPATCH_TO_UNENUMERATED_NODES,
        }
        /**
         * Flags used when starting a drive.
         */

        /**
         * Flags used when starting a drive.
         */
        export namespace DriveStartFlags {
            export const $gtype: GObject.GType<DriveStartFlags>;
        }

        enum DriveStartFlags {
            /**
             * No flags set.
             */
            NONE,
        }
        /**
         * Flags specifying the behaviour of an attribute.
         */

        /**
         * Flags specifying the behaviour of an attribute.
         */
        export namespace FileAttributeInfoFlags {
            export const $gtype: GObject.GType<FileAttributeInfoFlags>;
        }

        enum FileAttributeInfoFlags {
            /**
             * no flags set.
             */
            NONE,
            /**
             * copy the attribute values when the file is copied.
             */
            COPY_WITH_FILE,
            /**
             * copy the attribute values when the file is moved.
             */
            COPY_WHEN_MOVED,
        }
        /**
         * Flags used when copying or moving files.
         */

        /**
         * Flags used when copying or moving files.
         */
        export namespace FileCopyFlags {
            export const $gtype: GObject.GType<FileCopyFlags>;
        }

        enum FileCopyFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Overwrite any existing files
             */
            OVERWRITE,
            /**
             * Make a backup of any existing files.
             */
            BACKUP,
            /**
             * Don't follow symlinks.
             */
            NOFOLLOW_SYMLINKS,
            /**
             * Copy all file metadata instead of just default set used for copy (see #GFileInfo).
             */
            ALL_METADATA,
            /**
             * Don't use copy and delete fallback if native move not supported.
             */
            NO_FALLBACK_FOR_MOVE,
            /**
             * Leaves target file with default perms, instead of setting the source file perms.
             */
            TARGET_DEFAULT_PERMS,
            /**
             * Use default modification
             *     timestamps instead of copying them from the source file. Since 2.80
             */
            TARGET_DEFAULT_MODIFIED_TIME,
        }
        /**
         * Flags used when an operation may create a file.
         */

        /**
         * Flags used when an operation may create a file.
         */
        export namespace FileCreateFlags {
            export const $gtype: GObject.GType<FileCreateFlags>;
        }

        enum FileCreateFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Create a file that can only be
             *    accessed by the current user.
             */
            PRIVATE,
            /**
             * Replace the destination
             *    as if it didn't exist before. Don't try to keep any old
             *    permissions, replace instead of following links. This
             *    is generally useful if you're doing a "copy over"
             *    rather than a "save new version of" replace operation.
             *    You can think of it as "unlink destination" before
             *    writing to it, although the implementation may not
             *    be exactly like that. This flag can only be used with
             *    g_file_replace() and its variants, including g_file_replace_contents().
             *    Since 2.20
             */
            REPLACE_DESTINATION,
        }
        /**
         * Flags that can be used with g_file_measure_disk_usage().
         */

        /**
         * Flags that can be used with g_file_measure_disk_usage().
         */
        export namespace FileMeasureFlags {
            export const $gtype: GObject.GType<FileMeasureFlags>;
        }

        enum FileMeasureFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Report any error encountered
             *   while traversing the directory tree.  Normally errors are only
             *   reported for the toplevel file.
             */
            REPORT_ANY_ERROR,
            /**
             * Tally usage based on apparent file
             *   sizes.  Normally, the block-size is used, if available, as this is a
             *   more accurate representation of disk space used.
             *   Compare with `du --apparent-size`.
             *   Since GLib 2.78. and similarly to `du` since GNU Coreutils 9.2, this will
             *   ignore the sizes of file types other than regular files and links, as the
             *   sizes of other file types are not specified in a standard way.
             */
            APPARENT_SIZE,
            /**
             * Do not cross mount point boundaries.
             *   Compare with `du -x`.
             */
            NO_XDEV,
        }
        /**
         * Flags used to set what a #GFileMonitor will watch for.
         */

        /**
         * Flags used to set what a #GFileMonitor will watch for.
         */
        export namespace FileMonitorFlags {
            export const $gtype: GObject.GType<FileMonitorFlags>;
        }

        enum FileMonitorFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Watch for mount events.
             */
            WATCH_MOUNTS,
            /**
             * Pair DELETED and CREATED events caused
             *   by file renames (moves) and send a single G_FILE_MONITOR_EVENT_MOVED
             *   event instead (NB: not supported on all backends; the default
             *   behaviour -without specifying this flag- is to send single DELETED
             *   and CREATED events).  Deprecated since 2.46: use
             *   %G_FILE_MONITOR_WATCH_MOVES instead.
             */
            SEND_MOVED,
            /**
             * Watch for changes to the file made
             *   via another hard link. Since 2.36.
             */
            WATCH_HARD_LINKS,
            /**
             * Watch for rename operations on a
             *   monitored directory.  This causes %G_FILE_MONITOR_EVENT_RENAMED,
             *   %G_FILE_MONITOR_EVENT_MOVED_IN and %G_FILE_MONITOR_EVENT_MOVED_OUT
             *   events to be emitted when possible.  Since: 2.46.
             */
            WATCH_MOVES,
        }
        /**
         * Flags used when querying a #GFileInfo.
         */

        /**
         * Flags used when querying a #GFileInfo.
         */
        export namespace FileQueryInfoFlags {
            export const $gtype: GObject.GType<FileQueryInfoFlags>;
        }

        enum FileQueryInfoFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Don't follow symlinks.
             */
            NOFOLLOW_SYMLINKS,
        }
        /**
         * GIOStreamSpliceFlags determine how streams should be spliced.
         */

        /**
         * GIOStreamSpliceFlags determine how streams should be spliced.
         */
        export namespace IOStreamSpliceFlags {
            export const $gtype: GObject.GType<IOStreamSpliceFlags>;
        }

        enum IOStreamSpliceFlags {
            /**
             * Do not close either stream.
             */
            NONE,
            /**
             * Close the first stream after
             *     the splice.
             */
            CLOSE_STREAM1,
            /**
             * Close the second stream after
             *     the splice.
             */
            CLOSE_STREAM2,
            /**
             * Wait for both splice operations to finish
             *     before calling the callback.
             */
            WAIT_FOR_BOTH,
        }
        /**
         * Flags used when mounting a mount.
         */

        /**
         * Flags used when mounting a mount.
         */
        export namespace MountMountFlags {
            export const $gtype: GObject.GType<MountMountFlags>;
        }

        enum MountMountFlags {
            /**
             * No flags set.
             */
            NONE,
        }
        /**
         * Flags used when an unmounting a mount.
         */

        /**
         * Flags used when an unmounting a mount.
         */
        export namespace MountUnmountFlags {
            export const $gtype: GObject.GType<MountUnmountFlags>;
        }

        enum MountUnmountFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * Unmount even if there are outstanding
             *  file operations on the mount.
             */
            FORCE,
        }
        /**
         * GOutputStreamSpliceFlags determine how streams should be spliced.
         */

        /**
         * GOutputStreamSpliceFlags determine how streams should be spliced.
         */
        export namespace OutputStreamSpliceFlags {
            export const $gtype: GObject.GType<OutputStreamSpliceFlags>;
        }

        enum OutputStreamSpliceFlags {
            /**
             * Do not close either stream.
             */
            NONE,
            /**
             * Close the source stream after
             *     the splice.
             */
            CLOSE_SOURCE,
            /**
             * Close the target stream after
             *     the splice.
             */
            CLOSE_TARGET,
        }
        /**
         * Flags to modify lookup behavior.
         */

        /**
         * Flags to modify lookup behavior.
         */
        export namespace ResolverNameLookupFlags {
            export const $gtype: GObject.GType<ResolverNameLookupFlags>;
        }

        enum ResolverNameLookupFlags {
            /**
             * default behavior (same as g_resolver_lookup_by_name())
             */
            DEFAULT,
            /**
             * only resolve ipv4 addresses
             */
            IPV4_ONLY,
            /**
             * only resolve ipv6 addresses
             */
            IPV6_ONLY,
        }
        /**
         * GResourceFlags give information about a particular file inside a resource
         * bundle.
         */

        /**
         * GResourceFlags give information about a particular file inside a resource
         * bundle.
         */
        export namespace ResourceFlags {
            export const $gtype: GObject.GType<ResourceFlags>;
        }

        enum ResourceFlags {
            /**
             * No flags set.
             */
            NONE,
            /**
             * The file is compressed.
             */
            COMPRESSED,
        }
        /**
         * GResourceLookupFlags determine how resource path lookups are handled.
         */

        /**
         * GResourceLookupFlags determine how resource path lookups are handled.
         */
        export namespace ResourceLookupFlags {
            export const $gtype: GObject.GType<ResourceLookupFlags>;
        }

        enum ResourceLookupFlags {
            /**
             * No flags set.
             */
            NONE,
        }
        /**
         * Flags used when creating a binding.
         *
         * These flags determine in which direction the binding works. The default is to
         * synchronize in both directions.
         */

        /**
         * Flags used when creating a binding.
         *
         * These flags determine in which direction the binding works. The default is to
         * synchronize in both directions.
         */
        export namespace SettingsBindFlags {
            export const $gtype: GObject.GType<SettingsBindFlags>;
        }

        enum SettingsBindFlags {
            /**
             * Equivalent to `G_SETTINGS_BIND_GET|G_SETTINGS_BIND_SET`
             */
            DEFAULT,
            /**
             * Update the [class`GObject`.Object] property when the setting changes.
             *   It is an error to use this flag if the property is not writable.
             */
            GET,
            /**
             * Update the setting when the [class`GObject`.Object] property changes.
             *   It is an error to use this flag if the property is not readable.
             */
            SET,
            /**
             * Do not try to bind a ‘sensitivity’ property to the writability of the setting
             */
            NO_SENSITIVITY,
            /**
             * When set in addition to [flags`Gio`.SettingsBindFlags.GET],
             *   set the [class`GObject`.Object] property
             *   value initially from the setting, but do not listen for changes of the setting
             */
            GET_NO_CHANGES,
            /**
             * When passed to [method`Gio`.Settings.bind],
             *   uses a pair of mapping functions that invert
             *   the boolean value when mapping between the setting and the property.  The setting and property must both
             *   be booleans.  You cannot pass this flag to [method`Gio`.Settings.bind_with_mapping].
             */
            INVERT_BOOLEAN,
        }
        /**
         * Flags used in g_socket_receive_message() and g_socket_send_message().
         * The flags listed in the enum are some commonly available flags, but the
         * values used for them are the same as on the platform, and any other flags
         * are passed in/out as is. So to use a platform specific flag, just include
         * the right system header and pass in the flag.
         */

        /**
         * Flags used in g_socket_receive_message() and g_socket_send_message().
         * The flags listed in the enum are some commonly available flags, but the
         * values used for them are the same as on the platform, and any other flags
         * are passed in/out as is. So to use a platform specific flag, just include
         * the right system header and pass in the flag.
         */
        export namespace SocketMsgFlags {
            export const $gtype: GObject.GType<SocketMsgFlags>;
        }

        enum SocketMsgFlags {
            /**
             * No flags.
             */
            NONE,
            /**
             * Request to send/receive out of band data.
             */
            OOB,
            /**
             * Read data from the socket without removing it from
             *     the queue.
             */
            PEEK,
            /**
             * Don't use a gateway to send out the packet,
             *     only send to hosts on directly connected networks.
             */
            DONTROUTE,
        }
        /**
         * Flags to define the behaviour of a #GSubprocess.
         *
         * Note that the default for stdin is to redirect from `/dev/null`.  For
         * stdout and stderr the default are for them to inherit the
         * corresponding descriptor from the calling process.
         *
         * Note that it is a programmer error to mix 'incompatible' flags.  For
         * example, you may not request both %G_SUBPROCESS_FLAGS_STDOUT_PIPE and
         * %G_SUBPROCESS_FLAGS_STDOUT_SILENCE.
         */

        /**
         * Flags to define the behaviour of a #GSubprocess.
         *
         * Note that the default for stdin is to redirect from `/dev/null`.  For
         * stdout and stderr the default are for them to inherit the
         * corresponding descriptor from the calling process.
         *
         * Note that it is a programmer error to mix 'incompatible' flags.  For
         * example, you may not request both %G_SUBPROCESS_FLAGS_STDOUT_PIPE and
         * %G_SUBPROCESS_FLAGS_STDOUT_SILENCE.
         */
        export namespace SubprocessFlags {
            export const $gtype: GObject.GType<SubprocessFlags>;
        }

        enum SubprocessFlags {
            /**
             * No flags.
             */
            NONE,
            /**
             * create a pipe for the stdin of the
             *   spawned process that can be accessed with
             *   g_subprocess_get_stdin_pipe().
             */
            STDIN_PIPE,
            /**
             * stdin is inherited from the
             *   calling process.
             */
            STDIN_INHERIT,
            /**
             * create a pipe for the stdout of the
             *   spawned process that can be accessed with
             *   g_subprocess_get_stdout_pipe().
             */
            STDOUT_PIPE,
            /**
             * silence the stdout of the spawned
             *   process (ie: redirect to `/dev/null`).
             */
            STDOUT_SILENCE,
            /**
             * create a pipe for the stderr of the
             *   spawned process that can be accessed with
             *   g_subprocess_get_stderr_pipe().
             */
            STDERR_PIPE,
            /**
             * silence the stderr of the spawned
             *   process (ie: redirect to `/dev/null`).
             */
            STDERR_SILENCE,
            /**
             * merge the stderr of the spawned
             *   process with whatever the stdout happens to be.  This is a good way
             *   of directing both streams to a common log file, for example.
             */
            STDERR_MERGE,
            /**
             * spawned processes will inherit the
             *   file descriptors of their parent, unless those descriptors have
             *   been explicitly marked as close-on-exec.  This flag has no effect
             *   over the "standard" file descriptors (stdin, stdout, stderr).
             */
            INHERIT_FDS,
            /**
             * if path searching is
             *   needed when spawning the subprocess, use the `PATH` in the launcher
             *   environment. (Since: 2.72)
             */
            SEARCH_PATH_FROM_ENVP,
        }
        /**
         * Flags to define future #GTestDBus behaviour.
         */

        /**
         * Flags to define future #GTestDBus behaviour.
         */
        export namespace TestDBusFlags {
            export const $gtype: GObject.GType<TestDBusFlags>;
        }

        enum TestDBusFlags {
            /**
             * No flags.
             */
            NONE,
        }
        /**
         * A set of flags describing TLS certification validation. This can be
         * used to describe why a particular certificate was rejected (for
         * example, in #GTlsConnection::accept-certificate).
         *
         * GLib guarantees that if certificate verification fails, at least one
         * flag will be set, but it does not guarantee that all possible flags
         * will be set. Accordingly, you may not safely decide to ignore any
         * particular type of error. For example, it would be incorrect to mask
         * %G_TLS_CERTIFICATE_EXPIRED if you want to allow expired certificates,
         * because this could potentially be the only error flag set even if
         * other problems exist with the certificate.
         */

        /**
         * A set of flags describing TLS certification validation. This can be
         * used to describe why a particular certificate was rejected (for
         * example, in #GTlsConnection::accept-certificate).
         *
         * GLib guarantees that if certificate verification fails, at least one
         * flag will be set, but it does not guarantee that all possible flags
         * will be set. Accordingly, you may not safely decide to ignore any
         * particular type of error. For example, it would be incorrect to mask
         * %G_TLS_CERTIFICATE_EXPIRED if you want to allow expired certificates,
         * because this could potentially be the only error flag set even if
         * other problems exist with the certificate.
         */
        export namespace TlsCertificateFlags {
            export const $gtype: GObject.GType<TlsCertificateFlags>;
        }

        enum TlsCertificateFlags {
            /**
             * No flags set. Since: 2.74
             */
            NO_FLAGS,
            /**
             * The signing certificate authority is
             *   not known.
             */
            UNKNOWN_CA,
            /**
             * The certificate does not match the
             *   expected identity of the site that it was retrieved from.
             */
            BAD_IDENTITY,
            /**
             * The certificate's activation time
             *   is still in the future
             */
            NOT_ACTIVATED,
            /**
             * The certificate has expired
             */
            EXPIRED,
            /**
             * The certificate has been revoked
             *   according to the #GTlsConnection's certificate revocation list.
             */
            REVOKED,
            /**
             * The certificate's algorithm is
             *   considered insecure.
             */
            INSECURE,
            /**
             * Some other error occurred validating
             *   the certificate
             */
            GENERIC_ERROR,
            /**
             * the combination of all of the above
             *   flags
             */
            VALIDATE_ALL,
        }
        /**
         * Flags for g_tls_database_verify_chain().
         */

        /**
         * Flags for g_tls_database_verify_chain().
         */
        export namespace TlsDatabaseVerifyFlags {
            export const $gtype: GObject.GType<TlsDatabaseVerifyFlags>;
        }

        enum TlsDatabaseVerifyFlags {
            /**
             * No verification flags
             */
            NONE,
        }
        /**
         * Various flags for the password.
         */

        /**
         * Various flags for the password.
         */
        export namespace TlsPasswordFlags {
            export const $gtype: GObject.GType<TlsPasswordFlags>;
        }

        enum TlsPasswordFlags {
            /**
             * No flags
             */
            NONE,
            /**
             * The password was wrong, and the user should retry.
             */
            RETRY,
            /**
             * Hint to the user that the password has been
             *    wrong many times, and the user may not have many chances left.
             */
            MANY_TRIES,
            /**
             * Hint to the user that this is the last try to get
             *    this password right.
             */
            FINAL_TRY,
            /**
             * For PKCS #11, the user PIN is required.
             *    Since: 2.70.
             */
            PKCS11_USER,
            /**
             * For PKCS #11, the security officer
             *    PIN is required. Since: 2.70.
             */
            PKCS11_SECURITY_OFFICER,
            /**
             * For PKCS #11, the context-specific
             *    PIN is required. Since: 2.70.
             */
            PKCS11_CONTEXT_SPECIFIC,
        }
        namespace AppInfoMonitor {
            // Signal callback interfaces

            interface Changed {
                (): void;
            }

            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps {}
        }

        /**
         * `GAppInfoMonitor` monitors application information for changes.
         *
         * `GAppInfoMonitor` is a very simple object used for monitoring the app
         * info database for changes (newly installed or removed applications).
         *
         * Call [func`Gio`.AppInfoMonitor.get] to get a `GAppInfoMonitor` and connect
         * to the [signal`Gio`.AppInfoMonitor::changed] signal. The signal will be emitted once when
         * the app info database changes, and will not be emitted again until after the
         * next call to [func`Gio`.AppInfo.get_all] or another `g_app_info_*()` function.
         * This is because monitoring the app info database for changes is expensive.
         *
         * The following functions will re-arm the [signal`Gio`.AppInfoMonitor::changed]
         * signal so it can be emitted again:
         *
         *  - [func`Gio`.AppInfo.get_all]
         *  - [func`Gio`.AppInfo.get_all_for_type]
         *  - [func`Gio`.AppInfo.get_default_for_type]
         *  - [func`Gio`.AppInfo.get_fallback_for_type]
         *  - [func`Gio`.AppInfo.get_recommended_for_type]
         *  - [`g_desktop_app_info_get_implementations()`](../gio-unix/type_func.DesktopAppInfo.get_implementation.html)
         *  - [`g_desktop_app_info_new()`](../gio-unix/ctor.DesktopAppInfo.new.html)
         *  - [`g_desktop_app_info_new_from_filename()`](../gio-unix/ctor.DesktopAppInfo.new_from_filename.html)
         *  - [`g_desktop_app_info_new_from_keyfile()`](../gio-unix/ctor.DesktopAppInfo.new_from_keyfile.html)
         *  - [`g_desktop_app_info_search()`](../gio-unix/type_func.DesktopAppInfo.search.html)
         *
         * The latter functions are available if using
         * [`GDesktopAppInfo`](../gio-unix/class.DesktopAppInfo.html) from
         * `gio-unix-2.0.pc` (GIR namespace `GioUnix-2.0`).
         *
         * In the usual case, applications should try to make note of the change
         * (doing things like invalidating caches) but not act on it. In
         * particular, applications should avoid making calls to `GAppInfo` APIs
         * in response to the change signal, deferring these until the time that
         * the updated data is actually required. The exception to this case is when
         * application information is actually being displayed on the screen
         * (for example, during a search or when the list of all applications is shown).
         * The reason for this is that changes to the list of installed applications
         * often come in groups (like during system updates) and rescanning the list
         * on every change is pointless and expensive.
         */
        class AppInfoMonitor extends GObject.Object {
            static $gtype: GObject.GType<AppInfoMonitor>;

            // Constructors

            constructor(properties?: Partial<AppInfoMonitor.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'changed', callback: (_source: this) => void): number;
            connect_after(signal: 'changed', callback: (_source: this) => void): number;
            emit(signal: 'changed'): void;

            // Static methods

            /**
             * Gets the #GAppInfoMonitor for the current thread-default main
             * context.
             *
             * The #GAppInfoMonitor will emit a “changed” signal in the
             * thread-default main context whenever the list of installed
             * applications (as reported by g_app_info_get_all()) may have changed.
             *
             * The #GAppInfoMonitor::changed signal will only be emitted once until
             * g_app_info_get_all() (or another `g_app_info_*()` function) is called. Doing
             * so will re-arm the signal ready to notify about the next change.
             *
             * You must only call g_object_unref() on the return value from under
             * the same main context as you created it.
             */
            static get(): AppInfoMonitor;
        }

        namespace AppLaunchContext {
            // Signal callback interfaces

            interface LaunchFailed {
                (startup_notify_id: string): void;
            }

            interface LaunchStarted {
                (info: AppInfo, platform_data?: GLib.Variant | null): void;
            }

            interface Launched {
                (info: AppInfo, platform_data: GLib.Variant): void;
            }

            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps {}
        }

        /**
         * Integrating the launch with the launching application. This is used to
         * handle for instance startup notification and launching the new application
         * on the same screen as the launching window.
         */
        class AppLaunchContext extends GObject.Object {
            static $gtype: GObject.GType<AppLaunchContext>;

            // Constructors

            constructor(properties?: Partial<AppLaunchContext.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](): AppLaunchContext;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'launch-failed', callback: (_source: this, startup_notify_id: string) => void): number;
            connect_after(
                signal: 'launch-failed',
                callback: (_source: this, startup_notify_id: string) => void,
            ): number;
            emit(signal: 'launch-failed', startup_notify_id: string): void;
            connect(
                signal: 'launch-started',
                callback: (_source: this, info: AppInfo, platform_data: GLib.Variant | null) => void,
            ): number;
            connect_after(
                signal: 'launch-started',
                callback: (_source: this, info: AppInfo, platform_data: GLib.Variant | null) => void,
            ): number;
            emit(signal: 'launch-started', info: AppInfo, platform_data?: GLib.Variant | null): void;
            connect(
                signal: 'launched',
                callback: (_source: this, info: AppInfo, platform_data: GLib.Variant) => void,
            ): number;
            connect_after(
                signal: 'launched',
                callback: (_source: this, info: AppInfo, platform_data: GLib.Variant) => void,
            ): number;
            emit(signal: 'launched', info: AppInfo, platform_data: GLib.Variant): void;

            // Virtual methods

            /**
             * Gets the display string for the `context`. This is used to ensure new
             * applications are started on the same display as the launching
             * application, by setting the `DISPLAY` environment variable.
             * @param info the app info
             * @param files a list of [iface@Gio.File] objects
             */
            vfunc_get_display(info: AppInfo, files: File[]): string | null;
            /**
             * Initiates startup notification for the application and returns the
             * `XDG_ACTIVATION_TOKEN` or `DESKTOP_STARTUP_ID` for the launched operation,
             * if supported.
             *
             * The returned token may be referred to equivalently as an ‘activation token’
             * (using Wayland terminology) or a ‘startup sequence ID’ (using X11 terminology).
             * The two [are interoperable](https://gitlab.freedesktop.org/wayland/wayland-protocols/-/blob/main/staging/xdg-activation/x11-interoperation.rst).
             *
             * Activation tokens are defined in the [XDG Activation Protocol](https://wayland.app/protocols/xdg-activation-v1),
             * and startup notification IDs are defined in the
             * [freedesktop.org Startup Notification Protocol](http://standards.freedesktop.org/startup-notification-spec/startup-notification-latest.txt).
             *
             * Support for the XDG Activation Protocol was added in GLib 2.76.
             * Since GLib 2.82 `info` and `files` can be `NULL`. If that’s not supported by the backend,
             * the returned token will be `NULL`.
             * @param info the app info
             * @param files a list of [iface@Gio.File] objects
             */
            vfunc_get_startup_notify_id(info?: AppInfo | null, files?: File[] | null): string | null;
            /**
             * Called when an application has failed to launch, so that it can cancel
             * the application startup notification started in
             * [method`Gio`.AppLaunchContext.get_startup_notify_id].
             * @param startup_notify_id the startup notification id that was returned by   [method@Gio.AppLaunchContext.get_startup_notify_id].
             */
            vfunc_launch_failed(startup_notify_id: string): void;
            vfunc_launch_started(info: AppInfo, platform_data: GLib.Variant): void;
            vfunc_launched(info: AppInfo, platform_data: GLib.Variant): void;

            // Methods

            /**
             * Gets the display string for the `context`. This is used to ensure new
             * applications are started on the same display as the launching
             * application, by setting the `DISPLAY` environment variable.
             * @param info the app info
             * @param files a list of [iface@Gio.File] objects
             * @returns a display string for the display.
             */
            get_display(info: AppInfo, files: File[]): string | null;
            /**
             * Gets the complete environment variable list to be passed to
             * the child process when `context` is used to launch an application.
             * This is a `NULL`-terminated array of strings, where each string has
             * the form `KEY=VALUE`.
             * @returns the child’s environment
             */
            get_environment(): string[];
            /**
             * Initiates startup notification for the application and returns the
             * `XDG_ACTIVATION_TOKEN` or `DESKTOP_STARTUP_ID` for the launched operation,
             * if supported.
             *
             * The returned token may be referred to equivalently as an ‘activation token’
             * (using Wayland terminology) or a ‘startup sequence ID’ (using X11 terminology).
             * The two [are interoperable](https://gitlab.freedesktop.org/wayland/wayland-protocols/-/blob/main/staging/xdg-activation/x11-interoperation.rst).
             *
             * Activation tokens are defined in the [XDG Activation Protocol](https://wayland.app/protocols/xdg-activation-v1),
             * and startup notification IDs are defined in the
             * [freedesktop.org Startup Notification Protocol](http://standards.freedesktop.org/startup-notification-spec/startup-notification-latest.txt).
             *
             * Support for the XDG Activation Protocol was added in GLib 2.76.
             * Since GLib 2.82 `info` and `files` can be `NULL`. If that’s not supported by the backend,
             * the returned token will be `NULL`.
             * @param info the app info
             * @param files a list of [iface@Gio.File] objects
             * @returns a startup notification ID for the application, or `NULL` if   not supported.
             */
            get_startup_notify_id(info?: AppInfo | null, files?: File[] | null): string | null;
            /**
             * Called when an application has failed to launch, so that it can cancel
             * the application startup notification started in
             * [method`Gio`.AppLaunchContext.get_startup_notify_id].
             * @param startup_notify_id the startup notification id that was returned by   [method@Gio.AppLaunchContext.get_startup_notify_id].
             */
            launch_failed(startup_notify_id: string): void;
            /**
             * Arranges for `variable` to be set to `value` in the child’s environment when
             * `context` is used to launch an application.
             * @param variable the environment variable to set
             * @param value the value for to set the variable to.
             */
            setenv(variable: string, value: string): void;
            /**
             * Arranges for `variable` to be unset in the child’s environment when `context`
             * is used to launch an application.
             * @param variable the environment variable to remove
             */
            unsetenv(variable: string): void;
        }

        namespace Application {
            // Signal callback interfaces

            interface Activate {
                (): void;
            }

            interface CommandLine {
                (command_line: ApplicationCommandLine): number;
            }

            interface HandleLocalOptions {
                (options: GLib.VariantDict): number;
            }

            interface NameLost {
                (): boolean;
            }

            interface Open {
                (files: File[], hint: string): void;
            }

            interface Shutdown {
                (): void;
            }

            interface Startup {
                (): void;
            }

            // Constructor properties interface

            interface ConstructorProps
                extends GObject.Object.ConstructorProps,
                    ActionGroup.ConstructorProps,
                    ActionMap.ConstructorProps {
                action_group: ActionGroup;
                actionGroup: ActionGroup;
                application_id: string;
                applicationId: string;
                flags: ApplicationFlags;
                inactivity_timeout: number;
                inactivityTimeout: number;
                is_busy: boolean;
                isBusy: boolean;
                is_registered: boolean;
                isRegistered: boolean;
                is_remote: boolean;
                isRemote: boolean;
                resource_base_path: string;
                resourceBasePath: string;
                version: string;
            }
        }

        /**
         * `GApplication` is the core class for application support.
         *
         * A `GApplication` is the foundation of an application. It wraps some
         * low-level platform-specific services and is intended to act as the
         * foundation for higher-level application classes such as
         * `GtkApplication` or `MxApplication`. In general, you should not use
         * this class outside of a higher level framework.
         *
         * `GApplication` provides convenient life-cycle management by maintaining
         * a "use count" for the primary application instance. The use count can
         * be changed using [method`Gio`.Application.hold] and
         * [method`Gio`.Application.release]. If it drops to zero, the application
         * exits. Higher-level classes such as `GtkApplication` employ the use count
         * to ensure that the application stays alive as long as it has any opened
         * windows.
         *
         * Another feature that `GApplication` (optionally) provides is process
         * uniqueness. Applications can make use of this functionality by
         * providing a unique application ID. If given, only one application
         * with this ID can be running at a time per session. The session
         * concept is platform-dependent, but corresponds roughly to a graphical
         * desktop login. When your application is launched again, its
         * arguments are passed through platform communication to the already
         * running program. The already running instance of the program is
         * called the "primary instance"; for non-unique applications this is
         * always the current instance. On Linux, the D-Bus session bus
         * is used for communication.
         *
         * The use of `GApplication` differs from some other commonly-used
         * uniqueness libraries (such as libunique) in important ways. The
         * application is not expected to manually register itself and check
         * if it is the primary instance. Instead, the main() function of a
         * `GApplication` should do very little more than instantiating the
         * application instance, possibly connecting signal handlers, then
         * calling [method`Gio`.Application.run]. All checks for uniqueness are done
         * internally. If the application is the primary instance then the
         * startup signal is emitted and the mainloop runs. If the application
         * is not the primary instance then a signal is sent to the primary
         * instance and [method`Gio`.Application.run] promptly returns. See the code
         * examples below.
         *
         * If used, the expected form of an application identifier is the
         * same as that of a
         * [D-Bus well-known bus name](https://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-names-bus).
         * Examples include: `com.example.MyApp`, `org.example.internal_apps.Calculator`,
         * `org._7_zip.Archiver`.
         * For details on valid application identifiers, see [func`Gio`.Application.id_is_valid].
         *
         * On Linux, the application identifier is claimed as a well-known bus name
         * on the user's session bus. This means that the uniqueness of your
         * application is scoped to the current session. It also means that your
         * application may provide additional services (through registration of other
         * object paths) at that bus name. The registration of these object paths
         * should be done with the shared GDBus session bus. Note that due to the
         * internal architecture of GDBus, method calls can be dispatched at any time
         * (even if a main loop is not running). For this reason, you must ensure that
         * any object paths that you wish to register are registered before #GApplication
         * attempts to acquire the bus name of your application (which happens in
         * [method`Gio`.Application.register]). Unfortunately, this means that you cannot
         * use [property`Gio`.Application:is-remote] to decide if you want to register
         * object paths.
         *
         * `GApplication` also implements the [iface`Gio`.ActionGroup] and [iface`Gio`.ActionMap]
         * interfaces and lets you easily export actions by adding them with
         * [method`Gio`.ActionMap.add_action]. When invoking an action by calling
         * [method`Gio`.ActionGroup.activate_action] on the application, it is always
         * invoked in the primary instance. The actions are also exported on
         * the session bus, and GIO provides the [class`Gio`.DBusActionGroup] wrapper to
         * conveniently access them remotely. GIO provides a [class`Gio`.DBusMenuModel] wrapper
         * for remote access to exported [class`Gio`.MenuModel]s.
         *
         * Note: Due to the fact that actions are exported on the session bus,
         * using `maybe` parameters is not supported, since D-Bus does not support
         * `maybe` types.
         *
         * There is a number of different entry points into a `GApplication`:
         *
         * - via 'Activate' (i.e. just starting the application)
         *
         * - via 'Open' (i.e. opening some files)
         *
         * - by handling a command-line
         *
         * - via activating an action
         *
         * The [signal`Gio`.Application::startup] signal lets you handle the application
         * initialization for all of these in a single place.
         *
         * Regardless of which of these entry points is used to start the
         * application, `GApplication` passes some ‘platform data’ from the
         * launching instance to the primary instance, in the form of a
         * [struct`GLib`.Variant] dictionary mapping strings to variants. To use platform
         * data, override the [vfunc`Gio`.Application.before_emit] or
         * [vfunc`Gio`.Application.after_emit] virtual functions
         * in your `GApplication` subclass. When dealing with
         * [class`Gio`.ApplicationCommandLine] objects, the platform data is
         * directly available via [method`Gio`.ApplicationCommandLine.get_cwd],
         * [method`Gio`.ApplicationCommandLine.get_environ] and
         * [method`Gio`.ApplicationCommandLine.get_platform_data].
         *
         * As the name indicates, the platform data may vary depending on the
         * operating system, but it always includes the current directory (key
         * `cwd`), and optionally the environment (ie the set of environment
         * variables and their values) of the calling process (key `environ`).
         * The environment is only added to the platform data if the
         * `G_APPLICATION_SEND_ENVIRONMENT` flag is set. `GApplication` subclasses
         * can add their own platform data by overriding the
         * [vfunc`Gio`.Application.add_platform_data] virtual function. For instance,
         * `GtkApplication` adds startup notification data in this way.
         *
         * To parse commandline arguments you may handle the
         * [signal`Gio`.Application::command-line] signal or override the
         * [vfunc`Gio`.Application.local_command_line] virtual function, to parse them in
         * either the primary instance or the local instance, respectively.
         *
         * For an example of opening files with a `GApplication`, see
         * [gapplication-example-open.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gapplication-example-open.c).
         *
         * For an example of using actions with `GApplication`, see
         * [gapplication-example-actions.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gapplication-example-actions.c).
         *
         * For an example of using extra D-Bus hooks with `GApplication`, see
         * [gapplication-example-dbushooks.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gapplication-example-dbushooks.c).
         */
        class Application extends GObject.Object implements ActionGroup, ActionMap {
            static $gtype: GObject.GType<Application>;

            // Properties

            /**
             * The group of actions that the application exports.
             */
            set action_group(val: ActionGroup);
            /**
             * The group of actions that the application exports.
             */
            set actionGroup(val: ActionGroup);
            /**
             * The unique identifier for the application.
             */
            get application_id(): string;
            set application_id(val: string);
            /**
             * The unique identifier for the application.
             */
            get applicationId(): string;
            set applicationId(val: string);
            /**
             * Flags specifying the behaviour of the application.
             */
            get flags(): ApplicationFlags;
            set flags(val: ApplicationFlags);
            /**
             * Time (in milliseconds) to stay alive after becoming idle.
             */
            get inactivity_timeout(): number;
            set inactivity_timeout(val: number);
            /**
             * Time (in milliseconds) to stay alive after becoming idle.
             */
            get inactivityTimeout(): number;
            set inactivityTimeout(val: number);
            /**
             * Whether the application is currently marked as busy through
             * g_application_mark_busy() or g_application_bind_busy_property().
             */
            get is_busy(): boolean;
            /**
             * Whether the application is currently marked as busy through
             * g_application_mark_busy() or g_application_bind_busy_property().
             */
            get isBusy(): boolean;
            /**
             * Whether [method`Gio`.Application.register] has been called.
             */
            get is_registered(): boolean;
            /**
             * Whether [method`Gio`.Application.register] has been called.
             */
            get isRegistered(): boolean;
            /**
             * Whether this application instance is remote.
             */
            get is_remote(): boolean;
            /**
             * Whether this application instance is remote.
             */
            get isRemote(): boolean;
            /**
             * The base resource path for the application.
             */
            get resource_base_path(): string;
            set resource_base_path(val: string);
            /**
             * The base resource path for the application.
             */
            get resourceBasePath(): string;
            set resourceBasePath(val: string);
            /**
             * The human-readable version number of the application.
             */
            get version(): string;
            set version(val: string);

            // Constructors

            constructor(properties?: Partial<Application.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](application_id: string | null, flags: ApplicationFlags): Application;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'activate', callback: (_source: this) => void): number;
            connect_after(signal: 'activate', callback: (_source: this) => void): number;
            emit(signal: 'activate'): void;
            connect(
                signal: 'command-line',
                callback: (_source: this, command_line: ApplicationCommandLine) => number,
            ): number;
            connect_after(
                signal: 'command-line',
                callback: (_source: this, command_line: ApplicationCommandLine) => number,
            ): number;
            emit(signal: 'command-line', command_line: ApplicationCommandLine): void;
            connect(
                signal: 'handle-local-options',
                callback: (_source: this, options: GLib.VariantDict) => number,
            ): number;
            connect_after(
                signal: 'handle-local-options',
                callback: (_source: this, options: GLib.VariantDict) => number,
            ): number;
            emit(signal: 'handle-local-options', options: GLib.VariantDict): void;
            connect(signal: 'name-lost', callback: (_source: this) => boolean): number;
            connect_after(signal: 'name-lost', callback: (_source: this) => boolean): number;
            emit(signal: 'name-lost'): void;
            connect(signal: 'open', callback: (_source: this, files: File[], hint: string) => void): number;
            connect_after(signal: 'open', callback: (_source: this, files: File[], hint: string) => void): number;
            emit(signal: 'open', files: File[], hint: string): void;
            connect(signal: 'shutdown', callback: (_source: this) => void): number;
            connect_after(signal: 'shutdown', callback: (_source: this) => void): number;
            emit(signal: 'shutdown'): void;
            connect(signal: 'startup', callback: (_source: this) => void): number;
            connect_after(signal: 'startup', callback: (_source: this) => void): number;
            emit(signal: 'startup'): void;

            // Static methods

            /**
             * Returns the default #GApplication instance for this process.
             *
             * Normally there is only one #GApplication per process and it becomes
             * the default when it is created.  You can exercise more control over
             * this by using g_application_set_default().
             *
             * If there is no default application then %NULL is returned.
             */
            static get_default(): Application | null;
            /**
             * Checks if `application_id` is a valid application identifier.
             *
             * A valid ID is required for calls to g_application_new() and
             * g_application_set_application_id().
             *
             * Application identifiers follow the same format as
             * [D-Bus well-known bus names](https://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-names-bus).
             * For convenience, the restrictions on application identifiers are
             * reproduced here:
             *
             * - Application identifiers are composed of 1 or more elements separated by a
             *   period (`.`) character. All elements must contain at least one character.
             *
             * - Each element must only contain the ASCII characters `[A-Z][a-z][0-9]_-`,
             *   with `-` discouraged in new application identifiers. Each element must not
             *   begin with a digit.
             *
             * - Application identifiers must contain at least one `.` (period) character
             *   (and thus at least two elements).
             *
             * - Application identifiers must not begin with a `.` (period) character.
             *
             * - Application identifiers must not exceed 255 characters.
             *
             * Note that the hyphen (`-`) character is allowed in application identifiers,
             * but is problematic or not allowed in various specifications and APIs that
             * refer to D-Bus, such as
             * [Flatpak application IDs](http://docs.flatpak.org/en/latest/introduction.html#identifiers),
             * the
             * [`DBusActivatable` interface in the Desktop Entry Specification](https://specifications.freedesktop.org/desktop-entry-spec/desktop-entry-spec-latest.html#dbus),
             * and the convention that an application's "main" interface and object path
             * resemble its application identifier and bus name. To avoid situations that
             * require special-case handling, it is recommended that new application
             * identifiers consistently replace hyphens with underscores.
             *
             * Like D-Bus interface names, application identifiers should start with the
             * reversed DNS domain name of the author of the interface (in lower-case), and
             * it is conventional for the rest of the application identifier to consist of
             * words run together, with initial capital letters.
             *
             * As with D-Bus interface names, if the author's DNS domain name contains
             * hyphen/minus characters they should be replaced by underscores, and if it
             * contains leading digits they should be escaped by prepending an underscore.
             * For example, if the owner of 7-zip.org used an application identifier for an
             * archiving application, it might be named `org._7_zip.Archiver`.
             * @param application_id a potential application identifier
             */
            static id_is_valid(application_id: string): boolean;

            // Virtual methods

            /**
             * Activates the application.
             *
             * In essence, this results in the #GApplication::activate signal being
             * emitted in the primary instance.
             *
             * The application must be registered before calling this function.
             */
            vfunc_activate(): void;
            /**
             * invoked (locally) to add 'platform data' to be sent to
             *     the primary instance when activating, opening or invoking actions
             * @param builder
             */
            vfunc_add_platform_data(builder: GLib.VariantBuilder): void;
            /**
             * invoked on the primary instance after 'activate', 'open',
             *     'command-line' or any action invocation, gets the 'platform data' from
             *     the calling instance
             * @param platform_data
             */
            vfunc_after_emit(platform_data: GLib.Variant): void;
            /**
             * invoked on the primary instance before 'activate', 'open',
             *     'command-line' or any action invocation, gets the 'platform data' from
             *     the calling instance
             * @param platform_data
             */
            vfunc_before_emit(platform_data: GLib.Variant): void;
            /**
             * invoked on the primary instance when a command-line is
             *   not handled locally
             * @param command_line
             */
            vfunc_command_line(command_line: ApplicationCommandLine): number;
            /**
             * invoked locally during registration, if the application is
             *     using its D-Bus backend. You can use this to export extra objects on the
             *     bus, that need to exist before the application tries to own the bus name.
             *     The function is passed the #GDBusConnection to to session bus, and the
             *     object path that #GApplication will use to export its D-Bus API.
             *     If this function returns %TRUE, registration will proceed; otherwise
             *     registration will abort. Since: 2.34
             * @param connection
             * @param object_path
             */
            vfunc_dbus_register(connection: DBusConnection, object_path: string): boolean;
            /**
             * invoked locally during unregistration, if the application
             *     is using its D-Bus backend. Use this to undo anything done by
             *     the `dbus_register` vfunc. Since: 2.34
             * @param connection
             * @param object_path
             */
            vfunc_dbus_unregister(connection: DBusConnection, object_path: string): void;
            /**
             * invoked locally after the parsing of the commandline
             *  options has occurred. Since: 2.40
             * @param options
             */
            vfunc_handle_local_options(options: GLib.VariantDict): number;
            /**
             * This virtual function is always invoked in the local instance. It
             * gets passed a pointer to a %NULL-terminated copy of `argv` and is
             * expected to remove arguments that it handled (shifting up remaining
             * arguments).
             *
             * The last argument to local_command_line() is a pointer to the `status`
             * variable which can used to set the exit status that is returned from
             * g_application_run().
             *
             * See g_application_run() for more details on #GApplication startup.
             * @param _arguments array of command line arguments
             */
            vfunc_local_command_line(_arguments: string[]): [boolean, string[], number];
            /**
             * invoked when another instance is taking over the name. Since: 2.60
             */
            vfunc_name_lost(): boolean;
            /**
             * Opens the given files.
             *
             * In essence, this results in the #GApplication::open signal being emitted
             * in the primary instance.
             *
             * `n_files` must be greater than zero.
             *
             * `hint` is simply passed through to the ::open signal.  It is
             * intended to be used by applications that have multiple modes for
             * opening files (eg: "view" vs "edit", etc).  Unless you have a need
             * for this functionality, you should use "".
             *
             * The application must be registered before calling this function
             * and it must have the %G_APPLICATION_HANDLES_OPEN flag set.
             * @param files an array of #GFiles to open
             * @param hint a hint (or ""), but never %NULL
             */
            vfunc_open(files: File[], hint: string): void;
            /**
             * Used to be invoked on the primary instance when the use
             *     count of the application drops to zero (and after any inactivity
             *     timeout, if requested). Not used anymore since 2.32
             */
            vfunc_quit_mainloop(): void;
            /**
             * Used to be invoked on the primary instance from
             *     g_application_run() if the use-count is non-zero. Since 2.32,
             *     GApplication is iterating the main context directly and is not
             *     using `run_mainloop` anymore
             */
            vfunc_run_mainloop(): void;
            /**
             * invoked only on the registered primary instance immediately
             *      after the main loop terminates
             */
            vfunc_shutdown(): void;
            /**
             * invoked on the primary instance immediately after registration
             */
            vfunc_startup(): void;

            // Methods

            /**
             * Activates the application.
             *
             * In essence, this results in the #GApplication::activate signal being
             * emitted in the primary instance.
             *
             * The application must be registered before calling this function.
             */
            activate(): void;
            /**
             * Add an option to be handled by `application`.
             *
             * Calling this function is the equivalent of calling
             * g_application_add_main_option_entries() with a single #GOptionEntry
             * that has its arg_data member set to %NULL.
             *
             * The parsed arguments will be packed into a #GVariantDict which
             * is passed to #GApplication::handle-local-options. If
             * %G_APPLICATION_HANDLES_COMMAND_LINE is set, then it will also
             * be sent to the primary instance. See
             * g_application_add_main_option_entries() for more details.
             *
             * See #GOptionEntry for more documentation of the arguments.
             * @param long_name the long name of an option used to specify it in a commandline
             * @param short_name the short name of an option
             * @param flags flags from #GOptionFlags
             * @param arg the type of the option, as a #GOptionArg
             * @param description the description for the option in `--help` output
             * @param arg_description the placeholder to use for the extra argument    parsed by the option in `--help` output
             */
            add_main_option(
                long_name: string,
                short_name: number,
                flags: GLib.OptionFlags | null,
                arg: GLib.OptionArg | null,
                description: string,
                arg_description?: string | null,
            ): void;
            /**
             * Adds main option entries to be handled by `application`.
             *
             * This function is comparable to g_option_context_add_main_entries().
             *
             * After the commandline arguments are parsed, the
             * #GApplication::handle-local-options signal will be emitted.  At this
             * point, the application can inspect the values pointed to by `arg_data`
             * in the given #GOptionEntrys.
             *
             * Unlike #GOptionContext, #GApplication supports giving a %NULL
             * `arg_data` for a non-callback #GOptionEntry.  This results in the
             * argument in question being packed into a #GVariantDict which is also
             * passed to #GApplication::handle-local-options, where it can be
             * inspected and modified.  If %G_APPLICATION_HANDLES_COMMAND_LINE is
             * set, then the resulting dictionary is sent to the primary instance,
             * where g_application_command_line_get_options_dict() will return it.
             * As it has been passed outside the process at this point, the types of all
             * values in the options dict must be checked before being used.
             * This "packing" is done according to the type of the argument --
             * booleans for normal flags, strings for strings, bytestrings for
             * filenames, etc.  The packing only occurs if the flag is given (ie: we
             * do not pack a "false" #GVariant in the case that a flag is missing).
             *
             * In general, it is recommended that all commandline arguments are
             * parsed locally.  The options dictionary should then be used to
             * transmit the result of the parsing to the primary instance, where
             * g_variant_dict_lookup() can be used.  For local options, it is
             * possible to either use `arg_data` in the usual way, or to consult (and
             * potentially remove) the option from the options dictionary.
             *
             * This function is new in GLib 2.40.  Before then, the only real choice
             * was to send all of the commandline arguments (options and all) to the
             * primary instance for handling.  #GApplication ignored them completely
             * on the local side.  Calling this function "opts in" to the new
             * behaviour, and in particular, means that unrecognized options will be
             * treated as errors.  Unrecognized options have never been ignored when
             * %G_APPLICATION_HANDLES_COMMAND_LINE is unset.
             *
             * If #GApplication::handle-local-options needs to see the list of
             * filenames, then the use of %G_OPTION_REMAINING is recommended.  If
             * `arg_data` is %NULL then %G_OPTION_REMAINING can be used as a key into
             * the options dictionary.  If you do use %G_OPTION_REMAINING then you
             * need to handle these arguments for yourself because once they are
             * consumed, they will no longer be visible to the default handling
             * (which treats them as filenames to be opened).
             *
             * It is important to use the proper GVariant format when retrieving
             * the options with g_variant_dict_lookup():
             * - for %G_OPTION_ARG_NONE, use `b`
             * - for %G_OPTION_ARG_STRING, use `&s`
             * - for %G_OPTION_ARG_INT, use `i`
             * - for %G_OPTION_ARG_INT64, use `x`
             * - for %G_OPTION_ARG_DOUBLE, use `d`
             * - for %G_OPTION_ARG_FILENAME, use `^&ay`
             * - for %G_OPTION_ARG_STRING_ARRAY, use `^a&s`
             * - for %G_OPTION_ARG_FILENAME_ARRAY, use `^a&ay`
             * @param entries the   main options for the application
             */
            add_main_option_entries(entries: GLib.OptionEntry[]): void;
            /**
             * Adds a #GOptionGroup to the commandline handling of `application`.
             *
             * This function is comparable to g_option_context_add_group().
             *
             * Unlike g_application_add_main_option_entries(), this function does
             * not deal with %NULL `arg_data` and never transmits options to the
             * primary instance.
             *
             * The reason for that is because, by the time the options arrive at the
             * primary instance, it is typically too late to do anything with them.
             * Taking the GTK option group as an example: GTK will already have been
             * initialised by the time the #GApplication::command-line handler runs.
             * In the case that this is not the first-running instance of the
             * application, the existing instance may already have been running for
             * a very long time.
             *
             * This means that the options from #GOptionGroup are only really usable
             * in the case that the instance of the application being run is the
             * first instance.  Passing options like `--display=` or `--gdk-debug=`
             * on future runs will have no effect on the existing primary instance.
             *
             * Calling this function will cause the options in the supplied option
             * group to be parsed, but it does not cause you to be "opted in" to the
             * new functionality whereby unrecognized options are rejected even if
             * %G_APPLICATION_HANDLES_COMMAND_LINE was given.
             * @param group a #GOptionGroup
             */
            add_option_group(group: GLib.OptionGroup): void;
            /**
             * Marks `application` as busy (see g_application_mark_busy()) while
             * `property` on `object` is %TRUE.
             *
             * The binding holds a reference to `application` while it is active, but
             * not to `object`. Instead, the binding is destroyed when `object` is
             * finalized.
             * @param object a #GObject
             * @param property the name of a boolean property of @object
             */
            bind_busy_property(object: GObject.Object, property: string): void;
            /**
             * Gets the unique identifier for `application`.
             * @returns the identifier for @application, owned by @application
             */
            get_application_id(): string | null;
            /**
             * Gets the #GDBusConnection being used by the application, or %NULL.
             *
             * If #GApplication is using its D-Bus backend then this function will
             * return the #GDBusConnection being used for uniqueness and
             * communication with the desktop environment and other instances of the
             * application.
             *
             * If #GApplication is not using D-Bus then this function will return
             * %NULL.  This includes the situation where the D-Bus backend would
             * normally be in use but we were unable to connect to the bus.
             *
             * This function must not be called before the application has been
             * registered.  See g_application_get_is_registered().
             * @returns a #GDBusConnection, or %NULL
             */
            get_dbus_connection(): DBusConnection | null;
            /**
             * Gets the D-Bus object path being used by the application, or %NULL.
             *
             * If #GApplication is using its D-Bus backend then this function will
             * return the D-Bus object path that #GApplication is using.  If the
             * application is the primary instance then there is an object published
             * at this path.  If the application is not the primary instance then
             * the result of this function is undefined.
             *
             * If #GApplication is not using D-Bus then this function will return
             * %NULL.  This includes the situation where the D-Bus backend would
             * normally be in use but we were unable to connect to the bus.
             *
             * This function must not be called before the application has been
             * registered.  See g_application_get_is_registered().
             * @returns the object path, or %NULL
             */
            get_dbus_object_path(): string | null;
            /**
             * Gets the flags for `application`.
             *
             * See #GApplicationFlags.
             * @returns the flags for @application
             */
            get_flags(): ApplicationFlags;
            /**
             * Gets the current inactivity timeout for the application.
             *
             * This is the amount of time (in milliseconds) after the last call to
             * g_application_release() before the application stops running.
             * @returns the timeout, in milliseconds
             */
            get_inactivity_timeout(): number;
            /**
             * Gets the application's current busy state, as set through
             * g_application_mark_busy() or g_application_bind_busy_property().
             * @returns %TRUE if @application is currently marked as busy
             */
            get_is_busy(): boolean;
            /**
             * Checks if `application` is registered.
             *
             * An application is registered if g_application_register() has been
             * successfully called.
             * @returns %TRUE if @application is registered
             */
            get_is_registered(): boolean;
            /**
             * Checks if `application` is remote.
             *
             * If `application` is remote then it means that another instance of
             * application already exists (the 'primary' instance).  Calls to
             * perform actions on `application` will result in the actions being
             * performed by the primary instance.
             *
             * The value of this property cannot be accessed before
             * g_application_register() has been called.  See
             * g_application_get_is_registered().
             * @returns %TRUE if @application is remote
             */
            get_is_remote(): boolean;
            /**
             * Gets the resource base path of `application`.
             *
             * See g_application_set_resource_base_path() for more information.
             * @returns the base resource path, if one is set
             */
            get_resource_base_path(): string | null;
            /**
             * Gets the version of `application`.
             * @returns the version of @application
             */
            get_version(): string | null;
            /**
             * Increases the use count of `application`.
             *
             * Use this function to indicate that the application has a reason to
             * continue to run.  For example, g_application_hold() is called by GTK
             * when a toplevel window is on the screen.
             *
             * To cancel the hold, call g_application_release().
             */
            hold(): void;
            /**
             * Increases the busy count of `application`.
             *
             * Use this function to indicate that the application is busy, for instance
             * while a long running operation is pending.
             *
             * The busy state will be exposed to other processes, so a session shell will
             * use that information to indicate the state to the user (e.g. with a
             * spinner).
             *
             * To cancel the busy indication, use g_application_unmark_busy().
             *
             * The application must be registered before calling this function.
             */
            mark_busy(): void;
            /**
             * Opens the given files.
             *
             * In essence, this results in the #GApplication::open signal being emitted
             * in the primary instance.
             *
             * `n_files` must be greater than zero.
             *
             * `hint` is simply passed through to the ::open signal.  It is
             * intended to be used by applications that have multiple modes for
             * opening files (eg: "view" vs "edit", etc).  Unless you have a need
             * for this functionality, you should use "".
             *
             * The application must be registered before calling this function
             * and it must have the %G_APPLICATION_HANDLES_OPEN flag set.
             * @param files an array of #GFiles to open
             * @param hint a hint (or ""), but never %NULL
             */
            open(files: File[], hint: string): void;
            /**
             * Immediately quits the application.
             *
             * Upon return to the mainloop, g_application_run() will return,
             * calling only the 'shutdown' function before doing so.
             *
             * The hold count is ignored.
             * Take care if your code has called g_application_hold() on the application and
             * is therefore still expecting it to exist.
             * (Note that you may have called g_application_hold() indirectly, for example
             * through gtk_application_add_window().)
             *
             * The result of calling g_application_run() again after it returns is
             * unspecified.
             */
            quit(): void;
            /**
             * Attempts registration of the application.
             *
             * This is the point at which the application discovers if it is the
             * primary instance or merely acting as a remote for an already-existing
             * primary instance.  This is implemented by attempting to acquire the
             * application identifier as a unique bus name on the session bus using
             * GDBus.
             *
             * If there is no application ID or if %G_APPLICATION_NON_UNIQUE was
             * given, then this process will always become the primary instance.
             *
             * Due to the internal architecture of GDBus, method calls can be
             * dispatched at any time (even if a main loop is not running).  For
             * this reason, you must ensure that any object paths that you wish to
             * register are registered before calling this function.
             *
             * If the application has already been registered then %TRUE is
             * returned with no work performed.
             *
             * The #GApplication::startup signal is emitted if registration succeeds
             * and `application` is the primary instance (including the non-unique
             * case).
             *
             * In the event of an error (such as `cancellable` being cancelled, or a
             * failure to connect to the session bus), %FALSE is returned and `error`
             * is set appropriately.
             *
             * Note: the return value of this function is not an indicator that this
             * instance is or is not the primary instance of the application.  See
             * g_application_get_is_remote() for that.
             * @param cancellable a #GCancellable, or %NULL
             * @returns %TRUE if registration succeeded
             */
            register(cancellable?: Cancellable | null): boolean;
            /**
             * Decrease the use count of `application`.
             *
             * When the use count reaches zero, the application will stop running.
             *
             * Never call this function except to cancel the effect of a previous
             * call to g_application_hold().
             */
            release(): void;
            /**
             * Runs the application.
             *
             * This function is intended to be run from main() and its return value
             * is intended to be returned by main(). Although you are expected to pass
             * the `argc,` `argv` parameters from main() to this function, it is possible
             * to pass %NULL if `argv` is not available or commandline handling is not
             * required.  Note that on Windows, `argc` and `argv` are ignored, and
             * g_win32_get_command_line() is called internally (for proper support
             * of Unicode commandline arguments).
             *
             * #GApplication will attempt to parse the commandline arguments.  You
             * can add commandline flags to the list of recognised options by way of
             * g_application_add_main_option_entries().  After this, the
             * #GApplication::handle-local-options signal is emitted, from which the
             * application can inspect the values of its #GOptionEntrys.
             *
             * #GApplication::handle-local-options is a good place to handle options
             * such as `--version`, where an immediate reply from the local process is
             * desired (instead of communicating with an already-running instance).
             * A #GApplication::handle-local-options handler can stop further processing
             * by returning a non-negative value, which then becomes the exit status of
             * the process.
             *
             * What happens next depends on the flags: if
             * %G_APPLICATION_HANDLES_COMMAND_LINE was specified then the remaining
             * commandline arguments are sent to the primary instance, where a
             * #GApplication::command-line signal is emitted.  Otherwise, the
             * remaining commandline arguments are assumed to be a list of files.
             * If there are no files listed, the application is activated via the
             * #GApplication::activate signal.  If there are one or more files, and
             * %G_APPLICATION_HANDLES_OPEN was specified then the files are opened
             * via the #GApplication::open signal.
             *
             * If you are interested in doing more complicated local handling of the
             * commandline then you should implement your own #GApplication subclass
             * and override local_command_line(). In this case, you most likely want
             * to return %TRUE from your local_command_line() implementation to
             * suppress the default handling. See
             * [gapplication-example-cmdline2.c][https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gapplication-example-cmdline2.c]
             * for an example.
             *
             * If, after the above is done, the use count of the application is zero
             * then the exit status is returned immediately.  If the use count is
             * non-zero then the default main context is iterated until the use count
             * falls to zero, at which point 0 is returned.
             *
             * If the %G_APPLICATION_IS_SERVICE flag is set, then the service will
             * run for as much as 10 seconds with a use count of zero while waiting
             * for the message that caused the activation to arrive.  After that,
             * if the use count falls to zero the application will exit immediately,
             * except in the case that g_application_set_inactivity_timeout() is in
             * use.
             *
             * This function sets the prgname (g_set_prgname()), if not already set,
             * to the basename of argv[0].
             *
             * Much like g_main_loop_run(), this function will acquire the main context
             * for the duration that the application is running.
             *
             * Since 2.40, applications that are not explicitly flagged as services
             * or launchers (ie: neither %G_APPLICATION_IS_SERVICE or
             * %G_APPLICATION_IS_LAUNCHER are given as flags) will check (from the
             * default handler for local_command_line) if "--gapplication-service"
             * was given in the command line.  If this flag is present then normal
             * commandline processing is interrupted and the
             * %G_APPLICATION_IS_SERVICE flag is set.  This provides a "compromise"
             * solution whereby running an application directly from the commandline
             * will invoke it in the normal way (which can be useful for debugging)
             * while still allowing applications to be D-Bus activated in service
             * mode.  The D-Bus service file should invoke the executable with
             * "--gapplication-service" as the sole commandline argument.  This
             * approach is suitable for use by most graphical applications but
             * should not be used from applications like editors that need precise
             * control over when processes invoked via the commandline will exit and
             * what their exit status will be.
             * @param argv the argv from main(), or %NULL
             * @returns the exit status
             */
            run(argv?: string[] | null): number;
            /**
             * Sends a notification on behalf of `application` to the desktop shell.
             * There is no guarantee that the notification is displayed immediately,
             * or even at all.
             *
             * Notifications may persist after the application exits. It will be
             * D-Bus-activated when the notification or one of its actions is
             * activated.
             *
             * Modifying `notification` after this call has no effect. However, the
             * object can be reused for a later call to this function.
             *
             * `id` may be any string that uniquely identifies the event for the
             * application. It does not need to be in any special format. For
             * example, "new-message" might be appropriate for a notification about
             * new messages.
             *
             * If a previous notification was sent with the same `id,` it will be
             * replaced with `notification` and shown again as if it was a new
             * notification. This works even for notifications sent from a previous
             * execution of the application, as long as `id` is the same string.
             *
             * `id` may be `NULL`, but it is impossible to replace or withdraw
             * notifications without an id.
             *
             * If `notification` is no longer relevant, it can be withdrawn with
             * [method`Gio`.Application.withdraw_notification].
             *
             * It is an error to call this function if `application` has no
             * application ID.
             * @param id id of the notification, or %NULL
             * @param notification the #GNotification to send
             */
            send_notification(id: string | null, notification: Notification): void;
            /**
             * This used to be how actions were associated with a #GApplication.
             * Now there is #GActionMap for that.
             * @param action_group a #GActionGroup, or %NULL
             */
            set_action_group(action_group?: ActionGroup | null): void;
            /**
             * Sets the unique identifier for `application`.
             *
             * The application id can only be modified if `application` has not yet
             * been registered.
             *
             * If non-%NULL, the application id must be valid.  See
             * g_application_id_is_valid().
             * @param application_id the identifier for @application
             */
            set_application_id(application_id?: string | null): void;
            /**
             * Sets or unsets the default application for the process, as returned
             * by g_application_get_default().
             *
             * This function does not take its own reference on `application`.  If
             * `application` is destroyed then the default application will revert
             * back to %NULL.
             */
            set_default(): void;
            /**
             * Sets the flags for `application`.
             *
             * The flags can only be modified if `application` has not yet been
             * registered.
             *
             * See #GApplicationFlags.
             * @param flags the flags for @application
             */
            set_flags(flags: ApplicationFlags | null): void;
            /**
             * Sets the current inactivity timeout for the application.
             *
             * This is the amount of time (in milliseconds) after the last call to
             * g_application_release() before the application stops running.
             *
             * This call has no side effects of its own.  The value set here is only
             * used for next time g_application_release() drops the use count to
             * zero.  Any timeouts currently in progress are not impacted.
             * @param inactivity_timeout the timeout, in milliseconds
             */
            set_inactivity_timeout(inactivity_timeout: number): void;
            /**
             * Adds a description to the `application` option context.
             *
             * See g_option_context_set_description() for more information.
             * @param description a string to be shown in `--help` output  after the list of options, or %NULL
             */
            set_option_context_description(description?: string | null): void;
            /**
             * Sets the parameter string to be used by the commandline handling of `application`.
             *
             * This function registers the argument to be passed to g_option_context_new()
             * when the internal #GOptionContext of `application` is created.
             *
             * See g_option_context_new() for more information about `parameter_string`.
             * @param parameter_string a string which is displayed   in the first line of `--help` output, after the usage summary `programname [OPTION...]`.
             */
            set_option_context_parameter_string(parameter_string?: string | null): void;
            /**
             * Adds a summary to the `application` option context.
             *
             * See g_option_context_set_summary() for more information.
             * @param summary a string to be shown in `--help` output  before the list of options, or %NULL
             */
            set_option_context_summary(summary?: string | null): void;
            /**
             * Sets (or unsets) the base resource path of `application`.
             *
             * The path is used to automatically load various
             * [application resources][struct`Gio`.Resource] such as menu layouts and
             * action descriptions. The various types of resources will be found at
             * fixed names relative to the given base path.
             *
             * By default, the resource base path is determined from the application
             * ID by prefixing '/' and replacing each '.' with '/'.  This is done at
             * the time that the #GApplication object is constructed.  Changes to
             * the application ID after that point will not have an impact on the
             * resource base path.
             *
             * As an example, if the application has an ID of "org.example.app" then
             * the default resource base path will be "/org/example/app".  If this
             * is a #GtkApplication (and you have not manually changed the path)
             * then Gtk will then search for the menus of the application at
             * "/org/example/app/gtk/menus.ui".
             *
             * See #GResource for more information about adding resources to your
             * application.
             *
             * You can disable automatic resource loading functionality by setting
             * the path to %NULL.
             *
             * Changing the resource base path once the application is running is
             * not recommended.  The point at which the resource path is consulted
             * for forming paths for various purposes is unspecified.  When writing
             * a sub-class of #GApplication you should either set the
             * #GApplication:resource-base-path property at construction time, or call
             * this function during the instance initialization. Alternatively, you
             * can call this function in the #GApplicationClass.startup virtual function,
             * before chaining up to the parent implementation.
             * @param resource_path the resource path to use
             */
            set_resource_base_path(resource_path?: string | null): void;
            /**
             * Sets the version number of `application`. This will be used to implement
             * a `--version` command line argument
             *
             * The application version can only be modified if `application` has not yet
             * been registered.
             * @param version the version of @application
             */
            set_version(version: string): void;
            /**
             * Destroys a binding between `property` and the busy state of
             * `application` that was previously created with
             * g_application_bind_busy_property().
             * @param object a #GObject
             * @param property the name of a boolean property of @object
             */
            unbind_busy_property(object: GObject.Object, property: string): void;
            /**
             * Decreases the busy count of `application`.
             *
             * When the busy count reaches zero, the new state will be propagated
             * to other processes.
             *
             * This function must only be called to cancel the effect of a previous
             * call to g_application_mark_busy().
             */
            unmark_busy(): void;
            /**
             * Withdraws a notification that was sent with
             * g_application_send_notification().
             *
             * This call does nothing if a notification with `id` doesn't exist or
             * the notification was never sent.
             *
             * This function works even for notifications sent in previous
             * executions of this application, as long `id` is the same as it was for
             * the sent notification.
             *
             * Note that notifications are dismissed when the user clicks on one
             * of the buttons in a notification or triggers its default action, so
             * there is no need to explicitly withdraw the notification in that case.
             * @param id id of a previously sent notification
             */
            withdraw_notification(id: string): void;
            /**
             * Similar to `Gio.Application.run` but return a Promise which resolves when the main loop ends, instead of blocking while the main loop runs.
             * This helps avoid the situation where Promises never resolved if you didn't run the application inside a callback.
             * @param argv Commandline arguments
             */
            runAsync(argv?: string[]): Promise<number>;

            // Inherited methods
            /**
             * Emits the [signal`Gio`.ActionGroup::action-added] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             */
            action_added(action_name: string): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-enabled-changed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             * @param enabled whether the action is now enabled
             */
            action_enabled_changed(action_name: string, enabled: boolean): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-removed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             */
            action_removed(action_name: string): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-state-changed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             * @param state the new state of the named action
             */
            action_state_changed(action_name: string, state: GLib.Variant): void;
            /**
             * Activate the named action within `action_group`.
             *
             * If the action is expecting a parameter, then the correct type of
             * parameter must be given as `parameter`.  If the action is expecting no
             * parameters then `parameter` must be `NULL`.  See
             * [method`Gio`.ActionGroup.get_action_parameter_type].
             *
             * If the [type`Gio`.ActionGroup] implementation supports asynchronous remote
             * activation over D-Bus, this call may return before the relevant
             * D-Bus traffic has been sent, or any replies have been received. In
             * order to block on such asynchronous activation calls,
             * [method`Gio`.DBusConnection.flush] should be called prior to the code, which
             * depends on the result of the action activation. Without flushing
             * the D-Bus connection, there is no guarantee that the action would
             * have been activated.
             *
             * The following code which runs in a remote app instance, shows an
             * example of a ‘quit’ action being activated on the primary app
             * instance over D-Bus. Here [method`Gio`.DBusConnection.flush] is called
             * before `exit()`. Without `g_dbus_connection_flush()`, the ‘quit’ action
             * may fail to be activated on the primary instance.
             *
             * ```c
             * // call ‘quit’ action on primary instance
             * g_action_group_activate_action (G_ACTION_GROUP (app), "quit", NULL);
             *
             * // make sure the action is activated now
             * g_dbus_connection_flush (…);
             *
             * g_debug ("Application has been terminated. Exiting.");
             *
             * exit (0);
             * ```
             * @param action_name the name of the action to activate
             * @param parameter parameters to the activation
             */
            activate_action(action_name: string, parameter?: GLib.Variant | null): void;
            /**
             * Request for the state of the named action within `action_group` to be
             * changed to `value`.
             *
             * The action must be stateful and `value` must be of the correct type.
             * See [method`Gio`.ActionGroup.get_action_state_type].
             *
             * This call merely requests a change.  The action may refuse to change
             * its state or may change its state to something other than `value`.
             * See [method`Gio`.ActionGroup.get_action_state_hint].
             *
             * If the `value` GVariant is floating, it is consumed.
             * @param action_name the name of the action to request the change on
             * @param value the new state
             */
            change_action_state(action_name: string, value: GLib.Variant): void;
            /**
             * Checks if the named action within `action_group` is currently enabled.
             *
             * An action must be enabled in order to be activated or in order to
             * have its state changed from outside callers.
             * @param action_name the name of the action to query
             * @returns whether the action is currently enabled
             */
            get_action_enabled(action_name: string): boolean;
            /**
             * Queries the type of the parameter that must be given when activating
             * the named action within `action_group`.
             *
             * When activating the action using [method`Gio`.ActionGroup.activate_action],
             * the [type`GLib`.Variant] given to that function must be of the type returned
             * by this function.
             *
             * In the case that this function returns `NULL`, you must not give any
             * [type`GLib`.Variant], but `NULL` instead.
             *
             * The parameter type of a particular action will never change but it is
             * possible for an action to be removed and for a new action to be added
             * with the same name but a different parameter type.
             * @param action_name the name of the action to query
             * @returns the parameter type
             */
            get_action_parameter_type(action_name: string): GLib.VariantType | null;
            /**
             * Queries the current state of the named action within `action_group`.
             *
             * If the action is not stateful then `NULL` will be returned.  If the
             * action is stateful then the type of the return value is the type
             * given by [method`Gio`.ActionGroup.get_action_state_type].
             *
             * The return value (if non-`NULL`) should be freed with
             * [method`GLib`.Variant.unref] when it is no longer required.
             * @param action_name the name of the action to query
             * @returns the current state of the action
             */
            get_action_state(action_name: string): GLib.Variant | null;
            /**
             * Requests a hint about the valid range of values for the state of the
             * named action within `action_group`.
             *
             * If `NULL` is returned it either means that the action is not stateful
             * or that there is no hint about the valid range of values for the
             * state of the action.
             *
             * If a [type`GLib`.Variant] array is returned then each item in the array is a
             * possible value for the state.  If a [type`GLib`.Variant] pair (ie: two-tuple) is
             * returned then the tuple specifies the inclusive lower and upper bound
             * of valid values for the state.
             *
             * In any case, the information is merely a hint.  It may be possible to
             * have a state value outside of the hinted range and setting a value
             * within the range may fail.
             *
             * The return value (if non-`NULL`) should be freed with
             * [method`GLib`.Variant.unref] when it is no longer required.
             * @param action_name the name of the action to query
             * @returns the state range hint
             */
            get_action_state_hint(action_name: string): GLib.Variant | null;
            /**
             * Queries the type of the state of the named action within
             * `action_group`.
             *
             * If the action is stateful then this function returns the
             * [type`GLib`.VariantType] of the state.  All calls to
             * [method`Gio`.ActionGroup.change_action_state] must give a [type`GLib`.Variant] of this
             * type and [method`Gio`.ActionGroup.get_action_state] will return a [type`GLib`.Variant]
             * of the same type.
             *
             * If the action is not stateful then this function will return `NULL`.
             * In that case, [method`Gio`.ActionGroup.get_action_state] will return `NULL`
             * and you must not call [method`Gio`.ActionGroup.change_action_state].
             *
             * The state type of a particular action will never change but it is
             * possible for an action to be removed and for a new action to be added
             * with the same name but a different state type.
             * @param action_name the name of the action to query
             * @returns the state type, if the action is stateful
             */
            get_action_state_type(action_name: string): GLib.VariantType | null;
            /**
             * Checks if the named action exists within `action_group`.
             * @param action_name the name of the action to check for
             * @returns whether the named action exists
             */
            has_action(action_name: string): boolean;
            /**
             * Lists the actions contained within `action_group`.
             *
             * The caller is responsible for freeing the list with [func`GLib`.strfreev] when
             * it is no longer required.
             * @returns a `NULL`-terminated array   of the names of the actions in the group
             */
            list_actions(): string[];
            /**
             * Queries all aspects of the named action within an `action_group`.
             *
             * This function acquires the information available from
             * [method`Gio`.ActionGroup.has_action], [method`Gio`.ActionGroup.get_action_enabled],
             * [method`Gio`.ActionGroup.get_action_parameter_type],
             * [method`Gio`.ActionGroup.get_action_state_type],
             * [method`Gio`.ActionGroup.get_action_state_hint] and
             * [method`Gio`.ActionGroup.get_action_state] with a single function call.
             *
             * This provides two main benefits.
             *
             * The first is the improvement in efficiency that comes with not having
             * to perform repeated lookups of the action in order to discover
             * different things about it.  The second is that implementing
             * [type`Gio`.ActionGroup] can now be done by only overriding this one virtual
             * function.
             *
             * The interface provides a default implementation of this function that
             * calls the individual functions, as required, to fetch the
             * information.  The interface also provides default implementations of
             * those functions that call this function.  All implementations,
             * therefore, must override either this function or all of the others.
             *
             * If the action exists, `TRUE` is returned and any of the requested
             * fields (as indicated by having a non-`NULL` reference passed in) are
             * filled.  If the action doesn’t exist, `FALSE` is returned and the
             * fields may or may not have been modified.
             * @param action_name the name of an action in the group
             * @returns `TRUE` if the action exists, else `FALSE`
             */
            query_action(
                action_name: string,
            ): [
                boolean,
                boolean,
                GLib.VariantType | null,
                GLib.VariantType | null,
                GLib.Variant | null,
                GLib.Variant | null,
            ];
            /**
             * Emits the [signal`Gio`.ActionGroup::action-added] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             */
            vfunc_action_added(action_name: string): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-enabled-changed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             * @param enabled whether the action is now enabled
             */
            vfunc_action_enabled_changed(action_name: string, enabled: boolean): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-removed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             */
            vfunc_action_removed(action_name: string): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-state-changed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             * @param state the new state of the named action
             */
            vfunc_action_state_changed(action_name: string, state: GLib.Variant): void;
            /**
             * Activate the named action within `action_group`.
             *
             * If the action is expecting a parameter, then the correct type of
             * parameter must be given as `parameter`.  If the action is expecting no
             * parameters then `parameter` must be `NULL`.  See
             * [method`Gio`.ActionGroup.get_action_parameter_type].
             *
             * If the [type`Gio`.ActionGroup] implementation supports asynchronous remote
             * activation over D-Bus, this call may return before the relevant
             * D-Bus traffic has been sent, or any replies have been received. In
             * order to block on such asynchronous activation calls,
             * [method`Gio`.DBusConnection.flush] should be called prior to the code, which
             * depends on the result of the action activation. Without flushing
             * the D-Bus connection, there is no guarantee that the action would
             * have been activated.
             *
             * The following code which runs in a remote app instance, shows an
             * example of a ‘quit’ action being activated on the primary app
             * instance over D-Bus. Here [method`Gio`.DBusConnection.flush] is called
             * before `exit()`. Without `g_dbus_connection_flush()`, the ‘quit’ action
             * may fail to be activated on the primary instance.
             *
             * ```c
             * // call ‘quit’ action on primary instance
             * g_action_group_activate_action (G_ACTION_GROUP (app), "quit", NULL);
             *
             * // make sure the action is activated now
             * g_dbus_connection_flush (…);
             *
             * g_debug ("Application has been terminated. Exiting.");
             *
             * exit (0);
             * ```
             * @param action_name the name of the action to activate
             * @param parameter parameters to the activation
             */
            vfunc_activate_action(action_name: string, parameter?: GLib.Variant | null): void;
            /**
             * Request for the state of the named action within `action_group` to be
             * changed to `value`.
             *
             * The action must be stateful and `value` must be of the correct type.
             * See [method`Gio`.ActionGroup.get_action_state_type].
             *
             * This call merely requests a change.  The action may refuse to change
             * its state or may change its state to something other than `value`.
             * See [method`Gio`.ActionGroup.get_action_state_hint].
             *
             * If the `value` GVariant is floating, it is consumed.
             * @param action_name the name of the action to request the change on
             * @param value the new state
             */
            vfunc_change_action_state(action_name: string, value: GLib.Variant): void;
            /**
             * Checks if the named action within `action_group` is currently enabled.
             *
             * An action must be enabled in order to be activated or in order to
             * have its state changed from outside callers.
             * @param action_name the name of the action to query
             */
            vfunc_get_action_enabled(action_name: string): boolean;
            /**
             * Queries the type of the parameter that must be given when activating
             * the named action within `action_group`.
             *
             * When activating the action using [method`Gio`.ActionGroup.activate_action],
             * the [type`GLib`.Variant] given to that function must be of the type returned
             * by this function.
             *
             * In the case that this function returns `NULL`, you must not give any
             * [type`GLib`.Variant], but `NULL` instead.
             *
             * The parameter type of a particular action will never change but it is
             * possible for an action to be removed and for a new action to be added
             * with the same name but a different parameter type.
             * @param action_name the name of the action to query
             */
            vfunc_get_action_parameter_type(action_name: string): GLib.VariantType | null;
            /**
             * Queries the current state of the named action within `action_group`.
             *
             * If the action is not stateful then `NULL` will be returned.  If the
             * action is stateful then the type of the return value is the type
             * given by [method`Gio`.ActionGroup.get_action_state_type].
             *
             * The return value (if non-`NULL`) should be freed with
             * [method`GLib`.Variant.unref] when it is no longer required.
             * @param action_name the name of the action to query
             */
            vfunc_get_action_state(action_name: string): GLib.Variant | null;
            /**
             * Requests a hint about the valid range of values for the state of the
             * named action within `action_group`.
             *
             * If `NULL` is returned it either means that the action is not stateful
             * or that there is no hint about the valid range of values for the
             * state of the action.
             *
             * If a [type`GLib`.Variant] array is returned then each item in the array is a
             * possible value for the state.  If a [type`GLib`.Variant] pair (ie: two-tuple) is
             * returned then the tuple specifies the inclusive lower and upper bound
             * of valid values for the state.
             *
             * In any case, the information is merely a hint.  It may be possible to
             * have a state value outside of the hinted range and setting a value
             * within the range may fail.
             *
             * The return value (if non-`NULL`) should be freed with
             * [method`GLib`.Variant.unref] when it is no longer required.
             * @param action_name the name of the action to query
             */
            vfunc_get_action_state_hint(action_name: string): GLib.Variant | null;
            /**
             * Queries the type of the state of the named action within
             * `action_group`.
             *
             * If the action is stateful then this function returns the
             * [type`GLib`.VariantType] of the state.  All calls to
             * [method`Gio`.ActionGroup.change_action_state] must give a [type`GLib`.Variant] of this
             * type and [method`Gio`.ActionGroup.get_action_state] will return a [type`GLib`.Variant]
             * of the same type.
             *
             * If the action is not stateful then this function will return `NULL`.
             * In that case, [method`Gio`.ActionGroup.get_action_state] will return `NULL`
             * and you must not call [method`Gio`.ActionGroup.change_action_state].
             *
             * The state type of a particular action will never change but it is
             * possible for an action to be removed and for a new action to be added
             * with the same name but a different state type.
             * @param action_name the name of the action to query
             */
            vfunc_get_action_state_type(action_name: string): GLib.VariantType | null;
            /**
             * Checks if the named action exists within `action_group`.
             * @param action_name the name of the action to check for
             */
            vfunc_has_action(action_name: string): boolean;
            /**
             * Lists the actions contained within `action_group`.
             *
             * The caller is responsible for freeing the list with [func`GLib`.strfreev] when
             * it is no longer required.
             */
            vfunc_list_actions(): string[];
            /**
             * Queries all aspects of the named action within an `action_group`.
             *
             * This function acquires the information available from
             * [method`Gio`.ActionGroup.has_action], [method`Gio`.ActionGroup.get_action_enabled],
             * [method`Gio`.ActionGroup.get_action_parameter_type],
             * [method`Gio`.ActionGroup.get_action_state_type],
             * [method`Gio`.ActionGroup.get_action_state_hint] and
             * [method`Gio`.ActionGroup.get_action_state] with a single function call.
             *
             * This provides two main benefits.
             *
             * The first is the improvement in efficiency that comes with not having
             * to perform repeated lookups of the action in order to discover
             * different things about it.  The second is that implementing
             * [type`Gio`.ActionGroup] can now be done by only overriding this one virtual
             * function.
             *
             * The interface provides a default implementation of this function that
             * calls the individual functions, as required, to fetch the
             * information.  The interface also provides default implementations of
             * those functions that call this function.  All implementations,
             * therefore, must override either this function or all of the others.
             *
             * If the action exists, `TRUE` is returned and any of the requested
             * fields (as indicated by having a non-`NULL` reference passed in) are
             * filled.  If the action doesn’t exist, `FALSE` is returned and the
             * fields may or may not have been modified.
             * @param action_name the name of an action in the group
             */
            vfunc_query_action(
                action_name: string,
            ): [
                boolean,
                boolean,
                GLib.VariantType | null,
                GLib.VariantType | null,
                GLib.Variant | null,
                GLib.Variant | null,
            ];
            /**
             * Adds an action to the `action_map`.
             *
             * If the action map already contains an action with the same name
             * as `action` then the old action is dropped from the action map.
             *
             * The action map takes its own reference on `action`.
             * @param action a [iface@Gio.Action]
             */
            add_action(action: Action): void;
            /**
             * A convenience function for creating multiple simple actions.
             * See Gio.ActionEntryObj for the structure of the action entry.
             * @param entries Array of action entries to add
             */
            add_action_entries(entries: ActionEntryObj[]): void;
            /**
             * Looks up the action with the name `action_name` in `action_map`.
             *
             * If no such action exists, returns `NULL`.
             * @param action_name the name of an action
             * @returns a [iface@Gio.Action]
             */
            lookup_action(action_name: string): Action | null;
            /**
             * Removes the named action from the action map.
             *
             * If no action of this name is in the map then nothing happens.
             * @param action_name the name of the action
             */
            remove_action(action_name: string): void;
            /**
             * Remove actions from a [iface`Gio`.ActionMap]. This is meant as the reverse of
             * [method`Gio`.ActionMap.add_action_entries].
             *
             *
             * ```c
             * static const GActionEntry entries[] = {
             *     { "quit",         activate_quit              },
             *     { "print-string", activate_print_string, "s" }
             * };
             *
             * void
             * add_actions (GActionMap *map)
             * {
             *   g_action_map_add_action_entries (map, entries, G_N_ELEMENTS (entries), NULL);
             * }
             *
             * void
             * remove_actions (GActionMap *map)
             * {
             *   g_action_map_remove_action_entries (map, entries, G_N_ELEMENTS (entries));
             * }
             * ```
             * @param entries a pointer to   the first item in an array of [struct@Gio.ActionEntry] structs
             */
            remove_action_entries(entries: ActionEntry[]): void;
            /**
             * Adds an action to the `action_map`.
             *
             * If the action map already contains an action with the same name
             * as `action` then the old action is dropped from the action map.
             *
             * The action map takes its own reference on `action`.
             * @param action a [iface@Gio.Action]
             */
            vfunc_add_action(action: Action): void;
            /**
             * Looks up the action with the name `action_name` in `action_map`.
             *
             * If no such action exists, returns `NULL`.
             * @param action_name the name of an action
             */
            vfunc_lookup_action(action_name: string): Action | null;
            /**
             * Removes the named action from the action map.
             *
             * If no action of this name is in the map then nothing happens.
             * @param action_name the name of the action
             */
            vfunc_remove_action(action_name: string): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace ApplicationCommandLine {
            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps {
                arguments: GLib.Variant;
                is_remote: boolean;
                isRemote: boolean;
                options: GLib.Variant;
                platform_data: GLib.Variant;
                platformData: GLib.Variant;
            }
        }

        /**
         * `GApplicationCommandLine` represents a command-line invocation of
         * an application.
         *
         * It is created by [class`Gio`.Application] and emitted
         * in the [signal`Gio`.Application::command-line] signal and virtual function.
         *
         * The class contains the list of arguments that the program was invoked
         * with. It is also possible to query if the commandline invocation was
         * local (ie: the current process is running in direct response to the
         * invocation) or remote (ie: some other process forwarded the
         * commandline to this process).
         *
         * The `GApplicationCommandLine` object can provide the `argc` and `argv`
         * parameters for use with the [struct`GLib`.OptionContext] command-line parsing API,
         * with the [method`Gio`.ApplicationCommandLine.get_arguments] function. See
         * [gapplication-example-cmdline3.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gapplication-example-cmdline3.c)
         * for an example.
         *
         * The exit status of the originally-invoked process may be set and
         * messages can be printed to stdout or stderr of that process.
         *
         * For remote invocation, the originally-invoked process exits when
         * [method`Gio`.ApplicationCommandLine.done] method is called. This method is
         * also automatically called when the object is disposed.
         *
         * The main use for `GApplicationCommandLine` (and the
         * [signal`Gio`.Application::command-line] signal) is 'Emacs server' like use cases:
         * You can set the `EDITOR` environment variable to have e.g. git use
         * your favourite editor to edit commit messages, and if you already
         * have an instance of the editor running, the editing will happen
         * in the running instance, instead of opening a new one. An important
         * aspect of this use case is that the process that gets started by git
         * does not return until the editing is done.
         *
         * Normally, the commandline is completely handled in the
         * [signal`Gio`.Application::command-line] handler. The launching instance exits
         * once the signal handler in the primary instance has returned, and
         * the return value of the signal handler becomes the exit status
         * of the launching instance.
         *
         * ```c
         * static int
         * command_line (GApplication            *application,
         *               GApplicationCommandLine *cmdline)
         * {
         *   gchar **argv;
         *   gint argc;
         *   gint i;
         *
         *   argv = g_application_command_line_get_arguments (cmdline, &argc);
         *
         *   g_application_command_line_print (cmdline,
         *                                     "This text is written back\n"
         *                                     "to stdout of the caller\n");
         *
         *   for (i = 0; i < argc; i++)
         *     g_print ("argument %d: %s\n", i, argv[i]);
         *
         *   g_strfreev (argv);
         *
         *   return 0;
         * }
         * ```
         *
         * The complete example can be found here:
         * [gapplication-example-cmdline.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gapplication-example-cmdline.c)
         *
         * In more complicated cases, the handling of the commandline can be
         * split between the launcher and the primary instance.
         *
         * ```c
         * static gboolean
         *  test_local_cmdline (GApplication   *application,
         *                      gchar        ***arguments,
         *                      gint           *exit_status)
         * {
         *   gint i, j;
         *   gchar **argv;
         *
         *   argv = *arguments;
         *
         *   if (argv[0] == NULL)
         *     {
         *       *exit_status = 0;
         *       return FALSE;
         *     }
         *
         *   i = 1;
         *   while (argv[i])
         *     {
         *       if (g_str_has_prefix (argv[i], "--local-"))
         *         {
         *           g_print ("handling argument %s locally\n", argv[i]);
         *           g_free (argv[i]);
         *           for (j = i; argv[j]; j++)
         *             argv[j] = argv[j + 1];
         *         }
         *       else
         *         {
         *           g_print ("not handling argument %s locally\n", argv[i]);
         *           i++;
         *         }
         *     }
         *
         *   *exit_status = 0;
         *
         *   return FALSE;
         * }
         *
         * static void
         * test_application_class_init (TestApplicationClass *class)
         * {
         *   G_APPLICATION_CLASS (class)->local_command_line = test_local_cmdline;
         *
         *   ...
         * }
         * ```
         *
         * In this example of split commandline handling, options that start
         * with `--local-` are handled locally, all other options are passed
         * to the [signal`Gio`.Application::command-line] handler which runs in the primary
         * instance.
         *
         * The complete example can be found here:
         * [gapplication-example-cmdline2.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gapplication-example-cmdline2.c)
         *
         * If handling the commandline requires a lot of work, it may be better to defer it.
         *
         * ```c
         * static gboolean
         * my_cmdline_handler (gpointer data)
         * {
         *   GApplicationCommandLine *cmdline = data;
         *
         *   // do the heavy lifting in an idle
         *
         *   g_application_command_line_set_exit_status (cmdline, 0);
         *   g_object_unref (cmdline); // this releases the application
         *
         *   return G_SOURCE_REMOVE;
         * }
         *
         * static int
         * command_line (GApplication            *application,
         *               GApplicationCommandLine *cmdline)
         * {
         *   // keep the application running until we are done with this commandline
         *   g_application_hold (application);
         *
         *   g_object_set_data_full (G_OBJECT (cmdline),
         *                           "application", application,
         *                           (GDestroyNotify)g_application_release);
         *
         *   g_object_ref (cmdline);
         *   g_idle_add (my_cmdline_handler, cmdline);
         *
         *   return 0;
         * }
         * ```
         *
         * In this example the commandline is not completely handled before
         * the [signal`Gio`.Application::command-line] handler returns. Instead, we keep
         * a reference to the `GApplicationCommandLine` object and handle it
         * later (in this example, in an idle). Note that it is necessary to
         * hold the application until you are done with the commandline.
         *
         * The complete example can be found here:
         * [gapplication-example-cmdline3.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gapplication-example-cmdline3.c)
         */
        class ApplicationCommandLine extends GObject.Object {
            static $gtype: GObject.GType<ApplicationCommandLine>;

            // Properties

            /**
             * The commandline that caused this [signal`Gio`.Application::command-line]
             * signal emission.
             */
            set arguments(val: GLib.Variant);
            /**
             * Whether this is a remote commandline.
             */
            get is_remote(): boolean;
            /**
             * Whether this is a remote commandline.
             */
            get isRemote(): boolean;
            /**
             * The options sent along with the commandline.
             */
            set options(val: GLib.Variant);
            /**
             * Platform-specific data for the commandline.
             */
            set platform_data(val: GLib.Variant);
            /**
             * Platform-specific data for the commandline.
             */
            set platformData(val: GLib.Variant);

            // Constructors

            constructor(properties?: Partial<ApplicationCommandLine.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            // Virtual methods

            /**
             * Signals that command line processing is completed.
             *
             * For remote invocation, it causes the invoking process to terminate.
             *
             * For local invocation, it does nothing.
             *
             * This method should be called in the [signal`Gio`.Application::command-line]
             * handler, after the exit status is set and all messages are printed.
             *
             * After this call, g_application_command_line_set_exit_status() has no effect.
             * Subsequent calls to this method are no-ops.
             *
             * This method is automatically called when the #GApplicationCommandLine
             * object is disposed — so you can omit the call in non-garbage collected
             * languages.
             */
            vfunc_done(): void;
            /**
             * Gets the stdin of the invoking process.
             *
             * The #GInputStream can be used to read data passed to the standard
             * input of the invoking process.
             * This doesn't work on all platforms.  Presently, it is only available
             * on UNIX when using a D-Bus daemon capable of passing file descriptors.
             * If stdin is not available then %NULL will be returned.  In the
             * future, support may be expanded to other platforms.
             *
             * You must only call this function once per commandline invocation.
             */
            vfunc_get_stdin(): InputStream | null;
            /**
             * Prints a message using the stdout print handler in the invoking process.
             *
             * Unlike g_application_command_line_print(), `message` is not a `printf()`-style
             * format string. Use this function if `message` contains text you don't have
             * control over, that could include `printf()` escape sequences.
             * @param message the message
             */
            vfunc_print_literal(message: string): void;
            /**
             * Prints a message using the stderr print handler in the invoking process.
             *
             * Unlike g_application_command_line_printerr(), `message` is not
             * a `printf()`-style format string. Use this function if `message` contains text
             * you don't have control over, that could include `printf()` escape sequences.
             * @param message the message
             */
            vfunc_printerr_literal(message: string): void;

            // Methods

            /**
             * Creates a #GFile corresponding to a filename that was given as part
             * of the invocation of `cmdline`.
             *
             * This differs from g_file_new_for_commandline_arg() in that it
             * resolves relative pathnames using the current working directory of
             * the invoking process rather than the local process.
             * @param arg an argument from @cmdline
             * @returns a new #GFile
             */
            create_file_for_arg(arg: string): File;
            /**
             * Signals that command line processing is completed.
             *
             * For remote invocation, it causes the invoking process to terminate.
             *
             * For local invocation, it does nothing.
             *
             * This method should be called in the [signal`Gio`.Application::command-line]
             * handler, after the exit status is set and all messages are printed.
             *
             * After this call, g_application_command_line_set_exit_status() has no effect.
             * Subsequent calls to this method are no-ops.
             *
             * This method is automatically called when the #GApplicationCommandLine
             * object is disposed — so you can omit the call in non-garbage collected
             * languages.
             */
            done(): void;
            /**
             * Gets the list of arguments that was passed on the command line.
             *
             * The strings in the array may contain non-UTF-8 data on UNIX (such as
             * filenames or arguments given in the system locale) but are always in
             * UTF-8 on Windows.
             *
             * If you wish to use the return value with #GOptionContext, you must
             * use g_option_context_parse_strv().
             *
             * The return value is %NULL-terminated and should be freed using
             * g_strfreev().
             * @returns the string array containing the arguments (the argv)
             */
            get_arguments(): string[];
            /**
             * Gets the working directory of the command line invocation.
             * The string may contain non-utf8 data.
             *
             * It is possible that the remote application did not send a working
             * directory, so this may be %NULL.
             *
             * The return value should not be modified or freed and is valid for as
             * long as `cmdline` exists.
             * @returns the current directory, or %NULL
             */
            get_cwd(): string | null;
            /**
             * Gets the contents of the 'environ' variable of the command line
             * invocation, as would be returned by g_get_environ(), ie as a
             * %NULL-terminated list of strings in the form 'NAME=VALUE'.
             * The strings may contain non-utf8 data.
             *
             * The remote application usually does not send an environment.  Use
             * %G_APPLICATION_SEND_ENVIRONMENT to affect that.  Even with this flag
             * set it is possible that the environment is still not available (due
             * to invocation messages from other applications).
             *
             * The return value should not be modified or freed and is valid for as
             * long as `cmdline` exists.
             *
             * See g_application_command_line_getenv() if you are only interested
             * in the value of a single environment variable.
             * @returns the environment strings, or %NULL if they were not sent
             */
            get_environ(): string[];
            /**
             * Gets the exit status of `cmdline`.  See
             * g_application_command_line_set_exit_status() for more information.
             * @returns the exit status
             */
            get_exit_status(): number;
            /**
             * Determines if `cmdline` represents a remote invocation.
             * @returns %TRUE if the invocation was remote
             */
            get_is_remote(): boolean;
            /**
             * Gets the options that were passed to g_application_command_line().
             *
             * If you did not override local_command_line() then these are the same
             * options that were parsed according to the #GOptionEntrys added to the
             * application with g_application_add_main_option_entries() and possibly
             * modified from your GApplication::handle-local-options handler.
             *
             * If no options were sent then an empty dictionary is returned so that
             * you don't need to check for %NULL.
             *
             * The data has been passed via an untrusted external process, so the types of
             * all values must be checked before being used.
             * @returns a #GVariantDict with the options
             */
            get_options_dict(): GLib.VariantDict;
            /**
             * Gets the platform data associated with the invocation of `cmdline`.
             *
             * This is a #GVariant dictionary containing information about the
             * context in which the invocation occurred.  It typically contains
             * information like the current working directory and the startup
             * notification ID.
             *
             * It comes from an untrusted external process and hence the types of all
             * values must be validated before being used.
             *
             * For local invocation, it will be %NULL.
             * @returns the platform data, or %NULL
             */
            get_platform_data(): GLib.Variant | null;
            /**
             * Gets the stdin of the invoking process.
             *
             * The #GInputStream can be used to read data passed to the standard
             * input of the invoking process.
             * This doesn't work on all platforms.  Presently, it is only available
             * on UNIX when using a D-Bus daemon capable of passing file descriptors.
             * If stdin is not available then %NULL will be returned.  In the
             * future, support may be expanded to other platforms.
             *
             * You must only call this function once per commandline invocation.
             * @returns a #GInputStream for stdin
             */
            get_stdin(): InputStream | null;
            /**
             * Gets the value of a particular environment variable of the command
             * line invocation, as would be returned by g_getenv().  The strings may
             * contain non-utf8 data.
             *
             * The remote application usually does not send an environment.  Use
             * %G_APPLICATION_SEND_ENVIRONMENT to affect that.  Even with this flag
             * set it is possible that the environment is still not available (due
             * to invocation messages from other applications).
             *
             * The return value should not be modified or freed and is valid for as
             * long as `cmdline` exists.
             * @param name the environment variable to get
             * @returns the value of the variable, or %NULL if unset or unsent
             */
            getenv(name: string): string | null;
            /**
             * Prints a message using the stdout print handler in the invoking process.
             *
             * Unlike g_application_command_line_print(), `message` is not a `printf()`-style
             * format string. Use this function if `message` contains text you don't have
             * control over, that could include `printf()` escape sequences.
             * @param message the message
             */
            print_literal(message: string): void;
            /**
             * Prints a message using the stderr print handler in the invoking process.
             *
             * Unlike g_application_command_line_printerr(), `message` is not
             * a `printf()`-style format string. Use this function if `message` contains text
             * you don't have control over, that could include `printf()` escape sequences.
             * @param message the message
             */
            printerr_literal(message: string): void;
            /**
             * Sets the exit status that will be used when the invoking process
             * exits.
             *
             * The return value of the #GApplication::command-line signal is
             * passed to this function when the handler returns.  This is the usual
             * way of setting the exit status.
             *
             * In the event that you want the remote invocation to continue running
             * and want to decide on the exit status in the future, you can use this
             * call.  For the case of a remote invocation, the remote process will
             * typically exit when the last reference is dropped on `cmdline`.  The
             * exit status of the remote process will be equal to the last value
             * that was set with this function.
             *
             * In the case that the commandline invocation is local, the situation
             * is slightly more complicated.  If the commandline invocation results
             * in the mainloop running (ie: because the use-count of the application
             * increased to a non-zero value) then the application is considered to
             * have been 'successful' in a certain sense, and the exit status is
             * always zero.  If the application use count is zero, though, the exit
             * status of the local #GApplicationCommandLine is used.
             *
             * This method is a no-op if g_application_command_line_done() has
             * been called.
             * @param exit_status the exit status
             */
            set_exit_status(exit_status: number): void;
        }

        namespace BufferedInputStream {
            // Constructor properties interface

            interface ConstructorProps extends FilterInputStream.ConstructorProps, Seekable.ConstructorProps {
                buffer_size: number;
                bufferSize: number;
            }
        }

        /**
         * Buffered input stream implements [class`Gio`.FilterInputStream] and provides
         * for buffered reads.
         *
         * By default, `GBufferedInputStream`'s buffer size is set at 4 kilobytes.
         *
         * To create a buffered input stream, use [ctor`Gio`.BufferedInputStream.new],
         * or [ctor`Gio`.BufferedInputStream.new_sized] to specify the buffer's size at
         * construction.
         *
         * To get the size of a buffer within a buffered input stream, use
         * [method`Gio`.BufferedInputStream.get_buffer_size]. To change the size of a
         * buffered input stream's buffer, use [method`Gio`.BufferedInputStream.set_buffer_size].
         * Note that the buffer's size cannot be reduced below the size of the data within the buffer.
         */
        class BufferedInputStream extends FilterInputStream implements Seekable {
            static $gtype: GObject.GType<BufferedInputStream>;

            // Properties

            /**
             * The size of the backend buffer, in bytes.
             */
            get buffer_size(): number;
            set buffer_size(val: number);
            /**
             * The size of the backend buffer, in bytes.
             */
            get bufferSize(): number;
            set bufferSize(val: number);

            // Constructors

            constructor(properties?: Partial<BufferedInputStream.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](base_stream: InputStream): BufferedInputStream;

            static new_sized(base_stream: InputStream, size: number): BufferedInputStream;

            // Virtual methods

            /**
             * Tries to read `count` bytes from the stream into the buffer.
             * Will block during this read.
             *
             * If `count` is zero, returns zero and does nothing. A value of `count`
             * larger than `G_MAXSSIZE` will cause a
             * [error`Gio`.IOErrorEnum.INVALID_ARGUMENT] error.
             *
             * On success, the number of bytes read into the buffer is returned.
             * It is not an error if this is not the same as the requested size, as it
             * can happen e.g. near the end of a file. Zero is returned on end of file
             * (or if `count` is zero),  but never otherwise.
             *
             * If `count` is -1 then the attempted read size is equal to the number of
             * bytes that are required to fill the buffer.
             *
             * If `cancellable` is not `NULL`, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error [error`Gio`.IOErrorEnum.CANCELLED] will be returned.
             * If an operation was partially finished when the operation was cancelled the
             * partial result will be returned, without an error.
             *
             * On error `-1` is returned and `error` is set accordingly.
             *
             * For the asynchronous, non-blocking, version of this function, see
             * [method`Gio`.BufferedInputStream.fill_async].
             * @param count the number of bytes that will be read from the stream
             * @param cancellable optional [class@Gio.Cancellable] object, `NULL` to ignore
             */
            vfunc_fill(count: number, cancellable?: Cancellable | null): number;
            /**
             * Reads data into `stream'`s buffer asynchronously, up to `count` size.
             * `io_priority` can be used to prioritize reads. For the synchronous
             * version of this function, see [method`Gio`.BufferedInputStream.fill].
             *
             * If `count` is `-1` then the attempted read size is equal to the number
             * of bytes that are required to fill the buffer.
             * @param count the number of bytes that will be read from the stream
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional [class@Gio.Cancellable] object
             * @param callback a [callback@Gio.AsyncReadyCallback]
             */
            vfunc_fill_async(
                count: number,
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Finishes an asynchronous read.
             * @param result a [iface@Gio.AsyncResult]
             */
            vfunc_fill_finish(result: AsyncResult): number;

            // Methods

            /**
             * Tries to read `count` bytes from the stream into the buffer.
             * Will block during this read.
             *
             * If `count` is zero, returns zero and does nothing. A value of `count`
             * larger than `G_MAXSSIZE` will cause a
             * [error`Gio`.IOErrorEnum.INVALID_ARGUMENT] error.
             *
             * On success, the number of bytes read into the buffer is returned.
             * It is not an error if this is not the same as the requested size, as it
             * can happen e.g. near the end of a file. Zero is returned on end of file
             * (or if `count` is zero),  but never otherwise.
             *
             * If `count` is -1 then the attempted read size is equal to the number of
             * bytes that are required to fill the buffer.
             *
             * If `cancellable` is not `NULL`, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error [error`Gio`.IOErrorEnum.CANCELLED] will be returned.
             * If an operation was partially finished when the operation was cancelled the
             * partial result will be returned, without an error.
             *
             * On error `-1` is returned and `error` is set accordingly.
             *
             * For the asynchronous, non-blocking, version of this function, see
             * [method`Gio`.BufferedInputStream.fill_async].
             * @param count the number of bytes that will be read from the stream
             * @param cancellable optional [class@Gio.Cancellable] object, `NULL` to ignore
             * @returns the number of bytes read into @stream's buffer, up to @count,     or `-1` on error.
             */
            fill(count: number, cancellable?: Cancellable | null): number;
            /**
             * Reads data into `stream'`s buffer asynchronously, up to `count` size.
             * `io_priority` can be used to prioritize reads. For the synchronous
             * version of this function, see [method`Gio`.BufferedInputStream.fill].
             *
             * If `count` is `-1` then the attempted read size is equal to the number
             * of bytes that are required to fill the buffer.
             * @param count the number of bytes that will be read from the stream
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional [class@Gio.Cancellable] object
             */
            fill_async(count: number, io_priority: number, cancellable?: Cancellable | null): Promise<number>;
            /**
             * Reads data into `stream'`s buffer asynchronously, up to `count` size.
             * `io_priority` can be used to prioritize reads. For the synchronous
             * version of this function, see [method`Gio`.BufferedInputStream.fill].
             *
             * If `count` is `-1` then the attempted read size is equal to the number
             * of bytes that are required to fill the buffer.
             * @param count the number of bytes that will be read from the stream
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional [class@Gio.Cancellable] object
             * @param callback a [callback@Gio.AsyncReadyCallback]
             */
            fill_async(
                count: number,
                io_priority: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Reads data into `stream'`s buffer asynchronously, up to `count` size.
             * `io_priority` can be used to prioritize reads. For the synchronous
             * version of this function, see [method`Gio`.BufferedInputStream.fill].
             *
             * If `count` is `-1` then the attempted read size is equal to the number
             * of bytes that are required to fill the buffer.
             * @param count the number of bytes that will be read from the stream
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional [class@Gio.Cancellable] object
             * @param callback a [callback@Gio.AsyncReadyCallback]
             */
            fill_async(
                count: number,
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<number> | void;
            /**
             * Finishes an asynchronous read.
             * @param result a [iface@Gio.AsyncResult]
             * @returns a #gssize of the read stream, or `-1` on an error.
             */
            fill_finish(result: AsyncResult): number;
            /**
             * Gets the size of the available data within the stream.
             * @returns size of the available stream.
             */
            get_available(): number;
            /**
             * Gets the size of the input buffer.
             * @returns the current buffer size.
             */
            get_buffer_size(): number;
            /**
             * Peeks in the buffer, copying data of size `count` into `buffer,`
             * offset `offset` bytes.
             * @param buffer a pointer to   an allocated chunk of memory
             * @param offset a #gsize
             * @returns a #gsize of the number of bytes peeked, or `-1` on error.
             */
            peek(buffer: Uint8Array | string, offset: number): number;
            /**
             * Returns the buffer with the currently available bytes. The returned
             * buffer must not be modified and will become invalid when reading from
             * the stream or filling the buffer.
             * @returns read-only buffer
             */
            peek_buffer(): Uint8Array;
            /**
             * Tries to read a single byte from the stream or the buffer. Will block
             * during this read.
             *
             * On success, the byte read from the stream is returned. On end of stream
             * `-1` is returned but it's not an exceptional error and `error` is not set.
             *
             * If `cancellable` is not `NULL`, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error [error`Gio`.IOErrorEnum.CANCELLED] will be returned.
             * If an operation was partially finished when the operation was cancelled the
             * partial result will be returned, without an error.
             *
             * On error `-1` is returned and `error` is set accordingly.
             * @param cancellable optional [class@Gio.Cancellable] object, `NULL` to ignore
             * @returns the byte read from the @stream, or `-1` on end of stream or error.
             */
            read_byte(cancellable?: Cancellable | null): number;
            /**
             * Sets the size of the internal buffer of `stream` to `size,` or to the
             * size of the contents of the buffer. The buffer can never be resized
             * smaller than its current contents.
             * @param size a #gsize
             */
            set_buffer_size(size: number): void;

            // Inherited methods
            /**
             * Tests if the stream supports the #GSeekableIface.
             * @returns %TRUE if @seekable can be seeked. %FALSE otherwise.
             */
            can_seek(): boolean;
            /**
             * Tests if the length of the stream can be adjusted with
             * g_seekable_truncate().
             * @returns %TRUE if the stream can be truncated, %FALSE otherwise.
             */
            can_truncate(): boolean;
            /**
             * Seeks in the stream by the given `offset,` modified by `type`.
             *
             * Attempting to seek past the end of the stream will have different
             * results depending on if the stream is fixed-sized or resizable.  If
             * the stream is resizable then seeking past the end and then writing
             * will result in zeros filling the empty space.  Seeking past the end
             * of a resizable stream and reading will result in EOF.  Seeking past
             * the end of a fixed-sized stream will fail.
             *
             * Any operation that would result in a negative offset will fail.
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
             * @param offset a #goffset.
             * @param type a #GSeekType.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @returns %TRUE if successful. If an error     has occurred, this function will return %FALSE and set @error     appropriately if present.
             */
            seek(offset: number, type: GLib.SeekType | null, cancellable?: Cancellable | null): boolean;
            /**
             * Tells the current position within the stream.
             * @returns the (positive or zero) offset from the beginning of the buffer, zero if the target is not seekable.
             */
            tell(): number;
            /**
             * Sets the length of the stream to `offset`. If the stream was previously
             * larger than `offset,` the extra data is discarded. If the stream was
             * previously shorter than `offset,` it is extended with NUL ('\0') bytes.
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
             * operation was partially finished when the operation was cancelled the
             * partial result will be returned, without an error.
             * @param offset new length for @seekable, in bytes.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @returns %TRUE if successful. If an error     has occurred, this function will return %FALSE and set @error     appropriately if present.
             */
            truncate(offset: number, cancellable?: Cancellable | null): boolean;
            /**
             * Tests if the stream supports the #GSeekableIface.
             */
            vfunc_can_seek(): boolean;
            /**
             * Tests if the length of the stream can be adjusted with
             * g_seekable_truncate().
             */
            vfunc_can_truncate(): boolean;
            /**
             * Seeks in the stream by the given `offset,` modified by `type`.
             *
             * Attempting to seek past the end of the stream will have different
             * results depending on if the stream is fixed-sized or resizable.  If
             * the stream is resizable then seeking past the end and then writing
             * will result in zeros filling the empty space.  Seeking past the end
             * of a resizable stream and reading will result in EOF.  Seeking past
             * the end of a fixed-sized stream will fail.
             *
             * Any operation that would result in a negative offset will fail.
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
             * @param offset a #goffset.
             * @param type a #GSeekType.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            vfunc_seek(offset: number, type: GLib.SeekType, cancellable?: Cancellable | null): boolean;
            /**
             * Tells the current position within the stream.
             */
            vfunc_tell(): number;
            /**
             * Sets the length of the stream to `offset`. If the stream was previously
             * larger than `offset,` the extra data is discarded. If the stream was
             * previously shorter than `offset,` it is extended with NUL ('\0') bytes.
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
             * operation was partially finished when the operation was cancelled the
             * partial result will be returned, without an error.
             * @param offset new length for @seekable, in bytes.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            vfunc_truncate_fn(offset: number, cancellable?: Cancellable | null): boolean;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace BufferedOutputStream {
            // Constructor properties interface

            interface ConstructorProps extends FilterOutputStream.ConstructorProps, Seekable.ConstructorProps {
                auto_grow: boolean;
                autoGrow: boolean;
                buffer_size: number;
                bufferSize: number;
            }
        }

        /**
         * Buffered output stream implements [class`Gio`.FilterOutputStream] and provides
         * for buffered writes.
         *
         * By default, `GBufferedOutputStream`'s buffer size is set at 4 kilobytes.
         *
         * To create a buffered output stream, use [ctor`Gio`.BufferedOutputStream.new],
         * or [ctor`Gio`.BufferedOutputStream.new_sized] to specify the buffer's size
         * at construction.
         *
         * To get the size of a buffer within a buffered input stream, use
         * [method`Gio`.BufferedOutputStream.get_buffer_size]. To change the size of a
         * buffered output stream's buffer, use [method`Gio`.BufferedOutputStream.set_buffer_size].
         * Note that the buffer's size cannot be reduced below the size of the data within the buffer.
         */
        class BufferedOutputStream extends FilterOutputStream implements Seekable {
            static $gtype: GObject.GType<BufferedOutputStream>;

            // Properties

            /**
             * Whether the buffer should automatically grow.
             */
            get auto_grow(): boolean;
            set auto_grow(val: boolean);
            /**
             * Whether the buffer should automatically grow.
             */
            get autoGrow(): boolean;
            set autoGrow(val: boolean);
            /**
             * The size of the backend buffer, in bytes.
             */
            get buffer_size(): number;
            set buffer_size(val: number);
            /**
             * The size of the backend buffer, in bytes.
             */
            get bufferSize(): number;
            set bufferSize(val: number);

            // Constructors

            constructor(properties?: Partial<BufferedOutputStream.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](base_stream: OutputStream): BufferedOutputStream;

            static new_sized(base_stream: OutputStream, size: number): BufferedOutputStream;

            // Methods

            /**
             * Checks if the buffer automatically grows as data is added.
             * @returns `TRUE` if the @stream's buffer automatically grows, `FALSE` otherwise.
             */
            get_auto_grow(): boolean;
            /**
             * Gets the size of the buffer in the `stream`.
             * @returns the current size of the buffer.
             */
            get_buffer_size(): number;
            /**
             * Sets whether or not the `stream'`s buffer should automatically grow.
             * If `auto_grow` is true, then each write will just make the buffer
             * larger, and you must manually flush the buffer to actually write out
             * the data to the underlying stream.
             * @param auto_grow a #gboolean.
             */
            set_auto_grow(auto_grow: boolean): void;
            /**
             * Sets the size of the internal buffer to `size`.
             * @param size a #gsize.
             */
            set_buffer_size(size: number): void;

            // Inherited methods
            /**
             * Tests if the stream supports the #GSeekableIface.
             * @returns %TRUE if @seekable can be seeked. %FALSE otherwise.
             */
            can_seek(): boolean;
            /**
             * Tests if the length of the stream can be adjusted with
             * g_seekable_truncate().
             * @returns %TRUE if the stream can be truncated, %FALSE otherwise.
             */
            can_truncate(): boolean;
            /**
             * Seeks in the stream by the given `offset,` modified by `type`.
             *
             * Attempting to seek past the end of the stream will have different
             * results depending on if the stream is fixed-sized or resizable.  If
             * the stream is resizable then seeking past the end and then writing
             * will result in zeros filling the empty space.  Seeking past the end
             * of a resizable stream and reading will result in EOF.  Seeking past
             * the end of a fixed-sized stream will fail.
             *
             * Any operation that would result in a negative offset will fail.
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
             * @param offset a #goffset.
             * @param type a #GSeekType.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @returns %TRUE if successful. If an error     has occurred, this function will return %FALSE and set @error     appropriately if present.
             */
            seek(offset: number, type: GLib.SeekType | null, cancellable?: Cancellable | null): boolean;
            /**
             * Tells the current position within the stream.
             * @returns the (positive or zero) offset from the beginning of the buffer, zero if the target is not seekable.
             */
            tell(): number;
            /**
             * Sets the length of the stream to `offset`. If the stream was previously
             * larger than `offset,` the extra data is discarded. If the stream was
             * previously shorter than `offset,` it is extended with NUL ('\0') bytes.
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
             * operation was partially finished when the operation was cancelled the
             * partial result will be returned, without an error.
             * @param offset new length for @seekable, in bytes.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @returns %TRUE if successful. If an error     has occurred, this function will return %FALSE and set @error     appropriately if present.
             */
            truncate(offset: number, cancellable?: Cancellable | null): boolean;
            /**
             * Tests if the stream supports the #GSeekableIface.
             */
            vfunc_can_seek(): boolean;
            /**
             * Tests if the length of the stream can be adjusted with
             * g_seekable_truncate().
             */
            vfunc_can_truncate(): boolean;
            /**
             * Seeks in the stream by the given `offset,` modified by `type`.
             *
             * Attempting to seek past the end of the stream will have different
             * results depending on if the stream is fixed-sized or resizable.  If
             * the stream is resizable then seeking past the end and then writing
             * will result in zeros filling the empty space.  Seeking past the end
             * of a resizable stream and reading will result in EOF.  Seeking past
             * the end of a fixed-sized stream will fail.
             *
             * Any operation that would result in a negative offset will fail.
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
             * @param offset a #goffset.
             * @param type a #GSeekType.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            vfunc_seek(offset: number, type: GLib.SeekType, cancellable?: Cancellable | null): boolean;
            /**
             * Tells the current position within the stream.
             */
            vfunc_tell(): number;
            /**
             * Sets the length of the stream to `offset`. If the stream was previously
             * larger than `offset,` the extra data is discarded. If the stream was
             * previously shorter than `offset,` it is extended with NUL ('\0') bytes.
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
             * operation was partially finished when the operation was cancelled the
             * partial result will be returned, without an error.
             * @param offset new length for @seekable, in bytes.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            vfunc_truncate_fn(offset: number, cancellable?: Cancellable | null): boolean;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace BytesIcon {
            // Constructor properties interface

            interface ConstructorProps
                extends GObject.Object.ConstructorProps,
                    Icon.ConstructorProps,
                    LoadableIcon.ConstructorProps {
                bytes: GLib.Bytes;
            }
        }

        /**
         * `GBytesIcon` specifies an image held in memory in a common format (usually
         * PNG) to be used as icon.
         */
        class BytesIcon extends GObject.Object implements Icon, LoadableIcon {
            static $gtype: GObject.GType<BytesIcon>;

            // Properties

            /**
             * The bytes containing the icon.
             */
            get bytes(): GLib.Bytes;

            // Constructors

            constructor(properties?: Partial<BytesIcon.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](bytes: GLib.Bytes | Uint8Array): BytesIcon;

            // Methods

            /**
             * Gets the #GBytes associated with the given `icon`.
             * @returns a #GBytes.
             */
            get_bytes(): GLib.Bytes;

            // Inherited methods
            /**
             * Checks if two icons are equal.
             * @param icon2 pointer to the second #GIcon.
             * @returns %TRUE if @icon1 is equal to @icon2. %FALSE otherwise.
             */
            equal(icon2?: Icon | null): boolean;
            /**
             * Gets a hash for an icon.
             * @returns a #guint containing a hash for the @icon, suitable for   use in a #GHashTable or similar data structure.
             */
            hash(): number;
            /**
             * Serializes a #GIcon into a #GVariant. An equivalent #GIcon can be retrieved
             * back by calling g_icon_deserialize() on the returned value.
             * As serialization will avoid using raw icon data when possible, it only
             * makes sense to transfer the #GVariant between processes on the same machine,
             * (as opposed to over the network), and within the same file system namespace.
             * @returns a #GVariant, or %NULL when serialization fails. The #GVariant will not be floating.
             */
            serialize(): GLib.Variant | null;
            /**
             * Generates a textual representation of `icon` that can be used for
             * serialization such as when passing `icon` to a different process or
             * saving it to persistent storage. Use g_icon_new_for_string() to
             * get `icon` back from the returned string.
             *
             * The encoding of the returned string is proprietary to #GIcon except
             * in the following two cases
             *
             * - If `icon` is a #GFileIcon, the returned string is a native path
             *   (such as `/path/to/my icon.png`) without escaping
             *   if the #GFile for `icon` is a native file.  If the file is not
             *   native, the returned string is the result of g_file_get_uri()
             *   (such as `sftp://path/to/my%20icon.png`).
             *
             * - If `icon` is a #GThemedIcon with exactly one name and no fallbacks,
             *   the encoding is simply the name (such as `network-server`).
             * @returns An allocated NUL-terminated UTF8 string or %NULL if @icon can't be serialized. Use g_free() to free.
             */
            to_string(): string | null;
            /**
             * Checks if two icons are equal.
             * @param icon2 pointer to the second #GIcon.
             */
            vfunc_equal(icon2?: Icon | null): boolean;
            /**
             * Gets a hash for an icon.
             */
            vfunc_hash(): number;
            /**
             * Serializes a #GIcon into a #GVariant. An equivalent #GIcon can be retrieved
             * back by calling g_icon_deserialize() on the returned value.
             * As serialization will avoid using raw icon data when possible, it only
             * makes sense to transfer the #GVariant between processes on the same machine,
             * (as opposed to over the network), and within the same file system namespace.
             */
            vfunc_serialize(): GLib.Variant | null;
            /**
             * Serializes the `icon` into string tokens.
             * This is can be invoked when g_icon_new_for_string() is called.
             */
            vfunc_to_tokens(): [boolean, string[], number];
            /**
             * Loads a loadable icon. For the asynchronous version of this function,
             * see g_loadable_icon_load_async().
             * @param size an integer.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @returns a #GInputStream to read the icon from.
             */
            load(size: number, cancellable?: Cancellable | null): [InputStream, string];
            /**
             * Loads an icon asynchronously. To finish this function, see
             * g_loadable_icon_load_finish(). For the synchronous, blocking
             * version of this function, see g_loadable_icon_load().
             * @param size an integer.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            load_async(size: number, cancellable?: Cancellable | null): Promise<[InputStream, string]>;
            /**
             * Loads an icon asynchronously. To finish this function, see
             * g_loadable_icon_load_finish(). For the synchronous, blocking
             * version of this function, see g_loadable_icon_load().
             * @param size an integer.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            load_async(size: number, cancellable: Cancellable | null, callback: AsyncReadyCallback<this> | null): void;
            /**
             * Loads an icon asynchronously. To finish this function, see
             * g_loadable_icon_load_finish(). For the synchronous, blocking
             * version of this function, see g_loadable_icon_load().
             * @param size an integer.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            load_async(
                size: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<[InputStream, string]> | void;
            /**
             * Finishes an asynchronous icon load started in g_loadable_icon_load_async().
             * @param res a #GAsyncResult.
             * @returns a #GInputStream to read the icon from.
             */
            load_finish(res: AsyncResult): [InputStream, string];
            /**
             * Loads a loadable icon. For the asynchronous version of this function,
             * see g_loadable_icon_load_async().
             * @param size an integer.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            vfunc_load(size: number, cancellable?: Cancellable | null): [InputStream, string];
            /**
             * Loads an icon asynchronously. To finish this function, see
             * g_loadable_icon_load_finish(). For the synchronous, blocking
             * version of this function, see g_loadable_icon_load().
             * @param size an integer.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            vfunc_load_async(
                size: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Finishes an asynchronous icon load started in g_loadable_icon_load_async().
             * @param res a #GAsyncResult.
             */
            vfunc_load_finish(res: AsyncResult): [InputStream, string];
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace Cancellable {
            // Signal callback interfaces

            interface Cancelled {
                (): void;
            }

            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps {}
        }

        /**
         * `GCancellable` allows operations to be cancelled.
         *
         * `GCancellable` is a thread-safe operation cancellation stack used
         * throughout GIO to allow for cancellation of synchronous and
         * asynchronous operations.
         */
        class Cancellable extends GObject.Object {
            static $gtype: GObject.GType<Cancellable>;

            // Constructors

            constructor(properties?: Partial<Cancellable.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](): Cancellable;

            // Signals

            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect_after(signal: 'cancelled', callback: (_source: this) => void): number;
            emit(signal: 'cancelled'): void;

            // Static methods

            /**
             * Gets the top cancellable from the stack.
             */
            static get_current(): Cancellable | null;

            // Virtual methods

            vfunc_cancelled(): void;

            // Methods

            /**
             * Will set `cancellable` to cancelled, and will emit the
             * #GCancellable::cancelled signal. (However, see the warning about
             * race conditions in the documentation for that signal if you are
             * planning to connect to it.)
             *
             * This function is thread-safe. In other words, you can safely call
             * it from a thread other than the one running the operation that was
             * passed the `cancellable`.
             *
             * If `cancellable` is %NULL, this function returns immediately for convenience.
             *
             * The convention within GIO is that cancelling an asynchronous
             * operation causes it to complete asynchronously. That is, if you
             * cancel the operation from the same thread in which it is running,
             * then the operation's #GAsyncReadyCallback will not be invoked until
             * the application returns to the main loop.
             */
            cancel(): void;
            /**
             * Convenience function to connect to the #GCancellable::cancelled
             * signal. Also handles the race condition that may happen
             * if the cancellable is cancelled right before connecting.
             *
             * `callback` is called exactly once each time `cancellable` is cancelled,
             * either directly at the time of the connect if `cancellable` is already
             * cancelled, or when `cancellable` is cancelled in some thread.
             * In case the cancellable is reset via [method`Gio`.Cancellable.reset]
             * then the callback can be called again if the `cancellable` is cancelled.
             *
             * `data_destroy_func` will be called when the handler is
             * disconnected, or immediately if the cancellable is already
             * cancelled.
             *
             * See #GCancellable::cancelled for details on how to use this.
             *
             * Since GLib 2.40, the lock protecting `cancellable` is not held when
             * `callback` is invoked.  This lifts a restriction in place for
             * earlier GLib versions which now makes it easier to write cleanup
             * code that unconditionally invokes e.g. g_cancellable_cancel().
             * @param callback The #GCallback to connect.
             * @param data_destroy_func Free function for @data or %NULL.
             * @returns The id of the signal handler or 0 if @cancellable has already          been cancelled.
             */
            connect(callback: GObject.Callback, data_destroy_func?: GLib.DestroyNotify | null): number;
            connect(...args: never[]): any;
            /**
             * Disconnects a handler from a cancellable instance similar to
             * g_signal_handler_disconnect().  Additionally, in the event that a
             * signal handler is currently running, this call will block until the
             * handler has finished.  Calling this function from a
             * #GCancellable::cancelled signal handler will therefore result in a
             * deadlock.
             *
             * This avoids a race condition where a thread cancels at the
             * same time as the cancellable operation is finished and the
             * signal handler is removed. See #GCancellable::cancelled for
             * details on how to use this.
             *
             * If `cancellable` is %NULL or `handler_id` is `0` this function does
             * nothing.
             * @param handler_id Handler id of the handler to be disconnected, or `0`.
             */
            disconnect(handler_id: number): void;
            /**
             * Gets the file descriptor for a cancellable job. This can be used to
             * implement cancellable operations on Unix systems. The returned fd will
             * turn readable when `cancellable` is cancelled.
             *
             * You are not supposed to read from the fd yourself, just check for
             * readable status. Reading to unset the readable status is done
             * with g_cancellable_reset().
             *
             * After a successful return from this function, you should use
             * g_cancellable_release_fd() to free up resources allocated for
             * the returned file descriptor.
             *
             * See also g_cancellable_make_pollfd().
             * @returns A valid file descriptor. `-1` if the file descriptor is not supported, or on errors.
             */
            get_fd(): number;
            /**
             * Checks if a cancellable job has been cancelled.
             * @returns %TRUE if @cancellable is cancelled, FALSE if called with %NULL or if item is not cancelled.
             */
            is_cancelled(): boolean;
            /**
             * Creates a #GPollFD corresponding to `cancellable;` this can be passed
             * to g_poll() and used to poll for cancellation. This is useful both
             * for unix systems without a native poll and for portability to
             * windows.
             *
             * When this function returns %TRUE, you should use
             * g_cancellable_release_fd() to free up resources allocated for the
             * `pollfd`. After a %FALSE return, do not call g_cancellable_release_fd().
             *
             * If this function returns %FALSE, either no `cancellable` was given or
             * resource limits prevent this function from allocating the necessary
             * structures for polling. (On Linux, you will likely have reached
             * the maximum number of file descriptors.) The suggested way to handle
             * these cases is to ignore the `cancellable`.
             *
             * You are not supposed to read from the fd yourself, just check for
             * readable status. Reading to unset the readable status is done
             * with g_cancellable_reset().
             * @param pollfd a pointer to a #GPollFD
             * @returns %TRUE if @pollfd was successfully initialized, %FALSE on          failure to prepare the cancellable.
             */
            make_pollfd(pollfd: GLib.PollFD): boolean;
            /**
             * Pops `cancellable` off the cancellable stack (verifying that `cancellable`
             * is on the top of the stack).
             */
            pop_current(): void;
            /**
             * Pushes `cancellable` onto the cancellable stack. The current
             * cancellable can then be received using g_cancellable_get_current().
             *
             * This is useful when implementing cancellable operations in
             * code that does not allow you to pass down the cancellable object.
             *
             * This is typically called automatically by e.g. #GFile operations,
             * so you rarely have to call this yourself.
             */
            push_current(): void;
            /**
             * Releases a resources previously allocated by g_cancellable_get_fd()
             * or g_cancellable_make_pollfd().
             *
             * For compatibility reasons with older releases, calling this function
             * is not strictly required, the resources will be automatically freed
             * when the `cancellable` is finalized. However, the `cancellable` will
             * block scarce file descriptors until it is finalized if this function
             * is not called. This can cause the application to run out of file
             * descriptors when many #GCancellables are used at the same time.
             */
            release_fd(): void;
            /**
             * Resets `cancellable` to its uncancelled state.
             *
             * If cancellable is currently in use by any cancellable operation
             * then the behavior of this function is undefined.
             *
             * Note that it is generally not a good idea to reuse an existing
             * cancellable for more operations after it has been cancelled once,
             * as this function might tempt you to do. The recommended practice
             * is to drop the reference to a cancellable after cancelling it,
             * and let it die with the outstanding async operations. You should
             * create a fresh cancellable for further async operations.
             */
            reset(): void;
            /**
             * If the `cancellable` is cancelled, sets the error to notify
             * that the operation was cancelled.
             * @returns %TRUE if @cancellable was cancelled, %FALSE if it was not
             */
            set_error_if_cancelled(): boolean;
            /**
             * Creates a source that triggers if `cancellable` is cancelled and
             * calls its callback of type #GCancellableSourceFunc. This is
             * primarily useful for attaching to another (non-cancellable) source
             * with g_source_add_child_source() to add cancellability to it.
             *
             * For convenience, you can call this with a %NULL #GCancellable,
             * in which case the source will never trigger.
             *
             * The new #GSource will hold a reference to the #GCancellable.
             * @returns the new #GSource.
             */
            source_new(): GLib.Source;
        }

        namespace CharsetConverter {
            // Constructor properties interface

            interface ConstructorProps
                extends GObject.Object.ConstructorProps,
                    Converter.ConstructorProps,
                    Initable.ConstructorProps {
                from_charset: string;
                fromCharset: string;
                to_charset: string;
                toCharset: string;
                use_fallback: boolean;
                useFallback: boolean;
            }
        }

        /**
         * `GCharsetConverter` is an implementation of [iface`Gio`.Converter] based on
         * [struct`GLib`.IConv].
         */
        class CharsetConverter extends GObject.Object implements Converter, Initable {
            static $gtype: GObject.GType<CharsetConverter>;

            // Properties

            /**
             * The character encoding to convert from.
             */
            get from_charset(): string;
            /**
             * The character encoding to convert from.
             */
            get fromCharset(): string;
            /**
             * The character encoding to convert to.
             */
            get to_charset(): string;
            /**
             * The character encoding to convert to.
             */
            get toCharset(): string;
            /**
             * Use fallback (of form `\<hexval>`) for invalid bytes.
             */
            get use_fallback(): boolean;
            set use_fallback(val: boolean);
            /**
             * Use fallback (of form `\<hexval>`) for invalid bytes.
             */
            get useFallback(): boolean;
            set useFallback(val: boolean);

            // Constructors

            constructor(properties?: Partial<CharsetConverter.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](to_charset: string, from_charset: string): CharsetConverter;

            // Methods

            /**
             * Gets the number of fallbacks that `converter` has applied so far.
             * @returns the number of fallbacks that @converter has applied
             */
            get_num_fallbacks(): number;
            /**
             * Gets the #GCharsetConverter:use-fallback property.
             * @returns %TRUE if fallbacks are used by @converter
             */
            get_use_fallback(): boolean;
            /**
             * Sets the #GCharsetConverter:use-fallback property.
             * @param use_fallback %TRUE to use fallbacks
             */
            set_use_fallback(use_fallback: boolean): void;

            // Inherited methods
            /**
             * This is the main operation used when converting data. It is to be called
             * multiple times in a loop, and each time it will do some work, i.e.
             * producing some output (in `outbuf)` or consuming some input (from `inbuf)` or
             * both. If its not possible to do any work an error is returned.
             *
             * Note that a single call may not consume all input (or any input at all).
             * Also a call may produce output even if given no input, due to state stored
             * in the converter producing output.
             *
             * If any data was either produced or consumed, and then an error happens, then
             * only the successful conversion is reported and the error is returned on the
             * next call.
             *
             * A full conversion loop involves calling this method repeatedly, each time
             * giving it new input and space output space. When there is no more input
             * data after the data in `inbuf,` the flag %G_CONVERTER_INPUT_AT_END must be set.
             * The loop will be (unless some error happens) returning %G_CONVERTER_CONVERTED
             * each time until all data is consumed and all output is produced, then
             * %G_CONVERTER_FINISHED is returned instead. Note, that %G_CONVERTER_FINISHED
             * may be returned even if %G_CONVERTER_INPUT_AT_END is not set, for instance
             * in a decompression converter where the end of data is detectable from the
             * data (and there might even be other data after the end of the compressed data).
             *
             * When some data has successfully been converted `bytes_read` and is set to
             * the number of bytes read from `inbuf,` and `bytes_written` is set to indicate
             * how many bytes was written to `outbuf`. If there are more data to output
             * or consume (i.e. unless the %G_CONVERTER_INPUT_AT_END is specified) then
             * %G_CONVERTER_CONVERTED is returned, and if no more data is to be output
             * then %G_CONVERTER_FINISHED is returned.
             *
             * On error %G_CONVERTER_ERROR is returned and `error` is set accordingly.
             * Some errors need special handling:
             *
             * %G_IO_ERROR_NO_SPACE is returned if there is not enough space
             * to write the resulting converted data, the application should
             * call the function again with a larger `outbuf` to continue.
             *
             * %G_IO_ERROR_PARTIAL_INPUT is returned if there is not enough
             * input to fully determine what the conversion should produce,
             * and the %G_CONVERTER_INPUT_AT_END flag is not set. This happens for
             * example with an incomplete multibyte sequence when converting text,
             * or when a regexp matches up to the end of the input (and may match
             * further input). It may also happen when `inbuf_size` is zero and
             * there is no more data to produce.
             *
             * When this happens the application should read more input and then
             * call the function again. If further input shows that there is no
             * more data call the function again with the same data but with
             * the %G_CONVERTER_INPUT_AT_END flag set. This may cause the conversion
             * to finish as e.g. in the regexp match case (or, to fail again with
             * %G_IO_ERROR_PARTIAL_INPUT in e.g. a charset conversion where the
             * input is actually partial).
             *
             * After g_converter_convert() has returned %G_CONVERTER_FINISHED the
             * converter object is in an invalid state where its not allowed
             * to call g_converter_convert() anymore. At this time you can only
             * free the object or call g_converter_reset() to reset it to the
             * initial state.
             *
             * If the flag %G_CONVERTER_FLUSH is set then conversion is modified
             * to try to write out all internal state to the output. The application
             * has to call the function multiple times with the flag set, and when
             * the available input has been consumed and all internal state has
             * been produced then %G_CONVERTER_FLUSHED (or %G_CONVERTER_FINISHED if
             * really at the end) is returned instead of %G_CONVERTER_CONVERTED.
             * This is somewhat similar to what happens at the end of the input stream,
             * but done in the middle of the data.
             *
             * This has different meanings for different conversions. For instance
             * in a compression converter it would mean that we flush all the
             * compression state into output such that if you uncompress the
             * compressed data you get back all the input data. Doing this may
             * make the final file larger due to padding though. Another example
             * is a regexp conversion, where if you at the end of the flushed data
             * have a match, but there is also a potential longer match. In the
             * non-flushed case we would ask for more input, but when flushing we
             * treat this as the end of input and do the match.
             *
             * Flushing is not always possible (like if a charset converter flushes
             * at a partial multibyte sequence). Converters are supposed to try
             * to produce as much output as possible and then return an error
             * (typically %G_IO_ERROR_PARTIAL_INPUT).
             * @param inbuf the buffer         containing the data to convert.
             * @param outbuf a    buffer to write converted data in.
             * @param flags a #GConverterFlags controlling the conversion details
             * @returns a #GConverterResult, %G_CONVERTER_ERROR on error.
             */
            convert(
                inbuf: Uint8Array | string,
                outbuf: Uint8Array | string,
                flags: ConverterFlags | null,
            ): [ConverterResult, number, number];
            /**
             * Applies `converter` to the data in `bytes`.
             * @param bytes the data to convert
             * @returns A newly-allocated   `GBytes` with the converted data, or `NULL` if an error   occurred
             */
            convert_bytes(bytes: GLib.Bytes | Uint8Array): GLib.Bytes;
            /**
             * Resets all internal state in the converter, making it behave
             * as if it was just created. If the converter has any internal
             * state that would produce output then that output is lost.
             */
            reset(): void;
            /**
             * This is the main operation used when converting data. It is to be called
             * multiple times in a loop, and each time it will do some work, i.e.
             * producing some output (in `outbuf)` or consuming some input (from `inbuf)` or
             * both. If its not possible to do any work an error is returned.
             *
             * Note that a single call may not consume all input (or any input at all).
             * Also a call may produce output even if given no input, due to state stored
             * in the converter producing output.
             *
             * If any data was either produced or consumed, and then an error happens, then
             * only the successful conversion is reported and the error is returned on the
             * next call.
             *
             * A full conversion loop involves calling this method repeatedly, each time
             * giving it new input and space output space. When there is no more input
             * data after the data in `inbuf,` the flag %G_CONVERTER_INPUT_AT_END must be set.
             * The loop will be (unless some error happens) returning %G_CONVERTER_CONVERTED
             * each time until all data is consumed and all output is produced, then
             * %G_CONVERTER_FINISHED is returned instead. Note, that %G_CONVERTER_FINISHED
             * may be returned even if %G_CONVERTER_INPUT_AT_END is not set, for instance
             * in a decompression converter where the end of data is detectable from the
             * data (and there might even be other data after the end of the compressed data).
             *
             * When some data has successfully been converted `bytes_read` and is set to
             * the number of bytes read from `inbuf,` and `bytes_written` is set to indicate
             * how many bytes was written to `outbuf`. If there are more data to output
             * or consume (i.e. unless the %G_CONVERTER_INPUT_AT_END is specified) then
             * %G_CONVERTER_CONVERTED is returned, and if no more data is to be output
             * then %G_CONVERTER_FINISHED is returned.
             *
             * On error %G_CONVERTER_ERROR is returned and `error` is set accordingly.
             * Some errors need special handling:
             *
             * %G_IO_ERROR_NO_SPACE is returned if there is not enough space
             * to write the resulting converted data, the application should
             * call the function again with a larger `outbuf` to continue.
             *
             * %G_IO_ERROR_PARTIAL_INPUT is returned if there is not enough
             * input to fully determine what the conversion should produce,
             * and the %G_CONVERTER_INPUT_AT_END flag is not set. This happens for
             * example with an incomplete multibyte sequence when converting text,
             * or when a regexp matches up to the end of the input (and may match
             * further input). It may also happen when `inbuf_size` is zero and
             * there is no more data to produce.
             *
             * When this happens the application should read more input and then
             * call the function again. If further input shows that there is no
             * more data call the function again with the same data but with
             * the %G_CONVERTER_INPUT_AT_END flag set. This may cause the conversion
             * to finish as e.g. in the regexp match case (or, to fail again with
             * %G_IO_ERROR_PARTIAL_INPUT in e.g. a charset conversion where the
             * input is actually partial).
             *
             * After g_converter_convert() has returned %G_CONVERTER_FINISHED the
             * converter object is in an invalid state where its not allowed
             * to call g_converter_convert() anymore. At this time you can only
             * free the object or call g_converter_reset() to reset it to the
             * initial state.
             *
             * If the flag %G_CONVERTER_FLUSH is set then conversion is modified
             * to try to write out all internal state to the output. The application
             * has to call the function multiple times with the flag set, and when
             * the available input has been consumed and all internal state has
             * been produced then %G_CONVERTER_FLUSHED (or %G_CONVERTER_FINISHED if
             * really at the end) is returned instead of %G_CONVERTER_CONVERTED.
             * This is somewhat similar to what happens at the end of the input stream,
             * but done in the middle of the data.
             *
             * This has different meanings for different conversions. For instance
             * in a compression converter it would mean that we flush all the
             * compression state into output such that if you uncompress the
             * compressed data you get back all the input data. Doing this may
             * make the final file larger due to padding though. Another example
             * is a regexp conversion, where if you at the end of the flushed data
             * have a match, but there is also a potential longer match. In the
             * non-flushed case we would ask for more input, but when flushing we
             * treat this as the end of input and do the match.
             *
             * Flushing is not always possible (like if a charset converter flushes
             * at a partial multibyte sequence). Converters are supposed to try
             * to produce as much output as possible and then return an error
             * (typically %G_IO_ERROR_PARTIAL_INPUT).
             * @param inbuf the buffer         containing the data to convert.
             * @param outbuf a    buffer to write converted data in.
             * @param flags a #GConverterFlags controlling the conversion details
             */
            vfunc_convert(
                inbuf: Uint8Array | null,
                outbuf: Uint8Array | string,
                flags: ConverterFlags,
            ): [ConverterResult, number, number];
            /**
             * Resets all internal state in the converter, making it behave
             * as if it was just created. If the converter has any internal
             * state that would produce output then that output is lost.
             */
            vfunc_reset(): void;
            /**
             * Initializes the object implementing the interface.
             *
             * This method is intended for language bindings. If writing in C,
             * g_initable_new() should typically be used instead.
             *
             * The object must be initialized before any real use after initial
             * construction, either with this function or g_async_initable_init_async().
             *
             * Implementations may also support cancellation. If `cancellable` is not %NULL,
             * then initialization can be cancelled by triggering the cancellable object
             * from another thread. If the operation was cancelled, the error
             * %G_IO_ERROR_CANCELLED will be returned. If `cancellable` is not %NULL and
             * the object doesn't support cancellable initialization the error
             * %G_IO_ERROR_NOT_SUPPORTED will be returned.
             *
             * If the object is not initialized, or initialization returns with an
             * error, then all operations on the object except g_object_ref() and
             * g_object_unref() are considered to be invalid, and have undefined
             * behaviour. See the [description][iface`Gio`.Initable#description] for more details.
             *
             * Callers should not assume that a class which implements #GInitable can be
             * initialized multiple times, unless the class explicitly documents itself as
             * supporting this. Generally, a class’ implementation of init() can assume
             * (and assert) that it will only be called once. Previously, this documentation
             * recommended all #GInitable implementations should be idempotent; that
             * recommendation was relaxed in GLib 2.54.
             *
             * If a class explicitly supports being initialized multiple times, it is
             * recommended that the method is idempotent: multiple calls with the same
             * arguments should return the same results. Only the first call initializes
             * the object; further calls return the result of the first call.
             *
             * One reason why a class might need to support idempotent initialization is if
             * it is designed to be used via the singleton pattern, with a
             * #GObjectClass.constructor that sometimes returns an existing instance.
             * In this pattern, a caller would expect to be able to call g_initable_init()
             * on the result of g_object_new(), regardless of whether it is in fact a new
             * instance.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @returns %TRUE if successful. If an error has occurred, this function will     return %FALSE and set @error appropriately if present.
             */
            init(cancellable?: Cancellable | null): boolean;
            /**
             * Initializes the object implementing the interface.
             *
             * This method is intended for language bindings. If writing in C,
             * g_initable_new() should typically be used instead.
             *
             * The object must be initialized before any real use after initial
             * construction, either with this function or g_async_initable_init_async().
             *
             * Implementations may also support cancellation. If `cancellable` is not %NULL,
             * then initialization can be cancelled by triggering the cancellable object
             * from another thread. If the operation was cancelled, the error
             * %G_IO_ERROR_CANCELLED will be returned. If `cancellable` is not %NULL and
             * the object doesn't support cancellable initialization the error
             * %G_IO_ERROR_NOT_SUPPORTED will be returned.
             *
             * If the object is not initialized, or initialization returns with an
             * error, then all operations on the object except g_object_ref() and
             * g_object_unref() are considered to be invalid, and have undefined
             * behaviour. See the [description][iface`Gio`.Initable#description] for more details.
             *
             * Callers should not assume that a class which implements #GInitable can be
             * initialized multiple times, unless the class explicitly documents itself as
             * supporting this. Generally, a class’ implementation of init() can assume
             * (and assert) that it will only be called once. Previously, this documentation
             * recommended all #GInitable implementations should be idempotent; that
             * recommendation was relaxed in GLib 2.54.
             *
             * If a class explicitly supports being initialized multiple times, it is
             * recommended that the method is idempotent: multiple calls with the same
             * arguments should return the same results. Only the first call initializes
             * the object; further calls return the result of the first call.
             *
             * One reason why a class might need to support idempotent initialization is if
             * it is designed to be used via the singleton pattern, with a
             * #GObjectClass.constructor that sometimes returns an existing instance.
             * In this pattern, a caller would expect to be able to call g_initable_init()
             * on the result of g_object_new(), regardless of whether it is in fact a new
             * instance.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            vfunc_init(cancellable?: Cancellable | null): boolean;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace ConverterInputStream {
            // Constructor properties interface

            interface ConstructorProps
                extends FilterInputStream.ConstructorProps,
                    PollableInputStream.ConstructorProps {
                converter: Converter;
            }
        }

        /**
         * Converter input stream implements [class`Gio`.InputStream] and allows
         * conversion of data of various types during reading.
         *
         * As of GLib 2.34, `GConverterInputStream` implements
         * [iface`Gio`.PollableInputStream].
         */
        class ConverterInputStream extends FilterInputStream implements PollableInputStream {
            static $gtype: GObject.GType<ConverterInputStream>;

            // Properties

            /**
             * The converter object.
             */
            get converter(): Converter;

            // Constructors

            constructor(properties?: Partial<ConverterInputStream.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](base_stream: InputStream, converter: Converter): ConverterInputStream;

            // Methods

            /**
             * Gets the #GConverter that is used by `converter_stream`.
             * @returns the converter of the converter input stream
             */
            get_converter(): Converter;

            // Inherited methods
            /**
             * Checks if `stream` is actually pollable. Some classes may implement
             * #GPollableInputStream but have only certain instances of that class
             * be pollable. If this method returns %FALSE, then the behavior of
             * other #GPollableInputStream methods is undefined.
             *
             * For any given stream, the value returned by this method is constant;
             * a stream cannot switch from pollable to non-pollable or vice versa.
             * @returns %TRUE if @stream is pollable, %FALSE if not.
             */
            can_poll(): boolean;
            /**
             * Creates a #GSource that triggers when `stream` can be read, or
             * `cancellable` is triggered or an error occurs. The callback on the
             * source is of the #GPollableSourceFunc type.
             *
             * As with g_pollable_input_stream_is_readable(), it is possible that
             * the stream may not actually be readable even after the source
             * triggers, so you should use g_pollable_input_stream_read_nonblocking()
             * rather than g_input_stream_read() from the callback.
             *
             * The behaviour of this method is undefined if
             * g_pollable_input_stream_can_poll() returns %FALSE for `stream`.
             * @param cancellable a #GCancellable, or %NULL
             * @returns a new #GSource
             */
            create_source(cancellable?: Cancellable | null): GLib.Source;
            /**
             * Checks if `stream` can be read.
             *
             * Note that some stream types may not be able to implement this 100%
             * reliably, and it is possible that a call to g_input_stream_read()
             * after this returns %TRUE would still block. To guarantee
             * non-blocking behavior, you should always use
             * g_pollable_input_stream_read_nonblocking(), which will return a
             * %G_IO_ERROR_WOULD_BLOCK error rather than blocking.
             *
             * The behaviour of this method is undefined if
             * g_pollable_input_stream_can_poll() returns %FALSE for `stream`.
             * @returns %TRUE if @stream is readable, %FALSE if not. If an error   has occurred on @stream, this will result in   g_pollable_input_stream_is_readable() returning %TRUE, and the   next attempt to read will return the error.
             */
            is_readable(): boolean;
            /**
             * Attempts to read up to `count` bytes from `stream` into `buffer,` as
             * with g_input_stream_read(). If `stream` is not currently readable,
             * this will immediately return %G_IO_ERROR_WOULD_BLOCK, and you can
             * use g_pollable_input_stream_create_source() to create a #GSource
             * that will be triggered when `stream` is readable.
             *
             * Note that since this method never blocks, you cannot actually
             * use `cancellable` to cancel it. However, it will return an error
             * if `cancellable` has already been cancelled when you call, which
             * may happen if you call this method after a source triggers due
             * to having been cancelled.
             *
             * The behaviour of this method is undefined if
             * g_pollable_input_stream_can_poll() returns %FALSE for `stream`.
             * @param cancellable a #GCancellable, or %NULL
             * @returns the number of bytes read, or -1 on error (including   %G_IO_ERROR_WOULD_BLOCK).
             */
            read_nonblocking(cancellable?: Cancellable | null): [number, Uint8Array];
            /**
             * Checks if `stream` is actually pollable. Some classes may implement
             * #GPollableInputStream but have only certain instances of that class
             * be pollable. If this method returns %FALSE, then the behavior of
             * other #GPollableInputStream methods is undefined.
             *
             * For any given stream, the value returned by this method is constant;
             * a stream cannot switch from pollable to non-pollable or vice versa.
             */
            vfunc_can_poll(): boolean;
            /**
             * Creates a #GSource that triggers when `stream` can be read, or
             * `cancellable` is triggered or an error occurs. The callback on the
             * source is of the #GPollableSourceFunc type.
             *
             * As with g_pollable_input_stream_is_readable(), it is possible that
             * the stream may not actually be readable even after the source
             * triggers, so you should use g_pollable_input_stream_read_nonblocking()
             * rather than g_input_stream_read() from the callback.
             *
             * The behaviour of this method is undefined if
             * g_pollable_input_stream_can_poll() returns %FALSE for `stream`.
             * @param cancellable a #GCancellable, or %NULL
             */
            vfunc_create_source(cancellable?: Cancellable | null): GLib.Source;
            /**
             * Checks if `stream` can be read.
             *
             * Note that some stream types may not be able to implement this 100%
             * reliably, and it is possible that a call to g_input_stream_read()
             * after this returns %TRUE would still block. To guarantee
             * non-blocking behavior, you should always use
             * g_pollable_input_stream_read_nonblocking(), which will return a
             * %G_IO_ERROR_WOULD_BLOCK error rather than blocking.
             *
             * The behaviour of this method is undefined if
             * g_pollable_input_stream_can_poll() returns %FALSE for `stream`.
             */
            vfunc_is_readable(): boolean;
            /**
             * Attempts to read up to `count` bytes from `stream` into `buffer,` as
             * with g_input_stream_read(). If `stream` is not currently readable,
             * this will immediately return %G_IO_ERROR_WOULD_BLOCK, and you can
             * use g_pollable_input_stream_create_source() to create a #GSource
             * that will be triggered when `stream` is readable.
             *
             * Note that since this method never blocks, you cannot actually
             * use `cancellable` to cancel it. However, it will return an error
             * if `cancellable` has already been cancelled when you call, which
             * may happen if you call this method after a source triggers due
             * to having been cancelled.
             *
             * The behaviour of this method is undefined if
             * g_pollable_input_stream_can_poll() returns %FALSE for `stream`.
             */
            vfunc_read_nonblocking(): [number, Uint8Array | null];
            /**
             * Clears the pending flag on `stream`.
             */
            clear_pending(): void;
            /**
             * Closes the stream, releasing resources related to it.
             *
             * Once the stream is closed, all other operations will return %G_IO_ERROR_CLOSED.
             * Closing a stream multiple times will not return an error.
             *
             * Streams will be automatically closed when the last reference
             * is dropped, but you might want to call this function to make sure
             * resources are released as early as possible.
             *
             * Some streams might keep the backing store of the stream (e.g. a file descriptor)
             * open after the stream is closed. See the documentation for the individual
             * stream for details.
             *
             * On failure the first error that happened will be reported, but the close
             * operation will finish as much as possible. A stream that failed to
             * close will still return %G_IO_ERROR_CLOSED for all operations. Still, it
             * is important to check and report the error to the user.
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
             * Cancelling a close will still leave the stream closed, but some streams
             * can use a faster close that doesn't block to e.g. check errors.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @returns %TRUE on success, %FALSE on failure
             */
            close(cancellable?: Cancellable | null): boolean;
            /**
             * Requests an asynchronous closes of the stream, releasing resources related to it.
             * When the operation is finished `callback` will be called.
             * You can then call g_input_stream_close_finish() to get the result of the
             * operation.
             *
             * For behaviour details see g_input_stream_close().
             *
             * The asynchronous methods have a default fallback that uses threads to implement
             * asynchronicity, so they are optional for inheriting classes. However, if you
             * override one you must override all.
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional cancellable object
             */
            close_async(io_priority: number, cancellable?: Cancellable | null): Promise<boolean>;
            /**
             * Requests an asynchronous closes of the stream, releasing resources related to it.
             * When the operation is finished `callback` will be called.
             * You can then call g_input_stream_close_finish() to get the result of the
             * operation.
             *
             * For behaviour details see g_input_stream_close().
             *
             * The asynchronous methods have a default fallback that uses threads to implement
             * asynchronicity, so they are optional for inheriting classes. However, if you
             * override one you must override all.
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional cancellable object
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            close_async(
                io_priority: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Requests an asynchronous closes of the stream, releasing resources related to it.
             * When the operation is finished `callback` will be called.
             * You can then call g_input_stream_close_finish() to get the result of the
             * operation.
             *
             * For behaviour details see g_input_stream_close().
             *
             * The asynchronous methods have a default fallback that uses threads to implement
             * asynchronicity, so they are optional for inheriting classes. However, if you
             * override one you must override all.
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional cancellable object
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            close_async(
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<boolean> | void;
            /**
             * Finishes closing a stream asynchronously, started from g_input_stream_close_async().
             * @param result a #GAsyncResult.
             * @returns %TRUE if the stream was closed successfully.
             */
            close_finish(result: AsyncResult): boolean;
            /**
             * Checks if an input stream has pending actions.
             * @returns %TRUE if @stream has pending actions.
             */
            has_pending(): boolean;
            /**
             * Checks if an input stream is closed.
             * @returns %TRUE if the stream is closed.
             */
            is_closed(): boolean;
            /**
             * Tries to read `count` bytes from the stream into the buffer starting at
             * `buffer`. Will block during this read.
             *
             * If count is zero returns zero and does nothing. A value of `count`
             * larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the number of bytes read into the buffer is returned.
             * It is not an error if this is not the same as the requested size, as it
             * can happen e.g. near the end of a file. Zero is returned on end of file
             * (or if `count` is zero),  but never otherwise.
             *
             * The returned `buffer` is not a nul-terminated string, it can contain nul bytes
             * at any position, and this function doesn't nul-terminate the `buffer`.
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
             * operation was partially finished when the operation was cancelled the
             * partial result will be returned, without an error.
             *
             * On error -1 is returned and `error` is set accordingly.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @returns Number of bytes read, or -1 on error, or 0 on end of file.
             */
            read(cancellable?: Cancellable | null): [number, Uint8Array];
            /**
             * Tries to read `count` bytes from the stream into the buffer starting at
             * `buffer`. Will block during this read.
             *
             * This function is similar to g_input_stream_read(), except it tries to
             * read as many bytes as requested, only stopping on an error or end of stream.
             *
             * On a successful read of `count` bytes, or if we reached the end of the
             * stream,  %TRUE is returned, and `bytes_read` is set to the number of bytes
             * read into `buffer`.
             *
             * If there is an error during the operation %FALSE is returned and `error`
             * is set to indicate the error status.
             *
             * As a special exception to the normal conventions for functions that
             * use #GError, if this function returns %FALSE (and sets `error)` then
             * `bytes_read` will be set to the number of bytes that were successfully
             * read before the error was encountered.  This functionality is only
             * available from C.  If you need it from another language then you must
             * write your own loop around g_input_stream_read().
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @returns %TRUE on success, %FALSE if there was an error
             */
            read_all(cancellable?: Cancellable | null): [boolean, Uint8Array, number];
            /**
             * Request an asynchronous read of `count` bytes from the stream into the
             * buffer starting at `buffer`.
             *
             * This is the asynchronous equivalent of [method`InputStream`.read_all].
             *
             * Call [method`InputStream`.read_all_finish] to collect the result.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional #GCancellable object, %NULL to ignore
             */
            read_all_async(io_priority: number, cancellable?: Cancellable | null): [Promise<number>, Uint8Array];
            /**
             * Request an asynchronous read of `count` bytes from the stream into the
             * buffer starting at `buffer`.
             *
             * This is the asynchronous equivalent of [method`InputStream`.read_all].
             *
             * Call [method`InputStream`.read_all_finish] to collect the result.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional #GCancellable object, %NULL to ignore
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            read_all_async(
                io_priority: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): Uint8Array;
            /**
             * Request an asynchronous read of `count` bytes from the stream into the
             * buffer starting at `buffer`.
             *
             * This is the asynchronous equivalent of [method`InputStream`.read_all].
             *
             * Call [method`InputStream`.read_all_finish] to collect the result.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional #GCancellable object, %NULL to ignore
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            read_all_async(
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): [Promise<number> | void, Uint8Array];
            /**
             * Finishes an asynchronous stream read operation started with
             * [method`InputStream`.read_all_async].
             *
             * As a special exception to the normal conventions for functions that
             * use #GError, if this function returns %FALSE (and sets `error)` then
             * `bytes_read` will be set to the number of bytes that were successfully
             * read before the error was encountered.  This functionality is only
             * available from C.  If you need it from another language then you must
             * write your own loop around g_input_stream_read_async().
             * @param result a #GAsyncResult
             * @returns %TRUE on success, %FALSE if there was an error
             */
            read_all_finish(result: AsyncResult): [boolean, number];
            /**
             * Request an asynchronous read of `count` bytes from the stream into the buffer
             * starting at `buffer`. When the operation is finished `callback` will be called.
             * You can then call g_input_stream_read_finish() to get the result of the
             * operation.
             *
             * During an async request no other sync and async calls are allowed on `stream,` and will
             * result in %G_IO_ERROR_PENDING errors.
             *
             * A value of `count` larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the number of bytes read into the buffer will be passed to the
             * callback. It is not an error if this is not the same as the requested size, as it
             * can happen e.g. near the end of a file, but generally we try to read
             * as many bytes as requested. Zero is returned on end of file
             * (or if `count` is zero),  but never otherwise.
             *
             * Any outstanding i/o request with higher priority (lower numerical value) will
             * be executed before an outstanding request with lower priority. Default
             * priority is %G_PRIORITY_DEFAULT.
             *
             * The asynchronous methods have a default fallback that uses threads to implement
             * asynchronicity, so they are optional for inheriting classes. However, if you
             * override one you must override all.
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            read_async(io_priority: number, cancellable?: Cancellable | null): [Promise<number>, Uint8Array];
            /**
             * Request an asynchronous read of `count` bytes from the stream into the buffer
             * starting at `buffer`. When the operation is finished `callback` will be called.
             * You can then call g_input_stream_read_finish() to get the result of the
             * operation.
             *
             * During an async request no other sync and async calls are allowed on `stream,` and will
             * result in %G_IO_ERROR_PENDING errors.
             *
             * A value of `count` larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the number of bytes read into the buffer will be passed to the
             * callback. It is not an error if this is not the same as the requested size, as it
             * can happen e.g. near the end of a file, but generally we try to read
             * as many bytes as requested. Zero is returned on end of file
             * (or if `count` is zero),  but never otherwise.
             *
             * Any outstanding i/o request with higher priority (lower numerical value) will
             * be executed before an outstanding request with lower priority. Default
             * priority is %G_PRIORITY_DEFAULT.
             *
             * The asynchronous methods have a default fallback that uses threads to implement
             * asynchronicity, so they are optional for inheriting classes. However, if you
             * override one you must override all.
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            read_async(
                io_priority: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): Uint8Array;
            /**
             * Request an asynchronous read of `count` bytes from the stream into the buffer
             * starting at `buffer`. When the operation is finished `callback` will be called.
             * You can then call g_input_stream_read_finish() to get the result of the
             * operation.
             *
             * During an async request no other sync and async calls are allowed on `stream,` and will
             * result in %G_IO_ERROR_PENDING errors.
             *
             * A value of `count` larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the number of bytes read into the buffer will be passed to the
             * callback. It is not an error if this is not the same as the requested size, as it
             * can happen e.g. near the end of a file, but generally we try to read
             * as many bytes as requested. Zero is returned on end of file
             * (or if `count` is zero),  but never otherwise.
             *
             * Any outstanding i/o request with higher priority (lower numerical value) will
             * be executed before an outstanding request with lower priority. Default
             * priority is %G_PRIORITY_DEFAULT.
             *
             * The asynchronous methods have a default fallback that uses threads to implement
             * asynchronicity, so they are optional for inheriting classes. However, if you
             * override one you must override all.
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            read_async(
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): [Promise<number> | void, Uint8Array];
            /**
             * Like g_input_stream_read(), this tries to read `count` bytes from
             * the stream in a blocking fashion. However, rather than reading into
             * a user-supplied buffer, this will create a new #GBytes containing
             * the data that was read. This may be easier to use from language
             * bindings.
             *
             * If count is zero, returns a zero-length #GBytes and does nothing. A
             * value of `count` larger than %G_MAXSSIZE will cause a
             * %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, a new #GBytes is returned. It is not an error if the
             * size of this object is not the same as the requested size, as it
             * can happen e.g. near the end of a file. A zero-length #GBytes is
             * returned on end of file (or if `count` is zero), but never
             * otherwise.
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
             * operation was partially finished when the operation was cancelled the
             * partial result will be returned, without an error.
             *
             * On error %NULL is returned and `error` is set accordingly.
             * @param count maximum number of bytes that will be read from the stream. Common values include 4096 and 8192.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @returns a new #GBytes, or %NULL on error
             */
            read_bytes(count: number, cancellable?: Cancellable | null): GLib.Bytes;
            /**
             * Request an asynchronous read of `count` bytes from the stream into a
             * new #GBytes. When the operation is finished `callback` will be
             * called. You can then call g_input_stream_read_bytes_finish() to get the
             * result of the operation.
             *
             * During an async request no other sync and async calls are allowed
             * on `stream,` and will result in %G_IO_ERROR_PENDING errors.
             *
             * A value of `count` larger than %G_MAXSSIZE will cause a
             * %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the new #GBytes will be passed to the callback. It is
             * not an error if this is smaller than the requested size, as it can
             * happen e.g. near the end of a file, but generally we try to read as
             * many bytes as requested. Zero is returned on end of file (or if
             * `count` is zero), but never otherwise.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             * @param count the number of bytes that will be read from the stream
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            read_bytes_async(count: number, io_priority: number, cancellable?: Cancellable | null): Promise<GLib.Bytes>;
            /**
             * Request an asynchronous read of `count` bytes from the stream into a
             * new #GBytes. When the operation is finished `callback` will be
             * called. You can then call g_input_stream_read_bytes_finish() to get the
             * result of the operation.
             *
             * During an async request no other sync and async calls are allowed
             * on `stream,` and will result in %G_IO_ERROR_PENDING errors.
             *
             * A value of `count` larger than %G_MAXSSIZE will cause a
             * %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the new #GBytes will be passed to the callback. It is
             * not an error if this is smaller than the requested size, as it can
             * happen e.g. near the end of a file, but generally we try to read as
             * many bytes as requested. Zero is returned on end of file (or if
             * `count` is zero), but never otherwise.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             * @param count the number of bytes that will be read from the stream
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            read_bytes_async(
                count: number,
                io_priority: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Request an asynchronous read of `count` bytes from the stream into a
             * new #GBytes. When the operation is finished `callback` will be
             * called. You can then call g_input_stream_read_bytes_finish() to get the
             * result of the operation.
             *
             * During an async request no other sync and async calls are allowed
             * on `stream,` and will result in %G_IO_ERROR_PENDING errors.
             *
             * A value of `count` larger than %G_MAXSSIZE will cause a
             * %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the new #GBytes will be passed to the callback. It is
             * not an error if this is smaller than the requested size, as it can
             * happen e.g. near the end of a file, but generally we try to read as
             * many bytes as requested. Zero is returned on end of file (or if
             * `count` is zero), but never otherwise.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             * @param count the number of bytes that will be read from the stream
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            read_bytes_async(
                count: number,
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<GLib.Bytes> | void;
            /**
             * Finishes an asynchronous stream read-into-#GBytes operation.
             * @param result a #GAsyncResult.
             * @returns the newly-allocated #GBytes, or %NULL on error
             */
            read_bytes_finish(result: AsyncResult): GLib.Bytes;
            /**
             * Finishes an asynchronous stream read operation.
             * @param result a #GAsyncResult.
             * @returns number of bytes read in, or -1 on error, or 0 on end of file.
             */
            read_finish(result: AsyncResult): number;
            /**
             * Sets `stream` to have actions pending. If the pending flag is
             * already set or `stream` is closed, it will return %FALSE and set
             * `error`.
             * @returns %TRUE if pending was previously unset and is now set.
             */
            set_pending(): boolean;
            /**
             * Tries to skip `count` bytes from the stream. Will block during the operation.
             *
             * This is identical to g_input_stream_read(), from a behaviour standpoint,
             * but the bytes that are skipped are not returned to the user. Some
             * streams have an implementation that is more efficient than reading the data.
             *
             * This function is optional for inherited classes, as the default implementation
             * emulates it using read.
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
             * operation was partially finished when the operation was cancelled the
             * partial result will be returned, without an error.
             * @param count the number of bytes that will be skipped from the stream
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @returns Number of bytes skipped, or -1 on error
             */
            skip(count: number, cancellable?: Cancellable | null): number;
            /**
             * Request an asynchronous skip of `count` bytes from the stream.
             * When the operation is finished `callback` will be called.
             * You can then call g_input_stream_skip_finish() to get the result
             * of the operation.
             *
             * During an async request no other sync and async calls are allowed,
             * and will result in %G_IO_ERROR_PENDING errors.
             *
             * A value of `count` larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the number of bytes skipped will be passed to the callback.
             * It is not an error if this is not the same as the requested size, as it
             * can happen e.g. near the end of a file, but generally we try to skip
             * as many bytes as requested. Zero is returned on end of file
             * (or if `count` is zero), but never otherwise.
             *
             * Any outstanding i/o request with higher priority (lower numerical value)
             * will be executed before an outstanding request with lower priority.
             * Default priority is %G_PRIORITY_DEFAULT.
             *
             * The asynchronous methods have a default fallback that uses threads to
             * implement asynchronicity, so they are optional for inheriting classes.
             * However, if you override one, you must override all.
             * @param count the number of bytes that will be skipped from the stream
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            skip_async(count: number, io_priority: number, cancellable?: Cancellable | null): Promise<number>;
            /**
             * Request an asynchronous skip of `count` bytes from the stream.
             * When the operation is finished `callback` will be called.
             * You can then call g_input_stream_skip_finish() to get the result
             * of the operation.
             *
             * During an async request no other sync and async calls are allowed,
             * and will result in %G_IO_ERROR_PENDING errors.
             *
             * A value of `count` larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the number of bytes skipped will be passed to the callback.
             * It is not an error if this is not the same as the requested size, as it
             * can happen e.g. near the end of a file, but generally we try to skip
             * as many bytes as requested. Zero is returned on end of file
             * (or if `count` is zero), but never otherwise.
             *
             * Any outstanding i/o request with higher priority (lower numerical value)
             * will be executed before an outstanding request with lower priority.
             * Default priority is %G_PRIORITY_DEFAULT.
             *
             * The asynchronous methods have a default fallback that uses threads to
             * implement asynchronicity, so they are optional for inheriting classes.
             * However, if you override one, you must override all.
             * @param count the number of bytes that will be skipped from the stream
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            skip_async(
                count: number,
                io_priority: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Request an asynchronous skip of `count` bytes from the stream.
             * When the operation is finished `callback` will be called.
             * You can then call g_input_stream_skip_finish() to get the result
             * of the operation.
             *
             * During an async request no other sync and async calls are allowed,
             * and will result in %G_IO_ERROR_PENDING errors.
             *
             * A value of `count` larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the number of bytes skipped will be passed to the callback.
             * It is not an error if this is not the same as the requested size, as it
             * can happen e.g. near the end of a file, but generally we try to skip
             * as many bytes as requested. Zero is returned on end of file
             * (or if `count` is zero), but never otherwise.
             *
             * Any outstanding i/o request with higher priority (lower numerical value)
             * will be executed before an outstanding request with lower priority.
             * Default priority is %G_PRIORITY_DEFAULT.
             *
             * The asynchronous methods have a default fallback that uses threads to
             * implement asynchronicity, so they are optional for inheriting classes.
             * However, if you override one, you must override all.
             * @param count the number of bytes that will be skipped from the stream
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            skip_async(
                count: number,
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<number> | void;
            /**
             * Finishes a stream skip operation.
             * @param result a #GAsyncResult.
             * @returns the size of the bytes skipped, or `-1` on error.
             */
            skip_finish(result: AsyncResult): number;
            /**
             * Requests an asynchronous closes of the stream, releasing resources related to it.
             * When the operation is finished `callback` will be called.
             * You can then call g_input_stream_close_finish() to get the result of the
             * operation.
             *
             * For behaviour details see g_input_stream_close().
             *
             * The asynchronous methods have a default fallback that uses threads to implement
             * asynchronicity, so they are optional for inheriting classes. However, if you
             * override one you must override all.
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional cancellable object
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            vfunc_close_async(
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Finishes closing a stream asynchronously, started from g_input_stream_close_async().
             * @param result a #GAsyncResult.
             */
            vfunc_close_finish(result: AsyncResult): boolean;
            vfunc_close_fn(cancellable?: Cancellable | null): boolean;
            /**
             * Request an asynchronous read of `count` bytes from the stream into the buffer
             * starting at `buffer`. When the operation is finished `callback` will be called.
             * You can then call g_input_stream_read_finish() to get the result of the
             * operation.
             *
             * During an async request no other sync and async calls are allowed on `stream,` and will
             * result in %G_IO_ERROR_PENDING errors.
             *
             * A value of `count` larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the number of bytes read into the buffer will be passed to the
             * callback. It is not an error if this is not the same as the requested size, as it
             * can happen e.g. near the end of a file, but generally we try to read
             * as many bytes as requested. Zero is returned on end of file
             * (or if `count` is zero),  but never otherwise.
             *
             * Any outstanding i/o request with higher priority (lower numerical value) will
             * be executed before an outstanding request with lower priority. Default
             * priority is %G_PRIORITY_DEFAULT.
             *
             * The asynchronous methods have a default fallback that uses threads to implement
             * asynchronicity, so they are optional for inheriting classes. However, if you
             * override one you must override all.
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            vfunc_read_async(
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Uint8Array | null;
            /**
             * Finishes an asynchronous stream read operation.
             * @param result a #GAsyncResult.
             */
            vfunc_read_finish(result: AsyncResult): number;
            vfunc_read_fn(buffer: any | null, count: number, cancellable?: Cancellable | null): number;
            /**
             * Tries to skip `count` bytes from the stream. Will block during the operation.
             *
             * This is identical to g_input_stream_read(), from a behaviour standpoint,
             * but the bytes that are skipped are not returned to the user. Some
             * streams have an implementation that is more efficient than reading the data.
             *
             * This function is optional for inherited classes, as the default implementation
             * emulates it using read.
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
             * operation was partially finished when the operation was cancelled the
             * partial result will be returned, without an error.
             * @param count the number of bytes that will be skipped from the stream
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            vfunc_skip(count: number, cancellable?: Cancellable | null): number;
            /**
             * Request an asynchronous skip of `count` bytes from the stream.
             * When the operation is finished `callback` will be called.
             * You can then call g_input_stream_skip_finish() to get the result
             * of the operation.
             *
             * During an async request no other sync and async calls are allowed,
             * and will result in %G_IO_ERROR_PENDING errors.
             *
             * A value of `count` larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the number of bytes skipped will be passed to the callback.
             * It is not an error if this is not the same as the requested size, as it
             * can happen e.g. near the end of a file, but generally we try to skip
             * as many bytes as requested. Zero is returned on end of file
             * (or if `count` is zero), but never otherwise.
             *
             * Any outstanding i/o request with higher priority (lower numerical value)
             * will be executed before an outstanding request with lower priority.
             * Default priority is %G_PRIORITY_DEFAULT.
             *
             * The asynchronous methods have a default fallback that uses threads to
             * implement asynchronicity, so they are optional for inheriting classes.
             * However, if you override one, you must override all.
             * @param count the number of bytes that will be skipped from the stream
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the request
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            vfunc_skip_async(
                count: number,
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Finishes a stream skip operation.
             * @param result a #GAsyncResult.
             */
            vfunc_skip_finish(result: AsyncResult): number;
            /**
             * Creates an asynchronous iterator for a Gio.InputStream that reads the stream in chunks.
             *
             * Each iteration will return a GLib.Bytes object containing at most `count` bytes (default 4096). The iterator will end when the stream is exhausted.
             *
             * Example:
             * ```js
             * import Gio from "gi://Gio";
             *
             * const textDecoder = new TextDecoder("utf-8");
             *
             * const file = Gio.File.new_for_path("/etc/os-release");
             * const inputStream = file.read(null);
             *
             * for await (const bytes of inputStream.createAsyncIterator(4)) {
             *   log(textDecoder.decode(bytes.toArray()));
             * }
             * ```
             *
             * `returns` An async iterator yielding GLib.Bytes objects
             * @param count Maximum number of bytes to read per chunk (default: 4096)
             * @param priority I/O priority of the request (default: GLib.PRIORITY_DEFAULT)
             */
            createAsyncIterator(count?: number, priority?: number): AsyncIterableIterator<GLib.Bytes>;
            /**
             * Creates a synchronous iterator for a Gio.InputStream that reads the stream in chunks.
             *
             * Each iteration will return a GLib.Bytes object containing at most `count` bytes (default 4096). The iterator will end when the stream is exhausted.
             *
             * Example:
             * ```js
             * import Gio from "gi://Gio";
             *
             * const textDecoder = new TextDecoder("utf-8");
             *
             * const file = Gio.File.new_for_path("/etc/os-release");
             * const inputStream = file.read(null);
             *
             * for (const bytes of inputStream.createSyncIterator(4)) {
             *   log(textDecoder.decode(bytes.toArray()));
             * }
             * ```
             *
             * `returns` An iterable yielding GLib.Bytes objects
             * @param count Maximum number of bytes to read per chunk (default: 4096)
             * @param priority I/O priority of the request (default: GLib.PRIORITY_DEFAULT)
             */
            createSyncIterator(count?: number, priority?: number): IterableIterator<GLib.Bytes>;
        }

        namespace ConverterOutputStream {
            // Constructor properties interface

            interface ConstructorProps
                extends FilterOutputStream.ConstructorProps,
                    PollableOutputStream.ConstructorProps {
                converter: Converter;
            }
        }

        /**
         * Converter output stream implements [class`Gio`.OutputStream] and allows
         * conversion of data of various types during reading.
         *
         * As of GLib 2.34, `GConverterOutputStream` implements
         * [iface`Gio`.PollableOutputStream].
         */
        class ConverterOutputStream extends FilterOutputStream implements PollableOutputStream {
            static $gtype: GObject.GType<ConverterOutputStream>;

            // Properties

            /**
             * The converter object.
             */
            get converter(): Converter;

            // Constructors

            constructor(properties?: Partial<ConverterOutputStream.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](base_stream: OutputStream, converter: Converter): ConverterOutputStream;

            // Methods

            /**
             * Gets the #GConverter that is used by `converter_stream`.
             * @returns the converter of the converter output stream
             */
            get_converter(): Converter;

            // Inherited methods
            /**
             * Checks if `stream` is actually pollable. Some classes may implement
             * #GPollableOutputStream but have only certain instances of that
             * class be pollable. If this method returns %FALSE, then the behavior
             * of other #GPollableOutputStream methods is undefined.
             *
             * For any given stream, the value returned by this method is constant;
             * a stream cannot switch from pollable to non-pollable or vice versa.
             * @returns %TRUE if @stream is pollable, %FALSE if not.
             */
            can_poll(): boolean;
            /**
             * Creates a #GSource that triggers when `stream` can be written, or
             * `cancellable` is triggered or an error occurs. The callback on the
             * source is of the #GPollableSourceFunc type.
             *
             * As with g_pollable_output_stream_is_writable(), it is possible that
             * the stream may not actually be writable even after the source
             * triggers, so you should use g_pollable_output_stream_write_nonblocking()
             * rather than g_output_stream_write() from the callback.
             *
             * The behaviour of this method is undefined if
             * g_pollable_output_stream_can_poll() returns %FALSE for `stream`.
             * @param cancellable a #GCancellable, or %NULL
             * @returns a new #GSource
             */
            create_source(cancellable?: Cancellable | null): GLib.Source;
            /**
             * Checks if `stream` can be written.
             *
             * Note that some stream types may not be able to implement this 100%
             * reliably, and it is possible that a call to g_output_stream_write()
             * after this returns %TRUE would still block. To guarantee
             * non-blocking behavior, you should always use
             * g_pollable_output_stream_write_nonblocking(), which will return a
             * %G_IO_ERROR_WOULD_BLOCK error rather than blocking.
             *
             * The behaviour of this method is undefined if
             * g_pollable_output_stream_can_poll() returns %FALSE for `stream`.
             * @returns %TRUE if @stream is writable, %FALSE if not. If an error   has occurred on @stream, this will result in   g_pollable_output_stream_is_writable() returning %TRUE, and the   next attempt to write will return the error.
             */
            is_writable(): boolean;
            /**
             * Attempts to write up to `count` bytes from `buffer` to `stream,` as
             * with g_output_stream_write(). If `stream` is not currently writable,
             * this will immediately return %G_IO_ERROR_WOULD_BLOCK, and you can
             * use g_pollable_output_stream_create_source() to create a #GSource
             * that will be triggered when `stream` is writable.
             *
             * Note that since this method never blocks, you cannot actually
             * use `cancellable` to cancel it. However, it will return an error
             * if `cancellable` has already been cancelled when you call, which
             * may happen if you call this method after a source triggers due
             * to having been cancelled.
             *
             * Also note that if %G_IO_ERROR_WOULD_BLOCK is returned some underlying
             * transports like D/TLS require that you re-send the same `buffer` and
             * `count` in the next write call.
             *
             * The behaviour of this method is undefined if
             * g_pollable_output_stream_can_poll() returns %FALSE for `stream`.
             * @param buffer a buffer to write     data from
             * @param cancellable a #GCancellable, or %NULL
             * @returns the number of bytes written, or -1 on error (including   %G_IO_ERROR_WOULD_BLOCK).
             */
            write_nonblocking(buffer: Uint8Array | string, cancellable?: Cancellable | null): number;
            /**
             * Attempts to write the bytes contained in the `n_vectors` `vectors` to `stream,`
             * as with g_output_stream_writev(). If `stream` is not currently writable,
             * this will immediately return %`G_POLLABLE_RETURN_WOULD_BLOCK,` and you can
             * use g_pollable_output_stream_create_source() to create a #GSource
             * that will be triggered when `stream` is writable. `error` will *not* be
             * set in that case.
             *
             * Note that since this method never blocks, you cannot actually
             * use `cancellable` to cancel it. However, it will return an error
             * if `cancellable` has already been cancelled when you call, which
             * may happen if you call this method after a source triggers due
             * to having been cancelled.
             *
             * Also note that if %G_POLLABLE_RETURN_WOULD_BLOCK is returned some underlying
             * transports like D/TLS require that you re-send the same `vectors` and
             * `n_vectors` in the next write call.
             *
             * The behaviour of this method is undefined if
             * g_pollable_output_stream_can_poll() returns %FALSE for `stream`.
             * @param vectors the buffer containing the #GOutputVectors to write.
             * @param cancellable a #GCancellable, or %NULL
             * @returns %@G_POLLABLE_RETURN_OK on success, %G_POLLABLE_RETURN_WOULD_BLOCK if the stream is not currently writable (and @error is *not* set), or %G_POLLABLE_RETURN_FAILED if there was an error in which case @error will be set.
             */
            writev_nonblocking(vectors: OutputVector[], cancellable?: Cancellable | null): [PollableReturn, number];
            /**
             * Checks if `stream` is actually pollable. Some classes may implement
             * #GPollableOutputStream but have only certain instances of that
             * class be pollable. If this method returns %FALSE, then the behavior
             * of other #GPollableOutputStream methods is undefined.
             *
             * For any given stream, the value returned by this method is constant;
             * a stream cannot switch from pollable to non-pollable or vice versa.
             */
            vfunc_can_poll(): boolean;
            /**
             * Creates a #GSource that triggers when `stream` can be written, or
             * `cancellable` is triggered or an error occurs. The callback on the
             * source is of the #GPollableSourceFunc type.
             *
             * As with g_pollable_output_stream_is_writable(), it is possible that
             * the stream may not actually be writable even after the source
             * triggers, so you should use g_pollable_output_stream_write_nonblocking()
             * rather than g_output_stream_write() from the callback.
             *
             * The behaviour of this method is undefined if
             * g_pollable_output_stream_can_poll() returns %FALSE for `stream`.
             * @param cancellable a #GCancellable, or %NULL
             */
            vfunc_create_source(cancellable?: Cancellable | null): GLib.Source;
            /**
             * Checks if `stream` can be written.
             *
             * Note that some stream types may not be able to implement this 100%
             * reliably, and it is possible that a call to g_output_stream_write()
             * after this returns %TRUE would still block. To guarantee
             * non-blocking behavior, you should always use
             * g_pollable_output_stream_write_nonblocking(), which will return a
             * %G_IO_ERROR_WOULD_BLOCK error rather than blocking.
             *
             * The behaviour of this method is undefined if
             * g_pollable_output_stream_can_poll() returns %FALSE for `stream`.
             */
            vfunc_is_writable(): boolean;
            /**
             * Attempts to write up to `count` bytes from `buffer` to `stream,` as
             * with g_output_stream_write(). If `stream` is not currently writable,
             * this will immediately return %G_IO_ERROR_WOULD_BLOCK, and you can
             * use g_pollable_output_stream_create_source() to create a #GSource
             * that will be triggered when `stream` is writable.
             *
             * Note that since this method never blocks, you cannot actually
             * use `cancellable` to cancel it. However, it will return an error
             * if `cancellable` has already been cancelled when you call, which
             * may happen if you call this method after a source triggers due
             * to having been cancelled.
             *
             * Also note that if %G_IO_ERROR_WOULD_BLOCK is returned some underlying
             * transports like D/TLS require that you re-send the same `buffer` and
             * `count` in the next write call.
             *
             * The behaviour of this method is undefined if
             * g_pollable_output_stream_can_poll() returns %FALSE for `stream`.
             * @param buffer a buffer to write     data from
             */
            vfunc_write_nonblocking(buffer?: Uint8Array | null): number;
            /**
             * Attempts to write the bytes contained in the `n_vectors` `vectors` to `stream,`
             * as with g_output_stream_writev(). If `stream` is not currently writable,
             * this will immediately return %`G_POLLABLE_RETURN_WOULD_BLOCK,` and you can
             * use g_pollable_output_stream_create_source() to create a #GSource
             * that will be triggered when `stream` is writable. `error` will *not* be
             * set in that case.
             *
             * Note that since this method never blocks, you cannot actually
             * use `cancellable` to cancel it. However, it will return an error
             * if `cancellable` has already been cancelled when you call, which
             * may happen if you call this method after a source triggers due
             * to having been cancelled.
             *
             * Also note that if %G_POLLABLE_RETURN_WOULD_BLOCK is returned some underlying
             * transports like D/TLS require that you re-send the same `vectors` and
             * `n_vectors` in the next write call.
             *
             * The behaviour of this method is undefined if
             * g_pollable_output_stream_can_poll() returns %FALSE for `stream`.
             * @param vectors the buffer containing the #GOutputVectors to write.
             */
            vfunc_writev_nonblocking(vectors: OutputVector[]): [PollableReturn, number];
            /**
             * Clears the pending flag on `stream`.
             */
            clear_pending(): void;
            /**
             * Closes the stream, releasing resources related to it.
             *
             * Once the stream is closed, all other operations will return %G_IO_ERROR_CLOSED.
             * Closing a stream multiple times will not return an error.
             *
             * Closing a stream will automatically flush any outstanding buffers in the
             * stream.
             *
             * Streams will be automatically closed when the last reference
             * is dropped, but you might want to call this function to make sure
             * resources are released as early as possible.
             *
             * Some streams might keep the backing store of the stream (e.g. a file descriptor)
             * open after the stream is closed. See the documentation for the individual
             * stream for details.
             *
             * On failure the first error that happened will be reported, but the close
             * operation will finish as much as possible. A stream that failed to
             * close will still return %G_IO_ERROR_CLOSED for all operations. Still, it
             * is important to check and report the error to the user, otherwise
             * there might be a loss of data as all data might not be written.
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
             * Cancelling a close will still leave the stream closed, but there some streams
             * can use a faster close that doesn't block to e.g. check errors. On
             * cancellation (as with any error) there is no guarantee that all written
             * data will reach the target.
             * @param cancellable optional cancellable object
             * @returns %TRUE on success, %FALSE on failure
             */
            close(cancellable?: Cancellable | null): boolean;
            /**
             * Requests an asynchronous close of the stream, releasing resources
             * related to it. When the operation is finished `callback` will be
             * called. You can then call g_output_stream_close_finish() to get
             * the result of the operation.
             *
             * For behaviour details see g_output_stream_close().
             *
             * The asynchronous methods have a default fallback that uses threads
             * to implement asynchronicity, so they are optional for inheriting
             * classes. However, if you override one you must override all.
             * @param io_priority the io priority of the request.
             * @param cancellable optional cancellable object
             */
            close_async(io_priority: number, cancellable?: Cancellable | null): Promise<boolean>;
            /**
             * Requests an asynchronous close of the stream, releasing resources
             * related to it. When the operation is finished `callback` will be
             * called. You can then call g_output_stream_close_finish() to get
             * the result of the operation.
             *
             * For behaviour details see g_output_stream_close().
             *
             * The asynchronous methods have a default fallback that uses threads
             * to implement asynchronicity, so they are optional for inheriting
             * classes. However, if you override one you must override all.
             * @param io_priority the io priority of the request.
             * @param cancellable optional cancellable object
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            close_async(
                io_priority: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Requests an asynchronous close of the stream, releasing resources
             * related to it. When the operation is finished `callback` will be
             * called. You can then call g_output_stream_close_finish() to get
             * the result of the operation.
             *
             * For behaviour details see g_output_stream_close().
             *
             * The asynchronous methods have a default fallback that uses threads
             * to implement asynchronicity, so they are optional for inheriting
             * classes. However, if you override one you must override all.
             * @param io_priority the io priority of the request.
             * @param cancellable optional cancellable object
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            close_async(
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<boolean> | void;
            /**
             * Closes an output stream.
             * @param result a #GAsyncResult.
             * @returns %TRUE if stream was successfully closed, %FALSE otherwise.
             */
            close_finish(result: AsyncResult): boolean;
            /**
             * Forces a write of all user-space buffered data for the given
             * `stream`. Will block during the operation. Closing the stream will
             * implicitly cause a flush.
             *
             * This function is optional for inherited classes.
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
             * @param cancellable optional cancellable object
             * @returns %TRUE on success, %FALSE on error
             */
            flush(cancellable?: Cancellable | null): boolean;
            /**
             * Forces an asynchronous write of all user-space buffered data for
             * the given `stream`.
             * For behaviour details see g_output_stream_flush().
             *
             * When the operation is finished `callback` will be
             * called. You can then call g_output_stream_flush_finish() to get the
             * result of the operation.
             * @param io_priority the io priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            flush_async(io_priority: number, cancellable?: Cancellable | null): Promise<boolean>;
            /**
             * Forces an asynchronous write of all user-space buffered data for
             * the given `stream`.
             * For behaviour details see g_output_stream_flush().
             *
             * When the operation is finished `callback` will be
             * called. You can then call g_output_stream_flush_finish() to get the
             * result of the operation.
             * @param io_priority the io priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            flush_async(
                io_priority: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Forces an asynchronous write of all user-space buffered data for
             * the given `stream`.
             * For behaviour details see g_output_stream_flush().
             *
             * When the operation is finished `callback` will be
             * called. You can then call g_output_stream_flush_finish() to get the
             * result of the operation.
             * @param io_priority the io priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            flush_async(
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<boolean> | void;
            /**
             * Finishes flushing an output stream.
             * @param result a GAsyncResult.
             * @returns %TRUE if flush operation succeeded, %FALSE otherwise.
             */
            flush_finish(result: AsyncResult): boolean;
            /**
             * Checks if an output stream has pending actions.
             * @returns %TRUE if @stream has pending actions.
             */
            has_pending(): boolean;
            /**
             * Checks if an output stream has already been closed.
             * @returns %TRUE if @stream is closed. %FALSE otherwise.
             */
            is_closed(): boolean;
            /**
             * Checks if an output stream is being closed. This can be
             * used inside e.g. a flush implementation to see if the
             * flush (or other i/o operation) is called from within
             * the closing operation.
             * @returns %TRUE if @stream is being closed. %FALSE otherwise.
             */
            is_closing(): boolean;
            /**
             * Sets `stream` to have actions pending. If the pending flag is
             * already set or `stream` is closed, it will return %FALSE and set
             * `error`.
             * @returns %TRUE if pending was previously unset and is now set.
             */
            set_pending(): boolean;
            /**
             * Splices an input stream into an output stream.
             * @param source a #GInputStream.
             * @param flags a set of #GOutputStreamSpliceFlags.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @returns a #gssize containing the size of the data spliced, or     -1 if an error occurred. Note that if the number of bytes     spliced is greater than %G_MAXSSIZE, then that will be     returned, and there is no way to determine the actual number     of bytes spliced.
             */
            splice(
                source: InputStream,
                flags: OutputStreamSpliceFlags | null,
                cancellable?: Cancellable | null,
            ): number;
            /**
             * Splices a stream asynchronously.
             * When the operation is finished `callback` will be called.
             * You can then call g_output_stream_splice_finish() to get the
             * result of the operation.
             *
             * For the synchronous, blocking version of this function, see
             * g_output_stream_splice().
             * @param source a #GInputStream.
             * @param flags a set of #GOutputStreamSpliceFlags.
             * @param io_priority the io priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            splice_async(
                source: InputStream,
                flags: OutputStreamSpliceFlags | null,
                io_priority: number,
                cancellable?: Cancellable | null,
            ): Promise<number>;
            /**
             * Splices a stream asynchronously.
             * When the operation is finished `callback` will be called.
             * You can then call g_output_stream_splice_finish() to get the
             * result of the operation.
             *
             * For the synchronous, blocking version of this function, see
             * g_output_stream_splice().
             * @param source a #GInputStream.
             * @param flags a set of #GOutputStreamSpliceFlags.
             * @param io_priority the io priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            splice_async(
                source: InputStream,
                flags: OutputStreamSpliceFlags | null,
                io_priority: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Splices a stream asynchronously.
             * When the operation is finished `callback` will be called.
             * You can then call g_output_stream_splice_finish() to get the
             * result of the operation.
             *
             * For the synchronous, blocking version of this function, see
             * g_output_stream_splice().
             * @param source a #GInputStream.
             * @param flags a set of #GOutputStreamSpliceFlags.
             * @param io_priority the io priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            splice_async(
                source: InputStream,
                flags: OutputStreamSpliceFlags | null,
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<number> | void;
            /**
             * Finishes an asynchronous stream splice operation.
             * @param result a #GAsyncResult.
             * @returns a #gssize of the number of bytes spliced. Note that if the     number of bytes spliced is greater than %G_MAXSSIZE, then that     will be returned, and there is no way to determine the actual     number of bytes spliced.
             */
            splice_finish(result: AsyncResult): number;
            /**
             * Tries to write `count` bytes from `buffer` into the stream. Will block
             * during the operation.
             *
             * If count is 0, returns 0 and does nothing. A value of `count`
             * larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the number of bytes written to the stream is returned.
             * It is not an error if this is not the same as the requested size, as it
             * can happen e.g. on a partial I/O error, or if there is not enough
             * storage in the stream. All writes block until at least one byte
             * is written or an error occurs; 0 is never returned (unless
             * `count` is 0).
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
             * operation was partially finished when the operation was cancelled the
             * partial result will be returned, without an error.
             *
             * On error -1 is returned and `error` is set accordingly.
             * @param buffer the buffer containing the data to write.
             * @param cancellable optional cancellable object
             * @returns Number of bytes written, or -1 on error
             */
            write(buffer: Uint8Array | string, cancellable?: Cancellable | null): number;
            /**
             * Tries to write `count` bytes from `buffer` into the stream. Will block
             * during the operation.
             *
             * This function is similar to g_output_stream_write(), except it tries to
             * write as many bytes as requested, only stopping on an error.
             *
             * On a successful write of `count` bytes, %TRUE is returned, and `bytes_written`
             * is set to `count`.
             *
             * If there is an error during the operation %FALSE is returned and `error`
             * is set to indicate the error status.
             *
             * As a special exception to the normal conventions for functions that
             * use #GError, if this function returns %FALSE (and sets `error)` then
             * `bytes_written` will be set to the number of bytes that were
             * successfully written before the error was encountered.  This
             * functionality is only available from C.  If you need it from another
             * language then you must write your own loop around
             * g_output_stream_write().
             * @param buffer the buffer containing the data to write.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @returns %TRUE on success, %FALSE if there was an error
             */
            write_all(buffer: Uint8Array | string, cancellable?: Cancellable | null): [boolean, number];
            /**
             * Request an asynchronous write of `count` bytes from `buffer` into
             * the stream. When the operation is finished `callback` will be called.
             * You can then call g_output_stream_write_all_finish() to get the result of the
             * operation.
             *
             * This is the asynchronous version of g_output_stream_write_all().
             *
             * Call g_output_stream_write_all_finish() to collect the result.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             *
             * Note that no copy of `buffer` will be made, so it must stay valid
             * until `callback` is called.
             * @param buffer the buffer containing the data to write
             * @param io_priority the io priority of the request
             * @param cancellable optional #GCancellable object, %NULL to ignore
             */
            write_all_async(
                buffer: Uint8Array | string,
                io_priority: number,
                cancellable?: Cancellable | null,
            ): Promise<number>;
            /**
             * Request an asynchronous write of `count` bytes from `buffer` into
             * the stream. When the operation is finished `callback` will be called.
             * You can then call g_output_stream_write_all_finish() to get the result of the
             * operation.
             *
             * This is the asynchronous version of g_output_stream_write_all().
             *
             * Call g_output_stream_write_all_finish() to collect the result.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             *
             * Note that no copy of `buffer` will be made, so it must stay valid
             * until `callback` is called.
             * @param buffer the buffer containing the data to write
             * @param io_priority the io priority of the request
             * @param cancellable optional #GCancellable object, %NULL to ignore
             * @param callback a #GAsyncReadyCallback     to call when the request is satisfied
             */
            write_all_async(
                buffer: Uint8Array | string,
                io_priority: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Request an asynchronous write of `count` bytes from `buffer` into
             * the stream. When the operation is finished `callback` will be called.
             * You can then call g_output_stream_write_all_finish() to get the result of the
             * operation.
             *
             * This is the asynchronous version of g_output_stream_write_all().
             *
             * Call g_output_stream_write_all_finish() to collect the result.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             *
             * Note that no copy of `buffer` will be made, so it must stay valid
             * until `callback` is called.
             * @param buffer the buffer containing the data to write
             * @param io_priority the io priority of the request
             * @param cancellable optional #GCancellable object, %NULL to ignore
             * @param callback a #GAsyncReadyCallback     to call when the request is satisfied
             */
            write_all_async(
                buffer: Uint8Array | string,
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<number> | void;
            /**
             * Finishes an asynchronous stream write operation started with
             * g_output_stream_write_all_async().
             *
             * As a special exception to the normal conventions for functions that
             * use #GError, if this function returns %FALSE (and sets `error)` then
             * `bytes_written` will be set to the number of bytes that were
             * successfully written before the error was encountered.  This
             * functionality is only available from C.  If you need it from another
             * language then you must write your own loop around
             * g_output_stream_write_async().
             * @param result a #GAsyncResult
             * @returns %TRUE on success, %FALSE if there was an error
             */
            write_all_finish(result: AsyncResult): [boolean, number];
            /**
             * Request an asynchronous write of `count` bytes from `buffer` into
             * the stream. When the operation is finished `callback` will be called.
             * You can then call g_output_stream_write_finish() to get the result of the
             * operation.
             *
             * During an async request no other sync and async calls are allowed,
             * and will result in %G_IO_ERROR_PENDING errors.
             *
             * A value of `count` larger than %G_MAXSSIZE will cause a
             * %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the number of bytes written will be passed to the
             * `callback`. It is not an error if this is not the same as the
             * requested size, as it can happen e.g. on a partial I/O error,
             * but generally we try to write as many bytes as requested.
             *
             * You are guaranteed that this method will never fail with
             * %G_IO_ERROR_WOULD_BLOCK - if `stream` can't accept more data, the
             * method will just wait until this changes.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             *
             * The asynchronous methods have a default fallback that uses threads
             * to implement asynchronicity, so they are optional for inheriting
             * classes. However, if you override one you must override all.
             *
             * For the synchronous, blocking version of this function, see
             * g_output_stream_write().
             *
             * Note that no copy of `buffer` will be made, so it must stay valid
             * until `callback` is called. See g_output_stream_write_bytes_async()
             * for a #GBytes version that will automatically hold a reference to
             * the contents (without copying) for the duration of the call.
             * @param buffer the buffer containing the data to write.
             * @param io_priority the io priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            write_async(
                buffer: Uint8Array | string,
                io_priority: number,
                cancellable?: Cancellable | null,
            ): Promise<number>;
            /**
             * Request an asynchronous write of `count` bytes from `buffer` into
             * the stream. When the operation is finished `callback` will be called.
             * You can then call g_output_stream_write_finish() to get the result of the
             * operation.
             *
             * During an async request no other sync and async calls are allowed,
             * and will result in %G_IO_ERROR_PENDING errors.
             *
             * A value of `count` larger than %G_MAXSSIZE will cause a
             * %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the number of bytes written will be passed to the
             * `callback`. It is not an error if this is not the same as the
             * requested size, as it can happen e.g. on a partial I/O error,
             * but generally we try to write as many bytes as requested.
             *
             * You are guaranteed that this method will never fail with
             * %G_IO_ERROR_WOULD_BLOCK - if `stream` can't accept more data, the
             * method will just wait until this changes.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             *
             * The asynchronous methods have a default fallback that uses threads
             * to implement asynchronicity, so they are optional for inheriting
             * classes. However, if you override one you must override all.
             *
             * For the synchronous, blocking version of this function, see
             * g_output_stream_write().
             *
             * Note that no copy of `buffer` will be made, so it must stay valid
             * until `callback` is called. See g_output_stream_write_bytes_async()
             * for a #GBytes version that will automatically hold a reference to
             * the contents (without copying) for the duration of the call.
             * @param buffer the buffer containing the data to write.
             * @param io_priority the io priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback     to call when the request is satisfied
             */
            write_async(
                buffer: Uint8Array | string,
                io_priority: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Request an asynchronous write of `count` bytes from `buffer` into
             * the stream. When the operation is finished `callback` will be called.
             * You can then call g_output_stream_write_finish() to get the result of the
             * operation.
             *
             * During an async request no other sync and async calls are allowed,
             * and will result in %G_IO_ERROR_PENDING errors.
             *
             * A value of `count` larger than %G_MAXSSIZE will cause a
             * %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the number of bytes written will be passed to the
             * `callback`. It is not an error if this is not the same as the
             * requested size, as it can happen e.g. on a partial I/O error,
             * but generally we try to write as many bytes as requested.
             *
             * You are guaranteed that this method will never fail with
             * %G_IO_ERROR_WOULD_BLOCK - if `stream` can't accept more data, the
             * method will just wait until this changes.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             *
             * The asynchronous methods have a default fallback that uses threads
             * to implement asynchronicity, so they are optional for inheriting
             * classes. However, if you override one you must override all.
             *
             * For the synchronous, blocking version of this function, see
             * g_output_stream_write().
             *
             * Note that no copy of `buffer` will be made, so it must stay valid
             * until `callback` is called. See g_output_stream_write_bytes_async()
             * for a #GBytes version that will automatically hold a reference to
             * the contents (without copying) for the duration of the call.
             * @param buffer the buffer containing the data to write.
             * @param io_priority the io priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback     to call when the request is satisfied
             */
            write_async(
                buffer: Uint8Array | string,
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<number> | void;
            /**
             * A wrapper function for g_output_stream_write() which takes a
             * #GBytes as input.  This can be more convenient for use by language
             * bindings or in other cases where the refcounted nature of #GBytes
             * is helpful over a bare pointer interface.
             *
             * However, note that this function may still perform partial writes,
             * just like g_output_stream_write().  If that occurs, to continue
             * writing, you will need to create a new #GBytes containing just the
             * remaining bytes, using g_bytes_new_from_bytes(). Passing the same
             * #GBytes instance multiple times potentially can result in duplicated
             * data in the output stream.
             * @param bytes the #GBytes to write
             * @param cancellable optional cancellable object
             * @returns Number of bytes written, or -1 on error
             */
            write_bytes(bytes: GLib.Bytes | Uint8Array, cancellable?: Cancellable | null): number;
            /**
             * This function is similar to g_output_stream_write_async(), but
             * takes a #GBytes as input.  Due to the refcounted nature of #GBytes,
             * this allows the stream to avoid taking a copy of the data.
             *
             * However, note that this function may still perform partial writes,
             * just like g_output_stream_write_async(). If that occurs, to continue
             * writing, you will need to create a new #GBytes containing just the
             * remaining bytes, using g_bytes_new_from_bytes(). Passing the same
             * #GBytes instance multiple times potentially can result in duplicated
             * data in the output stream.
             *
             * For the synchronous, blocking version of this function, see
             * g_output_stream_write_bytes().
             * @param bytes The bytes to write
             * @param io_priority the io priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            write_bytes_async(
                bytes: GLib.Bytes | Uint8Array,
                io_priority: number,
                cancellable?: Cancellable | null,
            ): Promise<number>;
            /**
             * This function is similar to g_output_stream_write_async(), but
             * takes a #GBytes as input.  Due to the refcounted nature of #GBytes,
             * this allows the stream to avoid taking a copy of the data.
             *
             * However, note that this function may still perform partial writes,
             * just like g_output_stream_write_async(). If that occurs, to continue
             * writing, you will need to create a new #GBytes containing just the
             * remaining bytes, using g_bytes_new_from_bytes(). Passing the same
             * #GBytes instance multiple times potentially can result in duplicated
             * data in the output stream.
             *
             * For the synchronous, blocking version of this function, see
             * g_output_stream_write_bytes().
             * @param bytes The bytes to write
             * @param io_priority the io priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            write_bytes_async(
                bytes: GLib.Bytes | Uint8Array,
                io_priority: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * This function is similar to g_output_stream_write_async(), but
             * takes a #GBytes as input.  Due to the refcounted nature of #GBytes,
             * this allows the stream to avoid taking a copy of the data.
             *
             * However, note that this function may still perform partial writes,
             * just like g_output_stream_write_async(). If that occurs, to continue
             * writing, you will need to create a new #GBytes containing just the
             * remaining bytes, using g_bytes_new_from_bytes(). Passing the same
             * #GBytes instance multiple times potentially can result in duplicated
             * data in the output stream.
             *
             * For the synchronous, blocking version of this function, see
             * g_output_stream_write_bytes().
             * @param bytes The bytes to write
             * @param io_priority the io priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            write_bytes_async(
                bytes: GLib.Bytes | Uint8Array,
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<number> | void;
            /**
             * Finishes a stream write-from-#GBytes operation.
             * @param result a #GAsyncResult.
             * @returns a #gssize containing the number of bytes written to the stream.
             */
            write_bytes_finish(result: AsyncResult): number;
            /**
             * Finishes a stream write operation.
             * @param result a #GAsyncResult.
             * @returns a #gssize containing the number of bytes written to the stream.
             */
            write_finish(result: AsyncResult): number;
            /**
             * Tries to write the bytes contained in the `n_vectors` `vectors` into the
             * stream. Will block during the operation.
             *
             * If `n_vectors` is 0 or the sum of all bytes in `vectors` is 0, returns 0 and
             * does nothing.
             *
             * On success, the number of bytes written to the stream is returned.
             * It is not an error if this is not the same as the requested size, as it
             * can happen e.g. on a partial I/O error, or if there is not enough
             * storage in the stream. All writes block until at least one byte
             * is written or an error occurs; 0 is never returned (unless
             * `n_vectors` is 0 or the sum of all bytes in `vectors` is 0).
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
             * operation was partially finished when the operation was cancelled the
             * partial result will be returned, without an error.
             *
             * Some implementations of g_output_stream_writev() may have limitations on the
             * aggregate buffer size, and will return %G_IO_ERROR_INVALID_ARGUMENT if these
             * are exceeded. For example, when writing to a local file on UNIX platforms,
             * the aggregate buffer size must not exceed %G_MAXSSIZE bytes.
             * @param vectors the buffer containing the #GOutputVectors to write.
             * @param cancellable optional cancellable object
             * @returns %TRUE on success, %FALSE if there was an error
             */
            writev(vectors: OutputVector[], cancellable?: Cancellable | null): [boolean, number];
            /**
             * Tries to write the bytes contained in the `n_vectors` `vectors` into the
             * stream. Will block during the operation.
             *
             * This function is similar to g_output_stream_writev(), except it tries to
             * write as many bytes as requested, only stopping on an error.
             *
             * On a successful write of all `n_vectors` vectors, %TRUE is returned, and
             * `bytes_written` is set to the sum of all the sizes of `vectors`.
             *
             * If there is an error during the operation %FALSE is returned and `error`
             * is set to indicate the error status.
             *
             * As a special exception to the normal conventions for functions that
             * use #GError, if this function returns %FALSE (and sets `error)` then
             * `bytes_written` will be set to the number of bytes that were
             * successfully written before the error was encountered.  This
             * functionality is only available from C. If you need it from another
             * language then you must write your own loop around
             * g_output_stream_write().
             *
             * The content of the individual elements of `vectors` might be changed by this
             * function.
             * @param vectors the buffer containing the #GOutputVectors to write.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @returns %TRUE on success, %FALSE if there was an error
             */
            writev_all(vectors: OutputVector[], cancellable?: Cancellable | null): [boolean, number];
            /**
             * Request an asynchronous write of the bytes contained in the `n_vectors` `vectors` into
             * the stream. When the operation is finished `callback` will be called.
             * You can then call g_output_stream_writev_all_finish() to get the result of the
             * operation.
             *
             * This is the asynchronous version of g_output_stream_writev_all().
             *
             * Call g_output_stream_writev_all_finish() to collect the result.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             *
             * Note that no copy of `vectors` will be made, so it must stay valid
             * until `callback` is called. The content of the individual elements
             * of `vectors` might be changed by this function.
             * @param vectors the buffer containing the #GOutputVectors to write.
             * @param io_priority the I/O priority of the request
             * @param cancellable optional #GCancellable object, %NULL to ignore
             */
            writev_all_async(
                vectors: OutputVector[],
                io_priority: number,
                cancellable?: Cancellable | null,
            ): Promise<number>;
            /**
             * Request an asynchronous write of the bytes contained in the `n_vectors` `vectors` into
             * the stream. When the operation is finished `callback` will be called.
             * You can then call g_output_stream_writev_all_finish() to get the result of the
             * operation.
             *
             * This is the asynchronous version of g_output_stream_writev_all().
             *
             * Call g_output_stream_writev_all_finish() to collect the result.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             *
             * Note that no copy of `vectors` will be made, so it must stay valid
             * until `callback` is called. The content of the individual elements
             * of `vectors` might be changed by this function.
             * @param vectors the buffer containing the #GOutputVectors to write.
             * @param io_priority the I/O priority of the request
             * @param cancellable optional #GCancellable object, %NULL to ignore
             * @param callback a #GAsyncReadyCallback     to call when the request is satisfied
             */
            writev_all_async(
                vectors: OutputVector[],
                io_priority: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Request an asynchronous write of the bytes contained in the `n_vectors` `vectors` into
             * the stream. When the operation is finished `callback` will be called.
             * You can then call g_output_stream_writev_all_finish() to get the result of the
             * operation.
             *
             * This is the asynchronous version of g_output_stream_writev_all().
             *
             * Call g_output_stream_writev_all_finish() to collect the result.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             *
             * Note that no copy of `vectors` will be made, so it must stay valid
             * until `callback` is called. The content of the individual elements
             * of `vectors` might be changed by this function.
             * @param vectors the buffer containing the #GOutputVectors to write.
             * @param io_priority the I/O priority of the request
             * @param cancellable optional #GCancellable object, %NULL to ignore
             * @param callback a #GAsyncReadyCallback     to call when the request is satisfied
             */
            writev_all_async(
                vectors: OutputVector[],
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<number> | void;
            /**
             * Finishes an asynchronous stream write operation started with
             * g_output_stream_writev_all_async().
             *
             * As a special exception to the normal conventions for functions that
             * use #GError, if this function returns %FALSE (and sets `error)` then
             * `bytes_written` will be set to the number of bytes that were
             * successfully written before the error was encountered.  This
             * functionality is only available from C.  If you need it from another
             * language then you must write your own loop around
             * g_output_stream_writev_async().
             * @param result a #GAsyncResult
             * @returns %TRUE on success, %FALSE if there was an error
             */
            writev_all_finish(result: AsyncResult): [boolean, number];
            /**
             * Request an asynchronous write of the bytes contained in `n_vectors` `vectors` into
             * the stream. When the operation is finished `callback` will be called.
             * You can then call g_output_stream_writev_finish() to get the result of the
             * operation.
             *
             * During an async request no other sync and async calls are allowed,
             * and will result in %G_IO_ERROR_PENDING errors.
             *
             * On success, the number of bytes written will be passed to the
             * `callback`. It is not an error if this is not the same as the
             * requested size, as it can happen e.g. on a partial I/O error,
             * but generally we try to write as many bytes as requested.
             *
             * You are guaranteed that this method will never fail with
             * %G_IO_ERROR_WOULD_BLOCK — if `stream` can't accept more data, the
             * method will just wait until this changes.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             *
             * The asynchronous methods have a default fallback that uses threads
             * to implement asynchronicity, so they are optional for inheriting
             * classes. However, if you override one you must override all.
             *
             * For the synchronous, blocking version of this function, see
             * g_output_stream_writev().
             *
             * Note that no copy of `vectors` will be made, so it must stay valid
             * until `callback` is called.
             * @param vectors the buffer containing the #GOutputVectors to write.
             * @param io_priority the I/O priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            writev_async(
                vectors: OutputVector[],
                io_priority: number,
                cancellable?: Cancellable | null,
            ): Promise<number>;
            /**
             * Request an asynchronous write of the bytes contained in `n_vectors` `vectors` into
             * the stream. When the operation is finished `callback` will be called.
             * You can then call g_output_stream_writev_finish() to get the result of the
             * operation.
             *
             * During an async request no other sync and async calls are allowed,
             * and will result in %G_IO_ERROR_PENDING errors.
             *
             * On success, the number of bytes written will be passed to the
             * `callback`. It is not an error if this is not the same as the
             * requested size, as it can happen e.g. on a partial I/O error,
             * but generally we try to write as many bytes as requested.
             *
             * You are guaranteed that this method will never fail with
             * %G_IO_ERROR_WOULD_BLOCK — if `stream` can't accept more data, the
             * method will just wait until this changes.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             *
             * The asynchronous methods have a default fallback that uses threads
             * to implement asynchronicity, so they are optional for inheriting
             * classes. However, if you override one you must override all.
             *
             * For the synchronous, blocking version of this function, see
             * g_output_stream_writev().
             *
             * Note that no copy of `vectors` will be made, so it must stay valid
             * until `callback` is called.
             * @param vectors the buffer containing the #GOutputVectors to write.
             * @param io_priority the I/O priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback     to call when the request is satisfied
             */
            writev_async(
                vectors: OutputVector[],
                io_priority: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Request an asynchronous write of the bytes contained in `n_vectors` `vectors` into
             * the stream. When the operation is finished `callback` will be called.
             * You can then call g_output_stream_writev_finish() to get the result of the
             * operation.
             *
             * During an async request no other sync and async calls are allowed,
             * and will result in %G_IO_ERROR_PENDING errors.
             *
             * On success, the number of bytes written will be passed to the
             * `callback`. It is not an error if this is not the same as the
             * requested size, as it can happen e.g. on a partial I/O error,
             * but generally we try to write as many bytes as requested.
             *
             * You are guaranteed that this method will never fail with
             * %G_IO_ERROR_WOULD_BLOCK — if `stream` can't accept more data, the
             * method will just wait until this changes.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             *
             * The asynchronous methods have a default fallback that uses threads
             * to implement asynchronicity, so they are optional for inheriting
             * classes. However, if you override one you must override all.
             *
             * For the synchronous, blocking version of this function, see
             * g_output_stream_writev().
             *
             * Note that no copy of `vectors` will be made, so it must stay valid
             * until `callback` is called.
             * @param vectors the buffer containing the #GOutputVectors to write.
             * @param io_priority the I/O priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback     to call when the request is satisfied
             */
            writev_async(
                vectors: OutputVector[],
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<number> | void;
            /**
             * Finishes a stream writev operation.
             * @param result a #GAsyncResult.
             * @returns %TRUE on success, %FALSE if there was an error
             */
            writev_finish(result: AsyncResult): [boolean, number];
            /**
             * Requests an asynchronous close of the stream, releasing resources
             * related to it. When the operation is finished `callback` will be
             * called. You can then call g_output_stream_close_finish() to get
             * the result of the operation.
             *
             * For behaviour details see g_output_stream_close().
             *
             * The asynchronous methods have a default fallback that uses threads
             * to implement asynchronicity, so they are optional for inheriting
             * classes. However, if you override one you must override all.
             * @param io_priority the io priority of the request.
             * @param cancellable optional cancellable object
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            vfunc_close_async(
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Closes an output stream.
             * @param result a #GAsyncResult.
             */
            vfunc_close_finish(result: AsyncResult): boolean;
            vfunc_close_fn(cancellable?: Cancellable | null): boolean;
            /**
             * Forces a write of all user-space buffered data for the given
             * `stream`. Will block during the operation. Closing the stream will
             * implicitly cause a flush.
             *
             * This function is optional for inherited classes.
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
             * @param cancellable optional cancellable object
             */
            vfunc_flush(cancellable?: Cancellable | null): boolean;
            /**
             * Forces an asynchronous write of all user-space buffered data for
             * the given `stream`.
             * For behaviour details see g_output_stream_flush().
             *
             * When the operation is finished `callback` will be
             * called. You can then call g_output_stream_flush_finish() to get the
             * result of the operation.
             * @param io_priority the io priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            vfunc_flush_async(
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Finishes flushing an output stream.
             * @param result a GAsyncResult.
             */
            vfunc_flush_finish(result: AsyncResult): boolean;
            /**
             * Splices an input stream into an output stream.
             * @param source a #GInputStream.
             * @param flags a set of #GOutputStreamSpliceFlags.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            vfunc_splice(source: InputStream, flags: OutputStreamSpliceFlags, cancellable?: Cancellable | null): number;
            /**
             * Splices a stream asynchronously.
             * When the operation is finished `callback` will be called.
             * You can then call g_output_stream_splice_finish() to get the
             * result of the operation.
             *
             * For the synchronous, blocking version of this function, see
             * g_output_stream_splice().
             * @param source a #GInputStream.
             * @param flags a set of #GOutputStreamSpliceFlags.
             * @param io_priority the io priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback   to call when the request is satisfied
             */
            vfunc_splice_async(
                source: InputStream,
                flags: OutputStreamSpliceFlags,
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Finishes an asynchronous stream splice operation.
             * @param result a #GAsyncResult.
             */
            vfunc_splice_finish(result: AsyncResult): number;
            /**
             * Request an asynchronous write of `count` bytes from `buffer` into
             * the stream. When the operation is finished `callback` will be called.
             * You can then call g_output_stream_write_finish() to get the result of the
             * operation.
             *
             * During an async request no other sync and async calls are allowed,
             * and will result in %G_IO_ERROR_PENDING errors.
             *
             * A value of `count` larger than %G_MAXSSIZE will cause a
             * %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the number of bytes written will be passed to the
             * `callback`. It is not an error if this is not the same as the
             * requested size, as it can happen e.g. on a partial I/O error,
             * but generally we try to write as many bytes as requested.
             *
             * You are guaranteed that this method will never fail with
             * %G_IO_ERROR_WOULD_BLOCK - if `stream` can't accept more data, the
             * method will just wait until this changes.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             *
             * The asynchronous methods have a default fallback that uses threads
             * to implement asynchronicity, so they are optional for inheriting
             * classes. However, if you override one you must override all.
             *
             * For the synchronous, blocking version of this function, see
             * g_output_stream_write().
             *
             * Note that no copy of `buffer` will be made, so it must stay valid
             * until `callback` is called. See g_output_stream_write_bytes_async()
             * for a #GBytes version that will automatically hold a reference to
             * the contents (without copying) for the duration of the call.
             * @param buffer the buffer containing the data to write.
             * @param io_priority the io priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback     to call when the request is satisfied
             */
            vfunc_write_async(
                buffer: Uint8Array | null,
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Finishes a stream write operation.
             * @param result a #GAsyncResult.
             */
            vfunc_write_finish(result: AsyncResult): number;
            /**
             * Tries to write `count` bytes from `buffer` into the stream. Will block
             * during the operation.
             *
             * If count is 0, returns 0 and does nothing. A value of `count`
             * larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
             *
             * On success, the number of bytes written to the stream is returned.
             * It is not an error if this is not the same as the requested size, as it
             * can happen e.g. on a partial I/O error, or if there is not enough
             * storage in the stream. All writes block until at least one byte
             * is written or an error occurs; 0 is never returned (unless
             * `count` is 0).
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
             * operation was partially finished when the operation was cancelled the
             * partial result will be returned, without an error.
             *
             * On error -1 is returned and `error` is set accordingly.
             * @param buffer the buffer containing the data to write.
             * @param cancellable optional cancellable object
             */
            vfunc_write_fn(buffer?: Uint8Array | null, cancellable?: Cancellable | null): number;
            /**
             * Request an asynchronous write of the bytes contained in `n_vectors` `vectors` into
             * the stream. When the operation is finished `callback` will be called.
             * You can then call g_output_stream_writev_finish() to get the result of the
             * operation.
             *
             * During an async request no other sync and async calls are allowed,
             * and will result in %G_IO_ERROR_PENDING errors.
             *
             * On success, the number of bytes written will be passed to the
             * `callback`. It is not an error if this is not the same as the
             * requested size, as it can happen e.g. on a partial I/O error,
             * but generally we try to write as many bytes as requested.
             *
             * You are guaranteed that this method will never fail with
             * %G_IO_ERROR_WOULD_BLOCK — if `stream` can't accept more data, the
             * method will just wait until this changes.
             *
             * Any outstanding I/O request with higher priority (lower numerical
             * value) will be executed before an outstanding request with lower
             * priority. Default priority is %G_PRIORITY_DEFAULT.
             *
             * The asynchronous methods have a default fallback that uses threads
             * to implement asynchronicity, so they are optional for inheriting
             * classes. However, if you override one you must override all.
             *
             * For the synchronous, blocking version of this function, see
             * g_output_stream_writev().
             *
             * Note that no copy of `vectors` will be made, so it must stay valid
             * until `callback` is called.
             * @param vectors the buffer containing the #GOutputVectors to write.
             * @param io_priority the I/O priority of the request.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback     to call when the request is satisfied
             */
            vfunc_writev_async(
                vectors: OutputVector[],
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Finishes a stream writev operation.
             * @param result a #GAsyncResult.
             */
            vfunc_writev_finish(result: AsyncResult): [boolean, number];
            /**
             * Tries to write the bytes contained in the `n_vectors` `vectors` into the
             * stream. Will block during the operation.
             *
             * If `n_vectors` is 0 or the sum of all bytes in `vectors` is 0, returns 0 and
             * does nothing.
             *
             * On success, the number of bytes written to the stream is returned.
             * It is not an error if this is not the same as the requested size, as it
             * can happen e.g. on a partial I/O error, or if there is not enough
             * storage in the stream. All writes block until at least one byte
             * is written or an error occurs; 0 is never returned (unless
             * `n_vectors` is 0 or the sum of all bytes in `vectors` is 0).
             *
             * If `cancellable` is not %NULL, then the operation can be cancelled by
             * triggering the cancellable object from another thread. If the operation
             * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
             * operation was partially finished when the operation was cancelled the
             * partial result will be returned, without an error.
             *
             * Some implementations of g_output_stream_writev() may have limitations on the
             * aggregate buffer size, and will return %G_IO_ERROR_INVALID_ARGUMENT if these
             * are exceeded. For example, when writing to a local file on UNIX platforms,
             * the aggregate buffer size must not exceed %G_MAXSSIZE bytes.
             * @param vectors the buffer containing the #GOutputVectors to write.
             * @param cancellable optional cancellable object
             */
            vfunc_writev_fn(vectors: OutputVector[], cancellable?: Cancellable | null): [boolean, number];
        }

        namespace Credentials {
            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps {}
        }

        /**
         * The `GCredentials` type is a reference-counted wrapper for native
         * credentials.
         *
         * The information in `GCredentials` is typically used for identifying,
         * authenticating and authorizing other processes.
         *
         * Some operating systems supports looking up the credentials of the remote
         * peer of a communication endpoint - see e.g. [method`Gio`.Socket.get_credentials].
         *
         * Some operating systems supports securely sending and receiving
         * credentials over a Unix Domain Socket, see [class`Gio`.UnixCredentialsMessage],
         * [method`Gio`.UnixConnection.send_credentials] and
         * [method`Gio`.UnixConnection.receive_credentials] for details.
         *
         * On Linux, the native credential type is a `struct ucred` - see the
         * [`unix(7)` man page](man:unix(7)) for details. This corresponds to
         * `G_CREDENTIALS_TYPE_LINUX_UCRED`.
         *
         * On Apple operating systems (including iOS, tvOS, and macOS), the native credential
         * type is a `struct xucred`. This corresponds to `G_CREDENTIALS_TYPE_APPLE_XUCRED`.
         *
         * On FreeBSD, Debian GNU/kFreeBSD, and GNU/Hurd, the native credential type is a
         * `struct cmsgcred`. This corresponds to `G_CREDENTIALS_TYPE_FREEBSD_CMSGCRED`.
         *
         * On NetBSD, the native credential type is a `struct unpcbid`.
         * This corresponds to `G_CREDENTIALS_TYPE_NETBSD_UNPCBID`.
         *
         * On OpenBSD, the native credential type is a `struct sockpeercred`.
         * This corresponds to `G_CREDENTIALS_TYPE_OPENBSD_SOCKPEERCRED`.
         *
         * On Solaris (including OpenSolaris and its derivatives), the native credential type
         * is a `ucred_t`. This corresponds to `G_CREDENTIALS_TYPE_SOLARIS_UCRED`.
         *
         * Since GLib 2.72, on Windows, the native credentials may contain the PID of a
         * process. This corresponds to `G_CREDENTIALS_TYPE_WIN32_PID`.
         */
        class Credentials extends GObject.Object {
            static $gtype: GObject.GType<Credentials>;

            // Constructors

            constructor(properties?: Partial<Credentials.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](): Credentials;

            // Methods

            /**
             * Tries to get the UNIX process identifier from `credentials`. This
             * method is only available on UNIX platforms.
             *
             * This operation can fail if #GCredentials is not supported on the
             * OS or if the native credentials type does not contain information
             * about the UNIX process ID.
             * @returns The UNIX process ID, or `-1` if @error is set.
             */
            get_unix_pid(): never;
            /**
             * Tries to get the UNIX user identifier from `credentials`. This
             * method is only available on UNIX platforms.
             *
             * This operation can fail if #GCredentials is not supported on the
             * OS or if the native credentials type does not contain information
             * about the UNIX user.
             * @returns The UNIX user identifier or `-1` if @error is set.
             */
            get_unix_user(): never;
            /**
             * Checks if `credentials` and `other_credentials` is the same user.
             *
             * This operation can fail if #GCredentials is not supported on the
             * the OS.
             * @param other_credentials A #GCredentials.
             * @returns %TRUE if @credentials and @other_credentials has the same user, %FALSE otherwise or if @error is set.
             */
            is_same_user(other_credentials: Credentials): boolean;
            /**
             * Copies the native credentials of type `native_type` from `native`
             * into `credentials`.
             *
             * It is a programming error (which will cause a warning to be
             * logged) to use this method if there is no #GCredentials support for
             * the OS or if `native_type` isn't supported by the OS.
             * @param native_type The type of native credentials to set.
             * @param _native A pointer to native credentials.
             */
            set_native(native_type: CredentialsType | null, _native: any): void;
            /**
             * Tries to set the UNIX user identifier on `credentials`. This method
             * is only available on UNIX platforms.
             *
             * This operation can fail if #GCredentials is not supported on the
             * OS or if the native credentials type does not contain information
             * about the UNIX user. It can also fail if the OS does not allow the
             * use of "spoofed" credentials.
             * @param uid The UNIX user identifier to set.
             * @returns %TRUE if @uid was set, %FALSE if error is set.
             */
            set_unix_user(uid: never): boolean;
            /**
             * Creates a human-readable textual representation of `credentials`
             * that can be used in logging and debug messages. The format of the
             * returned string may change in future GLib release.
             * @returns A string that should be freed with g_free().
             */
            to_string(): string;
        }

        namespace DBusActionGroup {
            // Constructor properties interface

            interface ConstructorProps
                extends GObject.Object.ConstructorProps,
                    ActionGroup.ConstructorProps,
                    RemoteActionGroup.ConstructorProps {}
        }

        /**
         * `GDBusActionGroup` is an implementation of the [iface`Gio`.ActionGroup]
         * interface.
         *
         * `GDBusActionGroup` can be used as a proxy for an action group
         * that is exported over D-Bus with [method`Gio`.DBusConnection.export_action_group].
         */
        class DBusActionGroup extends GObject.Object implements ActionGroup, RemoteActionGroup {
            static $gtype: GObject.GType<DBusActionGroup>;

            // Constructors

            constructor(properties?: Partial<DBusActionGroup.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            // Static methods

            /**
             * Obtains a #GDBusActionGroup for the action group which is exported at
             * the given `bus_name` and `object_path`.
             *
             * The thread default main context is taken at the time of this call.
             * All signals on the menu model (and any linked models) are reported
             * with respect to this context.  All calls on the returned menu model
             * (and linked models) must also originate from this same context, with
             * the thread default main context unchanged.
             *
             * This call is non-blocking.  The returned action group may or may not
             * already be filled in.  The correct thing to do is connect the signals
             * for the action group to monitor for changes and then to call
             * g_action_group_list_actions() to get the initial list.
             * @param connection A #GDBusConnection
             * @param bus_name the bus name which exports the action     group or %NULL if @connection is not a message bus connection
             * @param object_path the object path at which the action group is exported
             */
            static get(connection: DBusConnection, bus_name: string | null, object_path: string): DBusActionGroup;

            // Inherited methods
            /**
             * Emits the [signal`Gio`.ActionGroup::action-added] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             */
            action_added(action_name: string): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-enabled-changed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             * @param enabled whether the action is now enabled
             */
            action_enabled_changed(action_name: string, enabled: boolean): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-removed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             */
            action_removed(action_name: string): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-state-changed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             * @param state the new state of the named action
             */
            action_state_changed(action_name: string, state: GLib.Variant): void;
            /**
             * Activate the named action within `action_group`.
             *
             * If the action is expecting a parameter, then the correct type of
             * parameter must be given as `parameter`.  If the action is expecting no
             * parameters then `parameter` must be `NULL`.  See
             * [method`Gio`.ActionGroup.get_action_parameter_type].
             *
             * If the [type`Gio`.ActionGroup] implementation supports asynchronous remote
             * activation over D-Bus, this call may return before the relevant
             * D-Bus traffic has been sent, or any replies have been received. In
             * order to block on such asynchronous activation calls,
             * [method`Gio`.DBusConnection.flush] should be called prior to the code, which
             * depends on the result of the action activation. Without flushing
             * the D-Bus connection, there is no guarantee that the action would
             * have been activated.
             *
             * The following code which runs in a remote app instance, shows an
             * example of a ‘quit’ action being activated on the primary app
             * instance over D-Bus. Here [method`Gio`.DBusConnection.flush] is called
             * before `exit()`. Without `g_dbus_connection_flush()`, the ‘quit’ action
             * may fail to be activated on the primary instance.
             *
             * ```c
             * // call ‘quit’ action on primary instance
             * g_action_group_activate_action (G_ACTION_GROUP (app), "quit", NULL);
             *
             * // make sure the action is activated now
             * g_dbus_connection_flush (…);
             *
             * g_debug ("Application has been terminated. Exiting.");
             *
             * exit (0);
             * ```
             * @param action_name the name of the action to activate
             * @param parameter parameters to the activation
             */
            activate_action(action_name: string, parameter?: GLib.Variant | null): void;
            /**
             * Request for the state of the named action within `action_group` to be
             * changed to `value`.
             *
             * The action must be stateful and `value` must be of the correct type.
             * See [method`Gio`.ActionGroup.get_action_state_type].
             *
             * This call merely requests a change.  The action may refuse to change
             * its state or may change its state to something other than `value`.
             * See [method`Gio`.ActionGroup.get_action_state_hint].
             *
             * If the `value` GVariant is floating, it is consumed.
             * @param action_name the name of the action to request the change on
             * @param value the new state
             */
            change_action_state(action_name: string, value: GLib.Variant): void;
            /**
             * Checks if the named action within `action_group` is currently enabled.
             *
             * An action must be enabled in order to be activated or in order to
             * have its state changed from outside callers.
             * @param action_name the name of the action to query
             * @returns whether the action is currently enabled
             */
            get_action_enabled(action_name: string): boolean;
            /**
             * Queries the type of the parameter that must be given when activating
             * the named action within `action_group`.
             *
             * When activating the action using [method`Gio`.ActionGroup.activate_action],
             * the [type`GLib`.Variant] given to that function must be of the type returned
             * by this function.
             *
             * In the case that this function returns `NULL`, you must not give any
             * [type`GLib`.Variant], but `NULL` instead.
             *
             * The parameter type of a particular action will never change but it is
             * possible for an action to be removed and for a new action to be added
             * with the same name but a different parameter type.
             * @param action_name the name of the action to query
             * @returns the parameter type
             */
            get_action_parameter_type(action_name: string): GLib.VariantType | null;
            /**
             * Queries the current state of the named action within `action_group`.
             *
             * If the action is not stateful then `NULL` will be returned.  If the
             * action is stateful then the type of the return value is the type
             * given by [method`Gio`.ActionGroup.get_action_state_type].
             *
             * The return value (if non-`NULL`) should be freed with
             * [method`GLib`.Variant.unref] when it is no longer required.
             * @param action_name the name of the action to query
             * @returns the current state of the action
             */
            get_action_state(action_name: string): GLib.Variant | null;
            /**
             * Requests a hint about the valid range of values for the state of the
             * named action within `action_group`.
             *
             * If `NULL` is returned it either means that the action is not stateful
             * or that there is no hint about the valid range of values for the
             * state of the action.
             *
             * If a [type`GLib`.Variant] array is returned then each item in the array is a
             * possible value for the state.  If a [type`GLib`.Variant] pair (ie: two-tuple) is
             * returned then the tuple specifies the inclusive lower and upper bound
             * of valid values for the state.
             *
             * In any case, the information is merely a hint.  It may be possible to
             * have a state value outside of the hinted range and setting a value
             * within the range may fail.
             *
             * The return value (if non-`NULL`) should be freed with
             * [method`GLib`.Variant.unref] when it is no longer required.
             * @param action_name the name of the action to query
             * @returns the state range hint
             */
            get_action_state_hint(action_name: string): GLib.Variant | null;
            /**
             * Queries the type of the state of the named action within
             * `action_group`.
             *
             * If the action is stateful then this function returns the
             * [type`GLib`.VariantType] of the state.  All calls to
             * [method`Gio`.ActionGroup.change_action_state] must give a [type`GLib`.Variant] of this
             * type and [method`Gio`.ActionGroup.get_action_state] will return a [type`GLib`.Variant]
             * of the same type.
             *
             * If the action is not stateful then this function will return `NULL`.
             * In that case, [method`Gio`.ActionGroup.get_action_state] will return `NULL`
             * and you must not call [method`Gio`.ActionGroup.change_action_state].
             *
             * The state type of a particular action will never change but it is
             * possible for an action to be removed and for a new action to be added
             * with the same name but a different state type.
             * @param action_name the name of the action to query
             * @returns the state type, if the action is stateful
             */
            get_action_state_type(action_name: string): GLib.VariantType | null;
            /**
             * Checks if the named action exists within `action_group`.
             * @param action_name the name of the action to check for
             * @returns whether the named action exists
             */
            has_action(action_name: string): boolean;
            /**
             * Lists the actions contained within `action_group`.
             *
             * The caller is responsible for freeing the list with [func`GLib`.strfreev] when
             * it is no longer required.
             * @returns a `NULL`-terminated array   of the names of the actions in the group
             */
            list_actions(): string[];
            /**
             * Queries all aspects of the named action within an `action_group`.
             *
             * This function acquires the information available from
             * [method`Gio`.ActionGroup.has_action], [method`Gio`.ActionGroup.get_action_enabled],
             * [method`Gio`.ActionGroup.get_action_parameter_type],
             * [method`Gio`.ActionGroup.get_action_state_type],
             * [method`Gio`.ActionGroup.get_action_state_hint] and
             * [method`Gio`.ActionGroup.get_action_state] with a single function call.
             *
             * This provides two main benefits.
             *
             * The first is the improvement in efficiency that comes with not having
             * to perform repeated lookups of the action in order to discover
             * different things about it.  The second is that implementing
             * [type`Gio`.ActionGroup] can now be done by only overriding this one virtual
             * function.
             *
             * The interface provides a default implementation of this function that
             * calls the individual functions, as required, to fetch the
             * information.  The interface also provides default implementations of
             * those functions that call this function.  All implementations,
             * therefore, must override either this function or all of the others.
             *
             * If the action exists, `TRUE` is returned and any of the requested
             * fields (as indicated by having a non-`NULL` reference passed in) are
             * filled.  If the action doesn’t exist, `FALSE` is returned and the
             * fields may or may not have been modified.
             * @param action_name the name of an action in the group
             * @returns `TRUE` if the action exists, else `FALSE`
             */
            query_action(
                action_name: string,
            ): [
                boolean,
                boolean,
                GLib.VariantType | null,
                GLib.VariantType | null,
                GLib.Variant | null,
                GLib.Variant | null,
            ];
            /**
             * Emits the [signal`Gio`.ActionGroup::action-added] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             */
            vfunc_action_added(action_name: string): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-enabled-changed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             * @param enabled whether the action is now enabled
             */
            vfunc_action_enabled_changed(action_name: string, enabled: boolean): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-removed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             */
            vfunc_action_removed(action_name: string): void;
            /**
             * Emits the [signal`Gio`.ActionGroup::action-state-changed] signal on `action_group`.
             *
             * This function should only be called by [type`Gio`.ActionGroup] implementations.
             * @param action_name the name of an action in the group
             * @param state the new state of the named action
             */
            vfunc_action_state_changed(action_name: string, state: GLib.Variant): void;
            /**
             * Activate the named action within `action_group`.
             *
             * If the action is expecting a parameter, then the correct type of
             * parameter must be given as `parameter`.  If the action is expecting no
             * parameters then `parameter` must be `NULL`.  See
             * [method`Gio`.ActionGroup.get_action_parameter_type].
             *
             * If the [type`Gio`.ActionGroup] implementation supports asynchronous remote
             * activation over D-Bus, this call may return before the relevant
             * D-Bus traffic has been sent, or any replies have been received. In
             * order to block on such asynchronous activation calls,
             * [method`Gio`.DBusConnection.flush] should be called prior to the code, which
             * depends on the result of the action activation. Without flushing
             * the D-Bus connection, there is no guarantee that the action would
             * have been activated.
             *
             * The following code which runs in a remote app instance, shows an
             * example of a ‘quit’ action being activated on the primary app
             * instance over D-Bus. Here [method`Gio`.DBusConnection.flush] is called
             * before `exit()`. Without `g_dbus_connection_flush()`, the ‘quit’ action
             * may fail to be activated on the primary instance.
             *
             * ```c
             * // call ‘quit’ action on primary instance
             * g_action_group_activate_action (G_ACTION_GROUP (app), "quit", NULL);
             *
             * // make sure the action is activated now
             * g_dbus_connection_flush (…);
             *
             * g_debug ("Application has been terminated. Exiting.");
             *
             * exit (0);
             * ```
             * @param action_name the name of the action to activate
             * @param parameter parameters to the activation
             */
            vfunc_activate_action(action_name: string, parameter?: GLib.Variant | null): void;
            /**
             * Request for the state of the named action within `action_group` to be
             * changed to `value`.
             *
             * The action must be stateful and `value` must be of the correct type.
             * See [method`Gio`.ActionGroup.get_action_state_type].
             *
             * This call merely requests a change.  The action may refuse to change
             * its state or may change its state to something other than `value`.
             * See [method`Gio`.ActionGroup.get_action_state_hint].
             *
             * If the `value` GVariant is floating, it is consumed.
             * @param action_name the name of the action to request the change on
             * @param value the new state
             */
            vfunc_change_action_state(action_name: string, value: GLib.Variant): void;
            /**
             * Checks if the named action within `action_group` is currently enabled.
             *
             * An action must be enabled in order to be activated or in order to
             * have its state changed from outside callers.
             * @param action_name the name of the action to query
             */
            vfunc_get_action_enabled(action_name: string): boolean;
            /**
             * Queries the type of the parameter that must be given when activating
             * the named action within `action_group`.
             *
             * When activating the action using [method`Gio`.ActionGroup.activate_action],
             * the [type`GLib`.Variant] given to that function must be of the type returned
             * by this function.
             *
             * In the case that this function returns `NULL`, you must not give any
             * [type`GLib`.Variant], but `NULL` instead.
             *
             * The parameter type of a particular action will never change but it is
             * possible for an action to be removed and for a new action to be added
             * with the same name but a different parameter type.
             * @param action_name the name of the action to query
             */
            vfunc_get_action_parameter_type(action_name: string): GLib.VariantType | null;
            /**
             * Queries the current state of the named action within `action_group`.
             *
             * If the action is not stateful then `NULL` will be returned.  If the
             * action is stateful then the type of the return value is the type
             * given by [method`Gio`.ActionGroup.get_action_state_type].
             *
             * The return value (if non-`NULL`) should be freed with
             * [method`GLib`.Variant.unref] when it is no longer required.
             * @param action_name the name of the action to query
             */
            vfunc_get_action_state(action_name: string): GLib.Variant | null;
            /**
             * Requests a hint about the valid range of values for the state of the
             * named action within `action_group`.
             *
             * If `NULL` is returned it either means that the action is not stateful
             * or that there is no hint about the valid range of values for the
             * state of the action.
             *
             * If a [type`GLib`.Variant] array is returned then each item in the array is a
             * possible value for the state.  If a [type`GLib`.Variant] pair (ie: two-tuple) is
             * returned then the tuple specifies the inclusive lower and upper bound
             * of valid values for the state.
             *
             * In any case, the information is merely a hint.  It may be possible to
             * have a state value outside of the hinted range and setting a value
             * within the range may fail.
             *
             * The return value (if non-`NULL`) should be freed with
             * [method`GLib`.Variant.unref] when it is no longer required.
             * @param action_name the name of the action to query
             */
            vfunc_get_action_state_hint(action_name: string): GLib.Variant | null;
            /**
             * Queries the type of the state of the named action within
             * `action_group`.
             *
             * If the action is stateful then this function returns the
             * [type`GLib`.VariantType] of the state.  All calls to
             * [method`Gio`.ActionGroup.change_action_state] must give a [type`GLib`.Variant] of this
             * type and [method`Gio`.ActionGroup.get_action_state] will return a [type`GLib`.Variant]
             * of the same type.
             *
             * If the action is not stateful then this function will return `NULL`.
             * In that case, [method`Gio`.ActionGroup.get_action_state] will return `NULL`
             * and you must not call [method`Gio`.ActionGroup.change_action_state].
             *
             * The state type of a particular action will never change but it is
             * possible for an action to be removed and for a new action to be added
             * with the same name but a different state type.
             * @param action_name the name of the action to query
             */
            vfunc_get_action_state_type(action_name: string): GLib.VariantType | null;
            /**
             * Checks if the named action exists within `action_group`.
             * @param action_name the name of the action to check for
             */
            vfunc_has_action(action_name: string): boolean;
            /**
             * Lists the actions contained within `action_group`.
             *
             * The caller is responsible for freeing the list with [func`GLib`.strfreev] when
             * it is no longer required.
             */
            vfunc_list_actions(): string[];
            /**
             * Queries all aspects of the named action within an `action_group`.
             *
             * This function acquires the information available from
             * [method`Gio`.ActionGroup.has_action], [method`Gio`.ActionGroup.get_action_enabled],
             * [method`Gio`.ActionGroup.get_action_parameter_type],
             * [method`Gio`.ActionGroup.get_action_state_type],
             * [method`Gio`.ActionGroup.get_action_state_hint] and
             * [method`Gio`.ActionGroup.get_action_state] with a single function call.
             *
             * This provides two main benefits.
             *
             * The first is the improvement in efficiency that comes with not having
             * to perform repeated lookups of the action in order to discover
             * different things about it.  The second is that implementing
             * [type`Gio`.ActionGroup] can now be done by only overriding this one virtual
             * function.
             *
             * The interface provides a default implementation of this function that
             * calls the individual functions, as required, to fetch the
             * information.  The interface also provides default implementations of
             * those functions that call this function.  All implementations,
             * therefore, must override either this function or all of the others.
             *
             * If the action exists, `TRUE` is returned and any of the requested
             * fields (as indicated by having a non-`NULL` reference passed in) are
             * filled.  If the action doesn’t exist, `FALSE` is returned and the
             * fields may or may not have been modified.
             * @param action_name the name of an action in the group
             */
            vfunc_query_action(
                action_name: string,
            ): [
                boolean,
                boolean,
                GLib.VariantType | null,
                GLib.VariantType | null,
                GLib.Variant | null,
                GLib.Variant | null,
            ];
            /**
             * Activates the remote action.
             *
             * This is the same as g_action_group_activate_action() except that it
             * allows for provision of "platform data" to be sent along with the
             * activation request.  This typically contains details such as the user
             * interaction timestamp or startup notification information.
             *
             * `platform_data` must be non-%NULL and must have the type
             * %G_VARIANT_TYPE_VARDICT.  If it is floating, it will be consumed.
             * @param action_name the name of the action to activate
             * @param parameter the optional parameter to the activation
             * @param platform_data the platform data to send
             */
            activate_action_full(
                action_name: string,
                parameter: GLib.Variant | null,
                platform_data: GLib.Variant,
            ): void;
            /**
             * Changes the state of a remote action.
             *
             * This is the same as g_action_group_change_action_state() except that
             * it allows for provision of "platform data" to be sent along with the
             * state change request.  This typically contains details such as the
             * user interaction timestamp or startup notification information.
             *
             * `platform_data` must be non-%NULL and must have the type
             * %G_VARIANT_TYPE_VARDICT.  If it is floating, it will be consumed.
             * @param action_name the name of the action to change the state of
             * @param value the new requested value for the state
             * @param platform_data the platform data to send
             */
            change_action_state_full(action_name: string, value: GLib.Variant, platform_data: GLib.Variant): void;
            /**
             * Activates the remote action.
             *
             * This is the same as g_action_group_activate_action() except that it
             * allows for provision of "platform data" to be sent along with the
             * activation request.  This typically contains details such as the user
             * interaction timestamp or startup notification information.
             *
             * `platform_data` must be non-%NULL and must have the type
             * %G_VARIANT_TYPE_VARDICT.  If it is floating, it will be consumed.
             * @param action_name the name of the action to activate
             * @param parameter the optional parameter to the activation
             * @param platform_data the platform data to send
             */
            vfunc_activate_action_full(
                action_name: string,
                parameter: GLib.Variant | null,
                platform_data: GLib.Variant,
            ): void;
            /**
             * Changes the state of a remote action.
             *
             * This is the same as g_action_group_change_action_state() except that
             * it allows for provision of "platform data" to be sent along with the
             * state change request.  This typically contains details such as the
             * user interaction timestamp or startup notification information.
             *
             * `platform_data` must be non-%NULL and must have the type
             * %G_VARIANT_TYPE_VARDICT.  If it is floating, it will be consumed.
             * @param action_name the name of the action to change the state of
             * @param value the new requested value for the state
             * @param platform_data the platform data to send
             */
            vfunc_change_action_state_full(action_name: string, value: GLib.Variant, platform_data: GLib.Variant): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace DBusAuthObserver {
            // Signal callback interfaces

            interface AllowMechanism {
                (mechanism: string): boolean;
            }

            interface AuthorizeAuthenticatedPeer {
                (stream: IOStream, credentials?: Credentials | null): boolean;
            }

            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps {}
        }

        /**
         * `GDBusAuthObserver` provides a mechanism for participating
         * in how a [class`Gio`.DBusServer] (or a [class`Gio`.DBusConnection])
         * authenticates remote peers.
         *
         * Simply instantiate a `GDBusAuthObserver` and connect to the
         * signals you are interested in. Note that new signals may be added
         * in the future.
         *
         * ## Controlling Authentication Mechanisms
         *
         * By default, a `GDBusServer` or server-side `GDBusConnection` will allow
         * any authentication mechanism to be used. If you only want to allow D-Bus
         * connections with the `EXTERNAL` mechanism, which makes use of credentials
         * passing and is the recommended mechanism for modern Unix platforms such
         * as Linux and the BSD family, you would use a signal handler like this:
         *
         * ```c
         * static gboolean
         * on_allow_mechanism (GDBusAuthObserver *observer,
         *                     const gchar       *mechanism,
         *                     gpointer           user_data)
         * {
         *   if (g_strcmp0 (mechanism, "EXTERNAL") == 0)
         *     {
         *       return TRUE;
         *     }
         *
         *   return FALSE;
         * }
         * ```
         *
         * ## Controlling Authorization
         *
         * By default, a `GDBusServer` or server-side `GDBusConnection` will accept
         * connections from any successfully authenticated user (but not from
         * anonymous connections using the `ANONYMOUS` mechanism). If you only
         * want to allow D-Bus connections from processes owned by the same uid
         * as the server, since GLib 2.68, you should use the
         * `G_DBUS_SERVER_FLAGS_AUTHENTICATION_REQUIRE_SAME_USER` flag. It’s equivalent
         * to the following signal handler:
         *
         * ```c
         * static gboolean
         * on_authorize_authenticated_peer (GDBusAuthObserver *observer,
         *                                  GIOStream         *stream,
         *                                  GCredentials      *credentials,
         *                                  gpointer           user_data)
         * {
         *   gboolean authorized;
         *
         *   authorized = FALSE;
         *   if (credentials != NULL)
         *     {
         *       GCredentials *own_credentials;
         *       own_credentials = g_credentials_new ();
         *       if (g_credentials_is_same_user (credentials, own_credentials, NULL))
         *         authorized = TRUE;
         *       g_object_unref (own_credentials);
         *     }
         *
         *   return authorized;
         * }
         * ```
         */
        class DBusAuthObserver extends GObject.Object {
            static $gtype: GObject.GType<DBusAuthObserver>;

            // Constructors

            constructor(properties?: Partial<DBusAuthObserver.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](): DBusAuthObserver;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'allow-mechanism', callback: (_source: this, mechanism: string) => boolean): number;
            connect_after(signal: 'allow-mechanism', callback: (_source: this, mechanism: string) => boolean): number;
            emit(signal: 'allow-mechanism', mechanism: string): void;
            connect(
                signal: 'authorize-authenticated-peer',
                callback: (_source: this, stream: IOStream, credentials: Credentials | null) => boolean,
            ): number;
            connect_after(
                signal: 'authorize-authenticated-peer',
                callback: (_source: this, stream: IOStream, credentials: Credentials | null) => boolean,
            ): number;
            emit(signal: 'authorize-authenticated-peer', stream: IOStream, credentials?: Credentials | null): void;

            // Methods

            /**
             * Emits the #GDBusAuthObserver::allow-mechanism signal on `observer`.
             * @param mechanism The name of the mechanism, e.g. `DBUS_COOKIE_SHA1`.
             * @returns %TRUE if @mechanism can be used to authenticate the other peer, %FALSE if not.
             */
            allow_mechanism(mechanism: string): boolean;
            /**
             * Emits the #GDBusAuthObserver::authorize-authenticated-peer signal on `observer`.
             * @param stream A #GIOStream for the #GDBusConnection.
             * @param credentials Credentials received from the peer or %NULL.
             * @returns %TRUE if the peer is authorized, %FALSE if not.
             */
            authorize_authenticated_peer(stream: IOStream, credentials?: Credentials | null): boolean;
        }

        namespace DBusConnection {
            // Signal callback interfaces

            interface Closed {
                (remote_peer_vanished: boolean, error?: GLib.Error | null): void;
            }

            // Constructor properties interface

            interface ConstructorProps
                extends GObject.Object.ConstructorProps,
                    AsyncInitable.ConstructorProps,
                    Initable.ConstructorProps {
                address: string;
                authentication_observer: DBusAuthObserver;
                authenticationObserver: DBusAuthObserver;
                capabilities: DBusCapabilityFlags;
                closed: boolean;
                exit_on_close: boolean;
                exitOnClose: boolean;
                flags: DBusConnectionFlags;
                guid: string;
                stream: IOStream;
                unique_name: string;
                uniqueName: string;
            }
        }

        /**
         * The `GDBusConnection` type is used for D-Bus connections to remote
         * peers such as a message buses.
         *
         * It is a low-level API that offers a lot of flexibility. For instance,
         * it lets you establish a connection over any transport that can by represented
         * as a [class`Gio`.IOStream].
         *
         * This class is rarely used directly in D-Bus clients. If you are writing
         * a D-Bus client, it is often easier to use the [func`Gio`.bus_own_name],
         * [func`Gio`.bus_watch_name] or [func`Gio`.DBusProxy.new_for_bus] APIs.
         *
         * As an exception to the usual GLib rule that a particular object must not
         * be used by two threads at the same time, `GDBusConnection`s methods may be
         * called from any thread. This is so that [func`Gio`.bus_get] and
         * [func`Gio`.bus_get_sync] can safely return the same `GDBusConnection` when
         * called from any thread.
         *
         * Most of the ways to obtain a `GDBusConnection` automatically initialize it
         * (i.e. connect to D-Bus): for instance, [func`Gio`.DBusConnection.new] and
         * [func`Gio`.bus_get], and the synchronous versions of those methods, give you
         * an initialized connection. Language bindings for GIO should use
         * [func`Gio`.Initable.new] or [func`Gio`.AsyncInitable.new_async], which also
         * initialize the connection.
         *
         * If you construct an uninitialized `GDBusConnection`, such as via
         * [ctor`GObject`.Object.new], you must initialize it via [method`Gio`.Initable.init] or
         * [method`Gio`.AsyncInitable.init_async] before using its methods or properties.
         * Calling methods or accessing properties on a `GDBusConnection` that has not
         * completed initialization successfully is considered to be invalid, and leads
         * to undefined behaviour. In particular, if initialization fails with a
         * `GError`, the only valid thing you can do with that `GDBusConnection` is to
         * free it with [method`GObject`.Object.unref].
         *
         * ## An example D-Bus server
         *
         * Here is an example for a D-Bus server:
         * [gdbus-example-server.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gdbus-example-server.c)
         *
         * ## An example for exporting a subtree
         *
         * Here is an example for exporting a subtree:
         * [gdbus-example-subtree.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gdbus-example-subtree.c)
         *
         * ## An example for file descriptor passing
         *
         * Here is an example for passing UNIX file descriptors:
         * [gdbus-unix-fd-client.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gdbus-example-unix-fd-client.c)
         *
         * ## An example for exporting a GObject
         *
         * Here is an example for exporting a #GObject:
         * [gdbus-example-export.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gdbus-example-export.c)
         */
        class DBusConnection extends GObject.Object implements AsyncInitable<DBusConnection>, Initable {
            static $gtype: GObject.GType<DBusConnection>;

            // Properties

            /**
             * A D-Bus address specifying potential endpoints that can be used
             * when establishing the connection.
             */
            set address(val: string);
            /**
             * A #GDBusAuthObserver object to assist in the authentication process or %NULL.
             */
            set authentication_observer(val: DBusAuthObserver);
            /**
             * A #GDBusAuthObserver object to assist in the authentication process or %NULL.
             */
            set authenticationObserver(val: DBusAuthObserver);
            /**
             * Flags from the #GDBusCapabilityFlags enumeration
             * representing connection features negotiated with the other peer.
             */
            get capabilities(): DBusCapabilityFlags;
            /**
             * A boolean specifying whether the connection has been closed.
             */
            get closed(): boolean;
            /**
             * A boolean specifying whether the process will be terminated (by
             * calling `raise(SIGTERM)`) if the connection is closed by the
             * remote peer.
             *
             * Note that #GDBusConnection objects returned by g_bus_get_finish()
             * and g_bus_get_sync() will (usually) have this property set to %TRUE.
             */
            get exit_on_close(): boolean;
            set exit_on_close(val: boolean);
            /**
             * A boolean specifying whether the process will be terminated (by
             * calling `raise(SIGTERM)`) if the connection is closed by the
             * remote peer.
             *
             * Note that #GDBusConnection objects returned by g_bus_get_finish()
             * and g_bus_get_sync() will (usually) have this property set to %TRUE.
             */
            get exitOnClose(): boolean;
            set exitOnClose(val: boolean);
            /**
             * Flags from the #GDBusConnectionFlags enumeration.
             */
            get flags(): DBusConnectionFlags;
            /**
             * The GUID of the peer performing the role of server when
             * authenticating.
             *
             * If you are constructing a #GDBusConnection and pass
             * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER in the
             * #GDBusConnection:flags property then you **must** also set this
             * property to a valid guid.
             *
             * If you are constructing a #GDBusConnection and pass
             * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT in the
             * #GDBusConnection:flags property you will be able to read the GUID
             * of the other peer here after the connection has been successfully
             * initialized.
             *
             * Note that the
             * [D-Bus specification](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses)
             * uses the term ‘UUID’ to refer to this, whereas GLib consistently uses the
             * term ‘GUID’ for historical reasons.
             *
             * Despite its name, the format of #GDBusConnection:guid does not follow
             * [RFC 4122](https://datatracker.ietf.org/doc/html/rfc4122) or the Microsoft
             * GUID format.
             */
            get guid(): string;
            /**
             * The underlying #GIOStream used for I/O.
             *
             * If this is passed on construction and is a #GSocketConnection,
             * then the corresponding #GSocket will be put into non-blocking mode.
             *
             * While the #GDBusConnection is active, it will interact with this
             * stream from a worker thread, so it is not safe to interact with
             * the stream directly.
             */
            get stream(): IOStream;
            /**
             * The unique name as assigned by the message bus or %NULL if the
             * connection is not open or not a message bus connection.
             */
            get unique_name(): string;
            /**
             * The unique name as assigned by the message bus or %NULL if the
             * connection is not open or not a message bus connection.
             */
            get uniqueName(): string;

            // Constructors

            constructor(properties?: Partial<DBusConnection.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static new_finish(res: AsyncResult): DBusConnection;
            // Conflicted with Gio.AsyncInitable.new_finish

            static new_finish(...args: never[]): any;

            static new_for_address_finish(res: AsyncResult): DBusConnection;

            static new_for_address_sync(
                address: string,
                flags: DBusConnectionFlags,
                observer?: DBusAuthObserver | null,
                cancellable?: Cancellable | null,
            ): DBusConnection;

            static new_sync(
                stream: IOStream,
                guid: string | null,
                flags: DBusConnectionFlags,
                observer?: DBusAuthObserver | null,
                cancellable?: Cancellable | null,
            ): DBusConnection;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(
                signal: 'closed',
                callback: (_source: this, remote_peer_vanished: boolean, error: GLib.Error | null) => void,
            ): number;
            connect_after(
                signal: 'closed',
                callback: (_source: this, remote_peer_vanished: boolean, error: GLib.Error | null) => void,
            ): number;
            emit(signal: 'closed', remote_peer_vanished: boolean, error?: GLib.Error | null): void;

            // Static methods

            /**
             * Asynchronously sets up a D-Bus connection for exchanging D-Bus messages
             * with the end represented by `stream`.
             *
             * If `stream` is a #GSocketConnection, then the corresponding #GSocket
             * will be put into non-blocking mode.
             *
             * The D-Bus connection will interact with `stream` from a worker thread.
             * As a result, the caller should not interact with `stream` after this
             * method has been called, except by calling g_object_unref() on it.
             *
             * If `observer` is not %NULL it may be used to control the
             * authentication process.
             *
             * When the operation is finished, `callback` will be invoked. You can
             * then call g_dbus_connection_new_finish() to get the result of the
             * operation.
             *
             * This is an asynchronous failable constructor. See
             * g_dbus_connection_new_sync() for the synchronous
             * version.
             * @param stream a #GIOStream
             * @param guid the GUID to use if authenticating as a server or %NULL
             * @param flags flags describing how to make the connection
             * @param observer a #GDBusAuthObserver or %NULL
             * @param cancellable a #GCancellable or %NULL
             * @param callback a #GAsyncReadyCallback to call when the request is satisfied
             */
            static ['new'](
                stream: IOStream,
                guid: string | null,
                flags: DBusConnectionFlags,
                observer?: DBusAuthObserver | null,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<DBusConnection> | null,
            ): void;
            /**
             * Asynchronously connects and sets up a D-Bus client connection for
             * exchanging D-Bus messages with an endpoint specified by `address`
             * which must be in the
             * [D-Bus address format](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses).
             *
             * This constructor can only be used to initiate client-side
             * connections - use g_dbus_connection_new() if you need to act as the
             * server. In particular, `flags` cannot contain the
             * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER,
             * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS or
             * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_REQUIRE_SAME_USER flags.
             *
             * When the operation is finished, `callback` will be invoked. You can
             * then call g_dbus_connection_new_for_address_finish() to get the result of
             * the operation.
             *
             * If `observer` is not %NULL it may be used to control the
             * authentication process.
             *
             * This is an asynchronous failable constructor. See
             * g_dbus_connection_new_for_address_sync() for the synchronous
             * version.
             * @param address a D-Bus address
             * @param flags flags describing how to make the connection
             * @param observer a #GDBusAuthObserver or %NULL
             * @param cancellable a #GCancellable or %NULL
             * @param callback a #GAsyncReadyCallback to call when the request is satisfied
             */
            static new_for_address(
                address: string,
                flags: DBusConnectionFlags,
                observer?: DBusAuthObserver | null,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<DBusConnection> | null,
            ): void;

            // Methods

            /**
             * Adds a message filter. Filters are handlers that are run on all
             * incoming and outgoing messages, prior to standard dispatch. Filters
             * are run in the order that they were added.  The same handler can be
             * added as a filter more than once, in which case it will be run more
             * than once.  Filters added during a filter callback won't be run on
             * the message being processed. Filter functions are allowed to modify
             * and even drop messages.
             *
             * Note that filters are run in a dedicated message handling thread so
             * they can't block and, generally, can't do anything but signal a
             * worker thread. Also note that filters are rarely needed - use API
             * such as g_dbus_connection_send_message_with_reply(),
             * g_dbus_connection_signal_subscribe() or g_dbus_connection_call() instead.
             *
             * If a filter consumes an incoming message the message is not
             * dispatched anywhere else - not even the standard dispatch machinery
             * (that API such as g_dbus_connection_signal_subscribe() and
             * g_dbus_connection_send_message_with_reply() relies on) will see the
             * message. Similarly, if a filter consumes an outgoing message, the
             * message will not be sent to the other peer.
             *
             * If `user_data_free_func` is non-%NULL, it will be called (in the
             * thread-default main context of the thread you are calling this
             * method from) at some point after `user_data` is no longer
             * needed. (It is not guaranteed to be called synchronously when the
             * filter is removed, and may be called after `connection` has been
             * destroyed.)
             * @param filter_function a filter function
             * @returns a filter identifier that can be used with     g_dbus_connection_remove_filter()
             */
            add_filter(filter_function: DBusMessageFilterFunction): number;
            /**
             * Asynchronously invokes the `method_name` method on the
             * `interface_name` D-Bus interface on the remote object at
             * `object_path` owned by `bus_name`.
             *
             * If `connection` is closed then the operation will fail with
             * %G_IO_ERROR_CLOSED. If `cancellable` is canceled, the operation will
             * fail with %G_IO_ERROR_CANCELLED. If `parameters` contains a value
             * not compatible with the D-Bus protocol, the operation fails with
             * %G_IO_ERROR_INVALID_ARGUMENT.
             *
             * If `reply_type` is non-%NULL then the reply will be checked for having this type and an
             * error will be raised if it does not match.  Said another way, if you give a `reply_type`
             * then any non-%NULL return value will be of this type. Unless it’s
             * %G_VARIANT_TYPE_UNIT, the `reply_type` will be a tuple containing one or more
             * values.
             *
             * If the `parameters` #GVariant is floating, it is consumed. This allows
             * convenient 'inline' use of g_variant_new(), e.g.:
             *
             * ```c
             *  g_dbus_connection_call (connection,
             *                          "org.freedesktop.StringThings",
             *                          "/org/freedesktop/StringThings",
             *                          "org.freedesktop.StringThings",
             *                          "TwoStrings",
             *                          g_variant_new ("(ss)",
             *                                         "Thing One",
             *                                         "Thing Two"),
             *                          NULL,
             *                          G_DBUS_CALL_FLAGS_NONE,
             *                          -1,
             *                          NULL,
             *                          (GAsyncReadyCallback) two_strings_done,
             *                          NULL);
             * ```
             *
             *
             * This is an asynchronous method. When the operation is finished,
             * `callback` will be invoked in the thread-default main context
             * (see [method`GLib`.MainContext.push_thread_default])
             * of the thread you are calling this method from. You can then call
             * g_dbus_connection_call_finish() to get the result of the operation.
             * See g_dbus_connection_call_sync() for the synchronous version of this
             * function.
             *
             * If `callback` is %NULL then the D-Bus method call message will be sent with
             * the %G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED flag set.
             * @param bus_name a unique or well-known bus name or %NULL if     @connection is not a message bus connection
             * @param object_path path of remote object
             * @param interface_name D-Bus interface to invoke method on
             * @param method_name the name of the method to invoke
             * @param parameters a #GVariant tuple with parameters for the method     or %NULL if not passing parameters
             * @param reply_type the expected type of the reply (which will be a     tuple), or %NULL
             * @param flags flags from the #GDBusCallFlags enumeration
             * @param timeout_msec the timeout in milliseconds, -1 to use the default     timeout or %G_MAXINT for no timeout
             * @param cancellable a #GCancellable or %NULL
             */
            call<T extends string = any>(
                bus_name: string | null,
                object_path: string,
                interface_name: string,
                method_name: string,
                parameters: GLib.Variant | null,
                reply_type: GLib.VariantType<T> | null,
                flags: DBusCallFlags | null,
                timeout_msec: number,
                cancellable?: Cancellable | null,
            ): Promise<GLib.Variant<T>>;
            /**
             * Asynchronously invokes the `method_name` method on the
             * `interface_name` D-Bus interface on the remote object at
             * `object_path` owned by `bus_name`.
             *
             * If `connection` is closed then the operation will fail with
             * %G_IO_ERROR_CLOSED. If `cancellable` is canceled, the operation will
             * fail with %G_IO_ERROR_CANCELLED. If `parameters` contains a value
             * not compatible with the D-Bus protocol, the operation fails with
             * %G_IO_ERROR_INVALID_ARGUMENT.
             *
             * If `reply_type` is non-%NULL then the reply will be checked for having this type and an
             * error will be raised if it does not match.  Said another way, if you give a `reply_type`
             * then any non-%NULL return value will be of this type. Unless it’s
             * %G_VARIANT_TYPE_UNIT, the `reply_type` will be a tuple containing one or more
             * values.
             *
             * If the `parameters` #GVariant is floating, it is consumed. This allows
             * convenient 'inline' use of g_variant_new(), e.g.:
             *
             * ```c
             *  g_dbus_connection_call (connection,
             *                          "org.freedesktop.StringThings",
             *                          "/org/freedesktop/StringThings",
             *                          "org.freedesktop.StringThings",
             *                          "TwoStrings",
             *                          g_variant_new ("(ss)",
             *                                         "Thing One",
             *                                         "Thing Two"),
             *                          NULL,
             *                          G_DBUS_CALL_FLAGS_NONE,
             *                          -1,
             *                          NULL,
             *                          (GAsyncReadyCallback) two_strings_done,
             *                          NULL);
             * ```
             *
             *
             * This is an asynchronous method. When the operation is finished,
             * `callback` will be invoked in the thread-default main context
             * (see [method`GLib`.MainContext.push_thread_default])
             * of the thread you are calling this method from. You can then call
             * g_dbus_connection_call_finish() to get the result of the operation.
             * See g_dbus_connection_call_sync() for the synchronous version of this
             * function.
             *
             * If `callback` is %NULL then the D-Bus method call message will be sent with
             * the %G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED flag set.
             * @param bus_name a unique or well-known bus name or %NULL if     @connection is not a message bus connection
             * @param object_path path of remote object
             * @param interface_name D-Bus interface to invoke method on
             * @param method_name the name of the method to invoke
             * @param parameters a #GVariant tuple with parameters for the method     or %NULL if not passing parameters
             * @param reply_type the expected type of the reply (which will be a     tuple), or %NULL
             * @param flags flags from the #GDBusCallFlags enumeration
             * @param timeout_msec the timeout in milliseconds, -1 to use the default     timeout or %G_MAXINT for no timeout
             * @param cancellable a #GCancellable or %NULL
             * @param callback a #GAsyncReadyCallback to call when the request     is satisfied or %NULL if you don't care about the result of the     method invocation
             */
            call<T extends string = any>(
                bus_name: string | null,
                object_path: string,
                interface_name: string,
                method_name: string,
                parameters: GLib.Variant | null,
                reply_type: GLib.VariantType<T> | null,
                flags: DBusCallFlags | null,
                timeout_msec: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Asynchronously invokes the `method_name` method on the
             * `interface_name` D-Bus interface on the remote object at
             * `object_path` owned by `bus_name`.
             *
             * If `connection` is closed then the operation will fail with
             * %G_IO_ERROR_CLOSED. If `cancellable` is canceled, the operation will
             * fail with %G_IO_ERROR_CANCELLED. If `parameters` contains a value
             * not compatible with the D-Bus protocol, the operation fails with
             * %G_IO_ERROR_INVALID_ARGUMENT.
             *
             * If `reply_type` is non-%NULL then the reply will be checked for having this type and an
             * error will be raised if it does not match.  Said another way, if you give a `reply_type`
             * then any non-%NULL return value will be of this type. Unless it’s
             * %G_VARIANT_TYPE_UNIT, the `reply_type` will be a tuple containing one or more
             * values.
             *
             * If the `parameters` #GVariant is floating, it is consumed. This allows
             * convenient 'inline' use of g_variant_new(), e.g.:
             *
             * ```c
             *  g_dbus_connection_call (connection,
             *                          "org.freedesktop.StringThings",
             *                          "/org/freedesktop/StringThings",
             *                          "org.freedesktop.StringThings",
             *                          "TwoStrings",
             *                          g_variant_new ("(ss)",
             *                                         "Thing One",
             *                                         "Thing Two"),
             *                          NULL,
             *                          G_DBUS_CALL_FLAGS_NONE,
             *                          -1,
             *                          NULL,
             *                          (GAsyncReadyCallback) two_strings_done,
             *                          NULL);
             * ```
             *
             *
             * This is an asynchronous method. When the operation is finished,
             * `callback` will be invoked in the thread-default main context
             * (see [method`GLib`.MainContext.push_thread_default])
             * of the thread you are calling this method from. You can then call
             * g_dbus_connection_call_finish() to get the result of the operation.
             * See g_dbus_connection_call_sync() for the synchronous version of this
             * function.
             *
             * If `callback` is %NULL then the D-Bus method call message will be sent with
             * the %G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED flag set.
             * @param bus_name a unique or well-known bus name or %NULL if     @connection is not a message bus connection
             * @param object_path path of remote object
             * @param interface_name D-Bus interface to invoke method on
             * @param method_name the name of the method to invoke
             * @param parameters a #GVariant tuple with parameters for the method     or %NULL if not passing parameters
             * @param reply_type the expected type of the reply (which will be a     tuple), or %NULL
             * @param flags flags from the #GDBusCallFlags enumeration
             * @param timeout_msec the timeout in milliseconds, -1 to use the default     timeout or %G_MAXINT for no timeout
             * @param cancellable a #GCancellable or %NULL
             * @param callback a #GAsyncReadyCallback to call when the request     is satisfied or %NULL if you don't care about the result of the     method invocation
             */
            call<T extends string = any>(
                bus_name: string | null,
                object_path: string,
                interface_name: string,
                method_name: string,
                parameters: GLib.Variant | null,
                reply_type: GLib.VariantType<T> | null,
                flags: DBusCallFlags | null,
                timeout_msec: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<GLib.Variant<T>> | void;
            /**
             * Finishes an operation started with g_dbus_connection_call().
             * @param res a #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_connection_call()
             * @returns %NULL if @error is set. Otherwise a non-floating     #GVariant tuple with return values. Free with g_variant_unref().
             */
            call_finish<T extends string = any>(res: AsyncResult): GLib.Variant<T>;
            /**
             * Synchronously invokes the `method_name` method on the
             * `interface_name` D-Bus interface on the remote object at
             * `object_path` owned by `bus_name`.
             *
             * If `connection` is closed then the operation will fail with
             * %G_IO_ERROR_CLOSED. If `cancellable` is canceled, the
             * operation will fail with %G_IO_ERROR_CANCELLED. If `parameters`
             * contains a value not compatible with the D-Bus protocol, the operation
             * fails with %G_IO_ERROR_INVALID_ARGUMENT.
             *
             * If `reply_type` is non-%NULL then the reply will be checked for having
             * this type and an error will be raised if it does not match.  Said
             * another way, if you give a `reply_type` then any non-%NULL return
             * value will be of this type.
             *
             * If the `parameters` #GVariant is floating, it is consumed.
             * This allows convenient 'inline' use of g_variant_new(), e.g.:
             *
             * ```c
             *  g_dbus_connection_call_sync (connection,
             *                               "org.freedesktop.StringThings",
             *                               "/org/freedesktop/StringThings",
             *                               "org.freedesktop.StringThings",
             *                               "TwoStrings",
             *                               g_variant_new ("(ss)",
             *                                              "Thing One",
             *                                              "Thing Two"),
             *                               NULL,
             *                               G_DBUS_CALL_FLAGS_NONE,
             *                               -1,
             *                               NULL,
             *                               &error);
             * ```
             *
             *
             * The calling thread is blocked until a reply is received. See
             * g_dbus_connection_call() for the asynchronous version of
             * this method.
             * @param bus_name a unique or well-known bus name or %NULL if     @connection is not a message bus connection
             * @param object_path path of remote object
             * @param interface_name D-Bus interface to invoke method on
             * @param method_name the name of the method to invoke
             * @param parameters a #GVariant tuple with parameters for the method     or %NULL if not passing parameters
             * @param reply_type the expected type of the reply, or %NULL
             * @param flags flags from the #GDBusCallFlags enumeration
             * @param timeout_msec the timeout in milliseconds, -1 to use the default     timeout or %G_MAXINT for no timeout
             * @param cancellable a #GCancellable or %NULL
             * @returns %NULL if @error is set. Otherwise a non-floating     #GVariant tuple with return values. Free with g_variant_unref().
             */
            call_sync(
                bus_name: string | null,
                object_path: string,
                interface_name: string,
                method_name: string,
                parameters: GLib.Variant | null,
                reply_type: GLib.VariantType | null,
                flags: DBusCallFlags | null,
                timeout_msec: number,
                cancellable?: Cancellable | null,
            ): GLib.Variant;
            /**
             * Like g_dbus_connection_call() but also takes a #GUnixFDList object.
             *
             * The file descriptors normally correspond to %G_VARIANT_TYPE_HANDLE
             * values in the body of the message. For example, if a message contains
             * two file descriptors, `fd_list` would have length 2, and
             * `g_variant_new_handle (0)` and `g_variant_new_handle (1)` would appear
             * somewhere in the body of the message (not necessarily in that order!)
             * to represent the file descriptors at indexes 0 and 1 respectively.
             *
             * When designing D-Bus APIs that are intended to be interoperable,
             * please note that non-GDBus implementations of D-Bus can usually only
             * access file descriptors if they are referenced in this way by a
             * value of type %G_VARIANT_TYPE_HANDLE in the body of the message.
             *
             * This method is only available on UNIX.
             * @param bus_name a unique or well-known bus name or %NULL if     @connection is not a message bus connection
             * @param object_path path of remote object
             * @param interface_name D-Bus interface to invoke method on
             * @param method_name the name of the method to invoke
             * @param parameters a #GVariant tuple with parameters for the method     or %NULL if not passing parameters
             * @param reply_type the expected type of the reply, or %NULL
             * @param flags flags from the #GDBusCallFlags enumeration
             * @param timeout_msec the timeout in milliseconds, -1 to use the default     timeout or %G_MAXINT for no timeout
             * @param fd_list a #GUnixFDList or %NULL
             * @param cancellable a #GCancellable or %NULL
             */
            call_with_unix_fd_list(
                bus_name: string | null,
                object_path: string,
                interface_name: string,
                method_name: string,
                parameters: GLib.Variant | null,
                reply_type: GLib.VariantType | null,
                flags: DBusCallFlags | null,
                timeout_msec: number,
                fd_list?: UnixFDList | null,
                cancellable?: Cancellable | null,
            ): Promise<[GLib.Variant, UnixFDList | null]>;
            /**
             * Like g_dbus_connection_call() but also takes a #GUnixFDList object.
             *
             * The file descriptors normally correspond to %G_VARIANT_TYPE_HANDLE
             * values in the body of the message. For example, if a message contains
             * two file descriptors, `fd_list` would have length 2, and
             * `g_variant_new_handle (0)` and `g_variant_new_handle (1)` would appear
             * somewhere in the body of the message (not necessarily in that order!)
             * to represent the file descriptors at indexes 0 and 1 respectively.
             *
             * When designing D-Bus APIs that are intended to be interoperable,
             * please note that non-GDBus implementations of D-Bus can usually only
             * access file descriptors if they are referenced in this way by a
             * value of type %G_VARIANT_TYPE_HANDLE in the body of the message.
             *
             * This method is only available on UNIX.
             * @param bus_name a unique or well-known bus name or %NULL if     @connection is not a message bus connection
             * @param object_path path of remote object
             * @param interface_name D-Bus interface to invoke method on
             * @param method_name the name of the method to invoke
             * @param parameters a #GVariant tuple with parameters for the method     or %NULL if not passing parameters
             * @param reply_type the expected type of the reply, or %NULL
             * @param flags flags from the #GDBusCallFlags enumeration
             * @param timeout_msec the timeout in milliseconds, -1 to use the default     timeout or %G_MAXINT for no timeout
             * @param fd_list a #GUnixFDList or %NULL
             * @param cancellable a #GCancellable or %NULL
             * @param callback a #GAsyncReadyCallback to call when the request is     satisfied or %NULL if you don't * care about the result of the     method invocation
             */
            call_with_unix_fd_list(
                bus_name: string | null,
                object_path: string,
                interface_name: string,
                method_name: string,
                parameters: GLib.Variant | null,
                reply_type: GLib.VariantType | null,
                flags: DBusCallFlags | null,
                timeout_msec: number,
                fd_list: UnixFDList | null,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Like g_dbus_connection_call() but also takes a #GUnixFDList object.
             *
             * The file descriptors normally correspond to %G_VARIANT_TYPE_HANDLE
             * values in the body of the message. For example, if a message contains
             * two file descriptors, `fd_list` would have length 2, and
             * `g_variant_new_handle (0)` and `g_variant_new_handle (1)` would appear
             * somewhere in the body of the message (not necessarily in that order!)
             * to represent the file descriptors at indexes 0 and 1 respectively.
             *
             * When designing D-Bus APIs that are intended to be interoperable,
             * please note that non-GDBus implementations of D-Bus can usually only
             * access file descriptors if they are referenced in this way by a
             * value of type %G_VARIANT_TYPE_HANDLE in the body of the message.
             *
             * This method is only available on UNIX.
             * @param bus_name a unique or well-known bus name or %NULL if     @connection is not a message bus connection
             * @param object_path path of remote object
             * @param interface_name D-Bus interface to invoke method on
             * @param method_name the name of the method to invoke
             * @param parameters a #GVariant tuple with parameters for the method     or %NULL if not passing parameters
             * @param reply_type the expected type of the reply, or %NULL
             * @param flags flags from the #GDBusCallFlags enumeration
             * @param timeout_msec the timeout in milliseconds, -1 to use the default     timeout or %G_MAXINT for no timeout
             * @param fd_list a #GUnixFDList or %NULL
             * @param cancellable a #GCancellable or %NULL
             * @param callback a #GAsyncReadyCallback to call when the request is     satisfied or %NULL if you don't * care about the result of the     method invocation
             */
            call_with_unix_fd_list(
                bus_name: string | null,
                object_path: string,
                interface_name: string,
                method_name: string,
                parameters: GLib.Variant | null,
                reply_type: GLib.VariantType | null,
                flags: DBusCallFlags | null,
                timeout_msec: number,
                fd_list?: UnixFDList | null,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<[GLib.Variant, UnixFDList | null]> | void;
            /**
             * Finishes an operation started with g_dbus_connection_call_with_unix_fd_list().
             *
             * The file descriptors normally correspond to %G_VARIANT_TYPE_HANDLE
             * values in the body of the message. For example,
             * if g_variant_get_handle() returns 5, that is intended to be a reference
             * to the file descriptor that can be accessed by
             * `g_unix_fd_list_get (*out_fd_list, 5, ...)`.
             *
             * When designing D-Bus APIs that are intended to be interoperable,
             * please note that non-GDBus implementations of D-Bus can usually only
             * access file descriptors if they are referenced in this way by a
             * value of type %G_VARIANT_TYPE_HANDLE in the body of the message.
             * @param res a #GAsyncResult obtained from the #GAsyncReadyCallback passed to     g_dbus_connection_call_with_unix_fd_list()
             * @returns %NULL if @error is set. Otherwise a non-floating     #GVariant tuple with return values. Free with g_variant_unref().
             */
            call_with_unix_fd_list_finish(res: AsyncResult): [GLib.Variant, UnixFDList | null];
            /**
             * Like g_dbus_connection_call_sync() but also takes and returns #GUnixFDList objects.
             * See g_dbus_connection_call_with_unix_fd_list() and
             * g_dbus_connection_call_with_unix_fd_list_finish() for more details.
             *
             * This method is only available on UNIX.
             * @param bus_name a unique or well-known bus name or %NULL     if @connection is not a message bus connection
             * @param object_path path of remote object
             * @param interface_name D-Bus interface to invoke method on
             * @param method_name the name of the method to invoke
             * @param parameters a #GVariant tuple with parameters for     the method or %NULL if not passing parameters
             * @param reply_type the expected type of the reply, or %NULL
             * @param flags flags from the #GDBusCallFlags enumeration
             * @param timeout_msec the timeout in milliseconds, -1 to use the default     timeout or %G_MAXINT for no timeout
             * @param fd_list a #GUnixFDList or %NULL
             * @param cancellable a #GCancellable or %NULL
             * @returns %NULL if @error is set. Otherwise a non-floating     #GVariant tuple with return values. Free with g_variant_unref().
             */
            call_with_unix_fd_list_sync(
                bus_name: string | null,
                object_path: string,
                interface_name: string,
                method_name: string,
                parameters: GLib.Variant | null,
                reply_type: GLib.VariantType | null,
                flags: DBusCallFlags | null,
                timeout_msec: number,
                fd_list?: UnixFDList | null,
                cancellable?: Cancellable | null,
            ): [GLib.Variant, UnixFDList | null];
            /**
             * Closes `connection`. Note that this never causes the process to
             * exit (this might only happen if the other end of a shared message
             * bus connection disconnects, see #GDBusConnection:exit-on-close).
             *
             * Once the connection is closed, operations such as sending a message
             * will return with the error %G_IO_ERROR_CLOSED. Closing a connection
             * will not automatically flush the connection so queued messages may
             * be lost. Use g_dbus_connection_flush() if you need such guarantees.
             *
             * If `connection` is already closed, this method fails with
             * %G_IO_ERROR_CLOSED.
             *
             * When `connection` has been closed, the #GDBusConnection::closed
             * signal is emitted in the thread-default main context
             * (see [method`GLib`.MainContext.push_thread_default])
             * of the thread that `connection` was constructed in.
             *
             * This is an asynchronous method. When the operation is finished,
             * `callback` will be invoked in the thread-default main context
             * (see [method`GLib`.MainContext.push_thread_default])
             * of the thread you are calling this method from. You can
             * then call g_dbus_connection_close_finish() to get the result of the
             * operation. See g_dbus_connection_close_sync() for the synchronous
             * version.
             * @param cancellable a #GCancellable or %NULL
             */
            close(cancellable?: Cancellable | null): Promise<boolean>;
            /**
             * Closes `connection`. Note that this never causes the process to
             * exit (this might only happen if the other end of a shared message
             * bus connection disconnects, see #GDBusConnection:exit-on-close).
             *
             * Once the connection is closed, operations such as sending a message
             * will return with the error %G_IO_ERROR_CLOSED. Closing a connection
             * will not automatically flush the connection so queued messages may
             * be lost. Use g_dbus_connection_flush() if you need such guarantees.
             *
             * If `connection` is already closed, this method fails with
             * %G_IO_ERROR_CLOSED.
             *
             * When `connection` has been closed, the #GDBusConnection::closed
             * signal is emitted in the thread-default main context
             * (see [method`GLib`.MainContext.push_thread_default])
             * of the thread that `connection` was constructed in.
             *
             * This is an asynchronous method. When the operation is finished,
             * `callback` will be invoked in the thread-default main context
             * (see [method`GLib`.MainContext.push_thread_default])
             * of the thread you are calling this method from. You can
             * then call g_dbus_connection_close_finish() to get the result of the
             * operation. See g_dbus_connection_close_sync() for the synchronous
             * version.
             * @param cancellable a #GCancellable or %NULL
             * @param callback a #GAsyncReadyCallback to call when the request is     satisfied or %NULL if you don't care about the result
             */
            close(cancellable: Cancellable | null, callback: AsyncReadyCallback<this> | null): void;
            /**
             * Closes `connection`. Note that this never causes the process to
             * exit (this might only happen if the other end of a shared message
             * bus connection disconnects, see #GDBusConnection:exit-on-close).
             *
             * Once the connection is closed, operations such as sending a message
             * will return with the error %G_IO_ERROR_CLOSED. Closing a connection
             * will not automatically flush the connection so queued messages may
             * be lost. Use g_dbus_connection_flush() if you need such guarantees.
             *
             * If `connection` is already closed, this method fails with
             * %G_IO_ERROR_CLOSED.
             *
             * When `connection` has been closed, the #GDBusConnection::closed
             * signal is emitted in the thread-default main context
             * (see [method`GLib`.MainContext.push_thread_default])
             * of the thread that `connection` was constructed in.
             *
             * This is an asynchronous method. When the operation is finished,
             * `callback` will be invoked in the thread-default main context
             * (see [method`GLib`.MainContext.push_thread_default])
             * of the thread you are calling this method from. You can
             * then call g_dbus_connection_close_finish() to get the result of the
             * operation. See g_dbus_connection_close_sync() for the synchronous
             * version.
             * @param cancellable a #GCancellable or %NULL
             * @param callback a #GAsyncReadyCallback to call when the request is     satisfied or %NULL if you don't care about the result
             */
            close(
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<boolean> | void;
            /**
             * Finishes an operation started with g_dbus_connection_close().
             * @param res a #GAsyncResult obtained from the #GAsyncReadyCallback passed     to g_dbus_connection_close()
             * @returns %TRUE if the operation succeeded, %FALSE if @error is set
             */
            close_finish(res: AsyncResult): boolean;
            /**
             * Synchronously closes `connection`. The calling thread is blocked
             * until this is done. See g_dbus_connection_close() for the
             * asynchronous version of this method and more details about what it
             * does.
             * @param cancellable a #GCancellable or %NULL
             * @returns %TRUE if the operation succeeded, %FALSE if @error is set
             */
            close_sync(cancellable?: Cancellable | null): boolean;
            /**
             * Emits a signal.
             *
             * If the parameters GVariant is floating, it is consumed.
             *
             * This can only fail if `parameters` is not compatible with the D-Bus protocol
             * (%G_IO_ERROR_INVALID_ARGUMENT), or if `connection` has been closed
             * (%G_IO_ERROR_CLOSED).
             * @param destination_bus_name the unique bus name for the destination     for the signal or %NULL to emit to all listeners
             * @param object_path path of remote object
             * @param interface_name D-Bus interface to emit a signal on
             * @param signal_name the name of the signal to emit
             * @param parameters a #GVariant tuple with parameters for the signal              or %NULL if not passing parameters
             * @returns %TRUE unless @error is set
             */
            emit_signal(
                destination_bus_name: string | null,
                object_path: string,
                interface_name: string,
                signal_name: string,
                parameters?: GLib.Variant | null,
            ): boolean;
            /**
             * Exports `action_group` on `connection` at `object_path`.
             *
             * The implemented D-Bus API should be considered private.  It is
             * subject to change in the future.
             *
             * A given object path can only have one action group exported on it.
             * If this constraint is violated, the export will fail and 0 will be
             * returned (with `error` set accordingly).
             *
             * You can unexport the action group using
             * [method`Gio`.DBusConnection.unexport_action_group] with the return value of
             * this function.
             *
             * The thread default main context is taken at the time of this call.
             * All incoming action activations and state change requests are
             * reported from this context.  Any changes on the action group that
             * cause it to emit signals must also come from this same context.
             * Since incoming action activations and state change requests are
             * rather likely to cause changes on the action group, this effectively
             * limits a given action group to being exported from only one main
             * context.
             * @param object_path a D-Bus object path
             * @param action_group an action group
             * @returns the ID of the export (never zero), or 0 in case of failure
             */
            export_action_group(object_path: string, action_group: ActionGroup): number;
            /**
             * Exports `menu` on `connection` at `object_path`.
             *
             * The implemented D-Bus API should be considered private.
             * It is subject to change in the future.
             *
             * An object path can only have one menu model exported on it. If this
             * constraint is violated, the export will fail and 0 will be
             * returned (with `error` set accordingly).
             *
             * Exporting menus with sections containing more than
             * %G_MENU_EXPORTER_MAX_SECTION_SIZE items is not supported and results in
             * undefined behavior.
             *
             * You can unexport the menu model using
             * g_dbus_connection_unexport_menu_model() with the return value of
             * this function.
             * @param object_path a D-Bus object path
             * @param menu a #GMenuModel
             * @returns the ID of the export (never zero), or 0 in case of failure
             */
            export_menu_model(object_path: string, menu: MenuModel): number;
            /**
             * Asynchronously flushes `connection,` that is, writes all queued
             * outgoing messages to the transport and then flushes the transport
             * (using g_output_stream_flush_async()). This is useful in programs
             * that want to emit a D-Bus signal and then exit immediately. Without
             * flushing the connection, there is no guarantee that the message has
             * been sent to the networking buffers in the OS kernel.
             *
             * This is an asynchronous method. When the operation is finished,
             * `callback` will be invoked in the thread-default main context
             * (see [method`GLib`.MainContext.push_thread_default])
             * of the thread you are calling this method from. You can
             * then call g_dbus_connection_flush_finish() to get the result of the
             * operation. See g_dbus_connection_flush_sync() for the synchronous
             * version.
             * @param cancellable a #GCancellable or %NULL
             */
            flush(cancellable?: Cancellable | null): Promise<boolean>;
            /**
             * Asynchronously flushes `connection,` that is, writes all queued
             * outgoing messages to the transport and then flushes the transport
             * (using g_output_stream_flush_async()). This is useful in programs
             * that want to emit a D-Bus signal and then exit immediately. Without
             * flushing the connection, there is no guarantee that the message has
             * been sent to the networking buffers in the OS kernel.
             *
             * This is an asynchronous method. When the operation is finished,
             * `callback` will be invoked in the thread-default main context
             * (see [method`GLib`.MainContext.push_thread_default])
             * of the thread you are calling this method from. You can
             * then call g_dbus_connection_flush_finish() to get the result of the
             * operation. See g_dbus_connection_flush_sync() for the synchronous
             * version.
             * @param cancellable a #GCancellable or %NULL
             * @param callback a #GAsyncReadyCallback to call when the     request is satisfied or %NULL if you don't care about the result
             */
            flush(cancellable: Cancellable | null, callback: AsyncReadyCallback<this> | null): void;
            /**
             * Asynchronously flushes `connection,` that is, writes all queued
             * outgoing messages to the transport and then flushes the transport
             * (using g_output_stream_flush_async()). This is useful in programs
             * that want to emit a D-Bus signal and then exit immediately. Without
             * flushing the connection, there is no guarantee that the message has
             * been sent to the networking buffers in the OS kernel.
             *
             * This is an asynchronous method. When the operation is finished,
             * `callback` will be invoked in the thread-default main context
             * (see [method`GLib`.MainContext.push_thread_default])
             * of the thread you are calling this method from. You can
             * then call g_dbus_connection_flush_finish() to get the result of the
             * operation. See g_dbus_connection_flush_sync() for the synchronous
             * version.
             * @param cancellable a #GCancellable or %NULL
             * @param callback a #GAsyncReadyCallback to call when the     request is satisfied or %NULL if you don't care about the result
             */
            flush(
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<boolean> | void;
            /**
             * Finishes an operation started with g_dbus_connection_flush().
             * @param res a #GAsyncResult obtained from the #GAsyncReadyCallback passed     to g_dbus_connection_flush()
             * @returns %TRUE if the operation succeeded, %FALSE if @error is set
             */
            flush_finish(res: AsyncResult): boolean;
            /**
             * Synchronously flushes `connection`. The calling thread is blocked
             * until this is done. See g_dbus_connection_flush() for the
             * asynchronous version of this method and more details about what it
             * does.
             * @param cancellable a #GCancellable or %NULL
             * @returns %TRUE if the operation succeeded, %FALSE if @error is set
             */
            flush_sync(cancellable?: Cancellable | null): boolean;
            /**
             * Gets the capabilities negotiated with the remote peer
             * @returns zero or more flags from the #GDBusCapabilityFlags enumeration
             */
            get_capabilities(): DBusCapabilityFlags;
            /**
             * Gets whether the process is terminated when `connection` is
             * closed by the remote peer. See
             * #GDBusConnection:exit-on-close for more details.
             * @returns whether the process is terminated when @connection is     closed by the remote peer
             */
            get_exit_on_close(): boolean;
            /**
             * Gets the flags used to construct this connection
             * @returns zero or more flags from the #GDBusConnectionFlags enumeration
             */
            get_flags(): DBusConnectionFlags;
            /**
             * The GUID of the peer performing the role of server when
             * authenticating. See #GDBusConnection:guid for more details.
             * @returns The GUID. Do not free this string, it is owned by     @connection.
             */
            get_guid(): string;
            /**
             * Retrieves the last serial number assigned to a #GDBusMessage on
             * the current thread. This includes messages sent via both low-level
             * API such as g_dbus_connection_send_message() as well as
             * high-level API such as g_dbus_connection_emit_signal(),
             * g_dbus_connection_call() or g_dbus_proxy_call().
             * @returns the last used serial or zero when no message has been sent     within the current thread
             */
            get_last_serial(): number;
            /**
             * Gets the credentials of the authenticated peer. This will always
             * return %NULL unless `connection` acted as a server
             * (e.g. %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER was passed)
             * when set up and the client passed credentials as part of the
             * authentication process.
             *
             * In a message bus setup, the message bus is always the server and
             * each application is a client. So this method will always return
             * %NULL for message bus clients.
             * @returns a #GCredentials or %NULL if not     available. Do not free this object, it is owned by @connection.
             */
            get_peer_credentials(): Credentials | null;
            /**
             * Gets the underlying stream used for IO.
             *
             * While the #GDBusConnection is active, it will interact with this
             * stream from a worker thread, so it is not safe to interact with
             * the stream directly.
             * @returns the stream used for IO
             */
            get_stream(): IOStream;
            /**
             * Gets the unique name of `connection` as assigned by the message
             * bus. This can also be used to figure out if `connection` is a
             * message bus connection.
             * @returns the unique name or %NULL if @connection is not a message     bus connection. Do not free this string, it is owned by     @connection.
             */
            get_unique_name(): string | null;
            /**
             * Gets whether `connection` is closed.
             * @returns %TRUE if the connection is closed, %FALSE otherwise
             */
            is_closed(): boolean;
            /**
             * Registers callbacks for exported objects at `object_path` with the
             * D-Bus interface that is described in `interface_info`.
             *
             * Calls to functions in `vtable` (and `user_data_free_func)` will happen
             * in the thread-default main context
             * (see [method`GLib`.MainContext.push_thread_default])
             * of the thread you are calling this method from.
             *
             * Note that all #GVariant values passed to functions in `vtable` will match
             * the signature given in `interface_info` - if a remote caller passes
             * incorrect values, the `org.freedesktop.DBus.Error.InvalidArgs`
             * is returned to the remote caller.
             *
             * Additionally, if the remote caller attempts to invoke methods or
             * access properties not mentioned in `interface_info` the
             * `org.freedesktop.DBus.Error.UnknownMethod` resp.
             * `org.freedesktop.DBus.Error.InvalidArgs` errors
             * are returned to the caller.
             *
             * It is considered a programming error if the
             * #GDBusInterfaceGetPropertyFunc function in `vtable` returns a
             * #GVariant of incorrect type.
             *
             * If an existing callback is already registered at `object_path` and
             * `interface_name,` then `error` is set to %G_IO_ERROR_EXISTS.
             *
             * GDBus automatically implements the standard D-Bus interfaces
             * org.freedesktop.DBus.Properties, org.freedesktop.DBus.Introspectable
             * and org.freedesktop.Peer, so you don't have to implement those for the
             * objects you export. You can implement org.freedesktop.DBus.Properties
             * yourself, e.g. to handle getting and setting of properties asynchronously.
             *
             * Note that the reference count on `interface_info` will be
             * incremented by 1 (unless allocated statically, e.g. if the
             * reference count is -1, see g_dbus_interface_info_ref()) for as long
             * as the object is exported. Also note that `vtable` will be copied.
             *
             * See this [server][class`Gio`.DBusConnection#an-example-d-bus-server]
             * for an example of how to use this method.
             * @param object_path the object path to register at
             * @param interface_info introspection data for the interface
             * @param vtable a #GDBusInterfaceVTable to call into or %NULL
             * @param user_data data to pass to functions in @vtable
             * @returns 0 if @error is set, otherwise a registration id (never 0)     that can be used with g_dbus_connection_unregister_object()
             */
            register_object(
                object_path: string,
                interface_info: DBusInterfaceInfo,
                vtable?: DBusInterfaceVTable | null,
                user_data?: any | null,
            ): number;
            /**
             * Version of g_dbus_connection_register_object() using closures instead of a
             * #GDBusInterfaceVTable for easier binding in other languages.
             *
             * Note that the reference counting semantics of the function wrapped by
             * `method_call_closure` are the same as those of
             * [callback`Gio`.DBusInterfaceMethodCallFunc]: ownership of a reference to the
             * [class`Gio`.DBusMethodInvocation] is transferred to the function.
             * @param object_path The object path to register at.
             * @param interface_info Introspection data for the interface.
             * @param method_call_closure #GClosure for handling incoming method calls.
             * @param get_property_closure #GClosure for getting a property.
             * @param set_property_closure #GClosure for setting a property.
             * @returns 0 if @error is set, otherwise a registration ID (never 0) that can be used with g_dbus_connection_unregister_object() .
             */
            register_object(
                object_path: string,
                interface_info: DBusInterfaceInfo,
                method_call_closure?: GObject.Closure | null,
                get_property_closure?: GObject.Closure | null,
                set_property_closure?: GObject.Closure | null,
            ): number;
            /**
             * Version of [method`Gio`.DBusConnection.register_object] using closures instead
             * of a [type`Gio`.DBusInterfaceVTable] for easier binding in other languages.
             *
             * In contrast to [method`Gio`.DBusConnection.register_object] and
             * [method`Gio`.DBusConnection.register_object_with_closures], the reference
             * counting semantics of the function wrapped by `method_call_closure` are *not*
             * the same as those of [callback`Gio`.DBusInterfaceMethodCallFunc]. Ownership of
             * a reference to the [class`Gio`.DBusMethodInvocation] is *not* transferred to
             * the function. Bindings must ensure that they add a reference to the
             * [class`Gio`.DBusMethodInvocation] before calling any
             * `g_dbus_method_invocation_return_*()` methods on it. This should be automatic
             * as a result of the introspection annotations on those methods.
             * @param object_path The object path to register at.
             * @param interface_info Introspection data for the interface.
             * @param method_call_closure [type@GObject.Closure] for handling incoming method calls.
             * @param get_property_closure [type@GObject.Closure] for getting a property.
             * @param set_property_closure [type@GObject.Closure] for setting a property.
             * @returns `0` if @error is set, otherwise a registration ID (never `0`) that can be used with [method@Gio.DBusConnection.unregister_object].
             */
            register_object_with_closures2(
                object_path: string,
                interface_info: DBusInterfaceInfo,
                method_call_closure?: GObject.Closure | null,
                get_property_closure?: GObject.Closure | null,
                set_property_closure?: GObject.Closure | null,
            ): number;
            /**
             * Registers a whole subtree of dynamic objects.
             *
             * The `enumerate` and `introspection` functions in `vtable` are used to
             * convey, to remote callers, what nodes exist in the subtree rooted
             * by `object_path`.
             *
             * When handling remote calls into any node in the subtree, first the
             * `enumerate` function is used to check if the node exists. If the node exists
             * or the %G_DBUS_SUBTREE_FLAGS_DISPATCH_TO_UNENUMERATED_NODES flag is set
             * the `introspection` function is used to check if the node supports the
             * requested method. If so, the `dispatch` function is used to determine
             * where to dispatch the call. The collected #GDBusInterfaceVTable and
             * #gpointer will be used to call into the interface vtable for processing
             * the request.
             *
             * All calls into user-provided code will be invoked in the thread-default
             * main context (see [method`GLib`.MainContext.push_thread_default])
             * of the thread you are calling this method from.
             *
             * If an existing subtree is already registered at `object_path` or
             * then `error` is set to %G_IO_ERROR_EXISTS.
             *
             * Note that it is valid to register regular objects (using
             * g_dbus_connection_register_object()) in a subtree registered with
             * g_dbus_connection_register_subtree() - if so, the subtree handler
             * is tried as the last resort. One way to think about a subtree
             * handler is to consider it a fallback handler for object paths not
             * registered via g_dbus_connection_register_object() or other bindings.
             *
             * Note that `vtable` will be copied so you cannot change it after
             * registration.
             *
             * See this [server][class`Gio`.DBusConnection#an-example-for-exporting-a-subtree]
             * for an example of how to use this method.
             * @param object_path the object path to register the subtree at
             * @param vtable a #GDBusSubtreeVTable to enumerate, introspect and     dispatch nodes in the subtree
             * @param flags flags used to fine tune the behavior of the subtree
             * @param user_data data to pass to functions in @vtable
             * @returns 0 if @error is set, otherwise a subtree registration ID (never 0) that can be used with g_dbus_connection_unregister_subtree()
             */
            register_subtree(
                object_path: string,
                vtable: DBusSubtreeVTable,
                flags: DBusSubtreeFlags | null,
                user_data?: any | null,
            ): number;
            /**
             * Removes a filter.
             *
             * Note that since filters run in a different thread, there is a race
             * condition where it is possible that the filter will be running even
             * after calling g_dbus_connection_remove_filter(), so you cannot just
             * free data that the filter might be using. Instead, you should pass
             * a #GDestroyNotify to g_dbus_connection_add_filter(), which will be
             * called when it is guaranteed that the data is no longer needed.
             * @param filter_id an identifier obtained from g_dbus_connection_add_filter()
             */
            remove_filter(filter_id: number): void;
            /**
             * Asynchronously sends `message` to the peer represented by `connection`.
             *
             * Unless `flags` contain the
             * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag, the serial number
             * will be assigned by `connection` and set on `message` via
             * g_dbus_message_set_serial(). If `out_serial` is not %NULL, then the
             * serial number used will be written to this location prior to
             * submitting the message to the underlying transport. While it has a `volatile`
             * qualifier, this is a historical artifact and the argument passed to it should
             * not be `volatile`.
             *
             * If `connection` is closed then the operation will fail with
             * %G_IO_ERROR_CLOSED. If `message` is not well-formed,
             * the operation fails with %G_IO_ERROR_INVALID_ARGUMENT.
             *
             * See this [server][class`Gio`.DBusConnection#an-example-d-bus-server]
             * and [client][class`Gio`.DBusConnection#an-example-for-file-descriptor-passing]
             * for an example of how to use this low-level API to send and receive
             * UNIX file descriptors.
             *
             * Note that `message` must be unlocked, unless `flags` contain the
             * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag.
             * @param message a #GDBusMessage
             * @param flags flags affecting how the message is sent
             * @returns %TRUE if the message was well-formed and queued for     transmission, %FALSE if @error is set
             */
            send_message(message: DBusMessage, flags: DBusSendMessageFlags | null): [boolean, number];
            /**
             * Asynchronously sends `message` to the peer represented by `connection`.
             *
             * Unless `flags` contain the
             * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag, the serial number
             * will be assigned by `connection` and set on `message` via
             * g_dbus_message_set_serial(). If `out_serial` is not %NULL, then the
             * serial number used will be written to this location prior to
             * submitting the message to the underlying transport. While it has a `volatile`
             * qualifier, this is a historical artifact and the argument passed to it should
             * not be `volatile`.
             *
             * If `connection` is closed then the operation will fail with
             * %G_IO_ERROR_CLOSED. If `cancellable` is canceled, the operation will
             * fail with %G_IO_ERROR_CANCELLED. If `message` is not well-formed,
             * the operation fails with %G_IO_ERROR_INVALID_ARGUMENT.
             *
             * This is an asynchronous method. When the operation is finished, `callback`
             * will be invoked in the thread-default main context
             * (see [method`GLib`.MainContext.push_thread_default])
             * of the thread you are calling this method from. You can then call
             * g_dbus_connection_send_message_with_reply_finish() to get the result of the operation.
             * See g_dbus_connection_send_message_with_reply_sync() for the synchronous version.
             *
             * Note that `message` must be unlocked, unless `flags` contain the
             * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag.
             *
             * See this [server][class`Gio`.DBusConnection#an-example-d-bus-server]
             * and [client][class`Gio`.DBusConnection#an-example-for-file-descriptor-passing]
             * for an example of how to use this low-level API to send and receive
             * UNIX file descriptors.
             * @param message a #GDBusMessage
             * @param flags flags affecting how the message is sent
             * @param timeout_msec the timeout in milliseconds, -1 to use the default     timeout or %G_MAXINT for no timeout
             * @param cancellable a #GCancellable or %NULL
             */
            send_message_with_reply(
                message: DBusMessage,
                flags: DBusSendMessageFlags | null,
                timeout_msec: number,
                cancellable?: Cancellable | null,
            ): [Promise<DBusMessage>, number];
            /**
             * Asynchronously sends `message` to the peer represented by `connection`.
             *
             * Unless `flags` contain the
             * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag, the serial number
             * will be assigned by `connection` and set on `message` via
             * g_dbus_message_set_serial(). If `out_serial` is not %NULL, then the
             * serial number used will be written to this location prior to
             * submitting the message to the underlying transport. While it has a `volatile`
             * qualifier, this is a historical artifact and the argument passed to it should
             * not be `volatile`.
             *
             * If `connection` is closed then the operation will fail with
             * %G_IO_ERROR_CLOSED. If `cancellable` is canceled, the operation will
             * fail with %G_IO_ERROR_CANCELLED. If `message` is not well-formed,
             * the operation fails with %G_IO_ERROR_INVALID_ARGUMENT.
             *
             * This is an asynchronous method. When the operation is finished, `callback`
             * will be invoked in the thread-default main context
             * (see [method`GLib`.MainContext.push_thread_default])
             * of the thread you are calling this method from. You can then call
             * g_dbus_connection_send_message_with_reply_finish() to get the result of the operation.
             * See g_dbus_connection_send_message_with_reply_sync() for the synchronous version.
             *
             * Note that `message` must be unlocked, unless `flags` contain the
             * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag.
             *
             * See this [server][class`Gio`.DBusConnection#an-example-d-bus-server]
             * and [client][class`Gio`.DBusConnection#an-example-for-file-descriptor-passing]
             * for an example of how to use this low-level API to send and receive
             * UNIX file descriptors.
             * @param message a #GDBusMessage
             * @param flags flags affecting how the message is sent
             * @param timeout_msec the timeout in milliseconds, -1 to use the default     timeout or %G_MAXINT for no timeout
             * @param cancellable a #GCancellable or %NULL
             * @param callback a #GAsyncReadyCallback to call when the request     is satisfied or %NULL if you don't care about the result
             */
            send_message_with_reply(
                message: DBusMessage,
                flags: DBusSendMessageFlags | null,
                timeout_msec: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): number;
            /**
             * Asynchronously sends `message` to the peer represented by `connection`.
             *
             * Unless `flags` contain the
             * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag, the serial number
             * will be assigned by `connection` and set on `message` via
             * g_dbus_message_set_serial(). If `out_serial` is not %NULL, then the
             * serial number used will be written to this location prior to
             * submitting the message to the underlying transport. While it has a `volatile`
             * qualifier, this is a historical artifact and the argument passed to it should
             * not be `volatile`.
             *
             * If `connection` is closed then the operation will fail with
             * %G_IO_ERROR_CLOSED. If `cancellable` is canceled, the operation will
             * fail with %G_IO_ERROR_CANCELLED. If `message` is not well-formed,
             * the operation fails with %G_IO_ERROR_INVALID_ARGUMENT.
             *
             * This is an asynchronous method. When the operation is finished, `callback`
             * will be invoked in the thread-default main context
             * (see [method`GLib`.MainContext.push_thread_default])
             * of the thread you are calling this method from. You can then call
             * g_dbus_connection_send_message_with_reply_finish() to get the result of the operation.
             * See g_dbus_connection_send_message_with_reply_sync() for the synchronous version.
             *
             * Note that `message` must be unlocked, unless `flags` contain the
             * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag.
             *
             * See this [server][class`Gio`.DBusConnection#an-example-d-bus-server]
             * and [client][class`Gio`.DBusConnection#an-example-for-file-descriptor-passing]
             * for an example of how to use this low-level API to send and receive
             * UNIX file descriptors.
             * @param message a #GDBusMessage
             * @param flags flags affecting how the message is sent
             * @param timeout_msec the timeout in milliseconds, -1 to use the default     timeout or %G_MAXINT for no timeout
             * @param cancellable a #GCancellable or %NULL
             * @param callback a #GAsyncReadyCallback to call when the request     is satisfied or %NULL if you don't care about the result
             */
            send_message_with_reply(
                message: DBusMessage,
                flags: DBusSendMessageFlags | null,
                timeout_msec: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): [Promise<DBusMessage> | void, number];
            /**
             * Finishes an operation started with g_dbus_connection_send_message_with_reply().
             *
             * Note that `error` is only set if a local in-process error
             * occurred. That is to say that the returned #GDBusMessage object may
             * be of type %G_DBUS_MESSAGE_TYPE_ERROR. Use
             * g_dbus_message_to_gerror() to transcode this to a #GError.
             *
             * See this [server][class`Gio`.DBusConnection#an-example-d-bus-server]
             * and [client][class`Gio`.DBusConnection#an-example-for-file-descriptor-passing]
             * for an example of how to use this low-level API to send and receive
             * UNIX file descriptors.
             * @param res a #GAsyncResult obtained from the #GAsyncReadyCallback passed to     g_dbus_connection_send_message_with_reply()
             * @returns a locked #GDBusMessage or %NULL if @error is set
             */
            send_message_with_reply_finish(res: AsyncResult): DBusMessage;
            /**
             * Synchronously sends `message` to the peer represented by `connection`
             * and blocks the calling thread until a reply is received or the
             * timeout is reached. See g_dbus_connection_send_message_with_reply()
             * for the asynchronous version of this method.
             *
             * Unless `flags` contain the
             * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag, the serial number
             * will be assigned by `connection` and set on `message` via
             * g_dbus_message_set_serial(). If `out_serial` is not %NULL, then the
             * serial number used will be written to this location prior to
             * submitting the message to the underlying transport. While it has a `volatile`
             * qualifier, this is a historical artifact and the argument passed to it should
             * not be `volatile`.
             *
             * If `connection` is closed then the operation will fail with
             * %G_IO_ERROR_CLOSED. If `cancellable` is canceled, the operation will
             * fail with %G_IO_ERROR_CANCELLED. If `message` is not well-formed,
             * the operation fails with %G_IO_ERROR_INVALID_ARGUMENT.
             *
             * Note that `error` is only set if a local in-process error
             * occurred. That is to say that the returned #GDBusMessage object may
             * be of type %G_DBUS_MESSAGE_TYPE_ERROR. Use
             * g_dbus_message_to_gerror() to transcode this to a #GError.
             *
             * See this [server][class`Gio`.DBusConnection#an-example-d-bus-server]
             * and [client][class`Gio`.DBusConnection#an-example-for-file-descriptor-passing]
             * for an example of how to use this low-level API to send and receive
             * UNIX file descriptors.
             *
             * Note that `message` must be unlocked, unless `flags` contain the
             * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag.
             * @param message a #GDBusMessage
             * @param flags flags affecting how the message is sent.
             * @param timeout_msec the timeout in milliseconds, -1 to use the default     timeout or %G_MAXINT for no timeout
             * @param cancellable a #GCancellable or %NULL
             * @returns a locked #GDBusMessage that is the reply     to @message or %NULL if @error is set
             */
            send_message_with_reply_sync(
                message: DBusMessage,
                flags: DBusSendMessageFlags | null,
                timeout_msec: number,
                cancellable?: Cancellable | null,
            ): [DBusMessage, number];
            /**
             * Sets whether the process should be terminated when `connection` is
             * closed by the remote peer. See #GDBusConnection:exit-on-close for
             * more details.
             *
             * Note that this function should be used with care. Most modern UNIX
             * desktops tie the notion of a user session with the session bus, and expect
             * all of a user's applications to quit when their bus connection goes away.
             * If you are setting `exit_on_close` to %FALSE for the shared session
             * bus connection, you should make sure that your application exits
             * when the user session ends.
             * @param exit_on_close whether the process should be terminated     when @connection is closed by the remote peer
             */
            set_exit_on_close(exit_on_close: boolean): void;
            /**
             * Subscribes to signals on `connection` and invokes `callback` whenever
             * the signal is received. Note that `callback` will be invoked in the
             * thread-default main context (see [method`GLib`.MainContext.push_thread_default])
             * of the thread you are calling this method from.
             *
             * If `connection` is not a message bus connection, `sender` must be
             * %NULL.
             *
             * If `sender` is a well-known name note that `callback` is invoked with
             * the unique name for the owner of `sender,` not the well-known name
             * as one would expect. This is because the message bus rewrites the
             * name. As such, to avoid certain race conditions, users should be
             * tracking the name owner of the well-known name and use that when
             * processing the received signal.
             *
             * If one of %G_DBUS_SIGNAL_FLAGS_MATCH_ARG0_NAMESPACE or
             * %G_DBUS_SIGNAL_FLAGS_MATCH_ARG0_PATH are given, `arg0` is
             * interpreted as part of a namespace or path.  The first argument
             * of a signal is matched against that part as specified by D-Bus.
             *
             * If `user_data_free_func` is non-%NULL, it will be called (in the
             * thread-default main context of the thread you are calling this
             * method from) at some point after `user_data` is no longer
             * needed. (It is not guaranteed to be called synchronously when the
             * signal is unsubscribed from, and may be called after `connection`
             * has been destroyed.)
             *
             * As `callback` is potentially invoked in a different thread from where it’s
             * emitted, it’s possible for this to happen after
             * g_dbus_connection_signal_unsubscribe() has been called in another thread.
             * Due to this, `user_data` should have a strong reference which is freed with
             * `user_data_free_func,` rather than pointing to data whose lifecycle is tied
             * to the signal subscription. For example, if a #GObject is used to store the
             * subscription ID from g_dbus_connection_signal_subscribe(), a strong reference
             * to that #GObject must be passed to `user_data,` and g_object_unref() passed to
             * `user_data_free_func`. You are responsible for breaking the resulting
             * reference count cycle by explicitly unsubscribing from the signal when
             * dropping the last external reference to the #GObject. Alternatively, a weak
             * reference may be used.
             *
             * It is guaranteed that if you unsubscribe from a signal using
             * g_dbus_connection_signal_unsubscribe() from the same thread which made the
             * corresponding g_dbus_connection_signal_subscribe() call, `callback` will not
             * be invoked after g_dbus_connection_signal_unsubscribe() returns.
             *
             * The returned subscription identifier is an opaque value which is guaranteed
             * to never be zero.
             *
             * This function can never fail.
             * @param sender sender name to match on (unique or well-known name)     or %NULL to listen from all senders
             * @param interface_name D-Bus interface name to match on or %NULL to     match on all interfaces
             * @param member D-Bus signal name to match on or %NULL to match on     all signals
             * @param object_path object path to match on or %NULL to match on     all object paths
             * @param arg0 contents of first string argument to match on or %NULL     to match on all kinds of arguments
             * @param flags #GDBusSignalFlags describing how arg0 is used in subscribing to the     signal
             * @param callback callback to invoke when there is a signal matching the requested data
             * @param user_data_free_func function to free @user_data with when     subscription is removed or %NULL
             * @returns a subscription identifier that can be used with g_dbus_connection_signal_unsubscribe()
             */
            signal_subscribe(
                sender: string | null,
                interface_name: string | null,
                member: string | null,
                object_path: string | null,
                arg0: string | null,
                flags: DBusSignalFlags | null,
                callback: DBusSignalCallback,
                user_data_free_func?: GLib.DestroyNotify | null,
            ): number;
            /**
             * Unsubscribes from signals.
             *
             * Note that there may still be D-Bus traffic to process (relating to this
             * signal subscription) in the current thread-default #GMainContext after this
             * function has returned. You should continue to iterate the #GMainContext
             * until the #GDestroyNotify function passed to
             * g_dbus_connection_signal_subscribe() is called, in order to avoid memory
             * leaks through callbacks queued on the #GMainContext after it’s stopped being
             * iterated.
             * Alternatively, any idle source with a priority lower than %G_PRIORITY_DEFAULT
             * that was scheduled after unsubscription, also indicates that all resources
             * of this subscription are released.
             * @param subscription_id a subscription id obtained from     g_dbus_connection_signal_subscribe()
             */
            signal_unsubscribe(subscription_id: number): void;
            /**
             * If `connection` was created with
             * %G_DBUS_CONNECTION_FLAGS_DELAY_MESSAGE_PROCESSING, this method
             * starts processing messages. Does nothing on if `connection` wasn't
             * created with this flag or if the method has already been called.
             */
            start_message_processing(): void;
            /**
             * Reverses the effect of a previous call to
             * [method`Gio`.DBusConnection.export_action_group].
             *
             * It is an error to call this function with an ID that wasn’t returned from
             * [method`Gio`.DBusConnection.export_action_group] or to call it with the same
             * ID more than once.
             * @param export_id the ID from [method@Gio.DBusConnection.export_action_group]
             */
            unexport_action_group(export_id: number): void;
            /**
             * Reverses the effect of a previous call to
             * g_dbus_connection_export_menu_model().
             *
             * It is an error to call this function with an ID that wasn't returned
             * from g_dbus_connection_export_menu_model() or to call it with the
             * same ID more than once.
             * @param export_id the ID from g_dbus_connection_export_menu_model()
             */
            unexport_menu_model(export_id: number): void;
            /**
             * Unregisters an object.
             * @param registration_id a registration id obtained from     g_dbus_connection_register_object()
             * @returns %TRUE if the object was unregistered, %FALSE otherwise
             */
            unregister_object(registration_id: number): boolean;
            /**
             * Unregisters a subtree.
             * @param registration_id a subtree registration id obtained from     g_dbus_connection_register_subtree()
             * @returns %TRUE if the subtree was unregistered, %FALSE otherwise
             */
            unregister_subtree(registration_id: number): boolean;
            watch_name(
                name: string,
                flags: BusNameWatcherFlags | null,
                name_appeared_closure?: GObject.Closure | null,
                name_vanished_closure?: GObject.Closure | null,
            ): number;
            unwatch_name(watcher_id: number): void;
            own_name(
                name: string,
                flags: BusNameOwnerFlags | null,
                name_acquired_closure?: GObject.Closure | null,
                name_lost_closure?: GObject.Closure | null,
            ): number;
            unown_name(owner_id: number): void;

            // Inherited methods
            /**
             * Starts asynchronous initialization of the object implementing the
             * interface. This must be done before any real use of the object after
             * initial construction. If the object also implements #GInitable you can
             * optionally call g_initable_init() instead.
             *
             * This method is intended for language bindings. If writing in C,
             * g_async_initable_new_async() should typically be used instead.
             *
             * When the initialization is finished, `callback` will be called. You can
             * then call g_async_initable_init_finish() to get the result of the
             * initialization.
             *
             * Implementations may also support cancellation. If `cancellable` is not
             * %NULL, then initialization can be cancelled by triggering the cancellable
             * object from another thread. If the operation was cancelled, the error
             * %G_IO_ERROR_CANCELLED will be returned. If `cancellable` is not %NULL, and
             * the object doesn't support cancellable initialization, the error
             * %G_IO_ERROR_NOT_SUPPORTED will be returned.
             *
             * As with #GInitable, if the object is not initialized, or initialization
             * returns with an error, then all operations on the object except
             * g_object_ref() and g_object_unref() are considered to be invalid, and
             * have undefined behaviour. They will often fail with g_critical() or
             * g_warning(), but this must not be relied on.
             *
             * Callers should not assume that a class which implements #GAsyncInitable can
             * be initialized multiple times; for more information, see g_initable_init().
             * If a class explicitly supports being initialized multiple times,
             * implementation requires yielding all subsequent calls to init_async() on the
             * results of the first call.
             *
             * For classes that also support the #GInitable interface, the default
             * implementation of this method will run the g_initable_init() function
             * in a thread, so if you want to support asynchronous initialization via
             * threads, just implement the #GAsyncInitable interface without overriding
             * any interface methods.
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the operation
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            init_async(io_priority: number, cancellable?: Cancellable | null): Promise<boolean>;
            /**
             * Starts asynchronous initialization of the object implementing the
             * interface. This must be done before any real use of the object after
             * initial construction. If the object also implements #GInitable you can
             * optionally call g_initable_init() instead.
             *
             * This method is intended for language bindings. If writing in C,
             * g_async_initable_new_async() should typically be used instead.
             *
             * When the initialization is finished, `callback` will be called. You can
             * then call g_async_initable_init_finish() to get the result of the
             * initialization.
             *
             * Implementations may also support cancellation. If `cancellable` is not
             * %NULL, then initialization can be cancelled by triggering the cancellable
             * object from another thread. If the operation was cancelled, the error
             * %G_IO_ERROR_CANCELLED will be returned. If `cancellable` is not %NULL, and
             * the object doesn't support cancellable initialization, the error
             * %G_IO_ERROR_NOT_SUPPORTED will be returned.
             *
             * As with #GInitable, if the object is not initialized, or initialization
             * returns with an error, then all operations on the object except
             * g_object_ref() and g_object_unref() are considered to be invalid, and
             * have undefined behaviour. They will often fail with g_critical() or
             * g_warning(), but this must not be relied on.
             *
             * Callers should not assume that a class which implements #GAsyncInitable can
             * be initialized multiple times; for more information, see g_initable_init().
             * If a class explicitly supports being initialized multiple times,
             * implementation requires yielding all subsequent calls to init_async() on the
             * results of the first call.
             *
             * For classes that also support the #GInitable interface, the default
             * implementation of this method will run the g_initable_init() function
             * in a thread, so if you want to support asynchronous initialization via
             * threads, just implement the #GAsyncInitable interface without overriding
             * any interface methods.
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the operation
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback to call when the request is satisfied
             */
            init_async(
                io_priority: number,
                cancellable: Cancellable | null,
                callback: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Starts asynchronous initialization of the object implementing the
             * interface. This must be done before any real use of the object after
             * initial construction. If the object also implements #GInitable you can
             * optionally call g_initable_init() instead.
             *
             * This method is intended for language bindings. If writing in C,
             * g_async_initable_new_async() should typically be used instead.
             *
             * When the initialization is finished, `callback` will be called. You can
             * then call g_async_initable_init_finish() to get the result of the
             * initialization.
             *
             * Implementations may also support cancellation. If `cancellable` is not
             * %NULL, then initialization can be cancelled by triggering the cancellable
             * object from another thread. If the operation was cancelled, the error
             * %G_IO_ERROR_CANCELLED will be returned. If `cancellable` is not %NULL, and
             * the object doesn't support cancellable initialization, the error
             * %G_IO_ERROR_NOT_SUPPORTED will be returned.
             *
             * As with #GInitable, if the object is not initialized, or initialization
             * returns with an error, then all operations on the object except
             * g_object_ref() and g_object_unref() are considered to be invalid, and
             * have undefined behaviour. They will often fail with g_critical() or
             * g_warning(), but this must not be relied on.
             *
             * Callers should not assume that a class which implements #GAsyncInitable can
             * be initialized multiple times; for more information, see g_initable_init().
             * If a class explicitly supports being initialized multiple times,
             * implementation requires yielding all subsequent calls to init_async() on the
             * results of the first call.
             *
             * For classes that also support the #GInitable interface, the default
             * implementation of this method will run the g_initable_init() function
             * in a thread, so if you want to support asynchronous initialization via
             * threads, just implement the #GAsyncInitable interface without overriding
             * any interface methods.
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the operation
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback to call when the request is satisfied
             */
            init_async(
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): Promise<boolean> | void;
            /**
             * Finishes asynchronous initialization and returns the result.
             * See g_async_initable_init_async().
             * @param res a #GAsyncResult.
             * @returns %TRUE if successful. If an error has occurred, this function will return %FALSE and set @error appropriately if present.
             */
            init_finish(res: AsyncResult): boolean;
            /**
             * Finishes the async construction for the various g_async_initable_new
             * calls, returning the created object or %NULL on error.
             * @param res the #GAsyncResult from the callback
             * @returns a newly created #GObject,      or %NULL on error. Free with g_object_unref().
             */
            new_finish(res: AsyncResult): DBusConnection;
            /**
             * Starts asynchronous initialization of the object implementing the
             * interface. This must be done before any real use of the object after
             * initial construction. If the object also implements #GInitable you can
             * optionally call g_initable_init() instead.
             *
             * This method is intended for language bindings. If writing in C,
             * g_async_initable_new_async() should typically be used instead.
             *
             * When the initialization is finished, `callback` will be called. You can
             * then call g_async_initable_init_finish() to get the result of the
             * initialization.
             *
             * Implementations may also support cancellation. If `cancellable` is not
             * %NULL, then initialization can be cancelled by triggering the cancellable
             * object from another thread. If the operation was cancelled, the error
             * %G_IO_ERROR_CANCELLED will be returned. If `cancellable` is not %NULL, and
             * the object doesn't support cancellable initialization, the error
             * %G_IO_ERROR_NOT_SUPPORTED will be returned.
             *
             * As with #GInitable, if the object is not initialized, or initialization
             * returns with an error, then all operations on the object except
             * g_object_ref() and g_object_unref() are considered to be invalid, and
             * have undefined behaviour. They will often fail with g_critical() or
             * g_warning(), but this must not be relied on.
             *
             * Callers should not assume that a class which implements #GAsyncInitable can
             * be initialized multiple times; for more information, see g_initable_init().
             * If a class explicitly supports being initialized multiple times,
             * implementation requires yielding all subsequent calls to init_async() on the
             * results of the first call.
             *
             * For classes that also support the #GInitable interface, the default
             * implementation of this method will run the g_initable_init() function
             * in a thread, so if you want to support asynchronous initialization via
             * threads, just implement the #GAsyncInitable interface without overriding
             * any interface methods.
             * @param io_priority the [I/O priority](iface.AsyncResult.html#io-priority) of the operation
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @param callback a #GAsyncReadyCallback to call when the request is satisfied
             */
            vfunc_init_async(
                io_priority: number,
                cancellable?: Cancellable | null,
                callback?: AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Finishes asynchronous initialization and returns the result.
             * See g_async_initable_init_async().
             * @param res a #GAsyncResult.
             */
            vfunc_init_finish(res: AsyncResult): boolean;
            /**
             * Initializes the object implementing the interface.
             *
             * This method is intended for language bindings. If writing in C,
             * g_initable_new() should typically be used instead.
             *
             * The object must be initialized before any real use after initial
             * construction, either with this function or g_async_initable_init_async().
             *
             * Implementations may also support cancellation. If `cancellable` is not %NULL,
             * then initialization can be cancelled by triggering the cancellable object
             * from another thread. If the operation was cancelled, the error
             * %G_IO_ERROR_CANCELLED will be returned. If `cancellable` is not %NULL and
             * the object doesn't support cancellable initialization the error
             * %G_IO_ERROR_NOT_SUPPORTED will be returned.
             *
             * If the object is not initialized, or initialization returns with an
             * error, then all operations on the object except g_object_ref() and
             * g_object_unref() are considered to be invalid, and have undefined
             * behaviour. See the [description][iface`Gio`.Initable#description] for more details.
             *
             * Callers should not assume that a class which implements #GInitable can be
             * initialized multiple times, unless the class explicitly documents itself as
             * supporting this. Generally, a class’ implementation of init() can assume
             * (and assert) that it will only be called once. Previously, this documentation
             * recommended all #GInitable implementations should be idempotent; that
             * recommendation was relaxed in GLib 2.54.
             *
             * If a class explicitly supports being initialized multiple times, it is
             * recommended that the method is idempotent: multiple calls with the same
             * arguments should return the same results. Only the first call initializes
             * the object; further calls return the result of the first call.
             *
             * One reason why a class might need to support idempotent initialization is if
             * it is designed to be used via the singleton pattern, with a
             * #GObjectClass.constructor that sometimes returns an existing instance.
             * In this pattern, a caller would expect to be able to call g_initable_init()
             * on the result of g_object_new(), regardless of whether it is in fact a new
             * instance.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             * @returns %TRUE if successful. If an error has occurred, this function will     return %FALSE and set @error appropriately if present.
             */
            init(cancellable?: Cancellable | null): boolean;
            /**
             * Initializes the object implementing the interface.
             *
             * This method is intended for language bindings. If writing in C,
             * g_initable_new() should typically be used instead.
             *
             * The object must be initialized before any real use after initial
             * construction, either with this function or g_async_initable_init_async().
             *
             * Implementations may also support cancellation. If `cancellable` is not %NULL,
             * then initialization can be cancelled by triggering the cancellable object
             * from another thread. If the operation was cancelled, the error
             * %G_IO_ERROR_CANCELLED will be returned. If `cancellable` is not %NULL and
             * the object doesn't support cancellable initialization the error
             * %G_IO_ERROR_NOT_SUPPORTED will be returned.
             *
             * If the object is not initialized, or initialization returns with an
             * error, then all operations on the object except g_object_ref() and
             * g_object_unref() are considered to be invalid, and have undefined
             * behaviour. See the [description][iface`Gio`.Initable#description] for more details.
             *
             * Callers should not assume that a class which implements #GInitable can be
             * initialized multiple times, unless the class explicitly documents itself as
             * supporting this. Generally, a class’ implementation of init() can assume
             * (and assert) that it will only be called once. Previously, this documentation
             * recommended all #GInitable implementations should be idempotent; that
             * recommendation was relaxed in GLib 2.54.
             *
             * If a class explicitly supports being initialized multiple times, it is
             * recommended that the method is idempotent: multiple calls with the same
             * arguments should return the same results. Only the first call initializes
             * the object; further calls return the result of the first call.
             *
             * One reason why a class might need to support idempotent initialization is if
             * it is designed to be used via the singleton pattern, with a
             * #GObjectClass.constructor that sometimes returns an existing instance.
             * In this pattern, a caller would expect to be able to call g_initable_init()
             * on the result of g_object_new(), regardless of whether it is in fact a new
             * instance.
             * @param cancellable optional #GCancellable object, %NULL to ignore.
             */
            vfunc_init(cancellable?: Cancellable | null): boolean;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace DBusInterfaceSkeleton {
            // Signal callback interfaces

            interface GAuthorizeMethod {
                (invocation: DBusMethodInvocation): boolean;
            }

            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps, DBusInterface.ConstructorProps {
                g_flags: DBusInterfaceSkeletonFlags;
                gFlags: DBusInterfaceSkeletonFlags;
            }
        }

        /**
         * Abstract base class for D-Bus interfaces on the service side.
         */
        abstract class DBusInterfaceSkeleton extends GObject.Object implements DBusInterface {
            static $gtype: GObject.GType<DBusInterfaceSkeleton>;

            // Properties

            /**
             * Flags from the #GDBusInterfaceSkeletonFlags enumeration.
             */
            get g_flags(): DBusInterfaceSkeletonFlags;
            set g_flags(val: DBusInterfaceSkeletonFlags);
            /**
             * Flags from the #GDBusInterfaceSkeletonFlags enumeration.
             */
            get gFlags(): DBusInterfaceSkeletonFlags;
            set gFlags(val: DBusInterfaceSkeletonFlags);

            // Constructors

            constructor(properties?: Partial<DBusInterfaceSkeleton.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(
                signal: 'g-authorize-method',
                callback: (_source: this, invocation: DBusMethodInvocation) => boolean,
            ): number;
            connect_after(
                signal: 'g-authorize-method',
                callback: (_source: this, invocation: DBusMethodInvocation) => boolean,
            ): number;
            emit(signal: 'g-authorize-method', invocation: DBusMethodInvocation): void;

            // Virtual methods

            /**
             * If `interface_` has outstanding changes, request for these changes to be
             * emitted immediately.
             *
             * For example, an exported D-Bus interface may queue up property
             * changes and emit the
             * `org.freedesktop.DBus.Properties.PropertiesChanged`
             * signal later (e.g. in an idle handler). This technique is useful
             * for collapsing multiple property changes into one.
             */
            vfunc_flush(): void;
            /**
             * Signal class handler for the #GDBusInterfaceSkeleton::g-authorize-method signal.
             * @param invocation
             */
            vfunc_g_authorize_method(invocation: DBusMethodInvocation): boolean;
            /**
             * Gets D-Bus introspection information for the D-Bus interface
             * implemented by `interface_`.
             */
            vfunc_get_info(): DBusInterfaceInfo;
            /**
             * Gets all D-Bus properties for `interface_`.
             */
            vfunc_get_properties(): GLib.Variant;
            /**
             * Gets the interface vtable for the D-Bus interface implemented by
             * `interface_`. The returned function pointers should expect `interface_`
             * itself to be passed as `user_data`.
             */
            vfunc_get_vtable(): DBusInterfaceVTable;

            // Methods

            /**
             * Exports `interface_` at `object_path` on `connection`.
             *
             * This can be called multiple times to export the same `interface_`
             * onto multiple connections however the `object_path` provided must be
             * the same for all connections.
             *
             * Use g_dbus_interface_skeleton_unexport() to unexport the object.
             * @param connection A #GDBusConnection to export @interface_ on.
             * @param object_path The path to export the interface at.
             * @returns %TRUE if the interface was exported on @connection, otherwise %FALSE with @error set.
             */
            ['export'](connection: DBusConnection, object_path: string): boolean;
            /**
             * If `interface_` has outstanding changes, request for these changes to be
             * emitted immediately.
             *
             * For example, an exported D-Bus interface may queue up property
             * changes and emit the
             * `org.freedesktop.DBus.Properties.PropertiesChanged`
             * signal later (e.g. in an idle handler). This technique is useful
             * for collapsing multiple property changes into one.
             */
            flush(): void;
            /**
             * Gets the first connection that `interface_` is exported on, if any.
             * @returns A #GDBusConnection or %NULL if @interface_ is not exported anywhere. Do not free, the object belongs to @interface_.
             */
            get_connection(): DBusConnection | null;
            /**
             * Gets a list of the connections that `interface_` is exported on.
             * @returns A list of   all the connections that @interface_ is exported on. The returned   list should be freed with g_list_free() after each element has   been freed with g_object_unref().
             */
            get_connections(): DBusConnection[];
            /**
             * Gets the #GDBusInterfaceSkeletonFlags that describes what the behavior
             * of `interface_`
             * @returns One or more flags from the #GDBusInterfaceSkeletonFlags enumeration.
             */
            get_flags(): DBusInterfaceSkeletonFlags;
            /**
             * Gets D-Bus introspection information for the D-Bus interface
             * implemented by `interface_`.
             * @returns A #GDBusInterfaceInfo (never %NULL). Do not free.
             */
            get_info(): DBusInterfaceInfo;
            /**
             * Gets the object path that `interface_` is exported on, if any.
             * @returns A string owned by @interface_ or %NULL if @interface_ is not exported anywhere. Do not free, the string belongs to @interface_.
             */
            get_object_path(): string | null;
            /**
             * Gets all D-Bus properties for `interface_`.
             * @returns A #GVariant of type ['a{sv}'](../glib/gvariant-text-format.html#dictionaries-and-dictionary-entries). Free with g_variant_unref().
             */
            get_properties(): GLib.Variant;
            /**
             * Gets the interface vtable for the D-Bus interface implemented by
             * `interface_`. The returned function pointers should expect `interface_`
             * itself to be passed as `user_data`.
             * @returns the vtable of the D-Bus interface implemented by the skeleton
             */
            get_vtable(): DBusInterfaceVTable;
            /**
             * Checks if `interface_` is exported on `connection`.
             * @param connection A #GDBusConnection.
             * @returns %TRUE if @interface_ is exported on @connection, %FALSE otherwise.
             */
            has_connection(connection: DBusConnection): boolean;
            /**
             * Sets flags describing what the behavior of `skeleton` should be.
             * @param flags Flags from the #GDBusInterfaceSkeletonFlags enumeration.
             */
            set_flags(flags: DBusInterfaceSkeletonFlags | null): void;
            /**
             * Stops exporting `interface_` on all connections it is exported on.
             *
             * To unexport `interface_` from only a single connection, use
             * g_dbus_interface_skeleton_unexport_from_connection()
             */
            unexport(): void;
            /**
             * Stops exporting `interface_` on `connection`.
             *
             * To stop exporting on all connections the interface is exported on,
             * use g_dbus_interface_skeleton_unexport().
             * @param connection A #GDBusConnection.
             */
            unexport_from_connection(connection: DBusConnection): void;

            // Inherited methods
            /**
             * Gets the #GDBusObject that `interface_` belongs to, if any.
             * @returns A #GDBusObject or %NULL. The returned reference should be freed with g_object_unref().
             */
            get_object(): DBusObject | null;
            /**
             * Sets the #GDBusObject for `interface_` to `object`.
             *
             * Note that `interface_` will hold a weak reference to `object`.
             * @param object A #GDBusObject or %NULL.
             */
            set_object(object?: DBusObject | null): void;
            /**
             * Gets the #GDBusObject that `interface_` belongs to, if any.
             */
            vfunc_dup_object(): DBusObject | null;
            /**
             * Sets the #GDBusObject for `interface_` to `object`.
             *
             * Note that `interface_` will hold a weak reference to `object`.
             * @param object A #GDBusObject or %NULL.
             */
            vfunc_set_object(object?: DBusObject | null): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace DBusMenuModel {
            // Constructor properties interface

            interface ConstructorProps extends MenuModel.ConstructorProps {}
        }

        /**
         * `GDBusMenuModel` is an implementation of [class`Gio`.MenuModel] that can be
         * used as a proxy for a menu model that is exported over D-Bus with
         * [method`Gio`.DBusConnection.export_menu_model].
         */
        class DBusMenuModel extends MenuModel {
            static $gtype: GObject.GType<DBusMenuModel>;

            // Constructors

            constructor(properties?: Partial<DBusMenuModel.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            // Static methods

            /**
             * Obtains a #GDBusMenuModel for the menu model which is exported
             * at the given `bus_name` and `object_path`.
             *
             * The thread default main context is taken at the time of this call.
             * All signals on the menu model (and any linked models) are reported
             * with respect to this context.  All calls on the returned menu model
             * (and linked models) must also originate from this same context, with
             * the thread default main context unchanged.
             * @param connection a #GDBusConnection
             * @param bus_name the bus name which exports the menu model     or %NULL if @connection is not a message bus connection
             * @param object_path the object path at which the menu model is exported
             */
            static get(connection: DBusConnection, bus_name: string | null, object_path: string): DBusMenuModel;
        }

        namespace DBusMessage {
            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps {
                locked: boolean;
            }
        }

        /**
         * A type for representing D-Bus messages that can be sent or received
         * on a [class`Gio`.DBusConnection].
         */
        class DBusMessage extends GObject.Object {
            static $gtype: GObject.GType<DBusMessage>;

            // Properties

            get locked(): boolean;

            // Constructors

            constructor(properties?: Partial<DBusMessage.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](): DBusMessage;

            static new_from_blob(blob: Uint8Array | string, capabilities: DBusCapabilityFlags): DBusMessage;

            static new_method_call(
                name: string | null,
                path: string,
                interface_: string | null,
                method: string,
            ): DBusMessage;

            static new_signal(path: string, interface_: string, signal: string): DBusMessage;

            // Static methods

            /**
             * Utility function to calculate how many bytes are needed to
             * completely deserialize the D-Bus message stored at `blob`.
             * @param blob A blob representing a binary D-Bus message.
             */
            static bytes_needed(blob: Uint8Array | string): number;

            // Methods

            /**
             * Copies `message`. The copy is a deep copy and the returned
             * #GDBusMessage is completely identical except that it is guaranteed
             * to not be locked.
             *
             * This operation can fail if e.g. `message` contains file descriptors
             * and the per-process or system-wide open files limit is reached.
             * @returns A new #GDBusMessage or %NULL if @error is set.     Free with g_object_unref().
             */
            copy(): DBusMessage;
            /**
             * Convenience to get the first item in the body of `message`.
             *
             * See [method`Gio`.DBusMessage.get_arg0_path] for returning object-path-typed
             * arg0 values.
             * @returns The string item or %NULL if the first item in the body of @message is not a string.
             */
            get_arg0(): string | null;
            /**
             * Convenience to get the first item in the body of `message`.
             *
             * See [method`Gio`.DBusMessage.get_arg0] for returning string-typed arg0 values.
             * @returns The object path item or `NULL` if the first item in the   body of @message is not an object path.
             */
            get_arg0_path(): string | null;
            /**
             * Gets the body of a message.
             * @returns A #GVariant or %NULL if the body is empty. Do not free, it is owned by @message.
             */
            get_body(): GLib.Variant | null;
            /**
             * Gets the byte order of `message`.
             * @returns The byte order.
             */
            get_byte_order(): DBusMessageByteOrder;
            /**
             * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_DESTINATION header field.
             * @returns The value.
             */
            get_destination(): string | null;
            /**
             * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME header field.
             * @returns The value.
             */
            get_error_name(): string | null;
            /**
             * Gets the flags for `message`.
             * @returns Flags that are set (typically values from the #GDBusMessageFlags enumeration bitwise ORed together).
             */
            get_flags(): DBusMessageFlags;
            /**
             * Gets a header field on `message`.
             *
             * The caller is responsible for checking the type of the returned #GVariant
             * matches what is expected.
             * @param header_field A 8-bit unsigned integer (typically a value from the #GDBusMessageHeaderField enumeration)
             * @returns A #GVariant with the value if the header was found, %NULL otherwise. Do not free, it is owned by @message.
             */
            get_header(header_field: DBusMessageHeaderField | null): GLib.Variant | null;
            /**
             * Gets an array of all header fields on `message` that are set.
             * @returns An array of header fields terminated by %G_DBUS_MESSAGE_HEADER_FIELD_INVALID.  Each element is a #guchar. Free with g_free().
             */
            get_header_fields(): Uint8Array;
            /**
             * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_INTERFACE header field.
             * @returns The value.
             */
            get_interface(): string | null;
            /**
             * Checks whether `message` is locked. To monitor changes to this
             * value, conncet to the #GObject::notify signal to listen for changes
             * on the #GDBusMessage:locked property.
             * @returns %TRUE if @message is locked, %FALSE otherwise.
             */
            get_locked(): boolean;
            /**
             * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_MEMBER header field.
             * @returns The value.
             */
            get_member(): string | null;
            /**
             * Gets the type of `message`.
             * @returns A 8-bit unsigned integer (typically a value from the #GDBusMessageType enumeration).
             */
            get_message_type(): DBusMessageType;
            /**
             * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS header field.
             * @returns The value.
             */
            get_num_unix_fds(): number;
            /**
             * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_PATH header field.
             * @returns The value.
             */
            get_path(): string | null;
            /**
             * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL header field.
             * @returns The value.
             */
            get_reply_serial(): number;
            /**
             * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_SENDER header field.
             * @returns The value.
             */
            get_sender(): string | null;
            /**
             * Gets the serial for `message`.
             * @returns A #guint32.
             */
            get_serial(): number;
            /**
             * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_SIGNATURE header field.
             *
             * This will always be non-%NULL, but may be an empty string.
             * @returns The value.
             */
            get_signature(): string;
            /**
             * Gets the UNIX file descriptors associated with `message,` if any.
             *
             * This method is only available on UNIX.
             *
             * The file descriptors normally correspond to %G_VARIANT_TYPE_HANDLE
             * values in the body of the message. For example,
             * if g_variant_get_handle() returns 5, that is intended to be a reference
             * to the file descriptor that can be accessed by
             * `g_unix_fd_list_get (list, 5, ...)`.
             * @returns A #GUnixFDList or %NULL if no file descriptors are associated. Do not free, this object is owned by @message.
             */
            get_unix_fd_list(): UnixFDList | null;
            /**
             * If `message` is locked, does nothing. Otherwise locks the message.
             */
            lock(): void;
            /**
             * Creates a new #GDBusMessage that is an error reply to `method_call_message`.
             * @param error_name A valid D-Bus error name.
             * @param error_message The D-Bus error message.
             * @returns A #GDBusMessage. Free with g_object_unref().
             */
            new_method_error_literal(error_name: string, error_message: string): DBusMessage;
            /**
             * Creates a new #GDBusMessage that is a reply to `method_call_message`.
             * @returns #GDBusMessage. Free with g_object_unref().
             */
            new_method_reply(): DBusMessage;
            /**
             * Produces a human-readable multi-line description of `message`.
             *
             * The contents of the description has no ABI guarantees, the contents
             * and formatting is subject to change at any time. Typical output
             * looks something like this:
             * ```
             * Flags:   none
             * Version: 0
             * Serial:  4
             * Headers:
             *   path -> objectpath '/org/gtk/GDBus/TestObject'
             *   interface -> 'org.gtk.GDBus.TestInterface'
             *   member -> 'GimmeStdout'
             *   destination -> ':1.146'
             * Body: ()
             * UNIX File Descriptors:
             *   (none)
             * ```
             * or
             * ```
             * Flags:   no-reply-expected
             * Version: 0
             * Serial:  477
             * Headers:
             *   reply-serial -> uint32 4
             *   destination -> ':1.159'
             *   sender -> ':1.146'
             *   num-unix-fds -> uint32 1
             * Body: ()
             * UNIX File Descriptors:
             *   fd 12: dev=0:10,mode=020620,ino=5,uid=500,gid=5,rdev=136:2,size=0,atime=1273085037,mtime=1273085851,ctime=1272982635
             * ```
             * @param indent Indentation level.
             * @returns A string that should be freed with [func@GLib.free].
             */
            print(indent: number): string;
            /**
             * Sets the body `message`. As a side-effect the
             * %G_DBUS_MESSAGE_HEADER_FIELD_SIGNATURE header field is set to the
             * type string of `body` (or cleared if `body` is %NULL).
             *
             * If `body` is floating, `message` assumes ownership of `body`.
             * @param body Either %NULL or a #GVariant that is a tuple.
             */
            set_body(body: GLib.Variant): void;
            /**
             * Sets the byte order of `message`.
             * @param byte_order The byte order.
             */
            set_byte_order(byte_order: DBusMessageByteOrder | null): void;
            /**
             * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_DESTINATION header field.
             * @param value The value to set.
             */
            set_destination(value?: string | null): void;
            /**
             * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME header field.
             * @param value The value to set.
             */
            set_error_name(value: string): void;
            /**
             * Sets the flags to set on `message`.
             * @param flags Flags for @message that are set (typically values from the #GDBusMessageFlags enumeration bitwise ORed together).
             */
            set_flags(flags: DBusMessageFlags | null): void;
            /**
             * Sets a header field on `message`.
             *
             * If `value` is floating, `message` assumes ownership of `value`.
             * @param header_field A 8-bit unsigned integer (typically a value from the #GDBusMessageHeaderField enumeration)
             * @param value A #GVariant to set the header field or %NULL to clear the header field.
             */
            set_header(header_field: DBusMessageHeaderField | null, value?: GLib.Variant | null): void;
            /**
             * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_INTERFACE header field.
             * @param value The value to set.
             */
            set_interface(value?: string | null): void;
            /**
             * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_MEMBER header field.
             * @param value The value to set.
             */
            set_member(value?: string | null): void;
            /**
             * Sets `message` to be of `type`.
             * @param type A 8-bit unsigned integer (typically a value from the #GDBusMessageType enumeration).
             */
            set_message_type(type: DBusMessageType | null): void;
            /**
             * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS header field.
             * @param value The value to set.
             */
            set_num_unix_fds(value: number): void;
            /**
             * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_PATH header field.
             * @param value The value to set.
             */
            set_path(value?: string | null): void;
            /**
             * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL header field.
             * @param value The value to set.
             */
            set_reply_serial(value: number): void;
            /**
             * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_SENDER header field.
             * @param value The value to set.
             */
            set_sender(value?: string | null): void;
            /**
             * Sets the serial for `message`.
             *
             * The [D-Bus specification](https://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-messages)
             * does not allow the `serial` to be zero.
             * @param serial A #guint32, which must not be zero.
             */
            set_serial(serial: number): void;
            /**
             * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_SIGNATURE header field.
             * @param value The value to set.
             */
            set_signature(value?: string | null): void;
            /**
             * Sets the UNIX file descriptors associated with `message`. As a
             * side-effect the %G_DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS header
             * field is set to the number of fds in `fd_list` (or cleared if
             * `fd_list` is %NULL).
             *
             * This method is only available on UNIX.
             *
             * When designing D-Bus APIs that are intended to be interoperable,
             * please note that non-GDBus implementations of D-Bus can usually only
             * access file descriptors if they are referenced by a value of type
             * %G_VARIANT_TYPE_HANDLE in the body of the message.
             * @param fd_list A #GUnixFDList or %NULL.
             */
            set_unix_fd_list(fd_list?: UnixFDList | null): void;
            /**
             * Serializes `message` to a blob. The byte order returned by
             * g_dbus_message_get_byte_order() will be used.
             * @param capabilities A #GDBusCapabilityFlags describing what protocol features are supported.
             * @returns A pointer to a valid binary D-Bus message of @out_size bytes generated by @message or %NULL if @error is set. Free with g_free().
             */
            to_blob(capabilities: DBusCapabilityFlags | null): Uint8Array;
            /**
             * If `message` is not of type %G_DBUS_MESSAGE_TYPE_ERROR does
             * nothing and returns %FALSE.
             *
             * Otherwise this method encodes the error in `message` as a #GError
             * using g_dbus_error_set_dbus_error() using the information in the
             * %G_DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME header field of `message` as
             * well as the first string item in `message'`s body.
             * @returns %TRUE if @error was set, %FALSE otherwise.
             */
            to_gerror(): boolean;
        }

        namespace DBusMethodInvocation {
            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps {}
        }

        /**
         * Instances of the `GDBusMethodInvocation` class are used when
         * handling D-Bus method calls. It provides a way to asynchronously
         * return results and errors.
         *
         * The normal way to obtain a `GDBusMethodInvocation` object is to receive
         * it as an argument to the `handle_method_call()` function in a
         * [type`Gio`.DBusInterfaceVTable] that was passed to
         * [method`Gio`.DBusConnection.register_object].
         */
        class DBusMethodInvocation extends GObject.Object {
            static $gtype: GObject.GType<DBusMethodInvocation>;

            // Constructors

            constructor(properties?: Partial<DBusMethodInvocation.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            // Methods

            /**
             * Gets the #GDBusConnection the method was invoked on.
             * @returns A #GDBusConnection. Do not free, it is owned by @invocation.
             */
            get_connection(): DBusConnection;
            /**
             * Gets the name of the D-Bus interface the method was invoked on.
             *
             * This can be `NULL` if it was not specified by the sender. See
             * [callback`Gio`.DBusInterfaceMethodCallFunc] or the
             * [D-Bus Specification](https://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-types-method)
             * for details on when this can happen and how it should be handled.
             *
             * If this method call is a property Get, Set or GetAll call that has
             * been redirected to the method call handler then
             * "org.freedesktop.DBus.Properties" will be returned.  See
             * #GDBusInterfaceVTable for more information.
             * @returns A string. Do not free, it is owned by @invocation.
             */
            get_interface_name(): string | null;
            /**
             * Gets the #GDBusMessage for the method invocation. This is useful if
             * you need to use low-level protocol features, such as UNIX file
             * descriptor passing, that cannot be properly expressed in the
             * #GVariant API.
             *
             * See this [server][class`Gio`.DBusConnection#an-example-d-bus-server]
             * and [client][class`Gio`.DBusConnection#an-example-for-file-descriptor-passing]
             * for an example of how to use this low-level API to send and receive
             * UNIX file descriptors.
             * @returns #GDBusMessage. Do not free, it is owned by @invocation.
             */
            get_message(): DBusMessage;
            /**
             * Gets information about the method call, if any.
             *
             * If this method invocation is a property Get, Set or GetAll call that
             * has been redirected to the method call handler then %NULL will be
             * returned.  See g_dbus_method_invocation_get_property_info() and
             * #GDBusInterfaceVTable for more information.
             * @returns A #GDBusMethodInfo or %NULL. Do not free, it is owned by @invocation.
             */
            get_method_info(): DBusMethodInfo | null;
            /**
             * Gets the name of the method that was invoked.
             * @returns A string. Do not free, it is owned by @invocation.
             */
            get_method_name(): string;
            /**
             * Gets the object path the method was invoked on.
             * @returns A string. Do not free, it is owned by @invocation.
             */
            get_object_path(): string;
            /**
             * Gets the parameters of the method invocation. If there are no input
             * parameters then this will return a GVariant with 0 children rather than NULL.
             * @returns A #GVariant tuple. Do not unref this because it is owned by @invocation.
             */
            get_parameters(): GLib.Variant;
            /**
             * Gets information about the property that this method call is for, if
             * any.
             *
             * This will only be set in the case of an invocation in response to a
             * property Get or Set call that has been directed to the method call
             * handler for an object on account of its property_get() or
             * property_set() vtable pointers being unset.
             *
             * See #GDBusInterfaceVTable for more information.
             *
             * If the call was GetAll, %NULL will be returned.
             * @returns a #GDBusPropertyInfo or %NULL
             */
            get_property_info(): DBusPropertyInfo | null;
            /**
             * Gets the bus name that invoked the method.
             *
             * This can return %NULL if not specified by the caller, e.g. on peer-to-peer
             * connections.
             * @returns A string. Do not free, it is owned by @invocation.
             */
            get_sender(): string | null;
            /**
             * Finishes handling a D-Bus method call by returning an error.
             *
             * This method will take ownership of `invocation`. See
             * #GDBusInterfaceVTable for more information about the ownership of
             * `invocation`.
             * @param error_name A valid D-Bus error name.
             * @param error_message A valid D-Bus error message.
             */
            return_dbus_error(error_name: string, error_message: string): void;
            /**
             * Like g_dbus_method_invocation_return_error() but without printf()-style formatting.
             *
             * This method will take ownership of `invocation`. See
             * #GDBusInterfaceVTable for more information about the ownership of
             * `invocation`.
             * @param domain A #GQuark for the #GError error domain.
             * @param code The error code.
             * @param message The error message.
             */
            return_error_literal(domain: GLib.Quark, code: number, message: string): void;
            /**
             * Like g_dbus_method_invocation_return_error() but takes a #GError
             * instead of the error domain, error code and message.
             *
             * This method will take ownership of `invocation`. See
             * #GDBusInterfaceVTable for more information about the ownership of
             * `invocation`.
             * @param error A #GError.
             */
            return_gerror(error: GLib.Error): void;
            /**
             * Finishes handling a D-Bus method call by returning `parameters`.
             * If the `parameters` GVariant is floating, it is consumed.
             *
             * It is an error if `parameters` is not of the right format: it must be a tuple
             * containing the out-parameters of the D-Bus method. Even if the method has a
             * single out-parameter, it must be contained in a tuple. If the method has no
             * out-parameters, `parameters` may be %NULL or an empty tuple.
             *
             *
             * ```c
             * GDBusMethodInvocation *invocation = some_invocation;
             * g_autofree gchar *result_string = NULL;
             * g_autoptr (GError) error = NULL;
             *
             * result_string = calculate_result (&error);
             *
             * if (error != NULL)
             *   g_dbus_method_invocation_return_gerror (invocation, error);
             * else
             *   g_dbus_method_invocation_return_value (invocation,
             *                                          g_variant_new ("(s)", result_string));
             *
             * // Do not free `invocation` here; returning a value does that
             * ```
             *
             *
             * This method will take ownership of `invocation`. See
             * #GDBusInterfaceVTable for more information about the ownership of
             * `invocation`.
             *
             * Since 2.48, if the method call requested for a reply not to be sent
             * then this call will sink `parameters` and free `invocation,` but
             * otherwise do nothing (as per the recommendations of the D-Bus
             * specification).
             * @param parameters A #GVariant tuple with out parameters for the method or %NULL if not passing any parameters.
             */
            return_value(parameters?: GLib.Variant | null): void;
            /**
             * Like g_dbus_method_invocation_return_value() but also takes a #GUnixFDList.
             *
             * This method is only available on UNIX.
             *
             * This method will take ownership of `invocation`. See
             * #GDBusInterfaceVTable for more information about the ownership of
             * `invocation`.
             * @param parameters A #GVariant tuple with out parameters for the method or %NULL if not passing any parameters.
             * @param fd_list A #GUnixFDList or %NULL.
             */
            return_value_with_unix_fd_list(parameters?: GLib.Variant | null, fd_list?: UnixFDList | null): void;
        }

        namespace DBusObjectManagerClient {
            // Signal callback interfaces

            interface InterfaceProxyPropertiesChanged {
                (
                    object_proxy: DBusObjectProxy,
                    interface_proxy: DBusProxy,
                    changed_properties: GLib.Variant,
                    invalidated_properties: string[],
                ): void;
            }

            interface InterfaceProxySignal {
                (
                    object_proxy: DBusObjectProxy,
                    interface_proxy: DBusProxy,
                    sender_name: string,
                    signal_name: string,
                    parameters: GLib.Variant,
                ): void;
            }

            // Constructor properties interface

            interface ConstructorProps
                extends GObject.Object.ConstructorProps,
                    AsyncInitable.ConstructorProps,
                    DBusObjectManager.ConstructorProps,
                    Initable.ConstructorProps {
                bus_type: BusType;
                busType: BusType;
                connection: DBusConnection;
                flags: DBusObjectManagerClientFlags;
                get_proxy_type_destroy_notify: any;
                getProxyTypeDestroyNotify: any;
                get_proxy_type_func: any;
                getProxyTypeFunc: any;
                get_proxy_type_user_data: any;
                getProxyTypeUserData: any;
                name: string;
                name_owner: string;
                nameOwner: string;
                object_path: string;
                objectPath: string;
            }
        }

        /**
         * `GDBusObjectManagerClient` is used to create, monitor and delete object
         * proxies for remote objects exported by a [class`Gio`.DBusObjectManagerServer]
         * (or any code implementing the
         * [org.freedesktop.DBus.ObjectManager](http://dbus.freedesktop.org/doc/dbus-specification.html#standard-interfaces-objectmanager)
         * interface).
         *
         * Once an instance of this type has been created, you can connect to
         * the [signal`Gio`.DBusObjectManager::object-added] and
         * [signal`Gio`.DBusObjectManager::object-removed signals] and inspect the
         * [class`Gio`.DBusObjectProxy] objects returned by
         * [method`Gio`.DBusObjectManager.get_objects].
         *
         * If the name for a `GDBusObjectManagerClient` is not owned by anyone at
         * object construction time, the default behavior is to request the
         * message bus to launch an owner for the name. This behavior can be
         * disabled using the `G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_DO_NOT_AUTO_START`
         * flag. It’s also worth noting that this only works if the name of
         * interest is activatable in the first place. E.g. in some cases it
         * is not possible to launch an owner for the requested name. In this
         * case, `GDBusObjectManagerClient` object construction still succeeds but
         * there will be no object proxies
         * (e.g. [method`Gio`.DBusObjectManager.get_objects] returns the empty list) and
         * the [property`Gio`.DBusObjectManagerClient:name-owner] property is `NULL`.
         *
         * The owner of the requested name can come and go (for example
         * consider a system service being restarted) – `GDBusObjectManagerClient`
         * handles this case too; simply connect to the [signal`GObject`.Object::notify]
         * signal to watch for changes on the
         * [property`Gio`.DBusObjectManagerClient:name-owner] property. When the name
         * owner vanishes, the behavior is that
         * [property`Gio`.DBusObjectManagerClient:name-owner] is set to `NULL` (this
         * includes emission of the [signal`GObject`.Object::notify] signal) and then
         * [signal`Gio`.DBusObjectManager::object-removed] signals are synthesized
         * for all currently existing object proxies. Since
         * [property`Gio`.DBusObjectManagerClient:name-owner] is `NULL` when this
         * happens, you can use this information to disambiguate a synthesized signal
         * from a genuine signal caused by object removal on the remote
         * [iface`Gio`.DBusObjectManager]. Similarly, when a new name owner appears,
         * [signal`Gio`.DBusObjectManager::object-added] signals are synthesized
         * while [property`Gio`.DBusObjectManagerClient:name-owner] is still `NULL`. Only
         * when all object proxies have been added, the
         * [property`Gio`.DBusObjectManagerClient:name-owner] is set to the new name
         * owner (this includes emission of the [signal`GObject`.Object::notify] signal).
         * Furthermore, you are guaranteed that
         * [property`Gio`.DBusObjectManagerClient:name-owner] will alternate between a
         * name owner (e.g. `:1.42`) and `NULL` even in the case where
         * the name of interest is atomically replaced
         *
         * Ultimately, `GDBusObjectManagerClient` is used to obtain
         * [class`Gio`.DBusProxy] instances. All signals (including the
         * `org.freedesktop.DBus.Properties::PropertiesChanged` signal)
         * delivered to [class`Gio`.DBusProxy] instances are guaranteed to originate
         * from the name owner. This guarantee along with the behavior
         * described above, means that certain race conditions including the
         * “half the proxy is from the old owner and the other half is from
         * the new owner” problem cannot happen.
         *
         * To avoid having the application connect to signals on the returned
         * [class`Gio`.DBusObjectProxy] and [class`Gio`.DBusProxy] objects, the
         * [signal`Gio`.DBusObject::interface-added],
         * [signal`Gio`.DBusObject::interface-removed],
         * [signal`Gio`.DBusProxy::g-properties-changed] and
         * [signal`Gio`.DBusProxy::g-signal] signals
         * are also emitted on the `GDBusObjectManagerClient` instance managing these
         * objects. The signals emitted are
         * [signal`Gio`.DBusObjectManager::interface-added],
         * [signal`Gio`.DBusObjectManager::interface-removed],
         * [signal`Gio`.DBusObjectManagerClient::interface-proxy-properties-changed] and
         * [signal`Gio`.DBusObjectManagerClient::interface-proxy-signal].
         *
         * Note that all callbacks and signals are emitted in the
         * thread-default main context (see
         * [method`GLib`.MainContext.push_thread_default]) that the
         * `GDBusObjectManagerClient` object was constructed in. Additionally, the
         * [class`Gio`.DBusObjectProxy] and [class`Gio`.DBusProxy] objects
         * originating from the `GDBusObjectManagerClient` object will be created in
         * the same context and, consequently, will deliver signals in the
         * same main loop.
         */
        class DBusObjectManagerClient
            extends GObject.Object
            implements AsyncInitable<DBusObjectManagerClient>, DBusObjectManager, Initable
        {
            static $gtype: GObject.GType<DBusObjectManagerClient>;

            // Properties

            /**
             * If this property is not %G_BUS_TYPE_NONE, then
             * #GDBusObjectManagerClient:connection must be %NULL and will be set to the
             * #GDBusConnection obtained by calling g_bus_get() with the value
             * of this property.
             */
            set bus_type(val: BusType);
            /**
             * If this property is not %G_BUS_TYPE_NONE, then
             * #GDBusObjectManagerClient:connection must be %NULL and will be set to the
             * #GDBusConnection obtained by calling g_bus_get() with the value
             * of this property.
             */
            set busType(val: BusType);
            /**
             * The #GDBusConnection to use.
             */
            get connection(): DBusConnection;
            /**
             * Flags from the #GDBusObjectManagerClientFlags enumeration.
             */
            get flags(): DBusObjectManagerClientFlags;
            /**
             * A #GDestroyNotify for the #gpointer user_data in #GDBusObjectManagerClient:get-proxy-type-user-data.
             */
            get get_proxy_type_destroy_notify(): any;
            /**
             * A #GDestroyNotify for the #gpointer user_data in #GDBusObjectManagerClient:get-proxy-type-user-data.
             */
            get getProxyTypeDestroyNotify(): any;
            /**
             * The #GDBusProxyTypeFunc to use when determining what #GType to
             * use for interface proxies or %NULL.
             */
            get get_proxy_type_func(): any;
            /**
             * The #GDBusProxyTypeFunc to use when determining what #GType to
             * use for interface proxies or %NULL.
             */
            get getProxyTypeFunc(): any;
            /**
             * The #gpointer user_data to pass to #GDBusObjectManagerClient:get-proxy-type-func.
             */
            get get_proxy_type_user_data(): any;
            /**
             * The #gpointer user_data to pass to #GDBusObjectManagerClient:get-proxy-type-func.
             */
            get getProxyTypeUserData(): any;
            /**
             * The well-known name or unique name that the manager is for.
             */
            get name(): string;
            /**
             * The unique name that owns #GDBusObjectManagerClient:name or %NULL if
             * no-one is currently ow