//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;
#[cfg(feature = "objc2-open-gl")]
#[cfg(target_os = "macos")]
use objc2_open_gl::*;

use crate::*;

/// CoreVideo OpenGL Texture Cache
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvopengltexturecache?language=objc)
#[doc(alias = "CVOpenGLTextureCacheRef")]
#[repr(C)]
pub struct CVOpenGLTextureCache {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CVOpenGLTextureCache {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CVOpenGLTextureCache"> for CVOpenGLTextureCache {}
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvopengltexturecachechromasamplingmodekey?language=objc)
    #[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
    pub static kCVOpenGLTextureCacheChromaSamplingModeKey: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvopengltexturecachechromasamplingmodeautomatic?language=objc)
    #[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
    pub static kCVOpenGLTextureCacheChromaSamplingModeAutomatic: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvopengltexturecachechromasamplingmodehighestquality?language=objc)
    #[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
    pub static kCVOpenGLTextureCacheChromaSamplingModeHighestQuality: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvopengltexturecachechromasamplingmodebestperformance?language=objc)
    #[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
    pub static kCVOpenGLTextureCacheChromaSamplingModeBestPerformance: &'static CFString;
}

unsafe impl ConcreteType for CVOpenGLTextureCache {
    #[doc(alias = "CVOpenGLTextureCacheGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CVOpenGLTextureCacheGetTypeID() -> CFTypeID;
        }
        unsafe { CVOpenGLTextureCacheGetTypeID() }
    }
}

impl CVOpenGLTextureCache {
    /// Creates a new Texture Cache.
    ///
    /// Parameter `allocator`: The CFAllocatorRef to use for allocating the cache.  May be NULL.
    ///
    /// Parameter `cacheAttributes`: A CFDictionaryRef containing the attributes of the cache itself.   May be NULL.
    ///
    /// Parameter `cglContext`: The OpenGL context into which the texture objects will be created
    ///
    /// Parameter `cglPixelFormat`: The OpenGL pixel format object used to create the passed in OpenGL context
    ///
    /// Parameter `textureAttributes`: A CFDictionaryRef containing the attributes to be used for creating the CVOpenGLTexture objects.  May be NULL.
    ///
    /// Parameter `cacheOut`: The newly created texture cache will be placed here
    ///
    /// Returns: Returns kCVReturnSuccess on success
    ///
    /// # Safety
    ///
    /// - `cache_attributes` generics must be of the correct type.
    /// - `cgl_context` must be a valid pointer.
    /// - `cgl_pixel_format` must be a valid pointer.
    /// - `texture_attributes` generics must be of the correct type.
    /// - `cache_out` must be a valid pointer.
    #[doc(alias = "CVOpenGLTextureCacheCreate")]
    #[cfg(all(feature = "CVReturn", feature = "objc2-open-gl"))]
    #[cfg(target_os = "macos")]
    #[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
    #[inline]
    pub unsafe fn create(
        allocator: Option<&CFAllocator>,
        cache_attributes: Option<&CFDictionary>,
        cgl_context: CGLContextObj,
        cgl_pixel_format: CGLPixelFormatObj,
        texture_attributes: Option<&CFDictionary>,
        cache_out: NonNull<*mut CVOpenGLTextureCache>,
    ) -> CVReturn {
        extern "C-unwind" {
            fn CVOpenGLTextureCacheCreate(
                allocator: Option<&CFAllocator>,
                cache_attributes: Option<&CFDictionary>,
                cgl_context: CGLContextObj,
                cgl_pixel_format: CGLPixelFormatObj,
                texture_attributes: Option<&CFDictionary>,
                cache_out: NonNull<*mut CVOpenGLTextureCache>,
            ) -> CVReturn;
        }
        unsafe {
            CVOpenGLTextureCacheCreate(
                allocator,
                cache_attributes,
                cgl_context,
                cgl_pixel_format,
                texture_attributes,
                cache_out,
            )
        }
    }

    /// Creates a CVOpenGLTexture object from an existing CVImageBuffer
    ///
    /// Parameter `allocator`: The CFAllocatorRef to use for allocating the CVOpenGLTexture object.  May be NULL.
    ///
    /// Parameter `textureCache`: The texture cache object that will manage the texture
    ///
    /// Parameter `sourceImage`: The CVImageBuffer that you want to create a CVOpenGLTexture from.
    ///
    /// Parameter `attributes`: For Future use only! - The desired buffer attributes for the CVOpenGLTexture.
    ///
    /// Parameter `textureOut`: The newly created texture object will be placed here.
    ///
    /// Returns: Returns kCVReturnSuccess on success
    ///
    /// # Safety
    ///
    /// - `attributes` generics must be of the correct type.
    /// - `texture_out` must be a valid pointer.
    #[doc(alias = "CVOpenGLTextureCacheCreateTextureFromImage")]
    #[cfg(all(
        feature = "CVBuffer",
        feature = "CVImageBuffer",
        feature = "CVOpenGLTexture",
        feature = "CVReturn"
    ))]
    #[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
    #[inline]
    pub unsafe fn create_texture_from_image(
        allocator: Option<&CFAllocator>,
        texture_cache: &CVOpenGLTextureCache,
        source_image: &CVImageBuffer,
        attributes: Option<&CFDictionary>,
        texture_out: NonNull<*mut CVOpenGLTexture>,
    ) -> CVReturn {
        extern "C-unwind" {
            fn CVOpenGLTextureCacheCreateTextureFromImage(
                allocator: Option<&CFAllocator>,
                texture_cache: &CVOpenGLTextureCache,
                source_image: &CVImageBuffer,
                attributes: Option<&CFDictionary>,
                texture_out: NonNull<*mut CVOpenGLTexture>,
            ) -> CVReturn;
        }
        unsafe {
            CVOpenGLTextureCacheCreateTextureFromImage(
                allocator,
                texture_cache,
                source_image,
                attributes,
                texture_out,
            )
        }
    }

    /// Performs internal housekeeping/recycling operations
    ///
    /// This call must be made periodically to give the texture cache a chance to make OpenGL calls
    /// on the OpenGL context used to create it in order to do housekeeping operations.
    ///
    /// Parameter `textureCache`: The texture cache object to flush
    ///
    /// Parameter `options`: Currently unused, set to 0.
    ///
    /// Returns: Returns kCVReturnSuccess on success
    #[doc(alias = "CVOpenGLTextureCacheFlush")]
    #[cfg(feature = "CVBase")]
    #[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
    #[inline]
    pub fn flush(&self, options: CVOptionFlags) {
        extern "C-unwind" {
            fn CVOpenGLTextureCacheFlush(
                texture_cache: &CVOpenGLTextureCache,
                options: CVOptionFlags,
            );
        }
        unsafe { CVOpenGLTextureCacheFlush(self, options) }
    }
}

extern "C-unwind" {
    #[cfg(all(feature = "CVReturn", feature = "objc2-open-gl"))]
    #[cfg(target_os = "macos")]
    #[deprecated = "renamed to `CVOpenGLTextureCache::create`"]
    pub fn CVOpenGLTextureCacheCreate(
        allocator: Option<&CFAllocator>,
        cache_attributes: Option<&CFDictionary>,
        cgl_context: CGLContextObj,
        cgl_pixel_format: CGLPixelFormatObj,
        texture_attributes: Option<&CFDictionary>,
        cache_out: NonNull<*mut CVOpenGLTextureCache>,
    ) -> CVReturn;
}

extern "C-unwind" {
    #[cfg(all(
        feature = "CVBuffer",
        feature = "CVImageBuffer",
        feature = "CVOpenGLTexture",
        feature = "CVReturn"
    ))]
    #[deprecated = "renamed to `CVOpenGLTextureCache::create_texture_from_image`"]
    pub fn CVOpenGLTextureCacheCreateTextureFromImage(
        allocator: Option<&CFAllocator>,
        texture_cache: &CVOpenGLTextureCache,
        source_image: &CVImageBuffer,
        attributes: Option<&CFDictionary>,
        texture_out: NonNull<*mut CVOpenGLTexture>,
    ) -> CVReturn;
}

#[cfg(feature = "CVBase")]
#[deprecated = "renamed to `CVOpenGLTextureCache::flush`"]
#[inline]
pub extern "C-unwind" fn CVOpenGLTextureCacheFlush(
    texture_cache: &CVOpenGLTextureCache,
    options: CVOptionFlags,
) {
    extern "C-unwind" {
        fn CVOpenGLTextureCacheFlush(texture_cache: &CVOpenGLTextureCache, options: CVOptionFlags);
    }
    unsafe { CVOpenGLTextureCacheFlush(texture_cache, options) }
}
