\page Exampleicsd Example icsd

\author Sylvain Meylan , Yann Perrot, Marcin Pietrzak, Carmen Villagrasa (a)       \n
(a) carmen.villagrasa _irsn _ fr             \n

This example is provided by the Geant4-DNA collaboration \n
Any report or published results obtained using the Geant4-DNA software  
shall cite the following Geant4-DNA collaboration publications: \n
[1] Med. Phys. 37 (2010) 4692-4708 \n
[2] Phys. Med. 31 (2015) 861-874 \n
In addition, for this example using DNA-materials cross-sections, please cite: \n
[3] Rad. Phys and Chem. 130 (2017) 459-479 \n
For this example using N2 cross-sections, please cite:\n
[4] Phys. Med. 102 (2022) 103-109\n

## INTRODUCTION
                                                                       
The icsd name of this example stands for: Ionisation Cluster Size Distribution.
This example allows the calculation of the distribution concerning the number of ionisations per event in an small cylinder of 2.3 nanometers diameter and 3.4 nanometers heigh, typical dimensions of a 10 base pairs piece of chromatin.

It constitutes the first use of new DNA-like material's cross-sections that were experimentally obtained at PTB (Rad. Phys and Chem. 130 (2017) 459-479) for electrons and calculated for protons on THF, TMP, PY and PU materials.

The new physical models corresponding to the DNA materials have recently been implemented in Geant4-DNA thaks to new classes, that allow the use of other materials different from liquid water: G4VDNAModel, G4DNAModelInterface,G4DNADummyModel and other associated classes.  

These new models are further described at:
http://geant4-dna.org

## GEOMETRY SET-UP AND PRIMARY PARTICLES
 
As indicated in the introduction, the geometry used in this exercise is a cylinder.
Two options are proposed: one nanometric cylinder made of DNA or a macroscopic volume with low nitrogen density.
The selection of the geometry is performed in the macro file:

--> `/icsd/setGeom dna`: a cylinder of 2.3 nanometers diameter and 3.4 nanometers height, typical dimensions of a 10 base pairs piece of chromatin that is centered in a cubic world of 10 nanometers side length filled with liquid water.
This cylinder is filled with THF material. The definition of the THF material must be done using the G4String="THF". Currently, other materials are available than also use the G4Strings to be recognized by the model classes "TMP", "PY" or "PU" for the DNA-like materials and "deoxyribose","adenine", "guanine", "thymine" or "cytosine" for the derived DNA materials.

--> `/icsd/setGeom nanodosimeter`: a cylinder of 10 mm nanometers diameter and 10 nanometers height filled with low pressure nitrogen (0.34 µg/cm3)  mimicking the size of a short of segment od DNA of 2.3 nm in both diameter and height
The obtained results can be compared to experimental data from Jet Counter nanodosimeter as shown in Pietrazk et al.
Phys. Med. 102 (2022) 103-109

Primary particles are electrons starting at the cylinder's edge) and initial momentum (1,0,0)

## PHYSICS LIST
                                                                        
The PhysicsList used in this example show how to use the new classes that allow Geant4-DNA to use other materials than liquid water :
-# Models are built: classical Geant4-DNA models for liquid water material and PTB models for DNA-like materials
-# G4DNAModelInterface object is built for each type of interaction (elastic, ionisation, excitation)
-# G4DNAModels are registered within the corresponding  G4DNAModelInterface. For liquid water models, the particle name must be added to the RegisterModel function. For DNA-like material models and Vacuum no other parameter is needed.
-# G4DNAProcesses objects are built and the corresponding G4DNAModelInterface is registered within. G4DNAModelInterface acts like a classical G4VEmModel

Remember that new DNA-like material classes are available for:
```
electrons from 12 eV-1 keV, including elastic, ionisation and excitation processes
protons from 70 keV to 10 MeV, only for ionisation processes following a modified HKS formalism
```

## SET UP

Make sure G4LEDATA points to the low energy electromagnetic data files.

## HOW TO RUN THE EXAMPLE

 ./icsd  will run in multi-threaded mode with 2 threads by default. 
 Two ntuples will be filled in the output file:
 - Ntuple 1 contains the information for calculating the ionisation cluster size distribution per event
 - Ntuple 2 contains interaction information at the step level

```
Please, do not forget to make "hadd ICSD.root ICSD_t0.root ICSD_t1.root" before using plot.C
```
