package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddCasterComponent invokes the live.AddCasterComponent API synchronously
func (client *Client) AddCasterComponent(request *AddCasterComponentRequest) (response *AddCasterComponentResponse, err error) {
	response = CreateAddCasterComponentResponse()
	err = client.DoAction(request, response)
	return
}

// AddCasterComponentWithChan invokes the live.AddCasterComponent API asynchronously
func (client *Client) AddCasterComponentWithChan(request *AddCasterComponentRequest) (<-chan *AddCasterComponentResponse, <-chan error) {
	responseChan := make(chan *AddCasterComponentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddCasterComponent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddCasterComponentWithCallback invokes the live.AddCasterComponent API asynchronously
func (client *Client) AddCasterComponentWithCallback(request *AddCasterComponentRequest, callback func(response *AddCasterComponentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddCasterComponentResponse
		var err error
		defer close(result)
		response, err = client.AddCasterComponent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddCasterComponentRequest is the request struct for api AddCasterComponent
type AddCasterComponentRequest struct {
	*requests.RpcRequest
	HtmlLayerContent    string           `position:"Query" name:"HtmlLayerContent"`
	ImageLayerContent   string           `position:"Query" name:"ImageLayerContent"`
	ComponentName       string           `position:"Query" name:"ComponentName"`
	LayerOrder          string           `position:"Query" name:"LayerOrder"`
	CasterId            string           `position:"Query" name:"CasterId"`
	ComponentLayer      string           `position:"Query" name:"ComponentLayer"`
	OwnerId             requests.Integer `position:"Query" name:"OwnerId"`
	ComponentType       string           `position:"Query" name:"ComponentType"`
	LocationId          string           `position:"Query" name:"LocationId"`
	Effect              string           `position:"Query" name:"Effect"`
	CaptionLayerContent string           `position:"Query" name:"CaptionLayerContent"`
	TextLayerContent    string           `position:"Query" name:"TextLayerContent"`
}

// AddCasterComponentResponse is the response struct for api AddCasterComponent
type AddCasterComponentResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	ComponentId string `json:"ComponentId" xml:"ComponentId"`
}

// CreateAddCasterComponentRequest creates a request to invoke AddCasterComponent API
func CreateAddCasterComponentRequest() (request *AddCasterComponentRequest) {
	request = &AddCasterComponentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddCasterComponent", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddCasterComponentResponse creates a response to parse from AddCasterComponent response
func CreateAddCasterComponentResponse() (response *AddCasterComponentResponse) {
	response = &AddCasterComponentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
