package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListJobs invokes the ehpc.ListJobs API synchronously
func (client *Client) ListJobs(request *ListJobsRequest) (response *ListJobsResponse, err error) {
	response = CreateListJobsResponse()
	err = client.DoAction(request, response)
	return
}

// ListJobsWithChan invokes the ehpc.ListJobs API asynchronously
func (client *Client) ListJobsWithChan(request *ListJobsRequest) (<-chan *ListJobsResponse, <-chan error) {
	responseChan := make(chan *ListJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListJobsWithCallback invokes the ehpc.ListJobs API asynchronously
func (client *Client) ListJobsWithCallback(request *ListJobsRequest, callback func(response *ListJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListJobsResponse
		var err error
		defer close(result)
		response, err = client.ListJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListJobsRequest is the request struct for api ListJobs
type ListJobsRequest struct {
	*requests.RpcRequest
	Owner      string           `position:"Query" name:"Owner"`
	ClusterId  string           `position:"Query" name:"ClusterId"`
	Rerunable  string           `position:"Query" name:"Rerunable"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	State      string           `position:"Query" name:"State"`
}

// ListJobsResponse is the response struct for api ListJobs
type ListJobsResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	PageSize   int    `json:"PageSize" xml:"PageSize"`
	Jobs       Jobs   `json:"Jobs" xml:"Jobs"`
}

// CreateListJobsRequest creates a request to invoke ListJobs API
func CreateListJobsRequest() (request *ListJobsRequest) {
	request = &ListJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "ListJobs", "", "")
	request.Method = requests.GET
	return
}

// CreateListJobsResponse creates a response to parse from ListJobs response
func CreateListJobsResponse() (response *ListJobsResponse) {
	response = &ListJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
