package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddDnsGtmAccessStrategy invokes the alidns.AddDnsGtmAccessStrategy API synchronously
func (client *Client) AddDnsGtmAccessStrategy(request *AddDnsGtmAccessStrategyRequest) (response *AddDnsGtmAccessStrategyResponse, err error) {
	response = CreateAddDnsGtmAccessStrategyResponse()
	err = client.DoAction(request, response)
	return
}

// AddDnsGtmAccessStrategyWithChan invokes the alidns.AddDnsGtmAccessStrategy API asynchronously
func (client *Client) AddDnsGtmAccessStrategyWithChan(request *AddDnsGtmAccessStrategyRequest) (<-chan *AddDnsGtmAccessStrategyResponse, <-chan error) {
	responseChan := make(chan *AddDnsGtmAccessStrategyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddDnsGtmAccessStrategy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddDnsGtmAccessStrategyWithCallback invokes the alidns.AddDnsGtmAccessStrategy API asynchronously
func (client *Client) AddDnsGtmAccessStrategyWithCallback(request *AddDnsGtmAccessStrategyRequest, callback func(response *AddDnsGtmAccessStrategyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddDnsGtmAccessStrategyResponse
		var err error
		defer close(result)
		response, err = client.AddDnsGtmAccessStrategy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddDnsGtmAccessStrategyRequest is the request struct for api AddDnsGtmAccessStrategy
type AddDnsGtmAccessStrategyRequest struct {
	*requests.RpcRequest
	DefaultLbaStrategy          string                                     `position:"Query" name:"DefaultLbaStrategy"`
	FailoverAddrPoolType        string                                     `position:"Query" name:"FailoverAddrPoolType"`
	DefaultAddrPoolType         string                                     `position:"Query" name:"DefaultAddrPoolType"`
	FailoverMaxReturnAddrNum    requests.Integer                           `position:"Query" name:"FailoverMaxReturnAddrNum"`
	FailoverLbaStrategy         string                                     `position:"Query" name:"FailoverLbaStrategy"`
	DefaultAddrPool             *[]AddDnsGtmAccessStrategyDefaultAddrPool  `position:"Query" name:"DefaultAddrPool"  type:"Repeated"`
	FailoverMinAvailableAddrNum requests.Integer                           `position:"Query" name:"FailoverMinAvailableAddrNum"`
	DefaultMaxReturnAddrNum     requests.Integer                           `position:"Query" name:"DefaultMaxReturnAddrNum"`
	DefaultMinAvailableAddrNum  requests.Integer                           `position:"Query" name:"DefaultMinAvailableAddrNum"`
	StrategyMode                string                                     `position:"Query" name:"StrategyMode"`
	Lang                        string                                     `position:"Query" name:"Lang"`
	Lines                       string                                     `position:"Query" name:"Lines"`
	StrategyName                string                                     `position:"Query" name:"StrategyName"`
	DefaultLatencyOptimization  string                                     `position:"Query" name:"DefaultLatencyOptimization"`
	InstanceId                  string                                     `position:"Query" name:"InstanceId"`
	FailoverLatencyOptimization string                                     `position:"Query" name:"FailoverLatencyOptimization"`
	UserClientIp                string                                     `position:"Query" name:"UserClientIp"`
	FailoverAddrPool            *[]AddDnsGtmAccessStrategyFailoverAddrPool `position:"Query" name:"FailoverAddrPool"  type:"Repeated"`
}

// AddDnsGtmAccessStrategyDefaultAddrPool is a repeated param struct in AddDnsGtmAccessStrategyRequest
type AddDnsGtmAccessStrategyDefaultAddrPool struct {
	Id        string `name:"Id"`
	LbaWeight string `name:"LbaWeight"`
}

// AddDnsGtmAccessStrategyFailoverAddrPool is a repeated param struct in AddDnsGtmAccessStrategyRequest
type AddDnsGtmAccessStrategyFailoverAddrPool struct {
	Id        string `name:"Id"`
	LbaWeight string `name:"LbaWeight"`
}

// AddDnsGtmAccessStrategyResponse is the response struct for api AddDnsGtmAccessStrategy
type AddDnsGtmAccessStrategyResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	StrategyId string `json:"StrategyId" xml:"StrategyId"`
}

// CreateAddDnsGtmAccessStrategyRequest creates a request to invoke AddDnsGtmAccessStrategy API
func CreateAddDnsGtmAccessStrategyRequest() (request *AddDnsGtmAccessStrategyRequest) {
	request = &AddDnsGtmAccessStrategyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "AddDnsGtmAccessStrategy", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddDnsGtmAccessStrategyResponse creates a response to parse from AddDnsGtmAccessStrategy response
func CreateAddDnsGtmAccessStrategyResponse() (response *AddDnsGtmAccessStrategyResponse) {
	response = &AddDnsGtmAccessStrategyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
