/*
 * Wine server protocol definitions
 *
 * This file is automatically generated; DO NO EDIT!
 * Edit server/protocol.def instead and re-run tools/make_requests
 */

#ifndef __WINE_WINE_SERVER_PROTOCOL_H
#define __WINE_WINE_SERVER_PROTOCOL_H

#include <stdarg.h>
#include <stdlib.h>
#include <time.h>

#include <windef.h>
#include <winbase.h>
#include <ntuser.h>

typedef unsigned int obj_handle_t;
typedef unsigned int user_handle_t;
typedef unsigned int d3dkmt_handle_t;
typedef unsigned int atom_t;
typedef unsigned int process_id_t;
typedef unsigned int thread_id_t;
typedef unsigned int data_size_t;
typedef unsigned int ioctl_code_t;
typedef unsigned __int64 lparam_t;
typedef unsigned __int64 apc_param_t;
typedef unsigned __int64 mem_size_t;
typedef unsigned __int64 file_pos_t;
typedef unsigned __int64 client_ptr_t;
typedef unsigned __int64 affinity_t;
typedef unsigned __int64 object_id_t;
typedef client_ptr_t mod_handle_t;

struct request_header
{
    int          req;
    data_size_t  request_size;
    data_size_t  reply_size;
};

struct reply_header
{
    unsigned int error;
    data_size_t  reply_size;
};



struct request_max_size
{
    int pad[16];
};

#define FIRST_USER_HANDLE 0x0020
#define LAST_USER_HANDLE  0xffef



union debug_event_data
{
    int code;
    struct
    {
        int              code;
        int              first;
        unsigned int     exc_code;
        unsigned int     flags;
        client_ptr_t     record;
        client_ptr_t     address;
        int              nb_params;
        int              __pad;
        client_ptr_t     params[15];
    } exception;
    struct
    {
        int          code;
        obj_handle_t handle;
        client_ptr_t start;
    } create_thread;
    struct
    {
        int          code;
        obj_handle_t file;
        obj_handle_t process;
        obj_handle_t thread;
        mod_handle_t base;
        int          dbg_offset;
        int          dbg_size;
        client_ptr_t start;
    } create_process;
    struct
    {
        int          code;
        int          exit_code;
    } exit;
    struct
    {
        int          code;
        obj_handle_t handle;
        mod_handle_t base;
        int          dbg_offset;
        int          dbg_size;
        client_ptr_t name;
    } load_dll;
    struct
    {
        int          code;
        int          __pad;
        mod_handle_t base;
    } unload_dll;
};


enum context_exec_space
{
    EXEC_SPACE_USERMODE,
    EXEC_SPACE_SYSCALL,
    EXEC_SPACE_EXCEPTION,
};


struct context_data
{
    unsigned int     machine;
    unsigned int     flags;
    union
    {
        struct { unsigned int eip, ebp, esp, eflags, cs, ss; } i386_regs;
        struct { unsigned __int64 rip, rsp;
                 unsigned int cs, ss, flags, __pad; } x86_64_regs;
        struct { unsigned int sp, lr, pc, cpsr; } arm_regs;
        struct { unsigned __int64 sp, pc, pstate; } arm64_regs;
    } ctl;
    union
    {
        struct { unsigned int eax, ebx, ecx, edx, esi, edi; } i386_regs;
        struct { unsigned __int64 rax, rbx, rcx, rdx, rbp, rsi, rdi,
                                  r8, r9, r10, r11, r12, r13, r14, r15; } x86_64_regs;
        struct { unsigned int r[13]; } arm_regs;
        struct { unsigned __int64 x[31]; } arm64_regs;
    } integer;
    union
    {
        struct { unsigned int ds, es, fs, gs; } i386_regs;
        struct { unsigned int ds, es, fs, gs; } x86_64_regs;
    } seg;
    union
    {
        struct { unsigned int ctrl, status, tag, err_off, err_sel, data_off, data_sel, cr0npx;
                 unsigned char regs[80]; } i386_regs;
        struct { struct { unsigned __int64 low, high; } fpregs[32]; } x86_64_regs;
        struct { unsigned __int64 d[32]; unsigned int fpscr; } arm_regs;
        struct { struct { unsigned __int64 low, high; } q[32]; unsigned int fpcr, fpsr; } arm64_regs;
    } fp;
    union
    {
        struct { unsigned int dr0, dr1, dr2, dr3, dr6, dr7; } i386_regs;
        struct { unsigned __int64 dr0, dr1, dr2, dr3, dr6, dr7; } x86_64_regs;
        struct { unsigned int bvr[8], bcr[8], wvr[1], wcr[1]; } arm_regs;
        struct { unsigned __int64 bvr[8], wvr[2]; unsigned int bcr[8], wcr[2]; } arm64_regs;
    } debug;
    union
    {
        unsigned char i386_regs[512];
    } ext;
    union
    {
        struct { enum context_exec_space space; int __pad; } space;
    } exec_space;
    union
    {
        struct { struct { unsigned __int64 low, high; } ymm_high[16]; } regs;
    } ymm;
};

#define SERVER_CTX_CONTROL            0x01
#define SERVER_CTX_INTEGER            0x02
#define SERVER_CTX_SEGMENTS           0x04
#define SERVER_CTX_FLOATING_POINT     0x08
#define SERVER_CTX_DEBUG_REGISTERS    0x10
#define SERVER_CTX_EXTENDED_REGISTERS 0x20
#define SERVER_CTX_YMM_REGISTERS      0x40
#define SERVER_CTX_EXEC_SPACE         0x80


struct send_fd
{
    thread_id_t tid;
    int         fd;
};


struct wake_up_reply
{
    client_ptr_t cookie;
    int          signaled;
    int          __pad;
};


typedef __int64 timeout_t;
#define TIMEOUT_INFINITE (((timeout_t)0x7fffffff) << 32 | 0xffffffff)


typedef __int64 abstime_t;


struct startup_info_data
{
    unsigned int debug_flags;
    unsigned int console_flags;
    obj_handle_t console;
    obj_handle_t hstdin;
    obj_handle_t hstdout;
    obj_handle_t hstderr;
    unsigned int x;
    unsigned int y;
    unsigned int xsize;
    unsigned int ysize;
    unsigned int xchars;
    unsigned int ychars;
    unsigned int attribute;
    unsigned int flags;
    unsigned int show;
    process_id_t process_group_id;
    data_size_t  curdir_len;
    data_size_t  dllpath_len;
    data_size_t  imagepath_len;
    data_size_t  cmdline_len;
    data_size_t  title_len;
    data_size_t  desktop_len;
    data_size_t  shellinfo_len;
    data_size_t  runtime_len;








};


struct property_data
{
    atom_t         atom;
    int            string;
    lparam_t       data;
};


struct rectangle
{
    int  left;
    int  top;
    int  right;
    int  bottom;
};


struct async_data
{
    obj_handle_t    handle;
    obj_handle_t    event;
    client_ptr_t    iosb;
    client_ptr_t    user;
    client_ptr_t    apc;
    apc_param_t     apc_context;
};



struct hw_msg_source
{
    unsigned int    device;
    unsigned int    origin;
};

struct rawinput
{
    int                  type;
    unsigned int         device;
    unsigned int         wparam;
    unsigned int         usage;
};

struct hardware_msg_data
{
    lparam_t             info;
    data_size_t          size;
    int                  __pad;
    unsigned int         hw_id;
    unsigned int         flags;
    struct hw_msg_source source;
    struct rawinput      rawinput;
};

struct callback_msg_data
{
    client_ptr_t    callback;
    lparam_t        data;
    lparam_t        result;
};

struct winevent_msg_data
{
    user_handle_t   hook;
    thread_id_t     tid;
    client_ptr_t    hook_proc;

};

union hw_input
{
    int type;
    struct
    {
        int            type;
        unsigned short vkey;
        unsigned short scan;
        unsigned int   flags;
        unsigned int   time;
        lparam_t       info;
    } kbd;
    struct
    {
        int            type;
        int            x;
        int            y;
        unsigned int   data;
        unsigned int   flags;
        unsigned int   time;
        lparam_t       info;
    } mouse;
    struct
    {
        int            type;
        unsigned int   msg;
        lparam_t       wparam;
        lparam_t       lparam;
        struct hid_input hid;
    } hw;
};

union message_data
{
    unsigned char            bytes[1];
    struct hardware_msg_data hardware;
    struct callback_msg_data callback;
    struct winevent_msg_data winevent;
};


struct filesystem_event
{
    int         action;
    data_size_t len;
    char        name[1];
};

struct luid
{
    unsigned int low_part;
    int          high_part;
};

struct luid_attr
{
    struct luid  luid;
    unsigned int attrs;
};

struct acl
{
    unsigned char  revision;
    unsigned char  pad1;
    unsigned short size;
    unsigned short count;
    unsigned short pad2;
};

struct sid
{
    unsigned char revision;
    unsigned char sub_count;
    unsigned char id_auth[6];
    unsigned int  sub_auth[15];
};

struct generic_map
{
    unsigned int read;
    unsigned int write;
    unsigned int exec;
    unsigned int all;
};

#define MAX_ACL_LEN 65535

struct security_descriptor
{
    unsigned int control;
    data_size_t  owner_len;
    data_size_t  group_len;
    data_size_t  sacl_len;
    data_size_t  dacl_len;




};

struct object_attributes
{
    obj_handle_t rootdir;
    unsigned int attributes;
    data_size_t  sd_len;
    data_size_t  name_len;


};

struct object_type_info
{
    data_size_t   name_len;
    unsigned int  index;
    unsigned int  obj_count;
    unsigned int  handle_count;
    unsigned int  obj_max;
    unsigned int  handle_max;
    unsigned int  valid_access;
    struct generic_map mapping;

};

enum select_opcode
{
    SELECT_NONE,
    SELECT_WAIT,
    SELECT_WAIT_ALL,
    SELECT_SIGNAL_AND_WAIT,
    SELECT_KEYED_EVENT_WAIT,
    SELECT_KEYED_EVENT_RELEASE
};

union select_op
{
    enum select_opcode op;
    struct
    {
        enum select_opcode op;
        obj_handle_t    handles[MAXIMUM_WAIT_OBJECTS];
        int             __pad;
    } wait;
    struct
    {
        enum select_opcode op;
        obj_handle_t    wait;
        obj_handle_t    signal;
    } signal_and_wait;
    struct
    {
        enum select_opcode op;
        obj_handle_t    handle;
        client_ptr_t    key;
    } keyed_event;
};

enum apc_type
{
    APC_NONE,
    APC_USER,
    APC_ASYNC_IO,
    APC_VIRTUAL_ALLOC,
    APC_VIRTUAL_ALLOC_EX,
    APC_VIRTUAL_FREE,
    APC_VIRTUAL_QUERY,
    APC_VIRTUAL_PROTECT,
    APC_VIRTUAL_FLUSH,
    APC_VIRTUAL_LOCK,
    APC_VIRTUAL_UNLOCK,
    APC_MAP_VIEW,
    APC_MAP_VIEW_EX,
    APC_UNMAP_VIEW,
    APC_CREATE_THREAD,
    APC_DUP_HANDLE
};

struct user_apc
{
    enum apc_type    type;
    unsigned int     flags;
    client_ptr_t     func;
    apc_param_t      args[3];
};

#define SERVER_USER_APC_SPECIAL               0x01
#define SERVER_USER_APC_CALLBACK_DATA_CONTEXT 0x02

union apc_call
{
    enum apc_type type;
    struct user_apc user;
    struct
    {
        enum apc_type    type;
        unsigned int     status;
        client_ptr_t     user;
        client_ptr_t     sb;
        data_size_t      result;
    } async_io;
    struct
    {
        enum apc_type    type;
        unsigned int     op_type;
        client_ptr_t     addr;
        mem_size_t       size;
        mem_size_t       zero_bits;
        unsigned int     prot;
    } virtual_alloc;
    struct
    {
        enum apc_type    type;
        unsigned int     op_type;
        client_ptr_t     addr;
        mem_size_t       size;
        mem_size_t       limit_low;
        mem_size_t       limit_high;
        mem_size_t       align;
        unsigned int     prot;
        unsigned int     attributes;
    } virtual_alloc_ex;
    struct
    {
        enum apc_type    type;
        unsigned int     op_type;
        client_ptr_t     addr;
        mem_size_t       size;
    } virtual_free;
    struct
    {
        enum apc_type    type;
        int              __pad;
        client_ptr_t     addr;
    } virtual_query;
    struct
    {
        enum apc_type    type;
        unsigned int     prot;
        client_ptr_t     addr;
        mem_size_t       size;
    } virtual_protect;
    struct
    {
        enum apc_type    type;
        int              __pad;
        client_ptr_t     addr;
        mem_size_t       size;
    } virtual_flush;
    struct
    {
        enum apc_type    type;
        int              __pad;
        client_ptr_t     addr;
        mem_size_t       size;
    } virtual_lock;
    struct
    {
        enum apc_type    type;
        int              __pad;
        client_ptr_t     addr;
        mem_size_t       size;
    } virtual_unlock;
    struct
    {
        enum apc_type    type;
        obj_handle_t     handle;
        client_ptr_t     addr;
        mem_size_t       size;
        file_pos_t       offset;
        mem_size_t       zero_bits;
        unsigned int     alloc_type;
        unsigned int     prot;
    } map_view;
    struct
    {
        enum apc_type    type;
        obj_handle_t     handle;
        client_ptr_t     addr;
        mem_size_t       size;
        file_pos_t       offset;
        mem_size_t       limit_low;
        mem_size_t       limit_high;
        unsigned int     alloc_type;
        unsigned int     prot;
        unsigned short   machine;
        unsigned short   __pad[3];
    } map_view_ex;
    struct
    {
        enum apc_type    type;
        unsigned int     flags;
        client_ptr_t     addr;
    } unmap_view;
    struct
    {
        enum apc_type    type;
        unsigned int     flags;
        client_ptr_t     func;
        client_ptr_t     arg;
        mem_size_t       zero_bits;
        mem_size_t       reserve;
        mem_size_t       commit;
    } create_thread;
    struct
    {
        enum apc_type    type;
        obj_handle_t     src_handle;
        obj_handle_t     dst_process;
        unsigned int     access;
        unsigned int     attributes;
        unsigned int     options;
    } dup_handle;
};

union apc_result
{
    enum apc_type type;
    struct
    {
        enum apc_type    type;
        unsigned int     status;
        unsigned int     total;
    } async_io;
    struct
    {
        enum apc_type    type;
        unsigned int     status;
        client_ptr_t     addr;
        mem_size_t       size;
    } virtual_alloc;
    struct
    {
        enum apc_type    type;
        unsigned int     status;
        client_ptr_t     addr;
        mem_size_t       size;
    } virtual_alloc_ex;
    struct
    {
        enum apc_type    type;
        unsigned int     status;
        client_ptr_t     addr;
        mem_size_t       size;
    } virtual_free;
    struct
    {
        enum apc_type    type;
        unsigned int     status;
        client_ptr_t     base;
        client_ptr_t     alloc_base;
        mem_size_t       size;
        unsigned short   state;
        unsigned short   prot;
        unsigned short   alloc_prot;
        unsigned short   alloc_type;
    } virtual_query;
    struct
    {
        enum apc_type    type;
        unsigned int     status;
        client_ptr_t     addr;
        mem_size_t       size;
        unsigned int     prot;
    } virtual_protect;
    struct
    {
        enum apc_type    type;
        unsigned int     status;
        client_ptr_t     addr;
        mem_size_t       size;
    } virtual_flush;
    struct
    {
        enum apc_type    type;
        unsigned int     status;
        client_ptr_t     addr;
        mem_size_t       size;
    } virtual_lock;
    struct
    {
        enum apc_type    type;
        unsigned int     status;
        client_ptr_t     addr;
        mem_size_t       size;
    } virtual_unlock;
    struct
    {
        enum apc_type    type;
        unsigned int     status;
        client_ptr_t     addr;
        mem_size_t       size;
    } map_view;
    struct
    {
        enum apc_type    type;
        unsigned int     status;
        client_ptr_t     addr;
        mem_size_t       size;
    } map_view_ex;
    struct
    {
        enum apc_type    type;
        unsigned int     status;
    } unmap_view;
    struct
    {
        enum apc_type    type;
        unsigned int     status;
        process_id_t     pid;
        thread_id_t      tid;
        client_ptr_t     teb;
        obj_handle_t     handle;
    } create_thread;
    struct
    {
        enum apc_type    type;
        unsigned int     status;
        obj_handle_t     handle;
    } dup_handle;
    struct
    {
        enum apc_type    type;
        unsigned int     status;
    } break_process;
};

enum irp_type
{
    IRP_CALL_NONE,
    IRP_CALL_CREATE,
    IRP_CALL_CLOSE,
    IRP_CALL_READ,
    IRP_CALL_WRITE,
    IRP_CALL_FLUSH,
    IRP_CALL_IOCTL,
    IRP_CALL_VOLUME,
    IRP_CALL_FREE,
    IRP_CALL_CANCEL
};

union irp_params
{
    enum irp_type        type;
    struct
    {
        enum irp_type    type;
        unsigned int     access;
        unsigned int     sharing;
        unsigned int     options;
        client_ptr_t     device;
        obj_handle_t     file;
    } create;
    struct
    {
        enum irp_type    type;
        int              __pad;
        client_ptr_t     file;
    } close;
    struct
    {
        enum irp_type    type;
        unsigned int     key;
        data_size_t      out_size;
        int              __pad;
        client_ptr_t     file;
        file_pos_t       pos;
    } read;
    struct
    {
        enum irp_type    type;
        unsigned int     key;
        client_ptr_t     file;
        file_pos_t       pos;
    } write;
    struct
    {
        enum irp_type    type;
        int              __pad;
        client_ptr_t     file;
    } flush;
    struct
    {
        enum irp_type    type;
        ioctl_code_t     code;
        data_size_t      out_size;
        int              __pad;
        client_ptr_t     file;
    } ioctl;
    struct
    {
        enum irp_type    type;
        unsigned int     info_class;
        data_size_t      out_size;
        int              __pad;
        client_ptr_t     file;
    } volume;
    struct
    {
        enum irp_type    type;
        int              __pad;
        client_ptr_t     obj;
    } free;
    struct
    {
        enum irp_type    type;
        int              __pad;
        client_ptr_t     irp;
    } cancel;
};


struct pe_image_info
{
    client_ptr_t   base;
    client_ptr_t   map_addr;
    mem_size_t     stack_size;
    mem_size_t     stack_commit;
    unsigned int   entry_point;
    unsigned int   map_size;
    unsigned int   alignment;
    unsigned int   zerobits;
    unsigned int   subsystem;
    unsigned short subsystem_minor;
    unsigned short subsystem_major;
    unsigned short osversion_major;
    unsigned short osversion_minor;
    unsigned short image_charact;
    unsigned short dll_charact;
    unsigned short machine;
    unsigned char  contains_code : 1;
    unsigned char  wine_builtin : 1;
    unsigned char  wine_fakedll : 1;
    unsigned char  is_hybrid : 1;
    unsigned char  padding : 4;
    unsigned char  image_flags;
    unsigned int   loader_flags;
    unsigned int   header_size;
    unsigned int   header_map_size;
    unsigned int   file_size;
    unsigned int   checksum;
    unsigned int   dbg_offset;
    unsigned int   dbg_size;
};
#define IMAGE_FLAGS_ComPlusNativeReady        0x01
#define IMAGE_FLAGS_ComPlusILOnly             0x02
#define IMAGE_FLAGS_ImageDynamicallyRelocated 0x04
#define IMAGE_FLAGS_ImageMappedFlat           0x08
#define IMAGE_FLAGS_BaseBelow4gb              0x10
#define IMAGE_FLAGS_ComPlusPrefer32bit        0x20

struct rawinput_device
{
    unsigned int   usage;
    unsigned int   flags;
    user_handle_t  target;
};

struct cursor_pos
{
    int x;
    int y;
    unsigned int time;
    int __pad;
    lparam_t info;
};

struct directory_entry
{
    data_size_t name_len;
    data_size_t type_len;


};

struct monitor_info
{
    struct rectangle raw;
    struct rectangle virt;
    unsigned int     flags;
    unsigned int     dpi;
};
#define MONITOR_FLAG_PRIMARY  0x01
#define MONITOR_FLAG_CLONE    0x02
#define MONITOR_FLAG_INACTIVE 0x04

union tcp_connection
{
    struct
    {
        unsigned int family;
        process_id_t owner;
        unsigned int state;
    } common;
    struct
    {
        unsigned int family;
        process_id_t owner;
        unsigned int state;
        unsigned int local_addr;
        unsigned int local_port;
        unsigned int remote_addr;
        unsigned int remote_port;
    } ipv4;
    struct
    {
        unsigned int family;
        process_id_t owner;
        unsigned int state;
        unsigned char local_addr[16];
        unsigned int local_scope_id;
        unsigned int local_port;
        unsigned char remote_addr[16];
        unsigned int remote_scope_id;
        unsigned int remote_port;
    } ipv6;
};

union udp_endpoint
{
    struct
    {
        unsigned int family;
        process_id_t owner;
    } common;
    struct
    {
        unsigned int family;
        process_id_t owner;
        unsigned int addr;
        unsigned int port;
    } ipv4;
    struct
    {
        unsigned int family;
        process_id_t owner;
        unsigned char addr[16];
        unsigned int scope_id;
        unsigned int port;
    } ipv6;
};

enum d3dkmt_type
{
    D3DKMT_ADAPTER      = 1,
    D3DKMT_DEVICE       = 2,
    D3DKMT_SOURCE       = 3,
    D3DKMT_MUTEX        = 4,
    D3DKMT_SYNC         = 5,
    D3DKMT_RESOURCE     = 6,
    D3DKMT_ALLOCATION   = 7,
};




struct obj_locator
{
    object_id_t          id;
    mem_size_t           offset;
};

#define MAX_ATOM_LEN     255
#define WH_WINEVENT      (WH_MAXHOOK + 1)
#define NB_HOOKS         (WH_WINEVENT - WH_MINHOOK + 1)

struct shared_cursor
{
    int                  x;
    int                  y;
    unsigned int         last_change;
    struct rectangle     clip;
};

typedef volatile struct
{
    unsigned int         flags;
    struct shared_cursor cursor;
    unsigned char        keystate[256];
    unsigned __int64     monitor_serial;
    unsigned __int64     keystate_serial;
} desktop_shm_t;

typedef volatile struct
{
    timeout_t            access_time;
    unsigned int         wake_mask;
    unsigned int         wake_bits;
    unsigned int         changed_mask;
    unsigned int         changed_bits;
    unsigned int         internal_bits;
    int                  hooks_count[NB_HOOKS];
} queue_shm_t;

typedef volatile struct
{
    int                  foreground;
    user_handle_t        active;
    user_handle_t        focus;
    user_handle_t        capture;
    user_handle_t        menu_owner;
    user_handle_t        move_size;
    user_handle_t        caret;
    struct rectangle     caret_rect;
    user_handle_t        cursor;
    int                  cursor_count;
    unsigned char        keystate[256];
    int                  keystate_lock;
    unsigned __int64     keystate_serial;
} input_shm_t;

typedef volatile struct
{
    atom_t               atom;
    unsigned int         style;
    unsigned int         cls_extra;
    unsigned int         win_extra;
    mod_handle_t         instance;
    data_size_t          name_offset;
    data_size_t          name_len;
    WCHAR                name[MAX_ATOM_LEN];
    unsigned short       __pad;
    char                 extra[];
} class_shm_t;

typedef volatile struct
{
    struct obj_locator   class;
    unsigned int         dpi_context;
} window_shm_t;

typedef volatile union
{
    desktop_shm_t        desktop;
    queue_shm_t          queue;
    input_shm_t          input;
    class_shm_t          class;
    window_shm_t         window;
} object_shm_t;

typedef volatile struct
{
    LONG64               seq;
    object_id_t          id;
    object_shm_t         shm;
} shared_object_t;

typedef volatile struct
{
    struct user_entry user_entries[MAX_USER_HANDLES];
} session_shm_t;





struct new_process_request
{
    struct request_header __header;
    obj_handle_t token;
    obj_handle_t debug;
    obj_handle_t parent_process;
    unsigned int flags;
    int          socket_fd;
    unsigned int access;
    unsigned short machine;
    char __pad_38[2];
    data_size_t  info_size;
    data_size_t  handles_size;
    data_size_t  jobs_size;
    /* VARARG(objattr,object_attributes); */
    /* VARARG(handles,uints,handles_size); */
    /* VARARG(jobs,uints,jobs_size); */
    /* VARARG(info,startup_info,info_size); */
    /* VARARG(env,unicode_str); */
    char __pad_52[4];
};
struct new_process_reply
{
    struct reply_header __header;
    obj_handle_t info;
    process_id_t pid;
    obj_handle_t handle;
    char __pad_20[4];
};



struct get_new_process_info_request
{
    struct request_header __header;
    obj_handle_t info;
};
struct get_new_process_info_reply
{
    struct reply_header __header;
    int          success;
    int          exit_code;
};



struct new_thread_request
{
    struct request_header __header;
    obj_handle_t process;
    unsigned int access;
    unsigned int flags;
    int          request_fd;
    /* VARARG(objattr,object_attributes); */
    char __pad_28[4];
};
struct new_thread_reply
{
    struct reply_header __header;
    thread_id_t  tid;
    obj_handle_t handle;
};



struct get_startup_info_request
{
    struct request_header __header;
    char __pad_12[4];
};
struct get_startup_info_reply
{
    struct reply_header __header;
    data_size_t  info_size;
    unsigned short machine;
    /* VARARG(info,startup_info,info_size); */
    /* VARARG(env,unicode_str); */
    char __pad_14[2];
};



struct init_process_done_request
{
    struct request_header __header;
    char __pad_12[4];
    client_ptr_t teb;
    client_ptr_t peb;
};
struct init_process_done_reply
{
    struct reply_header __header;
    int          suspend;
    char __pad_12[4];
};



struct init_first_thread_request
{
    struct request_header __header;
    int          unix_pid;
    int          unix_tid;
    int          debug_level;
    int          reply_fd;
    int          wait_fd;
};
struct init_first_thread_reply
{
    struct reply_header __header;
    process_id_t pid;
    thread_id_t  tid;
    timeout_t    server_start;
    unsigned int session_id;
    obj_handle_t inproc_device;
    data_size_t  info_size;
    /* VARARG(machines,ushorts); */
    char __pad_36[4];
};



struct init_thread_request
{
    struct request_header __header;
    int          unix_tid;
    int          reply_fd;
    int          wait_fd;
    client_ptr_t teb;
    client_ptr_t entry;
};
struct init_thread_reply
{
    struct reply_header __header;
    int          suspend;
    char __pad_12[4];
};



struct terminate_process_request
{
    struct request_header __header;
    obj_handle_t handle;
    int          exit_code;
    char __pad_20[4];
};
struct terminate_process_reply
{
    struct reply_header __header;
    int          self;
    char __pad_12[4];
};



struct terminate_thread_request
{
    struct request_header __header;
    obj_handle_t handle;
    int          exit_code;
    char __pad_20[4];
};
struct terminate_thread_reply
{
    struct reply_header __header;
    int          self;
    char __pad_12[4];
};



struct get_process_info_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct get_process_info_reply
{
    struct reply_header __header;
    process_id_t pid;
    process_id_t ppid;
    affinity_t   affinity;
    client_ptr_t peb;
    timeout_t    start_time;
    timeout_t    end_time;
    unsigned int session_id;
    int          exit_code;
    unsigned short priority;
    unsigned short base_priority;
    unsigned short disable_boost;
    unsigned short machine;
    /* VARARG(image,pe_image_info); */
};



struct get_process_debug_info_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct get_process_debug_info_reply
{
    struct reply_header __header;
    obj_handle_t debug;
    int          debug_children;
    /* VARARG(image,pe_image_info); */
};



struct get_process_image_name_request
{
    struct request_header __header;
    obj_handle_t handle;
    process_id_t pid;
    int          win32;
};
struct get_process_image_name_reply
{
    struct reply_header __header;
    data_size_t  len;
    /* VARARG(name,unicode_str); */
    char __pad_12[4];
};



struct get_process_vm_counters_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct get_process_vm_counters_reply
{
    struct reply_header __header;
    mem_size_t peak_virtual_size;
    mem_size_t virtual_size;
    mem_size_t peak_working_set_size;
    mem_size_t working_set_size;
    mem_size_t pagefile_usage;
    mem_size_t peak_pagefile_usage;
};



struct set_process_info_request
{
    struct request_header __header;
    obj_handle_t handle;
    affinity_t   affinity;
    int          priority;
    int          base_priority;
    int          disable_boost;
    obj_handle_t token;
    int          mask;
    char __pad_44[4];
};
struct set_process_info_reply
{
    struct reply_header __header;
};
#define SET_PROCESS_INFO_PRIORITY      0x01
#define SET_PROCESS_INFO_BASE_PRIORITY 0x02
#define SET_PROCESS_INFO_DISABLE_BOOST 0x04
#define SET_PROCESS_INFO_AFFINITY      0x08
#define SET_PROCESS_INFO_TOKEN         0x10



struct get_thread_info_request
{
    struct request_header __header;
    obj_handle_t handle;
    unsigned int access;
    char __pad_20[4];
};
struct get_thread_info_reply
{
    struct reply_header __header;
    process_id_t pid;
    thread_id_t  tid;
    client_ptr_t teb;
    client_ptr_t entry_point;
    affinity_t   affinity;
    int          exit_code;
    int          priority;
    int          base_priority;
    int          suspend_count;
    unsigned int flags;
    data_size_t  desc_len;
    /* VARARG(desc,unicode_str); */
};
#define GET_THREAD_INFO_FLAG_DBG_HIDDEN    0x01
#define GET_THREAD_INFO_FLAG_TERMINATED    0x02
#define GET_THREAD_INFO_FLAG_LAST          0x04
#define GET_THREAD_INFO_FLAG_DISABLE_BOOST 0x08



struct get_thread_times_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct get_thread_times_reply
{
    struct reply_header __header;
    timeout_t    creation_time;
    timeout_t    exit_time;
    int          unix_pid;
    int          unix_tid;
};



struct set_thread_info_request
{
    struct request_header __header;
    obj_handle_t handle;
    int          priority;
    int          base_priority;
    affinity_t   affinity;
    client_ptr_t entry_point;
    obj_handle_t token;
    int          disable_boost;
    unsigned int mask;
    /* VARARG(desc,unicode_str); */
    char __pad_52[4];
};
struct set_thread_info_reply
{
    struct reply_header __header;
};
#define SET_THREAD_INFO_PRIORITY        0x01
#define SET_THREAD_INFO_BASE_PRIORITY   0x02
#define SET_THREAD_INFO_AFFINITY        0x04
#define SET_THREAD_INFO_TOKEN           0x08
#define SET_THREAD_INFO_ENTRYPOINT      0x10
#define SET_THREAD_INFO_DESCRIPTION     0x20
#define SET_THREAD_INFO_DBG_HIDDEN      0x40
#define SET_THREAD_INFO_DISABLE_BOOST   0x80



struct suspend_thread_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct suspend_thread_reply
{
    struct reply_header __header;
    int          count;
    char __pad_12[4];
};



struct resume_thread_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct resume_thread_reply
{
    struct reply_header __header;
    int          count;
    char __pad_12[4];
};



struct queue_apc_request
{
    struct request_header __header;
    obj_handle_t handle;
    obj_handle_t reserve_handle;
    /* VARARG(call,apc_call); */
    char __pad_20[4];
};
struct queue_apc_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    int          self;
};



struct get_apc_result_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct get_apc_result_reply
{
    struct reply_header __header;
    union apc_result result;
};



struct close_handle_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct close_handle_reply
{
    struct reply_header __header;
};



struct set_handle_info_request
{
    struct request_header __header;
    obj_handle_t handle;
    int          flags;
    int          mask;
};
struct set_handle_info_reply
{
    struct reply_header __header;
    int          old_flags;
    char __pad_12[4];
};



struct dup_handle_request
{
    struct request_header __header;
    obj_handle_t src_process;
    obj_handle_t src_handle;
    obj_handle_t dst_process;
    unsigned int access;
    unsigned int attributes;
    unsigned int options;
    char __pad_36[4];
};
struct dup_handle_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct allocate_reserve_object_request
{
    struct request_header __header;
    int type;
    /* VARARG(objattr,object_attributes); */
};
struct allocate_reserve_object_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct compare_objects_request
{
    struct request_header __header;
    obj_handle_t first;
    obj_handle_t second;
    char __pad_20[4];
};
struct compare_objects_reply
{
    struct reply_header __header;
};



struct set_object_permanence_request
{
    struct request_header __header;
    obj_handle_t handle;
    int          permanent;
    char __pad_20[4];
};
struct set_object_permanence_reply
{
    struct reply_header __header;
};



struct open_process_request
{
    struct request_header __header;
    process_id_t pid;
    unsigned int access;
    unsigned int attributes;
};
struct open_process_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct open_thread_request
{
    struct request_header __header;
    thread_id_t  tid;
    unsigned int access;
    unsigned int attributes;
};
struct open_thread_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct select_request
{
    struct request_header __header;
    int          flags;
    client_ptr_t cookie;
    abstime_t    timeout;
    data_size_t  size;
    obj_handle_t prev_apc;
    /* VARARG(result,apc_result); */
    /* VARARG(data,select_op,size); */
    /* VARARG(contexts,contexts); */
};
struct select_reply
{
    struct reply_header __header;
    obj_handle_t apc_handle;
    int          signaled;
    /* VARARG(call,apc_call); */
    /* VARARG(contexts,contexts); */
};
#define SELECT_ALERTABLE     1
#define SELECT_INTERRUPTIBLE 2



struct create_event_request
{
    struct request_header __header;
    unsigned int access;
    int          manual_reset;
    int          initial_state;
    /* VARARG(objattr,object_attributes); */
};
struct create_event_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};


struct event_op_request
{
    struct request_header __header;
    obj_handle_t  handle;
    int           op;
    char __pad_20[4];
};
struct event_op_reply
{
    struct reply_header __header;
    int           state;
    char __pad_12[4];
};
enum event_op { PULSE_EVENT, SET_EVENT, RESET_EVENT };

struct query_event_request
{
    struct request_header __header;
    obj_handle_t  handle;
};
struct query_event_reply
{
    struct reply_header __header;
    int          manual_reset;
    int          state;
};


struct open_event_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int attributes;
    obj_handle_t rootdir;
    /* VARARG(name,unicode_str); */
};
struct open_event_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct create_keyed_event_request
{
    struct request_header __header;
    unsigned int access;
    /* VARARG(objattr,object_attributes); */
};
struct create_keyed_event_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};


struct open_keyed_event_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int attributes;
    obj_handle_t rootdir;
    /* VARARG(name,unicode_str); */
};
struct open_keyed_event_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct create_mutex_request
{
    struct request_header __header;
    unsigned int access;
    int          owned;
    /* VARARG(objattr,object_attributes); */
    char __pad_20[4];
};
struct create_mutex_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct release_mutex_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct release_mutex_reply
{
    struct reply_header __header;
    unsigned int prev_count;
    char __pad_12[4];
};



struct open_mutex_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int attributes;
    obj_handle_t rootdir;
    /* VARARG(name,unicode_str); */
};
struct open_mutex_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct query_mutex_request
{
    struct request_header __header;
    obj_handle_t  handle;
};
struct query_mutex_reply
{
    struct reply_header __header;
    unsigned int count;
    int          owned;
    int          abandoned;
    char __pad_20[4];
};



struct create_semaphore_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int initial;
    unsigned int max;
    /* VARARG(objattr,object_attributes); */
};
struct create_semaphore_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct release_semaphore_request
{
    struct request_header __header;
    obj_handle_t handle;
    unsigned int count;
    char __pad_20[4];
};
struct release_semaphore_reply
{
    struct reply_header __header;
    unsigned int prev_count;
    char __pad_12[4];
};

struct query_semaphore_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct query_semaphore_reply
{
    struct reply_header __header;
    unsigned int current;
    unsigned int max;
};


struct open_semaphore_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int attributes;
    obj_handle_t rootdir;
    /* VARARG(name,unicode_str); */
};
struct open_semaphore_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct create_file_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int sharing;
    int          create;
    unsigned int options;
    unsigned int attrs;
    /* VARARG(objattr,object_attributes); */
    /* VARARG(filename,string); */
};
struct create_file_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct open_file_object_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int attributes;
    obj_handle_t rootdir;
    unsigned int sharing;
    unsigned int options;
    /* VARARG(filename,unicode_str); */
};
struct open_file_object_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct alloc_file_handle_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int attributes;
    int          fd;
};
struct alloc_file_handle_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct get_handle_unix_name_request
{
    struct request_header __header;
    obj_handle_t   handle;
};
struct get_handle_unix_name_reply
{
    struct reply_header __header;
    data_size_t    name_len;
    /* VARARG(name,string); */
    char __pad_12[4];
};



struct get_handle_fd_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct get_handle_fd_reply
{
    struct reply_header __header;
    int          type;
    int          cacheable;
    unsigned int access;
    unsigned int options;
};
enum server_fd_type
{
    FD_TYPE_INVALID,
    FD_TYPE_FILE,
    FD_TYPE_DIR,
    FD_TYPE_SOCKET,
    FD_TYPE_SERIAL,
    FD_TYPE_CHAR,
    FD_TYPE_DEVICE,
    FD_TYPE_NB_TYPES
};



struct get_directory_cache_entry_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct get_directory_cache_entry_reply
{
    struct reply_header __header;
    int          entry;
    /* VARARG(free,ints); */
    char __pad_12[4];
};



struct flush_request
{
    struct request_header __header;
    char __pad_12[4];
    struct async_data async;
};
struct flush_reply
{
    struct reply_header __header;
    obj_handle_t event;
    char __pad_12[4];
};


struct get_file_info_request
{
    struct request_header __header;
    obj_handle_t handle;
    unsigned int info_class;
    char __pad_20[4];
};
struct get_file_info_reply
{
    struct reply_header __header;
    /* VARARG(data,bytes); */
};


struct get_volume_info_request
{
    struct request_header __header;
    obj_handle_t handle;
    struct async_data async;
    unsigned int info_class;
    char __pad_60[4];
};
struct get_volume_info_reply
{
    struct reply_header __header;
    obj_handle_t wait;
    /* VARARG(data,bytes); */
    char __pad_12[4];
};


struct lock_file_request
{
    struct request_header __header;
    obj_handle_t handle;
    file_pos_t   offset;
    file_pos_t   count;
    int          shared;
    int          wait;
};
struct lock_file_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    int          overlapped;
};



struct unlock_file_request
{
    struct request_header __header;
    obj_handle_t handle;
    file_pos_t   offset;
    file_pos_t   count;
};
struct unlock_file_reply
{
    struct reply_header __header;
};



struct recv_socket_request
{
    struct request_header __header;
    int          oob;
    struct async_data async;
    int          force_async;
    char __pad_60[4];
};
struct recv_socket_reply
{
    struct reply_header __header;
    obj_handle_t wait;
    unsigned int options;
    int          nonblocking;
    char __pad_20[4];
};



struct send_socket_request
{
    struct request_header __header;
    unsigned int flags;
    struct async_data async;
};
struct send_socket_reply
{
    struct reply_header __header;
    obj_handle_t wait;
    unsigned int options;
    int          nonblocking;
    char __pad_20[4];
};

#define SERVER_SOCKET_IO_FORCE_ASYNC 0x01
#define SERVER_SOCKET_IO_SYSTEM      0x02


struct socket_get_events_request
{
    struct request_header __header;
    obj_handle_t handle;
    obj_handle_t event;
    char __pad_20[4];
};
struct socket_get_events_reply
{
    struct reply_header __header;
    unsigned int flags;
    /* VARARG(status,uints); */
    char __pad_12[4];
};



struct socket_send_icmp_id_request
{
    struct request_header __header;
    obj_handle_t   handle;
    unsigned short icmp_id;
    unsigned short icmp_seq;
    char __pad_20[4];
};
struct socket_send_icmp_id_reply
{
    struct reply_header __header;
};



struct socket_get_icmp_id_request
{
    struct request_header __header;
    obj_handle_t   handle;
    unsigned short icmp_seq;
    char __pad_18[6];
};
struct socket_get_icmp_id_reply
{
    struct reply_header __header;
    unsigned short icmp_id;
    char __pad_10[6];
};



struct get_next_console_request_request
{
    struct request_header __header;
    obj_handle_t handle;
    int          signal;
    int          read;
    unsigned int status;
    /* VARARG(out_data,bytes); */
    char __pad_28[4];
};
struct get_next_console_request_reply
{
    struct reply_header __header;
    unsigned int code;
    unsigned int output;
    data_size_t  out_size;
    /* VARARG(in_data,bytes); */
    char __pad_20[4];
};



struct read_directory_changes_request
{
    struct request_header __header;
    unsigned int filter;
    int          subtree;
    int          want_data;
    struct async_data async;
};
struct read_directory_changes_reply
{
    struct reply_header __header;
};


struct read_change_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct read_change_reply
{
    struct reply_header __header;
    /* VARARG(events,filesystem_event); */
};



struct create_mapping_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int flags;
    unsigned int file_access;
    mem_size_t   size;
    obj_handle_t file_handle;
    /* VARARG(objattr,object_attributes); */
    char __pad_36[4];
};
struct create_mapping_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct open_mapping_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int attributes;
    obj_handle_t rootdir;
    /* VARARG(name,unicode_str); */
};
struct open_mapping_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct get_mapping_info_request
{
    struct request_header __header;
    obj_handle_t handle;
    unsigned int access;
    char __pad_20[4];
};
struct get_mapping_info_reply
{
    struct reply_header __header;
    mem_size_t   size;
    unsigned int flags;
    obj_handle_t shared_file;
    data_size_t  name_len;
    data_size_t  total;
    /* VARARG(image,pe_image_info); */
    /* VARARG(name,unicode_str,name_len); */
    /* VARARG(exp_name,string); */
};



struct get_image_map_address_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct get_image_map_address_reply
{
    struct reply_header __header;
    client_ptr_t addr;
};



struct map_view_request
{
    struct request_header __header;
    obj_handle_t mapping;
    unsigned int access;
    char __pad_20[4];
    client_ptr_t base;
    mem_size_t   size;
    file_pos_t   start;
};
struct map_view_reply
{
    struct reply_header __header;
};



struct map_image_view_request
{
    struct request_header __header;
    obj_handle_t mapping;
    client_ptr_t base;
    mem_size_t   size;
    mem_size_t   offset;
    unsigned int entry;
    unsigned short machine;
    char __pad_46[2];
};
struct map_image_view_reply
{
    struct reply_header __header;
};



struct map_builtin_view_request
{
    struct request_header __header;
    /* VARARG(image,pe_image_info); */
    /* VARARG(name,unicode_str); */
    char __pad_12[4];
};
struct map_builtin_view_reply
{
    struct reply_header __header;
};



struct get_image_view_info_request
{
    struct request_header __header;
    obj_handle_t process;
    client_ptr_t addr;
};
struct get_image_view_info_reply
{
    struct reply_header __header;
    client_ptr_t base;
    mem_size_t   size;
};



struct unmap_view_request
{
    struct request_header __header;
    char __pad_12[4];
    client_ptr_t base;
};
struct unmap_view_reply
{
    struct reply_header __header;
};



struct get_mapping_committed_range_request
{
    struct request_header __header;
    char __pad_12[4];
    client_ptr_t base;
    file_pos_t   offset;
};
struct get_mapping_committed_range_reply
{
    struct reply_header __header;
    mem_size_t   size;
    int          committed;
    char __pad_20[4];
};



struct add_mapping_committed_range_request
{
    struct request_header __header;
    char __pad_12[4];
    client_ptr_t base;
    file_pos_t   offset;
    mem_size_t   size;
};
struct add_mapping_committed_range_reply
{
    struct reply_header __header;
};



struct is_same_mapping_request
{
    struct request_header __header;
    char __pad_12[4];
    client_ptr_t base1;
    client_ptr_t base2;
};
struct is_same_mapping_reply
{
    struct reply_header __header;
};



struct get_mapping_filename_request
{
    struct request_header __header;
    obj_handle_t process;
    client_ptr_t addr;
};
struct get_mapping_filename_reply
{
    struct reply_header __header;
    data_size_t  len;
    /* VARARG(filename,unicode_str); */
    char __pad_12[4];
};


struct thread_info
{
    timeout_t       start_time;
    thread_id_t     tid;
    int             base_priority;
    int             current_priority;
    int             unix_tid;
    client_ptr_t    teb;
    client_ptr_t    entry_point;
};

struct process_info
{
    timeout_t       start_time;
    data_size_t     name_len;
    int             thread_count;
    int             priority;
    process_id_t    pid;
    process_id_t    parent_pid;
    unsigned int    session_id;
    int             handle_count;
    int             unix_pid;


};


struct list_processes_request
{
    struct request_header __header;
    char __pad_12[4];
};
struct list_processes_reply
{
    struct reply_header __header;
    data_size_t     info_size;
    int             process_count;
    int             total_thread_count;
    data_size_t     total_name_len;
    /* VARARG(data,process_info,info_size); */
};



struct create_debug_obj_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int flags;
    /* VARARG(objattr,object_attributes); */
    char __pad_20[4];
};
struct create_debug_obj_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct wait_debug_event_request
{
    struct request_header __header;
    obj_handle_t debug;
};
struct wait_debug_event_reply
{
    struct reply_header __header;
    process_id_t  pid;
    thread_id_t   tid;
    /* VARARG(event,debug_event); */
};



struct queue_exception_event_request
{
    struct request_header __header;
    int           first;
    unsigned int  code;
    unsigned int  flags;
    client_ptr_t  record;
    client_ptr_t  address;
    data_size_t   len;
    /* VARARG(params,uints64,len); */
    char __pad_44[4];
};
struct queue_exception_event_reply
{
    struct reply_header __header;
    obj_handle_t     handle;
    char __pad_12[4];
};



struct get_exception_status_request
{
    struct request_header __header;
    obj_handle_t     handle;
};
struct get_exception_status_reply
{
    struct reply_header __header;
};



struct continue_debug_event_request
{
    struct request_header __header;
    obj_handle_t debug;
    process_id_t pid;
    thread_id_t  tid;
    unsigned int status;
    char __pad_28[4];
};
struct continue_debug_event_reply
{
    struct reply_header __header;
};



struct debug_process_request
{
    struct request_header __header;
    obj_handle_t handle;
    obj_handle_t debug;
    int          attach;
};
struct debug_process_reply
{
    struct reply_header __header;
};



struct set_debug_obj_info_request
{
    struct request_header __header;
    obj_handle_t debug;
    unsigned int flags;
    char __pad_20[4];
};
struct set_debug_obj_info_reply
{
    struct reply_header __header;
};



struct read_process_memory_request
{
    struct request_header __header;
    obj_handle_t handle;
    client_ptr_t addr;
};
struct read_process_memory_reply
{
    struct reply_header __header;
    /* VARARG(data,bytes); */
};



struct write_process_memory_request
{
    struct request_header __header;
    obj_handle_t handle;
    client_ptr_t addr;
    /* VARARG(data,bytes); */
};
struct write_process_memory_reply
{
    struct reply_header __header;
    data_size_t written;
    char __pad_12[4];
};



struct create_key_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int options;
    /* VARARG(objattr,object_attributes); */
    /* VARARG(class,unicode_str); */
    char __pad_20[4];
};
struct create_key_reply
{
    struct reply_header __header;
    obj_handle_t hkey;
    char __pad_12[4];
};


struct open_key_request
{
    struct request_header __header;
    obj_handle_t parent;
    unsigned int access;
    unsigned int attributes;
    /* VARARG(name,unicode_str); */
};
struct open_key_reply
{
    struct reply_header __header;
    obj_handle_t hkey;
    char __pad_12[4];
};



struct delete_key_request
{
    struct request_header __header;
    obj_handle_t hkey;
};
struct delete_key_reply
{
    struct reply_header __header;
};



struct flush_key_request
{
    struct request_header __header;
    obj_handle_t hkey;
};
struct flush_key_reply
{
    struct reply_header __header;
};



struct enum_key_request
{
    struct request_header __header;
    obj_handle_t hkey;
    int          index;
    int          info_class;
};
struct enum_key_reply
{
    struct reply_header __header;
    int          subkeys;
    int          max_subkey;
    int          max_class;
    int          values;
    int          max_value;
    int          max_data;
    timeout_t    modif;
    data_size_t  total;
    data_size_t  namelen;
    /* VARARG(name,unicode_str,namelen); */
    /* VARARG(class,unicode_str); */
};



struct set_key_value_request
{
    struct request_header __header;
    obj_handle_t hkey;
    int          type;
    data_size_t  namelen;
    /* VARARG(name,unicode_str,namelen); */
    /* VARARG(data,bytes); */
};
struct set_key_value_reply
{
    struct reply_header __header;
};



struct get_key_value_request
{
    struct request_header __header;
    obj_handle_t hkey;
    /* VARARG(name,unicode_str); */
};
struct get_key_value_reply
{
    struct reply_header __header;
    int          type;
    data_size_t  total;
    /* VARARG(data,bytes); */
};



struct enum_key_value_request
{
    struct request_header __header;
    obj_handle_t hkey;
    int          index;
    int          info_class;
};
struct enum_key_value_reply
{
    struct reply_header __header;
    int          type;
    data_size_t  total;
    data_size_t  namelen;
    /* VARARG(name,unicode_str,namelen); */
    /* VARARG(data,bytes); */
    char __pad_20[4];
};



struct delete_key_value_request
{
    struct request_header __header;
    obj_handle_t hkey;
    /* VARARG(name,unicode_str); */
};
struct delete_key_value_reply
{
    struct reply_header __header;
};



struct load_registry_request
{
    struct request_header __header;
    obj_handle_t file;
    /* VARARG(objattr,object_attributes); */
};
struct load_registry_reply
{
    struct reply_header __header;
};



struct unload_registry_request
{
    struct request_header __header;
    obj_handle_t parent;
    unsigned int attributes;
    /* VARARG(name,unicode_str); */
    char __pad_20[4];
};
struct unload_registry_reply
{
    struct reply_header __header;
};



struct save_registry_request
{
    struct request_header __header;
    obj_handle_t hkey;
    obj_handle_t file;
    char __pad_20[4];
};
struct save_registry_reply
{
    struct reply_header __header;
};



struct set_registry_notification_request
{
    struct request_header __header;
    obj_handle_t hkey;
    obj_handle_t event;
    int          subtree;
    unsigned int filter;
    char __pad_28[4];
};
struct set_registry_notification_reply
{
    struct reply_header __header;
};



struct rename_key_request
{
    struct request_header __header;
    obj_handle_t hkey;
    /* VARARG(name,unicode_str); */
};
struct rename_key_reply
{
    struct reply_header __header;
};



struct create_timer_request
{
    struct request_header __header;
    unsigned int access;
    int          manual;
    /* VARARG(objattr,object_attributes); */
    char __pad_20[4];
};
struct create_timer_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct open_timer_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int attributes;
    obj_handle_t rootdir;
    /* VARARG(name,unicode_str); */
};
struct open_timer_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};


struct set_timer_request
{
    struct request_header __header;
    obj_handle_t handle;
    timeout_t    expire;
    client_ptr_t callback;
    client_ptr_t arg;
    int          period;
    char __pad_44[4];
};
struct set_timer_reply
{
    struct reply_header __header;
    int          signaled;
    char __pad_12[4];
};


struct cancel_timer_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct cancel_timer_reply
{
    struct reply_header __header;
     int         signaled;
    char __pad_12[4];
};


struct get_timer_info_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct get_timer_info_reply
{
    struct reply_header __header;
    timeout_t    when;
    int          signaled;
    char __pad_20[4];
};



struct get_thread_context_request
{
    struct request_header __header;
    obj_handle_t handle;
    obj_handle_t context;
    unsigned int flags;
    unsigned int native_flags;
    unsigned short machine;
    char __pad_30[2];
};
struct get_thread_context_reply
{
    struct reply_header __header;
    int          self;
    obj_handle_t handle;
    /* VARARG(contexts,contexts); */
};



struct set_thread_context_request
{
    struct request_header __header;
    obj_handle_t handle;
    unsigned int native_flags;
    /* VARARG(contexts,contexts); */
    char __pad_20[4];
};
struct set_thread_context_reply
{
    struct reply_header __header;
    int          self;
    char __pad_12[4];
};



struct add_atom_request
{
    struct request_header __header;
    /* VARARG(name,unicode_str); */
    char __pad_12[4];
};
struct add_atom_reply
{
    struct reply_header __header;
    atom_t        atom;
    char __pad_12[4];
};



struct delete_atom_request
{
    struct request_header __header;
    atom_t        atom;
};
struct delete_atom_reply
{
    struct reply_header __header;
};



struct find_atom_request
{
    struct request_header __header;
    /* VARARG(name,unicode_str); */
    char __pad_12[4];
};
struct find_atom_reply
{
    struct reply_header __header;
    atom_t       atom;
    char __pad_12[4];
};



struct get_atom_information_request
{
    struct request_header __header;
    atom_t       atom;
};
struct get_atom_information_reply
{
    struct reply_header __header;
    int          count;
    int          pinned;
    data_size_t  total;
    /* VARARG(name,unicode_str); */
    char __pad_20[4];
};



struct add_user_atom_request
{
    struct request_header __header;
    /* VARARG(name,unicode_str); */
    char __pad_12[4];
};
struct add_user_atom_reply
{
    struct reply_header __header;
    atom_t        atom;
    char __pad_12[4];
};



struct get_user_atom_name_request
{
    struct request_header __header;
    atom_t       atom;
};
struct get_user_atom_name_reply
{
    struct reply_header __header;
    data_size_t  total;
    /* VARARG(name,unicode_str); */
    char __pad_12[4];
};



struct get_msg_queue_handle_request
{
    struct request_header __header;
    char __pad_12[4];
};
struct get_msg_queue_handle_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    obj_handle_t idle_event;
};



struct get_msg_queue_request
{
    struct request_header __header;
    char __pad_12[4];
};
struct get_msg_queue_reply
{
    struct reply_header __header;
    struct obj_locator locator;
};



struct set_queue_fd_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct set_queue_fd_reply
{
    struct reply_header __header;
};



struct set_queue_mask_request
{
    struct request_header __header;
    unsigned int wake_mask;
    unsigned int changed_mask;
    int          poll_events;
};
struct set_queue_mask_reply
{
    struct reply_header __header;
    unsigned int wake_bits;
    unsigned int changed_bits;
};



struct get_queue_status_request
{
    struct request_header __header;
    unsigned int clear_bits;
};
struct get_queue_status_reply
{
    struct reply_header __header;
    unsigned int wake_bits;
    unsigned int changed_bits;
};



struct get_process_idle_event_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct get_process_idle_event_reply
{
    struct reply_header __header;
    obj_handle_t event;
    char __pad_12[4];
};



struct send_message_request
{
    struct request_header __header;
    thread_id_t     id;
    int             type;
    int             flags;
    user_handle_t   win;
    unsigned int    msg;
    lparam_t        wparam;
    lparam_t        lparam;
    timeout_t       timeout;
    /* VARARG(data,message_data); */
};
struct send_message_reply
{
    struct reply_header __header;
};

struct post_quit_message_request
{
    struct request_header __header;
    int             exit_code;
};
struct post_quit_message_reply
{
    struct reply_header __header;
};

enum message_type
{
    MSG_ASCII,
    MSG_UNICODE,
    MSG_NOTIFY,
    MSG_CALLBACK,
    MSG_CALLBACK_RESULT,
    MSG_OTHER_PROCESS,
    MSG_POSTED,
    MSG_HARDWARE,
    MSG_WINEVENT,
    MSG_HOOK_LL
};
#define SEND_MSG_ABORT_IF_HUNG  0x01



struct send_hardware_message_request
{
    struct request_header __header;
    user_handle_t   win;
    union hw_input  input;
    unsigned int    flags;
    /* VARARG(report,bytes); */
    char __pad_60[4];
};
struct send_hardware_message_reply
{
    struct reply_header __header;
    int             wait;
    int             prev_x;
    int             prev_y;
    int             new_x;
    int             new_y;
    char __pad_28[4];
};
#define SEND_HWMSG_INJECTED    0x01



struct get_message_request
{
    struct request_header __header;
    unsigned int    flags;
    user_handle_t   get_win;
    unsigned int    get_first;
    unsigned int    get_last;
    unsigned int    hw_id;
    unsigned int    wake_mask;
    unsigned int    changed_mask;
    unsigned int    internal;
    char __pad_44[4];
};
struct get_message_reply
{
    struct reply_header __header;
    user_handle_t   win;
    unsigned int    msg;
    lparam_t        wparam;
    lparam_t        lparam;
    int             type;
    int             x;
    int             y;
    unsigned int    time;
    data_size_t     total;
    /* VARARG(data,message_data); */
    char __pad_52[4];
};



struct reply_message_request
{
    struct request_header __header;
    int             remove;
    lparam_t        result;
    /* VARARG(data,bytes); */
};
struct reply_message_reply
{
    struct reply_header __header;
};



struct accept_hardware_message_request
{
    struct request_header __header;
    unsigned int    hw_id;
};
struct accept_hardware_message_reply
{
    struct reply_header __header;
};



struct get_message_reply_request
{
    struct request_header __header;
    int             cancel;
};
struct get_message_reply_reply
{
    struct reply_header __header;
    lparam_t        result;
    /* VARARG(data,bytes); */
};



struct set_win_timer_request
{
    struct request_header __header;
    user_handle_t   win;
    unsigned int    msg;
    unsigned int    rate;
    lparam_t        id;
    lparam_t        lparam;
};
struct set_win_timer_reply
{
    struct reply_header __header;
    lparam_t        id;
};



struct kill_win_timer_request
{
    struct request_header __header;
    user_handle_t   win;
    lparam_t        id;
    unsigned int    msg;
    char __pad_28[4];
};
struct kill_win_timer_reply
{
    struct reply_header __header;
};



struct is_window_hung_request
{
    struct request_header __header;
    user_handle_t   win;
};
struct is_window_hung_reply
{
    struct reply_header __header;
    int is_hung;
    char __pad_12[4];
};



struct get_serial_info_request
{
    struct request_header __header;
    obj_handle_t handle;
    int          flags;
    char __pad_20[4];
};
struct get_serial_info_reply
{
    struct reply_header __header;
    unsigned int eventmask;
    unsigned int pending_write;
};



struct set_serial_info_request
{
    struct request_header __header;
    obj_handle_t handle;
    int          flags;
    char __pad_20[4];
};
struct set_serial_info_reply
{
    struct reply_header __header;
};
#define SERIALINFO_PENDING_WRITE 0x04


struct cancel_sync_request
{
    struct request_header __header;
    obj_handle_t handle;
    client_ptr_t iosb;
};
struct cancel_sync_reply
{
    struct reply_header __header;
};


struct register_async_request
{
    struct request_header __header;
    int          type;
    struct async_data async;
    int          count;
    char __pad_60[4];
};
struct register_async_reply
{
    struct reply_header __header;
};
#define ASYNC_TYPE_READ  0x01
#define ASYNC_TYPE_WRITE 0x02
#define ASYNC_TYPE_WAIT  0x03



struct cancel_async_request
{
    struct request_header __header;
    obj_handle_t handle;
    client_ptr_t iosb;
    int          only_thread;
    char __pad_28[4];
};
struct cancel_async_reply
{
    struct reply_header __header;
    obj_handle_t cancel_handle;
    char __pad_12[4];
};



struct get_async_result_request
{
    struct request_header __header;
    char __pad_12[4];
    client_ptr_t   user_arg;
};
struct get_async_result_reply
{
    struct reply_header __header;
    /* VARARG(out_data,bytes); */
};



struct set_async_direct_result_request
{
    struct request_header __header;
    obj_handle_t   handle;
    apc_param_t    information;
    unsigned int   status;
    int            mark_pending;
};
struct set_async_direct_result_reply
{
    struct reply_header __header;
    obj_handle_t   handle;
    char __pad_12[4];
};



struct read_request
{
    struct request_header __header;
    char __pad_12[4];
    struct async_data async;
    file_pos_t     pos;
};
struct read_reply
{
    struct reply_header __header;
    obj_handle_t   wait;
    unsigned int   options;
    /* VARARG(data,bytes); */
};



struct write_request
{
    struct request_header __header;
    char __pad_12[4];
    struct async_data async;
    file_pos_t     pos;
    /* VARARG(data,bytes); */
};
struct write_reply
{
    struct reply_header __header;
    obj_handle_t   wait;
    unsigned int   options;
    data_size_t    size;
    char __pad_20[4];
};



struct ioctl_request
{
    struct request_header __header;
    ioctl_code_t   code;
    struct async_data async;
    /* VARARG(in_data,bytes); */
};
struct ioctl_reply
{
    struct reply_header __header;
    obj_handle_t   wait;
    unsigned int   options;
    /* VARARG(out_data,bytes); */
};



struct set_irp_result_request
{
    struct request_header __header;
    obj_handle_t handle;
    unsigned int status;
    data_size_t  size;
    /* VARARG(data,bytes); */
};
struct set_irp_result_reply
{
    struct reply_header __header;
};



struct create_named_pipe_request
{
    struct request_header __header;
    unsigned int   access;
    unsigned int   options;
    unsigned int   sharing;
    unsigned int   disposition;
    unsigned int   maxinstances;
    unsigned int   outsize;
    unsigned int   insize;
    timeout_t      timeout;
    unsigned int   flags;
    /* VARARG(objattr,object_attributes); */
    char __pad_52[4];
};
struct create_named_pipe_reply
{
    struct reply_header __header;
    obj_handle_t   handle;
    int            created;
};


#define NAMED_PIPE_MESSAGE_STREAM_WRITE 0x0001
#define NAMED_PIPE_MESSAGE_STREAM_READ  0x0002
#define NAMED_PIPE_NONBLOCKING_MODE     0x0004
#define NAMED_PIPE_SERVER_END           0x8000


struct set_named_pipe_info_request
{
    struct request_header __header;
    obj_handle_t   handle;
    unsigned int   flags;
    char __pad_20[4];
};
struct set_named_pipe_info_reply
{
    struct reply_header __header;
};


struct create_window_request
{
    struct request_header __header;
    user_handle_t  parent;
    user_handle_t  owner;
    atom_t         atom;
    mod_handle_t   class_instance;
    mod_handle_t   instance;
    unsigned int   dpi_context;
    unsigned int   style;
    unsigned int   ex_style;
    /* VARARG(class,unicode_str); */
    char __pad_52[4];
};
struct create_window_reply
{
    struct reply_header __header;
    user_handle_t  handle;
    user_handle_t  parent;
    user_handle_t  owner;
    int            extra;
    client_ptr_t   class_ptr;
};



struct destroy_window_request
{
    struct request_header __header;
    user_handle_t  handle;
};
struct destroy_window_reply
{
    struct reply_header __header;
};



struct get_desktop_window_request
{
    struct request_header __header;
    int            force;
};
struct get_desktop_window_reply
{
    struct reply_header __header;
    user_handle_t  top_window;
    user_handle_t  msg_window;
};



struct set_window_owner_request
{
    struct request_header __header;
    user_handle_t  handle;
    user_handle_t  owner;
    char __pad_20[4];
};
struct set_window_owner_reply
{
    struct reply_header __header;
    user_handle_t  full_owner;
    user_handle_t  prev_owner;
};



struct get_window_info_request
{
    struct request_header __header;
    user_handle_t  handle;
    int            offset;
    data_size_t    size;
};
struct get_window_info_reply
{
    struct reply_header __header;
    user_handle_t  last_active;
    int            is_unicode;
    lparam_t       info;
};



struct init_window_info_request
{
    struct request_header __header;
    user_handle_t  handle;
    unsigned int   style;
    unsigned int   ex_style;
    short int      is_unicode;
    char __pad_26[6];
};
struct init_window_info_reply
{
    struct reply_header __header;
};



struct set_window_info_request
{
    struct request_header __header;
    user_handle_t  handle;
    int            offset;
    data_size_t    size;
    lparam_t       new_info;
};
struct set_window_info_reply
{
    struct reply_header __header;
    lparam_t       old_info;
};



struct set_parent_request
{
    struct request_header __header;
    user_handle_t  handle;
    user_handle_t  parent;
    char __pad_20[4];
};
struct set_parent_reply
{
    struct reply_header __header;
    user_handle_t  old_parent;
    user_handle_t  full_parent;
};



struct get_window_parents_request
{
    struct request_header __header;
    user_handle_t  handle;
};
struct get_window_parents_reply
{
    struct reply_header __header;
    int            count;
    /* VARARG(parents,user_handles); */
    char __pad_12[4];
};



struct get_window_list_request
{
    struct request_header __header;
    obj_handle_t   desktop;
    user_handle_t  handle;
    thread_id_t    tid;
    int            children;
    char __pad_28[4];
};
struct get_window_list_reply
{
    struct reply_header __header;
    int            count;
    /* VARARG(windows,user_handles); */
    char __pad_12[4];
};



struct get_class_windows_request
{
    struct request_header __header;
    user_handle_t  parent;
    user_handle_t  child;
    atom_t         atom;
    /* VARARG(class,unicode_str); */
};
struct get_class_windows_reply
{
    struct reply_header __header;
    int            count;
    /* VARARG(children,user_handles); */
    char __pad_12[4];
};



struct get_window_children_from_point_request
{
    struct request_header __header;
    user_handle_t  parent;
    int            x;
    int            y;
    int            dpi;
    char __pad_28[4];
};
struct get_window_children_from_point_reply
{
    struct reply_header __header;
    int            count;
    /* VARARG(children,user_handles); */
    char __pad_12[4];
};



struct get_window_tree_request
{
    struct request_header __header;
    user_handle_t  handle;
};
struct get_window_tree_reply
{
    struct reply_header __header;
    user_handle_t  parent;
    user_handle_t  owner;
    user_handle_t  next_sibling;
    user_handle_t  prev_sibling;
    user_handle_t  first_sibling;
    user_handle_t  last_sibling;
    user_handle_t  first_child;
    user_handle_t  last_child;
};


struct set_window_pos_request
{
    struct request_header __header;
    unsigned short swp_flags;
    unsigned short paint_flags;
    unsigned int   monitor_dpi;
    user_handle_t  handle;
    user_handle_t  previous;
    struct rectangle window;
    struct rectangle client;
    /* VARARG(valid,rectangles); */
    char __pad_60[4];
};
struct set_window_pos_reply
{
    struct reply_header __header;
    unsigned int   new_style;
    unsigned int   new_ex_style;
    user_handle_t  surface_win;
    char __pad_20[4];
};
#define SET_WINPOS_PAINT_SURFACE    0x01
#define SET_WINPOS_PIXEL_FORMAT     0x02
#define SET_WINPOS_LAYERED_WINDOW   0x04


struct get_window_rectangles_request
{
    struct request_header __header;
    user_handle_t  handle;
    int            relative;
    int            dpi;
};
struct get_window_rectangles_reply
{
    struct reply_header __header;
    struct rectangle window;
    struct rectangle client;
};
enum coords_relative
{
    COORDS_CLIENT,
    COORDS_WINDOW,
    COORDS_PARENT,
    COORDS_SCREEN
};



struct get_window_text_request
{
    struct request_header __header;
    user_handle_t  handle;
};
struct get_window_text_reply
{
    struct reply_header __header;
    data_size_t    length;
    /* VARARG(text,unicode_str); */
    char __pad_12[4];
};



struct set_window_text_request
{
    struct request_header __header;
    user_handle_t  handle;
    /* VARARG(text,unicode_str); */
};
struct set_window_text_reply
{
    struct reply_header __header;
};



struct get_windows_offset_request
{
    struct request_header __header;
    user_handle_t  from;
    user_handle_t  to;
    int            dpi;
};
struct get_windows_offset_reply
{
    struct reply_header __header;
    int            x;
    int            y;
    int            mirror;
    char __pad_20[4];
};



struct get_visible_region_request
{
    struct request_header __header;
    user_handle_t  window;
    unsigned int   flags;
    char __pad_20[4];
};
struct get_visible_region_reply
{
    struct reply_header __header;
    user_handle_t  top_win;
    struct rectangle top_rect;
    struct rectangle win_rect;
    unsigned int   paint_flags;
    data_size_t    total_size;
    /* VARARG(region,rectangles); */
    char __pad_52[4];
};



struct get_window_region_request
{
    struct request_header __header;
    user_handle_t  window;
    int            surface;
    char __pad_20[4];
};
struct get_window_region_reply
{
    struct reply_header __header;
    struct rectangle visible_rect;
    data_size_t    total_size;
    /* VARARG(region,rectangles); */
    char __pad_28[4];
};



struct set_window_region_request
{
    struct request_header __header;
    user_handle_t  window;
    int            redraw;
    /* VARARG(region,rectangles); */
    char __pad_20[4];
};
struct set_window_region_reply
{
    struct reply_header __header;
};



struct get_update_region_request
{
    struct request_header __header;
    user_handle_t  window;
    user_handle_t  from_child;
    unsigned int   flags;
};
struct get_update_region_reply
{
    struct reply_header __header;
    user_handle_t  child;
    unsigned int   flags;
    data_size_t    total_size;
    /* VARARG(region,rectangles); */
    char __pad_20[4];
};
#define UPDATE_NONCLIENT       0x001
#define UPDATE_ERASE           0x002
#define UPDATE_PAINT           0x004
#define UPDATE_INTERNALPAINT   0x008
#define UPDATE_ALLCHILDREN     0x010
#define UPDATE_NOCHILDREN      0x020
#define UPDATE_NOREGION        0x040
#define UPDATE_DELAYED_ERASE   0x080
#define UPDATE_CLIPCHILDREN    0x100



struct update_window_zorder_request
{
    struct request_header __header;
    user_handle_t  window;
    struct rectangle rect;
};
struct update_window_zorder_reply
{
    struct reply_header __header;
};



struct redraw_window_request
{
    struct request_header __header;
    user_handle_t  window;
    unsigned int   flags;
    /* VARARG(region,rectangles); */
    char __pad_20[4];
};
struct redraw_window_reply
{
    struct reply_header __header;
};



struct set_window_property_request
{
    struct request_header __header;
    user_handle_t  window;
    lparam_t       data;
    atom_t         atom;
    /* VARARG(name,unicode_str); */
    char __pad_28[4];
};
struct set_window_property_reply
{
    struct reply_header __header;
};



struct remove_window_property_request
{
    struct request_header __header;
    user_handle_t  window;
    atom_t         atom;
    /* VARARG(name,unicode_str); */
    char __pad_20[4];
};
struct remove_window_property_reply
{
    struct reply_header __header;
    lparam_t       data;
};



struct get_window_property_request
{
    struct request_header __header;
    user_handle_t  window;
    atom_t         atom;
    /* VARARG(name,unicode_str); */
    char __pad_20[4];
};
struct get_window_property_reply
{
    struct reply_header __header;
    lparam_t       data;
};



struct get_window_properties_request
{
    struct request_header __header;
    user_handle_t  window;
};
struct get_window_properties_reply
{
    struct reply_header __header;
    int            total;
    /* VARARG(props,properties); */
    char __pad_12[4];
};



struct create_winstation_request
{
    struct request_header __header;
    unsigned int flags;
    unsigned int access;
    unsigned int attributes;
    obj_handle_t rootdir;
    /* VARARG(name,unicode_str); */
    char __pad_28[4];
};
struct create_winstation_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct open_winstation_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int attributes;
    obj_handle_t rootdir;
    /* VARARG(name,unicode_str); */
};
struct open_winstation_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct close_winstation_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct close_winstation_reply
{
    struct reply_header __header;
};



struct set_winstation_monitors_request
{
    struct request_header __header;
    int              increment;
    /* VARARG(infos,monitor_infos); */
};
struct set_winstation_monitors_reply
{
    struct reply_header __header;
    unsigned __int64 serial;
};



struct get_process_winstation_request
{
    struct request_header __header;
    char __pad_12[4];
};
struct get_process_winstation_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct set_process_winstation_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct set_process_winstation_reply
{
    struct reply_header __header;
};



struct enum_winstation_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct enum_winstation_reply
{
    struct reply_header __header;
    data_size_t count;
    data_size_t total;
    /* VARARG(names,unicode_strings); */
};



struct create_desktop_request
{
    struct request_header __header;
    unsigned int flags;
    unsigned int access;
    unsigned int attributes;
    /* VARARG(name,unicode_str); */
};
struct create_desktop_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct open_desktop_request
{
    struct request_header __header;
    obj_handle_t winsta;
    unsigned int flags;
    unsigned int access;
    unsigned int attributes;
    /* VARARG(name,unicode_str); */
    char __pad_28[4];
};
struct open_desktop_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct open_input_desktop_request
{
    struct request_header __header;
    unsigned int flags;
    unsigned int access;
    unsigned int attributes;
};
struct open_input_desktop_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct set_input_desktop_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct set_input_desktop_reply
{
    struct reply_header __header;
};



struct close_desktop_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct close_desktop_reply
{
    struct reply_header __header;
};



struct get_thread_desktop_request
{
    struct request_header __header;
    thread_id_t  tid;
};
struct get_thread_desktop_reply
{
    struct reply_header __header;
    struct obj_locator locator;
    obj_handle_t   handle;
    char __pad_28[4];
};



struct set_thread_desktop_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct set_thread_desktop_reply
{
    struct reply_header __header;
    struct obj_locator locator;
};



struct set_user_object_info_request
{
    struct request_header __header;
    obj_handle_t handle;
    unsigned int flags;
    unsigned int obj_flags;
};
struct set_user_object_info_reply
{
    struct reply_header __header;
    int          is_desktop;
    unsigned int old_obj_flags;
    /* VARARG(name,unicode_str); */
};
#define SET_USER_OBJECT_SET_FLAGS       1
#define SET_USER_OBJECT_GET_FULL_NAME   2



struct register_hotkey_request
{
    struct request_header __header;
    user_handle_t  window;
    int            id;
    unsigned int   flags;
    unsigned int   vkey;
    char __pad_28[4];
};
struct register_hotkey_reply
{
    struct reply_header __header;
    int            replaced;
    unsigned int   flags;
    unsigned int   vkey;
    char __pad_20[4];
};



struct unregister_hotkey_request
{
    struct request_header __header;
    user_handle_t  window;
    int            id;
    char __pad_20[4];
};
struct unregister_hotkey_reply
{
    struct reply_header __header;
    unsigned int   flags;
    unsigned int   vkey;
};



struct attach_thread_input_request
{
    struct request_header __header;
    thread_id_t    tid_from;
    thread_id_t    tid_to;
    int            attach;
};
struct attach_thread_input_reply
{
    struct reply_header __header;
};



struct get_thread_input_request
{
    struct request_header __header;
    thread_id_t    tid;
};
struct get_thread_input_reply
{
    struct reply_header __header;
    struct obj_locator locator;
};



struct get_last_input_time_request
{
    struct request_header __header;
    char __pad_12[4];
};
struct get_last_input_time_reply
{
    struct reply_header __header;
    unsigned int time;
    char __pad_12[4];
};



struct get_key_state_request
{
    struct request_header __header;
    int            async;
    int            key;
    char __pad_20[4];
};
struct get_key_state_reply
{
    struct reply_header __header;
    unsigned char  state;
    char __pad_9[7];
};


struct set_key_state_request
{
    struct request_header __header;
    int            async;
    /* VARARG(keystate,bytes); */
};
struct set_key_state_reply
{
    struct reply_header __header;
};


struct set_foreground_window_request
{
    struct request_header __header;
    user_handle_t  handle;
    int            internal;
    char __pad_20[4];
};
struct set_foreground_window_reply
{
    struct reply_header __header;
    user_handle_t  previous;
    int            send_msg_old;
    int            send_msg_new;
    char __pad_20[4];
};


struct set_focus_window_request
{
    struct request_header __header;
    user_handle_t  handle;
};
struct set_focus_window_reply
{
    struct reply_header __header;
    user_handle_t  previous;
    char __pad_12[4];
};


struct set_active_window_request
{
    struct request_header __header;
    user_handle_t  handle;
};
struct set_active_window_reply
{
    struct reply_header __header;
    user_handle_t  previous;
    char __pad_12[4];
};


struct set_capture_window_request
{
    struct request_header __header;
    user_handle_t  handle;
    unsigned int   flags;
    char __pad_20[4];
};
struct set_capture_window_reply
{
    struct reply_header __header;
    user_handle_t  previous;
    user_handle_t  full_handle;
};
#define CAPTURE_MENU     0x01
#define CAPTURE_MOVESIZE 0x02



struct set_caret_window_request
{
    struct request_header __header;
    user_handle_t  handle;
    int            width;
    int            height;
};
struct set_caret_window_reply
{
    struct reply_header __header;
    user_handle_t  previous;
    struct rectangle old_rect;
    int            old_hide;
    int            old_state;
    char __pad_36[4];
};



struct set_caret_info_request
{
    struct request_header __header;
    unsigned int   flags;
    user_handle_t  handle;
    int            x;
    int            y;
    int            hide;
    int            state;
    char __pad_36[4];
};
struct set_caret_info_reply
{
    struct reply_header __header;
    user_handle_t  full_handle;
    struct rectangle old_rect;
    int            old_hide;
    int            old_state;
    char __pad_36[4];
};
#define SET_CARET_POS        0x01
#define SET_CARET_HIDE       0x02
#define SET_CARET_STATE      0x04
enum caret_state
{
    CARET_STATE_OFF,
    CARET_STATE_ON,
    CARET_STATE_TOGGLE,
    CARET_STATE_ON_IF_MOVED
};



struct set_hook_request
{
    struct request_header __header;
    int            id;
    process_id_t   pid;
    thread_id_t    tid;
    int            event_min;
    int            event_max;
    client_ptr_t   proc;
    int            flags;
    int            unicode;
    /* VARARG(module,unicode_str); */
};
struct set_hook_reply
{
    struct reply_header __header;
    user_handle_t  handle;
    char __pad_12[4];
};



struct remove_hook_request
{
    struct request_header __header;
    user_handle_t  handle;
    client_ptr_t   proc;
    int            id;
    char __pad_28[4];
};
struct remove_hook_reply
{
    struct reply_header __header;
};



struct start_hook_chain_request
{
    struct request_header __header;
    int            id;
    int            event;
    user_handle_t  window;
    int            object_id;
    int            child_id;
};
struct start_hook_chain_reply
{
    struct reply_header __header;
    user_handle_t  handle;
    process_id_t   pid;
    thread_id_t    tid;
    int            unicode;
    client_ptr_t   proc;
    /* VARARG(module,unicode_str); */
};



struct finish_hook_chain_request
{
    struct request_header __header;
    int            id;
};
struct finish_hook_chain_reply
{
    struct reply_header __header;
};



struct get_hook_info_request
{
    struct request_header __header;
    user_handle_t  handle;
    int            get_next;
    int            event;
    user_handle_t  window;
    int            object_id;
    int            child_id;
    char __pad_36[4];
};
struct get_hook_info_reply
{
    struct reply_header __header;
    user_handle_t  handle;
    int            id;
    process_id_t   pid;
    thread_id_t    tid;
    client_ptr_t   proc;
    int            unicode;
    /* VARARG(module,unicode_str); */
    char __pad_36[4];
};



struct create_class_request
{
    struct request_header __header;
    int            local;
    atom_t         atom;
    unsigned int   style;
    mod_handle_t   instance;
    client_ptr_t   client_ptr;
    short int      cls_extra;
    short int      win_extra;
    data_size_t    name_offset;
    /* VARARG(name,unicode_str); */
};
struct create_class_reply
{
    struct reply_header __header;
    struct obj_locator locator;
    atom_t             atom;
    char __pad_28[4];
};



struct destroy_class_request
{
    struct request_header __header;
    atom_t         atom;
    mod_handle_t   instance;
    /* VARARG(name,unicode_str); */
};
struct destroy_class_reply
{
    struct reply_header __header;
    client_ptr_t   client_ptr;
};



struct set_class_info_request
{
    struct request_header __header;
    user_handle_t  window;
    int            offset;
    data_size_t    size;
    lparam_t       new_info;
};
struct set_class_info_reply
{
    struct reply_header __header;
    lparam_t       old_info;
};


struct get_class_info_request
{
    struct request_header __header;
    user_handle_t  window;
    int            offset;
    data_size_t    size;
};
struct get_class_info_reply
{
    struct reply_header __header;
    lparam_t       info;
};



struct open_clipboard_request
{
    struct request_header __header;
    user_handle_t  window;
};
struct open_clipboard_reply
{
    struct reply_header __header;
    user_handle_t  owner;
    char __pad_12[4];
};



struct close_clipboard_request
{
    struct request_header __header;
    char __pad_12[4];
};
struct close_clipboard_reply
{
    struct reply_header __header;
    user_handle_t  viewer;
    user_handle_t  owner;
};



struct empty_clipboard_request
{
    struct request_header __header;
    char __pad_12[4];
};
struct empty_clipboard_reply
{
    struct reply_header __header;
};



struct set_clipboard_data_request
{
    struct request_header __header;
    unsigned int   format;
    unsigned int   lcid;
    /* VARARG(data,bytes); */
    char __pad_20[4];
};
struct set_clipboard_data_reply
{
    struct reply_header __header;
    unsigned int   seqno;
    char __pad_12[4];
};



struct get_clipboard_data_request
{
    struct request_header __header;
    unsigned int   format;
    int            render;
    int            cached;
    unsigned int   seqno;
    char __pad_28[4];
};
struct get_clipboard_data_reply
{
    struct reply_header __header;
    unsigned int   from;
    user_handle_t  owner;
    unsigned int   seqno;
    data_size_t    total;
    /* VARARG(data,bytes); */
};



struct get_clipboard_formats_request
{
    struct request_header __header;
    unsigned int   format;
};
struct get_clipboard_formats_reply
{
    struct reply_header __header;
    unsigned int   count;
    /* VARARG(formats,uints); */
    char __pad_12[4];
};



struct enum_clipboard_formats_request
{
    struct request_header __header;
    unsigned int   previous;
};
struct enum_clipboard_formats_reply
{
    struct reply_header __header;
    unsigned int   format;
    char __pad_12[4];
};



struct release_clipboard_request
{
    struct request_header __header;
    user_handle_t  owner;
};
struct release_clipboard_reply
{
    struct reply_header __header;
    user_handle_t  viewer;
    user_handle_t  owner;
};



struct get_clipboard_info_request
{
    struct request_header __header;
    char __pad_12[4];
};
struct get_clipboard_info_reply
{
    struct reply_header __header;
    user_handle_t  window;
    user_handle_t  owner;
    user_handle_t  viewer;
    unsigned int   seqno;
};



struct set_clipboard_viewer_request
{
    struct request_header __header;
    user_handle_t  viewer;
    user_handle_t  previous;
    char __pad_20[4];
};
struct set_clipboard_viewer_reply
{
    struct reply_header __header;
    user_handle_t  old_viewer;
    user_handle_t  owner;
};



struct add_clipboard_listener_request
{
    struct request_header __header;
    user_handle_t  window;
};
struct add_clipboard_listener_reply
{
    struct reply_header __header;
};



struct remove_clipboard_listener_request
{
    struct request_header __header;
    user_handle_t  window;
};
struct remove_clipboard_listener_reply
{
    struct reply_header __header;
};



struct create_token_request
{
    struct request_header __header;
    struct luid    token_id;
    unsigned int   access;
    int            primary;
    int            impersonation_level;
    abstime_t      expire;
    int            group_count;
    int            primary_group;
    int            priv_count;





    char __pad_52[4];
};
struct create_token_reply
{
    struct reply_header __header;
    obj_handle_t   token;
    char __pad_12[4];
};



struct open_token_request
{
    struct request_header __header;
    obj_handle_t   handle;
    unsigned int   access;
    unsigned int   attributes;
    unsigned int   flags;
    char __pad_28[4];
};
struct open_token_reply
{
    struct reply_header __header;
    obj_handle_t   token;
    char __pad_12[4];
};
#define OPEN_TOKEN_THREAD   1
#define OPEN_TOKEN_AS_SELF  2



struct set_desktop_shell_windows_request
{
    struct request_header __header;
    unsigned int   flags;
    user_handle_t  shell_window;
    user_handle_t  shell_listview;
    user_handle_t  progman_window;
    user_handle_t  taskman_window;
};
struct set_desktop_shell_windows_reply
{
    struct reply_header __header;
    user_handle_t  old_shell_window;
    user_handle_t  old_shell_listview;
    user_handle_t  old_progman_window;
    user_handle_t  old_taskman_window;
};
#define SET_DESKTOP_SHELL_WINDOWS   0x01
#define SET_DESKTOP_PROGMAN_WINDOW  0x02
#define SET_DESKTOP_TASKMAN_WINDOW  0x04


struct adjust_token_privileges_request
{
    struct request_header __header;
    obj_handle_t  handle;
    int           disable_all;
    int           get_modified_state;
    /* VARARG(privileges,luid_attr); */
};
struct adjust_token_privileges_reply
{
    struct reply_header __header;
    unsigned int  len;
    /* VARARG(privileges,luid_attr); */
    char __pad_12[4];
};


struct get_token_privileges_request
{
    struct request_header __header;
    obj_handle_t  handle;
};
struct get_token_privileges_reply
{
    struct reply_header __header;
    unsigned int  len;
    /* VARARG(privileges,luid_attr); */
    char __pad_12[4];
};


struct check_token_privileges_request
{
    struct request_header __header;
    obj_handle_t  handle;
    int           all_required;
    /* VARARG(privileges,luid_attr); */
    char __pad_20[4];
};
struct check_token_privileges_reply
{
    struct reply_header __header;
    int           has_privileges;
    /* VARARG(privileges,luid_attr); */
    char __pad_12[4];
};

struct duplicate_token_request
{
    struct request_header __header;
    obj_handle_t  handle;
    unsigned int  access;
    int           primary;
    int           impersonation_level;
    /* VARARG(objattr,object_attributes); */
    char __pad_28[4];
};
struct duplicate_token_reply
{
    struct reply_header __header;
    obj_handle_t  new_handle;
    char __pad_12[4];
};

struct filter_token_request
{
    struct request_header __header;
    obj_handle_t  handle;
    unsigned int  flags;
    data_size_t   privileges_size;
    /* VARARG(privileges,luid_attr,privileges_size); */
    /* VARARG(disable_sids,sid); */
};
struct filter_token_reply
{
    struct reply_header __header;
    obj_handle_t  new_handle;
    char __pad_12[4];
};

struct access_check_request
{
    struct request_header __header;
    obj_handle_t    handle;
    unsigned int    desired_access;
    struct generic_map mapping;
    /* VARARG(sd,security_descriptor); */
    char __pad_36[4];
};
struct access_check_reply
{
    struct reply_header __header;
    unsigned int    access_granted;
    unsigned int    access_status;
    unsigned int    privileges_len;
    /* VARARG(privileges,luid_attr); */
    char __pad_20[4];
};

struct get_token_sid_request
{
    struct request_header __header;
    obj_handle_t    handle;
    unsigned int    which_sid;
    char __pad_20[4];
};
struct get_token_sid_reply
{
    struct reply_header __header;
    data_size_t     sid_len;
    /* VARARG(sid,sid); */
    char __pad_12[4];
};

struct get_token_groups_request
{
    struct request_header __header;
    obj_handle_t    handle;
    unsigned int    attr_mask;
    char __pad_20[4];
};
struct get_token_groups_reply
{
    struct reply_header __header;
    data_size_t     attr_len;
    data_size_t     sid_len;
    /* VARARG(attrs,uints,attr_len); */
    /* VARARG(sids,sids); */
};

struct get_token_default_dacl_request
{
    struct request_header __header;
    obj_handle_t    handle;
};
struct get_token_default_dacl_reply
{
    struct reply_header __header;
    data_size_t     acl_len;
    /* VARARG(acl,acl); */
    char __pad_12[4];
};

struct set_token_default_dacl_request
{
    struct request_header __header;
    obj_handle_t    handle;
    /* VARARG(acl,acl); */
};
struct set_token_default_dacl_reply
{
    struct reply_header __header;
};

struct set_security_object_request
{
    struct request_header __header;
    obj_handle_t    handle;
    unsigned int    security_info;
    /* VARARG(sd,security_descriptor); */
    char __pad_20[4];
};
struct set_security_object_reply
{
    struct reply_header __header;
};

struct get_security_object_request
{
    struct request_header __header;
    obj_handle_t    handle;
    unsigned int    security_info;
    char __pad_20[4];
};
struct get_security_object_reply
{
    struct reply_header __header;
    unsigned int    sd_len;
    /* VARARG(sd,security_descriptor); */
    char __pad_12[4];
};


struct handle_info
{
    process_id_t owner;
    obj_handle_t handle;
    unsigned int access;
    unsigned int attributes;
    unsigned int type;
};


struct get_system_handles_request
{
    struct request_header __header;
    char __pad_12[4];
};
struct get_system_handles_reply
{
    struct reply_header __header;
    unsigned int    count;
    /* VARARG(data,handle_infos); */
    char __pad_12[4];
};



struct get_tcp_connections_request
{
    struct request_header __header;
    unsigned int    state_filter;
};
struct get_tcp_connections_reply
{
    struct reply_header __header;
    unsigned int    count;
    /* VARARG(connections,tcp_connections); */
    char __pad_12[4];
};



struct get_udp_endpoints_request
{
    struct request_header __header;
    char __pad_12[4];
};
struct get_udp_endpoints_reply
{
    struct reply_header __header;
    unsigned int    count;
    /* VARARG(endpoints,udp_endpoints); */
    char __pad_12[4];
};



struct create_mailslot_request
{
    struct request_header __header;
    unsigned int   access;
    unsigned int   options;
    char __pad_20[4];
    timeout_t      read_timeout;
    unsigned int   max_msgsize;
    /* VARARG(objattr,object_attributes); */
    char __pad_36[4];
};
struct create_mailslot_reply
{
    struct reply_header __header;
    obj_handle_t   handle;
    char __pad_12[4];
};



struct set_mailslot_info_request
{
    struct request_header __header;
    obj_handle_t   handle;
    timeout_t      read_timeout;
    unsigned int   flags;
    char __pad_28[4];
};
struct set_mailslot_info_reply
{
    struct reply_header __header;
    timeout_t      read_timeout;
    unsigned int   max_msgsize;
    char __pad_20[4];
};
#define MAILSLOT_SET_READ_TIMEOUT  1



struct create_directory_request
{
    struct request_header __header;
    unsigned int   access;
    /* VARARG(objattr,object_attributes); */
};
struct create_directory_reply
{
    struct reply_header __header;
    obj_handle_t   handle;
    char __pad_12[4];
};



struct open_directory_request
{
    struct request_header __header;
    unsigned int   access;
    unsigned int   attributes;
    obj_handle_t   rootdir;
    /* VARARG(directory_name,unicode_str); */
};
struct open_directory_reply
{
    struct reply_header __header;
    obj_handle_t   handle;
    char __pad_12[4];
};



struct get_directory_entries_request
{
    struct request_header __header;
    obj_handle_t   handle;
    unsigned int   index;
    unsigned int   max_count;
};
struct get_directory_entries_reply
{
    struct reply_header __header;
    data_size_t    total_len;
    unsigned int   count;
    /* VARARG(entries,directory_entries); */
};



struct create_symlink_request
{
    struct request_header __header;
    unsigned int   access;
    /* VARARG(objattr,object_attributes); */
    /* VARARG(target_name,unicode_str); */
};
struct create_symlink_reply
{
    struct reply_header __header;
    obj_handle_t   handle;
    char __pad_12[4];
};



struct open_symlink_request
{
    struct request_header __header;
    unsigned int   access;
    unsigned int   attributes;
    obj_handle_t   rootdir;
    /* VARARG(name,unicode_str); */
};
struct open_symlink_reply
{
    struct reply_header __header;
    obj_handle_t   handle;
    char __pad_12[4];
};



struct query_symlink_request
{
    struct request_header __header;
    obj_handle_t   handle;
};
struct query_symlink_reply
{
    struct reply_header __header;
    data_size_t    total;
    /* VARARG(target_name,unicode_str); */
    char __pad_12[4];
};



struct get_object_info_request
{
    struct request_header __header;
    obj_handle_t   handle;
};
struct get_object_info_reply
{
    struct reply_header __header;
    unsigned int   access;
    unsigned int   ref_count;
    unsigned int   handle_count;
    char __pad_20[4];
};



struct get_object_name_request
{
    struct request_header __header;
    obj_handle_t   handle;
};
struct get_object_name_reply
{
    struct reply_header __header;
    data_size_t    total;
    /* VARARG(name,unicode_str); */
    char __pad_12[4];
};



struct get_object_type_request
{
    struct request_header __header;
    obj_handle_t   handle;
};
struct get_object_type_reply
{
    struct reply_header __header;
    /* VARARG(info,object_type_info); */
};



struct get_object_types_request
{
    struct request_header __header;
    char __pad_12[4];
};
struct get_object_types_reply
{
    struct reply_header __header;
    int            count;
    /* VARARG(info,object_types_info); */
    char __pad_12[4];
};



struct allocate_locally_unique_id_request
{
    struct request_header __header;
    char __pad_12[4];
};
struct allocate_locally_unique_id_reply
{
    struct reply_header __header;
    struct luid    luid;
};



struct create_device_manager_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int attributes;
    char __pad_20[4];
};
struct create_device_manager_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct create_device_request
{
    struct request_header __header;
    obj_handle_t rootdir;
    client_ptr_t user_ptr;
    obj_handle_t manager;
    /* VARARG(name,unicode_str); */
    char __pad_28[4];
};
struct create_device_reply
{
    struct reply_header __header;
};



struct delete_device_request
{
    struct request_header __header;
    obj_handle_t manager;
    client_ptr_t device;
};
struct delete_device_reply
{
    struct reply_header __header;
};



struct get_next_device_request_request
{
    struct request_header __header;
    obj_handle_t manager;
    obj_handle_t prev;
    unsigned int status;
    client_ptr_t user_ptr;
    int          pending;
    unsigned int iosb_status;
    data_size_t  result;
    /* VARARG(data,bytes); */
    char __pad_44[4];
};
struct get_next_device_request_reply
{
    struct reply_header __header;
    union irp_params params;
    obj_handle_t next;
    thread_id_t  client_tid;
    client_ptr_t client_thread;
    data_size_t  in_size;
    /* VARARG(next_data,bytes); */
    char __pad_60[4];
};



struct get_kernel_object_ptr_request
{
    struct request_header __header;
    obj_handle_t manager;
    obj_handle_t handle;
    char __pad_20[4];
};
struct get_kernel_object_ptr_reply
{
    struct reply_header __header;
    client_ptr_t user_ptr;
};



struct set_kernel_object_ptr_request
{
    struct request_header __header;
    obj_handle_t manager;
    obj_handle_t handle;
    char __pad_20[4];
    client_ptr_t user_ptr;
};
struct set_kernel_object_ptr_reply
{
    struct reply_header __header;
};



struct grab_kernel_object_request
{
    struct request_header __header;
    obj_handle_t manager;
    client_ptr_t user_ptr;
};
struct grab_kernel_object_reply
{
    struct reply_header __header;
};



struct release_kernel_object_request
{
    struct request_header __header;
    obj_handle_t manager;
    client_ptr_t user_ptr;
};
struct release_kernel_object_reply
{
    struct reply_header __header;
};



struct get_kernel_object_handle_request
{
    struct request_header __header;
    obj_handle_t manager;
    client_ptr_t user_ptr;
    unsigned int access;
    char __pad_28[4];
};
struct get_kernel_object_handle_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct make_process_system_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct make_process_system_reply
{
    struct reply_header __header;
    obj_handle_t event;
    char __pad_12[4];
};



struct grant_process_admin_token_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct grant_process_admin_token_reply
{
    struct reply_header __header;
};



struct get_token_info_request
{
    struct request_header __header;
    obj_handle_t   handle;
};
struct get_token_info_reply
{
    struct reply_header __header;
    struct luid    token_id;
    struct luid    modified_id;
    unsigned int   session_id;
    int            primary;
    int            impersonation_level;
    int            elevation_type;
    int            is_elevated;
    int            group_count;
    int            privilege_count;
    char __pad_52[4];
};



struct create_linked_token_request
{
    struct request_header __header;
    obj_handle_t   handle;
};
struct create_linked_token_reply
{
    struct reply_header __header;
    obj_handle_t   linked;
    char __pad_12[4];
};



struct create_completion_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int concurrent;
    /* VARARG(objattr,object_attributes); */
    char __pad_20[4];
};
struct create_completion_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct open_completion_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int attributes;
    obj_handle_t rootdir;
    /* VARARG(filename,unicode_str); */
};
struct open_completion_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct add_completion_request
{
    struct request_header __header;
    obj_handle_t  handle;
    apc_param_t   ckey;
    apc_param_t   cvalue;
    apc_param_t   information;
    obj_handle_t  reserve_handle;
    unsigned int  status;
};
struct add_completion_reply
{
    struct reply_header __header;
};



struct remove_completion_request
{
    struct request_header __header;
    obj_handle_t handle;
    int          alertable;
    char __pad_20[4];
};
struct remove_completion_reply
{
    struct reply_header __header;
    apc_param_t   ckey;
    apc_param_t   cvalue;
    apc_param_t   information;
    unsigned int  status;
    obj_handle_t  wait_handle;
};



struct get_thread_completion_request
{
    struct request_header __header;
    char __pad_12[4];
};
struct get_thread_completion_reply
{
    struct reply_header __header;
    apc_param_t   ckey;
    apc_param_t   cvalue;
    apc_param_t   information;
    unsigned int  status;
    char __pad_36[4];
};



struct query_completion_request
{
    struct request_header __header;
    obj_handle_t  handle;
};
struct query_completion_reply
{
    struct reply_header __header;
    unsigned int  depth;
    char __pad_12[4];
};



struct set_completion_info_request
{
    struct request_header __header;
    obj_handle_t  handle;
    apc_param_t   ckey;
    obj_handle_t  chandle;
    char __pad_28[4];
};
struct set_completion_info_reply
{
    struct reply_header __header;
};



struct add_fd_completion_request
{
    struct request_header __header;
    obj_handle_t   handle;
    apc_param_t    cvalue;
    apc_param_t    information;
    unsigned int   status;
    int            async;
};
struct add_fd_completion_reply
{
    struct reply_header __header;
};



struct set_fd_completion_mode_request
{
    struct request_header __header;
    obj_handle_t handle;
    unsigned int flags;
    char __pad_20[4];
};
struct set_fd_completion_mode_reply
{
    struct reply_header __header;
};



struct set_fd_disp_info_request
{
    struct request_header __header;
    obj_handle_t handle;
    unsigned int flags;
    char __pad_20[4];
};
struct set_fd_disp_info_reply
{
    struct reply_header __header;
};



struct set_fd_name_info_request
{
    struct request_header __header;
    obj_handle_t handle;
    obj_handle_t rootdir;
    data_size_t  namelen;
    int          link;
    unsigned int flags;
    /* VARARG(name,unicode_str,namelen); */
    /* VARARG(filename,string); */
};
struct set_fd_name_info_reply
{
    struct reply_header __header;
};



struct set_fd_eof_info_request
{
    struct request_header __header;
    obj_handle_t handle;
    file_pos_t   eof;
};
struct set_fd_eof_info_reply
{
    struct reply_header __header;
};



struct get_window_layered_info_request
{
    struct request_header __header;
    user_handle_t  handle;
};
struct get_window_layered_info_reply
{
    struct reply_header __header;
    unsigned int   color_key;
    unsigned int   alpha;
    unsigned int   flags;
    char __pad_20[4];
};



struct set_window_layered_info_request
{
    struct request_header __header;
    user_handle_t  handle;
    unsigned int   color_key;
    unsigned int   alpha;
    unsigned int   flags;
    char __pad_28[4];
};
struct set_window_layered_info_reply
{
    struct reply_header __header;
};



struct alloc_user_handle_request
{
    struct request_header __header;
    unsigned short type;
    char __pad_14[2];
};
struct alloc_user_handle_reply
{
    struct reply_header __header;
    user_handle_t  handle;
    char __pad_12[4];
};



struct free_user_handle_request
{
    struct request_header __header;
    unsigned short type;
    char __pad_14[2];
    user_handle_t  handle;
    char __pad_20[4];
};
struct free_user_handle_reply
{
    struct reply_header __header;
};



struct set_cursor_request
{
    struct request_header __header;
    unsigned int   flags;
    user_handle_t  handle;
    int            show_count;
    int            x;
    int            y;
    struct rectangle clip;
};
struct set_cursor_reply
{
    struct reply_header __header;
    user_handle_t  prev_handle;
    int            prev_count;
    int            prev_x;
    int            prev_y;
    int            new_x;
    int            new_y;
    struct rectangle new_clip;
    unsigned int   last_change;
    char __pad_52[4];
};
#define SET_CURSOR_HANDLE 0x01
#define SET_CURSOR_COUNT  0x02
#define SET_CURSOR_POS    0x04
#define SET_CURSOR_CLIP   0x08
#define SET_CURSOR_NOCLIP 0x10
#define SET_CURSOR_FSCLIP 0x20


struct get_cursor_history_request
{
    struct request_header __header;
    char __pad_12[4];
};
struct get_cursor_history_reply
{
    struct reply_header __header;
    /* VARARG(history,cursor_positions); */
};



struct get_rawinput_buffer_request
{
    struct request_header __header;
    data_size_t header_size;
    int         read_data;
    char __pad_20[4];
};
struct get_rawinput_buffer_reply
{
    struct reply_header __header;
    data_size_t next_size;
    unsigned int time;
    unsigned int count;
    /* VARARG(data,bytes); */
    char __pad_20[4];
};


struct update_rawinput_devices_request
{
    struct request_header __header;
    /* VARARG(devices,rawinput_devices); */
    char __pad_12[4];
};
struct update_rawinput_devices_reply
{
    struct reply_header __header;
};


struct create_job_request
{
    struct request_header __header;
    unsigned int access;
    /* VARARG(objattr,object_attributes); */
};
struct create_job_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct open_job_request
{
    struct request_header __header;
    unsigned int access;
    unsigned int attributes;
    obj_handle_t rootdir;
    /* VARARG(name,unicode_str); */
};
struct open_job_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct assign_job_request
{
    struct request_header __header;
    obj_handle_t job;
    obj_handle_t process;
    char __pad_20[4];
};
struct assign_job_reply
{
    struct reply_header __header;
};



struct process_in_job_request
{
    struct request_header __header;
    obj_handle_t job;
    obj_handle_t process;
    char __pad_20[4];
};
struct process_in_job_reply
{
    struct reply_header __header;
};



struct set_job_limits_request
{
    struct request_header __header;
    obj_handle_t handle;
    unsigned int limit_flags;
    char __pad_20[4];
};
struct set_job_limits_reply
{
    struct reply_header __header;
};



struct set_job_completion_port_request
{
    struct request_header __header;
    obj_handle_t job;
    obj_handle_t port;
    char __pad_20[4];
    client_ptr_t key;
};
struct set_job_completion_port_reply
{
    struct reply_header __header;
};



struct get_job_info_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct get_job_info_reply
{
    struct reply_header __header;
    int total_processes;
    int active_processes;
    /* VARARG(pids,uints); */
};



struct terminate_job_request
{
    struct request_header __header;
    obj_handle_t handle;
    int          status;
    char __pad_20[4];
};
struct terminate_job_reply
{
    struct reply_header __header;
};



struct suspend_process_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct suspend_process_reply
{
    struct reply_header __header;
};



struct resume_process_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct resume_process_reply
{
    struct reply_header __header;
};


struct get_next_process_request
{
    struct request_header __header;
    obj_handle_t last;
    unsigned int access;
    unsigned int attributes;
    unsigned int flags;
    char __pad_28[4];
};
struct get_next_process_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};


struct get_next_thread_request
{
    struct request_header __header;
    obj_handle_t process;
    obj_handle_t last;
    unsigned int access;
    unsigned int attributes;
    unsigned int flags;
};
struct get_next_thread_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct set_keyboard_repeat_request
{
    struct request_header __header;
    int enable;
    int delay;
    int period;
};
struct set_keyboard_repeat_reply
{
    struct reply_header __header;
    int enable;
    char __pad_12[4];
};


enum inproc_sync_type
{
    INPROC_SYNC_UNKNOWN   = 0,
    INPROC_SYNC_INTERNAL  = 1,
    INPROC_SYNC_EVENT     = 2,
    INPROC_SYNC_MUTEX     = 3,
    INPROC_SYNC_SEMAPHORE = 4,
};


struct get_inproc_sync_fd_request
{
    struct request_header __header;
    obj_handle_t handle;
};
struct get_inproc_sync_fd_reply
{
    struct reply_header __header;
    int           type;
    unsigned int access;
};



struct get_inproc_alert_fd_request
{
    struct request_header __header;
    char __pad_12[4];
};
struct get_inproc_alert_fd_reply
{
    struct reply_header __header;
    obj_handle_t handle;
    char __pad_12[4];
};



struct d3dkmt_object_create_request
{
    struct request_header __header;
    unsigned int        type;
    int                 fd;
    unsigned int        value;
    /* VARARG(runtime,bytes); */
};
struct d3dkmt_object_create_reply
{
    struct reply_header __header;
    d3dkmt_handle_t     global;
    obj_handle_t        handle;
};



struct d3dkmt_object_update_request
{
    struct request_header __header;
    unsigned int        type;
    d3dkmt_handle_t     global;
    /* VARARG(runtime,bytes); */
    char __pad_20[4];
};
struct d3dkmt_object_update_reply
{
    struct reply_header __header;
};



struct d3dkmt_object_query_request
{
    struct request_header __header;
    unsigned int        type;
    d3dkmt_handle_t     global;
    obj_handle_t        handle;
};
struct d3dkmt_object_query_reply
{
    struct reply_header __header;
    data_size_t         runtime_size;
    char __pad_12[4];
};



struct d3dkmt_object_open_request
{
    struct request_header __header;
    unsigned int        type;
    d3dkmt_handle_t     global;
    obj_handle_t        handle;
};
struct d3dkmt_object_open_reply
{
    struct reply_header __header;
    d3dkmt_handle_t     global;
    obj_handle_t        handle;
    data_size_t         runtime_size;
    /* VARARG(runtime,bytes); */
    char __pad_20[4];
};



struct d3dkmt_share_objects_request
{
    struct request_header __header;
    d3dkmt_handle_t     resource;
    d3dkmt_handle_t     mutex;
    d3dkmt_handle_t     sync;
    unsigned int        access;
    /* VARARG(objattr,object_attributes); */
    char __pad_28[4];
};
struct d3dkmt_share_objects_reply
{
    struct reply_header __header;
    obj_handle_t        handle;
    char __pad_12[4];
};



struct d3dkmt_object_open_name_request
{
    struct request_header __header;
    unsigned int        type;
    unsigned int        access;
    unsigned int        attributes;
    obj_handle_t        rootdir;
    /* VARARG(name,unicode_str); */
    char __pad_28[4];
};
struct d3dkmt_object_open_name_reply
{
    struct reply_header __header;
    obj_handle_t        handle;
    char __pad_12[4];
};



struct d3dkmt_mutex_acquire_request
{
    struct request_header __header;
    d3dkmt_handle_t     mutex;
    unsigned int        key_value;
    obj_handle_t        wait_handle;
    unsigned int        wait_status;
    char __pad_28[4];
};
struct d3dkmt_mutex_acquire_reply
{
    struct reply_header __header;
    unsigned __int64    fence_value;
    data_size_t         runtime_size;
    obj_handle_t        wait_handle;
    /* VARARG(runtime,bytes); */
};



struct d3dkmt_mutex_release_request
{
    struct request_header __header;
    d3dkmt_handle_t     mutex;
    int                 abandon;
    unsigned int        key_value;
    unsigned __int64    fence_value;
    data_size_t         runtime_size;
    /* VARARG(runtime,bytes); */
    char __pad_36[4];
};
struct d3dkmt_mutex_release_reply
{
    struct reply_header __header;
};


enum request
{
    REQ_new_process,
    REQ_get_new_process_info,
    REQ_new_thread,
    REQ_get_startup_info,
    REQ_init_process_done,
    REQ_init_first_thread,
    REQ_init_thread,
    REQ_terminate_process,
    REQ_terminate_thread,
    REQ_get_process_info,
    REQ_get_process_debug_info,
    REQ_get_process_image_name,
    REQ_get_process_vm_counters,
    REQ_set_process_info,
    REQ_get_thread_info,
    REQ_get_thread_times,
    REQ_set_thread_info,
    REQ_suspend_thread,
    REQ_resume_thread,
    REQ_queue_apc,
    REQ_get_apc_result,
    REQ_close_handle,
    REQ_set_handle_info,
    REQ_dup_handle,
    REQ_allocate_reserve_object,
    REQ_compare_objects,
    REQ_set_object_permanence,
    REQ_open_process,
    REQ_open_thread,
    REQ_select,
    REQ_create_event,
    REQ_event_op,
    REQ_query_event,
    REQ_open_event,
    REQ_create_keyed_event,
    REQ_open_keyed_event,
    REQ_create_mutex,
    REQ_release_mutex,
    REQ_open_mutex,
    REQ_query_mutex,
    REQ_create_semaphore,
    REQ_release_semaphore,
    REQ_query_semaphore,
    REQ_open_semaphore,
    REQ_create_file,
    REQ_open_file_object,
    REQ_alloc_file_handle,
    REQ_get_handle_unix_name,
    REQ_get_handle_fd,
    REQ_get_directory_cache_entry,
    REQ_flush,
    REQ_get_file_info,
    REQ_get_volume_info,
    REQ_lock_file,
    REQ_unlock_file,
    REQ_recv_socket,
    REQ_send_socket,
    REQ_socket_get_events,
    REQ_socket_send_icmp_id,
    REQ_socket_get_icmp_id,
    REQ_get_next_console_request,
    REQ_read_directory_changes,
    REQ_read_change,
    REQ_create_mapping,
    REQ_open_mapping,
    REQ_get_mapping_info,
    REQ_get_image_map_address,
    REQ_map_view,
    REQ_map_image_view,
    REQ_map_builtin_view,
    REQ_get_image_view_info,
    REQ_unmap_view,
    REQ_get_mapping_committed_range,
    REQ_add_mapping_committed_range,
    REQ_is_same_mapping,
    REQ_get_mapping_filename,
    REQ_list_processes,
    REQ_create_debug_obj,
    REQ_wait_debug_event,
    REQ_queue_exception_event,
    REQ_get_exception_status,
    REQ_continue_debug_event,
    REQ_debug_process,
    REQ_set_debug_obj_info,
    REQ_read_process_memory,
    REQ_write_process_memory,
    REQ_create_key,
    REQ_open_key,
    REQ_delete_key,
    REQ_flush_key,
    REQ_enum_key,
    REQ_set_key_value,
    REQ_get_key_value,
    REQ_enum_key_value,
    REQ_delete_key_value,
    REQ_load_registry,
    REQ_unload_registry,
    REQ_save_registry,
    REQ_set_registry_notification,
    REQ_rename_key,
    REQ_create_timer,
    REQ_open_timer,
    REQ_set_timer,
    REQ_cancel_timer,
    REQ_get_timer_info,
    REQ_get_thread_context,
    REQ_set_thread_context,
    REQ_add_atom,
    REQ_delete_atom,
    REQ_find_atom,
    REQ_get_atom_information,
    REQ_add_user_atom,
    REQ_get_user_atom_name,
    REQ_get_msg_queue_handle,
    REQ_get_msg_queue,
    REQ_set_queue_fd,
    REQ_set_queue_mask,
    REQ_get_queue_status,
    REQ_get_process_idle_event,
    REQ_send_message,
    REQ_post_quit_message,
    REQ_send_hardware_message,
    REQ_get_message,
    REQ_reply_message,
    REQ_accept_hardware_message,
    REQ_get_message_reply,
    REQ_set_win_timer,
    REQ_kill_win_timer,
    REQ_is_window_hung,
    REQ_get_serial_info,
    REQ_set_serial_info,
    REQ_cancel_sync,
    REQ_register_async,
    REQ_cancel_async,
    REQ_get_async_result,
    REQ_set_async_direct_result,
    REQ_read,
    REQ_write,
    REQ_ioctl,
    REQ_set_irp_result,
    REQ_create_named_pipe,
    REQ_set_named_pipe_info,
    REQ_create_window,
    REQ_destroy_window,
    REQ_get_desktop_window,
    REQ_set_window_owner,
    REQ_get_window_info,
    REQ_init_window_info,
    REQ_set_window_info,
    REQ_set_parent,
    REQ_get_window_parents,
    REQ_get_window_list,
    REQ_get_class_windows,
    REQ_get_window_children_from_point,
    REQ_get_window_tree,
    REQ_set_window_pos,
    REQ_get_window_rectangles,
    REQ_get_window_text,
    REQ_set_window_text,
    REQ_get_windows_offset,
    REQ_get_visible_region,
    REQ_get_window_region,
    REQ_set_window_region,
    REQ_get_update_region,
    REQ_update_window_zorder,
    REQ_redraw_window,
    REQ_set_window_property,
    REQ_remove_window_property,
    REQ_get_window_property,
    REQ_get_window_properties,
    REQ_create_winstation,
    REQ_open_winstation,
    REQ_close_winstation,
    REQ_set_winstation_monitors,
    REQ_get_process_winstation,
    REQ_set_process_winstation,
    REQ_enum_winstation,
    REQ_create_desktop,
    REQ_open_desktop,
    REQ_open_input_desktop,
    REQ_set_input_desktop,
    REQ_close_desktop,
    REQ_get_thread_desktop,
    REQ_set_thread_desktop,
    REQ_set_user_object_info,
    REQ_register_hotkey,
    REQ_unregister_hotkey,
    REQ_attach_thread_input,
    REQ_get_thread_input,
    REQ_get_last_input_time,
    REQ_get_key_state,
    REQ_set_key_state,
    REQ_set_foreground_window,
    REQ_set_focus_window,
    REQ_set_active_window,
    REQ_set_capture_window,
    REQ_set_caret_window,
    REQ_set_caret_info,
    REQ_set_hook,
    REQ_remove_hook,
    REQ_start_hook_chain,
    REQ_finish_hook_chain,
    REQ_get_hook_info,
    REQ_create_class,
    REQ_destroy_class,
    REQ_set_class_info,
    REQ_get_class_info,
    REQ_open_clipboard,
    REQ_close_clipboard,
    REQ_empty_clipboard,
    REQ_set_clipboard_data,
    REQ_get_clipboard_data,
    REQ_get_clipboard_formats,
    REQ_enum_clipboard_formats,
    REQ_release_clipboard,
    REQ_get_clipboard_info,
    REQ_set_clipboard_viewer,
    REQ_add_clipboard_listener,
    REQ_remove_clipboard_listener,
    REQ_create_token,
    REQ_open_token,
    REQ_set_desktop_shell_windows,
    REQ_adjust_token_privileges,
    REQ_get_token_privileges,
    REQ_check_token_privileges,
    REQ_duplicate_token,
    REQ_filter_token,
    REQ_access_check,
    REQ_get_token_sid,
    REQ_get_token_groups,
    REQ_get_token_default_dacl,
    REQ_set_token_default_dacl,
    REQ_set_security_object,
    REQ_get_security_object,
    REQ_get_system_handles,
    REQ_get_tcp_connections,
    REQ_get_udp_endpoints,
    REQ_create_mailslot,
    REQ_set_mailslot_info,
    REQ_create_directory,
    REQ_open_directory,
    REQ_get_directory_entries,
    REQ_create_symlink,
    REQ_open_symlink,
    REQ_query_symlink,
    REQ_get_object_info,
    REQ_get_object_name,
    REQ_get_object_type,
    REQ_get_object_types,
    REQ_allocate_locally_unique_id,
    REQ_create_device_manager,
    REQ_create_device,
    REQ_delete_device,
    REQ_get_next_device_request,
    REQ_get_kernel_object_ptr,
    REQ_set_kernel_object_ptr,
    REQ_grab_kernel_object,
    REQ_release_kernel_object,
    REQ_get_kernel_object_handle,
    REQ_make_process_system,
    REQ_grant_process_admin_token,
    REQ_get_token_info,
    REQ_create_linked_token,
    REQ_create_completion,
    REQ_open_completion,
    REQ_add_completion,
    REQ_remove_completion,
    REQ_get_thread_completion,
    REQ_query_completion,
    REQ_set_completion_info,
    REQ_add_fd_completion,
    REQ_set_fd_completion_mode,
    REQ_set_fd_disp_info,
    REQ_set_fd_name_info,
    REQ_set_fd_eof_info,
    REQ_get_window_layered_info,
    REQ_set_window_layered_info,
    REQ_alloc_user_handle,
    REQ_free_user_handle,
    REQ_set_cursor,
    REQ_get_cursor_history,
    REQ_get_rawinput_buffer,
    REQ_update_rawinput_devices,
    REQ_create_job,
    REQ_open_job,
    REQ_assign_job,
    REQ_process_in_job,
    REQ_set_job_limits,
    REQ_set_job_completion_port,
    REQ_get_job_info,
    REQ_terminate_job,
    REQ_suspend_process,
    REQ_resume_process,
    REQ_get_next_process,
    REQ_get_next_thread,
    REQ_set_keyboard_repeat,
    REQ_get_inproc_sync_fd,
    REQ_get_inproc_alert_fd,
    REQ_d3dkmt_object_create,
    REQ_d3dkmt_object_update,
    REQ_d3dkmt_object_query,
    REQ_d3dkmt_object_open,
    REQ_d3dkmt_share_objects,
    REQ_d3dkmt_object_open_name,
    REQ_d3dkmt_mutex_acquire,
    REQ_d3dkmt_mutex_release,
    REQ_NB_REQUESTS
};

union generic_request
{
    struct request_max_size max_size;
    struct request_header request_header;
    struct new_process_request new_process_request;
    struct get_new_process_info_request get_new_process_info_request;
    struct new_thread_request new_thread_request;
    struct get_startup_info_request get_startup_info_request;
    struct init_process_done_request init_process_done_request;
    struct init_first_thread_request init_first_thread_request;
    struct init_thread_request init_thread_request;
    struct terminate_process_request terminate_process_request;
    struct terminate_thread_request terminate_thread_request;
    struct get_process_info_request get_process_info_request;
    struct get_process_debug_info_request get_process_debug_info_request;
    struct get_process_image_name_request get_process_image_name_request;
    struct get_process_vm_counters_request get_process_vm_counters_request;
    struct set_process_info_request set_process_info_request;
    struct get_thread_info_request get_thread_info_request;
    struct get_thread_times_request get_thread_times_request;
    struct set_thread_info_request set_thread_info_request;
    struct suspend_thread_request suspend_thread_request;
    struct resume_thread_request resume_thread_request;
    struct queue_apc_request queue_apc_request;
    struct get_apc_result_request get_apc_result_request;
    struct close_handle_request close_handle_request;
    struct set_handle_info_request set_handle_info_request;
    struct dup_handle_request dup_handle_request;
    struct allocate_reserve_object_request allocate_reserve_object_request;
    struct compare_objects_request compare_objects_request;
    struct set_object_permanence_request set_object_permanence_request;
    struct open_process_request open_process_request;
    struct open_thread_request open_thread_request;
    struct select_request select_request;
    struct create_event_request create_event_request;
    struct event_op_request event_op_request;
    struct query_event_request query_event_request;
    struct open_event_request open_event_request;
    struct create_keyed_event_request create_keyed_event_request;
    struct open_keyed_event_request open_keyed_event_request;
    struct create_mutex_request create_mutex_request;
    struct release_mutex_request release_mutex_request;
    struct open_mutex_request open_mutex_request;
    struct query_mutex_request query_mutex_request;
    struct create_semaphore_request create_semaphore_request;
    struct release_semaphore_request release_semaphore_request;
    struct query_semaphore_request query_semaphore_request;
    struct open_semaphore_request open_semaphore_request;
    struct create_file_request create_file_request;
    struct open_file_object_request open_file_object_request;
    struct alloc_file_handle_request alloc_file_handle_request;
    struct get_handle_unix_name_request get_handle_unix_name_request;
    struct get_handle_fd_request get_handle_fd_request;
    struct get_directory_cache_entry_request get_directory_cache_entry_request;
    struct flush_request flush_request;
    struct get_file_info_request get_file_info_request;
    struct get_volume_info_request get_volume_info_request;
    struct lock_file_request lock_file_request;
    struct unlock_file_request unlock_file_request;
    struct recv_socket_request recv_socket_request;
    struct send_socket_request send_socket_request;
    struct socket_get_events_request socket_get_events_request;
    struct socket_send_icmp_id_request socket_send_icmp_id_request;
    struct socket_get_icmp_id_request socket_get_icmp_id_request;
    struct get_next_console_request_request get_next_console_request_request;
    struct read_directory_changes_request read_directory_changes_request;
    struct read_change_request read_change_request;
    struct create_mapping_request create_mapping_request;
    struct open_mapping_request open_mapping_request;
    struct get_mapping_info_request get_mapping_info_request;
    struct get_image_map_address_request get_image_map_address_request;
    struct map_view_request map_view_request;
    struct map_image_view_request map_image_view_request;
    struct map_builtin_view_request map_builtin_view_request;
    struct get_image_view_info_request get_image_view_info_request;
    struct unmap_view_request unmap_view_request;
    struct get_mapping_committed_range_request get_mapping_committed_range_request;
    struct add_mapping_committed_range_request add_mapping_committed_range_request;
    struct is_same_mapping_request is_same_mapping_request;
    struct get_mapping_filename_request get_mapping_filename_request;
    struct list_processes_request list_processes_request;
    struct create_debug_obj_request create_debug_obj_request;
    struct wait_debug_event_request wait_debug_event_request;
    struct queue_exception_event_request queue_exception_event_request;
    struct get_exception_status_request get_exception_status_request;
    struct continue_debug_event_request continue_debug_event_request;
    struct debug_process_request debug_process_request;
    struct set_debug_obj_info_request set_debug_obj_info_request;
    struct read_process_memory_request read_process_memory_request;
    struct write_process_memory_request write_process_memory_request;
    struct create_key_request create_key_request;
    struct open_key_request open_key_request;
    struct delete_key_request delete_key_request;
    struct flush_key_request flush_key_request;
    struct enum_key_request enum_key_request;
    struct set_key_value_request set_key_value_request;
    struct get_key_value_request get_key_value_request;
    struct enum_key_value_request enum_key_value_request;
    struct delete_key_value_request delete_key_value_request;
    struct load_registry_request load_registry_request;
    struct unload_registry_request unload_registry_request;
    struct save_registry_request save_registry_request;
    struct set_registry_notification_request set_registry_notification_request;
    struct rename_key_request rename_key_request;
    struct create_timer_request create_timer_request;
    struct open_timer_request open_timer_request;
    struct set_timer_request set_timer_request;
    struct cancel_timer_request cancel_timer_request;
    struct get_timer_info_request get_timer_info_request;
    struct get_thread_context_request get_thread_context_request;
    struct set_thread_context_request set_thread_context_request;
    struct add_atom_request add_atom_request;
    struct delete_atom_request delete_atom_request;
    struct find_atom_request find_atom_request;
    struct get_atom_information_request get_atom_information_request;
    struct add_user_atom_request add_user_atom_request;
    struct get_user_atom_name_request get_user_atom_name_request;
    struct get_msg_queue_handle_request get_msg_queue_handle_request;
    struct get_msg_queue_request get_msg_queue_request;
    struct set_queue_fd_request set_queue_fd_request;
    struct set_queue_mask_request set_queue_mask_request;
    struct get_queue_status_request get_queue_status_request;
    struct get_process_idle_event_request get_process_idle_event_request;
    struct send_message_request send_message_request;
    struct post_quit_message_request post_quit_message_request;
    struct send_hardware_message_request send_hardware_message_request;
    struct get_message_request get_message_request;
    struct reply_message_request reply_message_request;
    struct accept_hardware_message_request accept_hardware_message_request;
    struct get_message_reply_request get_message_reply_request;
    struct set_win_timer_request set_win_timer_request;
    struct kill_win_timer_request kill_win_timer_request;
    struct is_window_hung_request is_window_hung_request;
    struct get_serial_info_request get_serial_info_request;
    struct set_serial_info_request set_serial_info_request;
    struct cancel_sync_request cancel_sync_request;
    struct register_async_request register_async_request;
    struct cancel_async_request cancel_async_request;
    struct get_async_result_request get_async_result_request;
    struct set_async_direct_result_request set_async_direct_result_request;
    struct read_request read_request;
    struct write_request write_request;
    struct ioctl_request ioctl_request;
    struct set_irp_result_request set_irp_result_request;
    struct create_named_pipe_request create_named_pipe_request;
    struct set_named_pipe_info_request set_named_pipe_info_request;
    struct create_window_request create_window_request;
    struct destroy_window_request destroy_window_request;
    struct get_desktop_window_request get_desktop_window_request;
    struct set_window_owner_request set_window_owner_request;
    struct get_window_info_request get_window_info_request;
    struct init_window_info_request init_window_info_request;
    struct set_window_info_request set_window_info_request;
    struct set_parent_request set_parent_request;
    struct get_window_parents_request get_window_parents_request;
    struct get_window_list_request get_window_list_request;
    struct get_class_windows_request get_class_windows_request;
    struct get_window_children_from_point_request get_window_children_from_point_request;
    struct get_window_tree_request get_window_tree_request;
    struct set_window_pos_request set_window_pos_request;
    struct get_window_rectangles_request get_window_rectangles_request;
    struct get_window_text_request get_window_text_request;
    struct set_window_text_request set_window_text_request;
    struct get_windows_offset_request get_windows_offset_request;
    struct get_visible_region_request get_visible_region_request;
    struct get_window_region_request get_window_region_request;
    struct set_window_region_request set_window_region_request;
    struct get_update_region_request get_update_region_request;
    struct update_window_zorder_request update_window_zorder_request;
    struct redraw_window_request redraw_window_request;
    struct set_window_property_request set_window_property_request;
    struct remove_window_property_request remove_window_property_request;
    struct get_window_property_request get_window_property_request;
    struct get_window_properties_request get_window_properties_request;
    struct create_winstation_request create_winstation_request;
    struct open_winstation_request open_winstation_request;
    struct close_winstation_request close_winstation_request;
    struct set_winstation_monitors_request set_winstation_monitors_request;
    struct get_process_winstation_request get_process_winstation_request;
    struct set_process_winstation_request set_process_winstation_request;
    struct enum_winstation_request enum_winstation_request;
    struct create_desktop_request create_desktop_request;
    struct open_desktop_request open_desktop_request;
    struct open_input_desktop_request open_input_desktop_request;
    struct set_input_desktop_request set_input_desktop_request;
    struct close_desktop_request close_desktop_request;
    struct get_thread_desktop_request get_thread_desktop_request;
    struct set_thread_desktop_request set_thread_desktop_request;
    struct set_user_object_info_request set_user_object_info_request;
    struct register_hotkey_request register_hotkey_request;
    struct unregister_hotkey_request unregister_hotkey_request;
    struct attach_thread_input_request attach_thread_input_request;
    struct get_thread_input_request get_thread_input_request;
    struct get_last_input_time_request get_last_input_time_request;
    struct get_key_state_request get_key_state_request;
    struct set_key_state_request set_key_state_request;
    struct set_foreground_window_request set_foreground_window_request;
    struct set_focus_window_request set_focus_window_request;
    struct set_active_window_request set_active_window_request;
    struct set_capture_window_request set_capture_window_request;
    struct set_caret_window_request set_caret_window_request;
    struct set_caret_info_request set_caret_info_request;
    struct set_hook_request set_hook_request;
    struct remove_hook_request remove_hook_request;
    struct start_hook_chain_request start_hook_chain_request;
    struct finish_hook_chain_request finish_hook_chain_request;
    struct get_hook_info_request get_hook_info_request;
    struct create_class_request create_class_request;
    struct destroy_class_request destroy_class_request;
    struct set_class_info_request set_class_info_request;
    struct get_class_info_request get_class_info_request;
    struct open_clipboard_request open_clipboard_request;
    struct close_clipboard_request close_clipboard_request;
    struct empty_clipboard_request empty_clipboard_request;
    struct set_clipboard_data_request set_clipboard_data_request;
    struct get_clipboard_data_request get_clipboard_data_request;
    struct get_clipboard_formats_request get_clipboard_formats_request;
    struct enum_clipboard_formats_request enum_clipboard_formats_request;
    struct release_clipboard_request release_clipboard_request;
    struct get_clipboard_info_request get_clipboard_info_request;
    struct set_clipboard_viewer_request set_clipboard_viewer_request;
    struct add_clipboard_listener_request add_clipboard_listener_request;
    struct remove_clipboard_listener_request remove_clipboard_listener_request;
    struct create_token_request create_token_request;
    struct open_token_request open_token_request;
    struct set_desktop_shell_windows_request set_desktop_shell_windows_request;
    struct adjust_token_privileges_request adjust_token_privileges_request;
    struct get_token_privileges_request get_token_privileges_request;
    struct check_token_privileges_request check_token_privileges_request;
    struct duplicate_token_request duplicate_token_request;
    struct filter_token_request filter_token_request;
    struct access_check_request access_check_request;
    struct get_token_sid_request get_token_sid_request;
    struct get_token_groups_request get_token_groups_request;
    struct get_token_default_dacl_request get_token_default_dacl_request;
    struct set_token_default_dacl_request set_token_default_dacl_request;
    struct set_security_object_request set_security_object_request;
    struct get_security_object_request get_security_object_request;
    struct get_system_handles_request get_system_handles_request;
    struct get_tcp_connections_request get_tcp_connections_request;
    struct get_udp_endpoints_request get_udp_endpoints_request;
    struct create_mailslot_request create_mailslot_request;
    struct set_mailslot_info_request set_mailslot_info_request;
    struct create_directory_request create_directory_request;
    struct open_directory_request open_directory_request;
    struct get_directory_entries_request get_directory_entries_request;
    struct create_symlink_request create_symlink_request;
    struct open_symlink_request open_symlink_request;
    struct query_symlink_request query_symlink_request;
    struct get_object_info_request get_object_info_request;
    struct get_object_name_request get_object_name_request;
    struct get_object_type_request get_object_type_request;
    struct get_object_types_request get_object_types_request;
    struct allocate_locally_unique_id_request allocate_locally_unique_id_request;
    struct create_device_manager_request create_device_manager_request;
    struct create_device_request create_device_request;
    struct delete_device_request delete_device_request;
    struct get_next_device_request_request get_next_device_request_request;
    struct get_kernel_object_ptr_request get_kernel_object_ptr_request;
    struct set_kernel_object_ptr_request set_kernel_object_ptr_request;
    struct grab_kernel_object_request grab_kernel_object_request;
    struct release_kernel_object_request release_kernel_object_request;
    struct get_kernel_object_handle_request get_kernel_object_handle_request;
    struct make_process_system_request make_process_system_request;
    struct grant_process_admin_token_request grant_process_admin_token_request;
    struct get_token_info_request get_token_info_request;
    struct create_linked_token_request create_linked_token_request;
    struct create_completion_request create_completion_request;
    struct open_completion_request open_completion_request;
    struct add_completion_request add_completion_request;
    struct remove_completion_request remove_completion_request;
    struct get_thread_completion_request get_thread_completion_request;
    struct query_completion_request query_completion_request;
    struct set_completion_info_request set_completion_info_request;
    struct add_fd_completion_request add_fd_completion_request;
    struct set_fd_completion_mode_request set_fd_completion_mode_request;
    struct set_fd_disp_info_request set_fd_disp_info_request;
    struct set_fd_name_info_request set_fd_name_info_request;
    struct set_fd_eof_info_request set_fd_eof_info_request;
    struct get_window_layered_info_request get_window_layered_info_request;
    struct set_window_layered_info_request set_window_layered_info_request;
    struct alloc_user_handle_request alloc_user_handle_request;
    struct free_user_handle_request free_user_handle_request;
    struct set_cursor_request set_cursor_request;
    struct get_cursor_history_request get_cursor_history_request;
    struct get_rawinput_buffer_request get_rawinput_buffer_request;
    struct update_rawinput_devices_request update_rawinput_devices_request;
    struct create_job_request create_job_request;
    struct open_job_request open_job_request;
    struct assign_job_request assign_job_request;
    struct process_in_job_request process_in_job_request;
    struct set_job_limits_request set_job_limits_request;
    struct set_job_completion_port_request set_job_completion_port_request;
    struct get_job_info_request get_job_info_request;
    struct terminate_job_request terminate_job_request;
    struct suspend_process_request suspend_process_request;
    struct resume_process_request resume_process_request;
    struct get_next_process_request get_next_process_request;
    struct get_next_thread_request get_next_thread_request;
    struct set_keyboard_repeat_request set_keyboard_repeat_request;
    struct get_inproc_sync_fd_request get_inproc_sync_fd_request;
    struct get_inproc_alert_fd_request get_inproc_alert_fd_request;
    struct d3dkmt_object_create_request d3dkmt_object_create_request;
    struct d3dkmt_object_update_request d3dkmt_object_update_request;
    struct d3dkmt_object_query_request d3dkmt_object_query_request;
    struct d3dkmt_object_open_request d3dkmt_object_open_request;
    struct d3dkmt_share_objects_request d3dkmt_share_objects_request;
    struct d3dkmt_object_open_name_request d3dkmt_object_open_name_request;
    struct d3dkmt_mutex_acquire_request d3dkmt_mutex_acquire_request;
    struct d3dkmt_mutex_release_request d3dkmt_mutex_release_request;
};
union generic_reply
{
    struct request_max_size max_size;
    struct reply_header reply_header;
    struct new_process_reply new_process_reply;
    struct get_new_process_info_reply get_new_process_info_reply;
    struct new_thread_reply new_thread_reply;
    struct get_startup_info_reply get_startup_info_reply;
    struct init_process_done_reply init_process_done_reply;
    struct init_first_thread_reply init_first_thread_reply;
    struct init_thread_reply init_thread_reply;
    struct terminate_process_reply terminate_process_reply;
    struct terminate_thread_reply terminate_thread_reply;
    struct get_process_info_reply get_process_info_reply;
    struct get_process_debug_info_reply get_process_debug_info_reply;
    struct get_process_image_name_reply get_process_image_name_reply;
    struct get_process_vm_counters_reply get_process_vm_counters_reply;
    struct set_process_info_reply set_process_info_reply;
    struct get_thread_info_reply get_thread_info_reply;
    struct get_thread_times_reply get_thread_times_reply;
    struct set_thread_info_reply set_thread_info_reply;
    struct suspend_thread_reply suspend_thread_reply;
    struct resume_thread_reply resume_thread_reply;
    struct queue_apc_reply queue_apc_reply;
    struct get_apc_result_reply get_apc_result_reply;
    struct close_handle_reply close_handle_reply;
    struct set_handle_info_reply set_handle_info_reply;
    struct dup_handle_reply dup_handle_reply;
    struct allocate_reserve_object_reply allocate_reserve_object_reply;
    struct compare_objects_reply compare_objects_reply;
    struct set_object_permanence_reply set_object_permanence_reply;
    struct open_process_reply open_process_reply;
    struct open_thread_reply open_thread_reply;
    struct select_reply select_reply;
    struct create_event_reply create_event_reply;
    struct event_op_reply event_op_reply;
    struct query_event_reply query_event_reply;
    struct open_event_reply open_event_reply;
    struct create_keyed_event_reply create_keyed_event_reply;
    struct open_keyed_event_reply open_keyed_event_reply;
    struct create_mutex_reply create_mutex_reply;
    struct release_mutex_reply release_mutex_reply;
    struct open_mutex_reply open_mutex_reply;
    struct query_mutex_reply query_mutex_reply;
    struct create_semaphore_reply create_semaphore_reply;
    struct release_semaphore_reply release_semaphore_reply;
    struct query_semaphore_reply query_semaphore_reply;
    struct open_semaphore_reply open_semaphore_reply;
    struct create_file_reply create_file_reply;
    struct open_file_object_reply open_file_object_reply;
    struct alloc_file_handle_reply alloc_file_handle_reply;
    struct get_handle_unix_name_reply get_handle_unix_name_reply;
    struct get_handle_fd_reply get_handle_fd_reply;
    struct get_directory_cache_entry_reply get_directory_cache_entry_reply;
    struct flush_reply flush_reply;
    struct get_file_info_reply get_file_info_reply;
    struct get_volume_info_reply get_volume_info_reply;
    struct lock_file_reply lock_file_reply;
    struct unlock_file_reply unlock_file_reply;
    struct recv_socket_reply recv_socket_reply;
    struct send_socket_reply send_socket_reply;
    struct socket_get_events_reply socket_get_events_reply;
    struct socket_send_icmp_id_reply socket_send_icmp_id_reply;
    struct socket_get_icmp_id_reply socket_get_icmp_id_reply;
    struct get_next_console_request_reply get_next_console_request_reply;
    struct read_directory_changes_reply read_directory_changes_reply;
    struct read_change_reply read_change_reply;
    struct create_mapping_reply create_mapping_reply;
    struct open_mapping_reply open_mapping_reply;
    struct get_mapping_info_reply get_mapping_info_reply;
    struct get_image_map_address_reply get_image_map_address_reply;
    struct map_view_reply map_view_reply;
    struct map_image_view_reply map_image_view_reply;
    struct map_builtin_view_reply map_builtin_view_reply;
    struct get_image_view_info_reply get_image_view_info_reply;
    struct unmap_view_reply unmap_view_reply;
    struct get_mapping_committed_range_reply get_mapping_committed_range_reply;
    struct add_mapping_committed_range_reply add_mapping_committed_range_reply;
    struct is_same_mapping_reply is_same_mapping_reply;
    struct get_mapping_filename_reply get_mapping_filename_reply;
    struct list_processes_reply list_processes_reply;
    struct create_debug_obj_reply create_debug_obj_reply;
    struct wait_debug_event_reply wait_debug_event_reply;
    struct queue_exception_event_reply queue_exception_event_reply;
    struct get_exception_status_reply get_exception_status_reply;
    struct continue_debug_event_reply continue_debug_event_reply;
    struct debug_process_reply debug_process_reply;
    struct set_debug_obj_info_reply set_debug_obj_info_reply;
    struct read_process_memory_reply read_process_memory_reply;
    struct write_process_memory_reply write_process_memory_reply;
    struct create_key_reply create_key_reply;
    struct open_key_reply open_key_reply;
    struct delete_key_reply delete_key_reply;
    struct flush_key_reply flush_key_reply;
    struct enum_key_reply enum_key_reply;
    struct set_key_value_reply set_key_value_reply;
    struct get_key_value_reply get_key_value_reply;
    struct enum_key_value_reply enum_key_value_reply;
    struct delete_key_value_reply delete_key_value_reply;
    struct load_registry_reply load_registry_reply;
    struct unload_registry_reply unload_registry_reply;
    struct save_registry_reply save_registry_reply;
    struct set_registry_notification_reply set_registry_notification_reply;
    struct rename_key_reply rename_key_reply;
    struct create_timer_reply create_timer_reply;
    struct open_timer_reply open_timer_reply;
    struct set_timer_reply set_timer_reply;
    struct cancel_timer_reply cancel_timer_reply;
    struct get_timer_info_reply get_timer_info_reply;
    struct get_thread_context_reply get_thread_context_reply;
    struct set_thread_context_reply set_thread_context_reply;
    struct add_atom_reply add_atom_reply;
    struct delete_atom_reply delete_atom_reply;
    struct find_atom_reply find_atom_reply;
    struct get_atom_information_reply get_atom_information_reply;
    struct add_user_atom_reply add_user_atom_reply;
    struct get_user_atom_name_reply get_user_atom_name_reply;
    struct get_msg_queue_handle_reply get_msg_queue_handle_reply;
    struct get_msg_queue_reply get_msg_queue_reply;
    struct set_queue_fd_reply set_queue_fd_reply;
    struct set_queue_mask_reply set_queue_mask_reply;
    struct get_queue_status_reply get_queue_status_reply;
    struct get_process_idle_event_reply get_process_idle_event_reply;
    struct send_message_reply send_message_reply;
    struct post_quit_message_reply post_quit_message_reply;
    struct send_hardware_message_reply send_hardware_message_reply;
    struct get_message_reply get_message_reply;
    struct reply_message_reply reply_message_reply;
    struct accept_hardware_message_reply accept_hardware_message_reply;
    struct get_message_reply_reply get_message_reply_reply;
    struct set_win_timer_reply set_win_timer_reply;
    struct kill_win_timer_reply kill_win_timer_reply;
    struct is_window_hung_reply is_window_hung_reply;
    struct get_serial_info_reply get_serial_info_reply;
    struct set_serial_info_reply set_serial_info_reply;
    struct cancel_sync_reply cancel_sync_reply;
    struct register_async_reply register_async_reply;
    struct cancel_async_reply cancel_async_reply;
    struct get_async_result_reply get_async_result_reply;
    struct set_async_direct_result_reply set_async_direct_result_reply;
    struct read_reply read_reply;
    struct write_reply write_reply;
    struct ioctl_reply ioctl_reply;
    struct set_irp_result_reply set_irp_result_reply;
    struct create_named_pipe_reply create_named_pipe_reply;
    struct set_named_pipe_info_reply set_named_pipe_info_reply;
    struct create_window_reply create_window_reply;
    struct destroy_window_reply destroy_window_reply;
    struct get_desktop_window_reply get_desktop_window_reply;
    struct set_window_owner_reply set_window_owner_reply;
    struct get_window_info_reply get_window_info_reply;
    struct init_window_info_reply init_window_info_reply;
    struct set_window_info_reply set_window_info_reply;
    struct set_parent_reply set_parent_reply;
    struct get_window_parents_reply get_window_parents_reply;
    struct get_window_list_reply get_window_list_reply;
    struct get_class_windows_reply get_class_windows_reply;
    struct get_window_children_from_point_reply get_window_children_from_point_reply;
    struct get_window_tree_reply get_window_tree_reply;
    struct set_window_pos_reply set_window_pos_reply;
    struct get_window_rectangles_reply get_window_rectangles_reply;
    struct get_window_text_reply get_window_text_reply;
    struct set_window_text_reply set_window_text_reply;
    struct get_windows_offset_reply get_windows_offset_reply;
    struct get_visible_region_reply get_visible_region_reply;
    struct get_window_region_reply get_window_region_reply;
    struct set_window_region_reply set_window_region_reply;
    struct get_update_region_reply get_update_region_reply;
    struct update_window_zorder_reply update_window_zorder_reply;
    struct redraw_window_reply redraw_window_reply;
    struct set_window_property_reply set_window_property_reply;
    struct remove_window_property_reply remove_window_property_reply;
    struct get_window_property_reply get_window_property_reply;
    struct get_window_properties_reply get_window_properties_reply;
    struct create_winstation_reply create_winstation_reply;
    struct open_winstation_reply open_winstation_reply;
    struct close_winstation_reply close_winstation_reply;
    struct set_winstation_monitors_reply set_winstation_monitors_reply;
    struct get_process_winstation_reply get_process_winstation_reply;
    struct set_process_winstation_reply set_process_winstation_reply;
    struct enum_winstation_reply enum_winstation_reply;
    struct create_desktop_reply create_desktop_reply;
    struct open_desktop_reply open_desktop_reply;
    struct open_input_desktop_reply open_input_desktop_reply;
    struct set_input_desktop_reply set_input_desktop_reply;
    struct close_desktop_reply close_desktop_reply;
    struct get_thread_desktop_reply get_thread_desktop_reply;
    struct set_thread_desktop_reply set_thread_desktop_reply;
    struct set_user_object_info_reply set_user_object_info_reply;
    struct register_hotkey_reply register_hotkey_reply;
    struct unregister_hotkey_reply unregister_hotkey_reply;
    struct attach_thread_input_reply attach_thread_input_reply;
    struct get_thread_input_reply get_thread_input_reply;
    struct get_last_input_time_reply get_last_input_time_reply;
    struct get_key_state_reply get_key_state_reply;
    struct set_key_state_reply set_key_state_reply;
    struct set_foreground_window_reply set_foreground_window_reply;
    struct set_focus_window_reply set_focus_window_reply;
    struct set_active_window_reply set_active_window_reply;
    struct set_capture_window_reply set_capture_window_reply;
    struct set_caret_window_reply set_caret_window_reply;
    struct set_caret_info_reply set_caret_info_reply;
    struct set_hook_reply set_hook_reply;
    struct remove_hook_reply remove_hook_reply;
    struct start_hook_chain_reply start_hook_chain_reply;
    struct finish_hook_chain_reply finish_hook_chain_reply;
    struct get_hook_info_reply get_hook_info_reply;
    struct create_class_reply create_class_reply;
    struct destroy_class_reply destroy_class_reply;
    struct set_class_info_reply set_class_info_reply;
    struct get_class_info_reply get_class_info_reply;
    struct open_clipboard_reply open_clipboard_reply;
    struct close_clipboard_reply close_clipboard_reply;
    struct empty_clipboard_reply empty_clipboard_reply;
    struct set_clipboard_data_reply set_clipboard_data_reply;
    struct get_clipboard_data_reply get_clipboard_data_reply;
    struct get_clipboard_formats_reply get_clipboard_formats_reply;
    struct enum_clipboard_formats_reply enum_clipboard_formats_reply;
    struct release_clipboard_reply release_clipboard_reply;
    struct get_clipboard_info_reply get_clipboard_info_reply;
    struct set_clipboard_viewer_reply set_clipboard_viewer_reply;
    struct add_clipboard_listener_reply add_clipboard_listener_reply;
    struct remove_clipboard_listener_reply remove_clipboard_listener_reply;
    struct create_token_reply create_token_reply;
    struct open_token_reply open_token_reply;
    struct set_desktop_shell_windows_reply set_desktop_shell_windows_reply;
    struct adjust_token_privileges_reply adjust_token_privileges_reply;
    struct get_token_privileges_reply get_token_privileges_reply;
    struct check_token_privileges_reply check_token_privileges_reply;
    struct duplicate_token_reply duplicate_token_reply;
    struct filter_token_reply filter_token_reply;
    struct access_check_reply access_check_reply;
    struct get_token_sid_reply get_token_sid_reply;
    struct get_token_groups_reply get_token_groups_reply;
    struct get_token_default_dacl_reply get_token_default_dacl_reply;
    struct set_token_default_dacl_reply set_token_default_dacl_reply;
    struct set_security_object_reply set_security_object_reply;
    struct get_security_object_reply get_security_object_reply;
    struct get_system_handles_reply get_system_handles_reply;
    struct get_tcp_connections_reply get_tcp_connections_reply;
    struct get_udp_endpoints_reply get_udp_endpoints_reply;
    struct create_mailslot_reply create_mailslot_reply;
    struct set_mailslot_info_reply set_mailslot_info_reply;
    struct create_directory_reply create_directory_reply;
    struct open_directory_reply open_directory_reply;
    struct get_directory_entries_reply get_directory_entries_reply;
    struct create_symlink_reply create_symlink_reply;
    struct open_symlink_reply open_symlink_reply;
    struct query_symlink_reply query_symlink_reply;
    struct get_object_info_reply get_object_info_reply;
    struct get_object_name_reply get_object_name_reply;
    struct get_object_type_reply get_object_type_reply;
    struct get_object_types_reply get_object_types_reply;
    struct allocate_locally_unique_id_reply allocate_locally_unique_id_reply;
    struct create_device_manager_reply create_device_manager_reply;
    struct create_device_reply create_device_reply;
    struct delete_device_reply delete_device_reply;
    struct get_next_device_request_reply get_next_device_request_reply;
    struct get_kernel_object_ptr_reply get_kernel_object_ptr_reply;
    struct set_kernel_object_ptr_reply set_kernel_object_ptr_reply;
    struct grab_kernel_object_reply grab_kernel_object_reply;
    struct release_kernel_object_reply release_kernel_object_reply;
    struct get_kernel_object_handle_reply get_kernel_object_handle_reply;
    struct make_process_system_reply make_process_system_reply;
    struct grant_process_admin_token_reply grant_process_admin_token_reply;
    struct get_token_info_reply get_token_info_reply;
    struct create_linked_token_reply create_linked_token_reply;
    struct create_completion_reply create_completion_reply;
    struct open_completion_reply open_completion_reply;
    struct add_completion_reply add_completion_reply;
    struct remove_completion_reply remove_completion_reply;
    struct get_thread_completion_reply get_thread_completion_reply;
    struct query_completion_reply query_completion_reply;
    struct set_completion_info_reply set_completion_info_reply;
    struct add_fd_completion_reply add_fd_completion_reply;
    struct set_fd_completion_mode_reply set_fd_completion_mode_reply;
    struct set_fd_disp_info_reply set_fd_disp_info_reply;
    struct set_fd_name_info_reply set_fd_name_info_reply;
    struct set_fd_eof_info_reply set_fd_eof_info_reply;
    struct get_window_layered_info_reply get_window_layered_info_reply;
    struct set_window_layered_info_reply set_window_layered_info_reply;
    struct alloc_user_handle_reply alloc_user_handle_reply;
    struct free_user_handle_reply free_user_handle_reply;
    struct set_cursor_reply set_cursor_reply;
    struct get_cursor_history_reply get_cursor_history_reply;
    struct get_rawinput_buffer_reply get_rawinput_buffer_reply;
    struct update_rawinput_devices_reply update_rawinput_devices_reply;
    struct create_job_reply create_job_reply;
    struct open_job_reply open_job_reply;
    struct assign_job_reply assign_job_reply;
    struct process_in_job_reply process_in_job_reply;
    struct set_job_limits_reply set_job_limits_reply;
    struct set_job_completion_port_reply set_job_completion_port_reply;
    struct get_job_info_reply get_job_info_reply;
    struct terminate_job_reply terminate_job_reply;
    struct suspend_process_reply suspend_process_reply;
    struct resume_process_reply resume_process_reply;
    struct get_next_process_reply get_next_process_reply;
    struct get_next_thread_reply get_next_thread_reply;
    struct set_keyboard_repeat_reply set_keyboard_repeat_reply;
    struct get_inproc_sync_fd_reply get_inproc_sync_fd_reply;
    struct get_inproc_alert_fd_reply get_inproc_alert_fd_reply;
    struct d3dkmt_object_create_reply d3dkmt_object_create_reply;
    struct d3dkmt_object_update_reply d3dkmt_object_update_reply;
    struct d3dkmt_object_query_reply d3dkmt_object_query_reply;
    struct d3dkmt_object_open_reply d3dkmt_object_open_reply;
    struct d3dkmt_share_objects_reply d3dkmt_share_objects_reply;
    struct d3dkmt_object_open_name_reply d3dkmt_object_open_name_reply;
    struct d3dkmt_mutex_acquire_reply d3dkmt_mutex_acquire_reply;
    struct d3dkmt_mutex_release_reply d3dkmt_mutex_release_reply;
};

#define SERVER_PROTOCOL_VERSION 930

#endif /* __WINE_WINE_SERVER_PROTOCOL_H */
