﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codecommit/model/DescribeMergeConflictsRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::CodeCommit::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DescribeMergeConflictsRequest::SerializePayload() const {
  JsonValue payload;

  if (m_repositoryNameHasBeenSet) {
    payload.WithString("repositoryName", m_repositoryName);
  }

  if (m_destinationCommitSpecifierHasBeenSet) {
    payload.WithString("destinationCommitSpecifier", m_destinationCommitSpecifier);
  }

  if (m_sourceCommitSpecifierHasBeenSet) {
    payload.WithString("sourceCommitSpecifier", m_sourceCommitSpecifier);
  }

  if (m_mergeOptionHasBeenSet) {
    payload.WithString("mergeOption", MergeOptionTypeEnumMapper::GetNameForMergeOptionTypeEnum(m_mergeOption));
  }

  if (m_maxMergeHunksHasBeenSet) {
    payload.WithInteger("maxMergeHunks", m_maxMergeHunks);
  }

  if (m_filePathHasBeenSet) {
    payload.WithString("filePath", m_filePath);
  }

  if (m_conflictDetailLevelHasBeenSet) {
    payload.WithString("conflictDetailLevel",
                       ConflictDetailLevelTypeEnumMapper::GetNameForConflictDetailLevelTypeEnum(m_conflictDetailLevel));
  }

  if (m_conflictResolutionStrategyHasBeenSet) {
    payload.WithString("conflictResolutionStrategy", ConflictResolutionStrategyTypeEnumMapper::GetNameForConflictResolutionStrategyTypeEnum(
                                                         m_conflictResolutionStrategy));
  }

  if (m_nextTokenHasBeenSet) {
    payload.WithString("nextToken", m_nextToken);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DescribeMergeConflictsRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "CodeCommit_20150413.DescribeMergeConflicts"));
  return headers;
}
