﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/braket/model/GetJobResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Braket::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetJobResult::GetJobResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

GetJobResult& GetJobResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("status")) {
    m_status = JobPrimaryStatusMapper::GetJobPrimaryStatusForName(jsonValue.GetString("status"));
    m_statusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("jobArn")) {
    m_jobArn = jsonValue.GetString("jobArn");
    m_jobArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("roleArn")) {
    m_roleArn = jsonValue.GetString("roleArn");
    m_roleArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("failureReason")) {
    m_failureReason = jsonValue.GetString("failureReason");
    m_failureReasonHasBeenSet = true;
  }
  if (jsonValue.ValueExists("jobName")) {
    m_jobName = jsonValue.GetString("jobName");
    m_jobNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("hyperParameters")) {
    Aws::Map<Aws::String, JsonView> hyperParametersJsonMap = jsonValue.GetObject("hyperParameters").GetAllObjects();
    for (auto& hyperParametersItem : hyperParametersJsonMap) {
      m_hyperParameters[hyperParametersItem.first] = hyperParametersItem.second.AsString();
    }
    m_hyperParametersHasBeenSet = true;
  }
  if (jsonValue.ValueExists("inputDataConfig")) {
    Aws::Utils::Array<JsonView> inputDataConfigJsonList = jsonValue.GetArray("inputDataConfig");
    for (unsigned inputDataConfigIndex = 0; inputDataConfigIndex < inputDataConfigJsonList.GetLength(); ++inputDataConfigIndex) {
      m_inputDataConfig.push_back(inputDataConfigJsonList[inputDataConfigIndex].AsObject());
    }
    m_inputDataConfigHasBeenSet = true;
  }
  if (jsonValue.ValueExists("outputDataConfig")) {
    m_outputDataConfig = jsonValue.GetObject("outputDataConfig");
    m_outputDataConfigHasBeenSet = true;
  }
  if (jsonValue.ValueExists("stoppingCondition")) {
    m_stoppingCondition = jsonValue.GetObject("stoppingCondition");
    m_stoppingConditionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("checkpointConfig")) {
    m_checkpointConfig = jsonValue.GetObject("checkpointConfig");
    m_checkpointConfigHasBeenSet = true;
  }
  if (jsonValue.ValueExists("algorithmSpecification")) {
    m_algorithmSpecification = jsonValue.GetObject("algorithmSpecification");
    m_algorithmSpecificationHasBeenSet = true;
  }
  if (jsonValue.ValueExists("instanceConfig")) {
    m_instanceConfig = jsonValue.GetObject("instanceConfig");
    m_instanceConfigHasBeenSet = true;
  }
  if (jsonValue.ValueExists("createdAt")) {
    m_createdAt = jsonValue.GetString("createdAt");
    m_createdAtHasBeenSet = true;
  }
  if (jsonValue.ValueExists("startedAt")) {
    m_startedAt = jsonValue.GetString("startedAt");
    m_startedAtHasBeenSet = true;
  }
  if (jsonValue.ValueExists("endedAt")) {
    m_endedAt = jsonValue.GetString("endedAt");
    m_endedAtHasBeenSet = true;
  }
  if (jsonValue.ValueExists("billableDuration")) {
    m_billableDuration = jsonValue.GetInteger("billableDuration");
    m_billableDurationHasBeenSet = true;
  }
  if (jsonValue.ValueExists("deviceConfig")) {
    m_deviceConfig = jsonValue.GetObject("deviceConfig");
    m_deviceConfigHasBeenSet = true;
  }
  if (jsonValue.ValueExists("events")) {
    Aws::Utils::Array<JsonView> eventsJsonList = jsonValue.GetArray("events");
    for (unsigned eventsIndex = 0; eventsIndex < eventsJsonList.GetLength(); ++eventsIndex) {
      m_events.push_back(eventsJsonList[eventsIndex].AsObject());
    }
    m_eventsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("tags")) {
    Aws::Map<Aws::String, JsonView> tagsJsonMap = jsonValue.GetObject("tags").GetAllObjects();
    for (auto& tagsItem : tagsJsonMap) {
      m_tags[tagsItem.first] = tagsItem.second.AsString();
    }
    m_tagsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("queueInfo")) {
    m_queueInfo = jsonValue.GetObject("queueInfo");
    m_queueInfoHasBeenSet = true;
  }
  if (jsonValue.ValueExists("associations")) {
    Aws::Utils::Array<JsonView> associationsJsonList = jsonValue.GetArray("associations");
    for (unsigned associationsIndex = 0; associationsIndex < associationsJsonList.GetLength(); ++associationsIndex) {
      m_associations.push_back(associationsJsonList[associationsIndex].AsObject());
    }
    m_associationsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
