/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.sse.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.sse.OutboundSseEvent;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.events.Event;
import org.openhab.core.io.rest.sse.internal.dto.EventDTO;

@NonNullByDefault
public class SseUtil {
    static final String TOPIC_VALIDATE_PATTERN = "(\\w*\\*?\\/?,?:?-?\\s*)*";

    public static EventDTO buildDTO(Event event) {
        EventDTO dto = new EventDTO();
        dto.topic = event.getTopic();
        dto.type = event.getType();
        dto.payload = event.getPayload();
        return dto;
    }

    public static OutboundSseEvent buildEvent(OutboundSseEvent.Builder eventBuilder, EventDTO event) {
        return eventBuilder.name("message").mediaType(MediaType.APPLICATION_JSON_TYPE).data((Object)event).build();
    }

    public static boolean isValidTopicFilter(@Nullable String topicFilter) {
        return topicFilter == null || topicFilter.isEmpty() || topicFilter.matches(TOPIC_VALIDATE_PATTERN);
    }

    public static List<String> convertToRegex(@Nullable String topicFilter) {
        ArrayList<String> filters = new ArrayList<String>();
        if (topicFilter == null || topicFilter.isEmpty()) {
            filters.add(".*");
        } else {
            StringTokenizer tokenizer = new StringTokenizer(topicFilter, ",");
            while (tokenizer.hasMoreElements()) {
                String regex = tokenizer.nextToken().trim().replace("*", ".*") + "$";
                filters.add(regex);
            }
        }
        return filters;
    }
}

