# Часто задаваемые вопросы

## Какая конфигурация используется в демо-GIF?

- **Эмулятор терминала**: [iTerm2](https://iterm2.com/)
  - **Тема**: Minimal
  - **Цветовая схема**: [Snazzy](https://github.com/sindresorhus/iterm2-snazzy)
  - **Шрифт**: [FiraCode Nerd Font](https://www.nerdfonts.com/font-downloads)
- **Командная оболочка**: [Fish Shell](https://fishshell.com/)
  - **Конфигурация**: [matchai's Dotfiles](https://github.com/matchai/dotfiles/blob/b6c6a701d0af8d145a8370288c00bb9f0648b5c2/.config/fish/config.fish)
  - **Подсказка**: [Starship](https://starship.rs/)

## Как мне получить автодополнение команд, как показано на демонстрационной GIF?

Автодополнение команд обеспечивается выбранной вами оболочкой. В данном случае, демо было выполнено с [Fish Shell](https://fishshell.com/), которая обеспечивает дополнения по умолчанию. Если вы используете Z Shell (zsh), я бы посоветовал взглянуть на [zsh-autosuggestions](https://github.com/zsh-users/zsh-autosuggestions).

## Выполните `format` верхнего уровня и `<module>.disabled` одно и то же?

Да, они могут быть использованы для отключения модулей в подсказке. Если всё, что вы хотите сделать - это отключить модули, `<module>.disabled` - предпочитаемый способ сделать это по следующим причинам:

- Отключение модулей является более явным, чем их исключение из `format` верхнего уровня
- Новосозданные модули будут добавлены в подсказку по мере обновления Starship

## Доки говорят, что Starship поддерживается на всех оболочках *(cross-shell)*. Почему моя любимая оболочка не поддерживается?

Starship устроен так, что есть возможность добавить поддержку практически любой оболочки. Бинарный файл Starship не зависит от оболочки и не имеет состояния, так что если ваша оболочка поддерживает расширение подстрок и настройку подсказки, то Starship может быть использован.

Вот небольшой пример работы Starship с bash:

```sh
# Get the status code from the last command executed
STATUS=$?

# Get the number of jobs running.
NUM_JOBS=$(jobs -p | wc -l)

# Установите запрос на вывод `starship prompt`
PS1="$(starship prompt --status=$STATUS --jobs=$NUM_JOBS)"
```

[Реализация для Bash](https://github.com/starship/starship/blob/master/src/init/starship.bash), встроенная в Starship, несколько сложнее, чтобы предоставить дополнительные возможности, такие как [модуль длительности команды](https://starship.rs/config/#command-duration) и обеспечить совместимость Starship с заранее установленными конфигурациями Bash.

Для списка всех флагов, принимаемых `starship prompt`, используйте следующую команду:

```sh
starship prompt --help
```

Подсказка будет использовать столько контекста, сколько доступно, но ни один флаг не обязателен.

## Как запускать Starship на Linux-дистрибутивах с более ранними версиями glibc?

Если вы получаете ошибку типа "_version 'GLIBC_2.18' not found (required by starship)_" при использовании заранее собранного бинарного файла (например, на CentOS 6 или 7), вы можете использовать бинарный файл, скомпилированый с `musl` вместо `glibc`:

```sh
curl -sS https://starship.rs/install.sh | sh -s -- --platform unknown-linux-musl
```

## Почему я вижу предупреждение  `Executing command "..." timed out.`?

Starship выполняет различные команды, чтобы получить информацию, отображаемую в промпте, например версию программы или текущий git status. Чтобы быть уверенными, что starship не зависнет во время выполнения этих команд, мы поставили лимит времени, и если команда выполняется дольше лимита, starship прекратит её выполнение и выведет это предупреждение, это нормальное поведение. Временной лимит можно изменить с помощью опции [`command_timeout`key](../config/#prompt), поэтому при желании вы можете увеличить это время. Вы так же можете следовать шагам для отладки ниже, чтобы понять, какая команда влияет на время и ускорить промпт. Наконец, вы можете изменить переменную окружения `STARSHIP_LOG` `error`, чтобы спрятать это предупреждение.

## Я вижу символы, которые я не понимаю или не ожидаю, что они означают?

Если вы видите символы, которые вы не узнаете, вы можете использовать команду `starship explain`, чтобы разъяснить показываемые модули.

## Starship делает что-то неожиданное, как я могу отладить его?

Вы можете включить отладочные журналы с помощью `STARSHIP_LOG` env var. Эти логи могут быть очень подробными, поэтому часто полезно использовать команду `module` если вы пытаетесь отладить тот или иной модуль, например, если вы пытаетесь отладить модуль `rust`, вы можете выполнить следующую команду, чтобы получить логи и вывод трассировки из модуля.

```sh
env STARSHIP_LOG=trace starship module rust
```

Если starship работает медленно, вы можете попробовать использовать команду `timings`, чтобы узнать, виноват ли в этом какой-то конкретный модуль или команда.

```sh
env STARSHIP_LOG=trace starship timings
```

Это выведет журнал трассировки и разбивку по всем модулям, выполнение которых либо заняло более 1 мс, либо привело к некоторому результату.

Наконец, если вы обнаружили ошибку, вы можете использовать команду `bug-report` для создания проблемы в GitHub.

```sh
starship bug-report
```

## Почему я не вижу символ в промпте?

Наиболее распространенной причиной этого является неправильная конфигурация системы. В частности, некоторые Linux дистрибутивы не предоставляют поддержку шрифта из коробки. Необходимо убедиться, что:

- Для вашего языка задано значение UTF-8, например `de_DE.UTF-8` или `ja_JP.UTF-8`. Если `LC_ALL` не является значением UTF-8, [вам нужно будет изменить его](https://www.tecmint.com/set-system-locales-in-linux/).
- У вас установлен шрифт emoji. В большинстве систем по умолчанию используется шрифт emoji, но в некоторых (например, в Arch Linux) его нет. Обычно вы можете установить его через менеджер пакетов вашей системы--[noto emoji](https://www.google.com/get/noto/help/emoji/) является популярным выбором.
- Вы используете [Nerd Font](https://www.nerdfonts.com/).

Для тестирования системы запустите следующие команды в терминале:

```sh
echo -e "\xf0\x9f\x90\x8d"
echo -e "\xee\x82\xa0"
```

Первая строка должна создать [эмоджи змеи](https://emojipedia.org/snake/), а вторая - символ ветки [(e0a0)](https://github.com/ryanoasis/powerline-extra-symbols#glyphs).

Если любой из символов не отображается корректно, ваша система все еще неправильно настроена. К сожалению, иногда сложно получить правильную конфигурацию шрифта. Пользователи в Discord могут помочь. Если оба символа отображаются верно, но вы всё ещё не видите их в starship, [отправьте bug report!](https://github.com/starship/starship/issues/new/choose)

## Как удалить Starship?

Starship так же прост в удалении, как и установка его в первую очередь.

1. Удалите все строки в конфигурации вашей оболочки (например, `~/.bashrc`), используемые для инициализации Starship.
1. Удалите бинарный файл Starship.

Если Starship был установлен с помощью менеджера пакетов, пожалуйста, обратитесь к их документации для получения инструкций по установке.

Если Starship был установлен с помощью сценария установки, следующая команда удалит бинарный файл:

```sh
# Найти и удалить бинарный файл starship
sh -c 'rm "$(command -v 'starship')"'
```

## Как Starship без `sudo`?

Скрипт установки (`https://starship.rs/install. h`) использует `sudo` только если директория установки недоступна для записи текущим пользователем. Каталогом установки по умолчанию является значение переменной среды `$BIN_DIR` или `/usr/local/bin`, если значение `$BIN_DIR` не задано. Если вместо этого выбрать директорию установки, которая доступна для записи пользователем, вы можете установить starship без `sudo`. Например, в `curl -sS https://starship.rs/install.sh | sh -s -- -b ~/.local/bin` флаг `-b` установочного скрипта используется, чтобы задать директорию установки на `~/.local/bin`.

Для неинтерактивной установки Starship не забудьте добавить опцию `-y` чтобы пропустить подтверждение. Проверьте исходник установочного скрипта, чтобы получить список всех поддерживаемых параметров установки.

При через пакетный менеджер, смотрите документацию для вашего пакетного менеджера об установке с `sudo` и без.
