/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot.provisioning;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.AbstractPresenceEventListener;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.SubscribeListener;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.iot.IoTManager;
import org.jivesoftware.smackx.iot.discovery.IoTDiscoveryManager;
import org.jivesoftware.smackx.iot.provisioning.BecameFriendListener;
import org.jivesoftware.smackx.iot.provisioning.WasUnfriendedListener;
import org.jivesoftware.smackx.iot.provisioning.element.ClearCache;
import org.jivesoftware.smackx.iot.provisioning.element.ClearCacheResponse;
import org.jivesoftware.smackx.iot.provisioning.element.Friend;
import org.jivesoftware.smackx.iot.provisioning.element.IoTIsFriend;
import org.jivesoftware.smackx.iot.provisioning.element.IoTIsFriendResponse;
import org.jivesoftware.smackx.iot.provisioning.element.Unfriend;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.util.cache.LruCache;

public final class IoTProvisioningManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(IoTProvisioningManager.class.getName());
    private static final StanzaFilter FRIEND_MESSAGE = new AndFilter(StanzaTypeFilter.MESSAGE, new StanzaExtensionFilter("friend", "urn:xmpp:iot:provisioning"));
    private static final StanzaFilter UNFRIEND_MESSAGE = new AndFilter(StanzaTypeFilter.MESSAGE, new StanzaExtensionFilter("UNFRIEND", "urn:xmpp:iot:provisioning"));
    private static final Map<XMPPConnection, IoTProvisioningManager> INSTANCES = new WeakHashMap<XMPPConnection, IoTProvisioningManager>();
    private final Roster roster;
    private final LruCache<Jid, LruCache<BareJid, Void>> negativeFriendshipRequestCache = new LruCache(8);
    private final LruCache<BareJid, Void> friendshipDeniedCache = new LruCache(16);
    private final LruCache<BareJid, Void> friendshipRequestedCache = new LruCache(16);
    private final Set<BecameFriendListener> becameFriendListeners = new CopyOnWriteArraySet<BecameFriendListener>();
    private final Set<WasUnfriendedListener> wasUnfriendedListeners = new CopyOnWriteArraySet<WasUnfriendedListener>();
    private Jid configuredProvisioningServer;

    public static synchronized IoTProvisioningManager getInstanceFor(XMPPConnection connection) {
        IoTProvisioningManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new IoTProvisioningManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    private IoTProvisioningManager(XMPPConnection connection) {
        super(connection);
        connection.addAsyncStanzaListener(new StanzaListener(){

            @Override
            public void processStanza(Stanza stanza) throws SmackException.NotConnectedException, InterruptedException {
                if (!IoTProvisioningManager.this.isFromProvisioningService(stanza, true)) {
                    return;
                }
                Message message = (Message)stanza;
                Unfriend unfriend = Unfriend.from(message);
                BareJid unfriendJid = unfriend.getJid();
                XMPPConnection connection = IoTProvisioningManager.this.connection();
                Roster roster = Roster.getInstanceFor(connection);
                if (!roster.isSubscribedToMyPresence(unfriendJid)) {
                    LOGGER.warning("Ignoring <unfriend/> request '" + String.valueOf(stanza) + "' because " + String.valueOf(unfriendJid) + " is already not subscribed to our presence.");
                    return;
                }
                Presence unsubscribed = ((PresenceBuilder)connection.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.unsubscribed).to(unfriendJid)).build();
                connection.sendStanza(unsubscribed);
            }
        }, UNFRIEND_MESSAGE);
        connection.addAsyncStanzaListener(new StanzaListener(){

            @Override
            public void processStanza(Stanza stanza) throws SmackException.NotConnectedException, InterruptedException {
                Message friendMessage = (Message)stanza;
                Friend friend = Friend.from(friendMessage);
                BareJid friendJid = friend.getFriend();
                if (IoTProvisioningManager.this.isFromProvisioningService(friendMessage, false)) {
                    XMPPConnection connection = IoTProvisioningManager.this.connection();
                    Friend friendNotification = new Friend(connection.getUser().asBareJid());
                    Message notificationMessage = ((MessageBuilder)((MessageBuilder)connection.getStanzaFactory().buildMessageStanza().to(friendJid)).addExtension(friendNotification)).build();
                    connection.sendStanza(notificationMessage);
                } else {
                    BareJid bareFrom = friendMessage.getFrom().asBareJid();
                    if (!IoTProvisioningManager.this.friendshipDeniedCache.containsKey(bareFrom)) {
                        LOGGER.log(Level.WARNING, "Ignoring friendship recommendation " + String.valueOf(friendMessage) + " because friendship to this JID was not previously denied.");
                        return;
                    }
                    if (!bareFrom.equals(friendJid)) {
                        LOGGER.log(Level.WARNING, "Ignoring friendship recommendation " + String.valueOf(friendMessage) + " because it does not recommend itself, but " + String.valueOf(friendJid) + ".");
                        return;
                    }
                    IoTProvisioningManager.this.sendFriendshipRequest(friendJid);
                }
            }
        }, FRIEND_MESSAGE);
        connection.registerIQRequestHandler(new AbstractIqRequestHandler("clearCache", "urn:xmpp:iot:provisioning", IQ.Type.set, IQRequestHandler.Mode.async){

            @Override
            public IQ handleIQRequest(IQ iqRequest) {
                if (!IoTProvisioningManager.this.isFromProvisioningService(iqRequest, true)) {
                    return null;
                }
                ClearCache clearCache = (ClearCache)iqRequest;
                Jid from = iqRequest.getFrom();
                LruCache<BareJid, Void> cache = IoTProvisioningManager.this.negativeFriendshipRequestCache.lookup(from);
                if (cache != null) {
                    cache.clear();
                }
                return new ClearCacheResponse(clearCache);
            }
        });
        this.roster = Roster.getInstanceFor(connection);
        this.roster.addSubscribeListener(new SubscribeListener(){

            @Override
            public SubscribeListener.SubscribeAnswer processSubscribe(Jid from, Presence subscribeRequest) {
                boolean isFriend;
                try {
                    if (IoTDiscoveryManager.getInstanceFor(IoTProvisioningManager.this.connection()).isRegistry(from.asBareJid())) {
                        return SubscribeListener.SubscribeAnswer.Approve;
                    }
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                    LOGGER.log(Level.WARNING, "Could not determine if " + String.valueOf(from) + " is a registry", e);
                }
                Jid provisioningServer = null;
                try {
                    provisioningServer = IoTProvisioningManager.this.getConfiguredProvisioningServer();
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                    LOGGER.log(Level.WARNING, "Could not determine provisioning server. Ignoring friend request from " + String.valueOf(from), e);
                }
                if (provisioningServer == null) {
                    return null;
                }
                try {
                    isFriend = IoTProvisioningManager.this.isFriend(provisioningServer, from.asBareJid());
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                    LOGGER.log(Level.WARNING, "Could not determine if " + String.valueOf(from) + " is a friend.", e);
                    return null;
                }
                if (isFriend) {
                    return SubscribeListener.SubscribeAnswer.Approve;
                }
                return SubscribeListener.SubscribeAnswer.Deny;
            }
        });
        this.roster.addPresenceEventListener(new AbstractPresenceEventListener(){

            @Override
            public void presenceSubscribed(BareJid address, Presence subscribedPresence) {
                IoTProvisioningManager.this.friendshipRequestedCache.remove(address);
                for (BecameFriendListener becameFriendListener : IoTProvisioningManager.this.becameFriendListeners) {
                    becameFriendListener.becameFriend(address, subscribedPresence);
                }
            }

            @Override
            public void presenceUnsubscribed(BareJid address, Presence unsubscribedPresence) {
                if (IoTProvisioningManager.this.friendshipRequestedCache.containsKey(address)) {
                    IoTProvisioningManager.this.friendshipDeniedCache.put(address, null);
                }
                for (WasUnfriendedListener wasUnfriendedListener : IoTProvisioningManager.this.wasUnfriendedListeners) {
                    wasUnfriendedListener.wasUnfriendedListener(address, unsubscribedPresence);
                }
            }
        });
    }

    public void setConfiguredProvisioningServer(Jid provisioningServer) {
        this.configuredProvisioningServer = provisioningServer;
    }

    public Jid getConfiguredProvisioningServer() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (this.configuredProvisioningServer == null) {
            this.configuredProvisioningServer = this.findProvisioningServerComponent();
        }
        return this.configuredProvisioningServer;
    }

    public DomainBareJid findProvisioningServerComponent() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.connection();
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        List<DiscoverInfo> discoverInfos = sdm.findServicesDiscoverInfo("urn:xmpp:iot:provisioning", true, true);
        if (discoverInfos.isEmpty()) {
            return null;
        }
        Jid jid = discoverInfos.get(0).getFrom();
        assert (jid.isDomainBareJid());
        return jid.asDomainBareJid();
    }

    public boolean isFriend(Jid provisioningServer, BareJid friendInQuestion) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        LruCache<BareJid, Void> cache = this.negativeFriendshipRequestCache.lookup(provisioningServer);
        if (cache != null && cache.containsKey(friendInQuestion)) {
            return false;
        }
        IoTIsFriend iotIsFriend = new IoTIsFriend(friendInQuestion);
        iotIsFriend.setTo(provisioningServer);
        IoTIsFriendResponse response = (IoTIsFriendResponse)this.connection().sendIqRequestAndWaitForResponse(iotIsFriend);
        assert (response.getJid().equals(friendInQuestion));
        boolean isFriend = response.getIsFriendResult();
        if (!isFriend) {
            if (cache == null) {
                cache = new LruCache(1024);
                this.negativeFriendshipRequestCache.put(provisioningServer, cache);
            }
            cache.put(friendInQuestion, null);
        }
        return isFriend;
    }

    public boolean iAmFriendOf(BareJid otherJid) {
        return this.roster.iAmSubscribedTo(otherJid);
    }

    public void sendFriendshipRequest(BareJid bareJid) throws SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.connection();
        Presence presence = ((PresenceBuilder)connection.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.subscribe).to(bareJid)).build();
        this.friendshipRequestedCache.put(bareJid, null);
        this.connection().sendStanza(presence);
    }

    public void sendFriendshipRequestIfRequired(BareJid jid) throws SmackException.NotConnectedException, InterruptedException {
        if (this.iAmFriendOf(jid)) {
            return;
        }
        this.sendFriendshipRequest(jid);
    }

    public boolean isMyFriend(Jid friendInQuestion) {
        return this.roster.isSubscribedToMyPresence(friendInQuestion);
    }

    public void unfriend(Jid friend) throws SmackException.NotConnectedException, InterruptedException {
        if (this.isMyFriend(friend)) {
            XMPPConnection connection = this.connection();
            Presence presence = ((PresenceBuilder)connection.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.unsubscribed).to(friend)).build();
            connection.sendStanza(presence);
        }
    }

    public boolean addBecameFriendListener(BecameFriendListener becameFriendListener) {
        return this.becameFriendListeners.add(becameFriendListener);
    }

    public boolean removeBecameFriendListener(BecameFriendListener becameFriendListener) {
        return this.becameFriendListeners.remove(becameFriendListener);
    }

    public boolean addWasUnfriendedListener(WasUnfriendedListener wasUnfriendedListener) {
        return this.wasUnfriendedListeners.add(wasUnfriendedListener);
    }

    public boolean removeWasUnfriendedListener(WasUnfriendedListener wasUnfriendedListener) {
        return this.wasUnfriendedListeners.remove(wasUnfriendedListener);
    }

    private boolean isFromProvisioningService(Stanza stanza, boolean log) {
        Jid provisioningServer;
        try {
            provisioningServer = this.getConfiguredProvisioningServer();
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
            LOGGER.log(Level.WARNING, "Could determine provisioning server", e);
            return false;
        }
        if (provisioningServer == null) {
            if (log) {
                LOGGER.warning("Ignoring request '" + String.valueOf(stanza) + "' because no provisioning server configured.");
            }
            return false;
        }
        if (!provisioningServer.equals(stanza.getFrom())) {
            if (log) {
                LOGGER.warning("Ignoring  request '" + String.valueOf(stanza) + "' because not from provisioning server '" + String.valueOf(provisioningServer) + "'.");
            }
            return false;
        }
        return true;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection connection) {
                if (!IoTManager.isAutoEnableActive()) {
                    return;
                }
                IoTProvisioningManager.getInstanceFor(connection);
            }
        });
    }
}

