// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme-f8f32 -target-feature +sme-tmop -target-feature +sme2 -target-feature +sve -verify=streaming-guard

// REQUIRES: aarch64-registered-target

#include <arm_sme.h>

// Properties: guard="" streaming_guard="sme,sme2,sme-tmop,sme-f8f32" flags="streaming-only,requires-za"

void test(void) __arm_inout("za"){
  fpm_t fpm_t_val;
  svmfloat8_t svmfloat8_t_val;
  svmfloat8x2_t svmfloat8x2_t_val;
  svuint8_t svuint8_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_fpm(2, svmfloat8x2_t_val, svmfloat8_t_val, svuint8_t_val, 2, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_mf8_mf8_fpm(2, svmfloat8x2_t_val, svmfloat8_t_val, svuint8_t_val, 2, fpm_t_val);
}

void test_streaming(void) __arm_streaming __arm_inout("za"){
  fpm_t fpm_t_val;
  svmfloat8_t svmfloat8_t_val;
  svmfloat8x2_t svmfloat8x2_t_val;
  svuint8_t svuint8_t_val;

  svtmopa_lane_za32_fpm(2, svmfloat8x2_t_val, svmfloat8_t_val, svuint8_t_val, 2, fpm_t_val);
  svtmopa_lane_za32_mf8_mf8_fpm(2, svmfloat8x2_t_val, svmfloat8_t_val, svuint8_t_val, 2, fpm_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible __arm_inout("za"){
  fpm_t fpm_t_val;
  svmfloat8_t svmfloat8_t_val;
  svmfloat8x2_t svmfloat8x2_t_val;
  svuint8_t svuint8_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_fpm(2, svmfloat8x2_t_val, svmfloat8_t_val, svuint8_t_val, 2, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svtmopa_lane_za32_mf8_mf8_fpm(2, svmfloat8x2_t_val, svmfloat8_t_val, svuint8_t_val, 2, fpm_t_val);
}
