// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme-f8f16 -target-feature +sme-mop4 -target-feature +sme2 -target-feature +sve -verify=streaming-guard

// REQUIRES: aarch64-registered-target

#include <arm_sme.h>

// Properties: guard="" streaming_guard="sme,sme2,sme-mop4,sme-f8f16" flags="streaming-only,requires-za"

void test(void) __arm_inout("za"){
  fpm_t fpm_t_val;
  svmfloat8_t svmfloat8_t_val;
  svmfloat8x2_t svmfloat8x2_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmop4a_1x1_za16_mf8_mf8_fpm(1, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmop4a_1x2_za16_mf8_mf8_fpm(1, svmfloat8_t_val, svmfloat8x2_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmop4a_2x1_za16_mf8_mf8_fpm(1, svmfloat8x2_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmop4a_2x2_za16_mf8_mf8_fpm(1, svmfloat8x2_t_val, svmfloat8x2_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmop4a_za16_fpm(1, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmop4a_za16_fpm(1, svmfloat8_t_val, svmfloat8x2_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmop4a_za16_fpm(1, svmfloat8x2_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmop4a_za16_fpm(1, svmfloat8x2_t_val, svmfloat8x2_t_val, fpm_t_val);
}

void test_streaming(void) __arm_streaming __arm_inout("za"){
  fpm_t fpm_t_val;
  svmfloat8_t svmfloat8_t_val;
  svmfloat8x2_t svmfloat8x2_t_val;

  svmop4a_1x1_za16_mf8_mf8_fpm(1, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  svmop4a_1x2_za16_mf8_mf8_fpm(1, svmfloat8_t_val, svmfloat8x2_t_val, fpm_t_val);
  svmop4a_2x1_za16_mf8_mf8_fpm(1, svmfloat8x2_t_val, svmfloat8_t_val, fpm_t_val);
  svmop4a_2x2_za16_mf8_mf8_fpm(1, svmfloat8x2_t_val, svmfloat8x2_t_val, fpm_t_val);
  svmop4a_za16_fpm(1, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  svmop4a_za16_fpm(1, svmfloat8_t_val, svmfloat8x2_t_val, fpm_t_val);
  svmop4a_za16_fpm(1, svmfloat8x2_t_val, svmfloat8_t_val, fpm_t_val);
  svmop4a_za16_fpm(1, svmfloat8x2_t_val, svmfloat8x2_t_val, fpm_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible __arm_inout("za"){
  fpm_t fpm_t_val;
  svmfloat8_t svmfloat8_t_val;
  svmfloat8x2_t svmfloat8x2_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmop4a_1x1_za16_mf8_mf8_fpm(1, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmop4a_1x2_za16_mf8_mf8_fpm(1, svmfloat8_t_val, svmfloat8x2_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmop4a_2x1_za16_mf8_mf8_fpm(1, svmfloat8x2_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmop4a_2x2_za16_mf8_mf8_fpm(1, svmfloat8x2_t_val, svmfloat8x2_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmop4a_za16_fpm(1, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmop4a_za16_fpm(1, svmfloat8_t_val, svmfloat8x2_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmop4a_za16_fpm(1, svmfloat8x2_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmop4a_za16_fpm(1, svmfloat8x2_t_val, svmfloat8x2_t_val, fpm_t_val);
}
