#!/bin/sh
# SPDX-FileCopyrightText: 2024 Blender Authors
#
# SPDX-License-Identifier: GPL-2.0-or-later

# Generation of multilayer/multipart/multiview EXR files for regression testing.
#
# This script generates EXR images with the same configuration files from bug
# reports, but outputs very small files.
#
# To generate the images:
#
# 1. Open render.blend and hit F12
# 2. Run generate.sh script
# 3. Commit EXR files generated by the script (there is no need to commit files
#    generated by render.blend).

set -e

# Convert pass names from default Compositor naming to naming needed for combining files for test.
oiiotool passes/depth_float_rgb.exr --ch "depth=R" -o passes/depth_float.exr
oiiotool passes/normal_float_rgb.exr --ch "x=R,y=G,z=B" -d half -o passes/normal_half_xyz_lower.exr

# Generate Multi-Part file with the same parts and channels as "0130 - multilayer exr, CRASHY.exr" from #101227.
echo "==> Generating 101227.exr"
exrmultipart -combine \
  -i passes/combined_half_rgba.exr::C \
  -i passes/denoising_albedo_half_rgb.exr::albedo \
  -i passes/depth_float.exr::depth \
  -i passes/normal_half_xyz_lower.exr::N \
  -o 101227.exr
# exrinfo 101227.exr

# Generate file with the same channels as "Scene_RenderLayer_000.exr" from #108980.
echo "==> Generating 108980.exr"
oiiotool \
  passes/denoising_albedo_half_rgb.exr --ch "Albedo.R=R,Albedo.G=G,Albedo.B=B" \
  passes/combined_half_rgba.exr --ch "B=B,G=G" \
  --chappend \
  passes/denoising_normal_float_rgb.exr --ch "Nsx=R,Nsy=G,Nsz=B" \
  --chappend \
  passes/normal_float_rgb.exr --ch "Nx=R,Ny=G,Nz=B" \
  --chappend \
  passes/position_float_rgb.exr --ch "Px=R,Py=G,Pz=B" \
  --chappend \
  passes/combined_half_rgba.exr --ch "R=R" \
  --chappend \
  passes/diffuse_direct_half_rgb.exr --ch "RelativeVariance.B=B,RelativeVariance.G=G,RelativeVariance.R=R" \
  --chappend \
  passes/diffuse_indirect_half_rgb.exr --ch "Variance.B=B,Variance.G=G,Variance.R=R" \
  --chappend \
  passes/vector_half_rgba.exr --ch "dzdx=R,dzdy=G" \
  --chappend \
  passes/uv_half_rgb.exr --ch "u=R,v=G" \
  --chappend \
  -d float -o 108980.exr
exrinfo 108980.exr

# Generate file with the same channels as "test.exr" from #124217.
echo "==> Generating 124217.exr"
oiiotool \
  passes/combined_half_rgba.exr --ch "A=A" \
  passes/ao_half_rgba.exr --ch "AO.R=R,AO.G=G,AO.B=B,AO.A=A" \
  --chappend \
  passes/combined_half_rgba.exr --ch "B=B,G=G" \
  --chappend \
  passes/index_ob_rgb.exr --ch "ID=R" \
  --chappend \
  passes/combined_half_rgba.exr --ch "R=R" \
  --chappend \
  passes/depth_float_rgb.exr --ch "Z=R" \
  --chappend \
  --pattern constant:color=0.3,0.5,0.1,1.0 128x128 3 --ch "crypto_material.R=R,crypto_material.G=G,crypto_material.B=B" \
  --chappend \
  passes/crypto_material00_float_rgba.exr --ch "crypto_material00.R=R,crypto_material00.G=G,crypto_material00.B=B,crypto_material00.A=A" \
  --chappend \
  passes/crypto_material01_float_rgba.exr --ch "crypto_material01.R=R,crypto_material01.G=G,crypto_material01.B=B,crypto_material01.A=A" \
  --chappend \
  passes/crypto_material02_float_rgba.exr --ch "crypto_material02.R=R,crypto_material02.G=G,crypto_material02.B=B,crypto_material02.A=A" \
  --chappend \
  passes/crypto_material03_float_rgba.exr --ch "crypto_material03.R=R,crypto_material03.G=G,crypto_material03.B=B,crypto_material03.A=A" \
  --chappend \
  passes/crypto_material04_float_rgba.exr --ch "crypto_material04.R=R,crypto_material04.G=G,crypto_material04.B=B,crypto_material04.A=A" \
  --chappend \
  passes/crypto_material05_float_rgba.exr --ch "crypto_material05.R=R,crypto_material05.G=G,crypto_material05.B=B,crypto_material05.A=A" \
  --chappend \
  passes/crypto_material06_float_rgba.exr --ch "crypto_material06.R=R,crypto_material06.G=G,crypto_material06.B=B,crypto_material06.A=A" \
  --chappend \
  --pattern constant:color=0.1,0.3,0.5,1.0 128x128 3 --ch "crypto_object.R=R,crypto_object.G=G,crypto_object.B=B" \
  --chappend \
  passes/crypto_object00_float_rgba.exr --ch "crypto_object00.R=R,crypto_object00.G=G,crypto_object00.B=B,crypto_object00.A=A" \
  --chappend \
  passes/crypto_object01_float_rgba.exr --ch "crypto_object01.R=R,crypto_object01.G=G,crypto_object01.B=B,crypto_object01.A=A" \
  --chappend \
  passes/crypto_object02_float_rgba.exr --ch "crypto_object02.R=R,crypto_object02.G=G,crypto_object02.B=B,crypto_object02.A=A" \
  --chappend \
  passes/crypto_object03_float_rgba.exr --ch "crypto_object03.R=R,crypto_object03.G=G,crypto_object03.B=B,crypto_object03.A=A" \
  --chappend \
  passes/crypto_object04_float_rgba.exr --ch "crypto_object04.R=R,crypto_object04.G=G,crypto_object04.B=B,crypto_object04.A=A" \
  --chappend \
  passes/crypto_object05_float_rgba.exr --ch "crypto_object05.R=R,crypto_object05.G=G,crypto_object05.B=B,crypto_object05.A=A" \
  --chappend \
  passes/crypto_object06_float_rgba.exr --ch "crypto_object06.R=R,crypto_object06.G=G,crypto_object06.B=B,crypto_object06.A=A" \
  --chappend \
  passes/diffuse_color_half_rgb.exr --ch "diffuse.R=R,diffuse.G=G,diffuse.B=B" \
  --chappend \
  passes/transmission_color_half_rgb.exr --ch "opacity.R=R,opacity.G=G,opacity.B=B" \
  --chappend \
  passes/glossy_color_half_rgb.exr --ch "specular.R=R,specular.G=G,specular.B=B" \
  --chappend \
  passes/glossy_direct_half_rgb.exr --ch "v.X=R,v.Y=G,v.Z=B" \
  --chappend \
  -d float -o 124217.exr
# exrinfo 124217.exr
