/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "ನೌರು";
        final String metaValue_TK = "ಟೊಕೆಲಾವ್";
        final String metaValue_TV = "ಟುವಾಲು";
        final String metaValue_ar = "ಅರೇಬಿಕ್";
        final String metaValue_hy = "ಅರ್ಮೇನಿಯನ್";
        final String metaValue_ccp = "ಚಕ್ಮಾ";
        final String metaValue_ka = "ಜಾರ್ಜಿಯನ್";
        final String metaValue_el = "ಗ್ರೀಕ್";
        final String metaValue_gu = "ಗುಜರಾತಿ";
        final String metaValue_he = "ಹೀಬ್ರೂ";
        final String metaValue_ja = "ಜಾಪನೀಸ್";
        final String metaValue_km = "ಖಮೇರ್";
        final String metaValue_kn = "ಕನ್ನಡ";
        final String metaValue_ko = "ಕೊರಿಯನ್";
        final String metaValue_lo = "ಲಾವೋ";
        final String metaValue_la = "ಲ್ಯಾಟಿನ್";
        final String metaValue_ml = "ಮಲಯಾಳಂ";
        final String metaValue_mn = "ಮಂಗೋಲಿಯನ್";
        final String metaValue_si = "ಸಿಂಹಳ";
        final String metaValue_su = "ಸುಂಡಾನೀಸ್";
        final String metaValue_syr = "ಸಿರಿಯಾಕ್";
        final String metaValue_ta = "ತಮಿಳು";
        final String metaValue_te = "ತೆಲುಗು";
        final String metaValue_tl = "ಟ್ಯಾಗಲೋಗ್";
        final String metaValue_th = "ಥಾಯ್";
        final String metaValue_uga = "ಉಗಾರಿಟಿಕ್";
        final String metaValue_peo = "ಪ್ರಾಚೀನ ಪರ್ಶಿಯನ್";
        final Object[][] data = new Object[][] {
            { "001", "ಪ್ರಪಂಚ" },
            { "002", "ಆಫ್ರಿಕಾ" },
            { "003", "ಉತ್ತರ ಅಮೇರಿಕಾ" },
            { "005", "ದಕ್ಷಿಣ ಅಮೇರಿಕಾ" },
            { "009", "ಓಶಿಯೇನಿಯಾ" },
            { "011", "ಪಶ್ಚಿಮ ಆಫ್ರಿಕಾ" },
            { "013", "ಮಧ್ಯ ಅಮೇರಿಕಾ" },
            { "014", "ಪೂರ್ವ ಆಫ್ರಿಕಾ" },
            { "015", "ಉತ್ತರ ಆಫ್ರಿಕಾ" },
            { "017", "ಮಧ್ಯ ಆಫ್ರಿಕಾ" },
            { "018", "ಆಫ್ರಿಕಾದ ದಕ್ಷಿಣ ಭಾಗ" },
            { "019", "ಅಮೆರಿಕಾಸ್" },
            { "021", "ಅಮೇರಿಕಾದ ಉತ್ತರ ಭಾಗ" },
            { "029", "ಕೆರೀಬಿಯನ್" },
            { "030", "ಪೂರ್ವ ಏಷ್ಯಾ" },
            { "034", "ದಕ್ಷಿಣ ಏಷ್ಯಾ" },
            { "035", "ಆಗ್ನೇಯ ಏಷ್ಯಾ" },
            { "039", "ದಕ್ಷಿಣ ಯೂರೋಪ್" },
            { "053", "ಆಸ್ಟ್ರೇಲೇಷ್ಯಾ" },
            { "054", "ಮೆಲನೇಷಿಯಾ" },
            { "057", "ಮೈಕ್ರೋನೇಶಿಯನ್ ಪ್ರದೇಶ" },
            { "061", "ಪಾಲಿನೇಷ್ಯಾ" },
            { "142", "ಏಷ್ಯಾ" },
            { "143", "ಮಧ್ಯ ಏಷ್ಯಾ" },
            { "145", "ಪಶ್ಚಿಮ ಏಷ್ಯಾ" },
            { "150", "ಯೂರೋಪ್" },
            { "151", "ಪೂರ್ವ ಯೂರೋಪ್" },
            { "154", "ಉತ್ತರ ಯೂರೋಪ್" },
            { "155", "ಪಶ್ಚಿಮ ಯೂರೋಪ್" },
            { "202", "ಉಪ-ಸಹಾರನ್ ಆಫ್ರಿಕಾ" },
            { "419", "ಲ್ಯಾಟಿನ್ ಅಮೇರಿಕಾ" },
            { "AC", "ಅಸೆನ್ಶನ್ ದ್ವೀಪ" },
            { "AD", "ಅಂಡೋರಾ" },
            { "AE", "ಯುನೈಟೆಡ್ ಅರಬ್ ಎಮಿರೇಟ್ಸ್" },
            { "AF", "ಅಫಘಾನಿಸ್ಥಾನ" },
            { "AG", "ಆಂಟಿಗುವಾ ಮತ್ತು ಬರ್ಬುಡಾ" },
            { "AI", "ಆಂಗ್ವಿಲ್ಲಾ" },
            { "AL", "ಅಲ್ಬೇನಿಯಾ" },
            { "AM", "ಆರ್ಮೇನಿಯ" },
            { "AO", "ಅಂಗೋಲಾ" },
            { "AQ", "ಅಂಟಾರ್ಟಿಕಾ" },
            { "AR", "ಅರ್ಜೆಂಟಿನಾ" },
            { "AS", "ಅಮೇರಿಕನ್ ಸಮೋವಾ" },
            { "AT", "ಆಸ್ಟ್ರಿಯಾ" },
            { "AU", "ಆಸ್ಟ್ರೇಲಿಯಾ" },
            { "AW", "ಅರುಬಾ" },
            { "AX", "ಆಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳು" },
            { "AZ", "ಅಜರ್ಬೈಜಾನ್" },
            { "BA", "ಬೋಸ್ನಿಯಾ ಮತ್ತು ಹರ್ಜೆಗೋವಿನಾ" },
            { "BB", "ಬಾರ್ಬಡೋಸ್" },
            { "BD", "ಬಾಂಗ್ಲಾದೇಶ" },
            { "BE", "ಬೆಲ್ಜಿಯಮ್" },
            { "BF", "ಬುರ್ಕಿನಾ ಫಾಸೊ" },
            { "BG", "ಬಲ್ಗೇರಿಯಾ" },
            { "BH", "ಬಹ್ರೇನ್" },
            { "BI", "ಬುರುಂಡಿ" },
            { "BJ", "ಬೆನಿನ್" },
            { "BL", "ಸೇಂಟ್ ಬಾರ್ಥೆಲೆಮಿ" },
            { "BM", "ಬರ್ಮುಡಾ" },
            { "BN", "ಬ್ರೂನಿ" },
            { "BO", "ಬೊಲಿವಿಯಾ" },
            { "BQ", "ಕೆರೀಬಿಯನ್ ನೆದರ್‌ಲ್ಯಾಂಡ್ಸ್" },
            { "BR", "ಬ್ರೆಜಿಲ್" },
            { "BS", "ಬಹಾಮಾಸ್" },
            { "BT", "ಭೂತಾನ್" },
            { "BV", "ಬೋವೆಟ್ ದ್ವೀಪ" },
            { "BW", "ಬೋಟ್ಸ್‌ವಾನಾ" },
            { "BY", "ಬೆಲಾರಸ್" },
            { "BZ", "ಬೆಲಿಜ್" },
            { "CA", "ಕೆನಡಾ" },
            { "CC", "ಕೊಕೊಸ್ (ಕೀಲಿಂಗ್) ದ್ವೀಪಗಳು" },
            { "CD", "ಕಾಂಗೋ - ಕಿನ್ಶಾಸಾ" },
            { "CF", "ಮಧ್ಯ ಆಫ್ರಿಕಾ ಗಣರಾಜ್ಯ" },
            { "CG", "ಕಾಂಗೋ - ಬ್ರಾಜಾವಿಲ್ಲೇ" },
            { "CH", "ಸ್ವಿಟ್ಜರ್ಲ್ಯಾಂಡ್" },
            { "CI", "ಕೋತ್ ದ್‘ಇವಾರ್" },
            { "CK", "ಕುಕ್ ದ್ವೀಪಗಳು" },
            { "CL", "ಚಿಲಿ" },
            { "CM", "ಕ್ಯಾಮರೂನ್" },
            { "CN", "ಚೀನಾ" },
            { "CO", "ಕೊಲಂಬಿಯಾ" },
            { "CP", "ಕ್ಲಿಪ್ಪರ್‌ಟಾನ್ ದ್ವೀಪ" },
            { "CQ", "ಸಾರ್ಕ್" },
            { "CR", "ಕೊಸ್ಟಾ ರಿಕಾ" },
            { "CU", "ಕ್ಯೂಬಾ" },
            { "CV", "ಕೇಪ್ ವರ್ಡೆ" },
            { "CW", "ಕುರಾಕಾವ್" },
            { "CX", "ಕ್ರಿಸ್ಮಸ್ ದ್ವೀಪ" },
            { "CY", "ಸೈಪ್ರಸ್" },
            { "CZ", "ಝೆಕಿಯಾ" },
            { "DE", "ಜರ್ಮನಿ" },
            { "DG", "ಡೈಗೋ ಗಾರ್ಸಿಯ" },
            { "DJ", "ಜಿಬೂಟಿ" },
            { "DK", "ಡೆನ್ಮಾರ್ಕ್" },
            { "DM", "ಡೊಮಿನಿಕಾ" },
            { "DO", "ಡೊಮೆನಿಕನ್ ರಿಪಬ್ಲಿಕ್" },
            { "DZ", "ಅಲ್ಜೀರಿಯ" },
            { "EA", "ಸೆಯುಟಾ ಹಾಗೂ ಮೆಲಿಲ್ಲಾ" },
            { "EC", "ಈಕ್ವೆಡಾರ್" },
            { "EE", "ಎಸ್ಟೋನಿಯಾ" },
            { "EG", "ಈಜಿಪ್ಟ್" },
            { "EH", "ಪಶ್ಚಿಮ ಸಹಾರಾ" },
            { "ER", "ಎರಿಟ್ರಿಯಾ" },
            { "ES", "ಸ್ಪೇನ್" },
            { "ET", "ಇಥಿಯೋಪಿಯಾ" },
            { "EU", "ಯುರೋಪಿಯನ್ ಒಕ್ಕೂಟ" },
            { "EZ", "ಯೂರೋಝೋನ್‌" },
            { "FI", "ಫಿನ್‌ಲ್ಯಾಂಡ್" },
            { "FJ", "ಫಿಜಿ" },
            { "FK", "ಫಾಕ್‌ಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳು" },
            { "FM", "ಮೈಕ್ರೋನೇಶಿಯಾ" },
            { "FO", "ಫರೋ ದ್ವೀಪಗಳು" },
            { "FR", "ಫ್ರಾನ್ಸ್" },
            { "GA", "ಗೆಬೊನ್" },
            { "GB", "ಯುನೈಟೆಡ್ ಕಿಂಗ್‌ಡಮ್" },
            { "GD", "ಗ್ರೆನೆಡಾ" },
            { "GE", "ಜಾರ್ಜಿಯಾ" },
            { "GF", "ಫ್ರೆಂಚ್ ಗಯಾನಾ" },
            { "GG", "ಗುರ್ನ್‌ಸೆ" },
            { "GH", "ಘಾನಾ" },
            { "GI", "ಗಿಬ್ರಾಲ್ಟರ್" },
            { "GL", "ಗ್ರೀನ್‌ಲ್ಯಾಂಡ್" },
            { "GM", "ಗ್ಯಾಂಬಿಯಾ" },
            { "GN", "ಗಿನಿ" },
            { "GP", "ಗುಡೆಲೋಪ್" },
            { "GQ", "ಈಕ್ವೆಟೋರಿಯಲ್ ಗಿನಿ" },
            { "GR", "ಗ್ರೀಸ್" },
            { "GS", "ದಕ್ಷಿಣ ಜಾರ್ಜಿಯಾ ಮತ್ತು ದಕ್ಷಿಣ ಸ್ಯಾಂಡ್‍ವಿಚ್ ದ್ವೀಪಗಳು" },
            { "GT", "ಗ್ವಾಟೆಮಾಲಾ" },
            { "GU", "ಗುವಾಮ್" },
            { "GW", "ಗಿನಿ-ಬಿಸ್ಸಾವ್" },
            { "GY", "ಗಯಾನಾ" },
            { "HK", "ಹಾಂಗ್ ಕಾಂಗ್ ಎಸ್ಎಆರ್ ಚೈನಾ" },
            { "HM", "ಹರ್ಡ್ ಮತ್ತು ಮ್ಯಾಕ್‌ಡೋನಾಲ್ಡ್ ದ್ವೀಪಗಳು" },
            { "HN", "ಹೊಂಡುರಾಸ್" },
            { "HR", "ಕ್ರೊಯೇಷಿಯಾ" },
            { "HT", "ಹೈಟಿ" },
            { "HU", "ಹಂಗೇರಿ" },
            { "IC", "ಕ್ಯಾನರಿ ದ್ವೀಪಗಳು" },
            { "ID", "ಇಂಡೋನೇಶಿಯಾ" },
            { "IE", "ಐರ್ಲೆಂಡ್" },
            { "IL", "ಇಸ್ರೇಲ್" },
            { "IM", "ಐಲ್ ಆಫ್ ಮ್ಯಾನ್" },
            { "IN", "ಭಾರತ" },
            { "IO", "ಬ್ರಿಟೀಷ್ ಹಿಂದೂ ಮಹಾಸಾಗರದ ಪ್ರದೇಶ" },
            { "IQ", "ಇರಾಕ್" },
            { "IR", "ಇರಾನ್" },
            { "IS", "ಐಸ್‌ಲ್ಯಾಂಡ್" },
            { "IT", "ಇಟಲಿ" },
            { "JE", "ಜೆರ್ಸಿ" },
            { "JM", "ಜಮೈಕಾ" },
            { "JO", "ಜೋರ್ಡಾನ್" },
            { "JP", "ಜಪಾನ್" },
            { "KE", "ಕೀನ್ಯಾ" },
            { "KG", "ಕಿರ್ಗಿಸ್ಥಾನ್" },
            { "KH", "ಕಾಂಬೋಡಿಯಾ" },
            { "KI", "ಕಿರಿಬಾಟಿ" },
            { "KM", "ಕೊಮೊರೊಸ್" },
            { "KN", "ಸೇಂಟ್ ಕಿಟ್ಸ್ ಮತ್ತು ನೆವಿಸ್" },
            { "KP", "ಉತ್ತರ ಕೊರಿಯಾ" },
            { "KR", "ದಕ್ಷಿಣ ಕೊರಿಯಾ" },
            { "KW", "ಕುವೈತ್" },
            { "KY", "ಕೇಮನ್ ದ್ವೀಪಗಳು" },
            { "KZ", "ಕಝಾಕಿಸ್ಥಾನ್" },
            { "LA", "ಲಾವೋಸ್" },
            { "LB", "ಲೆಬನಾನ್" },
            { "LC", "ಸೇಂಟ್ ಲೂಸಿಯಾ" },
            { "LI", "ಲಿಚೆನ್‌ಸ್ಟೈನ್" },
            { "LK", "ಶ್ರೀಲಂಕಾ" },
            { "LR", "ಲಿಬೇರಿಯಾ" },
            { "LS", "ಲೆಸೊಥೊ" },
            { "LT", "ಲಿಥುವೇನಿಯಾ" },
            { "LU", "ಲಕ್ಸೆಂಬರ್ಗ್" },
            { "LV", "ಲಾಟ್ವಿಯಾ" },
            { "LY", "ಲಿಬಿಯಾ" },
            { "MA", "ಮೊರಾಕ್ಕೊ" },
            { "MC", "ಮೊನಾಕೊ" },
            { "MD", "ಮೊಲ್ಡೋವಾ" },
            { "ME", "ಮೊಂಟೆನೆಗ್ರೋ" },
            { "MF", "ಸೇಂಟ್ ಮಾರ್ಟಿನ್" },
            { "MG", "ಮಡಗಾಸ್ಕರ್" },
            { "MH", "ಮಾರ್ಷಲ್ ದ್ವೀಪಗಳು" },
            { "MK", "ಉತ್ತರ ಮ್ಯಾಸಿಡೋನಿಯಾ" },
            { "ML", "ಮಾಲಿ" },
            { "MM", "ಮಯನ್ಮಾರ್ (ಬರ್ಮಾ)" },
            { "MN", "ಮಂಗೋಲಿಯಾ" },
            { "MO", "ಮಕಾವು ಎಸ್ಎಆರ್ ಚೈನಾ" },
            { "MP", "ಉತ್ತರ ಮರಿಯಾನಾ ದ್ವೀಪಗಳು" },
            { "MQ", "ಮಾರ್ಟಿನಿಕ್" },
            { "MR", "ಮಾರಿಟೇನಿಯಾ" },
            { "MS", "ಮಾಂಟ್‌ಸೆರಟ್" },
            { "MT", "ಮಾಲ್ಟಾ" },
            { "MU", "ಮಾರಿಷಸ್" },
            { "MV", "ಮಾಲ್ಡೀವ್ಸ್" },
            { "MW", "ಮಲಾವಿ" },
            { "MX", "ಮೆಕ್ಸಿಕೊ" },
            { "MY", "ಮಲೇಶಿಯಾ" },
            { "MZ", "ಮೊಜಾಂಬಿಕ್" },
            { "NA", "ನಮೀಬಿಯಾ" },
            { "NC", "ನ್ಯೂ ಕ್ಯಾಲಿಡೋನಿಯಾ" },
            { "NE", "ನೈಜರ್" },
            { "NF", "ನಾರ್ಫೋಕ್ ದ್ವೀಪ" },
            { "NG", "ನೈಜೀರಿಯಾ" },
            { "NI", "ನಿಕಾರಾಗುವಾ" },
            { "NL", "ನೆದರ್‌ಲ್ಯಾಂಡ್ಸ್" },
            { "NO", "ನಾರ್ವೆ" },
            { "NP", "ನೇಪಾಳ" },
            { "NR", metaValue_NR },
            { "NU", "ನಿಯು" },
            { "NZ", "ನ್ಯೂಜಿಲೆಂಡ್" },
            { "OM", "ಓಮನ್" },
            { "PA", "ಪನಾಮಾ" },
            { "PE", "ಪೆರು" },
            { "PF", "ಫ್ರೆಂಚ್ ಪಾಲಿನೇಷ್ಯಾ" },
            { "PG", "ಪಪುವಾ ನ್ಯೂಗಿನಿಯಾ" },
            { "PH", "ಫಿಲಿಫೈನ್ಸ್" },
            { "PK", "ಪಾಕಿಸ್ತಾನ" },
            { "PL", "ಪೋಲ್ಯಾಂಡ್" },
            { "PM", "ಸೇಂಟ್ ಪಿಯರ್ ಮತ್ತು ಮಿಕ್ವೆಲನ್" },
            { "PN", "ಪಿಟ್‌ಕೈರ್ನ್ ದ್ವೀಪಗಳು" },
            { "PR", "ಪ್ಯೂರ್ಟೋ ರಿಕೊ" },
            { "PS", "ಪ್ಯಾಲೇಸ್ಟೇನಿಯನ್ ಪ್ರದೇಶಗಳು" },
            { "PT", "ಪೋರ್ಚುಗಲ್" },
            { "PW", "ಪಲಾವು" },
            { "PY", "ಪರಾಗ್ವೇ" },
            { "QA", "ಖತಾರ್" },
            { "QO", "ಔಟ್ ಲೈಯಿಂಗ್ ಓಷಿಯಾನಿಯಾ" },
            { "RE", "ರಿಯೂನಿಯನ್" },
            { "RO", "ರೊಮೇನಿಯಾ" },
            { "RS", "ಸೆರ್ಬಿಯಾ" },
            { "RU", "ರಷ್ಯಾ" },
            { "RW", "ರುವಾಂಡಾ" },
            { "SA", "ಸೌದಿ ಅರೇಬಿಯಾ" },
            { "SB", "ಸಾಲೊಮನ್ ದ್ವೀಪಗಳು" },
            { "SC", "ಸೀಶೆಲ್ಲೆಸ್" },
            { "SD", "ಸುಡಾನ್" },
            { "SE", "ಸ್ವೀಡನ್" },
            { "SG", "ಸಿಂಗಪುರ್" },
            { "SH", "ಸೇಂಟ್ ಹೆಲೆನಾ" },
            { "SI", "ಸ್ಲೋವೇನಿಯಾ" },
            { "SJ", "ಸ್ವಾಲ್ಬಾರ್ಡ್ ಮತ್ತು ಜಾನ್ ಮೆಯನ್" },
            { "SK", "ಸ್ಲೊವಾಕಿಯಾ" },
            { "SL", "ಸಿಯೆರ್ರಾ ಲಿಯೋನ್" },
            { "SM", "ಸ್ಯಾನ್ ಮೆರಿನೋ" },
            { "SN", "ಸೆನೆಗಲ್" },
            { "SO", "ಸೊಮಾಲಿಯಾ" },
            { "SR", "ಸುರಿನಾಮ್" },
            { "SS", "ದಕ್ಷಿಣ ಸುಡಾನ್" },
            { "ST", "ಸಾವೋ ಟೋಮ್ ಮತ್ತು ಪ್ರಿನ್ಸಿಪಿ" },
            { "SV", "ಎಲ್ ಸಾಲ್ವೇಡಾರ್" },
            { "SX", "ಸಿಂಟ್ ಮಾರ್ಟೆನ್" },
            { "SY", "ಸಿರಿಯಾ" },
            { "SZ", "ಎಸ್ವಾಟಿನಿ" },
            { "TA", "ಟ್ರಿಸ್ತನ್ ಡಾ ಕುನ್ಹಾ" },
            { "TC", "ಟರ್ಕ್ಸ್ ಮತ್ತು ಕೈಕೋಸ್ ದ್ವೀಪಗಳು" },
            { "TD", "ಚಾದ್" },
            { "TF", "ಫ್ರೆಂಚ್ ದಕ್ಷಿಣ ಪ್ರದೇಶಗಳು" },
            { "TG", "ಟೋಗೋ" },
            { "TH", "ಥೈಲ್ಯಾಂಡ್" },
            { "TJ", "ತಜಿಕಿಸ್ತಾನ್" },
            { "TK", metaValue_TK },
            { "TL", "ಟಿಮೋರ್ ಲೆಸ್ಟೆ" },
            { "TM", "ತುರ್ಕಮೆನಿಸ್ತಾನ್" },
            { "TN", "ಟುನೀಶಿಯ" },
            { "TO", "ಟೊಂಗಾ" },
            { "TR", "ತುರ್ಕಿಯೆ" },
            { "TT", "ಟ್ರಿನಿಡಾಡ್ ಮತ್ತು ಟೊಬಾಗೊ" },
            { "TV", metaValue_TV },
            { "TW", "ತೈವಾನ್" },
            { "TZ", "ತಾಂಜೇನಿಯಾ" },
            { "UA", "ಉಕ್ರೈನ್" },
            { "UG", "ಉಗಾಂಡಾ" },
            { "UM", "ಯುಎಸ್‌ ಔಟ್‌ಲೇಯಿಂಗ್ ದ್ವೀಪಗಳು" },
            { "UN", "ಸಂಯುಕ್ತ ಸಂಸ್ಥಾನಗಳು" },
            { "US", "ಯುನೈಟೆಡ್ ಸ್ಟೇಟ್ಸ್" },
            { "UY", "ಉರುಗ್ವೆ" },
            { "UZ", "ಉಜ್ಬೇಕಿಸ್ಥಾನ್" },
            { "VA", "ವ್ಯಾಟಿಕನ್ ಸಿಟಿ" },
            { "VC", "ಸೇಂಟ್. ವಿನ್ಸೆಂಟ್ ಮತ್ತು ಗ್ರೆನೆಡೈನ್ಸ್" },
            { "VE", "ವೆನೆಜುವೆಲಾ" },
            { "VG", "ಬ್ರಿಟಿಷ್ ವರ್ಜಿನ್ ದ್ವೀಪಗಳು" },
            { "VI", "ಯು.ಎಸ್. ವರ್ಜಿನ್ ದ್ವೀಪಗಳು" },
            { "VN", "ವಿಯೆಟ್ನಾಮ್" },
            { "VU", "ವನೌಟು" },
            { "WF", "ವಾಲಿಸ್ ಮತ್ತು ಫುಟುನಾ" },
            { "WS", "ಸಮೋವಾ" },
            { "XA", "ಸ್ಯುಡೊ ಉಚ್ಛಾರಣೆಗಳು" },
            { "XB", "ಸ್ಯುಡೊ-ಬಿಡಿ" },
            { "XK", "ಕೊಸೊವೊ" },
            { "YE", "ಯೆಮನ್" },
            { "YT", "ಮಯೊಟ್ಟೆ" },
            { "ZA", "ದಕ್ಷಿಣ ಆಫ್ರಿಕಾ" },
            { "ZM", "ಜಾಂಬಿಯ" },
            { "ZW", "ಜಿಂಬಾಬ್ವೆ" },
            { "ZZ", "ಅಜ್ಞಾತ ಪ್ರದೇಶ" },
            { "aa", "ಅಫಾರ್" },
            { "ab", "ಅಬ್ಖಾಜಿಯನ್" },
            { "ae", "ಅವೆಸ್ಟನ್" },
            { "af", "ಆಫ್ರಿಕಾನ್ಸ್" },
            { "ak", "ಅಕಾನ್" },
            { "am", "ಅಂಹರಿಕ್" },
            { "an", "ಅರಗೊನೀಸ್" },
            { "ar", metaValue_ar },
            { "as", "ಅಸ್ಸಾಮೀಸ್" },
            { "av", "ಅವರಿಕ್" },
            { "ay", "ಅಯ್ಮಾರಾ" },
            { "az", "ಅಜೆರ್ಬೈಜಾನಿ" },
            { "ba", "ಬಶ್ಕಿರ್" },
            { "be", "ಬೆಲರೂಸಿಯನ್" },
            { "bg", "ಬಲ್ಗೇರಿಯನ್" },
            { "bi", "ಬಿಸ್ಲಾಮಾ" },
            { "bm", "ಬಂಬಾರಾ" },
            { "bn", "ಬಾಂಗ್ಲಾ" },
            { "bo", "ಟಿಬೇಟಿಯನ್" },
            { "br", "ಬ್ರೆಟನ್" },
            { "bs", "ಬೋಸ್ನಿಯನ್" },
            { "ca", "ಕೆಟಲಾನ್" },
            { "ce", "ಚಚೆನ್" },
            { "ch", "ಕಮೊರೊ" },
            { "co", "ಕೋರ್ಸಿಕನ್" },
            { "cr", "ಕ್ರೀ" },
            { "cs", "ಜೆಕ್" },
            { "cu", "ಚರ್ಚ್ ಸ್ಲಾವಿಕ್" },
            { "cv", "ಚುವಾಶ್" },
            { "cy", "ವೆಲ್ಶ್" },
            { "da", "ಡ್ಯಾನಿಶ್" },
            { "de", "ಜರ್ಮನ್" },
            { "dv", "ದಿವೆಹಿ" },
            { "dz", "ಜೋಂಗ್‌ಖಾ" },
            { "ee", "ಈವ್" },
            { "el", metaValue_el },
            { "en", "ಇಂಗ್ಲಿಷ್" },
            { "eo", "ಎಸ್ಪೆರಾಂಟೊ" },
            { "es", "ಸ್ಪ್ಯಾನಿಷ್" },
            { "et", "ಎಸ್ಟೊನಿಯನ್" },
            { "eu", "ಬಾಸ್ಕ್" },
            { "fa", "ಪರ್ಶಿಯನ್" },
            { "ff", "ಫುಲಾ" },
            { "fi", "ಫಿನ್ನಿಶ್" },
            { "fj", "ಫಿಜಿಯನ್" },
            { "fo", "ಫರೋಸಿ" },
            { "fr", "ಫ್ರೆಂಚ್" },
            { "fy", "ಪಶ್ಚಿಮ ಫ್ರಿಸಿಯನ್" },
            { "ga", "ಐರಿಷ್" },
            { "gd", "ಸ್ಕಾಟಿಶ್ ಗೆಲಿಕ್" },
            { "gl", "ಗ್ಯಾಲಿಶಿಯನ್" },
            { "gn", "ಗೌರಾನಿ" },
            { "gu", metaValue_gu },
            { "gv", "ಮ್ಯಾಂಕ್ಸ್" },
            { "ha", "ಹೌಸಾ" },
            { "he", metaValue_he },
            { "hi", "ಹಿಂದಿ" },
            { "ho", "ಹಿರಿ ಮೊಟು" },
            { "hr", "ಕ್ರೊಯೇಶಿಯನ್" },
            { "ht", "ಹೈಟಿಯನ್ ಕ್ರಿಯೋಲಿ" },
            { "hu", "ಹಂಗೇರಿಯನ್" },
            { "hy", metaValue_hy },
            { "hz", "ಹೆರೆರೊ" },
            { "ia", "ಇಂಟರ್‌ಲಿಂಗ್ವಾ" },
            { "id", "ಇಂಡೋನೇಶಿಯನ್" },
            { "ie", "ಇಂಟರ್‌ಲಿಂಗ್" },
            { "ig", "ಇಗ್ಬೊ" },
            { "ii", "ಸಿಚುಅನ್ ಯಿ" },
            { "ik", "ಇನುಪಿಯಾಕ್" },
            { "io", "ಇಡೊ" },
            { "is", "ಐಸ್‌ಲ್ಯಾಂಡಿಕ್" },
            { "it", "ಇಟಾಲಿಯನ್" },
            { "iu", "ಇನುಕ್ಟಿಟುಟ್" },
            { "ja", metaValue_ja },
            { "jv", "ಜಾವಾನೀಸ್" },
            { "ka", metaValue_ka },
            { "kg", "ಕಾಂಗೋ" },
            { "ki", "ಕಿಕುಯು" },
            { "kj", "ಕ್ವಾನ್‌ಯಾಮಾ" },
            { "kk", "ಕಝಕ್" },
            { "kl", "ಕಲಾಲ್ಲಿಸುಟ್" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "ಕನುರಿ" },
            { "ks", "ಕಾಶ್ಮೀರಿ" },
            { "ku", "ಕುರ್ಮಂಜಿ" },
            { "kv", "ಕೋಮಿ" },
            { "kw", "ಕಾರ್ನಿಷ್" },
            { "ky", "ಕಿರ್ಗಿಜ್" },
            { "la", metaValue_la },
            { "lb", "ಲಕ್ಸಂಬರ್ಗಿಷ್" },
            { "lg", "ಗಾಂಡಾ" },
            { "li", "ಲಿಂಬರ್ಗಿಶ್" },
            { "ln", "ಲಿಂಗಾಲ" },
            { "lo", metaValue_lo },
            { "lt", "ಲಿಥುವೇನಿಯನ್" },
            { "lu", "ಲೂಬಾ-ಕಟಾಂಗಾ" },
            { "lv", "ಲಾಟ್ವಿಯನ್" },
            { "mg", "ಮಲಗಾಸಿ" },
            { "mh", "ಮಾರ್ಶಲ್ಲೀಸ್" },
            { "mi", "ಮಾವೋರಿ" },
            { "mk", "ಮೆಸಿಡೋನಿಯನ್" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "ಮರಾಠಿ" },
            { "ms", "ಮಲಯ್" },
            { "mt", "ಮಾಲ್ಟೀಸ್" },
            { "my", "ಬರ್ಮೀಸ್" },
            { "na", metaValue_NR },
            { "nb", "ನಾರ್ವೆಜಿಯನ್ ಬೊಕ್ಮಲ್" },
            { "nd", "ಉತ್ತರ ದೆಬೆಲೆ" },
            { "ne", "ನೇಪಾಳಿ" },
            { "ng", "ಡೋಂಗಾ" },
            { "nl", "ಡಚ್" },
            { "nn", "ನಾರ್ವೇಜಿಯನ್ ನೈನಾರ್ಸ್ಕ್" },
            { "no", "ನಾರ್ವೇಜಿಯನ್" },
            { "nr", "ದಕ್ಷಿಣ ದೆಬೆಲೆ" },
            { "nv", "ನವಾಜೊ" },
            { "ny", "ನ್ಯಾಂಜಾ" },
            { "oc", "ಒಸಿಟನ್" },
            { "oj", "ಒಜಿಬ್ವಾ" },
            { "om", "ಒರೊಮೊ" },
            { "or", "ಒಡಿಯ" },
            { "os", "ಒಸ್ಸೆಟಿಕ್" },
            { "pa", "ಪಂಜಾಬಿ" },
            { "pi", "ಪಾಲಿ" },
            { "pl", "ಪೊಲಿಶ್" },
            { "ps", "ಪಾಷ್ಟೋ" },
            { "pt", "ಪೋರ್ಚುಗೀಸ್" },
            { "qu", "ಕ್ವೆಚುವಾ" },
            { "rm", "ರೊಮಾನ್ಶ್" },
            { "rn", "ರುಂಡಿ" },
            { "ro", "ರೊಮೇನಿಯನ್" },
            { "ru", "ರಷ್ಯನ್" },
            { "rw", "ಕಿನ್ಯಾರ್‌ವಾಂಡಾ" },
            { "sa", "ಸಂಸ್ಕೃತ" },
            { "sc", "ಸರ್ಡೀನಿಯನ್" },
            { "sd", "ಸಿಂಧಿ" },
            { "se", "ಉತ್ತರ ಸಾಮಿ" },
            { "sg", "ಸಾಂಗೋ" },
            { "sh", "ಸರ್ಬೋ-ಕ್ರೊಯೇಶಿಯನ್" },
            { "si", metaValue_si },
            { "sk", "ಸ್ಲೋವಾಕ್" },
            { "sl", "ಸ್ಲೋವೇನಿಯನ್" },
            { "sm", "ಸಮೋವನ್" },
            { "sn", "ಶೋನಾ" },
            { "so", "ಸೊಮಾಲಿ" },
            { "sq", "ಅಲ್ಬೇನಿಯನ್" },
            { "sr", "ಸೆರ್ಬಿಯನ್" },
            { "ss", "ಸ್ವಾತಿ" },
            { "st", "ದಕ್ಷಿಣ ಸೋಥೋ" },
            { "su", metaValue_su },
            { "sv", "ಸ್ವೀಡಿಷ್" },
            { "sw", "ಸ್ವಹಿಲಿ" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "ತಾಜಿಕ್" },
            { "th", metaValue_th },
            { "ti", "ಟಿಗ್ರಿನ್ಯಾ" },
            { "tk", "ಟರ್ಕ್‌ಮೆನ್" },
            { "tl", metaValue_tl },
            { "tn", "ಸ್ವಾನಾ" },
            { "to", "ಟೋಂಗನ್" },
            { "tr", "ಟರ್ಕಿಶ್" },
            { "ts", "ಸೋಂಗಾ" },
            { "tt", "ಟಾಟರ್" },
            { "tw", "ಟ್ವಿ" },
            { "ty", "ಟಹೀಟಿಯನ್" },
            { "ug", "ಉಯಿಘರ್" },
            { "uk", "ಉಕ್ರೇನಿಯನ್" },
            { "ur", "ಉರ್ದು" },
            { "uz", "ಉಜ್ಬೇಕ್" },
            { "ve", "ವೆಂಡಾ" },
            { "vi", "ವಿಯೆಟ್ನಾಮೀಸ್" },
            { "vo", "ವೋಲಾಪುಕ್" },
            { "wa", "ವಾಲೂನ್" },
            { "wo", "ವೋಲೋಫ್" },
            { "xh", "ಕ್ಸೋಸ" },
            { "yi", "ಯಿಡ್ಡಿಶ್" },
            { "yo", "ಯೊರುಬಾ" },
            { "za", "ಝೂವಾಂಗ್" },
            { "zh", "ಚೈನೀಸ್" },
            { "zu", "ಜುಲು" },
            { "ace", "ಅಛಿನೀಸ್" },
            { "ach", "ಅಕೋಲಿ" },
            { "ada", "ಅಡಂಗ್ಮೆ" },
            { "ady", "ಅಡೈಘೆ" },
            { "afh", "ಆಫ್ರಿಹಿಲಿ" },
            { "agq", "ಅಘೆಮ್" },
            { "ain", "ಐನು" },
            { "akk", "ಅಕ್ಕಾಡಿಯನ್" },
            { "ale", "ಅಲೆಯುಟ್" },
            { "alt", "ದಕ್ಷಿಣ ಅಲ್ಟಾಯ್" },
            { "ang", "ಪ್ರಾಚೀನ ಇಂಗ್ಲೀಷ್" },
            { "ann", "ಒಬೊಲೊ" },
            { "anp", "ಆಂಗಿಕಾ" },
            { "arc", "ಅರಾಮಿಕ್" },
            { "arn", "ಮಪುಚೆ" },
            { "arp", "ಅರಪಾಹೋ" },
            { "ars", "ನ್ಯಾಜ್ಡಿ ಅರೇಬಿಕ್" },
            { "arw", "ಅರಾವಾಕ್" },
            { "asa", "ಅಸು" },
            { "ast", "ಆಸ್ಟುರಿಯನ್" },
            { "atj", "ಅತಿಕಮೆಕ್" },
            { "awa", "ಅವಧಿ" },
            { "bal", "ಬಲೂಚಿ" },
            { "ban", "ಬಲಿನೀಸ್" },
            { "bas", "ಬಸಾ" },
            { "bej", "ಬೇಜಾ" },
            { "bem", "ಬೆಂಬಾ" },
            { "bez", "ಬೆನ" },
            { "bgc", "ಹರ್ಯಾನ್ವಿ" },
            { "bgn", "ಪಶ್ಚಿಮ ಬಲೊಚಿ" },
            { "bho", "ಭೋಜಪುರಿ" },
            { "bik", "ಬಿಕೊಲ್" },
            { "bin", "ಬಿನಿ" },
            { "bla", "ಸಿಕ್ಸಿಕಾ" },
            { "blo", "ಅನೀ" },
            { "bra", "ಬ್ರಜ್" },
            { "brx", "ಬೋಡೊ" },
            { "bua", "ಬುರಿಯಟ್" },
            { "bug", "ಬುಗಿನೀಸ್" },
            { "byn", "ಬ್ಲಿನ್" },
            { "cad", "ಕ್ಯಾಡ್ಡೋ" },
            { "car", "ಕಾರಿಬ್" },
            { "cay", "ಕಯುಗಾ" },
            { "cch", "ಅಟ್ಸಮ್" },
            { "ccp", metaValue_ccp },
            { "ceb", "ಸೆಬುವಾನೊ" },
            { "cgg", "ಚಿಗಾ" },
            { "chb", "ಚಿಬ್ಚಾ" },
            { "chg", "ಚಗಟಾಯ್" },
            { "chk", "ಚೂಕಿಸೆ" },
            { "chm", "ಮಾರಿ" },
            { "chn", "ಚಿನೂಕ್ ಜಾರ್ಗೋನ್" },
            { "cho", "ಚೋಕ್ಟಾವ್" },
            { "chp", "ಚಿಪೆವ್ಯಾನ್" },
            { "chr", "ಚೆರೋಕಿ" },
            { "chy", "ಚೀಯೆನ್ನೇ" },
            { "ckb", "ಮಧ್ಯ ಕುರ್ದಿಶ್" },
            { "clc", "ಚಿಲ್ಕೋಟಿನ್" },
            { "cop", "ಕೊಪ್ಟಿಕ್" },
            { "crg", "ಮಿಚಿಫ್" },
            { "crh", "ಕ್ರಿಮೀಯನ್ ಟರ್ಕಿಷ್" },
            { "crj", "ದಕ್ಷಿಣ ಪೂರ್ವ ಕ್ರೀ" },
            { "crk", "ಪ್ಲೇನ್ಸ್ ಕ್ರೀ" },
            { "crl", "ಉತ್ತರ ಪೂರ್ವ ಕ್ರೀ" },
            { "crm", "ಮೂಸ್ ಕ್ರೀ" },
            { "crr", "ಕೆರೊಲಿನಾ ಅಲ್ಗೊಂಕ್ವಿಯನ್" },
            { "crs", "ಸೆಸೆಲ್ವಾ ಕ್ರಯೋಲ್ ಫ್ರೆಂಚ್" },
            { "csb", "ಕಶುಬಿಯನ್" },
            { "csw", "ಸ್ವಾಂಪಿ ಕ್ರೀ" },
            { "dak", "ಡಕೋಟಾ" },
            { "dar", "ದರ್ಗ್ವಾ" },
            { "dav", "ಟೈಟ" },
            { "del", "ಡೆಲಾವೇರ್" },
            { "den", "ಸ್ಲೇವ್" },
            { "dgr", "ಡೋಗ್ರಿಬ್" },
            { "din", "ಡಿಂಕಾ" },
            { "dje", "ಜರ್ಮಾ" },
            { "doi", "ಡೋಗ್ರಿ" },
            { "dsb", "ಲೋವರ್ ಸರ್ಬಿಯನ್" },
            { "dua", "ಡುವಾಲಾ" },
            { "dum", "ಮಧ್ಯ ಡಚ್" },
            { "dyo", "ಜೊಲ-ಫೊನ್ಯಿ" },
            { "dyu", "ಡ್ಯೂಲಾ" },
            { "dzg", "ಡಜಾಗ" },
            { "ebu", "ಎಂಬು" },
            { "efi", "ಎಫಿಕ್" },
            { "egy", "ಪ್ರಾಚೀನ ಈಜಿಪ್ಟಿಯನ್" },
            { "eka", "ಎಕಾಜುಕ್" },
            { "elx", "ಎಲಾಮೈಟ್" },
            { "enm", "ಮಧ್ಯ ಇಂಗ್ಲೀಷ್" },
            { "ewo", "ಇವಾಂಡೋ" },
            { "fan", "ಫಾಂಗ್" },
            { "fat", "ಫಾಂಟಿ" },
            { "fil", "ಫಿಲಿಪಿನೊ" },
            { "fon", "ಫೋನ್" },
            { "frc", "ಕಾಜುನ್ ಫ್ರೆಂಚ್" },
            { "frm", "ಮಧ್ಯ ಫ್ರೆಂಚ್" },
            { "fro", "ಪ್ರಾಚೀನ ಫ್ರೆಂಚ್" },
            { "frr", "ಉತ್ತರ ಫ್ರಿಸಿಯನ್" },
            { "frs", "ಪೂರ್ವ ಫ್ರಿಸಿಯನ್" },
            { "fur", "ಫ್ರಿಯುಲಿಯನ್" },
            { "gaa", "ಗ" },
            { "gag", "ಗಗೌಜ್" },
            { "gan", "ಗಾನ್ ಚೀನೀಸ್" },
            { "gay", "ಗಾಯೋ" },
            { "gba", "ಗ್ಬಾಯಾ" },
            { "gez", "ಗೀಝ್" },
            { "gil", "ಗಿಲ್ಬರ್ಟೀಸ್" },
            { "gmh", "ಮಧ್ಯ ಹೈ ಜರ್ಮನ್" },
            { "goh", "ಪ್ರಾಚೀನ ಹೈ ಜರ್ಮನ್" },
            { "gon", "ಗೊಂಡಿ" },
            { "gor", "ಗೊರೊಂಟಾಲೋ" },
            { "got", "ಗೋಥಿಕ್" },
            { "grb", "ಗ್ರೇಬೋ" },
            { "grc", "ಪ್ರಾಚೀನ ಗ್ರೀಕ್" },
            { "gsw", "ಸ್ವಿಸ್ ಜರ್ಮನ್" },
            { "guz", "ಗುಸಿ" },
            { "gwi", "ಗ್ವಿಚ್‌ಇನ್" },
            { "hai", "ಹೈಡಾ" },
            { "hak", "ಹಕ್" },
            { "haw", "ಹವಾಯಿಯನ್" },
            { "hax", "ದಕ್ಷಿಣ ಹೈಡಾ" },
            { "hil", "ಹಿಲಿಗೇನನ್" },
            { "hit", "ಹಿಟ್ಟಿಟೆ" },
            { "hmn", "ಮೋಂಗ್" },
            { "hsb", "ಅಪ್ಪರ್ ಸರ್ಬಿಯನ್" },
            { "hsn", "ಶಯಾಂಗ್ ಚೀನೀಸೇ" },
            { "hup", "ಹೂಪಾ" },
            { "hur", "ಹಾಲ್ಕೊಮೆಲೆಮ್" },
            { "iba", "ಇಬಾನ್" },
            { "ibb", "ಇಬಿಬಿಯೋ" },
            { "ikt", "ಪಶ್ಚಿಮ ಕೆನಡಿಯನ್ ಇನುಕ್ಟಿಟುಟ್" },
            { "ilo", "ಇಲ್ಲಿಕೋ" },
            { "inh", "ಇಂಗುಷ್" },
            { "jbo", "ಲೊಜ್ಬಾನ್" },
            { "jgo", "ನೊಂಬಾ" },
            { "jmc", "ಮ್ಯಕಮೆ" },
            { "jpr", "ಜೂಡಿಯೋ-ಪರ್ಶಿಯನ್" },
            { "jrb", "ಜೂಡಿಯೋ-ಅರೇಬಿಕ್" },
            { "kaa", "ಕಾರಾ-ಕಲ್ಪಾಕ್" },
            { "kab", "ಕಬೈಲ್" },
            { "kac", "ಕಚಿನ್" },
            { "kaj", "ಜ್ಜು" },
            { "kam", "ಕಂಬಾ" },
            { "kaw", "ಕಾವಿ" },
            { "kbd", "ಕಬರ್ಡಿಯನ್" },
            { "kcg", "ಟ್ಯಾಪ್" },
            { "kde", "ಮ್ಯಾಕೊಂಡ್" },
            { "kea", "ಕಬುವೆರ್ಡಿಯನು" },
            { "kfo", "ಕೋರೋ" },
            { "kgp", "ಕೈಗಂಗ್" },
            { "kha", "ಖಾಸಿ" },
            { "kho", "ಖೋಟಾನೀಸ್" },
            { "khq", "ಕೊಯ್ರ ಚೀನಿ" },
            { "kkj", "ಕಾಕೊ" },
            { "kln", "ಕಲೆಂಜಿನ್" },
            { "kmb", "ಕಿಂಬುಂಡು" },
            { "koi", "ಕೋಮಿ-ಪರ್ಮ್ಯಕ್" },
            { "kok", "ಕೊಂಕಣಿ" },
            { "kos", "ಕೊಸರಿಯನ್" },
            { "kpe", "ಕಪೆಲ್ಲೆ" },
            { "krc", "ಕರಚಯ್-ಬಲ್ಕಾರ್" },
            { "krl", "ಕರೇಲಿಯನ್" },
            { "kru", "ಕುರುಖ್" },
            { "ksb", "ಶಂಬಲ" },
            { "ksf", "ಬಫಿಯ" },
            { "ksh", "ಕಲೊಗ್ನಿಯನ್" },
            { "kum", "ಕುಮೈಕ್" },
            { "kut", "ಕುಟೇನಾಯ್" },
            { "kwk", "ಕ್ವಾಕ್‌ವಾಲಾ" },
            { "kxv", "ಕುವಿ" },
            { "lad", "ಲ್ಯಾಡಿನೋ" },
            { "lag", "ಲಾಂಗಿ" },
            { "lah", "ಲಹಂಡಾ" },
            { "lam", "ಲಂಬಾ" },
            { "lez", "ಲೆಜ್ಘಿಯನ್" },
            { "lij", "ಲಿಗುರಿಯನ್" },
            { "lil", "ಲಿಲ್ಲೂವೆಟ್" },
            { "lkt", "ಲಕೊಟ" },
            { "lmo", "ಲೋಂಬರ್ಡ್" },
            { "lol", "ಮೊಂಗೋ" },
            { "lou", "ಲೂಯಿಸಿಯಾನ ಕ್ರಿಯೋಲ್" },
            { "loz", "ಲೋಝಿ" },
            { "lrc", "ಉತ್ತರ ಲೂರಿ" },
            { "lsm", "ಸಾಮಿಯಾ" },
            { "lua", "ಲುಬ-ಲುಲಾ" },
            { "lui", "ಲೂಯಿಸೆನೋ" },
            { "lun", "ಲುಂಡಾ" },
            { "luo", "ಲುವೋ" },
            { "lus", "ಮಿಝೋ" },
            { "luy", "ಲುಯಿಯ" },
            { "mad", "ಮದುರೀಸ್" },
            { "mag", "ಮಗಾಹಿ" },
            { "mai", "ಮೈಥಿಲಿ" },
            { "mak", "ಮಕಾಸರ್" },
            { "man", "ಮಂಡಿಂಗೊ" },
            { "mas", "ಮಸಾಯ್" },
            { "mdf", "ಮೋಕ್ಷ" },
            { "mdr", "ಮಂದಾರ್" },
            { "men", "ಮೆಂಡೆ" },
            { "mer", "ಮೆರು" },
            { "mfe", "ಮೊರಿಸನ್" },
            { "mga", "ಮಧ್ಯ ಐರಿಷ್" },
            { "mgh", "ಮ್ಯಖುವಾ- ಮೀಟ್ಟೊ" },
            { "mgo", "ಮೆಟಾ" },
            { "mic", "ಮಿಕ್‌ಮ್ಯಾಕ್" },
            { "min", "ಮಿನಂಗ್‌ಕಬಾವು" },
            { "mnc", "ಮಂಚು" },
            { "mni", "ಮಣಿಪುರಿ" },
            { "moe", "ಇನ್ನು-ಐಮುನ್" },
            { "moh", "ಮೊಹಾವ್ಕ್" },
            { "mos", "ಮೊಸ್ಸಿ" },
            { "mua", "ಮುಂಡಂಗ್" },
            { "mul", "ಬಹುಸಂಖ್ಯೆಯ ಭಾಷೆಗಳು" },
            { "mus", "ಕ್ರೀಕ್" },
            { "mwl", "ಮಿರಾಂಡೀಸ್" },
            { "mwr", "ಮಾರ್ವಾಡಿ" },
            { "myv", "ಎರ್ಝ್ಯಾ" },
            { "mzn", "ಮಜಂದೆರಾನಿ" },
            { "nan", "ನಾನ್" },
            { "nap", "ನಿಯಾಪೊಲಿಟನ್" },
            { "naq", "ನಮ" },
            { "nds", "ಲೋ ಜರ್ಮನ್" },
            { "new", "ನೇವಾರೀ" },
            { "nia", "ನಿಯಾಸ್" },
            { "niu", "ನಿಯುವನ್" },
            { "nmg", "ಖ್ವಾಸಿಯೊ" },
            { "nnh", "ನಿಂಬೂನ್" },
            { "nog", "ನೊಗಾಯ್" },
            { "non", "ಪ್ರಾಚೀನ ನೋರ್ಸ್" },
            { "nqo", "ಎನ್‌ಕೋ" },
            { "nso", "ಉತ್ತರ ಸೋಥೋ" },
            { "nus", "ನೂಯರ್" },
            { "nwc", "ಶಾಸ್ತ್ರೀಯ ನೇವಾರಿ" },
            { "nym", "ನ್ಯಾಮ್‌ವೆಂಜಿ" },
            { "nyn", "ನ್ಯಾನ್‌ಕೋಲೆ" },
            { "nyo", "ನ್ಯೋರೋ" },
            { "nzi", "ಜೀಮಾ" },
            { "ojb", "ವಾಯುವ್ಯ ಓಜಿಬ್ವಾ" },
            { "ojc", "ಮಧ್ಯ ಓಜಿಬ್ವಾ" },
            { "ojs", "ಓಜಿ-ಕ್ರೀ" },
            { "ojw", "ಪಶ್ಚಿಮ ಓಜಿಬ್ವಾ" },
            { "oka", "ಒಕನಾಗನ್" },
            { "osa", "ಓಸಾಜ್" },
            { "ota", "ಒಟ್ಟೋಮನ್ ತುರ್ಕಿಷ್" },
            { "pag", "ಪಂಗಾಸಿನನ್" },
            { "pal", "ಪಹ್ಲವಿ" },
            { "pam", "ಪಂಪಾಂಗಾ" },
            { "pap", "ಪಪಿಯಾಮೆಂಟೊ" },
            { "pau", "ಪಲುಆನ್" },
            { "pcm", "ನೈಜೀರಿಯನ್ ಪಿಡ್ಗಿನ್" },
            { "peo", metaValue_peo },
            { "phn", "ಫೀನಿಷಿಯನ್" },
            { "pis", "ಪಿಜಿನ್" },
            { "pon", "ಪೋನ್‌‌ಪಿಯನ್" },
            { "pqm", "ಮ್ಯಾಲಿಸೀಟ್-ಪಸ್ಸಾಮಕ್ವಾಡ್ಡಿ" },
            { "prg", "ಪ್ರಶಿಯನ್" },
            { "pro", "ಪ್ರಾಚೀನ ಪ್ರೊವೆನ್ಶಿಯಲ್" },
            { "quc", "ಕಿಷೆ" },
            { "raj", "ರಾಜಸ್ಥಾನಿ" },
            { "rap", "ರಾಪಾನುಯಿ" },
            { "rar", "ರಾರೋಟೊಂಗನ್" },
            { "rhg", "ರೋಹಿಂಗ್ಯಾ" },
            { "rof", "ರೊಂಬೊ" },
            { "rom", "ರೋಮಾನಿ" },
            { "rup", "ಅರೋಮಾನಿಯನ್" },
            { "rwk", "ರುವ" },
            { "sad", "ಸಂಡಾವೇ" },
            { "sah", "ಸಖಾ" },
            { "sam", "ಸಮರಿಟನ್ ಅರಾಮಿಕ್" },
            { "saq", "ಸಂಬುರು" },
            { "sas", "ಸಸಾಕ್" },
            { "sat", "ಸಂತಾಲಿ" },
            { "sba", "ನಂಬೇ" },
            { "sbp", "ಸಂಗು" },
            { "scn", "ಸಿಸಿಲಿಯನ್" },
            { "sco", "ಸ್ಕೋಟ್ಸ್" },
            { "sdh", "ದಕ್ಷಿಣ ಕುರ್ದಿಶ್" },
            { "seh", "ಸೆನ" },
            { "sel", "ಸೆಲ್ಕಪ್" },
            { "ses", "ಕೊಯ್ರಬೊರೊ ಸೆನ್ನಿ" },
            { "sga", "ಪ್ರಾಚೀನ ಐರಿಷ್" },
            { "shi", "ಟಷೆಲ್‍ಹಿಟ್" },
            { "shn", "ಶಾನ್" },
            { "sid", "ಸಿಡಾಮೋ" },
            { "slh", "ದಕ್ಷಿಣ ಲುಶೂಟ್‌ಸೀಡ್" },
            { "sma", "ದಕ್ಷಿಣ ಸಾಮಿ" },
            { "smj", "ಲೂಲ್ ಸಾಮಿ" },
            { "smn", "ಇನಾರಿ ಸಮೀ" },
            { "sms", "ಸ್ಕೋಟ್ ಸಾಮಿ" },
            { "snk", "ಸೋನಿಂಕೆ" },
            { "sog", "ಸೋಗ್ಡಿಯನ್" },
            { "srn", "ಸ್ರಾನನ್ ಟೋಂಗೋ" },
            { "srr", "ಸೇರೇರ್" },
            { "ssy", "ಸಹೊ" },
            { "str", "ಸ್ಟ್ರೇಟ್ಸ್ ಸೆಲಿಶ್" },
            { "suk", "ಸುಕುಮಾ" },
            { "sus", "ಸುಸು" },
            { "sux", "ಸುಮೇರಿಯನ್" },
            { "swb", "ಕೊಮೊರಿಯನ್" },
            { "syc", "ಶಾಸ್ತ್ರೀಯ ಸಿರಿಯಕ್" },
            { "syr", metaValue_syr },
            { "szl", "ಸಿಲೆಸಿಯನ್" },
            { "tce", "ದಕ್ಷಿಣ ಟಚ್‌ವನ್" },
            { "tem", "ಟಿಮ್ನೆ" },
            { "teo", "ಟೆಸೊ" },
            { "ter", "ಟೆರೆನೋ" },
            { "tet", "ಟೇಟಮ್" },
            { "tgx", "ಟಾಗಿಶ್" },
            { "tht", "ಟಾಹ್ಲ್ಟನ್" },
            { "tig", "ಟೈಗ್ರೆ" },
            { "tiv", "ಟಿವ್" },
            { "tkl", metaValue_TK },
            { "tlh", "ಕ್ಲಿಂಗನ್" },
            { "tli", "ಟ್ಲಿಂಗಿಟ್" },
            { "tmh", "ಟಮಾಷೆಕ್" },
            { "tog", "ನ್ಯಾಸಾ ಟೋಂಗಾ" },
            { "tok", "ಟೋಕಿ ಪೋನಾ" },
            { "tpi", "ಟೋಕ್ ಪಿಸಿನ್" },
            { "trv", "ಟರೊಕೊ" },
            { "tsi", "ಸಿಂಶಿಯನ್" },
            { "ttm", "ಉತ್ತರ ಟಚ್‌ವನ್" },
            { "tum", "ತುಂಬುಕಾ" },
            { "tvl", metaValue_TV },
            { "twq", "ಟಸವಕ್" },
            { "tyv", "ಟುವಿನಿಯನ್" },
            { "tzm", "ಮಧ್ಯ ಅಟ್ಲಾಸ್ ಟಮಜೈಟ್" },
            { "udm", "ಉಡ್‌ಮುರ್ಟ್" },
            { "uga", metaValue_uga },
            { "umb", "ಉಂಬುಂಡು" },
            { "und", "ಅಪರಿಚಿತ ಭಾಷೆ" },
            { "vai", "ವಾಯಿ" },
            { "vec", "ವೆನಿಶಿಯನ್" },
            { "vmw", "ಮಖುವಾ" },
            { "vot", "ವೋಟಿಕ್" },
            { "vun", "ವುಂಜೊ" },
            { "wae", "ವಾಲ್ಸರ್" },
            { "wal", "ವಲಾಯ್ತಾ" },
            { "war", "ವರಾಯ್" },
            { "was", "ವಾಷೋ" },
            { "wbp", "ವಾರ್ಲ್‌ಪಿರಿ" },
            { "wuu", "ವು ಚೈನೀಸ್" },
            { "xal", "ಕಲ್ಮೈಕ್" },
            { "xnr", "ಕಂಗ್ರಿ" },
            { "xog", "ಸೊಗ" },
            { "yao", "ಯಾವೊ" },
            { "yap", "ಯಪೀಸೆ" },
            { "yav", "ಯಾಂಗ್ಬೆನ್" },
            { "ybb", "ಯೆಂಬಾ" },
            { "yrl", "ನಿಂಗಾಟು" },
            { "yue", "ಕ್ಯಾಂಟನೀಸ್" },
            { "zap", "ಝೋಪೊಟೆಕ್" },
            { "zbl", "ಬ್ಲಿಸ್ಸಿಂಬಲ್ಸ್" },
            { "zen", "ಝೆನಾಗಾ" },
            { "zgh", "ಸ್ಟ್ಯಾಂಡರ್ಡ್ ಮೊರೊಕ್ಕನ್ ಟಮಜೈಟ್" },
            { "zun", "ಝೂನಿ" },
            { "zxx", "ಯಾವುದೇ ಭಾಷಾಸಂಬಂಧಿ ವಿಷಯವಿಲ್ಲ" },
            { "zza", "ಜಾಝಾ" },
            { "Adlm", "ಆ್ಯಡ್ಲಮ್" },
            { "Arab", metaValue_ar },
            { "Aran", "ನಸ್ಟಾಲಿಕ್" },
            { "Armi", "ಇಂಪೀರಿಯಲ್ ಅರೆಮಾಯಿಕ್" },
            { "Armn", metaValue_hy },
            { "Avst", "ಅವೆಸ್ತಾನ್" },
            { "Bali", "ಬಾಲಿನೀಸ್" },
            { "Batk", "ಬಾಟಕ್" },
            { "Beng", "ಬೆಂಗಾಲಿ" },
            { "Blis", "ಬ್ಲಿಸ್‌ಸಿಂಬಲ್ಸ್" },
            { "Bopo", "ಬೋಪೊಮೋಫೋ" },
            { "Brah", "ಬ್ರಾಹ್ಮಿ" },
            { "Brai", "ಬ್ರೈಲ್" },
            { "Bugi", "ಬಗಿನೀಸ್" },
            { "Buhd", "ಬುಹಿದ್" },
            { "Cakm", metaValue_ccp },
            { "Cans", "ಯುನಿಫೈಯ್ಡ್ ಕೆನೆಡಿಯನ್ ಅಬೊರಿಜಿನಲ್ ಸಿಲ್ಯಾಬಿಕ್ಸ್" },
            { "Cari", "ಕರೇನ್" },
            { "Cham", "ಚಾಮ್" },
            { "Cher", "ಚೆರೋಕೀ" },
            { "Cirt", "ಸಿರ್ಥ್" },
            { "Copt", "ಕಾಪ್ಟಿಕ್" },
            { "Cprt", "ಸಿಪ್ರಿಯಾಟ್" },
            { "Cyrl", "ಸಿರಿಲಿಕ್" },
            { "Cyrs", "ಪ್ರಾಚೀನ ಚರ್ಚ್ ಸ್ಲೋವಾನಿಕ್ ಸಿರಿಲಿಕ್" },
            { "Deva", "ದೇವನಾಗರಿ" },
            { "Dsrt", "ಡಸರ್ಟ್" },
            { "Egyd", "ಈಜಿಪ್ಟಿಯನ್ ಡೆಮೋಟಿಕ್" },
            { "Egyh", "ಈಜಿಪ್ಟಿಯನ್ ಹಯಾರಿಟಿಕ್" },
            { "Egyp", "ಈಜಿಪ್ಟಿಯನ್ ಹೀರೋಗ್ಲಿಫ್ಸ್" },
            { "Ethi", "ಇಥಿಯೋಪಿಕ್" },
            { "Geok", "ಜಾರ್ಜಿಯನ್ ಖುಸ್ತುರಿ" },
            { "Geor", metaValue_ka },
            { "Glag", "ಗ್ಲಾಗೋಲಿಟಿಕ್" },
            { "Goth", "ಗೋತಿಕ್" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "ಗುರ್ಮುಖಿ" },
            { "Hanb", "ಬೋಪೋಮೊಫೋ ಜೊತೆಗೆ ಹಾನ್" },
            { "Hang", "ಹ್ಯಾಂಗುಲ್" },
            { "Hani", "ಹಾನ್" },
            { "Hano", "ಹನೂನೂ" },
            { "Hans", "ಸರಳೀಕೃತ" },
            { "Hant", "ಸಾಂಪ್ರದಾಯಿಕ" },
            { "Hebr", metaValue_he },
            { "Hira", "ಹಿರಾಗನ" },
            { "Hmng", "ಪಹವ್ ಹ್ಮೋಂಗ್" },
            { "Hrkt", "ಜಪಾನೀಸ್ ಸಿಲಬರೀಸ್" },
            { "Hung", "ಪ್ರಾಚೀನ ಹಂಗೇರಿಯನ್" },
            { "Inds", "ಸಿಂಧೂ" },
            { "Ital", "ಪ್ರಾಚೀನ್ ಇಟಾಲಿಕ್" },
            { "Jamo", "ಜಮೋ" },
            { "Java", "ಜಾವನೀಸ್" },
            { "Jpan", metaValue_ja },
            { "Kali", "ಕೆಯಾ ಲಿ" },
            { "Kana", "ಕಟಕಾನಾ" },
            { "Khar", "ಖರೋಶ್ತಿ" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "ಕೈಥಿ" },
            { "Lana", "ಲಾನಾ" },
            { "Laoo", metaValue_lo },
            { "Latf", "ಫ್ರಾಕ್ತರ್ ಲ್ಯಾಟಿನ್" },
            { "Latg", "ಗೇಲಿಕ್ ಲ್ಯಾಟಿನ್" },
            { "Latn", metaValue_la },
            { "Lepc", "ಲೆಪ್ಚಾ" },
            { "Limb", "ಲಿಂಬು" },
            { "Lina", "ಲೀನಯರ್ ಎ" },
            { "Linb", "ಲೀನಯರ್ ಬಿ" },
            { "Lyci", "ಲೈಸಿಯನ್" },
            { "Lydi", "ಲಿಡಿಯನ್" },
            { "Mand", "ಮಂಡೇಯನ್" },
            { "Mani", "ಮನಿಚೈಯನ್" },
            { "Maya", "ಮಯಾನ್ ಹೀರೋಗ್ಲಿಫ್ಸ್" },
            { "Mero", "ಮೆರೊಯಿಟಿಕ್" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "ಮೂನ್" },
            { "Mtei", "ಮೈತಿ ಮಯೆಕ್" },
            { "Mymr", "ಮ್ಯಾನ್ಮಾರ್" },
            { "Nkoo", "ಎನ್‍ಕೋ" },
            { "Ogam", "ಓಘಮ್" },
            { "Olck", "ಓಲ್ ಚಿಕಿ" },
            { "Orkh", "ಓರ್ಖೋನ್" },
            { "Orya", "ಒಡಿಯಾ" },
            { "Osma", "ಓಸ್ಮಾನ್ಯಾ" },
            { "Perm", "ಪ್ರಾಚೀನ ಪೆರ್ಮಿಕ್" },
            { "Phag", "ಫಾಗ್ಸ್-ಪಾ" },
            { "Phli", "ಇನ್ಸ್‌ಕ್ರಿಪ್ಶನಲ್ ಪಾಹ್ಲವಿ" },
            { "Phlp", "ಸಾಲ್ಟರ್ ಪಾಹ್ಲವಿ" },
            { "Phlv", "ಬುಕ್ ಪಾಹ್ಲವಿ" },
            { "Phnx", "ಫೀನಿಶಿಯನ್" },
            { "Plrd", "ಪೊಲ್ಲಾರ್ಡ್ ಫೊನೆಟಿಕ್" },
            { "Prti", "ಇನ್ಸ್‌ಕ್ರಿಪ್ಶನಲ್ ಪಾರ್ಥಿಯನ್" },
            { "Rjng", "ರೆಜಾಂಗ್" },
            { "Rohg", "ಹನೀಫಿ" },
            { "Roro", "ರೋಂಗೋರೋಂಗೋ" },
            { "Runr", "ರೂನಿಕ್" },
            { "Samr", "ಸಮಾರಿಟನ್" },
            { "Sara", "ಸರಾಟಿ" },
            { "Saur", "ಸೌರಾಷ್ಟ್ರ" },
            { "Sgnw", "ಸೈನ್‌ರೈಟಿಂಗ್" },
            { "Shaw", "ಶಾವಿಯಾನ್" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Sylo", "ಸೈಲೋಟಿ ನಗ್ರಿ" },
            { "Syrc", metaValue_syr },
            { "Syre", "ಎಸ್ಟ್ರಾಂಜಿಲೋ ಸಿರಿಯಾಕ್" },
            { "Syrj", "ಪಶ್ಚಿಮ ಸಿರಿಯಾಕ್" },
            { "Syrn", "ಪೂರ್ವ ಸಿರಿಯಾಕ್" },
            { "Tagb", "ಟಾಗ್ಬಾನವಾ" },
            { "Tale", "ಥಾಯ್ ಲಿ" },
            { "Talu", "ನ್ಯೂ ಥಾಯ್ ಲುಇ" },
            { "Taml", metaValue_ta },
            { "Tavt", "ಥಾಯ್ ವಿಯೆಟ್" },
            { "Telu", metaValue_te },
            { "Teng", "ತೆಂಗ್‌ವಾರ್" },
            { "Tfng", "ಟಿಫಿನಾಘ್" },
            { "Tglg", metaValue_tl },
            { "Thaa", "ಥಾನಾ" },
            { "Thai", metaValue_th },
            { "Tibt", "ಟಿಬೇಟನ್" },
            { "Ugar", metaValue_uga },
            { "Vaii", "ವಾಯ್" },
            { "Visp", "ವಿಸಿಬಲ್ ಸ್ಪೀಚ್" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "ಸುಮೇರೋ-ಅಕ್ಕಾಡಿಯನ್ ಕ್ಯೂನಿಫಾರ್ಮ್" },
            { "Yiii", "ಯಿ" },
            { "Zinh", "ಇನ್‍ಹೆರಿಟೆಡ್" },
            { "Zmth", "ಗಣಿತ ಸಂಕೇತಲಿಪಿ" },
            { "Zsye", "ಎಮೋಜಿ" },
            { "Zsym", "ಸಂಕೇತಗಳು" },
            { "Zxxx", "ಅಲಿಖಿತ" },
            { "Zyyy", "ಸಾಮಾನ್ಯ" },
            { "Zzzz", "ಅಪರಿಚಿತ ಲಿಪಿ" },
            { "de_AT", "ಆಸ್ಟ್ರಿಯನ್ ಜರ್ಮನ್" },
            { "de_CH", "ಸ್ವಿಸ್ ಹೈ ಜರ್ಮನ್" },
            { "en_AU", "ಆಸ್ಟ್ರೇಲಿಯನ್ ಇಂಗ್ಲಿಷ್" },
            { "en_CA", "ಕೆನೆಡಿಯನ್ ಇಂಗ್ಲಿಷ್" },
            { "en_GB", "ಬ್ರಿಟಿಷ್ ಇಂಗ್ಲಿಷ್" },
            { "en_US", "ಅಮೆರಿಕನ್ ಇಂಗ್ಲಿಷ್" },
            { "es_ES", "ಯುರೋಪಿಯನ್ ಸ್ಪ್ಯಾನಿಷ್" },
            { "es_MX", "ಮೆಕ್ಸಿಕನ್ ಸ್ಪ್ಯಾನಿಷ್" },
            { "fa_AF", "ದರಿ" },
            { "fr_CA", "ಕೆನೆಡಿಯನ್ ಫ್ರೆಂಚ್" },
            { "fr_CH", "ಸ್ವಿಸ್ ಫ್ರೆಂಚ್" },
            { "nl_BE", "ಫ್ಲೆಮಿಷ್" },
            { "pt_BR", "ಬ್ರೆಜಿಲಿಯನ್ ಪೋರ್ಚುಗೀಸ್" },
            { "pt_PT", "ಯೂರೋಪಿಯನ್ ಪೋರ್ಚುಗೀಸ್" },
            { "ro_MD", "ಮಾಲ್ಡೇವಿಯನ್" },
            { "sw_CD", "ಕಾಂಗೊ ಸ್ವಹಿಲಿ" },
            { "ar_001", "ಆಧುನಿಕ ಪ್ರಮಾಣಿತ ಅರೇಬಿಕ್" },
            { "es_419", "ಲ್ಯಾಟಿನ್ ಅಮೇರಿಕನ್ ಸ್ಪ್ಯಾನಿಷ್" },
            { "key.ca", "ಕ್ಯಾಲೆಂಡರ್" },
            { "key.cf", "ಕರೆನ್ಸಿ ಸ್ವರೂಪ" },
            { "key.co", "ವಿಂಗಡಣೆ ಕ್ರಮ" },
            { "key.cu", "ಕರೆನ್ಸಿ" },
            { "key.em", "ಎಮೋಜಿ ಪ್ರೆಸೆಂಟೇಶನ್" },
            { "key.hc", "ಕಾಲ ಚಕ್ರ (12 ವಿರುದ್ಧ 24)" },
            { "key.lb", "ಲೈನ್ ಬ್ರೇಕ್ ಶೈಲಿ" },
            { "key.lw", "ಪದಗಳ ಮಧ್ಯ ಲೈನ್ ಬ್ರೇಕ್‌ಗಳು" },
            { "key.ms", "ಮಾಪನ ವ್ಯವಸ್ಥೆ" },
            { "key.nu", "ಸಂಖ್ಯೆಗಳು" },
            { "key.ss", "ಸಂಕ್ಷಿಪ್ತರೂಪದ ನಂತರ ವಾಕ್ಯ ವಿರಾಮ" },
            { "key.tz", "ಸಮಯ ವಲಯ" },
            { "key.va", "ಸ್ಥಳೀಯ ಭಿನ್ನತೆ" },
            { "nds_NL", "ಲೋ ಸ್ಯಾಕ್ಸನ್" },
            { "zh_Hans", "ಸರಳೀಕೃತ ಚೈನೀಸ್" },
            { "zh_Hant", "ಸಾಂಪ್ರದಾಯಿಕ ಚೈನೀಸ್" },
            { "%%PINYIN", "ಪಿನ್‌ಯಿನ್ ರೋಮನೈಸೇಶನ್" },
            { "%%WADEGILE", "ವೇಡ್-ಗೈಲ್ಸ್ ರೋಮನೈಸೇಶನ್" },
            { "type.ca.roc", "ಮಿಂಗೋ ಕ್ಯಾಲೆಂಡರ್" },
            { "type.co.eor", "ಯುರೋಪಿನ ಅನುಕ್ರಮ ನಿಯಮಗಳು" },
            { "type.hc.h11", "12 ಗಂಟೆ ವ್ಯವಸ್ಥೆ (0–11)" },
            { "type.hc.h12", "12 ಗಂಟೆ ವ್ಯವಸ್ಥೆ (1–12)" },
            { "type.hc.h23", "24 ಗಂಟೆ ವ್ಯವಸ್ಥೆ (0–23)" },
            { "type.hc.h24", "24 ಗಂಟೆ ವ್ಯವಸ್ಥೆ (1–24)" },
            { "type.m0.bgn", "ಯುಎಸ್ ಬಿಜಿಎನ್ ಲಿಪ್ಯಂತರಣ" },
            { "type.nu.arab", "ಅರೇಬಿಕ್-ಇಂಡಿಕ್ ಅಂಕೆಗಳು" },
            { "type.nu.armn", "ಆರ್ಮೇನಿಯಾದ ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.beng", "ಬಾಂಗ್ಲಾ ಅಂಕೆಗಳು" },
            { "type.nu.cakm", "ಚಕ್ಮಾ ಅಂಕೆಗಳು" },
            { "type.nu.deva", "ದೇವನಾಗರಿ ಅಂಕೆಗಳು" },
            { "type.nu.ethi", "ಇಥಿಯೋಪಿಯಾದ ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.geor", "ಜಾರ್ಜಿಯಾದ ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.grek", "ಗ್ರೀಕ್ ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.gujr", "ಗುಜರಾತಿ ಅಂಕೆಗಳು" },
            { "type.nu.guru", "ಗುರ್ಮುಖಿ ಅಂಕೆಗಳು" },
            { "type.nu.hans", "ಸರಳೀಕೃತ ಚೀನಿ ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.hant", "ಸಾಂಪ್ರದಾಯಿಕ ಚೀನಿ ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.hebr", "ಹೀಬ್ರೂ ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.java", "ಜಾವಾನೀಸ್ ಅಂಕೆಗಳು" },
            { "type.nu.jpan", "ಜಪಾನೀ ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.khmr", "ಖಮೆ ಅಂಕೆಗಳು" },
            { "type.nu.knda", "ಕನ್ನಡ ಅಂಕೆಗಳು" },
            { "type.nu.laoo", "ಲಾವೋ ಅಂಕೆಗಳು" },
            { "type.nu.latn", "ಪಾಶ್ಚಿಮಾತ್ಯ ಅಂಕೆಗಳು" },
            { "type.nu.mlym", "ಮಲಯಾಳಂ ಅಂಕಿಗಳು" },
            { "type.nu.mong", "ಮಂಗೋಲಿಯಾದ ಅಂಕೆಗಳು" },
            { "type.nu.mtei", "ಮೈಟಿ ಮಯೆಕ್ ಅಂಕೆಗಳು" },
            { "type.nu.mymr", "ಮ್ಯಾನ್ಮಾರ್ ಅಂಕೆಗಳು" },
            { "type.nu.olck", "ಓಲ್ ಚಿಕಿ ಅಂಕೆಗಳು" },
            { "type.nu.orya", "ಒರಿಯಾ ಅಂಕೆಗಳು" },
            { "type.nu.taml", "ಸಾಂಪ್ರದಾಯಿಕ ತಮಿಳು ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.telu", "ತೆಲುಗು ಅಂಕೆಗಳು" },
            { "type.nu.thai", "ಥಾಯ್ ಅಂಕೆಗಳು" },
            { "type.nu.tibt", "ಟಿಬೇಟಿಯನ್ ಅಂಕೆಗಳು" },
            { "type.nu.vaii", "ವಾಯ್ ಅಂಕೆಗಳು" },
            { "type.ca.dangi", "ಡಾಂಗಿ ಕ್ಯಾಲೆಂಡರ್" },
            { "type.co.ducet", "ಡೀಫಾಲ್ಟ್ ಯೂನಿಕೋಡ್ ವಿಂಗಡಣೆ ಕ್ರಮ" },
            { "type.lb.loose", "ಲೂಸ್ ಲೈನ್ ಬ್ರೇಕ್ ಶೈಲಿ" },
            { "type.nu.roman", "ರೋಮನ್ ಸಂಖ್ಯೆಗಳು" },
            { "type.ca.coptic", "ಕೋಪ್ಟಿಕ್ ಕ್ಯಾಲೆಂಡರ್" },
            { "type.ca.hebrew", "ಹೀಬ್ರೂ ಕ್ಯಾಲೆಂಡರ್" },
            { "type.ca.indian", "ಭಾರತೀಯ ರಾಷ್ಟ್ರೀಯ ಕ್ಯಾಲೆಂಡರ್" },
            { "type.co.compat", "ಹೊಂದಾಣಿಕೆಯ ಸಲುವಾಗಿ ಹಿಂದಿನ ವಿಂಗಡಣಾ ಕ್ರಮ" },
            { "type.co.pinyin", "ಪಿನ್‌ಯಿನ್ ವಿಂಗಡಣೆ ಕ್ರಮ" },
            { "type.co.search", "ಸಾಮಾನ್ಯ- ಉದ್ದೇಶ ಹುಡುಕಾಟ" },
            { "type.co.stroke", "ಸ್ಟ್ರೋಕ್ ವಿಂಗಡಣೆ ಕ್ರಮ" },
            { "type.co.unihan", "ರ್ಯಾಡಿಕಲ್-ಸ್ಟ್ರೋಕ್ ವಿಂಗಡಣೆ ಕ್ರಮ" },
            { "type.d0.fwidth", "ಪೂರ್ಣಅಗಲಕ್ಕೆ" },
            { "type.d0.hwidth", "ಅರೆಅಗಲಕ್ಕೆ" },
            { "type.lb.normal", "ಸಾಮಾನ್ಯ ಲೈನ್ ಬ್ರೇಕ್ ಶೈಲಿ" },
            { "type.lb.strict", "ಕಟ್ಟುನಿಟ್ಟಾದ ಲೈನ್ ಬ್ರೇಕ್ ಶೈಲಿ" },
            { "type.m0.ungegn", "ಯುಎಸ್ ಜಿಇಜಿಎನ್ ಲಿಪ್ಯಂತರಣ" },
            { "type.ms.metric", "ಮೆಟ್ರಿಕ್ ಪದ್ಧತಿ" },
            { "type.nu.native", "ಸ್ಥಳೀಯ ಅಂಕೆಗಳು" },
            { "type.ca.chinese", "ಚೈನೀಸ್ ಕ್ಯಾಲೆಂಡರ್" },
            { "type.ca.islamic", "ಇಸ್ಲಾಮಿಕ್ ಕ್ಯಾಲೆಂಡರ್" },
            { "type.ca.iso8601", "ISO-8601 ಕ್ಯಾಲೆಂಡರ್" },
            { "type.ca.persian", "ಪರ್ಷಿಯನ್ ಕ್ಯಾಲೆಂಡರ್" },
            { "type.cf.account", "ಅಕೌಂಟಿಂಗ್ ಕರೆನ್ಸಿ ಸ್ವರೂಪ" },
            { "type.d0.npinyin", "ಸಂಖ್ಯೆ" },
            { "type.nu.arabext", "ವಿಸ್ತರಿಸಲಾದ ಅರೇಬಿಕ್-ಇಂಡಿಕ್ ಅಂಕೆಗಳು" },
            { "type.nu.armnlow", "ಅರ್ಮೇನಿಯಾದ ಸಣ್ಣಕ್ಷರ ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.finance", "ಆರ್ಥಿಕ ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.greklow", "ಗ್ರೀಕ್ ಲೋವರ್‌ಕೇಸ್ ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.hanidec", "ಚೀನಾದ ದಶಮಾಂಶ ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.hansfin", "ಸರಳೀಕೃತ ಚೀನಿ ಆರ್ಥಿಕ ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.hantfin", "ಸಾಂಪ್ರದಾಯಿಕ ಚೀನಿ ಆರ್ಥಿಕ ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.jpanfin", "ಜಪಾನೀ ಆರ್ಥಿಕ ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.tamldec", "ತಮಿಳು ಅಂಕೆಗಳು" },
            { "type.ca.buddhist", "ಬೌದ್ಧರ ಕ್ಯಾಲೆಂಡರ್" },
            { "type.ca.ethiopic", "ಇಥಿಯೋಪಿಕ್ ಕ್ಯಾಲೆಂಡರ್" },
            { "type.ca.japanese", "ಜಪಾನೀಸ್ ಕ್ಯಾಲೆಂಡರ್" },
            { "type.cf.standard", "ಪ್ರಮಾಣಿತ ಕರೆನ್ಸಿ ಸ್ವರೂಪ" },
            { "type.co.phonetic", "ಉಚ್ಛಾರಣಾನುರೂಪವಾಗಿ ವಿಂಗಡಣೆ ಕ್ರಮ" },
            { "type.co.searchjl", "ಹಂಗುಲ್ ಆದ್ಯಕ್ಷರ ವ್ಯಂಜನದ ಮೂಲಕ ಹುಡುಕಿ" },
            { "type.co.standard", "ಪ್ರಮಾಣೀಕೃತ ವಿಂಗಡಣೆ ಕ್ರಮ" },
            { "type.ms.uksystem", "ಇಂಪಿರಿಯಲ್ ಮಾಪನ ವ್ಯವಸ್ಥೆ" },
            { "type.ms.ussystem", "ಅಮೇರಿಕಾದ ಮಾಪನಾ ವ್ಯವಸ್ಥೆ" },
            { "type.nu.fullwide", "ಪೂರ್ಣ ಅಗಲವಾದ ಸಂಖ್ಯೆಗಳು" },
            { "type.nu.romanlow", "ರೋಮನ್ ಲೋವರ್‌ಕೇಸ್ ಸಂಖ್ಯೆಗಳು" },
            { "type.ca.gregorian", "ಗ್ರೆಗೋರಿಯನ್ ಕ್ಯಾಲೆಂಡರ್" },
            { "type.co.phonebook", "ಫೋನ್‌ಬುಕ್ ವಿಂಗಡಣೆ ಕ್ರಮ" },
            { "type.co.dictionary", "ಡಿಕ್ಷನರಿ ಅನುಕ್ರಮ ವಿನ್ಯಾಸ" },
            { "type.co.traditional", "ಸಾಂಪ್ರದಾಯಿಕ ವಿಂಗಡಣೆ ಕ್ರಮ" },
            { "type.nu.traditional", "ಸಾಂಪ್ರದಾಯಿಕ ಸಂಖ್ಯೆಗಳು" },
            { "type.ca.islamic-rgsa", "ಇಸ್ಲಾಮಿಕ್‌ ಕ್ಯಾಲೆಂಡರ್‌ (ಸೌದಿ ಅರೇಬಿಯಾ, ಸೈಟಿಂಗ್‌)bia, sighting)" },
            { "type.ca.islamic-civil", "ಇಸ್ಲಾಮಿಕ್-ಸಿವಿಲ್ ಕ್ಯಾಲೆಂಡರ್" },
            { "type.ca.islamic-umalqura", "ಇಸ್ಲಾಮಿಕ್ ಕ್ಯಾಲೆಂಡರ್ (ಉಮ್ ಅಲ್-ಖುರಾ)" },
            { "type.ca.ethiopic-amete-alem", "ಇಥಿಯೋಪಿಕ್ ಅಮೆಟೆ ಅಲೆಮ್ ಕ್ಯಾಲೆಂಡರ್" },
        };
        return data;
    }
}
