#[inline]
pub unsafe fn AmsiCloseSession(amsicontext: HAMSICONTEXT, amsisession: HAMSISESSION) {
    windows_link::link!("amsi.dll" "system" fn AmsiCloseSession(amsicontext : HAMSICONTEXT, amsisession : HAMSISESSION));
    unsafe { AmsiCloseSession(amsicontext, amsisession) }
}
#[inline]
pub unsafe fn AmsiInitialize<P0>(appname: P0) -> windows_core::Result<HAMSICONTEXT>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_link::link!("amsi.dll" "system" fn AmsiInitialize(appname : windows_core::PCWSTR, amsicontext : *mut HAMSICONTEXT) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        AmsiInitialize(appname.param().abi(), &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn AmsiNotifyOperation<P3>(amsicontext: HAMSICONTEXT, buffer: *const core::ffi::c_void, length: u32, contentname: P3) -> windows_core::Result<AMSI_RESULT>
where
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_link::link!("amsi.dll" "system" fn AmsiNotifyOperation(amsicontext : HAMSICONTEXT, buffer : *const core::ffi::c_void, length : u32, contentname : windows_core::PCWSTR, result : *mut AMSI_RESULT) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        AmsiNotifyOperation(amsicontext, buffer, length, contentname.param().abi(), &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn AmsiOpenSession(amsicontext: HAMSICONTEXT) -> windows_core::Result<HAMSISESSION> {
    windows_link::link!("amsi.dll" "system" fn AmsiOpenSession(amsicontext : HAMSICONTEXT, amsisession : *mut HAMSISESSION) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        AmsiOpenSession(amsicontext, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn AmsiScanBuffer<P3>(amsicontext: HAMSICONTEXT, buffer: *const core::ffi::c_void, length: u32, contentname: P3, amsisession: Option<HAMSISESSION>) -> windows_core::Result<AMSI_RESULT>
where
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_link::link!("amsi.dll" "system" fn AmsiScanBuffer(amsicontext : HAMSICONTEXT, buffer : *const core::ffi::c_void, length : u32, contentname : windows_core::PCWSTR, amsisession : HAMSISESSION, result : *mut AMSI_RESULT) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        AmsiScanBuffer(amsicontext, buffer, length, contentname.param().abi(), amsisession.unwrap_or(core::mem::zeroed()) as _, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn AmsiScanString<P1, P2>(amsicontext: HAMSICONTEXT, string: P1, contentname: P2, amsisession: Option<HAMSISESSION>) -> windows_core::Result<AMSI_RESULT>
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_link::link!("amsi.dll" "system" fn AmsiScanString(amsicontext : HAMSICONTEXT, string : windows_core::PCWSTR, contentname : windows_core::PCWSTR, amsisession : HAMSISESSION, result : *mut AMSI_RESULT) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        AmsiScanString(amsicontext, string.param().abi(), contentname.param().abi(), amsisession.unwrap_or(core::mem::zeroed()) as _, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn AmsiUninitialize(amsicontext: HAMSICONTEXT) {
    windows_link::link!("amsi.dll" "system" fn AmsiUninitialize(amsicontext : HAMSICONTEXT));
    unsafe { AmsiUninitialize(amsicontext) }
}
#[inline]
pub unsafe fn InstallELAMCertificateInfo(elamfile: super::super::Foundation::HANDLE) -> windows_core::Result<()> {
    windows_link::link!("kernel32.dll" "system" fn InstallELAMCertificateInfo(elamfile : super::super::Foundation:: HANDLE) -> windows_core::BOOL);
    unsafe { InstallELAMCertificateInfo(elamfile).ok() }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMSI_ATTRIBUTE(pub i32);
pub const AMSI_ATTRIBUTE_ALL_ADDRESS: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(8i32);
pub const AMSI_ATTRIBUTE_ALL_SIZE: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(7i32);
pub const AMSI_ATTRIBUTE_APP_NAME: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(0i32);
pub const AMSI_ATTRIBUTE_CONTENT_ADDRESS: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(3i32);
pub const AMSI_ATTRIBUTE_CONTENT_NAME: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(1i32);
pub const AMSI_ATTRIBUTE_CONTENT_SIZE: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(2i32);
pub const AMSI_ATTRIBUTE_QUIET: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(9i32);
pub const AMSI_ATTRIBUTE_REDIRECT_CHAIN_ADDRESS: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(6i32);
pub const AMSI_ATTRIBUTE_REDIRECT_CHAIN_SIZE: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(5i32);
pub const AMSI_ATTRIBUTE_SESSION: AMSI_ATTRIBUTE = AMSI_ATTRIBUTE(4i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMSI_RESULT(pub i32);
pub const AMSI_RESULT_BLOCKED_BY_ADMIN_END: AMSI_RESULT = AMSI_RESULT(20479i32);
pub const AMSI_RESULT_BLOCKED_BY_ADMIN_START: AMSI_RESULT = AMSI_RESULT(16384i32);
pub const AMSI_RESULT_CLEAN: AMSI_RESULT = AMSI_RESULT(0i32);
pub const AMSI_RESULT_DETECTED: AMSI_RESULT = AMSI_RESULT(32768i32);
pub const AMSI_RESULT_NOT_DETECTED: AMSI_RESULT = AMSI_RESULT(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMSI_UAC_MSI_ACTION(pub i32);
pub const AMSI_UAC_MSI_ACTION_INSTALL: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(0i32);
pub const AMSI_UAC_MSI_ACTION_MAINTENANCE: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(3i32);
pub const AMSI_UAC_MSI_ACTION_MAX: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(4i32);
pub const AMSI_UAC_MSI_ACTION_UNINSTALL: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(1i32);
pub const AMSI_UAC_MSI_ACTION_UPDATE: AMSI_UAC_MSI_ACTION = AMSI_UAC_MSI_ACTION(2i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AMSI_UAC_REQUEST_AX_INFO {
    pub ulLength: u32,
    pub lpwszLocalInstallPath: windows_core::PWSTR,
    pub lpwszSourceURL: windows_core::PWSTR,
}
impl Default for AMSI_UAC_REQUEST_AX_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AMSI_UAC_REQUEST_COM_INFO {
    pub ulLength: u32,
    pub lpwszServerBinary: windows_core::PWSTR,
    pub lpwszRequestor: windows_core::PWSTR,
    pub Clsid: windows_core::GUID,
}
impl Default for AMSI_UAC_REQUEST_COM_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct AMSI_UAC_REQUEST_CONTEXT {
    pub ulLength: u32,
    pub ulRequestorProcessId: u32,
    pub UACTrustState: AMSI_UAC_TRUST_STATE,
    pub Type: AMSI_UAC_REQUEST_TYPE,
    pub RequestType: AMSI_UAC_REQUEST_CONTEXT_0,
    pub bAutoElevateRequest: windows_core::BOOL,
}
impl Default for AMSI_UAC_REQUEST_CONTEXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union AMSI_UAC_REQUEST_CONTEXT_0 {
    pub ExeInfo: AMSI_UAC_REQUEST_EXE_INFO,
    pub ComInfo: AMSI_UAC_REQUEST_COM_INFO,
    pub MsiInfo: AMSI_UAC_REQUEST_MSI_INFO,
    pub ActiveXInfo: AMSI_UAC_REQUEST_AX_INFO,
    pub PackagedAppInfo: AMSI_UAC_REQUEST_PACKAGED_APP_INFO,
}
impl Default for AMSI_UAC_REQUEST_CONTEXT_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AMSI_UAC_REQUEST_EXE_INFO {
    pub ulLength: u32,
    pub lpwszApplicationName: windows_core::PWSTR,
    pub lpwszCommandLine: windows_core::PWSTR,
    pub lpwszDLLParameter: windows_core::PWSTR,
}
impl Default for AMSI_UAC_REQUEST_EXE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AMSI_UAC_REQUEST_MSI_INFO {
    pub ulLength: u32,
    pub MsiAction: AMSI_UAC_MSI_ACTION,
    pub lpwszProductName: windows_core::PWSTR,
    pub lpwszVersion: windows_core::PWSTR,
    pub lpwszLanguage: windows_core::PWSTR,
    pub lpwszManufacturer: windows_core::PWSTR,
    pub lpwszPackagePath: windows_core::PWSTR,
    pub lpwszPackageSource: windows_core::PWSTR,
    pub ulUpdates: u32,
    pub ppwszUpdates: *mut windows_core::PWSTR,
    pub ppwszUpdateSources: *mut windows_core::PWSTR,
}
impl Default for AMSI_UAC_REQUEST_MSI_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    pub ulLength: u32,
    pub lpwszApplicationName: windows_core::PWSTR,
    pub lpwszCommandLine: windows_core::PWSTR,
    pub lpPackageFamilyName: windows_core::PWSTR,
    pub lpApplicationId: windows_core::PWSTR,
}
impl Default for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMSI_UAC_REQUEST_TYPE(pub i32);
pub const AMSI_UAC_REQUEST_TYPE_AX: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(3i32);
pub const AMSI_UAC_REQUEST_TYPE_COM: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(1i32);
pub const AMSI_UAC_REQUEST_TYPE_EXE: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(0i32);
pub const AMSI_UAC_REQUEST_TYPE_MAX: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(5i32);
pub const AMSI_UAC_REQUEST_TYPE_MSI: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(2i32);
pub const AMSI_UAC_REQUEST_TYPE_PACKAGED_APP: AMSI_UAC_REQUEST_TYPE = AMSI_UAC_REQUEST_TYPE(4i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMSI_UAC_TRUST_STATE(pub i32);
pub const AMSI_UAC_TRUST_STATE_BLOCKED: AMSI_UAC_TRUST_STATE = AMSI_UAC_TRUST_STATE(2i32);
pub const AMSI_UAC_TRUST_STATE_MAX: AMSI_UAC_TRUST_STATE = AMSI_UAC_TRUST_STATE(3i32);
pub const AMSI_UAC_TRUST_STATE_TRUSTED: AMSI_UAC_TRUST_STATE = AMSI_UAC_TRUST_STATE(0i32);
pub const AMSI_UAC_TRUST_STATE_UNTRUSTED: AMSI_UAC_TRUST_STATE = AMSI_UAC_TRUST_STATE(1i32);
pub const CAntimalware: windows_core::GUID = windows_core::GUID::from_u128(0xfdb00e52_a214_4aa1_8fba_4357bb0072ec);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq)]
pub struct HAMSICONTEXT(pub *mut core::ffi::c_void);
impl HAMSICONTEXT {
    pub fn is_invalid(&self) -> bool {
        self.0 == -1 as _ || self.0 == 0 as _
    }
}
impl Default for HAMSICONTEXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq)]
pub struct HAMSISESSION(pub *mut core::ffi::c_void);
impl HAMSISESSION {
    pub fn is_invalid(&self) -> bool {
        self.0 == -1 as _ || self.0 == 0 as _
    }
}
impl Default for HAMSISESSION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
windows_core::imp::define_interface!(IAmsiStream, IAmsiStream_Vtbl, 0x3e47f2e5_81d4_4d3b_897f_545096770373);
windows_core::imp::interface_hierarchy!(IAmsiStream, windows_core::IUnknown);
impl IAmsiStream {
    pub unsafe fn GetAttribute(&self, attribute: AMSI_ATTRIBUTE, data: &mut [u8], retdata: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetAttribute)(windows_core::Interface::as_raw(self), attribute, data.len().try_into().unwrap(), core::mem::transmute(data.as_ptr()), retdata as _).ok() }
    }
    pub unsafe fn Read(&self, position: u64, buffer: &mut [u8], readsize: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Read)(windows_core::Interface::as_raw(self), position, buffer.len().try_into().unwrap(), core::mem::transmute(buffer.as_ptr()), readsize as _).ok() }
    }
}
#[repr(C)]
pub struct IAmsiStream_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetAttribute: unsafe extern "system" fn(*mut core::ffi::c_void, AMSI_ATTRIBUTE, u32, *mut u8, *mut u32) -> windows_core::HRESULT,
    pub Read: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, *mut u8, *mut u32) -> windows_core::HRESULT,
}
pub trait IAmsiStream_Impl: windows_core::IUnknownImpl {
    fn GetAttribute(&self, attribute: AMSI_ATTRIBUTE, datasize: u32, data: *mut u8, retdata: *mut u32) -> windows_core::Result<()>;
    fn Read(&self, position: u64, size: u32, buffer: *mut u8, readsize: *mut u32) -> windows_core::Result<()>;
}
impl IAmsiStream_Vtbl {
    pub const fn new<Identity: IAmsiStream_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetAttribute<Identity: IAmsiStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, attribute: AMSI_ATTRIBUTE, datasize: u32, data: *mut u8, retdata: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAmsiStream_Impl::GetAttribute(this, core::mem::transmute_copy(&attribute), core::mem::transmute_copy(&datasize), core::mem::transmute_copy(&data), core::mem::transmute_copy(&retdata)).into()
            }
        }
        unsafe extern "system" fn Read<Identity: IAmsiStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, position: u64, size: u32, buffer: *mut u8, readsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAmsiStream_Impl::Read(this, core::mem::transmute_copy(&position), core::mem::transmute_copy(&size), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&readsize)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), GetAttribute: GetAttribute::<Identity, OFFSET>, Read: Read::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAmsiStream as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAmsiStream {}
windows_core::imp::define_interface!(IAntimalware, IAntimalware_Vtbl, 0x82d29c2e_f062_44e6_b5c9_3d9a2f24a2df);
windows_core::imp::interface_hierarchy!(IAntimalware, windows_core::IUnknown);
impl IAntimalware {
    pub unsafe fn Scan<P0>(&self, stream: P0, result: *mut AMSI_RESULT, provider: *mut Option<IAntimalwareProvider>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IAmsiStream>,
    {
        unsafe { (windows_core::Interface::vtable(self).Scan)(windows_core::Interface::as_raw(self), stream.param().abi(), result as _, core::mem::transmute(provider)).ok() }
    }
    pub unsafe fn CloseSession(&self, session: u64) {
        unsafe { (windows_core::Interface::vtable(self).CloseSession)(windows_core::Interface::as_raw(self), session) }
    }
}
#[repr(C)]
pub struct IAntimalware_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Scan: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut AMSI_RESULT, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CloseSession: unsafe extern "system" fn(*mut core::ffi::c_void, u64),
}
pub trait IAntimalware_Impl: windows_core::IUnknownImpl {
    fn Scan(&self, stream: windows_core::Ref<'_, IAmsiStream>, result: *mut AMSI_RESULT, provider: windows_core::OutRef<'_, IAntimalwareProvider>) -> windows_core::Result<()>;
    fn CloseSession(&self, session: u64);
}
impl IAntimalware_Vtbl {
    pub const fn new<Identity: IAntimalware_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Scan<Identity: IAntimalware_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, stream: *mut core::ffi::c_void, result: *mut AMSI_RESULT, provider: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAntimalware_Impl::Scan(this, core::mem::transmute_copy(&stream), core::mem::transmute_copy(&result), core::mem::transmute_copy(&provider)).into()
            }
        }
        unsafe extern "system" fn CloseSession<Identity: IAntimalware_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, session: u64) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAntimalware_Impl::CloseSession(this, core::mem::transmute_copy(&session))
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), Scan: Scan::<Identity, OFFSET>, CloseSession: CloseSession::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAntimalware as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAntimalware {}
windows_core::imp::define_interface!(IAntimalware2, IAntimalware2_Vtbl, 0x301035b5_2d42_4f56_8c65_2dcaa7fb3cdc);
impl core::ops::Deref for IAntimalware2 {
    type Target = IAntimalware;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAntimalware2, windows_core::IUnknown, IAntimalware);
impl IAntimalware2 {
    pub unsafe fn Notify<P2, P3>(&self, buffer: *const core::ffi::c_void, length: u32, contentname: P2, appname: P3) -> windows_core::Result<AMSI_RESULT>
    where
        P2: windows_core::Param<windows_core::PCWSTR>,
        P3: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Notify)(windows_core::Interface::as_raw(self), buffer, length, contentname.param().abi(), appname.param().abi(), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAntimalware2_Vtbl {
    pub base__: IAntimalware_Vtbl,
    pub Notify: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR, *mut AMSI_RESULT) -> windows_core::HRESULT,
}
pub trait IAntimalware2_Impl: IAntimalware_Impl {
    fn Notify(&self, buffer: *const core::ffi::c_void, length: u32, contentname: &windows_core::PCWSTR, appname: &windows_core::PCWSTR) -> windows_core::Result<AMSI_RESULT>;
}
impl IAntimalware2_Vtbl {
    pub const fn new<Identity: IAntimalware2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Notify<Identity: IAntimalware2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: *const core::ffi::c_void, length: u32, contentname: windows_core::PCWSTR, appname: windows_core::PCWSTR, presult: *mut AMSI_RESULT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAntimalware2_Impl::Notify(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&length), core::mem::transmute(&contentname), core::mem::transmute(&appname)) {
                    Ok(ok__) => {
                        presult.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: IAntimalware_Vtbl::new::<Identity, OFFSET>(), Notify: Notify::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAntimalware2 as windows_core::Interface>::IID || iid == &<IAntimalware as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAntimalware2 {}
windows_core::imp::define_interface!(IAntimalwareProvider, IAntimalwareProvider_Vtbl, 0xb2cabfe3_fe04_42b1_a5df_08d483d4d125);
windows_core::imp::interface_hierarchy!(IAntimalwareProvider, windows_core::IUnknown);
impl IAntimalwareProvider {
    pub unsafe fn Scan<P0>(&self, stream: P0) -> windows_core::Result<AMSI_RESULT>
    where
        P0: windows_core::Param<IAmsiStream>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Scan)(windows_core::Interface::as_raw(self), stream.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn CloseSession(&self, session: u64) {
        unsafe { (windows_core::Interface::vtable(self).CloseSession)(windows_core::Interface::as_raw(self), session) }
    }
    pub unsafe fn DisplayName(&self) -> windows_core::Result<windows_core::PWSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).DisplayName)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAntimalwareProvider_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Scan: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut AMSI_RESULT) -> windows_core::HRESULT,
    pub CloseSession: unsafe extern "system" fn(*mut core::ffi::c_void, u64),
    pub DisplayName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
}
pub trait IAntimalwareProvider_Impl: windows_core::IUnknownImpl {
    fn Scan(&self, stream: windows_core::Ref<'_, IAmsiStream>) -> windows_core::Result<AMSI_RESULT>;
    fn CloseSession(&self, session: u64);
    fn DisplayName(&self) -> windows_core::Result<windows_core::PWSTR>;
}
impl IAntimalwareProvider_Vtbl {
    pub const fn new<Identity: IAntimalwareProvider_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Scan<Identity: IAntimalwareProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, stream: *mut core::ffi::c_void, result: *mut AMSI_RESULT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAntimalwareProvider_Impl::Scan(this, core::mem::transmute_copy(&stream)) {
                    Ok(ok__) => {
                        result.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CloseSession<Identity: IAntimalwareProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, session: u64) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAntimalwareProvider_Impl::CloseSession(this, core::mem::transmute_copy(&session))
            }
        }
        unsafe extern "system" fn DisplayName<Identity: IAntimalwareProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, displayname: *mut windows_core::PWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAntimalwareProvider_Impl::DisplayName(this) {
                    Ok(ok__) => {
                        displayname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Scan: Scan::<Identity, OFFSET>,
            CloseSession: CloseSession::<Identity, OFFSET>,
            DisplayName: DisplayName::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAntimalwareProvider as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAntimalwareProvider {}
windows_core::imp::define_interface!(IAntimalwareProvider2, IAntimalwareProvider2_Vtbl, 0x7c1e6570_3f73_4e0f_8ad4_98b94cd3290f);
impl core::ops::Deref for IAntimalwareProvider2 {
    type Target = IAntimalwareProvider;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAntimalwareProvider2, windows_core::IUnknown, IAntimalwareProvider);
impl IAntimalwareProvider2 {
    pub unsafe fn Notify<P2, P3>(&self, buffer: *const core::ffi::c_void, length: u32, contentname: P2, appname: P3) -> windows_core::Result<AMSI_RESULT>
    where
        P2: windows_core::Param<windows_core::PCWSTR>,
        P3: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Notify)(windows_core::Interface::as_raw(self), buffer, length, contentname.param().abi(), appname.param().abi(), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAntimalwareProvider2_Vtbl {
    pub base__: IAntimalwareProvider_Vtbl,
    pub Notify: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR, *mut AMSI_RESULT) -> windows_core::HRESULT,
}
pub trait IAntimalwareProvider2_Impl: IAntimalwareProvider_Impl {
    fn Notify(&self, buffer: *const core::ffi::c_void, length: u32, contentname: &windows_core::PCWSTR, appname: &windows_core::PCWSTR) -> windows_core::Result<AMSI_RESULT>;
}
impl IAntimalwareProvider2_Vtbl {
    pub const fn new<Identity: IAntimalwareProvider2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Notify<Identity: IAntimalwareProvider2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: *const core::ffi::c_void, length: u32, contentname: windows_core::PCWSTR, appname: windows_core::PCWSTR, presult: *mut AMSI_RESULT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAntimalwareProvider2_Impl::Notify(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&length), core::mem::transmute(&contentname), core::mem::transmute(&appname)) {
                    Ok(ok__) => {
                        presult.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: IAntimalwareProvider_Vtbl::new::<Identity, OFFSET>(), Notify: Notify::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAntimalwareProvider2 as windows_core::Interface>::IID || iid == &<IAntimalwareProvider as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAntimalwareProvider2 {}
windows_core::imp::define_interface!(IAntimalwareUacProvider, IAntimalwareUacProvider_Vtbl, 0xb2cabfe4_fe04_42b1_a5df_08d483d4d125);
windows_core::imp::interface_hierarchy!(IAntimalwareUacProvider, windows_core::IUnknown);
impl IAntimalwareUacProvider {
    pub unsafe fn UacScan(&self, context: *const AMSI_UAC_REQUEST_CONTEXT) -> windows_core::Result<AMSI_RESULT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).UacScan)(windows_core::Interface::as_raw(self), context, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DisplayName(&self) -> windows_core::Result<windows_core::PWSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).DisplayName)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAntimalwareUacProvider_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub UacScan: unsafe extern "system" fn(*mut core::ffi::c_void, *const AMSI_UAC_REQUEST_CONTEXT, *mut AMSI_RESULT) -> windows_core::HRESULT,
    pub DisplayName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
}
pub trait IAntimalwareUacProvider_Impl: windows_core::IUnknownImpl {
    fn UacScan(&self, context: *const AMSI_UAC_REQUEST_CONTEXT) -> windows_core::Result<AMSI_RESULT>;
    fn DisplayName(&self) -> windows_core::Result<windows_core::PWSTR>;
}
impl IAntimalwareUacProvider_Vtbl {
    pub const fn new<Identity: IAntimalwareUacProvider_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn UacScan<Identity: IAntimalwareUacProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, context: *const AMSI_UAC_REQUEST_CONTEXT, result: *mut AMSI_RESULT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAntimalwareUacProvider_Impl::UacScan(this, core::mem::transmute_copy(&context)) {
                    Ok(ok__) => {
                        result.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DisplayName<Identity: IAntimalwareUacProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, displayname: *mut windows_core::PWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAntimalwareUacProvider_Impl::DisplayName(this) {
                    Ok(ok__) => {
                        displayname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            UacScan: UacScan::<Identity, OFFSET>,
            DisplayName: DisplayName::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAntimalwareUacProvider as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAntimalwareUacProvider {}
