//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/cksyncengineconfiguration?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKSyncEngineConfiguration;
);

unsafe impl Send for CKSyncEngineConfiguration {}

unsafe impl Sync for CKSyncEngineConfiguration {}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKSyncEngineConfiguration {}
);

impl CKSyncEngineConfiguration {
    extern_methods!(
        #[cfg(all(
            feature = "CKDatabase",
            feature = "CKSyncEngine",
            feature = "CKSyncEngineState"
        ))]
        #[unsafe(method(initWithDatabase:stateSerialization:delegate:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithDatabase_stateSerialization_delegate(
            this: Allocated<Self>,
            database: &CKDatabase,
            state_serialization: Option<&CKSyncEngineStateSerialization>,
            delegate: &ProtocolObject<dyn CKSyncEngineDelegate>,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;

        #[cfg(feature = "CKDatabase")]
        /// The database for this sync engine to sync with.
        ///
        /// You can have multiple instances of `CKSyncEngine` in the same process, each targeting a different database.
        /// For example, you might have one for your private database and one for your shared database.
        ///
        /// It's also technically possible to have multiple instances of `CKSyncEngine` for the same ``CKDatabase``.
        /// This isn't recommended for production code, but it can be helpful for testing your `CKSyncEngine` integration.
        /// For example, you might make multiple `CKSyncEngine` instances to simulate multiple devices syncing back and forth.
        #[unsafe(method(database))]
        #[unsafe(method_family = none)]
        pub unsafe fn database(&self) -> Retained<CKDatabase>;

        #[cfg(feature = "CKDatabase")]
        /// Setter for [`database`][Self::database].
        #[unsafe(method(setDatabase:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDatabase(&self, database: &CKDatabase);

        #[cfg(feature = "CKSyncEngineState")]
        /// The state serialization you last received in a ``CKSyncEngine/Event/StateUpdate``.
        ///
        /// If this is the first time ever initializing your `CKSyncEngine`, you can provide `nil`.
        #[unsafe(method(stateSerialization))]
        #[unsafe(method_family = none)]
        pub unsafe fn stateSerialization(&self)
            -> Option<Retained<CKSyncEngineStateSerialization>>;

        #[cfg(feature = "CKSyncEngineState")]
        /// Setter for [`stateSerialization`][Self::stateSerialization].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setStateSerialization:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setStateSerialization(
            &self,
            state_serialization: Option<&CKSyncEngineStateSerialization>,
        );

        #[cfg(feature = "CKSyncEngine")]
        /// Your implementation of `CKSyncEngineDelegate`.
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(&self)
            -> Option<Retained<ProtocolObject<dyn CKSyncEngineDelegate>>>;

        #[cfg(feature = "CKSyncEngine")]
        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn CKSyncEngineDelegate>>,
        );

        /// Whether or not the sync engine should automatically sync on your behalf.
        ///
        /// If true, then the sync engine will automatically sync using the system scheduler. This is the default value.
        /// When you add pending changes to the state, the sync engine will automatically schedule a sync task to send changes.
        /// When it receives a notification about new changes on the server, it will automatically schedule a sync task to fetch changes.
        /// It will also automatically re-schedule sync tasks for retryable errors such as network failures or server throttles.
        ///
        /// If ``CKSyncEngineConfiguration/automaticallySync`` is off, then the sync engine will not perform any operations unless you tell it to do so via ``CKSyncEngine/fetchChanges(_:)`` or ``CKSyncEngine/sendChanges(_:)``.
        ///
        /// Most applications likely want to enable automatic syncing during normal use.
        /// However, you might want to disable it if you have specific requirements for when you want to sync.
        /// For example, if you want to sync only once per day, you can turn off automatic sync and manually call ``CKSyncEngine/fetchChanges(_:)`` and ``CKSyncEngine/sendChanges(_:)`` once per day.
        ///
        /// You might also disable automatic sync when writing automated tests for your integration with `CKSyncEngine`.
        /// This way, you can have fine grained control over exactly when the sync engine fetches or sends changes.
        /// This allows you to simulate edge cases and deterministically test your logic around scenarios like conflict resolution and error handling.
        #[unsafe(method(automaticallySync))]
        #[unsafe(method_family = none)]
        pub unsafe fn automaticallySync(&self) -> bool;

        /// Setter for [`automaticallySync`][Self::automaticallySync].
        #[unsafe(method(setAutomaticallySync:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutomaticallySync(&self, automatically_sync: bool);

        #[cfg(feature = "CKSubscription")]
        /// An optional override for the sync engine's default database subscription ID.
        /// Use this for backward compatibility with a previous CloudKit sync implementation.
        ///
        /// By default, `CKSyncEngine` will create its own ``CKDatabaseSubscription`` with its own subscription ID.
        /// If you're migrating to `CKSyncEngine` from a custom CloudKit sync implementation, you can specify your previous subscription ID here.
        /// This allows your `CKSyncEngine` integration to be backward compatible with previous versions of your app.
        ///
        /// >Note: `CKSyncEngine` will automatically attempt to discover any previous database subscriptions,
        /// but you can be more explicit by giving the subscription ID through this configuration option.
        #[unsafe(method(subscriptionID))]
        #[unsafe(method_family = none)]
        pub unsafe fn subscriptionID(&self) -> Option<Retained<CKSubscriptionID>>;

        #[cfg(feature = "CKSubscription")]
        /// Setter for [`subscriptionID`][Self::subscriptionID].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSubscriptionID:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSubscriptionID(&self, subscription_id: Option<&CKSubscriptionID>);
    );
}
