/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.sql.generator;

import java.util.Collection;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.generator.SQLGeneratorTable;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SQLGeneratorInsertOnConflict
extends SQLGeneratorTable {
    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBSEntity object) throws DBException {
        sql.append("INSERT INTO ").append(this.getEntityName(object)).append(this.getLineSeparator()).append("(");
        boolean hasAttr = false;
        for (DBSEntityAttribute attr : this.getAllAttributes(monitor, object)) {
            if (DBUtils.isPseudoAttribute((DBSAttributeBase)attr) || DBUtils.isHiddenObject((Object)attr) || attr.isAutoGenerated()) continue;
            if (hasAttr) {
                sql.append(", ");
            }
            sql.append(DBUtils.getObjectFullName((DBPNamedObject)attr, (DBPEvaluationContext)DBPEvaluationContext.DML));
            hasAttr = true;
        }
        sql.append(")").append(this.getLineSeparator());
        sql.append("SELECT ");
        hasAttr = false;
        for (DBSEntityAttribute attr : this.getAllAttributes(monitor, object)) {
            if (DBUtils.isPseudoAttribute((DBSAttributeBase)attr) || DBUtils.isHiddenObject((Object)attr) || attr.isAutoGenerated()) continue;
            if (hasAttr) {
                sql.append(", ");
            }
            sql.append("src." + DBUtils.getObjectFullName((DBPNamedObject)attr, (DBPEvaluationContext)DBPEvaluationContext.DML));
            hasAttr = true;
        }
        sql.append(this.getLineSeparator()).append("FROM SOURCE_TABLE AS src").append(this.getLineSeparator());
        sql.append("ON CONFLICT ");
        hasAttr = false;
        Collection keyAttributes = this.getKeyAttributes(monitor, object);
        if (!CommonUtils.isEmpty((Collection)keyAttributes)) {
            sql.append("(");
            for (DBSEntityAttribute attr : keyAttributes) {
                if (hasAttr) {
                    sql.append(", ");
                }
                sql.append(DBUtils.getQuotedIdentifier((DBSObject)attr));
                hasAttr = true;
            }
            sql.append(")").append(this.getLineSeparator());
        } else {
            sql.append("('/* insert on conflict attributes here, e.g. ID, ... */')").append(this.getLineSeparator());
        }
        sql.append("/* or you may use [DO NOTHING;] */").append(this.getLineSeparator());
        sql.append("DO UPDATE ").append(this.getLineSeparator());
        sql.append("SET ");
        hasAttr = false;
        for (DBSEntityAttribute attr : this.getValueAttributes(monitor, object, keyAttributes)) {
            if (DBUtils.isPseudoAttribute((DBSAttributeBase)attr) || DBUtils.isHiddenObject((Object)attr)) continue;
            if (hasAttr) {
                sql.append(", ");
            }
            sql.append(DBUtils.getObjectFullName((DBPNamedObject)attr, (DBPEvaluationContext)DBPEvaluationContext.DML)).append("=");
            sql.append("EXCLUDED." + DBUtils.getObjectFullName((DBPNamedObject)attr, (DBPEvaluationContext)DBPEvaluationContext.DML));
            hasAttr = true;
        }
        sql.append(";").append(this.getLineSeparator());
    }
}

