<!-- SPDX-License-Identifier: BSD-3-Clause -->
<!-- Copyright (c) Contributors to the OpenEXR Project -->

# Security Policy

## Reporting a Vulnerability

If you think you've found a potential vulnerability in OpenEXR, please
report it by filing a GitHub [security
advisory](https://github.com/AcademySoftwareFoundation/openexr/security/advisories/new). Alternatively,
email security@openexr.com and provide your contact info for further
private/secure discussion.  If your email does not receive a prompt
acknowledgement, your address may be blocked.

Our policy is to acknowledge the receipt of vulnerability reports
within 48 hours. Our policy is to address critical security vulnerabilities
rapidly and post patches within 14 days if possible.

## Known Vulnerabilities

These vulnerabilities are present in the given versions:

* [CVE-2023-5841](https://nvd.nist.gov/vuln/detail/CVE-2023-5841) 3.1.0, 3.1.1, 3.1.2, 3.1.3 3.1.4 3.1.5 3.1.6 3.1.7 3.1.8 3.1.9 3.1.10 3.1.11 3.2.0 3.2.1
* [CVE-2021-45942](https://nvd.nist.gov/vuln/detail/CVE-2021-45942) 3.1.0, 3.1.1, 3.1.2, 3.1.3
* [CVE-2021-20296](https://nvd.nist.gov/vuln/detail/CVE-2021-20296) 2.4.0, 2.4.1, 2.4.2, 2.5.0, 2.5.1, 2.5.2, 2.5.3
* [CVE-2021-3479](https://nvd.nist.gov/vuln/detail/CVE-2021-3479) 2.4.0, 2.4.1, 2.4.2, 2.5.0, 2.5.1, 2.5.2, 2.5.3
* [CVE-2021-3478](https://nvd.nist.gov/vuln/detail/CVE-2021-3478) 2.4.0, 2.4.1, 2.4.2, 2.5.0, 2.5.1, 2.5.2, 2.5.3
* [CVE-2021-3477](https://nvd.nist.gov/vuln/detail/CVE-2021-3477) 2.4.0, 2.4.1, 2.4.2, 2.5.0, 2.5.1, 2.5.2, 2.5.3
* [CVE-2021-3476](https://nvd.nist.gov/vuln/detail/CVE-2021-3476) 2.4.0, 2.4.1, 2.4.2, 2.5.0, 2.5.1, 2.5.2, 2.5.3
* [CVE-2021-3475](https://nvd.nist.gov/vuln/detail/CVE-2021-3475) 2.4.0, 2.4.1, 2.4.2, 2.5.0, 2.5.1, 2.5.2, 2.5.3
* [CVE-2021-3474](https://nvd.nist.gov/vuln/detail/CVE-2021-3474) 2.4.0, 2.4.1, 2.4.2, 2.5.0, 2.5.1, 2.5.2, 2.5.3
* [CVE-2020-16589](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-16589) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0
* [CVE-2020-16588](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-16588) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0
* [CVE-2020-16587](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-16587) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0
* [CVE-2020-15306](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-15306) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0, 2.4.0, 2.4.1, 2.5.0, 2.5.1
* [CVE-2020-15305](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-15305) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0, 2.4.0, 2.4.1, 2.5.0, 2.5.1
* [CVE-2020-15304](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-15304) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0, 2.4.0, 2.4.1, 2.5.0, 2.5.1
* [CVE-2020-11765](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-11765) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0, 2.4.0
* [CVE-2020-11764](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-11764) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0, 2.4.0
* [CVE-2020-11763](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-11763) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0, 2.4.0
* [CVE-2020-11762](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-11762) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0, 2.4.0
* [CVE-2020-11761](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-11761) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0, 2.4.0
* [CVE-2020-11760](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-11760) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0, 2.4.0
* [CVE-2020-11759](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-11759) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0, 2.4.0
* [CVE-2020-11758](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-11758) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0, 2.4.0
* [CVE-2018-18444](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2018-18444) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0
* [CVE-2018-18443](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2018-18443) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0
* [CVE-2017-9116](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-9116) 2.0.0, 2.0.1, 2.1.0, 2.2.0
* [CVE-2017-9115](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-9115) 2.0.0, 2.0.1, 2.1.0, 2.2.0
* [CVE-2017-9114](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-9114) 2.0.0, 2.0.1, 2.1.0, 2.2.0
* [CVE-2017-9113](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-9113) 2.0.0, 2.0.1, 2.1.0, 2.2.0
* [CVE-2017-9112](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-9112) 2.0.0, 2.0.1, 2.1.0, 2.2.0
* [CVE-2017-9111](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-9111) 2.0.0, 2.0.1, 2.1.0, 2.2.0
* [CVE-2017-9110](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-9110) 2.0.0, 2.0.1, 2.1.0, 2.2.0
* [CVE-2017-12596](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-12596) 2.0.0, 2.0.1, 2.1.0, 2.2.0, 2.2.1, 2.3.0
* [CVE-2009-1722](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2009-1722) 1.0.*, 1.1.*, 1.2.*, 1.3.*, 1.4.*, 1.5.*, 1.6.*
* [CVE-2009-1721](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2009-1721) 1.0.*, 1.1.*, 1.2.*, 1.3.*, 1.4.*, 1.5.*, 1.6.*
* [CVE-2009-1720](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2009-1720) 1.0.*, 1.1.*, 1.2.*, 1.3.*, 1.4.*, 1.5.*, 1.6.*

See the [release notes](CHANGES.md) for more information.

## Supported Versions

This gives guidance about which releases/branches are supported with bug fixes and patches to
security vulnerabilities.

| Version / branch  | Supported                                            |
|-------| ---------------------------------------------------- |
| main  | :white_check_mark: :construction: All fixes immediately, although this branch is under development with potential unstable ABI/API
| 3.3.x | :white_check_mark: All fixes that can be backported without breaking ABI compatibility
| 3.2.x | :warning: Patch releases considered in response to specific requests
| 3.1.x | :warning: Patch releases considered in response to specific requests
| 3.0.x | :warning: Patch releases considered in response to specific requests
| 2.5.x | :warning: Patch releases considered in response to specific requests
| 2.4.x | :warning: Patch releases considered in response to specific requests
| 2.3.x | :x: No longer receiving patches of any kind
| 2.2.x | :x: No longer receiving patches of any kind
| 2.1.x | :x: No longer receiving patches of any kind
| 2.0.x | :x: No longer receiving patches of any kind
| 1.x   | :x: No longer receiving patches of any kind

## Signed Releases

Releases artifacts are signed via
[sigstore](https://www.sigstore.dev). See
[release-sign.yml](.github/workflows/release-sign.yml) for details.

To verify a downloaded release at a given tag:

    % pip install sigstore
    % sigstore verify github --cert-identity https://github.com/AcademySoftwareFoundation/openexr/.github/workflows/release-sign.yml@refs/tags/<tag> openexr-<tag>.tar.gz

## Security Expectations

### Software Features

- The OpenEXR project implements the EXR image file format, used
  throughout the motion picture industry and beyond, on Linux, macOS,
  and Windows.

- The project consists of a software run-time library, implemented in
  C/C++ and built via cmake, that reads and writes image data
  files. The project also distributes python wrappings for the C/C++
  I/O API.

- The library reads and writes binary image data and text-based
  metadata, treated as blind data, none of which is executable code.

- Other than the website and online technical documentation, the
  project implements no web/online services or network communication
  protocols.  The library never requests any security or
  authentication credentials or login information from users.

  The website implements no interactive features and requires no login
  credentials.

- The library reads and writes only to file paths specifically requested
  via the C/C++ API. The runtime library uses no system configuration
  files or sidecar data files. Access to data files uses only standard
  file I/O system calls.

- The library compresses/decompresses data via standard compression
  algorithms but uses no cryptographic or confidentiality protocols.

### Software Dependencies

OpenEXR depends on
[Imath](https://github.com/AcademySoftwareFoundation/Imath), a library
of basic math operations also maintained and distributed by the
OpenEXR project. Imath follows the same security conventions
documented here for OpenEXR itself. The core Imath library has no
external dependencies. The Imath python bindings depend on python and
boost.

The only
external library dependency of OpenEXR is
[libdeflate](https://github.com/ebiggers/libdeflate), which implements
standard deflate/zlib/gzip compression and decompression.

The project uses
[Snyk](https://github.com/AcademySoftwareFoundation/openexr/blob/main/.github/workflows/snyk-scan-pr.yml)
to scan for dependency vulnerability.

### Potential Vulnerabilities

Potential entry points are images being loaded using the
library. Malformed images could caused issues such as heap buffer
overflows, out-of-memory faults, or segmentation faults that could be
exploitable as denial-of-service attacks.

### Hardening

#### Testing

The OpenEXR project implements a comprehensive suite of validation
tests, including fuzz testing to harden against malicious input
data. Note that fuzz testing hardens only against *small* input data
files and is not a comprehensive test against all potential input.

Note that the
[exrcheck](https://github.com/AcademySoftwareFoundation/openexr/tree/main/src/bin/exrcheck)
utility is intended to be used by testers to demonstrate a particular
proof-of-concept input file exposes a vulnerability, and it is very
helpful to let us know if a vulnerability can be reproduced using that
tool.

The project also uses the [OSS
Fuzz](https://bugs.chromium.org/p/oss-fuzz) service for continuous
fuzz testing.

#### Development Cycle and Distribution

OpenEXR is downloadable and buildable by C/C++ source via GitHub. Only
members of the project's Technical Steering Committee, all veteran
software engineers at major motion picture studios or vendors, have
write permissions on the source code repository. All critical software
changes are reviewed by multiple TSC members.

The library is distributed in binary form via many common package
managers across all platforms.
