/***************************************************************************
 *   Copyright (C) 2015 Hendrik Vennekate                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef MOLSKETCH_DRAWACTION_H
#define MOLSKETCH_DRAWACTION_H

#include "genericaction.h"

namespace Molsketch {

  class drawAction : public genericAction
  {
    Q_OBJECT
  public:
    explicit drawAction(MolScene* scene);
    ~drawAction();

    void mousePressEvent(QGraphicsSceneMouseEvent *event) override;
    void mouseMoveEvent(QGraphicsSceneMouseEvent *event) override;
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *event) override;
    void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event) override; // TODO
    void wheelEvent(QGraphicsSceneWheelEvent *event) override;

  private:
    class privateData;
    privateData *d;
  private slots:
    void refreshIcon();
    void toggleVisibility(bool visible);
  };

} // namespace Molsketch

#endif // MOLSKETCH_DRAWACTION_H
