/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.mdns.internal;

import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.discovery.AbstractDiscoveryService;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.DiscoveryService;
import org.openhab.core.config.discovery.mdns.MDNSDiscoveryParticipant;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.i18n.TranslationProvider;
import org.openhab.core.io.transport.mdns.MDNSClient;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={DiscoveryService.class}, configurationPid={"discovery.mdns"})
public class MDNSDiscoveryService
extends AbstractDiscoveryService
implements ServiceListener {
    private static final Duration FOREGROUND_SCAN_TIMEOUT = Duration.ofMillis(200L);
    private final Logger logger = LoggerFactory.getLogger(MDNSDiscoveryService.class);
    private final Set<MDNSDiscoveryParticipant> participants = new CopyOnWriteArraySet<MDNSDiscoveryParticipant>();
    private final MDNSClient mdnsClient;
    private Map<String, ScheduledFuture<?>> deviceRemovalTasks = new ConcurrentHashMap();

    @Activate
    public MDNSDiscoveryService(@Nullable Map<String, Object> configProperties, @Reference MDNSClient mdnsClient, @Reference TranslationProvider i18nProvider, @Reference LocaleProvider localeProvider) {
        super(5);
        this.mdnsClient = mdnsClient;
        this.i18nProvider = i18nProvider;
        this.localeProvider = localeProvider;
        super.activate(configProperties);
        if (this.isBackgroundDiscoveryEnabled()) {
            for (MDNSDiscoveryParticipant participant : this.participants) {
                mdnsClient.addServiceListener(participant.getServiceType(), (ServiceListener)this);
            }
        }
    }

    @Deactivate
    protected void deactivate() {
        super.deactivate();
        for (MDNSDiscoveryParticipant participant : this.participants) {
            this.mdnsClient.removeServiceListener(participant.getServiceType(), (ServiceListener)this);
        }
    }

    @Modified
    protected void modified(@Nullable Map<String, Object> configProperties) {
        super.modified(configProperties);
    }

    protected void startBackgroundDiscovery() {
        for (MDNSDiscoveryParticipant participant : this.participants) {
            this.mdnsClient.addServiceListener(participant.getServiceType(), (ServiceListener)this);
        }
        this.startScan(true);
    }

    protected void stopBackgroundDiscovery() {
        for (MDNSDiscoveryParticipant participant : this.participants) {
            this.mdnsClient.removeServiceListener(participant.getServiceType(), (ServiceListener)this);
        }
    }

    protected void startScan() {
        this.startScan(false);
    }

    protected synchronized void stopScan() {
        this.removeOlderResults(this.getTimestampOfLastScan());
        super.stopScan();
    }

    private void startScan(boolean isBackground) {
        this.scheduler.schedule(() -> this.scan(isBackground), 0L, TimeUnit.SECONDS);
    }

    private void scan(boolean isBackground) {
        for (MDNSDiscoveryParticipant participant : this.participants) {
            long start = System.currentTimeMillis();
            ServiceInfo[] services = isBackground ? this.mdnsClient.list(participant.getServiceType()) : this.mdnsClient.list(participant.getServiceType(), FOREGROUND_SCAN_TIMEOUT);
            this.logger.debug("{} services found for {}; duration: {}ms", new Object[]{services.length, participant.getServiceType(), System.currentTimeMillis() - start});
            ServiceInfo[] serviceInfoArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceInfo serviceInfo = serviceInfoArray[n2];
                this.createDiscoveryResult(participant, serviceInfo);
                ++n2;
            }
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addMDNSDiscoveryParticipant(MDNSDiscoveryParticipant participant) {
        this.participants.add(participant);
        if (this.isBackgroundDiscoveryEnabled()) {
            this.mdnsClient.addServiceListener(participant.getServiceType(), (ServiceListener)this);
        }
    }

    protected void removeMDNSDiscoveryParticipant(MDNSDiscoveryParticipant participant) {
        this.participants.remove(participant);
        this.mdnsClient.removeServiceListener(participant.getServiceType(), (ServiceListener)this);
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        HashSet<ThingTypeUID> supportedThingTypes = new HashSet<ThingTypeUID>();
        for (MDNSDiscoveryParticipant participant : this.participants) {
            supportedThingTypes.addAll(participant.getSupportedThingTypeUIDs());
        }
        return supportedThingTypes;
    }

    public void serviceAdded(@NonNullByDefault(value={}) ServiceEvent serviceEvent) {
        this.considerService(serviceEvent);
    }

    public void serviceRemoved(@NonNullByDefault(value={}) ServiceEvent serviceEvent) {
        for (MDNSDiscoveryParticipant participant : this.participants) {
            if (!participant.getServiceType().equals(serviceEvent.getType())) continue;
            this.removeDiscoveryResult(participant, serviceEvent.getInfo());
        }
    }

    public void serviceResolved(@NonNullByDefault(value={}) ServiceEvent serviceEvent) {
        this.considerService(serviceEvent);
    }

    private void considerService(ServiceEvent serviceEvent) {
        if (this.isBackgroundDiscoveryEnabled()) {
            for (MDNSDiscoveryParticipant participant : this.participants) {
                if (!participant.getServiceType().equals(serviceEvent.getType())) continue;
                this.createDiscoveryResult(participant, serviceEvent.getInfo());
            }
        }
    }

    private void createDiscoveryResult(MDNSDiscoveryParticipant participant, ServiceInfo serviceInfo) {
        try {
            DiscoveryResult result = participant.createResult(serviceInfo);
            if (result != null) {
                this.cancelRemovalTask(serviceInfo);
                this.thingDiscovered(result, FrameworkUtil.getBundle(participant.getClass()));
            }
        }
        catch (Exception e) {
            this.logger.error("Participant '{}' threw an exception", (Object)participant.getClass().getName(), (Object)e);
        }
    }

    private void removeDiscoveryResult(MDNSDiscoveryParticipant participant, ServiceInfo serviceInfo) {
        try {
            ThingUID thingUID = participant.getThingUID(serviceInfo);
            if (thingUID != null) {
                long gracePeriod = participant.getRemovalGracePeriodSeconds(serviceInfo);
                if (gracePeriod <= 0L) {
                    this.thingRemoved(thingUID);
                } else {
                    this.cancelRemovalTask(serviceInfo);
                    this.scheduleRemovalTask(thingUID, serviceInfo, gracePeriod);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Participant '{}' threw an exception", (Object)participant.getClass().getName(), (Object)e);
        }
    }

    private void cancelRemovalTask(ServiceInfo serviceInfo) {
        ScheduledFuture<?> deviceRemovalTask = this.deviceRemovalTasks.remove(serviceInfo.getQualifiedName());
        if (deviceRemovalTask != null) {
            deviceRemovalTask.cancel(false);
        }
    }

    private void scheduleRemovalTask(ThingUID thingUID, ServiceInfo serviceInfo, long gracePeriod) {
        this.deviceRemovalTasks.put(serviceInfo.getQualifiedName(), this.scheduler.schedule(() -> {
            this.thingRemoved(thingUID);
            this.cancelRemovalTask(serviceInfo);
        }, gracePeriod, TimeUnit.SECONDS));
    }
}

