//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-quartz-core")]
#[cfg(not(target_os = "watchos"))]
use objc2_quartz_core::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uisearchbaricon?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UISearchBarIcon(pub NSInteger);
impl UISearchBarIcon {
    #[doc(alias = "UISearchBarIconSearch")]
    pub const Search: Self = Self(0);
    #[doc(alias = "UISearchBarIconClear")]
    pub const Clear: Self = Self(1);
    #[doc(alias = "UISearchBarIconBookmark")]
    pub const Bookmark: Self = Self(2);
    #[doc(alias = "UISearchBarIconResultsList")]
    pub const ResultsList: Self = Self(3);
}

unsafe impl Encode for UISearchBarIcon {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UISearchBarIcon {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uisearchbarstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UISearchBarStyle(pub NSUInteger);
impl UISearchBarStyle {
    #[doc(alias = "UISearchBarStyleDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "UISearchBarStyleProminent")]
    pub const Prominent: Self = Self(1);
    #[doc(alias = "UISearchBarStyleMinimal")]
    pub const Minimal: Self = Self(2);
}

unsafe impl Encode for UISearchBarStyle {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for UISearchBarStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uilooktodictatecapable?language=objc)
    pub unsafe trait UILookToDictateCapable: NSObjectProtocol {
        /// Enable or disable 'Look To Dictate' on the receiver.
        #[unsafe(method(isLookToDictateEnabled))]
        #[unsafe(method_family = none)]
        fn isLookToDictateEnabled(&self) -> bool;

        /// Setter for [`isLookToDictateEnabled`][Self::isLookToDictateEnabled].
        #[unsafe(method(setLookToDictateEnabled:))]
        #[unsafe(method_family = none)]
        fn setLookToDictateEnabled(&self, look_to_dictate_enabled: bool);
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uisearchbar?language=objc)
    #[unsafe(super(UIView, UIResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "UIResponder", feature = "UIView"))]
    pub struct UISearchBar;
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UIView",
    feature = "objc2-quartz-core"
))]
#[cfg(not(target_os = "watchos"))]
extern_conformance!(
    unsafe impl CALayerDelegate for UISearchBar {}
);

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl NSCoding for UISearchBar {}
);

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for UISearchBar {}
);

#[cfg(all(feature = "UIAppearance", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIAppearance for UISearchBar {}
);

#[cfg(all(feature = "UIAppearance", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIAppearanceContainer for UISearchBar {}
);

#[cfg(all(feature = "UIBarCommon", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIBarPositioning for UISearchBar {}
);

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UICoordinateSpace for UISearchBar {}
);

#[cfg(all(
    feature = "UIDynamicBehavior",
    feature = "UIResponder",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIDynamicItem for UISearchBar {}
);

#[cfg(all(feature = "UIFocus", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIFocusEnvironment for UISearchBar {}
);

#[cfg(all(feature = "UIFocus", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIFocusItem for UISearchBar {}
);

#[cfg(all(feature = "UIFocus", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIFocusItemContainer for UISearchBar {}
);

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UILookToDictateCapable for UISearchBar {}
);

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIResponderStandardEditActions for UISearchBar {}
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UITextInputTraits",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITextInputTraits for UISearchBar {}
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UITraitCollection",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITraitEnvironment for UISearchBar {}
);

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
impl UISearchBar {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame(this: Allocated<Self>, frame: CGRect) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "UIInterface")]
        #[unsafe(method(barStyle))]
        #[unsafe(method_family = none)]
        pub fn barStyle(&self) -> UIBarStyle;

        #[cfg(feature = "UIInterface")]
        /// Setter for [`barStyle`][Self::barStyle].
        #[unsafe(method(setBarStyle:))]
        #[unsafe(method_family = none)]
        pub fn setBarStyle(&self, bar_style: UIBarStyle);

        #[cfg(feature = "UIBarCommon")]
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(&self) -> Option<Retained<ProtocolObject<dyn UISearchBarDelegate>>>;

        #[cfg(feature = "UIBarCommon")]
        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn UISearchBarDelegate>>);

        #[unsafe(method(text))]
        #[unsafe(method_family = none)]
        pub fn text(&self) -> Option<Retained<NSString>>;

        /// Setter for [`text`][Self::text].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setText:))]
        #[unsafe(method_family = none)]
        pub fn setText(&self, text: Option<&NSString>);

        #[unsafe(method(prompt))]
        #[unsafe(method_family = none)]
        pub fn prompt(&self) -> Option<Retained<NSString>>;

        /// Setter for [`prompt`][Self::prompt].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setPrompt:))]
        #[unsafe(method_family = none)]
        pub fn setPrompt(&self, prompt: Option<&NSString>);

        #[unsafe(method(placeholder))]
        #[unsafe(method_family = none)]
        pub fn placeholder(&self) -> Option<Retained<NSString>>;

        /// Setter for [`placeholder`][Self::placeholder].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setPlaceholder:))]
        #[unsafe(method_family = none)]
        pub fn setPlaceholder(&self, placeholder: Option<&NSString>);

        #[unsafe(method(showsBookmarkButton))]
        #[unsafe(method_family = none)]
        pub fn showsBookmarkButton(&self) -> bool;

        /// Setter for [`showsBookmarkButton`][Self::showsBookmarkButton].
        #[unsafe(method(setShowsBookmarkButton:))]
        #[unsafe(method_family = none)]
        pub fn setShowsBookmarkButton(&self, shows_bookmark_button: bool);

        #[cfg(all(
            feature = "UIControl",
            feature = "UISearchTextField",
            feature = "UITextField"
        ))]
        #[unsafe(method(searchTextField))]
        #[unsafe(method_family = none)]
        pub fn searchTextField(&self) -> Retained<UISearchTextField>;

        #[unsafe(method(showsCancelButton))]
        #[unsafe(method_family = none)]
        pub fn showsCancelButton(&self) -> bool;

        /// Setter for [`showsCancelButton`][Self::showsCancelButton].
        #[unsafe(method(setShowsCancelButton:))]
        #[unsafe(method_family = none)]
        pub fn setShowsCancelButton(&self, shows_cancel_button: bool);

        #[unsafe(method(showsSearchResultsButton))]
        #[unsafe(method_family = none)]
        pub fn showsSearchResultsButton(&self) -> bool;

        /// Setter for [`showsSearchResultsButton`][Self::showsSearchResultsButton].
        #[unsafe(method(setShowsSearchResultsButton:))]
        #[unsafe(method_family = none)]
        pub fn setShowsSearchResultsButton(&self, shows_search_results_button: bool);

        #[unsafe(method(isSearchResultsButtonSelected))]
        #[unsafe(method_family = none)]
        pub fn isSearchResultsButtonSelected(&self) -> bool;

        /// Setter for [`isSearchResultsButtonSelected`][Self::isSearchResultsButtonSelected].
        #[unsafe(method(setSearchResultsButtonSelected:))]
        #[unsafe(method_family = none)]
        pub fn setSearchResultsButtonSelected(&self, search_results_button_selected: bool);

        #[unsafe(method(setShowsCancelButton:animated:))]
        #[unsafe(method_family = none)]
        pub fn setShowsCancelButton_animated(&self, shows_cancel_button: bool, animated: bool);

        #[cfg(feature = "UITextInput")]
        /// Use this method to modify the contents of the Unified Content Bar, shown on top of the keyboard when search is engaged.
        /// You may modify the returned inputAssistantItem to add to or replace the existing items on the bar.
        /// Modifications made to the returned UITextInputAssistantItem are reflected automatically.
        #[unsafe(method(inputAssistantItem))]
        #[unsafe(method_family = none)]
        pub fn inputAssistantItem(&self) -> Retained<UITextInputAssistantItem>;

        #[cfg(feature = "UIColor")]
        #[unsafe(method(tintColor))]
        #[unsafe(method_family = none)]
        pub fn tintColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`tintColor`][Self::tintColor].
        ///
        /// # Safety
        ///
        /// `tint_color` might not allow `None`.
        #[unsafe(method(setTintColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTintColor(&self, tint_color: Option<&UIColor>);

        #[cfg(feature = "UIColor")]
        #[unsafe(method(barTintColor))]
        #[unsafe(method_family = none)]
        pub fn barTintColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`barTintColor`][Self::barTintColor].
        #[unsafe(method(setBarTintColor:))]
        #[unsafe(method_family = none)]
        pub fn setBarTintColor(&self, bar_tint_color: Option<&UIColor>);

        #[unsafe(method(searchBarStyle))]
        #[unsafe(method_family = none)]
        pub fn searchBarStyle(&self) -> UISearchBarStyle;

        /// Setter for [`searchBarStyle`][Self::searchBarStyle].
        #[unsafe(method(setSearchBarStyle:))]
        #[unsafe(method_family = none)]
        pub fn setSearchBarStyle(&self, search_bar_style: UISearchBarStyle);

        #[unsafe(method(isTranslucent))]
        #[unsafe(method_family = none)]
        pub fn isTranslucent(&self) -> bool;

        /// Setter for [`isTranslucent`][Self::isTranslucent].
        #[unsafe(method(setTranslucent:))]
        #[unsafe(method_family = none)]
        pub fn setTranslucent(&self, translucent: bool);

        #[unsafe(method(scopeButtonTitles))]
        #[unsafe(method_family = none)]
        pub fn scopeButtonTitles(&self) -> Option<Retained<NSArray<NSString>>>;

        /// Setter for [`scopeButtonTitles`][Self::scopeButtonTitles].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setScopeButtonTitles:))]
        #[unsafe(method_family = none)]
        pub fn setScopeButtonTitles(&self, scope_button_titles: Option<&NSArray<NSString>>);

        #[unsafe(method(selectedScopeButtonIndex))]
        #[unsafe(method_family = none)]
        pub fn selectedScopeButtonIndex(&self) -> NSInteger;

        /// Setter for [`selectedScopeButtonIndex`][Self::selectedScopeButtonIndex].
        #[unsafe(method(setSelectedScopeButtonIndex:))]
        #[unsafe(method_family = none)]
        pub fn setSelectedScopeButtonIndex(&self, selected_scope_button_index: NSInteger);

        #[unsafe(method(showsScopeBar))]
        #[unsafe(method_family = none)]
        pub fn showsScopeBar(&self) -> bool;

        /// Setter for [`showsScopeBar`][Self::showsScopeBar].
        #[unsafe(method(setShowsScopeBar:))]
        #[unsafe(method_family = none)]
        pub fn setShowsScopeBar(&self, shows_scope_bar: bool);

        #[unsafe(method(setShowsScopeBar:animated:))]
        #[unsafe(method_family = none)]
        pub fn setShowsScopeBar_animated(&self, show: bool, animate: bool);

        #[unsafe(method(inputAccessoryView))]
        #[unsafe(method_family = none)]
        pub fn inputAccessoryView(&self) -> Option<Retained<UIView>>;

        /// Setter for [`inputAccessoryView`][Self::inputAccessoryView].
        #[unsafe(method(setInputAccessoryView:))]
        #[unsafe(method_family = none)]
        pub fn setInputAccessoryView(&self, input_accessory_view: Option<&UIView>);

        /// When set to false, user interaction will be prevented and the search bar will take on a disabled appearance
        /// If the search bar is associated with a UINavigationItem with `UINavigationItemSearchBarPlacementIntegrated`,
        /// then the minimized (icon-only) UISearchBar will not grow to the text field while `enabled` is false.
        #[unsafe(method(isEnabled))]
        #[unsafe(method_family = none)]
        pub fn isEnabled(&self) -> bool;

        /// Setter for [`isEnabled`][Self::isEnabled].
        #[unsafe(method(setEnabled:))]
        #[unsafe(method_family = none)]
        pub fn setEnabled(&self, enabled: bool);

        #[cfg(feature = "UIImage")]
        #[unsafe(method(backgroundImage))]
        #[unsafe(method_family = none)]
        pub fn backgroundImage(&self) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImage")]
        /// Setter for [`backgroundImage`][Self::backgroundImage].
        #[unsafe(method(setBackgroundImage:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundImage(&self, background_image: Option<&UIImage>);

        #[cfg(feature = "UIImage")]
        #[unsafe(method(scopeBarBackgroundImage))]
        #[unsafe(method_family = none)]
        pub fn scopeBarBackgroundImage(&self) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImage")]
        /// Setter for [`scopeBarBackgroundImage`][Self::scopeBarBackgroundImage].
        #[unsafe(method(setScopeBarBackgroundImage:))]
        #[unsafe(method_family = none)]
        pub fn setScopeBarBackgroundImage(&self, scope_bar_background_image: Option<&UIImage>);

        #[cfg(all(feature = "UIBarCommon", feature = "UIImage"))]
        #[unsafe(method(setBackgroundImage:forBarPosition:barMetrics:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundImage_forBarPosition_barMetrics(
            &self,
            background_image: Option<&UIImage>,
            bar_position: UIBarPosition,
            bar_metrics: UIBarMetrics,
        );

        #[cfg(all(feature = "UIBarCommon", feature = "UIImage"))]
        #[unsafe(method(backgroundImageForBarPosition:barMetrics:))]
        #[unsafe(method_family = none)]
        pub fn backgroundImageForBarPosition_barMetrics(
            &self,
            bar_position: UIBarPosition,
            bar_metrics: UIBarMetrics,
        ) -> Option<Retained<UIImage>>;

        #[cfg(all(feature = "UIControl", feature = "UIImage"))]
        #[unsafe(method(setSearchFieldBackgroundImage:forState:))]
        #[unsafe(method_family = none)]
        pub fn setSearchFieldBackgroundImage_forState(
            &self,
            background_image: Option<&UIImage>,
            state: UIControlState,
        );

        #[cfg(all(feature = "UIControl", feature = "UIImage"))]
        #[unsafe(method(searchFieldBackgroundImageForState:))]
        #[unsafe(method_family = none)]
        pub fn searchFieldBackgroundImageForState(
            &self,
            state: UIControlState,
        ) -> Option<Retained<UIImage>>;

        #[cfg(all(feature = "UIControl", feature = "UIImage"))]
        #[unsafe(method(setImage:forSearchBarIcon:state:))]
        #[unsafe(method_family = none)]
        pub fn setImage_forSearchBarIcon_state(
            &self,
            icon_image: Option<&UIImage>,
            icon: UISearchBarIcon,
            state: UIControlState,
        );

        #[cfg(all(feature = "UIControl", feature = "UIImage"))]
        #[unsafe(method(imageForSearchBarIcon:state:))]
        #[unsafe(method_family = none)]
        pub fn imageForSearchBarIcon_state(
            &self,
            icon: UISearchBarIcon,
            state: UIControlState,
        ) -> Option<Retained<UIImage>>;

        #[cfg(all(feature = "UIControl", feature = "UIImage"))]
        #[unsafe(method(setScopeBarButtonBackgroundImage:forState:))]
        #[unsafe(method_family = none)]
        pub fn setScopeBarButtonBackgroundImage_forState(
            &self,
            background_image: Option<&UIImage>,
            state: UIControlState,
        );

        #[cfg(all(feature = "UIControl", feature = "UIImage"))]
        #[unsafe(method(scopeBarButtonBackgroundImageForState:))]
        #[unsafe(method_family = none)]
        pub fn scopeBarButtonBackgroundImageForState(
            &self,
            state: UIControlState,
        ) -> Option<Retained<UIImage>>;

        #[cfg(all(feature = "UIControl", feature = "UIImage"))]
        #[unsafe(method(setScopeBarButtonDividerImage:forLeftSegmentState:rightSegmentState:))]
        #[unsafe(method_family = none)]
        pub fn setScopeBarButtonDividerImage_forLeftSegmentState_rightSegmentState(
            &self,
            divider_image: Option<&UIImage>,
            left_state: UIControlState,
            right_state: UIControlState,
        );

        #[cfg(all(feature = "UIControl", feature = "UIImage"))]
        #[unsafe(method(scopeBarButtonDividerImageForLeftSegmentState:rightSegmentState:))]
        #[unsafe(method_family = none)]
        pub fn scopeBarButtonDividerImageForLeftSegmentState_rightSegmentState(
            &self,
            left_state: UIControlState,
            right_state: UIControlState,
        ) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIControl")]
        /// # Safety
        ///
        /// `attributes` generic should be of the correct type.
        #[unsafe(method(setScopeBarButtonTitleTextAttributes:forState:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setScopeBarButtonTitleTextAttributes_forState(
            &self,
            attributes: Option<&NSDictionary<NSAttributedStringKey, AnyObject>>,
            state: UIControlState,
        );

        #[cfg(feature = "UIControl")]
        #[unsafe(method(scopeBarButtonTitleTextAttributesForState:))]
        #[unsafe(method_family = none)]
        pub fn scopeBarButtonTitleTextAttributesForState(
            &self,
            state: UIControlState,
        ) -> Option<Retained<NSDictionary<NSAttributedStringKey, AnyObject>>>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(searchFieldBackgroundPositionAdjustment))]
        #[unsafe(method_family = none)]
        pub fn searchFieldBackgroundPositionAdjustment(&self) -> UIOffset;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Setter for [`searchFieldBackgroundPositionAdjustment`][Self::searchFieldBackgroundPositionAdjustment].
        #[unsafe(method(setSearchFieldBackgroundPositionAdjustment:))]
        #[unsafe(method_family = none)]
        pub fn setSearchFieldBackgroundPositionAdjustment(
            &self,
            search_field_background_position_adjustment: UIOffset,
        );

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(searchTextPositionAdjustment))]
        #[unsafe(method_family = none)]
        pub fn searchTextPositionAdjustment(&self) -> UIOffset;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Setter for [`searchTextPositionAdjustment`][Self::searchTextPositionAdjustment].
        #[unsafe(method(setSearchTextPositionAdjustment:))]
        #[unsafe(method_family = none)]
        pub fn setSearchTextPositionAdjustment(&self, search_text_position_adjustment: UIOffset);

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(setPositionAdjustment:forSearchBarIcon:))]
        #[unsafe(method_family = none)]
        pub fn setPositionAdjustment_forSearchBarIcon(
            &self,
            adjustment: UIOffset,
            icon: UISearchBarIcon,
        );

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(positionAdjustmentForSearchBarIcon:))]
        #[unsafe(method_family = none)]
        pub fn positionAdjustmentForSearchBarIcon(&self, icon: UISearchBarIcon) -> UIOffset;

        #[unsafe(method(isLookToDictateEnabled))]
        #[unsafe(method_family = none)]
        pub fn isLookToDictateEnabled(&self) -> bool;

        /// Setter for [`isLookToDictateEnabled`][Self::isLookToDictateEnabled].
        #[unsafe(method(setLookToDictateEnabled:))]
        #[unsafe(method_family = none)]
        pub fn setLookToDictateEnabled(&self, look_to_dictate_enabled: bool);
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "UIResponder", feature = "UIView"))]
impl UISearchBar {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uisearchbardelegate?language=objc)
    #[cfg(feature = "UIBarCommon")]
    pub unsafe trait UISearchBarDelegate: UIBarPositioningDelegate + MainThreadOnly {
        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(searchBarShouldBeginEditing:))]
        #[unsafe(method_family = none)]
        fn searchBarShouldBeginEditing(&self, search_bar: &UISearchBar) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(searchBarTextDidBeginEditing:))]
        #[unsafe(method_family = none)]
        fn searchBarTextDidBeginEditing(&self, search_bar: &UISearchBar);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(searchBarShouldEndEditing:))]
        #[unsafe(method_family = none)]
        fn searchBarShouldEndEditing(&self, search_bar: &UISearchBar) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(searchBarTextDidEndEditing:))]
        #[unsafe(method_family = none)]
        fn searchBarTextDidEndEditing(&self, search_bar: &UISearchBar);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(searchBar:textDidChange:))]
        #[unsafe(method_family = none)]
        fn searchBar_textDidChange(&self, search_bar: &UISearchBar, search_text: &NSString);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[deprecated]
        #[optional]
        #[unsafe(method(searchBar:shouldChangeTextInRange:replacementText:))]
        #[unsafe(method_family = none)]
        fn searchBar_shouldChangeTextInRange_replacementText(
            &self,
            search_bar: &UISearchBar,
            range: NSRange,
            text: &NSString,
        ) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Asks the delegate if the text at the specified `ranges` should be replaced with `text`.
        ///
        ///
        /// If this method returns YES then the search bar will, at its own discretion, choose any one of the specified `ranges` of text and replace it with the specified `replacementText` before deleting the text at the other ranges. If the delegate does not implement this method then the `searchBar:shouldChangeTextInRange:replacementText:` method will be called and passed the union range instead. If the delegate also does not implement that method then YES is assumed.
        ///
        ///
        /// Parameter `searchBar`: The search bar asking the delegate
        ///
        /// Parameter `ranges`: The ranges of the text that should be deleted before replacing
        ///
        /// Parameter `replacementText`: The replacement text
        ///
        ///
        /// Returns: Returns true if the text at the `ranges` should be replaced.
        #[optional]
        #[unsafe(method(searchBar:shouldChangeTextInRanges:replacementText:))]
        #[unsafe(method_family = none)]
        fn searchBar_shouldChangeTextInRanges_replacementText(
            &self,
            search_bar: &UISearchBar,
            ranges: &NSArray<NSValue>,
            replacement_text: &NSString,
        ) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(searchBarSearchButtonClicked:))]
        #[unsafe(method_family = none)]
        fn searchBarSearchButtonClicked(&self, search_bar: &UISearchBar);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(searchBarBookmarkButtonClicked:))]
        #[unsafe(method_family = none)]
        fn searchBarBookmarkButtonClicked(&self, search_bar: &UISearchBar);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(searchBarCancelButtonClicked:))]
        #[unsafe(method_family = none)]
        fn searchBarCancelButtonClicked(&self, search_bar: &UISearchBar);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(searchBarResultsListButtonClicked:))]
        #[unsafe(method_family = none)]
        fn searchBarResultsListButtonClicked(&self, search_bar: &UISearchBar);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(searchBar:selectedScopeButtonIndexDidChange:))]
        #[unsafe(method_family = none)]
        fn searchBar_selectedScopeButtonIndexDidChange(
            &self,
            search_bar: &UISearchBar,
            selected_scope: NSInteger,
        );
    }
);
