//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use objc2::__framework_prelude::*;

use crate::*;

/// Background
///
/// When fonts created with `+[UIFont preferredFontForTextStyle:]` are used, UILabel, UITextField, and nonscrollable
/// UITextView will increase the height calculated in `-sizeThatFits:` and `-intrinsicContentSize` in the presence
/// of tall scripts.
///
/// Even with this increase, there will be some extreme ascenders and descenders that extend beyond this height.
///
/// Furthermore, this increase only occurs for the text-style fonts, so for non-text-style fonts such cases will be markedly more common.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiletterformawaresizingrule?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UILetterformAwareSizingRule(pub NSInteger);
impl UILetterformAwareSizingRule {
    /// `UILetterformAwareSizingRuleTypographic`: `-sizeThatFits:` and `-intrinsicContentSize` results will work well for typographic alignment of edges and centers of the view frames, but extreme ascenders or descenders in tall scripts may not be accounted for
    #[doc(alias = "UILetterformAwareSizingRuleTypographic")]
    pub const Typographic: Self = Self(0);
    /// `UILetterformAwareSizingRuleOversize`: `-sizeThatFits:` and `-intrinsicContentSize` results will account for extreme ascenders or descenders in tall scripts, but in such cases might not work well for typographic alignment of top and bottom edges and vertical centers of the view frames
    #[doc(alias = "UILetterformAwareSizingRuleOversize")]
    pub const Oversize: Self = Self(1);
}

unsafe impl Encode for UILetterformAwareSizingRule {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UILetterformAwareSizingRule {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiletterformawareadjusting?language=objc)
    pub unsafe trait UILetterformAwareAdjusting: NSObjectProtocol + MainThreadOnly {
        /// `sizingRule` defaults to `UILetterformAwareSizingRuleTypographic` and determines what rule is used during the calculation of `-sizeThatFits:` and `-intrinsicContentSize`
        #[unsafe(method(sizingRule))]
        #[unsafe(method_family = none)]
        fn sizingRule(&self) -> UILetterformAwareSizingRule;

        /// Setter for [`sizingRule`][Self::sizingRule].
        #[unsafe(method(setSizingRule:))]
        #[unsafe(method_family = none)]
        fn setSizingRule(&self, sizing_rule: UILetterformAwareSizingRule);
    }
);
