/*
 * Copyright 2023 Ping Identity Corporation
 * All Rights Reserved.
 */
/*
 * Copyright 2020-2023 Ping Identity Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright (C) 2023 Ping Identity Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (GPLv2 only)
 * or the terms of the GNU Lesser General Public License (LGPLv2.1 only)
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;



import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;



/**
 * This enum defines a set of message keys for messages in the
 * com.unboundid.ldap.sdk.unboundidds.logs.v2.json package, which correspond to messages in the
 * unboundid-ldapsdk-json-log.properties properties file.
 * <BR><BR>
 * This source file was generated from the properties file.
 * Do not edit it directly.
 */
enum JSONLogMessages
{
  /**
   * Unable to identify the operation type for intermediate response log message {0}.
   */
  ERR_INTERMEDIATE_RESPONSE_CANNOT_IDENTIFY_OPERATION_TYPE("Unable to identify the operation type for intermediate response log message {0}."),



  /**
   * Unable to parse JSON object {0} as a valid JSON-formatted access log message because it is missing the required ''{1}'' field to indicate the type of log message that was read.
   */
  ERR_JSON_ACCESS_LOG_READER_MISSING_MESSAGE_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it is missing the required ''{1}'' field to indicate the type of log message that was read."),



  /**
   * Unable to parse JSON object {0} as a valid JSON-formatted access log message because it is missing the expected ''{1}'' field to indicate the type of operation being processed.
   */
  ERR_JSON_ACCESS_LOG_READER_MISSING_OPERATION_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it is missing the expected ''{1}'' field to indicate the type of operation being processed."),



  /**
   * The JSON-formatted access log data includes content that could not be parsed as a valid JSON object:  {0}
   */
  ERR_JSON_ACCESS_LOG_READER_NOT_VALID_JSON("The JSON-formatted access log data includes content that could not be parsed as a valid JSON object:  {0}"),



  /**
   * Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an operation type of {1}, which is not supported for assurance completed log messages.
   */
  ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_ASSURANCE_COMPLETED_OP_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an operation type of {1}, which is not supported for assurance completed log messages."),



  /**
   * Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an operation type of {1}, which is not supported for forward failed log messages.
   */
  ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_FORWARD_FAILED_OP_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an operation type of {1}, which is not supported for forward failed log messages."),



  /**
   * Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an operation type of {1}, which is not supported for forward log messages.
   */
  ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_FORWARD_OP_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an operation type of {1}, which is not supported for forward log messages."),



  /**
   * Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an unsupported message type of ''{1}''.
   */
  ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_MESSAGE_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an unsupported message type of ''{1}''."),



  /**
   * Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an unsupported operation type of ''{1}''.
   */
  ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_OPERATION_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an unsupported operation type of ''{1}''."),



  /**
   * Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an operation type of {1}, which is not supported for request log messages.
   */
  ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_REQUEST_OP_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an operation type of {1}, which is not supported for request log messages."),



  /**
   * Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an operation type of {1}, which is not supported for result log messages.
   */
  ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_RESULT_OP_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an operation type of {1}, which is not supported for result log messages."),



  /**
   * Unable to parse JSON object {0} as a JSON-formatted log message because the value of the ''{1}'' field cannot be parsed as a timestamp in the ISO 8601 format described in RFC 3339.
   */
  ERR_JSON_LOG_MESSAGE_MALFORMED_TIMESTAMP("Unable to parse JSON object {0} as a JSON-formatted log message because the value of the ''{1}'' field cannot be parsed as a timestamp in the ISO 8601 format described in RFC 3339."),



  /**
   * Unable to parse JSON object {0} as a JSON-formatted log message because it is missing the mandatory ''{1}'' field.
   */
  ERR_JSON_LOG_MESSAGE_MISSING_TIMESTAMP("Unable to parse JSON object {0} as a JSON-formatted log message because it is missing the mandatory ''{1}'' field."),



  /**
   * Unable to parse JSON object {0} as a JSON-formatted log message because the value of the ''{1}'' field is not a string.
   */
  ERR_JSON_LOG_MESSAGE_TIMESTAMP_NOT_STRING("Unable to parse JSON object {0} as a JSON-formatted log message because the value of the ''{1}'' field is not a string."),



  /**
   * Unable to parse the value of field ''{0}'' in JSON-formatted log message {1} as a Boolean.
   */
  ERR_JSON_LOG_MESSAGE_VALUE_NOT_BOOLEAN("Unable to parse the value of field ''{0}'' in JSON-formatted log message {1} as a Boolean."),



  /**
   * Unable to parse the value of field ''{0}'' in JSON-formatted log message {1} as a floating-point number.
   */
  ERR_JSON_LOG_MESSAGE_VALUE_NOT_FLOATING_POINT("Unable to parse the value of field ''{0}'' in JSON-formatted log message {1} as a floating-point number."),



  /**
   * Unable to parse the value of field ''{0}'' in JSON-formatted log message {1} as a timestamp in the generalized time format.
   */
  ERR_JSON_LOG_MESSAGE_VALUE_NOT_GENERALIZED_TIME("Unable to parse the value of field ''{0}'' in JSON-formatted log message {1} as a timestamp in the generalized time format."),



  /**
   * Unable to parse the value of field ''{0}'' in JSON-formatted log message {1} as an integer.
   */
  ERR_JSON_LOG_MESSAGE_VALUE_NOT_INTEGER("Unable to parse the value of field ''{0}'' in JSON-formatted log message {1} as an integer."),



  /**
   * Unable to parse the value of field ''{0}'' in JSON-formatted log message {1} as a timestamp in the ISO 8601 format described in RFC 3339.
   */
  ERR_JSON_LOG_MESSAGE_VALUE_NOT_RFC_3339_TIME("Unable to parse the value of field ''{0}'' in JSON-formatted log message {1} as a timestamp in the ISO 8601 format described in RFC 3339.");



  /**
   * Indicates whether the unit tests are currently running.
   */
  private static final boolean IS_WITHIN_UNIT_TESTS =
       Boolean.getBoolean("com.unboundid.ldap.sdk.RunningUnitTests") ||
       Boolean.getBoolean("com.unboundid.directory.server.RunningUnitTests");



  /**
   * A pre-allocated array of zero objects to use for messages
   * that do not require any arguments.
   */
  private static final Object[] NO_ARGS = new Object[0];



  /**
   * The resource bundle that will be used to load the properties file.
   */
  private static final ResourceBundle RESOURCE_BUNDLE;
  static
  {
    ResourceBundle rb = null;
    try
    {
      rb = ResourceBundle.getBundle("unboundid-ldapsdk-json-log");
    } catch (final Exception e) {}
    RESOURCE_BUNDLE = rb;
  }



  /**
   * The map that will be used to hold the unformatted message strings, indexed by property name.
   */
  private static final ConcurrentHashMap<JSONLogMessages,String> MESSAGE_STRINGS = new ConcurrentHashMap<>(100);



  /**
   * The map that will be used to hold the message format objects, indexed by property name.
   */
  private static final ConcurrentHashMap<JSONLogMessages,MessageFormat> MESSAGES = new ConcurrentHashMap<>(100);



  // The default text for this message
  private final String defaultText;



  /**
   * Creates a new message key.
   */
  private JSONLogMessages(final String defaultText)
  {
    this.defaultText = defaultText;
  }



  /**
   * Retrieves a localized version of the message.
   * This method should only be used for messages that do not take any
   * arguments.
   *
   * @return  A localized version of the message.
   */
  public String get()
  {
    MessageFormat f = MESSAGES.get(this);
    if (f == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        f = new MessageFormat(defaultText);
      }
      else
      {
        try
        {
          f = new MessageFormat(RESOURCE_BUNDLE.getString(name()));
        }
        catch (final Exception e)
        {
          f = new MessageFormat(defaultText);
        }
      }
      MESSAGES.putIfAbsent(this, f);
    }

    final String formattedMessage;
    synchronized (f)
    {
      formattedMessage = f.format(NO_ARGS);
    }

    if (IS_WITHIN_UNIT_TESTS)
    {
      if (formattedMessage.contains("{0}") ||
          formattedMessage.contains("{0,number,0}") ||
          formattedMessage.contains("{1}") ||
          formattedMessage.contains("{1,number,0}") ||
          formattedMessage.contains("{2}") ||
          formattedMessage.contains("{2,number,0}") ||
          formattedMessage.contains("{3}") ||
          formattedMessage.contains("{3,number,0}") ||
          formattedMessage.contains("{4}") ||
          formattedMessage.contains("{4,number,0}") ||
          formattedMessage.contains("{5}") ||
          formattedMessage.contains("{5,number,0}") ||
          formattedMessage.contains("{6}") ||
          formattedMessage.contains("{6,number,0}") ||
          formattedMessage.contains("{7}") ||
          formattedMessage.contains("{7,number,0}") ||
          formattedMessage.contains("{8}") ||
          formattedMessage.contains("{8,number,0}") ||
          formattedMessage.contains("{9}") ||
          formattedMessage.contains("{9,number,0}") ||
          formattedMessage.contains("{10}") ||
          formattedMessage.contains("{10,number,0}"))
      {
        throw new IllegalArgumentException(
             "Message " + getClass().getName() + '.' + name() +
                  " contains an un-replaced token:  " + formattedMessage);
      }
    }

    return formattedMessage;
  }



  /**
   * Retrieves a localized version of the message.
   *
   * @param  args  The arguments to use to format the message.
   *
   * @return  A localized version of the message.
   */
  public String get(final Object... args)
  {
    MessageFormat f = MESSAGES.get(this);
    if (f == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        f = new MessageFormat(defaultText);
      }
      else
      {
        try
        {
          f = new MessageFormat(RESOURCE_BUNDLE.getString(name()));
        }
        catch (final Exception e)
        {
          f = new MessageFormat(defaultText);
        }
      }
      MESSAGES.putIfAbsent(this, f);
    }

    final String formattedMessage;
    synchronized (f)
    {
      formattedMessage = f.format(args);
    }

    if (IS_WITHIN_UNIT_TESTS)
    {
      if (formattedMessage.contains("{0}") ||
          formattedMessage.contains("{0,number,0}") ||
          formattedMessage.contains("{1}") ||
          formattedMessage.contains("{1,number,0}") ||
          formattedMessage.contains("{2}") ||
          formattedMessage.contains("{2,number,0}") ||
          formattedMessage.contains("{3}") ||
          formattedMessage.contains("{3,number,0}") ||
          formattedMessage.contains("{4}") ||
          formattedMessage.contains("{4,number,0}") ||
          formattedMessage.contains("{5}") ||
          formattedMessage.contains("{5,number,0}") ||
          formattedMessage.contains("{6}") ||
          formattedMessage.contains("{6,number,0}") ||
          formattedMessage.contains("{7}") ||
          formattedMessage.contains("{7,number,0}") ||
          formattedMessage.contains("{8}") ||
          formattedMessage.contains("{8,number,0}") ||
          formattedMessage.contains("{9}") ||
          formattedMessage.contains("{9,number,0}") ||
          formattedMessage.contains("{10}") ||
          formattedMessage.contains("{10,number,0}"))
      {
        throw new IllegalArgumentException(
             "Message " + getClass().getName() + '.' + name() +
                  " contains an un-replaced token:  " + formattedMessage);
      }
    }

    return formattedMessage;
  }



  /**
   * Retrieves a string representation of this message key.
   *
   * @return  A string representation of this message key.
   */
  @Override()
  public String toString()
  {
    String s = MESSAGE_STRINGS.get(this);
    if (s == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        s = defaultText;
      }
      else
      {
        try
        {
          s = RESOURCE_BUNDLE.getString(name());
        }
        catch (final Exception e)
        {
          s = defaultText;
        }
        MESSAGE_STRINGS.putIfAbsent(this, s);
      }
    }

    return s;
  }
}

