/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server;

import com.sun.tools.javac.main.Main;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.comp.PooledSjavac;
import com.sun.tools.sjavac.comp.SjavacImpl;
import com.sun.tools.sjavac.server.IdleResetSjavac;
import com.sun.tools.sjavac.server.PortFile;
import com.sun.tools.sjavac.server.PortFileMonitor;
import com.sun.tools.sjavac.server.RequestHandler;
import com.sun.tools.sjavac.server.Sjavac;
import com.sun.tools.sjavac.server.Terminable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;

public class SjavacServer
implements Terminable {
    public static final String LINE_TYPE_RC = "RC";
    private final String portfilename;
    private final int poolsize;
    private final int keepalive;
    private final long myCookie;
    private long totalBuildTime;
    Sjavac sjavac;
    private ServerSocket serverSocket;
    private PortFile portFile;
    private PortFileMonitor portFileMonitor;
    final AtomicBoolean keepAcceptingRequests = new AtomicBoolean();
    private static Map<String, PortFile> allPortFiles;

    public SjavacServer(String string) throws FileNotFoundException {
        this(Util.extractStringOption("portfile", string), Util.extractIntOption("poolsize", string, Runtime.getRuntime().availableProcessors()), Util.extractIntOption("keepalive", string, 120));
    }

    public SjavacServer(String string, int n, int n2) throws FileNotFoundException {
        this.portfilename = string;
        this.poolsize = n;
        this.keepalive = n2;
        this.myCookie = new Random().nextLong();
    }

    public static synchronized PortFile getPortFile(String string) {
        PortFile portFile;
        if (allPortFiles == null) {
            allPortFiles = new HashMap<String, PortFile>();
        }
        if ((portFile = allPortFiles.get(string)) != null) {
            try {
                if (!portFile.exists()) {
                    portFile = null;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (portFile == null) {
            portFile = new PortFile(string);
            allPortFiles.put(string, portFile);
        }
        return portFile;
    }

    long getCookie() {
        return this.myCookie;
    }

    int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public void addBuildTime(long l) {
        this.totalBuildTime += l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startServer() throws IOException, InterruptedException {
        long l = System.currentTimeMillis();
        this.portFile = SjavacServer.getPortFile(this.portfilename);
        Object object = this.portFile;
        synchronized (object) {
            this.portFile.lock();
            this.portFile.getValues();
            if (this.portFile.containsPortInfo()) {
                Log.debug("Javac server not started because portfile exists!");
                this.portFile.unlock();
                return Main.Result.ERROR.exitCode;
            }
            this.sjavac = new SjavacImpl();
            this.sjavac = new PooledSjavac(this.sjavac, this.poolsize);
            this.sjavac = new IdleResetSjavac(this.sjavac, this, this.keepalive * 1000);
            this.serverSocket = new ServerSocket();
            InetAddress inetAddress = InetAddress.getByName(null);
            this.serverSocket.bind(new InetSocketAddress(inetAddress, 0));
            this.portFile.setValues(this.getPort(), this.getCookie());
            this.portFile.unlock();
        }
        this.portFileMonitor = new PortFileMonitor(this.portFile, this);
        this.portFileMonitor.start();
        Log.debug("Sjavac server started. Accepting connections...");
        Log.debug("    port: " + this.getPort());
        Log.debug("    time: " + new Date());
        Log.debug("    poolsize: " + this.poolsize);
        this.keepAcceptingRequests.set(true);
        do {
            try {
                object = this.serverSocket.accept();
                new RequestHandler((Socket)object, this.sjavac).start();
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        } while (this.keepAcceptingRequests.get());
        Log.debug("Shutting down.");
        long l2 = System.currentTimeMillis() - l;
        Log.debug("Total wall clock time " + l2 + "ms build time " + this.totalBuildTime + "ms");
        this.sjavac.shutdown();
        return Main.Result.OK.exitCode;
    }

    @Override
    public void shutdown(String string) {
        if (!this.keepAcceptingRequests.compareAndSet(true, false)) {
            return;
        }
        Log.debug("Quitting: " + string);
        this.portFileMonitor.shutdown();
        try {
            this.portFile.delete();
        }
        catch (IOException | InterruptedException exception) {
            Log.error(exception);
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            Log.error(iOException);
        }
    }
}

