/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.dummy;

import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerBase;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.MachineDescription;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.debugger.ReadResult;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.dummy.DummyAddress;
import sun.jvm.hotspot.utilities.PlatformInfo;

public class DummyDebugger
extends DebuggerBase {
    private MachineDescription machDesc;

    public DummyDebugger(MachineDescription machDesc) {
        this.machDesc = machDesc;
    }

    @Override
    public boolean hasProcessList() throws DebuggerException {
        return false;
    }

    @Override
    public List getProcessList() throws DebuggerException {
        return null;
    }

    @Override
    public void attach(int processID) throws DebuggerException {
    }

    @Override
    public void attach(String executableName, String coreFileName) throws DebuggerException {
    }

    @Override
    public boolean detach() {
        return true;
    }

    @Override
    public Address parseAddress(String addrStr) {
        String s = addrStr.trim();
        if (!s.startsWith("0x")) {
            throw new NumberFormatException(addrStr);
        }
        long l = 0L;
        for (int i = 2; i < s.length(); ++i) {
            int val = this.charToNibble(s.charAt(i));
            l <<= 4;
            l |= (long)val;
        }
        return new DummyAddress(this, l);
    }

    @Override
    public long getAddressValue(Address addr) {
        if (addr == null) {
            return 0L;
        }
        return ((DummyAddress)addr).getValue();
    }

    @Override
    public String getOS() {
        return PlatformInfo.getOS();
    }

    @Override
    public String getCPU() {
        return PlatformInfo.getCPU();
    }

    @Override
    public MachineDescription getMachineDescription() throws DebuggerException {
        return this.machDesc;
    }

    @Override
    public boolean hasConsole() {
        return false;
    }

    @Override
    public String consoleExecuteCommand(String cmd) throws DebuggerException {
        throw new DebuggerException("unimplemented");
    }

    @Override
    public String getConsolePrompt() throws DebuggerException {
        throw new DebuggerException("unimplemented");
    }

    @Override
    public CDebugger getCDebugger() throws DebuggerException {
        return null;
    }

    @Override
    public Address lookup(String objectName, String symbol) {
        return null;
    }

    @Override
    public OopHandle lookupOop(String objectName, String symbol) {
        return null;
    }

    @Override
    public ThreadProxy getThreadForIdentifierAddress(Address addr) {
        return null;
    }

    @Override
    public ThreadProxy getThreadForThreadId(long id) {
        return null;
    }

    @Override
    public ReadResult readBytesFromProcess(long address, long numBytes) throws DebuggerException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void writeBytesToProcess(long a, long b, byte[] buf) throws DebuggerException {
        throw new DebuggerException("Unimplemented");
    }

    String addressToString(DummyAddress addr) {
        StringBuffer buf = new StringBuffer();
        buf.append("0x");
        String val = addr == null ? "0" : Long.toHexString(addr.getValue());
        int i = 0;
        while ((long)i < 2L * this.machDesc.getAddressSize() - (long)val.length()) {
            buf.append('0');
            ++i;
        }
        buf.append(val);
        return buf.toString();
    }

    private int charToNibble(char ascii) throws NumberFormatException {
        if (ascii >= '0' && ascii <= '9') {
            return ascii - 48;
        }
        if (ascii >= 'A' && ascii <= 'F') {
            return 10 + ascii - 65;
        }
        if (ascii >= 'a' && ascii <= 'f') {
            return 10 + ascii - 97;
        }
        throw new NumberFormatException(new Character(ascii).toString());
    }
}

