/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.sql.JDBCType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectJDBC;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.utils.CommonUtils;

public class CustomTimeEditor {
    private final int style;
    private final boolean isPanel;
    private DateTime dateEditor;
    private DateTime timeEditor;
    private Composite basePart;
    private Label timeLabel;
    private Label dateLabel;
    private int millis = -1;
    private String dateAsText = "";
    private final boolean isInline;
    private InputMode inputMode = InputMode.NONE;
    private final Calendar calendar = Calendar.getInstance();
    private Text textEditor;
    private Listener modifyListener;
    private SelectionAdapter selectionListener;
    private boolean editable;
    private CLabel warningLabel;
    private Composite mainComposite;
    private JDBCType jdbcType;

    public void createDateFormat(@NotNull DBSTypedObject valueType) {
        if (valueType instanceof DBSTypedObjectJDBC) {
            try {
                this.jdbcType = JDBCType.valueOf(valueType.getTypeID());
            }
            catch (Exception exception) {
                this.jdbcType = JDBCType.TIMESTAMP;
            }
        } else {
            this.jdbcType = JDBCType.TIMESTAMP;
        }
        this.disposeNotNeededEditors();
    }

    public void createDateFormat(JDBCType jdbcType) {
        this.jdbcType = jdbcType;
        this.disposeNotNeededEditors();
    }

    private void disposeNotNeededEditors() {
        if (this.jdbcType != null) {
            switch (this.jdbcType) {
                case DATE: {
                    this.inputMode = InputMode.DATE;
                    this.disposeEditor((Control)this.timeEditor, this.timeLabel);
                    break;
                }
                case TIME: {
                    this.inputMode = InputMode.TIME;
                    this.disposeEditor((Control)this.dateEditor, this.dateLabel);
                    break;
                }
                default: {
                    this.inputMode = InputMode.DATETIME;
                }
            }
        }
    }

    public CustomTimeEditor(@NotNull Composite parent, int style, boolean isPanel, boolean isInline) {
        this.isInline = isInline;
        this.isPanel = isPanel;
        this.style = style;
        this.initEditor(parent, style);
    }

    @NotNull
    private Composite initEditor(@NotNull Composite parent, int style) {
        if (!this.isInline) {
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.mainComposite = new Composite(parent, style);
            this.mainComposite.setLayout((Layout)layout);
            this.mainComposite.setLayoutData((Object)new GridData(768));
        }
        this.basePart = new Composite(this.isInline ? parent : this.mainComposite, style);
        this.basePart.setLayoutData((Object)new GridData(768));
        GridLayout basePartLayout = new GridLayout(2, false);
        if (this.isInline) {
            basePartLayout.marginHeight = 0;
            basePartLayout.marginWidth = 0;
        }
        this.basePart.setLayout((Layout)basePartLayout);
        this.setToDateComposite();
        this.basePart.pack();
        return this.isInline ? this.basePart : this.mainComposite;
    }

    public void setToTextComposite() {
        if (this.textEditor != null && !this.textEditor.isDisposed()) {
            return;
        }
        this.disposeEditor((Control)this.timeEditor, this.timeLabel);
        this.timeEditor = null;
        this.disposeEditor((Control)this.dateEditor, this.dateLabel);
        this.dateEditor = null;
        this.textEditor = new Text(this.basePart, this.isPanel && !this.isInline ? this.style : 2048);
        CSSUtils.setExcludeFromStyling((Widget)this.textEditor);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        this.textEditor.setLayoutData((Object)gridData);
        if (this.warningLabel != null) {
            this.warningLabel.dispose();
            this.warningLabel = null;
        }
        this.basePart.setLayoutData((Object)new GridData(1808));
        this.allowEdit();
        this.textEditor.setText(this.dateAsText);
        if (this.mainComposite != null) {
            this.mainComposite.layout();
        }
        this.basePart.layout();
    }

    private void disposeEditor(Control editor, Label editorLabel) {
        if (editor != null) {
            editor.dispose();
            if (editorLabel != null) {
                editorLabel.dispose();
            }
        }
    }

    public void setToDateComposite() {
        if (this.dateEditor != null || this.timeEditor != null) {
            return;
        }
        this.disposeEditor((Control)this.textEditor, null);
        GridData layoutData = new GridData(4, 131072, true, false, 1, 1);
        if (!this.isInline) {
            this.dateLabel = UIUtils.createLabel(this.basePart, "Date");
        }
        if (CommonUtils.isEmpty((String)this.dateAsText)) {
            this.updateWarningLabel(null);
        }
        this.dateEditor = new DateTime(this.basePart, 4);
        this.dateEditor.setLayoutData((Object)layoutData);
        if (!this.isInline) {
            this.timeLabel = UIUtils.createLabel(this.basePart, "Time");
        }
        this.timeEditor = new DateTime(this.basePart, 65664);
        this.timeEditor.setLayoutData((Object)layoutData);
        this.basePart.setLayoutData((Object)new GridData(768));
        this.disposeNotNeededEditors();
        this.allowEdit();
        this.setDateFromCalendar();
        this.updateListeners();
        this.basePart.layout();
        if (this.mainComposite != null) {
            this.mainComposite.layout();
        }
    }

    public void updateListeners() {
        if (this.selectionListener != null) {
            if (this.dateEditor != null && !this.dateEditor.isDisposed()) {
                this.dateEditor.addSelectionListener((SelectionListener)this.selectionListener);
            }
            if (this.timeEditor != null && !this.timeEditor.isDisposed()) {
                this.timeEditor.addSelectionListener((SelectionListener)this.selectionListener);
            }
        }
        if (this.modifyListener != null && this.textEditor != null && !this.textEditor.isDisposed()) {
            this.textEditor.addListener(24, this.modifyListener);
        }
    }

    public void addSelectionAdapter(@NotNull SelectionAdapter listener) {
        this.selectionListener = listener;
        this.updateListeners();
    }

    public void addModifyListener(@NotNull Listener listener) {
        this.modifyListener = listener;
        this.updateListeners();
    }

    private static void setWithoutListener(@NotNull Control control, Listener listener, @NotNull Runnable blockToRun) {
        if (listener != null) {
            control.removeListener(24, listener);
            blockToRun.run();
            control.addListener(24, listener);
        } else {
            blockToRun.run();
        }
    }

    private void updateWarningLabel(@Nullable Object value) {
        if (this.isInline) {
            return;
        }
        if (value == null && (this.textEditor == null || this.textEditor.isDisposed())) {
            if (this.warningLabel != null && !this.warningLabel.isDisposed()) {
                return;
            }
            this.warningLabel = new CLabel(this.mainComposite, this.style);
            this.warningLabel.setText("Original value was null, using current time");
            this.warningLabel.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.SMALL_INFO));
            this.mainComposite.layout();
        } else if (this.warningLabel != null) {
            this.warningLabel.dispose();
            this.mainComposite.layout();
        }
    }

    public void setTextValue(@Nullable String value) {
        this.dateAsText = value;
        if (this.textEditor != null && !this.textEditor.isDisposed()) {
            CustomTimeEditor.setWithoutListener((Control)this.textEditor, this.modifyListener, () -> this.textEditor.setText(this.dateAsText));
        }
    }

    public void setValue(@Nullable Object value) throws DBCException {
        this.updateWarningLabel(value);
        Date adaptedValue = this.adaptToDate(value);
        if (adaptedValue != null) {
            this.calendar.setTime(adaptedValue);
        } else {
            switch (this.inputMode) {
                case TIME: {
                    this.calendar.setTime(new Time(System.currentTimeMillis()));
                    break;
                }
                case DATE: {
                    this.calendar.setTime(new Date(System.currentTimeMillis()));
                    break;
                }
                case DATETIME: {
                    this.calendar.setTime(new Timestamp(System.currentTimeMillis()));
                    break;
                }
            }
        }
        this.setDateFromCalendar();
    }

    private void setDateFromCalendar() {
        if (this.dateEditor != null && !this.dateEditor.isDisposed()) {
            this.dateEditor.setDate(this.calendar.get(1), this.calendar.get(2), this.calendar.get(5));
        }
        if (this.timeEditor != null && !this.timeEditor.isDisposed()) {
            this.timeEditor.addTraverseListener(e -> {
                boolean bl = this.timeEditor.setFocus();
            });
            this.timeEditor.setTime(this.calendar.get(11), this.calendar.get(12), this.calendar.get(13));
            try {
                this.millis = this.calendar.get(14);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.millis = -1;
            }
        }
    }

    @Nullable
    public String getValueAsString() {
        if (this.textEditor != null && !this.textEditor.isDisposed()) {
            return this.textEditor.getText();
        }
        return null;
    }

    @NotNull
    public Date getValueAsDate() {
        switch (this.inputMode) {
            case TIME: {
                this.calendar.set(0, 0, 0, this.timeEditor.getHours(), this.timeEditor.getMinutes(), this.timeEditor.getSeconds());
                break;
            }
            case DATE: {
                this.calendar.set(this.dateEditor.getYear(), this.dateEditor.getMonth(), this.dateEditor.getDay());
                break;
            }
            case DATETIME: {
                this.calendar.set(this.dateEditor.getYear(), this.dateEditor.getMonth(), this.dateEditor.getDay(), this.timeEditor.getHours(), this.timeEditor.getMinutes(), this.timeEditor.getSeconds());
                break;
            }
            default: {
                this.calendar.set(0, 0, 0, 0, 0, 0);
            }
        }
        if (this.millis != -1) {
            this.calendar.set(14, this.millis);
        }
        return this.calendar.getTime();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.allowEdit();
    }

    public void allowEdit() {
        if (this.dateEditor != null && !this.dateEditor.isDisposed()) {
            this.dateEditor.setEnabled(this.editable);
        }
        if (this.timeEditor != null && !this.timeEditor.isDisposed()) {
            this.timeEditor.setEnabled(this.editable);
        }
        if (this.textEditor != null && !this.textEditor.isDisposed()) {
            this.textEditor.setEditable(this.editable);
        }
    }

    public Composite getControl() {
        return this.isInline ? this.basePart : this.mainComposite;
    }

    public void selectAllContent() {
        if (this.textEditor != null && !this.textEditor.isDisposed()) {
            this.textEditor.selectAll();
        }
    }

    @Nullable
    public Date adaptToDate(@Nullable Object value) throws DBCException {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Instant) {
            return Date.from((Instant)value);
        }
        if (value instanceof LocalDateTime) {
            return Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
        }
        throw new DBCException(value.toString());
    }

    private static enum InputMode {
        NONE,
        DATE,
        TIME,
        DATETIME;

    }
}

