//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdeviceclassname?language=objc)
pub const kIOUSBDeviceClassName: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOUSBDevice\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbinterfaceclassname?language=objc)
pub const kIOUSBInterfaceClassName: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOUSBInterface\0") };
/// The object you use to access USB devices from user space, returned by all versions of the IOUSBFamily
/// currently shipping.
///
/// The functions listed here will work with any version of the IOUSBDeviceInterface, including
/// the one shipped with Mac OS X version 10.0.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicestruct100?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceStruct100 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    /// Creates a run loop source for delivery of all asynchronous notifications on this device.
    ///
    /// The Mac OS X kernel does not spawn a thread to callback to the client. Instead it delivers
    /// completion notifications (see
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface/CreateInterfaceAsyncPort/ CreateInterfaceAsyncPort
    /// ```
    ///
    /// ). This routine
    /// wraps that port with the appropriate routing code so that the completion notifications can be
    /// automatically routed through the client's CFRunLoop.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `source`: Pointer to a CFRunLoopSourceRef to return the newly created run loop event source.
    ///
    /// Returns: Returns kIOReturnSuccess if successful or a kern_return_t if unsuccessful.
    pub CreateDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    /// Returns the CFRunLoopSourceRef for this IOService instance.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Returns: Returns the run loop source if one has been created, 0 otherwise.
    pub GetDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    /// Creates and registers a mach_port_t for asynchronous communications.
    ///
    /// The Mac OS X kernel does not spawn a thread to callback to the client. Instead it delivers
    /// completion notifications on this mach port. After receiving a message on this port the
    /// client is obliged to call the IOKitLib.h IODispatchCalloutFromMessage() function for
    /// decoding the notification message.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `port`: Pointer to a mach_port_t to return the newly created port.
    ///
    /// Returns: Returns kIOReturnSuccess if successful or a kern_return_t if unsuccessful.
    pub CreateDeviceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    /// Returns the mach_port_t port for this IOService instance.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Returns: Returns the port if one exists, 0 otherwise.
    pub GetDeviceAsyncPort: Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    /// Opens the IOUSBDevice for exclusive access.
    ///
    /// Before the client can issue commands that change the state of the device, it
    /// must have succeeded in opening the device. This establishes an exclusive link
    /// between the client's task and the actual device.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Returns: Returns kIOReturnExclusiveAccess if some other task has the device opened already,
    /// kIOReturnError if the connection with the kernel cannot be established or kIOReturnSuccess if successful.
    pub USBDeviceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    /// Closes the task's connection to the IOUSBDevice.
    ///
    /// Releases the client's exclusive access to the IOUSBDevice.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, some other mach error if the connection is no longer valid.
    pub USBDeviceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    /// Returns the USB Class (bDeviceClass) of the device.
    ///
    /// The device does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `devClass`: Pointer to UInt8 to hold the device Class.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetDeviceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Returns the USB Subclass (bDeviceSubClass) of the device.
    ///
    /// The device does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `devSubClass`: Pointer to UInt8 to hold the device Subclass.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetDeviceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Returns the USB Protocol (bDeviceProtocol) of the interface.
    ///
    /// The device does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `devProtocol`: Pointer to UInt8 to hold the device Protocol.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetDeviceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Returns the USB Vendor ID (idVendor) of the device.
    ///
    /// The device does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `devVendor`: Pointer to UInt16 to hold the vendorID.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    /// Returns the USB Product ID (idProduct) of the device.
    ///
    /// The device does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `devProduct`: Pointer to UInt16 to hold the ProductID.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    /// Returns the Device Release Number (bcdDevice) of the device.
    ///
    /// The device does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `devRelNum`: Pointer to UInt16 to hold the Device Release Number.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    /// Returns the address of the device on its bus.
    ///
    /// The device does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `addr`: Pointer to USBDeviceAddress to hold the result.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetDeviceAddress:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut USBDeviceAddress) -> IOReturn>,
    /// Returns the power available to the device.
    ///
    /// The device does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `powerAvailable`: Pointer to UInt32 to hold the power available (in 2 mA increments).
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetDeviceBusPowerAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    /// Returns the speed of the device.
    ///
    /// The device does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `devSpeed`: Pointer to UInt8 to hold the speed (kUSBDeviceSpeedLow, kUSBDeviceSpeedFull, kUSBDeviceSpeedHigh, or kUSBDeviceSpeedSuper).
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetDeviceSpeed: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Returns the number of supported configurations in this device.
    ///
    /// The device does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `numConfig`: Pointer to UInt8 to hold the number of configurations.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetNumberOfConfigurations:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Returns the location ID.
    ///
    /// The location ID is a 32 bit number which is unique among all USB devices in the system, and
    /// which will not change on a system reboot unless the topology of the bus itself changes. The
    /// device does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `locationID`: Pointer to UInt32 to hold the location ID.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    /// Returns a pointer to a configuration descriptor for a given index.
    ///
    /// Note that this will point to the data as received from the USB bus and hence will be in USB bus
    /// order (i.e. little endian).  The device does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `configIndex`: The index (zero based) of the desired config descriptor.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetConfigurationDescriptorPtr: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBConfigurationDescriptorPtr,
        ) -> IOReturn,
    >,
    /// Returns the currently selected configuration in the device.
    ///
    /// The device does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `configNum`: Pointer to UInt8 to hold the configuration value.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Sets the configuration in the device.
    ///
    /// Note that setting the configuration causes any existing IOUSBInterface objects attached to the
    /// IOUSBDevice to be destroyed, and all of the interfaces in the new configuration to be instantiated
    /// as new IOUSBInterface objects.  The device must be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `configNum`: The value of the desired configuration (from IOUSBConfigurationDescriptor.bConfigurationValue).
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the device is not open for exclusive access.
    pub SetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    /// Gets the current frame number of the bus to which the device is attached.
    ///
    /// The device does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `frame`: Pointer to UInt64 to hold the frame number.
    ///
    /// Parameter `atTime`: Pointer to a returned AbsoluteTime, which is the system time ("wall time") when the frame number register was read. This
    /// system time could be the time at the beginning, middle, or end of the given frame.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    /// Tells the IOUSBFamily to issue a reset to the device.
    ///
    /// It will not reenumerate the device, which means that the cached device descriptor values will not
    /// be updated after the reset. (If you want the IOUSBFamily to reload the cached values, use the call
    /// USBDeviceReEnumerate). Prior to version 1.8.5 of the IOUSBFamily, this call also sent a message to
    /// all clients of the IOUSBDevice (IOUSBInterfaces and their drivers).  The device must be open to use
    /// this function.
    ///
    /// This behavior was eliminated in version 1.8.5 of the IOUSBFamily.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the device is not open for exclusive access.
    pub ResetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    /// Sends a USB request on the default control pipe.
    ///
    /// The device does not have to be open to use this function, but standard requests that change the state of the device
    /// may require that the device is opened first.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `req`: Pointer to an IOUSBDevRequest containing the request.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// kIOReturnAborted if the thread is interrupted before the call completes,
    /// or kIOReturnNotOpen if the device is not open for exclusive access.
    pub DeviceRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequest) -> IOReturn>,
    /// Sends an asynchronous USB request on the default control pipe.
    ///
    /// The device does not have to be open to use this function, but standard requests that change the state of the device
    /// may require that the device is opened first.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `req`: Pointer to an IOUSBDevRequest containing the request.
    ///
    /// Parameter `callback`: An IOAsyncCallback1 method. Upon completion, the arg0 argument of the AsyncCallback1 will contain the number of bytes that were actually transferred.  A message addressed to this callback is posted to the Async port upon completion.
    ///
    /// Parameter `refCon`: Arbitrary pointer which is passed as a parameter to the callback routine.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// kIOReturnNotOpen if the device is not open for exclusive access, or kIOUSBNoAsyncPortErr if no Async
    /// port has been created for this interface.
    pub DeviceRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    /// Creates an iterator to iterate over some or all of the interfaces of a device.
    ///
    /// The device does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `req`: Pointer an IOUSBFindInterfaceRequest structure describing the desired interfaces.
    ///
    /// Parameter `iter`: Pointer to a an io_iterator_t to contain the new iterator.
    ///
    /// Returns: Returns kIOReturnSuccess if successful or kIOReturnNoDevice if there is no connection to an IOService.
    pub CreateInterfaceIterator: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBFindInterfaceRequest,
            *mut io_iterator_t,
        ) -> IOReturn,
    >,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBDeviceStruct100 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBDeviceStruct100", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut USBDeviceAddress,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBConfigurationDescriptorPtr,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBFindInterfaceRequest,*mut io_iterator_t,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBDeviceStruct100 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access USB devices from user space, returned by all versions of the IOUSBFamily
/// currently shipping.
///
/// The functions listed here will work with any version of the IOUSBDeviceInterface, including
/// the one shipped with Mac OS X version 10.0.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdeviceinterface100?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBDeviceInterface100 = IOUSBDeviceStruct100;

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version
/// 1.8.2 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBDeviceInterface and
/// some new functions that are available on Mac OS X version 10.0.4 and later.
/// Super: IOUSBDeviceInterface
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicestruct182?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceStruct182 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateDeviceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetDeviceAsyncPort: Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBDeviceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBDeviceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetDeviceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceAddress:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut USBDeviceAddress) -> IOReturn>,
    pub GetDeviceBusPowerAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDeviceSpeed: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumberOfConfigurations:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetConfigurationDescriptorPtr: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBConfigurationDescriptorPtr,
        ) -> IOReturn,
    >,
    pub GetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub SetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ResetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequest) -> IOReturn>,
    pub DeviceRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub CreateInterfaceIterator: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBFindInterfaceRequest,
            *mut io_iterator_t,
        ) -> IOReturn,
    >,
    /// Opens the IOUSBDevice for exclusive access.
    ///
    /// This function opens the IOUSBDevice for exclusive access. If another client
    /// has the device opened, an attempt is made to get that client to close it before
    /// returning.  Before the client can issue commands that change the state of the device,
    /// it must have succeeded in opening the device. This establishes an exclusive
    /// link between the client's task and the actual device.
    /// Availability: This function is only available with IOUSBDeviceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Returns: Returns kIOReturnExclusiveAccess if some other task has the device opened already and refuses
    /// to close it, kIOReturnError if the connection with the kernel can not be established or kIOReturnSuccess if successful.
    pub USBDeviceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    /// Sends a USB request on the default control pipe.
    ///
    /// The device does not have to be open to use this function, but standard requests that change the state of the device may require that the device is opened first. This function sends a USB request on the default control pipe. The IOUSBDevRequestTO structure allows the client to specify timeout values for this request.
    ///
    /// Availability: This function is only available with IOUSBDeviceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `req`: Pointer to an IOUSBDevRequestTO containing the request.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// kIOReturnAborted if the thread is interrupted before the call completes,
    /// or kIOReturnNotOpen if the device is not open for exclusive access.
    pub DeviceRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequestTO) -> IOReturn>,
    /// Sends an asynchronous USB request on the default control pipe.
    ///
    /// The device does not have to be open to use this function, but standard requests that change the state of the device may require that the device is opened first. This function sends an asynchronous USB request on the default control pipe.  The IOUSBDevRequestTO structure allows the client to specify timeout values for this request.
    /// Availability: This function is only available with IOUSBDeviceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `req`: Pointer to an IOUSBDevRequestTO containing the request.
    ///
    /// Parameter `callback`: An IOAsyncCallback1 method. Upon completion, the arg0 argument of the AsyncCallback1 will contain the number of bytes that were actually transferred
    /// in the DeviceRequest. A message addressed to this callback is posted to the
    /// Async port upon completion.
    ///
    /// Parameter `refCon`: Arbitrary pointer which is passed as a parameter to the callback routine.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// kIOReturnNotOpen if the device is not open for exclusive access, orkIOUSBNoAsyncPortErr if no Async
    /// port has been created for this interface.
    pub DeviceRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    /// Tells the USB Family to either suspend or resume the port to which a device is attached.
    ///
    /// The device must be open to use this function.
    /// Availability: This function is only available with IOUSBDeviceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `suspend`: TRUE to cause the port to be suspended, FALSE to cause it to be resumed.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the device is not open for exclusive access.
    pub USBDeviceSuspend: Option<unsafe extern "C-unwind" fn(*mut c_void, Boolean) -> IOReturn>,
    /// Aborts a transaction on the default control pipe.
    ///
    /// The device does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBDeviceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the device is not open for exclusive access.
    pub USBDeviceAbortPipeZero: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    /// Returns the manufacturer string index in the device descriptor.
    ///
    /// The device does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBDeviceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `msi`: Pointer to UInt8 to hold the string index.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub USBGetManufacturerStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Returns the product string index in the device descriptor.
    ///
    /// The device does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBDeviceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `psi`: Pointer to UInt8 to hold the string index.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub USBGetProductStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Returns the serial number string index in the device descriptor.
    ///
    /// The device does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBDeviceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `snsi`: Pointer to UInt8 to hold the string index.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub USBGetSerialNumberStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBDeviceStruct182 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBDeviceStruct182", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut USBDeviceAddress,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBConfigurationDescriptorPtr,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBFindInterfaceRequest,*mut io_iterator_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,Boolean,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBDeviceStruct182 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version
/// 1.8.2 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBDeviceInterface and
/// some new functions that are available on Mac OS X version 10.0.4 and later.
/// Super: IOUSBDeviceInterface
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdeviceinterface182?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBDeviceInterface182 = IOUSBDeviceStruct182;

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version
/// 10.8.7 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBDeviceInterface,
/// IOUSBDeviceInterface182, and some new functions that are available on Mac OS X version 10.1.2 and later.
/// Super: IOUSBDeviceInterface182
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicestruct187?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceStruct187 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateDeviceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetDeviceAsyncPort: Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBDeviceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBDeviceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetDeviceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceAddress:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut USBDeviceAddress) -> IOReturn>,
    pub GetDeviceBusPowerAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDeviceSpeed: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumberOfConfigurations:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetConfigurationDescriptorPtr: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBConfigurationDescriptorPtr,
        ) -> IOReturn,
    >,
    pub GetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub SetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ResetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequest) -> IOReturn>,
    pub DeviceRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub CreateInterfaceIterator: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBFindInterfaceRequest,
            *mut io_iterator_t,
        ) -> IOReturn,
    >,
    pub USBDeviceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub DeviceRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBDeviceSuspend: Option<unsafe extern "C-unwind" fn(*mut c_void, Boolean) -> IOReturn>,
    pub USBDeviceAbortPipeZero: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBGetManufacturerStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetProductStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetSerialNumberStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Tells the IOUSBFamily to reenumerate the device.
    ///
    /// This function will send a terminate message to all clients of the IOUSBDevice (such as
    /// IOUSBInterfaces and their drivers, as well as the current User Client), emulating an unplug
    /// of the device. The IOUSBFamily will then enumerate the device as if it had just
    /// been plugged in. This call should be used by clients wishing to take advantage
    /// of the Device Firmware Update Class specification.  The device must be open to use this function, except when you are passing the kUSBReEnumerateCaptureDeviceBit or
    /// kUSBReEnumerateReleaseDeviceBit options.  In those cases you either need to (1) have the "com.apple.vm.device-access" entitlement set and the IOUSBDevice needs to have successfully been authorized by
    /// the IOKit's IOServiceAuthorize() APIs or (2) run with root privileges.
    /// Availability: This function is only available with IOUSBDeviceInterface187 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `options`: A UInt32 with a bit mask of options.  See USB.h and the USBReEnumerateOptions enum.  If the kUSBReEnumerateCaptureDeviceBit is used
    /// the client needs to either (1) have the "com.apple.vm.device-access" entitlement set and the IOUSBDevice needs to have successfully been authorized by
    /// the IOKit's IOServiceAuthorize() APIs or (2) run with root privileges.  Using that bit will terminate any kernel drivers for all non-mass storage interfaces
    /// attached to the device, as well as for any kernel driver that is attached to the device.  Specifying the kUSBReEnumerateReleaseDeviceBit will cause the IOUSBDevice to
    /// be returned to the OS and the driver for that device to be reloaded.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the device is not open for exclusive access.
    pub USBDeviceReEnumerate: Option<unsafe extern "C-unwind" fn(*mut c_void, u32) -> IOReturn>,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBDeviceStruct187 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBDeviceStruct187", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut USBDeviceAddress,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBConfigurationDescriptorPtr,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBFindInterfaceRequest,*mut io_iterator_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,Boolean,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBDeviceStruct187 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version
/// 10.8.7 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBDeviceInterface,
/// IOUSBDeviceInterface182, and some new functions that are available on Mac OS X version 10.1.2 and later.
/// Super: IOUSBDeviceInterface182
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdeviceinterface187?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBDeviceInterface187 = IOUSBDeviceStruct187;

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version
/// 1.9.7 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBDeviceInterface,
/// IOUSBDeviceInterface182, IOUSBDeviceInterface187, and some new functions that are available
/// on Mac OS X version 10.2.3 and later.
/// Super: IOUSBDeviceInterface187
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicestruct197?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceStruct197 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateDeviceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetDeviceAsyncPort: Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBDeviceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBDeviceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetDeviceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceAddress:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut USBDeviceAddress) -> IOReturn>,
    pub GetDeviceBusPowerAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDeviceSpeed: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumberOfConfigurations:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetConfigurationDescriptorPtr: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBConfigurationDescriptorPtr,
        ) -> IOReturn,
    >,
    pub GetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub SetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ResetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequest) -> IOReturn>,
    pub DeviceRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub CreateInterfaceIterator: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBFindInterfaceRequest,
            *mut io_iterator_t,
        ) -> IOReturn,
    >,
    pub USBDeviceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub DeviceRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBDeviceSuspend: Option<unsafe extern "C-unwind" fn(*mut c_void, Boolean) -> IOReturn>,
    pub USBDeviceAbortPipeZero: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBGetManufacturerStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetProductStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetSerialNumberStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBDeviceReEnumerate: Option<unsafe extern "C-unwind" fn(*mut c_void, u32) -> IOReturn>,
    /// Gets the current micro frame number of the bus to which the device is attached.
    ///
    /// The device does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBDeviceInterface197 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `microFrame`: Pointer to UInt64 to hold the microframe number.
    ///
    /// Parameter `atTime`: Pointer to an AbsoluteTime, which should be within 1ms of the time when the bus
    /// frame number was acquired.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    /// Returns the version of the IOUSBLib and the version of the IOUSBFamily.
    ///
    /// The device does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBDeviceInterface197 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `ioUSBLibVersion`: Pointer to a NumVersion structure that on return will contain the version of
    /// the IOUSBLib.
    ///
    /// Parameter `usbFamilyVersion`: Pointer to a NumVersion structure that on return will contain the version of
    /// the IOUSBFamily.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBDeviceStruct197 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBDeviceStruct197", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut USBDeviceAddress,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBConfigurationDescriptorPtr,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBFindInterfaceRequest,*mut io_iterator_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,Boolean,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBDeviceStruct197 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version
/// 1.9.7 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBDeviceInterface,
/// IOUSBDeviceInterface182, IOUSBDeviceInterface187, and some new functions that are available
/// on Mac OS X version 10.2.3 and later.
/// Super: IOUSBDeviceInterface187
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdeviceinterface197?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBDeviceInterface197 = IOUSBDeviceStruct197;

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version
/// 2.4.5 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBDeviceInterface,
/// IOUSBDeviceInterface182, IOUSBDeviceInterface187, IOUSBDeviceInterface197, and some new functions that are available
/// on Mac OS X version 10.2.3 and later.
/// Super: IOUSBDeviceInterface197
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicestruct245?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceStruct245 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateDeviceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetDeviceAsyncPort: Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBDeviceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBDeviceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetDeviceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceAddress:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut USBDeviceAddress) -> IOReturn>,
    pub GetDeviceBusPowerAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDeviceSpeed: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumberOfConfigurations:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetConfigurationDescriptorPtr: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBConfigurationDescriptorPtr,
        ) -> IOReturn,
    >,
    pub GetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub SetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ResetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequest) -> IOReturn>,
    pub DeviceRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub CreateInterfaceIterator: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBFindInterfaceRequest,
            *mut io_iterator_t,
        ) -> IOReturn,
    >,
    pub USBDeviceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub DeviceRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBDeviceSuspend: Option<unsafe extern "C-unwind" fn(*mut c_void, Boolean) -> IOReturn>,
    pub USBDeviceAbortPipeZero: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBGetManufacturerStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetProductStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetSerialNumberStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBDeviceReEnumerate: Option<unsafe extern "C-unwind" fn(*mut c_void, u32) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBDeviceStruct245 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBDeviceStruct245", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut USBDeviceAddress,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBConfigurationDescriptorPtr,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBFindInterfaceRequest,*mut io_iterator_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,Boolean,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBDeviceStruct245 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version
/// 2.4.5 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBDeviceInterface,
/// IOUSBDeviceInterface182, IOUSBDeviceInterface187, IOUSBDeviceInterface197, and some new functions that are available
/// on Mac OS X version 10.2.3 and later.
/// Super: IOUSBDeviceInterface197
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdeviceinterface245?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBDeviceInterface245 = IOUSBDeviceStruct245;

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version 3.0.0 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBDeviceInterface,
/// IOUSBDeviceInterface182, IOUSBDeviceInterface187, IOUSBDeviceInterface197, IOUSBDeviceInterface245,
/// and some new functions that are available on Mac OS X version 10.5 and later.
/// Super: IOUSBDeviceInterface245
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicestruct300?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceStruct300 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateDeviceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetDeviceAsyncPort: Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBDeviceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBDeviceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetDeviceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceAddress:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut USBDeviceAddress) -> IOReturn>,
    pub GetDeviceBusPowerAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDeviceSpeed: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumberOfConfigurations:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetConfigurationDescriptorPtr: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBConfigurationDescriptorPtr,
        ) -> IOReturn,
    >,
    pub GetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub SetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ResetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequest) -> IOReturn>,
    pub DeviceRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub CreateInterfaceIterator: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBFindInterfaceRequest,
            *mut io_iterator_t,
        ) -> IOReturn,
    >,
    pub USBDeviceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub DeviceRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBDeviceSuspend: Option<unsafe extern "C-unwind" fn(*mut c_void, Boolean) -> IOReturn>,
    pub USBDeviceAbortPipeZero: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBGetManufacturerStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetProductStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetSerialNumberStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBDeviceReEnumerate: Option<unsafe extern "C-unwind" fn(*mut c_void, u32) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    /// Gets a recent frame number of the bus to which the device is attached, along with a system time corresponding to the start of that frame
    ///
    /// The device does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBDeviceInterface300 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `frame`: Pointer to UInt64 to hold the frame number.
    ///
    /// Parameter `atTime`: Pointer to a returned AbsoluteTime, which is the system time ("wall time") as close as possible to the beginning of that USB frame. The jitter on this value may be as much as 200 microseconds.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, or kIOReturnUnsupported is the bus doesn't support this function.
    pub GetBusFrameNumberWithTime:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBDeviceStruct300 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBDeviceStruct300", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut USBDeviceAddress,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBConfigurationDescriptorPtr,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBFindInterfaceRequest,*mut io_iterator_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,Boolean,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBDeviceStruct300 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version 3.0.0 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBDeviceInterface,
/// IOUSBDeviceInterface182, IOUSBDeviceInterface187, IOUSBDeviceInterface197, IOUSBDeviceInterface245,
/// and some new functions that are available on Mac OS X version 10.5 and later.
/// Super: IOUSBDeviceInterface245
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdeviceinterface300?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBDeviceInterface300 = IOUSBDeviceStruct300;

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version 3.2.0 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBDeviceInterface,
/// IOUSBDeviceInterface182, IOUSBDeviceInterface187, IOUSBDeviceInterface197, IOUSBDeviceInterface245, or IOUSBDeviceInterface300
/// and some new functions that are available on Mac OS X version 10.5.4 and later.
/// Super: IOUSBDeviceInterface300
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicestruct320?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceStruct320 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateDeviceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetDeviceAsyncPort: Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBDeviceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBDeviceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetDeviceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceAddress:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut USBDeviceAddress) -> IOReturn>,
    pub GetDeviceBusPowerAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDeviceSpeed: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumberOfConfigurations:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetConfigurationDescriptorPtr: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBConfigurationDescriptorPtr,
        ) -> IOReturn,
    >,
    pub GetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub SetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ResetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequest) -> IOReturn>,
    pub DeviceRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub CreateInterfaceIterator: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBFindInterfaceRequest,
            *mut io_iterator_t,
        ) -> IOReturn,
    >,
    pub USBDeviceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub DeviceRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBDeviceSuspend: Option<unsafe extern "C-unwind" fn(*mut c_void, Boolean) -> IOReturn>,
    pub USBDeviceAbortPipeZero: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBGetManufacturerStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetProductStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetSerialNumberStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBDeviceReEnumerate: Option<unsafe extern "C-unwind" fn(*mut c_void, u32) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    pub GetBusFrameNumberWithTime:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    /// Returns status information about the USB device, such as whether the device is captive or whether it is in the suspended state.
    ///
    /// The device does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBDeviceInterface320 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `info`: Pointer to a buffer that returns a bit field of information on the device (see the USBDeviceInformationBits in USB.h).
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, or kIOReturnUnsupported is the bus doesn't support this function.
    pub GetUSBDeviceInformation:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    /// Clients can use this API to reserve extra power for use by this device while the machine is asleep or while it is awake.  Units are milliAmps (mA).
    ///
    /// The device has to be open to use this function.
    /// Availability: This function is only available with IOUSBDeviceInterface320 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `type`: Indicates whether the power is to be used during wake or sleep (One of kUSBPowerDuringSleep or kUSBPowerDuringWake)
    ///
    /// Parameter `requestedPower`: Amount of power desired, in mA
    ///
    /// Parameter `powerAvailable`: Amount of power that was reserved, in mA
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, or kIOReturnUnsupported is the bus doesn't support this function.
    pub RequestExtraPower:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u32, u32, *mut u32) -> IOReturn>,
    /// Clients can use this API to tell the system that they will not use power that was previously reserved by using the RequestExtraPower API.
    ///
    /// The device has to be open to use this function.
    /// Availability: This function is only available with IOUSBDeviceInterface320 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `type`: Indicates whether the power is to be used during wake or sleep (One of kUSBPowerDuringSleep or kUSBPowerDuringWake)
    ///
    /// Parameter `powerReturned`: Amount of power to be returned, in mA.
    ///
    /// Returns: If the returnedPower was not previously allocated, an error will be returned.  This will include the case for power that was requested for sleep but was returned for wake. Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub ReturnExtraPower: Option<unsafe extern "C-unwind" fn(*mut c_void, u32, u32) -> IOReturn>,
    /// Clients can use this API to ask how much extra power has already been reserved by this device.  Units are milliAmps (mA).
    ///
    /// The device has to be open to use this function.
    /// Availability: This function is only available with IOUSBDeviceInterface320 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `type`: Indicates whether the allocated power was to be used during wake or sleep (One of kUSBPowerDuringSleep or kUSBPowerDuringWake)
    ///
    /// Parameter `powerAllocated`: Amount of power to be returned, in mA.
    ///
    /// Returns: Value returned can be 0 if no power has been allocated. Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetExtraPowerAllocated:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u32, *mut u32) -> IOReturn>,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBDeviceStruct320 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBDeviceStruct320", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut USBDeviceAddress,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBConfigurationDescriptorPtr,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBFindInterfaceRequest,*mut io_iterator_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,Boolean,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,u32,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,*mut u32,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBDeviceStruct320 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version 3.2.0 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBDeviceInterface,
/// IOUSBDeviceInterface182, IOUSBDeviceInterface187, IOUSBDeviceInterface197, IOUSBDeviceInterface245, or IOUSBDeviceInterface300
/// and some new functions that are available on Mac OS X version 10.5.4 and later.
/// Super: IOUSBDeviceInterface300
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdeviceinterface320?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBDeviceInterface320 = IOUSBDeviceStruct320;

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version 4.0.0 and above.
///
/// This object is functionally identical to IOUSBDeviceInterface320 on macOS, and includes some new functions that are only available on iOS.
/// Super: IOUSBDeviceInterface320
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicestruct400?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceStruct400 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateDeviceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetDeviceAsyncPort: Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBDeviceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBDeviceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetDeviceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceAddress:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut USBDeviceAddress) -> IOReturn>,
    pub GetDeviceBusPowerAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDeviceSpeed: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumberOfConfigurations:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetConfigurationDescriptorPtr: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBConfigurationDescriptorPtr,
        ) -> IOReturn,
    >,
    pub GetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub SetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ResetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequest) -> IOReturn>,
    pub DeviceRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub CreateInterfaceIterator: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBFindInterfaceRequest,
            *mut io_iterator_t,
        ) -> IOReturn,
    >,
    pub USBDeviceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub DeviceRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBDeviceSuspend: Option<unsafe extern "C-unwind" fn(*mut c_void, Boolean) -> IOReturn>,
    pub USBDeviceAbortPipeZero: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBGetManufacturerStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetProductStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetSerialNumberStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBDeviceReEnumerate: Option<unsafe extern "C-unwind" fn(*mut c_void, u32) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    pub GetBusFrameNumberWithTime:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetUSBDeviceInformation:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub RequestExtraPower:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u32, u32, *mut u32) -> IOReturn>,
    pub ReturnExtraPower: Option<unsafe extern "C-unwind" fn(*mut c_void, u32, u32) -> IOReturn>,
    pub GetExtraPowerAllocated:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u32, *mut u32) -> IOReturn>,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBDeviceStruct400 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBDeviceStruct400", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut USBDeviceAddress,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBConfigurationDescriptorPtr,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBFindInterfaceRequest,*mut io_iterator_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,Boolean,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,u32,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,*mut u32,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBDeviceStruct400 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version 4.0.0 and above.
///
/// This object is functionally identical to IOUSBDeviceInterface320 on macOS, and includes some new functions that are only available on iOS.
/// Super: IOUSBDeviceInterface320
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdeviceinterface400?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBDeviceInterface400 = IOUSBDeviceStruct400;

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version 5.0.0 and above.
///
/// The functions listed here include all of the functions defined for IOUSBDeviceInterface400, and some new functions that are available on Mac OS X version 10.7.3 and later.
/// Super: IOUSBDeviceInterface400
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicestruct500?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceStruct500 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateDeviceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetDeviceAsyncPort: Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBDeviceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBDeviceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetDeviceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceAddress:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut USBDeviceAddress) -> IOReturn>,
    pub GetDeviceBusPowerAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDeviceSpeed: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumberOfConfigurations:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetConfigurationDescriptorPtr: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBConfigurationDescriptorPtr,
        ) -> IOReturn,
    >,
    pub GetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub SetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ResetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequest) -> IOReturn>,
    pub DeviceRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub CreateInterfaceIterator: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBFindInterfaceRequest,
            *mut io_iterator_t,
        ) -> IOReturn,
    >,
    pub USBDeviceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub DeviceRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBDeviceSuspend: Option<unsafe extern "C-unwind" fn(*mut c_void, Boolean) -> IOReturn>,
    pub USBDeviceAbortPipeZero: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBGetManufacturerStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetProductStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetSerialNumberStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBDeviceReEnumerate: Option<unsafe extern "C-unwind" fn(*mut c_void, u32) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    pub GetBusFrameNumberWithTime:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetUSBDeviceInformation:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub RequestExtraPower:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u32, u32, *mut u32) -> IOReturn>,
    pub ReturnExtraPower: Option<unsafe extern "C-unwind" fn(*mut c_void, u32, u32) -> IOReturn>,
    pub GetExtraPowerAllocated:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u32, *mut u32) -> IOReturn>,
    /// Returns the amount of bandwidth available on the bus for allocation to
    /// periodic pipes.  If the device is a high or super speed device, it will be the number of bytes per microframe (125 �secs). If it is a full
    /// speed device, it will be the number of bytes per frame (1ms)
    ///
    /// This function is useful for determining the correct AltInterface setting as well as for using
    /// SetPipePolicy. The interface does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBDeviceInterface500 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `bandwidth`: Pointer to UInt32 to hold the amount of bandwidth available (in bytes per frame or microframe).
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetBandwidthAvailableForDevice:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBDeviceStruct500 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBDeviceStruct500", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut USBDeviceAddress,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBConfigurationDescriptorPtr,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBFindInterfaceRequest,*mut io_iterator_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,Boolean,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,u32,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBDeviceStruct500 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version 5.0.0 and above.
///
/// The functions listed here include all of the functions defined for IOUSBDeviceInterface400, and some new functions that are available on Mac OS X version 10.7.3 and later.
/// Super: IOUSBDeviceInterface400
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdeviceinterface500?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBDeviceInterface500 = IOUSBDeviceStruct500;

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version 650.4.0 and above.
///
/// The functions listed here include all of the functions defined for IOUSBDeviceInterface500, and some new functions that are available on Mac OS X version 10.9 and later.
/// Super: IOUSBDeviceInterface500
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicestruct650?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceStruct650 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateDeviceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetDeviceAsyncPort: Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBDeviceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBDeviceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetDeviceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceAddress:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut USBDeviceAddress) -> IOReturn>,
    pub GetDeviceBusPowerAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDeviceSpeed: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumberOfConfigurations:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetConfigurationDescriptorPtr: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBConfigurationDescriptorPtr,
        ) -> IOReturn,
    >,
    pub GetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub SetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ResetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequest) -> IOReturn>,
    pub DeviceRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub CreateInterfaceIterator: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBFindInterfaceRequest,
            *mut io_iterator_t,
        ) -> IOReturn,
    >,
    pub USBDeviceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub DeviceRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBDeviceSuspend: Option<unsafe extern "C-unwind" fn(*mut c_void, Boolean) -> IOReturn>,
    pub USBDeviceAbortPipeZero: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBGetManufacturerStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetProductStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetSerialNumberStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBDeviceReEnumerate: Option<unsafe extern "C-unwind" fn(*mut c_void, u32) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    pub GetBusFrameNumberWithTime:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetUSBDeviceInformation:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub RequestExtraPower:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u32, u32, *mut u32) -> IOReturn>,
    pub ReturnExtraPower: Option<unsafe extern "C-unwind" fn(*mut c_void, u32, u32) -> IOReturn>,
    pub GetExtraPowerAllocated:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u32, *mut u32) -> IOReturn>,
    pub GetBandwidthAvailableForDevice:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    /// Sets the configuration in the device.
    ///
    /// Note that setting the configuration causes any existing IOUSBInterface objects attached to the
    /// IOUSBDevice to be destroyed, and all of the interfaces in the new configuration to be instantiated
    /// as new IOUSBInterface objects.  The device must be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `configNum`: The value of the desired configuration (from IOUSBConfigurationDescriptor.bConfigurationValue)
    ///
    /// Parameter `startInterfaceMatching`: true if IOUSBFamily should call IOKit to match the IOUSBInterface nubs.  If false is set, the client
    /// needs to either (1) have the "com.apple.vm.device-access" entitlement and have the IOUSBDevice authorized
    /// via the IOKit's IOServiceAuthorize() API or (1) have root privileges.
    ///
    /// Parameter `issueRemoteWakeup`: true if IOUSBFamily should send the command to enable remote wakeup in the device
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the device is not open for exclusive access.
    pub SetConfigurationV2:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, bool, bool) -> IOReturn>,
    /// Registers a callback routine to be invoked when certain events occur in the kernel.
    ///
    /// The callback function will be called, for example when the underlying IOUSBDevice is
    /// going to be suspended due to some kind of kernel activity. It will also be called when
    /// the underlying IOUSBDevice is resumed.
    /// Availability: This function is only available with IOUSBDeviceInterface650 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `notificationMask`: Specifies the desired type of notification
    ///
    /// Parameter `callback`: An IOAsyncCallback2 method. Upon completion, the arg0 argument of the AsyncCallback2 will contain the
    /// notification type, and arg1 will contain a notificationToken which should be used when calling AcknowledgeNotification
    ///
    /// Parameter `refCon`: Arbitrary pointer which is passed as a parameter to the callback routine.
    ///
    /// Parameter `pRegistrationToken`: A pointer to a UInt64 which will contain a registration token if the function is
    /// successful. This registration token can then later be used to call UnregisterNotification.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub RegisterForNotification: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u64,
            IOAsyncCallback2,
            *mut c_void,
            *mut u64,
        ) -> IOReturn,
    >,
    /// Unregisters a previously registered callback routine
    ///
    /// The callback routine will no longer be invoked when events occur
    /// Availability: This function is only available with IOUSBDeviceInterface650 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `registrationToken`: The registration token which was obtained in the call to RegisterForNotification
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub UnregisterNotification: Option<unsafe extern "C-unwind" fn(*mut c_void, u64) -> IOReturn>,
    /// Acknowledges a notification event
    ///
    /// Some events in the kernel will wait for an acknowledgement from all interested parties before proceeding.
    /// For example, if an IOUSBDevice is about to be suspended, any User Code which has registered to receive
    /// that event will be notified and should acknowledge the notification when it is ready for the IOUSBDevice
    /// to be suspended.
    /// Availability: This function is only available with IOUSBDeviceInterface650 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Parameter `notificationToken`: The notification token which was passed in to the callback routine
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub AcknowledgeNotification: Option<unsafe extern "C-unwind" fn(*mut c_void, u64) -> IOReturn>,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBDeviceStruct650 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBDeviceStruct650", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut USBDeviceAddress,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBConfigurationDescriptorPtr,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBFindInterfaceRequest,*mut io_iterator_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,Boolean,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,u32,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        Encoding::Pointer(&Encoding::Unknown),
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,IOAsyncCallback2,*mut c_void,*mut u64,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBDeviceStruct650 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version 650.4.0 and above.
///
/// The functions listed here include all of the functions defined for IOUSBDeviceInterface500, and some new functions that are available on Mac OS X version 10.9 and later.
/// Super: IOUSBDeviceInterface500
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdeviceinterface650?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBDeviceInterface650 = IOUSBDeviceStruct650;

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version 900.4.2 and above.
///
/// The functions listed here include all of the functions defined for IOUSBDeviceInterface650, and some new functions that are available on macOS 10.14 and later.
/// Super: IOUSBDeviceInterface650
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicestruct942?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceStruct942 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetDeviceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateDeviceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetDeviceAsyncPort: Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBDeviceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBDeviceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetDeviceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceAddress:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut USBDeviceAddress) -> IOReturn>,
    pub GetDeviceBusPowerAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDeviceSpeed: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumberOfConfigurations:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetConfigurationDescriptorPtr: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBConfigurationDescriptorPtr,
        ) -> IOReturn,
    >,
    pub GetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub SetConfiguration: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ResetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequest) -> IOReturn>,
    pub DeviceRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub CreateInterfaceIterator: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBFindInterfaceRequest,
            *mut io_iterator_t,
        ) -> IOReturn,
    >,
    pub USBDeviceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub DeviceRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub DeviceRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBDeviceSuspend: Option<unsafe extern "C-unwind" fn(*mut c_void, Boolean) -> IOReturn>,
    pub USBDeviceAbortPipeZero: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBGetManufacturerStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetProductStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBGetSerialNumberStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBDeviceReEnumerate: Option<unsafe extern "C-unwind" fn(*mut c_void, u32) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    pub GetBusFrameNumberWithTime:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetUSBDeviceInformation:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub RequestExtraPower:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u32, u32, *mut u32) -> IOReturn>,
    pub ReturnExtraPower: Option<unsafe extern "C-unwind" fn(*mut c_void, u32, u32) -> IOReturn>,
    pub GetExtraPowerAllocated:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u32, *mut u32) -> IOReturn>,
    pub GetBandwidthAvailableForDevice:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub SetConfigurationV2:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, bool, bool) -> IOReturn>,
    pub RegisterForNotification: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u64,
            IOAsyncCallback2,
            *mut c_void,
            *mut u64,
        ) -> IOReturn,
    >,
    pub UnregisterNotification: Option<unsafe extern "C-unwind" fn(*mut c_void, u64) -> IOReturn>,
    pub AcknowledgeNotification: Option<unsafe extern "C-unwind" fn(*mut c_void, u64) -> IOReturn>,
    /// Returns the IONotificationPort for this IOService instance.
    /// Availability: This function is only available with IOUSBDeviceInterface942 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBDeviceInterface.
    ///
    /// Returns: Returns the IONotificationPortRef if one exists, MACH_PORT_NULL otherwise.
    pub GetDeviceAsyncNotificationPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> IONotificationPortRef>,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBDeviceStruct942 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBDeviceStruct942", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut USBDeviceAddress,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBConfigurationDescriptorPtr,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBFindInterfaceRequest,*mut io_iterator_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,Boolean,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,u32,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        Encoding::Pointer(&Encoding::Unknown),
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,IOAsyncCallback2,*mut c_void,*mut u64,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IONotificationPortRef>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBDeviceStruct942 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access USB devices from user space, returned by the IOUSBFamily version 900.4.2 and above.
///
/// The functions listed here include all of the functions defined for IOUSBDeviceInterface650, and some new functions that are available on macOS 10.14 and later.
/// Super: IOUSBDeviceInterface650
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdeviceinterface942?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBDeviceInterface942 = IOUSBDeviceStruct942;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdeviceinterface?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBDeviceInterface = IOUSBDeviceInterface942;

/// The object you use to access a USB device interface from user space, returned by all versions
/// of the IOUSBFamily currently shipping.
///
/// The functions listed here will work with any version of the IOUSBInterfaceInterface, including
/// the one shipped with Mac OS X version 10.0.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct100?language=objc)
#[cfg(all(feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct100 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    /// Creates a run loop source for delivery of all asynchronous notifications on this device.
    ///
    /// The Mac OS X kernel does not spawn a thread to callback to the client. Instead
    /// it delivers completion notifications on a Mach port (see {
    ///
    /// ```text
    ///  CreateInterfaceAsyncPort}). This
    ///                 routine wraps that port with the appropriate routing code so that
    ///                 the completion notifications can be automatically routed through the client's
    ///                 CFRunLoop.
    ///        @param      self Pointer to the IOUSBInterfaceInterface.
    ///        @param      source Pointer to a CFRunLoopSourceRef to return the newly created run loop event source.
    ///        @result     Returns kIOReturnSuccess if successful or a kern_return_t if failed.
    ///      
    ///
    /// ```
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    /// Returns the CFRunLoopSourceRef for this IOService instance.
    ///
    /// (description)
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Returns: Returns the run loop source if one has been created, 0 otherwise.
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    /// Creates and registers a mach_port_t for asynchronous communications.
    ///
    /// The Mac OS X kernel does not spawn a thread to callback to the client. Instead
    /// it delivers completion notifications on this Mach port. After receiving a message
    /// on this port the client is obliged to call the IOKitLib.h: IODispatchCalloutFromMessage()
    /// function for decoding the notification message.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Returns: Returns kIOReturnSuccess if successful or a kern_return_t if failed.
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    /// Returns the mach_port_t port for this IOService instance.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Returns: Returns the port if one exists, 0 otherwise.
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    /// Opensthe IOUSBInterface for exclusive access.
    ///
    /// Before the client can transfer data to and from the interface, it must have
    /// succeeded in opening the interface. This establishes an exclusive link between
    /// the client's task and the actual interface device. Opening the interface causes
    /// pipes to be created on each endpoint contained in the interface. If the interface
    /// contains isochronous endpoints, an attempt is made to allocate bandwidth on
    /// the bus for each of those pipes. If there is not enough bandwidth available,
    /// an isochronous pipe may be created with a bandwidth of zero. The software must
    /// then call SetPipePolicy to change the size of that pipe before it can be used
    /// for I/O.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Returns: Returns kIOReturnExclusiveAccess if some other task has the device opened already,
    /// kIOReturnError if the connection with the kernel cannot be established or
    /// kIOReturnSuccess if successful.
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    /// Closes the task's connection to the IOUSBInterface.
    ///
    /// Releases the client's exclusive access to the IOUSBInterface.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    /// Returns the USB Class of the interface  (bInterfaceClass).
    ///
    /// The interface does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `intfClass`: Pointer to UInt8 to hold the interface Class.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Returns the USB Subclass of the interface (bInterfaceSubClass).
    ///
    /// The interface does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `intfSubClass`: Pointer to UInt8 to hold the interface Subclass.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Returns the USB Protocol of the interface (bInterfaceProtocol).
    ///
    /// The interface does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `intfProtocol`: Pointer to UInt8 to hold the interface Protocol.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Returns the USB Vendor ID (idVendor) of the device of which this interface is a part.
    ///
    /// The interface does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `devVendor`: Pointer to UInt16 to hold the vendorID.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    /// Returns the USB Product ID (idProduct) of the device of which this interface is a part.
    ///
    /// The interface does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `devProduct`: Pointer to UInt16 to hold the ProductID.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    /// Returns the Device Release Number (bcdDevice) of the device of which this interface is a part.
    ///
    /// The interface does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `devRelNum`: Pointer to UInt16 to hold the Release Number.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    /// Returns the current configuration value set in the device (the interface will be part of that configuration.)
    ///
    /// The interface does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `configVal`: Pointer to UInt8 to hold the configuration value.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Returns the interface number (zero-based index) of this interface within the current configuration of the device.
    ///
    /// The interface does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `intfNumber`: Pointer to UInt8 to hold the interface number.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Returns the alternate setting currently selected in this interface.
    ///
    /// The interface does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `intfAltSetting`: Pointer to UInt8 to hold the alternate setting value.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Returns the number of endpoints in this interface.
    ///
    /// The interface does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `intfNumEndpoints`: Pointer to UInt8 to hold the number of endpoints.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Returns the location ID.
    ///
    /// The location ID is a 32 bit number which is unique among all USB devices in the system, and which
    /// will not change on a system reboot unless the topology of the bus itself changes.  The interface
    /// does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `locationID`: Pointer to UInt32 to hold the location ID.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    /// Returns the device of which this interface is part.
    ///
    /// The interface does not have to be open to use this function. The returned device can be used to
    /// create a CFPlugin to talk to the device.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `device`: Pointer to io_service_t to hold the result.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    /// Changes the AltInterface setting.
    ///
    /// The interface must be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `alternateSetting`: The new alternate setting for the interface.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the interface is not open for exclusive access.
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    /// Gets the current frame number of the bus to which the interface and its device are attached.
    ///
    /// The interface does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `frame`: Pointer to UInt64 to hold the frame number.
    ///
    /// Parameter `atTime`: Pointer to an AbsoluteTime, which should be within 1ms of the time when the bus frame
    /// number was attained.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    /// Sends a USB request on a control pipe.
    ///
    /// If the request is a standard request which will change the state of the device, the device must
    /// be open, which means you should be using the IOUSBDeviceInterface for this command.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index of the control pipe to use. Use zero for the default control pipe on the device.
    ///
    /// Parameter `req`: Pointer to an IOUSBDevRequest containing the request.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// kIOReturnAborted if the thread is interrupted before the call completes,
    /// or kIOReturnNotOpen if the interface is not open for exclusive access.
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    /// Sends an asynchronous USB request on a control pipe.
    ///
    /// Use pipeRef=0 for the default device control pipe.  If the request is a standard request which will
    /// change the state of the device, the device must be open, which means you should be using the
    /// IOUSBDeviceInterface for this command.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index of the control pipe to use. Use zero for the default control pipe on the device.
    ///
    /// Parameter `req`: Pointer to an IOUSBDevRequest containing the request.
    ///
    /// Parameter `callback`: An IOAsyncCallback1 method. Upon completion, the arg0 argument of the AsyncCallback1 will contain the number of bytes that were actually transferred. A message addressed to this callback is posted to the Async port upon completion.
    ///
    /// Parameter `refCon`: Arbitrary pointer which is passed as a parameter to the callback routine.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// kIOReturnNotOpen if the interface is not open for exclusive access, or kIOUSBNoAsyncPortErr if no
    /// Async port has been created for this interface.
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    /// Gets the properties for a pipe.
    ///
    /// Once an interface is opened, all of the pipes in that interface get created by the kernel. The number
    /// of pipes can be retrieved by GetNumEndpoints. The client can then get the properties of any pipe
    /// using an index of 1 to GetNumEndpoints. Pipe 0 is the default control pipe in the device.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `direction`: Pointer to an UInt8 to get the direction of the pipe.
    ///
    /// Parameter `number`: Pointer to an UInt8 to get the pipe number.
    ///
    /// Parameter `transferType`: Pointer to an UInt8 to get the transfer type of the pipe.
    ///
    /// Parameter `maxPacketSize`: Pointer to an UInt16 to get the maxPacketSize of the pipe. This maxPacketSize is the FULL maxPacketSize, which takes into account the multipler for HS Isoc pipes
    /// and the burst and the multiplier for SS Isoc pipes. It could also have been adjusted by SetPipePolicy.
    ///
    /// Parameter `interval`: Pointer to an UInt8 to get the interval for polling the pipe for data (in milliseconds).
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the interface is not open for exclusive access.
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    /// Gets the current status of a pipe.
    ///
    /// The interface must be open for the pipe to exist.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Returns: Returns kIOReturnNoDevice if there is no connection to an IOService, or kIOReturnNotOpen
    /// if the interface is not open for exclusive access. Otherwise, the status of the pipe is returned.
    /// Returns kIOUSBPipeStalled if the pipe is stalled. See
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface/ClearPipeStall/ ClearPipeStall
    /// ```
    ///
    /// or
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface190/ClearPipeStallBothEnds/ ClearPipeStallBothEnds
    /// ```
    ///
    /// for
    /// more information.
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    /// Aborts any outstanding transactions on the pipe with status kIOReturnAborted.
    ///
    /// If there are outstanding asynchronous transactions on the pipe, the callbacks will happen.
    /// Note that this command will also clear the halted bit on the endpoint
    /// in the controller, but will NOT clear the data toggle bit.  If you want to clear the data toggle bit as well, see
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface/ClearPipeStall/ ClearPipeStall
    /// ```
    ///
    /// or
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface190/ClearPipeStallBothEnds/ ClearPipeStallBothEnds
    /// ```
    ///
    /// for more information.  The interface must be open for the pipe to exist.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the interface is not open for exclusive access.
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    /// Equivalent to ClearPipeStall.
    ///
    /// The interface must be open for the pipe to exist.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the interface is not open for exclusive access.
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    /// Clears the halted bit and the data toggle bit on the pipe's endpoint in the controller.
    ///
    /// This function also returns any outstanding transactions on the pipe with status kIOUSBTransactionReturned.
    /// If there are outstanding asynchronous transactions on the pipe, the callbacks will happen. The data
    /// toggle may need to be resynchronized. The driver may handle this by sending a ClearFeature(ENDPOINT_HALT)
    /// to the default control pipe, specifying the device's endpoint for this pipe. See also
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface190/ClearPipeStallBothEnds/ ClearPipeStallBothEnds
    /// ```
    ///
    /// .
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the interface is not open for exclusive access.
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    /// Reads data on a
    /// <b>
    /// BULK IN
    /// </b>
    /// or an
    /// <b>
    /// INTERRUPT
    /// </b>
    /// pipe.
    ///
    /// The interface must be open for the pipe to exist.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `buf`: Buffer to hold the data.
    ///
    /// Parameter `size`: On entry: a pointer to the size of the buffer pointed to by buf.
    /// On exit: a pointer to the number of bytes actually read from the device.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the interface is not open for exclusive access.
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    /// Writes data on a
    /// <b>
    /// BULK OUT
    /// </b>
    /// or
    /// <b>
    /// INTERRUPT OUT
    /// </b>
    /// pipe.
    ///
    /// The interface must be open for the pipe to exist.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `buf`: Buffer to hold the data.
    ///
    /// Parameter `size`: The size of the data buffer.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// kIOReturnAborted if the thread is interrupted before the call completes,
    /// or kIOReturnNotOpen if the interface is not open for exclusive access.
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    /// Performs an asynchronous read on a
    /// <b>
    /// BULK IN
    /// </b>
    /// or an
    /// <b>
    /// INTERRUPT
    /// </b>
    /// pipe.
    ///
    /// The interface must be open for the pipe to exist.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `buf`: Buffer to hold the data.
    ///
    /// Parameter `size`: The size of the buffer pointed to by buf.
    ///
    /// Parameter `callback`: An IOAsyncCallback1 method. Upon completion, the arg0 argument of the AsyncCallback1 will contain the number of bytes that were actually read. A message addressed to this callback is posted to the Async
    /// port upon completion.
    ///
    /// Parameter `refcon`: Arbitrary pointer which is passed as a parameter to the callback routine.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// kIOReturnAborted if the thread is interrupted before the call completes,
    /// or kIOReturnNotOpen if the interface is not open for exclusive access.
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    /// Performs an asynchronous write on a
    /// <b>
    /// BULK OUT
    /// </b>
    /// or
    /// <b>
    /// INTERRUPT OUT
    /// </b>
    /// pipe.
    ///
    /// The interface must be open for the pipe to exist.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `buf`: Buffer to hold the data.
    ///
    /// Parameter `size`: The size of the buffer pointed to by buf.
    ///
    /// Parameter `callback`: An IOAsyncCallback1 method. Upon completion, the arg0 argument of the AsyncCallback1 will contain the number of bytes that were actually written. A message addressed to this callback is posted to the Async
    /// port upon completion.
    ///
    /// Parameter `refcon`: Arbitrary pointer which is passed as a parameter to the callback routine.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the interface is not open for exclusive access.
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    /// Performs a read on an
    /// <b>
    /// ISOCHRONOUS
    /// </b>
    /// pipe.
    ///
    /// The interface must be open for the pipe to exist.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `buf`: Buffer to hold the data.
    ///
    /// Parameter `frameStart`: The bus frame number on which to start the read (obtained from GetBusFrameNumber).
    ///
    /// Parameter `numFrames`: The number of frames for which to transfer data.
    ///
    /// Parameter `frameList`: A pointer to an array of IOUSBIsocFrame structures describing the frames.
    ///
    /// Parameter `callback`: An IOAsyncCallback1 method. Upon completion, the arg0 argument of the AsyncCallback1 will contain the framelist pointer, which can be used to associate the completion with a particular request. A message addressed to this callback is posted to the Async
    /// port upon completion.
    ///
    /// Parameter `refcon`: Arbitrary pointer which is passed as a parameter to the callback routine.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the interface is not open for exclusive access.
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    /// Performs an asynchronous write on an
    /// <b>
    /// ISOCHRONOUS
    /// </b>
    /// pipe.
    ///
    /// The interface must be open for the pipe to exist.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `buf`: Buffer to hold the data.
    ///
    /// Parameter `frameStart`: The bus frame number on which to start the write (obtained from GetBusFrameNumber).
    ///
    /// Parameter `numFrames`: The number of frames for which to transfer data.
    ///
    /// Parameter `frameList`: A pointer to an array of IOUSBIsocFrame structures describing the frames.
    ///
    /// Parameter `callback`: An IOAsyncCallback1 method. Upon completion, the arg0 argument of the AsyncCallback1 will contain the framelist pointer, which can be used to associate the completion with a particular request. A message addressed to this callback is posted to the Async
    /// port upon completion.
    ///
    /// Parameter `refcon`: Arbitrary pointer which is passed as a parameter to the callback routine.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the interface is not open for exclusive access.
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
}

#[cfg(all(feature = "USB", feature = "libc", feature = "objc2"))]
unsafe impl Encode for IOUSBInterfaceStruct100 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct100", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(feature = "USB", feature = "libc", feature = "objc2"))]
unsafe impl RefEncode for IOUSBInterfaceStruct100 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB device interface from user space, returned by all versions
/// of the IOUSBFamily currently shipping.
///
/// The functions listed here will work with any version of the IOUSBInterfaceInterface, including
/// the one shipped with Mac OS X version 10.0.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface100?language=objc)
#[cfg(all(feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface100 = IOUSBInterfaceStruct100;

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 1.8.2 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBInterfaceInterface and
/// some new functions that are available on Mac OS X version 10.0.4 and later.
/// Super: IOUSBInterfaceInterface
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct182?language=objc)
#[cfg(all(feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct182 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    /// Sends a USB request on a control pipe.
    ///
    /// The IOUSBDevRequestTO structure allows the client to specify timeout values for this request.  If
    /// the request is a standard request which will change the state of the device, the device must be open,
    /// which means you should be using the IOUSBDeviceInterface for this command.
    /// Availability: This function is only available with IOUSBInterfaceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index of the control pipe to use. Use zero for the default control pipe on the device.
    ///
    /// Parameter `req`: Pointer to an IOUSBDevRequestTO containing the request.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, or
    /// kIOReturnAborted if the thread is interrupted before the call completes,
    /// kIOReturnNotOpen if the interface is not open for exclusive access.
    pub ControlRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequestTO) -> IOReturn>,
    /// Sends an asynchronous USB request on a control pipe.
    ///
    /// The IOUSBDevRequestTO structure allows the client to specify timeout values for this request. Use
    /// pipeRef=0 for the default device control pipe.  If the request is a standard request which will
    /// change the state of the device, the device must be open, which means you should be using the
    /// IOUSBDeviceInterface for this command.
    /// Availability: This function is only available with IOUSBInterfaceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index of the control pipe to use. Use zero for the default control pipe on the device.
    ///
    /// Parameter `req`: Pointer to an IOUSBDevRequestTO containing the request.
    ///
    /// Parameter `callback`: An IOAsyncCallback1 method. Upon completion, the arg0 argument of the AsyncCallback1 will contain the number of bytes that were actually transferred. A message addressed to this callback is posted to the Async
    /// port upon completion.
    ///
    /// Parameter `refCon`: Arbitrary pointer which is passed as a parameter to the callback routine.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, or
    /// kIOReturnNotOpen if the interface is not open for exclusive access.
    pub ControlRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    /// Performs a read on a
    /// <b>
    /// BULK IN
    /// </b>
    /// pipe, specifying timeout values.
    ///
    /// The interface must be open for the pipe to exist.
    ///
    /// If a timeout is specified and the request times out, the driver may need to resynchronize the data
    /// toggle. See
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface/ClearPipeStall/ ClearPipeStall
    /// ```
    ///
    /// or
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface190/ClearPipeStallBothEnds/ ClearPipeStallBothEnds
    /// ```
    ///
    /// .
    ///
    /// Timeouts do not apply to interrupt pipes, so you should use the ReadPipe API to perform a read from
    /// an interrupt pipe.
    /// Availability: This function is only available with IOUSBInterfaceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `buf`: Buffer to hold the data.
    ///
    /// Parameter `size`: Pointer to the size of the buffer pointed to by buf.
    ///
    /// Parameter `noDataTimeout`: Specifies a time value in milliseconds. Once the request is queued on the bus, if no
    /// data is transferred in this amount of time, the request will be aborted and returned.
    ///
    /// Parameter `completionTimeout`: Specifies a time value in milliseconds. Once the request is queued on the bus, if
    /// the entire request is not completed in this amount of time, the request will be aborted and returned.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// kIOReturnAborted if the thread is interrupted before the call completes, or
    /// kIOReturnNotOpen if the interface is not open for exclusive access.  Returns kIOReturnBadArgument if timeout
    /// values are specified for an interrupt pipe.  If an error is returned, the size parameter is not updated and the buffer will
    /// NOT contain any valid data.
    pub ReadPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32, u32, u32) -> IOReturn,
    >,
    /// Performs a write on a
    /// <b>
    /// BULK OUT
    /// </b>
    /// pipe, with specified timeout values.
    ///
    /// The interface must be open for the pipe to exist.
    ///
    /// If a timeout is specified and the request times out, the driver may need to resynchronize the data
    /// toggle. See
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface/ClearPipeStall/ ClearPipeStall
    /// ```
    ///
    /// or
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface190/ClearPipeStallBothEnds/ ClearPipeStallBothEnds
    /// ```
    ///
    /// .
    /// Availability: This function is only available with IOUSBInterfaceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `buf`: Buffer to hold the data.
    ///
    /// Parameter `size`: The size of the buffer pointed to by buf.
    ///
    /// Parameter `noDataTimeout`: Specifies a time value in milliseconds. Once the request is queued on the bus, if no
    /// data is transferred in this amount of time, the request will be aborted and returned.
    ///
    /// Parameter `completionTimeout`: Specifies a time value in milliseconds. Once the request is queued on the bus, if
    /// the entire request is not completed in this amount of time, the request will be aborted and returned.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// kIOReturnAborted if the thread is interrupted before the call completes, or
    /// kIOReturnNotOpen if the interface is not open for exclusive access.
    pub WritePipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    /// Performs an asynchronous read on a
    /// <b>
    /// BULK IN
    /// </b>
    /// pipe, with specified timeout values.
    ///
    /// The interface must be open for the pipe to exist.
    ///
    /// If a timeout is specified and the request times out, the driver may need to resynchronize the data
    /// toggle. See
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface/ClearPipeStall/ ClearPipeStall
    /// ```
    ///
    /// or
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface190/ClearPipeStallBothEnds/ ClearPipeStallBothEnds
    /// ```
    ///
    /// .
    ///
    /// Timeouts do not apply to interrupt pipes, so you should use the ReadPipeAsync API to perform an
    /// asynchronous read from an interrupt pipe.
    /// Availability: This function is only available with IOUSBInterfaceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `buf`: Buffer to hold the data.
    ///
    /// Parameter `size`: The size of the buffer pointed to by buf.
    ///
    /// Parameter `noDataTimeout`: Specifies a time value in milliseconds. Once the request is queued on the bus, if no
    /// data is transferred in this amount of time, the request will be aborted and returned.
    ///
    /// Parameter `completionTimeout`: Specifies a time value in milliseconds. Once the request is queued on the bus, if
    /// the entire request is not completed in this amount of time, the request will be aborted and returned.
    ///
    /// Parameter `callback`: An IOAsyncCallback1 method. Upon completion, the arg0 argument of the AsyncCallback1 will contain the number of bytes that were actually read. A message addressed to this callback is posted to the Async port
    /// upon completion.
    ///
    /// Parameter `refcon`: Arbitrary pointer which is passed as a parameter to the callback routine.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, or
    /// kIOReturnNotOpen if the interface is not open for exclusive access.  Returns kIOReturnBadArgument if timeout
    /// values are specified for an interrupt pipe.  If an error is returned, the size parameter is not updated and the buffer will
    /// NOT contain any valid data.
    pub ReadPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    /// Performs an asynchronous write on a
    /// <b>
    /// BULK OUT
    /// </b>
    /// pipe, with specified timeout values.
    ///
    /// The interface must be open for the pipe to exist.
    ///
    /// If a timeout is specified and the request times out, the driver may need to resynchronize the data
    /// toggle. See
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface/ClearPipeStall/ ClearPipeStall
    /// ```
    ///
    /// or
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface190/ClearPipeStallBothEnds/ ClearPipeStallBothEnds
    /// ```
    ///
    /// .
    /// Availability: This function is only available with IOUSBInterfaceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `buf`: Buffer to hold the data.
    ///
    /// Parameter `size`: The size of the buffer pointed to by buf.
    ///
    /// Parameter `noDataTimeout`: Specifies a time value in milliseconds. Once the request is queued on the bus, if no
    /// data is transferred in this amount of time, the request will be aborted and returned.
    ///
    /// Parameter `completionTimeout`: Specifies a time value in milliseconds. Once the request is queued on the bus, if
    /// the entire request is not completed in this amount of time, the request will be aborted and returned.
    ///
    /// Parameter `callback`: An IOAsyncCallback1 method. Upon completion, the arg0 argument of the AsyncCallback1 will contain the number of bytes that were actually written. A message addressed to this callback is posted to the Async port
    /// upon completion.
    ///
    /// Parameter `refcon`: Arbitrary pointer which is passed as a parameter to the callback routine.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, or
    /// kIOReturnNotOpen if the interface is not open for exclusive access.
    pub WritePipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    /// Returns the string index in the interface descriptor.
    ///
    /// The interface does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBInterfaceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `si`: Pointer to UInt8 to hold the string index.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub USBInterfaceGetStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
}

#[cfg(all(feature = "USB", feature = "libc", feature = "objc2"))]
unsafe impl Encode for IOUSBInterfaceStruct182 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct182", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(feature = "USB", feature = "libc", feature = "objc2"))]
unsafe impl RefEncode for IOUSBInterfaceStruct182 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 1.8.2 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBInterfaceInterface and
/// some new functions that are available on Mac OS X version 10.0.4 and later.
/// Super: IOUSBInterfaceInterface
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface182?language=objc)
#[cfg(all(feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface182 = IOUSBInterfaceStruct182;

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 1.8.3 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBInterfaceInterface,
/// IOUSBInterfaceInterface182, and some new functions that are available on Mac OS X version 10.1
/// and later.
/// Super: IOUSBInterfaceInterface182
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct183?language=objc)
#[cfg(all(feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct183 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ControlRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub ControlRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32, u32, u32) -> IOReturn,
    >,
    pub WritePipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBInterfaceGetStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    /// Opens the IOUSBInterface for exclusive access.
    ///
    /// If another client has the device open, an attempt is made to get that client to close it before
    /// returning.
    ///
    /// Before the client can issue commands that change the state of the device, it must have succeeded
    /// in opening the device. This establishes an exclusive link between the clients task and the actual
    /// device.
    /// Availability: This function is only available with IOUSBInterfaceInterface183 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Returns: Returns kIOReturnExclusiveAccess if some other task has the interface open already and refuses to
    /// close it, kIOReturnError if the connection with the kernel cannot be established or kIOReturnSuccess
    /// if successful.
    pub USBInterfaceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
}

#[cfg(all(feature = "USB", feature = "libc", feature = "objc2"))]
unsafe impl Encode for IOUSBInterfaceStruct183 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct183", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(feature = "USB", feature = "libc", feature = "objc2"))]
unsafe impl RefEncode for IOUSBInterfaceStruct183 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 1.8.3 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBInterfaceInterface,
/// IOUSBInterfaceInterface182, and some new functions that are available on Mac OS X version 10.1
/// and later.
/// Super: IOUSBInterfaceInterface182
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface183?language=objc)
#[cfg(all(feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface183 = IOUSBInterfaceStruct183;

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 1.9 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBInterfaceInterface,
/// IOUSBInterfaceInterface182, IOUSBInterfaceInterface183, and some new functions that are available
/// on Mac OS X version 10.2 and later.
/// Super: IOUSBInterfaceInterface183
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct190?language=objc)
#[cfg(all(feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct190 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ControlRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub ControlRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32, u32, u32) -> IOReturn,
    >,
    pub WritePipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBInterfaceGetStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBInterfaceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    /// Equivalent to ClearPipeStall.
    ///
    /// This function is equivalent to ClearPipeStall except that it also attempts to clear the halt and
    /// toggle bits on the device's endpoint for the pipe by sending a ClearFeature(ENDPOINT_HALT) to the
    /// default control pipe in the device, specifying the endpoint for the pipe represented by pipeRef. For
    /// most devices, this resynchronizes the data toggle between the two endpoints to ensure that there is
    /// no loss of data.
    /// Availability: This function is only available with IOUSBInterfaceInterface190 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, or
    /// kIOReturnNotOpen if the interface is not open for exclusive access.
    pub ClearPipeStallBothEnds: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    /// Changes the amount of bandwidth of an isochronous pipe or interrupt pipe, or the polling interval of an interrupt pipe.
    ///
    /// A pipe may be made smaller or larger (up to the maxPacketSize specified in the endpoint descriptor).
    /// When an interface is first opened, all pipes are created with their descriptor-supplied maxPacketSize.
    /// For isochronous or interrupt pipes, if there is not enough bandwidth on the bus to allocate to the pipe, the pipe
    /// is created with a reserved bandwidth of zero. Any attempts to transfer data on a pipe with zero
    /// bandwidth will result in a kIOReturnNoBandwidth error. The pipe must first be given some bandwidth
    /// using this call.  This can also be used to return bandwidth for an isochronous or an interrupt pipe.  If the driver
    /// knows that the device will not be sending the maxPacketSize data, it can use this call to return that unused bandwidth to the
    /// system.  If an interrupt pipe wants to change the polling interval, it can do so with this call.
    ///
    /// The interface must be open for the pipe to exist.
    /// Availability: This function is only available with IOUSBInterfaceInterface190 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `maxPacketSize`: The desired size for the isochronous or interrupt pipe. For Full Speed endpoints and High Speed endpoints which
    /// are not High Bandwidth (i.e. only a single packet is transferred in a microframe), valid values are 0 through the maxPacketSize
    /// defined in the endpoint descriptor. For High Speed High Bandwidth (i.e. 2 or 3 packets transferred in a microframe) and Super Speed endpoints,
    /// valid values are 0 and the maxPacketSize of the endpoint. The maxPacketSize of the endpoint is calculated as the base maxPacketSize
    /// multiplies by the burst size and the multiplier. See the USB 2.0 and the USB 3.0 specifications for more detail. Using a value of 0 for maxPacketSize
    /// maintains the handle for the pipe but unreserves any bandwidth on the bus.
    ///
    /// Parameter `maxInterval`: applies only to interrupt endpoints. maxInterval has the same value as the bInterval field of the endpoint.
    /// For Low Speed and Full Speed interrupt endpoints, it is the desired polling interval in milliseconds, up to a maximum of 128 ms.
    /// The system can only poll devices powers of 2 (1, 2, 4, 8, 16, 32, 64, or 128 ms).
    /// For High Speed and Super Speed endpoints, maxInterval is used as an exponent for a (2 ^ (maxInterval-1)) value representing the number
    /// of 125uS microframes between service intervals. See the USB 2.0 and the USB 3.0 specifications for more info. The lower layers may
    /// schedule the endpoint for service at an interval value equal to or less than the value specified. A value of 0 is illegal.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, or
    /// kIOReturnNotOpen if the interface is not open for exclusive access.  May also return kIOReturnNoBandwidth
    /// if there is not enough bandwidth available on the bus, or kIOReturnBadArgument if the desired
    /// maxPacketSize is outside of the allowed range.
    pub SetPipePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u16, u8) -> IOReturn>,
    /// Returns the amount of bandwidth available on the bus for allocation to
    /// isochronous pipes.  If the device is a high speed device, it will be the number of bytes per microframe (125 �secs). If it is a full
    /// speed device, it will be the number of bytes per frame (1ms)
    ///
    /// This function is useful for determining the correct AltInterface setting as well as for using
    /// SetPipePolicy.
    ///
    /// The interface does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBInterfaceInterface190 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `bandwidth`: Pointer to UInt32 to hold the amount of bandwidth available (in bytes per 1ms frame).
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetBandwidthAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    /// Returns the transfer type, max packet size, and interval of a specified endpoint, whether or not
    /// the endpoint has a pipe currently established.
    ///
    /// This function may be useful for determining which alternate interface to select when trying to
    /// balance bandwidth allocations among isochronous pipes.
    ///
    /// The interface does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBInterfaceInterface190 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `alternateSetting`: Specifies the alternate setting within the current interface.
    ///
    /// Parameter `endpointNumber`: Specifies the desired endpoint number.
    ///
    /// Parameter `direction`: Specifies the desired direction.
    ///
    /// Parameter `transferType`: Pointer to UInt8 to hold the endpoint's transfer type (kUSBControl, kUSBIsoc, etc).
    ///
    /// Parameter `maxPacketSize`: Pointer to UInt16 to hold the maxPacketSize of the endpoint.
    ///
    /// Parameter `interval`: Pointer to UInt8 to hold the polling interval for interrupt endpoints.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetEndpointProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u8,
            u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
}

#[cfg(all(feature = "USB", feature = "libc", feature = "objc2"))]
unsafe impl Encode for IOUSBInterfaceStruct190 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct190", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u16,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u8,u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(feature = "USB", feature = "libc", feature = "objc2"))]
unsafe impl RefEncode for IOUSBInterfaceStruct190 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 1.9 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBInterfaceInterface,
/// IOUSBInterfaceInterface182, IOUSBInterfaceInterface183, and some new functions that are available
/// on Mac OS X version 10.2 and later.
/// Super: IOUSBInterfaceInterface183
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface190?language=objc)
#[cfg(all(feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface190 = IOUSBInterfaceStruct190;

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 1.9.2 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBInterfaceInterface,
/// IOUSBInterfaceInterface182, IOUSBInterfaceInterface183, IOUSBInterfaceInterface190, and some new
/// functions that are available on Mac OS X version 10.2.3 and later.
/// Super: IOUSBInterfaceInterface190
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct192?language=objc)
#[cfg(all(feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct192 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ControlRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub ControlRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32, u32, u32) -> IOReturn,
    >,
    pub WritePipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBInterfaceGetStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBInterfaceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub ClearPipeStallBothEnds: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub SetPipePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u16, u8) -> IOReturn>,
    pub GetBandwidthAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetEndpointProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u8,
            u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    /// Performs an asynchronous read on a isochronous pipe and updates the frame list at primary interrupt time.
    ///
    /// The LowLatencyReadIsochPipeAsync() and LowLatencyWriteIsochPipeAsync()
    /// calls are analogous to ReadIsochPipeAsync() and WriteIsochPipeAsync(). They differ in that the frame
    /// list data is updated at
    /// <em>
    /// primary interrupt time
    /// </em>
    /// . This means that the client can inspect the
    /// frStatus and frActCount fields as soon as the transaction completes, without having to wait for the
    /// callback to happen (depending on the value of updateFrequency). The callback will still happen when
    /// all the frames have been received.
    ///
    /// The client can specify how often the USB stack should update the frame list data by specifying the
    /// updateFrequency: this value can range from 0 - 8. If the value is between 1 and 8, the
    /// frame list will be updated every updateFrequency milliseconds. If the value is 0, the
    /// frame list will only be updated once all the frames in the transfer have been received. For example,
    /// consider a transfer with numFrames equal to 64. If the update frequency is 4, the frame
    /// list data will be updated every 4 milliseconds. If the update frequency is 0, the frame list will
    /// only be updated at the end of the transfer, after the 64 frames have been sent or received. The
    /// difference between using an update frequency of 0 and using the non-low latency isoch calls is that
    /// in the former case, the frame list will be updated at primary interrupt time, while in the latter,
    /// it will be updated at secondary interrupt time. Regardless of the value of updateFrequency,
    /// the frame list will
    /// <em>
    /// always
    /// </em>
    /// be updated on the last frame of a transfer.
    ///
    /// The rationale for adding this call is that because completion routines run on the USB Workloop, they
    /// can be scheduled to run a number of milliseconds after the USB transfer has finished. This latency
    /// is variable and depends on what other higher priority threads are running on the system. This latency
    /// presents a problem for applications, such as audio processing, that depend on receiving data,
    /// processing it, and sending it back out, and need to do this as fast as possible. Since applications
    /// that use isochronous data know when the data should be available, they can look at the frame list at
    /// the expected time and note the frActCount and frStatus (and frTimeStamp
    /// if needed) and determine how many valid bytes are in their data buffer and whether there was an
    /// error. They can then access their data buffer and process the actual data.
    ///
    /// In order to update the frame list at primary interrupt time and to allow the client to see that
    /// update, the frame list buffer needs to be shared between the kernel and user space. The same thing
    /// applies to the data buffer. This is a difference between the low latency isoch calls and the regular
    /// isoch calls. The LowLatencyCreateBuffer() call is used to pre-allocate the buffers. The
    /// client
    /// <em>
    /// must
    /// </em>
    /// use that call to allocate the data and the frame list buffers. The client can
    /// pass a portion of the buffer that was previously allocated. The USB stack will range-check the data
    /// and frame list buffers to make sure they are within the ranges of the buffers previously allocated.
    /// This allows the client, if it so desires, to allocate a large data buffer and pass portions of it to
    /// the read or write calls. The same applies to the frame list buffers. Of course, the client can also
    /// pre-allocate several data buffers and several frame list buffers and use those for each transfer.
    /// Once the transfer completes, the buffers can be reused in subsequent calls. When all transfers are
    /// finished, the client needs to call LowLatencyDestroyBuffer() for each buffer that was
    /// created with LowLatencyCreateBuffer().
    ///
    /// The interface must be open for the pipe to exist. The buf pointer and the frameList
    /// pointer need to be pre-allocated using LowLatencyCreateBuffer().
    /// After using them, they should be freed using LowLatencyDestroyBuffer().
    /// Availability: This function is only available with IOUSBInterfaceInterface192 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `buf`: Buffer to hold the data, previously allocated with LowLatencyCreateBuffer()
    /// using a kUSBLowLatencyReadBuffer type.
    ///
    /// Parameter `frameStart`: The bus frame number on which to start the read (obtained from GetBusFrameNumber).
    ///
    /// Parameter `numFrames`: The number of frames for which to transfer data.
    ///
    /// Parameter `updateFrequency`: Specifies how often, in milliseconds, the frame list data should be updated. Valid
    /// range is 0 - 8. If 0, it means that the framelist should be updated at the end of the transfer.
    ///
    /// Parameter `frameList`: A pointer to an array of IOUSBLowLatencyIsocFrame structures describing the frames.
    ///
    /// Parameter `callback`: An IOAsyncCallback1 method. Upon completion, the arg0 argument of the AsyncCallback1 will contain the framelist pointer, which can be used to associate the completion with a particular request. A message addressed to this callback is posted to
    /// the Async port upon completion.
    ///
    /// Parameter `refcon`: Arbitrary pointer which is passed as a parameter to the callback routine.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, or
    /// kIOReturnNotOpen if the interface is not open for exclusive access.  Will return kIOUSBLowLatencyBufferNotPreviouslyAllocated
    /// or kIOUSBLowLatencyFrameListNotPreviouslyAllocated if the buffer or the frameList were
    /// not previously allocated using LowLatencyCreateBuffer().
    pub LowLatencyReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    /// Performs an asynchronous write on an isochronous pipe and updates the frame list at primary interrupt time.
    ///
    /// The LowLatencyReadIsochPipeAsync() and LowLatencyWriteIsochPipeAsync()
    /// calls are analogous to ReadIsochPipeAsync() and WriteIsochPipeAsync().
    /// They differ in that the frame list data is updated at
    /// <em>
    /// primary interrupt time
    /// </em>
    /// . This means that
    /// the client can inspect the frStatus and frActCount fields as soon as the
    /// transaction completes, without having to wait for the callback to happen (depending on the value of
    /// updateFrequency). The callback will still happen when the all the frames have been received.
    ///
    /// The client can specify how often the USB stack should update the frame list data by specifying the
    /// updateFrequency: this value can range from 0 - 8. If the value is between 1 and 8, the
    /// frame list will be updated every updateFrequency milliseconds. If the value is 0, the
    /// frame list will only be updated once all the frames in the transfer have been received. For example,
    /// consider a transfer with numFrames equal to 64. If the update frequency is 4, the frame
    /// list data will be updated every 4 milliseconds. If the update frequency is 0, the frame list will
    /// only be updated at the end of the transfer, after the 64 frames have been sent or received. The
    /// difference between using an update frequency of 0 and using the non-low latency isoch calls is that
    /// in the former case, the frame list will be updated at primary interrupt time, while in the latter,
    /// it will be updated at secondary interrupt time. Regardless of the value of updateFrequency,
    /// the frame list will
    /// <em>
    /// always
    /// </em>
    /// be updated on the last frame of a transfer.
    ///
    /// The rationale for adding this call is that because completion routines run on the USB Workloop,
    /// they can be scheduled to run a number of milliseconds after the USB transfer has finished. This
    /// latency is variable and depends on what other higher priority threads are running on the system.
    /// This latency presents a problem for applications, such as audio processing, that depend on receiving
    /// data, processing it, and sending it back out, and need to do this as fast as possible. Since applications
    /// that use isochronous data know when the data should be available, they can look at the frame list at
    /// the expected time and note the frActCount and frStatus (and frTimeStamp
    /// if needed) and determine how many valid bytes are in their data buffer and whether there was an error.
    /// They can then access their data buffer and process the actual data.
    ///
    /// In order to update the frame list at primary interrupt time and to allow the client to see that
    /// update, the frame list buffer needs to be shared between the kernel and user space. The same thing
    /// applies to the data buffer. This is a difference between the low latency isoch calls and the regular
    /// isoch calls. The LowLatencyCreateBuffer() call is used to pre-allocate the buffers. The
    /// <em>
    /// client
    /// </em>
    /// must use that call to allocate the data and the frame list buffers. The client can
    /// pass a portion of the buffer that was previously allocated. The USB stack will range-check the data
    /// and frame list buffers to make sure they are within the ranges of the buffers previously allocated.
    /// This allows the client, if it so desires, to allocate a large data buffer and pass portions of it to
    /// the read or write calls. The same applies to the frame list buffers. Of course, the client can also
    /// pre-allocate several data buffers and several frame list buffers and use those for each transfer.
    /// Once the transfer completes, the buffers can be reused in subsequent calls. When all transfers are
    /// finished, the client needs to call LowLatencyDestroyBuffer() for each buffer that was
    /// created with LowLatencyCreateBuffer().
    ///
    /// The interface must be open for the pipe to exist. The buf pointer and the frameList
    /// pointer need to be pre-allocated using LowLatencyCreateBuffer(). After using them, they
    /// should be freed using LowLatencyDestroyBuffer().
    /// Availability: This function is only available with IOUSBInterfaceInterface192 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `buf`: Buffer to hold the data, previously allocated with LowLatencyCreateBuffer()
    /// using a kUSBLowLatencyWriteBuffer type.
    ///
    /// Parameter `frameStart`: The bus frame number on which to start the write (obtained from GetBusFrameNumber).
    ///
    /// Parameter `numFrames`: The number of frames for which to transfer data.
    ///
    /// Parameter `updateFrequency`: Specifies how often, in milliseconds, should the frame list data be updated. Valid
    /// range is 0 - 8. If 0, it means that the framelist should be updated at the end of the transfer.
    ///
    /// Parameter `frameList`: A pointer to an array of IOUSBLowLatencyIsocFrame structures describing the frames.
    ///
    /// Parameter `callback`: An IOAsyncCallback1 method. Upon completion, the arg0 argument of the AsyncCallback1 will contain the framelist pointer, which can be used to associate the completion with a particular request. A message addressed to this callback is posted to
    /// the Async port upon completion.
    ///
    /// Parameter `refcon`: Arbitrary pointer which is passed as a parameter to the callback routine.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, or
    /// kIOReturnNotOpen if the interface is not open for exclusive access.  Will return kIOUSBLowLatencyBufferNotPreviouslyAllocated
    /// or kIOUSBLowLatencyFrameListNotPreviouslyAllocated if the buffer or the frameList were
    /// not previously allocated using LowLatencyCreateBuffer().
    pub LowLatencyWriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    /// Allocates a buffer of type bufferType.
    ///
    /// This function allocates a buffer of type bufferType. The buffer can then be used with
    /// the LowLatencyIsochReadPipeAsync() or LowLatencyIsochWritePipeAsync() calls.
    ///
    /// The LowLatencyIsochReadPipeAsync() or LowLatencyIsochWritePipeAsync() calls
    /// require the clients to pre-allocate the data buffer and the frame list buffer parameters. This call
    /// is used to allocate those buffers. After the client is done using the buffers, they need to be
    /// released through the LowLatencyDestroyBuffer() call.
    ///
    /// If the buffer is to be used for reading data, the type passed in should be kUSBLowLatencyReadBuffer.
    /// If the buffer is to be used for writing data, the type should be kUSBLowLatencyWriteBuffer. For
    /// frame list data, the type should be kUSBLowLatencyFrameListBuffer.
    ///
    /// The client can create multiple data and frame list buffers, or it can allocate a large buffer and
    /// then use only a portion of the buffer in calls to LowLatencyReadIsochPipeAsync()
    /// or LowLatencyWriteIsochPipeAsync().
    ///
    /// The interface must be open for the pipe to exist.
    /// Availability: This function is only available with IOUSBInterfaceInterface192 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `buffer`: Pointer to a pointer that will receive the pointer to the buffer created by this call.
    ///
    /// Parameter `size`: The size of the buffer to be created in bytes.
    ///
    /// Parameter `bufferType`: Type of buffer: one of kUSBLowLatencyWriteBuffer, kUSBLowLatencyReadBuffer,
    /// or kUSBLowLatencyFrameListBuffer. See the documentation for USB.h.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, or
    /// kIOReturnNotOpen if the interface is not open for exclusive access.  If the buffer can't be allocated,
    /// it will return kIOReturnNoMemory.
    pub LowLatencyCreateBuffer: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut *mut c_void, IOByteCount, u32) -> IOReturn,
    >,
    /// Releases a buffer that was previously allocated using LowLatencyCreateBuffer().
    ///
    /// The interface must be open for the pipe to exist.
    /// Availability: This function is only available with IOUSBInterfaceInterface192 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `buffer`: Pointer to the buffer previously allocated using LowLatencyCreateBuffer().
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, or
    /// kIOReturnNotOpen if the interface is not open for exclusive access.  If the buffer was not previously
    /// allocated using LowLatencyCreateBuffer() it will return kIOReturnBadArgument.
    pub LowLatencyDestroyBuffer:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void) -> IOReturn>,
}

#[cfg(all(feature = "USB", feature = "libc", feature = "objc2"))]
unsafe impl Encode for IOUSBInterfaceStruct192 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct192", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u16,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u8,u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut c_void,IOByteCount,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut c_void,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(feature = "USB", feature = "libc", feature = "objc2"))]
unsafe impl RefEncode for IOUSBInterfaceStruct192 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 1.9.2 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBInterfaceInterface,
/// IOUSBInterfaceInterface182, IOUSBInterfaceInterface183, IOUSBInterfaceInterface190, and some new
/// functions that are available on Mac OS X version 10.2.3 and later.
/// Super: IOUSBInterfaceInterface190
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface192?language=objc)
#[cfg(all(feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface192 = IOUSBInterfaceStruct192;

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 1.9.7 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBInterfaceInterface,
/// IOUSBInterfaceInterface182, IOUSBInterfaceInterface183, IOUSBInterfaceInterface190, IOUSBInterfaceInterface192,
/// and some new functions that are available on Mac OS X version 10.2.5 and later.
/// Super: IOUSBInterfaceInterface192
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct197?language=objc)
#[cfg(all(feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct197 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ControlRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub ControlRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32, u32, u32) -> IOReturn,
    >,
    pub WritePipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBInterfaceGetStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBInterfaceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub ClearPipeStallBothEnds: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub SetPipePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u16, u8) -> IOReturn>,
    pub GetBandwidthAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetEndpointProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u8,
            u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub LowLatencyReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyWriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyCreateBuffer: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut *mut c_void, IOByteCount, u32) -> IOReturn,
    >,
    pub LowLatencyDestroyBuffer:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void) -> IOReturn>,
    /// Gets the current micro frame number of the bus to which the interface and its device are attached.
    ///
    /// The interface does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBInterfaceInterface197 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `microFrame`: Pointer to UInt64 to hold the microrame number.
    ///
    /// Parameter `atTime`: Pointer to an AbsoluteTime, which should be within 1ms of the time when the bus frame number
    /// was attained.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    /// Returns the number of microseconds in each USB Frame.
    ///
    /// This function can be used to determine whether the device is functioning in full speed or a high
    /// speed. In the case of a full speed device, the returned value will be kUSBFullSpeedMicrosecondsInFrame.
    /// In the case of a high speed device, the return value will be kUSBHighSpeedMicrosecondsInFrame.
    /// (This API should really be called GetUSBFrameTime).
    ///
    /// The interface does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBInterfaceInterface197 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `microsecondsInFrame`: Pointer to UInt32 to hold the number of microseconds in each USB frame.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetFrameListTime: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    /// Returns the version of the IOUSBLib and the version of the IOUSBFamily.
    ///
    /// The interface does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBInterfaceInterface197 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `ioUSBLibVersion`: Pointer to a NumVersion structure that on return will contain
    /// the version of the IOUSBLib.
    ///
    /// Parameter `usbFamilyVersion`: Pointer to a NumVersion structure that on return will contain
    /// the version of the IOUSBFamily.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
}

#[cfg(all(feature = "USB", feature = "libc", feature = "objc2"))]
unsafe impl Encode for IOUSBInterfaceStruct197 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct197", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u16,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u8,u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut c_void,IOByteCount,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(feature = "USB", feature = "libc", feature = "objc2"))]
unsafe impl RefEncode for IOUSBInterfaceStruct197 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 1.9.7 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBInterfaceInterface,
/// IOUSBInterfaceInterface182, IOUSBInterfaceInterface183, IOUSBInterfaceInterface190, IOUSBInterfaceInterface192,
/// and some new functions that are available on Mac OS X version 10.2.5 and later.
/// Super: IOUSBInterfaceInterface192
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface197?language=objc)
#[cfg(all(feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface197 = IOUSBInterfaceStruct197;

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 2.2.0 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBInterfaceInterface,
/// IOUSBInterfaceInterface182, IOUSBInterfaceInterface183, IOUSBInterfaceInterface190, IOUSBInterfaceInterface192
/// and IOUSBInterfaceInterface197, as well as some new functions that are available on Mac OS X version 10.4 and later.
/// Super: IOUSBInterfaceInterface197
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct220?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct220 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ControlRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub ControlRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32, u32, u32) -> IOReturn,
    >,
    pub WritePipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBInterfaceGetStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBInterfaceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub ClearPipeStallBothEnds: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub SetPipePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u16, u8) -> IOReturn>,
    pub GetBandwidthAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetEndpointProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u8,
            u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub LowLatencyReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyWriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyCreateBuffer: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut *mut c_void, IOByteCount, u32) -> IOReturn,
    >,
    pub LowLatencyDestroyBuffer:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetFrameListTime: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    /// Find the next descriptor of the requested type associated with the interface.
    ///
    /// The interface does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBInterfaceInterface220 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `currentDescriptor`: Descriptor to start searching from, NULL to start from beginning of list.
    ///
    /// Parameter `descriptorType`: Descriptor type to search for, or kUSBAnyDesc to return any descriptor type.
    ///
    /// Returns: Pointer to the descriptor, or NULL if no matching descriptors found.
    pub FindNextAssociatedDescriptor: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *const c_void, u8) -> *mut IOUSBDescriptorHeader,
    >,
    /// return alternate interface descriptor satisfying the requirements specified in request, or NULL if there aren't any.
    /// discussion request is updated with the properties of the returned interface.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `current`: interface descriptor to start searching from, NULL to start at alternate interface 0.
    ///
    /// Parameter `request`: specifies what properties an interface must have to match.
    ///
    /// Returns: Pointer to a matching interface descriptor, or NULL if none match.
    pub FindNextAltInterface: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *const c_void,
            *mut IOUSBFindInterfaceRequest,
        ) -> *mut IOUSBDescriptorHeader,
    >,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBInterfaceStruct220 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct220", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u16,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u8,u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut c_void,IOByteCount,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,u8,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,*mut IOUSBFindInterfaceRequest,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBInterfaceStruct220 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 2.2.0 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBInterfaceInterface,
/// IOUSBInterfaceInterface182, IOUSBInterfaceInterface183, IOUSBInterfaceInterface190, IOUSBInterfaceInterface192
/// and IOUSBInterfaceInterface197, as well as some new functions that are available on Mac OS X version 10.4 and later.
/// Super: IOUSBInterfaceInterface197
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface220?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface220 = IOUSBInterfaceStruct220;

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 2.4.5 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBInterfaceInterface,
/// IOUSBInterfaceInterface182, IOUSBInterfaceInterface183, IOUSBInterfaceInterface190, IOUSBInterfaceInterface192,
/// IOUSBInterfaceInterface197 and IOUSBInterfaceInterface220, as well as some new functions that are available on
/// Mac OS X version 10.4.6 and later.
/// Super: IOUSBInterfaceInterface220
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct245?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct245 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ControlRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub ControlRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32, u32, u32) -> IOReturn,
    >,
    pub WritePipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBInterfaceGetStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBInterfaceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub ClearPipeStallBothEnds: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub SetPipePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u16, u8) -> IOReturn>,
    pub GetBandwidthAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetEndpointProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u8,
            u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub LowLatencyReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyWriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyCreateBuffer: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut *mut c_void, IOByteCount, u32) -> IOReturn,
    >,
    pub LowLatencyDestroyBuffer:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetFrameListTime: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    pub FindNextAssociatedDescriptor: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *const c_void, u8) -> *mut IOUSBDescriptorHeader,
    >,
    pub FindNextAltInterface: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *const c_void,
            *mut IOUSBFindInterfaceRequest,
        ) -> *mut IOUSBDescriptorHeader,
    >,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBInterfaceStruct245 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct245", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u16,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u8,u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut c_void,IOByteCount,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,u8,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,*mut IOUSBFindInterfaceRequest,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBInterfaceStruct245 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 2.4.5 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBInterfaceInterface,
/// IOUSBInterfaceInterface182, IOUSBInterfaceInterface183, IOUSBInterfaceInterface190, IOUSBInterfaceInterface192,
/// IOUSBInterfaceInterface197 and IOUSBInterfaceInterface220, as well as some new functions that are available on
/// Mac OS X version 10.4.6 and later.
/// Super: IOUSBInterfaceInterface220
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface245?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface245 = IOUSBInterfaceStruct245;

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 3.0.0 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBInterfaceInterface,
/// IOUSBInterfaceInterface182, IOUSBInterfaceInterface183, IOUSBInterfaceInterface190, IOUSBInterfaceInterface192,
/// IOUSBInterfaceInterface197, IOUSBInterfaceInterface220 and IOUSBInterfaceInterface245, as well as some new functions
/// that are available on Mac OS X version 10.5 and later.
/// Super: IOUSBInterfaceInterface245
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct300?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct300 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ControlRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub ControlRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32, u32, u32) -> IOReturn,
    >,
    pub WritePipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBInterfaceGetStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBInterfaceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub ClearPipeStallBothEnds: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub SetPipePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u16, u8) -> IOReturn>,
    pub GetBandwidthAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetEndpointProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u8,
            u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub LowLatencyReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyWriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyCreateBuffer: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut *mut c_void, IOByteCount, u32) -> IOReturn,
    >,
    pub LowLatencyDestroyBuffer:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetFrameListTime: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    pub FindNextAssociatedDescriptor: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *const c_void, u8) -> *mut IOUSBDescriptorHeader,
    >,
    pub FindNextAltInterface: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *const c_void,
            *mut IOUSBFindInterfaceRequest,
        ) -> *mut IOUSBDescriptorHeader,
    >,
    /// Gets a recent frame number of the bus to which the device is attached, along with a system time corresponding to the start of that frame
    ///
    /// The device does not have to be open to use this function.
    /// Availability: This function is only available with IOUSBInterfaceInterface300 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `frame`: Pointer to UInt64 to hold the frame number.
    ///
    /// Parameter `atTime`: Pointer to a returned AbsoluteTime, which is the system time ("wall time") as close as possible to the beginning of that USB frame. The jitter on this value may be as much as 200 microseconds.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, or kIOReturnUnsupported is the bus doesn't support this function.
    pub GetBusFrameNumberWithTime:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBInterfaceStruct300 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct300", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u16,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u8,u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut c_void,IOByteCount,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,u8,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,*mut IOUSBFindInterfaceRequest,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBInterfaceStruct300 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 3.0.0 and above.
///
/// The functions listed here include all of the functions defined for the IOUSBInterfaceInterface,
/// IOUSBInterfaceInterface182, IOUSBInterfaceInterface183, IOUSBInterfaceInterface190, IOUSBInterfaceInterface192,
/// IOUSBInterfaceInterface197, IOUSBInterfaceInterface220 and IOUSBInterfaceInterface245, as well as some new functions
/// that are available on Mac OS X version 10.5 and later.
/// Super: IOUSBInterfaceInterface245
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface300?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface300 = IOUSBInterfaceStruct300;

/// The object you use to access a USB interface from user space, returned by the IOUSBFamily version 3.9.8 and above.
///
/// This object is functionally identical to IOUSBInterfaceInterface300 on macOS, and includes some new functions that are only available on iOS.
/// Super: IOUSBInterfaceInterface300
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct398?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct398 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ControlRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub ControlRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32, u32, u32) -> IOReturn,
    >,
    pub WritePipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBInterfaceGetStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBInterfaceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub ClearPipeStallBothEnds: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub SetPipePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u16, u8) -> IOReturn>,
    pub GetBandwidthAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetEndpointProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u8,
            u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub LowLatencyReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyWriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyCreateBuffer: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut *mut c_void, IOByteCount, u32) -> IOReturn,
    >,
    pub LowLatencyDestroyBuffer:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetFrameListTime: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    pub FindNextAssociatedDescriptor: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *const c_void, u8) -> *mut IOUSBDescriptorHeader,
    >,
    pub FindNextAltInterface: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *const c_void,
            *mut IOUSBFindInterfaceRequest,
        ) -> *mut IOUSBDescriptorHeader,
    >,
    pub GetBusFrameNumberWithTime:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBInterfaceStruct398 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct398", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u16,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u8,u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut c_void,IOByteCount,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,u8,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,*mut IOUSBFindInterfaceRequest,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBInterfaceStruct398 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB interface from user space, returned by the IOUSBFamily version 3.9.8 and above.
///
/// This object is functionally identical to IOUSBInterfaceInterface300 on macOS, and includes some new functions that are only available on iOS.
/// Super: IOUSBInterfaceInterface300
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface398?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface398 = IOUSBInterfaceStruct398;

/// The object you use to access a USB interface from user space, returned by the IOUSBFamily version 4.0.0 and above.
///
/// This object is functionally identical to IOUSBInterfaceInterface300 on macOS, and includes some new functions that are only available on iOS.
/// Super: IOUSBInterfaceInterface398
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct400?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct400 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ControlRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub ControlRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32, u32, u32) -> IOReturn,
    >,
    pub WritePipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBInterfaceGetStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBInterfaceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub ClearPipeStallBothEnds: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub SetPipePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u16, u8) -> IOReturn>,
    pub GetBandwidthAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetEndpointProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u8,
            u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub LowLatencyReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyWriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyCreateBuffer: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut *mut c_void, IOByteCount, u32) -> IOReturn,
    >,
    pub LowLatencyDestroyBuffer:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetFrameListTime: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    pub FindNextAssociatedDescriptor: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *const c_void, u8) -> *mut IOUSBDescriptorHeader,
    >,
    pub FindNextAltInterface: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *const c_void,
            *mut IOUSBFindInterfaceRequest,
        ) -> *mut IOUSBDescriptorHeader,
    >,
    pub GetBusFrameNumberWithTime:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBInterfaceStruct400 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct400", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u16,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u8,u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut c_void,IOByteCount,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,u8,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,*mut IOUSBFindInterfaceRequest,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBInterfaceStruct400 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB interface from user space, returned by the IOUSBFamily version 4.0.0 and above.
///
/// This object is functionally identical to IOUSBInterfaceInterface300 on macOS, and includes some new functions that are only available on iOS.
/// Super: IOUSBInterfaceInterface398
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface400?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface400 = IOUSBInterfaceStruct400;

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 5.0.0 and above.
///
/// The functions listed here include all of the functions defined for IOUSBInterfaceInterface400, as well as some new functions that are available on Mac OS X version 10.7.3 and later.
/// Super: IOUSBInterfaceInterface400
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct500?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct500 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ControlRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub ControlRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32, u32, u32) -> IOReturn,
    >,
    pub WritePipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBInterfaceGetStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBInterfaceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub ClearPipeStallBothEnds: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub SetPipePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u16, u8) -> IOReturn>,
    pub GetBandwidthAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetEndpointProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u8,
            u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub LowLatencyReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyWriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyCreateBuffer: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut *mut c_void, IOByteCount, u32) -> IOReturn,
    >,
    pub LowLatencyDestroyBuffer:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetFrameListTime: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    pub FindNextAssociatedDescriptor: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *const c_void, u8) -> *mut IOUSBDescriptorHeader,
    >,
    pub FindNextAltInterface: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *const c_void,
            *mut IOUSBFindInterfaceRequest,
        ) -> *mut IOUSBDescriptorHeader,
    >,
    pub GetBusFrameNumberWithTime:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    /// This function is deprecated. See GetPipePropertiesV3
    pub GetPipePropertiesV2: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
        ) -> IOReturn,
    >,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBInterfaceStruct500 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct500", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u16,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u8,u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut c_void,IOByteCount,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,u8,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,*mut IOUSBFindInterfaceRequest,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,*mut u8,*mut u8,*mut u16,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBInterfaceStruct500 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 5.0.0 and above.
///
/// The functions listed here include all of the functions defined for IOUSBInterfaceInterface400, as well as some new functions that are available on Mac OS X version 10.7.3 and later.
/// Super: IOUSBInterfaceInterface400
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface500?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface500 = IOUSBInterfaceStruct500;

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 5.5.0 and above.
///
/// The functions listed here include all of the functions defined for IOUSBInterfaceInterface500, as well as some new functions that are available on Mac OS X version 10.8.2 and later.
/// Super: IOUSBInterfaceInterface500
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct550?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct550 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ControlRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub ControlRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32, u32, u32) -> IOReturn,
    >,
    pub WritePipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBInterfaceGetStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBInterfaceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub ClearPipeStallBothEnds: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub SetPipePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u16, u8) -> IOReturn>,
    pub GetBandwidthAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetEndpointProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u8,
            u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub LowLatencyReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyWriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyCreateBuffer: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut *mut c_void, IOByteCount, u32) -> IOReturn,
    >,
    pub LowLatencyDestroyBuffer:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetFrameListTime: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    pub FindNextAssociatedDescriptor: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *const c_void, u8) -> *mut IOUSBDescriptorHeader,
    >,
    pub FindNextAltInterface: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *const c_void,
            *mut IOUSBFindInterfaceRequest,
        ) -> *mut IOUSBDescriptorHeader,
    >,
    pub GetBusFrameNumberWithTime:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetPipePropertiesV2: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
        ) -> IOReturn,
    >,
    /// Gets the different properties for a pipe.  This API uses a pointer to IOUSBEndpointProperties to return all the different properties.
    ///
    /// Once an interface is opened, all of the pipes in that interface get created by the kernel. The number
    /// of pipes can be retrieved by GetNumEndpoints. The client can then get the properties of any pipe
    /// using an index of 1 to GetNumEndpoints. Pipe 0 is the default control pipe in the device.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `properties`: pointer to a IOUSBEndpointProperties that will contain all the endpoint parameters.  Initialize the bVersion field with the appropriate version.  (See USBGetEndpointVersion in USB.h).  The bMaxStreams
    /// field, if valid, is the actual number of streams that are supported for this pipe (e.g. it takes into account what the USB controller supports, as well as what the endpoint supports). The wMaxPacketSize is the
    /// current FULL maxPacketSize for this pipe, which includes both the mult and the burst. It may have been changed by SetPipePolicy, or it could be 0 as a result of a lack of bandwidth.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the interface is not open for exclusive access.
    pub GetPipePropertiesV3: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBEndpointProperties) -> IOReturn,
    >,
    /// Returns the properties of an endpoint, possibly in an alternate interface, including any information from the SuperSpeed Companion Descriptor
    ///
    /// Parameter `properties`: pointer to a IOUSBEndpointProperties that will contain all the endpoint parameters.  Initialize the bVersion field with the appropriate version.  (See USBGetEndpointVersion in USB.h).  Initialize
    /// the bAlternateSetting, bEndpointNumber, and bDirection fields of the structure with the desired values for the endpoint.
    ///
    /// Parameter `properties`: pointer to a IOUSBEndpointProperties that will contain all the endpoint parameters.  Initialize the bVersion field with the appropriate version.  (See USBGetEndpointVersion in USB.h).  You also NEED
    /// to initialize the bAlternateSetting, the bDirection (kUSBIn or kUSBOut), and the bEndPointNumber with the desired values for the endpoint. The bMaxStreams field, if valid, is the number of streams found in the Super Speed
    /// Companion Descriptor. The wMaxPacketSize is the BASE maxPacketSize as found in the endpoint descriptor, and has not been multiplied to take into account burst and mult.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the interface is not open for exclusive access.
    pub GetEndpointPropertiesV3:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBEndpointProperties) -> IOReturn>,
    /// Returns non zero if the pipe supports streams, nonZero for the maximum supported streams
    ///
    /// The interface does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `supportsStreams`: 0 if streams not supported, non-zero value indicates maximum stream number
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub SupportsStreams: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut u32) -> IOReturn>,
    /// Creates the streams for the pipe
    ///
    /// The interface does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `streamID`: pass 0 if you want to destroy all streams, non-zero value indicates streamID of the highest stream to create
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub CreateStreams: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u32) -> IOReturn>,
    /// Get the number of streams which have been configured for the endpoint with CreateStreams
    ///
    /// The interface does not have to be open to use this function.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `configuredStreams`: Number of streams that have been configured with CreateStreams
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub GetConfiguredStreams:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut u32) -> IOReturn>,
    /// Performs a read on a stream in a
    /// <b>
    /// BULK IN
    /// </b>
    /// pipe, specifying timeout values.
    ///
    /// The interface must be open for the pipe to exist.
    ///
    /// If a timeout is specified and the request times out, the driver may need to resynchronize the data
    /// toggle. See
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface/ClearPipeStall/ ClearPipeStall
    /// ```
    ///
    /// or
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface190/ClearPipeStallBothEnds/ ClearPipeStallBothEnds
    /// ```
    ///
    /// .
    ///
    /// Timeouts do not apply to interrupt pipes, so you should use the ReadPipe API to perform a read from
    /// an interrupt pipe.
    /// Availability: This function is only available with IOUSBInterfaceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `streamID`: ID of the stream to read from
    ///
    /// Parameter `buf`: Buffer to hold the data.
    ///
    /// Parameter `size`: Pointer to the size of the buffer pointed to by buf.
    ///
    /// Parameter `noDataTimeout`: Specifies a time value in milliseconds. Once the request is queued on the bus, if no
    /// data is transferred in this amount of time, the request will be aborted and returned.
    ///
    /// Parameter `completionTimeout`: Specifies a time value in milliseconds. Once the request is queued on the bus, if
    /// the entire request is not completed in this amount of time, the request will be aborted and returned.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// kIOReturnAborted if the thread is interrupted before the call completes, or
    /// kIOReturnNotOpen if the interface is not open for exclusive access.  Returns kIOReturnBadArgument if timeout
    /// values are specified for an interrupt pipe.  If an error is returned, the size parameter is not updated and the buffer will
    /// NOT contain any valid data.
    pub ReadStreamsPipeTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u32,
            *mut c_void,
            *mut u32,
            u32,
            u32,
        ) -> IOReturn,
    >,
    /// Performs an write on a stream on a
    /// <b>
    /// BULK OUT
    /// </b>
    /// pipe, with specified timeout values.
    ///
    /// The interface must be open for the pipe to exist.
    ///
    /// If a timeout is specified and the request times out, the driver may need to resynchronize the data
    /// toggle. See
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface/ClearPipeStall/ ClearPipeStall
    /// ```
    ///
    /// or
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface190/ClearPipeStallBothEnds/ ClearPipeStallBothEnds
    /// ```
    ///
    /// .
    /// Availability: This function is only available with IOUSBInterfaceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `streamID`: ID of the stream to write to
    ///
    /// Parameter `buf`: Buffer to hold the data.
    ///
    /// Parameter `size`: The size of the buffer pointed to by buf.
    ///
    /// Parameter `noDataTimeout`: Specifies a time value in milliseconds. Once the request is queued on the bus, if no
    /// data is transferred in this amount of time, the request will be aborted and returned.
    ///
    /// Parameter `completionTimeout`: Specifies a time value in milliseconds. Once the request is queued on the bus, if
    /// the entire request is not completed in this amount of time, the request will be aborted and returned.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// kIOReturnAborted if the thread is interrupted before the call completes, or
    /// kIOReturnNotOpen if the interface is not open for exclusive access.
    pub WriteStreamsPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, u32, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    /// Performs an asynchronous read on a stream on a
    /// <b>
    /// BULK IN
    /// </b>
    /// pipe, with specified timeout values.
    ///
    /// The interface must be open for the pipe to exist.
    ///
    /// If a timeout is specified and the request times out, the driver may need to resynchronize the data
    /// toggle. See
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface/ClearPipeStall/ ClearPipeStall
    /// ```
    ///
    /// or
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface190/ClearPipeStallBothEnds/ ClearPipeStallBothEnds
    /// ```
    ///
    /// .
    ///
    /// Timeouts do not apply to interrupt pipes, so you should use the ReadPipeAsync API to perform an
    /// asynchronous read from an interrupt pipe.
    /// Availability: This function is only available with IOUSBInterfaceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `streamID`: ID of the stream to read from
    ///
    /// Parameter `buf`: Buffer to hold the data.
    ///
    /// Parameter `size`: The size of the buffer pointed to by buf.
    ///
    /// Parameter `noDataTimeout`: Specifies a time value in milliseconds. Once the request is queued on the bus, if no
    /// data is transferred in this amount of time, the request will be aborted and returned.
    ///
    /// Parameter `completionTimeout`: Specifies a time value in milliseconds. Once the request is queued on the bus, if
    /// the entire request is not completed in this amount of time, the request will be aborted and returned.
    ///
    /// Parameter `callback`: An IOAsyncCallback1 method. Upon completion, the arg0 argument of the AsyncCallback1 will contain the number of bytes that were actually read.
    /// A message addressed to this callback is posted to the Async port
    /// upon completion.
    ///
    /// Parameter `refcon`: Arbitrary pointer which is passed as a parameter to the callback routine.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, or
    /// kIOReturnNotOpen if the interface is not open for exclusive access.  Returns kIOReturnBadArgument if timeout
    /// values are specified for an interrupt pipe.  If an error is returned, the size parameter is not updated and the buffer will
    /// NOT contain any valid data.
    pub ReadStreamsPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u32,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    /// Performs an asynchronous write on a stream on a
    /// <b>
    /// BULK OUT
    /// </b>
    /// pipe, with specified timeout values.
    ///
    /// The interface must be open for the pipe to exist.
    ///
    /// If a timeout is specified and the request times out, the driver may need to resynchronize the data
    /// toggle. See
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface/ClearPipeStall/ ClearPipeStall
    /// ```
    ///
    /// or
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface190/ClearPipeStallBothEnds/ ClearPipeStallBothEnds
    /// ```
    ///
    /// .
    /// Availability: This function is only available with IOUSBInterfaceInterface182 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `streamID`: ID of the stream to write to
    ///
    /// Parameter `buf`: Buffer to hold the data.
    ///
    /// Parameter `size`: The size of the buffer pointed to by buf.
    ///
    /// Parameter `noDataTimeout`: Specifies a time value in milliseconds. Once the request is queued on the bus, if no
    /// data is transferred in this amount of time, the request will be aborted and returned.
    ///
    /// Parameter `completionTimeout`: Specifies a time value in milliseconds. Once the request is queued on the bus, if
    /// the entire request is not completed in this amount of time, the request will be aborted and returned.
    ///
    /// Parameter `callback`: An IOAsyncCallback1 method. Upon completion, the arg0 argument of the AsyncCallback1 will contain the number of bytes that were actually written.
    /// A message addressed to this callback is posted to the Async port
    /// upon completion.
    ///
    /// Parameter `refcon`: Arbitrary pointer which is passed as a parameter to the callback routine.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, or
    /// kIOReturnNotOpen if the interface is not open for exclusive access.
    pub WriteStreamsPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u32,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    /// This method causes all outstanding I/O on a stream of a pipe to complete with return code kIOReturnAborted.
    ///
    /// If there are outstanding asynchronous transactions on the pipe, the callbacks will happen.
    /// Note that this command will also clear the halted bit on the endpoint
    /// in the controller, but will NOT clear the data toggle bit.  If you want to clear the data toggle bit as well, see
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface/ClearPipeStall/ ClearPipeStall
    /// ```
    ///
    /// or
    ///
    /// ```text
    ///  //apple_ref/C/instm/IOUSBInterfaceInterface190/ClearPipeStallBothEnds/ ClearPipeStallBothEnds
    /// ```
    ///
    /// for more information.  The interface must be open for the pipe to exist.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `streamID`: ID of the stream to abort
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService,
    /// or kIOReturnNotOpen if the interface is not open for exclusive access.
    pub AbortStreamsPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u32) -> IOReturn>,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBInterfaceStruct550 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct550", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u16,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u8,u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut c_void,IOByteCount,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,u8,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,*mut IOUSBFindInterfaceRequest,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,*mut u8,*mut u8,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBEndpointProperties,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBEndpointProperties,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBInterfaceStruct550 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 5.5.0 and above.
///
/// The functions listed here include all of the functions defined for IOUSBInterfaceInterface500, as well as some new functions that are available on Mac OS X version 10.8.2 and later.
/// Super: IOUSBInterfaceInterface500
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface550?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface550 = IOUSBInterfaceStruct550;

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 6.5.0 and above.
///
/// The functions listed here include all of the functions defined for IOUSBInterfaceInterface550, as well as some new functions that are available on
/// Mac OS X version 10.9 and later.
/// Super: IOUSBInterfaceInterface550
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct650?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct650 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ControlRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub ControlRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32, u32, u32) -> IOReturn,
    >,
    pub WritePipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBInterfaceGetStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBInterfaceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub ClearPipeStallBothEnds: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub SetPipePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u16, u8) -> IOReturn>,
    pub GetBandwidthAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetEndpointProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u8,
            u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub LowLatencyReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyWriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyCreateBuffer: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut *mut c_void, IOByteCount, u32) -> IOReturn,
    >,
    pub LowLatencyDestroyBuffer:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetFrameListTime: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    pub FindNextAssociatedDescriptor: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *const c_void, u8) -> *mut IOUSBDescriptorHeader,
    >,
    pub FindNextAltInterface: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *const c_void,
            *mut IOUSBFindInterfaceRequest,
        ) -> *mut IOUSBDescriptorHeader,
    >,
    pub GetBusFrameNumberWithTime:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetPipePropertiesV2: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
        ) -> IOReturn,
    >,
    pub GetPipePropertiesV3: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBEndpointProperties) -> IOReturn,
    >,
    pub GetEndpointPropertiesV3:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBEndpointProperties) -> IOReturn>,
    pub SupportsStreams: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut u32) -> IOReturn>,
    pub CreateStreams: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u32) -> IOReturn>,
    pub GetConfiguredStreams:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut u32) -> IOReturn>,
    pub ReadStreamsPipeTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u32,
            *mut c_void,
            *mut u32,
            u32,
            u32,
        ) -> IOReturn,
    >,
    pub WriteStreamsPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, u32, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadStreamsPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u32,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteStreamsPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u32,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub AbortStreamsPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u32) -> IOReturn>,
    /// Registers a callback routine to be invoked when certain events occur in the kernel.
    ///
    /// The callback function will be called, for example when the underlying IOUSBInterface is
    /// going to be suspended due to some kind of kernel activity. It will also be called when
    /// the underlying IOUSBInterface is resumed.
    /// Availability: This function is only available with IOUSBInterfaceInterface650 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `notificationMask`: Specifies the desired type of notification (e.g. suspend/resume)
    ///
    /// Parameter `callback`: An IOAsyncCallback2 method. Upon completion, the arg0 argument of the AsyncCallback2 will contain the
    /// notification type, and arg1 will contain a notificationToken which should be used when calling AcknowledgeNotification
    ///
    /// Parameter `refCon`: Arbitrary pointer which is passed as a parameter to the callback routine.
    ///
    /// Parameter `pRegistrationToken`: A pointer to a UInt64 which will contain a registration token if the function is
    /// successful. This registration token can then later be used to call UnregisterNotification.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub RegisterForNotification: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u64,
            IOAsyncCallback2,
            *mut c_void,
            *mut u64,
        ) -> IOReturn,
    >,
    /// Unregisters a previously registered callback routine
    ///
    /// The callback routine will no longer be invoked when events occur
    /// Availability: This function is only available with IOUSBInterfaceInterface650 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `registrationToken`: The registration token which was obtained in the call to RegisterForNotification
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub UnregisterNotification: Option<unsafe extern "C-unwind" fn(*mut c_void, u64) -> IOReturn>,
    /// Acknowledges a notification event
    ///
    /// Some events in the kernel will wait for an acknowledgement from all interested parties before proceeding.
    /// For example, if an IOUSBInterface is about to be suspended, any User Code which has registered to receive
    /// that event will be notified and should acknowledge the notification when it is ready for the IOUSBInterface
    /// to be suspended.
    /// Availability: This function is only available with IOUSBInterfaceInterface650 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `notificationToken`: The notification token which was passed in to the callback routine
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService.
    pub AcknowledgeNotification: Option<unsafe extern "C-unwind" fn(*mut c_void, u64) -> IOReturn>,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBInterfaceStruct650 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct650", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u16,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u8,u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut c_void,IOByteCount,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,u8,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,*mut IOUSBFindInterfaceRequest,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,*mut u8,*mut u8,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBEndpointProperties,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBEndpointProperties,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,IOAsyncCallback2,*mut c_void,*mut u64,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBInterfaceStruct650 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB device interface from user space, returned by the IOUSBFamily
/// version 6.5.0 and above.
///
/// The functions listed here include all of the functions defined for IOUSBInterfaceInterface550, as well as some new functions that are available on
/// Mac OS X version 10.9 and later.
/// Super: IOUSBInterfaceInterface550
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface650?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface650 = IOUSBInterfaceStruct650;

/// The object you use to access a USB interface interface from user space, returned by the IOUSBFamily
/// version 7.0.0 and above.
///
/// The functions listed here include all of the functions defined for IOUSBInterfaceInterface650, as well as some new functions that are available on
/// Mac OS X version 10.9 and later.
/// Super: IOUSBInterfaceInterface650
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct700?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct700 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ControlRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub ControlRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32, u32, u32) -> IOReturn,
    >,
    pub WritePipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBInterfaceGetStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBInterfaceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub ClearPipeStallBothEnds: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub SetPipePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u16, u8) -> IOReturn>,
    pub GetBandwidthAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetEndpointProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u8,
            u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub LowLatencyReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyWriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyCreateBuffer: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut *mut c_void, IOByteCount, u32) -> IOReturn,
    >,
    pub LowLatencyDestroyBuffer:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetFrameListTime: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    pub FindNextAssociatedDescriptor: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *const c_void, u8) -> *mut IOUSBDescriptorHeader,
    >,
    pub FindNextAltInterface: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *const c_void,
            *mut IOUSBFindInterfaceRequest,
        ) -> *mut IOUSBDescriptorHeader,
    >,
    pub GetBusFrameNumberWithTime:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetPipePropertiesV2: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
        ) -> IOReturn,
    >,
    pub GetPipePropertiesV3: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBEndpointProperties) -> IOReturn,
    >,
    pub GetEndpointPropertiesV3:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBEndpointProperties) -> IOReturn>,
    pub SupportsStreams: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut u32) -> IOReturn>,
    pub CreateStreams: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u32) -> IOReturn>,
    pub GetConfiguredStreams:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut u32) -> IOReturn>,
    pub ReadStreamsPipeTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u32,
            *mut c_void,
            *mut u32,
            u32,
            u32,
        ) -> IOReturn,
    >,
    pub WriteStreamsPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, u32, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadStreamsPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u32,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteStreamsPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u32,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub AbortStreamsPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u32) -> IOReturn>,
    pub RegisterForNotification: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u64,
            IOAsyncCallback2,
            *mut c_void,
            *mut u64,
        ) -> IOReturn,
    >,
    pub UnregisterNotification: Option<unsafe extern "C-unwind" fn(*mut c_void, u64) -> IOReturn>,
    pub AcknowledgeNotification: Option<unsafe extern "C-unwind" fn(*mut c_void, u64) -> IOReturn>,
    /// Triggers IOKit driver matching for this interface
    ///
    /// This function will call IOKit's registerService on the IOUSBInterface, which will load any kernel drivers for the interface. The SetConfigurationV2 API can be told to not load
    /// drivers for ALL IOUSBInterfaces.  This call will then allow a client to load a driver for just one of the interfaces.  The client must have the "com.apple.vm.device-access" entitlement or run with root privileges to call this API.
    /// Availability: This function is only available with IOUSBInterfaceInterface700 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, kIOReturnNotPermitted if the client does not have the "com.apple.vm.device-access" entitlement or does not have root privileges.
    pub RegisterDriver: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBInterfaceStruct700 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct700", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u16,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u8,u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut c_void,IOByteCount,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,u8,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,*mut IOUSBFindInterfaceRequest,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,*mut u8,*mut u8,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBEndpointProperties,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBEndpointProperties,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,IOAsyncCallback2,*mut c_void,*mut u64,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBInterfaceStruct700 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB interface interface from user space, returned by the IOUSBFamily
/// version 7.0.0 and above.
///
/// The functions listed here include all of the functions defined for IOUSBInterfaceInterface650, as well as some new functions that are available on
/// Mac OS X version 10.9 and later.
/// Super: IOUSBInterfaceInterface650
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface700?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface700 = IOUSBInterfaceStruct700;

/// The object you use to access a USB interface interface from user space, returned by the IOUSBFamily
/// version 8.0.0 and above.
///
/// The functions listed here include all of the functions defined for IOUSBInterfaceInterface700, as well as some new functions that are available on
/// Mac OS X version 10.11 and later.
/// Super: IOUSBInterfaceInterface700
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct800?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct800 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ControlRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub ControlRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32, u32, u32) -> IOReturn,
    >,
    pub WritePipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBInterfaceGetStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBInterfaceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub ClearPipeStallBothEnds: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub SetPipePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u16, u8) -> IOReturn>,
    pub GetBandwidthAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetEndpointProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u8,
            u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub LowLatencyReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyWriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyCreateBuffer: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut *mut c_void, IOByteCount, u32) -> IOReturn,
    >,
    pub LowLatencyDestroyBuffer:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetFrameListTime: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    pub FindNextAssociatedDescriptor: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *const c_void, u8) -> *mut IOUSBDescriptorHeader,
    >,
    pub FindNextAltInterface: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *const c_void,
            *mut IOUSBFindInterfaceRequest,
        ) -> *mut IOUSBDescriptorHeader,
    >,
    pub GetBusFrameNumberWithTime:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetPipePropertiesV2: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
        ) -> IOReturn,
    >,
    pub GetPipePropertiesV3: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBEndpointProperties) -> IOReturn,
    >,
    pub GetEndpointPropertiesV3:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBEndpointProperties) -> IOReturn>,
    pub SupportsStreams: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut u32) -> IOReturn>,
    pub CreateStreams: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u32) -> IOReturn>,
    pub GetConfiguredStreams:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut u32) -> IOReturn>,
    pub ReadStreamsPipeTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u32,
            *mut c_void,
            *mut u32,
            u32,
            u32,
        ) -> IOReturn,
    >,
    pub WriteStreamsPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, u32, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadStreamsPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u32,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteStreamsPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u32,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub AbortStreamsPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u32) -> IOReturn>,
    pub RegisterForNotification: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u64,
            IOAsyncCallback2,
            *mut c_void,
            *mut u64,
        ) -> IOReturn,
    >,
    pub UnregisterNotification: Option<unsafe extern "C-unwind" fn(*mut c_void, u64) -> IOReturn>,
    pub AcknowledgeNotification: Option<unsafe extern "C-unwind" fn(*mut c_void, u64) -> IOReturn>,
    pub RegisterDriver: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    /// Define an idling policy for the interface.
    ///
    /// This method is called to enforce an an idle policy for the device.  Note, the idle policy is only active while the interface is open and is reset when closed.
    /// Availability: This function is only available with IOUSBInterfaceInterface800 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `deviceIdleTimeout`: The amount of time in ms a device is idle before it can be suspended.  Use 0 to prevent suspending an idle device.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, kIOReturnUnsupported is the bus doesn't support this function.
    pub SetDeviceIdlePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u32) -> IOReturn>,
    /// Define an idling policy for the interface.
    ///
    /// This method is called to enforce an an idle policy for the pipes. Note, the idle policy is only active while the interface is open and is reset when closed.
    /// Availability: This function is only available with IOUSBInterfaceInterface800 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Parameter `pipeRef`: Index for the desired pipe (1 - GetNumEndpoints).
    ///
    /// Parameter `ioIdleTimeout`: The amount of time in ms an IO is pending before it allows the device to be considered idle.  Use 0 to prevent idling the device while the IO is in progress, regardless of how long it takes.
    ///
    /// Returns: Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, kIOReturnUnsupported is the bus doesn't support this function.
    pub SetPipeIdlePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u32) -> IOReturn>,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBInterfaceStruct800 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct800", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u16,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u8,u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut c_void,IOByteCount,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,u8,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,*mut IOUSBFindInterfaceRequest,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,*mut u8,*mut u8,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBEndpointProperties,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBEndpointProperties,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,IOAsyncCallback2,*mut c_void,*mut u64,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBInterfaceStruct800 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB interface interface from user space, returned by the IOUSBFamily
/// version 8.0.0 and above.
///
/// The functions listed here include all of the functions defined for IOUSBInterfaceInterface700, as well as some new functions that are available on
/// Mac OS X version 10.11 and later.
/// Super: IOUSBInterfaceInterface700
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface800?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface800 = IOUSBInterfaceStruct800;

/// The object you use to access a USB interface interface from user space, returned by the IOUSBFamily
/// version 900.4.2 and above.
///
/// The functions listed here include all of the functions defined for IOUSBInterfaceInterface800, as well as some new functions that are available on
/// macOS 10.14 and later.
/// Super: IOUSBInterfaceInterface800
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacestruct942?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceStruct942 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub CreateInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *mut CFRunLoopSource) -> IOReturn>,
    pub GetInterfaceAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut CFRunLoopSource>,
    pub CreateInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut libc::mach_port_t) -> IOReturn>,
    pub GetInterfaceAsyncPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub USBInterfaceOpen: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub USBInterfaceClose: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub GetInterfaceClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceSubClass: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceProtocol: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetDeviceVendor: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceProduct: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetDeviceReleaseNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u16) -> IOReturn>,
    pub GetConfigurationValue:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetInterfaceNumber: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetAlternateSetting: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetNumEndpoints: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub GetLocationID: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetDevice: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut io_service_t) -> IOReturn>,
    pub SetAlternateInterface: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub GetBusFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub ControlRequest:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequest) -> IOReturn>,
    pub ControlRequestAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequest,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub GetPipeProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub GetPipeStatus: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub AbortPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ResetPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ClearPipeStall: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub ReadPipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32) -> IOReturn>,
    pub WritePipe:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32) -> IOReturn>,
    pub ReadPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            *mut IOUSBIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ControlRequestTO:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBDevRequestTO) -> IOReturn>,
    pub ControlRequestAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut IOUSBDevRequestTO,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub ReadPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, *mut u32, u32, u32) -> IOReturn,
    >,
    pub WritePipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WritePipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub USBInterfaceGetStringIndex:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u8) -> IOReturn>,
    pub USBInterfaceOpenSeize: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub ClearPipeStallBothEnds: Option<unsafe extern "C-unwind" fn(*mut c_void, u8) -> IOReturn>,
    pub SetPipePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u16, u8) -> IOReturn>,
    pub GetBandwidthAvailable:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetEndpointProperties: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u8,
            u8,
            *mut u8,
            *mut u16,
            *mut u8,
        ) -> IOReturn,
    >,
    pub LowLatencyReadIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyWriteIsochPipeAsync: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut c_void,
            u64,
            u32,
            u32,
            *mut IOUSBLowLatencyIsocFrame,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub LowLatencyCreateBuffer: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut *mut c_void, IOByteCount, u32) -> IOReturn,
    >,
    pub LowLatencyDestroyBuffer:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void) -> IOReturn>,
    pub GetBusMicroFrameNumber:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetFrameListTime: Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u32) -> IOReturn>,
    pub GetIOUSBLibVersion: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *mut NumVersion, *mut NumVersion) -> IOReturn,
    >,
    pub FindNextAssociatedDescriptor: Option<
        unsafe extern "C-unwind" fn(*mut c_void, *const c_void, u8) -> *mut IOUSBDescriptorHeader,
    >,
    pub FindNextAltInterface: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            *const c_void,
            *mut IOUSBFindInterfaceRequest,
        ) -> *mut IOUSBDescriptorHeader,
    >,
    pub GetBusFrameNumberWithTime:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut u64, *mut AbsoluteTime) -> IOReturn>,
    pub GetPipePropertiesV2: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
            *mut u8,
            *mut u8,
            *mut u8,
            *mut u16,
        ) -> IOReturn,
    >,
    pub GetPipePropertiesV3: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, *mut IOUSBEndpointProperties) -> IOReturn,
    >,
    pub GetEndpointPropertiesV3:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut IOUSBEndpointProperties) -> IOReturn>,
    pub SupportsStreams: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut u32) -> IOReturn>,
    pub CreateStreams: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u32) -> IOReturn>,
    pub GetConfiguredStreams:
        Option<unsafe extern "C-unwind" fn(*mut c_void, u8, *mut u32) -> IOReturn>,
    pub ReadStreamsPipeTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u32,
            *mut c_void,
            *mut u32,
            u32,
            u32,
        ) -> IOReturn,
    >,
    pub WriteStreamsPipeTO: Option<
        unsafe extern "C-unwind" fn(*mut c_void, u8, u32, *mut c_void, u32, u32, u32) -> IOReturn,
    >,
    pub ReadStreamsPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u32,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub WriteStreamsPipeAsyncTO: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u8,
            u32,
            *mut c_void,
            u32,
            u32,
            u32,
            IOAsyncCallback1,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub AbortStreamsPipe: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u32) -> IOReturn>,
    pub RegisterForNotification: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            u64,
            IOAsyncCallback2,
            *mut c_void,
            *mut u64,
        ) -> IOReturn,
    >,
    pub UnregisterNotification: Option<unsafe extern "C-unwind" fn(*mut c_void, u64) -> IOReturn>,
    pub AcknowledgeNotification: Option<unsafe extern "C-unwind" fn(*mut c_void, u64) -> IOReturn>,
    pub RegisterDriver: Option<unsafe extern "C-unwind" fn(*mut c_void) -> IOReturn>,
    pub SetDeviceIdlePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u32) -> IOReturn>,
    pub SetPipeIdlePolicy: Option<unsafe extern "C-unwind" fn(*mut c_void, u8, u32) -> IOReturn>,
    /// Returns the IONotificationPort for this IOService instance.
    /// Availability: This function is only available with IOUSBInterfaceInterface942 and above.
    ///
    /// Parameter `self`: Pointer to the IOUSBInterfaceInterface.
    ///
    /// Returns: Returns the IONotificationPortRef if one exists, MACH_PORT_NULL otherwise.
    pub GetInterfaceAsyncNotificationPort:
        Option<unsafe extern "C-unwind" fn(*mut c_void) -> IONotificationPortRef>,
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl Encode for IOUSBInterfaceStruct942 {
    const ENCODING: Encoding = Encoding::Struct("IOUSBInterfaceStruct942", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut CFRunLoopSource,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> *mut CFRunLoopSource>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut libc::mach_port_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut io_service_t,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequest,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,*mut IOUSBIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBDevRequestTO,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u16,u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u8,u8,*mut u8,*mut u16,*mut u8,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut c_void,u64,u32,u32,*mut IOUSBLowLatencyIsocFrame,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *mut c_void,IOByteCount,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut NumVersion,*mut NumVersion,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,u8,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const c_void,*mut IOUSBFindInterfaceRequest,) -> *mut IOUSBDescriptorHeader>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut u64,*mut AbsoluteTime,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u8,*mut u8,*mut u8,*mut u16,*mut u8,*mut u8,*mut u8,*mut u16,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut IOUSBEndpointProperties,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut IOUSBEndpointProperties,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,*mut u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,*mut u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,u32,u32,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,*mut c_void,u32,u32,u32,IOAsyncCallback1,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,IOAsyncCallback2,*mut c_void,*mut u64,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u64,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,u8,u32,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> IONotificationPortRef>>::ENCODING,
    ]);
}

#[cfg(all(
    feature = "AppleUSBDefinitions",
    feature = "USB",
    feature = "libc",
    feature = "objc2"
))]
unsafe impl RefEncode for IOUSBInterfaceStruct942 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The object you use to access a USB interface interface from user space, returned by the IOUSBFamily
/// version 900.4.2 and above.
///
/// The functions listed here include all of the functions defined for IOUSBInterfaceInterface800, as well as some new functions that are available on
/// macOS 10.14 and later.
/// Super: IOUSBInterfaceInterface800
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface942?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface942 = IOUSBInterfaceStruct942;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceinterface?language=objc)
#[cfg(all(feature = "AppleUSBDefinitions", feature = "USB", feature = "libc"))]
pub type IOUSBInterfaceInterface = IOUSBInterfaceInterface942;
