<!-- THIS FILE IS AUTOGENERATED. DO NOT EDIT IT. See scripts/generate-docs.sh -->




# Commands

## Breakpoint

-  [break-if-not-taken](breakpoint/break-if-not-taken.md) - Breaks on a branch if it is not taken.
-  [break-if-taken](breakpoint/break-if-taken.md) - Breaks on a branch if it is taken.
-  [breakrva](breakpoint/breakrva.md) - Break at RVA from PIE base.
-  [ignore](breakpoint/ignore.md) - Set ignore-count of breakpoint number N to COUNT.

## Context

-  [context](context/context.md) - Print out the currently enabled context sections.
-  [contextnext](context/contextnext.md) - Select next entry in context history.
-  [contextoutput](context/contextoutput.md) - Sets the output of a context section.
-  [contextprev](context/contextprev.md) - Select previous entry in context history.
-  [contextsearch](context/contextsearch.md) - Search for a string in the context history and select that entry.
-  [contextunwatch](context/contextunwatch.md) - Removes an expression previously added to be watched.
-  [contextwatch](context/contextwatch.md) - Adds an expression to be shown on context.
-  [regs](context/regs.md) - Print out all registers and enhance the information.

## Darwin/libsystem/Mach-O

-  [commpage](darwin_libsystem_mach-o/commpage.md) - Dumps all values from the macOS commpage.

## Developer

-  [dev-dump-instruction](developer/dev-dump-instruction.md) - Dump internal PwndbgInstruction attributes.
-  [log-level](developer/log-level.md) - Set the log level.

## Disassemble

-  [emulate](disassemble/emulate.md) - Like nearpc, but will emulate instructions from the current $PC forward.
-  [nearpc](disassemble/nearpc.md) - Disassemble near a specified address.

## GLibc ptmalloc2 Heap

-  [arena](glibc_ptmalloc2_heap/arena.md) - Print the contents of an arena.
-  [arenas](glibc_ptmalloc2_heap/arenas.md) - List this process's arenas.
-  [bins](glibc_ptmalloc2_heap/bins.md) - Print the contents of all an arena's bins and a thread's tcache.
-  [fastbins](glibc_ptmalloc2_heap/fastbins.md) - Print the contents of an arena's fastbins.
-  [find-fake-fast](glibc_ptmalloc2_heap/find-fake-fast.md) - Find candidate fake fast or tcache chunks overlapping the specified address.
-  [heap](glibc_ptmalloc2_heap/heap.md) - Iteratively print chunks on a heap.
-  [hi](glibc_ptmalloc2_heap/hi.md) - Searches all heaps to find if an address belongs to a chunk. If yes, prints the chunk.
-  [largebins](glibc_ptmalloc2_heap/largebins.md) - Print the contents of an arena's largebins.
-  [malloc-chunk](glibc_ptmalloc2_heap/malloc-chunk.md) - Print a chunk.
-  [mp](glibc_ptmalloc2_heap/mp.md) - Print the mp_ struct's contents.
-  [smallbins](glibc_ptmalloc2_heap/smallbins.md) - Print the contents of an arena's smallbins.
-  [tcache](glibc_ptmalloc2_heap/tcache.md) - Print a thread's tcache contents.
-  [tcachebins](glibc_ptmalloc2_heap/tcachebins.md) - Print the contents of a tcache.
-  [top-chunk](glibc_ptmalloc2_heap/top-chunk.md) - Print relevant information about an arena's top chunk.
-  [try-free](glibc_ptmalloc2_heap/try-free.md) - Check what would happen if free was called with given address.
-  [unsortedbin](glibc_ptmalloc2_heap/unsortedbin.md) - Print the contents of an arena's unsortedbin.
-  [vis-heap-chunks](glibc_ptmalloc2_heap/vis-heap-chunks.md) - Visualize chunks on a heap.

## Integrations

-  [ai](integrations/ai.md) - Ask GPT-3 a question about the current debugging context.
-  [bn-sync](integrations/bn-sync.md) - Synchronize Binary Ninja's cursor with GDB.
-  [decomp](integrations/decomp.md) - Use the current integration to decompile code near an address.
-  [j](integrations/j.md) - Synchronize IDA's cursor with GDB.
-  [r2](integrations/r2.md) - Launches radare2.
-  [r2pipe](integrations/r2pipe.md) - Execute stateful radare2 commands through r2pipe.
-  [rop](integrations/rop.md) - Dump ROP gadgets with Jon Salwan's ROPgadget tool.
-  [ropper](integrations/ropper.md) - ROP gadget search with ropper.
-  [rz](integrations/rz.md) - Launches rizin.
-  [rzpipe](integrations/rzpipe.md) - Execute stateful rizin commands through rzpipe.
-  [save-ida](integrations/save-ida.md) - Save the ida database.

## Kernel

-  [binder](kernel/binder.md) - Show Android Binder information
-  [buddydump](kernel/buddydump.md) - Displays metadata and freelists of the buddy allocator.
-  [kbase](kernel/kbase.md) - Finds the kernel virtual base address.
-  [kbpf](kernel/kbpf.md) - Prints information about the linux kernel bpf progs and maps.
-  [kchecksec](kernel/kchecksec.md) - Checks for kernel hardening configuration options.
-  [kcmdline](kernel/kcmdline.md) - Return the kernel commandline (/proc/cmdline).
-  [kconfig](kernel/kconfig.md) - Outputs the kernel config.
-  [kdmabuf](kernel/kdmabuf.md) - Prints DMA buf info
-  [kdmesg](kernel/kdmesg.md) - Displays the kernel ring buffer (dmesg) contents.
-  [klookup](kernel/klookup.md) - Lookup kernel symbols
-  [kmod](kernel/kmod.md) - Displays the loaded Linux kernel modules.
-  [knft-dump](kernel/knft-dump.md) - Dump all nftables: tables, chains, rules, expressions
-  [knft-list-chains](kernel/knft-list-chains.md) - Dump netfilter chains form a specific table
-  [knft-list-exprs](kernel/knft-list-exprs.md) - Dump only expressions from specific rule
-  [knft-list-flowtables](kernel/knft-list-flowtables.md) - Dump netfilter flowtables from a specific table
-  [knft-list-objects](kernel/knft-list-objects.md) - Dump netfilter objects from a specific table
-  [knft-list-rules](kernel/knft-list-rules.md) - Dump netfilter rules form a specific chain
-  [knft-list-sets](kernel/knft-list-sets.md) - Dump netfilter sets from a specific table
-  [knft-list-tables](kernel/knft-list-tables.md) - Dump netfliter tables from a specific network namespace
-  [ksyscalls](kernel/ksyscalls.md) - Displays Linux syscall table, including names and addresses of syscalls.
-  [ktask](kernel/ktask.md) - Displays information about kernel tasks.
-  [kversion](kernel/kversion.md) - Outputs the kernel version (/proc/version).
-  [msr](kernel/msr.md) - Read or write to Model Specific Register (MSR)
-  [p2v](kernel/p2v.md) - Translate physical address to its corresponding virtual address.
-  [pageinfo](kernel/pageinfo.md) - Convert a pointer to a `struct page` to its corresponding virtual address.
-  [pagewalk](kernel/pagewalk.md) - Performs pagewalk.
-  [slab](kernel/slab.md) - Prints information about the linux kernel's slab allocator SLUB.
-  [v2p](kernel/v2p.md) - Translate virtual address to its corresponding physmap address.

## Linux/libc/ELF

-  [argc](linux_libc_elf/argc.md) - Prints out the number of arguments.
-  [argv](linux_libc_elf/argv.md) - Prints out the contents of argv.
-  [aslr](linux_libc_elf/aslr.md) - Check the current ASLR status, or turn it on/off.
-  [auxv-explore](linux_libc_elf/auxv-explore.md) - Explore and print information from the Auxiliary ELF Vector.
-  [auxv](linux_libc_elf/auxv.md) - Print information from the Auxiliary ELF Vector.
-  [elfsections](linux_libc_elf/elfsections.md) - Prints the section mappings contained in the ELF header.
-  [envp](linux_libc_elf/envp.md) - Prints out the contents of the environment.
-  [errno](linux_libc_elf/errno.md) - Converts errno (or argument) to its string representation.
-  [got](linux_libc_elf/got.md) - Show the state of the Global Offset Table.
-  [gotplt](linux_libc_elf/gotplt.md) - Prints any symbols found in the .got.plt section if it exists.
-  [libcinfo](linux_libc_elf/libcinfo.md) - Show libc version and link to its sources
-  [linkmap](linux_libc_elf/linkmap.md) - Show the state of the Link Map
-  [onegadget](linux_libc_elf/onegadget.md) - Find gadgets which single-handedly give code execution.
-  [parse-seccomp](linux_libc_elf/parse-seccomp.md) - Parse a struct sock_fprog from memory and dump its filter
-  [piebase](linux_libc_elf/piebase.md) - Calculate VA of RVA from PIE base.
-  [plt](linux_libc_elf/plt.md) - Prints any symbols found in Procedure Linkage Table sections if any exist.
-  [strings](linux_libc_elf/strings.md) - Extracts and displays ASCII strings from readable memory pages of the debugged process.
-  [threads](linux_libc_elf/threads.md) - List all threads belonging to the selected inferior.
-  [tls](linux_libc_elf/tls.md) - Print out base address of the current Thread Local Storage (TLS).
-  [track-got](linux_libc_elf/track-got.md) - Controls GOT tracking
-  [track-heap](linux_libc_elf/track-heap.md) - Manages the heap tracker.

## Memory

-  [distance](memory/distance.md) - Print the distance between the two arguments, or print the offset to the address's page base.
-  [dump-register-frame](memory/dump-register-frame.md) - Display the registers saved to memory for a certain frame type
-  [gdt](memory/gdt.md) - Decode X86-64 GDT entries at address
-  [go-dump](memory/go-dump.md) - Dumps a Go value of a given type at a specified address.
-  [go-type](memory/go-type.md) - Dumps a Go runtime reflection type at a specified address.
-  [hexdump](memory/hexdump.md) - Hexdumps data at the specified address or module name.
-  [leakfind](memory/leakfind.md) - Attempt to find a leak chain given a starting address.
-  [memfrob](memory/memfrob.md) - Memfrobs a region of memory (xor with '*').
-  [mmap](memory/mmap.md) - Calls the mmap syscall and prints its resulting address.
-  [mprotect](memory/mprotect.md) - Calls the mprotect syscall and prints its result value.
-  [p2p](memory/p2p.md) - Pointer to pointer chain search. Searches given mapping for all pointers that point to specified mapping.
-  [probeleak](memory/probeleak.md) - Pointer scan for possible offset leaks.
-  [search](memory/search.md) - Search memory for byte sequences, strings, pointers, and integer values.
-  [telescope](memory/telescope.md) - Recursively dereferences pointers starting at the specified address.
-  [vmmap-add](memory/vmmap-add.md) - Add virtual memory map page.
-  [vmmap-clear](memory/vmmap-clear.md) - Clear the vmmap cache.
-  [vmmap-explore](memory/vmmap-explore.md) - Explore a page, trying to guess permissions.
-  [vmmap](memory/vmmap.md) - Print virtual memory map pages.
-  [xinfo](memory/xinfo.md) - Shows offsets of the specified address from various useful locations.
-  [xor](memory/xor.md) - XOR `count` bytes at `address` with the key `key`.

## Misc

-  [asm](misc/asm.md) - Assemble shellcode into bytes
-  [checksec](misc/checksec.md) - Prints out the binary security settings using `checksec`.
-  [comm](misc/comm.md) - Put comments in assembly code.
-  [cyclic](misc/cyclic.md) - Cyclic pattern creator/finder.
-  [cymbol](misc/cymbol.md) - Manage custom C structures in pwndbg. Supports project-specific auto-loading from .gdbinit.
-  [down](misc/down.md) - Select and print stack frame called by this one.
-  [dt](misc/dt.md) - Dump out information on a type (e.g. ucontext_t).
-  [dumpargs](misc/dumpargs.md) - Prints determined arguments for call/syscall instruction.
-  [getfile](misc/getfile.md) - Gets the current file.
-  [hex2ptr](misc/hex2ptr.md) - Converts a space-separated hex string to a little-endian address.
-  [hijack-fd](misc/hijack-fd.md) - Replace a file descriptor of a debugged process.
-  [ipi](misc/ipi.md) - Start an interactive IPython prompt.
-  [patch-list](misc/patch-list.md) - List all patches.
-  [patch-revert](misc/patch-revert.md) - Revert patch at given address.
-  [patch](misc/patch.md) - Patches given instruction with given code or bytes.
-  [plist](misc/plist.md) - Dumps the elements of a linked list.
-  [sigreturn](misc/sigreturn.md) - Display the SigreturnFrame at the specific address
-  [spray](misc/spray.md) - Spray memory with cyclic() generated values
-  [tips](misc/tips.md) - Shows tips.
-  [up](misc/up.md) - Select and print stack frame that called this one.
-  [valist](misc/valist.md) - Dumps the arguments of a va_list.
-  [vmmap-load](misc/vmmap-load.md) - Load virtual memory map pages from ELF file.

## Process

-  [killthreads](process/killthreads.md) - Kill all or given threads.
-  [pid](process/pid.md) - Gets the pid.
-  [procinfo](process/procinfo.md) - Display information about the running process.

## Pwndbg

-  [bugreport](pwndbg/bugreport.md) - Generate a bug report.
-  [config](pwndbg/config.md) - Shows Pwndbg-specific configuration.
-  [configfile](pwndbg/configfile.md) - Generates a configuration file for the current Pwndbg options.
-  [heap-config](pwndbg/heap-config.md) - Shows heap related configuration.
-  [memoize](pwndbg/memoize.md) - Toggles memoization (caching).
-  [profiler](pwndbg/profiler.md) - Utilities for profiling Pwndbg.
-  [pwndbg](pwndbg/pwndbg.md) - Prints out a list of all Pwndbg commands.
-  [reinit-pwndbg](pwndbg/reinit-pwndbg.md) - Makes Pwndbg reinitialize all state.
-  [reload](pwndbg/reload.md) - Reload Pwndbg.
-  [theme](pwndbg/theme.md) - Shows Pwndbg-specific theme configuration.
-  [themefile](pwndbg/themefile.md) - Generates a configuration file for the current Pwndbg theme options.
-  [version](pwndbg/version.md) - Displays Pwndbg and its important deps versions.

## Register

-  [cpsr](register/cpsr.md) - Print out ARM CPSR or xPSR register.
-  [fsbase](register/fsbase.md) - Prints out the FS base address. See also $fsbase.
-  [gsbase](register/gsbase.md) - Prints out the GS base address. See also $gsbase.
-  [setflag](register/setflag.md) - Modify the flags register.

## Stack

-  [canary](stack/canary.md) - Print out the current stack canary.
-  [retaddr](stack/retaddr.md) - Print out the stack addresses that contain return addresses.
-  [stack-explore](stack/stack-explore.md) - Explore stack from all threads.
-  [stack](stack/stack.md) - Dereferences on stack data with specified count and offset.
-  [stackf](stack/stackf.md) - Dereferences on stack data, printing the entire stack frame with specified count and offset .

## Start

-  [attachp](start/attachp.md) - Attaches to a given pid, process name, process found with partial argv match or to a device file.
-  [entry](start/entry.md) - Start the debugged program stopping at its entrypoint address.
-  [sstart](start/sstart.md) - Alias for 'tbreak __libc_start_main; run'.
-  [start](start/start.md) - Start the debugged program stopping at the first convenient location

## Step/Next/Continue

-  [nextcall](step_next_continue/nextcall.md) - Breaks at the next call instruction.
-  [nextjmp](step_next_continue/nextjmp.md) - Breaks at the next jump instruction.
-  [nextproginstr](step_next_continue/nextproginstr.md) - Breaks at the next instruction that belongs to the running program.
-  [nextret](step_next_continue/nextret.md) - Breaks at next return-like instruction.
-  [nextsyscall](step_next_continue/nextsyscall.md) - Breaks at the next syscall not taking branches.
-  [stepover](step_next_continue/stepover.md) - Breaks on the instruction after this one.
-  [stepret](step_next_continue/stepret.md) - Breaks at next return-like instruction by 'stepping' to it.
-  [stepsyscall](step_next_continue/stepsyscall.md) - Breaks at the next syscall by taking branches.
-  [stepuntilasm](step_next_continue/stepuntilasm.md) - Breaks on the next matching instruction.
-  [xuntil](step_next_continue/xuntil.md) - Continue execution until an address or expression.

## WinDbg

-  [bc](windbg/bc.md) - Clear the breakpoint with the specified index.
-  [bd](windbg/bd.md) - Disable the breakpoint with the specified index.
-  [be](windbg/be.md) - Enable the breakpoint with the specified index.
-  [bl](windbg/bl.md) - List breakpoints.
-  [bp](windbg/bp.md) - Set a breakpoint at the specified address.
-  [da](windbg/da.md) - Dump a string at the specified address.
-  [db](windbg/db.md) - Starting at the specified address, dump N bytes.
-  [dc](windbg/dc.md) - Starting at the specified address, hexdump.
-  [dd](windbg/dd.md) - Starting at the specified address, dump N dwords.
-  [dds](windbg/dds.md) - Dump pointers and symbols at the specified address.
-  [dq](windbg/dq.md) - Starting at the specified address, dump N qwords.
-  [ds](windbg/ds.md) - Dump a string at the specified address.
-  [dw](windbg/dw.md) - Starting at the specified address, dump N words.
-  [eb](windbg/eb.md) - Write hex bytes at the specified address.
-  [ed](windbg/ed.md) - Write hex dwords at the specified address.
-  [eq](windbg/eq.md) - Write hex qwords at the specified address.
-  [ew](windbg/ew.md) - Write hex words at the specified address.
-  [ez](windbg/ez.md) - Write a string at the specified address.
-  [eza](windbg/eza.md) - Write a string at the specified address.
-  [go](windbg/go.md) - WinDbg compatibility alias for 'continue' command.
-  [k](windbg/k.md) - Print a backtrace (alias 'bt').
-  [ln](windbg/ln.md) - List the symbols nearest to the provided value.
-  [pc](windbg/pc.md) - WinDbg compatibility alias for 'nextcall' command.
-  [peb](windbg/peb.md) - Not be windows.

## jemalloc Heap

-  [jemalloc-extent-info](jemalloc_heap/jemalloc-extent-info.md) - Prints extent information for the given address
-  [jemalloc-find-extent](jemalloc_heap/jemalloc-find-extent.md) - Returns extent information for pointer address allocated by jemalloc
-  [jemalloc-heap](jemalloc_heap/jemalloc-heap.md) - Prints all extents information

## musl

-  [mallocng-dump](musl/mallocng-dump.md) - Dump the mallocng heap.
-  [mallocng-explain](musl/mallocng-explain.md) - Gives a quick explanation of musl's mallocng allocator.
-  [mallocng-find](musl/mallocng-find.md) - Find slot which contains the given address.
-  [mallocng-group](musl/mallocng-group.md) - Print out information about a mallocng group at the given address.
-  [mallocng-malloc-context](musl/mallocng-malloc-context.md) - Print out the mallocng __malloc_context (ctx) object.
-  [mallocng-meta-area](musl/mallocng-meta-area.md) - Print out a mallocng meta_area object at the given address.
-  [mallocng-meta](musl/mallocng-meta.md) - Print out information about a mallocng group given the address of its meta.
-  [mallocng-slot-start](musl/mallocng-slot-start.md) - Dump information about a mallocng slot, given its start address.
-  [mallocng-slot-user](musl/mallocng-slot-user.md) - Dump information about a mallocng slot, given its user address.
-  [mallocng-visualize-slots](musl/mallocng-visualize-slots.md) - Visualize slots in a group.

<!-- END OF AUTOGENERATED PART. Do not modify this line or the line below, they mark the end of the auto-generated part of the file. If you want to extend the documentation in a way which cannot easily be done by adding to the command help description, write below the following line. -->
<!-- ------------\>8---- ----\>8---- ----\>8------------ -->
