/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.CodeRange;
import org.jcodings.IntHolder;
import org.joni.BitSet;
import org.joni.BitStatus;
import org.joni.ByteCodePrinter;
import org.joni.CaptureTreeNode;
import org.joni.Config;
import org.joni.Option;
import org.joni.Regex;
import org.joni.Region;
import org.joni.SCStackEntry;
import org.joni.StackEntry;
import org.joni.StackMachine;
import org.joni.exception.InternalException;

class ByteCodeMachine
extends StackMachine {
    private static final int MAX_INTERRUPT_CHECK_EVERY = 32768;
    int interruptCheckEvery = 256;
    volatile boolean interrupted = false;
    private int bestLen;
    private int s = 0;
    private int range;
    private int sprev;
    private int sstart;
    private int sbegin;
    private int pkeep;
    private final int[] code;
    private int ip;
    protected int stkp;
    private byte[] cfbuf;
    private byte[] cfbuf2;

    ByteCodeMachine(Regex regex, Region region, byte[] bytes2, int p2, int end2) {
        super(regex, region, bytes2, p2, end2);
        this.code = regex.code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        this.interrupted = true;
        ByteCodeMachine byteCodeMachine = this;
        synchronized (byteCodeMachine) {
            this.interruptCheckEvery = 0;
        }
    }

    private boolean makeCaptureHistoryTree(CaptureTreeNode node) {
        int k = this.stkp;
        while (k < this.stk) {
            StackEntry e = this.stack[k];
            if (e.type == 256) {
                int n = e.getMemNum();
                if (n > Config.MAX_CAPTURE_HISTORY_GROUP || !BitStatus.bsAt(this.regex.captureHistory, n)) continue;
                CaptureTreeNode child = new CaptureTreeNode();
                child.group = n;
                child.beg = e.getMemPStr() - this.str;
                node.addChild(child);
                this.stkp = k + 1;
                if (this.makeCaptureHistoryTree(child)) {
                    return true;
                }
                k = this.stkp;
                child.end = e.getMemPStr() - this.str;
                continue;
            }
            if (e.type != 33280 || e.getMemNum() != node.group) continue;
            node.end = e.getMemPStr() - this.str;
            this.stkp = k;
            return false;
        }
        return true;
    }

    private void checkCaptureHistory(Region region) {
        CaptureTreeNode node;
        if (region.getCaptureTree() == null) {
            node = region.setCaptureTree(new CaptureTreeNode());
        } else {
            node = region.getCaptureTree();
            node.clear();
        }
        node.group = 0;
        node.beg = (this.pkeep > this.s ? this.s : this.pkeep) - this.str;
        node.end = this.s - this.str;
        this.stkp = 0;
        this.makeCaptureHistoryTree(region.getCaptureTree());
    }

    protected final byte[] cfbuf() {
        return this.cfbuf == null ? (this.cfbuf = new byte[18]) : this.cfbuf;
    }

    protected final byte[] cfbuf2() {
        return this.cfbuf2 == null ? (this.cfbuf2 = new byte[18]) : this.cfbuf2;
    }

    private boolean stringCmpIC(int caseFlodFlag, int s1, IntHolder ps2, int mbLen, int textEnd) {
        byte[] buf1 = this.cfbuf();
        byte[] buf2 = this.cfbuf2();
        int s2 = ps2.value;
        int end1 = s1 + mbLen;
        while (s1 < end1) {
            this.value = s1;
            int len1 = this.enc.mbcCaseFold(caseFlodFlag, this.bytes, this, textEnd, buf1);
            s1 = this.value;
            this.value = s2;
            int len2 = this.enc.mbcCaseFold(caseFlodFlag, this.bytes, this, textEnd, buf2);
            s2 = this.value;
            if (len1 != len2) {
                return false;
            }
            int p1 = 0;
            int p2 = 0;
            while (len1-- > 0) {
                if (buf1[p1] != buf2[p2]) {
                    return false;
                }
                ++p1;
                ++p2;
            }
        }
        ps2.value = s2;
        return true;
    }

    @Override
    protected final int matchAt(int _range, int _sstart, int _sprev, boolean interrupt) throws InterruptedException {
        this.range = _range;
        this.sstart = _sstart;
        this.sprev = _sprev;
        this.stk = 0;
        this.ip = 0;
        if (Config.DEBUG_MATCH) {
            this.debugMatchBegin();
        }
        this.stackInit();
        this.bestLen = -1;
        this.s = _sstart;
        this.pkeep = _sstart;
        return this.enc.isSingleByte() || (this.msaOptions & 0x40000) != 0 ? this.executeSb(interrupt) : this.execute(interrupt);
    }

    private final int execute(boolean checkThreadInterrupt) throws InterruptedException {
        int[] code = this.code;
        int interruptCheckCounter = 0;
        block98: while (true) {
            if (interruptCheckCounter++ >= this.interruptCheckEvery) {
                if (this.timeout != -1L) {
                    this.handleTimeout();
                }
                this.handleInterrupted(checkThreadInterrupt);
                interruptCheckCounter = 0;
            }
            if (Config.DEBUG_MATCH) {
                this.debugMatchLoop();
            }
            this.sbegin = this.s;
            switch (code[this.ip++]) {
                case 1: {
                    if (!this.opEnd()) continue block98;
                    return this.finish();
                }
                case 2: {
                    this.opExact1();
                    continue block98;
                }
                case 3: {
                    this.opExact2();
                    continue block98;
                }
                case 4: {
                    this.opExact3();
                    continue block98;
                }
                case 5: {
                    this.opExact4();
                    continue block98;
                }
                case 6: {
                    this.opExact5();
                    continue block98;
                }
                case 7: {
                    this.opExactN();
                    continue block98;
                }
                case 8: {
                    this.opExactMB2N1();
                    continue block98;
                }
                case 9: {
                    this.opExactMB2N2();
                    continue block98;
                }
                case 10: {
                    this.opExactMB2N3();
                    continue block98;
                }
                case 11: {
                    this.opExactMB2N();
                    continue block98;
                }
                case 12: {
                    this.opExactMB3N();
                    continue block98;
                }
                case 13: {
                    this.opExactMBN();
                    continue block98;
                }
                case 14: {
                    this.opExact1IC();
                    continue block98;
                }
                case 15: {
                    this.opExactNIC();
                    continue block98;
                }
                case 16: {
                    this.opCClass();
                    continue block98;
                }
                case 17: {
                    this.opCClassMB();
                    continue block98;
                }
                case 18: {
                    this.opCClassMIX();
                    continue block98;
                }
                case 19: {
                    this.opCClassNot();
                    continue block98;
                }
                case 20: {
                    this.opCClassMBNot();
                    continue block98;
                }
                case 21: {
                    this.opCClassMIXNot();
                    continue block98;
                }
                case 22: {
                    this.opAnyChar();
                    continue block98;
                }
                case 23: {
                    this.opAnyCharML();
                    continue block98;
                }
                case 24: {
                    this.opAnyCharStar();
                    continue block98;
                }
                case 25: {
                    this.opAnyCharMLStar();
                    continue block98;
                }
                case 26: {
                    this.opAnyCharStarPeekNext();
                    continue block98;
                }
                case 27: {
                    this.opAnyCharMLStarPeekNext();
                    continue block98;
                }
                case 28: {
                    this.opWord();
                    continue block98;
                }
                case 29: {
                    this.opNotWord();
                    continue block98;
                }
                case 30: {
                    this.opWordBound();
                    continue block98;
                }
                case 31: {
                    this.opNotWordBound();
                    continue block98;
                }
                case 32: {
                    this.opWordBegin();
                    continue block98;
                }
                case 33: {
                    this.opWordEnd();
                    continue block98;
                }
                case 34: {
                    this.opAsciiWord();
                    continue block98;
                }
                case 35: {
                    this.opNotAsciiWord();
                    continue block98;
                }
                case 36: {
                    this.opAsciiWordBound();
                    continue block98;
                }
                case 37: {
                    this.opNotAsciiWordBound();
                    continue block98;
                }
                case 38: {
                    this.opAsciiWordBegin();
                    continue block98;
                }
                case 39: {
                    this.opAsciiWordEnd();
                    continue block98;
                }
                case 40: {
                    this.opBeginBuf();
                    continue block98;
                }
                case 41: {
                    this.opEndBuf();
                    continue block98;
                }
                case 42: {
                    this.opBeginLine();
                    continue block98;
                }
                case 43: {
                    this.opEndLine();
                    continue block98;
                }
                case 44: {
                    this.opSemiEndBuf();
                    continue block98;
                }
                case 45: {
                    this.opBeginPosition();
                    continue block98;
                }
                case 54: {
                    this.opMemoryStartPush();
                    continue block98;
                }
                case 53: {
                    this.opMemoryStart();
                    continue block98;
                }
                case 55: {
                    this.opMemoryEndPush();
                    continue block98;
                }
                case 57: {
                    this.opMemoryEnd();
                    continue block98;
                }
                case 59: {
                    this.opKeep();
                    continue block98;
                }
                case 56: {
                    this.opMemoryEndPushRec();
                    continue block98;
                }
                case 58: {
                    this.opMemoryEndRec();
                    continue block98;
                }
                case 46: {
                    this.opBackRef1();
                    continue block98;
                }
                case 47: {
                    this.opBackRef2();
                    continue block98;
                }
                case 48: {
                    this.opBackRefN();
                    continue block98;
                }
                case 49: {
                    this.opBackRefNIC();
                    continue block98;
                }
                case 50: {
                    this.opBackRefMulti();
                    continue block98;
                }
                case 51: {
                    this.opBackRefMultiIC();
                    continue block98;
                }
                case 52: {
                    this.opBackRefAtLevel();
                    continue block98;
                }
                case 72: {
                    this.opNullCheckStart();
                    continue block98;
                }
                case 73: {
                    this.opNullCheckEnd();
                    continue block98;
                }
                case 74: {
                    this.opNullCheckEndMemST();
                    continue block98;
                }
                case 75: {
                    this.opNullCheckEndMemSTPush();
                    continue block98;
                }
                case 61: {
                    this.opJump();
                    continue block98;
                }
                case 62: {
                    this.opPush();
                    continue block98;
                }
                case 63: {
                    this.opPop();
                    continue block98;
                }
                case 64: {
                    this.opPushOrJumpExact1();
                    continue block98;
                }
                case 65: {
                    this.opPushIfPeekNext();
                    continue block98;
                }
                case 66: {
                    this.opRepeat();
                    continue block98;
                }
                case 67: {
                    this.opRepeatNG();
                    continue block98;
                }
                case 68: {
                    this.opRepeatInc();
                    continue block98;
                }
                case 70: {
                    this.opRepeatIncSG();
                    continue block98;
                }
                case 69: {
                    this.opRepeatIncNG();
                    continue block98;
                }
                case 71: {
                    this.opRepeatIncNGSG();
                    continue block98;
                }
                case 76: {
                    this.opPushPos();
                    continue block98;
                }
                case 77: {
                    this.opPopPos();
                    continue block98;
                }
                case 78: {
                    this.opPushPosNot();
                    continue block98;
                }
                case 79: {
                    this.opFailPos();
                    continue block98;
                }
                case 80: {
                    this.opPushStopBT();
                    continue block98;
                }
                case 81: {
                    this.opPopStopBT();
                    continue block98;
                }
                case 82: {
                    this.opLookBehind();
                    continue block98;
                }
                case 83: {
                    this.opPushLookBehindNot();
                    continue block98;
                }
                case 84: {
                    this.opFailLookBehindNot();
                    continue block98;
                }
                case 85: {
                    this.opPushAbsentPos();
                    continue block98;
                }
                case 86: {
                    this.opAbsent();
                    continue block98;
                }
                case 87: {
                    this.opAbsentEnd();
                    continue block98;
                }
                case 88: {
                    this.opCall();
                    continue block98;
                }
                case 89: {
                    this.opReturn();
                    continue block98;
                }
                case 90: {
                    this.opCondition();
                    continue block98;
                }
                case 0: {
                    return this.finish();
                }
                case 60: {
                    this.opFail();
                    continue block98;
                }
                case 94: {
                    if (Config.USE_CEC) {
                        this.opStateCheckAnyCharStar();
                        continue block98;
                    }
                }
                case 95: {
                    if (Config.USE_CEC) {
                        this.opStateCheckAnyCharMLStar();
                        continue block98;
                    }
                }
                case 91: {
                    if (Config.USE_CEC) {
                        this.opStateCheckPush();
                        continue block98;
                    }
                }
                case 92: {
                    if (Config.USE_CEC) {
                        this.opStateCheckPushOrJump();
                        continue block98;
                    }
                }
                case 93: {
                    if (!Config.USE_CEC) break block98;
                    this.opStateCheck();
                    continue block98;
                }
            }
            break;
        }
        throw new InternalException("undefined bytecode (bug)");
    }

    private void handleTimeout() throws InterruptedException {
        if (System.nanoTime() - this.startTime > this.timeout) {
            throw TIMEOUT_EXCEPTION;
        }
    }

    private final int executeSb(boolean checkThreadInterrupt) throws InterruptedException {
        int[] code = this.code;
        int interruptCheckCounter = 0;
        block100: while (true) {
            if (interruptCheckCounter++ >= this.interruptCheckEvery) {
                if (this.timeout != -1L) {
                    this.handleTimeout();
                }
                this.handleInterrupted(checkThreadInterrupt);
                interruptCheckCounter = 0;
            }
            if (Config.DEBUG_MATCH) {
                this.debugMatchLoop();
            }
            this.sbegin = this.s;
            switch (code[this.ip++]) {
                case 1: {
                    if (!this.opEnd()) continue block100;
                    return this.finish();
                }
                case 2: {
                    this.opExact1();
                    continue block100;
                }
                case 3: {
                    this.opExact2();
                    continue block100;
                }
                case 4: {
                    this.opExact3();
                    continue block100;
                }
                case 5: {
                    this.opExact4();
                    continue block100;
                }
                case 6: {
                    this.opExact5();
                    continue block100;
                }
                case 7: {
                    this.opExactN();
                    continue block100;
                }
                case 8: {
                    this.opExactMB2N1();
                    continue block100;
                }
                case 9: {
                    this.opExactMB2N2();
                    continue block100;
                }
                case 10: {
                    this.opExactMB2N3();
                    continue block100;
                }
                case 11: {
                    this.opExactMB2N();
                    continue block100;
                }
                case 12: {
                    this.opExactMB3N();
                    continue block100;
                }
                case 13: {
                    this.opExactMBN();
                    continue block100;
                }
                case 14: {
                    this.opExact1IC();
                    continue block100;
                }
                case 15: {
                    this.opExactNIC();
                    continue block100;
                }
                case 16: {
                    this.opCClassSb();
                    continue block100;
                }
                case 17: {
                    this.opCClassMBSb();
                    continue block100;
                }
                case 18: {
                    this.opCClassMIXSb();
                    continue block100;
                }
                case 19: {
                    this.opCClassNotSb();
                    continue block100;
                }
                case 20: {
                    this.opCClassMBNotSb();
                    continue block100;
                }
                case 21: {
                    this.opCClassMIXNotSb();
                    continue block100;
                }
                case 22: {
                    this.opAnyCharSb();
                    continue block100;
                }
                case 23: {
                    this.opAnyCharMLSb();
                    continue block100;
                }
                case 24: {
                    this.opAnyCharStarSb();
                    continue block100;
                }
                case 25: {
                    this.opAnyCharMLStarSb();
                    continue block100;
                }
                case 26: {
                    this.opAnyCharStarPeekNextSb();
                    continue block100;
                }
                case 27: {
                    this.opAnyCharMLStarPeekNextSb();
                    continue block100;
                }
                case 28: {
                    this.opWordSb();
                    continue block100;
                }
                case 29: {
                    this.opNotWordSb();
                    continue block100;
                }
                case 30: {
                    this.opWordBoundSb();
                    continue block100;
                }
                case 31: {
                    this.opNotWordBoundSb();
                    continue block100;
                }
                case 32: {
                    this.opWordBeginSb();
                    continue block100;
                }
                case 33: {
                    this.opWordEndSb();
                    continue block100;
                }
                case 34: {
                    this.opAsciiWord();
                    continue block100;
                }
                case 35: {
                    this.opNotAsciiWord();
                    continue block100;
                }
                case 36: {
                    this.opAsciiWordBound();
                    continue block100;
                }
                case 37: {
                    this.opNotAsciiWordBound();
                    continue block100;
                }
                case 38: {
                    this.opAsciiWordBegin();
                    continue block100;
                }
                case 39: {
                    this.opAsciiWordEnd();
                    continue block100;
                }
                case 40: {
                    this.opBeginBuf();
                    continue block100;
                }
                case 41: {
                    this.opEndBuf();
                    continue block100;
                }
                case 42: {
                    this.opBeginLineSb();
                    continue block100;
                }
                case 43: {
                    this.opEndLineSb();
                    continue block100;
                }
                case 44: {
                    this.opSemiEndBuf();
                    continue block100;
                }
                case 45: {
                    this.opBeginPosition();
                    continue block100;
                }
                case 54: {
                    this.opMemoryStartPush();
                    continue block100;
                }
                case 53: {
                    this.opMemoryStart();
                    continue block100;
                }
                case 55: {
                    this.opMemoryEndPush();
                    continue block100;
                }
                case 57: {
                    this.opMemoryEnd();
                    continue block100;
                }
                case 59: {
                    this.opKeep();
                    continue block100;
                }
                case 56: {
                    this.opMemoryEndPushRec();
                    continue block100;
                }
                case 58: {
                    this.opMemoryEndRec();
                    continue block100;
                }
                case 46: {
                    this.opBackRef1();
                    continue block100;
                }
                case 47: {
                    this.opBackRef2();
                    continue block100;
                }
                case 48: {
                    this.opBackRefN();
                    continue block100;
                }
                case 49: {
                    this.opBackRefNIC();
                    continue block100;
                }
                case 50: {
                    this.opBackRefMulti();
                    continue block100;
                }
                case 51: {
                    this.opBackRefMultiIC();
                    continue block100;
                }
                case 52: {
                    this.opBackRefAtLevel();
                    continue block100;
                }
                case 72: {
                    this.opNullCheckStart();
                    continue block100;
                }
                case 73: {
                    this.opNullCheckEnd();
                    continue block100;
                }
                case 74: {
                    this.opNullCheckEndMemST();
                    continue block100;
                }
                case 75: {
                    this.opNullCheckEndMemSTPush();
                    continue block100;
                }
                case 61: {
                    this.opJump();
                    continue block100;
                }
                case 62: {
                    this.opPush();
                    continue block100;
                }
                case 63: {
                    this.opPop();
                    continue block100;
                }
                case 64: {
                    this.opPushOrJumpExact1();
                    continue block100;
                }
                case 65: {
                    this.opPushIfPeekNext();
                    continue block100;
                }
                case 66: {
                    this.opRepeat();
                    continue block100;
                }
                case 67: {
                    this.opRepeatNG();
                    continue block100;
                }
                case 68: {
                    this.opRepeatInc();
                    continue block100;
                }
                case 70: {
                    this.opRepeatIncSG();
                    continue block100;
                }
                case 69: {
                    this.opRepeatIncNG();
                    continue block100;
                }
                case 71: {
                    this.opRepeatIncNGSG();
                    continue block100;
                }
                case 76: {
                    this.opPushPos();
                    continue block100;
                }
                case 77: {
                    this.opPopPos();
                    continue block100;
                }
                case 78: {
                    this.opPushPosNot();
                    continue block100;
                }
                case 79: {
                    this.opFailPos();
                    continue block100;
                }
                case 80: {
                    this.opPushStopBT();
                    continue block100;
                }
                case 81: {
                    this.opPopStopBT();
                    continue block100;
                }
                case 82: {
                    this.opLookBehindSb();
                    continue block100;
                }
                case 83: {
                    this.opPushLookBehindNot();
                    continue block100;
                }
                case 84: {
                    this.opFailLookBehindNot();
                    continue block100;
                }
                case 85: {
                    this.opPushAbsentPos();
                    continue block100;
                }
                case 86: {
                    this.opAbsent();
                    continue block100;
                }
                case 87: {
                    this.opAbsentEnd();
                    continue block100;
                }
                case 88: {
                    this.opCall();
                    continue block100;
                }
                case 89: {
                    this.opReturn();
                    continue block100;
                }
                case 90: {
                    this.opCondition();
                    continue block100;
                }
                case 0: {
                    return this.finish();
                }
                case 60: {
                    this.opFail();
                    continue block100;
                }
                case 98: {
                    this.opExact1ICSb();
                    continue block100;
                }
                case 99: {
                    this.opExactNICSb();
                    continue block100;
                }
                case 94: {
                    if (Config.USE_CEC) {
                        this.opStateCheckAnyCharStarSb();
                        continue block100;
                    }
                }
                case 95: {
                    if (Config.USE_CEC) {
                        this.opStateCheckAnyCharMLStarSb();
                        continue block100;
                    }
                }
                case 91: {
                    if (Config.USE_CEC) {
                        this.opStateCheckPush();
                        continue block100;
                    }
                }
                case 92: {
                    if (Config.USE_CEC) {
                        this.opStateCheckPushOrJump();
                        continue block100;
                    }
                }
                case 93: {
                    if (!Config.USE_CEC) break block100;
                    this.opStateCheck();
                    continue block100;
                }
            }
            break;
        }
        throw new InternalException("undefined bytecode (bug)");
    }

    private void handleInterrupted(boolean checkThreadInterrupt) throws InterruptedException {
        if (this.interrupted || checkThreadInterrupt && Thread.currentThread().isInterrupted()) {
            Thread.interrupted();
            throw INTERRUPTED_EXCEPTION;
        }
        this.interruptCheckEvery = Math.min(this.interruptCheckEvery << 1, 32768);
    }

    private boolean opEnd() {
        int n = this.s - this.sstart;
        if (n > this.bestLen) {
            if (Config.USE_FIND_LONGEST_SEARCH_ALL_OF_RANGE && Option.isFindLongest(this.regex.options)) {
                if (n > this.msaBestLen) {
                    this.msaBestLen = n;
                    this.msaBestS = this.sstart;
                } else {
                    return this.endBestLength();
                }
            }
            this.bestLen = n;
            Region region = this.msaRegion;
            if (region != null) {
                this.msaBegin = (this.pkeep > this.s ? this.s : this.pkeep) - this.str;
                region.setBeg(0, this.msaBegin);
                this.msaEnd = this.s - this.str;
                region.setEnd(0, this.msaEnd);
                for (int i2 = 1; i2 <= this.regex.numMem; ++i2) {
                    int me = this.repeatStk[this.memEndStk + i2];
                    if (me != -1) {
                        int ms = this.repeatStk[this.memStartStk + i2];
                        region.setBeg(i2, (BitStatus.bsAt(this.regex.btMemStart, i2) ? this.stack[ms].getMemPStr() : ms) - this.str);
                        region.setEnd(i2, (BitStatus.bsAt(this.regex.btMemEnd, i2) ? this.stack[me].getMemPStr() : me) - this.str);
                        continue;
                    }
                    region.setBeg(i2, -1);
                    region.setEnd(i2, -1);
                }
                if (Config.USE_CAPTURE_HISTORY && this.regex.captureHistory != 0) {
                    this.checkCaptureHistory(region);
                }
            } else {
                this.msaBegin = (this.pkeep > this.s ? this.s : this.pkeep) - this.str;
                this.msaEnd = this.s - this.str;
            }
        } else {
            Region region = this.msaRegion;
            if (region != null) {
                region.clear();
            } else {
                this.msaEnd = 0;
                this.msaBegin = 0;
            }
        }
        return this.endBestLength();
    }

    private boolean endBestLength() {
        if (Option.isFindCondition(this.regex.options)) {
            if (Option.isFindNotEmpty(this.regex.options) && this.s == this.sstart) {
                this.bestLen = -1;
                this.opFail();
                return false;
            }
            if (Option.isFindLongest(this.regex.options) && this.s < this.range) {
                this.opFail();
                return false;
            }
        }
        return true;
    }

    private void opExact1() {
        if (this.s >= this.range || this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
        } else {
            ++this.ip;
            ++this.s;
            this.sprev = this.sbegin;
        }
    }

    private void opExact2() {
        if (this.s + 2 > this.range || this.code[this.ip] != this.bytes[this.s] || this.code[++this.ip] != this.bytes[++this.s]) {
            this.opFail();
        } else {
            this.sprev = this.s++;
            ++this.ip;
        }
    }

    private void opExact3() {
        if (this.s + 3 > this.range || this.code[this.ip] != this.bytes[this.s] || this.code[++this.ip] != this.bytes[++this.s] || this.code[++this.ip] != this.bytes[++this.s]) {
            this.opFail();
        } else {
            this.sprev = this.s++;
            ++this.ip;
        }
    }

    private void opExact4() {
        if (this.s + 4 > this.range || this.code[this.ip] != this.bytes[this.s] || this.code[++this.ip] != this.bytes[++this.s] || this.code[++this.ip] != this.bytes[++this.s] || this.code[++this.ip] != this.bytes[++this.s]) {
            this.opFail();
        } else {
            this.sprev = this.s++;
            ++this.ip;
        }
    }

    private void opExact5() {
        if (this.s + 5 > this.range || this.code[this.ip] != this.bytes[this.s] || this.code[++this.ip] != this.bytes[++this.s] || this.code[++this.ip] != this.bytes[++this.s] || this.code[++this.ip] != this.bytes[++this.s] || this.code[++this.ip] != this.bytes[++this.s]) {
            this.opFail();
        } else {
            this.sprev = this.s++;
            ++this.ip;
        }
    }

    private void opExactN() {
        int tlen;
        if (this.s + (tlen = this.code[this.ip++]) > this.range) {
            this.opFail();
            return;
        }
        if (Config.USE_STRING_TEMPLATES) {
            byte[] bs = this.regex.templates[this.code[this.ip++]];
            int ps = this.code[this.ip++];
            while (tlen-- > 0) {
                if (bs[ps++] == this.bytes[this.s++]) continue;
                this.opFail();
                return;
            }
        } else {
            while (tlen-- > 0) {
                if (this.code[this.ip++] == this.bytes[this.s++]) continue;
                this.opFail();
                return;
            }
        }
        this.sprev = this.s - 1;
    }

    private void opExactMB2N1() {
        if (this.s + 2 > this.range || this.code[this.ip] != this.bytes[this.s] || this.code[++this.ip] != this.bytes[++this.s]) {
            this.opFail();
        } else {
            ++this.ip;
            ++this.s;
            this.sprev = this.sbegin;
        }
    }

    private void opExactMB2N2() {
        if (this.s + 4 > this.range || this.code[this.ip] != this.bytes[this.s] || this.code[++this.ip] != this.bytes[++this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        this.sprev = this.s;
        if (this.code[this.ip] != this.bytes[this.s] || this.code[++this.ip] != this.bytes[++this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
    }

    private void opExactMB2N3() {
        if (this.s + 6 > this.range || this.code[this.ip] != this.bytes[this.s] || this.code[++this.ip] != this.bytes[++this.s] || this.code[++this.ip] != this.bytes[++this.s] || this.code[++this.ip] != this.bytes[++this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        this.sprev = this.s;
        if (this.code[this.ip] != this.bytes[this.s] || this.code[++this.ip] != this.bytes[++this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
    }

    private void opExactMB2N() {
        int tlen;
        if (this.s + (tlen = this.code[this.ip++]) * 2 > this.range) {
            this.opFail();
            return;
        }
        if (Config.USE_STRING_TEMPLATES) {
            byte[] bs = this.regex.templates[this.code[this.ip++]];
            int ps = this.code[this.ip++];
            while (tlen-- > 0) {
                if (bs[ps] != this.bytes[this.s] || bs[++ps] != this.bytes[++this.s]) {
                    this.opFail();
                    return;
                }
                ++ps;
                ++this.s;
            }
        } else {
            while (tlen-- > 0) {
                if (this.code[this.ip] != this.bytes[this.s] || this.code[++this.ip] != this.bytes[++this.s]) {
                    this.opFail();
                    return;
                }
                ++this.ip;
                ++this.s;
            }
        }
        this.sprev = this.s - 2;
    }

    private void opExactMB3N() {
        int tlen;
        if (this.s + (tlen = this.code[this.ip++]) * 3 > this.range) {
            this.opFail();
            return;
        }
        if (Config.USE_STRING_TEMPLATES) {
            byte[] bs = this.regex.templates[this.code[this.ip++]];
            int ps = this.code[this.ip++];
            while (tlen-- > 0) {
                if (bs[ps] != this.bytes[this.s] || bs[++ps] != this.bytes[++this.s] || bs[++ps] != this.bytes[++this.s]) {
                    this.opFail();
                    return;
                }
                ++ps;
                ++this.s;
            }
        } else {
            while (tlen-- > 0) {
                if (this.code[this.ip] != this.bytes[this.s] || this.code[++this.ip] != this.bytes[++this.s] || this.code[++this.ip] != this.bytes[++this.s]) {
                    this.opFail();
                    return;
                }
                ++this.ip;
                ++this.s;
            }
        }
        this.sprev = this.s - 3;
    }

    private void opExactMBN() {
        int tlen = this.code[this.ip++];
        int tlen2 = this.code[this.ip++];
        if (this.s + (tlen2 *= tlen) > this.range) {
            this.opFail();
            return;
        }
        if (Config.USE_STRING_TEMPLATES) {
            byte[] bs = this.regex.templates[this.code[this.ip++]];
            int ps = this.code[this.ip++];
            while (tlen2-- > 0) {
                if (bs[ps] != this.bytes[this.s]) {
                    this.opFail();
                    return;
                }
                ++ps;
                ++this.s;
            }
        } else {
            while (tlen2-- > 0) {
                if (this.code[this.ip] != this.bytes[this.s]) {
                    this.opFail();
                    return;
                }
                ++this.ip;
                ++this.s;
            }
        }
        this.sprev = this.s - tlen;
    }

    private void opExact1IC() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        byte[] lowbuf = this.cfbuf();
        this.value = this.s;
        int len = this.enc.mbcCaseFold(this.regex.caseFoldFlag, this.bytes, this, this.end, lowbuf);
        this.s = this.value;
        if (this.s > this.range) {
            this.opFail();
            return;
        }
        int q = 0;
        while (len-- > 0) {
            if (this.code[this.ip] != lowbuf[q]) {
                this.opFail();
                return;
            }
            ++this.ip;
            ++q;
        }
        this.sprev = this.sbegin;
    }

    private void opExact1ICSb() {
        if (this.s >= this.range || this.code[this.ip] != this.enc.toLowerCaseTable()[this.bytes[this.s++] & 0xFF]) {
            this.opFail();
            return;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opExactNIC() {
        int tlen = this.code[this.ip++];
        byte[] lowbuf = this.cfbuf();
        if (Config.USE_STRING_TEMPLATES) {
            byte[] bs = this.regex.templates[this.code[this.ip++]];
            int ps = this.code[this.ip++];
            int endp = ps + tlen;
            while (ps < endp) {
                this.sprev = this.s;
                if (this.s >= this.range) {
                    this.opFail();
                    return;
                }
                this.value = this.s;
                int len = this.enc.mbcCaseFold(this.regex.caseFoldFlag, this.bytes, this, this.end, lowbuf);
                this.s = this.value;
                if (this.s > this.range) {
                    this.opFail();
                    return;
                }
                int q = 0;
                while (len-- > 0) {
                    if (bs[ps] != lowbuf[q]) {
                        this.opFail();
                        return;
                    }
                    ++ps;
                    ++q;
                }
            }
        } else {
            int endp = this.ip + tlen;
            while (this.ip < endp) {
                this.sprev = this.s;
                if (this.s >= this.range) {
                    this.opFail();
                    return;
                }
                this.value = this.s;
                int len = this.enc.mbcCaseFold(this.regex.caseFoldFlag, this.bytes, this, this.end, lowbuf);
                this.s = this.value;
                if (this.s > this.range) {
                    this.opFail();
                    return;
                }
                int q = 0;
                while (len-- > 0) {
                    if (this.code[this.ip] != lowbuf[q]) {
                        this.opFail();
                        return;
                    }
                    ++this.ip;
                    ++q;
                }
            }
        }
    }

    private void opExactNICSb() {
        int tlen;
        if (this.s + (tlen = this.code[this.ip++]) > this.range) {
            this.opFail();
            return;
        }
        byte[] toLowerTable = this.enc.toLowerCaseTable();
        if (Config.USE_STRING_TEMPLATES) {
            byte[] bs = this.regex.templates[this.code[this.ip++]];
            int ps = this.code[this.ip++];
            while (tlen-- > 0) {
                if (bs[ps++] == toLowerTable[this.bytes[this.s++] & 0xFF]) continue;
                this.opFail();
                return;
            }
        } else {
            while (tlen-- > 0) {
                if (this.code[this.ip++] == toLowerTable[this.bytes[this.s++] & 0xFF]) continue;
                this.opFail();
                return;
            }
        }
        this.sprev = this.s - 1;
    }

    private void opCondition() {
        int mem = this.code[this.ip++];
        int addr2 = this.code[this.ip++];
        if (mem > this.regex.numMem || this.repeatStk[this.memEndStk + mem] == -1 || this.repeatStk[this.memStartStk + mem] == -1) {
            this.ip += addr2;
        }
    }

    private boolean isInBitSet() {
        int c = this.bytes[this.s] & 0xFF;
        return (this.code[this.ip + (c >>> BitSet.ROOM_SHIFT)] & 1 << c) != 0;
    }

    private void opCClass() {
        if (this.s >= this.range || !this.isInBitSet()) {
            this.opFail();
            return;
        }
        this.ip += 8;
        this.s += this.enc.length(this.bytes, this.s, this.end);
        if (this.s > this.end) {
            this.s = this.end;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassSb() {
        if (this.s >= this.range || !this.isInBitSet()) {
            this.opFail();
            return;
        }
        this.ip += 8;
        ++this.s;
        this.sprev = this.sbegin;
    }

    private boolean isInClassMB() {
        int tlen = this.code[this.ip++];
        if (this.s >= this.range) {
            return false;
        }
        int mbLen = this.enc.length(this.bytes, this.s, this.end);
        if (this.s + mbLen > this.range) {
            return false;
        }
        int ss = this.s;
        this.s += mbLen;
        int c = this.enc.mbcToCode(this.bytes, ss, this.s);
        if (!CodeRange.isInCodeRange(this.code, this.ip, c)) {
            return false;
        }
        this.ip += tlen;
        return true;
    }

    private void opCClassMB() {
        if (this.s >= this.range || !this.enc.isMbcHead(this.bytes, this.s, this.end)) {
            this.opFail();
            return;
        }
        if (!this.isInClassMB()) {
            this.opFail();
            return;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassMBSb() {
        this.opFail();
    }

    private void opCClassMIX() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        if (this.enc.isMbcHead(this.bytes, this.s, this.end)) {
            this.ip += 8;
            if (!this.isInClassMB()) {
                this.opFail();
                return;
            }
        } else {
            if (!this.isInBitSet()) {
                this.opFail();
                return;
            }
            this.ip += 8;
            int tlen = this.code[this.ip++];
            this.ip += tlen;
            ++this.s;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassMIXSb() {
        if (this.s >= this.range || !this.isInBitSet()) {
            this.opFail();
            return;
        }
        this.ip += 8;
        int tlen = this.code[this.ip++];
        this.ip += tlen;
        ++this.s;
        this.sprev = this.sbegin;
    }

    private void opCClassNot() {
        if (this.s >= this.range || this.isInBitSet()) {
            this.opFail();
            return;
        }
        this.ip += 8;
        this.s += this.enc.length(this.bytes, this.s, this.end);
        if (this.s > this.end) {
            this.s = this.end;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassNotSb() {
        if (this.s >= this.range || this.isInBitSet()) {
            this.opFail();
            return;
        }
        this.ip += 8;
        ++this.s;
        this.sprev = this.sbegin;
    }

    private boolean isNotInClassMB() {
        int tlen = this.code[this.ip++];
        int mbLen = this.enc.length(this.bytes, this.s, this.end);
        if (this.s + mbLen > this.range) {
            if (this.s >= this.range) {
                return false;
            }
            this.s = this.end;
            this.ip += tlen;
            return true;
        }
        int ss = this.s;
        this.s += mbLen;
        int c = this.enc.mbcToCode(this.bytes, ss, this.s);
        if (CodeRange.isInCodeRange(this.code, this.ip, c)) {
            return false;
        }
        this.ip += tlen;
        return true;
    }

    private void opCClassMBNot() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        if (!this.enc.isMbcHead(this.bytes, this.s, this.end)) {
            ++this.s;
            int tlen = this.code[this.ip++];
            this.ip += tlen;
            this.sprev = this.sbegin;
            return;
        }
        if (!this.isNotInClassMB()) {
            this.opFail();
            return;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassMBNotSb() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        ++this.s;
        int tlen = this.code[this.ip++];
        this.ip += tlen;
        this.sprev = this.sbegin;
    }

    private void opCClassMIXNot() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        if (this.enc.isMbcHead(this.bytes, this.s, this.end)) {
            this.ip += 8;
            if (!this.isNotInClassMB()) {
                this.opFail();
                return;
            }
        } else {
            if (this.isInBitSet()) {
                this.opFail();
                return;
            }
            this.ip += 8;
            int tlen = this.code[this.ip++];
            this.ip += tlen;
            ++this.s;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassMIXNotSb() {
        if (this.s >= this.range || this.isInBitSet()) {
            this.opFail();
            return;
        }
        this.ip += 8;
        ++this.s;
        int tlen = this.code[this.ip++];
        this.ip += tlen;
        this.sprev = this.sbegin;
    }

    private void opAnyChar() {
        int n;
        if (this.s >= this.range || this.s + (n = this.enc.length(this.bytes, this.s, this.end)) > this.range || this.enc.isNewLine(this.bytes, this.s, this.end)) {
            this.opFail();
            return;
        }
        this.s += n;
        this.sprev = this.sbegin;
    }

    private void opAnyCharSb() {
        if (this.s >= this.range || this.bytes[this.s] == 10) {
            this.opFail();
            return;
        }
        ++this.s;
        this.sprev = this.sbegin;
    }

    private void opAnyCharML() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        int n = this.enc.length(this.bytes, this.s, this.end);
        if (this.s + n > this.range) {
            this.opFail();
            return;
        }
        this.s += n;
        this.sprev = this.sbegin;
    }

    private void opAnyCharMLSb() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        ++this.s;
        this.sprev = this.sbegin;
    }

    private void opAnyCharStar() {
        byte[] bytes2 = this.bytes;
        while (this.s < this.range) {
            this.pushAlt(this.ip, this.s, this.sprev, this.pkeep);
            int n = this.enc.length(bytes2, this.s, this.end);
            if (this.s + n > this.range) {
                this.opFail();
                return;
            }
            if (this.enc.isNewLine(bytes2, this.s, this.end)) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n;
        }
    }

    private void opAnyCharStarSb() {
        byte[] bytes2 = this.bytes;
        while (this.s < this.range) {
            this.pushAlt(this.ip, this.s, this.sprev, this.pkeep);
            if (bytes2[this.s] == 10) {
                this.opFail();
                return;
            }
            this.sprev = this.s++;
        }
    }

    private void opAnyCharMLStar() {
        byte[] bytes2 = this.bytes;
        while (this.s < this.range) {
            this.pushAlt(this.ip, this.s, this.sprev, this.pkeep);
            int n = this.enc.length(bytes2, this.s, this.end);
            if (this.s + n > this.range) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n;
        }
    }

    private void opAnyCharMLStarSb() {
        while (this.s < this.range) {
            this.pushAlt(this.ip, this.s, this.sprev, this.pkeep);
            this.sprev = this.s++;
        }
    }

    private void opAnyCharStarPeekNext() {
        byte c = (byte)this.code[this.ip];
        byte[] bytes2 = this.bytes;
        while (this.s < this.range) {
            int n;
            if (c == bytes2[this.s]) {
                this.pushAlt(this.ip + 1, this.s, this.sprev, this.pkeep);
            }
            if (this.s + (n = this.enc.length(bytes2, this.s, this.end)) > this.range || this.enc.isNewLine(bytes2, this.s, this.end)) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opAnyCharStarPeekNextSb() {
        byte c = (byte)this.code[this.ip];
        byte[] bytes2 = this.bytes;
        while (this.s < this.range) {
            byte b2 = bytes2[this.s];
            if (c == b2) {
                this.pushAlt(this.ip + 1, this.s, this.sprev, this.pkeep);
            }
            if (b2 == 10) {
                this.opFail();
                return;
            }
            this.sprev = this.s++;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opAnyCharMLStarPeekNext() {
        byte c = (byte)this.code[this.ip];
        byte[] bytes2 = this.bytes;
        while (this.s < this.range) {
            int n;
            if (c == bytes2[this.s]) {
                this.pushAlt(this.ip + 1, this.s, this.sprev, this.pkeep);
            }
            if (this.s + (n = this.enc.length(bytes2, this.s, this.end)) > this.range) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opAnyCharMLStarPeekNextSb() {
        byte c = (byte)this.code[this.ip];
        byte[] bytes2 = this.bytes;
        while (this.s < this.range) {
            if (c == bytes2[this.s]) {
                this.pushAlt(this.ip + 1, this.s, this.sprev, this.pkeep);
            }
            this.sprev = this.s++;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opStateCheckAnyCharStar() {
        int mem = this.code[this.ip++];
        byte[] bytes2 = this.bytes;
        while (this.s < this.range) {
            if (this.stateCheckVal(this.s, mem)) {
                this.opFail();
                return;
            }
            this.pushAltWithStateCheck(this.ip, this.s, this.sprev, mem, this.pkeep);
            int n = this.enc.length(bytes2, this.s, this.end);
            if (this.s + n > this.range || this.enc.isNewLine(bytes2, this.s, this.end)) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n;
        }
        this.sprev = this.sbegin;
    }

    private void opStateCheckAnyCharStarSb() {
        int mem = this.code[this.ip++];
        byte[] bytes2 = this.bytes;
        while (this.s < this.range) {
            if (this.stateCheckVal(this.s, mem)) {
                this.opFail();
                return;
            }
            this.pushAltWithStateCheck(this.ip, this.s, this.sprev, mem, this.pkeep);
            if (bytes2[this.s] == 10) {
                this.opFail();
                return;
            }
            this.sprev = this.s++;
        }
        this.sprev = this.sbegin;
    }

    private void opStateCheckAnyCharMLStar() {
        int mem = this.code[this.ip++];
        byte[] bytes2 = this.bytes;
        while (this.s < this.range) {
            if (this.stateCheckVal(this.s, mem)) {
                this.opFail();
                return;
            }
            this.pushAltWithStateCheck(this.ip, this.s, this.sprev, mem, this.pkeep);
            int n = this.enc.length(bytes2, this.s, this.end);
            if (this.s + n > this.range) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n;
        }
        this.sprev = this.sbegin;
    }

    private void opStateCheckAnyCharMLStarSb() {
        int mem = this.code[this.ip++];
        while (this.s < this.range) {
            if (this.stateCheckVal(this.s, mem)) {
                this.opFail();
                return;
            }
            this.pushAltWithStateCheck(this.ip, this.s, this.sprev, mem, this.pkeep);
            this.sprev = this.s++;
        }
        this.sprev = this.sbegin;
    }

    private void opWord() {
        if (this.s >= this.range || !this.enc.isMbcWord(this.bytes, this.s, this.end)) {
            this.opFail();
            return;
        }
        this.s += this.enc.length(this.bytes, this.s, this.end);
        this.sprev = this.sbegin;
    }

    private void opWordSb() {
        if (this.s >= this.range || !this.enc.isWord(this.bytes[this.s] & 0xFF)) {
            this.opFail();
            return;
        }
        ++this.s;
        this.sprev = this.sbegin;
    }

    private void opAsciiWord() {
        if (this.s >= this.range || !ByteCodeMachine.isMbcAsciiWord(this.enc, this.bytes, this.s, this.end)) {
            this.opFail();
            return;
        }
        this.s += this.enc.length(this.bytes, this.s, this.end);
        this.sprev = this.sbegin;
    }

    private void opNotWord() {
        if (this.s >= this.range || this.enc.isMbcWord(this.bytes, this.s, this.end)) {
            this.opFail();
            return;
        }
        this.s += this.enc.length(this.bytes, this.s, this.end);
        this.sprev = this.sbegin;
    }

    private void opNotWordSb() {
        if (this.s >= this.range || this.enc.isWord(this.bytes[this.s] & 0xFF)) {
            this.opFail();
            return;
        }
        ++this.s;
        this.sprev = this.sbegin;
    }

    private void opNotAsciiWord() {
        if (this.s >= this.range || ByteCodeMachine.isMbcAsciiWord(this.enc, this.bytes, this.s, this.end)) {
            this.opFail();
            return;
        }
        this.s += this.enc.length(this.bytes, this.s, this.end);
        this.sprev = this.sbegin;
    }

    private void opWordBound() {
        if (this.s == this.str) {
            if (this.s >= this.range || !this.enc.isMbcWord(this.bytes, this.s, this.end)) {
                this.opFail();
                return;
            }
        } else if (this.s == this.end) {
            if (this.sprev >= this.end || !this.enc.isMbcWord(this.bytes, this.sprev, this.end)) {
                this.opFail();
                return;
            }
        } else if (this.enc.isMbcWord(this.bytes, this.s, this.end) == this.enc.isMbcWord(this.bytes, this.sprev, this.end)) {
            this.opFail();
            return;
        }
    }

    private void opWordBoundSb() {
        if (this.s == this.str) {
            if (this.s >= this.range || !this.enc.isWord(this.bytes[this.s] & 0xFF)) {
                this.opFail();
                return;
            }
        } else if (this.s == this.end) {
            if (this.sprev >= this.end || !this.enc.isWord(this.bytes[this.sprev] & 0xFF)) {
                this.opFail();
                return;
            }
        } else if (this.enc.isWord(this.bytes[this.s] & 0xFF) == this.enc.isWord(this.bytes[this.sprev] & 0xFF)) {
            this.opFail();
            return;
        }
    }

    private void opAsciiWordBound() {
        if (this.s == this.str) {
            if (this.s >= this.range || !ByteCodeMachine.isMbcAsciiWord(this.enc, this.bytes, this.s, this.end)) {
                this.opFail();
                return;
            }
        } else if (this.s == this.end) {
            if (this.sprev >= this.end || !ByteCodeMachine.isMbcAsciiWord(this.enc, this.bytes, this.sprev, this.end)) {
                this.opFail();
                return;
            }
        } else if (ByteCodeMachine.isMbcAsciiWord(this.enc, this.bytes, this.s, this.end) == ByteCodeMachine.isMbcAsciiWord(this.enc, this.bytes, this.sprev, this.end)) {
            this.opFail();
            return;
        }
    }

    private void opNotWordBound() {
        if (this.s == this.str) {
            if (this.s < this.range && this.enc.isMbcWord(this.bytes, this.s, this.end)) {
                this.opFail();
                return;
            }
        } else if (this.s == this.end) {
            if (this.sprev < this.end && this.enc.isMbcWord(this.bytes, this.sprev, this.end)) {
                this.opFail();
                return;
            }
        } else if (this.enc.isMbcWord(this.bytes, this.s, this.end) != this.enc.isMbcWord(this.bytes, this.sprev, this.end)) {
            this.opFail();
            return;
        }
    }

    private void opNotWordBoundSb() {
        if (this.s == this.str) {
            if (this.s < this.range && this.enc.isWord(this.bytes[this.s] & 0xFF)) {
                this.opFail();
                return;
            }
        } else if (this.s == this.end) {
            if (this.sprev < this.end && this.enc.isWord(this.bytes[this.sprev] & 0xFF)) {
                this.opFail();
                return;
            }
        } else if (this.enc.isWord(this.bytes[this.s] & 0xFF) != this.enc.isWord(this.bytes[this.sprev] & 0xFF)) {
            this.opFail();
            return;
        }
    }

    private void opNotAsciiWordBound() {
        if (this.s == this.str) {
            if (this.s < this.range && ByteCodeMachine.isMbcAsciiWord(this.enc, this.bytes, this.s, this.end)) {
                this.opFail();
                return;
            }
        } else if (this.s == this.end) {
            if (this.sprev < this.end && ByteCodeMachine.isMbcAsciiWord(this.enc, this.bytes, this.sprev, this.end)) {
                this.opFail();
                return;
            }
        } else if (ByteCodeMachine.isMbcAsciiWord(this.enc, this.bytes, this.s, this.end) != ByteCodeMachine.isMbcAsciiWord(this.enc, this.bytes, this.sprev, this.end)) {
            this.opFail();
            return;
        }
    }

    private void opWordBegin() {
        if (this.s < this.range && this.enc.isMbcWord(this.bytes, this.s, this.end) && (this.s == this.str || !this.enc.isMbcWord(this.bytes, this.sprev, this.end))) {
            return;
        }
        this.opFail();
    }

    private void opWordBeginSb() {
        if (this.s < this.range && this.enc.isWord(this.bytes[this.s] & 0xFF) && (this.s == this.str || !this.enc.isWord(this.bytes[this.sprev] & 0xFF))) {
            return;
        }
        this.opFail();
    }

    private void opAsciiWordBegin() {
        if (this.s < this.range && ByteCodeMachine.isMbcAsciiWord(this.enc, this.bytes, this.s, this.end) && (this.s == this.str || !ByteCodeMachine.isMbcAsciiWord(this.enc, this.bytes, this.sprev, this.end))) {
            return;
        }
        this.opFail();
    }

    private void opWordEnd() {
        if (this.s != this.str && this.enc.isMbcWord(this.bytes, this.sprev, this.end) && (this.s == this.end || !this.enc.isMbcWord(this.bytes, this.s, this.end))) {
            return;
        }
        this.opFail();
    }

    private void opWordEndSb() {
        if (this.s != this.str && this.enc.isWord(this.bytes[this.sprev] & 0xFF) && (this.s == this.end || !this.enc.isWord(this.bytes[this.s] & 0xFF))) {
            return;
        }
        this.opFail();
    }

    private void opAsciiWordEnd() {
        if (this.s != this.str && ByteCodeMachine.isMbcAsciiWord(this.enc, this.bytes, this.sprev, this.end) && (this.s == this.end || !ByteCodeMachine.isMbcAsciiWord(this.enc, this.bytes, this.s, this.end))) {
            return;
        }
        this.opFail();
    }

    private void opBeginBuf() {
        if (this.s != this.str) {
            this.opFail();
        }
    }

    private void opEndBuf() {
        if (this.s != this.end) {
            this.opFail();
        }
    }

    private void opBeginLine() {
        if (this.s == this.str) {
            if (Option.isNotBol(this.msaOptions)) {
                this.opFail();
            }
            return;
        }
        if (this.enc.isNewLine(this.bytes, this.sprev, this.end) && this.s != this.end) {
            return;
        }
        this.opFail();
    }

    private void opBeginLineSb() {
        if (this.s == this.str) {
            if (Option.isNotBol(this.msaOptions)) {
                this.opFail();
            }
            return;
        }
        if (this.bytes[this.sprev] == 10 && this.s != this.end) {
            return;
        }
        this.opFail();
    }

    private void opEndLine() {
        if (this.s == this.end) {
            if (Config.USE_NEWLINE_AT_END_OF_STRING_HAS_EMPTY_LINE) {
                if ((this.str == this.end || !this.enc.isNewLine(this.bytes, this.sprev, this.end)) && Option.isNotEol(this.msaOptions)) {
                    this.opFail();
                }
                return;
            }
            if (Option.isNotEol(this.msaOptions)) {
                this.opFail();
            }
            return;
        }
        if (this.enc.isNewLine(this.bytes, this.s, this.end)) {
            return;
        }
        this.opFail();
    }

    private void opEndLineSb() {
        if (this.s == this.end) {
            if (Config.USE_NEWLINE_AT_END_OF_STRING_HAS_EMPTY_LINE) {
                if ((this.str == this.end || this.sprev >= this.end || this.bytes[this.sprev] != 10) && Option.isNotEol(this.msaOptions)) {
                    this.opFail();
                }
                return;
            }
            if (Option.isNotEol(this.msaOptions)) {
                this.opFail();
            }
            return;
        }
        if (this.bytes[this.s] == 10) {
            return;
        }
        this.opFail();
    }

    private void opSemiEndBuf() {
        if (this.s == this.end) {
            if (Config.USE_NEWLINE_AT_END_OF_STRING_HAS_EMPTY_LINE) {
                if ((this.str == this.end || !this.enc.isNewLine(this.bytes, this.sprev, this.end)) && Option.isNotEol(this.msaOptions)) {
                    this.opFail();
                }
                return;
            }
            if (Option.isNotEol(this.msaOptions)) {
                this.opFail();
            }
            return;
        }
        if (this.enc.isNewLine(this.bytes, this.s, this.end) && this.s + this.enc.length(this.bytes, this.s, this.end) == this.end) {
            return;
        }
        this.opFail();
    }

    private void opBeginPosition() {
        if (this.s != this.msaGpos) {
            this.opFail();
        }
    }

    private void opMemoryStartPush() {
        int mem = this.code[this.ip++];
        this.pushMemStart(mem, this.s);
    }

    private void opMemoryStart() {
        int mem = this.code[this.ip++];
        this.repeatStk[this.memStartStk + mem] = this.s;
        this.repeatStk[this.memEndStk + mem] = -1;
    }

    private void opMemoryEndPush() {
        int mem = this.code[this.ip++];
        this.pushMemEnd(mem, this.s);
    }

    private void opMemoryEnd() {
        int mem = this.code[this.ip++];
        this.repeatStk[this.memEndStk + mem] = this.s;
    }

    private void opKeep() {
        this.pkeep = this.s;
    }

    private void opMemoryEndPushRec() {
        int mem = this.code[this.ip++];
        int stkp = this.getMemStart(mem);
        this.pushMemEnd(mem, this.s);
        this.repeatStk[this.memStartStk + mem] = stkp;
    }

    private void opMemoryEndRec() {
        int mem = this.code[this.ip++];
        this.repeatStk[this.memEndStk + mem] = this.s;
        int stkp = this.getMemStart(mem);
        this.repeatStk[this.memStartStk + mem] = BitStatus.bsAt(this.regex.btMemStart, mem) ? stkp : this.stack[stkp].getMemPStr();
        this.pushMemEndMark(mem);
    }

    private boolean backrefInvalid(int mem) {
        return this.repeatStk[this.memEndStk + mem] == -1 || this.repeatStk[this.memStartStk + mem] == -1;
    }

    private int backrefStart(int mem) {
        int ms = this.repeatStk[this.memStartStk + mem];
        return BitStatus.bsAt(this.regex.btMemStart, mem) ? this.stack[ms].getMemPStr() : ms;
    }

    private int backrefEnd(int mem) {
        int me = this.repeatStk[this.memEndStk + mem];
        return BitStatus.bsAt(this.regex.btMemEnd, mem) ? this.stack[me].getMemPStr() : me;
    }

    private void backref(int mem) {
        if (mem > this.regex.numMem || this.backrefInvalid(mem)) {
            this.opFail();
            return;
        }
        int pstart = this.backrefStart(mem);
        int pend = this.backrefEnd(mem);
        int n = pend - pstart;
        if (this.s + n > this.range) {
            this.opFail();
            return;
        }
        this.sprev = this.s;
        while (n-- > 0) {
            if (this.bytes[pstart++] == this.bytes[this.s++]) continue;
            this.opFail();
            return;
        }
        if (this.sprev < this.range) {
            int len;
            while (this.sprev + (len = this.enc.length(this.bytes, this.sprev, this.end)) < this.s) {
                this.sprev += len;
            }
        }
    }

    private void opBackRef1() {
        this.backref(1);
    }

    private void opBackRef2() {
        this.backref(2);
    }

    private void opBackRefN() {
        this.backref(this.code[this.ip++]);
    }

    private void opBackRefNIC() {
        int mem;
        if ((mem = this.code[this.ip++]) > this.regex.numMem || this.backrefInvalid(mem)) {
            this.opFail();
            return;
        }
        int pstart = this.backrefStart(mem);
        int pend = this.backrefEnd(mem);
        int n = pend - pstart;
        if (this.s + n > this.range) {
            this.opFail();
            return;
        }
        this.sprev = this.s;
        this.value = this.s;
        if (!this.stringCmpIC(this.regex.caseFoldFlag, pstart, this, n, this.end)) {
            this.opFail();
            return;
        }
        this.s = this.value;
        if (this.sprev < this.range) {
            int len;
            while (this.sprev + (len = this.enc.length(this.bytes, this.sprev, this.end)) < this.s) {
                this.sprev += len;
            }
        }
    }

    private void opBackRefMulti() {
        int i2;
        int tlen = this.code[this.ip++];
        block0: for (i2 = 0; i2 < tlen; ++i2) {
            int mem;
            if (this.backrefInvalid(mem = this.code[this.ip++])) continue;
            int pstart = this.backrefStart(mem);
            int pend = this.backrefEnd(mem);
            int n = pend - pstart;
            if (this.s + n > this.range) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            int swork = this.s;
            while (n-- > 0) {
                if (this.bytes[pstart++] == this.bytes[swork++]) continue;
                continue block0;
            }
            this.s = swork;
            if (this.sprev < this.range) {
                int len;
                while (this.sprev + (len = this.enc.length(this.bytes, this.sprev, this.end)) < this.s) {
                    this.sprev += len;
                }
            }
            this.ip += tlen - i2 - 1;
            break;
        }
        if (i2 == tlen) {
            this.opFail();
            return;
        }
    }

    private void opBackRefMultiIC() {
        int i2;
        int tlen = this.code[this.ip++];
        for (i2 = 0; i2 < tlen; ++i2) {
            int mem;
            if (this.backrefInvalid(mem = this.code[this.ip++])) continue;
            int pstart = this.backrefStart(mem);
            int pend = this.backrefEnd(mem);
            int n = pend - pstart;
            if (this.s + n > this.range) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.value = this.s;
            if (!this.stringCmpIC(this.regex.caseFoldFlag, pstart, this, n, this.end)) continue;
            this.s = this.value;
            if (this.sprev < this.range) {
                int len;
                while (this.sprev + (len = this.enc.length(this.bytes, this.sprev, this.end)) < this.s) {
                    this.sprev += len;
                }
            }
            this.ip += tlen - i2 - 1;
            break;
        }
        if (i2 == tlen) {
            this.opFail();
            return;
        }
    }

    private boolean memIsInMemp(int mem, int num, int memp) {
        for (int i2 = 0; i2 < num; ++i2) {
            int m;
            if (mem != (m = this.code[memp++])) continue;
            return true;
        }
        return false;
    }

    private boolean backrefMatchAtNestedLevel(boolean ignoreCase, int caseFoldFlag, int nest, int memNum, int memp) {
        int pend = -1;
        int level2 = 0;
        for (int k = this.stk - 1; k >= 0; --k) {
            StackEntry e = this.stack[k];
            if (e.type == 2048) {
                --level2;
                continue;
            }
            if (e.type == 2304) {
                ++level2;
                continue;
            }
            if (level2 != nest) continue;
            if (e.type == 256) {
                if (!this.memIsInMemp(e.getMemNum(), memNum, memp)) continue;
                int pstart = e.getMemPStr();
                if (pend == -1) continue;
                if (pend - pstart > this.end - this.s) {
                    return false;
                }
                int p2 = pstart;
                this.value = this.s;
                if (ignoreCase) {
                    if (!this.stringCmpIC(caseFoldFlag, pstart, this, pend - pstart, this.end)) {
                        return false;
                    }
                } else {
                    while (p2 < pend) {
                        if (this.bytes[p2++] == this.bytes[this.value++]) continue;
                        return false;
                    }
                }
                this.s = this.value;
                return true;
            }
            if (e.type != 33280 || !this.memIsInMemp(e.getMemNum(), memNum, memp)) continue;
            pend = e.getMemPStr();
        }
        return false;
    }

    private void opBackRefAtLevel() {
        int ic = this.code[this.ip++];
        int level2 = this.code[this.ip++];
        int tlen = this.code[this.ip++];
        this.sprev = this.s;
        if (this.backrefMatchAtNestedLevel(ic != 0, this.regex.caseFoldFlag, level2, tlen, this.ip)) {
            if (this.sprev < this.range) {
                int len;
                while (this.sprev + (len = this.enc.length(this.bytes, this.sprev, this.end)) < this.s) {
                    this.sprev += len;
                }
            }
            this.ip += tlen;
        } else {
            this.opFail();
            return;
        }
    }

    private void opSetOptionPush() {
        this.pushAlt(this.ip, this.s, this.sprev, this.pkeep);
        this.ip += 3;
    }

    private void opSetOption() {
    }

    private void opNullCheckStart() {
        int mem = this.code[this.ip++];
        this.pushNullCheckStart(mem, this.s);
    }

    private void nullCheckFound() {
        switch (this.code[this.ip++]) {
            case 61: 
            case 62: {
                ++this.ip;
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                ++this.ip;
                break;
            }
            default: {
                throw new InternalException("unexpected bytecode (bug)");
            }
        }
    }

    private void opNullCheckEnd() {
        int mem;
        int isNull;
        if ((isNull = this.nullCheck(mem = this.code[this.ip++], this.s)) != 0) {
            if (Config.DEBUG_MATCH) {
                Config.log.println("NULL_CHECK_END: skip  id:" + mem + ", s:" + this.s);
            }
            this.nullCheckFound();
        }
    }

    private void opNullCheckEndMemST() {
        int mem;
        int isNull;
        if ((isNull = this.nullCheckMemSt(mem = this.code[this.ip++], this.s)) != 0) {
            if (Config.DEBUG_MATCH) {
                Config.log.println("NULL_CHECK_END_MEMST: skip  id:" + mem + ", s:" + this.s);
            }
            if (isNull == -1) {
                this.opFail();
                return;
            }
            this.nullCheckFound();
        }
    }

    private void opNullCheckEndMemSTPush() {
        int mem = this.code[this.ip++];
        int isNull = Config.USE_MONOMANIAC_CHECK_CAPTURES_IN_ENDLESS_REPEAT ? this.nullCheckMemStRec(mem, this.s) : this.nullCheckRec(mem, this.s);
        if (isNull != 0) {
            if (Config.DEBUG_MATCH) {
                Config.log.println("NULL_CHECK_END_MEMST_PUSH: skip  id:" + mem + ", s:" + this.s);
            }
            if (isNull == -1) {
                this.opFail();
                return;
            }
            this.nullCheckFound();
        } else {
            this.pushNullCheckEnd(mem);
        }
    }

    private void opJump() {
        this.ip += this.code[this.ip] + 1;
    }

    private void opPush() {
        int addr2 = this.code[this.ip++];
        this.pushAlt(this.ip + addr2, this.s, this.sprev, this.pkeep);
    }

    private void opStateCheckPush() {
        int mem;
        if (this.stateCheckVal(this.s, mem = this.code[this.ip++])) {
            this.opFail();
            return;
        }
        int addr2 = this.code[this.ip++];
        this.pushAltWithStateCheck(this.ip + addr2, this.s, this.sprev, mem, this.pkeep);
    }

    private void opStateCheckPushOrJump() {
        int mem = this.code[this.ip++];
        int addr2 = this.code[this.ip++];
        if (this.stateCheckVal(this.s, mem)) {
            this.ip += addr2;
        } else {
            this.pushAltWithStateCheck(this.ip + addr2, this.s, this.sprev, mem, this.pkeep);
        }
    }

    private void opStateCheck() {
        int mem;
        if (this.stateCheckVal(this.s, mem = this.code[this.ip++])) {
            this.opFail();
            return;
        }
        this.pushStateCheck(this.s, mem);
    }

    private void opPop() {
        this.popOne();
    }

    private void opPushOrJumpExact1() {
        int addr2 = this.code[this.ip++];
        if (this.s < this.range && this.code[this.ip] == this.bytes[this.s]) {
            ++this.ip;
            this.pushAlt(this.ip + addr2, this.s, this.sprev, this.pkeep);
            return;
        }
        this.ip += addr2 + 1;
    }

    private void opPushIfPeekNext() {
        int addr2 = this.code[this.ip++];
        if (this.s < this.range && this.code[this.ip] == this.bytes[this.s]) {
            ++this.ip;
            this.pushAlt(this.ip + addr2, this.s, this.sprev, this.pkeep);
            return;
        }
        ++this.ip;
    }

    private void opRepeat() {
        int mem = this.code[this.ip++];
        int addr2 = this.code[this.ip++];
        this.repeatStk[mem] = this.stk;
        this.pushRepeat(mem, this.ip);
        if (this.regex.repeatRangeLo[mem] == 0) {
            this.pushAlt(this.ip + addr2, this.s, this.sprev, this.pkeep);
        }
    }

    private void opRepeatNG() {
        int mem = this.code[this.ip++];
        int addr2 = this.code[this.ip++];
        this.repeatStk[mem] = this.stk;
        this.pushRepeat(mem, this.ip);
        if (this.regex.repeatRangeLo[mem] == 0) {
            this.pushAlt(this.ip, this.s, this.sprev, this.pkeep);
            this.ip += addr2;
        }
    }

    private void repeatInc(int mem, int si) {
        StackEntry e = this.stack[si];
        e.increaseRepeatCount();
        if (e.getRepeatCount() < this.regex.repeatRangeHi[mem]) {
            if (e.getRepeatCount() >= this.regex.repeatRangeLo[mem]) {
                this.pushAlt(this.ip, this.s, this.sprev, this.pkeep);
                this.ip = e.getRepeatPCode();
            } else {
                this.ip = e.getRepeatPCode();
            }
        }
        this.pushRepeatInc(si);
    }

    private void opRepeatInc() {
        int mem = this.code[this.ip++];
        int si = this.repeatStk[mem];
        this.repeatInc(mem, si);
    }

    private void opRepeatIncSG() {
        int mem = this.code[this.ip++];
        int si = this.getRepeat(mem);
        this.repeatInc(mem, si);
    }

    private void repeatIncNG(int mem, int si) {
        StackEntry e = this.stack[si];
        e.increaseRepeatCount();
        if (e.getRepeatCount() < this.regex.repeatRangeHi[mem]) {
            if (e.getRepeatCount() >= this.regex.repeatRangeLo[mem]) {
                int pcode = e.getRepeatPCode();
                this.pushRepeatInc(si);
                this.pushAlt(pcode, this.s, this.sprev, this.pkeep);
            } else {
                this.ip = e.getRepeatPCode();
                this.pushRepeatInc(si);
            }
        } else if (e.getRepeatCount() == this.regex.repeatRangeHi[mem]) {
            this.pushRepeatInc(si);
        }
    }

    private void opRepeatIncNG() {
        int mem = this.code[this.ip++];
        int si = this.repeatStk[mem];
        this.repeatIncNG(mem, si);
    }

    private void opRepeatIncNGSG() {
        int mem = this.code[this.ip++];
        int si = this.getRepeat(mem);
        this.repeatIncNG(mem, si);
    }

    private void opPushPos() {
        this.pushPos(this.s, this.sprev, this.pkeep);
    }

    private void opPopPos() {
        StackEntry e = this.stack[this.posEnd()];
        this.s = e.getStatePStr();
        this.sprev = e.getStatePStrPrev();
    }

    private void opPushPosNot() {
        int addr2 = this.code[this.ip++];
        this.pushPosNot(this.ip + addr2, this.s, this.sprev, this.pkeep);
    }

    private void opFailPos() {
        this.popTilPosNot();
        this.opFail();
    }

    private void opPushStopBT() {
        this.pushStopBT();
    }

    private void opPopStopBT() {
        this.stopBtEnd();
    }

    private void opLookBehind() {
        int tlen = this.code[this.ip++];
        this.s = this.enc.stepBack(this.bytes, this.str, this.s, this.end, tlen);
        if (this.s == -1) {
            this.opFail();
            return;
        }
        this.sprev = this.enc.prevCharHead(this.bytes, this.str, this.s, this.end);
    }

    private void opLookBehindSb() {
        int tlen = this.code[this.ip++];
        this.s -= tlen;
        if (this.s < this.str) {
            this.opFail();
            return;
        }
        this.sprev = this.s == this.str ? -1 : this.s - 1;
    }

    private void opPushLookBehindNot() {
        int tlen;
        int q;
        int addr2 = this.code[this.ip++];
        if ((q = this.enc.stepBack(this.bytes, this.str, this.s, this.end, tlen = this.code[this.ip++])) == -1) {
            this.ip += addr2;
        } else {
            this.pushLookBehindNot(this.ip + addr2, this.s, this.sprev, this.pkeep);
            this.s = q;
            this.sprev = this.enc.prevCharHead(this.bytes, this.str, this.s, this.end);
        }
    }

    private void opFailLookBehindNot() {
        this.popTilLookBehindNot();
        this.opFail();
    }

    private void opPushAbsentPos() {
        this.pushAbsentPos(this.s, this.range);
    }

    private void opAbsent() {
        int aend = this.range;
        int selfip = this.ip - 1;
        StackEntry e = this.stack[--this.stk];
        int absent = e.getAbsentStr();
        this.range = e.getAbsentEndStr();
        int addr2 = this.code[this.ip++];
        if (Config.DEBUG_MATCH) {
            System.out.println("ABSENT: s:" + this.s + " end:" + this.end + " absent:" + absent + " aend:" + aend);
        }
        if (absent > aend && this.s > absent) {
            this.pop();
            this.opFail();
            return;
        }
        if (this.s >= aend && this.s > absent) {
            if (this.s > aend || this.s > this.end) {
                this.opFail();
                return;
            }
            this.ip += addr2;
        } else {
            this.pushAlt(this.ip + addr2, this.s, this.sprev, this.pkeep);
            int n = this.s >= this.end ? 1 : this.enc.length(this.bytes, this.s, this.end);
            this.pushAbsentPos(absent, this.range);
            this.pushAlt(selfip, this.s + n, this.s, this.pkeep);
            this.pushAbsent();
            this.range = aend;
        }
    }

    private void opAbsentEnd() {
        if (this.sprev < this.range) {
            this.range = this.sprev;
        }
        if (Config.DEBUG_MATCH) {
            System.out.println("ABSENT_END: end:" + this.range);
        }
        this.popTilAbsent();
        this.opFail();
    }

    private void opCall() {
        int addr2 = this.code[this.ip++];
        this.pushCallFrame(this.ip);
        this.ip = addr2;
    }

    private void opReturn() {
        this.ip = this.sreturn();
        this.pushReturn();
    }

    private void opFail() {
        if (this.stack == null) {
            this.ip = this.regex.codeLength - 1;
            return;
        }
        StackEntry e = this.pop();
        this.ip = e.getStatePCode();
        this.s = e.getStatePStr();
        this.sprev = e.getStatePStrPrev();
        this.pkeep = e.getPKeep();
        if (Config.USE_CEC && ((SCStackEntry)e).getStateCheck() != 0) {
            e.type = 4096;
            ++this.stk;
        }
    }

    private int finish() {
        return this.bestLen;
    }

    private void debugMatchBegin() {
        Config.log.println("match_at: str: " + this.str + ", end: " + this.end + ", start: " + this.sstart + ", sprev: " + this.sprev);
        Config.log.println("size: " + (this.end - this.str) + ", start offset: " + (this.sstart - this.str));
    }

    private void debugMatchLoop() {
        int i2;
        Config.log.printf("%4d", this.s - this.str).print("> \"");
        int q = this.s;
        for (i2 = 0; i2 < 7 && q < this.end && this.s >= 0; ++i2) {
            int len = this.enc.length(this.bytes, q, this.end);
            while (len-- > 0) {
                if (q >= this.end) continue;
                Config.log.print(new String(this.bytes, q++, 1));
            }
        }
        String str = q < this.end ? "...\"" : "\"";
        q += str.length();
        Config.log.print(str);
        for (i2 = 0; i2 < 20 - (q - this.s); ++i2) {
            Config.log.print(" ");
        }
        StringBuilder sb = new StringBuilder();
        new ByteCodePrinter(this.regex).compiledByteCodeToString(sb, this.ip);
        Config.log.println(sb.toString());
    }
}

