// generated by diplomat-tool
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `Script`](https://docs.rs/icu/latest/icu/properties/props/struct.Script.html) for more information.
 */


export class Script {
    #value = undefined;

    static #values = new Map([
        ["Adlam", 167],
        ["Ahom", 161],
        ["AnatolianHieroglyphs", 156],
        ["Arabic", 2],
        ["Armenian", 3],
        ["Avestan", 117],
        ["Balinese", 62],
        ["Bamum", 130],
        ["BassaVah", 134],
        ["Batak", 63],
        ["Bengali", 4],
        ["Bhaiksuki", 168],
        ["Bopomofo", 5],
        ["Brahmi", 65],
        ["Braille", 46],
        ["Buginese", 55],
        ["Buhid", 44],
        ["CanadianAboriginal", 40],
        ["Carian", 104],
        ["CaucasianAlbanian", 159],
        ["Chakma", 118],
        ["Cham", 66],
        ["Cherokee", 6],
        ["Chorasmian", 189],
        ["Common", 0],
        ["Coptic", 7],
        ["Cuneiform", 101],
        ["Cypriot", 47],
        ["CyproMinoan", 193],
        ["Cyrillic", 8],
        ["Deseret", 9],
        ["Devanagari", 10],
        ["DivesAkuru", 190],
        ["Dogra", 178],
        ["Duployan", 135],
        ["EgyptianHieroglyphs", 71],
        ["Elbasan", 136],
        ["Elymaic", 185],
        ["Ethiopian", 11],
        ["Georgian", 12],
        ["Glagolitic", 56],
        ["Gothic", 13],
        ["Grantha", 137],
        ["Greek", 14],
        ["Gujarati", 15],
        ["GunjalaGondi", 179],
        ["Gurmukhi", 16],
        ["Han", 17],
        ["Hangul", 18],
        ["HanifiRohingya", 182],
        ["Hanunoo", 43],
        ["Hatran", 162],
        ["Hebrew", 19],
        ["Hiragana", 20],
        ["ImperialAramaic", 116],
        ["Inherited", 1],
        ["InscriptionalPahlavi", 122],
        ["InscriptionalParthian", 125],
        ["Javanese", 78],
        ["Kaithi", 120],
        ["Kannada", 21],
        ["Katakana", 22],
        ["Kawi", 198],
        ["KayahLi", 79],
        ["Kharoshthi", 57],
        ["KhitanSmallScript", 191],
        ["Khmer", 23],
        ["Khojki", 157],
        ["Khudawadi", 145],
        ["Lao", 24],
        ["Latin", 25],
        ["Lepcha", 82],
        ["Limbu", 48],
        ["LinearA", 83],
        ["LinearB", 49],
        ["Lisu", 131],
        ["Lycian", 107],
        ["Lydian", 108],
        ["Mahajani", 160],
        ["Makasar", 180],
        ["Malayalam", 26],
        ["Mandaic", 84],
        ["Manichaean", 121],
        ["Marchen", 169],
        ["MasaramGondi", 175],
        ["Medefaidrin", 181],
        ["MeeteiMayek", 115],
        ["MendeKikakui", 140],
        ["MeroiticCursive", 141],
        ["MeroiticHieroglyphs", 86],
        ["Miao", 92],
        ["Modi", 163],
        ["Mongolian", 27],
        ["Mro", 149],
        ["Multani", 164],
        ["Myanmar", 28],
        ["Nabataean", 143],
        ["NagMundari", 199],
        ["Nandinagari", 187],
        ["Nastaliq", 200],
        ["NewTaiLue", 59],
        ["Newa", 170],
        ["Nko", 87],
        ["Nushu", 150],
        ["NyiakengPuachueHmong", 186],
        ["Ogham", 29],
        ["OlChiki", 109],
        ["OldHungarian", 76],
        ["OldItalic", 30],
        ["OldNorthArabian", 142],
        ["OldPermic", 89],
        ["OldPersian", 61],
        ["OldSogdian", 184],
        ["OldSouthArabian", 133],
        ["OldTurkic", 88],
        ["OldUyghur", 194],
        ["Oriya", 31],
        ["Osage", 171],
        ["Osmanya", 50],
        ["PahawhHmong", 75],
        ["Palmyrene", 144],
        ["PauCinHau", 165],
        ["PhagsPa", 90],
        ["Phoenician", 91],
        ["PsalterPahlavi", 123],
        ["Rejang", 110],
        ["Runic", 32],
        ["Samaritan", 126],
        ["Saurashtra", 111],
        ["Sharada", 151],
        ["Shavian", 51],
        ["Siddham", 166],
        ["SignWriting", 112],
        ["Sinhala", 33],
        ["Sogdian", 183],
        ["SoraSompeng", 152],
        ["Soyombo", 176],
        ["Sundanese", 113],
        ["SylotiNagri", 58],
        ["Syriac", 34],
        ["Tagalog", 42],
        ["Tagbanwa", 45],
        ["TaiLe", 52],
        ["TaiTham", 106],
        ["TaiViet", 127],
        ["Takri", 153],
        ["Tamil", 35],
        ["Tangsa", 195],
        ["Tangut", 154],
        ["Telugu", 36],
        ["Thaana", 37],
        ["Thai", 38],
        ["Tibetan", 39],
        ["Tifinagh", 60],
        ["Tirhuta", 158],
        ["Toto", 196],
        ["Ugaritic", 53],
        ["Unknown", 103],
        ["Vai", 99],
        ["Vithkuqi", 197],
        ["Wancho", 188],
        ["WarangCiti", 146],
        ["Yezidi", 192],
        ["Yi", 41],
        ["ZanabazarSquare", 177]
    ]);

    static getAllEntries() {
        return Script.#values.entries();
    }

    #internalConstructor(value) {
        if (arguments.length > 1 && arguments[0] === diplomatRuntime.internalConstructor) {
            // We pass in two internalConstructor arguments to create *new*
            // instances of this type, otherwise the enums are treated as singletons.
            if (arguments[1] === diplomatRuntime.internalConstructor ) {
                this.#value = arguments[2];
                return this;
            }
            return Script.#objectValues[arguments[1]];
        }

        if (value instanceof Script) {
            return value;
        }

        let intVal = Script.#values.get(value);

        // Nullish check, checks for null or undefined
        if (intVal != null) {
            return Script.#objectValues[intVal];
        }

        throw TypeError(value + " is not a Script and does not correspond to any of its enumerator values.");
    }

    static fromValue(value) {
        return new Script(value);
    }

    get value(){
        for (let entry of Script.#values) {
            if (entry[1] == this.#value) {
                return entry[0];
            }
        }
    }

    get ffiValue(){
        return this.#value;
    }
    static #objectValues = {
        [167]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 167),
        [161]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 161),
        [156]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 156),
        [2]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 2),
        [3]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 3),
        [117]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 117),
        [62]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 62),
        [130]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 130),
        [134]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 134),
        [63]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 63),
        [4]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 4),
        [168]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 168),
        [5]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 5),
        [65]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 65),
        [46]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 46),
        [55]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 55),
        [44]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 44),
        [40]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 40),
        [104]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 104),
        [159]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 159),
        [118]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 118),
        [66]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 66),
        [6]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 6),
        [189]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 189),
        [0]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 0),
        [7]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 7),
        [101]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 101),
        [47]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 47),
        [193]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 193),
        [8]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 8),
        [9]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 9),
        [10]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 10),
        [190]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 190),
        [178]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 178),
        [135]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 135),
        [71]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 71),
        [136]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 136),
        [185]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 185),
        [11]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 11),
        [12]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 12),
        [56]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 56),
        [13]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 13),
        [137]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 137),
        [14]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 14),
        [15]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 15),
        [179]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 179),
        [16]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 16),
        [17]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 17),
        [18]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 18),
        [182]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 182),
        [43]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 43),
        [162]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 162),
        [19]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 19),
        [20]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 20),
        [116]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 116),
        [1]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 1),
        [122]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 122),
        [125]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 125),
        [78]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 78),
        [120]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 120),
        [21]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 21),
        [22]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 22),
        [198]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 198),
        [79]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 79),
        [57]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 57),
        [191]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 191),
        [23]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 23),
        [157]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 157),
        [145]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 145),
        [24]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 24),
        [25]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 25),
        [82]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 82),
        [48]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 48),
        [83]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 83),
        [49]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 49),
        [131]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 131),
        [107]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 107),
        [108]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 108),
        [160]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 160),
        [180]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 180),
        [26]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 26),
        [84]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 84),
        [121]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 121),
        [169]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 169),
        [175]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 175),
        [181]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 181),
        [115]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 115),
        [140]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 140),
        [141]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 141),
        [86]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 86),
        [92]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 92),
        [163]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 163),
        [27]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 27),
        [149]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 149),
        [164]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 164),
        [28]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 28),
        [143]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 143),
        [199]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 199),
        [187]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 187),
        [200]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 200),
        [59]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 59),
        [170]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 170),
        [87]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 87),
        [150]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 150),
        [186]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 186),
        [29]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 29),
        [109]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 109),
        [76]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 76),
        [30]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 30),
        [142]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 142),
        [89]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 89),
        [61]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 61),
        [184]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 184),
        [133]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 133),
        [88]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 88),
        [194]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 194),
        [31]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 31),
        [171]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 171),
        [50]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 50),
        [75]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 75),
        [144]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 144),
        [165]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 165),
        [90]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 90),
        [91]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 91),
        [123]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 123),
        [110]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 110),
        [32]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 32),
        [126]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 126),
        [111]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 111),
        [151]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 151),
        [51]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 51),
        [166]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 166),
        [112]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 112),
        [33]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 33),
        [183]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 183),
        [152]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 152),
        [176]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 176),
        [113]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 113),
        [58]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 58),
        [34]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 34),
        [42]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 42),
        [45]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 45),
        [52]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 52),
        [106]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 106),
        [127]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 127),
        [153]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 153),
        [35]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 35),
        [195]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 195),
        [154]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 154),
        [36]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 36),
        [37]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 37),
        [38]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 38),
        [39]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 39),
        [60]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 60),
        [158]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 158),
        [196]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 196),
        [53]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 53),
        [103]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 103),
        [99]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 99),
        [197]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 197),
        [188]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 188),
        [146]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 146),
        [192]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 192),
        [41]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 41),
        [177]: new Script(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 177),
    };

    static Adlam = Script.#objectValues[167];
    static Ahom = Script.#objectValues[161];
    static AnatolianHieroglyphs = Script.#objectValues[156];
    static Arabic = Script.#objectValues[2];
    static Armenian = Script.#objectValues[3];
    static Avestan = Script.#objectValues[117];
    static Balinese = Script.#objectValues[62];
    static Bamum = Script.#objectValues[130];
    static BassaVah = Script.#objectValues[134];
    static Batak = Script.#objectValues[63];
    static Bengali = Script.#objectValues[4];
    static Bhaiksuki = Script.#objectValues[168];
    static Bopomofo = Script.#objectValues[5];
    static Brahmi = Script.#objectValues[65];
    static Braille = Script.#objectValues[46];
    static Buginese = Script.#objectValues[55];
    static Buhid = Script.#objectValues[44];
    static CanadianAboriginal = Script.#objectValues[40];
    static Carian = Script.#objectValues[104];
    static CaucasianAlbanian = Script.#objectValues[159];
    static Chakma = Script.#objectValues[118];
    static Cham = Script.#objectValues[66];
    static Cherokee = Script.#objectValues[6];
    static Chorasmian = Script.#objectValues[189];
    static Common = Script.#objectValues[0];
    static Coptic = Script.#objectValues[7];
    static Cuneiform = Script.#objectValues[101];
    static Cypriot = Script.#objectValues[47];
    static CyproMinoan = Script.#objectValues[193];
    static Cyrillic = Script.#objectValues[8];
    static Deseret = Script.#objectValues[9];
    static Devanagari = Script.#objectValues[10];
    static DivesAkuru = Script.#objectValues[190];
    static Dogra = Script.#objectValues[178];
    static Duployan = Script.#objectValues[135];
    static EgyptianHieroglyphs = Script.#objectValues[71];
    static Elbasan = Script.#objectValues[136];
    static Elymaic = Script.#objectValues[185];
    static Ethiopian = Script.#objectValues[11];
    static Georgian = Script.#objectValues[12];
    static Glagolitic = Script.#objectValues[56];
    static Gothic = Script.#objectValues[13];
    static Grantha = Script.#objectValues[137];
    static Greek = Script.#objectValues[14];
    static Gujarati = Script.#objectValues[15];
    static GunjalaGondi = Script.#objectValues[179];
    static Gurmukhi = Script.#objectValues[16];
    static Han = Script.#objectValues[17];
    static Hangul = Script.#objectValues[18];
    static HanifiRohingya = Script.#objectValues[182];
    static Hanunoo = Script.#objectValues[43];
    static Hatran = Script.#objectValues[162];
    static Hebrew = Script.#objectValues[19];
    static Hiragana = Script.#objectValues[20];
    static ImperialAramaic = Script.#objectValues[116];
    static Inherited = Script.#objectValues[1];
    static InscriptionalPahlavi = Script.#objectValues[122];
    static InscriptionalParthian = Script.#objectValues[125];
    static Javanese = Script.#objectValues[78];
    static Kaithi = Script.#objectValues[120];
    static Kannada = Script.#objectValues[21];
    static Katakana = Script.#objectValues[22];
    static Kawi = Script.#objectValues[198];
    static KayahLi = Script.#objectValues[79];
    static Kharoshthi = Script.#objectValues[57];
    static KhitanSmallScript = Script.#objectValues[191];
    static Khmer = Script.#objectValues[23];
    static Khojki = Script.#objectValues[157];
    static Khudawadi = Script.#objectValues[145];
    static Lao = Script.#objectValues[24];
    static Latin = Script.#objectValues[25];
    static Lepcha = Script.#objectValues[82];
    static Limbu = Script.#objectValues[48];
    static LinearA = Script.#objectValues[83];
    static LinearB = Script.#objectValues[49];
    static Lisu = Script.#objectValues[131];
    static Lycian = Script.#objectValues[107];
    static Lydian = Script.#objectValues[108];
    static Mahajani = Script.#objectValues[160];
    static Makasar = Script.#objectValues[180];
    static Malayalam = Script.#objectValues[26];
    static Mandaic = Script.#objectValues[84];
    static Manichaean = Script.#objectValues[121];
    static Marchen = Script.#objectValues[169];
    static MasaramGondi = Script.#objectValues[175];
    static Medefaidrin = Script.#objectValues[181];
    static MeeteiMayek = Script.#objectValues[115];
    static MendeKikakui = Script.#objectValues[140];
    static MeroiticCursive = Script.#objectValues[141];
    static MeroiticHieroglyphs = Script.#objectValues[86];
    static Miao = Script.#objectValues[92];
    static Modi = Script.#objectValues[163];
    static Mongolian = Script.#objectValues[27];
    static Mro = Script.#objectValues[149];
    static Multani = Script.#objectValues[164];
    static Myanmar = Script.#objectValues[28];
    static Nabataean = Script.#objectValues[143];
    static NagMundari = Script.#objectValues[199];
    static Nandinagari = Script.#objectValues[187];
    static Nastaliq = Script.#objectValues[200];
    static NewTaiLue = Script.#objectValues[59];
    static Newa = Script.#objectValues[170];
    static Nko = Script.#objectValues[87];
    static Nushu = Script.#objectValues[150];
    static NyiakengPuachueHmong = Script.#objectValues[186];
    static Ogham = Script.#objectValues[29];
    static OlChiki = Script.#objectValues[109];
    static OldHungarian = Script.#objectValues[76];
    static OldItalic = Script.#objectValues[30];
    static OldNorthArabian = Script.#objectValues[142];
    static OldPermic = Script.#objectValues[89];
    static OldPersian = Script.#objectValues[61];
    static OldSogdian = Script.#objectValues[184];
    static OldSouthArabian = Script.#objectValues[133];
    static OldTurkic = Script.#objectValues[88];
    static OldUyghur = Script.#objectValues[194];
    static Oriya = Script.#objectValues[31];
    static Osage = Script.#objectValues[171];
    static Osmanya = Script.#objectValues[50];
    static PahawhHmong = Script.#objectValues[75];
    static Palmyrene = Script.#objectValues[144];
    static PauCinHau = Script.#objectValues[165];
    static PhagsPa = Script.#objectValues[90];
    static Phoenician = Script.#objectValues[91];
    static PsalterPahlavi = Script.#objectValues[123];
    static Rejang = Script.#objectValues[110];
    static Runic = Script.#objectValues[32];
    static Samaritan = Script.#objectValues[126];
    static Saurashtra = Script.#objectValues[111];
    static Sharada = Script.#objectValues[151];
    static Shavian = Script.#objectValues[51];
    static Siddham = Script.#objectValues[166];
    static SignWriting = Script.#objectValues[112];
    static Sinhala = Script.#objectValues[33];
    static Sogdian = Script.#objectValues[183];
    static SoraSompeng = Script.#objectValues[152];
    static Soyombo = Script.#objectValues[176];
    static Sundanese = Script.#objectValues[113];
    static SylotiNagri = Script.#objectValues[58];
    static Syriac = Script.#objectValues[34];
    static Tagalog = Script.#objectValues[42];
    static Tagbanwa = Script.#objectValues[45];
    static TaiLe = Script.#objectValues[52];
    static TaiTham = Script.#objectValues[106];
    static TaiViet = Script.#objectValues[127];
    static Takri = Script.#objectValues[153];
    static Tamil = Script.#objectValues[35];
    static Tangsa = Script.#objectValues[195];
    static Tangut = Script.#objectValues[154];
    static Telugu = Script.#objectValues[36];
    static Thaana = Script.#objectValues[37];
    static Thai = Script.#objectValues[38];
    static Tibetan = Script.#objectValues[39];
    static Tifinagh = Script.#objectValues[60];
    static Tirhuta = Script.#objectValues[158];
    static Toto = Script.#objectValues[196];
    static Ugaritic = Script.#objectValues[53];
    static Unknown = Script.#objectValues[103];
    static Vai = Script.#objectValues[99];
    static Vithkuqi = Script.#objectValues[197];
    static Wancho = Script.#objectValues[188];
    static WarangCiti = Script.#objectValues[146];
    static Yezidi = Script.#objectValues[192];
    static Yi = Script.#objectValues[41];
    static ZanabazarSquare = Script.#objectValues[177];


    /**
     * See the [Rust documentation for `for_char`](https://docs.rs/icu/latest/icu/properties/props/trait.EnumeratedProperty.html#tymethod.for_char) for more information.
     */
    static forChar(ch) {

        const result = wasm.icu4x_Script_for_char_mv1(ch);

        try {
            return new Script(diplomatRuntime.internalConstructor, result);
        }

        finally {
        }
    }

    /**
     * Get the "long" name of this property value (returns empty if property value is unknown)
     *
     * See the [Rust documentation for `get`](https://docs.rs/icu/latest/icu/properties/struct.PropertyNamesLongBorrowed.html#method.get) for more information.
     */
    longName() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 9, 4, true);


        const result = wasm.icu4x_Script_long_name_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new diplomatRuntime.DiplomatSliceStr(wasm, diplomatReceive.buffer,  "string8", []).getValue();
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Get the "short" name of this property value (returns empty if property value is unknown)
     *
     * See the [Rust documentation for `get`](https://docs.rs/icu/latest/icu/properties/struct.PropertyNamesShortBorrowed.html#method.get) for more information.
     */
    shortName() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 9, 4, true);


        const result = wasm.icu4x_Script_short_name_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new diplomatRuntime.DiplomatSliceStr(wasm, diplomatReceive.buffer,  "string8", []).getValue();
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Convert to an integer value usable with ICU4C and CodePointMapData
     *
     * See the [Rust documentation for `to_icu4c_value`](https://docs.rs/icu/latest/icu/properties/props/struct.Script.html#method.to_icu4c_value) for more information.
     */
    toIntegerValue() {

        const result = wasm.icu4x_Script_to_integer_value_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Convert from an integer value from ICU4C or CodePointMapData
     *
     * See the [Rust documentation for `from_icu4c_value`](https://docs.rs/icu/latest/icu/properties/props/struct.Script.html#method.from_icu4c_value) for more information.
     */
    static fromIntegerValue(other) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_Script_from_integer_value_mv1(diplomatReceive.buffer, other);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new Script(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
        }

        finally {
            diplomatReceive.free();
        }
    }

    constructor(value) {
        return this.#internalConstructor(...arguments)
    }
}