/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BKL_DB_H__
#define __BKL_DB_H__

#include <kozo.h>

#include <bickley/bkl-dbus.h>
#include <bickley/bkl-item.h>

#define BICKLEY_DB_VERSION 5 /* This is increased every time the database
                                format changes */

typedef struct _BklDBSource {
    char *db_uri;
    char *name;
} BklDBSource;

typedef struct _BklDB {
    KozoDB *db;
    BklDBus *dbus;
} BklDB;

typedef gboolean (* BklDBForeachFunc) (BklDB      *db,
                                       const char *key,
                                       BklItem    *item,
                                       gpointer    userdata);

BklDB *bkl_db_get (const char *db_name,
                   GError    **error);
BklDB *bkl_db_get_for_path (const char *path,
                            const char *db_name,
                            GError    **error);
BklDB *bkl_db_get_for_name (const char *filename,
                            const char *db_name,
                            GError    **error);
void bkl_db_free (BklDB *db);

gboolean bkl_db_add_item (BklDB      *db,
                          const char *key,
                          BklItem    *item,
                          GError    **error);
gboolean bkl_db_replace_item (BklDB      *db,
                              const char *key,
                              BklItem    *item,
                              GError    **error);
gboolean bkl_db_remove (BklDB      *db,
                        const char *key,
                        GError    **error);
BklItem *bkl_db_get_item (BklDB      *db,
                          const char *key,
                          GError    **error);
GPtrArray *bkl_db_get_items (BklDB   *db,
                             gboolean include_broken,
                             GError **error);
GSequence *bkl_db_get_index_words (BklDB   *db);
void bkl_db_foreach (BklDB           *db,
                     BklDBForeachFunc func,
                     gpointer         data);

#endif
